(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9149,        316]
NotebookOptionsPosition[      6570,        238]
NotebookOutlinePosition[      8004,        273]
CellTagsIndexPosition[      7961,        270]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[LeftAngleBracket]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftAngleBracket"], 
          "\\[RawGreater]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawGreater"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[LeftAngleBracket]\"\>", 
       2->"\<\"\\\\[RawGreater]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[RightAngleBracket]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[RightAngleBracket]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->381555405],

Cell["\\[RightAngleBracket]", "CharacterName",
 CellID->9047],

Cell["Unicode: 232A.", "Notes",
 CellID->15748],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox[">", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->20691],

Cell["Matchfix operator. ", "Notes",
 CellID->6098],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[LeftAngleBracket]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightAngleBracket]", TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AngleBracket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AngleBracket"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3265],

Cell[TextData[{
 "Used in the form ",
 Cell[BoxData[
  FormBox["\[LeftAngleBracket]", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[RightAngleBracket]", TraditionalForm]], "InlineMath"],
 " to indicate expected or average value. "
}], "Notes",
 CellID->10780],

Cell["Called ket in quantum mechanics. ", "Notes",
 CellID->4037],

Cell[TextData[{
 "Used in the form ",
 Cell[BoxData[
  FormBox["\[LeftAngleBracket]", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ",", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 Cell[BoxData[
  FormBox["\[RightAngleBracket]", TraditionalForm]], "InlineMath"],
 " to indicate various forms of inner product. "
}], "Notes",
 CellID->20232],

Cell[TextData[{
 "Used in the form ",
 Cell[BoxData[
  FormBox["\[LeftAngleBracket]", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ",", 
   StyleBox["y", "TI"], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightAngleBracket]", TraditionalForm]], "InlineMath"],
 " to denote an ordered set of objects. "
}], "Notes",
 CellID->1080],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[RawGreater]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawGreater"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->176],

Cell["Extensible character; grows by default to limited size. ", "Notes",
 CellID->6243]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->18021],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->18365]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->31259],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[LeftAngleBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftAngleBracket"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawGreater]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawGreater"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->23630]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->285879013],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RightAngleBracket] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 15.4548062}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 232A. Alias: Esc > Esc. Matchfix operator. < x > is by default \
interpreted as AngleBracket[x]. Used in the form <x> to indicate expected or \
average value. Called ket in quantum mechanics. Used in the form <x,y> to \
indicate various forms of inner product. Used in the form <x,y,... > to \
denote an ordered set of objects. Not the same as \\[RawGreater]. Extensible \
character; grows by default to limited size. ", 
    "synonyms" -> {"right angle bracket"}, "title" -> "\\[RightAngleBracket]",
     "type" -> "Character Name", "uri" -> 
    "ref/character/RightAngleBracket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1911, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2534, 76, 605, 19, 70, "CharacterImage",
 CellID->381555405],
Cell[3142, 97, 61, 1, 70, "CharacterName",
 CellID->9047],
Cell[3206, 100, 47, 1, 70, "Notes",
 CellID->15748],
Cell[3256, 103, 233, 9, 70, "Notes",
 CellID->20691],
Cell[3492, 114, 51, 1, 70, "Notes",
 CellID->6098],
Cell[3546, 117, 496, 18, 70, "Notes",
 CellID->3265],
Cell[4045, 137, 332, 10, 70, "Notes",
 CellID->10780],
Cell[4380, 149, 65, 1, 70, "Notes",
 CellID->4037],
Cell[4448, 152, 381, 12, 70, "Notes",
 CellID->20232],
Cell[4832, 166, 419, 14, 70, "Notes",
 CellID->1080],
Cell[5254, 182, 208, 7, 70, "Notes",
 CellID->176],
Cell[5465, 191, 88, 1, 70, "Notes",
 CellID->6243]
}, Open  ]],
Cell[CellGroupData[{
Cell[5590, 197, 53, 1, 70, "TutorialsSection",
 CellID->18021],
Cell[5646, 200, 129, 3, 70, "Tutorials",
 CellID->18365]
}, Open  ]],
Cell[CellGroupData[{
Cell[5812, 208, 50, 1, 70, "SeeAlsoSection",
 CellID->31259],
Cell[5865, 211, 422, 12, 70, "SeeAlso",
 CellID->23630]
}, Open  ]],
Cell[CellGroupData[{
Cell[6324, 228, 58, 1, 70, "MoreAboutSection",
 CellID->285879013],
Cell[6385, 231, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6543, 236, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

