(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8803,        298]
NotebookOptionsPosition[      6246,        221]
NotebookOutlinePosition[      7660,        255]
CellTagsIndexPosition[      7617,        252]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RightBracketingBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightBracketingBar"],
           "\\[DoubleVerticalBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/DoubleVerticalBar"], 
          "\\[LeftDoubleBracketingBar]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/LeftDoubleBracketingBar"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[RightBracketingBar]\"\>", 
       2->"\<\"\\\\[DoubleVerticalBar]\"\>", 
       3->"\<\"\\\\[LeftDoubleBracketingBar]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[RightDoubleBracketingBar]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[RightDoubleBracketingBar]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->56889011],

Cell["\\[RightDoubleBracketingBar]", "CharacterName",
 CellID->27071],

Cell["Unicode: F606.", "Notes",
 CellID->7270],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["r||", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->25597],

Cell["Matchfix operator. ", "Notes",
 CellID->31879],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[LeftDoubleBracketingBar]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightDoubleBracketingBar]", TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DoubleBracketingBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DoubleBracketingBar"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31528],

Cell["Used in mathematics to indicate taking a norm. ", "Notes",
 CellID->9203],

Cell["Sometimes used for determinant. ", "Notes",
 CellID->824],

Cell["Sometimes used to indicate a matrix. ", "Notes",
 CellID->16745],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[DoubleVerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleVerticalBar"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->30729],

Cell["\<\
Drawn in monospaced fonts with a small right\[Hyphen]pointing tee to indicate \
direction. \
\>", "Notes",
 CellID->12549],

Cell["Extensible character. ", "Notes",
 CellID->7724]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->16979],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->14140]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->17411],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RightBracketingBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightBracketingBar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DoubleVerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleVerticalBar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftDoubleBracketingBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftDoubleBracketingBar"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->31898]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->319781442],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RightDoubleBracketingBar] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 23.0956268}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F606. Alias: Esc r|| Esc. Matchfix operator. || x || is by \
default interpreted as DoubleBracketingBar[x]. Used in mathematics to \
indicate taking a norm. Sometimes used for determinant. Sometimes used to \
indicate a matrix. Not the same as \\[DoubleVerticalBar]. Drawn in monospaced \
fonts with a small right-pointing tee to indicate direction. Extensible \
character. ", "synonyms" -> {"right double bracketing bar"}, "title" -> 
    "\\[RightDoubleBracketingBar]", "type" -> "Character Name", "uri" -> 
    "ref/character/RightDoubleBracketingBar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2130, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2753, 80, 618, 19, 70, "CharacterImage",
 CellID->56889011],
Cell[3374, 101, 69, 1, 70, "CharacterName",
 CellID->27071],
Cell[3446, 104, 46, 1, 70, "Notes",
 CellID->7270],
Cell[3495, 107, 235, 9, 70, "Notes",
 CellID->25597],
Cell[3733, 118, 52, 1, 70, "Notes",
 CellID->31879],
Cell[3788, 121, 525, 18, 70, "Notes",
 CellID->31528],
Cell[4316, 141, 79, 1, 70, "Notes",
 CellID->9203],
Cell[4398, 144, 63, 1, 70, "Notes",
 CellID->824],
Cell[4464, 147, 70, 1, 70, "Notes",
 CellID->16745],
Cell[4537, 150, 227, 8, 70, "Notes",
 CellID->30729],
Cell[4767, 160, 132, 4, 70, "Notes",
 CellID->12549],
Cell[4902, 166, 54, 1, 70, "Notes",
 CellID->7724]
}, Open  ]],
Cell[CellGroupData[{
Cell[4993, 172, 53, 1, 70, "TutorialsSection",
 CellID->16979],
Cell[5049, 175, 129, 3, 70, "Tutorials",
 CellID->14140]
}, Open  ]],
Cell[CellGroupData[{
Cell[5215, 183, 50, 1, 70, "SeeAlsoSection",
 CellID->17411],
Cell[5268, 186, 695, 20, 70, "SeeAlso",
 CellID->31898]
}, Open  ]],
Cell[CellGroupData[{
Cell[6000, 211, 58, 1, 70, "MoreAboutSection",
 CellID->319781442],
Cell[6061, 214, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6219, 219, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

