(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7618,        262]
NotebookOptionsPosition[      5545,        197]
NotebookOutlinePosition[      6698,        228]
CellTagsIndexPosition[      6655,        225]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[LeftFloor]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftFloor"], 
          "\\[RightCeiling]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightCeiling"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[LeftFloor]\"\>", 
       2->"\<\"\\\\[RightCeiling]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Mathematica Syntax Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSyntaxCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Mathematica Syntax Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[RightFloor]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[RightFloor]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->459032043],

Cell["\\[RightFloor]", "CharacterName",
 CellID->25216],

Cell["Unicode: 230B.", "Notes",
 CellID->30942],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["rf", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->9157],

Cell["\<\
Matchfix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->16769],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[LeftFloor]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightFloor]", TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5031],

Cell["Extensible character. ", "Notes",
 CellID->18199]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->27473],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->20078]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->12334],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[LeftFloor]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftFloor"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightCeiling]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightCeiling"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->14964]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->27296737],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"],
  FontSlant->"Italic"],
 ButtonBox[" Syntax Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RightFloor] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 30.3145616}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 230B. Alias: Esc rf Esc. Matchfix operator with built-in \
evaluation rules. \\[LeftFloor] x \\[RightFloor] is by default interpreted as \
Floor[x]. Extensible character. ", "synonyms" -> {"right floor"}, "title" -> 
    "\\[RightFloor]", "type" -> "Character Name", "uri" -> 
    "ref/character/RightFloor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2067, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2690, 78, 591, 19, 70, "CharacterImage",
 CellID->459032043],
Cell[3284, 99, 55, 1, 70, "CharacterName",
 CellID->25216],
Cell[3342, 102, 47, 1, 70, "Notes",
 CellID->30942],
Cell[3392, 105, 233, 9, 70, "Notes",
 CellID->9157],
Cell[3628, 116, 99, 3, 70, "Notes",
 CellID->16769],
Cell[3730, 121, 468, 18, 70, "Notes",
 CellID->5031],
Cell[4201, 141, 55, 1, 70, "Notes",
 CellID->18199]
}, Open  ]],
Cell[CellGroupData[{
Cell[4293, 147, 53, 1, 70, "TutorialsSection",
 CellID->27473],
Cell[4349, 150, 129, 3, 70, "Tutorials",
 CellID->20078]
}, Open  ]],
Cell[CellGroupData[{
Cell[4515, 158, 50, 1, 70, "SeeAlsoSection",
 CellID->12334],
Cell[4568, 161, 409, 11, 70, "SeeAlso",
 CellID->14964]
}, Open  ]],
Cell[CellGroupData[{
Cell[5014, 177, 57, 1, 70, "MoreAboutSection",
 CellID->27296737],
Cell[5074, 180, 143, 2, 70, "MoreAbout"],
Cell[5220, 184, 283, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[5518, 195, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

