(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8408,        279]
NotebookOptionsPosition[      6252,        213]
NotebookOutlinePosition[      7498,        245]
CellTagsIndexPosition[      7455,        242]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ControlKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/ControlKey"], 
          "\\[CommandKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/CommandKey"], 
          "\\[LeftModified]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftModified"], 
          "\\[RawRightBracket]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/RawRightBracket"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[ControlKey]\"\>", 
       2->"\<\"\\\\[CommandKey]\"\>", 3->"\<\"\\\\[LeftModified]\"\>", 
       4->"\<\"\\\\[RawRightBracket]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[RightModified]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[RightModified]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->337408400],

Cell["\\[RightModified]", "CharacterName",
 CellID->27639],

Cell["Unicode: F76C.", "Notes",
 CellID->4601],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["]", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->9004],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->8540],

Cell["Used in documenting control and command characters. ", "Notes",
 CellID->7973],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["key", "TI"]], "InlineFormula"],
 "\[Backslash]",
 Cell[BoxData[
  RowBox[{
   RowBox[{"[", "LeftModified", "]"}], 
   StyleBox["char", "TI"]}]], "InlineFormula"],
 Cell["\\[RightModified]", "InlineCharacterName"],
 " is used to indicate that ",
 Cell[BoxData[
  StyleBox["char", "TI"]], "InlineFormula"],
 " should be typed while ",
 Cell[BoxData[
  StyleBox["key", "TI"]], "InlineFormula"],
 " is being pressed. "
}], "Notes",
 CellID->21422],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[RawRightBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawRightBracket"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->10131]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->9682],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->4606]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->17358],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ControlKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ControlKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CommandKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CommandKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftModified]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftModified"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawRightBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawRightBracket"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->12219]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RightModified] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 30.7833236}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F76C. Alias: Esc ] Esc. Letter-like form. Used in documenting \
control and command characters. key\\[LeftModified]char\\[RightModified] is \
used to indicate that char should be typed while key is being pressed. Not \
the same as \\[RawRightBracket]. ", "synonyms" -> {"right modified"}, "title" -> 
    "\\[RightModified]", "type" -> "Character Name", "uri" -> 
    "ref/character/RightModified"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2314, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2937, 84, 597, 19, 70, "CharacterImage",
 CellID->337408400],
Cell[3537, 105, 58, 1, 70, "CharacterName",
 CellID->27639],
Cell[3598, 108, 46, 1, 70, "Notes",
 CellID->4601],
Cell[3647, 111, 232, 9, 70, "Notes",
 CellID->9004],
Cell[3882, 122, 58, 1, 70, "Notes",
 CellID->8540],
Cell[3943, 125, 84, 1, 70, "Notes",
 CellID->7973],
Cell[4030, 128, 486, 17, 70, "Notes",
 CellID->21422],
Cell[4519, 147, 223, 8, 70, "Notes",
 CellID->10131]
}, Open  ]],
Cell[CellGroupData[{
Cell[4779, 160, 52, 1, 70, "TutorialsSection",
 CellID->9682],
Cell[4834, 163, 195, 4, 70, "Tutorials",
 CellID->4606]
}, Open  ]],
Cell[CellGroupData[{
Cell[5066, 172, 38, 0, 70, "MoreAboutSection"],
Cell[5107, 174, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5287, 181, 50, 1, 70, "SeeAlsoSection",
 CellID->17358],
Cell[5340, 184, 870, 24, 70, "SeeAlso",
 CellID->12219]
}, Open  ]],
Cell[6225, 211, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

