(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10081,        314]
NotebookOptionsPosition[      8006,        249]
NotebookOutlinePosition[      9157,        280]
CellTagsIndexPosition[      9114,        277]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RightTriangleEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightTriangleEqual"],
           "\\[RightTriangleBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightTriangleBar"], 
          "\\[RightArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightArrow"], 
          "\\[NotRightTriangle]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotRightTriangle"], 
          "\\[LeftTriangle]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftTriangle"], 
          "\\[EmptyUpTriangle]" :> 
          Documentation`HelpLookup["paclet:ref/character/EmptyUpTriangle"], 
          "\\[FilledUpTriangle]" :> 
          Documentation`HelpLookup["paclet:ref/character/FilledUpTriangle"], 
          "\\[RightAngle]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightAngle"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"\\\\[RightTriangleEqual]\"\>", 
       2->"\<\"\\\\[RightTriangleBar]\"\>", 3->"\<\"\\\\[RightArrow]\"\>", 
       4->"\<\"\\\\[NotRightTriangle]\"\>", 5->"\<\"\\\\[LeftTriangle]\"\>", 
       6->"\<\"\\\\[EmptyUpTriangle]\"\>", 
       7->"\<\"\\\\[FilledUpTriangle]\"\>", 
       8->"\<\"\\\\[RightAngle]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[RightTriangle]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[RightTriangle]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->6124881],

Cell["\\[RightTriangle]", "CharacterName",
 CellID->32380],

Cell["Unicode: 22B3.", "Notes",
 CellID->18199],

Cell["Infix ordering operator. ", "Notes",
 CellID->15392],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightTriangle]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RightTriangle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RightTriangle"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29350],

Cell["\<\
Used in pure mathematics to mean \[OpenCurlyDoubleQuote]contains as a normal \
subgroup\[CloseCurlyDoubleQuote]. \
\>", "Notes",
 CellID->18339]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->29353],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->30867],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->789]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->6635],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RightTriangleEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightTriangleEqual"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightTriangleBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightTriangleBar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightArrow"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotRightTriangle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotRightTriangle"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftTriangle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftTriangle"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[EmptyUpTriangle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EmptyUpTriangle"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[FilledUpTriangle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/FilledUpTriangle"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightAngle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightAngle"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->20610]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->86638156],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RightTriangle] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 38.3460172}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 22B3. Infix ordering operator. x |> y is by default interpreted \
as RightTriangle[x,y]. Used in pure mathematics to mean 'contains as a normal \
subgroup'. ", "synonyms" -> {"right triangle"}, "title" -> 
    "\\[RightTriangle]", "type" -> "Character Name", "uri" -> 
    "ref/character/RightTriangle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3197, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3820, 98, 595, 19, 70, "CharacterImage",
 CellID->6124881],
Cell[4418, 119, 58, 1, 70, "CharacterName",
 CellID->32380],
Cell[4479, 122, 47, 1, 70, "Notes",
 CellID->18199],
Cell[4529, 125, 58, 1, 70, "Notes",
 CellID->15392],
Cell[4590, 128, 516, 20, 70, "Notes",
 CellID->29350],
Cell[5109, 150, 154, 4, 70, "Notes",
 CellID->18339]
}, Open  ]],
Cell[CellGroupData[{
Cell[5300, 159, 53, 1, 70, "TutorialsSection",
 CellID->29353],
Cell[5356, 162, 163, 3, 70, "Tutorials",
 CellID->30867],
Cell[5522, 167, 127, 3, 70, "Tutorials",
 CellID->789]
}, Open  ]],
Cell[CellGroupData[{
Cell[5686, 175, 49, 1, 70, "SeeAlsoSection",
 CellID->6635],
Cell[5738, 178, 1826, 52, 70, "SeeAlso",
 CellID->20610]
}, Open  ]],
Cell[CellGroupData[{
Cell[7601, 235, 57, 1, 70, "MoreAboutSection",
 CellID->86638156],
Cell[7661, 238, 143, 2, 70, "MoreAbout"],
Cell[7807, 242, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7979, 247, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

