(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8350,        278]
NotebookOptionsPosition[      6279,        214]
NotebookOutlinePosition[      7468,        245]
CellTagsIndexPosition[      7425,        242]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[LeftUpVector]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftUpVector"], 
          "\\[RightUpTeeVector]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightUpTeeVector"], 
          "\\[UpArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/UpArrow"], 
          "\\[UpEquilibrium]" :> 
          Documentation`HelpLookup["paclet:ref/character/UpEquilibrium"], 
          "\\[RightDownVector]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/RightDownVector"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[LeftUpVector]\"\>", 
       2->"\<\"\\\\[RightUpTeeVector]\"\>", 3->"\<\"\\\\[UpArrow]\"\>", 
       4->"\<\"\\\\[UpEquilibrium]\"\>", 
       5->"\<\"\\\\[RightDownVector]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[RightUpVector]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[RightUpVector]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->67087419],

Cell["\\[RightUpVector]", "CharacterName",
 CellID->32016],

Cell["Unicode: 21BE.", "Notes",
 CellID->28704],

Cell["Infix arrow\[Hyphen]like operator. ", "Notes",
 CellID->31974],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightUpVector]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RightUpVector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RightUpVector"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15901],

Cell[TextData[{
 "Used in pure mathematics to indicate the restriction of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14221],

Cell["Extensible character. ", "Notes",
 CellID->30960]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->15583],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->25913]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->12153],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[LeftUpVector]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftUpVector"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightUpTeeVector]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightUpTeeVector"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[UpArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/UpArrow"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[UpEquilibrium]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/UpEquilibrium"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightDownVector]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightDownVector"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->20332]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->211877228],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RightUpVector] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 39.0335348}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 21BE. Infix arrow-like operator. x \\[RightUpVector] y is by \
default interpreted as RightUpVector[x,y]. Used in pure mathematics to \
indicate the restriction of x to y. Extensible character. ", 
    "synonyms" -> {"right up vector"}, "title" -> "\\[RightUpVector]", "type" -> 
    "Character Name", "uri" -> "ref/character/RightUpVector"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2361, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2984, 85, 596, 19, 70, "CharacterImage",
 CellID->67087419],
Cell[3583, 106, 58, 1, 70, "CharacterName",
 CellID->32016],
Cell[3644, 109, 47, 1, 70, "Notes",
 CellID->28704],
Cell[3694, 112, 68, 1, 70, "Notes",
 CellID->31974],
Cell[3765, 115, 516, 20, 70, "Notes",
 CellID->15901],
Cell[4284, 137, 234, 9, 70, "Notes",
 CellID->14221],
Cell[4521, 148, 55, 1, 70, "Notes",
 CellID->30960]
}, Open  ]],
Cell[CellGroupData[{
Cell[4613, 154, 53, 1, 70, "TutorialsSection",
 CellID->15583],
Cell[4669, 157, 129, 3, 70, "Tutorials",
 CellID->25913]
}, Open  ]],
Cell[CellGroupData[{
Cell[4835, 165, 50, 1, 70, "SeeAlsoSection",
 CellID->12153],
Cell[4888, 168, 1108, 31, 70, "SeeAlso",
 CellID->20332]
}, Open  ]],
Cell[CellGroupData[{
Cell[6033, 204, 58, 1, 70, "MoreAboutSection",
 CellID->211877228],
Cell[6094, 207, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6252, 212, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

