(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7570,        244]
NotebookOptionsPosition[      5720,        186]
NotebookOutlinePosition[      6820,        216]
CellTagsIndexPosition[      6777,        213]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[SpaceIndicator]" :> 
          Documentation`HelpLookup["paclet:ref/character/SpaceIndicator"], 
          "\\[Cup]" :> Documentation`HelpLookup["paclet:ref/character/Cup"], 
          "\\[Breve]" :> 
          Documentation`HelpLookup["paclet:ref/character/Breve"], 
          "\\[LetterSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/LetterSpace"], 
          "\\[RawSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawSpace"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[SpaceIndicator]\"\>", 
       2->"\<\"\\\\[Cup]\"\>", 3->"\<\"\\\\[Breve]\"\>", 
       4->"\<\"\\\\[LetterSpace]\"\>", 
       5->"\<\"\\\\[RawSpace]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[RoundSpaceIndicator]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[RoundSpaceIndicator]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->694343419],

Cell["\\[RoundSpaceIndicator]", "CharacterName",
 CellID->8343],

Cell["Unicode: F3B2.", "Notes",
 CellID->21429],

Cell["Spacing character. ", "Notes",
 CellID->6696],

Cell[TextData[{
 "Interpreted by default as equivalent to ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->30423]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->8800],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->9716]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->7572],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[SpaceIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SpaceIndicator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Cup]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Cup"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Breve]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Breve"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LetterSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LetterSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->11523]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RoundSpaceIndicator] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 39.6585508}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F3B2. Spacing character. Interpreted by default as equivalent \
to \\[RawSpace]. ", "synonyms" -> {"round space indicator"}, "title" -> 
    "\\[RoundSpaceIndicator]", "type" -> "Character Name", "uri" -> 
    "ref/character/RoundSpaceIndicator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2385, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3008, 85, 609, 19, 70, "CharacterImage",
 CellID->694343419],
Cell[3620, 106, 63, 1, 70, "CharacterName",
 CellID->8343],
Cell[3686, 109, 47, 1, 70, "Notes",
 CellID->21429],
Cell[3736, 112, 51, 1, 70, "Notes",
 CellID->6696],
Cell[3790, 115, 230, 7, 70, "Notes",
 CellID->30423]
}, Open  ]],
Cell[CellGroupData[{
Cell[4057, 127, 52, 1, 70, "TutorialsSection",
 CellID->8800],
Cell[4112, 130, 195, 4, 70, "Tutorials",
 CellID->9716]
}, Open  ]],
Cell[CellGroupData[{
Cell[4344, 139, 38, 0, 70, "MoreAboutSection"],
Cell[4385, 141, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4565, 148, 49, 1, 70, "SeeAlsoSection",
 CellID->7572],
Cell[4617, 151, 1061, 30, 70, "SeeAlso",
 CellID->11523]
}, Open  ]],
Cell[5693, 184, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

