(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9928,        345]
NotebookOptionsPosition[      7672,        274]
NotebookOutlinePosition[      8841,        305]
CellTagsIndexPosition[      8798,        302]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Special Characters\"\>", 
       3->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RuleDelayed]" :> 
          Documentation`HelpLookup["paclet:ref/character/RuleDelayed"], 
          "\\[RightArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightArrow"], 
          "\\[LongRightArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/LongRightArrow"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"\\\\[RuleDelayed]\"\>", 
       2->"\<\"\\\\[RightArrow]\"\>", 
       3->"\<\"\\\\[LongRightArrow]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Mathematica Syntax Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSyntaxCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Mathematica Syntax Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Rule]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Rule]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->300743137],

Cell["\\[Rule]", "CharacterName",
 CellID->5793],

Cell["Unicode: F522.", "Notes",
 CellID->1580],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["->", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->22789],

Cell["\<\
Infix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->31613],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Rule]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "->", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rule",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rule"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1209],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Rule]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Rule]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " groups as ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Rule]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  RowBox[{"(", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Rule]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  RowBox[{
   StyleBox["z", "TI"], ")"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4623],

Cell[TextData[{
 Cell["\\[Rule]", "InlineCharacterName"],
 " is not the same as ",
 Cell[TextData[ButtonBox["\\[RightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightArrow"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->15901]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->4143],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->24570],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->1157],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->26955]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->182],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RuleDelayed]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RuleDelayed"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightArrow"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LongRightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LongRightArrow"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->4390]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->369779932],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"],
  FontSlant->"Italic"],
 ButtonBox[" Syntax Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Rule] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 46.3618474}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F522. Alias: Esc -> Esc. Infix operator with built-in \
evaluation rules. x -> y is by default interpreted as x->y or Rule[x,y]. x -> \
y -> z groups as x -> (y -> z). \\[Rule] is not the same as \\[RightArrow]. ",
     "synonyms" -> {"rule"}, "title" -> "\\[Rule]", "type" -> 
    "Character Name", "uri" -> "ref/character/Rule"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2551, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3174, 87, 579, 19, 70, "CharacterImage",
 CellID->300743137],
Cell[3756, 108, 48, 1, 70, "CharacterName",
 CellID->5793],
Cell[3807, 111, 46, 1, 70, "Notes",
 CellID->1580],
Cell[3856, 114, 234, 9, 70, "Notes",
 CellID->22789],
Cell[4093, 125, 96, 3, 70, "Notes",
 CellID->31613],
Cell[4192, 130, 599, 25, 70, "Notes",
 CellID->1209],
Cell[4794, 157, 773, 34, 70, "Notes",
 CellID->4623],
Cell[5570, 193, 256, 8, 70, "Notes",
 CellID->15901]
}, Open  ]],
Cell[CellGroupData[{
Cell[5863, 206, 52, 1, 70, "TutorialsSection",
 CellID->4143],
Cell[5918, 209, 144, 3, 70, "Tutorials",
 CellID->24570],
Cell[6065, 214, 179, 5, 70, "Tutorials",
 CellID->1157],
Cell[6247, 221, 129, 3, 70, "Tutorials",
 CellID->26955]
}, Open  ]],
Cell[CellGroupData[{
Cell[6413, 229, 48, 1, 70, "SeeAlsoSection",
 CellID->182],
Cell[6464, 232, 639, 17, 70, "SeeAlso",
 CellID->4390]
}, Open  ]],
Cell[CellGroupData[{
Cell[7140, 254, 58, 1, 70, "MoreAboutSection",
 CellID->369779932],
Cell[7201, 257, 143, 2, 70, "MoreAbout"],
Cell[7347, 261, 283, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[7645, 272, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

