(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7553,        266]
NotebookOptionsPosition[      5300,        194]
NotebookOutlinePosition[      6452,        225]
CellTagsIndexPosition[      6409,        222]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Non\[Hyphen]English Characters and Keyboards" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NonEnglishCharactersAndKeyboards"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Non\[Hyphen]English Characters and Keyboards\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Beta]" :> 
          Documentation`HelpLookup["paclet:ref/character/Beta"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"\\\\[Beta]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[SZ]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[SZ]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->337896505],

Cell["\\[SZ]", "CharacterName",
 CellID->20379],

Cell["Unicode: 00DF.", "Notes",
 CellID->70997643],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["sz", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["ss", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->32082],

Cell["Letter. ", "Notes",
 CellID->9378],

Cell["Used in German. ", "Notes",
 CellID->12425],

Cell["\<\
Sometimes called s sharp, ess\[Hyphen]zed or ess\[Hyphen]zet. \
\>", "Notes",
 CellID->23744],

Cell[TextData[{
 "Usually transliterated in English as ",
 Cell[BoxData["ss"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10245],

Cell[TextData[{
 "Upper\[Hyphen]case form is ",
 Cell[BoxData["SS"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22373],

Cell["Included in ISO Latin\[Hyphen]1. ", "Notes",
 CellID->21228]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->19409],

Cell[TextData[ButtonBox["Non\[Hyphen]English Characters and Keyboards",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonEnglishCharactersAndKeyboards"]], "Tutorials",\

 CellID->17764],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->7275],

Cell[TextData[Cell[TextData[ButtonBox["\\[Beta]",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/character/Beta"]], "InlineCharacterName"]], "SeeAlso",\

 CellID->18508]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->348208967],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[SZ] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 14.4734780}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 00DF. Aliases: Esc sz Esc, Esc ss Esc. Letter. Used in German. \
Sometimes called s sharp, ess-zed or ess-zet. Usually transliterated in \
English as ss. Upper-case form is SS. Included in ISO Latin-1. ", 
    "synonyms" -> {"s z"}, "title" -> "\\[SZ]", "type" -> "Character Name", 
    "uri" -> "ref/character/SZ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2055, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2678, 80, 575, 19, 70, "CharacterImage",
 CellID->337896505],
Cell[3256, 101, 47, 1, 70, "CharacterName",
 CellID->20379],
Cell[3306, 104, 50, 1, 70, "Notes",
 CellID->70997643],
Cell[3359, 107, 416, 15, 70, "Notes",
 CellID->32082],
Cell[3778, 124, 40, 1, 70, "Notes",
 CellID->9378],
Cell[3821, 127, 49, 1, 70, "Notes",
 CellID->12425],
Cell[3873, 130, 103, 3, 70, "Notes",
 CellID->23744],
Cell[3979, 135, 131, 5, 70, "Notes",
 CellID->10245],
Cell[4113, 142, 121, 5, 70, "Notes",
 CellID->22373],
Cell[4237, 149, 66, 1, 70, "Notes",
 CellID->21228]
}, Open  ]],
Cell[CellGroupData[{
Cell[4340, 155, 53, 1, 70, "TutorialsSection",
 CellID->19409],
Cell[4396, 158, 189, 4, 70, "Tutorials",
 CellID->17764],
Cell[4588, 164, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4798, 172, 49, 1, 70, "SeeAlsoSection",
 CellID->7275],
Cell[4850, 175, 167, 4, 70, "SeeAlso",
 CellID->18508]
}, Open  ]],
Cell[CellGroupData[{
Cell[5054, 184, 58, 1, 70, "MoreAboutSection",
 CellID->348208967],
Cell[5115, 187, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5273, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

