(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7524,        253]
NotebookOptionsPosition[      5466,        190]
NotebookOutlinePosition[      6656,        221]
CellTagsIndexPosition[      6613,        218]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[NotSquareSubset]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotSquareSubset"], 
          "\\[SquareSuperset]" :> 
          Documentation`HelpLookup["paclet:ref/character/SquareSuperset"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"\\\\[NotSquareSubset]\"\>", 
       2->"\<\"\\\\[SquareSuperset]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[SquareSubset]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[SquareSubset]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->298821745],

Cell["\\[SquareSubset]", "CharacterName",
 CellID->8001],

Cell["Unicode: 228F.", "Notes",
 CellID->16176],

Cell["Infix set relation operator. ", "Notes",
 CellID->16385],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[SquareSubset]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SquareSubset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SquareSubset"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12390],

Cell[TextData[{
 "Used in computer science to indicate that ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is a substring occurring at the beginning of ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2208]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->15846],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->30114]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->10732],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[NotSquareSubset]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotSquareSubset"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SquareSuperset]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SquareSuperset"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->18942]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->73423985],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[SquareSubset] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 44, 58.7855764}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 228F. Infix set relation operator. x \\[SquareSubset] y is by \
default interpreted as SquareSubset[x,y]. Used in computer science to \
indicate that x is a substring occurring at the beginning of y. ", 
    "synonyms" -> {"square subset"}, "title" -> "\\[SquareSubset]", "type" -> 
    "Character Name", "uri" -> "ref/character/SquareSubset"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2112, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2735, 79, 595, 19, 70, "CharacterImage",
 CellID->298821745],
Cell[3333, 100, 56, 1, 70, "CharacterName",
 CellID->8001],
Cell[3392, 103, 47, 1, 70, "Notes",
 CellID->16176],
Cell[3442, 106, 62, 1, 70, "Notes",
 CellID->16385],
Cell[3507, 109, 513, 20, 70, "Notes",
 CellID->12390],
Cell[4023, 131, 261, 9, 70, "Notes",
 CellID->2208]
}, Open  ]],
Cell[CellGroupData[{
Cell[4321, 145, 53, 1, 70, "TutorialsSection",
 CellID->15846],
Cell[4377, 148, 129, 3, 70, "Tutorials",
 CellID->30114]
}, Open  ]],
Cell[CellGroupData[{
Cell[4543, 156, 50, 1, 70, "SeeAlsoSection",
 CellID->10732],
Cell[4596, 159, 428, 12, 70, "SeeAlso",
 CellID->18942]
}, Open  ]],
Cell[CellGroupData[{
Cell[5061, 176, 57, 1, 70, "MoreAboutSection",
 CellID->73423985],
Cell[5121, 179, 143, 2, 70, "MoreAbout"],
Cell[5267, 183, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5439, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

