(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7036,        235]
NotebookOptionsPosition[      5042,        172]
NotebookOutlinePosition[      6150,        202]
CellTagsIndexPosition[      6107,        199]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RawNumberSign]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawNumberSign"], 
          "\\[Euro]" :> 
          Documentation`HelpLookup["paclet:ref/character/Euro"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[RawNumberSign]\"\>", 
       2->"\<\"\\\\[Euro]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Sterling]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Sterling]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->162459298],

Cell["\\[Sterling]", "CharacterName",
 CellID->18987],

Cell["Unicode: 00A3.", "Notes",
 CellID->646365843],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->18518],

Cell[TextData[{
 "Currency symbol for British pound sterling, as in ",
 Cell[BoxData[
  FormBox["\[Sterling]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData["5"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14109],

Cell["Used in mathematics to denote Lie derivative. ", "Notes",
 CellID->17300]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->5364],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->30967],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->8929],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RawNumberSign]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawNumberSign"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Euro]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Euro"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->8074]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->588778615],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Sterling] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 44, 59.5512210}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 00A3. Letter-like form. Currency symbol for British pound \
sterling, as in \\[Sterling] 5. Used in mathematics to denote Lie derivative. \
", "synonyms" -> {"sterling"}, "title" -> "\\[Sterling]", "type" -> 
    "Character Name", "uri" -> "ref/character/Sterling"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2149, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2772, 81, 587, 19, 70, "CharacterImage",
 CellID->162459298],
Cell[3362, 102, 53, 1, 70, "CharacterName",
 CellID->18987],
Cell[3418, 105, 51, 1, 70, "Notes",
 CellID->646365843],
Cell[3472, 108, 59, 1, 70, "Notes",
 CellID->18518],
Cell[3534, 111, 223, 8, 70, "Notes",
 CellID->14109],
Cell[3760, 121, 79, 1, 70, "Notes",
 CellID->17300]
}, Open  ]],
Cell[CellGroupData[{
Cell[3876, 127, 52, 1, 70, "TutorialsSection",
 CellID->5364],
Cell[3931, 130, 163, 3, 70, "Tutorials",
 CellID->30967],
Cell[4097, 135, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4307, 143, 49, 1, 70, "SeeAlsoSection",
 CellID->8929],
Cell[4359, 146, 400, 11, 70, "SeeAlso",
 CellID->8074]
}, Open  ]],
Cell[CellGroupData[{
Cell[4796, 162, 58, 1, 70, "MoreAboutSection",
 CellID->588778615],
Cell[4857, 165, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5015, 170, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

