(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9193,        320]
NotebookOptionsPosition[      7065,        254]
NotebookOutlinePosition[      8257,        285]
CellTagsIndexPosition[      8214,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Exists]" :> 
          Documentation`HelpLookup["paclet:ref/character/Exists"], 
          "\\[ForAll]" :> 
          Documentation`HelpLookup["paclet:ref/character/ForAll"], 
          "\\[Colon]" :> 
          Documentation`HelpLookup["paclet:ref/character/Colon"], 
          "\\[VerticalBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/VerticalBar"], 
          "\\[ReverseElement]" :> 
          Documentation`HelpLookup["paclet:ref/character/ReverseElement"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"\\\\[Exists]\"\>", 
       2->"\<\"\\\\[ForAll]\"\>", 3->"\<\"\\\\[Colon]\"\>", 
       4->"\<\"\\\\[VerticalBar]\"\>", 
       5->"\<\"\\\\[ReverseElement]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[SuchThat]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[SuchThat]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->98798596],

Cell["\\[SuchThat]", "CharacterName",
 CellID->12269],

Cell["Unicode: 220D.", "Notes",
 CellID->24826],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["st", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->13331],

Cell["Infix operator. ", "Notes",
 CellID->18748],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[SuchThat]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SuchThat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuchThat"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23251],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[SuchThat]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[SuchThat]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " groups as ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[SuchThat]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  RowBox[{"(", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[SuchThat]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  RowBox[{
   StyleBox["z", "TI"], ")"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32134],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[ReverseElement]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ReverseElement"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->28406]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->11831],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->5426]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->30630],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Exists]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Exists"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ForAll]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ForAll"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Colon]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Colon"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[VerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VerticalBar"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ReverseElement]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ReverseElement"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->1021]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->168946821],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[SuchThat] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 7.2545432}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 220D. Alias: Esc st Esc. Infix operator. x \\[SuchThat] y is by \
default interpreted as SuchThat[x,y]. x \\[SuchThat] y \\[SuchThat] z groups \
as x \\[SuchThat] (y \\[SuchThat] z). Not the same as \\[ReverseElement]. ", 
    "synonyms" -> {"such that"}, "title" -> "\\[SuchThat]", "type" -> 
    "Character Name", "uri" -> "ref/character/SuchThat"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2287, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2910, 84, 586, 19, 70, "CharacterImage",
 CellID->98798596],
Cell[3499, 105, 53, 1, 70, "CharacterName",
 CellID->12269],
Cell[3555, 108, 47, 1, 70, "Notes",
 CellID->24826],
Cell[3605, 111, 234, 9, 70, "Notes",
 CellID->13331],
Cell[3842, 122, 49, 1, 70, "Notes",
 CellID->18748],
Cell[3894, 125, 501, 20, 70, "Notes",
 CellID->23251],
Cell[4398, 147, 790, 34, 70, "Notes",
 CellID->32134],
Cell[5191, 183, 221, 8, 70, "Notes",
 CellID->28406]
}, Open  ]],
Cell[CellGroupData[{
Cell[5449, 196, 53, 1, 70, "TutorialsSection",
 CellID->11831],
Cell[5505, 199, 128, 3, 70, "Tutorials",
 CellID->5426]
}, Open  ]],
Cell[CellGroupData[{
Cell[5670, 207, 50, 1, 70, "SeeAlsoSection",
 CellID->30630],
Cell[5723, 210, 1059, 29, 70, "SeeAlso",
 CellID->1021]
}, Open  ]],
Cell[CellGroupData[{
Cell[6819, 244, 58, 1, 70, "MoreAboutSection",
 CellID->168946821],
Cell[6880, 247, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7038, 252, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

