(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10034,        337]
NotebookOptionsPosition[      7524,        262]
NotebookOutlinePosition[      8923,        296]
CellTagsIndexPosition[      8880,        293]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Special Characters\"\>", 
       3->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>", 
       4->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Product]" :> 
          Documentation`HelpLookup["paclet:ref/character/Product"], 
          "\\[Integral]" :> 
          Documentation`HelpLookup["paclet:ref/character/Integral"], 
          "\\[CapitalSigma]" :> 
          Documentation`HelpLookup["paclet:ref/character/CapitalSigma"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[Product]\"\>", 
       2->"\<\"\\\\[Integral]\"\>", 
       3->"\<\"\\\\[CapitalSigma]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Sum]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Sum]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->288664200],

Cell["\\[Sum]", "CharacterName",
 CellID->32625],

Cell["Unicode: 2211.", "Notes",
 CellID->21115],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["sum", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->32526],

Cell["\<\
Compound operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->19186],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", "i", 
     SubscriptBox["i", "max"],
     LimitsPositioning->False], "f"}], TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sum"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27229],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     SubscriptBox[
      StyleBox[
       RowBox[{"i", "=", "i"}], "TI"], "min"], 
     SubscriptBox["i", "max"],
     LimitsPositioning->False], "f"}], TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sum"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23299],

Cell[TextData[{
 "Not the same as the Greek letter ",
 Cell[TextData[ButtonBox["\\[CapitalSigma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalSigma"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->21451]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->8947],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->31724],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->14543],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->18702]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->17194],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Product]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Product"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Integral]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Integral"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CapitalSigma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalSigma"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->26479]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->326727202],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Sum] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 7.3951718}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2211. Alias: Esc sum Esc. Compound operator with built-in \
evaluation rules. UnderoverscriptBox[\\[Sum], i, SubscriptBox[i, max], \
LimitsPositioning -> False]f is by default interpreted as Sum[f,{i,i_max}]. \
UnderoverscriptBox[\\[Sum], SubscriptBox[StyleBox[RowBox[{i, =, i}], TI], \
min], SubscriptBox[i, max], LimitsPositioning -> False]f is by default \
interpreted as Sum[f,{i,i_min,i_max}]. Not the same as the Greek letter \
\\[CapitalSigma]. ", "synonyms" -> {"sum"}, "title" -> "\\[Sum]", "type" -> 
    "Character Name", "uri" -> "ref/character/Sum"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2553, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3176, 88, 577, 19, 70, "CharacterImage",
 CellID->288664200],
Cell[3756, 109, 48, 1, 70, "CharacterName",
 CellID->32625],
Cell[3807, 112, 47, 1, 70, "Notes",
 CellID->21115],
Cell[3857, 115, 235, 9, 70, "Notes",
 CellID->32526],
Cell[4095, 126, 99, 3, 70, "Notes",
 CellID->19186],
Cell[4197, 131, 601, 23, 70, "Notes",
 CellID->27229],
Cell[4801, 156, 765, 29, 70, "Notes",
 CellID->23299],
Cell[5569, 187, 231, 7, 70, "Notes",
 CellID->21451]
}, Open  ]],
Cell[CellGroupData[{
Cell[5837, 199, 52, 1, 70, "TutorialsSection",
 CellID->8947],
Cell[5892, 202, 144, 3, 70, "Tutorials",
 CellID->31724],
Cell[6039, 207, 180, 5, 70, "Tutorials",
 CellID->14543],
Cell[6222, 214, 173, 3, 70, "Tutorials",
 CellID->20037],
Cell[6398, 219, 129, 3, 70, "Tutorials",
 CellID->18702]
}, Open  ]],
Cell[CellGroupData[{
Cell[6564, 227, 50, 1, 70, "SeeAlsoSection",
 CellID->17194],
Cell[6617, 230, 624, 17, 70, "SeeAlso",
 CellID->26479]
}, Open  ]],
Cell[CellGroupData[{
Cell[7278, 252, 58, 1, 70, "MoreAboutSection",
 CellID->326727202],
Cell[7339, 255, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7497, 260, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

