(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8866,        282]
NotebookOptionsPosition[      6902,        220]
NotebookOutlinePosition[      8007,        250]
CellTagsIndexPosition[      7964,        247]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[VeryThinSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/VeryThinSpace"], 
          "\\[MediumSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/MediumSpace"], 
          "\\[NegativeThinSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/NegativeThinSpace"], 
          "\\[SpaceIndicator]" :> 
          Documentation`HelpLookup["paclet:ref/character/SpaceIndicator"], 
          "\\[LetterSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/LetterSpace"], 
          "\\[ThinSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/ThinSpace"], 
          "\\[RawSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawSpace"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[VeryThinSpace]\"\>", 
       2->"\<\"\\\\[MediumSpace]\"\>", 3->"\<\"\\\\[NegativeThinSpace]\"\>", 
       4->"\<\"\\\\[SpaceIndicator]\"\>", 5->"\<\"\\\\[LetterSpace]\"\>", 
       6->"\<\"\\\\[ThinSpace]\"\>", 
       7->"\<\"\\\\[RawSpace]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[ThickSpace]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[ThickSpace]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->25926817],

Cell["\\[ThickSpace]", "CharacterName",
 CellID->27837],

Cell["Unicode: 2005.", "Notes",
 CellID->7752],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["\[SpaceIndicator]\[SpaceIndicator]\[SpaceIndicator]\
\[SpaceIndicator]", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->20376],

Cell["Spacing character. ", "Notes",
 CellID->28801],

Cell["Width: 5/18 em. ", "Notes",
 CellID->6953],

Cell[TextData[{
 "Interpreted by default just like an ordinary ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->12093]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->16972],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->11414]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->24794],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[VeryThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VeryThinSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[MediumSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/MediumSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NegativeThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NegativeThinSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SpaceIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SpaceIndicator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LetterSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LetterSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ThinSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->4261]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[ThickSpace] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 15.2859988}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2005. Alias: Esc      Esc. Spacing character. Width: 5/18 em. \
Interpreted by default just like an ordinary \\[RawSpace]. ", 
    "synonyms" -> {"thick space"}, "title" -> "\\[ThickSpace]", "type" -> 
    "Character Name", "uri" -> "ref/character/ThickSpace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2738, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3361, 91, 590, 19, 70, "CharacterImage",
 CellID->25926817],
Cell[3954, 112, 55, 1, 70, "CharacterName",
 CellID->27837],
Cell[4012, 115, 46, 1, 70, "Notes",
 CellID->7752],
Cell[4061, 118, 302, 10, 70, "Notes",
 CellID->20376],
Cell[4366, 130, 52, 1, 70, "Notes",
 CellID->28801],
Cell[4421, 133, 48, 1, 70, "Notes",
 CellID->6953],
Cell[4472, 136, 235, 7, 70, "Notes",
 CellID->12093]
}, Open  ]],
Cell[CellGroupData[{
Cell[4744, 148, 53, 1, 70, "TutorialsSection",
 CellID->16972],
Cell[4800, 151, 196, 4, 70, "Tutorials",
 CellID->11414]
}, Open  ]],
Cell[CellGroupData[{
Cell[5033, 160, 38, 0, 70, "MoreAboutSection"],
Cell[5074, 162, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5254, 169, 50, 1, 70, "SeeAlsoSection",
 CellID->24794],
Cell[5307, 172, 1553, 43, 70, "SeeAlso",
 CellID->4261]
}, Open  ]],
Cell[6875, 218, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

