(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9513,        314]
NotebookOptionsPosition[      6972,        237]
NotebookOutlinePosition[      8321,        270]
CellTagsIndexPosition[      8278,        267]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[NotTilde]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotTilde"], 
          "\\[VerticalTilde]" :> 
          Documentation`HelpLookup["paclet:ref/character/VerticalTilde"], 
          "\\[Not]" :> Documentation`HelpLookup["paclet:ref/character/Not"], 
          "\\[RawTilde]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawTilde"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[NotTilde]\"\>", 
       2->"\<\"\\\\[VerticalTilde]\"\>", 3->"\<\"\\\\[Not]\"\>", 
       4->"\<\"\\\\[RawTilde]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Tilde]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Tilde]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->235333893],

Cell["\\[Tilde]", "CharacterName",
 CellID->21085],

Cell["Unicode: 223C.", "Notes",
 CellID->4169],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["~", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->16415],

Cell["Infix similarity operator. ", "Notes",
 CellID->32191],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Tilde]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tilde",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tilde"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32680],

Cell["\<\
Used in mathematics for many notions of similarity or equivalence. \
\>", "Notes",
 CellID->8965],

Cell["Used in physical science to indicate approximate equality. ", "Notes",
 CellID->29009],

Cell["Occasionally used in mathematics for notions of difference. ", "Notes",
 CellID->560],

Cell["\<\
Occasionally used in prefix form to indicate complement or negation. \
\>", "Notes",
 CellID->11645],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[RawTilde]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawTilde"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->24139]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->3692],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->26201],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->21974]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->14058],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[NotTilde]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotTilde"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[VerticalTilde]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VerticalTilde"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Not]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Not"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawTilde]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawTilde"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->26807]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->315689475],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Tilde] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 22.4893082}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 223C. Alias: Esc ~ Esc. Infix similarity operator. x ~ y is by \
default interpreted as Tilde[x,y]. Used in mathematics for many notions of \
similarity or equivalence. Used in physical science to indicate approximate \
equality. Occasionally used in mathematics for notions of difference. \
Occasionally used in prefix form to indicate complement or negation. Not the \
same as \\[RawTilde]. ", "synonyms" -> {"tilde"}, "title" -> "\\[Tilde]", 
    "type" -> "Character Name", "uri" -> "ref/character/Tilde"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2494, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3117, 85, 581, 19, 70, "CharacterImage",
 CellID->235333893],
Cell[3701, 106, 50, 1, 70, "CharacterName",
 CellID->21085],
Cell[3754, 109, 46, 1, 70, "Notes",
 CellID->4169],
Cell[3803, 112, 233, 9, 70, "Notes",
 CellID->16415],
Cell[4039, 123, 60, 1, 70, "Notes",
 CellID->32191],
Cell[4102, 126, 492, 20, 70, "Notes",
 CellID->32680],
Cell[4597, 148, 107, 3, 70, "Notes",
 CellID->8965],
Cell[4707, 153, 92, 1, 70, "Notes",
 CellID->29009],
Cell[4802, 156, 91, 1, 70, "Notes",
 CellID->560],
Cell[4896, 159, 110, 3, 70, "Notes",
 CellID->11645],
Cell[5009, 164, 206, 7, 70, "Notes",
 CellID->24139]
}, Open  ]],
Cell[CellGroupData[{
Cell[5252, 176, 52, 1, 70, "TutorialsSection",
 CellID->3692],
Cell[5307, 179, 163, 3, 70, "Tutorials",
 CellID->26201],
Cell[5473, 184, 129, 3, 70, "Tutorials",
 CellID->21974]
}, Open  ]],
Cell[CellGroupData[{
Cell[5639, 192, 50, 1, 70, "SeeAlsoSection",
 CellID->14058],
Cell[5692, 195, 837, 23, 70, "SeeAlso",
 CellID->26807]
}, Open  ]],
Cell[CellGroupData[{
Cell[6566, 223, 58, 1, 70, "MoreAboutSection",
 CellID->315689475],
Cell[6627, 226, 143, 2, 70, "MoreAbout"],
Cell[6773, 230, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6945, 235, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

