(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8505,        281]
NotebookOptionsPosition[      6284,        212]
NotebookOutlinePosition[      7474,        243]
CellTagsIndexPosition[      7431,        240]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[TildeTilde]" :> 
          Documentation`HelpLookup["paclet:ref/character/TildeTilde"], 
          "\\[TildeFullEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/TildeFullEqual"], 
          "\\[NotTildeEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotTildeEqual"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[TildeTilde]\"\>", 
       2->"\<\"\\\\[TildeFullEqual]\"\>", 
       3->"\<\"\\\\[NotTildeEqual]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[TildeEqual]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[TildeEqual]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->210064501],

Cell["\\[TildeEqual]", "CharacterName",
 CellID->7780],

Cell["Unicode: 2243.", "Notes",
 CellID->2034],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["~=", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->31910],

Cell["Infix similarity operator. ", "Notes",
 CellID->14686],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[TildeEqual]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TildeEqual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TildeEqual"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26093],

Cell["Used to mean approximately or asymptotically equal. ", "Notes",
 CellID->24205],

Cell["Also used in mathematics to indicate homotopy. ", "Notes",
 CellID->18042]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->29498],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->29078],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->4639]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->12796],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[TildeTilde]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/TildeTilde"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[TildeFullEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/TildeFullEqual"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotTildeEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotTildeEqual"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->3234]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->235426243],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[TildeEqual] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 22.1611748}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2243. Alias: Esc ~= Esc. Infix similarity operator. x ~= y is \
by default interpreted as TildeEqual[x,y]. Used to mean approximately or \
asymptotically equal. Also used in mathematics to indicate homotopy. ", 
    "synonyms" -> {"tilde equal"}, "title" -> "\\[TildeEqual]", "type" -> 
    "Character Name", "uri" -> "ref/character/TildeEqual"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2417, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3040, 84, 591, 19, 70, "CharacterImage",
 CellID->210064501],
Cell[3634, 105, 54, 1, 70, "CharacterName",
 CellID->7780],
Cell[3691, 108, 46, 1, 70, "Notes",
 CellID->2034],
Cell[3740, 111, 234, 9, 70, "Notes",
 CellID->31910],
Cell[3977, 122, 60, 1, 70, "Notes",
 CellID->14686],
Cell[4040, 125, 507, 20, 70, "Notes",
 CellID->26093],
Cell[4550, 147, 85, 1, 70, "Notes",
 CellID->24205],
Cell[4638, 150, 80, 1, 70, "Notes",
 CellID->18042]
}, Open  ]],
Cell[CellGroupData[{
Cell[4755, 156, 53, 1, 70, "TutorialsSection",
 CellID->29498],
Cell[4811, 159, 163, 3, 70, "Tutorials",
 CellID->29078],
Cell[4977, 164, 128, 3, 70, "Tutorials",
 CellID->4639]
}, Open  ]],
Cell[CellGroupData[{
Cell[5142, 172, 50, 1, 70, "SeeAlsoSection",
 CellID->12796],
Cell[5195, 175, 646, 18, 70, "SeeAlso",
 CellID->3234]
}, Open  ]],
Cell[CellGroupData[{
Cell[5878, 198, 58, 1, 70, "MoreAboutSection",
 CellID->235426243],
Cell[5939, 201, 143, 2, 70, "MoreAbout"],
Cell[6085, 205, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6257, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

