(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9551,        308]
NotebookOptionsPosition[      7249,        237]
NotebookOutlinePosition[      8509,        269]
CellTagsIndexPosition[      8466,        266]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[UpTeeArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/UpTeeArrow"], 
          "\\[UpArrowBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/UpArrowBar"], 
          "\\[DoubleUpArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/DoubleUpArrow"], 
          "\\[LeftUpVector]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftUpVector"], 
          "\\[DownArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/DownArrow"], 
          "\\[Wedge]" :> 
          Documentation`HelpLookup["paclet:ref/character/Wedge"], 
          "\\[RawWedge]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawWedge"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[UpTeeArrow]\"\>", 
       2->"\<\"\\\\[UpArrowBar]\"\>", 3->"\<\"\\\\[DoubleUpArrow]\"\>", 
       4->"\<\"\\\\[LeftUpVector]\"\>", 5->"\<\"\\\\[DownArrow]\"\>", 
       6->"\<\"\\\\[Wedge]\"\>", 
       7->"\<\"\\\\[RawWedge]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[UpArrow]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[UpArrow]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->18686150],

Cell["\\[UpArrow]", "CharacterName",
 CellID->25069],

Cell["Unicode: 2191.", "Notes",
 CellID->24405],

Cell["Infix arrow operator. ", "Notes",
 CellID->16228],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[UpArrow]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["UpArrow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UpArrow"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2517],

Cell["\<\
Sometimes used in mathematics to denote generalization of powers. \
\>", "Notes",
 CellID->20568],

Cell["Used to indicate monotonic increase to a limit. ", "Notes",
 CellID->6713],

Cell["\<\
Sometimes used in prefix form to indicate the closure of a set. \
\>", "Notes",
 CellID->30598],

Cell["Extensible character. ", "Notes",
 CellID->13636]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->10191],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->1741],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->22564]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->11413],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[UpTeeArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/UpTeeArrow"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[UpArrowBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/UpArrowBar"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DoubleUpArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleUpArrow"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftUpVector]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftUpVector"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DownArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DownArrow"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Wedge]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawWedge]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawWedge"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->5829]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->40469225],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[UpArrow] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 38.1615844}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2191. Infix arrow operator. x \\[UpArrow] y is by default \
interpreted as UpArrow[x,y]. Sometimes used in mathematics to denote \
generalization of powers. Used to indicate monotonic increase to a limit. \
Sometimes used in prefix form to indicate the closure of a set. Extensible \
character. ", "synonyms" -> {"up arrow"}, "title" -> "\\[UpArrow]", "type" -> 
    "Character Name", "uri" -> "ref/character/UpArrow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2746, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3369, 91, 584, 19, 70, "CharacterImage",
 CellID->18686150],
Cell[3956, 112, 52, 1, 70, "CharacterName",
 CellID->25069],
Cell[4011, 115, 47, 1, 70, "Notes",
 CellID->24405],
Cell[4061, 118, 55, 1, 70, "Notes",
 CellID->16228],
Cell[4119, 121, 497, 20, 70, "Notes",
 CellID->2517],
Cell[4619, 143, 107, 3, 70, "Notes",
 CellID->20568],
Cell[4729, 148, 80, 1, 70, "Notes",
 CellID->6713],
Cell[4812, 151, 105, 3, 70, "Notes",
 CellID->30598],
Cell[4920, 156, 55, 1, 70, "Notes",
 CellID->13636]
}, Open  ]],
Cell[CellGroupData[{
Cell[5012, 162, 53, 1, 70, "TutorialsSection",
 CellID->10191],
Cell[5068, 165, 162, 3, 70, "Tutorials",
 CellID->1741],
Cell[5233, 170, 129, 3, 70, "Tutorials",
 CellID->22564]
}, Open  ]],
Cell[CellGroupData[{
Cell[5399, 178, 50, 1, 70, "SeeAlsoSection",
 CellID->11413],
Cell[5452, 181, 1515, 41, 70, "SeeAlso",
 CellID->5829]
}, Open  ]],
Cell[CellGroupData[{
Cell[7004, 227, 57, 1, 70, "MoreAboutSection",
 CellID->40469225],
Cell[7064, 230, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7222, 235, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

