(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9695,        326]
NotebookOptionsPosition[      7340,        253]
NotebookOutlinePosition[      8597,        285]
CellTagsIndexPosition[      8554,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Wedge]" :> 
          Documentation`HelpLookup["paclet:ref/character/Wedge"], "\\[Union]" :> 
          Documentation`HelpLookup["paclet:ref/character/Union"], 
          "\\[SquareUnion]" :> 
          Documentation`HelpLookup["paclet:ref/character/SquareUnion"], 
          "\\[Nu]" :> Documentation`HelpLookup["paclet:ref/character/Nu"], 
          "\\[Hacek]" :> 
          Documentation`HelpLookup["paclet:ref/character/Hacek"], "\\[Or]" :> 
          Documentation`HelpLookup["paclet:ref/character/Or"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[Wedge]\"\>", 
       2->"\<\"\\\\[Union]\"\>", 3->"\<\"\\\\[SquareUnion]\"\>", 
       4->"\<\"\\\\[Nu]\"\>", 5->"\<\"\\\\[Hacek]\"\>", 
       6->"\<\"\\\\[Or]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Vee]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Vee]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->8382223],

Cell["\\[Vee]", "CharacterName",
 CellID->17058],

Cell["Unicode: 22C1.", "Notes",
 CellID->25998],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["v", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->17757],

Cell["Infix operator. ", "Notes",
 CellID->14567],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Vee]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Vee",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Vee"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8023],

Cell[TextData[{
 "Used to indicate various notions of joining, and as a dual of ",
 Cell[TextData[ButtonBox["\\[Wedge]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->31500],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Or]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Or"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->1105],

Cell[TextData[{
 "Drawn slightly smaller than ",
 Cell[TextData[ButtonBox["\\[Or]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Or"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->30468],

Cell["\<\
Sometimes used in prefix form to indicate the total variation of a function. \
\
\>", "Notes",
 CellID->2136]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->6465],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->21577],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->25751]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->11952],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Wedge]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Union]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Union"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SquareUnion]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SquareUnion"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Nu]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Nu"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Hacek]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Hacek"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Or]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Or"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->28406]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->311085962],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Vee] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 46.1774146}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 22C1. Alias: Esc v Esc. Infix operator. x \\[Vee] y is by \
default interpreted as Vee[x,y]. Used to indicate various notions of joining, \
and as a dual of \\[Wedge]. Not the same as \\[Or]. Drawn slightly smaller \
than \\[Or]. Sometimes used in prefix form to indicate the total variation of \
a function. ", "synonyms" -> {"vee"}, "title" -> "\\[Vee]", "type" -> 
    "Character Name", "uri" -> "ref/character/Vee"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2490, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3113, 85, 575, 19, 70, "CharacterImage",
 CellID->8382223],
Cell[3691, 106, 48, 1, 70, "CharacterName",
 CellID->17058],
Cell[3742, 109, 47, 1, 70, "Notes",
 CellID->25998],
Cell[3792, 112, 233, 9, 70, "Notes",
 CellID->17757],
Cell[4028, 123, 49, 1, 70, "Notes",
 CellID->14567],
Cell[4080, 126, 485, 20, 70, "Notes",
 CellID->8023],
Cell[4568, 148, 246, 7, 70, "Notes",
 CellID->31500],
Cell[4817, 157, 193, 7, 70, "Notes",
 CellID->1105],
Cell[5013, 166, 206, 7, 70, "Notes",
 CellID->30468],
Cell[5222, 175, 119, 4, 70, "Notes",
 CellID->2136]
}, Open  ]],
Cell[CellGroupData[{
Cell[5378, 184, 52, 1, 70, "TutorialsSection",
 CellID->6465],
Cell[5433, 187, 163, 3, 70, "Tutorials",
 CellID->21577],
Cell[5599, 192, 129, 3, 70, "Tutorials",
 CellID->25751]
}, Open  ]],
Cell[CellGroupData[{
Cell[5765, 200, 50, 1, 70, "SeeAlsoSection",
 CellID->11952],
Cell[5818, 203, 1239, 35, 70, "SeeAlso",
 CellID->28406]
}, Open  ]],
Cell[CellGroupData[{
Cell[7094, 243, 58, 1, 70, "MoreAboutSection",
 CellID->311085962],
Cell[7155, 246, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7313, 251, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

