(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12677,        399]
NotebookOptionsPosition[     10031,        322]
NotebookOutlinePosition[     11543,        357]
CellTagsIndexPosition[     11500,        354]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RawVerticalBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawVerticalBar"], 
          "\\[Nand]" :> Documentation`HelpLookup["paclet:ref/character/Nand"],
           "\\[NotVerticalBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotVerticalBar"], 
          "\\[DoubleVerticalBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/DoubleVerticalBar"], 
          "\\[Backslash]" :> 
          Documentation`HelpLookup["paclet:ref/character/Backslash"], 
          "\\[HorizontalLine]" :> 
          Documentation`HelpLookup["paclet:ref/character/HorizontalLine"], 
          "\\[LeftBracketingBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftBracketingBar"], 
          "\\[RightBracketingBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightBracketingBar"],
           "\\[VerticalSeparator]" :> 
          Documentation`HelpLookup["paclet:ref/character/VerticalSeparator"], 
          "\\[VerticalLine]" :> 
          Documentation`HelpLookup["paclet:ref/character/VerticalLine"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[RawVerticalBar]\"\>", 
       2->"\<\"\\\\[Nand]\"\>", 3->"\<\"\\\\[NotVerticalBar]\"\>", 
       4->"\<\"\\\\[DoubleVerticalBar]\"\>", 5->"\<\"\\\\[Backslash]\"\>", 
       6->"\<\"\\\\[HorizontalLine]\"\>", 
       7->"\<\"\\\\[LeftBracketingBar]\"\>", 
       8->"\<\"\\\\[RightBracketingBar]\"\>", 
       9->"\<\"\\\\[VerticalSeparator]\"\>", 
       10->"\<\"\\\\[VerticalLine]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[VerticalBar]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[VerticalBar]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->905780],

Cell["\\[VerticalBar]", "CharacterName",
 CellID->13516],

Cell["Unicode: 2223.", "Notes",
 CellID->30335],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["\[SpaceIndicator]|", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->7214],

Cell["Infix operator. ", "Notes",
 CellID->6079],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[VerticalBar]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VerticalBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalBar"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6246],

Cell[TextData[{
 "Used in mathematics to indicate that ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " divides ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20689],

Cell["\<\
Also sometimes called Sheffer stroke, and used to indicate logical NAND. \
\>", "Notes",
 CellID->31518],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[VerticalSeparator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VerticalSeparator"]], 
  "InlineCharacterName"],
 ", which is drawn longer. "
}], "Notes",
 CellID->14718],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[LeftBracketingBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftBracketingBar"]], 
  "InlineCharacterName"],
 " and ",
 Cell[TextData[ButtonBox["\\[RightBracketingBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightBracketingBar"]], 
  "InlineCharacterName"],
 ", which are drawn with a small tee to indicate their direction. "
}], "Notes",
 CellID->24244],

Cell[TextData[{
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]|\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " is the alias for ",
 Cell[TextData[ButtonBox["\\[VerticalSeparator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VerticalSeparator"]], 
  "InlineCharacterName"],
 ". The alias for ",
 Cell[TextData[ButtonBox["\\[VerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VerticalBar"]], "InlineCharacterName"],
 " has a space at the beginning. "
}], "Notes",
 CellID->17790]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->26511],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->12542],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->27905]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->23613],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RawVerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawVerticalBar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Nand]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Nand"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotVerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotVerticalBar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DoubleVerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleVerticalBar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Backslash]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Backslash"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[HorizontalLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/HorizontalLine"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftBracketingBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftBracketingBar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightBracketingBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightBracketingBar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[VerticalSeparator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VerticalSeparator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[VerticalLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VerticalLine"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->7257]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[VerticalBar] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 46.4899226}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2223. Alias: Esc  | Esc. Infix operator. x | y is by default \
interpreted as VerticalBar[x,y]. Used in mathematics to indicate that x \
divides y. Also sometimes called Sheffer stroke, and used to indicate logical \
NAND. Not the same as \\[VerticalSeparator], which is drawn longer. Not the \
same as \\[LeftBracketingBar] and \\[RightBracketingBar], which are drawn \
with a small tee to indicate their direction. Esc | Esc is the alias for \
\\[VerticalSeparator]. The alias for \\[VerticalBar] has a space at the \
beginning. ", "synonyms" -> {"vertical bar"}, "title" -> "\\[VerticalBar]", 
    "type" -> "Character Name", "uri" -> "ref/character/VerticalBar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3280, 72, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3903, 99, 590, 19, 70, "CharacterImage",
 CellID->905780],
Cell[4496, 120, 56, 1, 70, "CharacterName",
 CellID->13516],
Cell[4555, 123, 47, 1, 70, "Notes",
 CellID->30335],
Cell[4605, 126, 249, 9, 70, "Notes",
 CellID->7214],
Cell[4857, 137, 48, 1, 70, "Notes",
 CellID->6079],
Cell[4908, 140, 509, 20, 70, "Notes",
 CellID->6246],
Cell[5420, 162, 220, 9, 70, "Notes",
 CellID->20689],
Cell[5643, 173, 114, 3, 70, "Notes",
 CellID->31518],
Cell[5760, 178, 250, 8, 70, "Notes",
 CellID->14718],
Cell[6013, 188, 457, 13, 70, "Notes",
 CellID->24244],
Cell[6473, 203, 534, 15, 70, "Notes",
 CellID->17790]
}, Open  ]],
Cell[CellGroupData[{
Cell[7044, 223, 53, 1, 70, "TutorialsSection",
 CellID->26511],
Cell[7100, 226, 163, 3, 70, "Tutorials",
 CellID->12542],
Cell[7266, 231, 129, 3, 70, "Tutorials",
 CellID->27905]
}, Open  ]],
Cell[CellGroupData[{
Cell[7432, 239, 38, 0, 70, "MoreAboutSection"],
Cell[7473, 241, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7653, 248, 50, 1, 70, "SeeAlsoSection",
 CellID->23613],
Cell[7706, 251, 2283, 66, 70, "SeeAlso",
 CellID->7257]
}, Open  ]],
Cell[10004, 320, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

