(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11492,        365]
NotebookOptionsPosition[      8657,        283]
NotebookOutlinePosition[     10287,        320]
CellTagsIndexPosition[     10244,        317]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[RawVerticalBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawVerticalBar"], 
          "\\[NotVerticalBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotVerticalBar"], 
          "\\[DoubleVerticalBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/DoubleVerticalBar"], 
          "\\[Colon]" :> 
          Documentation`HelpLookup["paclet:ref/character/Colon"], 
          "\\[SuchThat]" :> 
          Documentation`HelpLookup["paclet:ref/character/SuchThat"], 
          "\\[HorizontalLine]" :> 
          Documentation`HelpLookup["paclet:ref/character/HorizontalLine"], 
          "\\[VerticalLine]" :> 
          Documentation`HelpLookup["paclet:ref/character/VerticalLine"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[RawVerticalBar]\"\>", 
       2->"\<\"\\\\[NotVerticalBar]\"\>", 
       3->"\<\"\\\\[DoubleVerticalBar]\"\>", 4->"\<\"\\\\[Colon]\"\>", 
       5->"\<\"\\\\[SuchThat]\"\>", 6->"\<\"\\\\[HorizontalLine]\"\>", 
       7->"\<\"\\\\[VerticalLine]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[VerticalSeparator]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[VerticalSeparator]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->13442949],

Cell["\\[VerticalSeparator]", "CharacterName",
 CellID->30973],

Cell["Unicode: F432.", "Notes",
 CellID->24249],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["|", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->28650],

Cell["Infix operator. ", "Notes",
 CellID->14042],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[VerticalSeparator]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VerticalSeparator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalSeparator"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28018],

Cell["\<\
Used in mathematics for many purposes, including indicating restriction and \
standing for \[OpenCurlyDoubleQuote]such that\[CloseCurlyDoubleQuote]. \
\>", "Notes",
 CellID->30365],

Cell["\<\
Also used to separate arguments of various mathematical functions. \
\>", "Notes",
 CellID->9910],

Cell["Extensible character; grows by default to limited size. ", "Notes",
 CellID->31822],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[VerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VerticalBar"]], "InlineCharacterName"],
 ", which is drawn shorter. "
}], "Notes",
 CellID->12243],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[LeftBracketingBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftBracketingBar"]], 
  "InlineCharacterName"],
 " and ",
 Cell[TextData[ButtonBox["\\[RightBracketingBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightBracketingBar"]], 
  "InlineCharacterName"],
 ", which are drawn with a small tee to indicate their direction. "
}], "Notes",
 CellID->1674],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[VerticalLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VerticalLine"]], "InlineCharacterName"],
 ", which is a letter\[Hyphen]like form, and is indefinitely extensible. "
}], "Notes",
 CellID->17408]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->18042],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->20329],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->182]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->7033],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RawVerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawVerticalBar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotVerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotVerticalBar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DoubleVerticalBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleVerticalBar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Colon]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Colon"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SuchThat]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SuchThat"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[HorizontalLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/HorizontalLine"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[VerticalLine]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/VerticalLine"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->7262]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->568177069],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[VerticalSeparator] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 46.9743100}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F432. Alias: Esc | Esc. Infix operator. x | y is by default \
interpreted as VerticalSeparator[x,y]. Used in mathematics for many purposes, \
including indicating restriction and standing for 'such that'. Also used to \
separate arguments of various mathematical functions. Extensible character; \
grows by default to limited size. Not the same as \\[VerticalBar], which is \
drawn shorter. Not the same as \\[LeftBracketingBar] and \
\\[RightBracketingBar], which are drawn with a small tee to indicate their \
direction. Not the same as \\[VerticalLine], which is a letter-like form, and \
is indefinitely extensible. ", "synonyms" -> {"vertical separator"}, "title" -> 
    "\\[VerticalSeparator]", "type" -> "Character Name", "uri" -> 
    "ref/character/VerticalSeparator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2798, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3421, 91, 604, 19, 70, "CharacterImage",
 CellID->13442949],
Cell[4028, 112, 62, 1, 70, "CharacterName",
 CellID->30973],
Cell[4093, 115, 47, 1, 70, "Notes",
 CellID->24249],
Cell[4143, 118, 233, 9, 70, "Notes",
 CellID->28650],
Cell[4379, 129, 49, 1, 70, "Notes",
 CellID->14042],
Cell[4431, 132, 528, 20, 70, "Notes",
 CellID->28018],
Cell[4962, 154, 190, 4, 70, "Notes",
 CellID->30365],
Cell[5155, 160, 107, 3, 70, "Notes",
 CellID->9910],
Cell[5265, 165, 89, 1, 70, "Notes",
 CellID->31822],
Cell[5357, 168, 236, 7, 70, "Notes",
 CellID->12243],
Cell[5596, 177, 456, 13, 70, "Notes",
 CellID->1674],
Cell[6055, 192, 283, 7, 70, "Notes",
 CellID->17408]
}, Open  ]],
Cell[CellGroupData[{
Cell[6375, 204, 53, 1, 70, "TutorialsSection",
 CellID->18042],
Cell[6431, 207, 163, 3, 70, "Tutorials",
 CellID->20329],
Cell[6597, 212, 127, 3, 70, "Tutorials",
 CellID->182]
}, Open  ]],
Cell[CellGroupData[{
Cell[6761, 220, 49, 1, 70, "SeeAlsoSection",
 CellID->7033],
Cell[6813, 223, 1561, 45, 70, "SeeAlso",
 CellID->7262]
}, Open  ]],
Cell[CellGroupData[{
Cell[8411, 273, 58, 1, 70, "MoreAboutSection",
 CellID->568177069],
Cell[8472, 276, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[8630, 281, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

