(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8908,        284]
NotebookOptionsPosition[      6871,        220]
NotebookOutlinePosition[      7986,        250]
CellTagsIndexPosition[      7943,        247]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ThinSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/ThinSpace"], 
          "\\[NegativeVeryThinSpace]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/NegativeVeryThinSpace"], 
          "\\[AlignmentMarker]" :> 
          Documentation`HelpLookup["paclet:ref/character/AlignmentMarker"], 
          "\\[Null]" :> Documentation`HelpLookup["paclet:ref/character/Null"],
           "\\[InvisibleComma]" :> 
          Documentation`HelpLookup["paclet:ref/character/InvisibleComma"], 
          "\\[RawSpace]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawSpace"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[ThinSpace]\"\>", 
       2->"\<\"\\\\[NegativeVeryThinSpace]\"\>", 
       3->"\<\"\\\\[AlignmentMarker]\"\>", 4->"\<\"\\\\[Null]\"\>", 
       5->"\<\"\\\\[InvisibleComma]\"\>", 
       6->"\<\"\\\\[RawSpace]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Math Typesetting Options & Tweaking" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathTypesettingOptionsAndTweaking"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Math Typesetting Options & Tweaking\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[VeryThinSpace]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[VeryThinSpace]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->56575395],

Cell["\\[VeryThinSpace]", "CharacterName",
 CellID->28690],

Cell["Unicode: 200A.", "Notes",
 CellID->15419],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["\[SpaceIndicator]", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->15924],

Cell["Spacing character. ", "Notes",
 CellID->19040],

Cell["Width: 1/18 em. ", "Notes",
 CellID->24388],

Cell[TextData[{
 "Interpreted by default just like an ordinary ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->25938]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->29228],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->3321]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->19559],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ThinSpace"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NegativeVeryThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NegativeVeryThinSpace"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[AlignmentMarker]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/AlignmentMarker"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Null]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Null"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[InvisibleComma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/InvisibleComma"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->18372]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->456610384],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Math Typesetting Options & Tweaking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[VeryThinSpace] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 47.2868180}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 200A. Alias: Esc   Esc. Spacing character. Width: 1/18 em. \
Interpreted by default just like an ordinary \\[RawSpace]. ", 
    "synonyms" -> {"very thin space"}, "title" -> "\\[VeryThinSpace]", "type" -> 
    "Character Name", "uri" -> "ref/character/VeryThinSpace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2790, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3413, 92, 596, 19, 70, "CharacterImage",
 CellID->56575395],
Cell[4012, 113, 58, 1, 70, "CharacterName",
 CellID->28690],
Cell[4073, 116, 47, 1, 70, "Notes",
 CellID->15419],
Cell[4123, 119, 249, 9, 70, "Notes",
 CellID->15924],
Cell[4375, 130, 52, 1, 70, "Notes",
 CellID->19040],
Cell[4430, 133, 49, 1, 70, "Notes",
 CellID->24388],
Cell[4482, 136, 235, 7, 70, "Notes",
 CellID->25938]
}, Open  ]],
Cell[CellGroupData[{
Cell[4754, 148, 53, 1, 70, "TutorialsSection",
 CellID->29228],
Cell[4810, 151, 195, 4, 70, "Tutorials",
 CellID->3321]
}, Open  ]],
Cell[CellGroupData[{
Cell[5042, 160, 50, 1, 70, "SeeAlsoSection",
 CellID->19559],
Cell[5095, 163, 1330, 38, 70, "SeeAlso",
 CellID->18372]
}, Open  ]],
Cell[CellGroupData[{
Cell[6462, 206, 58, 1, 70, "MoreAboutSection",
 CellID->456610384],
Cell[6523, 209, 143, 2, 70, "MoreAbout"],
Cell[6669, 213, 160, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6844, 218, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

