(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17429,        550]
NotebookOptionsPosition[     14785,        464]
NotebookOutlinePosition[     15931,        499]
CellTagsIndexPosition[     15846,        494]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA FILE", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"mprep" :> Documentation`HelpLookup["paclet:ref/program/mprep"],
           "mcc" :> Documentation`HelpLookup["paclet:ref/program/mcc"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"mprep\"\>", 
       2->"\<\"mcc\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"C/C++ Language Interface" :> 
          Documentation`HelpLookup["paclet:guide/CLanguageInterface"], 
          "Installable MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/InstallableMathLinkPrograms"], 
          "MathLink C Language Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCLanguageFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"C/C++ Language Interface\"\>", 
       2->"\<\"Installable MathLink Programs\"\>", 
       3->"\<\"MathLink C Language Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["file",
  FontSlant->"Italic"],
 ".tm"
}], "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["file", "TI"], ".", "tm"}]], "InlineFormula"],
     " \[LineSeparator]is a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " template file."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template files contain templates for linking external C functions to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions."
}], "Notes",
 CellID->28923933],

Cell["Each template can contain the following:", "Notes",
 CellID->889398403],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{":", 
     RowBox[{"Begin", ":"}]}], Cell[
    "begin the template for a particular function", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{":", 
     RowBox[{"Function", ":"}]}], Cell[
    "the name of the function in the external program", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{":", 
     RowBox[{"Pattern", ":"}]}], Cell[
    "the pattern to be defined to call the function", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{":", 
     RowBox[{"Arguments", ":"}]}], Cell[
    "the arguments to the function", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{":", 
     RowBox[{"ArgumentTypes", ":"}]}], Cell[
    "the types of the arguments to the function", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{":", 
     RowBox[{"ReturnType", ":"}]}], Cell[
    "the type of value returned from the function", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{":", 
     RowBox[{"End", ":"}]}], Cell["end the template", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{":", 
     RowBox[{"Evaluate", ":"}]}], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input to evaluate when the function is installed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"::", 
     StyleBox["text", "TI"]}], Cell["treat as a comment", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->1458742298],

Cell["\<\
Arbitrary C code can be interspersed between templates in a .tm file.\
\>", "Notes",
 CellID->42312118],

Cell["\<\
The following argument and return type specifications can be used: \
\>", "Notes",
 CellID->1424428623],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "Integer16", Cell[TextData[StyleBox[
    "short", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "Integer32", Cell[TextData[StyleBox[
    "int", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "Integer64", Cell[TextData[StyleBox[
    ButtonBox["mlint64",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/c/mlint64"], "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "Real32", Cell[TextData[StyleBox[
    "float", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "Real64", Cell[TextData[StyleBox[
    "double", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "Real128", Cell[TextData[StyleBox[
    ButtonBox["mlextended_double",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/c/mlextended_double"], "InlineCode"]], 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "Integer16List", Cell[TextData[{
     StyleBox["short*", "InlineCode"],
     ", ",
     StyleBox["int", "InlineCode"],
     " (length)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "Integer32List", Cell[TextData[{
     StyleBox["int*", "InlineCode"],
     ", ",
     StyleBox["int", "InlineCode"],
     " (length)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "Integer64List", Cell[TextData[{
     StyleBox[ButtonBox["mlint64",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/mlint64"], "InlineCode"],
     StyleBox["*", "InlineCode"],
     ", ",
     StyleBox["int", "InlineCode"],
     " (length)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "Real32List", Cell[TextData[{
     StyleBox["float*", "InlineCode"],
     ", ",
     StyleBox["int", "InlineCode"],
     " (length)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "Real64List", Cell[TextData[{
     StyleBox["double*", "InlineCode"],
     ", ",
     StyleBox["int", "InlineCode"],
     " (length)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "Real128List", Cell[TextData[{
     StyleBox[ButtonBox["mlextended_double",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/mlextended_double"], "InlineCode"],
     StyleBox["*", "InlineCode"],
     ", ",
     StyleBox["int", "InlineCode"],
     " (length)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "String", Cell[TextData[StyleBox[
    "char*", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "ByteString", 
    RowBox[{
     StyleBox["unsigned", "InlineCode"], 
     StyleBox[" ", "InlineCode"], 
     StyleBox["char", "InlineCode"], 
     StyleBox["*", "InlineCode"], 
     StyleBox[" ", "TableText"], 
     StyleBox["and", "TableText"], 
     StyleBox[" ", "TableText"], 
     StyleBox["int", "InlineCode"], 
     StyleBox[" ", "TableText"], 
     StyleBox[
      RowBox[{"(", "length", ")"}], "TableText"]}]},
   {Cell["      ", "TableRowIcon"], "UCS2String", 
    RowBox[{"unsigned", " ", "short", "*"}]},
   {Cell["      ", "TableRowIcon"], "UTF8String", Cell[TextData[{
     StyleBox["unsigned char*", "InlineCode"],
     ", ",
     StyleBox["int", "InlineCode"],
     " (bytes), ",
     StyleBox["int", "InlineCode"],
     " (characters)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "UTF16String", Cell[TextData[{
     StyleBox["unsigned short*", "InlineCode"],
     ", ",
     StyleBox["int", "InlineCode"],
     " (length), ",
     StyleBox["int", "InlineCode"],
     " (characters)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "UTF32String", Cell[TextData[{
     StyleBox["unsigned int*, ", "InlineCode"],
     "and ",
     StyleBox["int", "InlineCode"],
     " (length)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "Symbol", Cell[TextData[StyleBox[
    "char*", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "ByteSymbol", Cell[TextData[{
     StyleBox["unsigned char*", "InlineCode"],
     ", ",
     StyleBox["int", "InlineCode"],
     " (length)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "UCS2Symbol", Cell[TextData[{
     StyleBox["unsigned short*", "InlineCode"],
     ", ",
     StyleBox["int", "InlineCode"],
     " (length)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "UTF8Symbol", Cell[TextData[{
     StyleBox["unsigned char*", "InlineCode"],
     ", ",
     StyleBox["int", "InlineCode"],
     " (bytes), ",
     StyleBox["int", "InlineCode"],
     " (characters)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "UTF16Symbol", Cell[TextData[{
     StyleBox["unsigned short*", "InlineCode"],
     ", ",
     StyleBox["int", "InlineCode"],
     " (length), ",
     StyleBox["int", "InlineCode"],
     " (characters)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "UTF32Symbol", Cell[TextData[{
     StyleBox["unsigned int*", "InlineCode"],
     ", ",
     StyleBox["int", "InlineCode"],
     " (length)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "ThisLink", Cell[TextData[StyleBox[
    ButtonBox["MLINK",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/c/MLINK"], "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "$CurrentLink", Cell[TextData[StyleBox[
    ButtonBox["MLINK",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/c/MLINK"], "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], "Manual", Cell[TextData[StyleBox[
    "void", "InlineCode"]], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True}}}},
 CellID->1195723755],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template files are converted to C code using mprep. They are also \
processed automatically by mcc when available. "
}], "Notes",
 CellID->426237433]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->105424812],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->392898662],

Cell[TextData[{
 "Template file entry for a function named ",
 Cell[BoxData["f"], "InlineFormula"],
 " that takes two integers as arguments and returns an integer:"
}], "ExampleText",
 CellID->433231852],

Cell["\<\
:Begin:
:Function:\t\tf
:Pattern:\t\tf[x_Integer, y_Integer]
:Arguments:\t\t{x, y}
:ArgumentTypes:\t{Integer, Integer}
:ReturnType:\tInteger
:End:\
\>", "Program",
 CellID->171397486]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 StyleBox[ButtonBox["mprep",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mprep"],
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["mcc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mcc"],
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["C/C++ Language Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CLanguageInterface"]], "MoreAbout"],

Cell[TextData[{
 ButtonBox["Installable ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"file.tm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 42.1975456}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica File", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "file.tmfile.tm is a MathLink template file.", 
    "synonyms" -> {}, "title" -> "file.tm", "type" -> "File", "uri" -> 
    "ref/file/file"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11916, 351, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->105424812]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15702, 487}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1607, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2230, 65, 106, 5, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[2339, 72, 433, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2809, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3287, 109, 232, 8, 70, "Notes",
 CellID->28923933],
Cell[3522, 119, 77, 1, 70, "Notes",
 CellID->889398403],
Cell[3602, 122, 1814, 46, 70, "2ColumnTableMod",
 CellID->1458742298],
Cell[5419, 170, 113, 3, 70, "Notes",
 CellID->42312118],
Cell[5535, 175, 113, 3, 70, "Notes",
 CellID->1424428623],
Cell[5651, 180, 6011, 158, 70, "2ColumnTableMod",
 CellID->1195723755],
Cell[11665, 340, 214, 6, 70, "Notes",
 CellID->426237433]
}, Closed]],
Cell[CellGroupData[{
Cell[11916, 351, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->105424812],
Cell[CellGroupData[{
Cell[12301, 365, 148, 5, 70, "ExampleSection",
 CellID->392898662],
Cell[12452, 372, 203, 5, 70, "ExampleText",
 CellID->433231852],
Cell[12658, 379, 193, 9, 70, "Program",
 CellID->171397486]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12900, 394, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[13219, 405, 367, 13, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[13623, 423, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[13944, 434, 134, 2, 70, "MoreAbout"],
Cell[14081, 438, 378, 11, 70, "MoreAbout"],
Cell[14462, 451, 281, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[14758, 462, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

