(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    741573,      13314]
NotebookOptionsPosition[    735695,      13123]
NotebookOutlinePosition[    737079,      13161]
CellTagsIndexPosition[    736991,      13156]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"BYU\"" :> Documentation`HelpLookup["paclet:ref/format/BYU"], 
          "\"JVX\"" :> Documentation`HelpLookup["paclet:ref/format/JVX"], 
          "\"LWO\"" :> Documentation`HelpLookup["paclet:ref/format/LWO"], 
          "\"Maya\"" :> Documentation`HelpLookup["paclet:ref/format/Maya"], 
          "\"OFF\"" :> Documentation`HelpLookup["paclet:ref/format/OFF"], 
          "\"POV\"" :> Documentation`HelpLookup["paclet:ref/format/POV"], 
          "\"RIB\"" :> Documentation`HelpLookup["paclet:ref/format/RIB"], 
          "\"STL\"" :> Documentation`HelpLookup["paclet:ref/format/STL"], 
          "\"X3D\"" :> Documentation`HelpLookup["paclet:ref/format/X3D"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"BYU\\\"\"\>", 
       2->"\<\"\\\"JVX\\\"\"\>", 3->"\<\"\\\"LWO\\\"\"\>", 
       4->"\<\"\\\"Maya\\\"\"\>", 5->"\<\"\\\"OFF\\\"\"\>", 
       6->"\<\"\\\"POV\\\"\"\>", 7->"\<\"\\\"RIB\\\"\"\>", 
       8->"\<\"\\\"STL\\\"\"\>", 
       9->"\<\"\\\"X3D\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"3D Geometry & Modeling Formats\"\>", 
       2->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "3DS ",
 StyleBox["(.3ds)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell[TextData[{
 "MIME types: ",
 StyleBox["application/x-3ds", "InlineCode"],
 ", ",
 StyleBox["image/x-3ds\n", "InlineCode"],
 "Autodesk 3DS file format.\nScene description and 3D modeling format.\nUsed \
for 3D modeling and animation.\nNative format of Autodesk 3D Studio.\nBinary \
file format.\nStores 3D objects together with lighting and viewpoint \
information."
}], "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " reads the Polygon Mesh Object contents of the 3DS format."
}], "FormatNotes",
 CellID->5821],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " to the 3DS format supports the following graphics primitives: ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Cuboid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cuboid"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Cylinder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cylinder"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Sphere",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sphere"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1150224632]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).3ds\>\"", "]"}]], "InlineFormula"],
 "imports a 3DS file ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).3ds\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " expression to a 3DS file."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).3ds\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "[", " ", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    RowBox[{
     StyleBox["vertices", "TI"], 
     StyleBox[",", "TI"], 
     StyleBox["primitives", "TI"], ",", 
     StyleBox["opts", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->25134],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).3ds\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a 3DS file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).3ds\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).3ds\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""}]], "InlineFormula"],
 ",",
 Cell[BoxData["\"\<3DS\>\""], "InlineFormula"],
 "] or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<3DS\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).3ds\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a 3DS file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).3ds\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).3ds\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).3ds\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell[TextData[{
 "The export format can be explicitly specified in the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["expr", "TI"], ",", "\"\<3DS\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<3DS\>\"", ",", 
      StyleBox["elems", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->111068952],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "3DS",
 " format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Data representation elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "3DS file represented as a ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsComplex\>\"", Cell[
    TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " objects, each representing a 3D geometry stored in the file"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonColors\>\"", Cell["\<\
face color information, given as a list of color primitives associated with \
each polygon\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonData\>\"", Cell[
    "polygon data in indexed form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexData\>\"", Cell[
    "list of vertex coordinates", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->961108812],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Graphics3D\>\""], "InlineFormula"],
 " element by default for 3DS files."
}], "FormatNotes",
 CellID->13037],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"],
 " element corresponds to the first argument of ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->4998],

Cell[TextData[{
 "When rendering a 3DS color model, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically uses the setting",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    ButtonBox["Lighting",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Lighting"], "->", "\"\<Neutral\>\""}]}]], 
  "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1495251562]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1911960202],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what background color to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall size of the graphics to display", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Lighting",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Lighting"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what simulated lighting to use in coloring 3D surfaces", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->2123520593],

Cell[TextData[{
 "All options of ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " can be given when importing from 3DS."
}], "FormatNotes",
 CellID->1022956994],

Cell["Advanced option:", "FormatNotes",
 CellID->19539],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<VerticalAxis\>\"", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}], Cell["\<\
orientation to assume for the coordinate system used in the file\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->28047],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that in the coordinate system used by 3DS the vertical axis \
corresponds to the third coordinate."
}], "FormatNotes",
 CellID->1642809193],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<VerticalAxis\>\"", "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will apply the transformation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     RowBox[{"-", 
      StyleBox["z", "TI"]}], ",", 
     StyleBox["y", "TI"]}], "}"}], " "}]], "InlineFormula"],
 "to all graphics coordinates when importing from 3DS, and the inverse \
transformation when exporting to 3DS."
}], "FormatNotes",
 CellID->182941150]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<BYU\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/BYU"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JVX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JVX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LWO\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LWO"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Maya\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Maya"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<POV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/POV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<RIB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/RIB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<STL\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/STL"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<X3D\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/X3D"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2645]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->33817001],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->538294639],

Cell["Show the import elements available in a 3DS  file:", "ExampleText",
 CellID->2041162356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/747.3ds.gz\>\"", ",", " ", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1982064839],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Graphics3D\"\>", ",", "\<\"GraphicsComplex\"\>", 
   ",", "\<\"PolygonColors\"\>", ",", "\<\"PolygonData\"\>", 
   ",", "\<\"PolygonObjects\"\>", ",", "\<\"VertexData\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1911940114]
}, Open  ]],

Cell["Import an example file, rendering it as 3D graphics:", "ExampleText",
 CellID->1839488447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/747.3ds.gz\>\"", ",", " ", 
   RowBox[{"ImageSize", " ", "\[Rule]", " ", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17199],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[None], GraphicsComplex3DBox[CompressedData["
1:eJx9Wn+MFVcVnpW2ILbJpmDSjUpn+fGWZbHb5EGqIjIu9JEmm8g+E0zDQodW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    "], {
     {RGBColor[0, 0, 0], Polygon3DBox[{1, 2, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{2, 4, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{4, 5, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{5, 6, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{6, 7, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{7, 8, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{8, 9, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{9, 10, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{11, 12, 1}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{12, 2, 1}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{12, 13, 2}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{13, 4, 2}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{13, 14, 4}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{14, 5, 4}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{14, 15, 5}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{15, 6, 5}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{15, 16, 6}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{16, 7, 6}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{16, 17, 7}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{17, 8, 7}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{17, 18, 8}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{18, 9, 8}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{18, 19, 9}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{19, 10, 9}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{20, 21, 22}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{23, 20, 22}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{24, 23, 22}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{25, 23, 24}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{26, 25, 24}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{27, 25, 26}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{28, 25, 27}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{29, 28, 27}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{30, 28, 29}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{31, 30, 29}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{32, 30, 31}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{33, 32, 31}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{34, 35, 36}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{37, 35, 34}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{38, 39, 40}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{41, 39, 38}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{42, 43, 44}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{43, 45, 46}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{44, 43, 46}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{47, 45, 48}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{46, 45, 47}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{49, 47, 48}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{50, 51, 52}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{53, 50, 52}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{51, 54, 55}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{52, 51, 55}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{55, 54, 56}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{57, 58, 59}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{58, 57, 60}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{58, 60, 53}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{60, 50, 53}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{49, 48, 61}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{48, 62, 61}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{61, 62, 63}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{62, 64, 63}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{57, 59, 64}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{63, 64, 59}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{65, 66, 67}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{66, 68, 67}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{66, 69, 68}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{69, 70, 68}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{69, 71, 70}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{71, 72, 70}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{71, 73, 72}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{73, 74, 72}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{73, 75, 74}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{75, 76, 74}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{75, 77, 76}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{77, 78, 76}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{77, 79, 78}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{79, 80, 78}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{79, 81, 80}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{81, 82, 80}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{81, 83, 82}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{83, 84, 82}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{83, 85, 84}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{85, 86, 84}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{85, 87, 86}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{87, 88, 86}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{87, 89, 88}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{89, 90, 88}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{89, 91, 90}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{91, 92, 90}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{91, 93, 92}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{93, 94, 92}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{93, 95, 94}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{95, 96, 94}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{95, 97, 96}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{97, 98, 96}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{99, 100, 101}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{100, 102, 103}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{102, 104, 105}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{104, 106, 107}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{106, 108, 109}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{108, 110, 111}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{110, 112, 113}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{112, 114, 115}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{114, 116, 117}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{116, 118, 119}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{118, 120, 121}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{120, 122, 123}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{122, 124, 125}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{124, 126, 127}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{126, 128, 129}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{128, 99, 130}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{131, 132, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{132, 134, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{134, 135, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{135, 136, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{136, 137, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{137, 138, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{138, 139, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{139, 140, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{140, 141, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{141, 142, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{142, 143, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{143, 144, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{144, 145, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{145, 146, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{146, 147, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{147, 131, 133}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{148, 149, 150}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{149, 151, 150}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{149, 152, 151}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{152, 153, 151}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{152, 154, 153}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{154, 155, 153}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{154, 156, 155}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{156, 157, 155}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{156, 158, 157}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{158, 159, 157}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{158, 160, 159}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{160, 161, 159}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{160, 162, 161}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{162, 163, 161}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{162, 164, 163}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{164, 165, 163}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{164, 166, 165}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{166, 167, 165}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{166, 168, 167}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{168, 169, 167}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{168, 170, 169}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{170, 171, 169}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{170, 172, 171}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{172, 173, 171}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{172, 174, 173}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{174, 175, 173}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{174, 176, 175}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{176, 177, 175}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{176, 178, 177}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{178, 179, 177}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{178, 180, 179}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{180, 181, 179}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{182, 183, 184}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{183, 185, 186}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{185, 187, 188}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{187, 189, 190}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{189, 191, 192}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{191, 193, 194}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{193, 195, 196}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{195, 197, 198}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{197, 199, 200}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{199, 201, 202}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{201, 203, 204}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{203, 205, 206}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{205, 207, 208}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{207, 209, 210}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{209, 211, 212}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{211, 182, 213}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{214, 215, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{215, 217, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{217, 218, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{218, 219, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{219, 220, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{220, 221, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{221, 222, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{222, 223, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{223, 224, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{224, 225, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{225, 226, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{226, 227, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{227, 228, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{228, 229, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{229, 230, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{230, 214, 216}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{231, 232, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{232, 234, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{234, 235, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{235, 236, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{236, 237, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{237, 238, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{238, 239, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{239, 240, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{240, 241, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{241, 242, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{242, 243, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{243, 244, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{244, 245, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{245, 246, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{246, 247, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{247, 231, 233}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{248, 249, 250}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{249, 251, 252}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{251, 253, 254}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{253, 255, 256}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{255, 257, 258}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{257, 259, 260}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{259, 261, 262}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{261, 263, 264}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{263, 265, 266}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{265, 267, 268}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{267, 269, 270}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{269, 271, 272}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{271, 273, 274}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{273, 275, 276}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{275, 277, 278}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{277, 248, 279}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{280, 281, 282}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{281, 283, 282}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{282, 283, 284}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{283, 285, 284}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{284, 285, 286}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{285, 287, 286}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{286, 287, 288}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{287, 289, 288}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{288, 289, 290}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{289, 291, 290}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{290, 291, 292}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{291, 293, 292}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{292, 293, 294}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{293, 295, 294}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{294, 295, 296}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{295, 297, 296}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{296, 297, 298}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{297, 299, 298}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{298, 299, 300}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{299, 301, 300}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{300, 301, 302}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{301, 303, 302}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{302, 303, 304}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{303, 305, 304}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{304, 305, 306}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{305, 307, 306}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{306, 307, 308}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{307, 309, 308}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{308, 309, 310}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{309, 311, 310}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{310, 311, 312}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{311, 313, 312}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{314, 315, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{315, 317, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{317, 318, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{318, 319, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{319, 320, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{320, 321, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{321, 322, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{322, 323, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{323, 324, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{324, 325, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{325, 326, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{326, 327, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{327, 328, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{328, 329, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{329, 330, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{330, 314, 316}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{331, 332, 333}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{332, 334, 335}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{334, 336, 337}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{336, 338, 339}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{338, 340, 341}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{340, 342, 343}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{342, 344, 345}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{344, 346, 347}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{346, 348, 349}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{348, 350, 351}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{350, 352, 353}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{352, 354, 355}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{354, 356, 357}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{356, 358, 359}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{358, 360, 361}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{360, 331, 362}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{363, 364, 365}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{364, 366, 365}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{365, 366, 367}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{366, 368, 367}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{367, 368, 369}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{368, 370, 369}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{369, 370, 371}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{370, 372, 371}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{371, 372, 373}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{372, 374, 373}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{373, 374, 375}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{374, 376, 375}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{375, 376, 377}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{376, 378, 377}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{377, 378, 379}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{378, 380, 379}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{379, 380, 381}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{380, 382, 381}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{381, 382, 383}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{382, 384, 383}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{383, 384, 385}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{384, 386, 385}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{385, 386, 387}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{386, 388, 387}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{387, 388, 389}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{388, 390, 389}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{389, 390, 391}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{390, 392, 391}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{391, 392, 393}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{392, 394, 393}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{393, 394, 395}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{394, 396, 395}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{397, 398, 399}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{399, 400, 397}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{397, 401, 398}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{401, 402, 398}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{401, 403, 402}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{403, 404, 402}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{405, 406, 407}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{406, 408, 407}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{400, 408, 406}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{408, 400, 399}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{409, 410, 56}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{411, 412, 410}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{409, 411, 410}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{405, 407, 412}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{411, 405, 412}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{413, 404, 403}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{414, 415, 413}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{414, 413, 403}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{416, 417, 415}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{414, 416, 415}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{416, 418, 417}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{419, 420, 421}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{419, 421, 422}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{423, 424, 425}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{423, 425, 426}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{427, 428, 429}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{430, 427, 429}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{430, 429, 431}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{432, 430, 431}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{432, 431, 433}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{434, 432, 433}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{434, 433, 435}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{434, 435, 436}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{437, 434, 436}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{437, 436, 438}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{439, 437, 438}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{440, 439, 438}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{10, 19, 441}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{19, 442, 441}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{441, 442, 443}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{442, 444, 443}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{443, 444, 445}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{444, 446, 445}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{445, 446, 447}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{446, 448, 447}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{447, 448, 449}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{448, 450, 449}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{449, 450, 451}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{450, 452, 451}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{451, 452, 453}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{452, 454, 453}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{453, 454, 1}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{454, 11, 1}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{10, 441, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{441, 443, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{443, 445, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{445, 447, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{447, 449, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{449, 451, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{451, 453, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{453, 1, 3}]}}], 
   GraphicsComplex3DBox[CompressedData["
1:eJx1ljFv01AUhZ9gQYiNqUtx0iRNGpg8I5mIZoqEmjmDhYRXMnfBAx2YLLFl
sxQkNoTUic0/wAxdADG5c2EMDAzG98Unee9wsVRZvT46Ofnede7tPH85f3HL
GJM2f7dNe6Wnhdw+l4Hc0yQ5lnuweObVo0Vm69CnYdixOmP69nl436tX5czW
i8O+59Poh3LPV5+ekn5g9Zs7vv7r2uqj63NPH4eXbR7D+Uf2eZJ4etTZv9oM
TzT/YnUw1vLnN1cnWv7ApA81bmk2GWt8zLvlI5enk3+sca7K0uqr9UfVvyh/
qP7R9Xc1f5xMp1r+6O5vlU9xeOHpwae5phr/fLXy9KizP86X/XG+nD9o+4fz
o3+YD/qW+aA/mydn2+f3nlh9knTt53x479XNIuu6+jgZ2HpR1w+23/eNV8/L
mf38OHvr+VR13d3+v2D9Ntf5a1//ZX1kny8fe/ogvGzzpJy/Z+9h6OlRZ/98
M+xr/unqYKDlj2+u+lr+qn51rHGLsslA41Osl8P/8B9onPOytPrq7JvqHye/
VP98+VPNH4VHczX/xR+VT5xNPD34NNdc41+UM0+POvvjfNkf58v50T+cf9c/
xAd9y3zQn8I5Mv/2M+r8XohPpPjI57p6fK7kJH0H38vV43sJB1cPDsLN07fc
hLOrB2c5F8rf0/xxjuyPc+f86BPOj75iPuhD5oO+Zf7oc4W/1ct7pPnLe6f5
y3uq5Zf3WssvvwMaH/nd0PmEnn7PP+X8Pc0f58v++/NdcL91tPzoH+aD/mQ+
+9/z9FTqvM+gznuRzBFXjzkic8fVY+7InCK95SlzzdUH7VyTOejqd3OwmZue
vp2bMmddPeZsc00p/0jzxxxnf8x9zr/bEyg/9grmgz2E+WBvYf7YcxT+uz1K
85e9S/OXPU3LL3udll/2QI2P7I06n8TTO/w5/0jzx/my//58/fy7PZnyB23/
MB/0J/Ox/fkXWwVf+A==
    "], {
     {RGBColor[0, 0, 0], Polygon3DBox[{1, 2, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{2, 4, 3}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{2, 5, 4}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{5, 6, 4}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{5, 7, 6}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{7, 8, 6}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{7, 9, 8}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{9, 10, 8}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{9, 11, 10}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{11, 12, 10}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{11, 13, 12}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{13, 14, 12}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{13, 15, 14}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{15, 16, 14}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{15, 17, 16}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{17, 18, 16}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{17, 19, 18}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{19, 20, 18}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{19, 21, 20}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{21, 22, 20}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{21, 23, 22}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{23, 24, 22}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{23, 25, 24}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{25, 26, 24}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{25, 27, 26}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{27, 28, 26}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{27, 29, 28}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{29, 30, 28}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{29, 31, 30}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{31, 32, 30}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{31, 1, 32}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{1, 3, 32}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{33, 34, 35}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{34, 36, 35}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{34, 37, 36}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{37, 38, 36}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{37, 39, 38}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{39, 40, 38}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{39, 41, 40}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{41, 42, 40}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{41, 43, 42}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{43, 44, 42}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{43, 45, 44}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{45, 46, 44}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{45, 47, 46}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{47, 48, 46}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{47, 49, 48}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{49, 50, 48}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{49, 51, 50}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{51, 52, 50}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{51, 53, 52}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{53, 54, 52}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{53, 55, 54}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{55, 56, 54}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{55, 57, 56}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{57, 58, 56}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{57, 59, 58}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{59, 60, 58}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{59, 61, 60}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{61, 62, 60}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{61, 63, 62}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{63, 64, 62}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{63, 33, 64}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{33, 35, 64}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{65, 66, 67}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{66, 68, 67}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{67, 68, 69}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{68, 70, 69}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{69, 70, 71}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{70, 72, 71}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{71, 72, 73}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{72, 74, 73}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{73, 74, 75}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{74, 76, 75}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{75, 76, 77}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{76, 78, 77}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{77, 78, 79}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{78, 80, 79}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{79, 80, 81}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{80, 82, 81}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{81, 82, 83}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{82, 84, 83}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{83, 84, 85}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{84, 86, 85}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{85, 86, 87}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{86, 88, 87}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{87, 88, 89}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{88, 90, 89}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{89, 90, 91}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{90, 92, 91}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{91, 92, 93}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{92, 94, 93}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{93, 94, 95}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{94, 96, 95}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{95, 96, 65}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{96, 66, 65}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{97, 98, 99}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{98, 100, 99}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{99, 100, 101}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{100, 102, 101}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{101, 102, 103}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{102, 104, 103}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{103, 104, 105}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{104, 106, 105}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{105, 106, 107}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{106, 108, 107}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{107, 108, 109}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{108, 110, 109}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{109, 110, 111}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{110, 112, 111}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{111, 112, 113}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{112, 114, 113}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{113, 114, 115}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{114, 116, 115}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{115, 116, 117}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{116, 118, 117}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{117, 118, 119}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{118, 120, 119}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{119, 120, 121}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{120, 122, 121}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{121, 122, 123}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{122, 124, 123}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{123, 124, 125}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{124, 126, 125}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{125, 126, 127}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{126, 128, 127}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{127, 128, 97}]}, 
     {RGBColor[0, 0, 0], Polygon3DBox[{128, 98, 97}]}}], 
   GraphicsComplex3DBox[CompressedData["
1:eJx9mX9sFEUUx6fQgjZUEn62FPBKK1JABc/Kz7bbCmmiJHJUi0i5Lphe/cNg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    "], {
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{1, 2, 3}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{2, 4, 3}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{2, 5, 4}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{5, 6, 4}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{5, 7, 6}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{5, 8, 7}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{8, 9, 7}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{9, 10, 7}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{11, 12, 1}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{12, 2, 1}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{12, 13, 2}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{13, 5, 2}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{14, 15, 11}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{15, 12, 11}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{15, 16, 12}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{16, 13, 12}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{17, 18, 14}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{18, 15, 14}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{18, 16, 15}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{19, 20, 21}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{22, 19, 21}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{21, 18, 17}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{22, 21, 17}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{23, 20, 19}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{24, 23, 19}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{25, 23, 24}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{26, 25, 24}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{27, 25, 26}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{28, 27, 26}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{29, 30, 27}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{29, 27, 28}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{29, 31, 30}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{31, 32, 30}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{33, 32, 31}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{34, 35, 32}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{33, 34, 32}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{36, 37, 35}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{34, 36, 35}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{38, 39, 37}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{36, 38, 37}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{40, 41, 39}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{38, 40, 39}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{42, 43, 41}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{40, 42, 41}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{44, 45, 43}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{42, 44, 43}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{46, 47, 45}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{44, 46, 45}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{48, 46, 44}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{49, 50, 47}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{46, 49, 47}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{51, 49, 46}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{48, 51, 46}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{49, 52, 50}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{51, 52, 49}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{53, 52, 51}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{54, 55, 52}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{53, 54, 52}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{56, 54, 53}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{57, 58, 55}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{54, 57, 55}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{56, 57, 54}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{59, 60, 61}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{59, 62, 60}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{63, 62, 59}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{61, 60, 64}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{60, 65, 64}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{66, 65, 67}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{64, 65, 66}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{66, 67, 68}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{67, 69, 68}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{68, 69, 70}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{69, 71, 70}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{70, 71, 72}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{71, 73, 72}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{72, 73, 74}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{73, 75, 74}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{76, 75, 77}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{74, 75, 76}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{78, 79, 80}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{79, 81, 80}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{81, 82, 80}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{82, 83, 80}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{83, 84, 80}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{84, 85, 80}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{85, 86, 80}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{86, 87, 80}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{88, 87, 86}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{89, 90, 91}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{90, 92, 91}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{93, 92, 90}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{93, 94, 92}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{95, 96, 97}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{98, 95, 97}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{99, 95, 98}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{100, 99, 98}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{101, 100, 98}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{102, 101, 98}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{103, 104, 105}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{104, 106, 105}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{106, 107, 105}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{107, 108, 105}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{108, 109, 105}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{110, 102, 98}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{111, 110, 98}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{112, 111, 98}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{97, 112, 98}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{113, 114, 115}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{116, 113, 115}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{117, 113, 116}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{118, 117, 116}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{119, 120, 114}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{113, 119, 114}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{121, 119, 113}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{117, 121, 113}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{122, 123, 120}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{119, 122, 120}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{124, 122, 119}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{125, 126, 123}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{122, 125, 123}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{127, 125, 122}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{124, 127, 122}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{128, 129, 126}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{125, 128, 126}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{130, 128, 125}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{127, 130, 125}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{121, 124, 119}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{131, 132, 133}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{134, 131, 133}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{134, 133, 117}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{118, 134, 117}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{132, 135, 136}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{133, 132, 136}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{133, 136, 121}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{117, 133, 121}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{135, 137, 138}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{136, 135, 138}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{136, 138, 124}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{121, 136, 124}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{137, 139, 140}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{138, 137, 140}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{138, 140, 127}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{124, 138, 127}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{139, 141, 142}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{140, 139, 142}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{140, 142, 130}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{127, 140, 130}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{143, 144, 145}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{146, 143, 145}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{147, 143, 146}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{148, 147, 146}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{149, 150, 144}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{143, 149, 144}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{151, 149, 143}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{147, 151, 143}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{152, 153, 150}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{149, 152, 150}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{154, 152, 149}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{151, 154, 149}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{155, 156, 153}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{152, 155, 153}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{157, 155, 152}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{154, 157, 152}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{158, 159, 156}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{155, 158, 156}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{160, 158, 155}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{157, 160, 155}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{150, 153, 161}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{145, 144, 162}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{163, 145, 162}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{163, 162, 164}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{165, 163, 164}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{144, 150, 166}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{162, 144, 166}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{162, 166, 167}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{164, 162, 167}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{166, 150, 161}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{166, 161, 168}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{167, 166, 168}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{153, 156, 169}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{161, 153, 169}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{161, 169, 170}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{168, 161, 170}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{156, 159, 171}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{169, 156, 171}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{169, 171, 172}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{170, 169, 172}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{173, 174, 175}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{176, 173, 175}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{177, 176, 175}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{178, 177, 175}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{179, 180, 181}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{180, 182, 181}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{182, 183, 181}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{183, 184, 181}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{184, 185, 181}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{186, 178, 175}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{187, 186, 175}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{188, 187, 175}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{189, 188, 175}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{189, 175, 174}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{190, 189, 174}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{191, 192, 193}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{193, 192, 194}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{193, 194, 195}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{194, 196, 195}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{197, 198, 199}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{197, 199, 200}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{199, 201, 200}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{201, 202, 200}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{202, 203, 200}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{203, 204, 200}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{204, 205, 200}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{205, 206, 200}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{206, 207, 200}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{208, 74, 76}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{208, 76, 77}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{208, 209, 74}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{209, 72, 74}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{209, 210, 72}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{210, 70, 72}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{210, 211, 70}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{211, 68, 70}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{211, 212, 68}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{212, 66, 68}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{213, 64, 66}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{213, 66, 212}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{213, 214, 64}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{214, 61, 64}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{215, 63, 59}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{215, 59, 214}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{214, 59, 61}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{57, 56, 216}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{57, 216, 217}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{218, 57, 217}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{216, 56, 219}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{216, 219, 220}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{217, 216, 220}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{220, 219, 221}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{220, 221, 222}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{220, 222, 223}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{221, 224, 225}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{222, 221, 225}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{222, 225, 226}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{223, 222, 226}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{225, 224, 227}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{225, 227, 228}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{226, 225, 228}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{227, 229, 230}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{228, 227, 230}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{229, 231, 232}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{230, 229, 232}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{231, 233, 234}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{232, 231, 234}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{233, 235, 236}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{234, 233, 236}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{235, 237, 238}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{236, 235, 238}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{237, 239, 240}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{238, 237, 240}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{240, 239, 241}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{240, 241, 242}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{241, 243, 242}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{244, 243, 245}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{242, 243, 244}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{244, 245, 246}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{247, 244, 246}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{247, 246, 248}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{249, 247, 248}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{249, 248, 250}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{251, 249, 250}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{252, 253, 254}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{255, 252, 254}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{250, 253, 252}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{251, 250, 252}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{256, 255, 257}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{257, 255, 258}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{255, 254, 258}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{259, 256, 260}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{256, 257, 260}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{260, 257, 261}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{257, 258, 261}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{262, 259, 263}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{259, 260, 263}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{263, 260, 264}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{260, 261, 264}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{10, 9, 265}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{9, 266, 265}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{266, 262, 265}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{265, 262, 267}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{267, 262, 268}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{262, 263, 268}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{268, 263, 269}]}, 
     {RGBColor[0, 0.03137254901960784, 0.12156862745098039`], 
      Polygon3DBox[{263, 264, 269}]}}], GraphicsComplex3DBox[CompressedData["
1:eJx9fQu4VVW1/+TpERDxcARBOKwDh8ND8cEGpRTOEhU0MAXCRx5tmbDhpuXh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    "], {
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1, 2, 3}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{2, 4, 3}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{2, 5, 4}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{5, 6, 4}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{5, 7, 6}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{7, 8, 6}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{7, 9, 8}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{9, 10, 8}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{11, 12, 13}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{14, 15, 12}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{11, 14, 12}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{16, 17, 1}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{17, 2, 1}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{17, 18, 2}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{18, 5, 2}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{18, 19, 5}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{19, 7, 5}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{19, 20, 7}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{20, 9, 7}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{21, 22, 13}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{22, 23, 13}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{23, 11, 13}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{23, 24, 11}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{24, 14, 11}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{25, 26, 16}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{26, 17, 16}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{26, 27, 17}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{27, 18, 17}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{27, 28, 18}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{28, 19, 18}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{28, 29, 19}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{29, 20, 19}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{30, 31, 21}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{31, 22, 21}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{31, 32, 22}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{32, 23, 22}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{32, 33, 23}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{33, 24, 23}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{34, 35, 25}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{35, 26, 25}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{35, 36, 26}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{36, 27, 26}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{36, 37, 27}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{37, 28, 27}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{37, 38, 28}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{38, 29, 28}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{39, 40, 30}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{40, 41, 30}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{41, 31, 30}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{41, 42, 31}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{42, 32, 31}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{43, 33, 42}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{42, 33, 32}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{44, 45, 46}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{47, 44, 46}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{48, 49, 50}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{51, 48, 50}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{52, 53, 54}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{55, 52, 54}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{47, 56, 44}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{57, 56, 47}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{58, 56, 57}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{59, 58, 57}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{60, 58, 59}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{61, 58, 60}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{62, 61, 60}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{49, 61, 62}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{48, 61, 49}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{58, 63, 56}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{64, 63, 58}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{61, 64, 58}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{65, 64, 61}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{48, 65, 61}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{48, 66, 65}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{48, 53, 66}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{64, 67, 63}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{67, 64, 68}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{64, 65, 68}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{65, 69, 68}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{65, 66, 69}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{66, 70, 69}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{66, 53, 70}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{53, 52, 70}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{52, 71, 70}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{55, 72, 73}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{74, 72, 55}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{54, 74, 55}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{51, 74, 54}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{75, 74, 51}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{50, 75, 51}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{50, 76, 75}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{76, 77, 75}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{77, 78, 75}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{77, 79, 78}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{79, 80, 78}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{80, 43, 78}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{43, 42, 78}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{80, 81, 43}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{81, 82, 43}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{82, 46, 43}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{46, 45, 43}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{83, 84, 67}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{68, 83, 67}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{85, 83, 68}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{69, 85, 68}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{86, 85, 69}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{70, 86, 69}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{87, 86, 70}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{71, 87, 70}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{88, 87, 71}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{73, 88, 71}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{89, 88, 73}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{72, 89, 73}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{90, 89, 72}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{91, 90, 72}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{92, 90, 91}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{93, 94, 95}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{96, 93, 95}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{97, 93, 96}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{98, 97, 96}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{99, 97, 98}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{100, 99, 98}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{101, 99, 100}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{102, 101, 100}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{103, 101, 102}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{104, 103, 102}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{72, 74, 91}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{74, 75, 91}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{75, 40, 91}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{75, 78, 40}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{78, 42, 41}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{78, 41, 40}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{91, 40, 39}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{37, 95, 38}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{96, 95, 37}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{36, 96, 37}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{98, 96, 36}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{105, 98, 36}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{35, 105, 36}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{100, 98, 105}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{35, 102, 105}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{102, 100, 105}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{106, 107, 83}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{107, 84, 83}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{106, 83, 85}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{108, 106, 85}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{108, 85, 86}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{109, 108, 86}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{109, 86, 87}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{110, 109, 87}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{110, 87, 88}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{111, 110, 88}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{111, 88, 89}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{112, 111, 89}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{113, 94, 93}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{114, 113, 93}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{114, 93, 97}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{115, 114, 97}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{115, 97, 99}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{116, 115, 99}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{116, 99, 101}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{117, 116, 101}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{117, 101, 103}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{118, 117, 103}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{118, 103, 119}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{120, 118, 119}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{121, 107, 106}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{122, 121, 106}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{122, 106, 108}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{123, 122, 108}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{123, 108, 109}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{124, 123, 109}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{124, 109, 110}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{125, 124, 110}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{125, 110, 111}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{126, 125, 111}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{126, 111, 112}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{127, 126, 112}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{128, 113, 114}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{129, 128, 114}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{129, 114, 115}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{130, 129, 115}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{130, 115, 116}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{131, 130, 116}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{131, 116, 117}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{132, 131, 117}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{132, 117, 118}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{133, 132, 118}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{133, 118, 120}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{134, 133, 120}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{135, 121, 122}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{136, 135, 122}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{136, 122, 123}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{137, 136, 123}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{137, 123, 124}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{138, 137, 124}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{138, 124, 125}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{139, 138, 125}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{139, 125, 126}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{140, 139, 126}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{140, 126, 127}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{141, 140, 127}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{142, 128, 129}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{143, 142, 129}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{143, 129, 130}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{144, 143, 130}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{144, 130, 131}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{145, 144, 131}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{145, 131, 132}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{146, 145, 132}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{146, 132, 133}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{147, 146, 133}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{147, 133, 134}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{148, 147, 134}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{149, 150, 135}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{149, 135, 136}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{151, 149, 136}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{151, 136, 137}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{152, 151, 137}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{152, 137, 138}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{153, 152, 138}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{153, 138, 139}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{154, 153, 139}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{154, 139, 140}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{155, 154, 140}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{155, 140, 141}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{156, 157, 142}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{156, 142, 143}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{158, 156, 159}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{156, 143, 159}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{143, 144, 159}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{160, 159, 144}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{161, 160, 144}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{145, 161, 144}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{146, 162, 145}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{147, 162, 146}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{163, 162, 147}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{164, 147, 148}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{164, 163, 147}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{165, 164, 148}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{165, 166, 164}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{165, 167, 166}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{149, 168, 150}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{169, 168, 149}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{151, 169, 149}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{170, 169, 151}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{152, 170, 151}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{171, 170, 152}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{153, 171, 152}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{172, 171, 153}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{154, 172, 153}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{173, 172, 154}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{155, 173, 154}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{174, 173, 155}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{175, 176, 157}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{156, 175, 157}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{158, 175, 156}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{177, 178, 179}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{178, 176, 179}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{176, 175, 179}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{180, 181, 168}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{169, 180, 168}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{182, 180, 169}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{170, 182, 169}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{183, 182, 170}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{171, 183, 170}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{184, 183, 171}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{172, 184, 171}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{185, 184, 172}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{173, 185, 172}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{186, 185, 173}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{174, 186, 173}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{187, 188, 181}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{180, 187, 181}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{189, 187, 180}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{182, 189, 180}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{190, 189, 182}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{183, 190, 182}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{191, 190, 183}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{184, 191, 183}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{192, 191, 184}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{185, 192, 184}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{193, 192, 185}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{186, 193, 185}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{194, 195, 188}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{187, 194, 188}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{196, 194, 187}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{189, 196, 187}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{197, 196, 189}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{190, 197, 189}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{198, 197, 190}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{191, 198, 190}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{199, 198, 191}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{192, 199, 191}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{200, 199, 192}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{193, 200, 192}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{177, 201, 178}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{201, 202, 178}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{203, 202, 201}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{203, 204, 202}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{204, 205, 202}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{206, 207, 195}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{194, 206, 195}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{208, 206, 194}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{196, 208, 194}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{209, 208, 196}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{197, 209, 196}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{210, 209, 197}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{198, 210, 197}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{211, 210, 198}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{199, 211, 198}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{212, 211, 199}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{200, 212, 199}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{213, 214, 215}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{216, 217, 214}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{213, 216, 214}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{218, 216, 213}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{218, 219, 216}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{219, 220, 216}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{216, 220, 217}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{220, 221, 217}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{221, 222, 217}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{221, 223, 222}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{223, 224, 222}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{224, 225, 226}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{225, 227, 226}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{226, 227, 228}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{227, 229, 228}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{229, 230, 228}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{229, 231, 230}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{229, 232, 231}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{232, 233, 231}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{232, 234, 233}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{233, 234, 235}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{234, 236, 235}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{235, 236, 237}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{236, 238, 237}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{230, 231, 239}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{231, 233, 239}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{233, 240, 239}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{233, 235, 240}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{235, 241, 240}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{235, 237, 241}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{237, 205, 241}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{205, 204, 241}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{242, 243, 238}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{236, 242, 238}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{244, 242, 236}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{234, 244, 236}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{245, 244, 234}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{232, 245, 234}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{246, 245, 232}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{229, 246, 232}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{247, 246, 229}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{227, 247, 229}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{248, 247, 227}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{225, 248, 227}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{224, 248, 225}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{249, 248, 224}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{223, 249, 224}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{250, 249, 223}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{221, 250, 223}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{251, 250, 221}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{220, 251, 221}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{252, 251, 220}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{219, 252, 220}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{253, 243, 242}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{254, 253, 242}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{244, 254, 242}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{255, 254, 244}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{245, 255, 244}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{256, 255, 245}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{246, 256, 245}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{257, 256, 246}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{247, 257, 246}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{258, 257, 247}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{248, 258, 247}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{259, 258, 248}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{249, 259, 248}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{260, 259, 249}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{250, 260, 249}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{261, 260, 250}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{251, 261, 250}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{262, 261, 251}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{252, 262, 251}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{263, 264, 207}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{206, 263, 207}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{265, 263, 206}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{208, 265, 206}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{266, 265, 208}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{209, 266, 208}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{267, 266, 209}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{210, 267, 209}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{268, 267, 210}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{211, 268, 210}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{269, 268, 211}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{212, 269, 211}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{270, 271, 243}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{253, 270, 243}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{272, 270, 253}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{254, 272, 253}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{273, 272, 254}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{255, 273, 254}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{274, 273, 255}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{256, 274, 255}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{275, 274, 256}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{257, 275, 256}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{276, 275, 257}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{258, 276, 257}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{277, 276, 258}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{259, 277, 258}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{278, 277, 259}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{260, 278, 259}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{279, 278, 260}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{261, 279, 260}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{280, 279, 261}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{262, 280, 261}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{263, 281, 264}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{265, 281, 263}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{282, 281, 265}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{283, 282, 265}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{266, 283, 265}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{284, 283, 266}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{267, 284, 266}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{285, 284, 267}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{268, 285, 267}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{269, 285, 268}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{286, 287, 271}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{270, 286, 271}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{272, 286, 270}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{288, 286, 272}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{273, 288, 272}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{274, 288, 273}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{275, 288, 274}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{289, 288, 275}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{276, 289, 275}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{277, 289, 276}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{290, 289, 277}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{278, 290, 277}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{279, 290, 278}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{291, 290, 279}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{280, 291, 279}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{292, 293, 283}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{284, 292, 283}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{294, 292, 284}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{285, 294, 284}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{295, 296, 287}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{286, 295, 287}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{297, 295, 286}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{288, 297, 286}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{289, 298, 288}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{298, 297, 288}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{290, 298, 289}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{299, 298, 290}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{291, 299, 290}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{300, 301, 293}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{292, 300, 293}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{302, 300, 292}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{294, 302, 292}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{303, 304, 296}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{295, 303, 296}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{305, 303, 295}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{297, 305, 295}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{298, 305, 297}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{306, 305, 298}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{299, 306, 298}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{307, 308, 309}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{300, 310, 309}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{310, 307, 309}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{300, 309, 301}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{311, 312, 307}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{311, 307, 310}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{311, 310, 302}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{310, 300, 302}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{303, 313, 304}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{305, 313, 303}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{314, 313, 305}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{306, 314, 305}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{315, 316, 317}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{307, 315, 317}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{308, 307, 317}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{318, 315, 307}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{312, 318, 307}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{314, 319, 313}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{320, 321, 316}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{315, 320, 316}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{322, 320, 315}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{318, 322, 315}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{323, 322, 318}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{320, 324, 321}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{322, 324, 320}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{325, 324, 322}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{323, 325, 322}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{326, 325, 323}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{327, 325, 326}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{328, 327, 326}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{329, 327, 328}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{330, 329, 328}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{331, 332, 333}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{325, 331, 324}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{325, 334, 331}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{327, 334, 325}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{335, 334, 327}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{329, 335, 327}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{331, 336, 332}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{334, 336, 331}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{334, 335, 336}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{324, 333, 321}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{324, 331, 333}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{337, 338, 339}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{340, 337, 339}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{341, 337, 340}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{342, 341, 340}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{343, 341, 342}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{344, 343, 342}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{345, 343, 344}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{346, 345, 344}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{347, 345, 346}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{348, 349, 350}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{351, 348, 350}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{352, 348, 351}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{353, 348, 352}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{352, 354, 353}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{352, 355, 354}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{355, 356, 354}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{355, 357, 356}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{354, 356, 358}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{359, 354, 358}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{359, 358, 360}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{361, 359, 360}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{361, 360, 362}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{363, 361, 362}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{353, 354, 359}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{364, 353, 359}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{364, 359, 361}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{365, 364, 361}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{365, 361, 363}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{366, 365, 363}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{367, 348, 353}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{368, 367, 353}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{369, 367, 368}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{368, 353, 364}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{370, 368, 364}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{365, 370, 364}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{371, 370, 365}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{366, 371, 365}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{372, 371, 366}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{373, 372, 366}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{372, 374, 371}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{375, 374, 372}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{373, 375, 372}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{376, 375, 373}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{377, 375, 376}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{378, 377, 376}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{379, 380, 376}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{373, 379, 376}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{366, 379, 373}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{366, 381, 379}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{381, 382, 379}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{381, 383, 382}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{383, 384, 382}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{383, 385, 384}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{383, 386, 385}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{386, 387, 385}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{386, 388, 387}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{388, 389, 387}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{387, 390, 391}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{387, 389, 390}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{392, 390, 389}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{392, 393, 390}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{394, 395, 392}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{389, 394, 392}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{389, 396, 394}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{388, 396, 389}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{396, 397, 394}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{396, 398, 397}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{398, 399, 397}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{398, 400, 399}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{400, 401, 399}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{402, 366, 363}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{381, 366, 402}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{403, 381, 402}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{403, 383, 381}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{403, 404, 383}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{404, 386, 383}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{404, 405, 386}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{405, 388, 386}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{405, 406, 388}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{406, 396, 388}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{406, 407, 396}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{407, 398, 396}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{407, 408, 398}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{408, 400, 398}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{362, 409, 363}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{409, 402, 363}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{409, 410, 402}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{410, 403, 402}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{410, 411, 403}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{411, 404, 403}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{411, 412, 404}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{412, 405, 404}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{412, 413, 405}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{413, 406, 405}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{413, 414, 406}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{414, 407, 406}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{414, 415, 407}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{415, 408, 407}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{401, 416, 417}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{401, 418, 416}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{400, 418, 401}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{419, 418, 400}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{408, 419, 400}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{420, 419, 408}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{415, 420, 408}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{415, 421, 420}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{415, 422, 421}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{418, 423, 416}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{418, 424, 423}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{419, 424, 418}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{419, 425, 424}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{420, 425, 419}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{420, 426, 425}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{420, 421, 426}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{427, 428, 429}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{430, 427, 429}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{431, 432, 433}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{434, 432, 431}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{435, 436, 437}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{438, 436, 435}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{439, 427, 430}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{432, 439, 430}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{434, 439, 432}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{440, 439, 434}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{436, 440, 434}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{438, 440, 436}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{440, 441, 439}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{442, 441, 440}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{443, 441, 442}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{444, 443, 442}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{444, 445, 443}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{444, 446, 445}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{446, 357, 445}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{446, 356, 357}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{438, 435, 447}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{448, 438, 447}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{440, 438, 448}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{449, 440, 448}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{442, 440, 449}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{450, 442, 449}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{444, 442, 450}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{451, 444, 450}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{446, 444, 451}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{452, 446, 451}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{356, 446, 452}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{358, 356, 452}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{448, 447, 453}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{454, 448, 453}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{449, 448, 454}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{455, 449, 454}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{450, 449, 455}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{456, 450, 455}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{451, 450, 456}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{457, 451, 456}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{452, 451, 457}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{458, 452, 457}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{358, 452, 458}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{360, 358, 458}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{454, 453, 459}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{460, 454, 459}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{461, 460, 459}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{462, 460, 461}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{455, 454, 460}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{463, 455, 460}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{462, 463, 460}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{463, 456, 455}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{464, 456, 463}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{457, 456, 464}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{465, 457, 464}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{458, 457, 465}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{466, 458, 465}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{360, 458, 466}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{362, 360, 466}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{462, 461, 467}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{468, 462, 467}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{469, 462, 468}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{469, 463, 462}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{464, 463, 469}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{465, 464, 469}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{470, 465, 469}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{466, 465, 470}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{362, 466, 470}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{409, 362, 470}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{468, 467, 471}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{472, 468, 471}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{469, 468, 472}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{473, 469, 472}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{470, 469, 473}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{474, 470, 473}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{409, 470, 474}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{410, 409, 474}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{472, 471, 475}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{476, 472, 475}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{473, 472, 476}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{477, 473, 476}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{474, 473, 477}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{410, 474, 477}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{411, 410, 477}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{476, 475, 478}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{479, 476, 478}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{412, 476, 479}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{412, 477, 476}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{412, 411, 477}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{479, 478, 480}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{481, 479, 480}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{482, 479, 481}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{412, 479, 482}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{413, 412, 482}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{483, 482, 481}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{484, 482, 483}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{485, 482, 484}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{413, 482, 485}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{414, 413, 485}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{486, 485, 484}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{487, 485, 486}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{414, 485, 487}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{415, 414, 487}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{422, 487, 486}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{415, 487, 422}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{350, 349, 488}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{489, 350, 488}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{489, 488, 490}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{488, 491, 490}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{488, 492, 491}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{492, 493, 491}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{492, 494, 493}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{492, 495, 494}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{493, 494, 496}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{493, 496, 497}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{496, 498, 497}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{497, 498, 499}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{500, 497, 499}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{500, 499, 501}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{500, 501, 502}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{503, 500, 502}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{504, 500, 503}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{505, 500, 504}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{503, 502, 506}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{506, 502, 507}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{508, 506, 507}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{508, 507, 509}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{508, 509, 510}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{507, 511, 509}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{507, 512, 511}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{507, 513, 512}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{502, 513, 507}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{502, 514, 513}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{513, 515, 512}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{514, 515, 513}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{514, 516, 515}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{514, 517, 516}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{514, 518, 517}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{518, 519, 517}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{501, 514, 502}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{501, 520, 514}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{520, 521, 514}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{521, 518, 514}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{521, 522, 518}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{522, 523, 518}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{523, 519, 518}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{523, 524, 519}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{523, 525, 524}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{523, 526, 525}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{523, 527, 526}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{527, 528, 526}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{529, 528, 527}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{528, 530, 526}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{517, 531, 516}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{519, 531, 517}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{519, 532, 531}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{519, 533, 532}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{533, 534, 532}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{535, 533, 519}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{536, 535, 519}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{524, 536, 519}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{536, 537, 535}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{535, 538, 533}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{535, 539, 538}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{537, 539, 535}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{537, 540, 539}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{540, 541, 539}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{542, 541, 540}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{541, 543, 539}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{541, 544, 543}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{541, 377, 544}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{377, 378, 544}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{544, 378, 545}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{544, 545, 546}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{546, 545, 547}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{548, 546, 547}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{548, 547, 549}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{550, 548, 549}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{550, 549, 551}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{552, 550, 551}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{533, 538, 534}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{428, 553, 429}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{553, 554, 429}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{433, 555, 431}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{555, 556, 431}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{553, 557, 554}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{557, 555, 554}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{557, 558, 555}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{555, 558, 556}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{556, 558, 559}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{557, 510, 558}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{510, 509, 558}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{437, 559, 435}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{559, 560, 435}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{559, 558, 560}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{558, 561, 560}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{558, 509, 561}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{509, 511, 561}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{435, 560, 447}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{560, 562, 447}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{562, 563, 447}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{563, 564, 447}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{564, 453, 447}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{564, 565, 453}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{565, 566, 453}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{566, 459, 453}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{566, 567, 459}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{566, 568, 567}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{568, 569, 567}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{568, 532, 569}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{532, 534, 569}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{459, 570, 461}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{570, 571, 461}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{570, 572, 571}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{572, 573, 571}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{572, 552, 573}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{552, 551, 573}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{573, 551, 574}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{571, 573, 574}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{571, 574, 461}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{574, 467, 461}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{574, 575, 467}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{467, 575, 471}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{575, 576, 471}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{576, 577, 471}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{471, 577, 475}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{577, 578, 475}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{578, 579, 475}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{579, 478, 475}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{580, 581, 582}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{545, 580, 582}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{545, 582, 583}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{545, 583, 584}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{583, 585, 584}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{547, 545, 584}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{549, 547, 584}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{551, 549, 584}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{586, 584, 585}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{586, 551, 584}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{585, 587, 586}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{587, 588, 586}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{588, 587, 589}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{590, 588, 589}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{591, 590, 589}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{592, 590, 591}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{593, 592, 591}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{589, 587, 594}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{589, 594, 595}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{591, 589, 595}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{595, 596, 591}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{596, 597, 591}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{597, 598, 591}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{598, 599, 591}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{599, 593, 591}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{598, 600, 599}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{593, 601, 592}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{601, 602, 592}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{601, 603, 602}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{603, 604, 602}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{603, 605, 604}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{604, 606, 602}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{604, 607, 606}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{604, 608, 607}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{604, 609, 608}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{605, 609, 604}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{610, 609, 605}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{609, 611, 608}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{609, 612, 611}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{612, 613, 611}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{393, 392, 612}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{392, 613, 612}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{602, 606, 614}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{579, 602, 614}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{478, 579, 614}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{392, 395, 615}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{613, 392, 615}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{613, 615, 616}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{616, 615, 617}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{618, 616, 617}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{619, 618, 617}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{620, 619, 617}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{621, 620, 617}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{615, 622, 617}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{617, 622, 623}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{617, 623, 624}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{617, 624, 621}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{623, 625, 624}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{622, 626, 623}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{623, 626, 625}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{626, 627, 625}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{625, 627, 628}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{626, 629, 627}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{627, 630, 631}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{627, 629, 630}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{630, 632, 631}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{630, 633, 632}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{630, 629, 633}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{629, 634, 633}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{629, 417, 634}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{417, 416, 634}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{634, 416, 423}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{634, 423, 633}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{633, 423, 424}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{633, 424, 425}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{633, 425, 632}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{632, 426, 421}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{632, 425, 426}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{631, 421, 635}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{627, 631, 628}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{628, 631, 635}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{635, 421, 422}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{481, 620, 636}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{619, 620, 481}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{481, 636, 483}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{636, 637, 483}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{637, 638, 483}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{483, 638, 484}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{638, 639, 484}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{484, 639, 486}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{639, 635, 486}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{631, 632, 421}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{635, 422, 486}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{481, 480, 619}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{640, 641, 642}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{641, 643, 642}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{641, 644, 643}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{644, 645, 643}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{644, 646, 645}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{646, 647, 645}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{646, 648, 647}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{648, 649, 647}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{648, 650, 649}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{650, 651, 649}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{650, 652, 651}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{652, 653, 651}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{652, 654, 653}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{654, 655, 653}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{654, 656, 655}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{656, 657, 655}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{656, 658, 657}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{658, 659, 657}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{658, 660, 659}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{660, 661, 659}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{660, 662, 661}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{662, 663, 661}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{662, 664, 663}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{664, 665, 663}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{664, 666, 665}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{666, 667, 665}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{666, 668, 667}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{668, 669, 667}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{668, 670, 669}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{670, 671, 669}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{672, 671, 670}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{640, 672, 670}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{642, 643, 673}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{643, 674, 673}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{643, 645, 674}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{645, 675, 674}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{645, 647, 675}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{647, 676, 675}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{647, 649, 676}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{649, 677, 676}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{649, 651, 677}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{651, 678, 677}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{651, 653, 678}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{653, 679, 678}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{653, 655, 679}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{655, 680, 679}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{655, 657, 680}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{657, 681, 680}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{657, 659, 681}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{659, 682, 681}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{659, 661, 682}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{661, 683, 682}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{661, 663, 683}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{663, 684, 683}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{663, 665, 684}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{665, 685, 684}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{665, 667, 685}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{667, 686, 685}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{667, 669, 686}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{669, 687, 686}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{669, 671, 687}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{671, 688, 687}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{671, 672, 688}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{672, 689, 688}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{690, 691, 692}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{691, 693, 692}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{691, 694, 693}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{694, 695, 693}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{694, 696, 695}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{696, 697, 695}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{696, 698, 697}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{698, 699, 697}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{698, 700, 699}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{700, 701, 699}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{700, 702, 701}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{702, 703, 701}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{702, 704, 703}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{704, 705, 703}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{704, 706, 705}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{706, 707, 705}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{706, 708, 707}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{708, 709, 707}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{708, 710, 709}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{710, 711, 709}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{710, 712, 711}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{712, 713, 711}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{712, 714, 713}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{714, 715, 713}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{714, 716, 715}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{716, 717, 715}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{716, 718, 717}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{718, 719, 717}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{718, 720, 719}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{720, 721, 719}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{720, 690, 721}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{690, 692, 721}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{722, 723, 690}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{723, 691, 690}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{723, 724, 691}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{724, 694, 691}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{724, 725, 694}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{725, 696, 694}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{725, 726, 696}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{726, 698, 696}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{726, 727, 698}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{727, 700, 698}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{727, 728, 700}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{728, 702, 700}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{728, 729, 702}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{729, 704, 702}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{729, 730, 704}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{730, 706, 704}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{730, 731, 706}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{731, 708, 706}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{731, 732, 708}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{732, 710, 708}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{732, 733, 710}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{733, 712, 710}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{733, 734, 712}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{734, 714, 712}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{734, 735, 714}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{735, 716, 714}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{735, 736, 716}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{736, 718, 716}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{736, 737, 718}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{737, 720, 718}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{737, 722, 720}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{722, 690, 720}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{738, 739, 740}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{738, 741, 739}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{741, 742, 739}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{741, 743, 742}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{741, 744, 743}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{744, 745, 743}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{744, 746, 745}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{744, 747, 746}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{747, 748, 746}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{747, 749, 748}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{747, 750, 749}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{750, 751, 749}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{750, 752, 751}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{750, 753, 752}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{753, 754, 752}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{753, 755, 754}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{753, 756, 755}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{756, 757, 755}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{756, 758, 757}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{756, 759, 758}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{759, 760, 758}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{759, 761, 760}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{759, 738, 761}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{738, 740, 761}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{741, 738, 762}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{744, 741, 762}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{747, 744, 762}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{750, 747, 762}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{753, 750, 762}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{756, 753, 762}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{759, 756, 762}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{738, 759, 762}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{763, 764, 765}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{764, 766, 765}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{764, 767, 766}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{767, 768, 766}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{767, 769, 768}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{769, 770, 768}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{769, 771, 770}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{771, 772, 770}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{771, 773, 772}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{773, 774, 772}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{773, 775, 774}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{775, 776, 774}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{775, 777, 776}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{777, 778, 776}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{777, 779, 778}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{779, 780, 778}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{779, 781, 780}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{781, 782, 780}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{781, 783, 782}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{783, 784, 782}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{783, 785, 784}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{785, 786, 784}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{785, 787, 786}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{787, 788, 786}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{787, 789, 788}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{789, 790, 788}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{789, 791, 790}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{791, 792, 790}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{791, 793, 792}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{793, 794, 792}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{795, 794, 793}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{763, 795, 793}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{765, 766, 796}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{766, 797, 796}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{766, 768, 797}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{768, 798, 797}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{768, 770, 798}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{770, 799, 798}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{770, 772, 799}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{772, 800, 799}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{772, 774, 800}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{774, 801, 800}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{774, 776, 801}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{776, 802, 801}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{776, 778, 802}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{778, 803, 802}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{778, 780, 803}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{780, 804, 803}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{780, 782, 804}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{782, 805, 804}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{782, 784, 805}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{784, 806, 805}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{784, 786, 806}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{786, 807, 806}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{786, 788, 807}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{788, 808, 807}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{788, 790, 808}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{790, 809, 808}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{790, 792, 809}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{792, 810, 809}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{792, 794, 810}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{794, 811, 810}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{794, 795, 811}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{795, 812, 811}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{813, 814, 815}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{814, 816, 815}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{814, 817, 816}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{817, 818, 816}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{817, 819, 818}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{819, 820, 818}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{819, 821, 820}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{821, 822, 820}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{821, 823, 822}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{823, 824, 822}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{823, 825, 824}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{825, 826, 824}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{825, 827, 826}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{827, 828, 826}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{827, 829, 828}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{829, 830, 828}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{829, 831, 830}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{831, 832, 830}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{831, 833, 832}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{833, 834, 832}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{833, 835, 834}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{835, 836, 834}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{835, 837, 836}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{837, 838, 836}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{837, 839, 838}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{839, 840, 838}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{839, 841, 840}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{841, 842, 840}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{841, 843, 842}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{843, 844, 842}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{843, 813, 844}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{813, 815, 844}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{845, 846, 813}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{846, 814, 813}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{846, 847, 814}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{847, 817, 814}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{847, 848, 817}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{848, 819, 817}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{848, 849, 819}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{849, 821, 819}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{849, 850, 821}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{850, 823, 821}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{850, 851, 823}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{851, 825, 823}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{851, 852, 825}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{852, 827, 825}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{852, 853, 827}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{853, 829, 827}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{853, 854, 829}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{854, 831, 829}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{854, 855, 831}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{855, 833, 831}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{855, 856, 833}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{856, 835, 833}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{856, 857, 835}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{857, 837, 835}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{857, 858, 837}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{858, 839, 837}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{858, 859, 839}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{859, 841, 839}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{859, 860, 841}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{860, 843, 841}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{860, 845, 843}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{845, 813, 843}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{861, 862, 863}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{861, 864, 862}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{864, 865, 862}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{864, 866, 865}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{864, 867, 866}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{867, 868, 866}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{867, 869, 868}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{867, 870, 869}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{870, 871, 869}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{870, 872, 871}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{870, 873, 872}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{873, 874, 872}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{873, 875, 874}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{873, 876, 875}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{876, 877, 875}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{876, 878, 877}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{876, 879, 878}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{879, 880, 878}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{879, 881, 880}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{879, 882, 881}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{882, 883, 881}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{882, 884, 883}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{882, 861, 884}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{861, 863, 884}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{864, 861, 885}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{867, 864, 885}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{870, 867, 885}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{873, 870, 885}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{876, 873, 885}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{879, 876, 885}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{882, 879, 885}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{861, 882, 885}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{493, 497, 500}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{491, 493, 500}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{491, 500, 505}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{490, 491, 505}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{886, 490, 505}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{887, 886, 505}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{504, 887, 505}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{886, 887, 888}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{887, 889, 888}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{889, 890, 888}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{888, 890, 891}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{891, 890, 892}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{893, 894, 895}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{890, 893, 895}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{896, 893, 890}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{889, 896, 890}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{896, 897, 893}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{897, 898, 893}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{899, 900, 898}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{897, 899, 898}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{901, 899, 897}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{902, 901, 897}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{899, 903, 900}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{904, 901, 902}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{905, 906, 907}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{908, 909, 910}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{905, 907, 911}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{909, 905, 911}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{909, 911, 912}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{910, 909, 912}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{912, 911, 913}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{911, 914, 913}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{914, 915, 916}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{913, 914, 916}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{913, 916, 917}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{918, 913, 917}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{916, 919, 920}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{916, 921, 919}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{916, 915, 921}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{915, 922, 921}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{922, 923, 921}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{922, 924, 925}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{923, 922, 925}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{926, 923, 925}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{927, 926, 925}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{928, 927, 925}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{929, 927, 928}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{930, 929, 928}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{931, 932, 933}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{934, 931, 933}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{935, 934, 933}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{936, 935, 933}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{937, 936, 933}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{938, 937, 933}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{939, 938, 933}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{932, 939, 933}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{940, 932, 941}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{932, 931, 941}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{941, 931, 942}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{942, 931, 943}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{931, 934, 943}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{943, 934, 944}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{944, 934, 945}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{934, 935, 945}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{945, 935, 946}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{946, 935, 947}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{935, 936, 947}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{947, 936, 948}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{948, 936, 949}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{936, 937, 949}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{949, 937, 950}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{950, 937, 951}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{937, 938, 951}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{951, 938, 952}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{952, 938, 953}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{938, 939, 953}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{953, 939, 954}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{954, 939, 955}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{939, 932, 955}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{955, 932, 940}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{956, 957, 958}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{957, 959, 958}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{958, 959, 960}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{959, 961, 960}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{960, 961, 962}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{961, 963, 962}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{962, 963, 964}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{963, 965, 964}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{964, 965, 966}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{965, 967, 966}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{966, 967, 968}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{967, 969, 968}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{968, 969, 970}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{969, 971, 970}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{970, 971, 972}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{971, 973, 972}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{972, 973, 974}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{973, 975, 974}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{974, 975, 976}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{975, 977, 976}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{976, 977, 978}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{977, 979, 978}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{978, 979, 980}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{979, 981, 980}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{980, 981, 982}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{981, 983, 982}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{982, 983, 984}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{983, 985, 984}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{984, 985, 986}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{985, 987, 986}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{986, 987, 956}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{987, 957, 956}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{988, 956, 989}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{956, 958, 989}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{989, 958, 990}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{958, 960, 990}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{990, 960, 991}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{960, 962, 991}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{991, 962, 992}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{962, 964, 992}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{992, 964, 993}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{964, 966, 993}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{993, 966, 994}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{966, 968, 994}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{994, 968, 995}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{968, 970, 995}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{995, 970, 996}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{970, 972, 996}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{996, 972, 997}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{972, 974, 997}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{997, 974, 998}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{974, 976, 998}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{998, 976, 999}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{976, 978, 999}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{999, 978, 1000}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{978, 980, 1000}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1000, 980, 1001}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{980, 982, 1001}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1001, 982, 1002}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{982, 984, 1002}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1002, 984, 1003}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{984, 986, 1003}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1003, 986, 988}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{986, 956, 988}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1004, 1005, 1006}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1005, 1007, 1006}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1006, 1007, 1008}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1007, 1009, 1008}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1008, 1009, 1010}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1009, 1011, 1010}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1010, 1011, 1012}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1011, 1013, 1012}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1012, 1013, 1014}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1013, 1015, 1014}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1014, 1015, 1016}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1015, 1017, 1016}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1016, 1017, 1018}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1017, 1019, 1018}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1018, 1019, 1020}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1019, 1021, 1020}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1020, 1021, 1022}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1021, 1023, 1022}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1022, 1023, 1024}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1023, 1025, 1024}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1024, 1025, 1026}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1025, 1027, 1026}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1026, 1027, 1028}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1027, 1029, 1028}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1028, 1029, 1030}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1029, 1031, 1030}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1030, 1031, 1032}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1031, 1033, 1032}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1032, 1033, 1034}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1033, 1035, 1034}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1034, 1035, 1036}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1035, 1037, 1036}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1005, 1038, 1039}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1007, 1005, 1039}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1007, 1039, 1009}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1039, 1040, 1009}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1009, 1040, 1011}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1040, 1041, 1011}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1011, 1041, 1013}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1041, 1042, 1013}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1013, 1042, 1015}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1042, 1043, 1015}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1015, 1043, 1017}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1043, 1044, 1017}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1017, 1044, 1019}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1044, 1045, 1019}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1019, 1045, 1021}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1045, 1046, 1021}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1021, 1046, 1023}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1046, 1047, 1023}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1023, 1047, 1025}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1047, 1048, 1025}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1025, 1048, 1027}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1048, 1049, 1027}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1027, 1049, 1029}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1049, 1050, 1029}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1029, 1050, 1031}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1050, 1051, 1031}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1031, 1051, 1033}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1051, 1052, 1033}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1033, 1052, 1035}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1052, 1053, 1035}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1035, 1053, 1037}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1053, 1038, 1037}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1054, 1055, 1056}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1057, 1054, 1056}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1058, 1057, 1056}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1059, 1058, 1056}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1060, 1059, 1056}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1061, 1060, 1056}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1062, 1061, 1056}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1055, 1062, 1056}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1063, 1055, 1064}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1055, 1054, 1064}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1064, 1054, 1065}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1065, 1054, 1066}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1054, 1057, 1066}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1066, 1057, 1067}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1067, 1057, 1068}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1057, 1058, 1068}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1068, 1058, 1069}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1069, 1058, 1070}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1058, 1059, 1070}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1070, 1059, 1071}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1071, 1059, 1072}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1059, 1060, 1072}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1072, 1060, 1073}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1073, 1060, 1074}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1060, 1061, 1074}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1074, 1061, 1075}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1075, 1061, 1076}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1061, 1062, 1076}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1076, 1062, 1077}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1077, 1062, 1078}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1062, 1055, 1078}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1078, 1055, 1063}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1079, 1080, 1081}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1080, 1082, 1081}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1081, 1082, 1083}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1082, 1084, 1083}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1083, 1084, 1085}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1084, 1086, 1085}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1085, 1086, 1087}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1086, 1088, 1087}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1087, 1088, 1089}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1088, 1090, 1089}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1089, 1090, 1091}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1090, 1092, 1091}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1091, 1092, 1093}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1092, 1094, 1093}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1093, 1094, 1095}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1094, 1096, 1095}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1095, 1096, 1097}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1096, 1098, 1097}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1097, 1098, 1099}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1098, 1100, 1099}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1099, 1100, 1101}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1100, 1102, 1101}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1101, 1102, 1103}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1102, 1104, 1103}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1103, 1104, 1105}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1104, 1106, 1105}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1105, 1106, 1107}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1106, 1108, 1107}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1107, 1108, 1109}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1108, 1110, 1109}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1109, 1110, 1079}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1110, 1080, 1079}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1111, 1079, 1112}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1079, 1081, 1112}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1112, 1081, 1113}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1081, 1083, 1113}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1113, 1083, 1114}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1083, 1085, 1114}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1114, 1085, 1115}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1085, 1087, 1115}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1115, 1087, 1116}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1087, 1089, 1116}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1116, 1089, 1117}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1089, 1091, 1117}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1117, 1091, 1118}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1091, 1093, 1118}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1118, 1093, 1119}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1093, 1095, 1119}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1119, 1095, 1120}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1095, 1097, 1120}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1120, 1097, 1121}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1097, 1099, 1121}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1121, 1099, 1122}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1099, 1101, 1122}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1122, 1101, 1123}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1101, 1103, 1123}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1123, 1103, 1124}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1103, 1105, 1124}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1124, 1105, 1125}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1105, 1107, 1125}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1125, 1107, 1126}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1107, 1109, 1126}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1126, 1109, 1111}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1109, 1079, 1111}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1127, 1128, 1129}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1128, 1130, 1129}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1129, 1130, 1131}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1130, 1132, 1131}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1131, 1132, 1133}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1132, 1134, 1133}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1133, 1134, 1135}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1134, 1136, 1135}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1135, 1136, 1137}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1136, 1138, 1137}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1137, 1138, 1139}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1138, 1140, 1139}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1139, 1140, 1141}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1140, 1142, 1141}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1141, 1142, 1143}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1142, 1144, 1143}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1143, 1144, 1145}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1144, 1146, 1145}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1145, 1146, 1147}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1146, 1148, 1147}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1147, 1148, 1149}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1148, 1150, 1149}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1149, 1150, 1151}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1150, 1152, 1151}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1151, 1152, 1153}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1152, 1154, 1153}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1153, 1154, 1155}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1154, 1156, 1155}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1155, 1156, 1157}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1156, 1158, 1157}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1157, 1158, 1159}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1158, 1160, 1159}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1128, 1161, 1162}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1130, 1128, 1162}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1130, 1162, 1132}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1162, 1163, 1132}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1132, 1163, 1134}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1163, 1164, 1134}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1134, 1164, 1136}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1164, 1165, 1136}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1136, 1165, 1138}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1165, 1166, 1138}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1138, 1166, 1140}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1166, 1167, 1140}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1140, 1167, 1142}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1167, 1168, 1142}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1142, 1168, 1144}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1168, 1169, 1144}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1144, 1169, 1146}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1169, 1170, 1146}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1146, 1170, 1148}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1170, 1171, 1148}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1148, 1171, 1150}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1171, 1172, 1150}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1150, 1172, 1152}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1172, 1173, 1152}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1152, 1173, 1154}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1173, 1174, 1154}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1154, 1174, 1156}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1174, 1175, 1156}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1156, 1175, 1158}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1175, 1176, 1158}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1158, 1176, 1160}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1176, 1161, 1160}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1177, 1178, 1179}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1180, 1181, 1182}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1183, 1184, 1185}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1181, 1186, 1182}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1186, 1187, 1182}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1186, 1188, 1187}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1188, 1189, 1187}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1188, 1190, 1189}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1190, 1191, 1189}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1191, 1178, 1189}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1192, 1179, 1178}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1192, 1178, 1191}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1185, 1181, 1180}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1184, 1193, 1181}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1184, 1194, 1193}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1185, 1184, 1181}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1195, 1183, 1196}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1196, 1183, 1185}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1195, 1197, 1183}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1198, 1197, 1195}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1199, 1197, 1198}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1199, 1200, 1197}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1201, 1200, 1199}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1201, 1202, 1200}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1202, 1203, 1200}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1200, 1203, 1197}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1203, 1204, 1197}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1197, 1204, 1183}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1183, 1204, 1184}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1203, 1194, 1204}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1204, 1194, 1184}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1203, 1205, 1194}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1194, 1206, 1193}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1194, 1205, 1206}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1205, 1207, 1206}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1205, 1208, 1207}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1206, 1207, 1209}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1209, 1210, 1211}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1207, 1210, 1209}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1208, 1210, 1207}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1208, 1212, 1210}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1192, 1211, 1210}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1179, 1192, 1210}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1213, 1179, 1210}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1214, 1213, 1210}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1212, 1214, 1210}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1212, 1215, 1214}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1216, 1215, 1212}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1217, 1216, 1212}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1218, 1219, 1220}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1221, 1218, 1220}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1222, 1221, 1220}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1215, 1216, 1223}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1216, 1224, 1223}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1215, 1223, 1225}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1223, 1226, 1225}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1225, 1226, 1227}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1226, 1228, 1229}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1226, 1229, 1230}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1226, 1230, 1227}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1227, 1230, 1231}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1231, 1230, 1222}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1222, 1230, 1221}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1229, 1232, 1230}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1230, 1232, 1221}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1232, 1233, 1221}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1221, 1233, 1234}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1233, 1235, 1234}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1236, 1237, 1238}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1235, 1238, 1239}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1238, 1237, 1239}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1237, 1240, 1239}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1240, 1241, 1239}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1241, 1242, 1239}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1243, 1239, 1242}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1244, 1243, 1242}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1245, 1243, 1244}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1234, 1235, 1239}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1246, 1234, 1239}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1246, 1239, 1243}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1247, 1246, 1243}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1245, 1247, 1243}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1247, 1245, 1248}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1245, 1249, 1248}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1250, 1248, 1251}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1251, 1248, 1249}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1252, 1250, 1251}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1253, 1252, 1251}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1254, 1253, 1251}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1249, 1255, 1251}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1255, 1254, 1251}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1256, 1254, 1255}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1257, 1254, 1256}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1258, 1257, 1256}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1219, 1218, 1259}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1218, 1260, 1259}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1260, 1261, 1259}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1261, 1262, 1259}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1261, 1263, 1262}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1263, 1264, 1262}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1264, 1265, 1262}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1264, 1266, 1265}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1265, 1266, 1267}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1266, 1268, 1267}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1269, 1268, 1266}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1250, 1269, 1266}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1250, 1270, 1269}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1270, 1271, 1269}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1269, 1271, 1268}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1271, 1272, 1268}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1268, 1272, 1267}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1272, 1273, 1267}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1274, 1275, 1276}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1275, 1277, 1276}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1276, 1277, 1278}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1277, 1279, 1278}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1278, 1279, 1273}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1273, 1279, 1280}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1279, 1281, 1280}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1281, 1282, 1280}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1280, 1282, 1283}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1282, 1284, 1283}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1284, 1285, 1283}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1285, 1286, 1283}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1286, 1287, 1283}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1288, 1289, 1290}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1289, 1291, 1290}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1290, 1291, 1286}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1291, 1292, 1286}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1286, 1292, 1287}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1292, 1293, 1287}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1289, 1294, 1291}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1294, 1295, 1291}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1291, 1296, 1292}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1291, 1297, 1296}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1291, 1295, 1297}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1297, 1295, 1298}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1295, 1299, 1298}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1296, 1297, 1300}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1297, 1301, 1300}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1298, 1299, 1302}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1299, 1303, 1302}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1304, 1305, 1274}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1306, 1270, 1250}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1252, 1306, 1250}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1307, 1306, 1252}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1253, 1307, 1252}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1308, 1307, 1253}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1254, 1308, 1253}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1254, 1309, 1308}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1310, 1309, 1254}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1310, 1311, 1309}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1311, 1312, 1309}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1309, 1312, 1313}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1313, 1312, 1314}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1312, 1315, 1316}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1312, 1316, 1314}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1316, 1317, 1314}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1314, 1317, 1318}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1314, 1318, 1304}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1304, 1318, 1305}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1317, 1319, 1318}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1319, 1320, 1321}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1318, 1319, 1321}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1305, 1318, 1321}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1274, 1305, 1275}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1305, 1321, 1275}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1275, 1321, 1322}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1322, 1321, 1323}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1322, 1323, 1324}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1325, 1326, 1327}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1326, 1328, 1329}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1326, 1329, 1327}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1329, 1330, 1327}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1327, 1330, 1331}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1331, 1330, 1320}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1320, 1330, 1321}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1321, 1330, 1332}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1330, 1333, 1332}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1333, 1334, 1332}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1332, 1334, 1335}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1334, 1336, 1335}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1336, 1337, 1335}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1335, 1337, 1338}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1321, 1332, 1323}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1332, 1335, 1323}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1323, 1335, 1324}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1324, 1335, 1339}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1339, 1335, 1340}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1339, 1340, 1341}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1335, 1338, 1340}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1340, 1338, 1342}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1340, 1342, 1341}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1341, 1342, 1288}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1288, 1342, 1289}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1289, 1343, 1294}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1342, 1343, 1289}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1344, 1343, 1342}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1338, 1344, 1342}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1338, 1345, 1344}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{928, 925, 924}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{928, 924, 1345}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{928, 1345, 1338}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1337, 928, 1338}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1346, 928, 1337}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{930, 928, 1346}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1347, 930, 1346}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1347, 1348, 930}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1348, 929, 930}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1349, 929, 1348}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1350, 1351, 1349}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1349, 1351, 929}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{929, 1351, 927}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1351, 1352, 927}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{927, 1352, 926}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1352, 1353, 926}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1354, 1353, 1352}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1355, 1354, 1352}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1356, 1357, 1180}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1356, 1180, 1182}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1358, 1357, 1356}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1359, 1358, 1356}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1359, 1356, 1182}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1359, 1182, 1187}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1360, 1358, 1359}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1361, 1360, 1359}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1361, 1359, 1187}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1361, 1187, 1189}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1361, 1189, 1178}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1362, 1360, 1361}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1363, 1362, 1361}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1363, 1361, 1178}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1363, 1178, 1177}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1219, 1363, 1177}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1364, 1362, 1365}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1365, 1362, 1366}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1366, 1362, 1363}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1366, 1363, 1219}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1259, 1366, 1219}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1367, 1364, 1365}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1368, 1367, 1365}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1369, 1368, 1365}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1369, 1365, 1366}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1370, 1369, 1366}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1370, 1366, 1259}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1262, 1370, 1259}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1371, 1367, 1368}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1372, 1371, 1368}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1372, 1368, 1369}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1373, 1372, 1369}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1373, 1369, 1370}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1374, 1373, 1370}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1374, 1370, 1262}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1265, 1374, 1262}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1375, 1371, 1372}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1376, 1375, 1372}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1377, 1376, 1372}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1377, 1372, 1373}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1378, 1377, 1373}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1379, 1378, 1373}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1379, 1373, 1380}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1380, 1373, 1374}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1380, 1374, 1265}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1267, 1380, 1265}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1381, 1375, 1376}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1382, 1381, 1376}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1382, 1376, 1377}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1383, 1382, 1377}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1383, 1377, 1378}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1384, 1383, 1378}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1384, 1378, 1379}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1384, 1379, 1385}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1379, 1380, 1386}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1385, 1379, 1386}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1387, 1385, 1386}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1386, 1380, 1267}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1386, 1267, 1273}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1387, 1386, 1273}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1280, 1387, 1273}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1388, 1381, 1382}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1389, 1388, 1382}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1389, 1382, 1383}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1390, 1389, 1383}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1390, 1383, 1384}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1391, 1390, 1384}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1391, 1384, 1385}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1392, 1391, 1385}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1392, 1385, 1387}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1393, 1392, 1387}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1393, 1387, 1280}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1283, 1393, 1280}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1394, 1388, 1389}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1395, 1394, 1389}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1395, 1389, 1390}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1396, 1395, 1390}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1396, 1390, 1391}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1397, 1396, 1391}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1397, 1391, 1392}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1398, 1397, 1392}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1398, 1392, 1393}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1399, 1398, 1393}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1399, 1393, 1283}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1287, 1399, 1283}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1394, 1395, 1400}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1400, 1395, 1401}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1395, 1396, 1401}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1401, 1396, 1402}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1402, 1396, 1397}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1403, 1402, 1397}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1403, 1397, 1398}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1403, 1398, 1404}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1398, 1399, 1405}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1398, 1405, 1406}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1404, 1398, 1406}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1404, 1406, 1407}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1404, 1407, 1408}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1409, 1404, 1408}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1405, 1399, 1287}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1405, 1287, 1293}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1407, 1406, 1300}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1407, 1300, 1301}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1409, 1408, 1302}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1303, 1409, 1302}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1185, 1410, 1196}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1196, 1410, 1195}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1195, 1410, 1411}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1195, 1411, 1198}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1198, 1411, 1412}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1198, 1412, 1199}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1199, 1412, 1201}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1180, 1357, 1185}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1185, 1357, 1410}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1410, 1357, 1413}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1411, 1410, 1413}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1411, 1413, 1414}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1412, 1411, 1414}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1412, 1414, 1415}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1412, 1415, 1201}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1201, 1415, 1202}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1413, 1357, 1416}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1357, 1358, 1416}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1416, 1358, 1417}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1358, 1360, 1417}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1417, 1360, 1418}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1360, 1362, 1418}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1418, 1362, 1419}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1362, 1364, 1419}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1419, 1364, 1420}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1364, 1367, 1420}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1420, 1367, 1421}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1367, 1371, 1421}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1421, 1371, 1422}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1371, 1375, 1422}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1414, 1413, 1423}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1413, 1416, 1423}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1423, 1416, 1424}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1416, 1417, 1424}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1424, 1417, 1425}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1417, 1418, 1425}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1425, 1418, 1426}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1418, 1419, 1426}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1426, 1419, 1427}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1419, 1420, 1427}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1427, 1420, 1428}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1428, 1420, 1421}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1429, 1428, 1421}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1429, 1421, 1422}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1415, 1414, 1430}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1414, 1423, 1430}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1430, 1423, 1431}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1423, 1424, 1431}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1431, 1424, 1432}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1424, 1425, 1433}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1424, 1433, 1432}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1432, 1433, 1216}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1217, 1432, 1216}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1224, 1216, 1434}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1434, 1216, 1433}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1433, 1435, 1434}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1434, 1435, 1436}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1433, 1425, 1435}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1425, 1426, 1435}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1435, 1426, 1437}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1426, 1427, 1437}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1437, 1427, 1438}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1438, 1427, 1439}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1427, 1428, 1439}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1439, 1428, 1440}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1428, 1429, 1440}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1440, 1429, 1441}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1440, 1441, 1442}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1443, 1440, 1442}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1311, 1310, 1442}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1444, 1311, 1442}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1444, 1442, 1441}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1444, 1441, 1445}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1446, 1444, 1445}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1446, 1445, 1447}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1445, 1441, 1429}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1447, 1445, 1429}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1447, 1429, 1448}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1449, 1447, 1448}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1449, 1448, 1450}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1451, 1449, 1450}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1452, 1451, 1450}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1453, 1454, 1451}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1453, 1451, 1452}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1455, 1453, 1452}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1448, 1429, 1422}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1456, 1448, 1422}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1450, 1448, 1456}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1457, 1450, 1456}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1452, 1450, 1457}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1458, 1452, 1457}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1456, 1422, 1375}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1381, 1456, 1375}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1457, 1456, 1381}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1388, 1457, 1381}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1458, 1457, 1388}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1394, 1458, 1388}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1400, 1459, 1394}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1394, 1459, 1458}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1459, 1460, 1458}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1458, 1460, 1452}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1455, 1452, 1460}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1455, 1460, 1461}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1455, 1461, 1354}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1355, 1455, 1354}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1462, 1463, 1464}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1462, 1464, 1465}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1466, 1462, 1465}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1466, 1465, 1467}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1468, 1466, 1467}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1468, 1467, 1469}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1470, 1468, 1469}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1470, 1469, 1471}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1472, 1470, 1471}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1473, 1474, 333}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{333, 1474, 321}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{335, 1475, 336}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{336, 1475, 1473}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{336, 1473, 332}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{335, 329, 1476}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1475, 335, 1476}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1475, 1476, 1477}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1475, 1477, 1473}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1473, 1477, 1474}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{332, 1473, 333}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{329, 330, 1478}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1476, 329, 1478}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1476, 1478, 1479}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1477, 1476, 1479}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1477, 1479, 1480}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1477, 1480, 1481}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1474, 1477, 1481}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1474, 1481, 1482}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1474, 1482, 321}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1481, 1480, 1483}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1481, 1483, 1484}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1482, 1481, 1484}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1482, 1484, 1485}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{321, 1482, 1485}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{319, 314, 1486}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1483, 1487, 1488}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1484, 1483, 1488}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1488, 1489, 1490}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1484, 1488, 1490}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1485, 1484, 1490}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{314, 306, 1491}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1486, 314, 1491}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1486, 1491, 1492}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1486, 1492, 1493}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1494, 1495, 1496}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1495, 1497, 1496}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1488, 1497, 1495}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1487, 1497, 1488}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1498, 1494, 1499}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1488, 1495, 1498}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1495, 1494, 1498}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1489, 1488, 1498}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{306, 299, 1500}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1491, 306, 1500}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1491, 1500, 1501}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1491, 1501, 1502}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1492, 1491, 1502}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1492, 1502, 1503}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1493, 1492, 1503}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1496, 1504, 1505}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1494, 1496, 1505}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1494, 1505, 1506}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1499, 1494, 1506}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{299, 291, 1507}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1500, 299, 1507}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1500, 1507, 1508}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1501, 1500, 1509}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1500, 1508, 1509}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1501, 1509, 1510}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1502, 1501, 1510}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1502, 1510, 1511}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1503, 1502, 1511}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1504, 1512, 1513}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1505, 1504, 1513}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1505, 1513, 1514}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1506, 1505, 1514}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{291, 280, 1515}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1507, 291, 1515}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1507, 1515, 1516}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1507, 1516, 1517}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1508, 1507, 1517}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1508, 1517, 1518}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1508, 1518, 1519}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1509, 1508, 1519}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1509, 1519, 1520}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1509, 1520, 1521}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1509, 1521, 1522}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1510, 1509, 1522}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1510, 1522, 1523}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1510, 1523, 1524}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1511, 1510, 1524}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1512, 1525, 1526}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1512, 1526, 1527}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1513, 1512, 1527}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1513, 1527, 1528}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1514, 1513, 1528}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1514, 1528, 1529}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1530, 1514, 1529}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1531, 1530, 1529}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1531, 1529, 1532}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1531, 1532, 264}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{280, 262, 1533}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1515, 280, 1533}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1515, 1533, 1534}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1516, 1515, 1534}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1516, 1534, 1535}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1517, 1516, 1535}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1517, 1535, 1536}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1518, 1517, 1536}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1518, 1536, 1537}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1519, 1518, 1537}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1519, 1537, 1538}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1520, 1519, 1538}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1520, 1538, 1539}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1521, 1520, 1539}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1521, 1539, 1540}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1522, 1521, 1540}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1522, 1540, 1541}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1523, 1522, 1541}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1523, 1541, 1542}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1524, 1523, 1542}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1525, 1543, 1544}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1526, 1525, 1544}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1526, 1544, 1545}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1527, 1526, 1545}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1527, 1545, 1546}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1528, 1527, 1546}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1528, 1546, 1547}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1529, 1528, 1547}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1529, 1547, 1548}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1532, 1529, 1548}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1532, 1548, 207}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{264, 1532, 207}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{262, 252, 1549}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1533, 262, 1549}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1533, 1549, 1550}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1534, 1533, 1550}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1534, 1550, 1551}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1535, 1534, 1551}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1535, 1551, 1552}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1536, 1535, 1552}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1536, 1552, 1553}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1537, 1536, 1553}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1537, 1553, 1554}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1538, 1537, 1554}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1538, 1554, 1555}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1539, 1538, 1555}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1539, 1555, 1556}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1540, 1539, 1556}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1540, 1556, 1557}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1541, 1540, 1557}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1542, 1541, 1557}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{252, 219, 1558}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1549, 252, 1558}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1549, 1558, 1559}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1550, 1549, 1559}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1550, 1559, 1560}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1551, 1550, 1560}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1551, 1560, 1561}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1552, 1551, 1561}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1552, 1561, 1562}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1552, 1562, 1563}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1553, 1552, 1563}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1553, 1563, 1564}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1554, 1553, 1564}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1554, 1564, 1565}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1555, 1554, 1565}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1555, 1565, 1566}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1556, 1555, 1566}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1556, 1566, 1567}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1557, 1556, 1567}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1557, 1567, 1568}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1542, 1557, 1568}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1569, 1570, 1571}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1570, 1572, 1571}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1572, 1573, 1571}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1571, 1573, 1574}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1573, 1575, 1574}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1574, 1575, 1576}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1575, 1577, 1576}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1577, 1578, 1576}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1568, 1567, 1572}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1567, 1573, 1572}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1567, 1566, 1573}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1566, 1575, 1573}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1566, 1565, 1575}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1575, 1565, 1577}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1565, 1564, 1577}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1577, 1564, 1578}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1578, 1564, 1579}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1564, 1563, 1579}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1563, 1580, 1579}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1563, 1562, 1580}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1562, 1561, 1580}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1561, 1560, 1581}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1560, 1559, 1581}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1581, 1559, 1582}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1559, 1558, 1582}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1558, 1583, 1582}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1558, 219, 1583}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{219, 218, 1583}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1583, 218, 213}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1583, 213, 1584}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1582, 1583, 1584}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1584, 213, 215}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1543, 1585, 1586}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1544, 1543, 1586}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1544, 1586, 1587}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1545, 1544, 1587}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1545, 1587, 1588}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1546, 1545, 1588}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1546, 1588, 1589}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1547, 1546, 1589}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1547, 1589, 1590}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1548, 1547, 1590}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1548, 1590, 195}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{207, 1548, 195}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1570, 1569, 1591}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1569, 1592, 1591}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1591, 1592, 1593}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1591, 1593, 1594}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1593, 1595, 1594}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1585, 1596, 1597}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1586, 1585, 1597}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1586, 1597, 1598}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1587, 1586, 1598}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1587, 1598, 1599}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1588, 1587, 1599}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1588, 1599, 1600}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1589, 1588, 1600}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1589, 1600, 1601}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1590, 1589, 1601}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1590, 1601, 188}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{195, 1590, 188}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1596, 1602, 1603}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1597, 1596, 1603}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1597, 1603, 1604}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1598, 1597, 1604}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1598, 1604, 1605}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1599, 1598, 1605}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1599, 1605, 1606}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1600, 1599, 1606}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1600, 1606, 1607}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1601, 1600, 1607}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1601, 1607, 181}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{188, 1601, 181}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1602, 1608, 1609}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1603, 1602, 1609}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1603, 1609, 1610}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1604, 1603, 1610}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1604, 1610, 1611}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1605, 1604, 1611}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1605, 1611, 1612}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1606, 1605, 1612}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1606, 1612, 1613}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1607, 1606, 1613}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1607, 1613, 168}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{181, 1607, 168}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1614, 1615, 1616}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1615, 1594, 1616}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1594, 1595, 1616}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1614, 1617, 1618}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1614, 1618, 1619}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1615, 1614, 1619}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1609, 1608, 1620}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1609, 1620, 1621}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1610, 1609, 1621}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1610, 1621, 1622}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1611, 1610, 1622}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1611, 1622, 1623}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1612, 1611, 1623}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1612, 1623, 1624}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1613, 1612, 1624}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1613, 1624, 1625}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{168, 1613, 1625}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{168, 1625, 150}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{167, 165, 1626}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1626, 165, 1627}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1627, 165, 148}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1628, 1627, 1629}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1629, 1627, 148}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1630, 1628, 1629}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1630, 1629, 1631}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1630, 1631, 1632}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1633, 1632, 1634}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1635, 1633, 1634}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1636, 1635, 1634}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1634, 1637, 1636}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1637, 1618, 1636}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1618, 1617, 1636}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1638, 1618, 1637}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1619, 1618, 1638}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1639, 1620, 1640}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1621, 1620, 1639}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1641, 1621, 1639}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1622, 1621, 1641}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1642, 1622, 1641}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1623, 1622, 1642}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1643, 1623, 1642}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1624, 1623, 1643}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1644, 1624, 1643}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1625, 1624, 1644}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{135, 1625, 1644}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{150, 1625, 135}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1629, 148, 134}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1645, 1629, 134}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1631, 1629, 1645}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1646, 1631, 1645}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1632, 1631, 1646}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1647, 1632, 1646}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1634, 1632, 1647}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1648, 1634, 1647}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1637, 1634, 1648}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1649, 1637, 1648}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1638, 1637, 1649}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1650, 1638, 1649}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1639, 1640, 1651}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1652, 1639, 1651}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1641, 1639, 1652}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1653, 1641, 1652}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1642, 1641, 1653}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1654, 1642, 1653}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1643, 1642, 1654}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1655, 1643, 1654}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1644, 1643, 1655}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1656, 1644, 1655}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{135, 1644, 1656}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{121, 135, 1656}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1645, 134, 120}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1657, 1645, 120}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1646, 1645, 1657}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1658, 1646, 1657}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1647, 1646, 1658}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1659, 1647, 1658}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1648, 1647, 1659}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1660, 1648, 1659}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1649, 1648, 1660}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1661, 1649, 1660}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1650, 1649, 1661}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1662, 1650, 1661}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1652, 1651, 1663}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1664, 1652, 1663}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1653, 1652, 1664}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1665, 1653, 1664}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1654, 1653, 1665}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1666, 1654, 1665}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1655, 1654, 1666}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1667, 1655, 1666}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1656, 1655, 1667}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1668, 1656, 1667}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{121, 1656, 1668}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{107, 121, 1668}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1657, 120, 119}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1669, 1657, 119}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1658, 1657, 1669}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1670, 1658, 1669}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1659, 1658, 1670}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1671, 1659, 1670}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1660, 1659, 1671}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1672, 1660, 1671}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1661, 1660, 1672}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1673, 1661, 1672}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1662, 1661, 1673}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1674, 1662, 1673}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1664, 1663, 1675}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1676, 1664, 1675}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1665, 1664, 1676}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1677, 1665, 1676}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1666, 1665, 1677}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1678, 1666, 1677}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1667, 1666, 1678}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1679, 1667, 1678}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1668, 1667, 1679}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1680, 1668, 1679}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{84, 107, 1680}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{107, 1668, 1680}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1681, 1682, 1683}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1682, 1684, 1683}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1685, 1681, 1683}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1683, 1684, 1686}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1685, 1683, 1686}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1687, 1685, 1686}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1687, 1686, 1688}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1689, 1687, 1688}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1689, 1688, 1690}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1691, 1692, 1693}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1694, 1695, 1691}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1696, 1695, 1694}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1695, 1697, 1691}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1691, 1697, 1692}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1697, 1698, 1692}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1698, 1699, 1692}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1669, 1700, 1682}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1670, 1669, 1682}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1670, 1682, 1681}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1671, 1670, 1681}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1671, 1681, 1685}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1672, 1671, 1685}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1672, 1685, 1687}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1673, 1672, 1687}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1673, 1687, 1689}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1674, 1673, 1689}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1701, 1702, 1692}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1701, 1692, 1699}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1675, 1701, 1699}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1675, 1699, 1703}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1676, 1675, 1703}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1676, 1703, 1704}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1677, 1676, 1704}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1677, 1704, 1705}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1678, 1677, 1705}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1678, 1705, 1706}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1679, 1678, 1706}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1679, 1706, 1707}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1680, 1679, 1707}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1680, 1707, 67}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{84, 1680, 67}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{45, 1708, 43}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1708, 1709, 43}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1709, 1710, 43}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1710, 1711, 43}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1696, 43, 1695}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{43, 1711, 1695}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1711, 1712, 1695}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1712, 1713, 1695}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1695, 1713, 1697}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1713, 1714, 1697}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1714, 1715, 1697}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1697, 1715, 1716}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1698, 1697, 1716}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1698, 1716, 1717}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1698, 1717, 1718}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1699, 1698, 1718}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1699, 1718, 1703}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1704, 1719, 1705}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1719, 1720, 1705}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1720, 1721, 1705}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1705, 1721, 1706}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1721, 1722, 1706}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1706, 1722, 1707}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1722, 1723, 1707}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1723, 67, 1707}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{67, 1723, 63}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1720, 1724, 1721}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1721, 1724, 1722}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1722, 1724, 1725}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1723, 1722, 1725}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1723, 1725, 1726}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{63, 1723, 1726}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{63, 1726, 56}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1725, 1724, 1727}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1725, 1727, 1728}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1725, 1728, 1729}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1726, 1725, 1729}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1726, 1729, 1730}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1726, 1730, 1731}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{56, 1726, 1731}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{56, 1731, 1732}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{56, 1732, 44}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1719, 1718, 1717}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1720, 1719, 1717}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1724, 1716, 1715}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1727, 1724, 1715}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{44, 1732, 1708}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{45, 44, 1708}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{33, 1696, 1733}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{33, 43, 1696}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1733, 1696, 1734}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1696, 1694, 1734}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1734, 1694, 1735}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1694, 1691, 1735}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1691, 1693, 1735}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1736, 1690, 1737}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1690, 1688, 1737}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1737, 1688, 1738}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1688, 1686, 1738}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1738, 1686, 1739}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1686, 1684, 1739}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1739, 1684, 25}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1684, 34, 25}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{24, 33, 1740}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{33, 1733, 1740}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1740, 1733, 1741}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1733, 1734, 1741}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1741, 1734, 1742}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1734, 1735, 1742}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1743, 1736, 1744}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1736, 1737, 1744}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1744, 1737, 1745}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1737, 1738, 1745}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1745, 1738, 1746}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1738, 1739, 1746}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1746, 1739, 16}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1739, 25, 16}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{14, 24, 1747}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{24, 1740, 1747}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1747, 1740, 1748}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1740, 1741, 1748}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1741, 1742, 1748}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1749, 1743, 1750}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1743, 1744, 1750}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1750, 1744, 1751}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1744, 1745, 1751}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1751, 1745, 1752}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1745, 1746, 1752}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1752, 1746, 1}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1746, 16, 1}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{14, 1747, 1753}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{15, 14, 1753}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1753, 1747, 1748}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1754, 1749, 1755}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1749, 1750, 1755}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1755, 1750, 1756}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1750, 1751, 1756}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1756, 1751, 1757}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1751, 1752, 1757}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1757, 1752, 3}]}, 
     {RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
      Polygon3DBox[{1752, 1, 3}]}}], GraphicsComplex3DBox[CompressedData["
1:eJxtlD9LAzEYxqMuUvQDuIgOnUQUzuJprRes6Gxd1Z6CXcVBXIODgy6uNwgH
+gEEP4CHc8FBpCgiV4T6bzno0q0mbxL6JpdA6d2Ph+d9knvzTh8c1Q6HCSE+
/40QYyWTL/WE/9NCq0gRj09Hw0Q+zggeNhqdB3hle6BXnK9McNr+3RWcRZH2
6QnOHk92BJ9Seva3lUmfK9CHlQvQU8/rAj//AX3a78+56vI1j3Oy42KI+UBP
6oovGPt62g4x1/o4mgB//l7CnHpdyEm9e+CsUviS/onOY+h13aQ5ZnEGPI6i
ktrvp9LrPIs4Zzp7prmveKpyGpz7vQqe3viaL2Mfenmn+QroN9tvsi5VnJXd
XOqTZvMdeKus+Sr2j78/NKd4XygnxTn5k+Zr2IdsjO9bHPabPFcNPe9T5T+k
81OsTyvXwHnuKvYPa0vgHzY6Bqe3ZV13XfsEDh+RP3DnB30uJz+HwHEOIn/g
yC/OGfytcxbfRdalue9ocvUdVU5HP6RWHh/nJFYfir6V3OzbATfvl811/4v7
Inn+vqg8uXun6hr3XcwH4I75EJD8PbV96GBe9QS35xJfGfhYc0zMK+mD5tU/
3RkkAQ==
    "], {
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{1, 2, 3}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{4, 1, 3}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{4, 3, 5}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{6, 4, 5}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{5, 3, 7}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{3, 8, 7}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{3, 2, 8}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{2, 9, 8}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{8, 9, 10}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{9, 11, 10}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{8, 10, 12}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{8, 12, 13}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{7, 8, 13}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{14, 12, 10}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{15, 14, 10}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{16, 15, 10}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{11, 16, 10}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{11, 17, 16}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{11, 18, 17}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{18, 19, 17}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{18, 20, 19}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{18, 21, 20}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{21, 22, 20}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{23, 22, 21}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{21, 24, 23}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{21, 25, 24}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{25, 26, 24}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{25, 27, 26}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{25, 28, 27}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{29, 26, 27}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{30, 26, 29}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{29, 27, 31}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{27, 32, 31}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{27, 28, 32}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{31, 32, 33}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{32, 34, 33}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{28, 35, 32}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{32, 35, 34}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{35, 36, 34}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{37, 38, 36}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{37, 36, 35}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{28, 25, 35}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{35, 25, 37}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{37, 25, 39}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{25, 21, 39}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{39, 21, 40}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{41, 40, 21}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{41, 21, 42}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{21, 18, 42}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{42, 18, 43}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{43, 18, 44}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{18, 11, 44}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{44, 11, 45}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{45, 11, 46}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{47, 45, 46}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{48, 47, 46}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{49, 48, 46}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{50, 51, 52}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{49, 50, 52}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{46, 50, 49}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{11, 9, 46}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{9, 50, 46}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{9, 2, 50}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{2, 53, 50}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{50, 53, 51}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{53, 54, 51}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{55, 56, 54}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{53, 55, 54}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{1, 55, 53}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{2, 1, 53}]}}], GraphicsComplex3DBox[CompressedData["
1:eJx1XGuMVdUV3lgfdNRikbc6nOExzIwjYC8qigOH10yb0pYZWhUY4GD10tQ2
ldhWi004f4itIcH0mTukyYlaYvogJtTERyuntOqfC1oxpZrWXmpLopCWxkJp
VG7PXo9711pne39wmW+++c531l57n3P3Wet23fm1kbsvcM49V/zzEUevNMqL
f6Pjb3w69j/eVb3av+edu67xeHzvT9bCz19EPNp1MpJ49kHz4/49rlRmSZ3G
B80rQa/3z11KZ3HHRfBev2yO5Mc3I168gN/Y8ash/3NKfuLKgVkSj86jflar
zZF41tYBn9lAxwo4ntFhPCGd/EzPXIlHt6BOUq0CP9/x2hLwQ/y441inxDPS
L15zFZ90ivhAPJOO2xdAfIjP+ozHpM86jEdLtJ+sWp0Kx2E/pJ9tQzy52/gh
PLpV66SHblgMv29qnZzwqKp1mO8GtE5xRqvh+EaH8djoMN4wOtH+S9aCjnOT
pA7judFp4Ut1/hRO18H7ONQp8uQqiSfbUCe7d2C2wpdxftb/c9Af/3jfF8DP
6IQ5pPO2xPNKZS4dl16okzo3R+LMjz65dS6d13sHQe91wN0zncw/J/FGW78h
8WTmrm6pz3h06g/dFM/zB/E3t5GO0hf4PPLzlsTdthO9+rwQz47N7iM8ygWe
j9UmEj5D4hznZM+KLokXE4jH/Wr4+86n7gD/49yUGM6nNl3i6bbWuF8j8YR0
0kn74bixy9fD708NTyH96RLPSMfyU9LJpl1IuNsA7+PcDIzPgSmIxxtBZ1EF
15PjO4CfVo6CjjtSnxbCU85Do59S3Kx+tLfG6+qVhI+C/nLyufLSSQp/a8dE
itvloHv8nU0QH+Indy2ZIHH3bOdkiMPJ4QsgXvX+BI57Afos4TdUrqJ4nj0o
8PhCN558Qj6zn8bE17pJ5zTij8Bx06UPcz5DHjZ6RpHv3LVSn3XibdW5dF7/
A36zuUHyi3n6PvIdxC2d9bEe8tM8KOKZbh9Q867QwTwp6+C4fOWjrfzHOOfM
B5300BnAOQ/dpcfM/HKAZ6TPxxV4D/EhPvmPfn07jJdzC4n/LvCv+MsdEmc+
+y/jyzaGdJJTL0M8U8J5HWt0f3cT4Yso/ieA/+2MdRZLfva7pRsIV/zo+JQN
ks94Vl/D+gbfDXh8uH6jOu7zfwW88fSbN9B54br3gxe24Di4FXBeHcdgvcru
PgV4o1aLJd9dclMi+azfaH4O+MmFty3X+MHNyE+XU9zeQnzn5pBOVKlsxuOu
V/zsnR9vknz2U+gDnlVPxOq4124fJb7COW4WbzQnAF5cd5ZqvMnje6uK58Wr
eBxvDfPTJSH9Ylxulv6jlU9zHFbp82oqvB235pYQP378+4nEi7x6Hc53aCvx
49VGn/CUcXjl9d2gkw/8TOHpwJ1bQ3j8+JKtxg8ehPSL/Fmt8Z2Au8O7V6v4
XH5+s4xbNnT8DZzXcRKMZ2XyFsQx/mW+Ga+v/31zSCcZe2+z5Du6/ubVF3H9
3FadKfH48w8if/FJwO36nxyp4/2PuY7EhLNOWjmA6+eReqc+bnUD6cwgvB/j
Vcc8H6t1STx/+7MQh+zLS2dJvLg+wnHzBycpfrHewnGL9T8i/CbQH1uP85eu
C4xncwchno2zTyi8GD/Mz0UVhefVP+I8OlyHdbtY/5eCTm095tVYrUfi0f6X
8Tr4p8cU7q2QH42P1bag/hq6Hh1YDuf70xHIw+h7b/Yq/Vd7t6L/HsUvGORn
ep/E48p9eL6H1yg8r49iXm2rqvs0zodkDO9PnMmfYtynSpzHPR/nDB/HvbGo
wnw1vu72hZ0S53yI99aukTiPu8g3Ne7J3tpVhKvxTS+ePVvinA/Ffb7Gadwb
j5+eJXEed+YHxrdb4pwP8aY9Cnc07kVeaZzG3Y1LAbfjmCyq9Eqcx7G471U4
j2Mx7oRXVgBv10Zc37YP9Ek8rhxNQrhz3wnifFzG8zPjCV9H86jH5Ns6zjfl
M926GP1TPhevPuAtb8L1O9l52ZW5xL91G1zvGw98dQrhMO7J9nuA3/hbr8Kj
cxMRn3doIuELAU9+WAEfrz46mfD5oLO/G+5L8qfunyjx7Esp4PFnTkxWOvfc
Ajr5yuuYr/w3artnBP0s/hTj+rj/vohx0M/uIv1HDk1HPIbPvdHQqYPPO/gc
D5+Lstozq+D335yfezxxbpbku2bzEvA/VoN5mFT3rVL49gHaN5mEeMcR0Mkq
B+DzbTT6r5WKf7ZnNukAnjz30m/huL2j3f7nuON+wBvnkZ86141+UsDjaf84
RP57/c95fY3i54SzfjR1/O/xvNJ+qZ8Tv7jf6Jf+8+73gR+NTV8g/WfMP/vE
Ahm3xrN7X/D8RrW6UMaH+cn+lxaSf9yPuPw14OeVAwpnflqpXI86g4Mh/WJd
GAzppwPvDIb9TxgK+18/FIpPcX8zFIpPcYShUPyL+TgUij/r2/FlfTu+7L+c
P+i/nD8YH5u3HB+bn8WRg/nPuM3zIq8AT5vNqXRemP97Hl0lcbe0owv9nFgp
8eK80P+uexSe7zpJ+1Ax5n9bv1fy2/iJfqnPeDEuC6QfxrOn39T5xn4or1zv
6GCIn9WmD4X0i/tkhbOf4n8G53FHvj1f1rfxYT82nkVeBeNfjC/in6jMlOPF
8y6t1RCncef528Ipf3gdYDylPOT1JCGcz4v5jPO8YP0WTvOL/TBeWgf4uDQu
nLeWz/lv9XkeWT88H61/5tvzZX0bH/Zj41mcVzD+4ry6yA/xcZ7GAw93kR/c
T3/sNOB5zyjilcoc1ElwnalNZ51u0ke8Xo8I75X8rLmT8X6pn/1yKKLzXSD9
ZBsnAF58/lLjUuQznFfxeZnmBa7zlt947IpVIX3/ySbkp3X9KvlHPseHz5f1
bXzYD8cnb+2DZ8Pgv3LgZvi7en0avo8qPG7vkzJ+Y476sE9f3G9p/PgO0EkH
OrR+tUr74/9dq/gnh69GnaNrJT/qHcX5uOs5xY9a++Y57r8Tv/j8OQff9zF+
o8RZn/mRS+dJfeY36vV50j/zG7XpfdJ/i3/miT4Ztxa/Xr9WxqflZ3QPr4eK
X/i0OPu/DnVmj4T083r/SEg/7/yG5rf8P6T4bf+/UHyOT1J9UfMpPsVfKD7H
Oau9rv0Qzvp2fFnfji/7L+fPQ4rfzp/Zih9T3nJ8bH4WZxLMf4GrPOf8L86r
QnGA+/9saFjhyYOTpqGfd9cq3DnwmR56SuEpPacsEI1T3JiftPAT86Q+48Xn
1z7pp4Vv/43Kq7YO5lU6af5IiF+s/yMh/SJOI1rnBOVDg8dd+We+PV/WL8WH
/Nh48rjY+PO4FPcZcF1smHUpOlxHnMad528Lp/zhdYDxmPKQ1xPG+byYX/i4
nuIzT+q38LM4v9gP46lZB1o4jQvnreVz/lt9nkfWD89H65/59nxZ38aH/dh4
8rjY+PN55XRddGP4nIznaWPSPxeST5injeEHUH/mReh/W7UTdZ4cQZ1uPi9e
/8nPGsbnSH5SuU/FgfXj0T18vn3ST7zr5xifSsXOF9aheYHrvOU3hscPh/Sd
e2VtyA9fv8r+kS/i0yX1bXzYj4hP63odu/C4EG7GZR3gdny9fhzQ93mu+JQn
3mcc8Onni+THrev4K4Db8/XzTvI5b33c4kDcWN/mP+vb+LN/O4/YfzlPMD52
PnJ8Qvmj+DSvGS/nVf9ISN/nZ0jfz9Ow/wdGQv79fA/H58mRUHz8uvEh8R8J
xZ/1y+OL+nb+sv9y/qD/cp73az7lJ8fHrideCY9r8x9xex3x1x2J83XHX6cU
Ttcpf12TePs63tC4uA5inPV1k/XtdZb9hK7jWgfzyl/3Q3x/nxDUL+4rQn78
fUjIP/Pt+bK+jQ/7KV/Hs2D8eVzsfRePu71/4/yx94Gch/Z+kvPZ3pcy397f
sn75Prlf64jruNGn+/Z1wyE+rz9Wn9cx64fXQ+uf+fZ8Wb98n7xOx7l1Hc+C
8Rfjou6Ted6V7reL+3bFp/t2f/8vcb7/5/XEfo5gvv08wvr2cw37sZ+PxLio
z1m8blu+/9wX1j+6VuLsh69H1j/z7fmyfjk+owqPxefuUPz9vpbHQ/sq8HNp
X2UfPE+2+zN+fwD5en/A71MpPu3z+H0G4Jl9Br/fJflpax8+A9zuV/h9Mzgv
s+/k9z2AZ/Y9WN/uX7G+3T9h/3YfjP2X93kwPnY/jeMT2v+hOKt9OcbL+0Lr
B0P6fn8ppO/32cL+Tw+G/Pv9unB8kqFQfPy+34fEfygUf9Yvjy/q2/039l/O
H/Rf3qfC+JT3DzE+dj/Q7ysC3+S/3wcG3OwD+31jifO+sd9nlnhK+8x+X1rp
tPbhc4xbYB9b47jvzfp2n5z9hPbhgWf24f2+fYjv9/lD+v65QMiPf44Q8s98
e76sb+PDfmw8/XOQYPxdjnUr5rkJj7t9/sL5Y5/jcB7a50Gcz/a5EvPt8ynW
DzznGpS43IeXePu5G64bls/rj9Xndcz64fXQ+me+PV/WDzwnXRWKp+N6JRN/
Hhf7nIvnnX1e5p+7AW6eu/nnd3D+5vldaz0xzwGZb58nsr59Lsl+7PPN1nwx
z0l53bZ8/9w2rL9vZchP63pk/DPfni/rl+ODfkLPzUPxd1z/WHou7+bDcQPP
8UEnUG8AOuW6gn7gl+sEoJ4iVFcAxy3XPyC/XC+hfbbrHNBnoJ5BHlfUY2if
VF/h6zrgfAL1Hv7d1nv4uhHFF3Uj8PtAHQu+6/qT9nFtPQzyy3UsyHeluhrW
t/Uw5N/UXzHf1tX4eh7UL9f5AG7qfBgP1QuBfqC+CHBT91W8boL3QP0S/J2p
X2rxA3VQ4KdcNwXjHqq/gniU66/60U+5jgv8lOu+8P4pUD+G/kv1Y4SX69DA
j6lbK8ZxCvrUdfK+rh5xXVfv6xuJr+rkfT0k+DT18DZvuY7OjjvX9dk84TpA
m89cp2fzhOsMbT5zvV8gf1Se2DpGZ/JH1j2i/3L9JPgp10+qfBB1mCp/ZN0m
Hrdc/wk+y/WfKh9EHanKH1l3ivxyvSv4NPWuNh9i0ceBuO7jsHnC88LmCdfN
+n6BZUJf9AucW4bvpfp/j9u+A1/f63Fb39vCA/XApFOq99a45ofqwIEfqE9G
/7o+uYwbP6Yu2kPkR9Vv+3rvZaBXrveGeJr6cF9PrnXa9eSEl+rSPR6qVwf/
pi+A8VJ/Qeu4uv6fcVvn34qz6ZtgPNQfATqB/gg8rq7Db+GBfgHJl30BUp/5
7biV+xHAp+lraOvr/og2rvspfF8GHNf0Zfj+EeAH+k3QZ7kfBOJp+kFYx/ah
FK/THg/10cC4B/po5Hws4+U+GvBj+mgczXfbx+T7lUhf9Stx/jjTZ8frgyv3
B52TfO7X8/19Bof13/cl+fdAXxLgselj8n1SuI7pPimxvqm+Kt+fRXzVn8X+
40D/F+K6/4t1bB+Z71+DvzP9a74fLRb8SPSpKZz61HzfXCz8cN+c7/uTceC+
P9+vB783/XqWz32Fls99f77fUPIz0bcoxyUR/Y8Sj0T/o8RT0UeJerqP0tF1
0AX6MSUu+14R132vxatL4k70zyp++7xw/Sz3pZ6TOPexcp7Yvlee17av1vfh
Spz7cB3lr+3/9X3EEs9EH7Hiiz5ifC/3I0tc9jVLPDY6of5oiedGJ9RnDXig
XxviFOj7BjzQ9w1/F+gfl3hsdGx/esuP6WdnnVBfvMQz0XcPPwf67iXOffeO
8tn27/t+f/Bn+v1Z334/gKN8tt8n4L9/AHjm+wf89xhIvPU9Bi6NJM7fk+C/
3wD+zny/gf+eBInz9yT471VQfP+9Cv8HamPg6g==
    "], {
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{1, 2, 3}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{4, 1, 3}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{4, 3, 5}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{6, 4, 5}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{7, 1, 4}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{8, 7, 4}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{8, 4, 6}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{9, 8, 6}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{10, 7, 8}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{11, 10, 8}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{11, 8, 9}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{12, 11, 9}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{13, 14, 10}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{13, 10, 11}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{15, 13, 11}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{15, 11, 12}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{13, 16, 14}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{17, 16, 13}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{15, 17, 13}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{18, 17, 15}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{19, 20, 16}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{17, 19, 16}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{21, 19, 17}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{18, 21, 17}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{22, 23, 20}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{19, 22, 20}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{24, 22, 19}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{21, 24, 19}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{25, 26, 23}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{22, 25, 23}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{27, 25, 22}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{24, 27, 22}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{28, 29, 26}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{25, 28, 26}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{30, 28, 25}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{27, 30, 25}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{31, 32, 29}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{28, 31, 29}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{33, 31, 28}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{30, 33, 28}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{34, 35, 36}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{35, 37, 36}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{34, 38, 35}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{38, 39, 35}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{39, 40, 35}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{40, 37, 35}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{40, 41, 37}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{38, 42, 39}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{42, 43, 39}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{39, 43, 40}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{43, 44, 40}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{40, 44, 41}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{44, 45, 41}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{46, 47, 32}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{31, 46, 32}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{48, 46, 31}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{33, 48, 31}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{49, 50, 47}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{46, 49, 47}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{51, 49, 46}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{48, 51, 46}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{52, 53, 50}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{49, 52, 50}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{54, 52, 49}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{51, 54, 49}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{55, 56, 53}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{57, 55, 53}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{52, 57, 53}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{54, 58, 52}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{54, 59, 58}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{54, 60, 59}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{54, 61, 60}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{61, 62, 60}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{63, 64, 62}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{61, 63, 62}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{65, 66, 64}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{67, 65, 64}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{63, 67, 64}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{68, 69, 70}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{71, 69, 68}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{68, 70, 72}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{73, 68, 72}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{71, 68, 73}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{74, 71, 73}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{72, 75, 73}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{76, 73, 75}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{74, 73, 76}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{77, 74, 76}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{78, 77, 76}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{79, 78, 76}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{80, 78, 79}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{42, 78, 80}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{43, 42, 80}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{44, 43, 80}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{79, 44, 80}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{81, 44, 79}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{79, 82, 81}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{79, 75, 82}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{75, 83, 82}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{75, 72, 83}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{72, 84, 83}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{72, 70, 84}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{70, 85, 84}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{85, 86, 87}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{84, 85, 87}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{88, 84, 87}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{83, 84, 88}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{82, 83, 88}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{81, 82, 88}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{89, 81, 88}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{87, 89, 88}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{86, 90, 87}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{86, 91, 90}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{91, 86, 92}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{93, 94, 95}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{96, 94, 93}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{97, 96, 93}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{98, 97, 93}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{99, 97, 98}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{100, 99, 98}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{100, 101, 99}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{102, 101, 100}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{102, 103, 101}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{102, 104, 103}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{105, 104, 102}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{106, 105, 102}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{87, 107, 106}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{87, 108, 107}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{87, 90, 108}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{89, 87, 106}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{100, 98, 109}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{98, 110, 109}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{98, 93, 110}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{93, 111, 110}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{111, 93, 112}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{93, 95, 112}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{109, 110, 113}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{110, 111, 113}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{111, 114, 113}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{111, 115, 114}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{112, 116, 115}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{111, 112, 115}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{112, 117, 116}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{114, 115, 118}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{119, 114, 118}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{113, 114, 119}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{120, 121, 122}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{123, 122, 121}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{106, 107, 105}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{107, 124, 105}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{124, 125, 105}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{79, 76, 75}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{126, 127, 128}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{129, 126, 128}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{130, 126, 129}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{56, 130, 129}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{131, 130, 56}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{55, 131, 56}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{132, 133, 127}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{126, 132, 127}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{134, 132, 126}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{130, 134, 126}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{135, 134, 130}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{131, 135, 130}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{136, 137, 133}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{132, 136, 133}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{138, 136, 132}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{134, 138, 132}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{139, 138, 134}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{135, 139, 134}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{140, 141, 137}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{136, 140, 137}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{142, 140, 136}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{138, 142, 136}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{143, 142, 138}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{139, 143, 138}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{141, 144, 145}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{146, 144, 141}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{140, 146, 141}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{147, 146, 140}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{142, 147, 140}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{148, 147, 142}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{143, 148, 142}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{64, 149, 150}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{62, 64, 150}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{62, 150, 151}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{60, 62, 151}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{60, 151, 152}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{59, 60, 152}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{149, 153, 154}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{150, 149, 154}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{150, 154, 155}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{151, 150, 155}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{151, 155, 156}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{152, 151, 156}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{153, 157, 158}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{154, 153, 158}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{154, 158, 159}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{155, 154, 159}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{155, 159, 160}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{156, 155, 160}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{157, 161, 162}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{158, 157, 162}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{158, 162, 163}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{159, 158, 163}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{159, 163, 164}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{160, 159, 164}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{161, 145, 144}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{161, 144, 165}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{162, 161, 165}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{162, 165, 166}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{163, 162, 166}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{163, 166, 167}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{164, 163, 167}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{144, 168, 169}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{165, 144, 169}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{165, 169, 170}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{166, 165, 170}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{166, 170, 171}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{167, 166, 171}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{167, 171, 172}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{173, 167, 172}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{174, 173, 172}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{175, 176, 177}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{178, 175, 177}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{179, 180, 181}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{182, 180, 179}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{176, 183, 177}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{183, 184, 177}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{181, 185, 179}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{185, 186, 179}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{187, 188, 189}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{188, 190, 189}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{188, 191, 190}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{191, 192, 190}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{191, 193, 192}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{193, 194, 192}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{193, 195, 194}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{195, 196, 194}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{195, 197, 196}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{197, 198, 196}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{197, 199, 198}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{199, 200, 198}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{199, 201, 200}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{201, 202, 200}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{201, 203, 202}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{203, 204, 202}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{203, 205, 204}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{205, 206, 204}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{205, 207, 206}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{207, 208, 206}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{207, 209, 208}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{209, 210, 208}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{209, 211, 210}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{211, 212, 210}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{211, 213, 212}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{213, 214, 212}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{213, 215, 214}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{215, 216, 214}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{215, 217, 216}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{217, 218, 216}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{217, 219, 218}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{219, 220, 218}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{189, 190, 221}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{190, 222, 221}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{190, 192, 222}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{192, 223, 222}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{192, 194, 223}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{194, 224, 223}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{194, 196, 224}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{196, 225, 224}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{196, 198, 225}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{198, 226, 225}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{198, 200, 226}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{200, 227, 226}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{200, 202, 227}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{202, 228, 227}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{202, 204, 228}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{204, 229, 228}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{204, 206, 229}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{206, 230, 229}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{206, 208, 230}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{208, 231, 230}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{208, 210, 231}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{210, 232, 231}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{210, 212, 232}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{212, 233, 232}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{212, 214, 233}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{214, 234, 233}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{214, 216, 234}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{216, 235, 234}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{216, 218, 235}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{218, 236, 235}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{218, 220, 236}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{220, 237, 236}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{221, 222, 238}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{222, 239, 238}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{222, 223, 239}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{223, 240, 239}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{223, 224, 240}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{224, 241, 240}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{224, 225, 241}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{225, 242, 241}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{225, 226, 242}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{226, 243, 242}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{226, 227, 243}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{227, 244, 243}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{227, 228, 244}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{228, 245, 244}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{228, 229, 245}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{229, 246, 245}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{229, 230, 246}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{230, 247, 246}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{230, 231, 247}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{231, 248, 247}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{231, 232, 248}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{232, 249, 248}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{232, 233, 249}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{233, 250, 249}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{233, 234, 250}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{234, 251, 250}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{234, 235, 251}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{235, 252, 251}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{235, 236, 252}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{236, 253, 252}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{236, 237, 253}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{237, 254, 253}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{255, 256, 254}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{256, 253, 254}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{256, 257, 253}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{257, 252, 253}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{257, 258, 252}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{258, 251, 252}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{258, 259, 251}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{259, 250, 251}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{259, 260, 250}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{260, 249, 250}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{260, 261, 249}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{261, 248, 249}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{261, 262, 248}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{262, 247, 248}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{262, 263, 247}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{263, 246, 247}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{263, 264, 246}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{264, 245, 246}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{264, 265, 245}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{265, 244, 245}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{265, 266, 244}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{266, 243, 244}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{266, 267, 243}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{267, 242, 243}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{267, 268, 242}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{268, 241, 242}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{268, 269, 241}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{269, 240, 241}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{269, 270, 240}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{270, 239, 240}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{270, 255, 239}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{255, 238, 239}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{271, 272, 273}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{272, 274, 273}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{272, 275, 274}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{275, 276, 274}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{275, 277, 276}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{277, 278, 276}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{277, 279, 278}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{279, 280, 278}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{279, 281, 280}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{281, 282, 280}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{281, 283, 282}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{283, 284, 282}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{283, 285, 284}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{285, 286, 284}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{285, 287, 286}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{287, 288, 286}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{287, 289, 288}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{289, 290, 288}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{289, 291, 290}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{291, 292, 290}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{291, 293, 292}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{293, 294, 292}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{293, 295, 294}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{295, 296, 294}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{295, 297, 296}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{297, 298, 296}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{297, 299, 298}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{299, 300, 298}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{299, 301, 300}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{301, 302, 300}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{301, 303, 302}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{303, 304, 302}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{273, 274, 305}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{274, 306, 305}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{274, 276, 306}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{276, 307, 306}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{276, 278, 307}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{278, 308, 307}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{278, 280, 308}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{280, 309, 308}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{280, 282, 309}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{282, 310, 309}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{282, 284, 310}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{284, 311, 310}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{284, 286, 311}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{286, 312, 311}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{286, 288, 312}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{288, 313, 312}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{288, 290, 313}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{290, 314, 313}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{290, 292, 314}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{292, 315, 314}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{292, 294, 315}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{294, 316, 315}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{294, 296, 316}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{296, 317, 316}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{296, 298, 317}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{298, 318, 317}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{298, 300, 318}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{300, 319, 318}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{300, 302, 319}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{302, 320, 319}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{302, 304, 320}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{304, 321, 320}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{305, 306, 322}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{306, 323, 322}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{306, 307, 323}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{307, 324, 323}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{307, 308, 324}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{308, 325, 324}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{308, 309, 325}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{309, 326, 325}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{309, 310, 326}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{310, 327, 326}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{310, 311, 327}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{311, 328, 327}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{311, 312, 328}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{312, 329, 328}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{312, 313, 329}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{313, 330, 329}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{313, 314, 330}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{314, 331, 330}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{314, 315, 331}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{315, 332, 331}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{315, 316, 332}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{316, 333, 332}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{316, 317, 333}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{317, 334, 333}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{317, 318, 334}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{318, 335, 334}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{318, 319, 335}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{319, 336, 335}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{319, 320, 336}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{320, 337, 336}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{320, 321, 337}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{321, 338, 337}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{339, 340, 338}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{340, 337, 338}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{340, 341, 337}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{341, 336, 337}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{341, 342, 336}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{342, 335, 336}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{342, 343, 335}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{343, 334, 335}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{343, 344, 334}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{344, 333, 334}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{344, 345, 333}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{345, 332, 333}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{345, 346, 332}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{346, 331, 332}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{346, 347, 331}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{347, 330, 331}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{347, 348, 330}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{348, 329, 330}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{348, 349, 329}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{349, 328, 329}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{349, 350, 328}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{350, 327, 328}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{350, 351, 327}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{351, 326, 327}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{351, 352, 326}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{352, 325, 326}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{352, 353, 325}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{353, 324, 325}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{353, 354, 324}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{354, 323, 324}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{354, 339, 323}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{339, 322, 323}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{355, 356, 357}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{356, 358, 357}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{357, 358, 359}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{358, 360, 359}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{359, 360, 361}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{360, 362, 361}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{361, 362, 363}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{362, 364, 363}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{363, 364, 365}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{364, 366, 365}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{365, 366, 367}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{366, 368, 367}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{367, 368, 369}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{368, 370, 369}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{369, 370, 371}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{370, 372, 371}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{371, 372, 373}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{372, 374, 373}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{373, 374, 375}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{374, 376, 375}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{375, 376, 377}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{376, 378, 377}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{377, 378, 379}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{378, 380, 379}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{379, 380, 381}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{380, 382, 381}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{381, 382, 383}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{382, 384, 383}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{383, 384, 385}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{384, 386, 385}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{385, 386, 387}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{386, 356, 387}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{387, 388, 385}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{388, 389, 385}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{385, 389, 383}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{389, 390, 383}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{383, 390, 381}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{390, 391, 381}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{381, 391, 379}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{391, 392, 379}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{379, 392, 377}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{392, 393, 377}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{377, 393, 375}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{393, 394, 375}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{375, 394, 373}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{394, 395, 373}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{373, 395, 371}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{395, 396, 371}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{371, 396, 369}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{396, 397, 369}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{369, 397, 367}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{397, 398, 367}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{367, 398, 365}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{398, 399, 365}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{365, 399, 363}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{399, 400, 363}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{363, 400, 361}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{400, 401, 361}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{361, 401, 359}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{401, 402, 359}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{359, 402, 357}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{402, 403, 357}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{357, 403, 355}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{403, 404, 355}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{388, 405, 389}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{405, 406, 389}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{389, 406, 390}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{406, 407, 390}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{390, 407, 391}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{407, 408, 391}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{391, 408, 392}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{408, 409, 392}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{392, 409, 393}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{409, 410, 393}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{393, 410, 394}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{410, 411, 394}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{394, 411, 395}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{411, 412, 395}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{395, 412, 396}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{412, 413, 396}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{396, 413, 397}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{413, 414, 397}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{397, 414, 398}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{414, 415, 398}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{398, 415, 399}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{415, 416, 399}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{399, 416, 400}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{416, 417, 400}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{400, 417, 401}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{417, 418, 401}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{401, 418, 402}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{418, 419, 402}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{402, 419, 403}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{419, 420, 403}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{403, 420, 404}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{420, 421, 404}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{405, 422, 406}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{422, 423, 406}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{406, 423, 407}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{423, 424, 407}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{407, 424, 408}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{424, 425, 408}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{408, 425, 409}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{425, 426, 409}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{409, 426, 410}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{426, 427, 410}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{410, 427, 411}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{427, 428, 411}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{411, 428, 412}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{428, 429, 412}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{412, 429, 413}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{429, 430, 413}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{413, 430, 414}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{430, 431, 414}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{414, 431, 415}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{431, 432, 415}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{415, 432, 416}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{432, 433, 416}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{416, 433, 417}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{433, 434, 417}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{417, 434, 418}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{434, 435, 418}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{418, 435, 419}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{435, 436, 419}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{419, 436, 420}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{436, 437, 420}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{420, 437, 421}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{437, 438, 421}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{439, 440, 441}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{440, 442, 441}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{441, 442, 443}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{442, 444, 443}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{443, 444, 445}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{444, 446, 445}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{445, 446, 447}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{446, 448, 447}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{447, 448, 449}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{448, 450, 449}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{449, 450, 451}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{450, 452, 451}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{451, 452, 453}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{452, 454, 453}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{453, 454, 455}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{454, 456, 455}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{455, 456, 457}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{456, 458, 457}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{457, 458, 459}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{458, 460, 459}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{459, 460, 461}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{460, 462, 461}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{461, 462, 463}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{462, 464, 463}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{463, 464, 465}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{464, 466, 465}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{465, 466, 467}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{466, 468, 467}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{467, 468, 469}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{468, 470, 469}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{469, 470, 471}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{470, 440, 471}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{471, 472, 469}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{472, 473, 469}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{469, 473, 467}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{473, 474, 467}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{467, 474, 465}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{474, 475, 465}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{465, 475, 463}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{475, 476, 463}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{463, 476, 461}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{476, 477, 461}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{461, 477, 459}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{477, 478, 459}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{459, 478, 457}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{478, 479, 457}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{457, 479, 455}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{479, 480, 455}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{455, 480, 453}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{480, 481, 453}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{453, 481, 451}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{481, 482, 451}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{451, 482, 449}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{482, 483, 449}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{449, 483, 447}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{483, 484, 447}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{447, 484, 445}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{484, 485, 445}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{445, 485, 443}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{485, 486, 443}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{443, 486, 441}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{486, 487, 441}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{441, 487, 439}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{487, 488, 439}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{472, 489, 473}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{489, 490, 473}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{473, 490, 474}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{490, 491, 474}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{474, 491, 475}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{491, 492, 475}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{475, 492, 476}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{492, 493, 476}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{476, 493, 477}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{493, 494, 477}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{477, 494, 478}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{494, 495, 478}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{478, 495, 479}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{495, 496, 479}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{479, 496, 480}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{496, 497, 480}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{480, 497, 481}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{497, 498, 481}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{481, 498, 482}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{498, 499, 482}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{482, 499, 483}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{499, 500, 483}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{483, 500, 484}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{500, 501, 484}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{484, 501, 485}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{501, 502, 485}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{485, 502, 486}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{502, 503, 486}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{486, 503, 487}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{503, 504, 487}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{487, 504, 488}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{504, 505, 488}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{489, 506, 490}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{506, 507, 490}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{490, 507, 491}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{507, 508, 491}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{491, 508, 492}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{508, 509, 492}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{492, 509, 493}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{509, 510, 493}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{493, 510, 494}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{510, 511, 494}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{494, 511, 495}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{511, 512, 495}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{495, 512, 496}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{512, 513, 496}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{496, 513, 497}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{513, 514, 497}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{497, 514, 498}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{514, 515, 498}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{498, 515, 499}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{515, 516, 499}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{499, 516, 500}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{516, 517, 500}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{500, 517, 501}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{517, 518, 501}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{501, 518, 502}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{518, 519, 502}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{502, 519, 503}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{519, 520, 503}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{503, 520, 504}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{520, 521, 504}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{504, 521, 505}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{521, 522, 505}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{523, 524, 525}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{524, 526, 525}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{527, 528, 529}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{528, 530, 529}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{531, 532, 525}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{531, 525, 526}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{533, 534, 529}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{530, 533, 529}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{535, 536, 537}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{538, 535, 537}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{539, 538, 537}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{540, 538, 539}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{541, 540, 539}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{542, 540, 541}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{543, 542, 541}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{544, 542, 543}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{545, 544, 543}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{546, 547, 538}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{540, 546, 538}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{548, 546, 540}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{542, 548, 540}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{549, 548, 542}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{544, 549, 542}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{550, 549, 544}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{551, 552, 547}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{546, 551, 547}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{553, 551, 546}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{548, 553, 546}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{554, 553, 548}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{549, 554, 548}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{555, 556, 552}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{551, 555, 552}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{557, 555, 551}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{553, 557, 551}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{558, 557, 553}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{554, 558, 553}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{559, 560, 556}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{555, 559, 556}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{561, 559, 555}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{557, 561, 555}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{562, 561, 557}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{558, 562, 557}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{563, 564, 560}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{559, 563, 560}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{565, 563, 559}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{561, 565, 559}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{566, 565, 561}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{562, 566, 561}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{567, 568, 569}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{570, 567, 569}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{570, 569, 571}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{572, 570, 571}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{572, 571, 573}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{544, 572, 573}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{544, 573, 550}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{568, 574, 575}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{569, 568, 575}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{569, 575, 576}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{571, 569, 576}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{571, 576, 577}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{573, 571, 577}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{574, 578, 579}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{575, 574, 579}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{575, 579, 580}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{576, 575, 580}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{576, 580, 581}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{577, 576, 581}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{578, 582, 583}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{579, 578, 583}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{579, 583, 584}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{580, 579, 584}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{580, 584, 585}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{581, 580, 585}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{582, 586, 587}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{583, 582, 587}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{583, 587, 588}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{584, 583, 588}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{584, 588, 589}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{585, 584, 589}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{590, 591, 592}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{593, 594, 595}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{594, 596, 595}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{596, 597, 595}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{598, 599, 600}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{600, 601, 598}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{602, 603, 119}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{602, 119, 118}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{115, 602, 118}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{117, 604, 116}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{604, 605, 115}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{116, 604, 115}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{115, 605, 602}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{602, 605, 603}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{605, 606, 603}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{606, 607, 603}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{608, 609, 604}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{609, 605, 604}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{605, 609, 606}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{609, 610, 606}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{606, 610, 607}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{610, 611, 607}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{612, 613, 597}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{614, 612, 615}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{615, 612, 596}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{596, 612, 597}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{595, 597, 616}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{617, 595, 616}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{617, 616, 618}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{618, 616, 619}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{619, 616, 611}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{619, 611, 620}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{620, 611, 610}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{621, 620, 610}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{621, 610, 609}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{622, 621, 609}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{623, 622, 609}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{623, 609, 608}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{624, 625, 626}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{625, 624, 614}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{614, 624, 612}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{613, 612, 627}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{628, 613, 627}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{629, 628, 627}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{630, 629, 627}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{631, 630, 627}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{631, 627, 612}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{632, 631, 612}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{624, 632, 612}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{632, 633, 631}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{633, 634, 631}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{631, 634, 630}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{634, 592, 630}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{630, 592, 629}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{592, 591, 629}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{629, 591, 628}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{635, 628, 591}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{635, 591, 636}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{637, 635, 636}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{638, 637, 636}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{639, 638, 636}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{639, 636, 591}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{639, 591, 590}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{640, 639, 590}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{641, 640, 590}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{642, 641, 590}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{642, 590, 592}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{592, 634, 642}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{643, 641, 642}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{644, 643, 642}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{644, 642, 634}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{633, 644, 634}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{645, 643, 644}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{645, 644, 633}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{646, 647, 566}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{648, 646, 566}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{649, 648, 566}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{647, 650, 565}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{566, 647, 565}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{565, 650, 563}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{650, 651, 563}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{563, 651, 564}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{564, 651, 652}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{652, 651, 653}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{654, 653, 655}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{586, 654, 655}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{587, 586, 655}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{651, 656, 657}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{653, 651, 657}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{653, 657, 658}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{655, 653, 658}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{656, 659, 660}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{657, 656, 660}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{657, 660, 661}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{658, 657, 661}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{659, 662, 663}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{660, 659, 663}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{660, 663, 664}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{661, 660, 664}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{45, 635, 41}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{635, 665, 41}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{635, 637, 665}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{637, 666, 665}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{637, 638, 666}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{638, 667, 666}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{41, 665, 37}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{37, 665, 668}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{665, 666, 668}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{666, 667, 668}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{667, 669, 668}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{37, 668, 36}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{668, 669, 36}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{662, 670, 671}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{663, 662, 671}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{663, 671, 672}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{664, 663, 672}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{670, 673, 674}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{671, 670, 674}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{671, 674, 675}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{672, 671, 675}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{673, 676, 677}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{674, 673, 677}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{674, 677, 678}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{675, 674, 678}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{676, 679, 680}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{677, 676, 680}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{677, 680, 681}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{678, 677, 681}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{679, 682, 683}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{680, 679, 683}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{680, 683, 684}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{681, 680, 684}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{683, 682, 685}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{683, 685, 686}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{684, 683, 686}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{684, 686, 687}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{688, 685, 689}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{686, 685, 688}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{690, 686, 688}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{687, 686, 690}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{688, 689, 691}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{692, 688, 691}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{690, 688, 692}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{693, 690, 692}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{692, 691, 694}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{695, 692, 694}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{693, 692, 695}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{696, 693, 695}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{695, 694, 697}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{698, 695, 697}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{696, 695, 698}]}, 
     {RGBColor[0.1843137254901961, 0.1843137254901961, 0.1843137254901961], 
      Polygon3DBox[{699, 696, 698}]}}], GraphicsComplex3DBox[CompressedData["
1:eJyFnAm0VdV5gDeDyKgID3jA43Eeb2AQUbkMTsgBZFBRBgeKS81N1KuNJA6N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    "], {
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{1, 2, 3}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{4, 2, 1}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{5, 6, 7}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{1, 6, 5}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{8, 9, 10}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{11, 9, 8}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{12, 13, 10}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{9, 12, 10}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{14, 12, 9}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{11, 14, 9}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{15, 14, 11}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{16, 15, 11}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{17, 18, 13}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{12, 17, 13}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{14, 17, 12}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{19, 17, 14}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{15, 19, 14}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{20, 19, 15}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{21, 20, 15}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{16, 21, 15}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{22, 23, 18}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{17, 22, 18}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{24, 22, 17}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{19, 24, 17}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{25, 24, 19}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{26, 25, 19}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{20, 26, 19}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{27, 26, 20}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{28, 27, 20}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{29, 28, 20}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{30, 29, 20}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{21, 30, 20}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{31, 32, 23}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{33, 32, 31}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{34, 31, 23}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{35, 34, 23}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{22, 35, 23}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{24, 35, 22}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{36, 35, 24}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{37, 35, 36}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{38, 37, 36}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{39, 38, 36}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{39, 36, 24}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{25, 39, 24}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{40, 39, 25}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{26, 40, 25}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{41, 40, 26}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{27, 41, 26}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{42, 41, 27}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{28, 42, 27}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{43, 42, 28}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{29, 43, 28}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{44, 43, 29}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{45, 44, 30}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{46, 44, 45}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{39, 47, 38}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{48, 47, 39}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{40, 48, 39}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{49, 48, 40}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{41, 49, 40}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{50, 49, 41}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{42, 50, 41}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{51, 50, 42}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{43, 51, 42}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{52, 51, 43}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{44, 52, 43}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{53, 52, 44}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{46, 53, 44}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{54, 53, 46}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{48, 55, 47}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{56, 55, 48}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{49, 56, 48}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{57, 56, 49}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{50, 57, 49}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{58, 57, 50}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{51, 58, 50}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{59, 58, 51}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{52, 59, 51}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{60, 59, 52}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{53, 60, 52}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{61, 60, 53}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{54, 61, 53}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{62, 61, 54}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{63, 64, 65}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{64, 66, 65}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{65, 67, 63}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{65, 32, 67}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{32, 33, 67}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{30, 44, 29}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{64, 68, 66}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{68, 69, 66}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{68, 70, 69}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{70, 71, 69}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{70, 72, 71}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{72, 73, 71}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{74, 73, 72}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{75, 76, 77}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{76, 78, 77}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{79, 80, 55}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{56, 79, 55}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{81, 79, 56}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{57, 81, 56}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{82, 81, 57}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{58, 82, 57}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{83, 82, 58}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{59, 83, 58}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{84, 83, 59}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{60, 84, 59}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{85, 84, 60}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{61, 85, 60}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{86, 85, 61}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{62, 86, 61}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{76, 75, 80}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{79, 76, 80}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{78, 76, 79}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{81, 78, 79}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{87, 78, 81}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{82, 87, 81}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{88, 87, 82}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{83, 88, 82}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{89, 88, 83}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{84, 89, 83}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{90, 89, 84}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{85, 90, 84}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{91, 90, 85}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{86, 91, 85}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{92, 93, 94}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{95, 92, 94}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{96, 92, 95}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{97, 96, 95}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{96, 98, 92}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{98, 99, 92}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{99, 93, 92}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{99, 74, 93}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{100, 74, 99}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{101, 100, 99}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{98, 101, 99}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{102, 101, 98}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{103, 102, 98}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{102, 104, 101}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{104, 105, 101}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{101, 105, 100}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{105, 106, 100}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{100, 106, 74}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{106, 107, 74}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{107, 108, 74}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{108, 73, 74}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{108, 109, 73}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{110, 111, 109}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{108, 110, 109}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{112, 110, 108}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{107, 112, 108}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{113, 112, 107}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{106, 113, 107}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{114, 113, 106}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{105, 114, 106}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{115, 114, 105}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{104, 115, 105}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{116, 115, 104}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{117, 116, 104}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{118, 116, 117}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{119, 118, 117}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{120, 118, 119}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{121, 120, 119}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{122, 120, 121}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{123, 122, 121}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{124, 125, 111}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{110, 124, 111}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{126, 124, 110}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{112, 126, 110}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{127, 126, 112}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{113, 127, 112}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{128, 127, 113}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{114, 128, 113}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{129, 128, 114}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{115, 129, 114}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{130, 129, 115}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{116, 130, 115}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{131, 130, 116}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{118, 131, 116}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{132, 131, 118}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{120, 132, 118}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{133, 132, 120}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{122, 133, 120}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{124, 134, 125}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{126, 134, 124}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{135, 134, 126}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{127, 135, 126}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{136, 135, 127}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{128, 136, 127}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{137, 136, 128}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{129, 137, 128}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{138, 137, 129}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{130, 138, 129}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{139, 138, 130}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{131, 139, 130}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{140, 139, 131}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{132, 140, 131}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{141, 140, 132}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{133, 141, 132}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{135, 142, 134}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{143, 142, 135}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{136, 143, 135}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{144, 143, 136}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{137, 144, 136}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{145, 144, 137}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{138, 145, 137}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{146, 145, 138}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{139, 146, 138}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{140, 146, 139}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{143, 147, 142}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{148, 147, 143}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{144, 148, 143}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{145, 148, 144}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{149, 148, 145}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{146, 149, 145}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{148, 150, 147}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{149, 150, 148}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{151, 152, 153}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{154, 151, 153}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{155, 156, 152}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{151, 155, 152}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{157, 158, 156}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{155, 157, 156}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{159, 160, 158}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{157, 159, 158}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{161, 153, 152}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{162, 153, 161}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{152, 156, 163}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{161, 152, 163}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{156, 158, 164}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{163, 156, 164}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{158, 160, 165}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{164, 158, 165}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{166, 167, 168}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{169, 167, 166}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{170, 169, 166}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{171, 169, 170}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{172, 173, 174}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{173, 175, 174}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{173, 167, 175}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{167, 169, 175}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{169, 176, 175}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{171, 176, 169}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{177, 176, 171}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{178, 177, 171}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{179, 180, 181}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{180, 182, 181}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{182, 183, 181}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{184, 183, 182}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{185, 183, 184}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{186, 185, 184}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{187, 185, 186}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{188, 187, 186}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{189, 187, 188}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{190, 189, 188}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{182, 180, 191}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{192, 182, 191}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{184, 182, 192}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{193, 184, 192}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{186, 184, 193}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{194, 186, 193}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{188, 186, 194}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{195, 188, 194}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{196, 197, 198}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{197, 199, 198}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{197, 200, 199}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{200, 201, 199}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{200, 202, 201}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{202, 203, 201}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{204, 205, 206}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{205, 207, 206}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{205, 208, 207}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{208, 209, 207}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{206, 207, 210}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{207, 211, 210}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{207, 209, 211}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{209, 212, 211}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{210, 211, 213}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{211, 214, 213}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{211, 212, 214}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{212, 215, 214}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{213, 214, 216}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{214, 217, 216}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{214, 215, 217}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{215, 218, 217}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{216, 217, 219}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{217, 220, 219}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{217, 218, 220}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{218, 221, 220}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{222, 223, 224}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{223, 225, 224}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{224, 225, 226}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{225, 227, 226}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{226, 227, 228}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{227, 229, 228}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{228, 229, 230}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{229, 231, 230}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{230, 231, 232}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{231, 233, 232}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{234, 235, 236}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{235, 237, 236}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{235, 238, 237}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{238, 239, 237}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{234, 240, 235}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{240, 241, 235}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{235, 241, 238}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{241, 242, 238}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{238, 242, 239}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{242, 243, 239}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{240, 244, 241}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{244, 245, 241}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{241, 245, 242}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{245, 246, 242}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{242, 246, 243}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{246, 247, 243}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{244, 248, 245}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{248, 249, 245}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{245, 249, 246}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{249, 250, 246}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{246, 250, 247}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{250, 251, 247}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{248, 252, 249}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{252, 253, 249}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{249, 253, 250}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{253, 254, 250}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{250, 254, 251}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{254, 255, 251}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{256, 257, 258}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{257, 259, 258}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{257, 260, 259}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{260, 261, 259}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{256, 262, 257}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{262, 263, 257}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{257, 263, 260}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{263, 264, 260}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{260, 264, 261}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{264, 265, 261}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{262, 266, 263}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{266, 267, 263}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{263, 267, 264}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{267, 268, 264}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{264, 268, 265}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{268, 269, 265}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{270, 271, 272}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{271, 273, 272}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{272, 273, 274}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{273, 275, 274}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{274, 275, 276}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{275, 277, 276}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{278, 270, 279}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{270, 272, 279}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{279, 272, 280}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{272, 274, 280}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{280, 274, 281}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{274, 276, 281}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{278, 279, 282}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{282, 279, 283}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{279, 280, 283}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{280, 281, 283}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{284, 285, 286}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{287, 284, 286}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{285, 288, 289}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{286, 285, 289}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{288, 290, 291}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{289, 288, 291}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{287, 286, 292}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{293, 287, 292}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{286, 289, 294}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{292, 286, 294}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{289, 291, 295}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{294, 289, 295}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{293, 292, 296}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{292, 294, 297}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{296, 292, 297}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{294, 295, 297}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{198, 199, 298}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{299, 198, 298}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{298, 199, 300}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{199, 201, 300}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{300, 201, 301}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{201, 203, 301}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{302, 303, 304}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{305, 303, 302}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{306, 307, 302}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{307, 305, 302}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{308, 307, 306}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{309, 308, 306}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{310, 308, 309}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{311, 310, 309}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{312, 313, 314}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{315, 312, 314}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{316, 312, 315}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{317, 316, 315}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{318, 316, 317}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{319, 318, 317}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{320, 318, 319}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{321, 320, 319}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{322, 323, 324}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{323, 322, 325}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{326, 322, 324}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{322, 326, 325}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{327, 326, 324}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{326, 328, 325}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{329, 326, 327}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{326, 329, 328}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{329, 327, 330}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{329, 331, 328}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{332, 329, 330}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{329, 333, 331}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{334, 329, 332}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{329, 334, 333}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{332, 330, 335}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{333, 336, 331}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{337, 332, 335}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{333, 338, 336}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{337, 339, 332}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{333, 339, 338}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{339, 334, 332}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{334, 339, 333}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{340, 339, 337}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{339, 340, 338}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{341, 340, 337}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{340, 341, 338}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{337, 335, 342}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{338, 343, 336}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{344, 341, 337}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{341, 345, 338}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{346, 344, 337}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{338, 345, 347}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{346, 337, 348}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{338, 347, 349}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{350, 344, 346}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{345, 351, 347}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{348, 337, 342}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{338, 349, 343}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{352, 350, 346}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{351, 353, 347}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{354, 352, 346}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{347, 353, 355}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{354, 346, 316}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{347, 355, 315}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{346, 356, 316}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{357, 347, 315}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{356, 346, 348}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{347, 357, 349}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{356, 348, 312}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{357, 314, 349}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{312, 348, 313}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{349, 314, 313}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{312, 316, 356}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{314, 357, 315}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{318, 354, 316}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{355, 317, 315}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{358, 354, 318}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{355, 359, 317}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{358, 360, 354}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{355, 361, 359}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{360, 352, 354}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{353, 361, 355}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{362, 360, 358}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{361, 363, 359}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{364, 358, 320}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{365, 319, 359}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{358, 318, 320}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{359, 319, 317}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{321, 364, 320}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{365, 321, 319}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{321, 366, 362}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{367, 321, 363}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{368, 366, 321}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{367, 368, 321}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{362, 358, 364}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{359, 363, 365}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{321, 362, 364}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{363, 321, 365}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{369, 370, 371}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{370, 369, 372}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{373, 369, 371}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{369, 373, 372}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{374, 373, 371}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{373, 374, 372}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{374, 371, 375}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{372, 374, 376}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{377, 375, 378}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{379, 380, 376}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{377, 374, 375}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{374, 379, 376}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{381, 374, 377}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{374, 381, 379}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{382, 381, 377}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{381, 382, 379}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{382, 377, 383}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{379, 382, 384}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{385, 382, 383}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{382, 385, 384}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{386, 385, 383}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{385, 387, 384}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{388, 386, 383}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{387, 389, 384}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{390, 388, 383}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{389, 391, 384}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{392, 390, 383}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{391, 393, 384}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{394, 392, 383}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{393, 395, 384}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{394, 383, 396}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{384, 395, 397}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{398, 392, 394}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{393, 399, 395}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{390, 392, 398}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{393, 391, 399}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{400, 390, 398}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{391, 401, 399}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{402, 400, 398}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{401, 403, 399}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{404, 402, 398}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{403, 405, 399}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{406, 402, 404}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{403, 407, 405}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{408, 406, 404}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{407, 408, 405}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{409, 406, 408}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{407, 409, 408}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{396, 397, 395}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{394, 396, 395}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{394, 395, 399}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{398, 394, 399}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{398, 399, 405}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{404, 398, 405}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{408, 404, 405}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{377, 378, 410}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{383, 377, 410}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{383, 410, 411}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{396, 383, 411}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{379, 412, 380}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{379, 413, 412}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{379, 384, 413}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{384, 397, 413}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{378, 411, 410}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{414, 415, 416}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{417, 418, 415}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{419, 420, 418}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{421, 422, 420}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{423, 424, 422}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{425, 426, 424}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{427, 428, 426}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{429, 430, 428}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{431, 432, 430}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{433, 434, 432}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{435, 436, 434}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{437, 438, 436}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{439, 440, 438}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{441, 442, 440}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{443, 444, 442}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{445, 416, 444}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{446, 447, 448}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{449, 450, 447}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{451, 452, 450}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{453, 454, 452}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{455, 456, 454}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{457, 458, 456}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{459, 460, 458}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{461, 462, 460}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{463, 464, 462}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{465, 466, 464}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{467, 468, 466}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{469, 470, 468}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{471, 472, 470}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{473, 474, 472}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{475, 476, 474}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{477, 448, 476}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{478, 90, 91}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{479, 478, 91}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{480, 478, 479}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{481, 480, 479}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{482, 483, 478}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{480, 482, 478}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{121, 480, 481}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{123, 121, 481}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{484, 485, 174}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{175, 484, 174}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{252, 484, 175}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{486, 252, 175}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{487, 255, 488}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{176, 487, 488}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{266, 487, 176}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{489, 266, 176}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{490, 269, 491}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{177, 490, 491}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{492, 493, 494}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{488, 492, 494}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{494, 486, 488}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{494, 493, 486}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{493, 252, 486}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{493, 253, 252}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{254, 253, 493}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{492, 254, 493}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{488, 254, 492}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{488, 255, 254}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{489, 491, 495}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{496, 489, 495}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{497, 496, 495}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{491, 497, 495}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{496, 266, 489}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{496, 267, 266}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{497, 267, 496}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{268, 267, 497}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{491, 268, 497}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{491, 269, 268}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{271, 498, 181}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{499, 271, 181}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{500, 277, 183}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{185, 500, 183}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{501, 500, 185}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{284, 501, 185}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{502, 284, 185}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{503, 290, 504}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{187, 503, 504}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{505, 503, 187}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{189, 505, 187}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{506, 499, 183}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{507, 499, 506}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{508, 507, 506}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{508, 506, 183}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{507, 271, 499}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{507, 273, 271}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{507, 508, 273}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{275, 273, 508}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{508, 183, 275}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{183, 277, 275}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{509, 502, 504}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{510, 502, 509}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{511, 510, 509}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{504, 511, 509}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{510, 284, 502}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{510, 285, 284}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{511, 285, 510}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{288, 285, 511}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{288, 511, 504}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{290, 288, 504}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{512, 513, 514}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{515, 512, 514}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{516, 512, 515}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{516, 515, 517}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{516, 517, 518}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{518, 517, 519}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{515, 514, 520}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{517, 515, 520}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{519, 517, 520}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{519, 520, 514}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{521, 522, 523}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{522, 524, 523}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{525, 523, 524}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{524, 526, 525}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{525, 526, 527}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{527, 526, 528}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{529, 524, 522}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{526, 524, 529}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{528, 526, 529}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{528, 529, 522}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{530, 531, 532}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{533, 530, 532}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{533, 532, 514}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{513, 533, 514}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{518, 519, 534}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{535, 518, 534}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{536, 535, 534}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{536, 534, 522}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{521, 536, 522}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{527, 528, 537}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{538, 527, 537}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{539, 540, 541}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{541, 540, 542}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{543, 541, 542}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{543, 542, 544}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{543, 544, 545}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{545, 544, 546}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{542, 540, 547}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{544, 542, 547}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{546, 544, 547}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{540, 546, 547}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{548, 549, 550}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{550, 549, 551}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{550, 551, 552}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{553, 550, 552}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{553, 552, 554}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{554, 552, 555}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{552, 556, 555}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{555, 556, 549}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{551, 549, 556}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{552, 551, 556}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{557, 558, 540}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{539, 557, 540}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{545, 546, 559}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{560, 545, 559}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{560, 559, 549}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{548, 560, 549}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{554, 555, 561}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{562, 554, 561}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{562, 561, 563}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{564, 562, 563}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{565, 123, 481}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{566, 565, 481}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{567, 566, 568}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{569, 567, 568}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{566, 481, 479}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{568, 566, 479}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{568, 479, 91}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{570, 568, 91}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{571, 572, 573}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{573, 574, 575}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{575, 576, 577}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{577, 578, 579}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{579, 580, 581}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{581, 582, 583}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{583, 584, 585}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{585, 586, 587}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{587, 588, 589}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{589, 590, 591}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{591, 592, 593}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{593, 594, 595}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{595, 596, 597}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{597, 598, 599}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{599, 600, 601}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{601, 602, 571}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{603, 604, 605}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{605, 606, 607}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{607, 608, 609}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{609, 610, 611}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{611, 612, 613}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{613, 614, 615}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{615, 616, 617}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{617, 618, 619}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{619, 620, 621}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{621, 622, 623}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{623, 624, 625}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{625, 626, 627}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{627, 628, 629}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{629, 630, 631}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{631, 632, 633}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{633, 634, 603}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{635, 636, 637}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{638, 639, 640}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{639, 641, 640}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{640, 641, 642}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{642, 641, 643}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{644, 645, 635}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{637, 644, 635}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{646, 644, 637}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{636, 646, 637}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{647, 648, 649}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{650, 647, 649}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{651, 650, 649}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{652, 650, 651}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{653, 652, 651}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{645, 652, 653}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{638, 645, 653}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{654, 655, 648}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{656, 654, 648}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{648, 655, 649}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{656, 648, 647}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{655, 657, 649}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{658, 656, 647}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{649, 657, 651}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{658, 647, 650}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{657, 659, 651}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{660, 658, 650}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{659, 661, 651}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{662, 660, 650}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{661, 663, 651}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{664, 662, 650}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{651, 663, 653}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{664, 650, 652}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{653, 639, 638}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{644, 652, 645}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{653, 663, 639}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{664, 652, 644}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{663, 661, 639}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{662, 664, 644}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{661, 665, 639}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{666, 662, 644}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{665, 667, 639}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{668, 666, 644}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{667, 669, 639}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{669, 668, 644}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{669, 670, 639}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{670, 669, 644}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{670, 641, 639}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{646, 670, 644}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{670, 671, 641}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{671, 670, 646}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{671, 672, 641}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{672, 671, 646}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{641, 672, 673}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{672, 646, 674}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{643, 641, 673}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{674, 646, 636}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{672, 675, 673}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{676, 672, 674}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{672, 677, 675}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{677, 672, 676}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{677, 678, 675}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{678, 677, 676}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{678, 679, 675}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{679, 678, 676}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{680, 681, 682}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{683, 680, 684}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{681, 685, 682}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{686, 683, 684}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{687, 688, 680}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{689, 687, 680}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{680, 688, 681}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{689, 680, 683}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{680, 682, 690}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{684, 680, 691}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{690, 685, 692}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{693, 686, 691}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{690, 682, 685}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{686, 684, 691}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{681, 694, 685}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{695, 683, 686}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{694, 696, 697}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{698, 695, 699}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{694, 697, 685}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{695, 686, 699}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{685, 697, 692}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{699, 686, 693}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{692, 697, 700}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{699, 693, 701}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{702, 703, 700}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{701, 704, 705}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{703, 706, 707}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{708, 704, 707}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{703, 702, 706}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{708, 705, 704}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{702, 709, 706}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{710, 705, 708}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{709, 702, 700}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{705, 710, 701}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{697, 709, 700}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{710, 699, 701}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{696, 709, 697}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{698, 699, 710}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{696, 711, 709}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{712, 698, 710}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{706, 713, 714}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{715, 708, 716}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{711, 717, 709}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{718, 712, 710}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{709, 713, 706}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{715, 710, 708}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{717, 713, 709}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{718, 710, 715}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{717, 719, 713}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{719, 718, 715}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{714, 713, 720}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{721, 715, 716}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{719, 722, 713}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{722, 719, 715}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{722, 723, 713}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{723, 722, 715}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{723, 724, 725}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{724, 723, 726}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{723, 725, 713}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{723, 715, 726}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{713, 725, 720}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{726, 715, 721}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{720, 725, 727}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{728, 726, 721}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{724, 729, 725}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{729, 724, 726}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{725, 729, 727}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{729, 726, 728}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{727, 729, 730}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{731, 729, 728}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{729, 732, 730}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{732, 729, 731}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{730, 732, 733}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{732, 731, 734}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{732, 735, 733}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{735, 732, 734}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{735, 736, 733}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{736, 735, 734}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{691, 680, 690}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{693, 691, 690}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{693, 690, 692}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{701, 693, 692}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{701, 692, 700}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{704, 701, 700}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{704, 700, 703}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{707, 704, 703}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{737, 738, 739}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{740, 737, 739}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{740, 739, 741}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{742, 740, 741}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{743, 742, 744}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{742, 741, 744}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{745, 743, 744}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{745, 744, 746}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{747, 748, 749}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{748, 750, 749}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{748, 751, 750}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{751, 752, 750}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{753, 754, 752}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{751, 753, 752}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{755, 756, 757}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{758, 759, 757}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{756, 758, 757}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{758, 760, 759}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{761, 756, 755}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{762, 761, 755}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{763, 758, 756}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{761, 763, 756}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{764, 760, 758}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{763, 764, 758}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{512, 761, 762}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{513, 512, 762}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{516, 763, 761}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{512, 516, 761}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{518, 764, 763}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{516, 518, 763}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{765, 766, 767}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{766, 768, 767}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{768, 769, 767}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{768, 770, 769}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{771, 772, 765}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{772, 766, 765}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{772, 773, 766}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{773, 768, 766}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{773, 774, 768}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{774, 770, 768}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{521, 523, 771}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{523, 772, 771}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{523, 525, 772}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{525, 773, 772}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{525, 527, 773}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{527, 774, 773}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{539, 541, 775}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{541, 776, 775}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{541, 543, 776}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{543, 777, 776}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{543, 545, 777}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{545, 778, 777}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{775, 776, 779}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{776, 780, 779}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{776, 777, 780}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{777, 781, 780}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{777, 778, 781}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{778, 782, 781}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{779, 780, 783}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{780, 781, 783}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{783, 781, 784}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{781, 782, 784}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{548, 550, 785}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{550, 786, 785}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{550, 553, 786}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{553, 787, 786}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{553, 554, 787}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{554, 788, 787}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{785, 786, 789}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{786, 790, 789}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{786, 787, 790}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{787, 791, 790}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{787, 788, 791}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{788, 792, 791}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{789, 790, 793}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{790, 794, 793}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{790, 791, 794}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{791, 795, 794}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{791, 792, 795}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{792, 796, 795}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{793, 794, 797}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{794, 798, 797}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{794, 795, 798}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{795, 799, 798}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{795, 796, 799}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{796, 800, 799}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{797, 798, 801}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{798, 799, 801}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{801, 799, 802}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{799, 800, 802}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{803, 804, 805}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{804, 806, 805}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{804, 807, 806}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{807, 808, 806}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{807, 809, 808}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{809, 810, 808}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{809, 811, 810}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{811, 812, 810}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{811, 813, 812}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{813, 814, 812}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{815, 816, 817}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{816, 818, 817}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{817, 818, 819}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{818, 820, 819}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{816, 821, 818}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{821, 822, 818}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{818, 822, 820}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{822, 823, 820}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{821, 824, 822}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{824, 825, 822}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{822, 825, 823}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{825, 826, 823}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{824, 827, 825}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{827, 828, 825}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{825, 828, 826}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{828, 829, 826}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{827, 830, 828}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{830, 831, 828}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{828, 831, 829}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{831, 832, 829}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{747, 833, 748}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{833, 834, 748}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{748, 834, 751}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{834, 835, 751}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{751, 835, 753}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{835, 836, 753}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{837, 838, 839}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{840, 837, 839}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{840, 839, 841}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{842, 840, 841}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{842, 841, 843}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{844, 842, 843}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{844, 843, 845}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{846, 844, 845}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{531, 847, 837}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{532, 531, 837}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{532, 837, 840}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{534, 532, 840}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{534, 840, 842}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{522, 534, 842}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{522, 842, 844}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{522, 844, 537}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{844, 846, 537}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{846, 848, 537}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{558, 849, 850}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{559, 558, 850}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{559, 850, 851}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{559, 851, 561}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{851, 852, 561}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{852, 853, 561}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{561, 853, 563}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{853, 854, 563}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{851, 850, 855}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{851, 855, 856}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{852, 851, 856}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{852, 856, 857}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{858, 859, 860}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{861, 858, 860}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{862, 863, 859}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{858, 862, 859}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{864, 865, 863}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{862, 864, 863}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{866, 867, 865}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{866, 865, 864}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{868, 869, 858}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{861, 868, 858}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{869, 870, 862}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{858, 869, 862}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{870, 871, 864}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{862, 870, 864}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{871, 872, 866}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{864, 871, 866}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{873, 874, 875}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{873, 875, 876}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{874, 877, 878}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{875, 874, 878}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{875, 878, 879}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{875, 879, 880}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{876, 875, 880}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{876, 880, 881}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{877, 882, 883}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{877, 883, 884}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{878, 877, 884}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{878, 884, 885}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{879, 878, 885}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{879, 885, 886}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{880, 879, 886}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{880, 886, 887}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{881, 880, 887}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{881, 887, 888}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{141, 133, 889}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{882, 141, 889}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{882, 889, 890}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{883, 882, 890}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{883, 890, 891}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{884, 883, 891}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{884, 891, 892}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{885, 884, 892}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{885, 892, 893}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{886, 885, 893}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{886, 893, 894}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{887, 886, 894}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{887, 894, 895}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{888, 887, 895}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{888, 895, 896}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{888, 896, 897}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{133, 122, 898}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{889, 133, 898}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{889, 898, 899}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{890, 889, 899}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{890, 899, 900}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{891, 890, 900}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{891, 900, 901}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{892, 891, 901}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{892, 901, 902}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{893, 892, 902}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{893, 902, 903}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{894, 893, 903}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{894, 903, 904}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{895, 894, 904}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{895, 904, 905}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{896, 895, 905}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{896, 905, 906}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{897, 896, 906}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{122, 123, 565}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{898, 122, 565}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{898, 565, 907}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{899, 898, 907}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{899, 907, 908}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{900, 899, 908}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{900, 908, 909}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{901, 900, 909}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{901, 909, 910}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{902, 901, 910}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{902, 910, 911}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{903, 902, 911}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{903, 911, 912}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{904, 903, 912}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{904, 912, 913}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{905, 904, 913}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{905, 913, 914}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{906, 905, 914}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{914, 913, 915}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{915, 913, 916}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{913, 912, 916}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{912, 911, 916}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{911, 917, 916}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{911, 910, 917}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{910, 918, 917}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{910, 909, 918}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{909, 919, 918}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{919, 920, 921}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{918, 919, 921}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{918, 921, 922}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{917, 918, 922}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{916, 917, 922}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{916, 922, 923}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{923, 922, 924}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{922, 921, 924}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{921, 925, 924}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{925, 926, 927}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{924, 925, 927}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{924, 927, 928}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{923, 924, 928}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{91, 86, 929}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{570, 91, 929}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{570, 929, 930}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{931, 570, 930}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{931, 930, 932}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{933, 931, 932}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{933, 932, 934}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{935, 933, 934}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{935, 934, 936}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{937, 935, 936}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{937, 936, 938}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{939, 937, 938}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{939, 938, 940}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{941, 939, 940}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{86, 62, 942}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{929, 86, 942}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{929, 942, 943}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{930, 929, 943}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{930, 943, 944}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{932, 930, 944}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{932, 944, 945}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{934, 932, 945}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{934, 945, 946}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{936, 934, 946}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{936, 946, 947}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{938, 936, 947}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{938, 947, 948}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{940, 938, 948}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{937, 939, 949}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{939, 941, 949}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{915, 916, 950}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{915, 950, 951}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{950, 952, 951}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{951, 952, 953}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{952, 954, 953}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{953, 954, 955}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{954, 956, 955}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{957, 958, 959}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{960, 961, 962}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{961, 963, 962}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{962, 963, 964}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{955, 956, 963}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{956, 964, 963}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{942, 62, 54}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{942, 54, 965}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{943, 942, 965}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{943, 965, 966}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{944, 943, 966}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{944, 966, 967}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{945, 944, 967}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{945, 967, 968}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{946, 945, 968}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{946, 968, 969}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{947, 946, 969}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{947, 969, 970}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{948, 947, 970}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{948, 970, 971}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{965, 54, 46}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{965, 46, 957}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{966, 965, 957}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{966, 957, 972}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{967, 966, 972}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{967, 972, 973}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{968, 967, 973}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{968, 973, 974}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{969, 968, 974}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{969, 974, 975}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{970, 969, 975}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{970, 975, 976}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{971, 970, 976}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{971, 976, 977}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{957, 46, 45}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{957, 45, 958}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{972, 957, 959}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{972, 959, 978}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{973, 972, 978}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{973, 978, 979}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{974, 973, 979}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{974, 979, 980}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{975, 974, 980}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{975, 980, 981}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{976, 975, 981}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{976, 981, 982}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{983, 976, 982}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{977, 976, 983}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{984, 977, 983}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{985, 984, 983}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{985, 983, 982}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{985, 982, 986}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{985, 986, 987}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{988, 985, 987}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{989, 988, 987}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{961, 960, 989}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{961, 989, 987}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{958, 990, 991}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{959, 958, 991}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{978, 959, 991}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{979, 978, 991}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{980, 979, 991}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{980, 991, 992}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{981, 980, 992}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{982, 981, 992}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{982, 992, 993}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{986, 982, 993}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{986, 993, 994}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{987, 986, 994}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{990, 995, 996}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{991, 990, 996}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{992, 991, 996}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{992, 996, 997}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{993, 992, 997}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{993, 997, 998}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{993, 998, 999}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{994, 993, 999}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{996, 995, 1000}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{997, 996, 1000}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{997, 1000, 1001}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{998, 997, 1001}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{998, 1001, 1002}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{999, 998, 1002}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{1001, 1000, 1003}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{1001, 1003, 1002}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{1004, 1, 5}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{1004, 5, 1005}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{1006, 4, 1}]}, 
     {RGBColor[0.03529411764705882, 0.03529411764705882, 0.03529411764705882],
       Polygon3DBox[{1006, 1, 1007}]}}]},
  Boxed->False,
  ImageSize->Medium,
  Lighting->"Neutral",
  ViewPoint->{2.8629883058180052`, 0.23956532751549303`, 1.7877098239372466`},
  
  ViewVertical->{0.09099201200843567, 0.27531983827770934`, 
   3.6580645459246557`}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1179685937]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1674195482],

Cell[TextData[{
 "Create a solid 3D object using ",
 Cell[BoxData[
  ButtonBox["SphericalPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalPlot3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1872722980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", 
    RowBox[{"z", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", " ", "False"}], ",", 
   RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Axes", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"ImageSize", " ", "\[Rule]", " ", "Small"}], ",", " ", 
   RowBox[{"ColorFunction", " ", "\[Rule]", " ", "\"\<RoseColors\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1334794428],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyNnT2SHUkVhYuBFWgHCMEKCNxMY0JIMx5LIAJnQhoINoCWwAg83HHHQjR4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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwt1Hdsj0EYwPF7f/erSsQmsSmJrfZqVQhiJWbsWSRirxgliFJi78SsxoiY
iRhRYu9NbH/RUtSoGq3R4vvkef74vDfeu3vvvXvuokZM6jUx5JxLgccdHiHL
v+HxGgvxBI8xivq6YefqYAz54RiNeAzgfW/0wkjKQzAMEbQNYxr5r7zLRhiL
cRLz8TFwrhkffks6g3bN0RBHqIvg/VHSSNLjpMdwFedxDoW8tpExA75TgH6R
OMu7VJzEZGs/BRcwDVNxChMwHkXoWxiHrf4STmOsjTNO5sc3MmQe6IMh6Ot1
ztMxC/X5h2g0wEqswmosxzKswFPa1SZ9IP9J2giNUSvQ+jrogp7oik58Iwlt
UYNyddQMNP+IMe4iAbMxB/dQlXc3SAeSDsegQOdcFEVQkX+tgCXkTyAR81CM
uqIoSL4UaUlsIP8Zn7AGKaxFNraiDOV4lPW6FxIDhTGU7/VF/0D3Tr4rY8Yy
p1aIwwz6X8dM7Jf9xgEsRCIWIQmLsUTi0+rn4bHTf39i/3vf6XqW8rp3F0O6
zs/w3PretrWS+NzrNJ6TrO98JGM3dmAntmG7xVJJr/HWBssQKzHJvwXwWEq5
NWJsTaR9CVlTyg3RIKRzq4jSiKY8F/UtnstRd83WQc7UGNvTy07Pzh/e/0aq
0xi+Zf+YIXGJd8jEe3yAZ99CaEr7aNJ6cm7JO9K/Xs/XI9KHElPkb9AnAbOw
AWlYjVdYh1X4jCx8QQs7pzFyri0evoV0fyUO5bvPGPspDpP/TvoNB2lTmznU
wlE5q3Jmccbp+MnYLOfVztQkp/+4Ceuxxf5xo5xRW58rTtufw0Ucsv3d5/Se
kbMjcZ6PPK9j5smckIOf+Itf1lf2VOZcmbQSqgR6v63FIDT2uuYv0Y58e3Tw
Oo7Ezx6n99mbQO+0NDSl/DrQPWpC23TSfpS7oQfKswblkCp3qHwPvbHAzqbc
w7LOsV73NyPQe1PGb0FdS8R4zWdZPMjZl//653Sev6jLQR46Us4lTSdNs/l/
kb52h1dmLpXQ2ev9I+0lHw70nMreleB98bDegVJfCBF4Qfm5nHe5p3hfQ+7W
QNcjw+acifRA12Sn7cUuvKLfS4l15hZFvyrIl5jjXS6ysd7u3sFex0izcX5I
DCFL7hivaxWH8l7Py82Qrm2u7XUy+U3YjC1IwVaMsHNaweuYskc5Fg9yh1xH
d7mX0RlRgd631QKNK7n38p3uncRGG6/7n2nzlLnNljok2N41wn+tf/qg
         "]], Polygon3DBox[CompressedData["
1:eJxNmHuQV2UZx3/nnJ+BEpMDEi4gsFyXVG6SGIIkQoCr6EqYCyXgFmgBXpAE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         "]], Polygon3DBox[CompressedData["
1:eJwt089LVFEUwPH73mtoERZUQgUVtquFGWajb5pymKKiXaJg5o9RTBCqVTWO
NUMTM5SWs5CgX/g7osSF5MIKIsqgQKl/oBZJLUrTftC4qOx7uGfx4b45755z
z73vTlHzmWOnXWNMOQK44xgzjzl8xg2MEl/GPyzhHmaJf8FX3EIvfhH/g794
gGFj86XOJ3xATp/3sGgQJa6N72TcjTJ85Pd7VHrGHEAUv4kvYpyaK3gXcGxP
0pvMlZxZ7eMaFphbTp7v2TqSK/2W6Tq+a3vPMx7i/WFE8JPfFYwdiCOpNWRP
HvMdjOn+5F0al3QNX2uEEcIP19bLoRtdqEQEUfKzyCCFMKrIqUUd1qJA1iee
xmVE4KOP/G96HnIu/a6t0YkEQlqvDQ/1jOSbxZQ8j0gd1Ol3kv3cRwsaUcja
J1CPaqzGI9aZxGO0oxWn8ARPMYGT+izz12ClZ+MBxlW6J6khtQp0n+vwTGuH
9F7I/ZjTu/iafqYxY+x5xHEXQ9q79FuLs3iOF8bmxPVs3+Et3ugZyfgKU+jQ
WF6/1XcMYBD7cBVX0IP9eIn1nj0f2aPs9Sg9DmIAt3EQG7EFW7V/6Wkz85vR
omdbqPclgyxSenduktOHfhxB1LE9b2MswibH9i//gRiacFz/D1KjEwns1XoZ
3nWhG0GUYBd9J+XeII4dqCHegEbH3nW58+eJX8BFFGO7a+9nE2LYoN+wgvk9
uI4sSmUt8s/pd0jq3f0PWmyOGw==
         "]], Polygon3DBox[CompressedData["
1:eJxF01mIjlEYAODvXxglxnaBGQwKY+xLiDtkubCMLENKKImsUdxZhltrWZKS
UkJJZBQzluxrWe+sY6sZ+zrkOZ2vXDx95z/Le97/nPd0nru0fEk2SZJ+NKYh
lyS/qdKupoal1PGVb3zhAPu4xEXOhvX5JGnESu1dgtbyhnrq2E2Z8Z6cMOc4
h1nIhEySTGcG02hI93rMI+5xl0o201qObWlHey6LXc0NivwupgNtuKAvI2YB
TXii7zHHxPlpbKT2aJ7zjF/6SuXYg2bmNyWfiTmvMXaN6+le51nBemO3uM19
HrCRQxxN4l6PxH7IfO2D/Aj7850P7KfeeB1b2EoF5YQ7SuTT32cIQ9Gd/GWm
3GZRQXkmxvxo8EO6dgpNyVPIVKbRUrwWNNGebc28JOb2wO/7dA/xff/kYg2s
YnUSc1gbziKJd50XI8dg7Y6+HdhsTSVjGUdPeZXSlS7cSe90rPZEJmViDYQa
q2eUNevYwEtepHd001gn80roRvfM/zMP7R70oS8P9Q3w7U9ZJuYQaulJOB8H
+on3vGUPe+kt9175WJMLmEMZw+09gsEM4l269jUD/R7AMIbmYs2HmGHOC56z
g51s4xlP07XhjWxntnXb2UFr+7fKxzsq8e2Uj2c4hgZz/1Csr4gqfafZlItn
XpONb+EKV1nNcqo4l76RMGcZi7Kx9kLNTGEy4/mob0T4z0m806x9MhRof7bH
p7SWGnFcjCOcpCAXa6nQ3OYc07cyfSPhDV7kDIvDezHvFCep5VV61/8A3ouW
3g==
         "]]}]}, 
     {EdgeForm[None], 
      GraphicsGroup3DBox[{
        Polygon3DBox[{{954, 972, 958}, {683, 685, 769}, {51, 54, 52}, {770, 
         688, 687}, {47, 50, 48}, {838, 843, 906}, {178, 180, 182}, {187, 190,
          188}, {183, 186, 184}, {960, 918, 917}, {842, 907, 846}, {109, 112, 
         110}, {181, 176, 175}, {910, 856, 855}, {107, 102, 101}, {849, 852, 
         909}, {104, 106, 108}, {911, 914, 959}, {766, 845, 768}, {771, 774, 
         847}, {900, 905, 956}, {951, 955, 971}, {1, 4, 1023}, {5, 8, 1075}, {
         763, 767, 844}, {904, 957, 908}, {271, 266, 265}, {113, 116, 114}, {
         42, 44, 46}, {848, 778, 777}, {268, 270, 272}, {45, 41, 40}}], 
        Polygon3DBox[CompressedData["
1:eJxNl3tsj1cYx9/392uaMSsdSoqyTdmoBDWXba5bXBpskc7EiqzRhQo66Sqh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         "]], 
        Polygon3DBox[{{52, 54, 62, 8, 5}, {1023, 4, 57, 50, 47}, {106, 172, 
         180, 178, 108}, {180, 262, 270, 268, 182}, {110, 112, 193, 186, 
         183}, {44, 98, 106, 104, 46}, {778, 848, 855, 856, 784}, {831, 838, 
         906, 905, 900}, {896, 954, 958, 957, 904}, {893, 900, 956, 955, 
         951}, {188, 190, 198, 116, 113}, {176, 181, 265, 266, 258}, {774, 
         780, 852, 849, 847}, {102, 107, 175, 176, 168}, {688, 770, 777, 778, 
         694}, {834, 904, 908, 907, 842}, {41, 45, 101, 102, 94}, {48, 50, 
         119, 112, 109}, {852, 858, 914, 911, 909}, {757, 763, 844, 843, 
         838}, {114, 116, 124, 54, 51}, {856, 910, 917, 918, 862}, {760, 842, 
         846, 845, 766}, {685, 690, 774, 771, 769}}]}]}, {}, {}, {}}, {{
      Line3DBox[{2, 973, 974, 975, 976, 977, 978, 979, 980, 981, 982, 983, 
       984, 985, 986, 987, 988, 989, 990, 991, 992, 993, 994, 995, 996, 997, 
       998, 999, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 
       1010, 1011, 1012, 1013, 1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021,
        1022, 1024, 2}], 
      Line3DBox[{6, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 
       1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045,
        1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 
       1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068,
        1069, 1070, 1071, 1072, 1073, 1074, 1076, 6}]}, {
      Line3DBox[{1, 1023, 47, 48, 109, 110, 183, 184, 273, 363, 445, 527, 605,
        683, 769, 771, 847, 849, 909, 911, 959, 961, 963, 965, 967, 969, 971, 
       955, 956, 905, 906, 843, 844, 767, 681, 603, 525, 443, 361, 271, 265, 
       181, 175, 107, 101, 45, 40, 34, 28, 22, 16, 10, 1}], 
      Line3DBox[{5, 1075, 12, 18, 24, 30, 36, 42, 46, 104, 108, 178, 182, 268,
        272, 362, 444, 526, 604, 682, 768, 845, 846, 907, 908, 957, 958, 972, 
       970, 968, 966, 964, 962, 960, 917, 910, 855, 848, 777, 770, 687, 609, 
       531, 449, 367, 277, 187, 188, 113, 114, 51, 52, 5}]}}},
   VertexColors->CompressedData["
1:eJztXPlXVFcSBlQCyiZEjBlkCUtwIg5uEaRJCSKDYTEaMGhwQMQtKkEQMBgE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    "],
   VertexNormals->CompressedData["
1:eJztXXl0VkWyZ3FjixIYVEYhKqsgIkIQE2gYnFERUEAREGQLS1gVCJvKKoQd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    "]],
  BoxRatios->{1, 1, 1},
  Boxed->False,
  ImageSize->Small,
  Lighting->"Neutral",
  PlotRange->{{-2, 2}, {-2, 2}, {-2, 2}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{2.6919530838373302`, -0.8890155155268, 1.8474414760882971`},
  ViewVertical->{0.2837096776153635, 0.41037996566603285`, 
   0.866658584799881}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1257916766]
}, Open  ]],

Cell["Export it to 3DS:", "ExampleText",
 CellID->843962209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<cones.3ds\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1470903390],

Cell[BoxData["\<\"cones.3ds\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1011758165]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->674089440],

Cell[TextData[{
 "An ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " example using inline 3D graphics:"
}], "ExampleText",
 CellID->1444980155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<spikey.3ds\>\"", ",", 
   Graphics3DBox[
    GraphicsComplex3DBox[
     NCache[{{0, 0, Root[5 - 20 #^2 + 16 #^4& , 1, 0]}, {
       0, 0, Root[5 - 20 #^2 + 16 #^4& , 4, 0]}, {
       Root[1 - 5 #^2 + 5 #^4& , 1, 0], 0, Root[
        1 - 20 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 5 #^2 + 5 #^4& , 4, 0], 0, Root[
        1 - 20 #^2 + 80 #^4& , 4, 0]}, {
       Root[1 - 40 #^2 + 80 #^4& , 1, 0], Rational[-1, 2], Root[
        1 - 20 #^2 + 80 #^4& , 4, 0]}, {
       Root[1 - 40 #^2 + 80 #^4& , 1, 0], Rational[1, 2], Root[
        1 - 20 #^2 + 80 #^4& , 4, 0]}, {
       Root[1 - 40 #^2 + 80 #^4& , 4, 0], Rational[-1, 2], Root[
        1 - 20 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 40 #^2 + 80 #^4& , 4, 0], Rational[1, 2], Root[
        1 - 20 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 4, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 4, 0]}, {
       Root[1 - 290 #^2 + 2555 #^4 - 5850 #^6 + 2025 #^8& , 1, 0], 0, Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
       Root[1 - 290 #^2 + 2555 #^4 - 5850 #^6 + 2025 #^8& , 8, 0], 0, Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
       Root[1 - 740 #^2 + 3230 #^4 - 4500 #^6 + 2025 #^8& , 1, 0], 0, Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
       Root[1 - 740 #^2 + 3230 #^4 - 4500 #^6 + 2025 #^8& , 8, 0], 0, Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
       Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0], Root[
        1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
       Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0], Root[
        1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
       Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0], Root[
        1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
       Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0], Root[
        1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
       Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0], 
        Root[1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
       Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0], 
        Root[1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
       Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0], 
        Root[1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
       Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0], 
        Root[1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
       Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 1, 0], Root[
        1 + 44 # - 100 #^2 - 48 #^3 + 144 #^4& , 3, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
       Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 1, 0], Root[
        1 - 44 # - 100 #^2 + 48 #^3 + 144 #^4& , 2, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
       Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 8, 0], Root[
        1 + 44 # - 100 #^2 - 48 #^3 + 144 #^4& , 3, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
       Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 8, 0], Root[
        1 - 44 # - 100 #^2 + 48 #^3 + 144 #^4& , 2, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
       Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 1, 0], Root[
        1 + 16 # - 40 #^2 - 192 #^3 + 144 #^4& , 4, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
       Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 1, 0], Root[
        1 - 16 # - 40 #^2 + 192 #^3 + 144 #^4& , 1, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
       Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 8, 0], Root[
        1 + 16 # - 40 #^2 - 192 #^3 + 144 #^4& , 4, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
       Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 8, 0], Root[
        1 - 16 # - 40 #^2 + 192 #^3 + 144 #^4& , 1, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}}, {{
       0, 0, -0.9510565162951532}, {
       0, 0, 0.9510565162951536}, {-0.8506508083520394, 
        0, -0.4253254041760197}, {
       0.85065080835204, 0, 0.42532540417602}, {-0.6881909602355868, -0.5, 
       0.42532540417602}, {-0.6881909602355868, 0.5, 0.42532540417602}, {
       0.6881909602355868, -0.5, -0.4253254041760197}, {0.6881909602355868, 
       0.5, -0.4253254041760197}, {-0.2628655560595671, -0.8090169943749475, \
-0.4253254041760197}, {-0.2628655560595671, 
       0.8090169943749475, -0.4253254041760197}, {
       0.2628655560595668, -0.8090169943749475, 0.42532540417602}, {
       0.2628655560595668, 0.8090169943749475, 
       0.42532540417602}, {-1.5443455162844653`, 0, 0.29494374842358073`}, {
       1.5443455162844653`, 0, -0.29494374842358073`}, {-0.9544580194373125, 
        0, 1.2494017678608846`}, {
       0.954458019437308, 0, -1.2494017678608846`}, {-1.2494017678608846`, 
       0.9077435189160142, -0.29494374842358073`}, {-1.2494017678608846`, \
-0.9077435189160141, -0.29494374842358073`}, {1.2494017678608846`, 
       0.9077435189160142, 0.29494374842358073`}, {
       1.2494017678608846`, -0.9077435189160141, 
       0.29494374842358073`}, {-0.29494374842358073`, 0.9077435189160142, 
       1.2494017678608846`}, {-0.29494374842358073`, -0.9077435189160141, 
       1.2494017678608846`}, {0.29494374842358073`, 
       0.9077435189160142, -1.2494017678608846`}, {
       0.29494374842358073`, -0.9077435189160141, -1.2494017678608846`}, \
{-0.7721727581422326, 
       0.5610163477575297, -1.2494017678608846`}, {-0.7721727581422326, \
-0.5610163477575298, -1.2494017678608846`}, {0.7721727581422326, 
       0.5610163477575297, 1.2494017678608846`}, {
       0.7721727581422326, -0.5610163477575298, 
       1.2494017678608846`}, {-0.4772290097186562, 1.468759866673544, 
       0.29494374842358073`}, {-0.4772290097186562, -1.468759866673544, 
       0.29494374842358073`}, {0.477229009718654, 
       1.468759866673544, -0.29494374842358073`}, {
       0.477229009718654, -1.468759866673544, -0.29494374842358073`}}], 
     Polygon3DBox[{{21, 2, 12}, {21, 12, 6}, {21, 6, 2}, {15, 2, 6}, {15, 6, 
      5}, {15, 5, 2}, {22, 2, 5}, {22, 5, 11}, {22, 11, 2}, {28, 2, 11}, {28, 
      11, 4}, {28, 4, 2}, {27, 2, 4}, {27, 4, 12}, {27, 12, 2}, {24, 7, 9}, {
      24, 9, 1}, {24, 1, 7}, {16, 8, 7}, {16, 7, 1}, {16, 1, 8}, {23, 10, 
      8}, {23, 8, 1}, {23, 1, 10}, {25, 3, 10}, {25, 10, 1}, {25, 1, 3}, {26, 
      9, 3}, {26, 3, 1}, {26, 1, 9}, {29, 12, 10}, {29, 10, 6}, {29, 6, 12}, {
      13, 6, 3}, {13, 3, 5}, {13, 5, 6}, {30, 5, 9}, {30, 9, 11}, {30, 11, 
      5}, {20, 11, 7}, {20, 7, 4}, {20, 4, 11}, {19, 4, 8}, {19, 8, 12}, {19, 
      12, 4}, {32, 7, 11}, {32, 11, 9}, {32, 9, 7}, {14, 8, 4}, {14, 4, 7}, {
      14, 7, 8}, {31, 10, 12}, {31, 12, 8}, {31, 8, 10}, {17, 3, 6}, {17, 6, 
      10}, {17, 10, 3}, {18, 9, 5}, {18, 5, 3}, {18, 3, 9}}]],
    Boxed->False,
    ImageSize->{99.83940242220801, 100.},
    ViewPoint->{0.0030124698202508293`, -2.8066412788513992`, 
     1.8901734462405728`},
    ViewVertical->{-0.28104140417203943`, -0.07172101959684306, 
     1.183248966211339}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->355229611],

Cell[BoxData["\<\"spikey.3ds\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->641231799]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"3DS - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 43.6350824}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME types: application/x-3ds, image/x-3ds Autodesk 3DS file format. \
Scene description and 3D modeling format. Used for 3D modeling and animation. \
Native format of Autodesk 3D Studio. Binary file format. Stores 3D objects \
together with lighting and viewpoint information.", "synonyms" -> {}, "title" -> 
    "3DS", "type" -> "Format", "uri" -> "ref/format/3DS"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[22401, 795, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 736857, 13149}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2205, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2828, 74, 101, 4, 70, "ObjectNameAlt",
 CellID->5045],
Cell[2932, 80, 405, 10, 70, "FormatUsage",
 CellID->20778],
Cell[3340, 92, 226, 7, 70, "FormatNotes",
 CellID->5821],
Cell[3569, 101, 750, 27, 70, "FormatNotes",
 CellID->1150224632]
}, Open  ]],
Cell[CellGroupData[{
Cell[4356, 133, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[4423, 136, 400, 14, 70, "FormatNotes",
 CellID->2520],
Cell[4826, 152, 459, 16, 70, "FormatNotes",
 CellID->12927],
Cell[5288, 170, 39, 1, 70, "WeakDivider",
 CellID->24773],
Cell[5330, 173, 741, 25, 70, "FormatNotes",
 CellID->25134],
Cell[6074, 200, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[6116, 203, 341, 11, 70, "FormatNotes",
 CellID->22675],
Cell[6460, 216, 574, 20, 70, "FormatNotes",
 CellID->13336],
Cell[7037, 238, 582, 21, 70, "FormatNotes",
 CellID->16334],
Cell[7622, 261, 689, 24, 70, "FormatNotes",
 CellID->21001],
Cell[8314, 287, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[8355, 290, 513, 18, 70, "FormatNotes",
 CellID->9310],
Cell[8871, 310, 1075, 40, 70, "FormatNotes",
 CellID->5974],
Cell[9949, 352, 661, 22, 70, "FormatNotes",
 CellID->7590],
Cell[10613, 376, 816, 28, 70, "FormatNotes",
 CellID->20356],
Cell[11432, 406, 747, 26, 70, "FormatNotes",
 CellID->111068952],
Cell[12182, 434, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[12223, 437, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[12587, 453, 352, 14, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[12976, 472, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[13030, 475, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[13225, 485, 710, 14, 70, "2ColumnTableMod",
 CellID->1825],
Cell[13938, 501, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[13980, 504, 68, 1, 70, "FormatNotes",
 CellID->13573],
Cell[14051, 507, 1649, 40, 70, "2ColumnTableMod",
 CellID->961108812],
Cell[15703, 549, 397, 14, 70, "FormatNotes",
 CellID->13037],
Cell[16103, 565, 304, 10, 70, "FormatNotes",
 CellID->4998],
Cell[16410, 577, 435, 16, 70, "FormatNotes",
 CellID->1495251562]
}, Open  ]],
Cell[CellGroupData[{
Cell[16882, 598, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[16934, 601, 196, 8, 70, "FormatNotes",
 CellID->1911960202],
Cell[17133, 611, 1155, 31, 70, "3ColumnTableMod",
 CellID->2123520593],
Cell[18291, 644, 240, 8, 70, "FormatNotes",
 CellID->1022956994],
Cell[18534, 654, 55, 1, 70, "FormatNotes",
 CellID->19539],
Cell[18592, 657, 468, 12, 70, "3ColumnTableMod",
 CellID->28047],
Cell[19063, 671, 232, 7, 70, "FormatNotes",
 CellID->1642809193],
Cell[19298, 680, 759, 26, 70, "FormatNotes",
 CellID->182941150]
}, Closed]],
Cell[CellGroupData[{
Cell[20094, 711, 50, 1, 70, "SeeAlsoSection",
 CellID->20829],
Cell[20147, 714, 1834, 62, 70, "SeeAlso",
 CellID->2645]
}, Open  ]],
Cell[CellGroupData[{
Cell[22018, 781, 57, 1, 70, "MoreAboutSection",
 CellID->33817001],
Cell[22078, 784, 150, 2, 70, "MoreAbout"],
Cell[22231, 788, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22401, 795, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[22517, 801, 60, 1, 70, "ExampleSection",
 CellID->538294639],
Cell[22580, 804, 94, 1, 70, "ExampleText",
 CellID->2041162356],
Cell[CellGroupData[{
Cell[22699, 809, 178, 5, 70, "Input",
 CellID->1982064839],
Cell[22880, 816, 283, 7, 70, "Output",
 CellID->1911940114]
}, Open  ]],
Cell[23178, 826, 96, 1, 70, "ExampleText",
 CellID->1839488447],
Cell[CellGroupData[{
Cell[23299, 831, 208, 5, 70, "Input",
 CellID->17199],
Cell[23510, 838, 673121, 11577, 70, "Output",
 CellID->1179685937]
}, Open  ]],
Cell[696646, 12418, 126, 3, 70, "ExampleDelimiter",
 CellID->1674195482],
Cell[696775, 12423, 229, 8, 70, "ExampleText",
 CellID->1872722980],
Cell[CellGroupData[{
Cell[697029, 12435, 844, 24, 70, "Input",
 CellID->1334794428],
Cell[697876, 12461, 28344, 476, 70, "Output",
 CellID->1257916766]
}, Open  ]],
Cell[726235, 12940, 60, 1, 70, "ExampleText",
 CellID->843962209],
Cell[CellGroupData[{
Cell[726320, 12945, 142, 4, 70, "Input",
 CellID->1470903390],
Cell[726465, 12951, 88, 2, 70, "Output",
 CellID->1011758165]
}, Open  ]],
Cell[726568, 12956, 125, 3, 70, "ExampleDelimiter",
 CellID->674089440],
Cell[726696, 12961, 216, 8, 70, "ExampleText",
 CellID->1444980155],
Cell[CellGroupData[{
Cell[726937, 12973, 8601, 139, 70, "Input",
 CellID->355229611],
Cell[735541, 13114, 88, 2, 70, "Output",
 CellID->641231799]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[735668, 13121, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

