(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     69203,       1816]
NotebookOptionsPosition[     64433,       1667]
NotebookOutlinePosition[     65983,       1708]
CellTagsIndexPosition[     65897,       1703]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Importing & Exporting" :> 
         Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
         "Listing of All Formats" :> 
         Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
         "New in 6.0: Import & Export Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/NewIn60ImportAndExportFormats"], 
         "New in 6.0: Visualization & Graphics" :> 
         Documentation`HelpLookup[
          "paclet:guide/NewIn60VisualizationAndGraphics"], "Print Formats" :> 
         Documentation`HelpLookup["paclet:guide/PrintFormats"], 
         "Raster Image Formats" :> 
         Documentation`HelpLookup["paclet:guide/RasterImageFormats"], 
         "Systems & Utility Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/SystemsAndUtilityFormats"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Importing & Exporting\"\>", 
      2->"\<\"Listing of All Formats\"\>", 
      3->"\<\"New in 6.0: Import & Export Formats\"\>", 
      4->"\<\"New in 6.0: Visualization & Graphics\"\>", 
      5->"\<\"Print Formats\"\>", 6->"\<\"Raster Image Formats\"\>", 
      7->"\<\"Systems & Utility Formats\"\>"}, "\<\"more about\"\>", 
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "ACO ",
 StyleBox["(.aco)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->16827],

Cell["\<\
Adobe Photoshop color swatch format.
Used for storing color palettes.
Native format of the Adobe Photoshop image-editing application.
ACO is an acronym derived from Adobe Color.
Binary file format.
Stores color specifications and, in version 2 of the format, color names.
Represents color values using 16 bits per color channel.
Supports a variety of color spaces.\
\>", "FormatUsage",
 CellID->9961],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support versions 1 and 2 of the ACO file format."
}], "FormatNotes",
 CellID->491]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->2995],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).aco\>\"", "]"}]], "InlineFormula"],
 " imports an ACO file as a list of color primitives."
}], "FormatNotes",
 CellID->11942],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).aco\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a list of colors or color rules to ACO."
}], "FormatNotes",
 CellID->4827],

Cell["", "WeakDivider",
 CellID->5436],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).aco\>\"", "]"}], " "}]], "InlineFormula"],
 "reads an ACO file and returns a list of color primitives, using exact \
numbers to represent color coordinates."
}], "FormatNotes",
 CellID->1374697286],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).aco\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["col", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["col", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], " "}]], 
  "InlineFormula"],
 "exports a list of color primitives to ACO, using version 1 of the format."
}], "FormatNotes",
 CellID->1908211376],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).aco\>\"", ",", 
     RowBox[{
      StyleBox["{", "TI"], 
      RowBox[{
       StyleBox[
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"name\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", " ", "->", " ", 
         SubscriptBox[
          StyleBox["col", "TI"], 
          StyleBox["1", "TR"]]}], "TI"], 
       StyleBox[",", "TI"], 
       StyleBox[" ", "TI"], 
       StyleBox["\[Ellipsis]", "TR"]}], 
      StyleBox["}", "TI"]}]}], "]"}], " "}]], "InlineFormula"],
 "creates an ACO version 2 file from color rules."
}], "FormatNotes",
 CellID->14604],

Cell["", "WeakDivider",
 CellID->3902],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).aco\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "ACO",
 " file."
}], "FormatNotes",
 CellID->153],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).aco\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      StyleBox["sub", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->292],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).aco\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->12382],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<ACO\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<ACO\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->17421],

Cell["", "WeakDivider",
 CellID->18716],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).aco\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates an ",
 "ACO",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->19718],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).aco\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->19895],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).aco\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5447],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).aco\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->21726],

Cell["", "WeakDivider",
 CellID->14771],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->11538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "ACO",
 " format."
}], "FormatNotes",
 CellID->1869]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->19912],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->25667],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->26299],

Cell["", "WeakDivider",
 CellID->17035],

Cell["Data representation elements:", "FormatNotes",
 CellID->9894],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ColorList\>\"", Cell[
    "list of color primitives", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ColorRules\>\"", Cell[
    "rules for named colors", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ColorSetters\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["ColorSetter",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorSetter"]], "InlineFormula"],
     " objects"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->146182287],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<ColorList\>\""], "InlineFormula"],
 " element."
}], "FormatNotes",
 CellID->812283704]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->159661309],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout"],

Cell[TextData[ButtonBox["Print Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrintFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Systems & Utility Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemsAndUtilityFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->45263138],

Cell["\<\
Read an ACO file that contains a palette of the 206 web-safe colors, and show \
the first few:\
\>", "ExampleText",
 CellID->40824672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"Import", "[", " ", "\"\<ExampleData/websafe.aco\>\"", "]"}], ",", 
   "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->945035723],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RGBColor", "[", 
    RowBox[{"1", ",", "1", ",", "1"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"1", ",", "1", ",", 
     FractionBox["4", "5"]}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"1", ",", "1", ",", 
     FractionBox["3", "5"]}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"1", ",", "1", ",", 
     FractionBox["2", "5"]}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"1", ",", "1", ",", 
     FractionBox["1", "5"]}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->426343249]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1545539551],

Cell[TextData[{
 "Import the same file as a list of ",
 Cell[BoxData[
  ButtonBox["ColorSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSetter"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->56526661],

Cell[BoxData[
 RowBox[{
  RowBox[{"cs", " ", "=", " ", 
   RowBox[{"Import", "[", " ", 
    RowBox[{
    "\"\<ExampleData/websafe.aco\>\"", ",", " ", "\"\<ColorSetters\>\""}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1932235877],

Cell[TextData[{
 "Show all ",
 Cell[BoxData[
  ButtonBox["ColorSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSetter"]], "InlineFormula"],
 " objects arranged in a grid:"
}], "ExampleText",
 CellID->121440739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Partition", "[", " ", 
   RowBox[{"cs", ",", " ", "18"}], "]"}], " ", "//", " ", 
  "GraphicsGrid"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->840674805],

Cell[BoxData[
 GraphicsBox[{{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{InsetBox[
      ColorSetterBox[RGBColor[1, 1, 1], 
       "Swatch"], {197.05263157894737`, -196.6153846153846}, {
      Center, Center}, {360.00000000000006`, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 1, 
        Rational[4, 5]], "Swatch"], {591.1578947368421, -196.6153846153846}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 1, 
        Rational[3, 5]], "Swatch"], {985.2631578947369, -196.6153846153846}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 1, 
        Rational[2, 5]], 
       "Swatch"], {1379.3684210526317`, -196.6153846153846}, {
      Center, Center}, {360.0000000000002, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 1, 
        Rational[1, 5]], 
       "Swatch"], {1773.4736842105262`, -196.6153846153846}, {
      Center, Center}, {360.0000000000002, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 1, 0], 
       "Swatch"], {2167.578947368421, -196.6153846153846}, {
      Center, Center}, {359.9999999999998, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[4, 5], 1], 
       "Swatch"], {2561.684210526316, -196.6153846153846}, {
      Center, Center}, {359.99999999999955`, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[4, 5], 
        Rational[4, 5]], "Swatch"], {2955.78947368421, -196.6153846153846}, {
      Center, Center}, {359.99999999999955`, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[4, 5], 
        Rational[3, 5]], "Swatch"], {3349.894736842105, -196.6153846153846}, {
      Center, Center}, {359.99999999999955`, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[4, 5], 
        Rational[2, 5]], "Swatch"], {3743.999999999999, -196.6153846153846}, {
      Center, Center}, {359.99999999999955`, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[4, 5], 
        Rational[1, 5]], "Swatch"], {4138.105263157894, -196.6153846153846}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[4, 5], 0], 
       "Swatch"], {4532.210526315789, -196.6153846153846}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[3, 5], 1], 
       "Swatch"], {4926.315789473684, -196.6153846153846}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[3, 5], 
        Rational[4, 5]], "Swatch"], {5320.421052631579, -196.6153846153846}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[3, 5], 
        Rational[3, 5]], "Swatch"], {5714.526315789474, -196.6153846153846}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[3, 5], 
        Rational[2, 5]], "Swatch"], {6108.631578947369, -196.6153846153846}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[3, 5], 
        Rational[1, 5]], "Swatch"], {6502.736842105264, -196.6153846153846}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[3, 5], 0], 
       "Swatch"], {6896.842105263159, -196.6153846153846}, {
      Center, Center}, {360., 359.99999999999994`}]}, {InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[2, 5], 1], 
       "Swatch"], {197.05263157894737`, -589.8461538461538}, {
      Center, Center}, {360.00000000000006`, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[2, 5], 
        Rational[4, 5]], "Swatch"], {591.1578947368421, -589.8461538461538}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[2, 5], 
        Rational[3, 5]], "Swatch"], {985.2631578947369, -589.8461538461538}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[2, 5], 
        Rational[2, 5]], 
       "Swatch"], {1379.3684210526317`, -589.8461538461538}, {
      Center, Center}, {360.0000000000002, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[2, 5], 
        Rational[1, 5]], 
       "Swatch"], {1773.4736842105262`, -589.8461538461538}, {
      Center, Center}, {360.0000000000002, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[2, 5], 0], 
       "Swatch"], {2167.578947368421, -589.8461538461538}, {
      Center, Center}, {359.9999999999998, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[1, 5], 1], 
       "Swatch"], {2561.684210526316, -589.8461538461538}, {
      Center, Center}, {359.99999999999955`, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[1, 5], 
        Rational[4, 5]], "Swatch"], {2955.78947368421, -589.8461538461538}, {
      Center, Center}, {359.99999999999955`, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[1, 5], 
        Rational[3, 5]], "Swatch"], {3349.894736842105, -589.8461538461538}, {
      Center, Center}, {359.99999999999955`, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[1, 5], 
        Rational[2, 5]], "Swatch"], {3743.999999999999, -589.8461538461538}, {
      Center, Center}, {359.99999999999955`, 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[1, 5], 
        Rational[1, 5]], "Swatch"], {4138.105263157894, -589.8461538461538}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 
        Rational[1, 5], 0], 
       "Swatch"], {4532.210526315789, -589.8461538461538}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 0, 1], 
       "Swatch"], {4926.315789473684, -589.8461538461538}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 0, 
        Rational[4, 5]], "Swatch"], {5320.421052631579, -589.8461538461538}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 0, 
        Rational[3, 5]], "Swatch"], {5714.526315789474, -589.8461538461538}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 0, 
        Rational[2, 5]], "Swatch"], {6108.631578947369, -589.8461538461538}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 0, 
        Rational[1, 5]], "Swatch"], {6502.736842105264, -589.8461538461538}, {
      Center, Center}, {360., 359.99999999999994`}], InsetBox[
      ColorSetterBox[RGBColor[1, 0, 0], 
       "Swatch"], {6896.842105263159, -589.8461538461538}, {
      Center, Center}, {360., 359.99999999999994`}]}, {InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 1, 1], 
       "Swatch"], {197.05263157894737`, -983.0769230769231}, {
      Center, Center}, {360.00000000000006`, 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 1, 
        Rational[4, 5]], "Swatch"], {591.1578947368421, -983.0769230769231}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 1, 
        Rational[3, 5]], "Swatch"], {985.2631578947369, -983.0769230769231}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 1, 
        Rational[2, 5]], 
       "Swatch"], {1379.3684210526317`, -983.0769230769231}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 1, 
        Rational[1, 5]], 
       "Swatch"], {1773.4736842105262`, -983.0769230769231}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 1, 0], 
       "Swatch"], {2167.578947368421, -983.0769230769231}, {
      Center, Center}, {359.9999999999998, 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[4, 5], 1], 
       "Swatch"], {2561.684210526316, -983.0769230769231}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[4, 5], 
        Rational[4, 5]], "Swatch"], {2955.78947368421, -983.0769230769231}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[4, 5], 
        Rational[3, 5]], "Swatch"], {3349.894736842105, -983.0769230769231}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[4, 5], 
        Rational[2, 5]], "Swatch"], {3743.999999999999, -983.0769230769231}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[4, 5], 
        Rational[1, 5]], "Swatch"], {4138.105263157894, -983.0769230769231}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[4, 5], 0], 
       "Swatch"], {4532.210526315789, -983.0769230769231}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[3, 5], 1], 
       "Swatch"], {4926.315789473684, -983.0769230769231}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[3, 5], 
        Rational[4, 5]], "Swatch"], {5320.421052631579, -983.0769230769231}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[3, 5], 
        Rational[3, 5]], "Swatch"], {5714.526315789474, -983.0769230769231}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[3, 5], 
        Rational[2, 5]], "Swatch"], {6108.631578947369, -983.0769230769231}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[3, 5], 
        Rational[1, 5]], "Swatch"], {6502.736842105264, -983.0769230769231}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[3, 5], 0], 
       "Swatch"], {6896.842105263159, -983.0769230769231}, {
      Center, Center}, {360., 360.}]}, {InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[2, 5], 1], 
       "Swatch"], {197.05263157894737`, -1376.3076923076924`}, {
      Center, Center}, {360.00000000000006`, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[2, 5], 
        Rational[4, 5]], 
       "Swatch"], {591.1578947368421, -1376.3076923076924`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[2, 5], 
        Rational[3, 5]], 
       "Swatch"], {985.2631578947369, -1376.3076923076924`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[2, 5], 
        Rational[2, 5]], 
       "Swatch"], {1379.3684210526317`, -1376.3076923076924`}, {
      Center, Center}, {360.0000000000002, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[2, 5], 
        Rational[1, 5]], 
       "Swatch"], {1773.4736842105262`, -1376.3076923076924`}, {
      Center, Center}, {360.0000000000002, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[2, 5], 0], 
       "Swatch"], {2167.578947368421, -1376.3076923076924`}, {
      Center, Center}, {359.9999999999998, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[1, 5], 1], 
       "Swatch"], {2561.684210526316, -1376.3076923076924`}, {
      Center, Center}, {359.99999999999955`, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[1, 5], 
        Rational[4, 5]], 
       "Swatch"], {2955.78947368421, -1376.3076923076924`}, {
      Center, Center}, {359.99999999999955`, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[1, 5], 
        Rational[3, 5]], 
       "Swatch"], {3349.894736842105, -1376.3076923076924`}, {
      Center, Center}, {359.99999999999955`, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[1, 5], 
        Rational[2, 5]], 
       "Swatch"], {3743.999999999999, -1376.3076923076924`}, {
      Center, Center}, {359.99999999999955`, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[1, 5], 
        Rational[1, 5]], 
       "Swatch"], {4138.105263157894, -1376.3076923076924`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 
        Rational[1, 5], 0], 
       "Swatch"], {4532.210526315789, -1376.3076923076924`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 0, 1], 
       "Swatch"], {4926.315789473684, -1376.3076923076924`}, {Center, Center},
       {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 0, 
        Rational[4, 5]], 
       "Swatch"], {5320.421052631579, -1376.3076923076924`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 0, 
        Rational[3, 5]], 
       "Swatch"], {5714.526315789474, -1376.3076923076924`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 0, 
        Rational[2, 5]], 
       "Swatch"], {6108.631578947369, -1376.3076923076924`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 0, 
        Rational[1, 5]], 
       "Swatch"], {6502.736842105264, -1376.3076923076924`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[4, 5], 0, 0], 
       "Swatch"], {6896.842105263159, -1376.3076923076924`}, {
      Center, Center}, {360., 360.0000000000002}]}, {InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 1, 1], 
       "Swatch"], {197.05263157894737`, -1769.5384615384614`}, {
      Center, Center}, {360.00000000000006`, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 1, 
        Rational[4, 5]], 
       "Swatch"], {591.1578947368421, -1769.5384615384614`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 1, 
        Rational[3, 5]], 
       "Swatch"], {985.2631578947369, -1769.5384615384614`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 1, 
        Rational[2, 5]], 
       "Swatch"], {1379.3684210526317`, -1769.5384615384614`}, {
      Center, Center}, {360.0000000000002, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 1, 
        Rational[1, 5]], 
       "Swatch"], {1773.4736842105262`, -1769.5384615384614`}, {
      Center, Center}, {360.0000000000002, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 1, 0], 
       "Swatch"], {2167.578947368421, -1769.5384615384614`}, {
      Center, Center}, {359.9999999999998, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[4, 5], 1], 
       "Swatch"], {2561.684210526316, -1769.5384615384614`}, {
      Center, Center}, {359.99999999999955`, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[4, 5], 
        Rational[4, 5]], 
       "Swatch"], {2955.78947368421, -1769.5384615384614`}, {
      Center, Center}, {359.99999999999955`, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[4, 5], 
        Rational[3, 5]], 
       "Swatch"], {3349.894736842105, -1769.5384615384614`}, {
      Center, Center}, {359.99999999999955`, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[4, 5], 
        Rational[2, 5]], 
       "Swatch"], {3743.999999999999, -1769.5384615384614`}, {
      Center, Center}, {359.99999999999955`, 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[4, 5], 
        Rational[1, 5]], 
       "Swatch"], {4138.105263157894, -1769.5384615384614`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[4, 5], 0], 
       "Swatch"], {4532.210526315789, -1769.5384615384614`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[3, 5], 1], 
       "Swatch"], {4926.315789473684, -1769.5384615384614`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[3, 5], 
        Rational[4, 5]], 
       "Swatch"], {5320.421052631579, -1769.5384615384614`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[3, 5], 
        Rational[3, 5]], 
       "Swatch"], {5714.526315789474, -1769.5384615384614`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[3, 5], 
        Rational[2, 5]], 
       "Swatch"], {6108.631578947369, -1769.5384615384614`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[3, 5], 
        Rational[1, 5]], 
       "Swatch"], {6502.736842105264, -1769.5384615384614`}, {
      Center, Center}, {360., 360.0000000000002}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[3, 5], 0], 
       "Swatch"], {6896.842105263159, -1769.5384615384614`}, {
      Center, Center}, {360., 360.0000000000002}]}, {InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[2, 5], 1], 
       "Swatch"], {197.05263157894737`, -2162.7692307692305`}, {
      Center, Center}, {360.00000000000006`, 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[2, 5], 
        Rational[4, 5]], 
       "Swatch"], {591.1578947368421, -2162.7692307692305`}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[2, 5], 
        Rational[3, 5]], 
       "Swatch"], {985.2631578947369, -2162.7692307692305`}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[2, 5], 
        Rational[2, 5]], 
       "Swatch"], {1379.3684210526317`, -2162.7692307692305`}, {
      Center, Center}, {360.0000000000002, 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[2, 5], 
        Rational[1, 5]], 
       "Swatch"], {1773.4736842105262`, -2162.7692307692305`}, {
      Center, Center}, {360.0000000000002, 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[2, 5], 0], 
       "Swatch"], {2167.578947368421, -2162.7692307692305`}, {
      Center, Center}, {359.9999999999998, 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[1, 5], 1], 
       "Swatch"], {2561.684210526316, -2162.7692307692305`}, {
      Center, Center}, {359.99999999999955`, 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[1, 5], 
        Rational[4, 5]], 
       "Swatch"], {2955.78947368421, -2162.7692307692305`}, {
      Center, Center}, {359.99999999999955`, 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[1, 5], 
        Rational[3, 5]], 
       "Swatch"], {3349.894736842105, -2162.7692307692305`}, {
      Center, Center}, {359.99999999999955`, 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[1, 5], 
        Rational[2, 5]], 
       "Swatch"], {3743.999999999999, -2162.7692307692305`}, {
      Center, Center}, {359.99999999999955`, 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[1, 5], 
        Rational[1, 5]], 
       "Swatch"], {4138.105263157894, -2162.7692307692305`}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 
        Rational[1, 5], 0], 
       "Swatch"], {4532.210526315789, -2162.7692307692305`}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 0, 1], 
       "Swatch"], {4926.315789473684, -2162.7692307692305`}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 0, 
        Rational[4, 5]], 
       "Swatch"], {5320.421052631579, -2162.7692307692305`}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 0, 
        Rational[3, 5]], 
       "Swatch"], {5714.526315789474, -2162.7692307692305`}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 0, 
        Rational[2, 5]], 
       "Swatch"], {6108.631578947369, -2162.7692307692305`}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 0, 
        Rational[1, 5]], 
       "Swatch"], {6502.736842105264, -2162.7692307692305`}, {
      Center, Center}, {360., 359.9999999999998}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[3, 5], 0, 0], 
       "Swatch"], {6896.842105263159, -2162.7692307692305`}, {
      Center, Center}, {360., 359.9999999999998}]}, {InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 1, 1], "Swatch"], {197.05263157894737`, -2556.}, {
      Center, Center}, {360.00000000000006`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 1, 
        Rational[4, 5]], "Swatch"], {591.1578947368421, -2556.}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 1, 
        Rational[3, 5]], "Swatch"], {985.2631578947369, -2556.}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 1, 
        Rational[2, 5]], "Swatch"], {1379.3684210526317`, -2556.}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 1, 
        Rational[1, 5]], "Swatch"], {1773.4736842105262`, -2556.}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 1, 0], "Swatch"], {2167.578947368421, -2556.}, {
      Center, Center}, {359.9999999999998, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[4, 5], 1], "Swatch"], {2561.684210526316, -2556.}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[4, 5], 
        Rational[4, 5]], "Swatch"], {2955.78947368421, -2556.}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[4, 5], 
        Rational[3, 5]], "Swatch"], {3349.894736842105, -2556.}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[4, 5], 
        Rational[2, 5]], "Swatch"], {3743.999999999999, -2556.}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[4, 5], 
        Rational[1, 5]], "Swatch"], {4138.105263157894, -2556.}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[4, 5], 0], "Swatch"], {4532.210526315789, -2556.}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[3, 5], 1], "Swatch"], {4926.315789473684, -2556.}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[3, 5], 
        Rational[4, 5]], "Swatch"], {5320.421052631579, -2556.}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[3, 5], 
        Rational[3, 5]], "Swatch"], {5714.526315789474, -2556.}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[3, 5], 
        Rational[2, 5]], "Swatch"], {6108.631578947369, -2556.}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[3, 5], 
        Rational[1, 5]], "Swatch"], {6502.736842105264, -2556.}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[3, 5], 0], "Swatch"], {6896.842105263159, -2556.}, {
      Center, Center}, {360., 359.99999999999955`}]}, {InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[2, 5], 1], 
       "Swatch"], {197.05263157894737`, -2949.2307692307686`}, {
      Center, Center}, {360.00000000000006`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[2, 5], 
        Rational[4, 5]], 
       "Swatch"], {591.1578947368421, -2949.2307692307686`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[2, 5], 
        Rational[3, 5]], 
       "Swatch"], {985.2631578947369, -2949.2307692307686`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[2, 5], 
        Rational[2, 5]], 
       "Swatch"], {1379.3684210526317`, -2949.2307692307686`}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[2, 5], 
        Rational[1, 5]], 
       "Swatch"], {1773.4736842105262`, -2949.2307692307686`}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[2, 5], 0], 
       "Swatch"], {2167.578947368421, -2949.2307692307686`}, {
      Center, Center}, {359.9999999999998, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[1, 5], 1], 
       "Swatch"], {2561.684210526316, -2949.2307692307686`}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[1, 5], 
        Rational[4, 5]], 
       "Swatch"], {2955.78947368421, -2949.2307692307686`}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[1, 5], 
        Rational[3, 5]], 
       "Swatch"], {3349.894736842105, -2949.2307692307686`}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[1, 5], 
        Rational[2, 5]], 
       "Swatch"], {3743.999999999999, -2949.2307692307686`}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[1, 5], 
        Rational[1, 5]], 
       "Swatch"], {4138.105263157894, -2949.2307692307686`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 
        Rational[1, 5], 0], 
       "Swatch"], {4532.210526315789, -2949.2307692307686`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 0, 1], 
       "Swatch"], {4926.315789473684, -2949.2307692307686`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 0, 
        Rational[4, 5]], 
       "Swatch"], {5320.421052631579, -2949.2307692307686`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 0, 
        Rational[3, 5]], 
       "Swatch"], {5714.526315789474, -2949.2307692307686`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 0, 
        Rational[2, 5]], 
       "Swatch"], {6108.631578947369, -2949.2307692307686`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 0, 
        Rational[1, 5]], 
       "Swatch"], {6502.736842105264, -2949.2307692307686`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[2, 5], 0, 0], 
       "Swatch"], {6896.842105263159, -2949.2307692307686`}, {
      Center, Center}, {360., 359.99999999999955`}]}, {InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 1, 1], 
       "Swatch"], {197.05263157894737`, -3342.461538461538}, {
      Center, Center}, {360.00000000000006`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 1, 
        Rational[4, 5]], "Swatch"], {591.1578947368421, -3342.461538461538}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 1, 
        Rational[3, 5]], "Swatch"], {985.2631578947369, -3342.461538461538}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 1, 
        Rational[2, 5]], 
       "Swatch"], {1379.3684210526317`, -3342.461538461538}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 1, 
        Rational[1, 5]], 
       "Swatch"], {1773.4736842105262`, -3342.461538461538}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 1, 0], 
       "Swatch"], {2167.578947368421, -3342.461538461538}, {
      Center, Center}, {359.9999999999998, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[4, 5], 1], 
       "Swatch"], {2561.684210526316, -3342.461538461538}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[4, 5], 
        Rational[4, 5]], "Swatch"], {2955.78947368421, -3342.461538461538}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[4, 5], 
        Rational[3, 5]], "Swatch"], {3349.894736842105, -3342.461538461538}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[4, 5], 
        Rational[2, 5]], "Swatch"], {3743.999999999999, -3342.461538461538}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[4, 5], 
        Rational[1, 5]], "Swatch"], {4138.105263157894, -3342.461538461538}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[4, 5], 0], 
       "Swatch"], {4532.210526315789, -3342.461538461538}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[3, 5], 1], 
       "Swatch"], {4926.315789473684, -3342.461538461538}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[3, 5], 
        Rational[4, 5]], "Swatch"], {5320.421052631579, -3342.461538461538}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[3, 5], 
        Rational[3, 5]], "Swatch"], {5714.526315789474, -3342.461538461538}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[3, 5], 
        Rational[2, 5]], "Swatch"], {6108.631578947369, -3342.461538461538}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[3, 5], 
        Rational[1, 5]], "Swatch"], {6502.736842105264, -3342.461538461538}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[3, 5], 0], 
       "Swatch"], {6896.842105263159, -3342.461538461538}, {
      Center, Center}, {360., 359.99999999999955`}]}, {InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[2, 5], 1], 
       "Swatch"], {197.05263157894737`, -3735.6923076923067`}, {
      Center, Center}, {360.00000000000006`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[2, 5], 
        Rational[4, 5]], 
       "Swatch"], {591.1578947368421, -3735.6923076923067`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[2, 5], 
        Rational[3, 5]], 
       "Swatch"], {985.2631578947369, -3735.6923076923067`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[2, 5], 
        Rational[2, 5]], 
       "Swatch"], {1379.3684210526317`, -3735.6923076923067`}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[2, 5], 
        Rational[1, 5]], 
       "Swatch"], {1773.4736842105262`, -3735.6923076923067`}, {
      Center, Center}, {360.0000000000002, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[2, 5], 0], 
       "Swatch"], {2167.578947368421, -3735.6923076923067`}, {
      Center, Center}, {359.9999999999998, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[1, 5], 1], 
       "Swatch"], {2561.684210526316, -3735.6923076923067`}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[1, 5], 
        Rational[4, 5]], 
       "Swatch"], {2955.78947368421, -3735.6923076923067`}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[1, 5], 
        Rational[3, 5]], 
       "Swatch"], {3349.894736842105, -3735.6923076923067`}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[1, 5], 
        Rational[2, 5]], 
       "Swatch"], {3743.999999999999, -3735.6923076923067`}, {
      Center, Center}, {359.99999999999955`, 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[1, 5], 
        Rational[1, 5]], 
       "Swatch"], {4138.105263157894, -3735.6923076923067`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 
        Rational[1, 5], 0], 
       "Swatch"], {4532.210526315789, -3735.6923076923067`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 0, 1], 
       "Swatch"], {4926.315789473684, -3735.6923076923067`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 0, 
        Rational[4, 5]], 
       "Swatch"], {5320.421052631579, -3735.6923076923067`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 0, 
        Rational[3, 5]], 
       "Swatch"], {5714.526315789474, -3735.6923076923067`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 0, 
        Rational[2, 5]], 
       "Swatch"], {6108.631578947369, -3735.6923076923067`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 0, 
        Rational[1, 5]], 
       "Swatch"], {6502.736842105264, -3735.6923076923067`}, {
      Center, Center}, {360., 359.99999999999955`}], InsetBox[
      ColorSetterBox[RGBColor[
        Rational[1, 5], 0, 0], 
       "Swatch"], {6896.842105263159, -3735.6923076923067`}, {
      Center, Center}, {360., 359.99999999999955`}]}, {InsetBox[
      ColorSetterBox[RGBColor[0, 1, 1], 
       "Swatch"], {197.05263157894737`, -4128.923076923076}, {
      Center, Center}, {360.00000000000006`, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 1, 
        Rational[4, 5]], "Swatch"], {591.1578947368421, -4128.923076923076}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 1, 
        Rational[3, 5]], "Swatch"], {985.2631578947369, -4128.923076923076}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 1, 
        Rational[2, 5]], 
       "Swatch"], {1379.3684210526317`, -4128.923076923076}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 1, 
        Rational[1, 5]], 
       "Swatch"], {1773.4736842105262`, -4128.923076923076}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 1, 0], 
       "Swatch"], {2167.578947368421, -4128.923076923076}, {
      Center, Center}, {359.9999999999998, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[4, 5], 1], 
       "Swatch"], {2561.684210526316, -4128.923076923076}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[4, 5], 
        Rational[4, 5]], "Swatch"], {2955.78947368421, -4128.923076923076}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[4, 5], 
        Rational[3, 5]], "Swatch"], {3349.894736842105, -4128.923076923076}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[4, 5], 
        Rational[2, 5]], "Swatch"], {3743.999999999999, -4128.923076923076}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[4, 5], 
        Rational[1, 5]], "Swatch"], {4138.105263157894, -4128.923076923076}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[4, 5], 0], 
       "Swatch"], {4532.210526315789, -4128.923076923076}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[3, 5], 1], 
       "Swatch"], {4926.315789473684, -4128.923076923076}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[3, 5], 
        Rational[4, 5]], "Swatch"], {5320.421052631579, -4128.923076923076}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[3, 5], 
        Rational[3, 5]], "Swatch"], {5714.526315789474, -4128.923076923076}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[3, 5], 
        Rational[2, 5]], "Swatch"], {6108.631578947369, -4128.923076923076}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[3, 5], 
        Rational[1, 5]], "Swatch"], {6502.736842105264, -4128.923076923076}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[3, 5], 0], 
       "Swatch"], {6896.842105263159, -4128.923076923076}, {
      Center, Center}, {360., 360.}]}, {InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[2, 5], 1], 
       "Swatch"], {197.05263157894737`, -4522.153846153846}, {
      Center, Center}, {360.00000000000006`, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[2, 5], 
        Rational[4, 5]], "Swatch"], {591.1578947368421, -4522.153846153846}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[2, 5], 
        Rational[3, 5]], "Swatch"], {985.2631578947369, -4522.153846153846}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[2, 5], 
        Rational[2, 5]], 
       "Swatch"], {1379.3684210526317`, -4522.153846153846}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[2, 5], 
        Rational[1, 5]], 
       "Swatch"], {1773.4736842105262`, -4522.153846153846}, {
      Center, Center}, {360.0000000000002, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[2, 5], 0], 
       "Swatch"], {2167.578947368421, -4522.153846153846}, {
      Center, Center}, {359.9999999999998, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[1, 5], 1], 
       "Swatch"], {2561.684210526316, -4522.153846153846}, {Center, Center}, 
      {359.99999999999955`, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[1, 5], 
        Rational[4, 5]], "Swatch"], {2955.78947368421, -4522.153846153846}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[1, 5], 
        Rational[3, 5]], "Swatch"], {3349.894736842105, -4522.153846153846}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[1, 5], 
        Rational[2, 5]], "Swatch"], {3743.999999999999, -4522.153846153846}, {
      Center, Center}, {359.99999999999955`, 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[1, 5], 
        Rational[1, 5]], "Swatch"], {4138.105263157894, -4522.153846153846}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 
        Rational[1, 5], 0], 
       "Swatch"], {4532.210526315789, -4522.153846153846}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 0, 1], 
       "Swatch"], {4926.315789473684, -4522.153846153846}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 0, 
        Rational[4, 5]], "Swatch"], {5320.421052631579, -4522.153846153846}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 0, 
        Rational[3, 5]], "Swatch"], {5714.526315789474, -4522.153846153846}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 0, 
        Rational[2, 5]], "Swatch"], {6108.631578947369, -4522.153846153846}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 0, 
        Rational[1, 5]], "Swatch"], {6502.736842105264, -4522.153846153846}, {
      Center, Center}, {360., 360.}], InsetBox[
      ColorSetterBox[RGBColor[0, 0, 0], 
       "Swatch"], {6896.842105263159, -4522.153846153846}, {
      Center, Center}, {360., 360.}]}}, {{}, 
    StyleBox[{{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}},
     Antialiasing->False]}},
  PlotRange->{{0, 7093.894736842107}, {0, -4718.7692307692305`}},
  PlotRangePadding->{5, 5}]], "Output",
 CellLabel->"Out[2]=",
 CellID->926534022]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ACO - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 46.1351464}", "context" -> "", 
    "keywords" -> {
     "color", "palette", "Adobe", "Photoshop", "RGB", "Lab", "CMYK"}, "index" -> 
    True, "label" -> "Mathematica Import/Export Format", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Adobe Photoshop color swatch format. Used for storing color palettes. \
Native format of the Adobe Photoshop image-editing application. ACO is an \
acronym derived from Adobe Color. Binary file format. Stores color \
specifications and, in version 2 of the format, color names. Represents color \
values using 16 bits per color channel. Supports a variety of color spaces.", 
    "synonyms" -> {}, "title" -> "ACO", "type" -> "Format", "uri" -> 
    "ref/format/ACO"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14894, 535, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 65763, 1696}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1605, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2228, 60, 102, 4, 70, "ObjectNameAlt",
 CellID->16827],
Cell[2333, 66, 410, 10, 70, "FormatUsage",
 CellID->9961],
Cell[2746, 78, 341, 12, 70, "FormatNotes",
 CellID->491]
}, Open  ]],
Cell[CellGroupData[{
Cell[3124, 95, 63, 1, 70, "ImportExportSection",
 CellID->2995],
Cell[3190, 98, 297, 9, 70, "FormatNotes",
 CellID->11942],
Cell[3490, 109, 341, 11, 70, "FormatNotes",
 CellID->4827],
Cell[3834, 122, 38, 1, 70, "WeakDivider",
 CellID->5436],
Cell[3875, 125, 384, 11, 70, "FormatNotes",
 CellID->1374697286],
Cell[4262, 138, 629, 21, 70, "FormatNotes",
 CellID->1908211376],
Cell[4894, 161, 757, 25, 70, "FormatNotes",
 CellID->14604],
Cell[5654, 188, 38, 1, 70, "WeakDivider",
 CellID->3902],
Cell[5695, 191, 350, 13, 70, "FormatNotes",
 CellID->153],
Cell[6048, 206, 435, 15, 70, "FormatNotes",
 CellID->292],
Cell[6486, 223, 582, 21, 70, "FormatNotes",
 CellID->12382],
Cell[7071, 246, 703, 25, 70, "FormatNotes",
 CellID->17421],
Cell[7777, 273, 39, 1, 70, "WeakDivider",
 CellID->18716],
Cell[7819, 276, 530, 20, 70, "FormatNotes",
 CellID->19718],
Cell[8352, 298, 1076, 40, 70, "FormatNotes",
 CellID->19895],
Cell[9431, 340, 661, 22, 70, "FormatNotes",
 CellID->5447],
Cell[10095, 364, 816, 28, 70, "FormatNotes",
 CellID->21726],
Cell[10914, 394, 39, 1, 70, "WeakDivider",
 CellID->14771],
Cell[10956, 397, 361, 14, 70, "FormatNotes",
 CellID->11538],
Cell[11320, 413, 351, 14, 70, "FormatNotes",
 CellID->1869]
}, Closed]],
Cell[CellGroupData[{
Cell[11708, 432, 51, 1, 70, "ElementsSection",
 CellID->19912],
Cell[11762, 435, 192, 8, 70, "FormatNotes",
 CellID->25667],
Cell[11957, 445, 668, 13, 70, "2ColumnTableMod",
 CellID->26299],
Cell[12628, 460, 39, 1, 70, "WeakDivider",
 CellID->17035],
Cell[12670, 463, 67, 1, 70, "FormatNotes",
 CellID->9894],
Cell[12740, 466, 766, 19, 70, "2ColumnTableMod",
 CellID->146182287],
Cell[13509, 487, 262, 9, 70, "FormatNotes",
 CellID->812283704]
}, Open  ]],
Cell[CellGroupData[{
Cell[13808, 501, 58, 1, 70, "MoreAboutSection",
 CellID->159661309],
Cell[13869, 504, 134, 2, 70, "MoreAbout"],
Cell[14006, 508, 133, 2, 70, "MoreAbout"],
Cell[14142, 512, 156, 2, 70, "MoreAbout"],
Cell[14301, 516, 159, 2, 70, "MoreAbout"],
Cell[14463, 520, 117, 2, 70, "MoreAbout"],
Cell[14583, 524, 130, 2, 70, "MoreAbout"],
Cell[14716, 528, 141, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14894, 535, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[15010, 541, 59, 1, 70, "ExampleSection",
 CellID->45263138],
Cell[15072, 544, 144, 4, 70, "ExampleText",
 CellID->40824672],
Cell[CellGroupData[{
Cell[15241, 552, 196, 6, 70, "Input",
 CellID->945035723],
Cell[15440, 560, 597, 18, 70, "Output",
 CellID->426343249]
}, Open  ]],
Cell[16052, 581, 126, 3, 70, "ExampleDelimiter",
 CellID->1545539551],
Cell[16181, 586, 230, 8, 70, "ExampleText",
 CellID->56526661],
Cell[16414, 596, 250, 8, 70, "Input",
 CellID->1932235877],
Cell[16667, 606, 225, 8, 70, "ExampleText",
 CellID->121440739],
Cell[CellGroupData[{
Cell[16917, 618, 189, 6, 70, "Input",
 CellID->840674805],
Cell[17109, 626, 47258, 1034, 70, "Output",
 CellID->926534022]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[64406, 1665, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

