(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    193627,       3937]
NotebookOptionsPosition[    187072,       3721]
NotebookOutlinePosition[    188441,       3759]
CellTagsIndexPosition[    188354,       3754]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"3DS\"" :> Documentation`HelpLookup["paclet:ref/format/3DS"], 
          "\"JVX\"" :> Documentation`HelpLookup["paclet:ref/format/JVX"], 
          "\"LWO\"" :> Documentation`HelpLookup["paclet:ref/format/LWO"], 
          "\"Maya\"" :> Documentation`HelpLookup["paclet:ref/format/Maya"], 
          "\"OBJ\"" :> Documentation`HelpLookup["paclet:ref/format/OBJ"], 
          "\"OFF\"" :> Documentation`HelpLookup["paclet:ref/format/OFF"], 
          "\"PLY\"" :> Documentation`HelpLookup["paclet:ref/format/PLY"], 
          "\"POV\"" :> Documentation`HelpLookup["paclet:ref/format/POV"], 
          "\"RIB\"" :> Documentation`HelpLookup["paclet:ref/format/RIB"], 
          "\"STL\"" :> Documentation`HelpLookup["paclet:ref/format/STL"], 
          "\"X3D\"" :> Documentation`HelpLookup["paclet:ref/format/X3D"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"3DS\\\"\"\>", 
       2->"\<\"\\\"JVX\\\"\"\>", 3->"\<\"\\\"LWO\\\"\"\>", 
       4->"\<\"\\\"Maya\\\"\"\>", 5->"\<\"\\\"OBJ\\\"\"\>", 
       6->"\<\"\\\"OFF\\\"\"\>", 7->"\<\"\\\"PLY\\\"\"\>", 
       8->"\<\"\\\"POV\\\"\"\>", 9->"\<\"\\\"RIB\\\"\"\>", 
       10->"\<\"\\\"STL\\\"\"\>", 
       11->"\<\"\\\"X3D\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"3D Geometry & Modeling Formats\"\>", 
       2->"\<\"Computational Geometry\"\>", 
       3->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "BYU ",
 StyleBox["(.byu)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell["\<\
3D geometry format.
Used for visualization of 3D polygonal meshes in CAD systems and other \
applications. 
BYU is an acronym for Brigham Young University.
ASCII format.
Represents 3D objects as collections of polygon primitives.
Can store multiple 3D objects.\
\>", "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the BYU format."
}], "FormatNotes",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).byu\>\"", "]"}]], "InlineFormula"],
 " imports a BYU file as a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).byu\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " expression to a BYU file."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).byu\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "[", " ", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    RowBox[{
     StyleBox["vertices", "TI"], ",", 
     StyleBox["primitives", "TI"], ",", 
     StyleBox["opts", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->25134],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).byu\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a ",
 "BYU",
 " file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).byu\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).byu\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<BYU\>\""}], "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<BYU\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).byu\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a BYU file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).byu\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).byu\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).byu\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the BYU format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->525384128],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "BYU",
     " file represented as a ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsComplex\>\"", Cell[
    TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " objects, each representing a 3D geometry stored in the file"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->263380570],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Graphics3D\>\""], "InlineFormula"],
 " element by default for BYU files."
}], "FormatNotes",
 CellID->13037],

Cell["Data representation elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<PolygonData\>\"", Cell[
    "the polygon data in indexed form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexData\>\"", Cell[
    "list of vertex coordinates", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->230773093],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " with a data representation element returns a list whose elements \
correspond to the geometry objects stored in the file. "
}], "FormatNotes",
 CellID->1326471371],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).byu\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<PolygonData\>\"", ",", 
      StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " gives the polygon data of the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " geometry object. "
}], "FormatNotes",
 CellID->842184215]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1911960202],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what background color to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall size of the graphics to display", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Lighting",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Lighting"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what simulated lighting to use in coloring 3D surfaces", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->2123520593],

Cell[TextData[{
 "All options of ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " can be given when importing from BYU."
}], "FormatNotes",
 CellID->1022956994],

Cell["Advanced option:", "FormatNotes",
 CellID->2132824898],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<VerticalAxis\>\"", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}], Cell["\<\
orientation to assume for the coordinate system used in the file\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->28047],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that in the coordinate system used by the BYU format the vertical \
axis corresponds to the third coordinate."
}], "FormatNotes",
 CellID->1642809193],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<VerticalAxis\>\"", "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will apply the transformation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     RowBox[{"-", 
      StyleBox["z", "TI"]}], ",", 
     StyleBox["y", "TI"]}], "}"}], " "}]], "InlineFormula"],
 "to all graphics coordinates when importing from BYU, and the inverse \
transformation when exporting to BYU."
}], "FormatNotes",
 CellID->182941150]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<3DS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/3DS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JVX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JVX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LWO\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LWO"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Maya\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Maya"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OBJ\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OBJ"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PLY\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PLY"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<POV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/POV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<RIB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/RIB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<STL\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/STL"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<X3D\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/X3D"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2645]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->329426040],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->277477022],

Cell["\<\
This imports a simple BYU file and renders it as 3D graphics:\
\>", "ExampleText",
 CellID->1615363059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/cube.byu\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17199],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[None], 
   GraphicsComplex3DBox[{{1., 1., 2.}, {2., 1., 2.}, {2., 2., 2.}, {1., 2., 
    2.}, {1., 1., 1.}, {1., 2., 1.}, {2., 2., 1.}, {2., 1., 1.}}, 
    Polygon3DBox[{{1, 2, 3, 4}, {5, 6, 7, 8}, {5, 8, 2, 1}, {8, 7, 3, 2}, {7, 
     6, 4, 3}, {6, 5, 1, 4}}]]},
  Boxed->False]], "Output",
 CellLabel->"Out[1]=",
 CellID->2012808947]
}, Open  ]],

Cell[TextData[{
 "Import the ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " object representing this sample file:"
}], "ExampleText",
 CellID->1964905787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
  "\"\<ExampleData/cube.byu\>\"", ",", " ", "\"\<GraphicsComplex\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->264564443],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"GraphicsComplex", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1.`", ",", "1.`", ",", "2.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2.`", ",", "1.`", ",", "2.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2.`", ",", "2.`", ",", "2.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.`", ",", "2.`", ",", "2.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.`", ",", "2.`", ",", "1.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2.`", ",", "2.`", ",", "1.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2.`", ",", "1.`", ",", "1.`"}], "}"}]}], "}"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6", ",", "7", ",", "8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "8", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "7", ",", "3", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "6", ",", "4", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "5", ",", "1", ",", "4"}], "}"}]}], "}"}], "]"}]}], 
   "]"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1243444211]
}, Open  ]],

Cell["Read the vertex coordinates:", "ExampleText",
 CellID->912034040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/cube.byu\>\"", ",", " ", "\"\<VertexData\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->168038543],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.`", ",", "1.`", ",", "2.`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2.`", ",", "1.`", ",", "2.`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2.`", ",", "2.`", ",", "2.`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.`", ",", "2.`", ",", "2.`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.`", ",", "2.`", ",", "1.`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2.`", ",", "2.`", ",", "1.`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2.`", ",", "1.`", ",", "1.`"}], "}"}]}], "}"}], "}"}]], "Output",\

 CellLabel->"Out[3]=",
 CellID->282796396]
}, Open  ]],

Cell["Import the corresponding polygon information:", "ExampleText",
 CellID->714845780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/cube.byu\>\"", ",", " ", "\"\<PolygonData\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1403485320],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6", ",", "7", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "8", ",", "2", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "7", ",", "3", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "6", ",", "4", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "5", ",", "1", ",", "4"}], "}"}]}], "}"}], 
  "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->417394592]
}, Open  ]],

Cell[TextData[{
 "Convert the sample file to a list of ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 " primitives:"
}], "ExampleText",
 CellID->1389503142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
  "\"\<ExampleData/cube.byu\>\"", ",", " ", "\"\<PolygonObjects\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1469316642],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.`", ",", "1.`", ",", "2.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "1.`", ",", "2.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "2.`", ",", "2.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "2.`", ",", "2.`"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "2.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "2.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "1.`", ",", "1.`"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "1.`", ",", "2.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "1.`", ",", "2.`"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "2.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "2.`", ",", "2.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "1.`", ",", "2.`"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2.`", ",", "2.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "2.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "2.`", ",", "2.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "2.`", ",", "2.`"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.`", ",", "2.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "1.`", ",", "2.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "2.`", ",", "2.`"}], "}"}]}], "}"}], "]"}]}], 
   "}"}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->890345241]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->634825496],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 " to create a 3D geometry:"
}], "ExampleText",
 CellID->813352976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"6", "+", 
        RowBox[{"Sin", "[", "v", "]"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
        RowBox[{"Sin", "[", "u", "]"}]}], ",", 
       RowBox[{"6", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", "u", "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"12", "+", 
        RowBox[{"Sin", "[", "v", "]"}]}], ",", 
       RowBox[{"6", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
        RowBox[{"Cos", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"12", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
        RowBox[{"Cos", "[", "u", "]"}]}], ",", 
       RowBox[{"Sin", "[", "v", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"6", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}], ",", 
       RowBox[{"6", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", "u", "]"}]}]}], ",", 
       RowBox[{"6", "+", 
        RowBox[{"Sin", "[", "v", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"6", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", "u", "]"}]}]}], ",", 
       RowBox[{"Sin", "[", "v", "]"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
        RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"12", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", "u", "]"}]}]}], ",", 
       RowBox[{"6", "+", 
        RowBox[{"Sin", "[", "v", "]"}]}], ",", 
       RowBox[{"6", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "+", 
           RowBox[{"Cos", "[", "v", "]"}]}], ")"}], " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}]}], "}"}]}], "}"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Axes", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Mesh", "\[Rule]", " ", "False"}], ",", 
   RowBox[{"ColorFunction", " ", "\[Rule]", " ", "\"\<Rainbow\>\""}], ",", 
   RowBox[{"ImageSize", " ", "\[Rule]", " ", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1290054477],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJzsvXm4lmP3/383l1KpXYbatYeKpr23UqjNvkOEHmlARSoUQh6hMj2mJ0WD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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNmwnYVuP2xvfeUebpOPjL0IAyN5kdKkOGECUdYyJDkiGK5DTIGFGmUCQJ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        "]]]}, 
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNnHncVlP3xuM+pygRfsiYeZ6nVOZeypRZNCDz1CQlqUjeVOZ5ForeJJVk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        "]]]}, 
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNnHncVmMTx7N0n/PoRVok+5JIlkIRIcmW7bUkihCytNqSpBReQgvZs2QL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        "]]]}, 
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNnHf8luMXx7+2574fK7SNEFJRRsnKJuPnR2RllKKskIxQkpGZUZJk+9mj
klEIyUgyKzIqZMve4nfe3/N+Xvxxva5P1/fc5z7XOed+7s91zvPUome//U5c
sq6ubsQydXVLxVyWdXXrxFhQqavbL+Y/Y24SY//Af8fcNEa3wEsWdXXNAh8e
eMXAawU+JPDygdcI/N/Av8bcOEbbWKvEaB34oFhfJnDzwJvEXI3RJvB/Yv2X
mBvFODLwKrG+duAG1ZjRGWOdGL/F2voxWgZeHPMGMXqG/Grx7xaBW8W8VIxW
gbvHehl4zcCtY142xkZcE3NdjA0DHx0yTQOvG7h9zCvFaBt405i3iXnPGJsF
bhBj48DDY+4f45TAnfBBjPaBt+X+MTYLvDX3jLFp4C1iXj3GJoHXjXmLmHdm
D4E7xLxLjHaBt455jxgdAzeO0S7wRjFvGfNuMTYPvG3Me8XoEHi7mPeOsWXg
zvgvxsaBt4q5S4xtAu9AHGJsGLhjzLvGaBO4U8y7x9gq8PYx7xOjV/ihET5G
L/pj7Bi4c5H2dsXuIq87ELuLvM9B6C3S9oOxtUifHYLvitR9eIyditxHN+5d
5D4OxdYi99E9xo5F2ngAvihyT4dxvyL19Y2xb+D9Yz6K/CxSthf2Fam7N7la
pI1Hcz16YuyL74r0xxHco0jbj8GmIm3vw36KtOtY9lDk/Y+PcW7gPkWunxDz
4TGODNwv5iNi9Ax8Ssw9irRtYMy9i9R/GmtF2ta9yPufGGOHIuPPfk5FR5F7
ObRIn50Q4wzWitzL2cxF2nlhzMcVKXM+dhVp53kx9+Vvga+KeQD5GngYfy/y
vpfFfFKMkwMPwsYifXtwkXHg2kuQjdGP/Cgy/uzxmsCnxzg18Ocxj4/5mRij
A5/D3wKPiXlwjDMCj415SIwzA98U89AYAwPfGfOlMQYFHhXzWTFOC3xLzBfw
78C3xXxRjLMDPxXzrTEuCXxHzBdzv8BPxHwz/w78UMwjuEfg8TFfG+P8wA/H
fB16Az8S8/UxLgx8X8xXYl/gu2O+PMa5gR+L+QbuHXhSzDfGGBb4gZivjnFe
4Kdjvp09BH4/5mfQG/j5mO+JMTzwczHfhd7Ab8R8WyX99XLgB2NcFfjVmCfE
uCbwSzHfj02B34z50RgjA78S8zjuHfjZmP8X47LAs2J+nH0GfifmJ9ln4Hkx
T40xJvCCmKexn8AvsJeY748xPfBN7CnGu4GnxBgdeE7Mk2OMCjwD38b8YIyZ
gW/BxzFeIxYxj4vxFn6IeUKMXwPPjHlKjLmB78TfMd7DDzE/GuODwHfj4xjz
8VXMj8f4pMj7PBXjbfYY88QY3wX+MMa9gT8q0vYnYiwRn1ffx78nBV5Y5D6e
jPFtkfpejPFFkXY9G+PLwA/HPDXGV0Xqfi7G10XaOC3GZ0Xu6ekYnxa5V/ay
qEjbn4/xTZG2vxDjhyJteTnGT0Xef0aMVcO2pcpc/7nIPb0SY3bgOyppx29F
PjevxfijSLveiPF7kfa+HuOXIu+PT/8s0t43Yywu0t639Dn2vhrjryJtnBXj
7yJtnB2jadiyXJl6Gse8bJn2NORdXKbNI3lGYwwI3Jz3eJk61465KNOeVXjv
x3ipAlFIH8+JsWbgSpl7gTvAIdjLejFXy7R5/ZhXKNPmjWNuEOPtwO14d8eY
G3gz3kEx3g28RcxNYrwXeNuYW8SYH7hNzCuXed+OMTeL8X7gTjGvEeODSvIW
uArv960DrxVjXiU5CXwGzrBL4FYxPg68W8ytYywM3CXmtjE+CbxnzJvE+DTw
DjG3jPFh4M4xrytH+r2SvKVlJTkMnAd+slPgDWJ8VEnuBF+Ck8BP4CG81w+R
n8B/DpI7wZF4t/A5zXvicLkQ3KOn72i4QXd5F1wFDgM/gm8cKReCb3STa8F5
1iuSO21eSe4E/4F/wIvgZnACeBp8DA4BN4MLwUvgRfAf+BDcCX4Fn4CPwcHg
NHAkeA4cBc4Dh4GjwGfgSHAU+BK8CM4BR4IvwVHgQjurB67COxHb4D/wAe4F
b4E/4Dd4DjwEm+FF8A1sg7PBQ7AZjgTHwB74FVyFfcGX4BvYBieBP3AP+BJc
BdvgPvCEev5UJAfar5Lv63oeVEmuwnsbW+FC8A1sgiPBQ7AVfgWHYe/bF8n/
dqokX4J7YBNcqJ4rVZLz8P7FPrgT3IPr4S3wAeyDy5AX2AfngS+wB3gUvIU9
H1nkO7tHJfkS723shi/BTbAbjgQfqbe1SP6D7+A/cAFsgnfBNfgbHAkug929
5MzwXjgDnIh7w6ngKfgC7gSPYD/wGbgJ+4H/wFnYz0ahZ6UyP6NOLpJHnVRJ
HgUXgmPDneA/8A24UG8/o+BXcCE4A7wIDgP3gAvBi+APcCp4F/wHngN/g5PA
5eBIcBK4CvyEdz3cCR4FP4HPwGHgCfAlOD/cAP4Pp4IzwK/gQvCBa/z8hHvA
teBO8BN4GrwLDsNnLDwHTgLngS/BSeBI8CI4BhwJ/gOfgXvAbXgXw4vgQvAf
OCc8E/52b5G85YpK8hn4CfwBPgO3gYfAo+BLcBU4DBwJ7gFfgiPBK+BU8DF4
BdwJvgQngTvBl0ZUkvPAPeA58DH4D5wBDgY3g3tcUSS3HFxJrgL/gYfAi+A2
8A/4FZwK3gIfg2vBc14skjuNDfx6zBO9L7wIvgRfgQvBl25RBo4Er4IvwYXg
IvAiOAzvWvgMvAg+AUeC58BL4EjwIvgH/A2+BC/5uEiedF8leRG8Du4CX4J7
YD/8hHc4+uFF8BZ4ErwIzoBt8D24BDwJjgTvw044AJwEO+FFcA/sgS/BSbAT
3gWfYb+v6gf0wJ3gIdgDJ4LnYD/8Bx6CffAoeAjXw2HgHtgHt4FLYB/8B77B
Hn4skldNriSfh0tgN9wJfoLdcCc4CXbDl+Ah2Ap/gwvhN7gYfACb4GBwD/4G
X4KTYDe8Fx6Lr5Yukz9NryS/gs/gC3gUvIn9wJ3gJuwHLgRnYT+Tysw9ngV4
FDwFu+FR8BRshSPBO7AVXgTv4B7wIvgRNtX52YOtDeVFcI9BZX4m8nm4pFyD
va0ur3unkjykgTxhVXkUHGYj+QlcYk25E9xjbXkRHGYdeRH8YT15EbyiqbwL
PtNYzgb/gTutKJfY0M9MeEtzeRecZ9VqvP/kUqsE3tt6yhZypC8rya/gVF9U
kiM0LLJm0kmO9HUluRbc5ptK8is41VeV5D/wme8qyangY4sqyd/gbJ9XkvPA
qb6vJKeCR/0YeB9tgRf9UUmORJ1nX/nSBsrAT+BRXeRdP1WSp8HNfgjcVxl4
wurV3Ofv6kMvtaa/KsnxwF3lexu6xt+oZS1RJD8EHyBXbKU8vAh7jhPDPQ6U
v8Gjli4SN/VauBD6/1Yv68e7DlcpiuR11LuWK5KPUTc7WG7WWv1wQmw4QQy3
4e/LeS3yFW04VK4Ib8SWpdWJPxfr5xOVh/OsUCTPXMNrq963nxi+xN+Ro1a2
cpHcEszMv6nvHSZfhXMeIf/c2PWVtOckMXxs1SK5K9dib6ENrPE36nsnl8kt
t1VnA/V3lm9/W8k8XU35HvJh+O1Rct12rq+uPaeI4XicmziL8HnXpEj+3MJr
G6uneZF8htoXf28iZh+buC/yDg5Nfh4j/4Fv95F7U/frXSbXxZ5TxfDJtYqU
Wddr4cDtzWc4IZycv6+tHnS2UP9p4h21Ac5N/i8WE+sB6oSvnq5OOGrDatZP
uf+lZfJOuBy2N9ee/vqhs3m7kTk/UAyPPaNMjg7XrX8+lFlKTP5X9dXWPjvw
+A7KtPJZwOaWrpPjrc1zdLb0uTvWe23hs9DGa88Sw7HJ67bmdlVMPp9d5tmg
izKtfV5OdL2TcdnK/ZL/7dSDz7Y3FsS9vTncQNzW3N7UPQ4S76nMZubw4DLP
JHuZ25urh3zcwpxcXXlytbHr5CH50smcObfMM8zeynTU5mbidsZuS3UOEXNe
OM89cl5YU53tfS46aCfrW5szLcSbmkvbaAPr25p7Q13n3HGOfuP9eH6Z5yXq
qxeUeVbqat5up37yZwdz8nRlOAdd6DrnkTPLPFORYxeJOddcXOaZ6kBzYGdz
cliZ57du5gy51cEc2MU8GagM57tLXD9I+3c1T3hmG+kfODJcGa5+WZkcgHMQ
54kLXScuXYzvFeLu+n8P4zVczHnnqjLPb5zZLi/zvHeoMdrTeF0pPtx9dXXv
Q72WOI4s8/zWSz9zvuNMeo2YMx5+/e+/fLuvsSBG/zF2xGRv4zVCmaP0+X7G
4mrlqW9fqz2cFceWea47Xn8eYFxGlXme5OzHeYszG+c1PnO66XP8eaCfP9d5
7TH65CD9PFr5PsZ9f+M7RhnOmTeUeeY8Tr8dqp9vFJ+gz7vrz5vEJxqXQ4zX
FeohFuz1MPfL3g83XjeL++lnzqecqW8Rn6wPe+j/W8WnGK+e+vY2cX/9eZRx
vKPMs+0AfdhLP+Of3vrzduXx5/9cP00/9NUnd5Z5Fub8e32ZZ2F8eJf4DH3I
+Zez/d3iM43psfrzHnUONBZHGyPy60jz7V7lOV/fV+azwXNxf5nnXM68+OwE
/YYPT9T/D4ip+T9Y5jnxXGN0vLHDr/30bQ9xT32O/EnKnGwsbtQGcvKhMs/p
Q4xFf/XU1xKMxfXmYV/XTzUuPZQ5xRw+1RgRuwGujxNz3u9lnvc2RqerZ7x4
qDJnGN/e4qON+5nGdIL4fGUGGt+Hy6wVXGDcz1IPMTnbWB+tPDE6xnXiTmzP
Nb4Ty6wzXKjMIPOhj7iveTJYnY+ILzJPhijfV521fDtHOx9VZpgy55k/x4rJ
q8fKrG9cbI4N1bYny6xdDPcz9nzj+HiZNZBL1HO++UaOXGie3KvMQPPwImUm
iS9Vfpg5Sd5dYu5NLvOz/jLz9mJz+EHtGWyuXvqva4eZw0+4Tk+HfLzMHO4v
Jt84o3Fem6XMFeYt+x7r3smj4eYVeXulep4SX6nMVebb6eL+4mvMsSll1nyo
55zp+qnm6tU+C+TkCPUQt1HGDvmR5t5Z4gHm5LXqf0Z8jTKjzMlny6wRjTBX
r1PP097rau812twbLD7dnLxePayPMd+muj5Sfw7XfnLyBvUM0YfDxGPMT/Lw
RvU8pzz1pWmuj9L/N5mHF4jJH/LlFvPnAjG593yZ9TfqWoN9d+9pft6qnseU
wZ4XXB+tztvMQ3o69Eaop7xYZu2CGhp5d4d5yH75zCIfyK87zTHy7S5lpovp
5b1cZq2MehT5crf581KZNTpqbsTtIeN4uTLDjdE4c4azAP2DTZW51/yfUWa9
jhoUefSA8iPE53nf+8zVV8qs0d3sc41tVyj/kPkwRZkrzfP7tWem9lA3I1aP
GUfsH2/u4eMnjMWrZdYAqYmRLw+bS9eJR4jHm5Pk6kT1vCamFneD97rWPJ+g
naw/Yr6RS4+bk2+I79DOSebV62XWIW833yar83r1jDS3H9W2m712mL69zzx/
02upAd7qfskx8uUpc5Icm6IfZompB84us1ZJLY74P23u3eq15OQ7ZdY271fn
0+YhsXrReL1VZr30TvU8ay6Rd8+Ze+ThNNffFt+rzLPmKrF93vi+qG2jzVts
GOt9nzeHkX/JfCM+rxovYv2aufG8tuFz8uhl843cm+G141y/SvyK1z6ofnKP
OLxpvN712gfN+enaM1dMHXWCeq722teN40QxufS+dlI7/anMOuF0r33VXCX3
3hB/IB5v/s90L++JqdPOKbMuXd8j12Zy6ccy6630YcmXWeYb+Tnbfc0XP6zM
HPMK/71jfB/32jtcn6NvycO3Xf+4zLoztdwFrk803z4w98jBd8XPiEebn+95
r4/Ej5pjc7VnivZc57Xvm8NTxeTnh8o/4vo8fYKvPjV2C8usRz+u3+arBz9Q
v55grn7otTwL1L2p85O/C8xhcvNj8/MT5ScpM8+cJzcW+hyRP5+YJ19ozxTz
4TPj+KX4aeP+uXnyuddS0/5MndS6v1KG98W8Mmvx5MnXYurbi9zXVD9/3jIP
8dXXxuhb8TT9v0gffiemBv5DmfV66tvflNkbeM64f2O8vhe/4B5/0eaFXktu
/FJmvZ4a/adl1vYn+yyAqenj7x/1Oful1v+Efv7e2OHv7/T5z8rM0Fc/659f
tWGmvv1Vn/9dZq0f3vWb66+at1/5LODD3/UtPvxDf/7h+uv6/zfj9acyb+if
P/X578rwXl/s+pv6fLE+xLf0GPBbXTV7D7P159/6f56xIz+XqKb8HJ9xeg8v
Gq+/jONf6qefgc/4HgyfAy/5WcHzsmQ1r+X7FZPlA5fqT/oUxGLpauJ3jR29
jxn6jR7ETP1MD4KYEkN6NsS0Ws2eBf2IZap57Xv6H96LbfQE6A3QE1mumjrp
U1Sq2ROZr2/pieDzopp4gb6lr0Hsymr2SuiPLFtNe97XD9jwpv5H5g3jiH7i
skI17fnY/TbSnhWr2UOhR4NdTd0vPltFv61czf7Op/qzgXEhRvR3iCOf8auq
cxkxvsUfDfXnSsrTJ2pfZn+GXsnmZdrzhfKN9eFy4lfU2dAYdSizd0MfZ6lq
6nlHG+hLTTcWTZRfvpo+nKfOpvqtzr3zjKxmjLAH369tLLYqs+9DPwhfrqk/
K+J54ubGiHutZXy3KRMvMnYtjSk5sIY2LO+1yG9XZi+JfhMxXMc4Etv1jO/2
ZfakvlVmPfOh0Ob55lULbSOX1nWdvW5krNG5vnlLPNsY053L7G3RtyJfNjRn
VhLPMmdau75rmX2uH3wWNvhXfjYzjuReK++1ovfluVhZe8if3cvU+aP2bGy+
7VFm7+wn86et9jeqZp+PPCI/NzGvtizzvl+pv43rO5bpf3p2q4X8XmVeQw2Z
umd7n9PNzEN6SfSi6EORR1uYb83E77neQXni2ck8AXc0vujc3LwiDtsb32bK
YCd27aBtTbSBvF1LnR+It1E/sd1WPeuK53vfrdTJemfzhHttqf0tXV+gnu3M
zw20gdjh4z2MReNq+ovvf/GMbOqzhvzO2kzcdjEfWol/cH039XDfHbWHZ5Zn
da7yu5pv6NxJ3Er8kfbsZtzpnfLdsvXF9HbpnxLLvcwT9rW1+c96F3PgV69t
5LX0WVtq5+7a3FZ59PDu/sj38lrqXKQevj9Hj4ZeKt+xq/U9wU1c76oMPZ2u
ytADOsC8ok6/rzJcu7/r5B64qffa1/0ic4B66D3ynTl6iMuaq/R36JPy/Tl6
QMuLm7t+8L9k+D5cM+/VzfWKMrVr0d9GfKjr3Jfv29EDot/I9/Dov9AnOsx1
eqF8V4+eziritZTnO3n1v2Uosse5sToP815/6tvG6jniXzq575rqRM8m4h7l
P/2jo7RnNTEyjbSTXudvxn1913vVnn0/B7h2dXVybdW9Y1tT5emH0qOkVkDf
kPMU53nOWfSS6GtSQ6BnRP9yM+9Lj5OeGv01cK13eayY3KDv2FH9fdRDDxCZ
DubScWL6afTV6GFt6HpHfcv6NsaUnh/9vo3FtV5hP3E78dbmEr1G+owbac+W
xvckZTYVo7+N8p302yn/soc+Fj0senH05zobIzB9Omrj9BjoNdCjox9Jr43e
Gr03+mXNXOda+jX00nbUzwOU7+B9t9O39NV20m/022rfUcSeXd3XQPFO4t3c
y1niHbwW+zurEz07K7O7/jxbvIu4i/48R7yrmP4gPTR6pXsau8Hi3cW137Oc
K+4i3lv/0CejR0Y/bYh4T9f30c9DlMeHQ12nr0UPbH99SA+M/td/xPu6R3pp
9DX2EXfVDxeW/3xnkt7YAfrzInXu5b3+a24Mcr/4dpjy+I0+Vjd9Rc+MftkB
4tpvZy4VdxPTI6PfRW+M/tT+6jlQf16mzIHiQ/Tn5WJ8eIXXdtWebvqNnhn9
Mvpgw8V7iLv7/J5mHh6qPH20g9XZ3b1f5Xp38RH69mox/qRnRo/mCHFP4zJC
3ENc+y3PSHFPce13PdeKjxL31of0yein0GcZJe7t+jH6bZTy+Ha06/Qp6J8d
pw/pCdE3OUbcV/+PEfcRH6sfbhDTm6B/drz+HKvOo71XH314ozLHiU/QbzeJ
+Uyo75NVsmdxk5j6Nj2YM/VhfQ9Mv1Erptdwotf202/0q6ghn6Q8MgNc768P
by//6SOA6RdQ26fPdJo+BNMLoEdwh7iP9pzhHu9Uvpcy6DnH9dP1513iwWKu
pSZMDfoqY3GPe6T2Tm39Yn1Lj2eg6+Cz9OF94ovEZ+u3+8XUz+nfDNI/4HP0
CT0e6tsXK8/65a6f637pf1Azp75Nb2aIPhwnvlpc68uMF48QD9Wf9EWoP1+r
TnB/dXKv65S5QL9NFF8vpv5cX4susx4+WMz6UP2Gf6hF0/+gnkxt+TF9OMR1
rr1V317itY8pjw8nuX67+FL9M1mMf6jpUx+mxktP4nL9DKbeO86YUiO9R3lq
v/9Tz2X68ynX7xdfqT+niOu/B1ckJ8Rvz6iT8yn1As6G1F2p6Y/QV1PFj4pH
6rfnxPiE2vEofc611JYfV+ZafThNTA2QOjV14Mmuj3JfrI/VV9S1qXM+I77e
/b4knioeo/+p3VPnfFJ7rtOf05WZJqbGPkX50fpqxr/soT5LbZa6NbXv+t9o
iamBU5eihkWNi1oy9WVq4NSnqaffarxmei11aGrT1A8nKIP8dO97k759XRn8
Rq2ZOvPb2lOrLb8lniu+073MEs/2Wux/S52170IjU6shzxZ/IK7VhOeI54up
5VIzpLZbq99S26XG+JG49nu3ueKF4gf0D3VkasjUYt8Vf+r6Q/r5XeXx4fuu
U3+lvvywPqS2W1/XFY93j/PEX4gn6If5YmqT1Cgn6s8F6vzMe40zN952v/j2
Q+XxG7XdR/QVdVtqtt+Ia7+zWyj+VkytlZoe5z3OeovU86j+/ESZ78WT9Cfy
k/XhZ177tfY8ot+oEVMfpl77ufgT8ZM+v6+Zh78oT/32J3U+6d6/dP1X8dP6
9isx/vzaPP9dXPut3yLxH+La7/6+Ef8prv0G8FvxYvE0fUitljot9dfvxH+7
/oJ++055fPuD69TuqLfO0IfUc6nlUmMEv6T/qY9Tu6M2AK79lvDn8p9aIvXZ
V/TnL+qkTvyDOvHhr8pQ6wPP1G+/iflMoK5aX68rcx1MfYPaxFx9SP209ptE
Pm+pB1Lr+911/LbYz2Hqb38oQ12O9drvE/8SU3MDU/uinkb9cbY+BNfX1sqs
Hc/SD9jzjntcQnn8/3f5Tw2N9Tn6c0lxAzH1W86tnEnbG4ul3WMza2if6Vtq
ptSdmohrNdhlxc3EtbrlcmJqI9Q9a7VQ8Af6pOL6Gsqz3sL1+e6X+iB1HmpW
1CsX6MNS3FL8oT6sijcQf6Q/qUvWalAriEt1cq/WyizUbyuJ24qpEVEvop74
qT5c2fVG+g3/8D17vm9PDYnvE/O9Ys7rTfwefsNK1iVXtTbd1O8er1exjma9
srm1tZ/Vt7rXgpv4uwX+3lgZ9DUyXhPkA7y70d3U/xsC3NB7Id+s9luIat6P
Ghlche9awPc4E3NW5yz8f1z05v4=
        "]]]}, 
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNm3ncVWP3xp/X8Bres/cxlTkqQ6IoKXOSISGZMytSlJJ5ekNIJCkUiso8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        "]]]}, 
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNm3ncVtMWx9/LNXZ5zn5IiRCVyhgSmULmeUjGa+rKHFEqQyJTyRgyJRkz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        "]]]}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}}},
   VertexColors->CompressedData["
1:eJzsvHk41dv7N56xCZUkSZNKmkcNqLtMiVJJksyNklKkuVCSBjQjVErRoAxp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    "],
   VertexNormals->CompressedData["
1:eJztnX3QnmV14F/d7UynowUCUmbtzFamO53Ztn5B7Ypve4vFtrJJ22m77ZbV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    "]],
  Boxed->False,
  ImageSize->Medium,
  Lighting->"Neutral",
  PlotRange->{{0., 17.}, {-5., 11.}, {-5., 11.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1418054175]
}, Open  ]],

Cell["Export it to BYU:", "ExampleText",
 CellID->138483434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<rings.byu\>\"", ",", " ", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1049623709],

Cell[BoxData["\<\"rings.byu\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1595000705]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->674089440],

Cell["Export inline 3D graphics:", "ExampleText",
 CellID->1444980155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<spikey.byu\>\"", ",", 
   Graphics3DBox[
    GraphicsComplex3DBox[
     NCache[{{0, 0, Root[5 - 20 #^2 + 16 #^4& , 1, 0]}, {
       0, 0, Root[5 - 20 #^2 + 16 #^4& , 4, 0]}, {
       Root[1 - 5 #^2 + 5 #^4& , 1, 0], 0, Root[
        1 - 20 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 5 #^2 + 5 #^4& , 4, 0], 0, Root[
        1 - 20 #^2 + 80 #^4& , 4, 0]}, {
       Root[1 - 40 #^2 + 80 #^4& , 1, 0], Rational[-1, 2], Root[
        1 - 20 #^2 + 80 #^4& , 4, 0]}, {
       Root[1 - 40 #^2 + 80 #^4& , 1, 0], Rational[1, 2], Root[
        1 - 20 #^2 + 80 #^4& , 4, 0]}, {
       Root[1 - 40 #^2 + 80 #^4& , 4, 0], Rational[-1, 2], Root[
        1 - 20 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 40 #^2 + 80 #^4& , 4, 0], Rational[1, 2], Root[
        1 - 20 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 4, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 4, 0]}, {
       Root[1 - 290 #^2 + 2555 #^4 - 5850 #^6 + 2025 #^8& , 1, 0], 0, Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
       Root[1 - 290 #^2 + 2555 #^4 - 5850 #^6 + 2025 #^8& , 8, 0], 0, Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
       Root[1 - 740 #^2 + 3230 #^4 - 4500 #^6 + 2025 #^8& , 1, 0], 0, Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
       Root[1 - 740 #^2 + 3230 #^4 - 4500 #^6 + 2025 #^8& , 8, 0], 0, Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
       Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0], Root[
        1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
       Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0], Root[
        1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
       Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0], Root[
        1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
       Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0], Root[
        1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
       Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0], 
        Root[1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
       Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0], 
        Root[1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
       Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0], 
        Root[1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
       Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0], 
        Root[1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
       Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 1, 0], Root[
        1 + 44 # - 100 #^2 - 48 #^3 + 144 #^4& , 3, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
       Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 1, 0], Root[
        1 - 44 # - 100 #^2 + 48 #^3 + 144 #^4& , 2, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
       Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 8, 0], Root[
        1 + 44 # - 100 #^2 - 48 #^3 + 144 #^4& , 3, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
       Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 8, 0], Root[
        1 - 44 # - 100 #^2 + 48 #^3 + 144 #^4& , 2, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
       Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 1, 0], Root[
        1 + 16 # - 40 #^2 - 192 #^3 + 144 #^4& , 4, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
       Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 1, 0], Root[
        1 - 16 # - 40 #^2 + 192 #^3 + 144 #^4& , 1, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
       Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 8, 0], Root[
        1 + 16 # - 40 #^2 - 192 #^3 + 144 #^4& , 4, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
       Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 8, 0], Root[
        1 - 16 # - 40 #^2 + 192 #^3 + 144 #^4& , 1, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}}, {{
       0, 0, -0.9510565162951532}, {
       0, 0, 0.9510565162951536}, {-0.8506508083520394, 
        0, -0.4253254041760197}, {
       0.85065080835204, 0, 0.42532540417602}, {-0.6881909602355868, -0.5, 
       0.42532540417602}, {-0.6881909602355868, 0.5, 0.42532540417602}, {
       0.6881909602355868, -0.5, -0.4253254041760197}, {0.6881909602355868, 
       0.5, -0.4253254041760197}, {-0.2628655560595671, -0.8090169943749475, \
-0.4253254041760197}, {-0.2628655560595671, 
       0.8090169943749475, -0.4253254041760197}, {
       0.2628655560595668, -0.8090169943749475, 0.42532540417602}, {
       0.2628655560595668, 0.8090169943749475, 
       0.42532540417602}, {-1.5443455162844653`, 0, 0.29494374842358073`}, {
       1.5443455162844653`, 0, -0.29494374842358073`}, {-0.9544580194373125, 
        0, 1.2494017678608846`}, {
       0.954458019437308, 0, -1.2494017678608846`}, {-1.2494017678608846`, 
       0.9077435189160142, -0.29494374842358073`}, {-1.2494017678608846`, \
-0.9077435189160141, -0.29494374842358073`}, {1.2494017678608846`, 
       0.9077435189160142, 0.29494374842358073`}, {
       1.2494017678608846`, -0.9077435189160141, 
       0.29494374842358073`}, {-0.29494374842358073`, 0.9077435189160142, 
       1.2494017678608846`}, {-0.29494374842358073`, -0.9077435189160141, 
       1.2494017678608846`}, {0.29494374842358073`, 
       0.9077435189160142, -1.2494017678608846`}, {
       0.29494374842358073`, -0.9077435189160141, -1.2494017678608846`}, \
{-0.7721727581422326, 
       0.5610163477575297, -1.2494017678608846`}, {-0.7721727581422326, \
-0.5610163477575298, -1.2494017678608846`}, {0.7721727581422326, 
       0.5610163477575297, 1.2494017678608846`}, {
       0.7721727581422326, -0.5610163477575298, 
       1.2494017678608846`}, {-0.4772290097186562, 1.468759866673544, 
       0.29494374842358073`}, {-0.4772290097186562, -1.468759866673544, 
       0.29494374842358073`}, {0.477229009718654, 
       1.468759866673544, -0.29494374842358073`}, {
       0.477229009718654, -1.468759866673544, -0.29494374842358073`}}], 
     Polygon3DBox[{{21, 2, 12}, {21, 12, 6}, {21, 6, 2}, {15, 2, 6}, {15, 6, 
      5}, {15, 5, 2}, {22, 2, 5}, {22, 5, 11}, {22, 11, 2}, {28, 2, 11}, {28, 
      11, 4}, {28, 4, 2}, {27, 2, 4}, {27, 4, 12}, {27, 12, 2}, {24, 7, 9}, {
      24, 9, 1}, {24, 1, 7}, {16, 8, 7}, {16, 7, 1}, {16, 1, 8}, {23, 10, 
      8}, {23, 8, 1}, {23, 1, 10}, {25, 3, 10}, {25, 10, 1}, {25, 1, 3}, {26, 
      9, 3}, {26, 3, 1}, {26, 1, 9}, {29, 12, 10}, {29, 10, 6}, {29, 6, 12}, {
      13, 6, 3}, {13, 3, 5}, {13, 5, 6}, {30, 5, 9}, {30, 9, 11}, {30, 11, 
      5}, {20, 11, 7}, {20, 7, 4}, {20, 4, 11}, {19, 4, 8}, {19, 8, 12}, {19, 
      12, 4}, {32, 7, 11}, {32, 11, 9}, {32, 9, 7}, {14, 8, 4}, {14, 4, 7}, {
      14, 7, 8}, {31, 10, 12}, {31, 12, 8}, {31, 8, 10}, {17, 3, 6}, {17, 6, 
      10}, {17, 10, 3}, {18, 9, 5}, {18, 5, 3}, {18, 3, 9}}]],
    Boxed->False,
    ImageSize->{99.83940242220801, 100.},
    ViewPoint->{0.0030124698202508293`, -2.8066412788513992`, 
     1.8901734462405728`},
    ViewVertical->{-0.28104140417203943`, -0.07172101959684306, 
     1.183248966211339}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->355229611],

Cell[BoxData["\<\"spikey.byu\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->165680570]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BYU - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 55.7291420}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "3D geometry format. Used for visualization of 3D polygonal meshes in CAD \
systems and other applications. BYU is an acronym for Brigham Young \
University. ASCII format. Represents 3D objects as collections of polygon \
primitives. Can store multiple 3D objects.", "synonyms" -> {}, "title" -> 
    "BYU", "type" -> "Format", "uri" -> "ref/format/BYU"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[22134, 780, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 188220, 3747}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2576, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3199, 80, 101, 4, 70, "ObjectNameAlt",
 CellID->5045],
Cell[3303, 86, 307, 9, 70, "FormatUsage",
 CellID->20778],
Cell[3613, 97, 323, 12, 70, "FormatNotes",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[3973, 114, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[4040, 117, 406, 14, 70, "FormatNotes",
 CellID->2520],
Cell[4449, 133, 459, 16, 70, "FormatNotes",
 CellID->12927],
Cell[4911, 151, 39, 1, 70, "WeakDivider",
 CellID->24773],
Cell[4953, 154, 719, 24, 70, "FormatNotes",
 CellID->25134],
Cell[5675, 180, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[5717, 183, 351, 13, 70, "FormatNotes",
 CellID->22675],
Cell[6071, 198, 574, 20, 70, "FormatNotes",
 CellID->13336],
Cell[6648, 220, 582, 21, 70, "FormatNotes",
 CellID->16334],
Cell[7233, 243, 676, 24, 70, "FormatNotes",
 CellID->21001],
Cell[7912, 269, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[7953, 272, 513, 18, 70, "FormatNotes",
 CellID->9310],
Cell[8469, 292, 1075, 40, 70, "FormatNotes",
 CellID->5974],
Cell[9547, 334, 661, 22, 70, "FormatNotes",
 CellID->7590],
Cell[10211, 358, 816, 28, 70, "FormatNotes",
 CellID->20356],
Cell[11030, 388, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[11071, 391, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[11435, 407, 342, 12, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[11814, 424, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[11868, 427, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[12063, 437, 668, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[12734, 452, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[12776, 455, 187, 7, 70, "FormatNotes",
 CellID->525384128],
Cell[12966, 464, 898, 25, 70, "2ColumnTableMod",
 CellID->263380570],
Cell[13867, 491, 397, 14, 70, "FormatNotes",
 CellID->13037],
Cell[14267, 507, 68, 1, 70, "FormatNotes",
 CellID->13573],
Cell[14338, 510, 807, 19, 70, "2ColumnTableMod",
 CellID->230773093],
Cell[15148, 531, 297, 8, 70, "FormatNotes",
 CellID->1326471371],
Cell[15448, 541, 559, 19, 70, "FormatNotes",
 CellID->842184215]
}, Open  ]],
Cell[CellGroupData[{
Cell[16044, 565, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[16096, 568, 196, 8, 70, "FormatNotes",
 CellID->1911960202],
Cell[16295, 578, 1155, 31, 70, "3ColumnTableMod",
 CellID->2123520593],
Cell[17453, 611, 240, 8, 70, "FormatNotes",
 CellID->1022956994],
Cell[17696, 621, 60, 1, 70, "FormatNotes",
 CellID->2132824898],
Cell[17759, 624, 468, 12, 70, "3ColumnTableMod",
 CellID->28047],
Cell[18230, 638, 243, 7, 70, "FormatNotes",
 CellID->1642809193],
Cell[18476, 647, 759, 26, 70, "FormatNotes",
 CellID->182941150]
}, Closed]],
Cell[CellGroupData[{
Cell[19272, 678, 50, 1, 70, "SeeAlsoSection",
 CellID->20829],
Cell[19325, 681, 2250, 76, 70, "SeeAlso",
 CellID->2645]
}, Open  ]],
Cell[CellGroupData[{
Cell[21612, 762, 58, 1, 70, "MoreAboutSection",
 CellID->329426040],
Cell[21673, 765, 150, 2, 70, "MoreAbout"],
Cell[21826, 769, 135, 2, 70, "MoreAbout"],
Cell[21964, 773, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22134, 780, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[22250, 786, 60, 1, 70, "ExampleSection",
 CellID->277477022],
Cell[22313, 789, 113, 3, 70, "ExampleText",
 CellID->1615363059],
Cell[CellGroupData[{
Cell[22451, 796, 125, 3, 70, "Input",
 CellID->17199],
Cell[22579, 801, 377, 9, 70, "Output",
 CellID->2012808947]
}, Open  ]],
Cell[22971, 813, 246, 8, 70, "ExampleText",
 CellID->1964905787],
Cell[CellGroupData[{
Cell[23242, 825, 185, 6, 70, "Input",
 CellID->264564443],
Cell[23430, 833, 1434, 39, 70, "Output",
 CellID->1243444211]
}, Open  ]],
Cell[24879, 875, 71, 1, 70, "ExampleText",
 CellID->912034040],
Cell[CellGroupData[{
Cell[24975, 880, 177, 5, 70, "Input",
 CellID->168038543],
Cell[25155, 887, 738, 22, 70, "Output",
 CellID->282796396]
}, Open  ]],
Cell[25908, 912, 88, 1, 70, "ExampleText",
 CellID->714845780],
Cell[CellGroupData[{
Cell[26021, 917, 179, 5, 70, "Input",
 CellID->1403485320],
Cell[26203, 924, 609, 18, 70, "Output",
 CellID->417394592]
}, Open  ]],
Cell[26827, 945, 230, 8, 70, "ExampleText",
 CellID->1389503142],
Cell[CellGroupData[{
Cell[27082, 957, 185, 6, 70, "Input",
 CellID->1469316642],
Cell[27270, 965, 2590, 72, 70, "Output",
 CellID->890345241]
}, Open  ]],
Cell[29875, 1040, 125, 3, 70, "ExampleDelimiter",
 CellID->634825496],
Cell[30003, 1045, 227, 8, 70, "ExampleText",
 CellID->813352976],
Cell[CellGroupData[{
Cell[30255, 1057, 3643, 108, 70, "Input",
 CellID->1290054477],
Cell[33901, 1167, 143837, 2375, 70, "Output",
 CellID->1418054175]
}, Open  ]],
Cell[177753, 3545, 60, 1, 70, "ExampleText",
 CellID->138483434],
Cell[CellGroupData[{
Cell[177838, 3550, 147, 4, 70, "Input",
 CellID->1049623709],
Cell[177988, 3556, 88, 2, 70, "Output",
 CellID->1595000705]
}, Open  ]],
Cell[178091, 3561, 125, 3, 70, "ExampleDelimiter",
 CellID->674089440],
Cell[178219, 3566, 70, 1, 70, "ExampleText",
 CellID->1444980155],
Cell[CellGroupData[{
Cell[178314, 3571, 8601, 139, 70, "Input",
 CellID->355229611],
Cell[186918, 3712, 88, 2, 70, "Output",
 CellID->165680570]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[187045, 3719, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

