(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    189398,       3817]
NotebookOptionsPosition[    182025,       3580]
NotebookOutlinePosition[    183636,       3622]
CellTagsIndexPosition[    183549,       3617]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"FITS\"" :> 
          Documentation`HelpLookup["paclet:ref/format/FITS"], "\"HDF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/HDF"], "\"HDF5\"" :> 
          Documentation`HelpLookup["paclet:ref/format/HDF5"], "\"NetCDF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/NetCDF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"FITS\\\"\"\>", 
       2->"\<\"\\\"HDF\\\"\"\>", 3->"\<\"\\\"HDF5\\\"\"\>", 
       4->"\<\"\\\"NetCDF\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], 
          "Numerical Data Formats" :> 
          Documentation`HelpLookup["paclet:guide/NumericalDataFormats"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"], 
          "Scientific & Medical Data Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/ScientificAndMedicalDataFormats"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Importing & Exporting\"\>",
        2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>", 
       4->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       5->"\<\"New in 6.0: Import & Export Formats\"\>", 
       6->"\<\"Numerical Data Formats\"\>", 7->"\<\"Raster Image Formats\"\>",
        8->"\<\"Scientific & Medical Data Formats\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "CDF ",
 StyleBox["(.cdf)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->29426],

Cell[TextData[{
 "MIME type: ",
 StyleBox["application/x-cdf", "InlineCode"],
 "\nCDF data file format.\nGeneral-purpose, self-describing format for \
storing multidimensional datasets.\nUsed for storage, management, and \
exchange of scientific data and images.\nCDF is an acronym for Common Data \
Format.\nDeveloped in 1985 by the National Space Science Data Center at NASA.\
\nBinary file format.\nRelated to, but incompatible with, netCDF."
}], "FormatUsage",
 CellID->15871],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " supports CDF 3.1 and earlier versions."
}], "FormatNotes",
 CellID->10697],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by default exports CDF 2.7 files, and can also generate 64-bit enhanced \
CDF 3.1 files.  "
}], "FormatNotes",
 CellID->634337019]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->17612],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cdf\>\"", "]"}]], "InlineFormula"],
 " imports a CDF file, returning the names of the datasets stored in the \
file."
}], "FormatNotes",
 CellID->18703],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cdf\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports an array or a ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " object to a ",
 "CDF",
 " file."
}], "FormatNotes",
 CellID->11027],

Cell["", "WeakDivider",
 CellID->5545],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cdf\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a list of strings representing the names of all datasets contained \
in the file."
}], "FormatNotes",
 CellID->9508],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cdf\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<Datasets\>\"", ",", " ", 
       RowBox[{"{", 
        RowBox[{"\"\</dataset1\>\"", ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}], " "}]], 
  "InlineFormula"],
 "creates a CDF file, storing the arrays or ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " objects ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " as separate datasets."
}], "FormatNotes",
 CellID->1233989338],

Cell["", "WeakDivider",
 CellID->24237],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cdf\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a CDF file."
}], "FormatNotes",
 CellID->26443],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cdf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->21313],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cdf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->22501],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<CDF\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<CDF\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8850],

Cell["", "WeakDivider",
 CellID->25128],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cdf\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a CDF file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->2111],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cdf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->23650],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cdf\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->28149],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cdf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->11192],

Cell["", "WeakDivider",
 CellID->1454],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->15869],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "CDF",
 " format."
}], "FormatNotes",
 CellID->681]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->27465],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->20267],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->17713],

Cell["", "WeakDivider",
 CellID->19793],

Cell["Data representation elements:", "FormatNotes",
 CellID->2027411603],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "all datasets imported as a list of arrays", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Datasets\>\"", Cell[
    "names of all datasets", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->629581695],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<Datasets\>\""], "InlineFormula"],
 " element for the CDF format."
}], "FormatNotes",
 CellID->2128534904],

Cell["Specifying and selecting datasets:", "FormatNotes",
 CellID->18634],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Datasets\>\"", ",", " ", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "th dataset"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Datasets\>\"", ",", " ", 
     StyleBox["dataset", "TI"]}], Cell["named dataset", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->517846341],

Cell[TextData[{
 "The following values can be given for ",
 Cell[BoxData["\"\<DataFormat\>\""], "InlineFormula"],
 ":"
}], "FormatNotes",
 CellID->727619096],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Date\>\"", Cell[TextData[{
     "dates, given as ",
     Cell[BoxData[
      ButtonBox["DateList",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
     " specifications"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer8\>\"", Cell[
    "8-bit integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer16\>\"", Cell[
    "16-bit integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer32\>\"", Cell[
    "32-bit integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger8\>\"", Cell[
    "unsigned 8-bit integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger16\>\"", Cell[
    "unsigned 16-bit integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger32\>\"", Cell[
    "unsigned 32-bit integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Real32\>\"", Cell[
    "IEEE single\[Hyphen]precision numbers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Real64\>\"", Cell[
    "IEEE double\[Hyphen]precision numbers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<String\>\"", Cell[
    "strings of ASCII characters", "TableText"]}
  },
  GridBoxAlignment->{"Columns" -> {Left, {Left}}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->19976],

Cell["Meta-information elements:", "FormatNotes",
 CellID->914246541],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Annotations\>\"", Cell[
    "meta-information for each dataset", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DataEncoding\>\"", Cell[
    "specifies how each dataset is compressed", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DataFormat\>\"", Cell[
    "type used to represent each dataset", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Dimensions\>\"", Cell[
    "data dimensions of each dataset", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Metadata\>\"", Cell[
    "general meta-information as a list of rules", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->496120302],

Cell[TextData[{
 Cell[BoxData["\"\<DataEncoding\>\""], "InlineFormula"],
 " can take the following values:"
}], "FormatNotes",
 CellID->242171646],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no data compression is used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AdaptiveHuffman\>\"", Cell[
    "adaptive Huffman encoding", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GZIP\>\"", Cell[
    "GZIP compression", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Huffman\>\"", Cell[
    "Huffman encoding", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RLE\>\"", Cell[
    "run-length encoding", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->1429858720]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->8823],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1322260454],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Append\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to append to an existing file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LargeFileSupport\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to export a 64-bit CDF file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1070671222],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<LargeFileSupport\>\"", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the exported file uses a 32-bit data representation conforming to Version \
2.7 of the CDF format."
}], "FormatNotes",
 CellID->431430963],

Cell[TextData[{
 "64-bit enhanced CDF 3.1 files can be created with ",
 Cell[BoxData[
  RowBox[{"\"\<LargeFileSupport\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1155402869]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->2742],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<FITS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/FITS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<HDF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/HDF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<HDF5\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/HDF5"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NetCDF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NetCDF"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2017119098]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->472627310],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalDataFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Scientific & Medical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScientificAndMedicalDataFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->71846128],

Cell["Show the import elements available in the example file:", "ExampleText",
 CellID->1946355481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/cacsst2.cdf\>\"", ",", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1398846610],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Data\"\>", ",", "\<\"DataEncoding\"\>", 
   ",", "\<\"Datasets\"\>", ",", "\<\"Metadata\"\>"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1700358518]
}, Open  ]],

Cell["Read all meta-information:", "ExampleText",
 CellID->1956504551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/cacsst2.cdf\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<Metadata\>\"", ",", "\"\<TITLE\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->66499607],

Cell[BoxData[
 RowBox[{"{", "\<\"Climate Analysis Center SST blended analysis\"\>", 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1042215832]
}, Open  ]],

Cell["Get the dataset names:", "ExampleText",
 CellID->702385793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/cacsst2.cdf\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7128],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"LATITUDE\"\>", ",", "\<\"LONGITUD\"\>", ",", "\<\"SST\"\>", 
   ",", "\<\"EPOCH\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1644863492]
}, Open  ]],

Cell[TextData[{
 "Import the ",
 Cell[BoxData["\"\<LATITUDE\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<LONGITUD\>\""], "InlineFormula"],
 " datasets:"
}], "ExampleText",
 CellID->280415392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/cacsst2.cdf\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<Datasets\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<LATITUDE\>\"", ",", "\"\<LONGITUD\>\""}], "}"}]}], "}"}]}],
   "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1617190901],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "90"}], ",", 
      RowBox[{"-", "88"}], ",", 
      RowBox[{"-", "86"}], ",", 
      RowBox[{"-", "84"}], ",", 
      RowBox[{"-", "82"}], ",", 
      RowBox[{"-", "80"}], ",", 
      RowBox[{"-", "78"}], ",", 
      RowBox[{"-", "76"}], ",", 
      RowBox[{"-", "74"}], ",", 
      RowBox[{"-", "72"}], ",", 
      RowBox[{"-", "70"}], ",", 
      RowBox[{"-", "68"}], ",", 
      RowBox[{"-", "66"}], ",", 
      RowBox[{"-", "64"}], ",", 
      RowBox[{"-", "62"}], ",", 
      RowBox[{"-", "60"}], ",", 
      RowBox[{"-", "58"}], ",", 
      RowBox[{"-", "56"}], ",", 
      RowBox[{"-", "54"}], ",", 
      RowBox[{"-", "52"}], ",", 
      RowBox[{"-", "50"}], ",", 
      RowBox[{"-", "48"}], ",", 
      RowBox[{"-", "46"}], ",", 
      RowBox[{"-", "44"}], ",", 
      RowBox[{"-", "42"}], ",", 
      RowBox[{"-", "40"}], ",", 
      RowBox[{"-", "38"}], ",", 
      RowBox[{"-", "36"}], ",", 
      RowBox[{"-", "34"}], ",", 
      RowBox[{"-", "32"}], ",", 
      RowBox[{"-", "30"}], ",", 
      RowBox[{"-", "28"}], ",", 
      RowBox[{"-", "26"}], ",", 
      RowBox[{"-", "24"}], ",", 
      RowBox[{"-", "22"}], ",", 
      RowBox[{"-", "20"}], ",", 
      RowBox[{"-", "18"}], ",", 
      RowBox[{"-", "16"}], ",", 
      RowBox[{"-", "14"}], ",", 
      RowBox[{"-", "12"}], ",", 
      RowBox[{"-", "10"}], ",", 
      RowBox[{"-", "8"}], ",", 
      RowBox[{"-", "6"}], ",", 
      RowBox[{"-", "4"}], ",", 
      RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "4", ",", "6", ",", "8", 
      ",", "10", ",", "12", ",", "14", ",", "16", ",", "18", ",", "20", ",", 
      "22", ",", "24", ",", "26", ",", "28", ",", "30", ",", "32", ",", "34", 
      ",", "36", ",", "38", ",", "40", ",", "42", ",", "44", ",", "46", ",", 
      "48", ",", "50", ",", "52", ",", "54", ",", "56", ",", "58", ",", "60", 
      ",", "62", ",", "64", ",", "66", ",", "68", ",", "70", ",", "72", ",", 
      "74", ",", "76", ",", "78", ",", "80", ",", "82", ",", "84", ",", "86", 
      ",", "88", ",", "90"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "178"}], ",", 
      RowBox[{"-", "176"}], ",", 
      RowBox[{"-", "174"}], ",", 
      RowBox[{"-", "172"}], ",", 
      RowBox[{"-", "170"}], ",", 
      RowBox[{"-", "168"}], ",", 
      RowBox[{"-", "166"}], ",", 
      RowBox[{"-", "164"}], ",", 
      RowBox[{"-", "162"}], ",", 
      RowBox[{"-", "160"}], ",", 
      RowBox[{"-", "158"}], ",", 
      RowBox[{"-", "156"}], ",", 
      RowBox[{"-", "154"}], ",", 
      RowBox[{"-", "152"}], ",", 
      RowBox[{"-", "150"}], ",", 
      RowBox[{"-", "148"}], ",", 
      RowBox[{"-", "146"}], ",", 
      RowBox[{"-", "144"}], ",", 
      RowBox[{"-", "142"}], ",", 
      RowBox[{"-", "140"}], ",", 
      RowBox[{"-", "138"}], ",", 
      RowBox[{"-", "136"}], ",", 
      RowBox[{"-", "134"}], ",", 
      RowBox[{"-", "132"}], ",", 
      RowBox[{"-", "130"}], ",", 
      RowBox[{"-", "128"}], ",", 
      RowBox[{"-", "126"}], ",", 
      RowBox[{"-", "124"}], ",", 
      RowBox[{"-", "122"}], ",", 
      RowBox[{"-", "120"}], ",", 
      RowBox[{"-", "118"}], ",", 
      RowBox[{"-", "116"}], ",", 
      RowBox[{"-", "114"}], ",", 
      RowBox[{"-", "112"}], ",", 
      RowBox[{"-", "110"}], ",", 
      RowBox[{"-", "108"}], ",", 
      RowBox[{"-", "106"}], ",", 
      RowBox[{"-", "104"}], ",", 
      RowBox[{"-", "102"}], ",", 
      RowBox[{"-", "100"}], ",", 
      RowBox[{"-", "98"}], ",", 
      RowBox[{"-", "96"}], ",", 
      RowBox[{"-", "94"}], ",", 
      RowBox[{"-", "92"}], ",", 
      RowBox[{"-", "90"}], ",", 
      RowBox[{"-", "88"}], ",", 
      RowBox[{"-", "86"}], ",", 
      RowBox[{"-", "84"}], ",", 
      RowBox[{"-", "82"}], ",", 
      RowBox[{"-", "80"}], ",", 
      RowBox[{"-", "78"}], ",", 
      RowBox[{"-", "76"}], ",", 
      RowBox[{"-", "74"}], ",", 
      RowBox[{"-", "72"}], ",", 
      RowBox[{"-", "70"}], ",", 
      RowBox[{"-", "68"}], ",", 
      RowBox[{"-", "66"}], ",", 
      RowBox[{"-", "64"}], ",", 
      RowBox[{"-", "62"}], ",", 
      RowBox[{"-", "60"}], ",", 
      RowBox[{"-", "58"}], ",", 
      RowBox[{"-", "56"}], ",", 
      RowBox[{"-", "54"}], ",", 
      RowBox[{"-", "52"}], ",", 
      RowBox[{"-", "50"}], ",", 
      RowBox[{"-", "48"}], ",", 
      RowBox[{"-", "46"}], ",", 
      RowBox[{"-", "44"}], ",", 
      RowBox[{"-", "42"}], ",", 
      RowBox[{"-", "40"}], ",", 
      RowBox[{"-", "38"}], ",", 
      RowBox[{"-", "36"}], ",", 
      RowBox[{"-", "34"}], ",", 
      RowBox[{"-", "32"}], ",", 
      RowBox[{"-", "30"}], ",", 
      RowBox[{"-", "28"}], ",", 
      RowBox[{"-", "26"}], ",", 
      RowBox[{"-", "24"}], ",", 
      RowBox[{"-", "22"}], ",", 
      RowBox[{"-", "20"}], ",", 
      RowBox[{"-", "18"}], ",", 
      RowBox[{"-", "16"}], ",", 
      RowBox[{"-", "14"}], ",", 
      RowBox[{"-", "12"}], ",", 
      RowBox[{"-", "10"}], ",", 
      RowBox[{"-", "8"}], ",", 
      RowBox[{"-", "6"}], ",", 
      RowBox[{"-", "4"}], ",", 
      RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "4", ",", "6", ",", "8", 
      ",", "10", ",", "12", ",", "14", ",", "16", ",", "18", ",", "20", ",", 
      "22", ",", "24", ",", "26", ",", "28", ",", "30", ",", "32", ",", "34", 
      ",", "36", ",", "38", ",", "40", ",", "42", ",", "44", ",", "46", ",", 
      "48", ",", "50", ",", "52", ",", "54", ",", "56", ",", "58", ",", "60", 
      ",", "62", ",", "64", ",", "66", ",", "68", ",", "70", ",", "72", ",", 
      "74", ",", "76", ",", "78", ",", "80", ",", "82", ",", "84", ",", "86", 
      ",", "88", ",", "90", ",", "92", ",", "94", ",", "96", ",", "98", ",", 
      "100", ",", "102", ",", "104", ",", "106", ",", "108", ",", "110", ",", 
      "112", ",", "114", ",", "116", ",", "118", ",", "120", ",", "122", ",", 
      "124", ",", "126", ",", "128", ",", "130", ",", "132", ",", "134", ",", 
      "136", ",", "138", ",", "140", ",", "142", ",", "144", ",", "146", ",", 
      "148", ",", "150", ",", "152", ",", "154", ",", "156", ",", "158", ",", 
      "160", ",", "162", ",", "164", ",", "166", ",", "168", ",", "170", ",", 
      "172", ",", "174", ",", "176", ",", "178", ",", "180"}], "}"}], "}"}]}],
   "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->663722213]
}, Open  ]],

Cell[TextData[{
 "Importing the ",
 Cell[BoxData["\"\<EPOCH\>\""], "InlineFormula"],
 " dataset returns a date in the form given by ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->912635268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/cacsst2.cdf\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<Datasets\>\"", ",", "\"\<EPOCH\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1490067714],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1982", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0.`"}], 
   "}"}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->865455304]
}, Open  ]],

Cell[TextData[{
 "Read a data array from the example file and render it using ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1147112204],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Import", "[", 
    RowBox[{"\"\<ExampleData/cacsst2.cdf\>\"", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<Datasets\>\"", ",", "\"\<SST\>\""}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], " ", "//", " ", "MatrixPlot"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->607961269],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzsvXlUTm0b918qUjI1mIpCmgxFhcSXkKFBiFIhEY0UGUqIBkVSSSVJkhSh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   "], {{0, 0}, {91, 180}}, {0, 1}],
  Frame->True,
  FrameLabel->{None, None},
  FrameTicks->{{{{179.5, 
       FormBox["1", TraditionalForm]}, {130.5, 
       FormBox["50", TraditionalForm]}, {80.5, 
       FormBox["100", TraditionalForm]}, {30.5, 
       FormBox["150", TraditionalForm]}, {0.5, 
       FormBox["180", TraditionalForm]}}, {{179.5, 
       FormBox["1", TraditionalForm]}, {130.5, 
       FormBox["50", TraditionalForm]}, {80.5, 
       FormBox["100", TraditionalForm]}, {30.5, 
       FormBox["150", TraditionalForm]}, {0.5, 
       FormBox["180", TraditionalForm]}}}, {{{0.5, 
       FormBox["1", TraditionalForm]}, {19.5, 
       FormBox["20", TraditionalForm]}, {39.5, 
       FormBox["40", TraditionalForm]}, {59.5, 
       FormBox["60", TraditionalForm]}, {79.5, 
       FormBox["80", TraditionalForm]}, {90.5, 
       FormBox["91", TraditionalForm]}}, {{0.5, 
       FormBox["1", TraditionalForm]}, {19.5, 
       FormBox["20", TraditionalForm]}, {39.5, 
       FormBox["40", TraditionalForm]}, {59.5, 
       FormBox["60", TraditionalForm]}, {79.5, 
       FormBox["80", TraditionalForm]}, {90.5, 
       FormBox["91", TraditionalForm]}}}},
  PlotRangeClipping->True]], "Output",
 CellLabel->"Out[6]=",
 CellID->1149171373]
}, Open  ]],

Cell["\<\
Rasterize the earlier graphics and export them as an array of color values to \
CDF:\
\>", "ExampleText",
 CellID->1373469442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<sample.cdf\>\"", ",", 
   RowBox[{"Rasterize", "[", 
    RowBox[{"%", ",", "\"\<Data\>\""}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1466800071],

Cell[BoxData["\<\"sample.cdf\"\>"], "Output",
 CellLabel->"Out[7]=",
 CellID->1544009384]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->327299877],

Cell["\<\
Export a list of integers to CDF, explicitly specifying the dataset name:\
\>", "ExampleText",
 CellID->710045320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<numbers.cdf\>\"", ",", 
   RowBox[{"\"\<mydataset\>\"", "->", 
    RowBox[{"Range", "[", "10", "]"}]}], ",", "\"\<Datasets\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1223412772],

Cell[BoxData["\<\"numbers.cdf\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1840623609]
}, Open  ]],

Cell["This imports the generated CDF file:", "ExampleText",
 CellID->253896692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<numbers.cdf\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Datasets\>\"", ",", "\"\<mydataset\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1617493386],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->712861615]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CDF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 57.7448186}", "context" -> "", 
    "keywords" -> {
     "scientific data", "oceanography", "meteorology", "atmospheric science", 
      "NCSA", "NASA", "remote sensing"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: application/x-cdf CDF data file format. General-purpose, \
self-describing format for storing multidimensional datasets. Used for \
storage, management, and exchange of scientific data and images. CDF is an \
acronym for Common Data Format. Developed in 1985 by the National Space \
Science Data Center at NASA. Binary file format. Related to, but incompatible \
with, netCDF.", "synonyms" -> {}, "title" -> "CDF", "type" -> "Format", "uri" -> 
    "ref/format/CDF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[23164, 767, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 183415, 3610}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2784, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3407, 87, 102, 4, 70, "ObjectNameAlt",
 CellID->29426],
Cell[3512, 93, 480, 9, 70, "FormatUsage",
 CellID->15871],
Cell[3995, 104, 208, 7, 70, "FormatNotes",
 CellID->10697],
Cell[4206, 113, 198, 6, 70, "FormatNotes",
 CellID->634337019]
}, Open  ]],
Cell[CellGroupData[{
Cell[4441, 124, 64, 1, 70, "ImportExportSection",
 CellID->17612],
Cell[4508, 127, 324, 10, 70, "FormatNotes",
 CellID->18703],
Cell[4835, 139, 473, 18, 70, "FormatNotes",
 CellID->11027],
Cell[5311, 159, 38, 1, 70, "WeakDivider",
 CellID->5545],
Cell[5352, 162, 356, 11, 70, "FormatNotes",
 CellID->9508],
Cell[5711, 175, 1054, 36, 70, "FormatNotes",
 CellID->1233989338],
Cell[6768, 213, 39, 1, 70, "WeakDivider",
 CellID->24237],
Cell[6810, 216, 341, 11, 70, "FormatNotes",
 CellID->26443],
Cell[7154, 229, 574, 20, 70, "FormatNotes",
 CellID->21313],
Cell[7731, 251, 582, 21, 70, "FormatNotes",
 CellID->22501],
Cell[8316, 274, 702, 25, 70, "FormatNotes",
 CellID->8850],
Cell[9021, 301, 39, 1, 70, "WeakDivider",
 CellID->25128],
Cell[9063, 304, 518, 18, 70, "FormatNotes",
 CellID->2111],
Cell[9584, 324, 1076, 40, 70, "FormatNotes",
 CellID->23650],
Cell[10663, 366, 662, 22, 70, "FormatNotes",
 CellID->28149],
Cell[11328, 390, 816, 28, 70, "FormatNotes",
 CellID->11192],
Cell[12147, 420, 38, 1, 70, "WeakDivider",
 CellID->1454],
Cell[12188, 423, 361, 14, 70, "FormatNotes",
 CellID->15869],
Cell[12552, 439, 350, 14, 70, "FormatNotes",
 CellID->681]
}, Closed]],
Cell[CellGroupData[{
Cell[12939, 458, 51, 1, 70, "ElementsSection",
 CellID->27465],
Cell[12993, 461, 192, 8, 70, "FormatNotes",
 CellID->20267],
Cell[13188, 471, 668, 13, 70, "2ColumnTableMod",
 CellID->17713],
Cell[13859, 486, 39, 1, 70, "WeakDivider",
 CellID->19793],
Cell[13901, 489, 73, 1, 70, "FormatNotes",
 CellID->2027411603],
Cell[13977, 492, 490, 11, 70, "2ColumnTableMod",
 CellID->629581695],
Cell[14470, 505, 281, 9, 70, "FormatNotes",
 CellID->2128534904],
Cell[14754, 516, 73, 1, 70, "FormatNotes",
 CellID->18634],
Cell[14830, 519, 643, 17, 70, "2ColumnTableMod",
 CellID->517846341],
Cell[15476, 538, 157, 5, 70, "FormatNotes",
 CellID->727619096],
Cell[15636, 545, 1695, 37, 70, "2ColumnTableMod",
 CellID->19976],
Cell[17334, 584, 69, 1, 70, "FormatNotes",
 CellID->914246541],
Cell[17406, 587, 916, 17, 70, "2ColumnTableMod",
 CellID->496120302],
Cell[18325, 606, 146, 4, 70, "FormatNotes",
 CellID->242171646],
Cell[18474, 612, 888, 20, 70, "2ColumnTableMod",
 CellID->1429858720]
}, Open  ]],
Cell[CellGroupData[{
Cell[19399, 637, 48, 1, 70, "OptionsSection",
 CellID->8823],
Cell[19450, 640, 183, 7, 70, "FormatNotes",
 CellID->1322260454],
Cell[19636, 649, 683, 17, 70, "3ColumnTableMod",
 CellID->1070671222],
Cell[20322, 668, 351, 10, 70, "FormatNotes",
 CellID->431430963],
Cell[20676, 680, 276, 9, 70, "FormatNotes",
 CellID->1155402869]
}, Closed]],
Cell[CellGroupData[{
Cell[20989, 694, 49, 1, 70, "SeeAlsoSection",
 CellID->2742],
Cell[21041, 697, 808, 27, 70, "SeeAlso",
 CellID->2017119098]
}, Open  ]],
Cell[CellGroupData[{
Cell[21886, 729, 58, 1, 70, "MoreAboutSection",
 CellID->472627310],
Cell[21947, 732, 151, 2, 70, "MoreAbout"],
Cell[22101, 736, 134, 2, 70, "MoreAbout"],
Cell[22238, 740, 133, 2, 70, "MoreAbout"],
Cell[22374, 744, 165, 2, 70, "MoreAbout"],
Cell[22542, 748, 156, 2, 70, "MoreAbout"],
Cell[22701, 752, 134, 2, 70, "MoreAbout"],
Cell[22838, 756, 130, 2, 70, "MoreAbout"],
Cell[22971, 760, 156, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23164, 767, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[23280, 773, 59, 1, 70, "ExampleSection",
 CellID->71846128],
Cell[23342, 776, 99, 1, 70, "ExampleText",
 CellID->1946355481],
Cell[CellGroupData[{
Cell[23466, 781, 174, 5, 70, "Input",
 CellID->1398846610],
Cell[23643, 788, 201, 5, 70, "Output",
 CellID->1700358518]
}, Open  ]],
Cell[23859, 796, 70, 1, 70, "ExampleText",
 CellID->1956504551],
Cell[CellGroupData[{
Cell[23954, 801, 238, 7, 70, "Input",
 CellID->66499607],
Cell[24195, 810, 148, 4, 70, "Output",
 CellID->1042215832]
}, Open  ]],
Cell[24358, 817, 65, 1, 70, "ExampleText",
 CellID->702385793],
Cell[CellGroupData[{
Cell[24448, 822, 127, 3, 70, "Input",
 CellID->7128],
Cell[24578, 827, 193, 5, 70, "Output",
 CellID->1644863492]
}, Open  ]],
Cell[24786, 835, 200, 7, 70, "ExampleText",
 CellID->280415392],
Cell[CellGroupData[{
Cell[25011, 846, 311, 9, 70, "Input",
 CellID->1617190901],
Cell[25325, 857, 6368, 166, 70, "Output",
 CellID->663722213]
}, Open  ]],
Cell[31708, 1026, 297, 10, 70, "ExampleText",
 CellID->912635268],
Cell[CellGroupData[{
Cell[32030, 1040, 240, 7, 70, "Input",
 CellID->1490067714],
Cell[32273, 1049, 189, 6, 70, "Output",
 CellID->865455304]
}, Open  ]],
Cell[32477, 1058, 248, 8, 70, "ExampleText",
 CellID->1147112204],
Cell[CellGroupData[{
Cell[32750, 1070, 336, 9, 70, "Input",
 CellID->607961269],
Cell[33089, 1081, 147200, 2422, 70, "Output",
 CellID->1149171373]
}, Open  ]],
Cell[180304, 3506, 136, 4, 70, "ExampleText",
 CellID->1373469442],
Cell[CellGroupData[{
Cell[180465, 3514, 216, 6, 70, "Input",
 CellID->1466800071],
Cell[180684, 3522, 89, 2, 70, "Output",
 CellID->1544009384]
}, Open  ]],
Cell[180788, 3527, 125, 3, 70, "ExampleDelimiter",
 CellID->327299877],
Cell[180916, 3532, 124, 3, 70, "ExampleText",
 CellID->710045320],
Cell[CellGroupData[{
Cell[181065, 3539, 248, 7, 70, "Input",
 CellID->1223412772],
Cell[181316, 3548, 90, 2, 70, "Output",
 CellID->1840623609]
}, Open  ]],
Cell[181421, 3553, 79, 1, 70, "ExampleText",
 CellID->253896692],
Cell[CellGroupData[{
Cell[181525, 3558, 227, 7, 70, "Input",
 CellID->1617493386],
Cell[181755, 3567, 204, 6, 70, "Output",
 CellID->712861615]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[181998, 3578, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

