(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44508,       1476]
NotebookOptionsPosition[     37458,       1253]
NotebookOutlinePosition[     38885,       1292]
CellTagsIndexPosition[     38799,       1287]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Basic Formats" :> 
         Documentation`HelpLookup["paclet:guide/BasicFormats"], 
         "Importing & Exporting" :> 
         Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
         "Listing of All Formats" :> 
         Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
         "List Manipulation" :> 
         Documentation`HelpLookup["paclet:guide/ListManipulation"], 
         "Matrices and Linear Algebra" :> 
         Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
         "Numerical Data" :> 
         Documentation`HelpLookup["paclet:guide/NumericalData"], 
         "Numerical Data Formats" :> 
         Documentation`HelpLookup["paclet:guide/NumericalDataFormats"], 
         "Statistics" :> Documentation`HelpLookup["paclet:guide/Statistics"], 
         "Tabular & Spreadsheet Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/TabularAndSpreadsheetFormats"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Basic Formats\"\>", 
      2->"\<\"Importing & Exporting\"\>", 3->"\<\"Listing of All Formats\"\>",
       4->"\<\"List Manipulation\"\>", 
      5->"\<\"Matrices and Linear Algebra\"\>", 6->"\<\"Numerical Data\"\>", 
      7->"\<\"Numerical Data Formats\"\>", 8->"\<\"Statistics\"\>", 
      9->"\<\"Tabular & Spreadsheet Formats\"\>"}, "\<\"more about\"\>", 
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "CSV ",
 StyleBox["(.csv)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "MIME type: ",
 StyleBox["text/comma-separated-values", "InlineCode"],
 ", ",
 StyleBox["text/csv", "InlineCode"],
 " \nCSV tabular data format.\nStores records of numerical and textual \
information as lines, using commas to separate fields.\nCommonly used in \
spreadsheet applications as an exchange format.\nCSV is an acronym for \
Comma-Separated Values.\nPlain text format.\nSimilar to TSV."
}], "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the CSV format and provide various data conversion and \
formatting options. "
}], "FormatNotes",
 CellID->344331575],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically recognizes common number formats, including C and Fortran \
notations."
}], "FormatNotes",
 CellID->56646289],

Cell["Numbers without decimal points are imported as integers.", "FormatNotes",
 CellID->718923602]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).csv\>\"", "]"}]], "InlineFormula"],
 " imports a CSV file, returning an array."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).csv\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a table to a CSV file."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).csv\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a list of lists containing strings and numbers, representing the \
rows and columns stored in the file."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).csv\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "creates a CSV file from a table ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", using the ",
 Cell[BoxData[
  ButtonBox["CForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CForm"]], "InlineFormula"],
 " of non-numeric table elements."
}], "FormatNotes",
 CellID->7572],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically transforms arbitrary expressions to a list of lists when \
exporting to CSV."
}], "FormatNotes",
 CellID->1052031979],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).csv\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a CSV file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).csv\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).csv\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<CSV\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<CSV\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).csv\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a CSV file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).csv\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).csv\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).csv\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the CSV format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->2075609843],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook as a CSV file."
}], "FormatNotes",
 CellID->1050269433]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell["\<\
two-dimensional array, representing the rows and columns of a .csv file\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Grid\>\"", Cell[TextData[{
     "table data as a ",
     Cell[BoxData[
      ButtonBox["Grid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
     " object"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1019936196],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->853175818],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->577662107],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how data is aligned within table columns", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CharacterEncoding"], "\"\<UTF8\>\"", Cell[
    "raw character encoding used in the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->275885706],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1175867229],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->431454156],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CharacterEncoding"], "\"\<ASCII\>\"", Cell[
    "raw character encoding used in the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1545207620],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->363422294],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EmptyField\>\"", "\"\<\>\"", Cell[
    "how to represent empty fields", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TextDelimiters\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "string or list of strings used to delimit non-numeric fields", 
     "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->595003190],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " delimits text fields containing commas with double-quote characters."
}], "FormatNotes",
 CellID->751587654],

Cell[TextData[{
 "With an explicit setting of ",
 Cell[BoxData["\"\<TextDelimiters\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " always uses the specified string tokens to delimit text fields, \
effectively cycling through the list of delimiters."
}], "FormatNotes",
 CellID->1294656327],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<TextDelimiters\>\"", " "}]], "InlineFormula"],
 Cell[BoxData[
  RowBox[{"->", " ", "\"\<\\\"\>\""}]], "InlineFormula"],
 " puts double quotes around each text field when exporting to CSV. "
}], "FormatNotes",
 CellID->1132802757],

Cell["\<\
Double-quote characters delimiting text fields are not imported by default.\
\>", "FormatNotes",
 CellID->434889124],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->175377388],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CurrencyTokens\>\"", 
    RowBox[{
     StyleBox["{", "MR"], 
     RowBox[{
      RowBox[{
       StyleBox["{", "MR"], 
       RowBox[{
        StyleBox[
         RowBox[{"\"\<\>", "$", "\"\<\>"}], "MR"], 
        StyleBox[",", "MR"], " ", 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Sterling]",
          TraditionalForm], "\"\<\>"}], ",", 
        StyleBox[" ", "TR"], 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Yen]",
          TraditionalForm], 
         StyleBox["\"\<\>", "MR"]}], 
        StyleBox[",", "MR"], " ", 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Euro]",
          TraditionalForm], "\"\<\>"}]}], "}"}], ",", 
      StyleBox[" ", "TR"], 
      RowBox[{
       StyleBox["{", "MR"], 
       RowBox[{
        StyleBox[
         RowBox[{"\"\<\>", "c", "\"\<\>"}], "MR"], 
        StyleBox[",", "MR"], " ", 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Cent]",
          TraditionalForm], "\"\<\>"}], ",", 
        StyleBox[" ", "TR"], 
        StyleBox[
         RowBox[{"\"\<\>", "p", "\"\<\>"}], "MR"], 
        StyleBox[",", "MR"], " ", 
        StyleBox[
         RowBox[{"\"\<\>", "F", "\"\<\>"}], "MR"]}], 
       StyleBox["}", "MR"]}]}], 
     StyleBox["}", "MR"]}], Cell[
    "currency units to be skipped when importing numerical values", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DateStringFormat\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "date format, given as a ",
     Cell[BoxData[
      ButtonBox["DateString",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
     " specification"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EmptyField\>\"", "\"\<\>\"", Cell[
    "how to represent empty fields", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Numeric\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to import data fields as numbers if possible", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NumberSigns\>\"", 
    RowBox[{"{", 
     RowBox[{"\"\<-\>\"", ",", "\"\<+\>\""}], "}"}], Cell[
    "strings to use for signs of negative and positive numbers", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HeaderLines\>\"", "0", Cell[
    "number of lines to skip at the beginning of the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->1220196432],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " converts table entries formatted as specified by the",
 Cell[BoxData[
  RowBox[{"\"\<DateStringFormat\>\"", " "}]], "InlineFormula"],
 "option to a ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " representation of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["d", "TI"], ",", 
    StyleBox["h", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["s", "TI"]}], "}"}]], "InlineFormula"],
 ". "
}], "FormatNotes",
 CellID->968510758],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<Numeric\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", numbers will be imported as strings in the form they appear in the file."
}], "FormatNotes",
 CellID->2005072920],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically recognizes all common conventions for the encoding of \
line-separator characters."
}], "FormatNotes",
 CellID->1534753898],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->1643820035],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<TableHeadings\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "headings for table columns and rows", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->306209590],

Cell[TextData[{
 Cell[BoxData["\"\<TableHeadings\>\""], "InlineFormula"],
 " can be set to the following values: "
}], "FormatNotes",
 CellID->5556],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no labels", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "gives successive integer labels for columns and rows", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"col\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"col\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "list of column labels ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox[
      RowBox[{"rhead", ",", "chead"}], "TI"], "}"}], Cell[
    "specifies separate labels for the rows and columns", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1993],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " encodes line separator characters using the convention of the computer \
system on which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is being run."
}], "FormatNotes",
 CellID->1182679569]
}, Closed]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->36816911],

Cell[TextData[ButtonBox["Basic Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout"],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalDataFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout"],

Cell[TextData[ButtonBox["Tabular & Spreadsheet Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TabularAndSpreadsheetFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->122155417],

Cell["Import a CSV file, showing the first 10 entries:", "ExampleText",
 CellID->531378726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Take", "[", " ", 
   RowBox[{
    RowBox[{
    "Import", "[", "\"\<ExampleData/financialtimeseries.csv\>\"", "]"}], ",", 
    "10"}], "]"}], " ", "//", " ", "TableForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1842837129],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Jan 03 2006\"\>", "11.82`"},
    {"\<\"Jan 04 2006\"\>", "12.04`"},
    {"\<\"Jan 05 2006\"\>", "12.09`"},
    {"\<\"Jan 06 2006\"\>", "11.88`"},
    {"\<\"Jan 09 2006\"\>", "12.43`"},
    {"\<\"Jan 10 2006\"\>", "12.48`"},
    {"\<\"Jan 11 2006\"\>", "12.61`"},
    {"\<\"Jan 12 2006\"\>", "12.76`"},
    {"\<\"Jan 13 2006\"\>", "12.54`"},
    {"\<\"Jan 17 2006\"\>", "12.54`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$5352]]]], "Output",
 CellLabel->"Out[1]//TableForm=",
 CellID->1645243656]
}, Open  ]],

Cell["\<\
Import this file, specifying what format to use for parsing dates:\
\>", "ExampleText",
 CellID->1024386781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Take", "[", " ", 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{"\"\<ExampleData/financialtimeseries.csv\>\"", ",", " ", 
      RowBox[{"\"\<DateStringFormat\>\"", " ", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
        "\"\<MonthNameShort\>\"", ",", "\"\<Day\>\"", ",", "\"\<Year\>\""}], 
        "}"}]}]}], "]"}], ",", "10"}], "]"}], "  "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->384919377],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2006", ",", "1", ",", "3"}], "}"}], ",", "11.82`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2006", ",", "1", ",", "4"}], "}"}], ",", "12.04`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2006", ",", "1", ",", "5"}], "}"}], ",", "12.09`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2006", ",", "1", ",", "6"}], "}"}], ",", "11.88`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2006", ",", "1", ",", "9"}], "}"}], ",", "12.43`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2006", ",", "1", ",", "10"}], "}"}], ",", "12.48`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2006", ",", "1", ",", "11"}], "}"}], ",", "12.61`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2006", ",", "1", ",", "12"}], "}"}], ",", "12.76`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2006", ",", "1", ",", "13"}], "}"}], ",", "12.54`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2006", ",", "1", ",", "17"}], "}"}], ",", "12.54`"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1869637955]
}, Open  ]],

Cell[TextData[{
 "Read all data from the file and plot it using ",
 Cell[BoxData[
  ButtonBox["DateListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateListPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->492230268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", " ", 
  RowBox[{
   RowBox[{
   "Import", "[", "\"\<ExampleData/financialtimeseries.csv\>\"", "]"}], ",", 
   " ", 
   RowBox[{"ImageSize", " ", "\[Rule]", " ", "Medium"}]}], " ", 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->976592890],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxVl1twU1UUhg+XFno/bdMbLe3pvYBgZhBFsJr4YEGrpNUZZ7RKQEFmGCWI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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->NCache[{3345235200, 11.}, {3.3452352*^9, 11.}],
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {{{
       NCache[3345062400, 3.3450624*^9], 
       FormBox["\"Jan\"", TraditionalForm]}, {
       NCache[3352838400, 3.3528384*^9], 
       FormBox["\"Apr\"", TraditionalForm]}, {
       NCache[3360700800, 3.3607008*^9], 
       FormBox["\"Jul\"", TraditionalForm]}, {
       NCache[3368649600, 3.3686496*^9], 
       FormBox["\"Oct\"", TraditionalForm]}, {
       NCache[3376598400, 3.3765984*^9], 
       FormBox["\"Jan\"", TraditionalForm]}, {
       NCache[3347740800, 3.3477408*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3350160000, 3.35016*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3355430400, 3.3554304*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3358108800, 3.3581088*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3363379200, 3.3633792*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3366057600, 3.3660576*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3371328000, 3.371328*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3373920000, 3.37392*^9], 
       FormBox["\" \"", TraditionalForm]}}, {{
       NCache[3345062400, 3.3450624*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3352838400, 3.3528384*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3360700800, 3.3607008*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3368649600, 3.3686496*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3376598400, 3.3765984*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3347740800, 3.3477408*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3350160000, 3.35016*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3355430400, 3.3554304*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3358108800, 3.3581088*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3363379200, 3.3633792*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3366057600, 3.3660576*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3371328000, 3.371328*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3373920000, 3.37392*^9], 
       FormBox["\" \"", TraditionalForm]}}}},
  GridLines->NCache[{{{3345062400, 
       GrayLevel[0.8]}, {3352838400, 
       GrayLevel[0.8]}, {3360700800, 
       GrayLevel[0.8]}, {3368649600, 
       GrayLevel[0.8]}, {3376598400, 
       GrayLevel[0.8]}}, None}, {{{3.3450624*^9, 
       GrayLevel[0.8]}, {3.3528384*^9, 
       GrayLevel[0.8]}, {3.3607008*^9, 
       GrayLevel[0.8]}, {3.3686496*^9, 
       GrayLevel[0.8]}, {3.3765984*^9, 
       GrayLevel[0.8]}}, None}],
  ImageSize->Medium,
  PlotRange->{{3.3452352*^9, 3.3763392*^9}, {10.89, 16.41}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 CellLabel->"Out[3]=",
 CellID->807106032]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1497700896],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically converts expressions to a list of lists when exporting to \
CSV:"
}], "ExampleText",
 CellID->1203132585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}], ",", "\"\<CSV\>\""}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->343335943],

Cell[BoxData["\<\"a\\na,b,c\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->158634512]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"%", ",", "\"\<CSV\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1143037257],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "\<\"a\"\>", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1785955984]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CSV - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 59.6042412}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: text/comma-separated-values, text/csv CSV tabular data \
format. Stores records of numerical and textual information as lines, using \
commas to separate fields. Commonly used in spreadsheet applications as an \
exchange format. CSV is an acronym for Comma-Separated Values. Plain text \
format. Similar to TSV.", "synonyms" -> {}, "title" -> "CSV", "type" -> 
    "Format", "uri" -> "ref/format/CSV"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[26688, 926, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38665, 1280}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1766, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2389, 62, 107, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[2499, 68, 452, 10, 70, "FormatUsage",
 CellID->37585799],
Cell[2954, 80, 390, 13, 70, "FormatNotes",
 CellID->344331575],
Cell[3347, 95, 257, 8, 70, "FormatNotes",
 CellID->56646289],
Cell[3607, 105, 99, 1, 70, "FormatNotes",
 CellID->718923602]
}, Open  ]],
Cell[CellGroupData[{
Cell[3743, 111, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[3810, 114, 286, 9, 70, "FormatNotes",
 CellID->28652],
Cell[4099, 125, 324, 11, 70, "FormatNotes",
 CellID->8194],
Cell[4426, 138, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[4468, 141, 379, 11, 70, "FormatNotes",
 CellID->28396],
Cell[4850, 154, 575, 20, 70, "FormatNotes",
 CellID->7572],
Cell[5428, 176, 199, 6, 70, "FormatNotes",
 CellID->1052031979],
Cell[5630, 184, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[5672, 187, 341, 11, 70, "FormatNotes",
 CellID->29174],
Cell[6016, 200, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[6593, 222, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[7176, 245, 703, 25, 70, "FormatNotes",
 CellID->32611],
Cell[7882, 272, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[7923, 275, 519, 18, 70, "FormatNotes",
 CellID->20289],
Cell[8445, 295, 1075, 40, 70, "FormatNotes",
 CellID->8419],
Cell[9523, 337, 661, 22, 70, "FormatNotes",
 CellID->5565],
Cell[10187, 361, 815, 28, 70, "FormatNotes",
 CellID->3805],
Cell[11005, 391, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[11046, 394, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[11410, 410, 342, 12, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[11789, 427, 75, 1, 70, "NotebookInterfaceSection",
 CellID->2075609843],
Cell[11867, 430, 158, 4, 70, "FormatNotes",
 CellID->1050269433]
}, Closed]],
Cell[CellGroupData[{
Cell[12062, 439, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[12121, 442, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[12320, 452, 710, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[13033, 468, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[13077, 471, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[13152, 474, 676, 18, 70, "2ColumnTableMod",
 CellID->1019936196],
Cell[13831, 494, 382, 14, 70, "FormatNotes",
 CellID->1999285391]
}, Open  ]],
Cell[CellGroupData[{
Cell[14250, 513, 53, 1, 70, "OptionsSection",
 CellID->853175818],
Cell[14306, 516, 195, 8, 70, "FormatNotes",
 CellID->577662107],
Cell[14504, 526, 775, 20, 70, "3ColumnTableMod",
 CellID->275885706],
Cell[15282, 548, 693, 28, 70, "FormatNotes",
 CellID->1175867229],
Cell[15978, 578, 194, 8, 70, "FormatNotes",
 CellID->431454156],
Cell[16175, 588, 482, 12, 70, "3ColumnTableMod",
 CellID->1545207620],
Cell[16660, 602, 307, 12, 70, "FormatNotes",
 CellID->363422294],
Cell[16970, 616, 641, 15, 70, "3ColumnTableMod",
 CellID->595003190],
Cell[17614, 633, 259, 8, 70, "FormatNotes",
 CellID->751587654],
Cell[17876, 643, 391, 11, 70, "FormatNotes",
 CellID->1294656327],
Cell[18270, 656, 275, 7, 70, "FormatNotes",
 CellID->1132802757],
Cell[18548, 665, 126, 3, 70, "FormatNotes",
 CellID->434889124],
Cell[18677, 670, 182, 7, 70, "FormatNotes",
 CellID->175377388],
Cell[18862, 679, 2852, 78, 70, "3ColumnTableMod",
 CellID->1220196432],
Cell[21717, 759, 732, 25, 70, "FormatNotes",
 CellID->968510758],
Cell[22452, 786, 307, 9, 70, "FormatNotes",
 CellID->2005072920],
Cell[22762, 797, 271, 8, 70, "FormatNotes",
 CellID->1534753898],
Cell[23036, 807, 182, 7, 70, "FormatNotes",
 CellID->1643820035],
Cell[23221, 816, 459, 12, 70, "3ColumnTableMod",
 CellID->306209590],
Cell[23683, 830, 148, 4, 70, "FormatNotes",
 CellID->5556],
Cell[23834, 836, 1195, 30, 70, "2ColumnTableMod",
 CellID->1993],
Cell[25032, 868, 332, 11, 70, "FormatNotes",
 CellID->1182679569]
}, Closed]],
Cell[CellGroupData[{
Cell[25401, 884, 57, 1, 70, "MoreAboutSection",
 CellID->36816911],
Cell[25461, 887, 117, 2, 70, "MoreAbout"],
Cell[25581, 891, 134, 2, 70, "MoreAbout"],
Cell[25718, 895, 133, 2, 70, "MoreAbout"],
Cell[25854, 899, 125, 2, 70, "MoreAbout"],
Cell[25982, 903, 143, 2, 70, "MoreAbout"],
Cell[26128, 907, 119, 2, 70, "MoreAbout"],
Cell[26250, 911, 134, 2, 70, "MoreAbout"],
Cell[26387, 915, 112, 2, 70, "MoreAbout"],
Cell[26502, 919, 149, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26688, 926, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[26804, 932, 60, 1, 70, "ExampleSection",
 CellID->122155417],
Cell[26867, 935, 91, 1, 70, "ExampleText",
 CellID->531378726],
Cell[CellGroupData[{
Cell[26983, 940, 260, 8, 70, "Input",
 CellID->1842837129],
Cell[27246, 950, 951, 26, 70, "Output",
 CellID->1645243656]
}, Open  ]],
Cell[28212, 979, 118, 3, 70, "ExampleText",
 CellID->1024386781],
Cell[CellGroupData[{
Cell[28355, 986, 450, 12, 70, "Input",
 CellID->384919377],
Cell[28808, 1000, 1441, 54, 70, "Output",
 CellID->1869637955]
}, Open  ]],
Cell[30264, 1057, 237, 8, 70, "ExampleText",
 CellID->492230268],
Cell[CellGroupData[{
Cell[30526, 1069, 286, 9, 70, "Input",
 CellID->976592890],
Cell[30815, 1080, 5458, 116, 70, "Output",
 CellID->807106032]
}, Open  ]],
Cell[36288, 1199, 126, 3, 70, "ExampleDelimiter",
 CellID->1497700896],
Cell[36417, 1204, 187, 6, 70, "ExampleText",
 CellID->1203132585],
Cell[CellGroupData[{
Cell[36629, 1214, 256, 9, 70, "Input",
 CellID->343335943],
Cell[36888, 1225, 87, 2, 70, "Output",
 CellID->158634512]
}, Open  ]],
Cell[CellGroupData[{
Cell[37012, 1232, 142, 4, 70, "Input",
 CellID->1143037257],
Cell[37157, 1238, 235, 8, 70, "Output",
 CellID->1785955984]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[37431, 1251, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

