(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24455,        832]
NotebookOptionsPosition[     19908,        681]
NotebookOutlinePosition[     21127,        717]
CellTagsIndexPosition[     21042,        712]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary" :> 
          Documentation`HelpLookup["paclet:ref/format/Binary"], "Bit" :> 
          Documentation`HelpLookup["paclet:ref/format/Bit"], "Byte" :> 
          Documentation`HelpLookup["paclet:ref/format/Byte"], "Character16" :> 
          Documentation`HelpLookup["paclet:ref/format/Character16"], 
          "Integer8" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer8"], "Integer16" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer16"], 
          "Integer24" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer24"], 
          "Integer32" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer32"], 
          "Integer64" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer64"], 
          "Integer128" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer128"], 
          "UnsignedInteger8" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger8"], 
          "UnsignedInteger16" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger16"], 
          "UnsignedInteger24" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger24"], 
          "UnsignedInteger32" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger32"], 
          "UnsignedInteger64" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger64"], 
          "UnsignedInteger128" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger128"], 
          "Real32" :> Documentation`HelpLookup["paclet:ref/format/Real32"], 
          "Real64" :> Documentation`HelpLookup["paclet:ref/format/Real64"], 
          "Real128" :> Documentation`HelpLookup["paclet:ref/format/Real128"], 
          "Complex64" :> 
          Documentation`HelpLookup["paclet:ref/format/Complex64"], 
          "Complex128" :> 
          Documentation`HelpLookup["paclet:ref/format/Complex128"], 
          "Complex256" :> 
          Documentation`HelpLookup["paclet:ref/format/Complex256"], "String" :> 
          Documentation`HelpLookup["paclet:ref/format/String"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Binary\"\>", 2->"\<\"Bit\"\>", 
       3->"\<\"Byte\"\>", 4->"\<\"Character16\"\>", 5->"\<\"Integer8\"\>", 
       6->"\<\"Integer16\"\>", 7->"\<\"Integer24\"\>", 8->"\<\"Integer32\"\>",
        9->"\<\"Integer64\"\>", 10->"\<\"Integer128\"\>", 
       11->"\<\"UnsignedInteger8\"\>", 12->"\<\"UnsignedInteger16\"\>", 
       13->"\<\"UnsignedInteger24\"\>", 14->"\<\"UnsignedInteger32\"\>", 
       15->"\<\"UnsignedInteger64\"\>", 16->"\<\"UnsignedInteger128\"\>", 
       17->"\<\"Real32\"\>", 18->"\<\"Real64\"\>", 19->"\<\"Real128\"\>", 
       20->"\<\"Complex64\"\>", 21->"\<\"Complex128\"\>", 
       22->"\<\"Complex256\"\>", 23->"\<\"String\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary Data" :> 
          Documentation`HelpLookup["paclet:guide/BinaryData"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Binary Data\"\>", 
       2->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Character8", "ObjectNameAlt",
 CellID->2066222148],

Cell["\<\
Sequence of 8-bit characters.
Raw binary format.\
\>", "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " can read any file as a sequence of characters."
}], "FormatNotes",
 CellID->344331575],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " writes a list of characters to a file."
}], "FormatNotes",
 CellID->1289702565]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<Character8\>\""}], "]"}]], 
  "InlineFormula"],
 " imports any file, returning a list of 8-bit characters."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["list", "TI"], ",", "\"\<Character8\>\""}], "]"}]], 
  "InlineFormula"],
 " exports a list of characters to a binary file."
}], "FormatNotes",
 CellID->1622768181],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["expr", "TI"], ",", "\"\<Character8\>\""}], "]"}]], 
  "InlineFormula"],
 " converts an expression to a string of characters and exports it to a \
binary file in which each byte represents a character."
}], "FormatNotes",
 CellID->2110685786],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Character8\>\"", ",", 
       StyleBox["elem", "TI"]}]}]}]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["elem", "TI"]}], 
   StyleBox[" ", "TI"], "]"}]], "InlineFormula"],
 " imports the specified element."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Character8\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the Character8 format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation element:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "list of 8-bit characters", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->611127238],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element."
}], "FormatNotes",
 CellID->456888197],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Character8\>\"", ",", 
       StyleBox["n", "TI"]}], "}"}]}], "]"}], " "}]], "InlineFormula"],
 "gives the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " byte."
}], "FormatNotes",
 CellID->61452522]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->853175818],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->1838786897],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<HeaderBytes\>\"", "0", Cell[
    "how many bytes to skip at the beginning of the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->54213902]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Binary",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Binary"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Bit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Bit"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Byte",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Byte"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Character16",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Character16"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer8",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer8"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer16",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer16"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer24",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer24"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer32",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer32"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger8",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger8"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger16",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger16"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger24",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger24"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger32",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger32"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Real32",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Real32"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Real64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Real64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Real128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Real128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Complex64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Complex128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex256",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Complex256"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/String"]], "InlineFormula"]
}], "SeeAlso",
 CellID->344804987]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->28203978],

Cell[TextData[ButtonBox["Binary Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BinaryData"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->435149757],

Cell["\<\
Convert a list of characters to a string representing an 8-bit character \
array:\
\>", "ExampleText",
 CellID->1155101741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\""}], "}"}], ",", 
   "\"\<Character8\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->841536072],

Cell[BoxData["\<\"abc\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->541923935]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can also convert expressions of multi-character strings to 8-bit \
characters:"
}], "ExampleText",
 CellID->637428618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<a+1\>\"", ",", "\"\<b\>\"", ",", "\"\<cdef\>\""}], "}"}], 
   ",", "\"\<Character8\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1614351490],

Cell[BoxData["\<\"a+1bcdef\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->601778082]
}, Open  ]],

Cell["Convert the previous result back to an expression:", "ExampleText",
 CellID->378706212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"s", ",", "\"\<Character8\>\""}], " ", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1137055818],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"+\"\>", ",", "\<\"1\"\>", ",", "\<\"b\"\>", 
   ",", "\<\"c\"\>", ",", "\<\"d\"\>", ",", "\<\"e\"\>", ",", "\<\"f\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1583730451]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1498815344],

Cell["\<\
Multi-byte characters cannot be exported to the Character8 format:\
\>", "ExampleText",
 CellID->1538967698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<file\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{
    "\"\<\[Alpha]\>\"", ",", "\"\<\[Beta]\>\"", ",", "\"\<\[Gamma]\>\""}], 
    "}"}], ",", "\"\<Character8\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10868426],

Cell[BoxData[
 RowBox[{
  RowBox[{"BinaryWrite", "::", "\<\"nocoerce\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"\\\\[Alpha]\\\"\\) cannot be coerced to the specified \
format. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/BinaryWrite/nocoerce\\\", ButtonNote -> \\\
\"BinaryWrite::nocoerce\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->1845369039],

Cell[BoxData["$Failed"], "Output",
 CellLabel->"Out[1]=",
 CellID->1158608499]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Character8 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 58.4948378}", "context" -> "", 
    "keywords" -> {"binary data", "C", "Fortran", "IEEE 754"}, "index" -> 
    True, "label" -> "Mathematica Import/Export Format", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Sequence of 8-bit characters. Raw binary format.", "synonyms" -> {}, 
    "title" -> "Character8", "type" -> "Format", "uri" -> 
    "ref/format/Character8"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17019, 565, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20908, 705}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3969, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4592, 105, 56, 1, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[4651, 108, 98, 4, 70, "FormatUsage",
 CellID->37585799],
Cell[4752, 114, 220, 7, 70, "FormatNotes",
 CellID->344331575],
Cell[4975, 123, 213, 7, 70, "FormatNotes",
 CellID->1289702565]
}, Open  ]],
Cell[CellGroupData[{
Cell[5225, 135, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[5292, 138, 342, 11, 70, "FormatNotes",
 CellID->28652],
Cell[5637, 151, 372, 12, 70, "FormatNotes",
 CellID->1622768181],
Cell[6012, 165, 451, 13, 70, "FormatNotes",
 CellID->2110685786],
Cell[6466, 180, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[6508, 183, 677, 24, 70, "FormatNotes",
 CellID->29174],
Cell[7188, 209, 628, 22, 70, "FormatNotes",
 CellID->943],
Cell[7819, 233, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[7860, 236, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[8224, 252, 349, 12, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[8610, 269, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[8669, 272, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[8868, 282, 692, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[9563, 298, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[9607, 301, 71, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[9681, 304, 355, 9, 70, "2ColumnTableMod",
 CellID->611127238],
Cell[10039, 315, 387, 15, 70, "FormatNotes",
 CellID->456888197],
Cell[10429, 332, 546, 20, 70, "FormatNotes",
 CellID->61452522]
}, Open  ]],
Cell[CellGroupData[{
Cell[11012, 357, 53, 1, 70, "OptionsSection",
 CellID->853175818],
Cell[11068, 360, 182, 7, 70, "FormatNotes",
 CellID->1838786897],
Cell[11253, 369, 393, 9, 70, "3ColumnTableMod",
 CellID->54213902]
}, Closed]],
Cell[CellGroupData[{
Cell[11683, 383, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[11741, 386, 4895, 160, 70, "SeeAlso",
 CellID->344804987]
}, Open  ]],
Cell[CellGroupData[{
Cell[16673, 551, 57, 1, 70, "MoreAboutSection",
 CellID->28203978],
Cell[16733, 554, 113, 2, 70, "MoreAbout"],
Cell[16849, 558, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17019, 565, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[17135, 571, 60, 1, 70, "ExampleSection",
 CellID->435149757],
Cell[17198, 574, 133, 4, 70, "ExampleText",
 CellID->1155101741],
Cell[CellGroupData[{
Cell[17356, 582, 235, 7, 70, "Input",
 CellID->841536072],
Cell[17594, 591, 81, 2, 70, "Output",
 CellID->541923935]
}, Open  ]],
Cell[17690, 596, 186, 6, 70, "ExampleText",
 CellID->637428618],
Cell[CellGroupData[{
Cell[17901, 606, 241, 7, 70, "Input",
 CellID->1614351490],
Cell[18145, 615, 86, 2, 70, "Output",
 CellID->601778082]
}, Open  ]],
Cell[18246, 620, 93, 1, 70, "ExampleText",
 CellID->378706212],
Cell[CellGroupData[{
Cell[18364, 625, 154, 4, 70, "Input",
 CellID->1137055818],
Cell[18521, 631, 248, 6, 70, "Output",
 CellID->1583730451]
}, Open  ]],
Cell[18784, 640, 126, 3, 70, "ExampleDelimiter",
 CellID->1498815344],
Cell[18913, 645, 118, 3, 70, "ExampleText",
 CellID->1538967698],
Cell[CellGroupData[{
Cell[19056, 652, 280, 8, 70, "Input",
 CellID->10868426],
Cell[19339, 662, 422, 8, 70, "Message",
 CellID->1845369039],
Cell[19764, 672, 78, 2, 70, "Output",
 CellID->1158608499]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[19881, 679, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

