(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23923,        799]
NotebookOptionsPosition[     19457,        651]
NotebookOutlinePosition[     20697,        687]
CellTagsIndexPosition[     20612,        682]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"BZIP2\"" :> 
          Documentation`HelpLookup["paclet:ref/format/BZIP2"], "\"GZIP\"" :> 
          Documentation`HelpLookup["paclet:ref/format/GZIP"], "\"SDTS\"" :> 
          Documentation`HelpLookup["paclet:ref/format/SDTS"], "\"TAR\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TAR"], "\"ZIP\"" :> 
          Documentation`HelpLookup["paclet:ref/format/ZIP"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"BZIP2\\\"\"\>", 
       2->"\<\"\\\"GZIP\\\"\"\>", 3->"\<\"\\\"SDTS\\\"\"\>", 
       4->"\<\"\\\"TAR\\\"\"\>", 
       5->"\<\"\\\"ZIP\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Systems & Utility Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/SystemsAndUtilityFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing & Exporting\"\>", 
       2->"\<\"Listing of All Formats\"\>", 
       3->"\<\"Systems & Utility Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Directory", "ObjectNameAlt",
 CellID->29478],

Cell["\<\
File system directory hierarchy. 
Can contain files and subdirectories.\
\>", "FormatUsage",
 CellID->32145],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " can read files from general file directories. "
}], "FormatNotes",
 CellID->1126358294],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " also recognizes formats that are represented as a bundle of related files \
and organized in a directory structure."
}], "FormatNotes",
 CellID->403436288]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->833],

Cell[TextData[{
 "When importing from a directory that constitutes a supported multi-file ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " format,",
 " ",
 "the converter for this format will be used."
}], "FormatNotes",
 CellID->635498953],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " gives path specifications for all files in a general directory ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\""], "InlineFormula"],
 " and its subdirectories."
}], "FormatNotes",
 CellID->19285],

Cell["", "WeakDivider",
 CellID->23994],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 "returns a list of path names as an expression of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"fn\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"fn\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", " ", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->16633],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"fn\", \"TI\"]\)\>\""}], "]"}], " "}]], "InlineFormula"],
 "imports ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\!\(\*
StyleBox[\"/\", \"TI\"]\)\!\(\*
StyleBox[\"fn\", \"TI\"]\)\!\(\*
StyleBox[\"\\\"\<\>\", \"TI\"]\)\>"], "InlineFormula"],
 ". "
}], "FormatNotes",
 CellID->13885],

Cell["", "WeakDivider",
 CellID->348],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a directory."
}], "FormatNotes",
 CellID->18281],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18032],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16256],

Cell[TextData[{
 "Because ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can determine whether a path specification refers to a directory, it is \
normally not necessary to specify ",
 Cell[BoxData["\"\<Directory\>\""], "InlineFormula"],
 " as a format in the second argument of ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->814065088],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", " ", "\"\<Directory\>\""}], "]"}], 
   " "}]], "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Directory\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " explicitly specifies ",
 Cell[BoxData["\"\<Directory\>\""], "InlineFormula"],
 " as the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " ",
 "format."
}], "FormatNotes",
 CellID->29910],

Cell["", "WeakDivider",
 CellID->10872],

Cell["", "WeakDivider",
 CellID->17860],

Cell[TextData[{
 "See the reference pages for full general information on ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "."}]], "InlineFormula"]
}], "FormatNotes",
 CellID->32471]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->7137],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->8343],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->15947],

Cell["", "WeakDivider",
 CellID->28233],

Cell["\<\
The following can be used to select or specify individual files in a \
directory:\
\>", "FormatNotes",
 CellID->3995],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<FileNames\>\"", Cell[
    "list of full pathnames for all files", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\"", Cell["a single file", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", " "}], Cell[
    "a single file, taken to be in the specified format", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", ",", " ", 
     StyleBox["elem", "TI"]}], Cell[TextData[{
     "element ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " from the specified file"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->29171],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData[
  RowBox[{"\"\<FileNames\>\"", " "}]], "InlineFormula"],
 "element for directories."
}], "FormatNotes",
 CellID->7603],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"fn\", \"TI\"]\)\>\""}], "]"}], " "}]], "InlineFormula"],
 "imports ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"\"\<\>", 
    RowBox[{"dir", "/", "fn"}]}], "TI"]], "InlineFormula"],
 "\"."
}], "FormatNotes",
 CellID->28942],

Cell[TextData[{
 "File names can include relative or absolute directory specifications and \
the abbreviated string patterns supported by ",
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->23865],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", "\"\<*\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "imports an entire directory."
}], "FormatNotes",
 CellID->18011],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"subdir\", \"TI\"]\)/*.jpg\>\""}], "]"}], " "}]], "InlineFormula"],
 "imports all JPEG files from \"",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{"dir", "/", "subdir"}], "\"\<\>"}], "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->31034]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->21926],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<BZIP2\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/BZIP2"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<GZIP\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GZIP"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<SDTS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/SDTS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TAR\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TAR"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ZIP\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ZIP"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1468114270]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->305897826],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Systems & Utility Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemsAndUtilityFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->145415170],

Cell[TextData[{
 "Import and count the file names included in this installation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "ExampleText",
 CellID->604116078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", "$InstallationDirectory", "]"}], " ", "//", " ", 
  "Length"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1564459743],

Cell[BoxData["13103"], "Output",
 CellLabel->"Out[1]=",
 CellID->76239930]
}, Open  ]],

Cell[TextData[{
 "Show the names of some example files included in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "ExampleText",
 CellID->1362964048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"Import", "[", "\"\<ExampleData/\>\"", "]"}], ",", "8"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->128692187],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"100d.pdb\"\>", ",", "\<\"1PPT.pdb\"\>", 
   ",", "\<\"747.3ds.gz\"\>", ",", "\<\"addtoprog.tm\"\>", 
   ",", "\<\"afiro.mps\"\>", ",", "\<\"arrow.cur\"\>", 
   ",", "\<\"aspirin.mol\"\>", ",", "\<\"bcsstk08.mtx.gz\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->413554380]
}, Open  ]],

Cell[TextData[{
 "Import a file from a directory, specifying its name as an ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " element:"
}], "ExampleText",
 CellID->1351382968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/\>\"", ",", " ", "\"\<aspirin.mol\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->906492504],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[3], EdgeForm[None], Specularity[
    GrayLevel[1], 100], 
   GraphicsComplex3DBox[{{-222.40000000000003`, -144.42, \
-45.769999999999996`}, {-216.57000000000002`, -5.45, -53.49}, {-99.16, 
    60.85, -16.939999999999998`}, {14.71, -7.380000000000001, 
    27.639999999999997`}, {7.51, -148.32, 
    33.900000000000006`}, {-110.52, -215.32, -1.8800000000000001`}, {
    124.12, -229.34, 79.25}, {242.23, -176.19, 117.27000000000001`}, {
    116.5, -351.62, 83.64}, {127.95, 62.33, 59.540000000000006`}, {110.05, 
    175.77, 132.58}, {244.29, 236.35000000000002`, 168.25}, {2.55, 220.41, 
    165.78}, {-314.29999999999995`, -197.75, -75.}, {-303.82, 
    51.67, -89.14999999999999}, {-96.08, 
    170.82999999999998`, -24.79}, {-117.39999999999999`, -325.2, 3.15}, {
    298.69, -251.32, 141.66}, {231.42000000000002`, 339.67, 
    207.73000000000002`}, {310.51, 241.41, 78.84}, {293.90999999999997`, 
    174.59, 246.57}, {-268.35, -171.08499999999998`, -60.385}, {-260.195, 
    23.110000000000003`, -71.32}, {-97.62, 115.84, -20.865}, {
    71.33000000000001, 27.474999999999994`, 43.59}, {-113.96, -270.26, 
    0.635}, {183.175, -202.765, 98.26}, {120.31, -290.48, 81.445}, {
    270.46, -213.755, 129.465}, {119., 119.05000000000001`, 96.06}, {56.3, 
    198.09, 149.18}, {237.85500000000002`, 288.01, 187.99}, {277.4, 238.88, 
    123.545}, {269.09999999999997`, 205.47000000000003`, 207.41}}, {
     {RGBColor[0.65, 0.7, 0.7], SphereBox[14, 24.], SphereBox[15, 24.], 
      SphereBox[16, 24.], SphereBox[17, 24.], SphereBox[18, 24.], 
      SphereBox[19, 24.], SphereBox[20, 24.], SphereBox[21, 24.]}, 
     {RGBColor[0.4, 0.4, 0.4], SphereBox[1, 34.], SphereBox[2, 34.], 
      SphereBox[3, 34.], SphereBox[4, 34.], SphereBox[5, 34.], 
      SphereBox[6, 34.], SphereBox[7, 34.], SphereBox[11, 34.], 
      SphereBox[12, 34.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[8, 31.], 
      SphereBox[9, 31.], SphereBox[10, 31.], SphereBox[13, 31.]}, 
     {RGBColor[0.65, 0.7, 0.7], CylinderBox[{22, 14}, 15.], 
      CylinderBox[{23, 15}, 15.], CylinderBox[{24, 16}, 15.], 
      CylinderBox[{26, 17}, 15.], CylinderBox[{29, 18}, 15.], 
      CylinderBox[{32, 19}, 15.], CylinderBox[{33, 20}, 15.], 
      CylinderBox[{34, 21}, 15.]}, 
     {RGBColor[0.4, 0.4, 0.4], CylinderBox[{1, 2}, 15.], 
      CylinderBox[{1, 6}, 15.], CylinderBox[{1, 22}, 15.], 
      CylinderBox[{2, 3}, 15.], CylinderBox[{2, 23}, 15.], 
      CylinderBox[{3, 4}, 15.], CylinderBox[{3, 24}, 15.], 
      CylinderBox[{4, 5}, 15.], CylinderBox[{4, 25}, 15.], 
      CylinderBox[{5, 6}, 15.], CylinderBox[{5, 7}, 15.], 
      CylinderBox[{6, 26}, 15.], CylinderBox[{7, 27}, 15.], 
      CylinderBox[{7, 28}, 15.], CylinderBox[{30, 11}, 15.], 
      CylinderBox[{11, 12}, 15.], CylinderBox[{11, 31}, 15.], 
      CylinderBox[{12, 32}, 15.], CylinderBox[{12, 33}, 15.], 
      CylinderBox[{12, 34}, 15.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], CylinderBox[{25, 10}, 15.], 
      CylinderBox[{27, 8}, 15.], CylinderBox[{28, 9}, 15.], 
      CylinderBox[{8, 29}, 15.], CylinderBox[{10, 30}, 15.], 
      CylinderBox[{31, 13}, 15.]}}]},
  Boxed->False,
  Lighting->"Neutral",
  ViewPoint->{-1.2806119487554317`, -0.22856150272106565`, 
   3.119646242152899}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1128835524]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Directory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 6.2762870}", "context" -> "", 
    "keywords" -> {"Unix find", "directory tree", "file system"}, "index" -> 
    True, "label" -> "Mathematica Import/Export Format", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "File system directory hierarchy. Can contain files and subdirectories.", 
    "synonyms" -> {}, "title" -> "Directory", "type" -> "Format", "uri" -> 
    "ref/format/Directory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14230, 507, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20478, 675}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1938, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2561, 71, 50, 1, 70, "ObjectNameAlt",
 CellID->29478],
Cell[2614, 74, 118, 4, 70, "FormatUsage",
 CellID->32145],
Cell[2735, 80, 221, 7, 70, "FormatNotes",
 CellID->1126358294],
Cell[2959, 89, 289, 8, 70, "FormatNotes",
 CellID->403436288]
}, Open  ]],
Cell[CellGroupData[{
Cell[3285, 102, 51, 1, 70, "ImportExportSection",
 CellID->833],
Cell[3339, 105, 312, 10, 70, "FormatNotes",
 CellID->635498953],
Cell[3654, 117, 413, 12, 70, "FormatNotes",
 CellID->19285],
Cell[4070, 131, 39, 1, 70, "WeakDivider",
 CellID->23994],
Cell[4112, 134, 598, 18, 70, "FormatNotes",
 CellID->16633],
Cell[4713, 154, 524, 18, 70, "FormatNotes",
 CellID->13885],
Cell[5240, 174, 37, 1, 70, "WeakDivider",
 CellID->348],
Cell[5280, 177, 337, 11, 70, "FormatNotes",
 CellID->18281],
Cell[5620, 190, 569, 20, 70, "FormatNotes",
 CellID->18032],
Cell[6192, 212, 577, 21, 70, "FormatNotes",
 CellID->16256],
Cell[6772, 235, 448, 14, 70, "FormatNotes",
 CellID->814065088],
Cell[7223, 251, 890, 32, 70, "FormatNotes",
 CellID->29910],
Cell[8116, 285, 39, 1, 70, "WeakDivider",
 CellID->10872],
Cell[8158, 288, 39, 1, 70, "WeakDivider",
 CellID->17860],
Cell[8200, 291, 246, 8, 70, "FormatNotes",
 CellID->32471]
}, Closed]],
Cell[CellGroupData[{
Cell[8483, 304, 50, 1, 70, "ElementsSection",
 CellID->7137],
Cell[8536, 307, 191, 8, 70, "FormatNotes",
 CellID->8343],
Cell[8730, 317, 668, 13, 70, "2ColumnTableMod",
 CellID->15947],
Cell[9401, 332, 39, 1, 70, "WeakDivider",
 CellID->28233],
Cell[9443, 335, 127, 4, 70, "FormatNotes",
 CellID->3995],
Cell[9573, 341, 1120, 26, 70, "2ColumnTableMod",
 CellID->29171],
Cell[10696, 369, 290, 10, 70, "FormatNotes",
 CellID->7603],
Cell[10989, 381, 458, 17, 70, "FormatNotes",
 CellID->28942],
Cell[11450, 400, 307, 9, 70, "FormatNotes",
 CellID->23865],
Cell[11760, 411, 327, 12, 70, "FormatNotes",
 CellID->18011],
Cell[12090, 425, 487, 17, 70, "FormatNotes",
 CellID->31034]
}, Open  ]],
Cell[CellGroupData[{
Cell[12614, 447, 50, 1, 70, "SeeAlsoSection",
 CellID->21926],
Cell[12667, 450, 1014, 34, 70, "SeeAlso",
 CellID->1468114270]
}, Open  ]],
Cell[CellGroupData[{
Cell[13718, 489, 58, 1, 70, "MoreAboutSection",
 CellID->305897826],
Cell[13779, 492, 134, 2, 70, "MoreAbout"],
Cell[13916, 496, 133, 2, 70, "MoreAbout"],
Cell[14052, 500, 141, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14230, 507, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[14346, 513, 60, 1, 70, "ExampleSection",
 CellID->145415170],
Cell[14409, 516, 178, 6, 70, "ExampleText",
 CellID->604116078],
Cell[CellGroupData[{
Cell[14612, 526, 166, 5, 70, "Input",
 CellID->1564459743],
Cell[14781, 533, 74, 2, 70, "Output",
 CellID->76239930]
}, Open  ]],
Cell[14870, 538, 163, 6, 70, "ExampleText",
 CellID->1362964048],
Cell[CellGroupData[{
Cell[15058, 548, 179, 6, 70, "Input",
 CellID->128692187],
Cell[15240, 556, 329, 8, 70, "Output",
 CellID->413554380]
}, Open  ]],
Cell[15584, 567, 246, 8, 70, "ExampleText",
 CellID->1351382968],
Cell[CellGroupData[{
Cell[15855, 579, 170, 5, 70, "Input",
 CellID->906492504],
Cell[16028, 586, 3363, 58, 70, "Output",
 CellID->1128835524]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[19430, 649, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

