(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34148,       1147]
NotebookOptionsPosition[     28232,        953]
NotebookOutlinePosition[     29713,        993]
CellTagsIndexPosition[     29628,        988]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"ExpressionML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/ExpressionML"], 
          "\"MathML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/MathML"], "\"MX\"" :> 
          Documentation`HelpLookup["paclet:ref/format/MX"], "\"NB\"" :> 
          Documentation`HelpLookup["paclet:ref/format/NB"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"ExpressionML\\\"\"\>", 
       2->"\<\"\\\"MathML\\\"\"\>", 3->"\<\"\\\"MX\\\"\"\>", 
       4->"\<\"\\\"NB\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "XML Formats" :> 
          Documentation`HelpLookup["paclet:guide/XMLFormats"], 
          "XML Import & Export" :> 
          Documentation`HelpLookup["paclet:guide/XMLImportAndExport"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Listing of All Formats\"\>", 
       2->"\<\"XML Formats\"\>", 
       3->"\<\"XML Import & Export\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "ExpressionML ",
 StyleBox["(.xml)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "MIME type: ",
 StyleBox["text/xml", "InlineCode"],
 "\n",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ExpressionML format.\nRepresents an arbitrary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression as XML.\nUsed for the exchange of general expressions between \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and other applications.\nPlain text file, normally encoded as UTF-8. \n\
Developed in 2002 by Wolfram Research."
}], "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the ExpressionML format. "
}], "FormatNotes",
 CellID->344331575]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", "]"}]], "InlineFormula"],
 " imports an ExpressionML file and returns an expression."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
    StyleBox["expr", "TI"], ",", "\"\<ExpressionML\>\""}], "]"}]], 
  "InlineFormula"],
 " exports an arbitrary expression to XML."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", "]"}], " "}]], "InlineFormula"],
 "reads an XML file that holds ExpressionML data and converts it to the \
corresponding ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 "When reading XML, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically recognizes the ExpressionML format. Generic XML content will \
be imported as an ",
 Cell[BoxData[
  ButtonBox["XMLObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLObject"]], "InlineFormula"],
 " expression."
}], "FormatNotes",
 CellID->726618581],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
     StyleBox["expr", "TI"], ",", " ", "\"\<ExpressionML\>\""}], "]"}], 
   " "}]], "InlineFormula"],
 "converts an arbitrary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression to the corresponding ExpressionML data structure and writes it \
to an XML file."
}], "FormatNotes",
 CellID->7572],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", " ", 
     RowBox[{
      ButtonBox["XMLObject",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/XMLObject"], "[", 
      StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}], " "}]], 
  "InlineFormula"],
 "converts a symbolic XML expression to generic XML."
}], "FormatNotes",
 CellID->20192464],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "ExpressionML",
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<ExpressionML\>\""}], "]"}], 
   " "}]], "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<ExpressionML\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates an ",
 "ExpressionML",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell[TextData[{
 "The export format can be explicitly specified in the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["expr", "TI"], ",", "\"\<ExpressionML\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<ExpressionML\>\"", ",", 
      StyleBox["elems", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->72326222],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "ExpressionML",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Boxes\>\"", Cell[TextData[{
     "ExpressionML typeset as a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " box expression"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Expression\>\"", Cell[TextData[{
     "arbitrary ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HeldExpression\>\"", Cell[
    "unevaluated expression", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<XMLObject\>\"", Cell[
    "ExpressionML as a symbolic XML expression", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<XMLElement\>\"", Cell[
    "nested XMLElement objects", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->1865694418],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Expression\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<ExpressionML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ExpressionML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MathML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NB"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1213902688]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->532038560],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Import & Export",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLImportAndExport"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->33428503],

Cell["\<\
Convert a mathematical expression to the ExpressionML format:\
\>", "ExampleText",
 CellID->751895924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", " ", "=", " ", 
  RowBox[{"ExportString", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"3", "+", "a", " ", "-", " ", 
       RowBox[{"x", "^", "2"}]}], ")"}]}], ",", " ", "\"\<ExpressionML\>\""}],
    "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->523877819],

Cell[BoxData["\<\"<?xml version='1.0'?>\\n<!DOCTYPE Expression SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\\n<Expression \
xmlns:mathematica='http://www.wolfram.com/XML/'\\n    \
xmlns='http://www.wolfram.com/XML/'>\\n <Function>\\n  <Symbol>Power</Symbol>\
\\n  <Function>\\n   <Symbol>Plus</Symbol>\\n   <Number>3</Number>\\n   \
<Symbol>a</Symbol>\\n   <Function>\\n    <Symbol>Times</Symbol>\\n    \
<Number>-1</Number>\\n    <Function>\\n     <Symbol>Power</Symbol>\\n     \
<Symbol>x</Symbol>\\n     <Number>2</Number>\\n    </Function>\\n   \
</Function>\\n  </Function>\\n  <Number>-1</Number>\\n \
</Function>\\n</Expression>\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->2049889911]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically recognizes the ExpressionML format when reading XML data:"
}], "ExampleText",
 CellID->1686474025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFormat", "[", "str", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1076011616],

Cell[BoxData["\<\"ExpressionML\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->419585356]
}, Open  ]],

Cell[TextData[{
 "Show the available ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "ExampleText",
 CellID->1321015720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"str", ",", "\"\<Elements\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->577732033],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Boxes\"\>", ",", "\<\"Expression\"\>", 
   ",", "\<\"HeldExpression\"\>", ",", "\<\"XMLElement\"\>", 
   ",", "\<\"XMLObject\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1782265191]
}, Open  ]],

Cell["Convert ExpressionML to an evaluated expression:", "ExampleText",
 CellID->1625263354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", "str", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1220900268],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"3", "+", "a", "-", 
   SuperscriptBox["x", "2"]}]]], "Output",
 CellLabel->"Out[4]=",
 CellID->1429156781]
}, Open  ]],

Cell["Import without evaluating:", "ExampleText",
 CellID->1956684485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"str", ",", " ", "\"\<HeldExpression\>\""}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1632677546],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  FractionBox["1", 
   RowBox[{"3", "+", "a", "-", 
    SuperscriptBox["x", "2"]}]], "]"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->233426572]
}, Open  ]],

Cell[TextData[{
 "Convert ExpressionML to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " typesetting expression:"
}], "ExampleText",
 CellID->1579052884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"str", ",", " ", "\"\<Boxes\>\""}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->326100883],

Cell[BoxData[
 RowBox[{"FractionBox", "[", 
  RowBox[{"\<\"1\"\>", ",", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\<\"3\"\>", ",", "\<\"+\"\>", ",", "\<\"a\"\>", 
      ",", "\<\"-\"\>", ",", 
      RowBox[{"SuperscriptBox", "[", 
       RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}]}], "}"}], "]"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[6]=",
 CellID->1895256182]
}, Open  ]],

Cell["Import ExpressionML to a complete symbolic XML expression:", \
"ExampleText",
 CellID->538911762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"str", ",", " ", "\"\<XMLObject\>\""}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1849742431],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Declaration\"\>", "]"}], "[", 
      RowBox[{"\<\"Version\"\>", "\[Rule]", "\<\"1.0\"\>"}], "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
      RowBox[{"\<\"Expression\"\>", ",", 
       RowBox[{"\<\"System\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/notebookml1.dtd\"\>"}]}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"Expression\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\<\"mathematica\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}], ",", 
       RowBox[{"\<\"xmlns\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"Function\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"Symbol\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"Power\"\>", "}"}]}], "]"}], ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"Function\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"Symbol\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", "\<\"Plus\"\>", "}"}]}], "]"}], ",", 
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"Number\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", "\<\"3\"\>", "}"}]}], "]"}], ",", 
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"Symbol\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", "\<\"a\"\>", "}"}]}], "]"}], ",", 
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"Function\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"Symbol\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"Times\"\>", "}"}]}], "]"}], ",", 
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"Number\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"-1\"\>", "}"}]}], "]"}], ",", 
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"Function\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"Symbol\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"Power\"\>", "}"}]}], "]"}], ",", 
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"Symbol\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"Number\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"2\"\>", "}"}]}], "]"}]}], "}"}]}], 
                   "]"}]}], "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"Number\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"-1\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], 
      "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"\<\"Valid\"\>", "\[Rule]", "True"}]}], "]"}]], "Output",
 CellLabel->"Out[7]=",
 CellID->2093198570]
}, Open  ]],

Cell["Import ExpressionML to a symbolic XML fragment:", "ExampleText",
 CellID->1551444535],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"str", ",", " ", "\"\<XMLElement\>\""}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->668684523],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"Expression\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"mathematica\"\>", 
      "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}], ",", 
     RowBox[{"\<\"xmlns\"\>", 
      "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"XMLElement", "[", 
     RowBox[{"\<\"Function\"\>", ",", 
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"Symbol\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "\<\"Power\"\>", "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"Function\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"Symbol\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"Plus\"\>", "}"}]}], "]"}], ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"Number\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"3\"\>", "}"}]}], "]"}], ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"Symbol\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"a\"\>", "}"}]}], "]"}], ",", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"Function\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"XMLElement", "[", 
                 RowBox[{"\<\"Symbol\"\>", ",", 
                  RowBox[{"{", "}"}], ",", 
                  RowBox[{"{", "\<\"Times\"\>", "}"}]}], "]"}], ",", 
                RowBox[{"XMLElement", "[", 
                 RowBox[{"\<\"Number\"\>", ",", 
                  RowBox[{"{", "}"}], ",", 
                  RowBox[{"{", "\<\"-1\"\>", "}"}]}], "]"}], ",", 
                RowBox[{"XMLElement", "[", 
                 RowBox[{"\<\"Function\"\>", ",", 
                  RowBox[{"{", "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"Symbol\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"Power\"\>", "}"}]}], "]"}], ",", 
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"Symbol\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"Number\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"2\"\>", "}"}]}], "]"}]}], "}"}]}], 
                 "]"}]}], "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"XMLElement", "[", 
         RowBox[{"\<\"Number\"\>", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "\<\"-1\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], 
    "}"}]}], "]"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->311260836]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExpressionML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 9.7920020}", "context" -> "", 
    "keywords" -> {"XML", "MathML", "notebook", "expression", "typesetting"}, 
    "index" -> True, "label" -> "Mathematica Import/Export Format", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MIME type: text/xml Mathematica ExpressionML format. Represents an \
arbitrary Mathematica expression as XML. Used for the exchange of general \
expressions between Mathematica and other applications. Plain text file, \
normally encoded as UTF-8. Developed in 2002 by Wolfram Research.", 
    "synonyms" -> {}, "title" -> "ExpressionML", "type" -> "Format", "uri" -> 
    "ref/format/ExpressionML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16494, 600, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29494, 981}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1798, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2421, 69, 116, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[2540, 75, 509, 16, 70, "FormatUsage",
 CellID->37585799],
Cell[3052, 93, 338, 12, 70, "FormatNotes",
 CellID->344331575]
}, Open  ]],
Cell[CellGroupData[{
Cell[3427, 110, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[3494, 113, 302, 9, 70, "FormatNotes",
 CellID->28652],
Cell[3799, 124, 365, 12, 70, "FormatNotes",
 CellID->8194],
Cell[4167, 138, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[4209, 141, 420, 14, 70, "FormatNotes",
 CellID->28396],
Cell[4632, 157, 430, 14, 70, "FormatNotes",
 CellID->726618581],
Cell[5065, 173, 523, 17, 70, "FormatNotes",
 CellID->7572],
Cell[5591, 192, 513, 17, 70, "FormatNotes",
 CellID->20192464],
Cell[6107, 211, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[6149, 214, 361, 13, 70, "FormatNotes",
 CellID->29174],
Cell[6513, 229, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[7096, 252, 722, 25, 70, "FormatNotes",
 CellID->32611],
Cell[7821, 279, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[7862, 282, 539, 20, 70, "FormatNotes",
 CellID->20289],
Cell[8404, 304, 1075, 40, 70, "FormatNotes",
 CellID->8419],
Cell[9482, 346, 661, 22, 70, "FormatNotes",
 CellID->5565],
Cell[10146, 370, 815, 28, 70, "FormatNotes",
 CellID->3805],
Cell[10964, 400, 764, 26, 70, "FormatNotes",
 CellID->72326222],
Cell[11731, 428, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[11772, 431, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[12136, 447, 361, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[12534, 466, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[12593, 469, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[12792, 479, 710, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[13505, 495, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[13549, 498, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[13624, 501, 1050, 25, 70, "2ColumnTableMod",
 CellID->1865694418],
Cell[14677, 528, 388, 14, 70, "FormatNotes",
 CellID->1999285391]
}, Open  ]],
Cell[CellGroupData[{
Cell[15102, 547, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[15160, 550, 818, 27, 70, "SeeAlso",
 CellID->1213902688]
}, Open  ]],
Cell[CellGroupData[{
Cell[16015, 582, 58, 1, 70, "MoreAboutSection",
 CellID->532038560],
Cell[16076, 585, 133, 2, 70, "MoreAbout"],
Cell[16212, 589, 113, 2, 70, "MoreAbout"],
Cell[16328, 593, 129, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16494, 600, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[16610, 606, 59, 1, 70, "ExampleSection",
 CellID->33428503],
Cell[16672, 609, 112, 3, 70, "ExampleText",
 CellID->751895924],
Cell[CellGroupData[{
Cell[16809, 616, 321, 10, 70, "Input",
 CellID->523877819],
Cell[17133, 628, 706, 11, 70, "Output",
 CellID->2049889911]
}, Open  ]],
Cell[17854, 642, 246, 7, 70, "ExampleText",
 CellID->1686474025],
Cell[CellGroupData[{
Cell[18125, 653, 111, 3, 70, "Input",
 CellID->1076011616],
Cell[18239, 658, 90, 2, 70, "Output",
 CellID->419585356]
}, Open  ]],
Cell[18344, 663, 208, 8, 70, "ExampleText",
 CellID->1321015720],
Cell[CellGroupData[{
Cell[18577, 675, 148, 4, 70, "Input",
 CellID->577732033],
Cell[18728, 681, 238, 6, 70, "Output",
 CellID->1782265191]
}, Open  ]],
Cell[18981, 690, 92, 1, 70, "ExampleText",
 CellID->1625263354],
Cell[CellGroupData[{
Cell[19098, 695, 111, 3, 70, "Input",
 CellID->1220900268],
Cell[19212, 700, 150, 5, 70, "Output",
 CellID->1429156781]
}, Open  ]],
Cell[19377, 708, 70, 1, 70, "ExampleText",
 CellID->1956684485],
Cell[CellGroupData[{
Cell[19472, 713, 160, 4, 70, "Input",
 CellID->1632677546],
Cell[19635, 719, 190, 6, 70, "Output",
 CellID->233426572]
}, Open  ]],
Cell[19840, 728, 163, 6, 70, "ExampleText",
 CellID->1579052884],
Cell[CellGroupData[{
Cell[20028, 738, 150, 4, 70, "Input",
 CellID->326100883],
Cell[20181, 744, 386, 11, 70, "Output",
 CellID->1895256182]
}, Open  ]],
Cell[20582, 758, 103, 2, 70, "ExampleText",
 CellID->538911762],
Cell[CellGroupData[{
Cell[20710, 764, 155, 4, 70, "Input",
 CellID->1849742431],
Cell[20868, 770, 3874, 89, 70, "Output",
 CellID->2093198570]
}, Open  ]],
Cell[24757, 862, 91, 1, 70, "ExampleText",
 CellID->1551444535],
Cell[CellGroupData[{
Cell[24873, 867, 155, 4, 70, "Input",
 CellID->668684523],
Cell[25031, 873, 3135, 73, 70, "Output",
 CellID->311260836]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[28205, 951, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

