(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31000,       1032]
NotebookOptionsPosition[     25345,        853]
NotebookOutlinePosition[     26854,        894]
CellTagsIndexPosition[     26769,        889]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"AVI\"" :> Documentation`HelpLookup["paclet:ref/format/AVI"], 
          "\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"JPEG\"" :> Documentation`HelpLookup["paclet:ref/format/JPEG"], 
          "\"PNG\"" :> Documentation`HelpLookup["paclet:ref/format/PNG"], 
          "\"SWF\"" :> Documentation`HelpLookup["paclet:ref/format/SWF"], 
          "\"TIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TIFF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"AVI\\\"\"\>", 
       2->"\<\"\\\"GIF\\\"\"\>", 3->"\<\"\\\"JPEG\\\"\"\>", 
       4->"\<\"\\\"PNG\\\"\"\>", 5->"\<\"\\\"SWF\\\"\"\>", 
       6->"\<\"\\\"TIFF\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Multimedia Formats" :> 
          Documentation`HelpLookup["paclet:guide/MultimediaFormats"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Importing & Exporting\"\>",
        2->"\<\"Importing & Exporting\"\>", 3->"\<\"Multimedia Formats\"\>", 
       4->"\<\"New in 6.0: Import & Export Formats\"\>", 
       5->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "FLV ",
 StyleBox["(", "FilenameExtension"],
 ".flv",
 StyleBox[")", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->24307],

Cell[TextData[{
 "Registered MIME type: ",
 StyleBox["video/x-flv", "InlineCode"],
 "\nAdobe/Macromedia Flash video file.\nUsed for compositing Flash animations \
with Flash authoring software, or for playback through a Flash-based video \
player.\nFLV is an acronym derived from Flash Video."
}], "FormatUsage",
 CellID->23481],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " creates ",
 "FLV",
 " files compatible with Adobe Flash Player version 7.0 or later. "
}], "FormatNotes",
 CellID->1012]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXPORT", "ImportExportSection",
 CellID->21136],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).flv\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " exports a list of arbitrary expressions to ",
 "FLV",
 "."
}], "FormatNotes",
 CellID->1838044116],

Cell[TextData[{
 "When exporting a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]]],
 ", the animation is composed from frames corresponding to rasterized images \
of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->455195517],

Cell["\<\
The duration of the FLV animation is determined from the number of frames and \
the specified frame rate.\
\>", "FormatNotes",
 CellID->624431530],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).flv\>\"", ",", 
    RowBox[{
     ButtonBox["Manipulate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Manipulate"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}]], "InlineFormula"],
 " exports an animated demonstration of a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " object."
}], "FormatNotes",
 CellID->1447928605],

Cell[TextData[{
 "The exported Flash animation will play at the same speed and will have the \
same size as the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " object."
}], "FormatNotes",
 CellID->195249723],

Cell[TextData[{
 "If bookmarks are set in the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " object, ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " will create an ",
 "FLV",
 " file by interpolating between the bookmarks, while preserving the speed \
and duration of the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->68141821],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).flv\>\"", ",", 
    RowBox[{
     ButtonBox["ListAnimate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListAnimate"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 " object as a Flash animation."
}], "FormatNotes",
 CellID->4084],

Cell["", "WeakDivider",
 CellID->23556],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).flv\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates an ",
 "FLV",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->12290],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).flv\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->29996],

Cell["", "WeakDivider",
 CellID->1054],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->25345],

Cell[TextData[{
 " ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " supports the Flash ",
 "FLV",
 " format."
}], "FormatNotes",
 CellID->14708]
}, Closed]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->13712],

Cell["General options:", "FormatNotes",
 CellID->5131],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["White",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/White"], Cell[
    "color of area padded around the exported animation", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "pixel dimensions of the animated object", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->30114],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", and the image size cannot be determined from the expression given, the \
first frame of the exported object will be rasterized and taken as the size \
of the resulting animation."
}], "FormatNotes",
 CellID->24722],

Cell["", "WeakDivider",
 CellID->804924484],

Cell["Video encoding and compression settings:", "FormatNotes",
 CellID->870393702],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CompressionMethod\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "whether the FLV data should be compressed", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VideoEncoding\>\"", 
    "\"\<ScreenVideo\>\"", Cell[
    "encoding method used for animation video", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->48346150],

Cell[TextData[{
 "Allowed settings for ",
 Cell[BoxData["\"\<CompressionMethod\>\""], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<GZ\>\""], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1052],

Cell[TextData[{
 "With a setting of the form ",
 Cell[BoxData[
  RowBox[{"\"\<VideoEncoding\>\"", " ", "->", " ", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["encoding", "TI"], ",", " ", 
     StyleBox["opts", "TI"]}], "}"}]}]], "InlineFormula"],
 ",",
 " ",
 "additional options specific to the selected encoding method can be given."
}], "FormatNotes",
 CellID->439999093],

Cell[TextData[{
 "Method options for ",
 Cell[BoxData[
  RowBox[{"\"\<VideoEncoding\>\"", " ", "->", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<ScreenVideo\>\"", ",", " ", 
     StyleBox["opts", "TI"]}], "}"}]}]], "InlineFormula"],
 ":"
}], "FormatNotes",
 CellID->927256357],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BlockSize\>\"", "32", Cell[
    "block size parameter of the screen video codec", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->108765820],

Cell[TextData[{
 "\"BlockSize\" -> ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " or \"BlockSize\" -> ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"]}], "}"}]], "InlineFormula"],
 " sets the block size parameter of the Flash inter-frame compression method. \
Allowed values for the pixel dimensions are of the form ",
 Cell[BoxData[
  RowBox[{"16", "*", 
   StyleBox["k", "TI"]}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " <= 16."
}], "FormatNotes",
 CellID->1487492595],

Cell["", "WeakDivider",
 CellID->1366310135],

Cell["Playback controls:", "FormatNotes",
 CellID->531801574],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AnimationDuration\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "length of the animation in seconds when exporting a ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ControlAppearance\>\"", 
    "\"\<Generic\>\"", Cell[TextData[{
     "how ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
     " control elements are rendered in the exported file"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FrameRate\>\"", "15", Cell[
    "number of frames shown per second", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RepeatAnimation\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the animation loops indefinitely", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Scalable\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether the animation scales to fit into the window when played with a \
browser plug-in \
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->162115404],

Cell[TextData[{
 "The following settings can be given for ",
 Cell[BoxData["\"\<ControlAppearance\>\""], "InlineFormula"],
 ": "
}], "FormatNotes",
 CellID->20328],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
captures user controls exactly as seen in the notebook interface, using the \
style elements of the local computer system\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Generic\>\"", Cell[
    "renders graphical controls in a generic style ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "excludes control elements when exporting an animation", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->22646],

Cell[TextData[{
 "An animation exported with the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<ControlAppearance\>\"", "->", "\"\<Generic\>\""}]], 
  "InlineFormula"],
 " will look the same regardless of the computer system on which it was \
created."
}], "FormatNotes",
 CellID->562049616],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<ControlAppearance\>\"", " "}]], "InlineFormula"],
 "-> ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", no user controls are included in the exported animation."
}], "FormatNotes",
 CellID->777555376],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).flv\>\"", ",", "  ", 
    RowBox[{
     ButtonBox["Manipulate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Manipulate"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], ",", " ", 
    RowBox[{"\"\<ControlAppearance\>\"", " ", "->", " ", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}]}], "]"}]], "InlineFormula"],
 "exports a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " object to a Flash animation file, rendering user controls in the style of \
the local notebook interface."
}], "FormatNotes",
 CellID->677221723],

Cell[TextData[{
 "Control elements captured from a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " animation cannot be manipulated when playing an animation file."
}], "FormatNotes",
 CellID->402169361],

Cell["", "FormatNotes",
 CellID->1430429849],

Cell["Additional properties and settings:", "FormatNotes",
 CellID->16439],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<HTMLFile\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "name of the file to which an HTML wrapper should be written", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ThumbnailFile\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
name of the file to which a small preview image of the first frame should be \
exported\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->716285122]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->27918],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<AVI\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/AVI"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JPEG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JPEG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<SWF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/SWF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TIFF"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1409815940]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->5567886],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Multimedia Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MultimediaFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->143918760],

Cell[TextData[{
 "Create a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " to be exported to FLV:"
}], "ExampleText",
 CellID->1009558061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "+", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "6"}], "}"}], ",", " ", 
     RowBox[{"Mesh", " ", "\[Rule]", " ", "False"}], ",", 
     RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", 
     RowBox[{"Axes", " ", "\[Rule]", " ", "None"}], ",", " ", 
     RowBox[{
     "ColorFunction", " ", "\[Rule]", " ", "\"\<StarryNightColors\>\""}]}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1641178647],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "::", "\<\"color\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"StarryNightColors\\\"\\) is not a valid color or \
gray-level specification. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/color\\\", ButtonNote -> \
\\\"Plot3D::color\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->1263281160],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, 4}}, Typeset`size$$ = {180., {71., 75.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$26565$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$26565$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot3D[
        Sin[$CellContext`x $CellContext`y + $CellContext`a$$], \
{$CellContext`x, 0, 6}, {$CellContext`y, 0, 6}, Mesh -> False, Boxed -> False,
         Axes -> None, ColorFunction -> "StarryNightColors"], 
      "Specifications" :> {{$CellContext`a$$, 0, 4}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {115., 120.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->1886259585]
}, Open  ]],

Cell["Export it to FLV:", "ExampleText",
 CellID->521611049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<manipulate.flv\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1261699475],

Cell[BoxData["\<\"manipulate.flv\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1129545847]
}, Open  ]],

Cell[TextData[{
 "You can export a ",
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 " object to FLV:"
}], "ExampleText",
 CellID->142820278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", " ", 
  RowBox[{"\"\<test.flv\>\"", ",", " ", 
   RowBox[{"ListAnimate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"n", " ", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2145816484],

Cell[BoxData["\<\"test.flv\"\>"], "Output",
 CellLabel->"Out[3]=",
 CellID->2044762517]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FLV - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 13.3077170}", "context" -> "", 
    "keywords" -> {
     "web", "web technology", "WWW", "world wide web", "w3c", "internet", 
      "HTTP", "hypertext", "hyperlink", "Flash", "animation", "multimedia", 
      "video"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Registered MIME type: video/x-flv Adobe/Macromedia Flash video file. \
Used for compositing Flash animations with Flash authoring software, or for \
playback through a Flash-based video player. FLV is an acronym derived from \
Flash Video.", "synonyms" -> {}, "title" -> "FLV", "type" -> "Format", "uri" -> 
    "ref/format/FLV"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[20812, 707, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26635, 882}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2446, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3069, 80, 143, 6, 70, "ObjectNameAlt",
 CellID->24307],
Cell[3215, 88, 328, 7, 70, "FormatUsage",
 CellID->23481],
Cell[3546, 97, 254, 9, 70, "FormatNotes",
 CellID->1012]
}, Open  ]],
Cell[CellGroupData[{
Cell[3837, 111, 53, 1, 70, "ImportExportSection",
 CellID->21136],
Cell[3893, 114, 581, 21, 70, "FormatNotes",
 CellID->1838044116],
Cell[4477, 137, 529, 20, 70, "FormatNotes",
 CellID->455195517],
Cell[5009, 159, 156, 4, 70, "FormatNotes",
 CellID->624431530],
Cell[5168, 165, 607, 20, 70, "FormatNotes",
 CellID->1447928605],
Cell[5778, 187, 288, 9, 70, "FormatNotes",
 CellID->195249723],
Cell[6069, 198, 595, 21, 70, "FormatNotes",
 CellID->68141821],
Cell[6667, 221, 597, 20, 70, "FormatNotes",
 CellID->4084],
Cell[7267, 243, 39, 1, 70, "WeakDivider",
 CellID->23556],
Cell[7309, 246, 525, 20, 70, "FormatNotes",
 CellID->12290],
Cell[7837, 268, 662, 22, 70, "FormatNotes",
 CellID->29996],
Cell[8502, 292, 38, 1, 70, "WeakDivider",
 CellID->1054],
Cell[8543, 295, 236, 9, 70, "FormatNotes",
 CellID->25345],
Cell[8782, 306, 228, 10, 70, "FormatNotes",
 CellID->14708]
}, Closed]],
Cell[CellGroupData[{
Cell[9047, 321, 49, 1, 70, "OptionsSection",
 CellID->13712],
Cell[9099, 324, 54, 1, 70, "FormatNotes",
 CellID->5131],
Cell[9156, 327, 847, 23, 70, "3ColumnTableMod",
 CellID->30114],
Cell[10006, 352, 500, 15, 70, "FormatNotes",
 CellID->24722],
Cell[10509, 369, 43, 1, 70, "WeakDivider",
 CellID->804924484],
Cell[10555, 372, 83, 1, 70, "FormatNotes",
 CellID->870393702],
Cell[10641, 375, 638, 15, 70, "3ColumnTableMod",
 CellID->48346150],
Cell[11282, 392, 320, 12, 70, "FormatNotes",
 CellID->1052],
Cell[11605, 406, 375, 12, 70, "FormatNotes",
 CellID->439999093],
Cell[11983, 420, 272, 9, 70, "FormatNotes",
 CellID->927256357],
Cell[12258, 431, 388, 9, 70, "3ColumnTableMod",
 CellID->108765820],
Cell[12649, 442, 588, 20, 70, "FormatNotes",
 CellID->1487492595],
Cell[13240, 464, 44, 1, 70, "WeakDivider",
 CellID->1366310135],
Cell[13287, 467, 61, 1, 70, "FormatNotes",
 CellID->531801574],
Cell[13351, 470, 1654, 41, 70, "3ColumnTableMod",
 CellID->162115404],
Cell[15008, 513, 163, 5, 70, "FormatNotes",
 CellID->20328],
Cell[15174, 520, 885, 21, 70, "2ColumnTableMod",
 CellID->22646],
Cell[16062, 543, 293, 8, 70, "FormatNotes",
 CellID->562049616],
Cell[16358, 553, 325, 11, 70, "FormatNotes",
 CellID->777555376],
Cell[16686, 566, 847, 25, 70, "FormatNotes",
 CellID->677221723],
Cell[17536, 593, 209, 6, 70, "FormatNotes",
 CellID->402169361],
Cell[17748, 601, 44, 1, 70, "FormatNotes",
 CellID->1430429849],
Cell[17795, 604, 74, 1, 70, "FormatNotes",
 CellID->16439],
Cell[17872, 607, 760, 20, 70, "3ColumnTableMod",
 CellID->716285122]
}, Closed]],
Cell[CellGroupData[{
Cell[18669, 632, 50, 1, 70, "SeeAlsoSection",
 CellID->27918],
Cell[18722, 635, 1218, 41, 70, "SeeAlso",
 CellID->1409815940]
}, Open  ]],
Cell[CellGroupData[{
Cell[19977, 681, 56, 1, 70, "MoreAboutSection",
 CellID->5567886],
Cell[20036, 684, 151, 2, 70, "MoreAbout"],
Cell[20190, 688, 134, 2, 70, "MoreAbout"],
Cell[20327, 692, 127, 2, 70, "MoreAbout"],
Cell[20457, 696, 156, 2, 70, "MoreAbout"],
Cell[20616, 700, 159, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20812, 707, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[20928, 713, 60, 1, 70, "ExampleSection",
 CellID->143918760],
Cell[20991, 716, 219, 8, 70, "ExampleText",
 CellID->1009558061],
Cell[CellGroupData[{
Cell[21235, 728, 758, 21, 70, "Input",
 CellID->1641178647],
Cell[21996, 751, 412, 8, 70, "Message",
 CellID->1263281160],
Cell[22411, 761, 1671, 35, 70, "Output",
 CellID->1886259585]
}, Open  ]],
Cell[24097, 799, 60, 1, 70, "ExampleText",
 CellID->521611049],
Cell[CellGroupData[{
Cell[24182, 804, 147, 4, 70, "Input",
 CellID->1261699475],
Cell[24332, 810, 93, 2, 70, "Output",
 CellID->1129545847]
}, Open  ]],
Cell[24440, 815, 220, 8, 70, "ExampleText",
 CellID->142820278],
Cell[CellGroupData[{
Cell[24685, 827, 504, 15, 70, "Input",
 CellID->2145816484],
Cell[25192, 844, 87, 2, 70, "Output",
 CellID->2044762517]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[25318, 851, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

