(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    180828,       3541]
NotebookOptionsPosition[    174059,       3324]
NotebookOutlinePosition[    175663,       3366]
CellTagsIndexPosition[    175576,       3361]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"HDF5\"" :> 
          Documentation`HelpLookup["paclet:ref/format/HDF"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"\\\"HDF5\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Numerical Data Formats" :> 
          Documentation`HelpLookup["paclet:guide/NumericalDataFormats"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"], 
          "Scientific & Medical Data Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/ScientificAndMedicalDataFormats"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Importing & Exporting\"\>",
        2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>", 
       4->"\<\"Matrices and Linear Algebra\"\>", 5->"\<\"Numerical Data\"\>", 
       6->"\<\"Numerical Data Formats\"\>", 7->"\<\"Raster Image Formats\"\>",
        8->"\<\"Scientific & Medical Data Formats\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "HDF ",
 StyleBox["(.hdf)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->29426],

Cell[TextData[{
 "MIME type: ",
 StyleBox["application/x-hdf", "InlineCode"],
 "\nHDF data format Version 4. \nGeneral-purpose format for representing \
multidimensional datasets.\nUsed for storage, management, and exchange of \
scientific data.\nHDF is an acronym for Hierarchical Data Format.\nDeveloped \
by the U.S. National Center for Supercomputing Applications (NCSA).\nBinary \
file format.\nIncompatible with with HDF Version 5. "
}], "FormatUsage",
 CellID->15871],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support the scientific dataset (SD) data model of the HDF format."
}], "FormatNotes",
 CellID->10697]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->17612],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).hdf\>\"", "]"}]], "InlineFormula"],
 " imports a HDF file, returning the names of the datasets stored in the \
file."
}], "FormatNotes",
 CellID->18703],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).hdf\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a multidimensional array to a ",
 Cell[BoxData["HDF"], "InlineFormula"],
 " file."
}], "FormatNotes",
 CellID->11027],

Cell["", "WeakDivider",
 CellID->5545],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).hdf\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a list of strings representing the names of all datasets contained \
in the file."
}], "FormatNotes",
 CellID->9508],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).hdf\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Datasets\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"\"\</dataset1\>\"", ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}], " "}]], 
  "InlineFormula"],
 "creates an HDF file, storing the arrays ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " as separate datasets."
}], "FormatNotes",
 CellID->1233989338],

Cell["", "WeakDivider",
 CellID->24237],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).hdf\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "HDF",
 " file."
}], "FormatNotes",
 CellID->26443],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).hdf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->21313],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).hdf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->22501],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<HDF\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<HDF\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8850],

Cell["", "WeakDivider",
 CellID->25128],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).hdf\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates an ",
 "HDF",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->2111],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).hdf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->23650],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).hdf\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->28149],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).hdf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->11192],

Cell["", "WeakDivider",
 CellID->1454],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->15869],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "HDF",
 " format."
}], "FormatNotes",
 CellID->681]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->27465],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->20267],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->17713],

Cell["", "WeakDivider",
 CellID->19793],

Cell["Data representation elements:", "FormatNotes",
 CellID->2027411603],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "all datasets imported as a list of arrays", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Datasets\>\"", Cell[
    "names of all datasets", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->629581695],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<Datasets\>\""], "InlineFormula"],
 " element for the HDF format."
}], "FormatNotes",
 CellID->2128534904],

Cell["Specifying and selecting datasets:", "FormatNotes",
 CellID->18634],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Datasets\>\"", ",", " ", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " dataset"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Datasets\>\"", ",", " ", 
     StyleBox["dataset", "TI"]}], Cell["named dataset", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->517846341],

Cell["Meta-information elements:", "FormatNotes",
 CellID->914246541],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DataFormat\>\"", Cell[
    "type used to represent each dataset", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Dimensions\>\"", Cell[
    "data dimensions of each dataset", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->496120302],

Cell[TextData[{
 "The following values can be given for ",
 Cell[BoxData["\"\<DataFormat\>\""], "InlineFormula"],
 ":"
}], "FormatNotes",
 CellID->727619096],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Integer8\>\"", Cell[
    "8-bit integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer16\>\"", Cell[
    "16-bit integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer32\>\"", Cell[
    "32-bit integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger8\>\"", Cell[
    "8-bit unsigned integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger16\>\"", Cell[
    "16-bit unsigned integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger32\>\"", Cell[
    "32-bit unsigned integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Real32\>\"", Cell[
    "IEEE single\[Hyphen]precision numbers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Real64\>\"", Cell[
    "IEEE double\[Hyphen]precision numbers", "TableText"]}
  },
  GridBoxAlignment->{"Columns" -> {Left, {Left}}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->19976]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->8823],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->1322260454],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Append\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to append to an existing file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1070671222]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->2742],

Cell[TextData[Cell[BoxData[
 ButtonBox["\"\<HDF5\>\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HDF"]], "InlineFormula"]], "SeeAlso",
 CellID->8610]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->28923870],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalDataFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Scientific & Medical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScientificAndMedicalDataFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->607654440],

Cell["Show the names of datasets in a file:", "ExampleText",
 CellID->1571502705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/ozonemap.hdf\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7128],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"TOTAL_OZONE\"\>", ",", "\<\"LATITUDE\"\>", 
   ",", "\<\"LONGITUDE\"\>", ",", "\<\"REFLECTIVITY\"\>"}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"Out[1]=",
 CellID->881600594]
}, Open  ]],

Cell["Import a dataset and render it as a raster image:", "ExampleText",
 CellID->1593199336],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", " ", "=", " ", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<ExampleData/ozonemap.hdf\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Datasets\>\"", ",", "\"\<TOTAL_OZONE\>\""}], "}"}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->344588482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", "d", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->493017967],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzUvQe0bdd1njfdey9yN+XeZEuWHBVbNmhRtGSZEkmRVJceKZESK1jE3h7Y
ALCAIHolDgg8dOChP3RegKDEIlly7FQnMRmnx+m9583x1pf17f/uw50bUI59
x5jj3LPPPrustea//vnPufb52ped/cLX/eqquv+0PetXVf2xf8nsj36V7Y//
S2ZfG/asf8HtT/5ztv+/x+eW/aF/we0P/nO2o17PH/gq26/0/T3T8ZL+9Ce+
ypZ48qeOaH867Kjff6b21caPo57/z4T9877/7L+jWs6Hf+RX2H7vV9m+2viz
db6veYb2e8J+3zO0PH7i2x9+hpb4k+NnC18SH7Ys/enPblju/+fCtvbfsq3z
f7Xtz4f9hSNafj8tz5ft9Uznj6Py2S38+Wrzm2fKF37/V9kSD45qv2vDfucR
7Xcf0Y6KT0flS1vj56jjdYu/pP9v+dNR/fPrwv7yhh3V39Of0/5i2K80njxT
PD4qH8r5KsdLjq8tvpLz4db4zfH+1caLrzZ/+u0b9tvCfmvYb9ywXx/2m8N+
S1ie73eEbeHRVvsdNf7M8ZDz1ZbecVS+lLblT+mPfylsC2/+yoZt4VMe/6h4
uGVb93tUfDlqvLrFd7b0uBwvW3rmM9Vncv5Nfz8qv9j6/jPlH78u7NeGVdj/
VUv7Vb9qafl5fj/tV4f9mrC8vt8Ulvi01R5b8d8WPiUebelFOT6fqR6S/pR8
IvHn68O+Iewbw/5qWH5/C5/y/Fv8JS3vJ+2o8egW3hy1P56p3reFP1v8Z0vf
yPl4Cw/Sf5J/bPlXfp6W/CL5R+LF/xn2v4f9z2H/S9j/uGG5//8a9r+F5fkT
n5Jf/Yaw5GvZ/lt4dFT+lONpi//k+N7yny29J/1/i+8k3iQ+peX3j4o3yW+2
4rGteOuZ6ltb8dZR8Sf7eyu+2sKfLX6T4zfxJ8f7VjyT8/tWvJKfZ/yT/CLx
JvEgLfHmfwj7r8P+iw37L8P+m7D/Pux/Cku8+j/C8n6zPbP9tuK75J9b+tJR
+VGO3y3/Oqq+kviTfCbxZwuP8vsZfx1V39m6n6PaVnsdlS8dlT89U76zFW/l
+MvxmuM58SXxIv0j5/Oc79O28CX5ROLLfxf2325Y4s1/GvafhP2HYf9x2H8e
lsdPfMrrTbzK+8v2yPgy+2NLD0/+mfwo8wU5vrbqeY6aD9vSf46KP1vx2FHj
r6Pqyb/Slnj0TPFn6/MtvfmoeJN8J/Em+U3Ot1t4sxUP5ec5/6f/HRU/Eh/S
/qOwL4V9OSw///fD/oOwPH5+nviW+JX3uxX/pX6V/HErfsv+z/GR/GgrPjtq
vLXFf7bwIvHlm8K28GdL387Pt/BpS886ary2ZVv4voVPW/mGLfzZwpstvSXH
5xbepJ6a/CXxZIu/5PyffOGfhf1nYV8O+ydh/27Yvxf2j8P+nbB/a8Py+Fvf
z/3z+o/Kr7L9Um/K/sr+TbzK+Sfjt5zvMh7L+fOZxl9b/rvFf9IyHku82fr8
qPi0Fd+lHbUe4Kj1SVt60VZ94Va+POevHE9bekvymRy/Od8m3qS+kfpH+kvq
K4kvGf98KexfD/tHYVuf/8Owfy0sP/+lDfuFDcv983q28GorHvyvwhLvk49u
6U05X+X8lvPhFr9Pf8j5P/13y7b06ORDW3r0ln6d8d8WHm3ZFh96pnr1Vny1
xXcyf7VVf5f5p8SbrXx14kvmm3N+TXxJfTfjicSbjEeSn6Q//oOwL4R9Puyz
G/bzYVvH+7mw/P7TYZ8LezLsM2F5vsSrfzMs8emfhiV/yv7J+SPHx1b8luMx
x+8WHzoq/qT/Jh5s6T9H1aefKd480/qjo+r5W/WER60PzP5NPXErH5X53MSX
nA+39JjUIzJeyvk38Sbn64yXkq8kf0h/fTzssbCHN+yhsEfDHtmw3D+Pl9eT
n58Ky88/HZZ4lniceJ16VeJR5gdzPCQe5XyW4zHH81Z+fsufjlr/vFUflLaF
N89ULzpqPeRR67OzfY8aL6Vt5aeS32Q8n/HTlj6T+JJ8JvM1iS85npPP5Hyc
+kjGN8k/0v/S309u2J1hd4fdGnZ72G1huX/aibA83s1ht4TdFJbXn3iVeJx4
nXwp8Sjnh5xfcr7K8ZXjMfWhrfWpW/r0Fj5l/JL4saVHb+nZR8WP3H+LP23p
W3m/mR/P9k48OWr98FY9Xs4/W/W+qf9u1cNkvJT1LplvSj3iy2H/dljO1xkP
PRF2b9hdYTeE7cKuD8v9rzqiXRZ2RdglYfl5Hu/KsK39Ew+zfRKffzEs+VHO
D6lvJx/K8ZbzX863W+s7jqpPb9UDbsVjW/HZ1udb8dpR9aLEny1+k/UP2d5b
+LKVD9/KR6VenPPTlj6zlW/aipdy/vxSWM63qV+kfpLxTPKT5APXh6W/X7Rh
F4Z9LOyCsI+GnRt2Xlh+/qGw88Py+/n5h8MS/3Zhybcynkt9KfX2rB/I+Wqr
/ijrh7bqFY+6Pir5wVY8tFUvdNT1HFvx21a8tpU/38KbjK+S3yRf2aoHy88T
X7JeL/lN5puSzyS+ZLy0hS+pz+T8mXpNzrcZH6Q/bOFN8oOLw84JOx72vrAP
bFh+/91hbw17c9jbw94U9o6wPF5+/70blnh5bVjGb6mXJR5lfycfTvzJ+TLx
Z6s+6Kj1wVv1ilv5+6Pmu7byZVv6z5Y+nHiceL1Vf5x8Zit+yng5853Zv4kv
GZ8nX97SY7IebivflPiSfCbzP0+GpV5xR9iNYek/yT/eH/bqDXtd2BvDEh/e
EPbasFeG/XRYnv8nw3L/nwnL4+f15vUlXmV7XR+W8dpB2L8RlvVXybcTfzIe
2Fq/elT8Oer6h2e6Xuuo67fSnul60K3nX2R+KvEm8SUt+U3qw0fNX2/pvRkf
bdW3fDEs9ZrUh+8LS70i/eHSsI+HvTMs8eJFYd8f9uKwHwp7WdixsB8J+8EN
y+N/b9jW9fxAWF7PK8LODkt+lfFp9kfGv9nfqffl+Mz4K/XPZ6r/fLXrYXL/
5GNbz6NIPMh8X+rBiRdb6z238GfreXuJL5l/2tKHU69JPpPxUdZ/JL78q2GZ
X0r+kvrMk2GZT34gLPEl46fUYz4YlvN58omfCnt22N8OO2sYn3/HsOcOe86w
vzvsecP+3jC2f9ew79xjHO/vDGP7Xx/2N4Zxfvbj+OBTnv8Fw8A3cPBHh718
GHj0mmFvGUbcCf5cN4x8GzyIegR0f/qfcQT/Ia5nvMLTqf9AV8jnoaX+k/n4
xJt9OknW0eX7XEewFc9sPddv6zk2xJn7njtAnU3W9+17/lI+dyfrdPJ8mbei
zoZ8QcZN4Arv0YGJn+hn9D94zJeHEReBJ7887O8PY95i/MBTsl4m61eyfobt
xE33D2O8kt9mHr1mGHmbTwxD10U/RWdBv8BPiCfAGeIT/O0lw+ANzx/2V4d9
/bBvGPb1YX8l7C8N+/PDvnnYXxv2r+wxPue83xjGfrzn+H9uGOfnfN8+7Kxh
4FjiGrj0fcPgez887Fgt+RF8CN6Ivs08wPxA/zF/JA6h45HfZHyiRzOPZr00
foIf5Xyf+JPrUffFL1t6CedLPrLv+d/53Nt99TL7ngeXeJPHS/zYwrG8rn3r
G7L+JuMncAbdN5/vQD9m3PSlYaxHIi+ROAOuPDkMvHhw2P1h4AW6C/kRdEk+
J6+d9SroM58ahj5z+TDySfAY8AUegz6LDoPegb/8xDDmdfCG+R8+gD8+e9if
DPvTw/7EsD867I8N+yNhf3DYHx/Gcb52GMfhPcdj/2cN43O+/6eG/eFh7P9n
hv3FYeAgeAa+nVVLPII3gUu0B3Hmjw1DZ0KvQtdGL0O3p//o1+RBzE/MY+iD
rIuhHizrpvEL/IX5fl8dUOIP7/c9j3ifHpvPB058yOfd5fMA9r3P55bse053
4te+69j3XL99zyfIdZupE7OOGz5Dv4AzxE3Ez18eBr4kj2G+IR8BvsBLGBfg
DHkjcIW8ETgB32beAy/gKVcPYzyyH3oM+8PfybPAZ8grv2cYPIY4gDgJfQU+
A4954bC/F5Y4Q/wCb8Bf/8Cw3zfs9w77XcN+57DfHfY7wn7rsN82jPd8/tvD
fmcY5//9Yb9nGNcJ3j1rGDgFT/q6Ydwf8du3hxG3wQPRi8Bv8B3dGh5Ev9H/
u2GMH/CH8YauR/4h15nB7/EH/AS/y98J2vqdiMSZrefq5brrLT/eWo8Nfu57
/kM+921fXV8+X4D3+86ffAacIQ9OXIWOQ30NdcOJO/l8h8Qb6uefGkZ/w1fu
GUZdLfVy1w/75LCrw5jfGGfkQT4yjLqU1F3YTnyUeabjw9A1iZsY38RLx4ah
p8JfiB/wG/SZvzkMfPm2Yd8yjHgG//yzw/Bb8CFx5TcN+83DfsOwXz/sNw77
NcN+XRj78332z+OCV3kdvyfs94XBx+Brf2EY8SLx29/cY+A0+J269kuHEc8m
D4KvEjczzqiLYJ47GEY+grwp/D3rpJP/gBepP2f+eet55vCb1EHS/9Pvc911
1rfg17zP51ztW5/N55n/y/PluqjEtTwucVSujwLnc50Cehy8FJ5K3ASfQd8l
Tkp8ga9Q58r8BN8AP8AT6tPOqWXdC+/BibcNyzqT3P6zw8AT4iW2v34YeWHi
JsY5+ig4A3/5W8PAl28ahp/9pTD8EXx51rA/NAx+g7+DC/AV8CXxJLf/2mG8
B4eS9/yWMPAGHgTPgu98zbAtPkT8R7yWcRi8B338u4ehg6P/pC4N7hOP0V/0
I3Ex8w38lnmNOAwcQgeCn+c6MsY/OhB+Bh8BN/bhztZz9PbpvFk/l+uP8ON8
zlTW56Kj4+fcB8fJdZP7ngeXOJUGn+F4xKtcZ66/TN041yekXky9RK6TpB/R
WYiH4CngC3jC/ARfhmfg/1mPknot+RDiHvQA9JXUCcAPPj827CfCfiyMeRe/
eHYt4yTmb/RWdA/0lNRjwJf0U+IbcIa/MUz+HzxIXoKBJ1s8hvMQH/2hMLaD
L4k3xFe853ts5z7/eBi69F8eljoQ7QrupB6NToYODf7Qr+APuhvzEvPUPh6U
cRh6AHlW4jB4P/7DvJ/4sy8PtS+eStxJ/QZ+g38Tl3Ad6OPwBHhD1udi+56T
m79DAF7l8745Lzi173mfiWO5DjN5DXiT6y3Ri4mrnhyGLkM/EhfBW+j3dw1j
XmJ8gBv4OXE9cQz5D/yf9/Dx7xlGfpf5k3GcOibjOvPBzwkDZzg+xyE+Iu+E
rsq8jl6bfguPwe/BkX24kbyF7RwXvMr4B9xABwb38H+uL3lX6ths53t/OCxx
h/NwfL7P8fL4iUP78mP0I/0CDqEDMS4yP898Rd0U9dzMe/Ag9Oh8TgB6Abw+
14vhf/CQfF7Z/9vfSdiXXwZ3ct0j/gwOZN0//AC8JI+HPoJegn/nc3PBsfw9
gcxfc15wZN/zvcGdXA+Vzw/O9ZbwzlxHSVwFz2FdDv0KzmT8kvke8hjgQNav
oIswLvF7dJL8nDiH8Zz5Ft4z3+b3/lpYfg6vwa+Y3/FH/D/jldRzwR+2p26c
n4Nf8IrEFXAPvYj7R19J/QiDn3GcZw3L/FrmxxLPOB7n+dNhnIfvJ56xneul
n+GV3xp21jDGDfMQOtCPD3vVMPLyxN/wbfIL6ADokOgFjHP0yy8Nw0/wS+KL
xJ9965f26cj5eytZT5f6CH4M3oCPxCVcN/lj6m35nLqWfB4mOIW+Ai4lL8nf
JwDH9j3ve18cRT78y7XMUxH/ko+kX8hXw1/pV+Yb+j/rc+Ed8AjwA39Pv2Hc
/vkw8CTrWsijwEvYjl/8xTDOw3Ezj/ysYelv8Bhw4XeFZX4o45s/Fpa4wHVk
HpzryfbI9mJ/eAi4xfXu02n+QNg+HvWssKwDyOul3bgfrjtxiOvN+qRvC6N/
ma/gqdQzog9lXj71IOIw9AHyqujQ6AnomdTTEw8w7+/Dn311dvCfrG8BfxJ3
iIPAO3gHeAM/w09T/6CehPp8cJY6t4w7wSv8n3pMdN5967BzHW/iGDws6244
PudL3Ri82Q1jnQB8NvEGnMl8D/MaOAH/TlzhPeOZ/cAR/Iz3We+GP4Jn4BTn
xQ+eNYxxj7/hj38wDL8l3mG/1HHgRfgh95H3iXG9XxuGv6eewv3vu/6Mz5JP
cf1s/71h3CffZ3vmt7iujOvy/rE/EZb8ivuhveivrKNM/pp12MTt4A9xPviT
9YnoBdSD4b/gD/Wt+AnzNfEEui04kvwHS/xJnYc4K/VZcA4egv9Tzw+uEEdm
3Qg4S7xJ3Qn55N0w8s20A8cFB56s5fMr0X3zOXDg9JeG5ToF8orEtwfDaHfq
8Lg+dBzwhv4k/0BcTt4HPsM8BQ7keOJ9xj/ouHyOfyYfyHGcuMI4BqdynKde
wfZ9ejH7pX7BdYIn3HfWKbMf/Cvjoqwf5HqyfjDjMLbn9YMLeR/Jv/bVG2Lg
EfhFfAkugb9fE7ZPd+K6ud7kf1xH4hPtyzhh3BCnMd+hDxHnowPkurpzhrEu
JuuBDobhJ8QzzOPwEPI65KfgNZk/z9+vA3/yORDwHfCNOOdLw8Ad9Fb4AHVp
54Tlc1DyOSvgE/mhfB4Tcc71w1jHAk6BS+A07US8B58Ct8gvUn/O8TgP6wfA
G+rr4DnE2/Q3ePGXw/A/9Bp0Rb737LBcnwRvYrzhx/h96qaM2/TnZ4VlXMf7
9IPUNRIvcz0C21NvwpKnZdyYuATu7tOJ2T95XvYD+6V/p35DO+T5sg4gedO+
ODPjvH26Ff3EdXL+xE3aJccVvJrxBf6QF0N/pO4CfRL/ZLzz/EbyKfgJ+EN8
8KVh6BlZB0Qclr+/ms/ry99LAMfgO+gq8Adwh3oB+Bt1sPvqTPh863ks4BR1
CuhkfM75aC9wm/gVvkT8ms8DBi/BMepuwEHiYvDm2DD0m1zniB6I/4ETjAN0
nu8KI99EXgk8Y9wQx8OnOR7H/7qwjM/S0k+xjH94n3iSvAx+k3U94Avny3VS
+3RtLHkT15l4mde3733yTAz/flYteWLGdZnPS/yBD2WclvXYGa9yPM6XcTjX
k3jGdvoJ3KE9zxpGfhQdiDr0XB+Gf+FPu2EZd7Duh7iBfAy8hPwO8RN58lzH
kOsPwCv0I45DnAXuoIcQl+D34Ax1a/gtfI+8H/uxLijxiXoX2iWPS7zDcfke
/AQch0eRjyKuBWdo56y34bjHaok34AP8JOt0wR/iLvCF74EnHC+f10D8Rt79
x8Pgz+DRWcPwz8x7P6vW6/sz74Wfgwd/IyzXO3xDGHiTcR2f0y6Zp2N75vFy
Hk8elXXQ7L/vOnP9aepNqd9z3D8XlrwS/pJ1QPk+dbSME1OPBmczrwj/yTwZ
OEp70a7Mi4yXfJ4H45x5lvmceAR/QbcFf6jXB39Yl0EcBl9BB8rfNdz3+4eJ
O+SL0GfRk8EdrhMcIb+Xz1ViHdDrw8Bfvgcv5Htsp77upcPy+Sj4Jfoa+1PH
mzwzcY36CPAA/gFfOWtYrhNIv2E/4iX057w+6ntoJ+6T+856QvYnX899c52c
l+vIeT11XvwSf826fvA18Sfre7KeEIM/gTO5bumvhyU+8T51s+RnyX+SL6W+
lvwrLesKEp+474x3UzfKeHdf/hD8oJ+ybiB1pz+zx8Ar2pP5j35k/mPcMJ7g
B8Qj4A/PLWAdIPki4hziCPTWfzSMfBBxGLpx/m5PrkcgzkJfTr5DvAfuwCvw
a/wH/3hZGH6VdbvwGPwNHDhWy/pb+AD1VcQr1M+dVct1won32L46UXgK/pf+
wnb8g3Ga9fHgAeejXbjf5IHgL/efeMv6BsYL7cP176s/5rrwK+Z/8HLfesZc
7wl+4M/4/T49CD+gfcCRxG3Onzwr8SjjsIyfeJ98DNziOIl34Cn9yf75PnEs
14ukXpZ5BbYn38n3yW/gQ5k3o/1TH8OyX2n3xB/mcfDn+DB0B+IZ9FZ0IPTV
ffWIxGHk4+Ex5M/3PfeTvDr6NTyKemv4F9cFf8BfMj4AL8AP/A+8gi9x38RN
ud4onwdD3EIcA/4kH6Ef8CN4DO+zrjfjqIwT6E+2c3z0GPAOPKNduF/aCz7G
5+BJ4jXtRrvSnrQv54Ff0R5cT+IH/sa8eFYt62hzfRZ+i/+lnzFPJ+7kcyM4
Pu8T3zlvxmNcb/KSfP5O8prsn/TDjI+Tj3Ed+R5Lvpt13+BS6sjgCXFY5tsy
j5d6NJa6Vep3ed/MJ+g/zFvwAfwQPTXzPegU5GOyHggdhrwOeR7WpxKH5e+G
EWdRv0xeizw+cR26E9dF/AIe4Cf4A/eHv+Bv6DGssybvlc9vQI8+Poy4FP/F
P8Fx+FA+Z45xhj8x3nIeTv0h8wZYzuP4Of2KbpPPv8w6RPCG+Yf7gd8k/hwb
Bg4l7oDH1HckL8z7SL0co30yP556L/6U833Gn5w/652yH9if/mB79iPvk39i
iRuJLxw/22PffMT+GYfmcTgv+Jf1nakPZ7uCI6mb8Z7vZf40j5P4T7vDx/ET
/JK4A3+D94A7u2E8xwX+QfxFnV7WI5IP+yfDWLdAPizXZ4FP1OPBo9CZyCNx
nfAR/Ae8wf/wG+ILcGXf+m3031zPnc+B4Pz5/E38kriKOCTHX85jqTfkOpuM
Y+hP4rTMZ2Y9O4aeletAMfAodZ5XhLE/7QzePD+M8Zb1jrm+K3nPvnqBzHfj
F8z3tM93hIEjtHe+z/kh9afkQclHkwelTpX4lvfLdvDmuXss43sscSz5Mbj4
zXss47yMK3PdS+Ltvu/RPvR3rgdjHDE+mf9T76FuD70FHgL+UKdyMIw8OPhD
3R06DuugqFeG75BPpw7vyWHwLXCBuAh/yXgg83mpY2HUBRHH8R4c2vdcGvJT
8Cn0bHhk6iL4IeNt33ya/PysMPqR+Ir+BO/AjTfW+u8T/Mz/RwO3wFu2g++5
3hQ84jrhQfv8iPvP/Dc4lLoC8zDjn+OAN1lvmfiQeWH6YUuf3qcLJR5Z2/n2
Wl+j+ZxxrfA91t/+bd0H/xuXnlPLZ6Aax59bS573nLH9u2pZQ/Hcmjz6W2qu
2SVHh4YF1nyzPqdOwfUJ31LLetS/MrZ/Zy3XFPf5ezw09vQ82Zyh/YZcV/t2
+yU1wNfX/H3Grkvp2sNel9A1uI07PC/GPKjrgRozOi/VMRO1v61Hf7nO6EDo
0azRZM1Ux1qNU41Znxnn6ufAdo3vRTWfzYsW2hiDbgvu/NS4p+Y7HSM1flxa
Z3gceHpFzefnwfEurflbca1lw4+6XZozNe4092nc6dit9fn26ca3jmVeNa4J
3yQ/1NfXa+6+f7T/d9d8dmWPj7Nq+onnQsZP78cacHwc3Onjvmjc/7GaObY3
1cQdno/xmjr83HR0n/4MDsy+r4nvvaZmLpGcIDFaXxd4+L018YjrZc173xdx
F/f4rbX0Y3DAmkZqLb0dfH52Lf3NnAduQozg+dn1QWjTa5rLt9aSt/6NmhrW
t2jb36qpUTumW+M9YEn75HeP9mFcgCHgxndpv7YeB8+riSW0Pc8Z8FqrnpNa
F/jB8dpj5YXjeObhxuNv0v/cv/sBPHJ/UYMK7lDLCq5SU8Y1ta8eqzPjqfWT
9i94T+s7XWPbmNM5ruY9xFytNXfdYcdCrfc8VMvfbLtn/H9QZ/LxXevbcVjj
UNf3NgZ1/qrXbhNj/bPx+k/H561fP15n+FRfQ+NEcxHq7nrsN9fpce84q7G0
/aR5UWtYxJGNK42lHbd9spa/MQsmXT7249k3Hx3tQezVuNOYc7zOYBo1Qu3j
r6sZ08C7jo1rhP+QR2cMdD/wPAp80fjj8cl4Y8w9v6be9KLRn8dqYs/Pjldy
W319r9H/5PnAqZ+tpc7+ptHO7PtqvcLtiMFeOs5N7IUvfJ+umbir/a79Ct0d
/+5xjb+DO15Lb15CDT8+Si3Tc3WOtm+vJe58Q8312t2+5OBYo2QMsSZnDHKs
hn+hXXvfb6upnX9nLevGvQ7qu2vyAfJB8ES4yt+t+XwRuGS3dWNIz2cvUtu/
YLzvOanHnJ9lwBzN2IMbknvrdgA3uFdwE/7HfRKnsv2ssS/H+Wu15IbPHdff
19i+eqzOjJseQ80len5vX2u/g/e0n7bvN+40BjXvaWzpmIua5+YnB+P/zr03
V7lX+3y6ztQkdhzWOPTz45X6oH9cZ3LzvQ6q15r/w7Hvg+N8n6ozNXrNNxoj
2x9eVjPGwqdbb2mfeOW4n973A+N+rhj303i6G69X1+Q7l49zwHs+VhN3iEW7
feA+jWmNQ42FnR9rLOp8Uvss/Odlo30bf35I18lc1OMDbtD+SZ0xr3+vJm94
Xs06QcYec9gLa2JPn7sxA+wBP95QE2feXLOW8q3xP/E3dZbk4uFErxn3Zu2I
+0Tvgov5WUB9zY0R5Pza76gb6HFKrPPNNeuXzXXAC+II2sNtBed5dk3ccJ03
MYz5Bvs67wV2waOMRcQqcB7HyPga+vBZNXExuSA85Xn67IXjlXj1+bXkjvQ7
PAadH6yhXpQ6UebiY7XMA//Q+N73jTboa2ZNyNfXjC8zZsy8ADgPfwdj0Zlo
I+oNzXleLuux2b7U3Kd9rP2v/bH981PDOsfOOiY0nsaVxp7Gk6fG+8fGZ2hC
zYEeH9t738ahp2vqOf1/85xfHMc5qDP5+8a4G8Y1fHxcX/vUa0a70sb4cv/f
8UD7SvtXY0/HTI0tzWuuqlkz2fyn8YfYyxh0cU3dx1o024xF8KHGosbGjsPe
Ps6Pz4JDP17LWh/niRhnjEViKs+HzHnPqznHPX98v4/30nFOeE/jxutjW1/X
W8Y1kgeDv7m2G3tzLfmTuc9P1/KZhnC9n6jDsQDzd+NGj1F82vUEzL/NT75R
26wjE1fgt9a0+5j4PHgBljyn5m9k+Rmh312zNgA+9h36H/3ExyXecoyGFnRW
TXwkluo2ABt+uJY8+CV6ZUx8v16t48N1XlRLnIHP9Ph/aU1OSkxMboGc5o+N
77943Ptz1O7ox2CO9Sb+t5bEPGB+9ndq8inyLPDdPi/xFtjT82WPzZ7H25fa
Zzv2gi+g+XTs1fjTsVdjQ+s7aDuNKY0/zXU6HnuwphaERvRYTS7UePTwOEbv
S/zW+95VZ3hWY15zkfb15hbtyz9d8xmyP6j+6Dbt+bh9rf2mcaCxAkxB8yGe
/GRN/Lm0pt5zcS21aOvT1oGIxawFoQM17sGDqJ8mH8Z1w1s8xvoVn2Vut799
by3Hocdi3/9ra2INsVT/TywF7rjOGq5DrQXvzYPAMmIx60CM8WM1a4J+uJZY
iQ5BrIGW2v7qHF/izlk1Y0/iDvDGbfM9NfWks+rwsxPR2fAXxzC0Ibq4Yzd4
FO/BHvQmMM7+5TiK/oWXOwZy/RRt1mPjxcPQ7N3PvR3ewzgiH4kO14Yu5/wH
+AP/gXt/Ty2fgfDXa9aY00/WHeGN1nC+r5a1b3+3JkeiPv87RtvQFi8d19TX
3vNaj9HGn/b19rP2x45F0H7IebX+29pOY0bjSWNOc5aOlRqLGlvIvzf2nBz7
P1DzN+L4vLfdM/bpPFrHd7txzuYrjQXt12+r6cM/UnO+oG9/YrQz99GxEPEj
uHLZOCbYc/XK5+DPx2v5HI5P1FJ/JgeG/owG3UZdjesT0aR/ZrT5j4/7+IFx
D4xTx1nWE8khvbiWv2+HhkSuq/G5MSLrKN86rqux8XjNWLExCEx6Z7zy/bfp
eHC6xp1XjnP2/RyrqW8xrsEfOF2Pc3MUtAPrysQy31lTLwInnleHtSTiLvQf
8A0tDX3WfIfjff+4Vs9j3zc+h/ucVdMPz6qpcYA/31EzHgZ36DNiY/oaraPb
qzlIYwIc0nXk1Fcxx8KJ4EkYmk77heNi8AcMMv9J/ecFoz/A/2+pWW8ADzRf
dRuD/b5X4u3vqRnjMg+gY1E35txQ+0qPs44h8Dt4Q8cpHXfdNF4bf9CV0X06
dvp8TQ0IntMY1djT+IIWRI6stzWPaj7VubTGtmvGOS+q+ftNbxhteawmf4Az
vGS0a98Dmmn7VnMT1nTCe4ix0J6bB108ztWvl4x9wRrn3uE7beS/4DuN2cfH
/91+1qOJYYiBGoPQTJiL4MEvrGXdTP7/klr+ZoA5INjb/fiOcQ3vqeV613fX
XEfDNfa+7xqf5dozc6OfHcdnDdgraj4PHv3N8wKalrlPGzGXa+7QcHvMe2yD
N/hzGrpPY4p5DnoG2i65H/CG+bfHvznBi2qJId9Zk99YT4KXPbtmjecP1MQv
6lnorz7HD9dcV2eeAl8lL3n2eAVHwHfq2eALcJtX15zjwJ9X6Xsvr4k/x4aB
Py+uqZe5pgBeB+8xhpiHgrvoBtwzOh9xLfMQ/Mi1rXCfntt6jLbOQS1e+yTa
T2MPeS9y7h1jNfdp7QZNuWOwg1ryoMadxqCOqe6s+buWJ8Yx0WGam7T/t8+3
n6MzMx/86Lh+YpAfHJ8x5xNzNWZRv+M8+yU1eU7bhTUxhjgLvkO9D9vMez5U
k+8crxlz4etoKMQ+6L/oJmglyRt6rMId8OF+j8aFtnKsJnf/qXHcN482eNe4
FjCx8ZD6pOM18efdst6emNnHe30t817O6fkastYKDKLeECxwfctZtcxBU09g
7Z2xnRqIaxkdBzDWya+t5Vm6zc0X8PFXjD54vo7Tx6cmyRwADYR1fOahxNQv
UZ+9qqavUdvQxnxE/pF1d/Bm8pOug/A81tterffUT8CpqNNirjumfkIzIl6y
Pkd7ovP87Zp8EG6ZfPT71Q7WschBYL39x2vyn76fHm89Ttvn0VipNWxsaMxp
zgNPae7S+NP6TeNPY84Xa+a0GntY/0WMRXx18zhOH7N5yGW11FUaO9pX3lFT
O0GrJ+Z9wXilnpB7OK5rv2C8Nt6Q4+pzwXPYB55zoV7hXsafvi5iruPD4Aqp
3zrn5PiLOc31wmiF5OlzTRV6gTVF5s8ef2+uJV/5wLhG6rqpszy3Zo02a0bA
oXfU/G1z5+QZz6+suSaDa2P+OqZtxBg9rnucmfdQ75P1gGAEefnvGf2LHu/a
2Mz1gUF8n/Udz62JRy8e7ffTNfOB9m8/56Dv6YdqyWPgQeZvvKfeihpzryOm
/gr+QRu+vGbtFLjyhlrqc1wjeQJe0d/8XAa4Es9w8LMZ4KiYdSJiPfqPOc79
ai77glrGu7Q3fUL+4wfHsYxxjAdq8vp8zAN9bz1/9/gk794cqH2u45PWnak1
buwg9kJPJqcO/vzc2NZaMvhz//gOevKuzmDPFeNc+HVfB5z/9TV1M2KUtu8d
9/UzNWtWuq/alxozGlvA0EvHPTSGXl1T2yHmMv58uCbeGJvgQvAx59m5Vo8R
xg86rbEHX35FTf4DJ2dsOlZnvDBnwtPRYho3nP//YM1aAeOO2xeuZr6DnoMx
htERnCP9SvyHmJB4krwd+JO6JdzEcaZzPszL6F74Np85H/38Wmo9zxv7dvu9
dvSJOR/zhusO+l7b/16ia3pBTX2JOI/jv7CWegzrC/Gxl8no95+uiT3Uc3af
Uh/Kq/OVHlPOAcCZ4FD0GfiCzpQx36v0+rqa+ZFX6toYu1w3WEXejLYx7nDv
vR/z5o/plc+JRfvaew7vMdnzJjll1rU79upXsKjjqMaT1nYaaxpzWvvpGKz1
n+Y/zY1Yo9X4c3Icp4/R2NO40H7evnG8ZtyCxsBY/8k6XNvDXIbe4Zwda7eI
u66tiXUXyS6sGWtmbv1j+gzdB+xBI4EzMFdRT8M8tg93fioMHCKWp7aP779e
x35bTe71vlquAzm3lvrUh2tizvGauIk2Dma+qWYtD3poXpvztvTJsZr447jL
a03bHFc5V0L9CuZ6TLQUOE9jD9zqJbWsR6D+EpwD21487ukNNXX3D9XhfOUH
av5e81tr/qYZPub6GPLN4N2LxrX+cC3zObSRtRo4JXlDuA8xrtfGMG7gSeZt
yd/gqMwbntvQtOFDaNKux7A2ABaBjcx5Nj6DD4O1x2qp6YB9tAe1J8xTrx1t
/v7RF467mic0Puxq6j7X633HUdQ9N/50zNX40xq0638eGvvcV8vcVh+78eGC
cW6wh5o94te+xx7jL675W5jmAW8a32We91q1jh0bP68Z50OHJgZD8yHOAnPA
L2p8qO3p87Tf4rPE6by6bu8ttcxhu46Ya+c16wHZ9206ZuMdGEudUd9zY419
yjEiejM8jRjRvK3PSZxlbGHMWLPMz6mn7M+Ij8nJgRtoxOi51nOIWcAd+D9j
lGMytxLfEHdxPM7hNU/9+ctHu75b7WOMpp70vNGm7x3t87qa62jRLl5QU8eC
szHvM793+6C5vCoM33VtOfVhb9Y28yDHvxh4BW5YC2LOBhN+opb4AC6QD3Mc
5nNYQ3plzfHJWCRnAXd2XiLX8lCbAR4dk72jZszVftg+ifbRfkvND+vLXXvY
GnJzoMaV5jfUD1J/2Nynsad1n3tr/p7NDbXMO7Wv49vMx/BK8tTMRegd9GHf
e48Z/I55v/GEuKvvgzUVaM79P7XNznHBg/qaiLc+OM6Br4ITr69lfY3z3NTR
vKMO9xU5bTDJfervtR2v5TNBzg/DpzCvhcWfiLPIs6NXkUP3+jTGo7UB8MZ1
JMwL8NNjNeNjtAJe0XCopUNLJ2/n5xKAZeZU5PJ/QMd8UU1diPxaYw/x0fPG
91432pGY1LEoPJk55/yaPKjb5rU1eRBazgtr5tjRoH5s7Oc1c15bZ37DmCXf
eLxmPoCY0DVYb60ZF3N8r/91DozaVnzFOotroH+iJta/vKZ+nfq240DXhr2j
Zg71vbV89gyxAJzdfAmdn7j9ZTXxn9qWNmqEWRcFd+j/qTtkzWnnsxpbGn8O
6gzmPF0z907evfdt3gP2XDvO0/2O3xDPgKdnjzYlbnxZTY2ONnlfLec0xhXx
I2sqyLl7nSlY69wXOg/rvM6tOSeiD5iv5joF/md82cCAt8vIkXu/4zW1Y+7r
w2G9/f2y4zV1ZjATnsTnxI3gqOM8tEtyJObM6AYe++gI3T/HatapkPOglgk9
50dr+ay3Y7XUrNFGj9Uyh5b1BWCVORC6Emszv2fs19eHJkhexRhEfAoGEasy
37xZbcKawh+qqXcTe1G3C1fJmAbuQE1EH5saDWLmD9SS16Zfo4WiyYFFcArm
CLDHeVPwG14J1+x+eI2uEz2JuZSx/NZa1oR5POOzjufxCesS1sepDe5+QQPB
F5sbtM+CO9TI7OoM92n8ofanuU9jS/Of5jmNPV3r8/R4dd3hiXGMT45jNh40
1nXfu4bmPeNe+npd8/CKmvXMxDWOP6z5oBtfOu4BvkMshu7U/Mc5d+vQ1PqQ
+4e/0LZwZ3Sz47X83Z731XIsUVvjvPdxbT9nnOtDuh9wEB7G9vNqiT2M4Y/U
4foA8nTgobmy8739CncmtiLPhlmvNP8hN+B1BNR4wHfQX8EyuJW1UerivFYJ
LHR9kXPHjsEc1/Wxzh5tC46b53jckGvxZ/T7m2vycPJixGLfP67jp2piOe1J
nsr5iLfUxB9wDt7KWGkDL+lfasnQJqzLgEPMBeQmf6SWeUjWQoKjXHOPBcY1
WPPucY3UlryzlvVj+OrxmmP5Xfqfa3WujuP7/tvPqLWjHsZ4w3rT/h/dmfUX
6M+s/+ocV+NPaz4H4z359pv13T5248AnRn+fF/fC3Py6mrlCYl70leM1dXIw
x5oxPA7M6fsjBoPLoUOT73etz8fGtvNqWRPjeIl2hHNYc2FM8Z4xBLZ6Hjk+
9rXedIEMvmOMYQ5nPs/1aJ5PXRf53nF+anpeK7P/MMda+wc3zP1dT0IdP7Ud
rMPr7WgOWY9rrZ16KGvycC7n/eFOnJd5nlzvD499X1uzls31B9gHa4lBHgO0
H+v3qBvt63Gd6IvHdZDzRhdgbnJ+kv7mehi7aAb0qfGI+jLPzWikxACZ24Cr
We+lH70W7PU14/vjOg9zINwsx7M1NOMmPuy1j9S+ej4+b7Rx8x14Aa/tm+g8
4I6N7Y1FHX9Ry9wxlmugWc/F+q2bxveu0/kuqNnPx2uJ76+uGde+uiZ3JcdF
LO/4HR0H7Qo8vWJce/O2xs0T4zour1mH6HVezJEfHeexbmvd7ZyauIN5fMPv
P6j9PlQTD5jbjCHWoVLjOa8mRn1kxT5ah/Ug8/luY+bzzLO/RuY1Qs4bO5fi
euEfCoMDNR6gx76iDsd65HOYI+EYYBL7kIvx9cHh0RKso6I3w4+pZTO/cV4B
7Mm2xwfR799a8/nex2rGMj9VUz+B9zDPM25Y60J9S5+zx6jXElIjyzim78HO
9Hc4Ebr1G2uJQ647BO+ZA3rft9eMHzxeifcZs+fVcpxn7JraAG2Lee0A2s5V
tXzWDeugiI3adjXXumPtt81hGk/An6wBAn+8puuW8T3WeF4y2vz8mvyOOZm2
g/Og7RKTmivTj2DNheN/4ixiSGvmt4z319Ryral1IHgH10aOoq+F8fT+6Af6
hvmCudX9QU21seWCWurexH0frmVOzmvO0KGNwdaF4Eoer++uOZdbu+K+yKOg
PzKOnbdwbeSxmjqmc8/ETfThWo4ZjYFYlnn87NjH+snr4jhom2jl1KycXTMu
/nDNnArzi8cP7Uq/gAkfq6Wmf04tY9fXqD1eWjO3xfzYbU2dBpwFrfbccU50
DmKMNnRK5kbX4jKe7O9optS6mtO6Voya9VfX/E27vhZzaWKIj9YyJnVcQfsx
54Pbn6hZS0c8dZns8ppcgHu+Wv/vaq4FB4vMgz6pbY097cOdR29sYS1X401r
0M2BwB/WeN0yvn9lHX6mDnH2z9asXXANOmsi4XFoVZfofsjjG0sbY5rvgJd9
DbeN1xtr1gKRh/cYJS50PQAY2NdyvJa/aZpzQfYf5rVlV9RhDTxz6MmprEcn
ZnlfrgM+RO4uc2/UAdmsdVnz8rM30InQ55yPp67kLfq+tXZ0S9couKYu9RJy
0ra3yuxbb6w5P5xTs/aU2nrmqP7fsTfjke0XqQ/RJ9Hx3jmuCZ7YhoZ7vJb6
H1hk++DoM/I7u5rzOnprj1+4QfoL9Wgfq2XNwLvUt+A5WE4uC43mnTXXl3uc
UgvnOjj4Gf4B1lxcc/62fuM8DxyH93CbxBd82PHXrqZOy7F6W2s5zX3alzuf
TvzVXIccGLWGd9X8zWB0YK95OG/0E3FB+jg5Z2scjhPB0St0fVz7TTLWetxV
s36ba3IfX1JLntHnp9bHOXFiZPgPHN98xbwF8/pWsJJnDF1UM//LfX+wlr/5
DJ/yuGC8+H9jILkcMAANqu/L8TmxP/G7Nbnj+qz/t3YOXqFzEFuiX3j9h/Uw
NALwyDiF3rn26jW1x2vmhrg3rvHcmvWzzL/MU1fU9BvXgxmHwHb4BziO//Y4
dR0fY5bYyHoN13q8Zl52V1NLbW5ObW/PjawPMAblGKXPGavgEDqTefvbx+cf
U7/Yp8AXz4XwQV4vrsnNbPAa4wSYQ9uznfVPYBB4dLW+f632Q7u9tJbPPST/
3vjT/OaBmvjT8ddjtVxnwZqri8a9uc2Ir6l9gbuCy8RU3OO1NTUczx831NTI
iQ9vq/m76fwP/7m+lrUFjEn4Dzlsa8boh45v0C/N35lXzVsv0udwL68BubTm
XMs8ic87jmNsfGLP+Tx/UVfFeAQ3OTY5emuMcCfrSFkLAK9yvRXtgM+CkXDK
j6ht0cLAOWITcoEY9ZZgIUau0P2Q7QX38bMbbqw5bzGWPP8yBvBDzyker+jS
cHTiGfOe47XMc4JLrOU2J+9Y4taaNb6sTbp+/G+f5DkxrqElpqfelHkLLnZ+
Ldc7gjFeAwCHMbcB78CQq8OIl3h/Vbznc8dbroWxgWXGNcY4a6duqLn2ndrn
ts7Bw4Ueq4k/aC3OdbOOwTo6ccPH9Rl61eW1fO5ZH/OEDCyB59xW8zkfd43r
6mu9Y/TxiZpxmcceMbfnPuuQ8BDmDefG8asLZcRHaG6MlUtr1j55TFCHiVaT
nMf6dPJhYxBGTIZPnluzNoHvcs/GBXDfMX7m5tZewUTPl45pL9CxGAPJjcBC
1yyZm1lXg+PRHsxpzAXmONfU5BjXh/VYYC72sxc+oWObE59fk/vBiY/X9Pnj
tcwHgZXcG37U45HxeUfNcQoGYYzXtp2uFbxk/uI6aVfmDPrNuoy1bsdM5onm
ONTwginWZK6N9+SteHWcQt0ddqVer9T58QnyZFfqeN0ecB+wp424pjHo/pr1
htfXEn8Y5+YNrj9iTDNuOCdx3+061801ccevtw8z/jDHML94HqQdrEVb48Yv
P1JL7cD5M9rM8wvzivkz7+kDxgPrZeHHjCO3Eec2b0oMwtfRCvHxD9fMeXKP
zH9ef/JRHc/zo99fUstxb65urHFN69o6F7Yz1vAht3vq68SftEPO29SQENte
Ofqb8eI86K6WeV34sGvjzVtpH9YqZu0WcxRYBEeD672/pv+crOX8TR0v/zN/
3lHLedbX6TjFmjV+5vmqrx/Mumx895J4D8awTtv8xXU5O12D8QaDt1Fvw/ev
0XFTGwJ74D3M52i819esfQavab87a+L1XTVrDsl7Ga+T03EttAdYi358e83f
NOz/b9tjxFhZm831EXsxn+x0bq/NIP9pH8BXrLlZ27cGB8bgj+x3qT67VN9D
t+OVmkfiG/s7OJc4kHj0cb3ir7S5c4UX6HNj2CUrx2MsW8Mynnr/HPfmQmvf
9za3I3PSBXEs2i/nTjRA9+3VNX8jihjHWMR8RMzjmJx+497AUHD9uIz4D/7u
/IR1QuItcMY5nPtq+bt59499bqs5t/p60RzAT3wcHucaFOszzOuX1VL/5hjk
jp13Ik9ls/6xZo5rrQ3l/7wnPsMHL6+Zv3asCpe4dbQLc0m3zcnRjifH/rua
2Ann3dXh3D7YcHNNzuMcGzFeH9N8lWvis5tqPteMuYX9GH8namIzMbXznswj
jPlLaukTzmGhDzoX4Ljcua7U7vwddHV0aPDf+14chh8a33LOZo0t1+MYjHsy
Rq7di7HTfJ1x7TGW7WGc8TGNGzaO6bHrNXvm7Dk3o98SrzAPE5ffUXOOMn/m
O/gxfgW38LzMvEJ9GHzVeQhrZdbEPlFz7PaYZmw31oA9jTmdO35w/M/ayZPj
u7fUHMPWIIxL1nTBEnjHTm2Fb3Pv7LPGfawdWzfzvtfEvvRfjhdzrWtl4A9j
E92H2Jk+cx/Sf9eP/RyXndT+aC8c45aavKTf367tN47t9FEf666aOg58iPEE
Jt5Uc5wRe92t/Tzm4EA5d4DFjPv0PbZ5Tsn9yN9+tCbPc8y7Fgujc/X/cGX6
Ft5onnNxXEPGIanBOHcKptrn8ec1TdHzla/L8yTzy07m8Ze6qee/q+N8Hvce
z7ua84bPaYyhnx2zs514Bi2Q8UaexLnhXU2fNAZyL92O1sY+Wkud6KN6tY7h
NQPUrWDUq/Tr/bJ79Bn3kP4EvzeueN04OWNq4eA08D7Wd5o/0Tdeh3Wdjgtn
Sh7EOLBfpVbk/JHb2usUejsaGJhLfMMrWERbsCas8fuRmthBv7NmHvy4veaz
7Pku8wB9Bfbcru9zTM7PGLtd5wQH0aK4buaQzDXQJ7QRfN681j5hnHL82vMj
9YO0Jb7F96/S+2tW9qOP0DEcExF7gT/mbeZJ6KhZp2HOtW+MeV5z+/A/uQib
t8ExPQbBWuMbGOa232mbYw3XkIIx5Ks958B3re36c7gy48HzEQaucV2O51JL
cL9Y/weTqPnteyLmImfcdbuNPT3eM58DP8JSF3LejHugD07E9V9Wy5iK/qUv
vdbc+fFc+5l9TQwI36TdPvUVtvsYvl5r786zW1Oxngtn4Xs3jzbqtRdP15nn
cRDnGnP6f7DijlpikzGG9R2MFWKqxK87tD9zBdyJfkW3dixtHHJb7mo5x7pW
irGYPsr4zPoM+2xqceRCdtrmOfgr6aGuIbJ+5Dyb9R5w0nHLrpa+xpx5Q5jH
h8cFfn+LjO208406ruc+j+8bajlesRM6n3mu5zH6HGPM3FGTL3hfa5Ycj/nT
/gW+pcbiecjrC2lf628XjT7YqR2t+YA/rBOwFuT58546rH/StifqMEfglbHl
2IvxvatZk8C1sc06iceD53DHMfYlczG4ATFNxk4eM+4Lv4fj8D51X8dD3U6N
PaxB/XTNsQB+eR7yfGQuc2stx4u5zh21fI69+RZ89QH9b157Zy3nTfzJY4+2
zhqMrFV1HExtt+upWf+KT3EsXolXmafc5+am1hJTs+mx7fyHa70yhvdaFNcq
OK72mLpV711H5X40F/U8g38nzzih85sneezeovOYYzvfwbwCx25rP3645rPu
HLebV9yjz4xDXEO2B9sdn5mzOgbu9md+gG/s4njmND1OrfUwbzJe4e72j9TQ
wWnek18zdjKuzGe8noHjMVcwLo0P9Cftzz2A+YwB+gZ+x/08UEsfzfv1PWff
GDeM0w/E8fr4vfbiqTqDPU+Ofcw9GA8Zi92i98S/1FbDYbietf7Ka7lf27lm
4rjkrMktzV+TC+xWjLVkzmdeUkt9zxqh5xPGjDEQLIInw3+sn4A15tPkThlj
xlTul/jUuG48QTO7q5acNDHH45BxhtF/98W5jGHWa5Kf5PXxOdyW9c5d70q9
WY871v48WnM85LjwmGEeg0cbZz33miebD5uzej3PlTWfUZz3iK95rrSvGre5
Ls/71jqyxp8x5Dgn5z7+p57YeM/xuda7db3d5uhUD9d8voXvgT7BHqn5+1v0
zxMr/YU9Nr738Pgu5wOnH6rlPIOGZt7bx2j8ORjm+MlzmGN25wLcN85HOi6G
04C3+R3jEXMhx8+8XcYWa3EpZi7OPv1/askXjW1wLOsMHMf1bzfE/32O1ALR
uM1xnPfZ1eRmjlvwJdqZseL2on2M156D7A8ch30ZF4xPxiPbPEaMM8Y+sCX9
MfuT8f1E2MEwxjbj/+GafvBITdxCc+HarC3a9+6u5f3DN7KG0XMFWivrfcBz
xvKDNedP+xHt7jZJDpC5u7U8nnk1Yy21OmIkYtT0P/z+oVq2F7jANT8o8/rP
Tw9z37Q9ufLa9pS20Yc22onze0zRV9zLIzWfffjIuCd4HPsy/qw3Gy+MG+47
4wy4lGPWbeL4mvFELJgxgLHBxnbGnjFpV0tdlVjoylrWnDCXOvdmvcV5APOs
rC9zTuLauHaPR8YWmP1ALX3R4wj+T3uZJ1v3dM2K5+6HdEzHP6dWjum5Ajxi
Tso5jrmTcdTz40GdWd/T9tSw/v/pmr93wNj3vOr75n8w6sE6zInwxZwHna/1
3IXf03/ELvfUxEy3i9scv3q4Zt2K9SzHJc4BJy/yHJfzjmNPeII5F9cD1nNN
5jKJ6+afYM5Toy8+O15/Tvb0VzDj0KdrzheeN8ypHftZC36oJu49XPP5h2C6
59WT2ga/Sxy5pw7jivWcxCCPeWPmgzXnEtcCpN+ayzqf4NjIn5HHci6ncYL5
z+PA5yW2MwbtauJb1sI593Kt9nUdiHUMc+eHRn8wv2C9DV80V8l4xePUbY3v
2J8YH8Yuc6X7ZHDak7XEsr6mxgzi9x6TPX5zTH92vP58fP4Z3SNjEb7P/Oz4
IHka15+Y7GsmJnRNkXXyu8Z3PH/jS2CiY5MndX1uT165RvudseTe+Cx10Afj
mFxPYjGYQ3tl+3261rnNU6P96YPPjn7Ifsm54qAm9jB3EHeZT6eWx5hi2301
nz9/UBPvze3XdCVzU873kL6b+hTnNp67PsJjxb7DPuY+zuMybjJOyjnOHMlr
x4xBnxz7run11nSt/1sHBpt2dThm59XaEfXozAV31dTdH6slZ2Ae6vHCeAef
3VanwpJT4gvs7xjZvDbXFnhe9/s+TnKcz9X8LblfkH2uJgY19ny+5m+u8Bn3
e1ATa43B+H/qDIm51h8cNzkuw26qJZcz93pM54S39XV8VtfNNuOk/R59BD5o
Y663NvNQ/G9embpMamgHdTguOtB7sMLYAScFe8Aa4w1G24BlcKtHaok3tHPm
zhlXjMHHdb2P1eQb5u/31jKPBTe0dm0M6usBl8Af8vYZo2fturmz/cIaXuZ6
jA/WG7N+oWMl142Tg/JamBO6P14xY5G59B11eE2A9SD0RGJBdEL4Othwqub4
+nTNcYBvHtTkAHBJt5/nzzTzGeMH9+ZcJpbrnHK9AbrBQU2MBFe+UGfw5xdr
YtEXavrs57Xt8+N75kiO057Se/znsZo+u6ZdWftILcs5H9d9PFyH9dWndF76
4elxvdxLcjfHJL0dHmFMIF4xdtmspVjXTZ0mcdLff7KW8SzfS52H/7l2zwFg
jjUd5y0dX8EvrXm5ts/rquA9vo+Ha+os5uLGDOfrMx/p+nNroXzP9T6JjXAr
52jv1XnhGWs5Z+eZnYt0rsM17V5zRP5jVzPvRBzkeJ52uUvncvs6t7FWEwAH
A3+MvadqzrHEMAc156Qe809qH8/la7hgzKf/MoftvLC5AOMn86VwVHi+r9Ex
VfvjF4aBPXCcn68l34En9b6/oONg+L5jAPz1iZpYDc5Y50y9zDhF+9Gv6Mnw
B7c7mPPZcY1cK/bFWsYqGct8dtw3sWbGM97PXAScchxlzQY8cTxqLY8+oo3M
WcCcxCVj0BM6DzzMnNqxCb5MzOAaEHME/PyuWmprruG03sPYYyxmrQD+iR/4
ulzn41wM45u8fdZGZp6Fe0K3cTxlDdo5rl0t89r71k1QR2gM4nkgYI3jUNch
7eNfmSfLHB1Y6VpaeA/jxjVYjjs839Cm1ouINehP+g5LLdP1KeZ6a+sIuLaD
WvJ2/BQ/g/v0q2Muaz3s+znt94Vaap2ONx079Pnti4kvxCmMbc/Z+CbvwSLy
vuYq4CX3Alb+Up3B1bZ/cNr+/tj+Od3Xz9UytvyC9nEMCo8Ck/J+uVeunfsB
W7h/x5nOecMPjVHmUta2nHN/XN8xtzSnyHUMWYdl89oFxhn3hRbkumi0HdcQ
urbDHMt18q71YIx7fDPXrukpxs19dROObYw3xDe7OvxsDjgO+rL1nt7fOvFO
x2ddW9aweu1O1vblOmeuL7GHtbnEXp67GWPEGMlzzRmN3ffU4fVI4JTN+o11
nqzFIpZZ01+tH3xGr8zz+Bw+mbpz4gy6AxhgXzTuHNQy5si8WPqT45f8nPfo
bMbEn68llpjXfVHW+PPLdQY/wRHwNWNR2iM5njHnQPcK53FeEs7g6yfOdK7H
mLGmkTjf4O9YZzJfxJfT/61HOLeY861945aazzu0rnN7mOfMXLfFePf7O1f2
W7tGrmutbofrAzOzxj7rN3Y1tR3jj9dCshaM+ptcw4uBP65pNB/LdfjOlbpW
nc+S/6BVew2141WPAV6dU2SecK6M9iFP75wrOcjMSTs+W8uZ+TqS02eO66CW
PA3dhnkfH8Sf13Iq1niejG3WPp/SuYwpbi/XuD0ar44ffH+P12Eex/8ZT6Ve
3hyo+Q88z/GiYyv2d1zm+OpgvKdtrXE595/1PFlH6PyfdT/0DM8v2f/OUVjT
R4PNWlbnfDzvZp0L4xQfPjnuEZ3ZtbGOjTLOct7duJTruHJ9ndeSUIfjmmWv
HVpbu+Z78Tov194Yf1xLxms+G+LKWq4dhytdW7MebVdLLDb2kMunXZN3Mg+Y
83jNi2vH1uYpah+svZADNDdkPqIOBH/C507Vcrx5bnywlrkW54tTP/E+xIfM
z2gHB7Ws6cHXwB6wZA1vDmo59ztHbI6VWoi5gWsLuM7cx76GL1tvzfjn6Vry
MHM48nyfl32mltzQOSWO5/y164rBG7gvugt9uIa3qcW4JtU1N1mDlzmftXpz
r8+wlmy9AZ+2f+Y6hMwhM077/BkveY2gtR0wxXmgvKbMicO7kudkrXCu1+Jz
587Jazun7fd8B+zwulJyXfxPPIYGdGkt10a7nvCmaL/bRpu4ZgReRkx4k75H
O1j/z7U4WaNCv7ve3PVrHA8O5TpyxiUxvPUO6oBcb2XOkHw850XXhOIXqSeg
SeN/mb/tz6x1WufKen5ro/4emoTz1ll37VjE27l/tj+ycm3mWsYK5yOdGzqo
ZX47tbvPal9qJ5LDOV70NseX1FpkTUHWm3ptgXMTa+u+7q7DOYyMza2XZK2J
51zrIfiv127dNo79RC3XqrgG2utdrP2kdux1J15r7GsyjhhjdjVxyL6eBqdh
7TL1OX52zPV67zXtfuYG1p9dVstn1XjNj59x4pjO68HBE+e1cg0GuATPYe2K
80yuxXKdg+Nr6nWt+3M8toNZWfviHNBX4ghZX2KesLbeEB3aWi/4hrm2DX+1
D2d9s2tz1zQdr9V4vA7XNRGDZM02Puk8rrkPsY7z39b7wROf+4k9n2X+yDks
uNWn9R1jTObuMo50jddanOz5y3mS1PyMSfbp1E28P59lbsV6ibmPYxlyOF6L
fP+4d/DG+Sfny1K7sQ5s7SafcwAG7epw7Z3zTOwPtuzq8G8ogiHWaKzpZP3g
vn0zB3ZVfI+1F6zHMqahHa+tA897BK+sXeU6IPf32rrujF2ZM1yrYO3HOUrG
JHza6wP4LNciulYP7FnLtZrTE9t4H75r/MEXHVs8WoexZs3SD+EGWc/Pua2j
Ob6wLgIuOx9E/U3W6h3UrM9xPsgY63qJXPPEMeB1T8XxHq51bPF1Z11X1svd
H98Da60Tu1Yma0w9ntbGpjVPxyFrdW1eo4YvkEf2+nT6iTnWMdNafOdnKZhj
Ob+zq8kZOPdO28k9WY/x81jY5ngJvOD75M2vjGMl9lxVyxz7VfFdn4fzg1N+
dg9ci9ycaw3dB6lBgVXuzzv0Xc8xrsH0ujqek3Sylnq11w+5XiHrdPbVG65p
lA/E/7nGic+4PmNVakquncz6uUf06pya8zrgjnnNg9ruWNB5aHT2bAPHZMbJ
h+tw3Yu1bcdi3EPGmWt8zbjpfdBzzHvW1u1ljXlyFuYn8CVrdo1Rd9WS5zhn
6jW5+ZyAHLeup0ts4X8beLCrpT/cXLMWzWuXXdOXz2zJeuI1nQb/w6fNW3g1
bmB8RgzEPjYwgvfWjomZrojj74u7nHN3rj21Ip/z6pp5ePM/5/5pA95bu2ce
oT9vr8PzjccH/cJ8kFqP8w/mpuhyHpNgAzzXOMR212uRr1/Te4wxWd9ongVP
sX+7jsRrJaw9PbhixkLHgXyeWuza2ov74zzGBXOVjMHMd7I2JvX41Obz/rwm
y9ecenE+f8nPM8lYat+6Ae9nDGHect4i1zXeGtsxa8uMd3AmY4V9z3JwjHWP
3vfx0YStI3mdpmM+cMZ1esae1F3MS8AQxz9gx+V6dZ6KeMjPjPJ3waFL9d3E
GvOfq2r5nC/nvS7XtV5ey+fA3KS+At9zbQec0LXd4M9aHJscCfzxWnv3Aesi
s5YBbLpD58t5z9pijnPX+Zgf5Xrlk7U+3+aavawbynx4+if4cqoOxx/WnLIO
wfpyfr6Gm2uaSupLa2sMEl/yfx/TeXJzOHM1tKqMq1zj4hrhNb7sGi7ukfay
XmvevYYtmTsiX8R+fiZa1tqhpfCKdmI8wic4BmsKvH6KfLjritGOHNMRk5jb
7GrGS/bpzDXZ16/Ys+3yWscG7s3Yc1nYJfr/qjBfE7ji81yh7b3/xbX8jaFd
LX9/yrrQ9frf9T2OmeAfWS+xVvedNdS36LhrvNTjKXHP29C5s4ad8WzfT5/I
uOakjne3XsEE/s8cjetVPP+nxm3ulnGU5/vMc+V+azV3xjvrL9bAH4z/XWuT
773N+L2WL3ScxrXl8yQ8D/H/fbWMzd0vec+O1fatwVrTVHId0y2xT+rLzLe7
Ovx8411NLHIejP1vHffhZ56sxW/M63y3j9c+CkcwN7EfOxa6qg77+JrvJzY4
1gLvXK9j3Gnuc3Et8ct8qPe7qJa/o+Nr9fHaPl7zd3euVtvST9Z6aGtiOdaN
Ead5Dadrp93P8CDXSjnuNabl/GQtyHH97Tqu11N4fR3fR1POWmj7RcYDqWvm
+njXUePvvc15M+se9tf74rP7dUzr6lkj4FxXal7Wp2zEQsRVXJe1dWOK+V3m
4KzlZ44x8cprGKzVuL6FNkdPdmzlWvXU+phnsibZtSA3xStznGtqzdHNU1zn
sqvDdcDelnXBV4//icH6mNS7MJdnPhw/Q8dxbAQ3cR7bfn1FbE/NJmOuy2vG
SOSkiOV8DvjJpbX8/TswxPjDfpfpnJfqOMau3n5hzeewXq72Bv9pX94Tf+5q
mfdybMR85hrpXDuWNQ3+Hz3atc+Ov1yL5bjeHCh5OPt7HU/WeJ1c+d/aJfwO
XTSfb+PYyTpzajuOR+zjqW/sq/l5sA7HhpkjOhXnhbNwTNfXPBzHTU61T7tP
LOD/jEetNTtezngrNR/6wO3rvLvz5dYrM5Zfy19b/0VvuEPvrT3fVEudZ1fL
PBhcBkxxDuq6cZ2ee2+N/fApcKmPn7GMc+TJJ2xgAbhgjmPOY97kGA4OBG5d
Egb2EIOt6UlX1vLZp3le8I3jgWPX1MQa+Acc8ZZa/iaE13i5ZtH1o/i/9Tb6
YS3naG05x2nWft5RSzxaW0NnXLKOzdyb9fXOw1pLd6xwUt83T1nLfYM3Ga+w
z121rM02t0icMEYYw6znmgtlXWVqxGjMPqc1KHzcnCjjv+Rh1vPhW9bwzTH9
rJx9ay5TgzsZ/yfuML5cowyWwHlO1GH8cWxPvmWtXnjtuZ/U/Tk+6FfWFbRP
3VET+/jftTnmQ5+qZQ4K7Yf8NHEWvm5d2XzEOMR+Wb9DLAP+XaVXx2vEXJ+o
5W8gm+M4tuOauD+vyeA7V+nY4CvXcqLm832s9dD26G5obeav1hS99sLrS5Lz
GC+SwziuN57ks0A4pmuJcn2NYzbPR3kea+TO3blOFVxM7DEu4O+OtVh/a73Y
tUoPa5vrKn0c18BYW0nseSCOv5a3e7SWmHKfjnWPvp/5NufdwAhjnfnP/Tpe
1l4wxzBv3a99XKec63LW6pS93tKaYs5T4M0tYV7HeKIOP98K/HHdberUO+1n
HGP+trZJjgvM4jv9mviDDos/WzOG55jzZKzFc8DASuvpn9J5/NwecAjMIbay
1uP8FzhmzraruTbeeUPXKfr+3PbkHMmDWSNjTvlKsQ96TNZWZP8nBpH7ynox
sOE2ncP60a1xDI83c6s747jWLTNfcnstcRQNiPNn3GV8MAcyFjiWynodx1r3
6fvWk9f0GWOE81Kn4jvEW2jQD2mftbjOmJfaVX5mzHWtM9dqXuW8AHGt+c2a
Jpdxmflr6j/wHM+PxqOcA2+J/9diNq/zuqmWGAVPuiH2advVspbx+rhG60jU
+jre8jqIrPujnjh13v6MHBpY4GOAP2CpYzzn9hN/1uK3rAMwHnktR2r33Je3
O94lxqUfaEfWyBI3wzv2YYZfkwOl3RbH8jF9LOOFdabM96e2uMap1riUP8/6
JseX1iWsn6Tms4YDzm2vabrGMNcp2u9Ti8nj53HZnjVKxhHrUGv1SsZCY1fG
eI/WYfyxXmaMca2h47E1jc45gbVx5XVDjveT8+Q8k/v4eTOpLeV+juvAHzg4
Nbx8d1eH12jhbxzL+jR86pMy5+W9boJ6PvZn+3U6B9q2cc4aN9dx4/gu8Rwc
y/hzrc5nTQtutaslbzlRh+sPuX6v0QfHXQ9KbSIc1z7vvJf5Arwnc1ceBxmL
Jf64tuO22G9NQ/KcmDzHeiP1YK7/YFwmjjkuy7WC1DWm/9vnHVcRD8ET4A18
56GVfRNzzKUeqiWXul/Htgbl47g+O+uwrelkXVPiT2pW/J+1B67hvDfMa3H2
5efX6ufX8gyZc01t8I6vYIyzNe1w7TjWrM2xGF9wJI7v+iLP7TfqM9c/k++x
Lm3zunav+cr17rta+jZ5JWMguLGrmf8h/01cRwyF/mttzHXJa/Gnn1UCtiQf
cq3DCX3PfNS+7n6wj2ZuPDVex+1rmhDxl/XJ5D8ZYyWHIfbrfa03O8fhseX7
SMwyBjpf7/fkfTLeWvPNjI0ejm0P61iZS/KxwCdvAyeSGyVXgZ9Y30696n59
5n1OxfvM7Z2K4xkfHYc5j5X5ecYL2tBaXWnmOTKedny+Nh6/kubotWBrY+wO
3Q/5LccJnu+NL+Zo7M8rvsZaALTtPp5zbK4zska1q6UP53eMS7mOn2NQM3lr
zTqAxp/GiMvHe9a2kaO6o5ZrRLN2nPj0RC31setiH7eFnwdifS45RsZErvNz
TXzWLFvbzf7F5/N5BHzfvMjcyGMRbHDe17yFMXlbHDPz8JmPI5fsmlyvyzcn
SN3D/Mi58IfCHMd4XVXuiz6d58z8eWKhuddjK8d2nJg13bw+vLJt7dX3k5hI
m/mZW2AN/esYMDlUcqC1+dBjZp/u53qPu8e1+bu5jp46JfNY9GRip4wl0DXI
LeO7qTVZr7RPr/lo1ktmvs+4kpoK2zhP1rWwv9dhUHcDP2Aux3/N66ihtC62
q+UaNq87Ie4wNltDS303uWzGJq4fuys+px9Tc/bYSBy4sw6PpzXMyHw58yTz
FOMoc2IefznP2m9cF511ca6FNiZk7sjaT2KPsYkctuOkU7F/+jl45GtOPubz
J7atrbWwpuPrA5/WMAeNyfeVWrljscQV5/Z9T2v9mFqfMci8nD7POdG6N/pd
1ng9UEuuBjYy1hMLHGvBTZxz9Xy+ph2gcVh/Xauhs/5pTcTaFOcxt7DWdELf
9bH63J8Mu74mXjuvdKfOgaa8q+Uzyqx372qu9QIHwb6skzD2pCbifIRrxajd
MB+y3sjY8fjx+kHzH/Nytpvv8N2TcWzv7zw1tSjGKGNY1vQ8qPu6V+9db8yr
/dcxR+a77Nep5drP0WawtfePxHtzmFNxLp8T/PFzQvadh/1O1eHr9j7+nvFs
rXbR+OOcHnHZfTqWaxtPap+1+SlzmPvqVpnzPCbXnivg3Bzz5j792/M1eAEG
ZZ2A9UYMPHNdP9ft+Rn9wxiQOZxba8kruF9wh9jter23/mBdCOy4Ucc0BuLz
t9Xy+Ym7mr/53vwpn2NijkNfcI3GU2tv5LvWcqOME9dxGAfuXfnOGvbALZyP
zf52bG7NMuuYfV2eO722y585p3WqlvFVrsmyboPvZQ6dOp/MH63xmDVsWXuO
0GOxPd/DOR6ow9zJ1/lwzfXvXrPu1zXzuvpH4/88zlrdwBoGZf0j26xhG89d
02h+nbG4scjY4zkqceeeOK55+q11OM9rrQmfgRO4No1z3xzXSjyTtZhr3N4x
gP3BOOhak9S4OEbWhhsT4U6Zg7tB92INxXhMOxO/Ue9jbdn4wjVwHHO6zFP6
3l07Bm+w/7J9bbw55+F+cFzjWlePpcQQ65SOp1wzy9imnVyHknV35j8P6nrY
zzXB4MdaHsm+Zr95ML6Dr/Kcrv4/n8fK66O1fGaGn6n4WBwPfHlUx/b/5i15
HJ7H4WfEfjqubW0N/WOxLZ8bssYNmRsy/2Zd31p78iTrieYUa/pkcm7PUY6v
sj4pa8nwwbWaRvuHuRJ+6bqlrPVPzp9zZdYt8H/qoDbjBG3AfZ0abWz8dL7b
a9vADPMU7iexGA2J3Jafm7FvDTDXyv9r+Wf4p9vO7UAbuXaFuQ9eyfjKdk+t
z21Lf6Px4vcegz6m8QU89HoFYjGvX8raX6+VdE7aawz21duxLfUS2iS5Rfsy
HMg+z7MynlzZ/nhss++DVdQaJp8xVzFuPBHH+bS28z/PfM7nV/u5HnnsNY07
9THzG+Ymx8t8fq/2yfzEbWGOJ/Kz5EAey5njMPfJ/Kv92vj1gI63liOxFurP
s9Yyfcv5BecC85qTOyUmmdc735casH8jg/aiT9by3843runsa7VYrtnKtQvG
GmN7rgHnNev+H6k5bqwZZV9jHlv0/a3qW2sNxEe0cdbp+9WxENfzYB3m/8a+
e1e+DwbCg8Aaa7Rr+k3mnsxVnhifPbFi4AA+7ecv57Oi/bnXWPh83m484vtw
MM57UId/Yx0M8jOeed6qsRH88XMV8zlDztlZH9oXE5tLW8fzeHXMlPX1xgvG
l+c/z3uMzzUMSs2A+dH6VGJDxhCulXO+xDmRNW0q507j2FquGLzBR4zl/l7e
J5zH9+3rWcv1ON9oTMycZOafEqMTJzweMr/L+FnTbdEY4HprMS5+Tmxk/ASz
GJ/4CPGU+3itHsZzpvNBtntqiZuOs5OXe11EYotjCefXH4n9HJtY4zHOpM5i
Sz83Vq3xEPqA6+DVWLTGW+BejS3+bQzbZ2rioXna2rPqHSOucSHXRzrfiL95
zGX+3jVZ5q8e25n/Ml+gb8n1JxZlTs0YdrIOj5W1Y5jfJCdJv707zOPPzxtI
vm48wafwX+sPjFfXPmQ8m7jgeNFtv1ZTmnFi5pgzL+74J/NA+TyGzOtmDT9j
i+P1NsZ6zgm+Dq4RPe027UMc9Ni4rrXxAx8BFx6rpXaZY975XD5nm3ms+98Y
xxpy1x+aS63VQD+o75prWOOxrmsOlfrPGtasxWXGlUfCHtfxrd0YOw5q+dtC
/u0wuNDjNZ8j7WfPH9QyjnOM57pK1wXAaz2+vc7FHNaxtrXjjH2ypiPjHOaV
rCW3X+PP1j0dP90a5zJfsc/51TjGWNtXm+n7NG+/r5Z6edaVZK6FttxXA5Hc
zdhkHMx1QvjX2rpExxC51id14ayXW8vfOmfsmlvjEW3l+da1r9b1HeM5Tiau
93V5X/NC5k7iocdqqcHkdT9QE9ecS3efGZvBmcSwrDek7TxO3D7dFnAF+37m
oU6pvR6qw1hi3uJ6xcyHOd55NLZnTh3cTvzJ39U5qPm7GU/Ee/Z7Wv8bnw50
7qwzYqxkHiw5pec8tzttjw9xjH26irkx2OgxnRhiv3duxH7vGlifL7EvtYe7
aun7xpt9XIPxazw0p3C8lBjuce8cSeYmE/9Pha3VgmTN/gMr38/caNaoZY7Y
87Hnqswvm9tRp8u+9+uccNS1fnHs7pjb7QovRhMj3/x4LeOaXFvAda7lu/jf
saTnSNfUuY09D1tLvS+OSW0eHIFrxS/BhlM6N9fxUC31XsdUjAM+Nx7Z19OH
zT1czwOuOf9l3ce/5eN8nLWpA+1rLHu8lthDe/p6EsPvX/mOdbg1Y3ztyxvR
V1n3BK8lzk++Bd9wbslaqevSrJd67jV+rNlaXYgxyNvAqrWYIjUT15as1cU7
T2CusoYBa7WnWYv2cB3uW+dgrAk8Usv+TY0ya9ac8/H9eM4h55UY67GT2J11
XV4X4761fmhss+6C76zV+dK25vF31BJHrAe4xtDH8P0Su3KvYOU9cQxzF3Jg
B7V8LkbiIP1mvRmsMj/ImsQca55/3F+nanKn5EzGGOPLk7UcI6llg5GOE9d0
MXMca9KpKa7NrakP7OP1GcfQx847wn/oH/Mxx4LWW13DYw3Y+ZZ7dK2OZXx9
Pr75R2qQrlu4W9v24ay5e/KLxB7GjDU6sIC+zPqKzCusYZHrW2lb5ibGVeoC
Oadl3Qfnc4zm/Dr4nzGKY2zzQGt91uD93IOsVwd/OLfHNXyBdsO/nlDbG3tc
O2SfZx749Lhe6zDgF2MDHsf3T9aS+6MzOJ6yNmLtNWN+a0/mvm5Pjm0enLFK
ann4+j01ffHRONYavmT+npoDc+5TOq/jO49f/Dtj5MwVgD85/2Y+wfs7Hk6/
dpvaJ9KXXG+U8Zhz3OBK4tz98T23v+N2X+u+GGjt/63PrBOlXpOxd/IN4w99
t6/mNLlRzl2udXNuw7+ty7HMo+He+Ru8+LVjG/OZO2s5vs2DMi6xvzJ3eD2K
f5sHnEKf9txifuf2ck6Z+3lYfeM5yXGq897oV/frmHDxnG8Yf9R2wdfgGXBa
48+jOq/nWc9pzHk+r+vT8F3n2zMGX8sb2EecL7Bvmg94zCYPtF8SXzMmzHOs
vVtvfCiO6e0e09yjY7bE59QVzCudK6BPD+I+4Wapozjvbe7Ofo4fk99YT6Ed
2df1B3l9qXWllpz1VIlrboM1jkJ7ml8417Kvdiz5cc4vmQdBC2wzBvV7x/dP
1vL3wZ+KbW1oqPQ1+XP3Q+ogjnvcP/iAa8lYi5e/kZE5zUdqOYbRnYzJbpuD
WvJhOBv9mPGMOYnzj9apjRPm4OiTjhNSVzU3SY3ec2zWkWStnTWmR2sZ6+a8
xzbnjZjH4VXmGTl+XXOwdt+upfeaJV8H/ZNt7jwK2GN93byW+3F7WlfK2NO+
az8138MffY+pw3recg6Fsbym6xi/MjfB/2v8x5jH8XNup818f6n5pF5s/SVz
E9YNzV+yljVrYLMmzXM4HPOgpp74pOypOow1/f/TYa4JYb6gv+kPfJkxbv3M
7es+zPqDfF4mY/mu+N5abHdvTQ7ktoBreM63ZpzzjflBjiHnWZy3Ty0ATD4Z
x8m433PkPfF9/s/n+PtcqcUl3uFnjrkyP3xPzbkETf9RHe+++C59Btbm2k+v
ibizlv5gHdH+nzrVWp2S+xSt2HGNcwQZf9rHaXP7qGM/Y9h9tfTdB2o5f7kW
z/l5c0H3r/uFceW2xW84PmONazX/MQdwrLmPQ3puof2de+V4qflap380toMz
ro/NHAS5i4Na5kTbssYMDCL/+tlhT+sz15Y9qPZaw/LU8q09O2dJPUWuNV17
vg9zi32Nz8hvOAYlvvF8D364P9f0TI+JtRor9CvrWGu5u7U6rKxjy/wKbeCa
eK9tZmynVmqMdPyb/M1rlMBS4jF8LXVO+s/roPJZlll7x1igfTNeSuwxh3Xc
5T6Fr3E8c5SMW5LDMF4f0vGtGRnTwbzkbo7HXFOSsZnrh1zL5/y+6z68L58x
Pzhedi1I8rt79Jl1tNR5jM0eJ/S/dWTrrI7hrCvDc8x3noxtT8S+a5/1d+A9
n5GxL1rQQ7XE68xzpUaSdRD2TY9pPzvFz/4AZ5xLYHwZF8xfM9dvPrJWo5Vj
434dx5hjDGUtZL+uPbct8WltfTa8IeNQPzePtcR8jp/b942tiUmOl/wMCfoC
jmh9wnjpe/XzZvybNhkf2q+st1lvcfzkebU/J953HsbYk5qrsce4bH54d81Y
k+Oe0veMib3Pk7X04Ydq2aYeXw/UEjs8/rKOke94XZXrFM1/zLWsN3GfqT05
znMbO+8NjrpvuC/zyUdq2UeZb96nHTdmUHfivFeuIXROI2vwP6PjWLum5oQx
wPV6XGQNqsex9Q3P9dZ+6BPXJNPG7gvOvxbnZL2XMYrzOxYzJnl8rXETjxvW
8fp52Y4njUW5PiljTa/F8XN0/RsPyZHMZax9c093xvn8G8G3qO/wIfzU18nz
bfwsYD/Pypqd6yi4f+r30JusS6FPJ/6s5W0cA6W+cl/Y2jbO73NRZ5+4RPzu
HEfWgJkbokdkfZt1HOPxmu5g/YG5h7EBt05tC+3B12JNyHkwDIw0h3W9trnj
Ws7VsZ1r8A9qasjmP4+GWUvK5ztwHMdn/M8+xJ7WNj0vJNegfpnnGjF353NI
WDfreTRz0xlzJ69N3GOfXHtzh45JrAF/cCyPDmyOYu7heIRn93stsHUbj7fb
4hXcMefxbyDRNtaaEtP8/Cafn2fW8Vt519Z8hi9xkudC2ovn6Pl39NaeEWqs
vCHecw3MJ/jLWi1bauCe48EezyU5N6XeYj2yDSyx/zxUk2swh7sm03gEbp2q
w2N9n77pnAI5m/xNBq9D9zO9/Ds/jCnXfBhbHU84T7vmO3Avjz1fz+11GEPv
1nmt/ROnOad2UIdz55l7yxr+x+JYWZvvY2XuaC0/4vjrjmhjngufz2dZ403m
MM7xOqZgjjd2OZ5xHOR4yJyHceQ442TN3yHys//BUz/38uZa9qV/x8W447XG
5krmGTfG6w06jzWmvNc0NGye9dI4ckXN3yxnuzVz2vgWfefams+msibl55rD
jXbad1eTKzlWdL1smmMLz+VZg7Nv7bd5iXUadB9rsMRTzEXOI1vbyJo6fMDx
OrY2lq3XM2/4+a1gOM8M5Jnt/s0wY/nJmhjoedd6Us5PudaJa/G5Pd9l/Z01
k8zpZp16rj90DOia6X1zj4/lNrc2mfGltbm1HJefXct9Wdc0jwFfaCP3Z+aJ
sq1Tm7A/ps5inMf8DN3EHmOQOQ5+7OfZ+tn++RyUNb6dvNtjwZzKGpmfg7em
MXl9C79LcFWdwZ/dOL73BZv7mP7NFH6z0vGg9SnjVO9/ec3fzYRrmYuhBRFH
pJ6aOGI+St+7Ldaeu3FXbLM26PwpseYttcwd9ZhHu8j4gRyctZ6sMfG1u298
jZzXzyj070rQ/jwflb4AK1L3p689ljyG/Ns8/j0O+Op1Ou+n9D3nGZxDMTd1
vbVrgYinzSNdc7YPd8xrHPtRS/VYHMe5RWMQ45nf8HD+JTVL2tJz8K21nOeM
3dZhHM/AdV0TQPztcWsuz3jlNwHsZ+BO9/81dZgX49/+vRT/ToB5UOrA6cuO
vezvid3mTm4Hxzm0P9qUuYx/i4X2c7zF72peU4fnRj/bjpju4tP2sTrz++EX
nLaPjm1XjXPyTE9qKtA40e+cB7eGw1yU83nyxLVYhTa/vfbHR/Zb56HIp6Jv
eJ1K5hQz1vEcag6W5zLe+1mlHkvEYtfW4d8hvF7H83PmPX/5d3ES33bqW7ab
x3p855zveB19i3lkbS2Pc5jmk2vrbMyrHoj3ru9z/QB+njlF/Cz5pzVnPsMX
+G7mWO6odZyHA6zVM5vvnaplTi1z+mg45jqM7V0t53PmIvzZv0nifv9UTdzA
v4hH7ceMDft6jpHEINcueHy7Lol5FvzhHk7Ucj64peZY73u7qqZG5PnZ3LGv
qX3h0jqDPefVGey56LR95LRdqPO5NvFe9ZHX9Th37ro/OHLitn8Da1cTq+1z
ftae41bzYPMFawJ9XmviXk/l2gnHhifjs8y9gFPuH9dvOm5nPPj3bK6t+bvM
tKvjKMdSnj8dZ/n58I6Vbwgzf8/cnWPe1Ie6L6nVoQYva+sTh6zxux4g6/mz
rtafu44O7cHP3L8tPgdz1/K5d9byN5LyNwQyhmJMG2+4v9QW7q3DOsND6m/3
Af1EH8GHed721bX8TVxj0vV6PaH+Iv5P3uPxcH2ckxjI2tnJWnIg83HPUbT1
riaPty7jvBj3wz75+3Dmmf1Zx1oXDPtQneE9Hz5t54/Xy2uZV6B20utbzdOz
D4mRzFWsk/G7N3A2/JU2NG5nbu5EfOacE+exvgyfpF7qfl2X69/hPcadrGlL
3dK5iNQKk5d+Uv/vava546nkhsYTY9GulmOaMch4uCHuy3pbxn/mjn42w2Px
6lqAtfUzrk0yb3VdjP3XtTiOa83prJnQroyV/I0OYjWwBv+0ToL/uXaMuck1
5OCra2Zpx6zZzv76ZE0eCq60b1417HLZlTKwyPPzTbX0I4x5zudbm58YG4wj
5yk81u/We3yHWBYOlNcGxpvrX1frv+dpDb+/0zpPY01zn+Y74M8HT9u54/31
NePdvp4eb51n+mzNfNPas9Tg19ZamNdurckLPD+s5eEcB+ec4mOkxpVzouNU
dALnVq3tmNNYK/Rckdql+fzN8f3k1Du90u/EFI69fP+eB6wZMJeiL/D/rg77
ZsYhjkcc/3tNj/Vmx1eOubOmay1uvaOW3NR1S/YBdGDPUe5bxj4+5d+PpY08
b4A9HhPGHzhYruu1/k7dBlyZnEfmJk+E0Z/JdzqP1HFH+59x6Kqav0PCmEdb
ok2dO8Wvd+pzn9f+caO231xL7ZN7Sh3fn3Eux4nWx9nOXGG+ARaZv9422oGY
65LxemHNGOwjoz3uqKkBU9vXda4HdfhZrl7n47qfu2s59uF0u5pjx/eVHABe
ZA3litFvV9TUqnZqc+OUddobaqkjOr6ELzjv4XoFY1DqWpkTB/+sE3PP+BGa
Pj5oPcg6Jv1nrGTe8/x6rdqDe71R/5sLZB6YWM2cgPnf+p7rtnJ+yXbJvHbW
ajp34utJLeW6OswhGUNuJ9fM4BfGhFtrzu2Zi0P/cv2m9XnnQByTMS873iMG
hIcwZuE5V9WS91xZM7/NPd0c53TtHLwy8xTmeMZv7t1Y4DiLOfm+WtbKYR57
5vk3aZv1NPydOcf6BWO977Ox5uM1/bhxubGo9ecLRzvdqX44qPlsVz/rzLUg
OW8+UMtaUHIJjjWc/2Tsee7b1RJz+jrRyxsnPzau99LRl3DPvn7HKNer3XLN
W+oD+Gly+Ntq1l0Zf1KLdo7RMbnxkTmOOQeOZn2RvuY6mYc4FuOb/OhVYWjf
4BP4yzmss7huD/76leoj0fmS79we/ztXhdZj7djxFj77Sdk1NX2Uecbcx1oa
58T/HcfjS9a8wFf0zOR7XgvldWqu2Xqwpq6K/7u2kDzotbXEIDgr94Y2yHyR
603pD2v0azl2j9vkfp4nTo5jPlFLjY5cTdYAm/s7ZrO+6Brqu2sZazsu7/bq
Mdk+C/7QLvj61eN88JvGnZ87bT9fc41hPh/G+g+4Definu/U/2hhHoc539E/
jYuNmY09HTe+/7S977Sdc9qOn7YP1Bk8vayWYxjsgRuCHVyL6+WN7VmPwffv
rTnGjTPJWVKP3tWMjYgbmY8YVz5nxtFea2Buwxhm/mAOuXj8f+mwi0c7WnND
u3f/kKN3/sC6wNpzIMyBzHOyZsFtbP0CX/Q8c1nNWIVtxCrX1tRnT9RyriUH
5hiUORhfcI4u83S8Z+xmjViu06FvzOEYA+a98Hfu03HZVTV9kLnCNatoZ163
Y+5urpljxTpl1plzXJ7T7OdKGDvQc8HhU7VcI+BnmvjZG7T1w7WM29HNaBNq
pJmrrx7ve7+DOoM3nzttnx/W/zcO/dz4jN/ZQL90jQ3cIDUc1+tZ96f96Zfu
kx6D7T+NL+hU7zltbxn2s6ftTaftbXVGvyIPaD2e9oef41PwS+MOvmEdEL7i
mrXMv7vWzBpS6snGN+IC5/WdU75V53POvdsKP6VtWrf7SFhj9fk1c5ufqKl3
3lhLHpi1Lbk2xT4M9rhuIXOGmau1fzDewE/mQeaZi2riKPh5ybhf/NR5ouRa
5o5e6+W1r7x6jR1rRFybbd7GPTr/Ya7OPMTYoQYI7rarZVzGGE8e4Pq3fFaA
6yyZSz1XOK/i/Lr7yxywY5f2Y+IZ1/h5vT+vaPSu3/CzcawXUntB3px272sw
RoM9cIf7xncaZ74g+6Vhv3DafvG0fXHs03yIZ1e6FhUubP0GPkrNQBqcx/Mg
Onnjy3vrDOa8+bS98bS9+rS96rS9Zmw/vyaXJ9ZxrRr4gJ84BmTuOhHv9+W4
9uWtbtBxfCzXx3lNkXV7+3uuRXD+C7wGl+GFbfDC9+r/94994U67Ws6Vjvcz
V59rZODTxh3MtQz4ruslwJ/rapkTaoz5SE28/PDob/4n1u5X9EtwCHNc5rjf
c0XqXX5uCZjkddOubXMMhG+7ntm1F9bM+R9c6v5D9wBvG1/B1k/VjGm8pgn+
YQzyWghze/DY+su9+o7ja9aZo6MYf+jzh7SfY1Tjj3PiD9ayhpXtYJprHcFL
sLGxpDGx+U5jTeNM4w3488vDfmns85maaxzu1rHxGWN+v+5q4hK8m7ntspqx
BNp4j7cel+1LzXUaZ15/2l5x2l4+rP9/7Wl7R03/3NXMR3suQDdgLsuYyTyF
/7MeOTXSXS01ZuMSx2bMmAd3PxPPMgf5WRpgEnM8cwZ1XM1pGps/NNrnnXWG
C771tL2rzmDPOePzy2vOBdaqkz/gX319a+skqH/xcxcyn+/cGH4K9uxq6ufd
95eM+/jIuNb3DnvfsP6/Y+xzx/20nTfuGx9GQ8naWXJFmbf3mCCWyPU5+ClY
wNwKFluLYaw7h5c1yf2eeZe+6znhwvF6cc3cPOPW8R5YA5aDsZ4XHbvDPfFx
rt9r5bhHc0P4rfUbrxmkPVKfd22Xv2NM4vhgG+MGjGM+IN/ecVZzn8afv19n
8Kjtl8f2x2sZM/q4qYMlx9jVrM+7ouZYZE7oPkFr7rir/anx5w2n7adP20+e
tmOn7cdP20vrDA6dPb7bxyIvfWMt4+CszXedSNa4myPAGZlnE1fhd1l74ZrJ
1Hu7rXjmFzhEPhFOydwHdqKd9Pkar4lL20fPqenD7xn2vtGG3ZYfq4mX9lXX
1XvMgynO0bJeweu/XUflNeKOwcx9rMsSR/Ycc3xc8ztHf7+7zsw3jalvrzMx
9xvHPsfHfff9ty/DIy6vGX/TVslB6OOsv6dviGPor5Ox3TnoT8k8dzkHyri5
puYY7/5oHD13GDV4Hx3tcV0t81qMU9e7+5683fXjd+qVWN81Yq71BW+Mu84Z
PlzLmPp27et11eBXPusra8hZF4mG5OfgNq9pf4DrNAa1/vPZ8flaLbT7iHuE
W1lfID4jRmYcMhbRm6nTbp9q3Om463V1Bmsaf370tP3AeH3p2NZj8sJxrKtq
cnLHXVn375yWtWXrys7TdT+DOZfXxB7iSGozdjW5f9b1oqmg8VsL9BpOr7ul
9hQOwzqaHrfkBK0FnT/ef7zmXAvP5zozXmFcwv89zzkPzxhzXbnHgLEdXYT+
Bj+JwS4a/dxY2bjTWNMY1DzuTbLu+1fWGQx6+7B3jz4HY9GtXfcH16ZfzFn5
HwxxjbXnz5triTNZ8+x1YBmjX18Tby+uyVmZI44P6/v/wOi37q9L1U+uewPD
uX7GJHlOx2JZ2+ax7bw8mvb96j/4iXOgjMNb47g367zmkrnWD59zzhXuxFpB
nnXXeNPxV8dZrfU8Wev1hjkXuh6E2lFiRefjmEPwXXQfOBBze8/njT89F7bW
05rPz9TEnx8b1lyoYzPy8uR9yPe7Hi55qGsJ4dOuB0ydHu2QPBNxI7kb6/uM
Sc6B9kx91UHNZ+b4ebY8Xxe+BodAu4XDt+8xb16ga/lEzdjW+ho1b1xPzo3M
Ua6DcS7e+S/nhV0Tldoz8YfXPoPf8IHmAe2PbxvW8XRjUM87cF/6/+yx/c2x
L3j0oXFcxoHz3XDW1H/BRPNZ/N/X7TrajL+TX+1qxr1X1BJr3zHsnTXx9h3j
Hlqzayz6cE0sco73ahl8clczbwIPYH51/tRaFTl69mEsZCxHPzvfay3DvAPc
cl7VMbzrX+BdGbs1BvW83HyH9Rc8865feWauNXo/X4ExSi7OGMf/1AGjy3Uf
oUd2P/V83mOy58QeZz3fNb70OGy9p3WfxpyX1ZlY7OXjc/qLMbWrqT06rs9a
XOfCnZ8zf86aADQqeAbYd0nN2hXX7no9APyCtj2oZU058Rex0A21zOVaR3BN
qTHnmpqxIvlr4gTmvLUaD+e3nGNxW2Xdidf/5DoVtG8/I2Cna+77aMx4/+hv
rP2RfMObavZ/vzYWva7m3NQ41H78lvGK/1JvAsf+RC1rFcivXV7rNQxwaeoA
MPAK/79uxcAsxnafGy3r3eNa+/7A2bfoFX53Ts0YDX2B63X9DNjo3Kl52K6W
+hu4yPoJ8ob02RqX2MmIC3s/NDPHEuY65Cxsxiy4E/WQrEc8qCUn8lpmP2fH
MYOfBebndlLjhNaFtkmMu6s5J7Z9fLT522riD3Nej7fGoOZBrx7/nz327T6G
u9K+1jacF7C+Qe27Oa5jqe5z9MI24sNzx2u/p94GY4ySr8H3qTFp/KG+/DO1
/E2tR2viO/jj+I95237Ds1Ssw2cNMRjruc24TI4IvM66cLAmayx5tf7FeW6t
ZWzrNTToItbSm/MeH6/MP40z4BB5iO7zxqFXjtf+7O3jO++ppX7dx79AdqHa
7cKVz5hf+J+agMtkWZNPX7vfPV9cMK6nr6ux1XUk4A742vcKp3vnuB/GGesW
wE5zM/qq+8NY6JjUNYBeB+JaODDJsYJzO8w3aPqubYcHgT3Eb9aAvAZgTW9j
/UmuAYLroBmBP41Rn62pEeE//T10VmK222tZY8k9U9+CT/WYaa769tFfb6o5
N7x12FvG9u6jHr8fH/0CV6BPwFraCdwmpqCuDD5Gv11Tc94Ef9DF3z/Oybq6
88d+aKEeh+SdiLvhP/DMp2vWe/YrmP1gTW6G/+O7fTz0s8tr4u1O1w734dVr
f12T5PUj5Agcd8JbwDjzVfMG5mTOSVvC9bN++uax74VqUzT1NnSh9kd8Ey7U
886rxivzEByJOYu4Bq3lA6OvmDs+qPO09Zgj159amuuTLgoD/6l3hp8wp15Y
M8/39nEPb9Qr98c2MKmvnxjz+LheuDZj0nl811dj5HlSM/h4zfma2jDHX4wJ
YjFwDtvVnHPIyzlnx3vriqnBum7+9lrGZtRr28j587zNxpb2n86JfbFmbeJB
LZ/hQJ0iujeGZnlTzXX9jOseA++rJbfm/x5P1LyQ6zm/DvMN5tyc78F0OBB5
u11NH6Zeg/mZ+bF5fY/ZD41XuFlfW89t59VSQ8RfiX/QxU6NtvpczVrPL9bk
Qo/VfN4M/ms+0tfoGv/Lda5rtY05jlfwC13KtSu7Wmqyu5qaF/oc8/+Foy2o
y/lYzXjQtcxwhetqmSOCg9+o45F7OL9mTNYcwFoQfKgxpznwq2TNg15bE4sw
asfAIzQj4hxzpuM1eRN1SB+p6a+sBbqgllhgnsQ86rVD543jk8t7XU3eA6ae
XXNupZ6C6+7vfnAcB2wEK+FqngvoF2MOMTvzKBpTXyvrz4mPnOPvceLaSWMc
tUvwXfg0sTvHML6srX3CR10XQsziegB+A4HYwWs0+vVzYxuxRH/Pmuq9uk/z
sL5++xN6Hbrcu2rWiLSdW8v6Cbiv1196vaWxd23dkte/mvskP2dO7LHwnnF9
PVZ6DPU4ed/Yj3EAB9+Nc2T8Be78wvi/2/Gpmr93gj7ovgGvra3CqXnPNtcQ
k3tHF+hrsW7q9ebUaJnPgCXWn8i9fbhmzeC5en9BLXUXuKBr1Zlb4VjE340D
x9W+1L+3/xJ7wX3Qp6lNJVfxqtjn7JpxHBhEH1I71X3Y+Hee7oN7oR7y4poc
5BO1xCC0JWpo4cw9XhpP4G9nj3shDiOGxMCid9Qc/3A4eNlH9T+YSA0LfI79
GLvnjfsDzz5Wc26CozM3g0es87kkDI3M85trsft/10ehEzp/Zj91jRZaLXEK
z2uC0xzUGQwCf4gfPldz3Txr5qlVxP/RQPm/r8t6BTUuaALn1OQd5Dk+UnNM
w58Y19ZZibVcf2n9FK3O9T3mPh57H6+Zx2gu1mPnDbXUQvvzS2Xg44ma8Wdb
c53GnK5xaPz5Qs31vt1uaPXW7JgraC/HreAMOAT+XFSTC3kdNvWVrtViLgM3
4difrP+7vTtt1uYqqzjefiVLURzjACoqMokMigcISZjDKCQk9WBIQAMlIsio
dQCpglIRp5IChGipoFKI+oWsLvpX93X+OZ3WV77pF6ue03fPe+9r7XUNu59L
Tknuit7BLdqKNuTnrP00bXTGHmac4nq5fKdT/Snd8M6tbVd7XTnl3uXCM68P
Jhe9brmpi2bc+i3LTdt/y3Lxd+ihR5dLDJjvNjmnf9uez497jJc3LBe9Jt4z
uWfmxh5cbvKPXP1jy4UjPZ9aIvpIjfxjAd9zvaYY9/rMvpU3+YevMms59Ln6
q6mLzXNrX67jCJeoo1vH7fzuyKwPpO9nffesk+Q3qMlWsyiPs2K1qZWHcJA6
yK9s57mHeik5EvMg7f+J7V3ft1ziAerOpi5ej5Fbnt90Mq/PvOCsYVDXMb+d
MmO8bJdNTR29jgHr0cQc1jH0xu23O1tfqXn1fJ9ZLrGntS3UeKqz+ubWfmL+
s/5mb13SXCfGVyrP4CZxiRkPoqvL2XNciBP5brh88qzjZXePL5cxL5fMhucc
rT7nenlyvPRjy8Weze98sZUfVl65Wr5X+3X38j0uwi3T7xLjnTGW+7fjXjvO
eeP2Ox+PJlFXzi/zHrSf2k7awt9qs9Zj371c9Dsdt973VdtzqydY74djZ6wB
HhrPMefi9w48On4zBzy6Hf/Icqk3Mp+L8eOgDy2XuI5aETGc99+C6YPqf/Eo
Otd6qFnjMtdczu3bdNBcvzbXpnUNiHUgtNHUPyv3zLVDcoS0mXeeeSLzujjD
jEm+d7lo4Lk+kW6ZOVc+qnWLc03F9XJzPdHMeX18ufjMbOHx5ZLDWPln1cY0
tDlsHUsPbn2jVvDjy6UmkT+7tsnKNWt9+VrrOflnru2d+Sg+9MwZzBoe/pm5
ZtaMyLvyp+b3NdVrz7qoGSeb9//sdr2ZP/fvOhbxhXkfB3X++PBy8QdpublO
kA8+fTvxvpVHVt9qrb9Qh7HyCW1D18hpi6+8brnpn009xK+bUPv4huXi/608
YAzyg6Y2wr3vWS41TXIlYlfrc6zcs9aRvHq5+O7vGMeJ+9BEOOjh5WaNu29C
+D6EWPvDy4X3Zk3DA2P74eVSby7+rnZs+uqfX27y2aPjnenbGSOVp5MXWftT
jHrWELFF9UizTs54nmtf5noLNWrNk1lDwIYc0xpomh8PzhjWXMPqWxN41vxq
LRDtZ86vXcy/Z12g9+ZviRVf5774HA+aT+4sl7zczKG+detXuuwPlsv6t/W+
tO3aTqtGXPln1pmvvP2N5eKzaj8+2KzHmeslaFZzxYx1dR3trNOZtZnyctbT
yJWKA5ovpp8qRjZzQ/ppHZu4Z22vR5ab9Sy4f+b4+YDi/2Lbrvfo1u7yXqsN
Xy3fs+fJFThotfeZq79nA//s7uXCQbByjxiNPNtrtt/EZGgIeVBxAeNj5Qvc
R4PRVq/fnuXeDeoH3r5cYlHGEi1kLQoNhIumJqKxcJWa8hlLmjWeDyyXmoV3
be+y9o2YnTV2n1pu+oIPjOv5nQajjT6wQQziesPndyAvYlu+hR/2V8GXgslH
fzOOm7k28c5ZA9K6LfzoOHPizM037ysONoGLmzN1n/kNhRXi1/KLfJdez1gz
9+g7sdE7G2a89RPjfvTkvywXP/VbY1sdA/9WnbrzykHaedagTt1qf/vRcbbd
p/08/fAvjfvQkN6PTqxGpw/EJBov0B9zrersd9d1HWvd+Fgv3/DGwH6cdN+G
lwd3b7gvePVykyNsv3YDO3xouegH62bV7b9p3L+YMfL7xvPih7cul3jiBHuf
61CmLiq/2H5bYLziEdfzHjSnuM+Mrc14Gq3oPp6jfISHZryDzz9rJWGPf/DL
nBu/OH437tlHazA/GUzNveKzgfNmDdVtmHkzun0FrVS+mvmyWaPVb9eVf9jB
ewLtz87cp7zKzr+5XPytCbVA4vxqPfG7dp85vD9bnswTtGrng73fO6+0ZtV+
/e3++mnW831wtNOs65s6CbRz11Xph/an9mZf7OH+oPbCzl+54Tc3WMODj64C
x9NN+Mp1ywO27cdXM/79hvE7HsJveGHqavUdk1fwU3ll1ulOaJc3BeVpfKSd
9eMrNmi3l23Az66Dj7TH9NdW6PfrYH6/ZH7LoOOxvFM7aG6Jnc91UnPdFOAf
fFX+EV82Xl0X/8j5GOd4QDtoz7neVb3GR8Z1yz8zt/P+cV066JHlUou0YuZ4
PjbeR7t8eQOd8w87+MYGfIU3yhcFXlE/XR3kOns84/i5Lmdirs9YYf7SP9rL
/Kc/tHvHg+3pI1qj/OlbrkvXG9fsvXqDvdNDtvHHr29gR+zqakP5yXnsDX+w
d8+BP+zHe3imfOR3/OZ5yz/gd+/r+NvyfDMeb39zhn73Xn6ns+ihF2/4teBF
G/C093UdfMn+6AF2wu7rFxlXs156xiNh5vCnjnJd8xe77TxoP/0xc7HX47ls
s+v6W3jE+HQ/vKAdysOzbmPOx7PObsX8XsKMN9p2X3zo/bUPfv77Df+4XNa+
f31sAz0kts8f2+MZvEYv2aaj8Jjz/jqo/sEzva7z8VF1rn6s/w/1b/H9nwb0
t36fNX0fuaVf7mwwf8+c1+Ql9lG+gZduwDuOww/OxyPug3fYO16o31ZdVH7q
9WdM6s3Lk/mkfqLnLM9Vb5Wfe7zr4z188/wNv7rhhRteskH74aPqKv4pPqKP
9W/X1DWuYHzgG+Op+sT8RjfwI+kG43OPd2ad9wo81PkTf1X344c7y81xiY88
F/6Z+TI5tI+O+2gvfnF5x3N4vvI4nsA/TyyX/ODcxjv0EX8MT9225s7a1a89
xfX8jof+dgf4Br98PXBfx+Ev/OP99Yd+15768Y+D6ujGCz8e6K/6Z3SROARd
wo7YKT3Dr+B/2WZPdJLfZ/x66pk9viteG+APz/OqYI9H7L8nYPc9v/ymHer/
Vd/hoRdseE7wvA3lJbpIu7oOf5Bfwh4bb+p81fgQ3qi9smd2aRziOfc1Xvbi
PnP90uRDv3f8eX48wS9yP/MTPxoPet/Ghz4WzJr7WYtfP+J6ufl/crEr+oFf
hQ/Y9RMbqn/KQ853fI+rjnKe7a8G+OSJYNZzTZQH8U/j0vqp/q32ad6jeQq6
kR+v/7Vz+ajxb/MD3Yt/6Af2tme//DLzO7vye+2ffdET+OZ/Gxcvv8G9AV6w
33OURxu3cn7jX1fL7bqvfie+efaGX9rwyxt+ZYP92otu8pzaiR+pf/BQ/Qp2
iV+a78Azjc8C/mHv7seOr5dLbczMf+zFhcG4nutZ5GhX8FvdrzoWL/V9vYfr
N65UOxKnaHyMPeGdxnfqh+3xzb8ul+8wrWie7N+WSx2jOupvL0+Ob7svnYTH
/C4P577fCso/zc/xy+o3mScaF2ve6wuB3/FU+afzQ8eDcVAdpP/ZAbtgt3QP
e/uFDeyMXbFfdu86cy3a9LPwT/WR412nOshzlYear2vezvlXy814Fp6hT+ia
527AH9U39uOdXwyeHbiu9qIjGyfSTvQBu+Sn0bPvC/DVrPtewe4dh59m7fcK
uoH9fi4wzuoXsf9ZDz7jSe7XPEnjkHSQ96SXZo395BvX97x4RtxEvITfQh9U
3xTsmp3jDbyDX/a28c1/LJf/J+Db47jyFb7z+79v+K8NvY77lH+al+O/NR6k
/fQ/fVK/u/Fn6HxUNO9ZP1x9RPPaxj27F181j7OrZ274uQ3s0vH4oXHkxmfK
Q42T452rwPWru8pPrwjYO/2BV+k5vOI9n7HB++LdZ23QLvjn54PqINvug4/c
v36i9tBP5SHb+rN1R+zddvUI4JNPB/W/jM/yC32CF41n+/GS/Z5Xv5v/zIez
FlTt6Ar20jiGcc/+nlgu30eacWL8I05if+PN7Lo6p3xTnVO9YxufOL86BlwP
7/znBvzznQ2ep+/ZvNxfBviDH6b/zQ/mn+sNjsdDdE/nJ8fNNTszT+/6+Me8
ol/Ns+yeLhC/qF2xQ3Zau8IL+AP/NA9lm/7hf7Q+AJ80/t26pfIM4Bn8SH88
N8CjePWng/LRswLt4ny/VweBdtPOntP7aDd8PWtIVzTP13qExrV/d3ny2uEV
7LfjzXiaa4Cm3+M69Al+8btx1zoRcWfjoHGg8imevbOh9XP4kf3N9bhPBcfN
bwdM/wqPlB/wwHc34In/Dux3vX/eAT6xjW+cX97Bk3ONzYq9/D4/TNwLf5h3
Go++3tD4Mz9u1uR/YfzeuNBccz7zYsaBfjX/NA/GLtnTz2xgf/gIDzke/9R/
aty5eTL21Thv62xaB9B6AfaLf/AOncHeq1+qe/CO9/7Z4JmBdmr74KXqoOoj
/Oc5PXfrsfBR83Wtz6zdmnfwRPP9rbNm1/Xrjdfb1tmsmGtOZt7d/et/iUM+
EOBPOoh/aRx7fs9ZP+sbwV58p7xDt1TffPcA3w6qn/biSuUf2/X/PGfzZ/in
9dLN54uHVae0HsjvzbM2jobnWvfRvGj9r44D8V9xFPEQdsEOf2rDng6if66W
yzeAZzyavbgfvqG7bTevhRddlx02PoyHbFf3sOvGdfBNecX7VgfdtcHxPc71
tJPj2m74x3PsxaubP2scvXVN9KR2Zcd3NrDf1l//eVC9Xn8L6J3HA7+3LpCu
af7B73jG89qujjO/Gu/mef7UPwXsFg/U3vEFf+k7QfmlvEJHdX0GXvT7XIs3
823lSdv1H8s7UL3TuiDP0/qt1j/TL47DP66ztx6k+Tb8Y75qnLI6mM4QH2m8
ec+OCna+ly8v/5ivbXuexqvZHT3Vbc/ffF3rBBvvwR8/suHpG350w13BT2xw
nm37tVP1U3mKXqof2+3GvfEqvad9tBv+qa7AQ+xXPIdubr6IvsZP7L1xndYJ
NN5Mb1V3ty6tvIM/beNN9+MvNN9Vv6r6Yk9/lF/wEB3ieLzQeBKd0XZr3ehe
fVD9QtflV+2tG3NdPEGP4Jvy4fVys37LOKB/zDd0JT5pvVnRvJjrNe64tx6L
rjDPmofxjXhG/RXb9TPYvzh08+5db8V/2FuH0XpCvzfP3ngRe917rx/bgG+e
tuEHN+CXH97guJ5XfrlrAz2Fh/b8ur04W/02+g2vXi039Wb9MTzEvukW46x1
Ma03Yz+tY9xbB4Fn6B75N797jtYB8bO6Ts94rX9nfsWf7J69su/mr23jHf6V
uIt4TuO8dIjr4onqDfrR87TuseeXj9zHe+CX9k+vb7v+Up+r8Rs82XV/rb+/
Xm7WUWl3245zHePEfEH/6s+uCzN+8Qbd33hp89Gdp22z+9a5NN9hnPkdHzZv
Bvbjn+bDqneaZ/J87PsnN/z4BjxDB9FFP7DB/vJPech+57t+9ZLzPEfj1/jJ
Nh3E/9yrR28enw5pHWPjzsZp12/gK7rjqM4H39h+NDAO8STeKQ/dWW7Gnd23
/Ok9anf0SuMoe/kr/pbjyg/1d5pnoj/KE56PfqFLGj92Pp5oful6ufl9sNbf
2I+v3K/+NX8JzzTf0PpS46V8Vf20ty6s3yXQ7+zYOMYb+Md434ubgrju84Kr
DXhufstn6u/GA/bqoptvr78l7oxvuk4CT9If9bPwBr4oj+AX5z8tcD089f0B
XfVDG1y/OrPxbO3pveg77Vt9qL1b32yc1j9o3Zlxb15zPP5pfLl5faBb6CHH
4yXPVz8RHgvkdY3/2imwY3b+xHJ7PXHjOECHNM7ieq7Pntm77cZrPef1cvkW
5gr2z769F16p/X8q6Pou7dO43t7zVr90vtl7rq7Ha51z9a/4nn41PlvvY3xX
9/O32Ift5m9a53u1wbx8f4AH+YO2u75LnIfeuToA+6QTPFfrde4K8IHt+kf2
Pz1o/Ah/9bjqJ8fRP/Vzqy/pz731ZXiodcX8Fn5U8+7sg67GR7XrxhVb79j4
tHGJh/DSwwG/zPis/mneiz14rr11cXSKeMoer3SdaI/DO43n7umVPdRvaT1f
7V1/dd0E3uHn4HXHuW79svZr67wan27de9cJN//ZeN8jgX5tfY1x/MJgr86u
8YjyD7ju1XIzTgGeQ7yn/NS6xcaby0d+r47zHq0nbN3OM4LGb+ifuwI8goca
B2oezXV6P+2MZ7Rv41jldzoRj5tvjIPWD3d9VOs59uZxxxt/zX913VbXgTje
OK2/tqeHXL/6hz3xM/pdMO/T71d0naf4sf39Ho/rNt5bHfGZoPGSPTvveuHy
i/7rOpSug9MujRtrn+pbx+FP2/TTXl0zvqmfbR4p7/B3jE/zJb+rfgt/pesM
yj9gf+v82Av/6Gq5mUdvPqvxZ/P53nqKuwP3wXt9j9YNtn6p74O36g85Dm+0
brF1QUf59vKN566/Vb1Dx8ofdl1950XjuvqaHZvPa4/s0HFd30P/u37XxdNB
jRvR6Xc2iBPgH7rHeXjPfdgRO2teqOsy6Bg6p/mh5nVcF/+W14Bdf24H2m3P
r7pebn5nYC/epj21A/7Zaxfvr1+br2r8z/7Gh/oc+Ea/2cZLzS+IuxivrdMz
n1bPiN8271W7EZ/AN7b7XRz89JLgarnpp3lO/INf7Gd/7LLfL2r8qutIbHvf
rovwvtoBH+AR1+869/Jd13tcLbf7ieVN7WW7eq91PneW2+sM2X31TuOM7GTP
XvGQcco+Wl/m945b8yY7adzAeP3twP4PBOIPzf+UP6F6p9/xqi7y/rXb8lB5
il03H6Rd6IrmmRrX1V/0ZP0b/I1/tLP+9Dzev3Gfo3pmv3ceqe7xPOYJ+sf8
8VtB64qN79odv+Q5QXVB4xPscK/u5oiPrpabPHTvDjy/eGv9k64fKU+WL+t3
lpea9/uNoHza/fcE9wWtT2j8/c1B64WbX2pd2SeD6+Avgi8HzfP0ezEfDHr9
7i+fNI7Qesa972ZB8zvlm8Z5vhb0fffqW/biPH8S7MWJqz/39vd9G1drfzaP
0P5q+3wh6Plt3/bH7wTtv+YRmsd+aVC7bD1K9zf/VfutPfY7gc8PXhS8LOjz
Ns7U65c36y92nVjv94Kg79/n6fXKP+XPfg+2fPK2oPNIUX/794Ouo2jc8YvB
3wXVE41z/GFQe/xo8HvBh4LaX78v0/Wy5YfyT/nm60H3l4/rb+35X9WH9aOg
7VV7vw76vr1f/c32V+u62v9tv7Z3+6vzR/mo+YU3BbW32n/ttftfHJRvul6r
55d/er3ac/eXf8oPRfmk/PCKoHxaPrs6QPVO9U355t1B+6/HvyPo+R0vtYfO
3x2v9Uu6v/rgj4LaR/292mPn/yOU/xpv6TqB8mn1zleD2nOvX3utfqj9lv/7
/tUzfb/e72i+KP+2Pdp/7a+2d/Vr54uubz7SP1fL7XEIOOKD1hv3ekX1yRGf
VV/0/PJD+ajr28uPzcP1ffo85ctXHqD80/W31St7dTP1t+FO0PPrfx3Zb+2t
47fju/ZW1D463nv/6+Wp5/vyV8/v/VuXXL6p3vlKsPf9iubRoc/f9j7yf8vf
1Y9F+aT91ffv/HHER71fn6/8Wf//XUHH/6sPcBVUz9Teas+1vyM+KR/1/kf+
XPXNEd+8Juj1jp6379/26/7WFVS/dL4o31Tftr/LP/W/qn86vsoXR/Ha8lXt
v/GG+jOdz4vyzXVQ/6H8UPuqPZZPu7/8U3+r7Vd+qX9VHL3PXv5sj1+Pnv9I
39Y/6/vVPyy/1h+7E5R/6g8c8VHz3EWPb7zjanlqPqm9l+9q/z2/+qR6qHxw
xGflw+q/1wdtz75//d/6S+WP8kv1bfmpdcLvDzpejubTxmurD2q/e/XHXQ/Z
uj2o/q/9Hflbtc/yRe9/pB+6v893HZQva6/l/z7vUXy7fF++Kb93f/uv1zuK
R5cf+34dn81jvjNo/LL2UXuqXqieKB/VXssnV0HPL1+Un4ojf6v64yg+VT5q
vKzxmbZv9cxDwZG+2asrhfpvPb/xn8YjOr46Hmuv9V86vmvv/1c91fm559ce
6y/U/np++eQoP9Trtb3Kh/UX297ln55f9P5tr6N4VuPrPb/Xr/5pe3V89HnL
Px2fnW9rD+WjtwcPBm8Jmh/u/uZzygfVT41XVW/0fs1Xl896//Jb9WHvX3+2
7VU+Kf9Xn7S/6l+3f7v/w0Hzs9XDHf8db0fjufNn93/5+54aHf9H8Zc+T/VB
+aP2UT7p/iN76/4jPVa+qR6q3jzi/yP7b7z8qD2P/LOj9jzSSx2PnQ+rx8s/
5aujdYBHfFL+qn7q8eWrHl9+qP2Xj1pfU/1ypP+O+OzI3k6cOHHixIkTJ06c
OHHixIkTJ06cOHHixIkTJ06cOHHixIkTJ06cOHHixIkTJ06cOHHixIkTJ06c
OHHixP8P/gcyNfs2
   "], {{0, 0}, {288, 180}}, {0, 440}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"Out[3]=",
 CellID->571720883]
}, Open  ]],

Cell[TextData[{
 "Render as ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 ", specifying a color scheme:"
}], "ExampleText",
 CellID->1913545721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"d", ",", " ", 
   RowBox[{"ColorFunction", " ", "\[Rule]", " ", "\"\<BrightBands\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1919894459],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzsvQdQVdm2/a2YW1tBFMWcQEVMmFqxnbYgaIM5YUARMWDEBIgoBlpaxCwG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   "], {{0, 0}, {288, 180}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 CellLabel->"Out[4]=",
 CellID->210833295]
}, Open  ]],

Cell["Rasterize the color image and export the data to HDF:", "ExampleText",
 CellID->501915740],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<image.hdf\>\"", ",", 
   RowBox[{"Rasterize", "[", 
    RowBox[{"%", ",", "\"\<Data\>\""}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1299615801],

Cell[BoxData["\"\<image.hdf\>\""], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"In[6]:=",
 CellID->826948567],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1222177783],

Cell["Create a random matrix and export it to HDF:", "ExampleText",
 CellID->118932528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", " ", "=", " ", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"255", ",", " ", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1739206386],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"241", ",", "84", ",", "182", ",", "148"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"220", ",", "93", ",", "154", ",", "239"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"143", ",", "151", ",", "91", ",", "252"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"161", ",", "26", ",", "116", ",", "5"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1645798179]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", " ", 
  RowBox[{"\"\<matrix.hdf\>\"", ",", " ", "m"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->298306547],

Cell[BoxData["\<\"matrix.hdf\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1340621093]
}, Open  ]],

Cell["Show the datasets contained in the generated file:", "ExampleText",
 CellID->1734011958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<matrix.hdf\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->818203002],

Cell[BoxData[
 RowBox[{"{", "\<\"Dataset1\"\>", "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->420285727]
}, Open  ]],

Cell["Import the data:", "ExampleText",
 CellID->38404669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<matrix.hdf\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Datasets\>\"", ",", "\"\<Dataset1\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->290293887],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"241", ",", "84", ",", "182", ",", "148"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"220", ",", "93", ",", "154", ",", "239"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"143", ",", "151", ",", "91", ",", "252"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"161", ",", "26", ",", "116", ",", "5"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->351776667]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HDF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 53.2149886}", "context" -> "", 
    "keywords" -> {
     "scientific data", "oceanography", "meteorology", "atmospheric science", 
      "NCSA", "NASA", "remote sensing"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: application/x-hdf HDF data format Version 4. General-purpose \
format for representing multidimensional datasets. Used for storage, \
management, and exchange of scientific data. HDF is an acronym for \
Hierarchical Data Format. Developed by the U.S. National Center for \
Supercomputing Applications (NCSA). Binary file format. Incompatible with \
with HDF Version 5. ", "synonyms" -> {}, "title" -> "HDF", "type" -> "Format",
     "uri" -> "ref/format/HDF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[19105, 658, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 175442, 3354}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2335, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2958, 80, 102, 4, 70, "ObjectNameAlt",
 CellID->29426],
Cell[3063, 86, 474, 9, 70, "FormatUsage",
 CellID->15871],
Cell[3540, 97, 360, 12, 70, "FormatNotes",
 CellID->10697]
}, Open  ]],
Cell[CellGroupData[{
Cell[3937, 114, 64, 1, 70, "ImportExportSection",
 CellID->17612],
Cell[4004, 117, 324, 10, 70, "FormatNotes",
 CellID->18703],
Cell[4331, 129, 384, 13, 70, "FormatNotes",
 CellID->11027],
Cell[4718, 144, 38, 1, 70, "WeakDivider",
 CellID->5545],
Cell[4759, 147, 356, 11, 70, "FormatNotes",
 CellID->9508],
Cell[5118, 160, 909, 31, 70, "FormatNotes",
 CellID->1233989338],
Cell[6030, 193, 39, 1, 70, "WeakDivider",
 CellID->24237],
Cell[6072, 196, 352, 13, 70, "FormatNotes",
 CellID->26443],
Cell[6427, 211, 574, 20, 70, "FormatNotes",
 CellID->21313],
Cell[7004, 233, 582, 21, 70, "FormatNotes",
 CellID->22501],
Cell[7589, 256, 702, 25, 70, "FormatNotes",
 CellID->8850],
Cell[8294, 283, 39, 1, 70, "WeakDivider",
 CellID->25128],
Cell[8336, 286, 529, 20, 70, "FormatNotes",
 CellID->2111],
Cell[8868, 308, 1076, 40, 70, "FormatNotes",
 CellID->23650],
Cell[9947, 350, 662, 22, 70, "FormatNotes",
 CellID->28149],
Cell[10612, 374, 816, 28, 70, "FormatNotes",
 CellID->11192],
Cell[11431, 404, 38, 1, 70, "WeakDivider",
 CellID->1454],
Cell[11472, 407, 361, 14, 70, "FormatNotes",
 CellID->15869],
Cell[11836, 423, 350, 14, 70, "FormatNotes",
 CellID->681]
}, Closed]],
Cell[CellGroupData[{
Cell[12223, 442, 51, 1, 70, "ElementsSection",
 CellID->27465],
Cell[12277, 445, 192, 8, 70, "FormatNotes",
 CellID->20267],
Cell[12472, 455, 668, 13, 70, "2ColumnTableMod",
 CellID->17713],
Cell[13143, 470, 39, 1, 70, "WeakDivider",
 CellID->19793],
Cell[13185, 473, 73, 1, 70, "FormatNotes",
 CellID->2027411603],
Cell[13261, 476, 490, 11, 70, "2ColumnTableMod",
 CellID->629581695],
Cell[13754, 489, 281, 9, 70, "FormatNotes",
 CellID->2128534904],
Cell[14038, 500, 73, 1, 70, "FormatNotes",
 CellID->18634],
Cell[14114, 503, 735, 20, 70, "2ColumnTableMod",
 CellID->517846341],
Cell[14852, 525, 69, 1, 70, "FormatNotes",
 CellID->914246541],
Cell[14924, 528, 502, 11, 70, "2ColumnTableMod",
 CellID->496120302],
Cell[15429, 541, 157, 5, 70, "FormatNotes",
 CellID->727619096],
Cell[15589, 548, 1281, 26, 70, "2ColumnTableMod",
 CellID->19976]
}, Open  ]],
Cell[CellGroupData[{
Cell[16907, 579, 48, 1, 70, "OptionsSection",
 CellID->8823],
Cell[16958, 582, 182, 7, 70, "FormatNotes",
 CellID->1322260454],
Cell[17143, 591, 457, 12, 70, "3ColumnTableMod",
 CellID->1070671222]
}, Closed]],
Cell[CellGroupData[{
Cell[17637, 608, 49, 1, 70, "SeeAlsoSection",
 CellID->2742],
Cell[17689, 611, 161, 4, 70, "SeeAlso",
 CellID->8610]
}, Open  ]],
Cell[CellGroupData[{
Cell[17887, 620, 57, 1, 70, "MoreAboutSection",
 CellID->28923870],
Cell[17947, 623, 151, 2, 70, "MoreAbout"],
Cell[18101, 627, 134, 2, 70, "MoreAbout"],
Cell[18238, 631, 133, 2, 70, "MoreAbout"],
Cell[18374, 635, 143, 2, 70, "MoreAbout"],
Cell[18520, 639, 119, 2, 70, "MoreAbout"],
Cell[18642, 643, 134, 2, 70, "MoreAbout"],
Cell[18779, 647, 130, 2, 70, "MoreAbout"],
Cell[18912, 651, 156, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19105, 658, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[19221, 664, 60, 1, 70, "ExampleSection",
 CellID->607654440],
Cell[19284, 667, 81, 1, 70, "ExampleText",
 CellID->1571502705],
Cell[CellGroupData[{
Cell[19390, 672, 128, 3, 70, "Input",
 CellID->7128],
Cell[19521, 677, 258, 7, 70, "Output",
 CellID->881600594]
}, Open  ]],
Cell[19794, 687, 93, 1, 70, "ExampleText",
 CellID->1593199336],
Cell[19890, 690, 301, 9, 70, "Input",
 CellID->344588482],
Cell[CellGroupData[{
Cell[20216, 703, 105, 3, 70, "Input",
 CellID->493017967],
Cell[20324, 708, 50478, 833, 70, "Output",
 CellID->571720883]
}, Open  ]],
Cell[70817, 1544, 223, 8, 70, "ExampleText",
 CellID->1913545721],
Cell[CellGroupData[{
Cell[71065, 1556, 207, 6, 70, "Input",
 CellID->1919894459],
Cell[71275, 1564, 99925, 1642, 70, "Output",
 CellID->210833295]
}, Open  ]],
Cell[171215, 3209, 96, 1, 70, "ExampleText",
 CellID->501915740],
Cell[171314, 3212, 215, 6, 70, "Input",
 CellID->1299615801],
Cell[171532, 3220, 136, 4, 70, "Input",
 CellID->826948567],
Cell[171671, 3226, 126, 3, 70, "ExampleDelimiter",
 CellID->1222177783],
Cell[171800, 3231, 87, 1, 70, "ExampleText",
 CellID->118932528],
Cell[CellGroupData[{
Cell[171912, 3236, 225, 7, 70, "Input",
 CellID->1739206386],
Cell[172140, 3245, 442, 13, 70, "Output",
 CellID->1645798179]
}, Open  ]],
Cell[CellGroupData[{
Cell[172619, 3263, 152, 4, 70, "Input",
 CellID->298306547],
Cell[172774, 3269, 89, 2, 70, "Output",
 CellID->1340621093]
}, Open  ]],
Cell[172878, 3274, 94, 1, 70, "ExampleText",
 CellID->1734011958],
Cell[CellGroupData[{
Cell[172997, 3279, 119, 3, 70, "Input",
 CellID->818203002],
Cell[173119, 3284, 108, 3, 70, "Output",
 CellID->420285727]
}, Open  ]],
Cell[173242, 3290, 58, 1, 70, "ExampleText",
 CellID->38404669],
Cell[CellGroupData[{
Cell[173325, 3295, 224, 7, 70, "Input",
 CellID->290293887],
Cell[173552, 3304, 441, 13, 70, "Output",
 CellID->351776667]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[174032, 3322, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

