(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     56376,       1828]
NotebookOptionsPosition[     46945,       1529]
NotebookOutlinePosition[     48775,       1574]
CellTagsIndexPosition[     48689,       1569]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Internet Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InternetConnectivity"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathematica Internet Connectivity\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"EPS\"" :> Documentation`HelpLookup["paclet:ref/format/EPS"], 
          "\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"LaTeX\"" :> Documentation`HelpLookup["paclet:ref/format/LaTeX"], 
          "\"MathML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/MathML"], "\"NB\"" :> 
          Documentation`HelpLookup["paclet:ref/format/NB"], "\"PDF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/PDF"], "\"RTF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/RTF"], "\"SVG\"" :> 
          Documentation`HelpLookup["paclet:ref/format/SVG"], "\"SWF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/SWF"], "\"TeX\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TeX"], "\"XHTML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/XHTML"], 
          "\"XHTMLMathML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/XHTMLMathML"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\"EPS\\\"\"\>", 
       2->"\<\"\\\"GIF\\\"\"\>", 3->"\<\"\\\"LaTeX\\\"\"\>", 
       4->"\<\"\\\"MathML\\\"\"\>", 5->"\<\"\\\"NB\\\"\"\>", 
       6->"\<\"\\\"PDF\\\"\"\>", 7->"\<\"\\\"RTF\\\"\"\>", 
       8->"\<\"\\\"SVG\\\"\"\>", 9->"\<\"\\\"SWF\\\"\"\>", 
       10->"\<\"\\\"TeX\\\"\"\>", 11->"\<\"\\\"XHTML\\\"\"\>", 
       12->"\<\"\\\"XHTMLMathML\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Creating Web Pages" :> 
          Documentation`HelpLookup["paclet:guide/CreatingWebPages"], 
          "Document Formats" :> 
          Documentation`HelpLookup["paclet:guide/DocumentFormats"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Importing & Exporting in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/ImportingAndExportingInNotebooks"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"], "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Processing Textual Data" :> 
          Documentation`HelpLookup["paclet:guide/ProcessingTextualData"], 
          "Web Formats" :> 
          Documentation`HelpLookup["paclet:guide/WebFormats"], 
          "Web Operations" :> 
          Documentation`HelpLookup["paclet:guide/WebOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Creating Web Pages\"\>", 
       2->"\<\"Document Formats\"\>", 
       3->"\<\"Graphics Importing & Exporting\"\>", 
       4->"\<\"Importing & Exporting\"\>", 
       5->"\<\"Importing & Exporting in Notebooks\"\>", 
       6->"\<\"Listing of All Formats\"\>", 
       7->"\<\"New in 6.0: Notebooks & Documents\"\>", 
       8->"\<\"Numerical Data\"\>", 9->"\<\"Processing Textual Data\"\>", 
       10->"\<\"Web Formats\"\>", 
       11->"\<\"Web Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "HTML ",
 StyleBox["(.html, .htm)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->19281],

Cell[TextData[{
 "Registered MIME type: ",
 StyleBox["text/html", "InlineCode"],
 "\nHTML markup language and file format.\nPredominant language for the \
creation of web pages.\nHTML is an acronym derived from Hypertext Markup \
Language.\nPlain text format.\nDescribes the structure and aspects of the \
appearance of web pages.\nFirst published in 1993 as an Internet Engineering \
Task Force (IETF) working draft.\nMaintained since 1996 by the World Wide Web \
Consortium (W3C).\nMost recent version is 4.01, published in 1999 as W3C \
recommendation.\nInternational standard ISO/IEC 15445:2000.\nPredecessor of \
XHTML."
}], "FormatUsage",
 CellID->7085],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " fully supports HTML version 4.01."
}], "FormatNotes",
 CellID->9152],

Cell[TextData[{
 "Output from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], ",", 
    ButtonBox["\"\<HTML\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/HTML"]}], "]"}]], "InlineFormula"],
 "conforms to the XHTML 1.1 standard."
}], "FormatNotes",
 CellID->754516599]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).html\>\"", "]"}]], "InlineFormula"],
 " gives a plain text representation of an HTML file."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).html\>\"", ",", "\"\<Data\>\""}], "]"}]], 
  "InlineFormula"],
 " extracts tabular data from HTML."
}], "FormatNotes",
 CellID->269543858],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).html\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " creates an HTML version of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8194],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " translates ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " to HTML, saving the output in the specified directory."
}], "FormatNotes",
 CellID->1111605557],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).html\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a string, representing the textual content of the file as formatted \
plain text."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).html\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "exports a notebook, a cell, a list of cells, or other notebook elements to \
HTML."
}], "FormatNotes",
 CellID->7572],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " always creates a complete HTML document, and not merely a fragment of \
HTML."
}], "FormatNotes",
 CellID->1180609883],

Cell[TextData[{
 "The output consists of one or more HTML files and two directories, ",
 StyleBox["HTMLFiles", "InlineCode"],
 " and ",
 StyleBox["HTMLLinks", "InlineCode"],
 "."
}], "FormatNotes",
 CellID->2050276003],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by default converts typeset expressions to GIF images when exporting to \
HTML. "
}], "FormatNotes",
 CellID->466182659],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can export ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Hyperlink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hyperlink"]], "InlineFormula"],
 " expressions to HTML, creating HTML image maps if necessary."
}], "FormatNotes",
 CellID->1279277825],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).html\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "HTML",
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).html\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).html\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<HTML\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<HTML\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).html\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates an ",
 "HTML",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).html\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).html\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).html\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "HTML",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->1615],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook as a web page."
}], "FormatNotes",
 CellID->11064],

Cell[TextData[{
 StyleBox["Save As", "MenuName"],
 " exports an entire notebook as a web page."
}], "FormatNotes",
 CellID->1262458812]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->9166],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->16893],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->16074],

Cell["", "WeakDivider",
 CellID->13509],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->30300],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell["\<\
textual and numerical content from HTML table and list elements\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hyperlinks\>\"", Cell[
    "list of strings, representing target URLs of hyperlinks", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Plaintext\>\"", Cell[
    "HTML document formatted as text", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Source\>\"", Cell[
    "raw HTML source as a single string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<XMLObject\>\"", Cell[
    "symbolic XML representation of the entire document", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->19695],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<Plaintext\>\""], "InlineFormula"],
 " element."
}], "FormatNotes",
 CellID->9573],

Cell[TextData[{
 "When importing a plain HTML document as ",
 Cell[BoxData["\"\<XMLObject\>\""], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will attempt to convert it to well-formed XHTML and import the resulting \
XML file."
}], "FormatNotes",
 CellID->1070518464],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->435924729],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Notebook\>\"", Cell[TextData[{
     "a ",
     Cell[BoxData[
      ButtonBox["Notebook",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
     " expression"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NotebookObject\>\"", Cell[TextData[{
     "a ",
     Cell[BoxData[
      ButtonBox["NotebookObject",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
     " expression"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Expression\>\"", Cell[TextData[{
     "an arbitrary ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1520200386]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->10422],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->30774],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DefaultEncoding\>\"", "\"\<UTF8\>\"",
     Cell["\<\
encoding to use if no character set is specified in the HTML source \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Numeric\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to import data fields as numbers when possible", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->8779],

Cell[TextData[{
 "If the character encoding of the file is not specified in the HTML file, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the encoding specified by ",
 Cell[BoxData["\"\<DefaultEncoding\>\""], "InlineFormula"],
 ". A complete list of possible encodings is given by ",
 Cell[BoxData[
  ButtonBox["$CharacterEncodings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncodings"]], "InlineFormula"],
 ". "
}], "FormatNotes",
 CellID->191607095],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always uses the UTF-8 encoding when exporting to HTML."
}], "FormatNotes",
 CellID->1329172617],

Cell["", "WeakDivider",
 CellID->15495],

Cell[TextData[{
 " ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula",
  ShowStringCharacters->False],
 " options:"
}], "FormatNotes",
 CellID->5764],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ConvertLinkedNotebooks\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to convert linked notebooks to HTML", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ConversionRules\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "specifies mappings from ",
     StyleBox["Mathematica ",
      FontSlant->"Italic"],
     "cell styles to HTML elements, including both inline and block-level \
versions of the markup"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CSS\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what CSS stylesheet to use or link to", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HeadAttributes\>\"", 
    RowBox[{"{", "}"}], Cell[TextData[{
     "attributes to be inserted in HTML ",
     StyleBox["<head>", "InlineCode"],
     " tag, given as a list of rules"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HeadElements\>\"", 
    RowBox[{"{", "}"}], Cell[TextData[{
     "subelements of HTML ",
     StyleBox["<head>", "InlineCode"],
     " tag"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MathOutput\>\"", "\"\<GIF\>\"", Cell[
    "how to represent typeset expressions", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ConvertClosed\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to export forward-closed cell groups", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ConvertReverseClosed\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to export reverse-closed cell groups", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Semantics\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to export MathML content elements", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->1908888948],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  RowBox[{"\"\<CSS\>\"", " "}]], "InlineFormula"],
 "are:"
}], "FormatNotes",
 CellID->757163963],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "creates a CSS stylesheet from the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " style sheet"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "does not create a stylesheet file or inline CSS style", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).css\>\"", Cell[
    "uses a stylesheet file", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1814117666],

Cell[TextData[{
 "The following settings can be given for ",
 Cell[BoxData["\"\<MathOutput\>\""], "InlineFormula"],
 ":"
}], "FormatNotes",
 CellID->1262887948],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<GIF\>\"", Cell[
    "converts all typeset expressions to GIF", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MathML\>\"", Cell[
    "converts all typeset expressions to MathML", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DisplayForm\>\"", Cell["\<\
converts all typeset expressions to ASCII approximations of their appearance\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InputForm\>\"", Cell[TextData[{
     "converts all typeset expressions to their ",
     Cell[BoxData[
      ButtonBox["InputForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InputForm"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1776858735],

Cell[TextData[{
 "Allowed settings for ",
 Cell[BoxData["\"\<ConvertClosed\>\""], "InlineFormula"],
 "and ",
 Cell[BoxData["\"\<ConvertReverseClosed\>\""], "InlineFormula"],
 " are:"
}], "FormatNotes",
 CellID->989206763],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "does not export closed groups", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "exports all open groups", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LinkedPage\>\"", Cell[
    "exports each forward-closed group to separate a page", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1927154314]
}, Closed]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->26122],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"],
  FontSlant->"Italic"],
 ButtonBox[" Internet Connectivity",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"]
}], "Tutorials",
 CellID->25547]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->25605],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<EPS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/EPS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LaTeX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LaTeX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MathML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PDF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PDF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<RTF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/RTF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<SVG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/SVG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<SWF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/SWF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TeX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TeX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XHTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XHTML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XHTMLMathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XHTMLMathML"]], "InlineFormula"]
}], "SeeAlso",
 CellID->943180803]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->176385089],

Cell[TextData[ButtonBox["Creating Web Pages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingWebPages"]], "MoreAbout"],

Cell[TextData[ButtonBox["Document Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExportingInNotebooks"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout"],

Cell[TextData[ButtonBox["Processing Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProcessingTextualData"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebOperations"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->26628768],

Cell["Read an HTML file as plain text:", "ExampleText",
 CellID->790085111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/worldpopulation.html\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->789341257],

Cell[BoxData["\<\"World population from 1950 to 2000\\n1950 2556518868\\n1960 \
3040617514\\n1970 3707921742\\n1980 4447068714\\n1990 5274320491\\n2000 \
6073265234\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1683403091]
}, Open  ]],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in this file:"
}], "ExampleText",
 CellID->216131011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
  "\"\<ExampleData/worldpopulation.html\>\"", ",", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1119054800],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Data\"\>", ",", "\<\"HTMLSource\"\>", 
   ",", "\<\"Hyperlinks\"\>", ",", "\<\"Plaintext\"\>", 
   ",", "\<\"XMLObject\"\>"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->292243174]
}, Open  ]],

Cell["Import the tabular content from this file:", "ExampleText",
 CellID->1069071176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{
   "\"\<ExampleData/worldpopulation.html\>\"", ",", " ", "\"\<Data\>\""}], 
   "]"}], " ", "//", " ", "TableForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1755176023],

Cell[BoxData[
 TagBox[GridBox[{
    {"1950", "2556518868"},
    {"1960", "3040617514"},
    {"1970", "3707921742"},
    {"1980", "4447068714"},
    {"1990", "5274320491"},
    {"2000", "6073265234"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[3]//TableForm=",
 CellID->282181024]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1794351246],

Cell["This exports a mathematical expression to HTML:", "ExampleText",
 CellID->379800108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<formula.html\>\"", ",", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"a", " ", "-", " ", 
     RowBox[{"b", "/", "4"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42761584],

Cell[BoxData["\<\"formula.html\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->909140552]
}, Open  ]],

Cell["\<\
Show the names of the files saved into the HTMLFiles directory:\
\>", "ExampleText",
 CellID->1683577700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<HTMLFiles\>\"", ",", " ", "\"\<Directory\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->306780190],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Default.css\"\>", ",", "\<\"formula_1.gif\"\>", 
   ",", "\<\"xhtml-math11-f.dtd\"\>"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->579109059]
}, Open  ]],

Cell["Import the rasterized typeset expression:", "ExampleText",
 CellID->983300372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<HTMLFiles/formula_1.gif\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->645871028],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQB2IjIC6nF8ggWYdmAak6pKMIqRBjUkHmBjm44lefnZ7O
lYssYFhigl8HGycnowgSv8ik3BC/DoWAcp4iJL57DCEdKVKlPMh8/XJCOsot
rJF15FiWl9tk4ddRKsOBxLNPKS/3DyFgSTSyK4COKk92JKADCXgnOoEoAyg3
uwiPWgiIVc6FWQQEStwcqmyqRFmlByZTeEqL1QSIc5x+GYgs43PNDoXo8HAA
AqhksA8I+KHqcEgCU1FqohJCYFZqIhBAJROiQSAOVUcwxITIiDJzlXKiQKYV
mArkZ5eOJk5HuS6R6hBAh9o6CgsxhAyKcSu3ZVZgZVFEV+ASj8cGQfmcVDEz
NMFwT3w6wsrLHWXRBHNN8enwKi83VkcX1canQ9jXlSuGJB12kuLOGKJauDXk
8KZhEzbKx6nDRS4Pm7AbwZIUHUQTKEkxQaEBYTVoQJMOOjRMiQD+JBtLFgAA
nNFXoQ==
   "], {{0, 0}, {50, 39}},
   ColorFunction->(Apply[RGBColor, 
     Part[CompressedData["
1:eJztl8lKVnEYhyW6gOaZojsoihbRcAtRQURUELSOoFbRsGyZQ9rksOgCSkEt
xxZNVqJFjqnfpN/gN2SppWXk+/75LU4PQRfQA4dn8fAtDud/zvt+O89dOHp+
RVlZ2Y3la+Xytcm5efhPlzmfD69zqmD1VU4DHP39Q1h9jdMIq691mmD1DU4z
rB7upxVW3+a0w+o7nC44ev/dsPpq5xmsvt55DqvXVBsvYPU7NcZLWP3uHeMV
rH7vrvEaVt/i9MDq9+8ZPbD6VucNrF77wHgLq9fVGu9g9e1OL6xeX2f0wtHn
1werH3H6YPX3/Q6s/uG9A0fP9wdYvfq28RGOno8BWH1wwIHVh4ccWH2zMwxH
n+8orH7KGYXVxz45sPppZwxWP+OMw+oT4w6sHptwYPVdTgyOno8YrF5+y4jB
6o8fGTFYvb/PiMHqM5+NGKwevjdxWH23E4fVLzpxWL2i3IjD6o2PjTis/mXG
iMPqYR4kYPXKCiMBqzc1Ggk4+n4m4Oj7mYTV9zhJWP2Yk4TVqyqNJKw++9VI
wuphnqZg9b1OClY/7qRg9UtOClafmzVSsHqYZ5Ow+mVnElafnzMmYfV9zhSs
Hr6HU7B6S7MxBat/mzemYPWNThpWP+GkYfXWFiMNqw8NGmlYPewzGVg9zPsM
rP6k1cjA6mEeZGD1he9GBlYP8yILq590srB62EeysPrIsJGF1RcXjCysHvaZ
HKy+38nB6m1PjRysPjpi5GD1H4tGDlYP83QaVr/iTMPq7W3GNKx+wMnD6mEf
y8PqHe1GHlYP8zwPqy/9NPKw+kGnAKuHfaAAq191CrB62CcLsHpnh1GA1X8t
GQVY/ZBThNWvOUVYPeyrRVi9q9Mowuph3ynC6uH/TAlWP+uUYPXrTglWb6g3
SrB6d5dRgtXDPlaC1f/Nf+N//w37eigf
      "], #]]& ),
   ColorFunctionScaling->False],
  Background->None,
  ImageSize->{50, 39},
  PlotRange->{{0, 50}, {0, 39}}]], "Output",
 CellLabel->"Out[3]=",
 CellID->690066409]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->963947410],

Cell[TextData[{
 "This translates a ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " expression to HTML:"
}], "ExampleText",
 CellID->548536701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{
     "TextData", "[", "\"\<Converting a Cell expression to HTML\>\"", "]"}], 
     ",", "\"\<Subsection\>\""}], "]"}], ",", " ", "\"\<HTML\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109037136],

Cell[BoxData["\<\"<?xml version=\\\"1.0\\\" \
encoding=\\\"UTF-8\\\"?>\\n<!DOCTYPE html PUBLIC \\\"-//W3C//DTD XHTML 1.1 \
plus MathML 2.0//EN\\\"\\n        \
\\\"HTMLFiles/xhtml-math11-f.dtd\\\">\\n\\n<!-- Created by Wolfram \
Mathematica 6.0 -->\\n\\n<html \
xmlns=\\\"http://www.w3.org/1999/xhtml\\\">\\n<head>\\n <title>\\n  \
Untitled\\n </title>\\n <link href=\\\"HTMLFiles/Default.css\\\" \
rel=\\\"stylesheet\\\" type=\\\"text/css\\\"/>\\n</head>\\n\\n<body>\\n\\n<p \
class=\\\"Subsection\\\">\\n Converting a Cell expression to \
HTML\\n</p>\\n\\n\\n\\n<hr/>\\n\\n<table><tr>\\n<td style='font-family: \
Helvetica; font-size: 10px; width: 100%'>Created by\\n <a \
href=\\\"http://www.wolfram.com/products/mathematica\\\"><span \
style='font-style: italic'>Wolfram Mathematica 6.0</span></a>\\n &nbsp;(17 \
April 2007)</td>\\n<td><img \
src='http://www.w3.org/Icons/valid-xhtml11.gif'\\n alt='Valid XHTML 1.1!' \
height='31' \
width='88'/></td>\\n</tr></table>\\n</body>\\n\\n</html>\\n\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1534442263]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->621484306],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can export graphics with embedded tooltips and hyperlinks to HTML image \
maps: "
}], "ExampleText",
 CellID->2073755581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Tooltip", "[", 
       RowBox[{
        RowBox[{"Hyperlink", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Purple", ",", 
            RowBox[{"Rectangle", "[", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
          "\"\<http://www.wolfram.com\>\""}], "]"}], ",", 
        "\"\<Wolfram Research\>\""}], "]"}], ",", 
      RowBox[{"Tooltip", "[", 
       RowBox[{
        RowBox[{"Hyperlink", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Orange", ",", 
            RowBox[{"Rectangle", "[", 
             RowBox[{"{", 
              RowBox[{"1.2", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
          "\"\<http://www.wolfram.com/products/mathematica\>\""}], "]"}], 
        ",", "\"\<Mathematica\>\""}], "]"}]}], "}"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"150", ",", "75"}], "}"}]}]}], "]"}], "\n"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2097942704],

Cell[BoxData[
 GraphicsBox[{
   TagBox[
    TooltipBox[
     TagBox[
      TagBox[
       {RGBColor[0.5, 0, 0.5], RectangleBox[{0, 0}]},
       EventHandlerTag[{"MouseClicked" :> FrontEndExecute[{
            NotebookLocate[{
              URL["http://www.wolfram.com"], None}]}], PassEventsDown -> 
         Automatic, PassEventsUp -> True}]],
      Annotation[#, "http://www.wolfram.com", "Hyperlink"]& ],
     "\"Wolfram Research\""],
    Annotation[#, "Wolfram Research", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     TagBox[
      TagBox[
       {RGBColor[1, 0.5, 0], RectangleBox[{1.2, 0}]},
       EventHandlerTag[{"MouseClicked" :> FrontEndExecute[{
            NotebookLocate[{
              URL["http://www.wolfram.com/products/mathematica"], None}]}], 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      Annotation[#, "http://www.wolfram.com/products/mathematica", 
       "Hyperlink"]& ],
     "\"Mathematica\""],
    Annotation[#, "Mathematica", "Tooltip"]& ]},
  ImageSize->{150, 75}]], "Output",
 CellLabel->"Out[1]=",
 CellID->950348375]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<imagemap.html\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1723654608],

Cell[BoxData["\<\"imagemap.html\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1669255886]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1394939143],

Cell[TextData[{
 "The mapping of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " style elements to HTML can be specified as ",
 StyleBox["\"ConversionRules\"", "InlineCode"],
 ":"
}], "ExampleText",
 CellID->663202102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{"TextData", "[", "\"\<Using ConversionRules\>\"", "]"}], ",", 
     "\"\<Subsection\>\""}], "]"}], ",", "\"\<HTML\>\"", ",", 
   RowBox[{"\"\<ConversionRules\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Subsection\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<<b><i>\>\"", ",", "\"\<</i></b>\>\""}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->997600384],

Cell[BoxData["\<\"<?xml version=\\\"1.0\\\" \
encoding=\\\"UTF-8\\\"?>\\n<!DOCTYPE html PUBLIC \\\"-//W3C//DTD XHTML 1.1 \
plus MathML 2.0//EN\\\"\\n        \
\\\"HTMLFiles/xhtml-math11-f.dtd\\\">\\n\\n<!-- Created by Wolfram \
Mathematica 6.0 -->\\n\\n<html \
xmlns=\\\"http://www.w3.org/1999/xhtml\\\">\\n<head>\\n <title>\\n  \
Untitled\\n </title>\\n <link href=\\\"HTMLFiles/Default.css\\\" \
rel=\\\"stylesheet\\\" \
type=\\\"text/css\\\"/>\\n</head>\\n\\n<body>\\n\\n<b><i>Using \
ConversionRules</i></b>\\n\\n<hr/>\\n\\n<table><tr>\\n<td style='font-family: \
Helvetica; font-size: 10px; width: 100%'>Created by\\n <a \
href=\\\"http://www.wolfram.com/products/mathematica\\\"><span \
style='font-style: italic'>Wolfram Mathematica 6.0</span></a>\\n &nbsp;(17 \
April 2007)</td>\\n<td><img \
src='http://www.w3.org/Icons/valid-xhtml11.gif'\\n alt='Valid XHTML 1.1!' \
height='31' \
width='88'/></td>\\n</tr></table>\\n</body>\\n\\n</html>\\n\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->239997418]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1871790598],

Cell["Export a formatted table to HTML:", "ExampleText",
 CellID->696635683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Notebook", "[", 
    RowBox[{"{", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"BoxData", "[", 
        RowBox[{"GridBox", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\"\<a\>\"", ",", "\"\<b\>\""}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\"\<c\>\"", ",", "\"\<d\>\""}], "}"}]}], "}"}], "]"}], 
        "]"}], ",", "\"\<Input\>\""}], "]"}], "}"}], "]"}], ",", 
   "\"\<HTML\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2018527380],

Cell[BoxData["\<\"<?xml version=\\\"1.0\\\" \
encoding=\\\"UTF-8\\\"?>\\n<!DOCTYPE html PUBLIC \\\"-//W3C//DTD XHTML 1.1 \
plus MathML 2.0//EN\\\"\\n        \
\\\"HTMLFiles/xhtml-math11-f.dtd\\\">\\n\\n<!-- Created by Wolfram \
Mathematica 6.0 -->\\n\\n<html \
xmlns=\\\"http://www.w3.org/1999/xhtml\\\">\\n<head>\\n <title>\\n  \
Untitled\\n </title>\\n <link href=\\\"HTMLFiles/Default.css\\\" \
rel=\\\"stylesheet\\\" \
type=\\\"text/css\\\"/>\\n</head>\\n\\n<body>\\n\\n<table class='Input'>\\n \
<tr style='vertical-align:bottom;'>\\n  <td style='text-align: \
center;'><span>a</span></td>\\n  <td style='text-align: \
center;'><span>b</span></td>\\n </tr>\\n <tr \
style='vertical-align:bottom;'>\\n  <td style='text-align: \
center;'><span>c</span></td>\\n  <td style='text-align: \
center;'><span>d</span></td>\\n \
</tr>\\n</table>\\n\\n<hr/>\\n\\n<table><tr>\\n<td style='font-family: \
Helvetica; font-size: 10px; width: 100%'>Created by\\n <a \
href=\\\"http://www.wolfram.com/products/mathematica\\\"><span \
style='font-style: italic'>Wolfram Mathematica 6.0</span></a>\\n &nbsp;(17 \
April 2007)</td>\\n<td><img \
src='http://www.w3.org/Icons/valid-xhtml11.gif'\\n alt='Valid XHTML 1.1!' \
height='31' \
width='88'/></td>\\n</tr></table>\\n</body>\\n\\n</html>\\n\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->662315260]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HTML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 53.8556300}", "context" -> "", 
    "keywords" -> {
     "web", "web technology", "web mining", "data mining", "WWW", 
      "world wide web", "w3c", "internet", "HTTP", "hypertext", "hyperlink", 
      "Flash"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Registered MIME type: text/html HTML markup language and file format. \
Predominant language for the creation of web pages. HTML is an acronym \
derived from Hypertext Markup Language. Plain text format. Describes the \
structure and aspects of the appearance of web pages. First published in 1993 \
as an Internet Engineering Task Force (IETF) working draft. Maintained since \
1996 by the World Wide Web Consortium (W3C). Most recent version is 4.01, \
published in 1999 as W3C recommendation. International standard ISO/IEC \
15445:2000. Predecessor of XHTML.", "synonyms" -> {}, "title" -> "HTML", 
    "type" -> "Format", "uri" -> "ref/format/HTML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[32681, 1080, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 48554, 1562}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4575, 95, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5198, 122, 110, 4, 70, "ObjectNameAlt",
 CellID->19281],
Cell[5311, 128, 659, 12, 70, "FormatUsage",
 CellID->7085],
Cell[5973, 142, 202, 7, 70, "FormatNotes",
 CellID->9152],
Cell[6178, 151, 405, 14, 70, "FormatNotes",
 CellID->754516599]
}, Open  ]],
Cell[CellGroupData[{
Cell[6620, 170, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[6687, 173, 298, 9, 70, "FormatNotes",
 CellID->28652],
Cell[6988, 184, 322, 11, 70, "FormatNotes",
 CellID->269543858],
Cell[7313, 197, 388, 14, 70, "FormatNotes",
 CellID->8194],
Cell[7704, 213, 426, 14, 70, "FormatNotes",
 CellID->1111605557],
Cell[8133, 229, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[8175, 232, 358, 11, 70, "FormatNotes",
 CellID->28396],
Cell[8536, 245, 400, 13, 70, "FormatNotes",
 CellID->7572],
Cell[8939, 260, 252, 8, 70, "FormatNotes",
 CellID->1180609883],
Cell[9194, 270, 218, 7, 70, "FormatNotes",
 CellID->2050276003],
Cell[9415, 279, 188, 6, 70, "FormatNotes",
 CellID->466182659],
Cell[9606, 287, 433, 15, 70, "FormatNotes",
 CellID->1279277825],
Cell[10042, 304, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[10084, 307, 354, 13, 70, "FormatNotes",
 CellID->29174],
Cell[10441, 322, 575, 20, 70, "FormatNotes",
 CellID->18819],
Cell[11019, 344, 581, 21, 70, "FormatNotes",
 CellID->943],
Cell[11603, 367, 705, 25, 70, "FormatNotes",
 CellID->32611],
Cell[12311, 394, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[12352, 397, 532, 20, 70, "FormatNotes",
 CellID->20289],
Cell[12887, 419, 1076, 40, 70, "FormatNotes",
 CellID->8419],
Cell[13966, 461, 662, 22, 70, "FormatNotes",
 CellID->5565],
Cell[14631, 485, 816, 28, 70, "FormatNotes",
 CellID->3805],
Cell[15450, 515, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[15491, 518, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[15855, 534, 353, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[16245, 553, 69, 1, 70, "NotebookInterfaceSection",
 CellID->1615],
Cell[16317, 556, 153, 4, 70, "FormatNotes",
 CellID->11064],
Cell[16473, 562, 135, 4, 70, "FormatNotes",
 CellID->1262458812]
}, Closed]],
Cell[CellGroupData[{
Cell[16645, 571, 50, 1, 70, "ElementsSection",
 CellID->9166],
Cell[16698, 574, 192, 8, 70, "FormatNotes",
 CellID->16893],
Cell[16893, 584, 707, 14, 70, "2ColumnTableMod",
 CellID->16074],
Cell[17603, 600, 39, 1, 70, "WeakDivider",
 CellID->13509],
Cell[17645, 603, 179, 7, 70, "FormatNotes",
 CellID->30300],
Cell[17827, 612, 953, 18, 70, "2ColumnTableMod",
 CellID->19695],
Cell[18783, 632, 257, 9, 70, "FormatNotes",
 CellID->9573],
Cell[19043, 643, 299, 9, 70, "FormatNotes",
 CellID->1070518464],
Cell[19345, 654, 183, 7, 70, "FormatNotes",
 CellID->435924729],
Cell[19531, 663, 1008, 29, 70, "2ColumnTableMod",
 CellID->1520200386]
}, Open  ]],
Cell[CellGroupData[{
Cell[20576, 697, 49, 1, 70, "OptionsSection",
 CellID->10422],
Cell[20628, 700, 178, 7, 70, "FormatNotes",
 CellID->30774],
Cell[20809, 709, 663, 16, 70, "3ColumnTableMod",
 CellID->8779],
Cell[21475, 727, 548, 15, 70, "FormatNotes",
 CellID->191607095],
Cell[22026, 744, 163, 5, 70, "FormatNotes",
 CellID->1329172617],
Cell[22192, 751, 39, 1, 70, "WeakDivider",
 CellID->15495],
Cell[22234, 754, 214, 9, 70, "FormatNotes",
 CellID->5764],
Cell[22451, 765, 2428, 58, 70, "3ColumnTableMod",
 CellID->1908888948],
Cell[24882, 825, 155, 6, 70, "FormatNotes",
 CellID->757163963],
Cell[25040, 833, 904, 24, 70, "2ColumnTableMod",
 CellID->1814117666],
Cell[25947, 859, 160, 5, 70, "FormatNotes",
 CellID->1262887948],
Cell[26110, 866, 981, 21, 70, "2ColumnTableMod",
 CellID->1776858735],
Cell[27094, 889, 221, 7, 70, "FormatNotes",
 CellID->989206763],
Cell[27318, 898, 766, 19, 70, "2ColumnTableMod",
 CellID->1927154314]
}, Closed]],
Cell[CellGroupData[{
Cell[28121, 922, 53, 1, 70, "TutorialsSection",
 CellID->26122],
Cell[28177, 925, 295, 9, 70, "Tutorials",
 CellID->25547]
}, Closed]],
Cell[CellGroupData[{
Cell[28509, 939, 50, 1, 70, "SeeAlsoSection",
 CellID->25605],
Cell[28562, 942, 2489, 83, 70, "SeeAlso",
 CellID->943180803]
}, Open  ]],
Cell[CellGroupData[{
Cell[31088, 1030, 58, 1, 70, "MoreAboutSection",
 CellID->176385089],
Cell[31149, 1033, 126, 2, 70, "MoreAbout"],
Cell[31278, 1037, 123, 2, 70, "MoreAbout"],
Cell[31404, 1041, 151, 2, 70, "MoreAbout"],
Cell[31558, 1045, 134, 2, 70, "MoreAbout"],
Cell[31695, 1049, 158, 2, 70, "MoreAbout"],
Cell[31856, 1053, 133, 2, 70, "MoreAbout"],
Cell[31992, 1057, 153, 2, 70, "MoreAbout"],
Cell[32148, 1061, 119, 2, 70, "MoreAbout"],
Cell[32270, 1065, 136, 2, 70, "MoreAbout"],
Cell[32409, 1069, 113, 2, 70, "MoreAbout"],
Cell[32525, 1073, 119, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32681, 1080, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[32797, 1086, 59, 1, 70, "ExampleSection",
 CellID->26628768],
Cell[32859, 1089, 75, 1, 70, "ExampleText",
 CellID->790085111],
Cell[CellGroupData[{
Cell[32959, 1094, 144, 4, 70, "Input",
 CellID->789341257],
Cell[33106, 1100, 225, 4, 70, "Output",
 CellID->1683403091]
}, Open  ]],
Cell[33346, 1107, 220, 8, 70, "ExampleText",
 CellID->216131011],
Cell[CellGroupData[{
Cell[33591, 1119, 186, 6, 70, "Input",
 CellID->1119054800],
Cell[33780, 1127, 231, 6, 70, "Output",
 CellID->292243174]
}, Open  ]],
Cell[34026, 1136, 86, 1, 70, "ExampleText",
 CellID->1069071176],
Cell[CellGroupData[{
Cell[34137, 1141, 232, 7, 70, "Input",
 CellID->1755176023],
Cell[34372, 1150, 708, 22, 70, "Output",
 CellID->282181024]
}, Open  ]],
Cell[35095, 1175, 126, 3, 70, "ExampleDelimiter",
 CellID->1794351246],
Cell[35224, 1180, 90, 1, 70, "ExampleText",
 CellID->379800108],
Cell[CellGroupData[{
Cell[35339, 1185, 236, 7, 70, "Input",
 CellID->42761584],
Cell[35578, 1194, 90, 2, 70, "Output",
 CellID->909140552]
}, Open  ]],
Cell[35683, 1199, 115, 3, 70, "ExampleText",
 CellID->1683577700],
Cell[CellGroupData[{
Cell[35823, 1206, 165, 5, 70, "Input",
 CellID->306780190],
Cell[35991, 1213, 193, 5, 70, "Output",
 CellID->579109059]
}, Open  ]],
Cell[36199, 1221, 84, 1, 70, "ExampleText",
 CellID->983300372],
Cell[CellGroupData[{
Cell[36308, 1226, 132, 3, 70, "Input",
 CellID->645871028],
Cell[36443, 1231, 1774, 36, 70, "Output",
 CellID->690066409]
}, Open  ]],
Cell[38232, 1270, 125, 3, 70, "ExampleDelimiter",
 CellID->963947410],
Cell[38360, 1275, 212, 8, 70, "ExampleText",
 CellID->548536701],
Cell[CellGroupData[{
Cell[38597, 1287, 317, 10, 70, "Input",
 CellID->109037136],
Cell[38917, 1299, 1056, 18, 70, "Output",
 CellID->1534442263]
}, Open  ]],
Cell[39988, 1320, 125, 3, 70, "ExampleDelimiter",
 CellID->621484306],
Cell[40116, 1325, 189, 6, 70, "ExampleText",
 CellID->2073755581],
Cell[CellGroupData[{
Cell[40330, 1335, 1098, 32, 70, "Input",
 CellID->2097942704],
Cell[41431, 1369, 1073, 29, 70, "Output",
 CellID->950348375]
}, Open  ]],
Cell[CellGroupData[{
Cell[42541, 1403, 146, 4, 70, "Input",
 CellID->1723654608],
Cell[42690, 1409, 92, 2, 70, "Output",
 CellID->1669255886]
}, Open  ]],
Cell[42797, 1414, 126, 3, 70, "ExampleDelimiter",
 CellID->1394939143],
Cell[42926, 1419, 225, 8, 70, "ExampleText",
 CellID->663202102],
Cell[CellGroupData[{
Cell[43176, 1431, 513, 14, 70, "Input",
 CellID->997600384],
Cell[43692, 1447, 1009, 18, 70, "Output",
 CellID->239997418]
}, Open  ]],
Cell[44716, 1468, 126, 3, 70, "ExampleDelimiter",
 CellID->1871790598],
Cell[44845, 1473, 76, 1, 70, "ExampleText",
 CellID->696635683],
Cell[CellGroupData[{
Cell[44946, 1478, 592, 18, 70, "Input",
 CellID->2018527380],
Cell[45541, 1498, 1338, 24, 70, "Output",
 CellID->662315260]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[46918, 1527, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

