(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33864,        914]
NotebookOptionsPosition[     29635,        778]
NotebookOutlinePosition[     31056,        817]
CellTagsIndexPosition[     30971,        812]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"BMP\"" :> Documentation`HelpLookup["paclet:ref/format/BMP"], 
          "\"CUR\"" :> Documentation`HelpLookup["paclet:ref/format/CUR"], 
          "\"TIFF\"" :> Documentation`HelpLookup["paclet:ref/format/TIFF"], 
          "\"XBM\"" :> Documentation`HelpLookup["paclet:ref/format/XBM"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"BMP\\\"\"\>", 
       2->"\<\"\\\"CUR\\\"\"\>", 3->"\<\"\\\"TIFF\\\"\"\>", 
       4->"\<\"\\\"XBM\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"], 
          "Systems & Utility Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/SystemsAndUtilityFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Listing of All Formats\"\>", 
       2->"\<\"New in 6.0: Import & Export Formats\"\>", 
       3->"\<\"Raster Image Formats\"\>", 
       4->"\<\"Systems & Utility Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "ICO ",
 StyleBox["(.ico)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->7514],

Cell[TextData[{
 "Registered MIME type: ",
 Cell[BoxData[
  RowBox[{"image", "/", 
   RowBox[{"vnd", ".", "microsoft", ".", "icon"}]}]], "InlineFormula"],
 "\nMicrosoft Windows icon.\nRaster image file format.\nNative icon format on \
Windows.\nICO is an acronym derived from icon.\nBinary format.\nCan store \
multiple icons at different color resolutions.\nSupports alpha channels.\n\
Similar to CUR format."
}], "FormatUsage",
 CellID->10168],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " fully supports the ",
 "ICO",
 " format."
}], "FormatNotes",
 CellID->5055]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->5973],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ico\>\"", "]"}]], "InlineFormula"],
 " imports an ",
 "ICO",
 " file, returning a graphics object."
}], "FormatNotes",
 CellID->8922],

Cell["", "WeakDivider",
 CellID->5651],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ico\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     StyleBox["data", "TI"], "]"}], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " is an array of RGB color values."
}], "FormatNotes",
 CellID->10986],

Cell["", "WeakDivider",
 CellID->31577],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ico\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "ICO",
 " file."
}], "FormatNotes",
 CellID->26517],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ico\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->14629],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ico\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->29916],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<ICO\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<ICO\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5874],

Cell["", "WeakDivider",
 CellID->9091],

Cell[TextData[{
 "See the reference pages for full general information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " supports the ",
 "ICO",
 " format."
}], "FormatNotes",
 CellID->26949]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->236],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->8551],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->9487],

Cell["", "WeakDivider",
 CellID->31226],

Cell["Data representation elements:", "FormatNotes",
 CellID->28162],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "array of color values for each icon", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<GraphicsList\>\"", Cell["", "TableText"]}], Cell[
    "icons given as a list of graphics objects", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GrayLevels\>\"", Cell[
    "array of normalized gray-level values", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->16955],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<RGBColorArray\>\"", Cell[TextData[{
     "array of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects for each icon"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->23183],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<GraphicsList\>\""], "InlineFormula"],
 " element for ",
 "ICO",
 " files."
}], "FormatNotes",
 CellID->8394],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " element:"
}], "FormatNotes",
 CellID->450361849],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BitDepth\>\"", Cell[
    "number of bits used to represent each color channel", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ColorSpace\>\"", Cell[
    "color encoding used in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageSize\>\"", Cell[
    "raster dimensions", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1499224115]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22214],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<BMP\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/BMP"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<CUR\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/CUR"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TIFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XBM\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XBM"]], "InlineFormula"]
}], "SeeAlso",
 CellID->599190091]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->327643250],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Systems & Utility Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemsAndUtilityFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->78378223],

Cell["Import an ICO file that stores two bitmaps:", "ExampleText",
 CellID->167418574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/mathematica3.ico\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27432],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJzNlutRxDAMhDMDhUBLlHAN0II6NxxObGn1sGyHgR+am5sk+tarR/L++Px4
vBzH8XbG63eUUv5tPOVdkbk3+r/KJ6Kfv5GOy0au9/kc/13RU58rhZcJcyGb
Dsm9su3xpQY8aw06o7Lb+U8N+3ytoevQbK5hha/ZkQ82m3tQ++gOvt0PFvue
3os1RGxRgykuhq9hxM560Fgkgz+fiYgf7Y/GnM4p/Wi5nByejlEf2X569QEf
vblc1MD5vobiemBpwJ0ds0nwYw2l7QCsg9jhLN14njWfyK8Fsfzm+wM60vMB
dy0+WDUYewJuRT5qtDyw3jPWKEsPNNvS4OnQc0NDftfgsz0NqIP3pGSP+egn
sZxT+/DmmHsPUMpHfkZrLrNMye8+ZzXgXlrl87P3bwhKsFnfb/P1/I18V3O/
wbe/o7QH1GpUFP/aibt80b+ps3cNs3w583pXcw+IXZdzhnWYr310nfdclGPl
/Cl/2v7L3X8n/7dy/lV8AQR6SvI=
     "], {{0, 0}, {32, 32}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{32, 32},
    PlotRange->{{0, 32}, {0, 32}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJytU8kNwzAME5AO0BWyUkfIAlmBm6v1ocuHUKB9ELBskBIZ5bzu13UQ0bPj
8QEz/w1Frkn+yvc67axv9TrjM3tbRKg1gHrO+cwGm6NwBTt/NmPU8NwV33sT
yKzez/xuOvs+40zRj880aFDPitcarPm03uKmcFQXCBF5rmKTw9hf96GX2OyZ
ft8Bcc3z3ZtmHPYh41t+FHpLdjkfU6ZwtWl89y9hkc8Kb5k2Wjo=
     "], {{0, 0}, {16, 16}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{16, 16},
    PlotRange->{{0, 16}, {0, 16}}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->600395648]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1178330747],

Cell[TextData[{
 "Read an ICO file representing the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 icon at various resolutions:"
}], "ExampleText",
 CellID->110672195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/mathematica6.ico\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1203333358],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJzdmt+N2zAMxgW0i3SDAlqhExToAveg1z56Ba+gFbxCVtBOriWT8kdKsuN/
CdIHIsnhIv1IfiIp3/34+vv765sx5ifZ98nGcbzWrB2DjW8vXvdV5iK/HXvz
oT4Qv5/s7SwHLBB/+DB+H/Vigf2AD920xrv85r0fzOCiuadZ3PS9B8XgbdrB
uFvif8KHntjvjP1WPel5/5386Xvm/jMT9e1XfPBr/K7CBWeF+e/URkc5Hibr
Kn7w+c3mFD+blRa5h+T7en6v0hDvN+S8z/sG5LbA68EH+nmA2HNMhhf0u465
IeeB5oVgKzFmfm9FDpDf29fxR3tQ3LleCP6sefAh8c+WehsbsSd7lt0d6yto
Iu6G2U1d8yIHE7+vsBN/K/6YK7RT8Sdm3jvYitadOguRnfi9RYv5nNeL54vN
02eptfM1ivk5din2xIdaET6AnkQcQYciH5U5ZA97oLj2VCtZn0OOvZXnFbmR
v+ZLQw+J2UHvgFq2yW51fIxYB2Mh67uKeyDjmuPrPgS9pq5ZugZsxFvH1WOd
1NyiNlbYhQ+lnrD+iBwi9w52NtZJriWrcVf6yNyerM6v62dap+Yn73PwjA56
FqjmWO2vfVBcOebTdwJpvdDcwdhvnYmilui5RsdQ+cC8iZ3q58Lu6/wn62Th
B+td+6K5MebInnLgcp3J3OLMqLWv9EHXG9uIPbI7qIvct+IZ826b/8ocVGfK
dv1fZoRFN9xvU09t+g05Rv1emINZC7MeCp/EOaWYZ9279F7wO5XXxj3h9N0G
zgDWQD2zSb2omqP1X+trOu5Yx8/M2FbGVPQf9KtSZ7I/wJ/rz8qcJO6h8Hn3
XUH1sqL329In1j7Pl4sf7BdpaIW95cMeTelnCg89vzX8ipxc03Hel3NxOWPV
1luN6wp7eh6VZyAz4tzMd9+H4Rma9tL9i/sB6T3FHmbaq+8mbPwsjGf0AT4v
/I05Gtmxr3o8JzO/V/m8gr2vrBnscmZ6Ys93F+zNodKXamcUNOV1Dk/yb63B
ceN9iz4c4HWDH2OTYmYu7LkbOcLnbeLu2+qnwK1rWn6eRHp9BT/vJ+bRWk9V
80CzdlE9eMXfbQYRezVL21Iraz1E1+e7+Ts4b4LXlrzPzjLoS/Thz40+dFr3
rTn9QM/MNXp6/XWTD8Xdcu33D/R81mbtGfdZ2/086QA/+uEu9oE1uueMBcjX
Ff3psFGv2VsfOtTbu9gp9kdrW87BG/nPmP9w/u4/4P/o/0m50f4B9b96Gg==

     "], {{0, 0}, {48, 48}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{48, 48},
    PlotRange->{{0, 48}, {0, 48}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzNV9ttwzAMFNAO0s7gFTpBgC6QD/32MytkBa7gFbyCdnL1ICmSlhPZatF+
HGA4du545NH2+/Xrcn1xzr0hXiPWdT2FME3rPd9+7v5hRH6I+Cv+VH/o5O+9
rgfJ8zAVJA9W73f/+4bX/lrtfp8/6VwcajzJA/H+W2PGmJ/q95oj/55rH/M9
1TBH2Dmv3ILf4zlEcFOpf9DrxJ/+q8BV34kLfAFqIG9m1D7KD8Sf/9fpvtNx
1hB/R36I1yW0+Mm77uwg94L1BO65rz4kXuSX3OkewP6V89WfPX6recYMgazd
eE46ggFpId6Vzxtu6mU8pjoXhMoaCG70XOloaAjCo70sUl/JZ55vNefIFQSk
FjN/NRv+ITfhJvaFyvcuPygNefaQv6Wrdw81eSU/IfOD4K4alD8HuDczQT1v
8du6Iz9Q7eRNOF4/w9bd0ECzXHJX5n2r0eyrgx4EzHbV47nP1XPP9edrodE7
kb+uvSjyw3Mljuk8sEbPx5u5M1A529m5zSw3sk09kHi0l6wOy+3F3lnM7lM7
hTKItdLure8nz3dtawfMglvuQvXsCTp/MidZr9HQO2/8TmV6Aa6x/23Gjd+z
1Hw0+wbk6eZ5b2d90v0mD0f5ofXc3cmWRfLhY0ADv8NKLpkrw6/7Wc6NfKdw
34nL7ugneaIefJ7R4Dvy84CbfXAnPejYlTwbPzDnG92d3y6j3xmjuP8D/rPf
ed81q7zQ
     "], {{0, 0}, {32, 32}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{32, 32},
    PlotRange->{{0, 32}, {0, 32}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJyFk8ERwzAIBDWTFJAWUoM6SQl+8M3TLbgFWkgLakE9ESFAxrItPW6csbwn
Dsh7+X6WRwjhpXoWEdGlcozEujuf6Vese369eOe1lfOtliQ88bcAZPUke3fD
sz9zye4B5UGyJPX2GXuPpLywRVjY8sQYCLU+1N5UPu7eWe/NlQMR7N/0jNTg
6rWamcuq8pv9mqf6nfK3vI43ls/MDwYzhaOH3ct5JU9s9/e9RJ2Nz+n5DDtL
XQ82m1mI1PamZkCpI0r/Tzvpeui9Gm/9AqtJZjjaW/SzP7CidcC3+qzHXU7b
rzuPq/9cnuz8TDjh/5gMlnc=
     "], {{0, 0}, {16, 16}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{16, 16},
    PlotRange->{{0, 16}, {0, 16}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzV2XdY09fCwPGjIOACZa/sHRIIO2HI3htRK3UvWhe4t1c7tM7WDrXLvVpn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     "], {{0, 0}, {48, 48}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{48, 48},
    PlotRange->{{0, 48}, {0, 48}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzFl2lUU2caxxnUWrWoqAgEsu9hyQoJEMCYADYmYZnYCoOiCJapohZUOsdx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     "], {{0, 0}, {32, 32}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{32, 32},
    PlotRange->{{0, 32}, {0, 32}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGAQgGIWIP7//z9WfN5SS3iLjpo9LnlCeL2UhMk9Z9v1yGL1
rOz8FzUVBXDp6eXll+rl5mcGsddJSDa88nf9/zUx0A/Ev2GirrVHWmbWMxN1
flz6q9i5jdaJSa3eJyPredvEePu7ULf/n2sDrr8JNZ532ULj60Yp2Q5k9fcd
DRnRzdguLbdvp7zU/zcxzv8/xLi8f9vk+fpCqe3L5fpyv2cJicxr4OVUWaqn
FHrRyTjxnLEW11tHHd47pmrSm8TEHQ/LyDse0Vc6cS/e4v/fRSn/P/cH3/5c
4PD1kZ/Rr8M6qv/3mqn9OOpk/vuhk/3FrZraWiD7NihIKO6WlZxwV1f1/0tr
g/+fo1z//J4R+/bfmbofv/dVffrSH/f5RpTj9yvxrp+/9Sc++JHkeu+9kbkM
urs/m2qHfEiwefqh0P/z5+6wOz+3lb56vqzk+fEkj5s7fW2+fdxa/On/vtwH
XxPN9uEKvw8xpu0P69zevyv0+vuyM+rL/nD7extjvB+v8bf99HZG9J3Pvb5v
3sdbfHtvrLl5l4S0CrLeuXyCko9ttW8f99B6f8PF+N8hN5Pf+4Id/mwMcvq6
xMP6z5Ukix9vY01/PrJSf/HYUP3wAz31Oad0VYxAelt4OWU3y0gt3SOvcHi1
hOTro7pKf5+0hD78c779xZv2gEf7XTX+LFYQ+3DaROX+HUN1bZidj2y12ED0
TlUpsWsGaiIgdg8vb+1lb6M/f2anvfm9Nv3B53rXd+9CDX9dMFb9sE1B/v8U
YVFlfOl2roTIjE+hXh++JDo0fY4yPfA21Pj/XROVFbcN1S1v6OusrObinoBL
72UPHemTBrrLvgR5qIL47131ld4aaX+5aq7iDFOzQVLGtZSTSwib/mOmynLb
1dVFkcUOSEp2vtfT0iU3H07h51d7ZKAijkseAK8oYjY=
     "], {{0, 0}, {16, 16}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{16, 16},
    PlotRange->{{0, 16}, {0, 16}}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1971482330]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ICO - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 54.3712682}", "context" -> "", 
    "keywords" -> {"Microsoft", "Windows"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Registered MIME type: image/vnd.microsoft.icon Microsoft Windows icon. \
Raster image file format. Native icon format on Windows. ICO is an acronym \
derived from icon. Binary format. Can store multiple icons at different color \
resolutions. Supports alpha channels. Similar to CUR format.", 
    "synonyms" -> {}, "title" -> "ICO", "type" -> "Format", "uri" -> 
    "ref/format/ICO"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12373, 434, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30837, 805}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2010, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2633, 72, 101, 4, 70, "ObjectNameAlt",
 CellID->7514],
Cell[2737, 78, 445, 10, 70, "FormatUsage",
 CellID->10168],
Cell[3185, 90, 209, 9, 70, "FormatNotes",
 CellID->5055]
}, Open  ]],
Cell[CellGroupData[{
Cell[3431, 104, 52, 1, 70, "ImportExportSection",
 CellID->5973],
Cell[3486, 107, 305, 11, 70, "FormatNotes",
 CellID->8922],
Cell[3794, 120, 38, 1, 70, "WeakDivider",
 CellID->5651],
Cell[3835, 123, 752, 26, 70, "FormatNotes",
 CellID->10986],
Cell[4590, 151, 39, 1, 70, "WeakDivider",
 CellID->31577],
Cell[4632, 154, 352, 13, 70, "FormatNotes",
 CellID->26517],
Cell[4987, 169, 574, 20, 70, "FormatNotes",
 CellID->14629],
Cell[5564, 191, 582, 21, 70, "FormatNotes",
 CellID->29916],
Cell[6149, 214, 697, 25, 70, "FormatNotes",
 CellID->5874],
Cell[6849, 241, 38, 1, 70, "WeakDivider",
 CellID->9091],
Cell[6890, 244, 230, 8, 70, "FormatNotes",
 CellID->9815],
Cell[7123, 254, 216, 9, 70, "FormatNotes",
 CellID->26949]
}, Closed]],
Cell[CellGroupData[{
Cell[7376, 268, 49, 1, 70, "ElementsSection",
 CellID->236],
Cell[7428, 271, 191, 8, 70, "FormatNotes",
 CellID->8551],
Cell[7622, 281, 711, 14, 70, "2ColumnTableMod",
 CellID->9487],
Cell[8336, 297, 39, 1, 70, "WeakDivider",
 CellID->31226],
Cell[8378, 300, 68, 1, 70, "FormatNotes",
 CellID->28162],
Cell[8449, 303, 678, 14, 70, "2ColumnTableMod",
 CellID->16955],
Cell[9130, 319, 529, 15, 70, "2ColumnTableMod",
 CellID->23183],
Cell[9662, 336, 284, 11, 70, "FormatNotes",
 CellID->8394],
Cell[9949, 349, 196, 8, 70, "FormatNotes",
 CellID->450361849],
Cell[10148, 359, 632, 13, 70, "2ColumnTableMod",
 CellID->1499224115]
}, Open  ]],
Cell[CellGroupData[{
Cell[10817, 377, 50, 1, 70, "SeeAlsoSection",
 CellID->22214],
Cell[10870, 380, 799, 27, 70, "SeeAlso",
 CellID->599190091]
}, Open  ]],
Cell[CellGroupData[{
Cell[11706, 412, 58, 1, 70, "MoreAboutSection",
 CellID->327643250],
Cell[11767, 415, 133, 2, 70, "MoreAbout"],
Cell[11903, 419, 156, 2, 70, "MoreAbout"],
Cell[12062, 423, 130, 2, 70, "MoreAbout"],
Cell[12195, 427, 141, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12373, 434, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[12489, 440, 59, 1, 70, "ExampleSection",
 CellID->78378223],
Cell[12551, 443, 86, 1, 70, "ExampleText",
 CellID->167418574],
Cell[CellGroupData[{
Cell[12662, 448, 136, 4, 70, "Input",
 CellID->27432],
Cell[12801, 454, 1211, 27, 70, "Output",
 CellID->600395648]
}, Open  ]],
Cell[14027, 484, 126, 3, 70, "ExampleDelimiter",
 CellID->1178330747],
Cell[14156, 489, 177, 6, 70, "ExampleText",
 CellID->110672195],
Cell[CellGroupData[{
Cell[14358, 499, 141, 4, 70, "Input",
 CellID->1203333358],
Cell[14502, 505, 15067, 266, 70, "Output",
 CellID->1971482330]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[29608, 776, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

