(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     74759,       1781]
NotebookOptionsPosition[     69367,       1607]
NotebookOutlinePosition[     70745,       1645]
CellTagsIndexPosition[     70659,       1640]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"3DS\"" :> Documentation`HelpLookup["paclet:ref/format/3DS"], 
          "\"BYU\"" :> Documentation`HelpLookup["paclet:ref/format/BYU"], 
          "\"JVX\"" :> Documentation`HelpLookup["paclet:ref/format/JVX"], 
          "\"PLY\"" :> Documentation`HelpLookup["paclet:ref/format/PLY"], 
          "\"Maya\"" :> Documentation`HelpLookup["paclet:ref/format/Maya"], 
          "\"OBJ\"" :> Documentation`HelpLookup["paclet:ref/format/OBJ"], 
          "\"OFF\"" :> Documentation`HelpLookup["paclet:ref/format/OFF"], 
          "\"POV\"" :> Documentation`HelpLookup["paclet:ref/format/POV"], 
          "\"RIB\"" :> Documentation`HelpLookup["paclet:ref/format/RIB"], 
          "\"STL\"" :> Documentation`HelpLookup["paclet:ref/format/STL"], 
          "\"VRML\"" :> Documentation`HelpLookup["paclet:ref/format/VRML"], 
          "\"X3D\"" :> Documentation`HelpLookup["paclet:ref/format/X3D"], 
          "\"ZPR\"" :> Documentation`HelpLookup["paclet:ref/format/ZPR"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"3DS\\\"\"\>", 
       2->"\<\"\\\"BYU\\\"\"\>", 3->"\<\"\\\"JVX\\\"\"\>", 
       4->"\<\"\\\"PLY\\\"\"\>", 5->"\<\"\\\"Maya\\\"\"\>", 
       6->"\<\"\\\"OBJ\\\"\"\>", 7->"\<\"\\\"OFF\\\"\"\>", 
       8->"\<\"\\\"POV\\\"\"\>", 9->"\<\"\\\"RIB\\\"\"\>", 
       10->"\<\"\\\"STL\\\"\"\>", 11->"\<\"\\\"VRML\\\"\"\>", 
       12->"\<\"\\\"X3D\\\"\"\>", 
       13->"\<\"\\\"ZPR\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"3D Geometry & Modeling Formats\"\>", 
       2->"\<\"Graphics Importing & Exporting\"\>", 
       3->"\<\"Importing & Exporting\"\>", 
       4->"\<\"Listing of All Formats\"\>", 
       5->"\<\"New in 6.0: Import & Export Formats\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "LWO ",
 StyleBox["(.lwo)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->12097],

Cell[TextData[{
 "MIME type: ",
 StyleBox["image/x-lwo ", "InlineCode"],
 "\nLightWave 3D object file format.\nNative format of the LightWave 3D \
rendering and animation software.\nLWO is an acronym for LightWave Object.\n\
Developed by NewTek.\nBinary format.\nStores 3D objects as a collections of \
polygons and their properties."
}], "FormatUsage",
 CellID->28118],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " are fully compatible with the LWO2 format."
}], "FormatNotes",
 CellID->24390],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support the point, line, and polygon content of LWO2 files. ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " also reads LWO2 patch data."
}], "FormatNotes",
 CellID->1507129624]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->15199],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"MR\"]\)\!\(\*
StyleBox[\"lwo\", \"MR\"]\)\>\"", "]"}]], "InlineFormula"],
 "imports an LWO file as a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object."
}], "FormatNotes",
 CellID->11785],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).lwo\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " expression to an LWO file."
}], "FormatNotes",
 CellID->14486],

Cell["", "WeakDivider",
 CellID->19199],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).lwo\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "[", " ", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    StyleBox[
     RowBox[{"vertices", ",", "polygons"}], "TI"], "]"}], "]"}]], 
  "InlineFormula"],
 ". "
}], "FormatNotes",
 CellID->12420],

Cell["\<\
The vertices are given as a list of coordinates, and the polygons are \
represented as integer indices taken to be the corresponding vertices. \
\>", "FormatNotes",
 CellID->1591577617],

Cell["", "WeakDivider",
 CellID->20710],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).lwo\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an LWO file."
}], "FormatNotes",
 CellID->18271],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).lwo\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->15813],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).lwo\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->27415],

Cell[TextData[{
 "The import format can be specified with",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""}]], "InlineFormula"],
 ",",
 Cell[BoxData["\"\<LWO\>\""], "InlineFormula"],
 "] or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<LWO\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->6085],

Cell["", "WeakDivider",
 CellID->318],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).lwo\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates an LWO file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->3580],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).lwo\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1331],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).lwo\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7267],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).lwo\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->8387],

Cell["", "WeakDivider",
 CellID->13444],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->23186],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the LWO",
 " ",
 "format."
}], "FormatNotes",
 CellID->14507]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->4360],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17827],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->28074],

Cell["", "WeakDivider",
 CellID->26431],

Cell["Data representation elements:", "FormatNotes",
 CellID->7152],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "LWO file represented as a ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsComplex\>\"", Cell[
    TextData[{
     "LWO file given as a ",
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonData\>\"", Cell[TextData[{
     "list of polygon indices, referencing the vertices given by ",
     Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexData\>\"", Cell[
    "list of vertex coordinates", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PointObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Point",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Point"]], "InlineFormula"],
     " primitives specified with absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LineObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Line",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Line"]], "InlineFormula"],
     " primitives specified with absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " primitives specified with absolute coordinates"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->30271],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Graphics3D\>\""], "InlineFormula"],
 " element by default for LWO files."
}], "FormatNotes",
 CellID->10268],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<PolygonData\>\""], "InlineFormula"],
 " elements correspond to the arguments of ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->4693]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1911960202],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what background color to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall size of the graphics to display", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Lighting",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Lighting"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what simulated lighting to use in coloring 3D surfaces", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->2123520593],

Cell[TextData[{
 "All options of ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " can be given when importing from LWO."
}], "FormatNotes",
 CellID->1022956994],

Cell["Advanced options:", "FormatNotes",
 CellID->2132824898],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<VerticalAxis\>\"", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}], Cell["\<\
orientation to assume for the coordinate system used in the file\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->28047],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that in the coordinate system used by LWO the vertical axis \
corresponds to the third coordinate."
}], "FormatNotes",
 CellID->1642809193],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<VerticalAxis\>\"", "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will apply the transformation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     RowBox[{"-", 
      StyleBox["z", "TI"]}], ",", 
     StyleBox["y", "TI"]}], "}"}], " "}]], "InlineFormula"],
 "to all graphics coordinates when importing from LWO, and the inverse \
transformation when exporting to LWO."
}], "FormatNotes",
 CellID->182941150]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->19413],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<3DS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/3DS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<BYU\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/BYU"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JVX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JVX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PLY\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PLY"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Maya\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Maya"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OBJ\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OBJ"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<POV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/POV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<RIB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/RIB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<STL\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/STL"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<VRML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/VRML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<X3D\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/X3D"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ZPR\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ZPR"]], "InlineFormula"]
}], "SeeAlso",
 CellID->290304992]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->53798033],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->701956363],

Cell["Import an LWO example file:", "ExampleText",
 CellID->1737630772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/cuboids.lwo\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17537],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[None], GraphicsComplex3DBox[CompressedData["
1:eJyNlcFNw0AURL9ASL64CGpIAaQGSkDiTD3c6CQugzK4cyGL5GT+7NvvXSkg
P5nRkz1hnt8+Xt8fIuL7+nmM/fy8XH+cT6ffi13P8P3ac5y33xe7Vq65M9xz
vj4/nzbwPOLuOeLtbPk6cfAsOfivA8+Sgz/y61kG/svAs+SeIz2Jc2B/kLfn
fYYc53F/70F8v997MuKeIz1JnkfcPUe8Hc1xDp4lB/9VOfQHOfgjj/t7d/9l
4Flyz5GeLHr/EW++lOM87u99Ib7fD/1B7jnSk+R5xN1zxNvRHOfgWXLwX5VD
f5CDP/K4v3f3X/R+6A9yybn1WndBe1dxfS4Vj353Etf3OsM9x3dqv/+Iu+eI
t6M5zsGz5OCfdko8Sw7+yKPfncTBs+Se4zsF/UGuz6Xi0e9O4vpeZ7jn+E5B
f5C754i3s9m1cvAsOfinnYL+IAd/5NHvTuLgWXLP8Z2C/iCX/5Pen8Sj3x3v
z2qeJfcc3ynoD3L3HPF2NMc5eJYc/NNOQX+Qgz/yGOxO2E5Bf5BLzm1XbafW
Ga67WPHodydx3fUZ7jmwU+sMd88Rb0dznINnycHfd2qd4eCPPPrdSRw8S+45
sFPeH+Tay4pHvzuJ6/dqhnsO7JT3B7l7jng7muMcPEsO/r5T3h/k4I88+t1J
HDxL7jmwU94f5Jpb8eh3x/tzey4z3HNgp7w/yN1zxNvZ8rX3xz1LDv6+U94f
5OCPPAa7E9HtlPcH+f/f/wGCC7kw
    "], Polygon3DBox[{{4, 3, 2, 1}, {8, 7, 6, 5}, {1, 2, 8, 5}, {2, 3, 7, 
     8}, {3, 4, 6, 7}, {4, 1, 5, 6}, {12, 11, 10, 9}, {16, 15, 14, 13}, {9, 
     10, 16, 13}, {10, 11, 15, 16}, {11, 12, 14, 15}, {12, 9, 13, 14}, {20, 
     19, 18, 17}, {24, 23, 22, 21}, {17, 18, 24, 21}, {18, 19, 23, 24}, {19, 
     20, 22, 23}, {20, 17, 21, 22}, {28, 27, 26, 25}, {32, 31, 30, 29}, {25, 
     26, 32, 29}, {26, 27, 31, 32}, {27, 28, 30, 31}, {28, 25, 29, 30}, {36, 
     35, 34, 33}, {40, 39, 38, 37}, {33, 34, 40, 37}, {34, 35, 39, 40}, {35, 
     36, 38, 39}, {36, 33, 37, 38}, {44, 43, 42, 41}, {48, 47, 46, 45}, {41, 
     42, 48, 45}, {42, 43, 47, 48}, {43, 44, 46, 47}, {44, 41, 45, 46}, {52, 
     51, 50, 49}, {56, 55, 54, 53}, {49, 50, 56, 53}, {50, 51, 55, 56}, {51, 
     52, 54, 55}, {52, 49, 53, 54}, {60, 59, 58, 57}, {64, 63, 62, 61}, {57, 
     58, 64, 61}, {58, 59, 63, 64}, {59, 60, 62, 63}, {60, 57, 61, 62}, {68, 
     67, 66, 65}, {72, 71, 70, 69}, {65, 66, 72, 69}, {66, 67, 71, 72}, {67, 
     68, 70, 71}, {68, 65, 69, 70}, {76, 75, 74, 73}, {80, 79, 78, 77}, {73, 
     74, 80, 77}, {74, 75, 79, 80}, {75, 76, 78, 79}, {76, 73, 77, 78}, {84, 
     83, 82, 81}, {88, 87, 86, 85}, {81, 82, 88, 85}, {82, 83, 87, 88}, {83, 
     84, 86, 87}, {84, 81, 85, 86}, {92, 91, 90, 89}, {96, 95, 94, 93}, {89, 
     90, 96, 93}, {90, 91, 95, 96}, {91, 92, 94, 95}, {92, 89, 93, 94}, {100, 
     99, 98, 97}, {104, 103, 102, 101}, {97, 98, 104, 101}, {98, 99, 103, 
     104}, {99, 100, 102, 103}, {100, 97, 101, 102}, {108, 107, 106, 105}, {
     112, 111, 110, 109}, {105, 106, 112, 109}, {106, 107, 111, 112}, {107, 
     108, 110, 111}, {108, 105, 109, 110}, {116, 115, 114, 113}, {120, 119, 
     118, 117}, {113, 114, 120, 117}, {114, 115, 119, 120}, {115, 116, 118, 
     119}, {116, 113, 117, 118}, {124, 123, 122, 121}, {128, 127, 126, 125}, {
     121, 122, 128, 125}, {122, 123, 127, 128}, {123, 124, 126, 127}, {124, 
     121, 125, 126}, {132, 131, 130, 129}, {136, 135, 134, 133}, {129, 130, 
     136, 133}, {130, 131, 135, 136}, {131, 132, 134, 135}, {132, 129, 133, 
     134}, {140, 139, 138, 137}, {144, 143, 142, 141}, {137, 138, 144, 141}, {
     138, 139, 143, 144}, {139, 140, 142, 143}, {140, 137, 141, 142}, {148, 
     147, 146, 145}, {152, 151, 150, 149}, {145, 146, 152, 149}, {146, 147, 
     151, 152}, {147, 148, 150, 151}, {148, 145, 149, 150}, {156, 155, 154, 
     153}, {160, 159, 158, 157}, {153, 154, 160, 157}, {154, 155, 159, 160}, {
     155, 156, 158, 159}, {156, 153, 157, 158}, {164, 163, 162, 161}, {168, 
     167, 166, 165}, {161, 162, 168, 165}, {162, 163, 167, 168}, {163, 164, 
     166, 167}, {164, 161, 165, 166}, {172, 171, 170, 169}, {176, 175, 174, 
     173}, {169, 170, 176, 173}, {170, 171, 175, 176}, {171, 172, 174, 175}, {
     172, 169, 173, 174}, {180, 179, 178, 177}, {184, 183, 182, 181}, {177, 
     178, 184, 181}, {178, 179, 183, 184}, {179, 180, 182, 183}, {180, 177, 
     181, 182}, {188, 187, 186, 185}, {192, 191, 190, 189}, {185, 186, 192, 
     189}, {186, 187, 191, 192}, {187, 188, 190, 191}, {188, 185, 189, 190}, {
     196, 195, 194, 193}, {200, 199, 198, 197}, {193, 194, 200, 197}, {194, 
     195, 199, 200}, {195, 196, 198, 199}, {196, 193, 197, 198}, {204, 203, 
     202, 201}, {208, 207, 206, 205}, {201, 202, 208, 205}, {202, 203, 207, 
     208}, {203, 204, 206, 207}, {204, 201, 205, 206}, {212, 211, 210, 209}, {
     216, 215, 214, 213}, {209, 210, 216, 213}, {210, 211, 215, 216}, {211, 
     212, 214, 215}, {212, 209, 213, 214}}]]},
  Boxed->False]], "Output",
 CellLabel->"Out[1]=",
 CellID->168756042]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->707841354],

Cell[TextData[{
 "Create a solid 3D object using ",
 Cell[BoxData[
  ButtonBox["RegionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1777715945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"x", " ", "y", " ", "z"}], "]"}], "<", "4"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "False"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<RoseColors\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131906904],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJztnU+LpEkRxqtV+iQsvcwXEFY/wl4zr3r0OrcBj+t+FxU/yuqt+uJhQVAE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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwt1mlQVlUYwPH33HtBQctKnawpE0kEl7TgU5bmBzcULbV0milRSzNkRx3Q
sDKJNEXFhVJHQaFYtMgVxxFEY7dSyrRFzQ0XtBEtt5D+Z57nw2/Oe84959yz
PvcNmhY/Ps7x+Xw1cPGK8fkyMRSDyH+NHijGUIQhCHl4ChtptAGb8JXWL8QB
TEE00nnBffprRRsW2hciV/vZgm89n68ExSjENyhCMr5DCtbRxg/tkE+brSjA
y/Q5DIONlIegOwKol4NAGNsPY8xDAL8D0QHnyd/ABfyJ33ASv+IPnMAu+Nux
kT5G2hld8Ag64VEU8OyursMDtNnFpPw/0vtoRTtP+mnvyRj2UrbdlbUtQgm2
UV6G7UhnPj8jGft0HUpRizrU4zrPZjO/v0mryVehBrMou0DZJZRhr+0DpZiG
t1GOChy076B+C+ktTOb3D6RVqMMkR+rEoBKzMAXFeBO7sBt7cAcp1L9LukzH
k4Gj5H/CMTsn8r/gOI6Qn4cEzEUDYm092waNnqxJEhJxkmcfYgFOYxEy7G/W
8WMsQhTvP0zZAZ3jGPL7SZfgLJbqmIMpLyF9g34nYTLCHFmrHbiCLKxENq5i
NRp5RyISkITjSMYnOIsM/Mhe1qFB70I1yvWepWAO6lGBSqRq/TS0IJT3XCbt
T3qTtBkL6dfAcaW8H56DH/lMe750DB9gAdJ0Tebbs8m80u1ZdGQMR1CLjyhb
rus2EDsQjH0IRwh6IB+PIwfZWIUsLNb5FqHQlTtSgm16tpdgDZait5F5heFT
vKR39jDPDuF7lCIUT+q924nd2OPKfSlDJcZiCEajHINRhWrU2L6MnAF7hmfo
fr2n+zUbMRjJfnf05J7a36MQiYmYgNfhh2Ge3N8Zul8zMVzLR2AAXsRADEIE
wrGSNs26Vpf0bPyFc/hc18Se2yacQQuu4oorscWO4SFPzqeNOQ/jsiv92zrB
zK0nnjXyu4lxndd42Er6AG0YQt6HVNrcZv/v4AxS7JgciXt96PMUaTxOUXYa
F23sp9050t4874dQPGOkPEj3ritlFaTdPFn/g66syUWNq/096T/Mk35sXP3d
7hXta1CLzeRzXYnPUbq/4zBd49U7Rt77Lp7GF/gXXyIRSRon4xGn8WQ0xtn7
jz42TqKXkfiZhUy7RxpnlsPjffccuSMrqLdO7/5riMJYGP0GOeig5R01pmVj
hSf1N2K8kY9qgN7Ze+SvGYnVkUb2xX5n1+IzjUs3jXwrb+kcV2nMseMZjhF2
v+mrl97N9TrHV+16MCbXlf0dqW1H6ToEIBCHdH3et+Omrr/GjRf0vke48v2N
Q6wncT4aUzFTz1t3LMYyjb3zkaYx2d7HSIzBP7qGOTZ2OnL2muGPLZRtNfJ/
4LaR70U+2vOswMi324WHRvJvOXJOUhGhcS+ashNGvinhmKOxpQk3jHz7Nhl5
12Z0Y0xPaGyxsW4AnnflLjSgHl3Jd9FYF6//SRLQk3yQxsYYPUuxOuZc5OnZ
64sQey8cuUdVjsTe67iG/wG5oT5G
         "]], Polygon3DBox[CompressedData["
1:eJxNmnn81lPax7/3/V1UY8YwYWpkMDIakfmRGVqUmtImbShJPKOFRmlV2hct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         "]], Polygon3DBox[CompressedData["
1:eJxF1nlwD2cYwPHd324ScfVSKlWkSRBHHKFTDUrryoEQgsy0jE6VSpMicUXQ
klCmjqBoq2mUCqXtSBVxp+Kqqyi9XCkRiVJJhMSRfp95n5n+8Znd991332vf
93nXf1TioASPZVmL4QV/x7JC0BbtEIAVtmXdRRmKsQSh5HdAJwSiGbZjG3Kx
Cd/iVcpGoC98YCEL6/A1YjEYGyibgx+wFd+gK8IRgUh0w2PKVuAeqqU+Ov86
1/lYgI/wGnZqXTk6jvbIdqkXm5CIeLxJ2VF4C43ghyFYi6+QiRgMouxQxKIu
aiGIOr/TsebqHPhSNhJR6ANv9MIiLMRcdMOn+AKrMRD9Be/3QzS6y9zhefJH
YgTiUB8XGfMB5OECLmES+e8hHi3RHMlIss0zSQfjKFN2EqcwE9MwgPzP8DlW
at+j9F6+/WIdSyplT+A4DiMZKeRPxyy8hE6ooj+3cQuVeIB7KEExKnAfYZRN
QzpmozNmYCImoAPaIRHvYzJaoxUysErnUeYuXJ9JmSmYihBcoZ2TOIbLKPCY
tZura3UPOqK3jnOJfiv5ZrJ2ZF2ux4u6F8K1vX6ohRq6vpdimfZL1vo8LNd8
ed4D7yJBx9MMgbCp8y59KpdNyL1H2iL/HYzRd6RcAuttAzZiPcahDvnRtvl+
suZqIkjXwDiMhb/2VdbYINRFbX02Gm+jiZarpO0q3MNqZGIo/YpEFPZSZr/0
ia7uRx72YTR86M8A9EEveEn/EIPBiEYNlFjm+8m3aoObsgbJ344d2IzxqJY9
zzUcfWGhtt5HYCBqYgtysRMpSMJN3i1DOVYiAwdkHhhDfwzDQdKluGGbmCax
rRybHdOO1O3rmhhWR/vu7ZrY9KPsT+poigBs5b1tthl3b/TEQ8o8wt90vanO
8QuyHklvl73Ie63RA7mkv5fY5vw/TulHkH4Xeb+QR9fQ2DbrIwBXSRfgDmU7
884raItrsqa5hqELSkkXYzj3Q/SbPImnJB7y/ibkoCd64EPKXsJl/IkUXMQV
FGAOpuOB7Ff6n4qJHjN/p8n/FecwAePwJXWuxTrpPxpiPPlncBYnMAZ/4IK2
JfVPxgjK7sFe7MYbck7R1gp8gvnwoBH5a5CFTDTADR13CRZjERaiENd1jLPx
jMb1YYhDPdeMWcb+F85jEpbjFv6V74oFuOqY+S7Uuj+WfPqzCivhCxfxEqOR
jCrm6bZt5rLIMf2UvqUjieezMNNjzrdKHCL/OfrUAH44TLoh1/p4FgdI5+v5
66tnk5xRO0gv5XoW5/AbluE8zuAXLEEGplA2FTMcE7P/QQvumyNY2oefY+L4
VK7TkIybHrOPJdZ2lD3EvJfJMc99d4178g9QTV49yjdGEzRFA3jLPqGOh/Di
3gctbHNeyTlWLN/RMv1Kw1y4jjlTNjomzsg+e4Bsx/wXlEhcwX2dP0lLfoWe
GRKnD/LeIeQjDemuWc8SB+Rf5yEeIdQ256b0qVT2mu4PGb/Mwwe6htJ07lJ1
f8i3dDBLy0hZOfMkhvhofJT+y3/OI+rsapv/gi7SNunrltnjgXpWFFnm7PgJ
+ThumzPxBE5qWvIlrmVJ29TvgY01Mm9cj+EojmCexEzK5mGfbWL7LtusG9kP
T2O3Y9aQxJR2aO+afSNr/Q5lJzCeRIxFEekOPA91Tey5oWt7F57QeCNxVGKn
l23OWzljZdyPGVtLnrVBiGvijMSALeRvQDbC8LLsf9qKQSwO8e4R28T2fJ2b
3dgjc0Y9wa6pV2LK7xrPWpFujeau2d/HdPx5embKP5TseXneQv7xZN84poyU
/RlH9Rw8heH0Iw4jcZr0f2G4cVc=
         "]], 
        Polygon3DBox[{{793, 928, 930, 946, 945, 794}, {904, 913, 914, 915, 
         780, 775}, {168, 167, 163, 162, 33, 32}, {933, 934, 927, 924, 789, 
         791}, {38, 165, 166, 170, 171, 41}, {777, 906, 907, 908, 895, 770}, {
         846, 962, 961, 967, 966, 847}, {1138, 1197, 1198, 1199, 1193, 
         1133}, {116, 200, 201, 199, 190, 96}, {876, 882, 883, 884, 736, 
         715}, {419, 518, 519, 517, 513, 416}, {515, 521, 522, 520, 421, 
         418}, {192, 203, 204, 202, 121, 103}, {438, 437, 428, 427, 351, 
         353}, {354, 433, 435, 440, 441, 356}, {1167, 1225, 1227, 1237, 1236, 
         1168}, {1196, 1200, 1201, 1202, 1139, 1136}, {378, 465, 466, 472, 
         473, 380}, {963, 964, 960, 959, 843, 844}, {1233, 1234, 1224, 1222, 
         1165, 1166}, {482, 494, 495, 493, 406, 395}, {468, 467, 457, 456, 
         369, 371}, {397, 487, 488, 485, 479, 390}, {734, 879, 880, 881, 870, 
         710}}]}]}, 
     {EdgeForm[None], 
      GraphicsGroup3DBox[{
        Polygon3DBox[{{34, 36, 35}, {523, 525, 524}, {432, 434, 436}, {1272, 
         1273, 1274}, {469, 471, 470}, {474, 476, 475}, {483, 484, 496}, {429,
          430, 426}, {785, 790, 923}, {786, 931, 796}, {916, 782, 781}, {862, 
         863, 973}, {1268, 1270, 1269}, {859, 860, 969}, {714, 877, 718}, {
         778, 779, 905}, {97, 98, 115}, {871, 712, 711}, {1319, 1309, 1308}, {
         486, 481, 480}, {529, 528, 527}, {100, 104, 120}, {42, 40, 39}, {
         1311, 1322, 1313}}], Polygon3DBox[CompressedData["
1:eJxNl3dslVUYh7/7ffdeUGSUUlosU4YoVqiMlkaUqBCIBAFRqiJCaZ1x/aEY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         "]], 
        Polygon3DBox[{{98, 99, 119, 118, 115}, {524, 525, 683, 682, 681}, {
         475, 476, 478, 386, 385}, {551, 714, 718, 717, 554}, {40, 42, 66, 67,
          64}, {381, 383, 477, 471, 469}, {528, 529, 686, 687, 685}, {99, 100,
          120, 123, 119}, {386, 478, 484, 483, 396}, {35, 36, 62, 61, 60}, {
         423, 424, 526, 525, 523}, {548, 709, 711, 712, 549}, {383, 388, 480, 
         481, 477}, {1269, 1270, 1271, 1266, 1265}, {1266, 1271, 1273, 1272, 
         1267}, {426, 430, 431, 348, 347}, {1289, 1311, 1313, 1312, 1291}, {
         424, 425, 527, 528, 526}, {861, 862, 973, 972, 971}, {1310, 1321, 
         1323, 1322, 1311}, {1309, 1319, 1320, 1321, 1310}, {712, 871, 873, 
         874, 713}, {713, 874, 878, 877, 714}, {860, 861, 971, 970, 969}, {
         1273, 1289, 1291, 1290, 1274}, {685, 687, 864, 863, 862}, {616, 786, 
         796, 795, 622}, {682, 683, 860, 859, 858}, {610, 776, 781, 782, 
         612}, {29, 31, 39, 40, 37}, {607, 611, 779, 778, 767}, {348, 431, 
         434, 432, 349}, {782, 916, 921, 922, 784}, {783, 785, 923, 926, 
         919}, {1285, 1286, 1287, 1270, 1268}, {546, 548, 549, 430, 429}, {
         434, 551, 554, 552, 436}, {609, 610, 612, 476, 474}, {470, 471, 611, 
         607, 606}, {779, 783, 919, 918, 905}, {481, 486, 618, 619, 615}, {61,
          62, 98, 97, 94}, {784, 922, 932, 931, 786}, {615, 619, 787, 790, 
         785}, {1286, 1307, 1308, 1309, 1287}, {484, 616, 622, 621, 496}, {64,
          67, 101, 104, 100}, {27, 29, 37, 36, 34}}]}]}, {}, {}, {}}, {{
      Line3DBox[{4, 1339, 1340, 1341, 1342, 1343, 1344, 1345, 1346, 1347, 
       1348, 1349, 1350, 1351, 1352, 1353, 1354, 1355, 1356, 1357, 1358, 1359,
        1360, 1361, 1362, 1363, 1364, 1365, 1366, 1367, 1368, 1369, 1370, 
       1371, 1372, 1373, 1374, 1375, 1377, 4}], 
      Line3DBox[{8, 1381, 1382, 1383, 1384, 1385, 1386, 1387, 1388, 1389, 
       1390, 1391, 1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399, 1400, 1401,
        1402, 1403, 1404, 1405, 1406, 1407, 1408, 1409, 1410, 1411, 1412, 
       1413, 1414, 1415, 1416, 1417, 1419, 8}], 
      Line3DBox[{84, 1423, 1424, 1425, 1426, 1427, 1428, 1429, 1430, 1431, 
       1432, 1433, 1434, 1435, 1436, 1437, 1438, 1439, 1440, 1441, 1442, 1443,
        1444, 1445, 1446, 1447, 1448, 1449, 1450, 1451, 1452, 1453, 1454, 
       1455, 1456, 1457, 1458, 1459, 1461, 84}], 
      Line3DBox[{114, 1465, 1466, 1467, 1468, 1469, 1470, 1471, 1472, 1473, 
       1474, 1475, 1476, 1477, 1478, 1479, 1480, 1481, 1482, 1483, 1484, 1485,
        1486, 1487, 1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 
       1497, 1498, 1499, 1500, 1501, 1503, 114}], 
      Line3DBox[{698, 1510, 1511, 1512, 1513, 1514, 1515, 1516, 1517, 1518, 
       1519, 1520, 1521, 1522, 1523, 1524, 1525, 1526, 1527, 1528, 1529, 1530,
        1531, 1532, 1533, 1534, 1535, 1536, 1537, 1538, 1539, 1540, 1541, 
       1542, 1543, 1544, 1545, 1546, 1548, 698}], 
      Line3DBox[{726, 1552, 1553, 1554, 1555, 1556, 1557, 1558, 1559, 1560, 
       1561, 1562, 1563, 1564, 1565, 1566, 1567, 1568, 1569, 1570, 1571, 1572,
        1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583, 
       1584, 1585, 1586, 1587, 1588, 1590, 726}], 
      Line3DBox[{854, 1594, 1595, 1596, 1597, 1598, 1599, 1600, 1601, 1602, 
       1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 1611, 1612, 1613, 1614,
        1615, 1616, 1617, 1618, 1619, 1620, 1621, 1622, 1623, 1624, 1625, 
       1626, 1627, 1628, 1629, 1630, 1632, 854}], 
      Line3DBox[{852, 1636, 1637, 1638, 1639, 1640, 1641, 1642, 1643, 1644, 
       1645, 1646, 1647, 1648, 1649, 1650, 1651, 1652, 1653, 1654, 1655, 1656,
        1657, 1658, 1659, 1660, 1661, 1662, 1663, 1664, 1665, 1666, 1667, 
       1668, 1669, 1670, 1671, 1672, 1674, 852}]}, {
      Line3DBox[{3, 1378, 1379, 1380, 1418, 153, 221, 281, 349, 432, 436, 552,
        555, 558, 561, 564, 1549, 1550, 1551, 1589, 724, 722, 720, 717, 718, 
       877, 878, 977, 1057, 1125, 1185, 1676, 1253, 1251, 1183, 1123, 1055, 
       975, 873, 871, 711, 709, 707, 705, 703, 700, 701, 534, 533, 530, 537, 
       540, 543, 546, 429, 426, 347, 279, 219, 151, 3}], 
      Line3DBox[{1376, 1, 12, 17, 22, 27, 34, 35, 60, 57, 54, 51, 45, 1420, 
       1421, 1422, 1460, 88, 90, 92, 94, 97, 115, 118, 124, 129, 134, 139, 
       1504, 1506, 149, 143, 138, 133, 128, 123, 120, 104, 101, 105, 107, 109,
        111, 113, 82, 81, 78, 75, 72, 69, 66, 42, 39, 31, 26, 21, 16, 10, 11, 
       5, 1376}], 
      Line3DBox[{46, 43, 173, 237, 303, 381, 469, 470, 606, 596, 584, 572, 
       532, 1507, 1508, 1509, 1547, 729, 743, 755, 767, 778, 905, 918, 1005, 
       1077, 1141, 1203, 1678, 1679, 1303, 1218, 1154, 1090, 1016, 926, 923, 
       790, 787, 797, 811, 825, 837, 853, 674, 672, 658, 646, 634, 624, 618, 
       486, 480, 388, 314, 250, 186, 86, 87, 48, 46}], 
      Line3DBox[{80, 1462, 1463, 1464, 1502, 198, 260, 324, 396, 483, 496, 
       621, 631, 643, 655, 669, 1633, 1634, 1635, 1673, 836, 824, 810, 795, 
       796, 931, 932, 1028, 1102, 1164, 1232, 1682, 1301, 1300, 1215, 1151, 
       1087, 1013, 921, 916, 781, 776, 766, 754, 742, 727, 728, 569, 567, 568,
        581, 593, 603, 609, 474, 475, 385, 311, 247, 183, 80}], 
      Line3DBox[{144, 145, 215, 275, 343, 423, 523, 524, 681, 679, 677, 675, 
       671, 1591, 1592, 1593, 1631, 855, 856, 857, 858, 859, 969, 970, 1051, 
       1119, 1179, 1247, 1684, 1685, 1338, 1249, 1181, 1121, 1053, 972, 973, 
       863, 864, 865, 866, 867, 868, 869, 697, 696, 694, 692, 690, 688, 686, 
       529, 527, 425, 345, 277, 217, 148, 1505, 146, 144}], 
      Line3DBox[{1250, 1675, 1677, 1254, 1255, 1258, 1261, 1264, 1267, 1272, 
       1274, 1290, 1292, 1294, 1296, 1298, 1681, 1683, 1318, 1317, 1316, 1315,
        1314, 1312, 1313, 1322, 1323, 1326, 1329, 1332, 1335, 1686, 1337, 
       1336, 1333, 1330, 1327, 1324, 1320, 1319, 1308, 1307, 1306, 1305, 1304,
        1302, 1680, 1277, 1275, 1276, 1279, 1281, 1283, 1285, 1268, 1269, 
       1265, 1262, 1259, 1256, 1250}]}}},
   VertexColors->CompressedData["
1:eJztXWlQVFcWRuOouLAGjIKIbEGDCgFX0FMqkmhCaB2IBldklGVQDCAoTlDH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    "],
   VertexNormals->CompressedData["
1:eJztnXvQXVV1wFOxpbXIowRpRxxJodMCw9THCNOCLBwhYKKAkKCBIJQB5DEt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    "]],
  BoxRatios->{1, 1, 1},
  Boxed->False,
  Lighting->"Neutral",
  PlotRange->{{-5, 5}, {-5, 5}, {-5, 5}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1612210698]
}, Open  ]],

Cell["Export the previous output to LWO:", "ExampleText",
 CellID->1978291486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<model.lwo\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->843903022],

Cell[BoxData["\<\"model.lwo\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1496085966]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LWO - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 4.1840194}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: image/x-lwo LightWave 3D object file format. Native format of \
the LightWave 3D rendering and animation software. LWO is an acronym for \
LightWave Object. Developed by NewTek. Binary format. Stores 3D objects as a \
collections of polygons and their properties.", "synonyms" -> {}, "title" -> 
    "LWO", "type" -> "Format", "uri" -> "ref/format/LWO"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[24032, 823, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 70525, 1633}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3182, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3805, 91, 102, 4, 70, "ObjectNameAlt",
 CellID->12097],
Cell[3910, 97, 369, 8, 70, "FormatUsage",
 CellID->28118],
Cell[4282, 107, 337, 12, 70, "FormatNotes",
 CellID->24390],
Cell[4622, 121, 508, 17, 70, "FormatNotes",
 CellID->1507129624]
}, Open  ]],
Cell[CellGroupData[{
Cell[5167, 143, 64, 1, 70, "ImportExportSection",
 CellID->15199],
Cell[5234, 146, 469, 16, 70, "FormatNotes",
 CellID->11785],
Cell[5706, 164, 460, 16, 70, "FormatNotes",
 CellID->14486],
Cell[6169, 182, 39, 1, 70, "WeakDivider",
 CellID->19199],
Cell[6211, 185, 662, 23, 70, "FormatNotes",
 CellID->12420],
Cell[6876, 210, 195, 4, 70, "FormatNotes",
 CellID->1591577617],
Cell[7074, 216, 39, 1, 70, "WeakDivider",
 CellID->20710],
Cell[7116, 219, 342, 11, 70, "FormatNotes",
 CellID->18271],
Cell[7461, 232, 574, 20, 70, "FormatNotes",
 CellID->15813],
Cell[8038, 254, 582, 21, 70, "FormatNotes",
 CellID->27415],
Cell[8623, 277, 693, 25, 70, "FormatNotes",
 CellID->6085],
Cell[9319, 304, 37, 1, 70, "WeakDivider",
 CellID->318],
Cell[9359, 307, 514, 18, 70, "FormatNotes",
 CellID->3580],
Cell[9876, 327, 1075, 40, 70, "FormatNotes",
 CellID->1331],
Cell[10954, 369, 661, 22, 70, "FormatNotes",
 CellID->7267],
Cell[11618, 393, 815, 28, 70, "FormatNotes",
 CellID->8387],
Cell[12436, 423, 39, 1, 70, "WeakDivider",
 CellID->13444],
Cell[12478, 426, 361, 14, 70, "FormatNotes",
 CellID->23186],
Cell[12842, 442, 352, 14, 70, "FormatNotes",
 CellID->14507]
}, Closed]],
Cell[CellGroupData[{
Cell[13231, 461, 50, 1, 70, "ElementsSection",
 CellID->4360],
Cell[13284, 464, 192, 8, 70, "FormatNotes",
 CellID->17827],
Cell[13479, 474, 668, 13, 70, "2ColumnTableMod",
 CellID->28074],
Cell[14150, 489, 39, 1, 70, "WeakDivider",
 CellID->26431],
Cell[14192, 492, 67, 1, 70, "FormatNotes",
 CellID->7152],
Cell[14262, 495, 2151, 56, 70, "2ColumnTableMod",
 CellID->30271],
Cell[16416, 553, 397, 14, 70, "FormatNotes",
 CellID->10268],
Cell[16816, 569, 365, 12, 70, "FormatNotes",
 CellID->4693]
}, Open  ]],
Cell[CellGroupData[{
Cell[17218, 586, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[17270, 589, 196, 8, 70, "FormatNotes",
 CellID->1911960202],
Cell[17469, 599, 1155, 31, 70, "3ColumnTableMod",
 CellID->2123520593],
Cell[18627, 632, 240, 8, 70, "FormatNotes",
 CellID->1022956994],
Cell[18870, 642, 61, 1, 70, "FormatNotes",
 CellID->2132824898],
Cell[18934, 645, 468, 12, 70, "3ColumnTableMod",
 CellID->28047],
Cell[19405, 659, 232, 7, 70, "FormatNotes",
 CellID->1642809193],
Cell[19640, 668, 759, 26, 70, "FormatNotes",
 CellID->182941150]
}, Closed]],
Cell[CellGroupData[{
Cell[20436, 699, 50, 1, 70, "SeeAlsoSection",
 CellID->19413],
Cell[20489, 702, 2673, 90, 70, "SeeAlso",
 CellID->290304992]
}, Open  ]],
Cell[CellGroupData[{
Cell[23199, 797, 57, 1, 70, "MoreAboutSection",
 CellID->53798033],
Cell[23259, 800, 150, 2, 70, "MoreAbout"],
Cell[23412, 804, 151, 2, 70, "MoreAbout"],
Cell[23566, 808, 134, 2, 70, "MoreAbout"],
Cell[23703, 812, 133, 2, 70, "MoreAbout"],
Cell[23839, 816, 156, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24032, 823, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[24148, 829, 60, 1, 70, "ExampleSection",
 CellID->701956363],
Cell[24211, 832, 71, 1, 70, "ExampleText",
 CellID->1737630772],
Cell[CellGroupData[{
Cell[24307, 837, 128, 3, 70, "Input",
 CellID->17537],
Cell[24438, 842, 4456, 64, 70, "Output",
 CellID->168756042]
}, Open  ]],
Cell[28909, 909, 125, 3, 70, "ExampleDelimiter",
 CellID->707841354],
Cell[29037, 914, 223, 8, 70, "ExampleText",
 CellID->1777715945],
Cell[CellGroupData[{
Cell[29285, 926, 697, 21, 70, "Input",
 CellID->131906904],
Cell[29985, 949, 38966, 635, 70, "Output",
 CellID->1612210698]
}, Open  ]],
Cell[68966, 1587, 78, 1, 70, "ExampleText",
 CellID->1978291486],
Cell[CellGroupData[{
Cell[69069, 1592, 141, 4, 70, "Input",
 CellID->843903022],
Cell[69213, 1598, 88, 2, 70, "Output",
 CellID->1496085966]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[69340, 1605, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

