(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29502,       1002]
NotebookOptionsPosition[     24833,        855]
NotebookOutlinePosition[     26370,        896]
CellTagsIndexPosition[     26285,        891]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"ExpressionML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/ExpressionML"], 
          "\"HTML\"" :> Documentation`HelpLookup["paclet:ref/format/HTML"], 
          "\"MathML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/MathML"], "\"Package\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Package"], "\"TeX\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TeX"], "\"XHTML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/XHTML"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"ExpressionML\\\"\"\>", 
       2->"\<\"\\\"HTML\\\"\"\>", 3->"\<\"\\\"MathML\\\"\"\>", 
       4->"\<\"\\\"Package\\\"\"\>", 5->"\<\"\\\"TeX\\\"\"\>", 
       6->"\<\"\\\"XHTML\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Web Formats" :> 
          Documentation`HelpLookup["paclet:guide/WebFormats"], "XML Formats" :> 
          Documentation`HelpLookup["paclet:guide/XMLFormats"], 
          "XML Import & Export" :> 
          Documentation`HelpLookup["paclet:guide/XMLImportAndExport"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Importing & Exporting\"\>", 
       2->"\<\"Listing of All Formats\"\>", 3->"\<\"Web Formats\"\>", 
       4->"\<\"XML Formats\"\>", 
       5->"\<\"XML Import & Export\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "LaTeX ",
 StyleBox["(", "FilenameExtension"],
 ".tex",
 StyleBox[")", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "MIME type: ",
 StyleBox["application/x-tex", "InlineCode"],
 "\n",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " typesetting system and programming language.\nCommonly used for \
typesetting mathematical and scientific publications.\nPlain text format.\n\
Describes the contents and the layout of multi-page documents.\nBased on \
Donald Knuth's ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " typesetting system.\nDeveloped in 1985 by Leslie Lamport as a \
special-purpose derivative of ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 "."
}], "FormatUsage",
 CellID->27666],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " fully supports AMS-",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " and other variants of the ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " language."
}], "FormatNotes",
 CellID->344331575],

Cell[TextData[{
 "See the ",
 Cell[BoxData[
  RowBox[{" ", 
   ButtonBox["\"\<TeX\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/TeX"]}]]],
 " reference page for full information about ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " export capabilities.",
 Cell[BoxData[" "]],
 " "
}], "FormatNotes",
 CellID->1663388364]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tex\>\"", "]"}]], "InlineFormula"],
 " imports a ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " document and returns a notebook version of it."
}], "FormatNotes",
 CellID->28652],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tex\>\"", "]"}], " "}]], "InlineFormula"],
 "converts a ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " document to a ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " expression."
}], "FormatNotes",
 CellID->28396],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tex\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tex\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<LaTeX\>\""}], "]"}], " "}]],
   "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<LaTeX\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general information on ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "."}]], "InlineFormula"]
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " supports the ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->1615],

Cell[TextData[{
 "In the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end, ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " can be pasted directly into a notebook."
}], "FormatNotes",
 CellID->1680934938],

Cell[TextData[{
 StyleBox["Save As", "MenuName"],
 " exports the active notebook as a ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " document."
}], "FormatNotes",
 CellID->377189133],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook to ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->11064]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->1895710687],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Notebook\>\"", Cell[TextData[{
     "a ",
     Cell[BoxData[
      ButtonBox["Notebook",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
     " version of the ",
     Cell[BoxData[
      FormBox[
       StyleBox[
        RowBox[{"L", 
         StyleBox[
          AdjustmentBox["A",
           BoxBaselineShift->-0.4,
           BoxMargins->{{-0.5, -0.3}, {0, 0}}],
          FontSize->Smaller], "T", 
         AdjustmentBox["E",
          BoxBaselineShift->0.5,
          BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
        SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
     " file"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NotebookObject\>\"", Cell[TextData[{
     Cell[BoxData[
      FormBox[
       StyleBox[
        RowBox[{"L", 
         StyleBox[
          AdjustmentBox["A",
           BoxBaselineShift->-0.4,
           BoxMargins->{{-0.5, -0.3}, {0, 0}}],
          FontSize->Smaller], "T", 
         AdjustmentBox["E",
          BoxBaselineShift->0.5,
          BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
        SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
     " file represented as a ",
     Cell[BoxData[
      ButtonBox["NotebookObject",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1142129517],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by default uses the ",
 Cell[BoxData["\"\<Notebook\>\""], "InlineFormula"],
 " element when importing from ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1561955333]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->30180],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1414897565],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<InputPath\>\"", 
    RowBox[{"{", "}"}], Cell[TextData[{
     "list of directories to search for ",
     Cell[BoxData[
      FormBox[
       StyleBox[
        RowBox[{"T", 
         AdjustmentBox["E",
          BoxBaselineShift->0.5,
          BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
        SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
     " input files"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LogFile\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to create a log file for the conversion process", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<OutputFile\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "file to which to save the ",
     Cell[BoxData[
      ButtonBox["Notebook",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
     " expression"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StyleDefinitions\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " stylesheet to use in the generated notebook"
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1096951724]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<ExpressionML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ExpressionML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<HTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/HTML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MathML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Package\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Package"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TeX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TeX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XHTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XHTML"]], "InlineFormula"]
}], "SeeAlso",
 CellID->626117102]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->532038560],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Import & Export",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLImportAndExport"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->224687033],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in a ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " sample file:"
}], "ExampleText",
 CellID->650445243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/test.tex\>\"", ",", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1341435871],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Notebook\"\>", ",", "\<\"NotebookObject\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->376947909]
}, Open  ]],

Cell[TextData[{
 "Convert a ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " file to a ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " expression: "
}], "ExampleText",
 CellID->2115752313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/test.tex\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1403333001],

Cell[BoxData[
 RowBox[{"Notebook", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"TextData", "[", 
        RowBox[{"{", "\<\"Importing LaTeX  \"\>", "}"}], "]"}], 
       ",", "\<\"Section\"\>"}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"TextData", "[", 
        RowBox[{"{", 
         RowBox[{"\<\"Embedded typeset math: \"\>", ",", 
          RowBox[{"Cell", "[", 
           RowBox[{
            RowBox[{"BoxData", "[", 
             RowBox[{"FormBox", "[", 
              RowBox[{
               RowBox[{"SuperscriptBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\<\"x\"\>", ",", "\<\"TI\"\>"}], "]"}], ",", 
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\<\"n\"\>", ",", "\<\"TI\"\>"}], "]"}]}], "]"}], 
               ",", "TraditionalForm"}], "]"}], "]"}], 
            ",", "\<\"InlineFormula\"\>"}], "]"}], ",", "\<\" \"\>"}], "}"}], 
        "]"}], ",", "\<\"Text\"\>"}], "]"}], ",", 
     RowBox[{"Cell", "[", 
      RowBox[{
       RowBox[{"TextData", "[", 
        RowBox[{"{", 
         RowBox[{"\<\"Embedded PostScript:   \"\>", ",", 
          RowBox[{"Cell", "[", 
           RowBox[{
            RowBox[{"BoxData", "[", 
             RowBox[{
              RowBox[{"GraphicsBox", "[", 
               RowBox[{
                RowBox[{"RasterBox", "[", 
                 RowBox[{
                  RowBox[{
                  "CompressedData", 
                   "[", "\<\"1:eJxTTMoPymNmYGAQBGJhIAax/\
5OIcQFSzRnMeLj6kRgw0G6kph+JEScVv0TC\\\
ngyHuSFWDjL8hYRckHI2E3ZDwWSQ8VPyIjP8hYWTxK0g4AQnTwi/EuJkSPyLj\\\
n10i4FAlPQsL0jDti9JJq70Ek7IuE7yBhWqRVSsKHGPU/kTCy+Cok3IOEB9p/\\\
n5KSBTiQchoR9kPAjJDzQ/iPHj8gYV/kz2DAlfhyKeNSPwwPjAgPtLnr4caDA\\\
nQIcHPTAAPWgfoQ\[LongEqual]\[LongEqual]\"\>", "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"19", ",", "17"}], "}"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", "255"}], "}"}], ",", 
                  RowBox[{"ColorFunction", "\[Rule]", "RGBColor"}]}], "]"}], 
                ",", 
                RowBox[{"ImageSize", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"19", ",", "17"}], "}"}]}], ",", 
                RowBox[{"PlotRange", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0", ",", "19"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "17"}], "}"}]}], "}"}]}]}], "]"}], ",", 
              "StandardForm"}], "]"}], ",", "\<\"Output\"\>"}], "]"}], 
          ",", "\<\"   \"\>"}], "}"}], "]"}], ",", "\<\"Text\"\>"}], "]"}]}], 
    "}"}], ",", 
   RowBox[{
   "StyleDefinitions", "\[Rule]", "\<\"Article/LaTeX-Article.nb\"\>"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1827921064]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LaTeX - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 3.5746288}", "context" -> "", 
    "keywords" -> {"XML", "TeX", "notebook", "expression", "typesetting"}, 
    "index" -> True, "label" -> "Mathematica Import/Export Format", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MIME type: application/x-tex LATEX typesetting system and programming \
language. Commonly used for typesetting mathematical and scientific \
publications. Plain text format. Describes the contents and the layout of \
multi-page documents. Based on Donald Knuth's TEX typesetting system. \
Developed in 1985 by Leslie Lamport as a special-purpose derivative of TEX.", 
    "synonyms" -> {}, "title" -> "LaTeX", "type" -> "Format", "uri" -> 
    "ref/format/LaTeX"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[19750, 690, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26151, 884}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2299, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2922, 76, 150, 6, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[3075, 84, 1309, 41, 70, "FormatUsage",
 CellID->27666],
Cell[4387, 127, 1000, 35, 70, "FormatNotes",
 CellID->344331575],
Cell[5390, 164, 529, 20, 70, "FormatNotes",
 CellID->1663388364]
}, Open  ]],
Cell[CellGroupData[{
Cell[5956, 189, 53, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[6012, 192, 689, 23, 70, "FormatNotes",
 CellID->28652],
Cell[6704, 217, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[6746, 220, 815, 29, 70, "FormatNotes",
 CellID->28396],
Cell[7564, 251, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[7606, 254, 723, 25, 70, "FormatNotes",
 CellID->29174],
Cell[8332, 281, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[8915, 304, 707, 25, 70, "FormatNotes",
 CellID->32611],
Cell[9625, 331, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[9666, 334, 246, 8, 70, "FormatNotes",
 CellID->16216],
Cell[9915, 344, 588, 21, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[10540, 370, 69, 1, 70, "NotebookInterfaceSection",
 CellID->1615],
Cell[10612, 373, 557, 20, 70, "FormatNotes",
 CellID->1680934938],
Cell[11172, 395, 521, 18, 70, "FormatNotes",
 CellID->377189133],
Cell[11696, 415, 528, 18, 70, "FormatNotes",
 CellID->11064]
}, Closed]],
Cell[CellGroupData[{
Cell[12261, 438, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[12320, 441, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[12519, 451, 710, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[13232, 467, 184, 7, 70, "FormatNotes",
 CellID->1895710687],
Cell[13419, 476, 1685, 49, 70, "2ColumnTableMod",
 CellID->1142129517],
Cell[15107, 527, 602, 21, 70, "FormatNotes",
 CellID->1561955333]
}, Open  ]],
Cell[CellGroupData[{
Cell[15746, 553, 49, 1, 70, "OptionsSection",
 CellID->30180],
Cell[15798, 556, 197, 8, 70, "FormatNotes",
 CellID->1414897565],
Cell[15998, 566, 1637, 44, 70, "3ColumnTableMod",
 CellID->1096951724]
}, Closed]],
Cell[CellGroupData[{
Cell[17672, 615, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[17730, 618, 1251, 41, 70, "SeeAlso",
 CellID->626117102]
}, Open  ]],
Cell[CellGroupData[{
Cell[19018, 664, 58, 1, 70, "MoreAboutSection",
 CellID->532038560],
Cell[19079, 667, 134, 2, 70, "MoreAbout"],
Cell[19216, 671, 133, 2, 70, "MoreAbout"],
Cell[19352, 675, 113, 2, 70, "MoreAbout"],
Cell[19468, 679, 113, 2, 70, "MoreAbout"],
Cell[19584, 683, 129, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19750, 690, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[19866, 696, 60, 1, 70, "ExampleSection",
 CellID->224687033],
Cell[19929, 699, 610, 22, 70, "ExampleText",
 CellID->650445243],
Cell[CellGroupData[{
Cell[20564, 725, 171, 5, 70, "Input",
 CellID->1341435871],
Cell[20738, 732, 155, 5, 70, "Output",
 CellID->376947909]
}, Open  ]],
Cell[20908, 740, 602, 22, 70, "ExampleText",
 CellID->2115752313],
Cell[CellGroupData[{
Cell[21535, 766, 130, 3, 70, "Input",
 CellID->1403333001],
Cell[21668, 771, 3099, 77, 70, "Output",
 CellID->1827921064]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[24806, 853, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

