(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31658,       1105]
NotebookOptionsPosition[     25763,        914]
NotebookOutlinePosition[     27031,        951]
CellTagsIndexPosition[     26946,        946]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Basic Formats" :> 
         Documentation`HelpLookup["paclet:guide/BasicFormats"], 
         "Importing & Exporting" :> 
         Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
         "Listing of All Formats" :> 
         Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Basic Formats\"\>", 
      2->"\<\"Importing & Exporting\"\>", 
      3->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["List", "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "Column of numbers or strings.\nStores a list of numbers or strings as \
lines.\nPlain text format.\nIs essentially a single-column version of the ",
 Cell[BoxData[
  ButtonBox["\"\<Table\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Table"]], "InlineFormula"],
 " format."
}], "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " provide various data conversion and formatting options for storing lists \
of numbers or strings."
}], "FormatNotes",
 CellID->344331575],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically recognizes common number formats, including C and Fortran \
notations."
}], "FormatNotes",
 CellID->56646289],

Cell["Numbers without decimal points are imported as integers.", "FormatNotes",
 CellID->718923602]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<List\>\""}], "]"}]], 
  "InlineFormula"],
 " imports a text file, returning each line as a string or a number."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["list", "TI"], ",", "\"\<List\>\""}], "]"}]], "InlineFormula"],
 " writes any list as a column of numbers or strings."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<List\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "returns a list of strings or numbers, each representing a line of ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["list", "TI"], ",", "\"\<List\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "exports ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " as a column, writing the ",
 Cell[BoxData[
  ButtonBox["CForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CForm"]], "InlineFormula"],
 " of",
 " ",
 "each element as a separate line."
}], "FormatNotes",
 CellID->7572],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<List\>\"", ",", 
       StyleBox["elem", "TI"]}], 
      StyleBox[" ", "TI"]}]}]}], "]"}]], "InlineFormula"],
 " imports the specified element from a List file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<List\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<List\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The format ",
 Cell[BoxData["\"\<List\>\""], "InlineFormula"],
 " must be explicitly given."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<List\>\"", ",", 
      StyleBox["elem", "TI"]}], 
     StyleBox["}", "TI"]}]}], "]"}]], "InlineFormula"],
 " creates a List file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<List\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["expr", "TI"], ",", "\"\<List\>\"", ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<List\>\"", ",", "\"\<Rules\>\""}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the List format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "list of numbers or strings, each representing a line", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Grid\>\"", Cell[TextData[{
     "list data as a ",
     Cell[BoxData[
      ButtonBox["Grid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
     " object"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1019936196],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->853175818],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->577662107],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how data is aligned within table columns", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CharacterEncoding"], "\"\<UTF8\>\"", Cell[
    "raw character encoding used in the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->275885706],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1175867229],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->431454156],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CharacterEncoding"], "\"\<ASCII\>\"", Cell[
    "raw character encoding used in the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1545207620],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->363422294],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EmptyField\>\"", "\"\<\>\"", Cell[
    "how to represent empty fields", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->595003190],

Cell["", "WeakDivider",
 CellID->1791006941],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->175377388],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CurrencyTokens\>\"", 
    RowBox[{
     StyleBox["{", "MR"], 
     RowBox[{
      RowBox[{
       StyleBox["{", "MR"], 
       RowBox[{
        StyleBox[
         RowBox[{"\"\<\>", "$", "\"\<\>"}], "MR"], 
        StyleBox[",", "MR"], " ", 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Sterling]",
          TraditionalForm], "\"\<\>"}], ",", 
        StyleBox[" ", "TR"], 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Yen]",
          TraditionalForm], 
         StyleBox["\"\<\>", "MR"]}], 
        StyleBox[",", "MR"], " ", 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Euro]",
          TraditionalForm], "\"\<\>"}]}], "}"}], ",", 
      StyleBox[" ", "TR"], 
      RowBox[{
       StyleBox["{", "MR"], 
       RowBox[{
        StyleBox[
         RowBox[{"\"\<\>", "c", "\"\<\>"}], "MR"], 
        StyleBox[",", "MR"], " ", 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Cent]",
          TraditionalForm], "\"\<\>"}], ",", 
        StyleBox[" ", "TR"], 
        StyleBox[
         RowBox[{"\"\<\>", "p", "\"\<\>"}], "MR"], 
        StyleBox[",", "MR"], " ", 
        StyleBox[
         RowBox[{"\"\<\>", "F", "\"\<\>"}], "MR"]}], 
       StyleBox["}", "MR"]}]}], 
     StyleBox["}", "MR"]}], Cell[
    "currency units to be skipped when importing numerical values", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DateStringFormat\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "date format, given as a ",
     Cell[BoxData[
      ButtonBox["DateString",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
     " specification"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IgnoreEmptyLines\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to ignore empty lines", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LineSeparators\>\"", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Backslash]r\\n\>\"", ",", "\"\<\[Backslash]n\>\"", ",", 
      "\"\<\\r\>\""}], "}"}], Cell[
    "string tokens taken to separate list elements", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Numeric\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to import data fields as numbers if possible  ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NumberPoint\>\"", "\"\<.\>\"", Cell[
    "string to use for a decimal point", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NumberSigns\>\"", 
    RowBox[{"{", 
     RowBox[{"\"\<-\>\"", ",", "\"\<+\>\""}], "}"}], Cell[
    "strings to use for signs of negative and positive numbers", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HeaderLines\>\"", "0", Cell[
    "number of lines to skip at the beginning of the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->1220196432],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " converts table entries formatted as specified by the ",
 Cell[BoxData["\"\<DateStringFormat\>\""], "InlineFormula"],
 " option to a ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " representation of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["d", "TI"], ",", 
    StyleBox["h", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["s", "TI"]}], "}"}]], "InlineFormula"],
 ". "
}], "FormatNotes",
 CellID->1885747166],

Cell[TextData[{
 "Empty lines and lines containing only whitespace characters are converted \
to an empty string by default. With ",
 Cell[BoxData["\"\<IgnoreEmptyLines\>\""], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " will skip empty lines."
}], "FormatNotes",
 CellID->1986350738],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<Numeric\>\"", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", numbers will be imported as strings in the form they appear in the file."
}], "FormatNotes",
 CellID->2005072920],

Cell[TextData[{
 "All common conventions for the encoding of newline characters are \
recognized with the default setting of ",
 Cell[BoxData["\"\<LineSeparators\>\""], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1188956536]
}, Closed]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->62284587],

Cell[TextData[ButtonBox["Basic Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->197119697],

Cell["Import a text file as a list of strings:", "ExampleText",
 CellID->1027385192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/50states.txt\>\"", ",", "\"\<List\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->976592890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Alabama\"\>", ",", "\<\"Alaska\"\>", ",", "\<\"Arizona\"\>", 
   ",", "\<\"Arkansas\"\>", ",", "\<\"California\"\>", 
   ",", "\<\"Colorado\"\>", ",", "\<\"Connecticut\"\>", 
   ",", "\<\"Delaware\"\>", ",", "\<\"Florida\"\>", ",", "\<\"Georgia\"\>", 
   ",", "\<\"Hawaii\"\>", ",", "\<\"Idaho\"\>", ",", "\<\"Illinois\"\>", 
   ",", "\<\"Indiana\"\>", ",", "\<\"Iowa\"\>", ",", "\<\"Kansas\"\>", 
   ",", "\<\"Kentucky\"\>", ",", "\<\"Louisiana\"\>", ",", "\<\"Maine\"\>", 
   ",", "\<\"Maryland\"\>", ",", "\<\"Massachusetts\"\>", 
   ",", "\<\"Michigan\"\>", ",", "\<\"Minnesota\"\>", 
   ",", "\<\"Mississippi\"\>", ",", "\<\"Missouri\"\>", 
   ",", "\<\"Montana\"\>", ",", "\<\"Nebraska\"\>", ",", "\<\"Nevada\"\>", 
   ",", "\<\"New Hampshire\"\>", ",", "\<\"New Jersey\"\>", 
   ",", "\<\"New Mexico\"\>", ",", "\<\"New York\"\>", 
   ",", "\<\"North Carolina\"\>", ",", "\<\"North Dakota\"\>", 
   ",", "\<\"Ohio\"\>", ",", "\<\"Oklahoma\"\>", ",", "\<\"Oregon\"\>", 
   ",", "\<\"Pennsylvania\"\>", ",", "\<\"Rhode Island\"\>", 
   ",", "\<\"South Carolina\"\>", ",", "\<\"South Dakota\"\>", 
   ",", "\<\"Tennessee\"\>", ",", "\<\"Texas\"\>", ",", "\<\"Utah\"\>", 
   ",", "\<\"Vermont\"\>", ",", "\<\"Virginia\"\>", ",", "\<\"Washington\"\>",
    ",", "\<\"West Virginia\"\>", ",", "\<\"Wisconsin\"\>", 
   ",", "\<\"Wyoming\"\>"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->714568688]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->767088048],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " converts records to integers or reals if possible:"
}], "ExampleText",
 CellID->1104489795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
  "\"\<-1\\n0\\n2.49000\\n18446744073709551616\>\"", ",", " ", 
   "\"\<List\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->311339897],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "0", ",", "2.49`", ",", "18446744073709551616"}], 
  "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->396969780]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42017823],

Cell["\<\
Currency symbols are automatically omitted when importing as a List:\
\>", "ExampleText",
 CellID->1818914945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"\"\<$1.99\\n$2.49\\n$2.99\>\"", ",", " ", "\"\<List\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1494400064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.99`", ",", "2.49`", ",", "2.99`"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1034622197]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1786884878],

Cell["Export a list of numbers using the List format:", "ExampleText",
 CellID->1762824898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10000", ",", "10010"}], "}"}]}], "]"}], ",", 
   "\"\<List\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1113666674],

Cell[BoxData["\<\"104729\\n104743\\n104759\\n104761\\n104773\\n104779\\\
n104789\\n104801\\n104803\\n104827\\n104831\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->2036274206]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"List - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 3.8558860}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Column of numbers or strings. Stores a list of numbers or strings as \
lines. Plain text format. Is essentially a single-column version of the \
\"Table\" format.", "synonyms" -> {}, "title" -> "List", "type" -> "Format", 
    "uri" -> "ref/format/List"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[21652, 775, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26812, 939}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 892, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1515, 47, 50, 1, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[1568, 50, 344, 9, 70, "FormatUsage",
 CellID->37585799],
Cell[1915, 61, 396, 13, 70, "FormatNotes",
 CellID->344331575],
Cell[2314, 76, 257, 8, 70, "FormatNotes",
 CellID->56646289],
Cell[2574, 86, 99, 1, 70, "FormatNotes",
 CellID->718923602]
}, Open  ]],
Cell[CellGroupData[{
Cell[2710, 92, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[2777, 95, 346, 11, 70, "FormatNotes",
 CellID->28652],
Cell[3126, 108, 361, 11, 70, "FormatNotes",
 CellID->8194],
Cell[3490, 121, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[3532, 124, 435, 15, 70, "FormatNotes",
 CellID->28396],
Cell[3970, 141, 600, 23, 70, "FormatNotes",
 CellID->7572],
Cell[4573, 166, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[4615, 169, 446, 15, 70, "FormatNotes",
 CellID->29174],
Cell[5064, 186, 591, 20, 70, "FormatNotes",
 CellID->18819],
Cell[5658, 208, 622, 22, 70, "FormatNotes",
 CellID->943],
Cell[6283, 232, 145, 5, 70, "FormatNotes",
 CellID->32611],
Cell[6431, 239, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[6472, 242, 602, 21, 70, "FormatNotes",
 CellID->20289],
Cell[7077, 265, 1117, 41, 70, "FormatNotes",
 CellID->8419],
Cell[8197, 308, 678, 22, 70, "FormatNotes",
 CellID->5565],
Cell[8878, 332, 873, 30, 70, "FormatNotes",
 CellID->3805],
Cell[9754, 364, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[9795, 367, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[10159, 383, 343, 12, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[10539, 400, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[10598, 403, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[10797, 413, 672, 13, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[11472, 428, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[11516, 431, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[11591, 434, 653, 17, 70, "2ColumnTableMod",
 CellID->1019936196],
Cell[12247, 453, 382, 14, 70, "FormatNotes",
 CellID->1999285391]
}, Open  ]],
Cell[CellGroupData[{
Cell[12666, 472, 53, 1, 70, "OptionsSection",
 CellID->853175818],
Cell[12722, 475, 195, 8, 70, "FormatNotes",
 CellID->577662107],
Cell[12920, 485, 775, 20, 70, "3ColumnTableMod",
 CellID->275885706],
Cell[13698, 507, 693, 28, 70, "FormatNotes",
 CellID->1175867229],
Cell[14394, 537, 194, 8, 70, "FormatNotes",
 CellID->431454156],
Cell[14591, 547, 482, 12, 70, "3ColumnTableMod",
 CellID->1545207620],
Cell[15076, 561, 306, 12, 70, "FormatNotes",
 CellID->363422294],
Cell[15385, 575, 378, 9, 70, "3ColumnTableMod",
 CellID->595003190],
Cell[15766, 586, 44, 1, 70, "WeakDivider",
 CellID->1791006941],
Cell[15813, 589, 182, 7, 70, "FormatNotes",
 CellID->175377388],
Cell[15998, 598, 3367, 91, 70, "3ColumnTableMod",
 CellID->1220196432],
Cell[19368, 691, 717, 24, 70, "FormatNotes",
 CellID->1885747166],
Cell[20088, 717, 506, 16, 70, "FormatNotes",
 CellID->1986350738],
Cell[20597, 735, 297, 9, 70, "FormatNotes",
 CellID->2005072920],
Cell[20897, 746, 231, 6, 70, "FormatNotes",
 CellID->1188956536]
}, Closed]],
Cell[CellGroupData[{
Cell[21165, 757, 57, 1, 70, "MoreAboutSection",
 CellID->62284587],
Cell[21225, 760, 117, 2, 70, "MoreAbout"],
Cell[21345, 764, 134, 2, 70, "MoreAbout"],
Cell[21482, 768, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21652, 775, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[21768, 781, 60, 1, 70, "ExampleSection",
 CellID->197119697],
Cell[21831, 784, 84, 1, 70, "ExampleText",
 CellID->1027385192],
Cell[CellGroupData[{
Cell[21940, 789, 170, 5, 70, "Input",
 CellID->976592890],
Cell[22113, 796, 1448, 24, 70, "Output",
 CellID->714568688]
}, Open  ]],
Cell[23576, 823, 125, 3, 70, "ExampleDelimiter",
 CellID->767088048],
Cell[23704, 828, 225, 7, 70, "ExampleText",
 CellID->1104489795],
Cell[CellGroupData[{
Cell[23954, 839, 200, 6, 70, "Input",
 CellID->311339897],
Cell[24157, 847, 181, 6, 70, "Output",
 CellID->396969780]
}, Open  ]],
Cell[24353, 856, 124, 3, 70, "ExampleDelimiter",
 CellID->42017823],
Cell[24480, 861, 120, 3, 70, "ExampleText",
 CellID->1818914945],
Cell[CellGroupData[{
Cell[24625, 868, 179, 5, 70, "Input",
 CellID->1494400064],
Cell[24807, 875, 139, 4, 70, "Output",
 CellID->1034622197]
}, Open  ]],
Cell[24961, 882, 126, 3, 70, "ExampleDelimiter",
 CellID->1786884878],
Cell[25090, 887, 91, 1, 70, "ExampleText",
 CellID->1762824898],
Cell[CellGroupData[{
Cell[25206, 892, 311, 10, 70, "Input",
 CellID->1113666674],
Cell[25520, 904, 177, 3, 70, "Output",
 CellID->2036274206]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[25736, 912, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

