(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32702,       1027]
NotebookOptionsPosition[     27215,        849]
NotebookOutlinePosition[     28690,        889]
CellTagsIndexPosition[     28605,        884]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"CSV\"" :> Documentation`HelpLookup["paclet:ref/format/CSV"], 
          "\"DBF\"" :> Documentation`HelpLookup["paclet:ref/format/DBF"], 
          "\"DIF\"" :> Documentation`HelpLookup["paclet:ref/format/DIF"], 
          "\"Table\"" :> Documentation`HelpLookup["paclet:ref/format/Table"], 
          "\"TSV\"" :> Documentation`HelpLookup["paclet:ref/format/TSV"], 
          "\"XLS\"" :> Documentation`HelpLookup["paclet:ref/format/XLS"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"CSV\\\"\"\>", 
       2->"\<\"\\\"DBF\\\"\"\>", 3->"\<\"\\\"DIF\\\"\"\>", 
       4->"\<\"\\\"Table\\\"\"\>", 5->"\<\"\\\"TSV\\\"\"\>", 
       6->"\<\"\\\"XLS\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Importing & Exporting Database Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/ImportingAndExportingDatabaseFormats"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], "Statistics" :> 
          Documentation`HelpLookup["paclet:guide/Statistics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Date & Time\"\>", 
       2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Importing & Exporting Database Formats\"\>", 
       4->"\<\"Listing of All Formats\"\>", 
       5->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       6->"\<\"New in 6.0: Import & Export Formats\"\>", 
       7->"\<\"Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "MDB ",
 StyleBox["(.mdb)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "MIME types: ",
 StyleBox["application/mdb, application/msaccess, application/vnd.msaccess", 
  "InlineCode"],
 "\nMDB database file.\nNative format of the Microsoft Access database \
application.\nUsed in conjunction with the Access relational database \
management system and as an exchange format.\nBinary format.\nStores \
numerical and textual information as sets of tables.\nDeveloped by Microsoft \
in 1992."
}], "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " supports the MDB 2000 format."
}], "FormatNotes",
 CellID->344331575],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can read MDB files without having Microsoft Access installed."
}], "FormatNotes",
 CellID->256392596],

Cell[TextData[{
 "System requirement: ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " of MDB files is supported on computers that are capable of running Java \
1.5."
}], "FormatNotes",
 CellID->318441593]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mdb\>\"", "]"}]], "InlineFormula"],
 " imports an MDB database, returning a list of arrays."
}], "FormatNotes",
 CellID->28652],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mdb\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a list of two-dimensional arrays, each representing a database \
table."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 "MDB data is represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by real or integer numbers, strings, Boolean values ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ",",
 " ",
 "and ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " specifications."
}], "FormatNotes",
 CellID->373727629],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mdb\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "MDB",
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mdb\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mdb\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<MDB\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<MDB\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " supports the ",
 "MDB",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Specifying and selecting datasets:", "FormatNotes",
 CellID->18634],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "all datasets given as a list of arrays", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Datasets\>\"", Cell[
    "names of all datasets", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Datasets\>\"", ",", " ", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " dataset given as an array"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Datasets\>\"", ",", " ", 
     StyleBox["name", "TI"]}], Cell[TextData[{
     "dataset ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     " name given as an array"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Datasets\>\"", ",", " ", 
     StyleBox["name", "TI"], ",", " ", "\"\<Labels\>\""}], Cell[TextData[{
     "list of strings, representing the column labels of dataset ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Datasets\>\"", ",", " ", 
     StyleBox["name", "TI"], ",", " ", "\"\<LabeledData\>\""}], Cell[
    TextData[{
     "dataset ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     " using rules for each column"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->517846341],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->31322],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EmptyField\>\"", "\"\<\>\"", Cell[
    TextData[{
     "how empty cells are represented in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->30333]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<CSV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/CSV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<DBF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/DBF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<DIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/DIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Table\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Table"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TSV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TSV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XLS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XLS"]], "InlineFormula"]
}], "SeeAlso",
 CellID->269437084]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->210521534],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting Database Formats",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ImportingAndExportingDatabaseFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->794975586],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in an MDB sample file:"
}], "ExampleText",
 CellID->2078656372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", " ", 
   RowBox[{"\"\<ExampleData/buildings.mdb\>\"", ",", "\"\<Elements\>\""}], 
   " ", "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->976592890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Data\"\>", ",", "\<\"Datasets\"\>"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1840750174]
}, Open  ]],

Cell["Import the names of all datasets stored in the file:", "ExampleText",
 CellID->713674808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", 
  RowBox[{"\"\<ExampleData/buildings.mdb\>\"", ",", "\"\<Datasets\>\""}], " ",
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->838755736],

Cell[BoxData[
 RowBox[{"{", "\<\"Buildings\"\>", "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->884996044]
}, Open  ]],

Cell["Import the data labels available for this dataset:", "ExampleText",
 CellID->1407344855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", 
  RowBox[{"\"\<ExampleData/buildings.mdb\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
    "\"\<Datasets\>\"", ",", "\"\<Buildings\>\"", ",", "\"\<Labels\>\""}], 
    "}"}]}], " ", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1644066203],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Rank\"\>", ",", "\<\"Name\"\>", ",", "\<\"City\"\>", 
   ",", "\<\"Country\"\>", ",", "\<\"Year\"\>", ",", "\<\"Stories\"\>", 
   ",", "\<\"Height\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->148587872]
}, Open  ]],

Cell["Import data associated with three labels:", "ExampleText",
 CellID->818975132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Import", "[", " ", 
    RowBox[{"\"\<ExampleData/buildings.mdb\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Datasets\>\"", ",", "\"\<Buildings\>\"", ",", 
       "\"\<LabeledData\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Rank\>\"", ",", "\"\<Name\>\"", ",", "\"\<City\>\"", ",", 
         "\"\<Height\>\""}], "}"}]}], "}"}]}], " ", "]"}], "//", 
   "Transpose"}], " ", "//", " ", "Grid"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1925937114],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "\<\"Taipei 101\"\>", "\<\"Taipei\"\>", "508"},
    {"2", "\<\"Petronas Tower 1\"\>", "\<\"Kuala Lumpur\"\>", "452"},
    {"3", "\<\"Petronas Tower 2\"\>", "\<\"Kuala Lumpur\"\>", "452"},
    {"4", "\<\"Sears Tower\"\>", "\<\"Chicago\"\>", "442"},
    {"5", "\<\"Jin Mao Building\"\>", "\<\"Shanghai\"\>", "421"},
    {"6", "\<\"Two International Finance Centre\"\>", "\<\"Hong Kong\"\>", 
     "415"},
    {"7", "\<\"CITIC Plaza\"\>", "\<\"Guangzhou\"\>", "391"},
    {"8", "\<\"Shun Hing Square\"\>", "\<\"Shenzhen\"\>", "384"},
    {"9", "\<\"Empire State Building\"\>", "\<\"New York\"\>", "381"},
    {"10", "\<\"Central Plaza\"\>", "\<\"Hong Kong\"\>", "374"},
    {"11", "\<\"Bank of China\"\>", "\<\"Hong Kong\"\>", "367"},
    {"12", "\<\"Emirates Tower One\"\>", "\<\"Dubai\"\>", "355"},
    {"13", "\<\"Tuntex Sky Tower\"\>", "\<\"Kaohsiung\"\>", "348"},
    {"14", "\<\"Aon Centre\"\>", "\<\"Chicago\"\>", "346"},
    {"15", "\<\"The Center\"\>", "\<\"Hong Kong\"\>", "346"},
    {"16", "\<\"John Hancock Center\"\>", "\<\"Chicago\"\>", "344"},
    {"17", "\<\"Shimao International Plaza\"\>", "\<\"Shanghai\"\>", "333"},
    {"18", "\<\"Minsheng Bank Building\"\>", "\<\"Wuhan\"\>", "331"},
    {"19", "\<\"Ryugyong Hotel\"\>", "\<\"Pyongyang\"\>", "330"},
    {"20", "\<\"Q1\"\>", "\<\"Gold Coast\"\>", "323"}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 CellLabel->"Out[4]=",
 CellID->1787998249]
}, Open  ]],

Cell["Import an entire dataset as a list of rules:", "ExampleText",
 CellID->1884017903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", 
  RowBox[{"\"\<ExampleData/buildings.mdb\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
    "\"\<Datasets\>\"", ",", "\"\<Buildings\>\"", ",", 
     "\"\<LabeledData\>\""}], "}"}]}], " ", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1940366890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"Rank\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
      "8", ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", 
      ",", "15", ",", "16", ",", "17", ",", "18", ",", "19", ",", "20"}], 
     "}"}]}], ",", 
   RowBox[{"\<\"Name\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Taipei 101\"\>", ",", "\<\"Petronas Tower 1\"\>", 
      ",", "\<\"Petronas Tower 2\"\>", ",", "\<\"Sears Tower\"\>", 
      ",", "\<\"Jin Mao Building\"\>", 
      ",", "\<\"Two International Finance Centre\"\>", 
      ",", "\<\"CITIC Plaza\"\>", ",", "\<\"Shun Hing Square\"\>", 
      ",", "\<\"Empire State Building\"\>", ",", "\<\"Central Plaza\"\>", 
      ",", "\<\"Bank of China\"\>", ",", "\<\"Emirates Tower One\"\>", 
      ",", "\<\"Tuntex Sky Tower\"\>", ",", "\<\"Aon Centre\"\>", 
      ",", "\<\"The Center\"\>", ",", "\<\"John Hancock Center\"\>", 
      ",", "\<\"Shimao International Plaza\"\>", 
      ",", "\<\"Minsheng Bank Building\"\>", ",", "\<\"Ryugyong Hotel\"\>", 
      ",", "\<\"Q1\"\>"}], "}"}]}], ",", 
   RowBox[{"\<\"City\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Taipei\"\>", ",", "\<\"Kuala Lumpur\"\>", 
      ",", "\<\"Kuala Lumpur\"\>", ",", "\<\"Chicago\"\>", 
      ",", "\<\"Shanghai\"\>", ",", "\<\"Hong Kong\"\>", 
      ",", "\<\"Guangzhou\"\>", ",", "\<\"Shenzhen\"\>", 
      ",", "\<\"New York\"\>", ",", "\<\"Hong Kong\"\>", 
      ",", "\<\"Hong Kong\"\>", ",", "\<\"Dubai\"\>", 
      ",", "\<\"Kaohsiung\"\>", ",", "\<\"Chicago\"\>", 
      ",", "\<\"Hong Kong\"\>", ",", "\<\"Chicago\"\>", 
      ",", "\<\"Shanghai\"\>", ",", "\<\"Wuhan\"\>", ",", "\<\"Pyongyang\"\>",
       ",", "\<\"Gold Coast\"\>"}], "}"}]}], ",", 
   RowBox[{"\<\"Country\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Taiwan\"\>", ",", "\<\"Malaysia\"\>", 
      ",", "\<\"Malaysia\"\>", ",", "\<\"United States\"\>", 
      ",", "\<\"China\"\>", ",", "\<\"China\"\>", ",", "\<\"China\"\>", 
      ",", "\<\"China\"\>", ",", "\<\"United States\"\>", 
      ",", "\<\"China\"\>", ",", "\<\"China\"\>", 
      ",", "\<\"United Arab Emirates\"\>", ",", "\<\"Taiwan\"\>", 
      ",", "\<\"United States\"\>", ",", "\<\"China\"\>", 
      ",", "\<\"United States\"\>", ",", "\<\"China\"\>", 
      ",", "\<\"China\"\>", ",", "\<\"North Korea\"\>", 
      ",", "\<\"Australia\"\>"}], "}"}]}], ",", 
   RowBox[{"\<\"Year\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "2004", ",", "1998", ",", "1998", ",", "1974", ",", "1999", ",", "2003", 
      ",", "1996", ",", "1996", ",", "1931", ",", "1992", ",", "1989", ",", 
      "1999", ",", "1997", ",", "1973", ",", "1998", ",", "1969", ",", "2005",
       ",", "2006", ",", "1995", ",", "2005"}], "}"}]}], ",", 
   RowBox[{"\<\"Stories\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "101", ",", "88", ",", "88", ",", "110", ",", "88", ",", "88", ",", "80",
       ",", "69", ",", "102", ",", "78", ",", "70", ",", "54", ",", "85", ",",
       "80", ",", "73", ",", "100", ",", "60", ",", "68", ",", "105", ",", 
      "78"}], "}"}]}], ",", 
   RowBox[{"\<\"Height\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "508", ",", "452", ",", "452", ",", "442", ",", "421", ",", "415", ",", 
      "391", ",", "384", ",", "381", ",", "374", ",", "367", ",", "355", ",", 
      "348", ",", "346", ",", "346", ",", "344", ",", "333", ",", "331", ",", 
      "330", ",", "323"}], "}"}]}]}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->59656888]
}, Open  ]],

Cell["Import all data from an MDB database:", "ExampleText",
 CellID->1036329561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", "\"\<ExampleData/buildings.mdb\>\"", " ", 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->656772386],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "\<\"Taipei 101\"\>", ",", "\<\"Taipei\"\>", 
     ",", "\<\"Taiwan\"\>", ",", "2004", ",", "101", ",", "508"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
    "2", ",", "\<\"Petronas Tower 1\"\>", ",", "\<\"Kuala Lumpur\"\>", 
     ",", "\<\"Malaysia\"\>", ",", "1998", ",", "88", ",", "452"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "3", ",", "\<\"Petronas Tower 2\"\>", ",", "\<\"Kuala Lumpur\"\>", 
     ",", "\<\"Malaysia\"\>", ",", "1998", ",", "88", ",", "452"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "\<\"Sears Tower\"\>", ",", "\<\"Chicago\"\>", 
     ",", "\<\"United States\"\>", ",", "1974", ",", "110", ",", "442"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "\<\"Jin Mao Building\"\>", ",", "\<\"Shanghai\"\>", 
     ",", "\<\"China\"\>", ",", "1999", ",", "88", ",", "421"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "6", ",", "\<\"Two International Finance Centre\"\>", 
     ",", "\<\"Hong Kong\"\>", ",", "\<\"China\"\>", ",", "2003", ",", "88", 
     ",", "415"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "7", ",", "\<\"CITIC Plaza\"\>", ",", "\<\"Guangzhou\"\>", 
     ",", "\<\"China\"\>", ",", "1996", ",", "80", ",", "391"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "8", ",", "\<\"Shun Hing Square\"\>", ",", "\<\"Shenzhen\"\>", 
     ",", "\<\"China\"\>", ",", "1996", ",", "69", ",", "384"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "9", ",", "\<\"Empire State Building\"\>", ",", "\<\"New York\"\>", 
     ",", "\<\"United States\"\>", ",", "1931", ",", "102", ",", "381"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "\<\"Central Plaza\"\>", ",", "\<\"Hong Kong\"\>", 
     ",", "\<\"China\"\>", ",", "1992", ",", "78", ",", "374"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "11", ",", "\<\"Bank of China\"\>", ",", "\<\"Hong Kong\"\>", 
     ",", "\<\"China\"\>", ",", "1989", ",", "70", ",", "367"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "12", ",", "\<\"Emirates Tower One\"\>", ",", "\<\"Dubai\"\>", 
     ",", "\<\"United Arab Emirates\"\>", ",", "1999", ",", "54", ",", 
     "355"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "13", ",", "\<\"Tuntex Sky Tower\"\>", ",", "\<\"Kaohsiung\"\>", 
     ",", "\<\"Taiwan\"\>", ",", "1997", ",", "85", ",", "348"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
    "14", ",", "\<\"Aon Centre\"\>", ",", "\<\"Chicago\"\>", 
     ",", "\<\"United States\"\>", ",", "1973", ",", "80", ",", "346"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "15", ",", "\<\"The Center\"\>", ",", "\<\"Hong Kong\"\>", 
     ",", "\<\"China\"\>", ",", "1998", ",", "73", ",", "346"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "16", ",", "\<\"John Hancock Center\"\>", ",", "\<\"Chicago\"\>", 
     ",", "\<\"United States\"\>", ",", "1969", ",", "100", ",", "344"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "17", ",", "\<\"Shimao International Plaza\"\>", ",", "\<\"Shanghai\"\>", 
     ",", "\<\"China\"\>", ",", "2005", ",", "60", ",", "333"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "18", ",", "\<\"Minsheng Bank Building\"\>", ",", "\<\"Wuhan\"\>", 
     ",", "\<\"China\"\>", ",", "2006", ",", "68", ",", "331"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "19", ",", "\<\"Ryugyong Hotel\"\>", ",", "\<\"Pyongyang\"\>", 
     ",", "\<\"North Korea\"\>", ",", "1995", ",", "105", ",", "330"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
    "20", ",", "\<\"Q1\"\>", ",", "\<\"Gold Coast\"\>", 
     ",", "\<\"Australia\"\>", ",", "2005", ",", "78", ",", "323"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[6]=",
 CellID->1292349901]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MDB - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 7.1059692}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME types: application/mdb, application/msaccess, \
application/vnd.msaccess MDB database file. Native format of the Microsoft \
Access database application. Used in conjunction with the Access relational \
database management system and as an exchange format. Binary format. Stores \
numerical and textual information as sets of tables. Developed by Microsoft \
in 1992.", "synonyms" -> {}, "title" -> "MDB", "type" -> "Format", "uri" -> 
    "ref/format/MDB"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15021, 515, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28471, 877}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2725, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3348, 84, 107, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[3458, 90, 470, 10, 70, "FormatUsage",
 CellID->37585799],
Cell[3931, 102, 203, 7, 70, "FormatNotes",
 CellID->344331575],
Cell[4137, 111, 169, 5, 70, "FormatNotes",
 CellID->256392596],
Cell[4309, 118, 277, 9, 70, "FormatNotes",
 CellID->318441593]
}, Open  ]],
Cell[CellGroupData[{
Cell[4623, 132, 53, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[4679, 135, 299, 9, 70, "FormatNotes",
 CellID->28652],
Cell[4981, 146, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[5023, 149, 347, 11, 70, "FormatNotes",
 CellID->28396],
Cell[5373, 162, 587, 23, 70, "FormatNotes",
 CellID->373727629],
Cell[5963, 187, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[6005, 190, 352, 13, 70, "FormatNotes",
 CellID->29174],
Cell[6360, 205, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[6937, 227, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[7520, 250, 698, 25, 70, "FormatNotes",
 CellID->32611],
Cell[8221, 277, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[8262, 280, 236, 9, 70, "FormatNotes",
 CellID->16216],
Cell[8501, 291, 216, 9, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[8754, 305, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[8813, 308, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[9012, 318, 672, 13, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[9687, 333, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[9731, 336, 73, 1, 70, "FormatNotes",
 CellID->18634],
Cell[9807, 339, 1776, 46, 70, "2ColumnTableMod",
 CellID->517846341],
Cell[11586, 387, 258, 9, 70, "FormatNotes",
 CellID->1999285391]
}, Open  ]],
Cell[CellGroupData[{
Cell[11881, 401, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[11933, 404, 177, 7, 70, "FormatNotes",
 CellID->31322],
Cell[12113, 413, 460, 13, 70, "3ColumnTableMod",
 CellID->30333]
}, Closed]],
Cell[CellGroupData[{
Cell[12610, 431, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[12668, 434, 1217, 41, 70, "SeeAlso",
 CellID->269437084]
}, Open  ]],
Cell[CellGroupData[{
Cell[13922, 480, 58, 1, 70, "MoreAboutSection",
 CellID->210521534],
Cell[13983, 483, 114, 2, 70, "MoreAbout"],
Cell[14100, 487, 134, 2, 70, "MoreAbout"],
Cell[14237, 491, 169, 3, 70, "MoreAbout"],
Cell[14409, 496, 133, 2, 70, "MoreAbout"],
Cell[14545, 500, 165, 2, 70, "MoreAbout"],
Cell[14713, 504, 156, 2, 70, "MoreAbout"],
Cell[14872, 508, 112, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15021, 515, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[15137, 521, 60, 1, 70, "ExampleSection",
 CellID->794975586],
Cell[15200, 524, 230, 8, 70, "ExampleText",
 CellID->2078656372],
Cell[CellGroupData[{
Cell[15455, 536, 205, 6, 70, "Input",
 CellID->976592890],
Cell[15663, 544, 143, 4, 70, "Output",
 CellID->1840750174]
}, Open  ]],
Cell[15821, 551, 95, 1, 70, "ExampleText",
 CellID->713674808],
Cell[CellGroupData[{
Cell[15941, 556, 185, 5, 70, "Input",
 CellID->838755736],
Cell[16129, 563, 109, 3, 70, "Output",
 CellID->884996044]
}, Open  ]],
Cell[16253, 569, 94, 1, 70, "ExampleText",
 CellID->1407344855],
Cell[CellGroupData[{
Cell[16372, 574, 281, 8, 70, "Input",
 CellID->1644066203],
Cell[16656, 584, 259, 6, 70, "Output",
 CellID->148587872]
}, Open  ]],
Cell[16930, 593, 84, 1, 70, "ExampleText",
 CellID->818975132],
Cell[CellGroupData[{
Cell[17039, 598, 523, 15, 70, "Input",
 CellID->1925937114],
Cell[17565, 615, 1558, 29, 70, "Output",
 CellID->1787998249]
}, Open  ]],
Cell[19138, 647, 88, 1, 70, "ExampleText",
 CellID->1884017903],
Cell[CellGroupData[{
Cell[19251, 652, 287, 8, 70, "Input",
 CellID->1940366890],
Cell[19541, 662, 3586, 70, 70, "Output",
 CellID->59656888]
}, Open  ]],
Cell[23142, 735, 81, 1, 70, "ExampleText",
 CellID->1036329561],
Cell[CellGroupData[{
Cell[23248, 740, 147, 4, 70, "Input",
 CellID->656772386],
Cell[23398, 746, 3751, 96, 70, "Output",
 CellID->1292349901]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[27188, 847, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

