(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48999,       1424]
NotebookOptionsPosition[     42393,       1210]
NotebookOutlinePosition[     43940,       1251]
CellTagsIndexPosition[     43854,       1246]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"FASTA\"" :> 
          Documentation`HelpLookup["paclet:ref/format/FASTA"], "\"PDB\"" :> 
          Documentation`HelpLookup["paclet:ref/format/PDB"], "\"XYZ\"" :> 
          Documentation`HelpLookup["paclet:ref/format/XYZ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"FASTA\\\"\"\>", 
       2->"\<\"\\\"PDB\\\"\"\>", 
       3->"\<\"\\\"XYZ\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Scientific & Medical Data Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/ScientificAndMedicalDataFormats"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Geometry & Modeling Formats\"\>",
        2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>", 
       4->"\<\"Scientific & Medical Data Formats\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "MOL ",
 StyleBox["(.mol)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell[TextData[{
 "Mime type: ",
 StyleBox["chemical/x-mdl-molfile", "InlineCode"],
 "\nMDL molecule model files.\nUsed in cheminformatics applications and on \
the web for storing and exchanging 3D molecule models.\nPlain text tabular \
format.\nRepresents a single chemical compound.\nStores atomic coordinates, \
chemical bond information, and metadata.\nMaintained by Elsevier Molecular \
Design Limited (MDL)."
}], "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " reads versions 2.0 and 3.0 of the MOL format."
}], "FormatNotes",
 CellID->5821],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " creates version 2.0 molfiles."
}], "FormatNotes",
 CellID->83604582]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mol\>\"", "]"}]], "InlineFormula"],
 "imports a molecule model or a structure diagram from a molfile."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mol\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports elements of a molecule model to a molfile."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mol\>\"", "]"}]], "InlineFormula"],
 "gives a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object when reading a 3D molecule model and vector graphics when importing \
a planar representation of a molecule."
}], "FormatNotes",
 CellID->25134],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mol\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a molfile."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mol\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mol\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<MOL\>\""}], "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<MOL\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mol\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a molfile by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mol\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mol\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mol\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the MOL format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Graphics elements:", "FormatNotes",
 CellID->525384128],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[
    "3D rendering of the molecule model", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StructureDiagram\>\"", Cell[
    "2D structure formula", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->263380570],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<Graphics3D\>\""], "InlineFormula"],
 " element 3D molfiles and",
 Cell[BoxData[
  RowBox[{" ", "\"\<StructureDiagram\>\""}]], "InlineFormula"],
 " for 2D molfiles."
}], "FormatNotes",
 CellID->13037],

Cell["Data representation elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EdgeRules\>\"", Cell[
    "connectivity data, given as a list of rules", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EdgeTypes\>\"", Cell[
    "bond types, as a list of strings", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FormalCharges\>\"", Cell[
    "charges of the atoms given by \"VertexTypes\"", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexCoordinates\>\"", Cell[
    "2D or 3D atomic coordinates, typically given in picometers", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexTypes\>\"", Cell["\<\
all atoms or groups constituting the molecule,  typically given as a list of \
chemical element abbreviations\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->230773093],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mol\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["vert", "TI"], ",", 
      StyleBox["coord", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<VertexTypes\>\"", ",", "\"\<VertexCoordinates\>\""}], 
      "}"}], "}"}]}], "]"}]], "InlineFormula"],
 " creates a molfile from a specification of atom types and their 2D or 3D \
coordinates."
}], "FormatNotes",
 CellID->1210665048],

Cell["Meta-information element:", "FormatNotes",
 CellID->1168456045],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Header\>\"", Cell[
    "header information from the file", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1650280147]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1911960202],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies the overall size of the graphics to display", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["White",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/White"], Cell[
    "specifies what background color to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ViewPoint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewPoint"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "point in space from which the 3D model is to be viewed", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->2123520593],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<ViewPoint\>\"", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically calculates the optimal viewing angle for the imported \
molecule geometry."
}], "FormatNotes",
 CellID->389608530],

Cell["Selecting a 3D rendering style:", "FormatNotes",
 CellID->2097373960],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Rendering\>\"", 
    "\"\<BallAndStick\>\"", Cell[
    "specifies the visualization method", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->30333],

Cell["Possible settings for \"Rendering\" are:", "FormatNotes",
 CellID->1728212143],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BallAndStick\>\"", Cell[
    "displays atoms and bonds as a ball and stick model", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Spacefilling\>\"", Cell[
    "atoms shown as overlapping spheres", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Wireframe\>\"", Cell[
    "bonds rendered as lines", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1345161726]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<FASTA\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/FASTA"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PDB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PDB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XYZ\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XYZ"]], "InlineFormula"]
}], "SeeAlso",
 CellID->73154560]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->329426040],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Scientific & Medical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScientificAndMedicalDataFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->85933691],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in a MOL file:"
}], "ExampleText",
 CellID->1072652349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/aspirin.mol\>\"", ",", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->846844759],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"EdgeRules\"\>", ",", "\<\"EdgeTypes\"\>", 
   ",", "\<\"FormalCharges\"\>", ",", "\<\"Graphics3D\"\>", 
   ",", "\<\"Header\"\>", ",", "\<\"StructureDiagram\"\>", 
   ",", "\<\"VertexCoordinates\"\>", ",", "\<\"VertexTypes\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1545735844]
}, Open  ]],

Cell["Import a 3D molecule model as a ball-and-stick model:", "ExampleText",
 CellID->2022872597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/aspirin.mol\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17199],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[3], EdgeForm[None], Specularity[
    GrayLevel[1], 100], 
   GraphicsComplex3DBox[{{-222.40000000000003`, -144.42, \
-45.769999999999996`}, {-216.57000000000002`, -5.45, -53.49}, {-99.16, 
    60.85, -16.939999999999998`}, {14.71, -7.380000000000001, 
    27.639999999999997`}, {7.51, -148.32, 
    33.900000000000006`}, {-110.52, -215.32, -1.8800000000000001`}, {
    124.12, -229.34, 79.25}, {242.23, -176.19, 117.27000000000001`}, {
    116.5, -351.62, 83.64}, {127.95, 62.33, 59.540000000000006`}, {110.05, 
    175.77, 132.58}, {244.29, 236.35000000000002`, 168.25}, {2.55, 220.41, 
    165.78}, {-314.29999999999995`, -197.75, -75.}, {-303.82, 
    51.67, -89.14999999999999}, {-96.08, 
    170.82999999999998`, -24.79}, {-117.39999999999999`, -325.2, 3.15}, {
    298.69, -251.32, 141.66}, {231.42000000000002`, 339.67, 
    207.73000000000002`}, {310.51, 241.41, 78.84}, {293.90999999999997`, 
    174.59, 246.57}, {-268.35, -171.08499999999998`, -60.385}, {-260.195, 
    23.110000000000003`, -71.32}, {-97.62, 115.84, -20.865}, {
    71.33000000000001, 27.474999999999994`, 43.59}, {-113.96, -270.26, 
    0.635}, {183.175, -202.765, 98.26}, {120.31, -290.48, 81.445}, {
    270.46, -213.755, 129.465}, {119., 119.05000000000001`, 96.06}, {56.3, 
    198.09, 149.18}, {237.85500000000002`, 288.01, 187.99}, {277.4, 238.88, 
    123.545}, {269.09999999999997`, 205.47000000000003`, 207.41}}, {
     {RGBColor[0.65, 0.7, 0.7], SphereBox[14, 24.], SphereBox[15, 24.], 
      SphereBox[16, 24.], SphereBox[17, 24.], SphereBox[18, 24.], 
      SphereBox[19, 24.], SphereBox[20, 24.], SphereBox[21, 24.]}, 
     {RGBColor[0.4, 0.4, 0.4], SphereBox[1, 34.], SphereBox[2, 34.], 
      SphereBox[3, 34.], SphereBox[4, 34.], SphereBox[5, 34.], 
      SphereBox[6, 34.], SphereBox[7, 34.], SphereBox[11, 34.], 
      SphereBox[12, 34.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[8, 31.], 
      SphereBox[9, 31.], SphereBox[10, 31.], SphereBox[13, 31.]}, 
     {RGBColor[0.65, 0.7, 0.7], CylinderBox[{22, 14}, 15.], 
      CylinderBox[{23, 15}, 15.], CylinderBox[{24, 16}, 15.], 
      CylinderBox[{26, 17}, 15.], CylinderBox[{29, 18}, 15.], 
      CylinderBox[{32, 19}, 15.], CylinderBox[{33, 20}, 15.], 
      CylinderBox[{34, 21}, 15.]}, 
     {RGBColor[0.4, 0.4, 0.4], CylinderBox[{1, 2}, 15.], 
      CylinderBox[{1, 6}, 15.], CylinderBox[{1, 22}, 15.], 
      CylinderBox[{2, 3}, 15.], CylinderBox[{2, 23}, 15.], 
      CylinderBox[{3, 4}, 15.], CylinderBox[{3, 24}, 15.], 
      CylinderBox[{4, 5}, 15.], CylinderBox[{4, 25}, 15.], 
      CylinderBox[{5, 6}, 15.], CylinderBox[{5, 7}, 15.], 
      CylinderBox[{6, 26}, 15.], CylinderBox[{7, 27}, 15.], 
      CylinderBox[{7, 28}, 15.], CylinderBox[{30, 11}, 15.], 
      CylinderBox[{11, 12}, 15.], CylinderBox[{11, 31}, 15.], 
      CylinderBox[{12, 32}, 15.], CylinderBox[{12, 33}, 15.], 
      CylinderBox[{12, 34}, 15.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], CylinderBox[{25, 10}, 15.], 
      CylinderBox[{27, 8}, 15.], CylinderBox[{28, 9}, 15.], 
      CylinderBox[{8, 29}, 15.], CylinderBox[{10, 30}, 15.], 
      CylinderBox[{31, 13}, 15.]}}]},
  Boxed->False,
  Lighting->"Neutral",
  ViewPoint->{-1.2806119487554317`, -0.22856150272106565`, 
   3.119646242152899}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1653640730]
}, Open  ]],

Cell["Show the bonds of the same molecule as a wireframe model:", \
"ExampleText",
 CellID->1899472945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/aspirin.mol\>\"", ",", " ", 
   RowBox[{"\"\<Rendering\>\"", " ", "\[Rule]", " ", "\"\<Wireframe\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->892684481],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[3], EdgeForm[None], Specularity[
    GrayLevel[1], 100], 
   GraphicsComplex3DBox[{{-222.40000000000003`, -144.42, \
-45.769999999999996`}, {-216.57000000000002`, -5.45, -53.49}, {-99.16, 
    60.85, -16.939999999999998`}, {14.71, -7.380000000000001, 
    27.639999999999997`}, {7.51, -148.32, 
    33.900000000000006`}, {-110.52, -215.32, -1.8800000000000001`}, {
    124.12, -229.34, 79.25}, {242.23, -176.19, 117.27000000000001`}, {
    116.5, -351.62, 83.64}, {127.95, 62.33, 59.540000000000006`}, {110.05, 
    175.77, 132.58}, {244.29, 236.35000000000002`, 168.25}, {2.55, 220.41, 
    165.78}, {-314.29999999999995`, -197.75, -75.}, {-303.82, 
    51.67, -89.14999999999999}, {-96.08, 
    170.82999999999998`, -24.79}, {-117.39999999999999`, -325.2, 3.15}, {
    298.69, -251.32, 141.66}, {231.42000000000002`, 339.67, 
    207.73000000000002`}, {310.51, 241.41, 78.84}, {293.90999999999997`, 
    174.59, 246.57}, {-268.35, -171.08499999999998`, -60.385}, {-260.195, 
    23.110000000000003`, -71.32}, {-97.62, 115.84, -20.865}, {
    71.33000000000001, 27.474999999999994`, 43.59}, {-113.96, -270.26, 
    0.635}, {183.175, -202.765, 98.26}, {120.31, -290.48, 81.445}, {
    270.46, -213.755, 129.465}, {119., 119.05000000000001`, 96.06}, {56.3, 
    198.09, 149.18}, {237.85500000000002`, 288.01, 187.99}, {277.4, 238.88, 
    123.545}, {269.09999999999997`, 205.47000000000003`, 207.41}}, {
     {RGBColor[0.65, 0.7, 0.7], 
      Line3DBox[{{22, 14}, {23, 15}, {24, 16}, {26, 17}, {29, 18}, {32, 19}, {
       33, 20}, {34, 21}}]}, 
     {RGBColor[0.4, 0.4, 0.4], 
      Line3DBox[{{1, 2}, {1, 6}, {1, 22}, {2, 3}, {2, 23}, {3, 4}, {3, 24}, {
       4, 5}, {4, 25}, {5, 6}, {5, 7}, {6, 26}, {7, 27}, {7, 28}, {30, 11}, {
       11, 12}, {11, 31}, {12, 32}, {12, 33}, {12, 34}}]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], 
      Line3DBox[{{25, 10}, {27, 8}, {28, 9}, {8, 29}, {10, 30}, {31, 
       13}}]}}]},
  Boxed->False,
  Lighting->"Neutral",
  ViewPoint->{-1.2806119487554317`, -0.22856150272106565`, 
   3.119646242152899}]], "Output",
 CellLabel->"Out[3]=",
 CellID->6389636]
}, Open  ]],

Cell["Show the same molecule as space-filling atoms:", "ExampleText",
 CellID->1737899958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/aspirin.mol\>\"", ",", " ", 
   RowBox[{
   "\"\<Rendering\>\"", " ", "\[Rule]", " ", "\"\<Spacefilling\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1767563862],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[3], EdgeForm[None], Specularity[
    GrayLevel[1], 100], 
   GraphicsComplex3DBox[{{-222.40000000000003`, -144.42, \
-45.769999999999996`}, {-216.57000000000002`, -5.45, -53.49}, {-99.16, 
    60.85, -16.939999999999998`}, {14.71, -7.380000000000001, 
    27.639999999999997`}, {7.51, -148.32, 
    33.900000000000006`}, {-110.52, -215.32, -1.8800000000000001`}, {
    124.12, -229.34, 79.25}, {242.23, -176.19, 117.27000000000001`}, {
    116.5, -351.62, 83.64}, {127.95, 62.33, 59.540000000000006`}, {110.05, 
    175.77, 132.58}, {244.29, 236.35000000000002`, 168.25}, {2.55, 220.41, 
    165.78}, {-314.29999999999995`, -197.75, -75.}, {-303.82, 
    51.67, -89.14999999999999}, {-96.08, 
    170.82999999999998`, -24.79}, {-117.39999999999999`, -325.2, 3.15}, {
    298.69, -251.32, 141.66}, {231.42000000000002`, 339.67, 
    207.73000000000002`}, {310.51, 241.41, 78.84}, {293.90999999999997`, 
    174.59, 246.57}}, {
     {RGBColor[0.65, 0.7, 0.7], SphereBox[14, 120.], SphereBox[15, 120.], 
      SphereBox[16, 120.], SphereBox[17, 120.], SphereBox[18, 120.], 
      SphereBox[19, 120.], SphereBox[20, 120.], SphereBox[21, 120.]}, 
     {RGBColor[0.4, 0.4, 0.4], SphereBox[1, 170.], SphereBox[2, 170.], 
      SphereBox[3, 170.], SphereBox[4, 170.], SphereBox[5, 170.], 
      SphereBox[6, 170.], SphereBox[7, 170.], SphereBox[11, 170.], 
      SphereBox[12, 170.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[8, 155.], 
      SphereBox[9, 155.], SphereBox[10, 155.], SphereBox[13, 155.]}}]},
  Boxed->False,
  Lighting->"Neutral",
  ViewPoint->{-1.2806119487554317`, -0.22856150272106565`, 
   3.119646242152899}]], "Output",
 CellLabel->"Out[4]=",
 CellID->1373824996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1121813067],

Cell[TextData[{
 "When importing a molfile that contains a 2D representation of a molecule, \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically renders it as a chemical structure diagram:"
}], "ExampleText",
 CellID->225061664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", "\"\<ExampleData/fluoxetine.mol\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1726103090],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{-98.28, 75.86}, {-98.28, 34.31}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{-98.28, 34.31}, {-98.28, -7.24}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{-98.28, 75.86}, {-62.07, 96.725}}], 
     {RGBColor[0.800498, 0.201504, 0.192061], InsetBox[
       StyleBox["\<\"O\"\>",
        StripOnInput->False,
        FontSize->Scaled[
         0.05017125760923021]], {-25.86, 117.58999999999999`}], 
      LineBox[{{-62.07, 96.725}, {-48.69469902243661, 
       104.43214318963987`}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{-98.28, 75.86}, {-134.485, 96.725}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{-134.485, 96.725}, {-170.69, 117.58999999999999`}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{-98.28, -7.24}, {-134.655, -28.105}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{-134.655, -28.105}, {-171.03, -48.97}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{{-96.1935, -3.6365000000000003`}, {-60.158500000000004`, \
-24.5015}}, {{-100.3665, -10.8435}, {-64.3315, -31.7085}}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{{-60.158500000000004`, -24.5015}, {-24.1235, -45.3665}}, \
{{-64.3315, -31.7085}, {-28.2965, -52.573499999999996`}}}]}}, 
    {RGBColor[0.800498, 0.201504, 0.192061], AbsoluteThickness[0.55], 
     InsetBox[
      StyleBox["\<\"O\"\>",
       StripOnInput->False,
       FontSize->Scaled[0.05017125760923021]], {-25.86, 117.58999999999999`}],
      LineBox[{{-3.0529600478789227`, 104.38425867625901`}, {10.175, 
      96.725}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{10.175, 96.725}, {46.21, 75.86}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{-170.69, 117.58999999999999`}, {-206.55, 
      96.89999999999999}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{-206.55, 96.89999999999999}, {-242.41000000000003`, 
       76.21}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{{-166.858, -48.97}, {-166.858, -90.69}}, {{-175.202, -48.97}, \
{-175.202, -90.69}}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{{-166.858, -90.69}, {-166.858, -132.41}}, {{-175.202, \
-90.69}, {-175.202, -132.41}}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{-26.21, -48.97}, {-26.21, -90.69}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{-26.21, -90.69}, {-26.21, -132.41}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{{50.365, 75.86}, {50.365, 34.31}}, {{42.055, 75.86}, {42.055, 
      34.31}}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{{50.365, 34.31}, {50.365, -7.24}}, {{42.055, 34.31}, {
       42.055, -7.24}}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{46.21, 75.86}, {82.245, 96.725}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{82.245, 96.725}, {118.28, 117.58999999999999`}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{-242.41000000000003`, 76.21}, {-278.62, 97.07}}], 
     {RGBColor[0.291989, 0.437977, 0.888609], InsetBox[
       StyleBox["\<\"N\"\>",
        StripOnInput->False,
        FontSize->Scaled[0.05017125760923021]], {-314.83, 117.93}], 
      LineBox[{{-278.62, 97.07}, {-293.8276233771031, 
       105.8308678168012}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{-171.03, -132.41}, {-134.655, -153.275}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{-134.655, -153.275}, {-98.28, -174.14000000000001`}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{46.21, -7.24}, {82.07000000000001, -28.105}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{82.07000000000001, -28.105}, {117.93, -48.97}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{{120.3665, 121.19349999999999`}, {156.4015, 
      100.32849999999999`}}, {{116.1935, 113.98649999999999`}, {152.2285, 
      93.1215}}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{{156.4015, 100.32849999999999`}, {192.4365, 79.4635}}, {{
       152.2285, 93.1215}, {188.2635, 72.2565}}}]}}, 
    {RGBColor[0.291989, 0.437977, 0.888609], AbsoluteThickness[0.55], 
     InsetBox[
      StyleBox["\<\"N\"\>",
       StripOnInput->False,
       FontSize->Scaled[0.05017125760923021]], {-314.83, 117.93}], 
     LineBox[{{-335.8069461331886, 105.7868309605019}, {-350.865, 97.07}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{-350.865, 97.07}, {-386.90000000000003`, 76.21}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{{115.861, -45.349}, {152.071, -24.659000000000002`}}, {{
      119.99900000000001`, -52.591}, {156.20899999999997`, -31.901}}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{{152.071, -24.659000000000002`}, {
       188.281, -3.9690000000000003`}}, {{156.20899999999997`, -31.901}, {
       192.41899999999998`, -11.210999999999999`}}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{190.35, -7.59}, {226.38, -28.449999999999996`}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{226.38, -28.449999999999996`}, {
       262.40999999999997`, -49.309999999999995`}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{262.40999999999997`, -49.309999999999995`}, {
      301.205, -68.105}}], 
     {RGBColor[0.3856413333333334, 0.57026, 0.27257000000000003`], InsetBox[
       StyleBox["\<\"F\"\>",
        StripOnInput->False,
        FontSize->Scaled[0.05017125760923021]], {340., -86.9}], 
      LineBox[{{301.205, -68.105}, {
       321.99584778501145`, -78.17753471115583}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{262.40999999999997`, -49.309999999999995`}, {
      279.825, -19.824999999999996`}}], 
     {RGBColor[0.3856413333333334, 0.57026, 0.27257000000000003`], InsetBox[
       StyleBox["\<\"F\"\>",
        StripOnInput->False,
        FontSize->Scaled[0.05017125760923021]], {297.24, 9.66}], 
      LineBox[{{279.825, -19.824999999999996`}, {
       287.0659222179619, -7.565534504932128}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{262.40999999999997`, -49.309999999999995`}, {
      242.065, -82.75999999999999}}], 
     {RGBColor[0.3856413333333334, 0.57026, 0.27257000000000003`], InsetBox[
       StyleBox["\<\"F\"\>",
        StripOnInput->False,
        FontSize->Scaled[0.05017125760923021]], {221.72, -116.21}], 
      LineBox[{{242.065, -82.75999999999999}, {
       232.11602237277944`, -99.11749823693916}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{{-24.1235, -136.0135}, {-60.158500000000004`, -156.8785}}, \
{{-28.2965, -128.8065}, {-64.3315, -149.6715}}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{{-60.158500000000004`, -156.8785}, {-96.1935, -177.7435}}, \
{{-64.3315, -149.6715}, {-100.3665, -170.53650000000002`}}}]}}, 
    {RGBColor[0.4, 0.4, 0.4], AbsoluteThickness[0.55], 
     LineBox[{{190.35, 75.86}, {190.35, 34.135}}], 
     {RGBColor[0.4, 0.4, 0.4], 
      LineBox[{{190.35, 34.135}, {190.35, -7.59}}]}}}, {}},
  ImageSize->{{0., 239.1807694649518}, {0., 102.82351435357585`}},
  PlotRange->{{-406.90000000000003`, 360.}, {-182.90210000000002`, 
   146.787253095389}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1259456098]
}, Open  ]],

Cell["\<\
This gives the atom types and their 2D coordinates for the above structure \
diagram:\
\>", "ExampleText",
 CellID->1051024690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/fluoxetine.mol\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"\"\<VertexTypes\>\"", ",", " ", "\"\<VertexCoordinates\>\""}], 
     "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->415010179],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"C\"\>", ",", "\<\"C\"\>", ",", "\<\"O\"\>", ",", "\<\"C\"\>",
      ",", "\<\"C\"\>", ",", "\<\"C\"\>", ",", "\<\"C\"\>", ",", "\<\"C\"\>", 
     ",", "\<\"C\"\>", ",", "\<\"C\"\>", ",", "\<\"C\"\>", ",", "\<\"C\"\>", 
     ",", "\<\"N\"\>", ",", "\<\"C\"\>", ",", "\<\"C\"\>", ",", "\<\"C\"\>", 
     ",", "\<\"C\"\>", ",", "\<\"C\"\>", ",", "\<\"C\"\>", ",", "\<\"F\"\>", 
     ",", "\<\"F\"\>", ",", "\<\"F\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "98.28`"}], ",", "75.86`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "98.28`"}], ",", 
       RowBox[{"-", "7.24`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "25.86`"}], ",", "117.58999999999999`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "170.69`"}], ",", "117.58999999999999`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "171.03`"}], ",", 
       RowBox[{"-", "48.97`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "26.21`"}], ",", 
       RowBox[{"-", "48.97`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"46.21`", ",", "75.86`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "242.41000000000003`"}], ",", "76.21`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "171.03`"}], ",", 
       RowBox[{"-", "132.41`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "26.21`"}], ",", 
       RowBox[{"-", "132.41`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"46.21`", ",", 
       RowBox[{"-", "7.24`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"118.28`", ",", "117.58999999999999`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "314.83`"}], ",", "117.93`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "98.28`"}], ",", 
       RowBox[{"-", "174.14000000000001`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"117.93`", ",", 
       RowBox[{"-", "48.97`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"190.35`", ",", "75.86`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "386.90000000000003`"}], ",", "76.21`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"190.35`", ",", 
       RowBox[{"-", "7.59`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"262.40999999999997`", ",", 
       RowBox[{"-", "49.309999999999995`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"340.`", ",", 
       RowBox[{"-", "86.9`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"297.24`", ",", "9.66`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"221.72`", ",", 
       RowBox[{"-", "116.21`"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->2079814254]
}, Open  ]],

Cell["This creates a molfile from the previous output:", "ExampleText",
 CellID->13866249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", " ", 
  RowBox[{"%", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<MOL\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<VertexTypes\>\"", ",", " ", "\"\<VertexCoordinates\>\""}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5496484],

Cell[BoxData["\<\"\\n\\nCreated by Wolfram Mathematica 6.0\\n 22  0  0     0  \
0            999 V2000\\n   -0.9828    0.7586    0.0000 C   0  0  0  0  0  0  \
         0  0  0\\n   -0.9828   -0.0724    0.0000 C   0  0  0  0  0  0        \
   0  0  0\\n   -0.2586    1.1759    0.0000 O   0  0  0  0  0  0           0  \
0  0\\n   -1.7069    1.1759    0.0000 C   0  0  0  0  0  0           0  0  \
0\\n   -1.7103   -0.4897    0.0000 C   0  0  0  0  0  0           0  0  0\\n  \
 -0.2621   -0.4897    0.0000 C   0  0  0  0  0  0           0  0  0\\n    \
0.4621    0.7586    0.0000 C   0  0  0  0  0  0           0  0  0\\n   \
-2.4241    0.7621    0.0000 C   0  0  0  0  0  0           0  0  0\\n   \
-1.7103   -1.3241    0.0000 C   0  0  0  0  0  0           0  0  0\\n   \
-0.2621   -1.3241    0.0000 C   0  0  0  0  0  0           0  0  0\\n    \
0.4621   -0.0724    0.0000 C   0  0  0  0  0  0           0  0  0\\n    \
1.1828    1.1759    0.0000 C   0  0  0  0  0  0           0  0  0\\n   \
-3.1483    1.1793    0.0000 N   0  0  0  0  0  0           0  0  0\\n   \
-0.9828   -1.7414    0.0000 C   0  0  0  0  0  0           0  0  0\\n    \
1.1793   -0.4897    0.0000 C   0  0  0  0  0  0           0  0  0\\n    \
1.9035    0.7586    0.0000 C   0  0  0  0  0  0           0  0  0\\n   \
-3.8690    0.7621    0.0000 C   0  0  0  0  0  0           0  0  0\\n    \
1.9035   -0.0759    0.0000 C   0  0  0  0  0  0           0  0  0\\n    \
2.6241   -0.4931    0.0000 C   0  0  0  0  0  0           0  0  0\\n    \
3.4000   -0.8690    0.0000 F   0  0  0  0  0  0           0  0  0\\n    \
2.9724    0.0966    0.0000 F   0  0  0  0  0  0           0  0  0\\n    \
2.2172   -1.1621    0.0000 F   0  0  0  0  0  0           0  0  0\\n\\nM  END\
\"\>"], "Output",
 CellLabel->"Out[3]=",
 CellID->1518968255]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MOL - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 12.0592210}", "context" -> "", 
    "keywords" -> {
     "chemistry", "biology", "biochemistry", "molecule", "compound", 
      "geometry"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mime type: chemical/x-mdl-molfile MDL molecule model files. Used in \
cheminformatics applications and on the web for storing and exchanging 3D \
molecule models. Plain text tabular format. Represents a single chemical \
compound. Stores atomic coordinates, chemical bond information, and metadata. \
Maintained by Elsevier Molecular Design Limited (MDL).", "synonyms" -> {}, 
    "title" -> "MOL", "type" -> "Format", "uri" -> "ref/format/MOL"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[19514, 672, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 43720, 1239}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1947, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2570, 73, 101, 4, 70, "ObjectNameAlt",
 CellID->5045],
Cell[2674, 79, 449, 9, 70, "FormatUsage",
 CellID->20778],
Cell[3126, 90, 214, 7, 70, "FormatNotes",
 CellID->5821],
Cell[3343, 99, 202, 7, 70, "FormatNotes",
 CellID->83604582]
}, Open  ]],
Cell[CellGroupData[{
Cell[3582, 111, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[3649, 114, 308, 9, 70, "FormatNotes",
 CellID->2520],
Cell[3960, 125, 345, 11, 70, "FormatNotes",
 CellID->12927],
Cell[4308, 138, 39, 1, 70, "WeakDivider",
 CellID->24773],
Cell[4350, 141, 498, 15, 70, "FormatNotes",
 CellID->25134],
Cell[4851, 158, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[4893, 161, 340, 11, 70, "FormatNotes",
 CellID->22675],
Cell[5236, 174, 574, 20, 70, "FormatNotes",
 CellID->13336],
Cell[5813, 196, 582, 21, 70, "FormatNotes",
 CellID->16334],
Cell[6398, 219, 681, 25, 70, "FormatNotes",
 CellID->21001],
Cell[7082, 246, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[7123, 249, 512, 18, 70, "FormatNotes",
 CellID->9310],
Cell[7638, 269, 1075, 40, 70, "FormatNotes",
 CellID->5974],
Cell[8716, 311, 661, 22, 70, "FormatNotes",
 CellID->7590],
Cell[9380, 335, 816, 28, 70, "FormatNotes",
 CellID->20356],
Cell[10199, 365, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[10240, 368, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[10604, 384, 342, 12, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[10983, 401, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[11037, 404, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[11232, 414, 668, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[11903, 429, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[11945, 432, 61, 1, 70, "FormatNotes",
 CellID->525384128],
Cell[12009, 435, 496, 11, 70, "2ColumnTableMod",
 CellID->263380570],
Cell[12508, 448, 375, 12, 70, "FormatNotes",
 CellID->13037],
Cell[12886, 462, 68, 1, 70, "FormatNotes",
 CellID->13573],
Cell[12957, 465, 1038, 20, 70, "2ColumnTableMod",
 CellID->230773093],
Cell[13998, 487, 603, 19, 70, "FormatNotes",
 CellID->1210665048],
Cell[14604, 508, 69, 1, 70, "FormatNotes",
 CellID->1168456045],
Cell[14676, 511, 366, 9, 70, "2ColumnTableMod",
 CellID->1650280147]
}, Open  ]],
Cell[CellGroupData[{
Cell[15079, 525, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[15131, 528, 196, 8, 70, "FormatNotes",
 CellID->1911960202],
Cell[15330, 538, 1173, 31, 70, "3ColumnTableMod",
 CellID->2123520593],
Cell[16506, 571, 397, 13, 70, "FormatNotes",
 CellID->389608530],
Cell[16906, 586, 75, 1, 70, "FormatNotes",
 CellID->2097373960],
Cell[16984, 589, 395, 10, 70, "3ColumnTableMod",
 CellID->30333],
Cell[17382, 601, 84, 1, 70, "FormatNotes",
 CellID->1728212143],
Cell[17469, 604, 646, 13, 70, "2ColumnTableMod",
 CellID->1345161726]
}, Closed]],
Cell[CellGroupData[{
Cell[18152, 622, 50, 1, 70, "SeeAlsoSection",
 CellID->20829],
Cell[18205, 625, 592, 20, 70, "SeeAlso",
 CellID->73154560]
}, Open  ]],
Cell[CellGroupData[{
Cell[18834, 650, 58, 1, 70, "MoreAboutSection",
 CellID->329426040],
Cell[18895, 653, 150, 2, 70, "MoreAbout"],
Cell[19048, 657, 134, 2, 70, "MoreAbout"],
Cell[19185, 661, 133, 2, 70, "MoreAbout"],
Cell[19321, 665, 156, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19514, 672, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[19630, 678, 59, 1, 70, "ExampleSection",
 CellID->85933691],
Cell[19692, 681, 222, 8, 70, "ExampleText",
 CellID->1072652349],
Cell[CellGroupData[{
Cell[19939, 693, 173, 5, 70, "Input",
 CellID->846844759],
Cell[20115, 700, 339, 8, 70, "Output",
 CellID->1545735844]
}, Open  ]],
Cell[20469, 711, 97, 1, 70, "ExampleText",
 CellID->2022872597],
Cell[CellGroupData[{
Cell[20591, 716, 128, 3, 70, "Input",
 CellID->17199],
Cell[20722, 721, 3363, 58, 70, "Output",
 CellID->1653640730]
}, Open  ]],
Cell[24100, 782, 103, 2, 70, "ExampleText",
 CellID->1899472945],
Cell[CellGroupData[{
Cell[24228, 788, 235, 6, 70, "Input",
 CellID->892684481],
Cell[24466, 796, 2153, 39, 70, "Output",
 CellID->6389636]
}, Open  ]],
Cell[26634, 838, 90, 1, 70, "ExampleText",
 CellID->1737899958],
Cell[CellGroupData[{
Cell[26749, 843, 243, 7, 70, "Input",
 CellID->1767563862],
Cell[26995, 852, 1745, 32, 70, "Output",
 CellID->1373824996]
}, Open  ]],
Cell[28755, 887, 126, 3, 70, "ExampleDelimiter",
 CellID->1121813067],
Cell[28884, 892, 246, 7, 70, "ExampleText",
 CellID->225061664],
Cell[CellGroupData[{
Cell[29155, 903, 144, 4, 70, "Input",
 CellID->1726103090],
Cell[29302, 909, 7447, 148, 70, "Output",
 CellID->1259456098]
}, Open  ]],
Cell[36764, 1060, 137, 4, 70, "ExampleText",
 CellID->1051024690],
Cell[CellGroupData[{
Cell[36926, 1068, 286, 8, 70, "Input",
 CellID->415010179],
Cell[37215, 1078, 2871, 81, 70, "Output",
 CellID->2079814254]
}, Open  ]],
Cell[40101, 1162, 90, 1, 70, "ExampleText",
 CellID->13866249],
Cell[CellGroupData[{
Cell[40216, 1167, 305, 9, 70, "Input",
 CellID->5496484],
Cell[40524, 1178, 1803, 25, 70, "Output",
 CellID->1518968255]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[42366, 1208, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

