(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47831,       1474]
NotebookOptionsPosition[     42517,       1301]
NotebookOutlinePosition[     43957,       1340]
CellTagsIndexPosition[     43871,       1335]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"Graph6\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Graph6"], 
          "\"HarwellBoeing\"" :> 
          Documentation`HelpLookup["paclet:ref/format/HarwellBoeing"], 
          "\"MTP\"" :> Documentation`HelpLookup["paclet:ref/format/MTP"], 
          "\"MTX\"" :> Documentation`HelpLookup["paclet:ref/format/MTX"], 
          "\"Sparse6\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Sparse6"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"Graph6\\\"\"\>", 
       2->"\<\"\\\"HarwellBoeing\\\"\"\>", 3->"\<\"\\\"MTP\\\"\"\>", 
       4->"\<\"\\\"MTX\\\"\"\>", 
       5->"\<\"\\\"Sparse6\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Numerical Data Formats" :> 
          Documentation`HelpLookup["paclet:guide/NumericalDataFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Importing & Exporting\"\>", 
       2->"\<\"Listing of All Formats\"\>", 
       3->"\<\"Numerical Data Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "MPS ",
 StyleBox["(.mps)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell["\<\
MPS mathematical file format.
De facto standard for specifying linear programming (LP) problems.
Commonly used as input format by LP solvers.
MPS is an acronym for Mathematical Programming System. 
Plain text ASCII format, sometimes compressed as binary.
Stores data in a fixed-width tabular form.
Developed in the 1970s at IBM.\
\>", "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " fully supports the ",
 "MPS",
 " format."
}], "FormatNotes",
 CellID->344331575]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mps\>\"", "]"}]], "InlineFormula"],
 " imports an MPS file, returning an expression representing an optimization \
problem."
}], "FormatNotes",
 CellID->28652],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mps\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a list of objective functions and constraints in a form suitable as \
input for ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 "MPS data is represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by real or integer numbers, strings, Boolean values ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " specifications."
}], "FormatNotes",
 CellID->373727629],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mps\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "MPS",
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mps\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mps\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<MPS\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<MPS\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " supports the ",
 "MPS",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Equations\>\"", Cell[
    "list of objective functions and constraints", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LinearProgrammingData\>\"", Cell[
    "vectors and matrices representing a linear program", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ConstraintMatrix\>\"", Cell["\<\
matrix describing the constraints of a linear programming problem
\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1019936196],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Equations\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->31322],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<FreeFormat\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether data fields are loosely or strictly aligned in the file\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EMPS\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether the file is compressed", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->30333]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<Graph6\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Graph6"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<HarwellBoeing\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/HarwellBoeing"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MTP\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MTP"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MTX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MTX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Sparse6\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Sparse6"]], "InlineFormula"]
}], "SeeAlso",
 CellID->269437084]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->210521534],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalDataFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->10391393],

Cell[TextData[{
 "Get a list of ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements from an MPS file:"
}], "ExampleText",
 CellID->2019954481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", 
  RowBox[{"\"\<ExampleData/afiro.mps\>\"", ",", " ", "\"\<Elements\>\""}], 
  " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1101764710],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ConstraintMatrix\"\>", ",", "\<\"Equations\"\>", 
   ",", "\<\"LinearProgrammingData\"\>"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1755476536]
}, Open  ]],

Cell[TextData[{
 "Read an MPS file as a list of objective functions and constraints that is \
an expression suitable for ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1953470391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", "\"\<ExampleData/afiro.mps\>\"", " ", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->976592890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.4`"}], " ", 
       SubscriptBox["\<\"X02\"\>", "\<\"MPS\"\>"]}], "-", 
      RowBox[{"0.32`", " ", 
       SubscriptBox["\<\"X14\"\>", "\<\"MPS\"\>"]}], "-", 
      RowBox[{"0.6`", " ", 
       SubscriptBox["\<\"X23\"\>", "\<\"MPS\"\>"]}], "-", 
      RowBox[{"0.48`", " ", 
       SubscriptBox["\<\"X36\"\>", "\<\"MPS\"\>"]}], "+", 
      RowBox[{"10.`", " ", 
       SubscriptBox["\<\"X39\"\>", "\<\"MPS\"\>"]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1.`"}], " ", 
         SubscriptBox["\<\"X01\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X02\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X03\"\>", "\<\"MPS\"\>"]}]}], "\[Equal]", "0.`"}], 
      "&&", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1.06`"}], " ", 
         SubscriptBox["\<\"X01\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X04\"\>", "\<\"MPS\"\>"]}]}], "\[Equal]", "0.`"}], 
      "&&", 
      RowBox[{
       RowBox[{"1.`", " ", 
        SubscriptBox["\<\"X01\"\>", "\<\"MPS\"\>"]}], "\[LessEqual]", 
       "80.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1.`"}], " ", 
         SubscriptBox["\<\"X02\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.4`", " ", 
         SubscriptBox["\<\"X14\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "0.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1.`"}], " ", 
         SubscriptBox["\<\"X06\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X07\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X08\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X09\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X14\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X15\"\>", "\<\"MPS\"\>"]}]}], "\[Equal]", "0.`"}], 
      "&&", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1.06`"}], " ", 
         SubscriptBox["\<\"X06\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.06`", " ", 
         SubscriptBox["\<\"X07\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"0.96`", " ", 
         SubscriptBox["\<\"X08\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"0.86`", " ", 
         SubscriptBox["\<\"X09\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X16\"\>", "\<\"MPS\"\>"]}]}], "\[Equal]", "0.`"}], 
      "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X06\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X10\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "80.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X07\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X11\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "0.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X08\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X12\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "0.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X09\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X13\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "0.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1.`"}], " ", 
         SubscriptBox["\<\"X22\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X23\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X24\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X25\"\>", "\<\"MPS\"\>"]}]}], "\[Equal]", "0.`"}], 
      "&&", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "0.43`"}], " ", 
         SubscriptBox["\<\"X22\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X26\"\>", "\<\"MPS\"\>"]}]}], "\[Equal]", "0.`"}], 
      "&&", 
      RowBox[{
       RowBox[{"1.`", " ", 
        SubscriptBox["\<\"X22\"\>", "\<\"MPS\"\>"]}], "\[LessEqual]", 
       "500.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1.`"}], " ", 
         SubscriptBox["\<\"X23\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.4`", " ", 
         SubscriptBox["\<\"X36\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "0.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "0.43`"}], " ", 
         SubscriptBox["\<\"X28\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"0.43`", " ", 
         SubscriptBox["\<\"X29\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"0.39`", " ", 
         SubscriptBox["\<\"X30\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"0.37`", " ", 
         SubscriptBox["\<\"X31\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X38\"\>", "\<\"MPS\"\>"]}]}], "\[Equal]", "0.`"}], 
      "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X28\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X29\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X30\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X31\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X36\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X37\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X39\"\>", "\<\"MPS\"\>"]}]}], "\[Equal]", "44.`"}],
       "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X28\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X32\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "500.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X29\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X33\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "0.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X30\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X34\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "0.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X31\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X35\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "0.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"2.364`", " ", 
         SubscriptBox["\<\"X10\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"2.386`", " ", 
         SubscriptBox["\<\"X11\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"2.408`", " ", 
         SubscriptBox["\<\"X12\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"2.429`", " ", 
         SubscriptBox["\<\"X13\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X25\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"2.191`", " ", 
         SubscriptBox["\<\"X32\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"2.219`", " ", 
         SubscriptBox["\<\"X33\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"2.249`", " ", 
         SubscriptBox["\<\"X34\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"2.279`", " ", 
         SubscriptBox["\<\"X35\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "0.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1.`"}], " ", 
         SubscriptBox["\<\"X03\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"0.109`", " ", 
         SubscriptBox["\<\"X22\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "0.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1.`"}], " ", 
         SubscriptBox["\<\"X15\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"0.109`", " ", 
         SubscriptBox["\<\"X28\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"0.108`", " ", 
         SubscriptBox["\<\"X29\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"0.108`", " ", 
         SubscriptBox["\<\"X30\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"0.107`", " ", 
         SubscriptBox["\<\"X31\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "0.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"0.301`", " ", 
         SubscriptBox["\<\"X01\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X24\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "0.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"0.301`", " ", 
         SubscriptBox["\<\"X06\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"0.313`", " ", 
         SubscriptBox["\<\"X07\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"0.313`", " ", 
         SubscriptBox["\<\"X08\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"0.326`", " ", 
         SubscriptBox["\<\"X09\"\>", "\<\"MPS\"\>"]}], "-", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X37\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "0.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X04\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X26\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "310.`"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X16\"\>", "\<\"MPS\"\>"]}], "+", 
        RowBox[{"1.`", " ", 
         SubscriptBox["\<\"X38\"\>", "\<\"MPS\"\>"]}]}], "\[LessEqual]", 
       "300.`"}], "&&", 
      RowBox[{
       SubscriptBox["\<\"X01\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X02\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X03\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X04\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X06\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X07\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X08\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X09\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X10\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X11\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X12\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X13\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X14\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X15\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X16\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X22\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X23\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X24\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X25\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X26\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X28\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X29\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X30\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X31\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X32\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X33\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X34\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X35\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X36\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X37\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X38\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", "0"}], "&&",
       
      RowBox[{
       SubscriptBox["\<\"X39\"\>", "\<\"MPS\"\>"], "\[GreaterEqual]", 
       "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\<\"X01\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X02\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X03\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X04\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X06\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X07\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X08\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X09\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X10\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X11\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X12\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X13\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X14\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X15\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X16\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X22\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X23\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X24\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X25\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X26\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X28\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X29\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X30\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X31\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X32\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X33\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X34\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X35\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X36\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X37\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X38\"\>", "\<\"MPS\"\>"], ",", 
     SubscriptBox["\<\"X39\"\>", "\<\"MPS\"\>"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->93235187]
}, Open  ]],

Cell[TextData[{
 "Use it as input for ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1246866201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", " ", "@@", " ", "%"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1488209246],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "464.75314285714285`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\<\"X01\"\>", "\<\"MPS\"\>"], "\[Rule]", "80.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X02\"\>", "\<\"MPS\"\>"], "\[Rule]", "25.5`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X03\"\>", "\<\"MPS\"\>"], "\[Rule]", "54.5`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X04\"\>", "\<\"MPS\"\>"], "\[Rule]", 
      "84.80000000000001`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X06\"\>", "\<\"MPS\"\>"], "\[Rule]", 
      "18.214285714285715`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X07\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X08\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X09\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X10\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X11\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X12\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X13\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X14\"\>", "\<\"MPS\"\>"], "\[Rule]", 
      "18.214285714285715`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X15\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X16\"\>", "\<\"MPS\"\>"], "\[Rule]", 
      "19.30714285714286`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X22\"\>", "\<\"MPS\"\>"], "\[Rule]", "500.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X23\"\>", "\<\"MPS\"\>"], "\[Rule]", "475.92`"}], ",",
      
     RowBox[{
      SubscriptBox["\<\"X24\"\>", "\<\"MPS\"\>"], "\[Rule]", "24.08`"}], ",", 
     
     RowBox[{
      SubscriptBox["\<\"X25\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X26\"\>", "\<\"MPS\"\>"], "\[Rule]", 
      "215.00000000000003`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X28\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X29\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X30\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X31\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X32\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X33\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X34\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X35\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X36\"\>", "\<\"MPS\"\>"], "\[Rule]", 
      "339.9428571428571`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X37\"\>", "\<\"MPS\"\>"], "\[Rule]", 
      "383.9428571428571`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X38\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      SubscriptBox["\<\"X39\"\>", "\<\"MPS\"\>"], "\[Rule]", "0.`"}]}], 
    "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->590760913]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16314419],

Cell[TextData[{
 "Read MPS data in a form suitable as input for ",
 Cell[BoxData[
  ButtonBox["LinearProgramming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearProgramming"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1244552749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", " ", 
   RowBox[{
   "\"\<ExampleData/afiro.mps\>\"", ",", " ", 
    "\"\<LinearProgrammingData\>\""}], " ", "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1466016964],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "0.4`"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", "0.32`"}], ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", "0.6`"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", "0.48`"}], ",", "0", ",", "0", ",", "10.`"}], "}"}], ",", 
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "83", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 83, ">"],
       Editable->False], ",", 
      RowBox[{"{", 
       RowBox[{"27", ",", "32"}], "}"}]}], "]"}],
    False,
    Editable->False], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"500.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"44.`", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"500.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"310.`", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"300.`", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->408048815]
}, Open  ]],

Cell[TextData[{
 "Use it as input for ",
 Cell[BoxData[
  ButtonBox["LinearProgramming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearProgramming"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1925990717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", " ", "@@", " ", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1771501720],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "80.`", ",", "25.5`", ",", "54.5`", ",", "84.80000000000001`", ",", 
   "18.214285714285715`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",",
    "0.`", ",", "0.`", ",", "0.`", ",", "18.214285714285715`", ",", "0.`", 
   ",", "19.30714285714286`", ",", "500.`", ",", "475.92`", ",", "24.08`", 
   ",", "0.`", ",", "215.00000000000003`", ",", "0.`", ",", "0.`", ",", "0.`",
    ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "339.9428571428571`", ",", "383.9428571428571`", ",", "0.`", ",", "0.`"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->916126032]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1104969388],

Cell["\<\
Import and plot the constraint matrix of the previous example:\
\>", "ExampleText",
 CellID->1929408507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", " ", 
   RowBox[{
   "\"\<ExampleData/afiro.mps\>\"", ",", " ", "\"\<ConstraintMatrix\>\""}], 
   " ", "]"}], " ", "//", "MatrixPlot"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->565707449],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt2XtIU1EYAHCxskgz8pHmqAw0S8WMmJahH2maUYjMIqHIkmZOylelZhEj
fNSifIFgqXMl+yPnoxGNlAmZYKGu0IY6V905c0+1h2RCiyZmRHCDxezO7nfH
5Xd3/jicx3cO57EpOYPFXmJnZ8cwv97md/Z77nkPqHVkRwQ65ncY4dt6QaFL
tAYe8geL9t2VU14uukhV+2O/Uyu2v23a4lTmM51lBNlIdzURrgdGZT8RyFXB
yvBTXQTfCAcUTRdSHfRQst9+da2KIE2XVeeGusjM/WuKKqmS6WBKwYjxiCQo
rx9Kjb49dZzKiAHYOuRRn+g/Cqy2Dx6XX+qsFp9U14/uWqt/UZTO8VlQWB1c
tsYIznJBzBGxHjSvuGfde0dAevxGknTMANqnKUz3MT303ecIvp5Qk6Z/Ds2/
pWszwBNxgE//OgNIuSy5ekpNef3+tYul321Nsjikulzo4vZjM4+zuXQCIgTu
0cxdb+BQaYB3enwydPBAYOc4CZNsYpsu8TVo1z4zhbEToZw9NagonASBf4NX
TZ4S8ryyc3YkxP7Mr7rqjvk3/OP//EN9Pee1tfmncLTAnp9qhBCnELabmwo4
y67FfRnJgdt7ttdKNEaQZPjXOtcRkBKrFi99fA6yNwYfDUsdh4ktM5Ht/gT4
3KxIWFWUCbGmIE+pdhziOkteDKe9BeW9Ym2AMI3y9kbRWRf6fMnWxjVKTzHO
UTqIcY7SQYxzlM6Sxb+10he6/GTjy9Ly4P04PfVc3vFJs5cA3pWY1uJcDXgr
Uw4LTHrS9N4sZvPucBVImo7xAjy04Md8vrMvyQBOLNOgkDECPcuVxX5CLdS4
6os6JQbK6/e7GOeLS1w//NmGmfrSvCAjTMt8RXLpKIjsz2eGneyivFyoZeK8
hNJZsvWGtfLH8YXaspbu42xtH4pSK57joXQQ4xylgxjnKB3EOEfprPuZqwdX
qOUQxbw+FMJVQ3tj0KMHDnrS9PiBFlHcxUFIL49uPN05Ct26DWVsvg5qvC9B
q1AB4wZxEqPiHZhExa6iftuLc9yfor9KNj9bK32hy4/nMPQU1xVz4v3j/y3O
YyidJVuHW5oPjiN0MWqte0mq64Gif+N3keCyag==
   "], {{0, 0}, {32, 27}}, {0, 1}],
  Frame->True,
  FrameLabel->{None, None},
  FrameTicks->{{{{26.5, 
       FormBox["1", TraditionalForm]}, {17.5, 
       FormBox["10", TraditionalForm]}, {7.5, 
       FormBox["20", TraditionalForm]}, {0.5, 
       FormBox["27", TraditionalForm]}}, {{26.5, 
       FormBox["1", TraditionalForm]}, {17.5, 
       FormBox["10", TraditionalForm]}, {7.5, 
       FormBox["20", TraditionalForm]}, {0.5, 
       FormBox["27", TraditionalForm]}}}, {{{0.5, 
       FormBox["1", TraditionalForm]}, {9.5, 
       FormBox["10", TraditionalForm]}, {19.5, 
       FormBox["20", TraditionalForm]}, {31.5, 
       FormBox["32", TraditionalForm]}}, {{0.5, 
       FormBox["1", TraditionalForm]}, {9.5, 
       FormBox["10", TraditionalForm]}, {19.5, 
       FormBox["20", TraditionalForm]}, {31.5, 
       FormBox["32", TraditionalForm]}}}},
  PlotRangeClipping->True]], "Output",
 CellLabel->"Out[1]=",
 CellID->1611239296]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MPS - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 12.4186052}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MPS mathematical file format. De facto standard for specifying linear \
programming (LP) problems. Commonly used as input format by LP solvers. MPS \
is an acronym for Mathematical Programming System. Plain text ASCII format, \
sometimes compressed as binary. Stores data in a fixed-width tabular form. \
Developed in the 1970s at IBM.", "synonyms" -> {}, "title" -> "MPS", "type" -> 
    "Format", "uri" -> "ref/format/MPS"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12309, 440, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 43737, 1328}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1978, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2601, 72, 107, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[2711, 78, 378, 9, 70, "FormatUsage",
 CellID->37585799],
Cell[3092, 89, 214, 9, 70, "FormatNotes",
 CellID->344331575]
}, Open  ]],
Cell[CellGroupData[{
Cell[3343, 103, 53, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[3399, 106, 331, 10, 70, "FormatNotes",
 CellID->28652],
Cell[3733, 118, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[3775, 121, 483, 16, 70, "FormatNotes",
 CellID->28396],
Cell[4261, 139, 577, 21, 70, "FormatNotes",
 CellID->373727629],
Cell[4841, 162, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[4883, 165, 352, 13, 70, "FormatNotes",
 CellID->29174],
Cell[5238, 180, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[5815, 202, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[6398, 225, 703, 25, 70, "FormatNotes",
 CellID->32611],
Cell[7104, 252, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[7145, 255, 236, 9, 70, "FormatNotes",
 CellID->16216],
Cell[7384, 266, 216, 9, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[7637, 280, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[7696, 283, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[7895, 293, 672, 13, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[8570, 308, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[8614, 311, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[8689, 314, 714, 15, 70, "2ColumnTableMod",
 CellID->1019936196],
Cell[9406, 331, 263, 9, 70, "FormatNotes",
 CellID->1999285391]
}, Open  ]],
Cell[CellGroupData[{
Cell[9706, 345, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[9758, 348, 178, 7, 70, "FormatNotes",
 CellID->31322],
Cell[9939, 357, 694, 18, 70, "3ColumnTableMod",
 CellID->30333]
}, Closed]],
Cell[CellGroupData[{
Cell[10670, 380, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[10728, 383, 1039, 34, 70, "SeeAlso",
 CellID->269437084]
}, Open  ]],
Cell[CellGroupData[{
Cell[11804, 422, 58, 1, 70, "MoreAboutSection",
 CellID->210521534],
Cell[11865, 425, 134, 2, 70, "MoreAbout"],
Cell[12002, 429, 133, 2, 70, "MoreAbout"],
Cell[12138, 433, 134, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12309, 440, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[12425, 446, 59, 1, 70, "ExampleSection",
 CellID->10391393],
Cell[12487, 449, 220, 8, 70, "ExampleText",
 CellID->2019954481],
Cell[CellGroupData[{
Cell[12732, 461, 187, 5, 70, "Input",
 CellID->1101764710],
Cell[12922, 468, 198, 5, 70, "Output",
 CellID->1755476536]
}, Open  ]],
Cell[13135, 476, 289, 9, 70, "ExampleText",
 CellID->1953470391],
Cell[CellGroupData[{
Cell[13449, 489, 143, 4, 70, "Input",
 CellID->976592890],
Cell[13595, 495, 15378, 405, 70, "Output",
 CellID->93235187]
}, Open  ]],
Cell[28988, 903, 206, 8, 70, "ExampleText",
 CellID->1246866201],
Cell[CellGroupData[{
Cell[29219, 915, 112, 3, 70, "Input",
 CellID->1488209246],
Cell[29334, 920, 3250, 81, 70, "Output",
 CellID->590760913]
}, Open  ]],
Cell[32599, 1004, 124, 3, 70, "ExampleDelimiter",
 CellID->16314419],
Cell[32726, 1009, 248, 8, 70, "ExampleText",
 CellID->1244552749],
Cell[CellGroupData[{
Cell[32999, 1021, 225, 7, 70, "Input",
 CellID->1466016964],
Cell[33227, 1030, 5543, 165, 70, "Output",
 CellID->408048815]
}, Open  ]],
Cell[38785, 1198, 222, 8, 70, "ExampleText",
 CellID->1925990717],
Cell[CellGroupData[{
Cell[39032, 1210, 120, 3, 70, "Input",
 CellID->1771501720],
Cell[39155, 1215, 632, 12, 70, "Output",
 CellID->916126032]
}, Open  ]],
Cell[39802, 1230, 126, 3, 70, "ExampleDelimiter",
 CellID->1104969388],
Cell[39931, 1235, 114, 3, 70, "ExampleText",
 CellID->1929408507],
Cell[CellGroupData[{
Cell[40070, 1242, 238, 7, 70, "Input",
 CellID->565707449],
Cell[40311, 1251, 2140, 43, 70, "Output",
 CellID->1611239296]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[42490, 1299, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

