(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     67801,       1601]
NotebookOptionsPosition[     62355,       1429]
NotebookOutlinePosition[     63910,       1470]
CellTagsIndexPosition[     63824,       1465]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"CSV\"" :> Documentation`HelpLookup["paclet:ref/format/CSV"], 
          "\"Graph6\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Graph6"], 
          "\"HarwellBoeing\"" :> 
          Documentation`HelpLookup["paclet:ref/format/HarwellBoeing"], 
          "\"MAT\"" :> Documentation`HelpLookup["paclet:ref/format/MAT"], 
          "\"MPS\"" :> Documentation`HelpLookup["paclet:ref/format/MPS"], 
          "\"MTP\"" :> Documentation`HelpLookup["paclet:ref/format/MTP"], 
          "\"Sparse6\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Sparse6"], "\"TSV\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TSV"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"CSV\\\"\"\>", 
       2->"\<\"\\\"Graph6\\\"\"\>", 3->"\<\"\\\"HarwellBoeing\\\"\"\>", 
       4->"\<\"\\\"MAT\\\"\"\>", 5->"\<\"\\\"MPS\\\"\"\>", 
       6->"\<\"\\\"MTP\\\"\"\>", 7->"\<\"\\\"Sparse6\\\"\"\>", 
       8->"\<\"\\\"TSV\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Mathematical Data" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalData"], 
          "Mathematical Data Formats" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalDataFormats"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Numerical Data Formats" :> 
          Documentation`HelpLookup["paclet:guide/NumericalDataFormats"], 
          "Sparse Arrays" :> 
          Documentation`HelpLookup["paclet:guide/SparseArrays"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Importing & Exporting\"\>", 
       2->"\<\"Listing of All Formats\"\>", 3->"\<\"Mathematical Data\"\>", 
       4->"\<\"Mathematical Data Formats\"\>", 
       5->"\<\"Matrices and Linear Algebra\"\>", 
       6->"\<\"Numerical Data Formats\"\>", 
       7->"\<\"Sparse Arrays\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "MTX ",
 StyleBox["(.mtx)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell["\<\
Matrix Market matrix format.
Used for exchanging and storing test matrices.
Plain text format.
File format of the NIST Matrix Market collection of standard test matrices.
Stores numerical or pattern matrices in a dense (\"array format\") or sparse \
(\"coordinate format\") representation.
Developed in 1996 by R. Boisvert, R. Pozo, K. Remington and J. Dongarra.
Maintained by the U.S. National Institute of Standards and Technology (NIST).\
\
\>", "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the ",
 "Matrix Market",
 " file format."
}], "FormatNotes",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtx\>\"", "]"}]], "InlineFormula"],
 "imports matrix data from a Matrix Market file."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtx\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports any numerical or pattern matrix to a ",
 "Matrix Market",
 " file."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtx\>\"", "]"}], " "}]], "InlineFormula"],
 "reads an MTX matrix file and returns an array."
}], "FormatNotes",
 CellID->25134],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " converts \"array format\" files to packed arrays and \"coordinate format\" \
files to sparse arrays."
}], "FormatNotes",
 CellID->571675508],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtx\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a ",
 "Matrix Market",
 " file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<MTX\>\""}], "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<MTX\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtx\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a Matrix Market file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtx\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "Matrix Market",
 " file format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Data representation elements:", "FormatNotes",
 CellID->2010768115],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "matrix data given as a packed or sparse array", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Graphics\>\"", Cell[
    "a visual representation of the values of the matrix elements", 
     "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->29555966],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element by default. "
}], "FormatNotes",
 CellID->7162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtx\>\"", ",", "\"\<Graphics\>\""}], "]"}]], 
  "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " to render the matrix structure as graphics."
}], "FormatNotes",
 CellID->394933343],

Cell["Meta-information elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Comments\>\"", Cell[
    "user comments stored in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MatrixStructure\>\"", Cell[
    "symmetry properties of the matrix", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->977886736],

Cell[TextData[{
 "Possible values for",
 Cell[BoxData[
  RowBox[{" ", "\"\<MatrixStructure\>\""}]], "InlineFormula"],
 " are:"
}], "FormatNotes",
 CellID->678398105],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Hermitian\>\"", Cell[
    "matrix which is equal to its own conjugate transpose", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<General\>\"", Cell[
    "matrix without transposition symmetry", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SkewSymmetric\>\"", Cell[
    "matrix whose transpose is also its negative", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Symmetric\>\"", Cell[
    "matrix which is equal to its transpose ", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->846268812]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<CSV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/CSV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Graph6\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Graph6"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<HarwellBoeing\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/HarwellBoeing"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MAT\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MAT"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MPS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MPS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MTP\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MTP"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Sparse6\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Sparse6"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TSV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TSV"]], "InlineFormula"]
}], "SeeAlso",
 CellID->629914528]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->661059097],

Cell["\<\
This imports a sparse matrix from a MTX sample file, giving a visual \
representation of it: \
\>", "ExampleText",
 CellID->1813340629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", 
  RowBox[{
  "\"\<ExampleData/bcsstk08.mtx.gz\>\"", ",", " ", "\"\<Graphics\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17199],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzs3XlYTe/+P34pkanekZKiaBAJIYSeVIYyVzKUqaQ0yBgqmVIhJHPGMhbJ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   "], {{0, 0}, {120, 120}}, {0, 1}],
  Frame->True,
  FrameLabel->{None, None},
  FrameTicks->{{{{119.94413407821229`, 
       FormBox["1", TraditionalForm]}, {64.1899441340782, 
       FormBox["500", TraditionalForm]}, {0.055865921787709494`, 
       FormBox["1074", TraditionalForm]}}, {{119.94413407821229`, 
       FormBox["1", TraditionalForm]}, {64.1899441340782, 
       FormBox["500", TraditionalForm]}, {0.055865921787709494`, 
       FormBox["1074", TraditionalForm]}}}, {{{0.055865921787709494`, 
       FormBox["1", TraditionalForm]}, {55.81005586592178, 
       FormBox["500", TraditionalForm]}, {119.94413407821229`, 
       FormBox["1074", TraditionalForm]}}, {{0.055865921787709494`, 
       FormBox["1", TraditionalForm]}, {55.81005586592178, 
       FormBox["500", TraditionalForm]}, {119.94413407821229`, 
       FormBox["1074", TraditionalForm]}}}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1678372462]
}, Open  ]],

Cell["Import this file as a sparse array object:", "ExampleText",
 CellID->381925909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", "\"\<ExampleData/bcsstk08.mtx.gz\>\"", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->968990569],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "12960", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 12960, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1074", ",", "1074"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]=",
 CellID->1455997982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->200131680],

Cell["This exports a 2-by-2 matrix to MTX:", "ExampleText",
 CellID->653754558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.", ",", "3."}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"5.", ",", "0."}], "}"}]}], "}"}], ",", " ", "\"\<MTX\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1514029619],

Cell[BoxData["\<\"%%MatrixMarket matrix array real general\\n%Created by \
Wolfram Mathematica 6.0\\n2 2\\n   0.0000000000000000E+00\\n   \
5.0000000000000000E+00\\n   3.0000000000000000E+00\\n   \
0.0000000000000000E+00\\n\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->584665906]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->572305902],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "3.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1742197117]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Mathematical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalData"]], "MoreAbout"],

Cell[TextData[ButtonBox["Mathematical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalDataFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalDataFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SparseArrays"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MTX - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 13.0592466}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Matrix Market matrix format. Used for exchanging and storing test \
matrices. Plain text format. File format of the NIST Matrix Market collection \
of standard test matrices. Stores numerical or pattern matrices in a dense \
(\"array format\") or sparse (\"coordinate format\") representation. \
Developed in 1996 by R. Boisvert, R. Pozo, K. Remington and J. Dongarra. \
Maintained by the U.S. National Institute of Standards and Technology \
(NIST).", "synonyms" -> {}, "title" -> "MTX", "type" -> "Format", "uri" -> 
    "ref/format/MTX"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17634, 608, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 63690, 1458}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2895, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3518, 87, 101, 4, 70, "ObjectNameAlt",
 CellID->5045],
Cell[3622, 93, 489, 11, 70, "FormatUsage",
 CellID->20778],
Cell[4114, 106, 348, 14, 70, "FormatNotes",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[4499, 125, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[4566, 128, 291, 9, 70, "FormatNotes",
 CellID->2520],
Cell[4860, 139, 369, 13, 70, "FormatNotes",
 CellID->12927],
Cell[5232, 154, 39, 1, 70, "WeakDivider",
 CellID->24773],
Cell[5274, 157, 314, 10, 70, "FormatNotes",
 CellID->25134],
Cell[5591, 169, 208, 6, 70, "FormatNotes",
 CellID->571675508],
Cell[5802, 177, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[5844, 180, 361, 13, 70, "FormatNotes",
 CellID->22675],
Cell[6208, 195, 574, 20, 70, "FormatNotes",
 CellID->13336],
Cell[6785, 217, 582, 21, 70, "FormatNotes",
 CellID->16334],
Cell[7370, 240, 681, 25, 70, "FormatNotes",
 CellID->21001],
Cell[8054, 267, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[8095, 270, 523, 18, 70, "FormatNotes",
 CellID->9310],
Cell[8621, 290, 1075, 40, 70, "FormatNotes",
 CellID->5974],
Cell[9699, 332, 661, 22, 70, "FormatNotes",
 CellID->7590],
Cell[10363, 356, 816, 28, 70, "FormatNotes",
 CellID->20356],
Cell[11182, 386, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[11223, 389, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[11587, 405, 367, 14, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[11991, 424, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[12045, 427, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[12240, 437, 667, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[12910, 452, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[12952, 455, 73, 1, 70, "FormatNotes",
 CellID->2010768115],
Cell[13028, 458, 538, 12, 70, "2ColumnTableMod",
 CellID->29555966],
Cell[13569, 472, 253, 9, 70, "FormatNotes",
 CellID->7162],
Cell[13825, 483, 470, 16, 70, "FormatNotes",
 CellID->394933343],
Cell[14298, 501, 65, 1, 70, "FormatNotes",
 CellID->13573],
Cell[14366, 504, 504, 11, 70, "2ColumnTableMod",
 CellID->977886736],
Cell[14873, 517, 165, 6, 70, "FormatNotes",
 CellID->678398105],
Cell[15041, 525, 803, 15, 70, "2ColumnTableMod",
 CellID->846268812]
}, Open  ]],
Cell[CellGroupData[{
Cell[15881, 545, 50, 1, 70, "SeeAlsoSection",
 CellID->20829],
Cell[15934, 548, 1663, 55, 70, "SeeAlso",
 CellID->629914528]
}, Open  ]],
Cell[CellGroupData[{
Cell[17634, 608, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[17750, 614, 60, 1, 70, "ExampleSection",
 CellID->661059097],
Cell[17813, 617, 145, 4, 70, "ExampleText",
 CellID->1813340629],
Cell[CellGroupData[{
Cell[17983, 625, 186, 6, 70, "Input",
 CellID->17199],
Cell[18172, 633, 41194, 679, 70, "Output",
 CellID->1678372462]
}, Open  ]],
Cell[59381, 1315, 85, 1, 70, "ExampleText",
 CellID->381925909],
Cell[CellGroupData[{
Cell[59491, 1320, 144, 4, 70, "Input",
 CellID->968990569],
Cell[59638, 1326, 406, 14, 70, "Output",
 CellID->1455997982]
}, Open  ]],
Cell[60059, 1343, 125, 3, 70, "ExampleDelimiter",
 CellID->200131680],
Cell[60187, 1348, 79, 1, 70, "ExampleText",
 CellID->653754558],
Cell[CellGroupData[{
Cell[60291, 1353, 319, 11, 70, "Input",
 CellID->1514029619],
Cell[60613, 1366, 283, 5, 70, "Output",
 CellID->584665906]
}, Open  ]],
Cell[CellGroupData[{
Cell[60933, 1376, 108, 3, 70, "Input",
 CellID->572305902],
Cell[61044, 1381, 223, 8, 70, "Output",
 CellID->1742197117]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61328, 1396, 38, 0, 70, "MoreAboutSection"],
Cell[61369, 1398, 134, 2, 70, "MoreAbout"],
Cell[61506, 1402, 133, 2, 70, "MoreAbout"],
Cell[61642, 1406, 125, 2, 70, "MoreAbout"],
Cell[61770, 1410, 140, 2, 70, "MoreAbout"],
Cell[61913, 1414, 143, 2, 70, "MoreAbout"],
Cell[62059, 1418, 134, 2, 70, "MoreAbout"],
Cell[62196, 1422, 117, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[62328, 1427, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

