(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24540,        851]
NotebookOptionsPosition[     19468,        692]
NotebookOutlinePosition[     21240,        736]
CellTagsIndexPosition[     21155,        731]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"ExpressionML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/ExpressionML"], 
          "\"LaTeX\"" :> Documentation`HelpLookup["paclet:ref/format/LaTeX"], 
          "\"MathML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/MathML"], "\"MX\"" :> 
          Documentation`HelpLookup["paclet:ref/format/MX"], "\"Package\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Package"], "\"TeX\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TeX"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"ExpressionML\\\"\"\>", 
       2->"\<\"\\\"LaTeX\\\"\"\>", 3->"\<\"\\\"MathML\\\"\"\>", 
       4->"\<\"\\\"MX\\\"\"\>", 5->"\<\"\\\"Package\\\"\"\>", 
       6->"\<\"\\\"TeX\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Formats" :> 
          Documentation`HelpLookup["paclet:guide/BasicFormats"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Basic Formats\"\>", 
       2->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "NB ",
 StyleBox["(.nb)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->3676],

Cell[TextData[{
 "Registered MIME type: ",
 StyleBox["application/mathematica", "InlineCode"],
 StyleBox["\nMathematica",
  FontSlant->"Italic"],
 " notebooks.\nUsed for storing and exchanging ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input and output and for the creation of interactive technical documents.\n\
Native file format of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook interface.\nASCII format based on the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression syntax.\nStores text, typeset expressions, graphics, \
animations, sounds, and other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input and output.\nSupports interactive elements like hyperlinks, buttons, \
sliders, and other graphical user interface features. \nUses external or \
embedded style sheets for specifying the appearance on screen and in print.\n\
Developed since 1988 by Wolfram Research."
}], "FormatUsage",
 CellID->29643],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook format."
}], "FormatNotes",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).nb\>\"", "]"}]], "InlineFormula"],
 "reads a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook and returns it as a ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " expression."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).nb\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " or box expression as well as arbitrary mathematical expressions as a \
notebook."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).nb\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a notebook."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).nb\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).nb\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<NB\>\""}], "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<NB\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).nb\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a notebook by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).nb\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).nb\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).nb\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Put",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Put"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).nb\>\""}], "]"}]], "InlineFormula"],
 " can be used to export multiple expressions."
}], "FormatNotes",
 CellID->104113528],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the notebook format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->1615],

Cell[TextData[{
 "In the notebook front end, ",
 StyleBox["Save", "MenuName"],
 " and ",
 StyleBox["Save As", "MenuName"],
 " can be used to save the current notebook to a file."
}], "FormatNotes",
 CellID->2609]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Initialization\>\"", Cell["\<\
reads and evaluates all initializaton cells, returning the results as a list\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Notebook\>\"", Cell[TextData[{
     "notebook represented as a ",
     Cell[BoxData[
      ButtonBox["Notebook",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
     " expression"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NotebookObject\>\"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NotebookObject",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
     " expression"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Plaintext\>\"", Cell[
    "plain text version of the notebook", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->230773093],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<Notebook\>\""], "InlineFormula"],
 " element for notebook files."
}], "FormatNotes",
 CellID->13037]
}, Open  ]],

Cell["OPTIONS", "OptionsSection",
 CellID->25476],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->19008],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<ExpressionML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ExpressionML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LaTeX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LaTeX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MathML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Package\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Package"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TeX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TeX"]], "InlineFormula"]
}], "SeeAlso",
 CellID->666558934]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->195477949],

Cell[TextData[ButtonBox["Basic Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->9381043],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in a sample file:"
}], "ExampleText",
 CellID->2065206152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{"\"\<ExampleData/document.nb\>\"", ",", " ", "\"\<Elements\>\""}], 
   "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->927891765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Initialization\"\>", ",", "\<\"Notebook\"\>", 
   ",", "\<\"NotebookObject\"\>", ",", "\<\"Plaintext\"\>"}], "}"}]], "Output",\

 CellLabel->"Out[1]=",
 CellID->1091682383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1953014760],

Cell["\<\
Convert an arbitrary mathematical expression to the notebook format:\
\>", "ExampleText",
 CellID->31526925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"3", "+", "x"}], "]"}], ",", "\"\<NB\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1592051313],

Cell[BoxData["\<\"(* Content-type: application/mathematica *)\\n\\n(*** \
Wolfram Notebook File ***)\\n(* http://www.wolfram.com/nb *)\\n\\n(* \
CreatedBy='Mathematica 6.0' *)\\n\\n(*CacheID: 234*)\\n(* Internal cache \
information:\\nNotebookFileLineBreakTest\\nNotebookFileLineBreakTest\\\
nNotebookDataPosition[       145,          7]\\nNotebookDataLength[       \
801,         36]\\nNotebookOptionsPosition[       633,         \
25]\\nNotebookOutlinePosition[       894,         \
38]\\nCellTagsIndexPosition[       851,         \
35]\\nWindowFrame->Normal\\nContainsDynamic->False*)\\n\\n(* Beginning of \
Notebook Content *)\\nNotebook[{\\nCell[BoxData[\\n SqrtBox[\\n  \
RowBox[{\\\"3\\\", \\\"+\\\", \\\"x\\\"}]]], \
\\\"Input\\\"]\\n},\\nFrontEndVersion->\\\"6.0 for Mac OS X x86 (32-bit) \
(April 2, 2007)\\\",\\nStyleDefinitions->\\\"Default.nb\\\"\\n]\\n(* End of \
Notebook Content *)\\n\\n(* Internal cache information *)\\n(*CellTagsOutline\
\\nCellTagsIndex->{}\\n*)\\n(*CellTagsIndex\\nCellTagsIndex->{}\\n*)\\n(*\
NotebookFileOutline\\nNotebook[{\\nCell[568, 21, 61, 2, 70, \
\\\"Input\\\"]\\n}\\n]\\n*)\\n\\n(* End of internal cache information *)\\n\"\
\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->186933916]
}, Open  ]],

Cell["Import plain text contents from the previous output:", "ExampleText",
 CellID->1699621882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"%", ",", " ", "\"\<Plaintext\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29750651],

Cell[BoxData["\<\"\[Sqrt]3 + x\\n\\n\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1802985253]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NB - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 13.5748848}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Registered MIME type: application/mathematica Mathematica notebooks. \
Used for storing and exchanging Mathematica input and output and for the \
creation of interactive technical documents. Native file format of the \
Mathematica notebook interface. ASCII format based on the Mathematica \
expression syntax. Stores text, typeset expressions, graphics, animations, \
sounds, and other Mathematica input and output. Supports interactive elements \
like hyperlinks, buttons, sliders, and other graphical user interface \
features. Uses external or embedded style sheets for specifying the \
appearance on screen and in print. Developed since 1988 by Wolfram Research.",
     "synonyms" -> {}, "title" -> "NB", "type" -> "Format", "uri" -> 
    "ref/format/NB"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16452, 592, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21021, 724}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1885, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2508, 69, 99, 4, 70, "ObjectNameAlt",
 CellID->3676],
Cell[2610, 75, 967, 24, 70, "FormatUsage",
 CellID->29643],
Cell[3580, 101, 383, 15, 70, "FormatNotes",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[4000, 121, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[4067, 124, 472, 17, 70, "FormatNotes",
 CellID->2520],
Cell[4542, 143, 627, 22, 70, "FormatNotes",
 CellID->12927],
Cell[5172, 167, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[5214, 170, 340, 11, 70, "FormatNotes",
 CellID->22675],
Cell[5557, 183, 573, 20, 70, "FormatNotes",
 CellID->13336],
Cell[6133, 205, 581, 21, 70, "FormatNotes",
 CellID->16334],
Cell[6717, 228, 674, 24, 70, "FormatNotes",
 CellID->21001],
Cell[7394, 254, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[7435, 257, 512, 18, 70, "FormatNotes",
 CellID->9310],
Cell[7950, 277, 1074, 40, 70, "FormatNotes",
 CellID->5974],
Cell[9027, 319, 660, 22, 70, "FormatNotes",
 CellID->7590],
Cell[9690, 343, 815, 28, 70, "FormatNotes",
 CellID->20356],
Cell[10508, 373, 504, 17, 70, "FormatNotes",
 CellID->104113528],
Cell[11015, 392, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[11056, 395, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[11420, 411, 347, 12, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[11804, 428, 69, 1, 70, "NotebookInterfaceSection",
 CellID->1615],
Cell[11876, 431, 212, 7, 70, "FormatNotes",
 CellID->2609]
}, Closed]],
Cell[CellGroupData[{
Cell[12125, 443, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[12179, 446, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[12374, 456, 668, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[13045, 471, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[13087, 474, 179, 7, 70, "FormatNotes",
 CellID->13573],
Cell[13269, 483, 1127, 27, 70, "2ColumnTableMod",
 CellID->230773093],
Cell[14399, 512, 276, 9, 70, "FormatNotes",
 CellID->13037]
}, Open  ]],
Cell[14690, 524, 49, 1, 70, "OptionsSection",
 CellID->25476],
Cell[CellGroupData[{
Cell[14764, 529, 50, 1, 70, "SeeAlsoSection",
 CellID->19008],
Cell[14817, 532, 1247, 41, 70, "SeeAlso",
 CellID->666558934]
}, Open  ]],
Cell[CellGroupData[{
Cell[16101, 578, 58, 1, 70, "MoreAboutSection",
 CellID->195477949],
Cell[16162, 581, 117, 2, 70, "MoreAbout"],
Cell[16282, 585, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16452, 592, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[16568, 598, 58, 1, 70, "ExampleSection",
 CellID->9381043],
Cell[16629, 601, 225, 8, 70, "ExampleText",
 CellID->2065206152],
Cell[CellGroupData[{
Cell[16879, 613, 198, 6, 70, "Input",
 CellID->927891765],
Cell[17080, 621, 216, 6, 70, "Output",
 CellID->1091682383]
}, Open  ]],
Cell[17311, 630, 126, 3, 70, "ExampleDelimiter",
 CellID->1953014760],
Cell[17440, 635, 118, 3, 70, "ExampleText",
 CellID->31526925],
Cell[CellGroupData[{
Cell[17583, 642, 198, 6, 70, "Input",
 CellID->1592051313],
Cell[17784, 650, 1231, 19, 70, "Output",
 CellID->186933916]
}, Open  ]],
Cell[19030, 672, 96, 1, 70, "ExampleText",
 CellID->1699621882],
Cell[CellGroupData[{
Cell[19151, 677, 151, 4, 70, "Input",
 CellID->29750651],
Cell[19305, 683, 97, 2, 70, "Output",
 CellID->1802985253]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[19441, 690, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

