(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    302314,       5589]
NotebookOptionsPosition[    296386,       5394]
NotebookOutlinePosition[    297721,       5432]
CellTagsIndexPosition[    297634,       5427]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"3DS\"" :> Documentation`HelpLookup["paclet:ref/format/3DS"], 
          "\"BYU\"" :> Documentation`HelpLookup["paclet:ref/format/BYU"], 
          "\"JVX\"" :> Documentation`HelpLookup["paclet:ref/format/JVX"], 
          "\"LWO\"" :> Documentation`HelpLookup["paclet:ref/format/LWO"], 
          "\"Maya\"" :> Documentation`HelpLookup["paclet:ref/format/Maya"], 
          "\"OFF\"" :> Documentation`HelpLookup["paclet:ref/format/OFF"], 
          "\"POV\"" :> Documentation`HelpLookup["paclet:ref/format/POV"], 
          "\"RIB\"" :> Documentation`HelpLookup["paclet:ref/format/RIB"], 
          "\"STL\"" :> Documentation`HelpLookup["paclet:ref/format/STL"], 
          "\"X3D\"" :> Documentation`HelpLookup["paclet:ref/format/X3D"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"3DS\\\"\"\>", 
       2->"\<\"\\\"BYU\\\"\"\>", 3->"\<\"\\\"JVX\\\"\"\>", 
       4->"\<\"\\\"LWO\\\"\"\>", 5->"\<\"\\\"Maya\\\"\"\>", 
       6->"\<\"\\\"OFF\\\"\"\>", 7->"\<\"\\\"POV\\\"\"\>", 
       8->"\<\"\\\"RIB\\\"\"\>", 9->"\<\"\\\"STL\\\"\"\>", 
       10->"\<\"\\\"X3D\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"3D Geometry & Modeling Formats\"\>", 
       2->"\<\"Graphics Importing & Exporting\"\>", 
       3->"\<\"Importing & Exporting\"\>", 
       4->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "OBJ ",
 StyleBox["(.obj)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell["\<\
Wavefront OBJ format.
3D geometry format.
Used for storage and exchange of 3D geometry definitions.
Native format of the Wavefront application.
Developed by Alias Wavefront.
ASCII format.
An OBJ file stores a single object.\
\>", "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support the OBJ file format."
}], "FormatNotes",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).obj\>\"", "]"}]], "InlineFormula"],
 "imports an ",
 "OBJ",
 " file ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).obj\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " expression to an OBJ file."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).obj\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "[", " ", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    RowBox[{
     StyleBox["vertices", "TI"], ",", 
     StyleBox["primitives", "TI"], ",", 
     StyleBox["opts", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->25134],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).obj\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "OBJ",
 " file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).obj\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).obj\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<OBJ\>\""}], "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<OBJ\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).obj\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates an OBJ file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).obj\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).obj\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).obj\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the OBJ format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Data representation elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "OBJ",
     " file represented as a ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsComplex\>\"", Cell[
    TextData[{
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " object, representing the geometry stored in the file"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LineData\>\"", Cell[TextData[{
     "lines represented as lists of indices, referencing the vertices as \
given by the ",
     Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"],
     " element"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LineObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Line",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Line"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PointData\>\"", Cell[
    "point data in indexed form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PointObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Point",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Point"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonData\>\"", Cell[
    "polygon data in indexed form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexData\>\"", Cell[
    "list of vertex coordinates", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexNormals\>\"", Cell[TextData[{
     "normal vectors corresponding to the vertices given by ",
     Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->230773093],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Graphics3D\>\""], "InlineFormula"],
 " element by default for OBJ files."
}], "FormatNotes",
 CellID->13037],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"],
 " element corresponds to the first argument of ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->4998]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1911960202],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what background color to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall size of the graphics to display", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Lighting",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Lighting"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what simulated lighting to use in coloring 3D surfaces", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->2123520593],

Cell[TextData[{
 "All options of ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " can be given when importing from OBJ."
}], "FormatNotes",
 CellID->1022956994],

Cell["Advanced options:", "FormatNotes",
 CellID->2132824898],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<InvertNormals\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to invert the orientation of vertex normals", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VerticalAxis\>\"", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}], Cell["\<\
orientation to assume for the coordinate system used in the file\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->28047],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that in the coordinate system used by the OBJ format the vertical \
axis corresponds to the third coordinate."
}], "FormatNotes",
 CellID->1642809193],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<VerticalAxis\>\"", "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will apply the transformation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     RowBox[{"-", 
      StyleBox["z", "TI"]}], ",", 
     StyleBox["y", "TI"]}], "}"}], " "}]], "InlineFormula"],
 "to all graphics coordinates when importing from OBJ, and the inverse \
transformation when exporting to OBJ."
}], "FormatNotes",
 CellID->182941150]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<3DS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/3DS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<BYU\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/BYU"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JVX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JVX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LWO\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LWO"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Maya\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Maya"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<POV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/POV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<RIB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/RIB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<STL\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/STL"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<X3D\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/X3D"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2645]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->248267631],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->338000525],

Cell["Import an OBJ example file:", "ExampleText",
 CellID->1715972221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/wrench.obj.gz\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17199],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[None], GraphicsComplex3DBox[CompressedData["
1:eJxtXWWc10bXzS7L7rJAcVhsybJAkVK8UDQ4FKdosUBxd5fg7hSX4MXdZYMX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    "], Polygon3DBox[CompressedData["
1:eJxNnXe8j/X//12X67L33nvvEUKy98reSUL23jtJdkJC9t4kZIVkZadIklRk
k9WQfK/H53l//X7nj8ftcb8/z3HO833O6RPPr6tv9jd7N+7lx4oV607SWLFi
R+1FkYsDXBxGicPbPFwcN0o83hbi4vhREvC2uLg4YZREvC0+Lk4cJQlvS4gn
YofYvC0xnoSPlYDPlYhZApKEeRzYJ0n4WPHZKeRjJmSWmHbzkNeamNbnjr5M
sZJFSR4lBaxZSmap8OTMUjNLg6dilpZZOjwNs/TMMuDpmGVklgnPwCwFs2R4
JmZp+FzuY6XjbemYZ6KTw8n5GJn4vG73jDH2ysg8Lexet9tDnjlKlihZ4Wx4
djgznAPPCWeHc+G54ZxwHjwvnBvOh+eH88IF8IJwfrgQXhguCBfBi8KF4WJ4
cbgoXAIvCReHX8JLwSXh0ngZuBT8Ml4WLgOXw8vDZeFX8ApwefhVvCJcAa6E
V4YrwlXwqnBluBpeHa4K18BrwtXhWnhtuCZcB68L14br4fXhunADvCFcH34N
bwQ3hBvjTeBGcFO8GdwEbo63gJvBLfFWcAu4Nd4GbgW3xdvBbeDX8fZwO/gN
vAPcHn4T7wh3gN/CO8Ed4c54F7gT/DbeFe4Cd8O7w13hHnhPuDvcC+8N94T7
4H3h3nA/vD/cFx6AD4T7w4PwwfBAeAg+FB4MD8OHw0PhEfhIeDg8Ch8Nj4TH
4GPh0fA7+Dh4LPwuPh4eB7+HT4DHw+/jE+EJ8CR8MjwRnoJPhSfD0/Dp8FT4
A3wGPB3+EJ8Jz4Bn4bPhmfBH+Bx4NvwxPheeA8/D58Nz4U/wBfB8eCG+CF4A
L8aXwIvgpfgyeAm8HF8BL4NX4qvgFfBqfA28Cl6Lr4PXwOvxDfA6eCO+Cd4A
b8a3wJvgT/Gt8Bb4M3wbvBXeju+At8Gf4zvhHfAufDe8E96D74V3w1/g++C9
8H78ALwP/hI/CB+Av8IPwQfhw/gR+BB8FD8GH4G/xo/Dx+AT+En4OHwKPw2f
hM/gZ+HT8Df4Ofgs/C3+HXwOPo9fgL+Dv8cvwhfgH/BL8EX4R/wyfAn+Cb8C
X4Z/xq/CV+Bf8F/hq/Bv+DX4V/g6/jt8Db6B34R/h2/ht+Gb8B38Lnwbvoff
h+/CD/A/4PvwQ/wR/Af8GH8CP4Kf4n/CT+C/8Kzwn3AW/O8o/0R5Bv+LP4f/
hv/DX8DPYf3GXe55xi9gH48Ne3CAh3BsOA4eFw7heHh8OC6cAE8Ix4cT4Ynh
hHASPCmcGE6GJ4eTwinwlHByOBWeGk4Jp8HTwqnhdHh6OC2cAc8Ip4cz4Znh
jHAWPCucGc6GZ4ezwjnwnHB2OBeeG84J58HzwrnhfHh+OC9cAC8I54cL4YXh
gnARvChcGC6G6+evGLNn/AzKi0cpEaUk/BJeCi4Ol8bLwKXgl/GScBm4BF42
Srko5eFX8ApwWfhVvCJcAa6EV4YrwlXwqnBluBpeHa4K18BrwtXhWnhtuCZc
B68L14br4fXhunADvCFcH34NbwQ3hBvjTeBGcFO8GdwEbo63gJvBLfFWcAu4
Nd4GbgW3xdvBbeDX8fZwO/gNvAPcHn4T7wh3gN/CO8Ed4c54F7gT/DbeFdas
G9wV7o73gLvBPfFecA+4N94H7gX3xfvBfeD++AC4HzwQHwQPgAfjQ+BB8FB8
GDwEHo6PgIfBI/FRsGaj4VHwGHwsPBp+Bx8Hj4XfxcfD4+D38AnwePh9fCI8
AZ6ET4YnwlPwqfBkeBpeHp4Kl8OzRf97M92zfy+KP/DMc8CaiWd45rlgzcQf
euZ5YM3EMz3zfLBm4lmeeQFYM/Fsz7wQrJn4I8+8CKyZeI5nXgzWTPyxZ14C
1kw81zN/CdZMPM8zLw1rJp7vmb8Mayb+xDMvB2smXuCZvwJrJl7omb8KayZe
5JlXgjUTL/bMq8CaiZd45tVgzcRLPfMasGbiZZ55LVgz8XLPvA6smXiFZ14P
1ky80jNvAGsmXuWZvwZrJl7tmTeGNROv8cybwpqJ13rmzWHNxOs885awZuL1
nnlrWDPxBs+8LayZeKNn/jqsmXiTZ/4GrJl4s2f+JqyZeItn/hasmfhTz7wz
rJl4q2f+NqyZ+DPPvBusmXibZ94D1ky83TPvBWsm3uGZ94E1E3/umfeDNRPv
9MwHwJqJd3nmg2DNxLs98yGwZuI9nvkwWDPxXs98BKyZ+AvPfBSsmXifZz4G
1ky83zN/B9ZMfMAzfxfWTPylZ/4erJn4oGf+PqyZ+CvPfBKsmfiQZz4F1kx8
2DOfBmsmPuKZfwBrJj7qmX8IayY+5pnPgjUTf+2ZfwRrJj7umX8MayY+4ZnP
gzUTn/TMP4E1E5/yzBfCmolPe+aLYc3EZzzzpbBm4rOe+XJYM/E3nvlKWDPx
Oc98NayZ+FvPfC2smfg7z3w9rJn4vGe+EdZMfMEz3wxrJv7eM/8U1kx80TP/
DNZM/INnvh3WTHzJM/8c1kz8o2e+C9ZMfNkz3wNrJv7JM/8C1kx8xTPfD2sm
/tkz/xLWTHzVM/8K1kz8i2d+GNZM/KtnfhTWTPybZ/41rJn4mmd+AtZMfN0z
PwVrJv7dMz8Daya+4Zl/A2smvumZfwtrJr7lmZ+HNRPf9sy/hzUT3/HMf4A1
E9/1zH+ENRPf88x/gjUT3/fMf4Y1Ez/wzH+BNRP/4Zn/BmsmfuiZX4c1Ez/y
zG/Amokfe+a3YM3ETzzzO7Bm4qee+T1YM/GfnvkDWDPxX575Q1gz8d+e+WNY
M/E/nvlTWDPxM8/8L1gz8b+eeRZYM7F+zyjXreS5Z3+OFf/nmf8H/28W5YVn
/r/bCW93/0diuQ/Hgj3+j60BrNn/biq+eRxYM3Fs3zwerJk48M0TwJqJQ988
EayZOI5vngTWTBzXN08GayaO55ungDUTx/fNU8GaiRP45mlgzcQJffN0sGbi
RL55BlgzcWLfPBOsmTiJb54F1kyc1DfPBmsmTuab54A1Eyf3zXPBmolT+OZ5
YM3EKX3zfLBm4lS+eQFYM3Fq37wQrJk4jW9eBNZMnNY3LwZrJk7nm+vnLx1v
/4efSbluJel9u4OIM/jmpWHNxBl985dhzcSZfPMSsGYl+Jhy3Uoy+/bnK3EW
3/xVWDNxVt+8EqyZOJtvXgXWTJzdN68GaybO4ZvXgDUT5/TNa8GaiXP55nVg
zcS5ffN6sGbiPL55A1gzcV7f/DVYM3E+37wxrJk4v2/eFNZMXMA3bw5rJi7o
m7eENRMX8s1bw5qJC/vmbWHNxEV889dhzcRFffM3YM3ExXzzN2HNxMV987dg
zcQlfPPOsGbikr7527Bm3WHNesLd4Zd8896wZuJSvnlfWDNxad+8P6yZuIxv
PhDWTPyybz4Y1kxc1jcfCmsmLuebD4c1E5f3zUfCmo2BNXsHHgO/4pu/C2sm
ruCbvwdrJn7VN38f1kxc0TefBGsmruSbT4E1E1f2zafBmomr+OblYM3K8c+s
XDeOqr79+0xczTefAWsmru6bfwhrJq7hm8+ENRPX9M1nwZqJa/nms2HNxLV9
849gzcR1fPM5sGbiur75x7Bm4nq++VxYM3F933werJm4gW8+H9ZM3NA3/wTW
TPyab74A1kzcyDdfCGsmbuybL4I1EzfxzRfDmomb+uZLYM3EzXzzpbBm4ua+
+TJYM3EL33w5rJm4pW++AtZM3Mo3XwlrJm7tm6+CNRO38c1Xw5qJ2/rma2DN
xO1887WwZuLXffN1sGbi9r75elgz8Ru++QZYM3EH33wjrJn4Td98E6yZuKNv
vhnW7H/3Dt98C6yZuJNv/imsmbizb74V1kzcxTf/DNbsf/cP33wbrJm4q2++
HdZM3M033wFrJu7um38Oaybu4ZvvhDUT9/TNd8GaifWXFuW7Yc3EvX3zPbBm
4j6++V5YM3Ff3/wLWDNxP998H6yZuL9vvh/WTDzANz8AayYe6Jt/CWsmHuSb
H4Q1Ew/2zb+CNRMP8c0PwZqJh/rmh2HNxMN88yOwZuLhvvlRWDPxCN/8GKyZ
eKRv/jWsmXiUb34c1kw82jc/AWsmHuObn4Q1E4/1zU/Bmonf8c1Pw5qJx/nm
Z2DNxO/65mdhzcTjffNvYM3E7/nm52DNxBN8829hzcTv++bfwZqJJ/rm52HN
xJN88wuwZuLJvvn3sGbiKb75RVgz8VTf/AdYM/E03/wSrJl4um/+I6yZ+APf
/DKsmXiGb/4TrJn4Q9/8CqyZeKZv/jOsmXiWb34V1kw82zf/BdZM/JFv/ius
mXiOb/4brJn4Y9/8GqyZeK5vfh3WTDzPN/8d1kw83ze/AWsm/sQ3vwlrJl7g
m9+CNRMv9M1vw5qJF/nmd2DNxIt987uwZuIlvvk9WDPxUt/8PqyZeJlv/gDW
TLzcN/8D1ky8wjd/CGsmXumbP4I1E6/yzR/DmolX++ZPYM3Ea3zzp7Bm4rW+
+Z+wZuJ1vvlfsGbi9b7537Bm4g2++T+wZuKNvvkzWDPxJt/8X1gz8WbffDqs
mVi/Z5TrxrHF5wYS5VPf/AWsmXirb64bx1beLv4M9+BY8Dbchz14Ox4b9uEd
eADHhj/HQziAd+Jx4BDehceF48C78XhwXHgPHh+OB+/FE8Dx4S/whHACeB+e
CE4I78cTw4ngA3gSODH8JZ4UTgIfxJPBSeGv8ORwMvgQngJODh/GU8Ip4CN4
KjglfBRPDaeCj+Fp4NTw13haOA18HE8Hp4VP4Pr5O8HsOT+Tct04Tvp2vxCf
wjPCGeDTeCY4I3wGTw9ngk/iunGc9e3PV+Jv8KxwFvgcng3OCn+LZ4ezwd/h
OeDs8Hk8J5wDvoDngnPC3+O54VzwRTwPnBv+Ac8L54Ev4fngvPCPeH44H3wZ
LwDnh3/CC8IF4Ct4Ibgg/DNeGC4EX8WLwIXhX/CicBH4V7wYXBT+DS8OF4Ov
4SXg4vB1vCRcAv4dfwkuCd/AS8EvwTfx0nAp+BZeBi4N38ZfhsvAd/Cy8Mvw
XbwcXBa+h5eHy8H38Vfg8vADvAL8CvwH/ipcAX6IV4RfhR/hleCK8GO8MlwJ
foJXgSvDT/HMcBX4LP4UPkV/A6vPwepvYf1v7j6+R/o5089UVSLeTF+F1b/A
6l9h9W+w+hqsvg5f5/Ns5vN/xw76XNX4/KeYn6TPw+oLsPp7WL+uOr9Wf17V
n0078pr28/k6Mteff/VnTv35sguueQc+Rg0+TgfmbxBxeyJ+nYjbEXFbIm5D
xK2JuBWfpyafS/vd4Pug13SR16Udu7FnK35tS95/P19D9QFY/SWsPgirv4L1
eW7yuVryMVvwebrzudQ9YHVPWN0LVveG1X1gdV9Y3Q9W94fVA2D1QFh73WK3
FuzWnN0Psf9meBN9GN4Eb6SPwBvhDfRReAO8nj4Gr4fX0V/D6+C19HF4LbyG
PgGvgVfTW2C9vtu8Rr3uQbx2/SzoFniF2WDmq/m1q+hP4eZ8fZoRcVM+9h0+
/hfwXvouvBfeQ9+D98C76fuwdhnCPqvYYSW9FVZ/Bq+EV9Db4BXwcno7vBxe
Ru+Al8FL6c/hJrzWxuw1lN30z43+/XySr2Vtvp5X4J9432G8v2Z1mO/m9e7i
7cN5H/UI+Cfe/zJdF9bbR/I+6lGwejSsHgOrx8La9xI7a/YO8y5wZ3ocrK/B
Tr4Omr3LXD0eVr8HqyfA6vdh9URYPQlWT4bVU2D1VFg9DVZPh9UfwOoZsPpD
WD0T7gx34mtZj6/nZfhHuj7clPdtzPfpPl+LnfBS3q8+X9NL8Em6AaxuCKtf
g9WN4EZ8npNEfIbuBJ+BT9Mz4dPwKXoWrJ4Nqz+C1XNgvY4HvBbNPmaungur
58F63z94/6XwEvohrH4Eqx/D6iew+in8lI+9hIgXE/EiIl5IxAuI+BMink/P
g/V3U/V3VPX32/V3kfX39/V3+/X30cvHmGumZwG64OIKvJ/eR3/fWn8XW898
tKD1DEgr3ibW37FuBevvVbeB9Xep28H6+9PtYf2d6Q5wFz5nRj5/R+bZcbGe
Sdbn1R7ZcXFFdtWeeg45e4y5Zvp7+pVxcVVcXB0X18TFem45Jx+nQyx7HlTP
inag28DqVrC6Ba9Fr0PPYnTla5qej6O365lWPeepZ0D1fGhtPndJ3kdvb8LH
VDeC1Q1hdX1YXRdW14bVNfka6uv3hLlmei64O3t0Yq6ZniPuyds0742L++Li
/rh4IC4ejIuH4uLhuHgkLh6Ni8fiYj0fnjvG1197VWZPtZ6PHsev0fvn5Gf7
CazWM016/kTuWK1noPT8idyxWs9M6fkTuWO1nrHS8ydyx2o9k6XnT+SO1XqG
S8+fyMXj2VV76jmK2nyvi/J2PQv2jF8jnsCv0ftPxMXd+HnSz1I3Ws8B9cDF
z/h4eu7sbz6u+DnuWK1n1l7gjtVXY9lzVi9isFrPxOk5K7ljtZ6h03NWcsdq
PXOn56zkl/ie6Xl3PQvfg331fFMvXoM4P9/7ZrBaz4b04f1Sw2o9M9UPd6zW
M1YDcPEg3LFaz2cNwR2r9TzXMNyxWs9/jcDFk/ne6Pui/zaBdtWeeh54MnM9
G1OX77WeB54a4/31vnoWpjAu1rPB03kfPQ88A56Ni+fg4rm4Y7WeQ5+Pixfg
4kW4eAkuXoaLV+DiVbh4DS5eh4s34OJNuHgLLt6Ki7fh4h24eCcu3o2L9+Ji
/TcdCvO1KkrrOSM9sxeXn7ERfH/i8/2Kz3wULi7Ox9Kv1XMmo5h34Ge0PG+r
z/euOC4uya8X678NURLWfw+iFKz/BkQZWB+rbAz+3/t69rnkjtV61qwje4j3
8rodq/Xvs318XcQHYpmL9QzwAVjP/R6Ex/I69Rr13O8h5sdwsZ7vPQaP49fo
/cfReq52PG8T6/mZ8bCemZkA6zmZibB+3zEZ1sedGoPVF2D1d7D6HKw+C6tP
w2o9d3wcF/8Z/V7nryh/+8bqf6I8wx2r/43yHHes/i/KC9yxWv8xGi+2uWO1
HyU27lgdRAlxx+o4UeLijtXxosTHHasTREmIO1YnipIYd6xOEiUp7lidLEpy
3LE6RZSUuGN1qiipccfqNFHS4o7V6aKkxx2rM0TJiDtWZ4qSGXeszhIlK+5Y
nS1KdtyxOkeUnLhjda4ouXHH6jxR8uKO1fmi5McdqwtEKYg7VheKUhh3rC4S
pSjuWF0sSnHcsbpElJK4Y/VLUUrhjtWlo5TBHatfjlIWd6wuF6U87lj9SpQK
uGP1q1Eq4o7VlaJUxh2rq0SpijtWV4tSHXesrhGlJu5YXStKbdyxuk6Uurhj
db0o9XHH6gZRGuKO1a9FaYQ7VjeO0gR3rG4apRnuWN08SgvcsbpllFa4Y3Xr
KG1wx+q2UdrhjtWvR2mPO1a/EaUD7lj9ZpSOuGP1W1E64Y7VnaN0wR2r347S
FXes7halO+5Y3SNKT9yxuleU3rhjdZ8ofXHH6n5R+uOO1QOiDMQdqwdFGYw7
Vg+JMhR3rB4WZTjuWD0iykjcsXpUlNG4Y/WYKGNxx+p3oozDHavfjTIed6x+
L8oE3LH6/SgTccfqSVEm447VU6JMxR2rp0WZjjtWfxBlBu5Y/WGUmbhj9awo
s3HH6o+izMEdqz+OMhd3rJ4XZT7uWP1JlAW4Y/XCKItwx+rFUZbgjtVLoyzD
HauXR1mBO1avjLIKd6xeHWUN7li9Nso63LF6fZQNuGP1xiibcMfqzVG24I7V
n0bZijtWfxZlG+5YvT3KDtyx+vMoO3HH6l1RduOO1Xui7MUdq7+Isg93rN4f
5QDuWP1llIO4Y/VXUQ7hjtWHoxzBHauPRjmGO1Z/HeU47lh9IspJ3LH6VJTT
uGP1mShnccfqb2Lb7xnPxmC1fu94Lupvo3wX21h9PsoF3LH6+ygXccfqH6Jc
wh2rf4xyGXes/inKFdyx+ucoV3HH6l+i/Io7Vv8W5RruWH09yu+4Y/WNKDdx
x+pbUW7jjtV3otzFHavvRbmPO1Y/iPIH7lj9MMoj3LH6cZQnuGP10yh/4o7V
f+l7hjtW/xPlGe5Y/W+U57hj9X9RXuCO1foPSnqBuWO1HyU27lgdRAlxx+o4
UeLijtXxosTHHasTBPYzGD8Gq/WzmDDqRFESB8bqJFGS4o7VyaIkxx2rU/Ax
ksfgFHyslFFSRUkNq9NESYs7VqeLkh53rM4QJSPuWJ0pSmbcsTpLlKy4Y3W2
KNlxx+ocUXLijtW5ouTGHavzRMmLO1bni5Ifd6wuEKUg7lhdKEph3LG6SJSi
uGN1sSjFccfqElFK4o7VL0UphTtWl45SBnesfjlKWdyxulyU8rhj9StRKuCO
1a9GqYg7VleKUhl3rK4SpSouroY7VlePUgN3rK4ZpRbuWF07Sh3csbpulHq4
Y3X9KA1wx+qGUV7DHasbRWmMO1Y3idIUd6xuFqU57ljdIkpLXNwKd6xuHaUN
7ljdNko73LH69SjtccfqN6J0wB2r34zSEXesfitKJ9yxunOULrhj9duB/bPe
JQar9c/8P9xSusLqboHdS+SO1d0Du5fIHat7BHYvkTtW9wzsXiJ3rO4V2L1E
7ljdO7B7idyxuk9g9xK5Y3XfwO4lcsfqfoHdS+SO1f0Du5fIHasHBHYvkTtW
DwzsXiJ3rB4U2L1E7lg9OLB7idyxekhg9xK5Y/XQwO4lcsfqYYHdS+SO1cMD
u5fIHatHBHYvkTtWjwzsXiJ3rB4V2L1E7lg9OrB7idyxekxg9xK5Y/XYwO4l
csfqdwK7l8gdq8cFdi+RO1a/G9i9RO5YPT6we4ncsfq9wO4lcsfqCYHdS+SO
1e8Hdi+RO1ZPDOxeInesnhTYvUTuWD05sHuJ3LF6SmD3Erlj9dTA7iVyx+pp
gd1L5I7V0wO7l8gdqz8I7F4id6yeEdi9RO5Y/WFg9xK5Y/XMwO4lcsfqWYHd
S+SO1bMDu5fIHas/CuxeInesnhPYvUTuWP1xYPcSuWP13MDuJXLH6nmB3Uvk
jtXzA7uXyB2rPwnsXiJ3rF4Q2L1E7li9MLB7idyxelFg9xK5Y/XiwO4lcsfq
JYHdS+SO1UsDu5fIHauXBXYvkTtWLw/sXiJ3rF4R2L1E7li9MrB7idyxelVg
9xK5Y/XqwO4lcsfqNYHdS+SO1WsDu5fIHavXBXYvkTtWrw/sXiJ3rN4Q2L1E
7li9MbB7idyxelNg9xK5Y/XmwO4lcsfqLYHdS+SO1Z8Gdi+RO1ZvDexeInes
/iywe4ncsXpbYPcSuWP19sDuJXLH6h2B3UvkjtWfB3YvkTtW7wzsXiJ3rN4V
2L1E7li9O7B7idyxek9g9xK5Y/XewO4lcsfqLwK7l8gdq/cFdi+RO1bvD+xe
InesPhDYvUTuWP1lYPcSuWP1wcDuJXLH6q8Cu5fIHasPBXYvkTtWHw7sXiJ3
rD4S2L1E7lh9NLB7idyx+lhg9xK5Y/XXgd1L5I7VxwO7l8gdq08Edi+RO1af
DOxeInesPhXYvUTuWH06sHuJ3LH6TGD3Erlj9dnA7iVyx+pvAruXyB2rzwV2
L5E7Vn8b2L1E7lj9XWD3Erlj9fnAfs8od6zW7x11L9GfXy/A6u8Du5f875YC
qy8Gdi/5300F/l8Hdi+R/z+O+lJg9xK5Y/WPgd1L/vc2WH05sHuJ3LH6p8Du
JXLH6iuB3UvkjtU/B3YvkTtWXw3sXiJ3rP4lsHuJ3LH618DuJXLH6t8Cu5fI
HauvBXYvkTtWXw/sXiJ3rP49sHuJ3LH6RmD3Erlj9c3A7iVyx+pbgd1L5I7V
twO7l8gdq+8Edi+RO1bfDexeEisGq+8Fdi/xY7D6fmD3kiAGqx8Edi+JE4PV
fwR2L4kXg9UPA/sZTBCD1fpZ1L1E949HsPpxYPeSJDFY/SSwe0myGKx+ysdI
EYOf8rF0L9Gfq/6E1X8Fdi9JE4PVfwd2L0kXg9X/BHYvyRCD1c8Cu5dkisHq
fwO7l2SJwerngd1LssVg9X+B3UtyxGD1i8DuJblisFr/D1jy4Y7VXmj3Erlj
tR/avUTuWB07tHuJ3LE6CO1eInesDkO7l8gdq+OEdi+RO1bHDe1eInesjhfa
vUTuWB0/tHuJ3LE6QWj3ErljdcLQ7iVyx+pEod1L5I7ViUO7kcjFuotUgXUL
qR6D1UlCu4XIHauThnYLkTtWJwvtFiJ3rE4e2i1E7lidIrRbiNyxOmVotxC5
Y3Wq0G4hcsfq1KHdP+Ri3TxawLpztI7B6jSh3TnkjtVpQ7tzyB2r04V255A7
VqcP7c4hd6zOENqdQ+5YnTG0O4fcsTpTaP+Myh2r9c+q7hz691jm0FidJbQ7
h9yxOmtodw65Y3W20O4ccsfq7KHdOeSO1TlCu3PIHatzhnbnkDtW5wrtziF3
rM4d2p1D7lidJ7Q7h9yxOm9odw65Y3W+0O4ccsfq/KHdOeSO1QVCu3PIHasL
hnbnkDtWFwrtziF3rC4c2p1D7lhdJLQ7h9yxumhodw65Y3Wx0O4ccsfq4qHd
OeSO1SVCu3PIHatLhnbnkDtWvxTanUPuWF0qtDuH3LG6dGh3DrljdZnQ7hxy
x+qXQ7tzyB2ry4Z255A7VpcL7c4hd6wuH9qdQ+5Y/Upodw65Y3WF0O4ccsfq
V0O7c8gdqyuGdueQO1ZXCu3O8b9bCKyuHNqdQ+5YXSW0O4fcsbpqaHcOuWN1
tdDuHHLH6uqh3TnkjtU1QrtzyB2ra4Z255A7VtcK7c4hd6yuHdqdQ+5YXSe0
O4fcsbpuaHcOuWN1vdDuHHLH6vqh3TnkjtUNQrtzyB2rG4Z255A7Vr8W2p1D
7ljdKLQ7h9yxunFodw65Y3WT0O4ccsfqpqHdOeSO1c1Cu3PIHaubh3bnkDtW
twjtziF3rG4Z2p1D7ljdKrQ7h9yxunVodw65Y3Wb0O4ccsfqtqHdOeSO1e1C
u3PIHatfD+3OIXesbh/anUPuWP1GaHcOuWN1h9DuHHLH6jdDu3PIHas7hnbn
kDtWvxXanUPuWN0ptDuH3LG6c2h3DrljdZfQ7hxyx+q3Q7tzyB2ru4Z255A7
VncL7c4hd6zuHtqdQ+5Y3SO0O4fcsbpnaHcOuWN1r9DuHHLH6t6h3TnkjtV9
QrtzyB2r+4Z255A7VvcL7c4hd6zuH9qdQ+5YPSC0O4fcsXpgaHcOuWP1oNDu
HHLH6sGh3TnkjtVDQrtzyB2rh4Z255A7Vg8L7c4hd6weHtqdQ+5YPSK0O4fc
sXpkaHcOuWP1qNDuHHLH6tGh3TnkjtVjQrtzyB2rx4Z255A7Vr8T2p1D7lg9
LrQ7h9yx+t3Q7hxyx+rxod055I7V74V255A7Vk8I7c4hd6x+P7Q7h9yxemJo
dw65Y/WkkNtH8P9Zrd876s6hP3dOhtVTQrtzyB2rp4Z255A7Vk8L7c4hd6ye
HtqdQ+5Y/UFodw65Y/WM0O4ccsfqD0O7c8gdq2eGdueQO1bPCu3OIXesnh3a
nUPuWP1RaHcOuWP1nNDuHHLH6o9Du3PIHavnhnbnkDtWzwvtziF3rJ4f2p1D
7lj9SWh3Drlj9YLQ7hxyx+qFod055I7Vi0K7c8gdqxeHdueQO1YvCe3OIXes
XhranUPuWL0stDuH3LF6eWh3Drlj9YrQ7hxyx+qVof0Myh2r9bOoO4fuFqtg
9erQ7hxyx+o1od055I7Va0P7GHLHan0s3Tn056p1sHp9aHcOuWP1htDuHHLH
6o2h3TnkjtWbQrtzyB2rN4d255A7Vm8J7c4hd6z+NLQ7h9yxemtodw65Y/Vn
od05YsVg9bbQ7hxeDFZvD+3O4cdg9Y7Q7hyxY7D689DuHEEMVu8M7c4RxmD1
rtDuHHFisHp3aHeOuDFYvSe0O0e8GKzeG9qdI34MVn8R2p0jQQxW7wvtzpEw
Bqv3h3bPSBSD1QdCu2ckjsHqL0O7ZySJweqDod0zksZg9Veh3TOSxWD1odDu
GcljsPpwaPeMFDFYfSS0e0bKGKw+GtrdIlUMVh8L7W6ROgarvw7tbpEmBquP
h3a3SBuD1SdCu1uki8Hqk6HdLdLHYPWp0O4WGWKw+nRod4uMMVh9JrR/5jLF
YPU6fDW8Dl5PxBuIWP+Mfcz3SP87q581/TttFz0J3gXvJuI9RLyXiL8g4n1E
vJ9M4vNtZIdNfC597izMVjHfBG8m4i1E/Cm/Rr9Wdxn9mVV/nq3I69Hnmcfs
Feb6c6f+TFqVWXnmWfk42ZiVY64uC6tfhtVlYHVpWF0KVr8Eq0vC2fhc2dlR
34MveT16XVvZT3tW49eV4Nce4Gs4j4jnE/EnRLyAiBfyOfS5DvLxivMxq/G5
qhNxDSKuScS1iLg2Edch4rpEXI+I6xNxAyJuyE7a7Sv2KsZuC9l/ET0RXgQv
pt+HF8NL6AnwEngp/R68FF5Gj4eXwcvpd+Hl8Ap6HLwCXkm/A6+EJ/Pa9BoP
8Zr12vXndv0c6OchB655I37dWH7tZHgKX5uifH3UReBDfPzD9Bz4MHyE/gg+
Ah+lZ8NH4WPsoX0a8/nHsMMUeCoRT6NHw9Pg6fQoeDr8AT0S/gCeQY+AZ8D6
PavuhYV4zY3ZTTcL/TOjf3Y+4+uor2dO+nO4Ce/fFNc8F691Fq+3Ke/TjIib
8747eP9ccG7epvdpQcQtibgVEbcm4jbsqp234Zq3pSvBbeF2vH59HWbimr9O
xO2J+A0i7kDEbxJxRyJ+i4g7EXFnIu5CxG8TcVci7kbE3Ym4BxH3pCvCufl6
5qG3w3ngvHy/C/FrZvE1OEaPgLfztcxLr4LzwvmIOD8RFyDigmQVn0+9Fi4E
V6TXwBXhnvRquCfci4h7E3EfIu7La9Br+RrXvB8R9yfiAbyf3v84PRw+Dp8g
4pNEfIqITxPxGTKcz6EeBquHwuohsHowrB4EqwfCq2HtrL+bqr/frr+rqr+P
rL/br7/Hn5J5KuZ6FkBvqwxrlpb30fvq71zreY+isJ4BkZeENSsFa1YG1qws
rFl5WLMKsGb6vHpOwX1uzfV27XqW2Z98/r94Frkos/TsqX2fM3/GPBFvywhr
lhnWLCusWXZYsxd8HH08PfepZ0X1XKi4FC4uiYuL43otehZDr6cqrJnepyjv
p2c99XyongXNyefNzvsU5v3EBXFxflycFxfnxsU5cXF2XF/D03wdNc/K26qz
Q1XmmXlbTeZ6e21Ys7qwZvVhzRrCmjWCNWsCa9YM1qwFrFkrWLM2sGZ6Rrwo
3wftlpH9xOnxdry/ft1zXuMz+CT+An4OH8f1DMpxZuJjvC02rJlYz1jJQ1gz
sZ7JkseFNRPrGS55fFiz9uypfXPzvdb3XO+jZ8H0fnpW5QC/rgPvr1/XEdas
Gj9L+pkS6zkgeQ1YM32cfXysc7BmF+Bz8F78InwB3o1fgi/CO/HL8CV4B34F
vgxvw6/CV/i+6Vn4tOys55u0dy1Ys9h83/X9F+vZEHkd3qcWrGem5PVgzcR6
xkreANbsNbgBrOez5I1hzcR6nkveFNZMrOe/5M1hzTrxfdH3J2RP7duFud6e
l++1vuddmXfh/fUsjH5NXFiz7ryP3rcnrFlvWLO+sGb94b5wBXwgrNlgWLOh
sGbDYc1GwpqNhjUbC2s2DtZsPKzZBFizibBmk2HNpsKaTYc1mwFrNhPWbDas
2RxYs/h8reLCes5I/is/Y1f5HsmvwZrLW8KaJeTX6mO0Yt6S/+1Nzc9pfr53
eXl/sWaJYc2SwpolhzVLCSfn44lTwsn5uOVhzcR61kxeAS7Pa0/KTKx/j8nn
wprNhzVbAGu2CNasDa9Rr3UJc719GazZClizdry/fp14K1/f9rBmHWDNOsKa
dYI16wJ34t/B4i6wnuHdyufUc75bYD0LvAnW88IbYD1TvA7Wc8dr2HkVs7PR
73W+iXKOiL+F1d8R8XlYfYGIv4fVF4n4B1h9iYh/hNWXifgnWH2FiH+G1WfJ
z+x6Ff+FnGX3X+hfyTl2/5X+jXzH7r/R18gFdr9GXycX2f06/Tu5xO6/0zfI
ZXa/QV8lV9j1Jn6LXGX3W/Rt8gu736bvkF/Z/Q59l/zG7nfpe+Qau9+j75Pr
7H6ffkB+Z/cH9E1yg13/wB+Sm+z+kH5EbrH7I/oxuc3uj+kn5A67P6Gfkrvs
/pT+k9xj9z/pv8h9dv+L/oM8YNe/8X/IH+z+D/2MPGT3Z/S/5BG7/0s/J4/Z
/Tn9H3nC7v/RL8hTdn9Bx4pj+ZPdxX+x79/MtKsXx9yPY/mb3cXq2HEs/7C7
WB3EsTxjd7E6jGP5l93F6jhxLM/ZXayOG8fyH7uL1fHiWF6wezxej0disWt8
PAHxeB0J6ITE53UkpBOR2LyORHRiEvA6EtNJSMjrSEInJXF4HUnpZCQuuyej
45N47JocT0His3sKOiVJwO4p6VQkIbunolOTROyemk5DErN7GjotScLuael0
JCm7p6OTk2Tsmh7PQJKzewY6I0nB7hnpTCQlu2eiM5NU7J6ZzkJSs3sWOitJ
w+5Z6WwkLbtno9OTdOyaHc9B0rN7DjonycDuOelcJCO756Jzk0zsnpvOQzKz
ex46L8nC7nnpfCQru+ejs5Ns7JofL0Cys3sBuiDJwe4F6UIkJ7sXoguTXOxe
mC5CcrN7EbooycPuReliJC+7F6Pzk3zsWhwvQfKzewm6JCnA7iXpl0hBdn+J
LkUKsXspujQpzO6l6TKkCLuXoV8mRdn9Zbo4KcauZfFypDi7l6PLkxLsXp5+
hZRk91foCuQldq9Av0pKsfurdEVSmt0r0pVIGXavRJclL7NrZbwKKcvuVeiq
pBy7V6WrkfLsXo2uTl5h9+p0DVKB3WvQNcmr7F6TrkUqsnstujKpxK618Tqk
MrvXoeuSKuxel65HqrJ7Pbo+qcbu9ekGpDq7N6Abkhrs3pB+jdRk99fo2qQW
uzbCG5Pa7N6YbkLqsHsTuimpy+5N6WakHrs3o5uT+uzenG5BGrB7C7olacju
LelG5DV2bYW3Jo3YvTXdhjRm9zZ0W9KE3dvS7UhTdm9Hv06asfvrdHvSnN3b
02+QFuz+Bt2KtGTXDvibpBW7v0l3JK3ZvSP9FmnD7m/RnUhbdu9Edybt2L0z
3YW8zu5d6LdJe3Z/m+5A3mDXrng30oHdu9HdyZvs3p3uQTqyew+6J3mL3XvS
vUgndu9F9yad2b033Yd0Yfc+dFfyNrv2xfuRruzej+5PurF7f3oA6c7uA+iB
pAe7D6QHkZ7sPogeTHqx+2B6COnN7kPovqQPuw7Fh5G+7D6MHk76sftwegTp
z+4j6JFkALuPpEeRgew+ih5NBrH7aHoMGczuY+ihZAi7jsXfIUPZ/R16HBnG
7uPod8lwdn+XHk9GsPt4+j0ykt3foyeQUew+gX6fjGb39+mxZAy7TsQnkbHs
PomeTN5h98n0FDKO3afQU8m77D6VnkbGs/s0ejp5j92n0x+QCez+AT2RvM+u
M/APyUR2/5CeSSax+0x6FpnM7rPo2WQKu8+mPyJT2f0jeg6Zxu5z6I/JdHb/
mJ5BPmDXufg8MoPd59HzyYfsPp/+hMxk90/oBWQWuy+gF5LZ7L6QXkQ+YvdF
9GIyh90X03PJx+y6BF9K5rL7UnoZmcfuy+jlZD67L6dXkE/YfQW9kixg95X0
KrKQ3VfRq8kidl9NLyGL2XUNvpYsYfe19DqylN3X0evJMnZfT28gy9l9A72R
rGD3jfQmspLdN9GbySp230yvIavZdQv+KVnD7p/SW8ladt9Kf0bWsftn9Day
nt230dvJBnbfTu8gG9l9B/052cTun9NbyGZ23YnvIlvYfRe9m3zK7rvpPWQr
u++h95LP2H0v/QXZxu5f0PvIdnbfR+8nO9h9P72TfM6uB/AvyU52/5I+SHax
+0H6K7Kb3b+iD5E97H6IPkz2svth+gj5gt2P0EfJPnY/Sh8g+9n1GP41OcDu
X9PHyZfsfpw+QQ6y+wn6JPmK3U/Sp8ghdj9FnyaH2f00fYYcYfcz9DFylF3P
4t+QY+z+DX2OfM3u5+hvyXF2/5b+jpxg9+/o8+Qku5+nL5BT7H6B/p6cZvfv
6bPkDLtexH8gZ9n9B/oS+YbdL9E/knPs/iN9mXzL7pfpn8h37P4TfYWcZ/cr
9M/kArv/TF8k37PrVfwXcpHdf6F/JT+w+6/0b+QSu/9GXyM/svs1+jq5zO7X
6d/JT+z+O32DXGH3G/RV8jO73sRvkavsfou+TX5h99v0HfIru9+h75Lf2P0u
fY9cY/d79H1ynd3v0w/I7+z+gL5JbrDrH/hDcpPdH9KPyC12f0Q/JrfZ/TH9
hNxh9yf0U3KX3Z/Sf5J77P4n/Re5z+5/0X+QB+z6N/4P+YPd/6GfkYfs/oz+
lzxi93/p5+Qxuz+n/yNP2P0/+gV5yu4v6FhxLX+yu/gv9v2bmXb14pr7cS1/
s7tYHTuu5R92F6uDuJZn7C5Wh3Et/7K7WB0nruU5u4vVceNa/mN3sTpeXMsL
do/H6/FILHaNjycgHq8jAZ2Q+LyOhHQiEpvXkYhOTAJeR2I6CQl5HUnopCQO
ryMpnYzEZfdkdHwSj12T4ylIfHZPQackCdg9JZ2KJGT3VHRqkojdU9NpSGJ2
T0OnJUnYPS2djiRl93R0cpKMXdPjGUhyds9AZyQp2D0jnYmkZPdMdGaSit0z
01lIanbPQmcladg9K52NpGX3bHR6ko5ds+M5SHp2z0HnJBnYPSedi2Rk91x0
bpKJ3XPTeUhmds9D5yVZ2D0vnY9kZfd8dHaSjV3z4wVIdnYvQBckOdi9IF2I
5GT3QnRhkovdC9NFSG52L0IXJXnYvShdjORl92J0fpKPXYvjJUh+di9BlyQF
2L0k/RIpyO4v0aVIIXYvRZcmhdm9NF2GFGH3MvTLpCi7v0wXJ8XYtSxejhRn
93J0eVKC3cvTr5CS7P4KXYG8xO4V6FdJKXZ/la5ISrN7RboSKcPuleiy5GV2
rYxXIWXZvQpdlZRj96p0NVKe3avR1ckr7F6drkEqsHsNuiZ5ld1r0rVIRXav
RVcmldi1Nl6HVGb3OnRdUoXd69L1SFV2r0fXJ9XYvT7dgFRn9wZ0Q1KD3RvS
r5Ga7P4aXZvUYtdGeGNSm90b001IHXZvQjclddm9Kd2M1GP3ZnRzUp/dm9Mt
SAN2b0G3JA3ZvSXdiLzGrq3w1qQRu7em25DG7N6GbkuasHtbuh1pyu7t6NdJ
M3Z/nW5PmrN7e/oN0oLd36BbkZbs2gF/k7Ri9zfpjqQ1u3ek3yJt2P0tuhNp
y+6d6M6kHbt3pruQ19m9C/02ac/ub9MdyBvs2hXvRjqweze6O3mT3bvTPUhH
du9B9yRvsXtPuhfpxO696N6kM7v3pvuQLuzeh+5K3mbXvng/0pXd+9H9STd2
708PIN3ZfQA9kPRg94H0INKT3QfRg0kvdh9MDyG92X0I3Zf0Ydeh+DDSl92H
0cNJP3YfTo8g/dl9BD2SDGD3kfQoMpDdR9GjySB2H02PIYPZfQw9lAxh17H4
O2Qou79DjyPD2H0c/S4Zzu7v0uPJCHYfT79HRrL7e/QEMordJ9Dvk9Hs/j49
loxh14n4JDKW3SfRk8k77D6ZnkLGsfsUeip5l92n0tPIeHafRk8n77H7dPoD
MoHdP6AnkvfZdQb+IZnI7h/SM8kkdp9JzyKT2X0WPZtMYffZ9EdkKrt/RM8h
09h9Dv0xmc7uH9MzyAfsOhefR2aw+zx6PvmQ3efTn5CZ7P4JvYDMYvcF9EIy
m90X0ovIR+y+iF5M5rD7Ynou+Zhdl+BLyVx2X0ovI/PYfRm9nMxn9+X0CvIJ
u6+gV5IF7L6SXkUWsvsqejVZxO6r6SVkMbuuwdeSJey+ll5HlrL7Ono9Wcbu
6+kNZDm7b6A3khXsvpHeRFay+yZ6M1nF7pvpNWQ1u27BPyVr2P1TeitZy+5b
6c/IOnb/jN5G1rP7Nno72cDu2+kdZCO776A/J5vY/XN6C9nMrjvxXWQLu++i
d5NP2X03vYdsZfc99F7yGbvvpb8g29j9C3of2c7u++j9ZAe776d3ks/Z9QD+
JdnJ7l/SB8kudj9If0V2s/tX9CGyh90P0YfJXnY/TB8hX7D7Efoo2cfuR+kD
ZD+7HsO/JgfY/Wv6OPmS3Y/TJ8hBdj9BnyRfsftJ+hQ5xO6n6NPkMLufps+Q
I+x+hj5GjrLrWfwbcozdv6HPka/Z/Rz9LTnO7t/S35ET7P4dfZ6cZPfz9AVy
it0v0N+T0+z+PX2WnGFX/f16/d37n4n4GyL+lojPE/H3RKy/0/89O13g45/n
c34Dn+W1n2f2LXyO13ie2cUoP0S5RMQ/EvFlIv6JiK8Q8c9EfJWIfyHiX4n4
NyK+RsTXifh38gM73qBvkovse5O+RS6x+y36NvmR13GbvkMu85ru0HfJT7y+
u/Q9coXXeo++T37mdd+nH5CrfA0e0H+QX/h6/EE/JL/ytXlIPyK/8XV6RD8m
1/iaPaafkOt8/Z7QN8jvMb6OT5ndgm/y9XnK7A58m6/DU2b34Lu83qfMHsD3
eV1PmT2E/2D/p8wew4/Y8ymzG7Bm/wcmx1AS
     "]]]},
  Boxed->False]], "Output",
 CellLabel->"Out[1]=",
 CellID->1313332385]
}, Open  ]],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in this file:"
}], "ExampleText",
 CellID->539199129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/wrench.obj.gz\>\"", ",", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2086254410],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Graphics3D\"\>", ",", "\<\"GraphicsComplex\"\>", 
   ",", "\<\"LineData\"\>", ",", "\<\"LineObjects\"\>", 
   ",", "\<\"PointData\"\>", ",", "\<\"PointObjects\"\>", 
   ",", "\<\"PolygonData\"\>", ",", "\<\"PolygonObjects\"\>", 
   ",", "\<\"VertexData\"\>", ",", "\<\"VertexNormals\"\>"}], "}"}]], "Output",\

 CellLabel->"Out[2]=",
 CellID->1712364301]
}, Open  ]],

Cell["Import and count the polygons stored in this file:", "ExampleText",
 CellID->799675360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{
   "\"\<ExampleData/wrench.obj.gz\>\"", ",", "\"\<PolygonObjects\>\""}], 
   "]"}], " ", "//", " ", "Length"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1278453460],

Cell[BoxData["4076"], "Output",
 CellLabel->"Out[3]=",
 CellID->1191112594]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1743237368],

Cell[TextData[{
 "Compute a 3D geometry using ",
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->471047955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", 
         RowBox[{"Sin", "[", "u", "]"}]}], "+", 
        RowBox[{"Cos", "[", "u", "]"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", 
         RowBox[{"Sin", "[", "u", "]"}]}], "+", 
        RowBox[{"Cos", "[", "u", "]"}]}], ")"}]}], ",", 
     RowBox[{"Sin", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Axes", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Mesh", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{
   "ColorFunction", " ", "\[Rule]", " ", "\"\<WatermelonColors\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1966622584],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJxtXHucDdT2nxnPMHLLs+j20q0fUereHo72SVQmlUwkhvJWJPRUop9e1x11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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3Hn8RtW0BvDzvuetlItUCElzSYU0Ks1zaZSSlFJXokGSzEKSuETIEI3K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        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJztnH9Q03UYx5dMpVj8gR0ERAcc2sT+ENND8+CJQEDKSwpjh2KdnZEaxp38
MOIoSBBLYHYRadghP/rhmV4ElaxiKMgP5ccYts3hkB+6sQ0v7abXXVF2ffuH
7vG+3/HZbstn/3xvr3vds7vdd5+9P5/n2UK2vfH89nkikeglsUjkcec6o4rc
ETA8CaZ4WUrHl1NQsFjuo8gdB+Jsuba+64uwqxaoHNzwrrrKAjnxkmjjGRNx
xvxs+aLaFyemYVmiZO0jeyahTFpTtSpnkjhj/tUuVYMxywq7c/Zdz/DRQZBn
nmqvv444cbfkrvb5+r/yf9ftCmQ9J86Gi4b+ySFmLocUcjmEOFsOA4nhlm16
OC3bWXK1ehyqsyPeEWVfJM6Y978mWXpuwQD87OFblHhSDU3FXpmht7uIM+ZJ
+q39nr0/Qn7Nuqm85ja4JC5OlYf/QJy4W/Ie7j5Xc/f5Ke4+J86WR3Hr9nfc
ul3FrdvE2fI/Zp0vvcXlEOJsefeZsJD2qml4QtmyaeCYCaThHof7vjcSt5P3
BobVzo+7CI+ulctWhIzApoO3ogYjB4nbyUvi/Ar3V5ig6PcHf5VlWiBi3QN/
2qTXiDuJn+Pu85Wz7nOMH88MyOqZscKSZ1bf2hg6Cp6rNjcmSkcdXod88vn4
GFeauw/1P2WF1lL/gOfEGnglYWJjm5fG4XXIJ5+PL5S7Wi5yF97H5ZBQLoek
cjkE44pf4jRdPp1wYUS8Jk3fDcPK1OoYQ7vD65BPPh8f40cO//04/Z+ro+uQ
Tz4fX+jV1fat7sINy9/bWew3BjWRqi3fllyD9Z+KigJ6R4gz5tj5m6vN77k7
x/aD2JwG+eTPxae5QedwLPdi/X3yyZ+LT3MjzuGu1g91F47lzI4ym0qrvPN8
KCtv3m9mKIydCE6ST6LcV3Xz6IGU62BrSd+ekWKE+v1TTXtijdB0yZyue3Ua
JH61LfG9Y/BktjJTf2EM9VnVIZ98Pr6+XqfLOWGF1yvu26s+qoeP9H3Juxv0
xO3kQt/nZvnI+4ZnrbDs8jdvQ5kGMryT+qsrNSivS/Hq9Dg0BI03jxtOhWrB
28/b9wPVefB/Wl45daQHOmzLR+fnDsAnYcrkGw0dqM+qDvnk8/FfyM813C5o
h+iglZbBY2fhYc3JlxfI2ojbyYW+z6sXf365/LNWUEr86w6GKGCpRDGxOboV
54H5oi3GcShTQERpmgneXBglfjz9CsqxPqCrzUO6C8fOmTFf6BzdTMKJx9SR
Wkjr7Ak6D1egwHYjMPanIeJ2cqH7AmxuQWiuwLjQeRuhr0t1qA7V4Z/zsfpC
cz7W/xWaEzAudG5B6OtSHapDdfjndqw+ltuxfi7WX8PyCfnkO8LH+pJYnwj7
HiSffEf4Qvtr2HkItg5j+0RWny/id+fYnD+Ww7H1Csv5rOpTHapDdfjPNbFa
/4nfnWNz49h+BPs+xfY7rOpTHapDdfjPj2E5Fsu9pbN+576C+5079v9y5JPv
TN/V+oPuzsN3rR97qNMK9yfrmvO9zaD9enifdI2JuJ0c6wex6ufeaxzbR2Dn
56z6X/cax/KG0H0c+eTPxReae8knfy6+q+UHd+dYnv9wa1tjcIIZFsZIF31c
bgFTzI664ANG8sl3qv8XtM45oQ==
    "],
   VertexNormals->CompressedData["
1:eJzFfHd0FcTWfbAgyKMIgiA9lISqoRq4MFhQQUqAIKBPWgCpgkpVpCiEJgIi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    "]],
  Boxed->False,
  ImageSize->{180., 150.151396234438},
  Lighting->"Neutral",
  PlotRange->{{-2.2358214749223966`, 
   2.2358214749223966`}, {-2.2358214749223966`, 2.2358214749223966`}, {-1., 
   1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{1.937381185247801, -2.5110932675801867`, 1.1793916841157084`},
  ViewVertical->{0.35224655622249396`, -0.08703216883214712, 
   2.0834542515545134`}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1355717012]
}, Open  ]],

Cell["Export it to OBJ:", "ExampleText",
 CellID->914034515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<plot.obj\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1227566614],

Cell[BoxData["\<\"plot.obj\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->979084929]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->987811573],

Cell["Export inline graphics to OBJ:", "ExampleText",
 CellID->2100516101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<torus.obj\>\"", ",", 
   Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx0nXVYFc33wC9dgh3YIpjYnbu2GKiIYmJhN2JiggK2iNgBCljYIirIrIGi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     "], {{
       {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwsnXW8FOUfhWe4s9y7MbF2K3Z3Y2EgdmAiFipii10oioTdARYmqGC3qGBh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          "]]]}, {}, {}, {}}, {}},
     VertexNormals->CompressedData["
1:eJx0XXVUVd3TtsDGbuxuRUXMg93xYgfY3WJ3d4CdCBYigiJSimylRJGSFKSR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      "]],
    Boxed->False,
    ImageSize->Small,
    PlotRange->{{-3.999999999999756, 
     3.9999999999997233`}, {-3.9979448731900873`, 
     3.9979448731900877`}, {-0.999999999999939, 0.999999999999939}},
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]},
    ViewPoint->{1.2699756943402518`, -2.728995019846619, 1.5458809518967995`},
    
    ViewVertical->{0.05172392675774916, -0.14954157324184025`, 
     3.9496530003407253`}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->890436474],

Cell[BoxData["\<\"torus.obj\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1899766222]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OBJ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 16.3093298}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Wavefront OBJ format. 3D geometry format. Used for storage and exchange \
of 3D geometry definitions. Native format of the Wavefront application. \
Developed by Alias Wavefront. ASCII format. An OBJ file stores a single \
object.", "synonyms" -> {}, "title" -> "OBJ", "type" -> "Format", "uri" -> 
    "ref/format/OBJ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[22610, 779, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 297500, 5420}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2659, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3282, 82, 101, 4, 70, "ObjectNameAlt",
 CellID->5045],
Cell[3386, 88, 270, 9, 70, "FormatUsage",
 CellID->20778],
Cell[3659, 99, 322, 12, 70, "FormatNotes",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[4018, 116, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[4085, 119, 411, 16, 70, "FormatNotes",
 CellID->2520],
Cell[4499, 137, 460, 16, 70, "FormatNotes",
 CellID->12927],
Cell[4962, 155, 39, 1, 70, "WeakDivider",
 CellID->24773],
Cell[5004, 158, 719, 24, 70, "FormatNotes",
 CellID->25134],
Cell[5726, 184, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[5768, 187, 352, 13, 70, "FormatNotes",
 CellID->22675],
Cell[6123, 202, 574, 20, 70, "FormatNotes",
 CellID->13336],
Cell[6700, 224, 582, 21, 70, "FormatNotes",
 CellID->16334],
Cell[7285, 247, 676, 24, 70, "FormatNotes",
 CellID->21001],
Cell[7964, 273, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[8005, 276, 514, 18, 70, "FormatNotes",
 CellID->9310],
Cell[8522, 296, 1075, 40, 70, "FormatNotes",
 CellID->5974],
Cell[9600, 338, 661, 22, 70, "FormatNotes",
 CellID->7590],
Cell[10264, 362, 816, 28, 70, "FormatNotes",
 CellID->20356],
Cell[11083, 392, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[11124, 395, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[11488, 411, 342, 12, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[11867, 428, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[11921, 431, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[12116, 441, 668, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[12787, 456, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[12829, 459, 68, 1, 70, "FormatNotes",
 CellID->13573],
Cell[12900, 462, 2691, 67, 70, "2ColumnTableMod",
 CellID->230773093],
Cell[15594, 531, 397, 14, 70, "FormatNotes",
 CellID->13037],
Cell[15994, 547, 304, 10, 70, "FormatNotes",
 CellID->4998]
}, Open  ]],
Cell[CellGroupData[{
Cell[16335, 562, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[16387, 565, 196, 8, 70, "FormatNotes",
 CellID->1911960202],
Cell[16586, 575, 1155, 31, 70, "3ColumnTableMod",
 CellID->2123520593],
Cell[17744, 608, 240, 8, 70, "FormatNotes",
 CellID->1022956994],
Cell[17987, 618, 61, 1, 70, "FormatNotes",
 CellID->2132824898],
Cell[18051, 621, 707, 17, 70, "3ColumnTableMod",
 CellID->28047],
Cell[18761, 640, 243, 7, 70, "FormatNotes",
 CellID->1642809193],
Cell[19007, 649, 759, 26, 70, "FormatNotes",
 CellID->182941150]
}, Closed]],
Cell[CellGroupData[{
Cell[19803, 680, 50, 1, 70, "SeeAlsoSection",
 CellID->20829],
Cell[19856, 683, 2042, 69, 70, "SeeAlso",
 CellID->2645]
}, Open  ]],
Cell[CellGroupData[{
Cell[21935, 757, 58, 1, 70, "MoreAboutSection",
 CellID->248267631],
Cell[21996, 760, 150, 2, 70, "MoreAbout"],
Cell[22149, 764, 151, 2, 70, "MoreAbout"],
Cell[22303, 768, 134, 2, 70, "MoreAbout"],
Cell[22440, 772, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22610, 779, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[22726, 785, 60, 1, 70, "ExampleSection",
 CellID->338000525],
Cell[22789, 788, 71, 1, 70, "ExampleText",
 CellID->1715972221],
Cell[CellGroupData[{
Cell[22885, 793, 130, 3, 70, "Input",
 CellID->17199],
Cell[23018, 798, 43869, 724, 70, "Output",
 CellID->1313332385]
}, Open  ]],
Cell[66902, 1525, 220, 8, 70, "ExampleText",
 CellID->539199129],
Cell[CellGroupData[{
Cell[67147, 1537, 176, 5, 70, "Input",
 CellID->2086254410],
Cell[67326, 1544, 398, 9, 70, "Output",
 CellID->1712364301]
}, Open  ]],
Cell[67739, 1556, 93, 1, 70, "ExampleText",
 CellID->799675360],
Cell[CellGroupData[{
Cell[67857, 1561, 227, 7, 70, "Input",
 CellID->1278453460],
Cell[68087, 1570, 75, 2, 70, "Output",
 CellID->1191112594]
}, Open  ]],
Cell[68177, 1575, 126, 3, 70, "ExampleDelimiter",
 CellID->1743237368],
Cell[68306, 1580, 227, 8, 70, "ExampleText",
 CellID->471047955],
Cell[CellGroupData[{
Cell[68558, 1592, 1093, 33, 70, "Input",
 CellID->1966622584],
Cell[69654, 1627, 39064, 652, 70, "Output",
 CellID->1355717012]
}, Open  ]],
Cell[108733, 2282, 60, 1, 70, "ExampleText",
 CellID->914034515],
Cell[CellGroupData[{
Cell[108818, 2287, 141, 4, 70, "Input",
 CellID->1227566614],
Cell[108962, 2293, 86, 2, 70, "Output",
 CellID->979084929]
}, Open  ]],
Cell[109063, 2298, 125, 3, 70, "ExampleDelimiter",
 CellID->987811573],
Cell[109191, 2303, 74, 1, 70, "ExampleText",
 CellID->2100516101],
Cell[CellGroupData[{
Cell[109290, 2308, 186939, 3075, 70, "Input",
 CellID->890436474],
Cell[296232, 5385, 88, 2, 70, "Output",
 CellID->1899766222]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[296359, 5392, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

