(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28052,        990]
NotebookOptionsPosition[     22340,        807]
NotebookOutlinePosition[     23979,        849]
CellTagsIndexPosition[     23894,        844]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"], 
          "Exporting Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExportingGraphicsAndSounds"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing Graphics and Sounds\"\>", 
       2->"\<\"Exporting Graphics and Sounds\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"PNG\"" :> Documentation`HelpLookup["paclet:ref/format/PNG"], 
          "\"TIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TIFF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"GIF\\\"\"\>", 
       2->"\<\"\\\"PNG\\\"\"\>", 
       3->"\<\"\\\"TIFF\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Listing of All Formats\"\>", 
       2->"\<\"Raster Image Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "PBM ",
 StyleBox["(.pbm)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->7514],

Cell[TextData[{
 "MIME type: ",
 StyleBox["image/x-portable-bitmap", "InlineCode"],
 "\nPBM monochrome raster image format.\nMember of the Portable family of \
image formats.\nRelated to PGM and PPM.\nImplements a subset of the PNM \
format.\nNative format of the Netpbm graphics software package.\nPrimarily \
used as an intermediate file format on Unix systems.\nPBM is an acronym \
derived from Portable Bit Map.\nASCII or binary format.\nStores raster images \
formatted as plain text, representing each pixel as a 0 (white) or 1 (black).\
\nDeveloped in 1988 as part of the Pbmplus package."
}], "FormatUsage",
 CellID->10168],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the ",
 "PBM",
 " format. "
}], "FormatNotes",
 CellID->5055],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " creates binary PBM files."
}], "FormatNotes",
 CellID->2043945572],

Cell[TextData[{
 "If multiple images are present in a ",
 "PBM",
 " file, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " returns the first of the images."
}], "FormatNotes",
 CellID->1665544589]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->5973],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pbm\>\"", "]"}]], "InlineFormula"],
 " imports a ",
 "PBM",
 " file, returning a graphics object."
}], "FormatNotes",
 CellID->8922],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pbm\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports graphics or any other expression as a PBM raster image."
}], "FormatNotes",
 CellID->6748],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default generates binary PGM files."
}], "FormatNotes",
 CellID->1610239997],

Cell["", "WeakDivider",
 CellID->5651],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pbm\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     StyleBox["data", "TI"], "]"}], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " is an array of bit values."
}], "FormatNotes",
 CellID->10986],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pbm\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "creates a ",
 "PBM",
 " image with the same image size as the displayed form of ",
 Cell[BoxData[
  FormBox[
   StyleBox["expr", "TI"], TraditionalForm]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->2144],

Cell["\<\
Because PBM is a raster image format, all fonts are rasterized on export.\
\>", "FormatNotes",
 CellID->16446],

Cell["", "WeakDivider",
 CellID->31577],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pbm\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a ",
 "PBM",
 " file."
}], "FormatNotes",
 CellID->26517],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pbm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->14629],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pbm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->29916],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<PBM\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<PBM\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5874],

Cell["", "WeakDivider",
 CellID->15791],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pbm\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 "PBM",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->15469],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pbm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], 
      StyleBox["}", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->22912],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pbm\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->8146],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pbm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->30693],

Cell["", "WeakDivider",
 CellID->9091],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "PBM",
 " format."
}], "FormatNotes",
 CellID->26949]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->26857],

Cell[TextData[{
 "In the notebook front end, ",
 StyleBox["Insert \[FilledRightTriangle] Picture", "MenuName"],
 " and the ",
 StyleBox["Open", "MenuName"],
 " menu allow import of a PBM file into a cell. "
}], "FormatNotes",
 CellID->20640],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook as a PBM file."
}], "FormatNotes",
 CellID->26052]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->236],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->8551],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->9487],

Cell["", "WeakDivider",
 CellID->31226],

Cell["Data representation elements:", "FormatNotes",
 CellID->28162],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "array of RGB triples", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Graphics\>\"", Cell["", "TableText"]}], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " object representing an image"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GrayLevels\>\"", Cell[TextData[{
     "array of normalized gray-level values",
     Cell[BoxData[Cell["", "TableText"]]]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RGBColorArray\>\"", Cell[TextData[{
     "array of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->16955],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default use the ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 "element for ",
 "PBM",
 " files."
}], "FormatNotes",
 CellID->8394],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " element:"
}], "FormatNotes",
 CellID->1343645003],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ImageSize\>\"", Cell[
    "raster dimensions", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1851017216]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->30180],

Cell["General option:", "FormatNotes",
 CellID->16097],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall image size", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->3065],

Cell["Detailed properties and settings:", "FormatNotes",
 CellID->4611],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ColorSpace\>\"", 
    ButtonBox["GrayLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GrayLevel"], Cell[
    "color space of the image", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageTopOrientation\>\"", 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "orientation of the image in the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->31947]
}, Closed]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->24750],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "Tutorials",
 CellID->9009],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "Tutorials",
 CellID->503348882]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22214],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TIFF"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17282]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->137192209],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->601045443],

Cell[TextData[{
 "This imports a PBM example file and renders it as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1507677398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/rule30sideways.pbm\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27432],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztloGNWzEMQ3+6SRe5ITrCLdB5um3vEKDfkR8p/7ZA3YQEcvn5lizJJI37
+v792/uX4zjePj4/bsdxu338CfbDJzHuU+Puz/Bq5hfWXHjdcoirr6nxWmKh
GjXbzKWqXkg9fy9VCDEhRoRz8y9NTLAhVt3ymCNDSC7nlg/LLqX8VpWo4YvV
yreTubb5FKoqlHuHT0nPF2Km3mltOI4aqiqEmOcgJtgQK26ZuZ+2qM9qO7Gr
13Sb9ofVwJtuDmjQuH3FMeSOEBNiLhyVqPZqxAQbonMLxUJqDWcN/E6VQ6iq
cwo7wlYzMleVYS53JDCXmiXEhJgQc5WYYEM4t1Teh3fsCO0cwb8KhTTVjLKE
kDrNfb6TTakUUYlSxLbKHSEmxIjGKTTEyC2Df4yGTxVD+q3hkGo86DpxxtKV
J706+5rZXMr9g811abC8ehvMHYQYPBZsrkuD5RDznxATbAgvOubd6Hd8Bt5J
uyJ0RcPe5lJ05CThTWU22JrmcgPAa2Vx2l7MTFuHmL9NTLAhvOjYTY1+jfy7
CmPM+Q0NrNjc7CjF2GlWOEjNpW4IM1dt2m0/52NqiJHbhJjnJCbYCCw2/ldL
pK6YcDBaTeXQ8X2rYTUQzMA3wK+boHMJV7Mnp5prdw0xIUZWdkO9MDHBhlDa
dXo+vCTqNufzFKJDH3TsmjZidUJsBNmFCa13p1lugm6uECPnCDEhxoQGG8GJ
b4x5jMflxS1I4tQRNErhNMhCJb418Ci6hrl422wzV4gJMaKTECOPIdgQpJxx
bYw5n+Vy3XaMO2bNrnQgNOzS7nHYjGq4OZ5a+XEAmabMVk5RhYYYiRATYkRo
sBmc+JRIh9Rx2b0bpD+G1efa2frraR0aoPSi4ZULZPwtLhBqCu4dd9eEmBAT
Yq4SE2yIzjVjTElTz53SDlaXMd2V8OIY1Qy5yaCbERvo/mmVR7JynYmtQ0yI
uRj+TMQEG2LFNbNczBLr4P5sU6gqVFuVfNsMbTktqapQiV2hbVHCrlxlIUZW
hUoh5nWICTbELQiCC/gJOBYgUg==
   "], {{0, 0}, {409, 62}}, {0, 1},
   ColorFunction->GrayLevel],
  ImageSize->{409, 62},
  PlotRange->{{0, 409}, {0, 62}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1444811192]
}, Open  ]],

Cell[TextData[{
 "Read meta-information elements ",
 Cell[BoxData["\"\<ColorSpace\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<BitDepth\>\""], "InlineFormula"],
 " from this file:"
}], "ExampleText",
 CellID->1374477233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/rule30sideways.pbm\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"\"\<ColorSpace\>\"", ",", " ", "\"\<BitDepth\>\""}], "}"}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1344107315],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"GrayLevel", ",", "1"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1894133227]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PBM - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 20.3875592}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: image/x-portable-bitmap PBM monochrome raster image format. \
Member of the Portable family of image formats. Related to PGM and PPM. \
Implements a subset of the PNM format. Native format of the Netpbm graphics \
software package. Primarily used as an intermediate file format on Unix \
systems. PBM is an acronym derived from Portable Bit Map. ASCII or binary \
format. Stores raster images formatted as plain text, representing each pixel \
as a 0 (white) or 1 (black). Developed in 1988 as part of the Pbmplus \
package.", "synonyms" -> {}, "title" -> "PBM", "type" -> "Format", "uri" -> 
    "ref/format/PBM"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[19712, 720, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23760, 837}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2332, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2955, 83, 101, 4, 70, "ObjectNameAlt",
 CellID->7514],
Cell[3059, 89, 631, 11, 70, "FormatUsage",
 CellID->10168],
Cell[3693, 102, 334, 14, 70, "FormatNotes",
 CellID->5055],
Cell[4030, 118, 200, 7, 70, "FormatNotes",
 CellID->2043945572],
Cell[4233, 127, 268, 10, 70, "FormatNotes",
 CellID->1665544589]
}, Open  ]],
Cell[CellGroupData[{
Cell[4538, 142, 63, 1, 70, "ImportExportSection",
 CellID->5973],
Cell[4604, 145, 304, 11, 70, "FormatNotes",
 CellID->8922],
Cell[4911, 158, 357, 11, 70, "FormatNotes",
 CellID->6748],
Cell[5271, 171, 213, 7, 70, "FormatNotes",
 CellID->1610239997],
Cell[5487, 180, 38, 1, 70, "WeakDivider",
 CellID->5651],
Cell[5528, 183, 746, 26, 70, "FormatNotes",
 CellID->10986],
Cell[6277, 211, 493, 18, 70, "FormatNotes",
 CellID->2144],
Cell[6773, 231, 120, 3, 70, "FormatNotes",
 CellID->16446],
Cell[6896, 236, 39, 1, 70, "WeakDivider",
 CellID->31577],
Cell[6938, 239, 351, 13, 70, "FormatNotes",
 CellID->26517],
Cell[7292, 254, 574, 20, 70, "FormatNotes",
 CellID->14629],
Cell[7869, 276, 582, 21, 70, "FormatNotes",
 CellID->29916],
Cell[8454, 299, 702, 25, 70, "FormatNotes",
 CellID->5874],
Cell[9159, 326, 39, 1, 70, "WeakDivider",
 CellID->15791],
Cell[9201, 329, 524, 20, 70, "FormatNotes",
 CellID->15469],
Cell[9728, 351, 1096, 40, 70, "FormatNotes",
 CellID->22912],
Cell[10827, 393, 661, 22, 70, "FormatNotes",
 CellID->8146],
Cell[11491, 417, 816, 28, 70, "FormatNotes",
 CellID->30693],
Cell[12310, 447, 38, 1, 70, "WeakDivider",
 CellID->9091],
Cell[12351, 450, 360, 14, 70, "FormatNotes",
 CellID->9815],
Cell[12714, 466, 352, 14, 70, "FormatNotes",
 CellID->26949]
}, Closed]],
Cell[CellGroupData[{
Cell[13103, 485, 70, 1, 70, "NotebookInterfaceSection",
 CellID->26857],
Cell[13176, 488, 241, 7, 70, "FormatNotes",
 CellID->20640],
Cell[13420, 497, 153, 4, 70, "FormatNotes",
 CellID->26052]
}, Closed]],
Cell[CellGroupData[{
Cell[13610, 506, 49, 1, 70, "ElementsSection",
 CellID->236],
Cell[13662, 509, 191, 8, 70, "FormatNotes",
 CellID->8551],
Cell[13856, 519, 710, 14, 70, "2ColumnTableMod",
 CellID->9487],
Cell[14569, 535, 39, 1, 70, "WeakDivider",
 CellID->31226],
Cell[14611, 538, 68, 1, 70, "FormatNotes",
 CellID->28162],
Cell[14682, 541, 1142, 29, 70, "2ColumnTableMod",
 CellID->16955],
Cell[15827, 572, 403, 16, 70, "FormatNotes",
 CellID->8394],
Cell[16233, 590, 197, 8, 70, "FormatNotes",
 CellID->1343645003],
Cell[16433, 600, 354, 9, 70, "2ColumnTableMod",
 CellID->1851017216]
}, Open  ]],
Cell[CellGroupData[{
Cell[16824, 614, 49, 1, 70, "OptionsSection",
 CellID->30180],
Cell[16876, 617, 54, 1, 70, "FormatNotes",
 CellID->16097],
Cell[16933, 620, 516, 15, 70, "3ColumnTableMod",
 CellID->3065],
Cell[17452, 637, 71, 1, 70, "FormatNotes",
 CellID->4611],
Cell[17526, 640, 677, 17, 70, "3ColumnTableMod",
 CellID->31947]
}, Closed]],
Cell[CellGroupData[{
Cell[18240, 662, 53, 1, 70, "TutorialsSection",
 CellID->24750],
Cell[18296, 665, 165, 3, 70, "Tutorials",
 CellID->9009],
Cell[18464, 670, 170, 3, 70, "Tutorials",
 CellID->503348882]
}, Closed]],
Cell[CellGroupData[{
Cell[18671, 678, 50, 1, 70, "SeeAlsoSection",
 CellID->22214],
Cell[18724, 681, 587, 20, 70, "SeeAlso",
 CellID->17282]
}, Open  ]],
Cell[CellGroupData[{
Cell[19348, 706, 58, 1, 70, "MoreAboutSection",
 CellID->137192209],
Cell[19409, 709, 133, 2, 70, "MoreAbout"],
Cell[19545, 713, 130, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19712, 720, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[19828, 726, 60, 1, 70, "ExampleSection",
 CellID->601045443],
Cell[19891, 729, 234, 8, 70, "ExampleText",
 CellID->1507677398],
Cell[CellGroupData[{
Cell[20150, 741, 138, 4, 70, "Input",
 CellID->27432],
Cell[20291, 747, 1301, 25, 70, "Output",
 CellID->1444811192]
}, Open  ]],
Cell[21607, 775, 229, 7, 70, "ExampleText",
 CellID->1374477233],
Cell[CellGroupData[{
Cell[21861, 786, 285, 8, 70, "Input",
 CellID->1344107315],
Cell[22149, 796, 125, 4, 70, "Output",
 CellID->1894133227]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[22313, 805, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

