(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51754,       1347]
NotebookOptionsPosition[     46499,       1175]
NotebookOutlinePosition[     47937,       1214]
CellTagsIndexPosition[     47851,       1209]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"], 
          "Exporting Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExportingGraphicsAndSounds"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing Graphics and Sounds\"\>", 
       2->"\<\"Exporting Graphics and Sounds\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"PNG\"" :> Documentation`HelpLookup["paclet:ref/format/PNG"], 
          "\"TIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TIFF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"GIF\\\"\"\>", 
       2->"\<\"\\\"PNG\\\"\"\>", 
       3->"\<\"\\\"TIFF\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Listing of All Formats\"\>", 
       2->"\<\"Raster Image Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "PCX ",
 StyleBox["(.pcx)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->7514],

Cell[TextData[{
 "Common MIME types:",
 StyleBox[" application/pcx, image/pcx", "InlineCode"],
 "\nPaintbrush PCX format.\nRaster image format.\nLegacy format used on \
Microsoft DOS.\nBinary format.\nCompresses image data using run-length \
encoding after restriction to a color map.\nCan also store true color raster \
images.\nDeveloped by ZSoft as part of the PC Paintbrush application."
}], "FormatUsage",
 CellID->10168],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support version 5 of the PCX format."
}], "FormatNotes",
 CellID->5055]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->5973],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pcx\>\"", "]"}]], "InlineFormula"],
 " imports a ",
 "PCX",
 " file, returning a graphics object."
}], "FormatNotes",
 CellID->8922],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pcx\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports graphics or any other expression as an image to a ",
 "PCX",
 " file."
}], "FormatNotes",
 CellID->6748],

Cell["", "WeakDivider",
 CellID->5651],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pcx\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     StyleBox["data", "TI"], "]"}], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " is an array of RGB color values."
}], "FormatNotes",
 CellID->10986],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pcx\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "creates a ",
 "PCX",
 " image with the same image size as the displayed form of ",
 Cell[BoxData[
  FormBox[
   StyleBox["expr", "TI"], TraditionalForm]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->2144],

Cell["\<\
Because PCX is a raster image format, all fonts are rasterized on export.\
\>", "FormatNotes",
 CellID->16446],

Cell["", "WeakDivider",
 CellID->31577],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pcx\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a ",
 "PCX",
 " file."
}], "FormatNotes",
 CellID->26517],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pcx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->14629],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pcx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->29916],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<PCX\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<PCX\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5874],

Cell["", "WeakDivider",
 CellID->15791],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pcx\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 "PCX",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->15469],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pcx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], 
      StyleBox["}", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->22912],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pcx\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->8146],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pcx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->30693],

Cell["", "WeakDivider",
 CellID->9091],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "PCX",
 " format."
}], "FormatNotes",
 CellID->26949]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->236],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->8551],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->9487],

Cell["", "WeakDivider",
 CellID->31226],

Cell["Data representation elements:", "FormatNotes",
 CellID->28162],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "array of color values", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Graphics\>\"", Cell["", "TableText"]}], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " object representing an image"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GrayLevels\>\"", Cell[
    "array of normalized gray-level values", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->16955],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<RGBColorArray\>\"", Cell[TextData[{
     "array of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->23183],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default use the ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " element for ",
 "PCX",
 " files."
}], "FormatNotes",
 CellID->8394],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->450361849],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BitDepth\>\"", Cell[
    "bits used to represent each color channel in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ColorSpace\>\"", Cell[
    "color encoding used in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageSize\>\"", Cell[
    "raster dimensions", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1499224115]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->30180],

Cell["General options:", "FormatNotes",
 CellID->16097],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall image size", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->3065]
}, Closed]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->24750],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "Tutorials",
 CellID->9009],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "Tutorials",
 CellID->503348882]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22214],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TIFF"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17282]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->327643250],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->238804546],

Cell["This imports a PCX example file:", "ExampleText",
 CellID->357264252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/spikey1.pcx\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27432],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnQdYU9cCx7vssMuu11oIqw6UPbMTskggCUmAJBAyIOy9ZO8NIihLBRQn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   "], {{0, 0}, {226, 204}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{226, 204},
  PlotRange->{{0, 226}, {0, 204}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->744741702]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176006352],

Cell["Create a raster image using ArrayPlot and export it to PCX:", \
"ExampleText",
 CellID->1053776145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1635", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "80"}], "]"}], ",", 
   RowBox[{"ColorFunction", " ", "\[Rule]", " ", "\"\<BrightBands\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->518032206],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnT2rrkcZhQ+mSmchphLxJ1iKxa6VNOYfGNBKsFS0sxBsLQ0E/AFC6oA/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   "], {{0, 0}, {161, 81}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 CellLabel->"Out[1]=",
 CellID->1653651865]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<image.pcx\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1211535224],

Cell[BoxData["\<\"image.pcx\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1980052561]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PCX - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 20.7313180}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Common MIME types: application/pcx, image/pcx Paintbrush PCX format. \
Raster image format. Legacy format used on Microsoft DOS. Binary format. \
Compresses image data using run-length encoding after restriction to a color \
map. Can also store true color raster images. Developed by ZSoft as part of \
the PC Paintbrush application.", "synonyms" -> {}, "title" -> "PCX", "type" -> 
    "Format", "uri" -> "ref/format/PCX"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18033, 655, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47717, 1202}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2332, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2955, 83, 101, 4, 70, "ObjectNameAlt",
 CellID->7514],
Cell[3059, 89, 426, 8, 70, "FormatUsage",
 CellID->10168],
Cell[3488, 99, 336, 12, 70, "FormatNotes",
 CellID->5055]
}, Open  ]],
Cell[CellGroupData[{
Cell[3861, 116, 63, 1, 70, "ImportExportSection",
 CellID->5973],
Cell[3927, 119, 304, 11, 70, "FormatNotes",
 CellID->8922],
Cell[4234, 132, 371, 13, 70, "FormatNotes",
 CellID->6748],
Cell[4608, 147, 38, 1, 70, "WeakDivider",
 CellID->5651],
Cell[4649, 150, 752, 26, 70, "FormatNotes",
 CellID->10986],
Cell[5404, 178, 493, 18, 70, "FormatNotes",
 CellID->2144],
Cell[5900, 198, 120, 3, 70, "FormatNotes",
 CellID->16446],
Cell[6023, 203, 39, 1, 70, "WeakDivider",
 CellID->31577],
Cell[6065, 206, 351, 13, 70, "FormatNotes",
 CellID->26517],
Cell[6419, 221, 574, 20, 70, "FormatNotes",
 CellID->14629],
Cell[6996, 243, 582, 21, 70, "FormatNotes",
 CellID->29916],
Cell[7581, 266, 697, 25, 70, "FormatNotes",
 CellID->5874],
Cell[8281, 293, 39, 1, 70, "WeakDivider",
 CellID->15791],
Cell[8323, 296, 524, 20, 70, "FormatNotes",
 CellID->15469],
Cell[8850, 318, 1096, 40, 70, "FormatNotes",
 CellID->22912],
Cell[9949, 360, 661, 22, 70, "FormatNotes",
 CellID->8146],
Cell[10613, 384, 816, 28, 70, "FormatNotes",
 CellID->30693],
Cell[11432, 414, 38, 1, 70, "WeakDivider",
 CellID->9091],
Cell[11473, 417, 360, 14, 70, "FormatNotes",
 CellID->9815],
Cell[11836, 433, 352, 14, 70, "FormatNotes",
 CellID->26949]
}, Closed]],
Cell[CellGroupData[{
Cell[12225, 452, 49, 1, 70, "ElementsSection",
 CellID->236],
Cell[12277, 455, 191, 8, 70, "FormatNotes",
 CellID->8551],
Cell[12471, 465, 711, 14, 70, "2ColumnTableMod",
 CellID->9487],
Cell[13185, 481, 39, 1, 70, "WeakDivider",
 CellID->31226],
Cell[13227, 484, 68, 1, 70, "FormatNotes",
 CellID->28162],
Cell[13298, 487, 801, 19, 70, "2ColumnTableMod",
 CellID->16955],
Cell[14102, 508, 515, 15, 70, "2ColumnTableMod",
 CellID->23183],
Cell[14620, 525, 404, 16, 70, "FormatNotes",
 CellID->8394],
Cell[15027, 543, 197, 8, 70, "FormatNotes",
 CellID->450361849],
Cell[15227, 553, 634, 13, 70, "2ColumnTableMod",
 CellID->1499224115]
}, Open  ]],
Cell[CellGroupData[{
Cell[15898, 571, 49, 1, 70, "OptionsSection",
 CellID->30180],
Cell[15950, 574, 55, 1, 70, "FormatNotes",
 CellID->16097],
Cell[16008, 577, 516, 15, 70, "3ColumnTableMod",
 CellID->3065]
}, Closed]],
Cell[CellGroupData[{
Cell[16561, 597, 53, 1, 70, "TutorialsSection",
 CellID->24750],
Cell[16617, 600, 165, 3, 70, "Tutorials",
 CellID->9009],
Cell[16785, 605, 170, 3, 70, "Tutorials",
 CellID->503348882]
}, Closed]],
Cell[CellGroupData[{
Cell[16992, 613, 50, 1, 70, "SeeAlsoSection",
 CellID->22214],
Cell[17045, 616, 587, 20, 70, "SeeAlso",
 CellID->17282]
}, Open  ]],
Cell[CellGroupData[{
Cell[17669, 641, 58, 1, 70, "MoreAboutSection",
 CellID->327643250],
Cell[17730, 644, 133, 2, 70, "MoreAbout"],
Cell[17866, 648, 130, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18033, 655, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[18149, 661, 60, 1, 70, "ExampleSection",
 CellID->238804546],
Cell[18212, 664, 75, 1, 70, "ExampleText",
 CellID->357264252],
Cell[CellGroupData[{
Cell[18312, 669, 128, 3, 70, "Input",
 CellID->27432],
Cell[18443, 674, 21255, 352, 70, "Output",
 CellID->744741702]
}, Open  ]],
Cell[39713, 1029, 125, 3, 70, "ExampleDelimiter",
 CellID->176006352],
Cell[39841, 1034, 105, 2, 70, "ExampleText",
 CellID->1053776145],
Cell[CellGroupData[{
Cell[39971, 1040, 476, 15, 70, "Input",
 CellID->518032206],
Cell[40450, 1057, 5713, 98, 70, "Output",
 CellID->1653651865]
}, Open  ]],
Cell[CellGroupData[{
Cell[46200, 1160, 142, 4, 70, "Input",
 CellID->1211535224],
Cell[46345, 1166, 88, 2, 70, "Output",
 CellID->1980052561]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[46472, 1173, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

