(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     71253,       1861]
NotebookOptionsPosition[     64081,       1628]
NotebookOutlinePosition[     65711,       1670]
CellTagsIndexPosition[     65625,       1665]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"], 
          "Exporting Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExportingGraphicsAndSounds"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing Graphics and Sounds\"\>", 
       2->"\<\"Exporting Graphics and Sounds\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"PBM\"" :> Documentation`HelpLookup["paclet:ref/format/PBM"], 
          "\"PNG\"" :> Documentation`HelpLookup["paclet:ref/format/PNG"], 
          "\"PNM\"" :> Documentation`HelpLookup["paclet:ref/format/PNM"], 
          "\"PPM\"" :> Documentation`HelpLookup["paclet:ref/format/PPM"], 
          "\"TIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TIFF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"GIF\\\"\"\>", 
       2->"\<\"\\\"PBM\\\"\"\>", 3->"\<\"\\\"PNG\\\"\"\>", 
       4->"\<\"\\\"PNM\\\"\"\>", 5->"\<\"\\\"PPM\\\"\"\>", 
       6->"\<\"\\\"TIFF\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Listing of All Formats\"\>", 
       2->"\<\"Raster Image Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "PGM ",
 StyleBox["(.pgm)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->7514],

Cell[TextData[{
 "MIME type: ",
 StyleBox["image/x-portable-graymap", "InlineCode"],
 "\nPGM grayscale raster image format.\nMember of the Portable family of \
image formats.\nRelated to PBM and PPM.\nImplements a subset of the PNM \
format.\nNative format of the Netpbm graphics software package.\nPrimarily \
used as an intermediate file format on Unix systems.\nPGM is an acronym for \
Portable Gray Map.\nASCII or binary format.\nStores raster images formatted \
as plain text, representing each pixel as an 8-bit gray level.\nDeveloped in \
1988 as part of the Pbmplus package."
}], "FormatUsage",
 CellID->10168],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the ",
 "PGM",
 " format. "
}], "FormatNotes",
 CellID->5055],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " creates binary PGM files."
}], "FormatNotes",
 CellID->1239494724],

Cell[TextData[{
 "If multiple images are present in a ",
 "PGM",
 " file, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " returns the first of the images."
}], "FormatNotes",
 CellID->1665544589]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->5973],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pgm\>\"", "]"}]], "InlineFormula"],
 " imports a ",
 "PGM",
 " file, returning a graphics object."
}], "FormatNotes",
 CellID->8922],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pgm\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports graphics or any other expression as a PGM raster image."
}], "FormatNotes",
 CellID->6748],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default generates binary PGM files."
}], "FormatNotes",
 CellID->1610239997],

Cell["", "WeakDivider",
 CellID->5651],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pgm\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     StyleBox["data", "TI"], "]"}], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " is an array of gray-level values."
}], "FormatNotes",
 CellID->10986],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pgm\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "creates a ",
 "PGM",
 " image with the same image size as the displayed form of ",
 Cell[BoxData[
  FormBox[
   StyleBox["expr", "TI"], TraditionalForm]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->2144],

Cell["\<\
Because PGM is a raster image format, all fonts are rasterized on export.\
\>", "FormatNotes",
 CellID->16446],

Cell["", "WeakDivider",
 CellID->31577],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pgm\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a ",
 "PGM",
 " file."
}], "FormatNotes",
 CellID->26517],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pgm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->14629],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pgm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->29916],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<PGM\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<PGM\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5874],

Cell["", "WeakDivider",
 CellID->15791],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pgm\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 "PGM",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->15469],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pgm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], 
      StyleBox["}", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->22912],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pgm\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->8146],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pgm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->30693],

Cell["", "WeakDivider",
 CellID->9091],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "PGM",
 " format."
}], "FormatNotes",
 CellID->26949]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->26857],

Cell[TextData[{
 "In the notebook front end, ",
 StyleBox["Insert \[FilledRightTriangle] Picture", "MenuName"],
 " and the ",
 StyleBox["Open", "MenuName"],
 " menu allow import of a PGM file into a cell. "
}], "FormatNotes",
 CellID->20640],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook as a PGM file."
}], "FormatNotes",
 CellID->26052]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->236],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->8551],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->9487],

Cell["", "WeakDivider",
 CellID->31226],

Cell["Data representation elements:", "FormatNotes",
 CellID->28162],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "array of grayscale values", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Graphics\>\"", Cell["", "TableText"]}], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " object representing an image"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GrayLevels\>\"", Cell[TextData[{
     "equivalent to ",
     Cell[BoxData["\"\<Data\>\""], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RGBColorArray\>\"", Cell[TextData[{
     "array of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->16955],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default use the ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " element for ",
 "PGM",
 " files."
}], "FormatNotes",
 CellID->8394],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " element:"
}], "FormatNotes",
 CellID->520820141],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ImageSize\>\"", Cell[
    "raster dimensions", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->280764615]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->30180],

Cell["General option:", "FormatNotes",
 CellID->16097],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall image size", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->3065],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->2513],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ColorMap\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
determines the grayscale palette used for representing the imported PGM\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DitheringMethod\>\"", 
    "\"\<FloydSteinberg\>\"", Cell[TextData[{
     "the dithering method used when color reduction is performed on ",
     Cell[BoxData[
      ButtonBox["Import",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Import"]], "InlineFormula"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->9261],

Cell[TextData[{
 "The following settings can be given for ",
 Cell[BoxData["\"\<ColorMap\>\""], "InlineFormula"],
 ": "
}], "FormatNotes",
 CellID->31101],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "chooses an adaptive set of at most 256 colors", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "adaptive set of at most ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " colors"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["color", "TI"], 
       StyleBox["1", "TR"]], ",", " ", 
      SubscriptBox[
       StyleBox["color", "TI"], 
       StyleBox["2", "TR"]], ",", " ", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["GrayLevel",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
     " objects"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no color reduction is performed", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->24393],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<DitheringMethod\>\""], "InlineFormula"],
 " option specifies the dithering algorithm used for generating the color \
reduction palette on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 ":"
}], "FormatNotes",
 CellID->442094198],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<FloydSteinberg\>\"", Cell["\<\
Floyd\[Dash]Steinberg error diffusion dithering\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no dithering is used", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->10285],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->21078],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ImageTopOrientation\>\"", 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "orientation of the exported image", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->16878],

Cell["Detailed properties and settings:", "FormatNotes",
 CellID->4611],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ColorSpace\>\"", 
    ButtonBox["GrayLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GrayLevel"], Cell[
    "color space of the image", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->31947]
}, Closed]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->24750],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "Tutorials",
 CellID->9009],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "Tutorials",
 CellID->503348882]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22214],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PBM\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PBM"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNM\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNM"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PPM\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PPM"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TIFF"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17282]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->498432937],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->195989047],

Cell["This imports a PGM example file:", "ExampleText",
 CellID->558082645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/wolframtones.pgm\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27432],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztlIlNxDAQRQOd0AZlUMI2QEM0lmoMUtgojMfj8bLxlfclpOCdy35f83b7
/Li9Lsvy/vP39bIsAXWr5SBxko0XWdvHuq7Hj/1fIWeYmrX1dda3+/rji3Sc
bX8l9enU+r+/wsYZXyTYzM7mMT2rdxwWFzHc8ICHYjade6hYsPG8D2wuwIa9
H6f34CF5DeedYQMb69wz56hsxNzsfbuvP75IqodgI+vbff3xRYLNmGya9Fax
9bj3tY8aHoJNqo64L2xgo+1e9n7o1kOwCbCBjZdNKoi9395DsImzYAMb6zw/
ZZveve19TS09BBvYWN2vziaV09IXo+z9kz0Em8y5Z07YwKZi76xEpDrhzB6C
TVGYmgWb67HprXeHe78rD8k7wwY21rlnztnYtOydfuVsmJq19Z3HQ7BJzemM
LxJsZmFjV6ncW6Qcw/CQ77dcb9jY7wObC7Bh78fpdTyUmT7ABjapvv74Ig3M
pk5vNWuUvV/HQ4pgE9e3+/rj/yvYxPXtvv74J4i9n6oj7nuqh3TBJlVH3Bc2
l2TT1hej7P0mHoKNS7CBzd9qx67s/ZTaeAg2apiaBRvY3M9jKvv36b3LNZOH
jDkDbELnbFC/+gZs2a6Z
   "], {{0, 0}, {412, 58}}, {0, 255},
   ColorFunction->GrayLevel],
  ImageSize->{412, 58},
  PlotRange->{{0, 412}, {0, 58}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->880649358]
}, Open  ]],

Cell["Read the color palette used in this file:", "ExampleText",
 CellID->1633928066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
  "\"\<ExampleData/wolframtones.pgm\>\"", ",", " ", "\"\<ColorMap\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->217213459],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"217", ",", "217", ",", "217"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"255", ",", "255", ",", "255"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->2131889160]
}, Open  ]],

Cell[TextData[{
 "Import the ",
 StyleBox["\"BitDepth\"", "InlineCode"],
 " element:"
}], "ExampleText",
 CellID->1555611073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
  "\"\<ExampleData/wolframtones.pgm\>\"", ",", " ", "\"\<BitDepth\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1033344781],

Cell[BoxData["8"], "Output",
 CellLabel->"Out[3]=",
 CellID->725480978]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2124922981],

Cell[TextData[{
 "Create a sample gray-level image using ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " and export it to PGM:"
}], "ExampleText",
 CellID->927492057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "30"}], "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1689385333],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJwtV3k4lOv/VkcIyZFTiiQkSSctRJZbUhSVyBLKUsn5RilCpZq0ScoSUimK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   "], {{0, 0}, {30, 20}}, {0, 0.9993407630464608}],
  Frame->False,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 CellLabel->"Out[1]=",
 CellID->1825340279]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<image.pgm\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1690171758],

Cell[BoxData["\<\"image.pgm\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1950537837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140361808],

Cell["Export arbitrary graphics to the PGM format:", "ExampleText",
 CellID->1123862650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<plot.pgm\>\"", ",", 
   GraphicsBox[{{}, {}, 
     {GrayLevel[0.5], LineBox[CompressedData["
1:eJwk23k8VN/7AHDSSostlX3ft2EYhnGelFQkLbSpkMqWLC0qbWihSCSF7Aof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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    ImageSize->Small,
    PlotRange->{{0, 40}, {-0.9999992328657719, 0.9999997588489247}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1071273883],

Cell[BoxData["\<\"plot.pgm\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->397255133]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PGM - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 36.0285846}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: image/x-portable-graymap PGM grayscale raster image format. \
Member of the Portable family of image formats. Related to PBM and PPM. \
Implements a subset of the PNM format. Native format of the Netpbm graphics \
software package. Primarily used as an intermediate file format on Unix \
systems. PGM is an acronym for Portable Gray Map. ASCII or binary format. \
Stores raster images formatted as plain text, representing each pixel as an \
8-bit gray level. Developed in 1988 as part of the Pbmplus package.", 
    "synonyms" -> {}, "title" -> "PGM", "type" -> "Format", "uri" -> 
    "ref/format/PGM"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[24532, 875, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 65491, 1658}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2643, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3266, 87, 101, 4, 70, "ObjectNameAlt",
 CellID->7514],
Cell[3370, 93, 618, 11, 70, "FormatUsage",
 CellID->10168],
Cell[3991, 106, 334, 14, 70, "FormatNotes",
 CellID->5055],
Cell[4328, 122, 200, 7, 70, "FormatNotes",
 CellID->1239494724],
Cell[4531, 131, 268, 10, 70, "FormatNotes",
 CellID->1665544589]
}, Open  ]],
Cell[CellGroupData[{
Cell[4836, 146, 63, 1, 70, "ImportExportSection",
 CellID->5973],
Cell[4902, 149, 304, 11, 70, "FormatNotes",
 CellID->8922],
Cell[5209, 162, 357, 11, 70, "FormatNotes",
 CellID->6748],
Cell[5569, 175, 213, 7, 70, "FormatNotes",
 CellID->1610239997],
Cell[5785, 184, 38, 1, 70, "WeakDivider",
 CellID->5651],
Cell[5826, 187, 753, 26, 70, "FormatNotes",
 CellID->10986],
Cell[6582, 215, 493, 18, 70, "FormatNotes",
 CellID->2144],
Cell[7078, 235, 120, 3, 70, "FormatNotes",
 CellID->16446],
Cell[7201, 240, 39, 1, 70, "WeakDivider",
 CellID->31577],
Cell[7243, 243, 351, 13, 70, "FormatNotes",
 CellID->26517],
Cell[7597, 258, 574, 20, 70, "FormatNotes",
 CellID->14629],
Cell[8174, 280, 582, 21, 70, "FormatNotes",
 CellID->29916],
Cell[8759, 303, 702, 25, 70, "FormatNotes",
 CellID->5874],
Cell[9464, 330, 39, 1, 70, "WeakDivider",
 CellID->15791],
Cell[9506, 333, 524, 20, 70, "FormatNotes",
 CellID->15469],
Cell[10033, 355, 1096, 40, 70, "FormatNotes",
 CellID->22912],
Cell[11132, 397, 661, 22, 70, "FormatNotes",
 CellID->8146],
Cell[11796, 421, 816, 28, 70, "FormatNotes",
 CellID->30693],
Cell[12615, 451, 38, 1, 70, "WeakDivider",
 CellID->9091],
Cell[12656, 454, 360, 14, 70, "FormatNotes",
 CellID->9815],
Cell[13019, 470, 352, 14, 70, "FormatNotes",
 CellID->26949]
}, Closed]],
Cell[CellGroupData[{
Cell[13408, 489, 70, 1, 70, "NotebookInterfaceSection",
 CellID->26857],
Cell[13481, 492, 241, 7, 70, "FormatNotes",
 CellID->20640],
Cell[13725, 501, 153, 4, 70, "FormatNotes",
 CellID->26052]
}, Closed]],
Cell[CellGroupData[{
Cell[13915, 510, 49, 1, 70, "ElementsSection",
 CellID->236],
Cell[13967, 513, 191, 8, 70, "FormatNotes",
 CellID->8551],
Cell[14161, 523, 710, 14, 70, "2ColumnTableMod",
 CellID->9487],
Cell[14874, 539, 39, 1, 70, "WeakDivider",
 CellID->31226],
Cell[14916, 542, 68, 1, 70, "FormatNotes",
 CellID->28162],
Cell[14987, 545, 1134, 29, 70, "2ColumnTableMod",
 CellID->16955],
Cell[16124, 576, 404, 16, 70, "FormatNotes",
 CellID->8394],
Cell[16531, 594, 196, 8, 70, "FormatNotes",
 CellID->520820141],
Cell[16730, 604, 353, 9, 70, "2ColumnTableMod",
 CellID->280764615]
}, Open  ]],
Cell[CellGroupData[{
Cell[17120, 618, 49, 1, 70, "OptionsSection",
 CellID->30180],
Cell[17172, 621, 54, 1, 70, "FormatNotes",
 CellID->16097],
Cell[17229, 624, 516, 15, 70, "3ColumnTableMod",
 CellID->3065],
Cell[17748, 641, 177, 7, 70, "FormatNotes",
 CellID->2513],
Cell[17928, 650, 835, 21, 70, "3ColumnTableMod",
 CellID->9261],
Cell[18766, 673, 154, 5, 70, "FormatNotes",
 CellID->31101],
Cell[18923, 680, 1390, 41, 70, "2ColumnTableMod",
 CellID->24393],
Cell[20316, 723, 343, 11, 70, "FormatNotes",
 CellID->442094198],
Cell[20662, 736, 568, 15, 70, "2ColumnTableMod",
 CellID->10285],
Cell[21233, 753, 178, 7, 70, "FormatNotes",
 CellID->21078],
Cell[21414, 762, 457, 12, 70, "3ColumnTableMod",
 CellID->16878],
Cell[21874, 776, 71, 1, 70, "FormatNotes",
 CellID->4611],
Cell[21948, 779, 451, 12, 70, "3ColumnTableMod",
 CellID->31947]
}, Closed]],
Cell[CellGroupData[{
Cell[22436, 796, 53, 1, 70, "TutorialsSection",
 CellID->24750],
Cell[22492, 799, 165, 3, 70, "Tutorials",
 CellID->9009],
Cell[22660, 804, 170, 3, 70, "Tutorials",
 CellID->503348882]
}, Closed]],
Cell[CellGroupData[{
Cell[22867, 812, 50, 1, 70, "SeeAlsoSection",
 CellID->22214],
Cell[22920, 815, 1211, 41, 70, "SeeAlso",
 CellID->17282]
}, Open  ]],
Cell[CellGroupData[{
Cell[24168, 861, 58, 1, 70, "MoreAboutSection",
 CellID->498432937],
Cell[24229, 864, 133, 2, 70, "MoreAbout"],
Cell[24365, 868, 130, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24532, 875, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[24648, 881, 60, 1, 70, "ExampleSection",
 CellID->195989047],
Cell[24711, 884, 75, 1, 70, "ExampleText",
 CellID->558082645],
Cell[CellGroupData[{
Cell[24811, 889, 136, 4, 70, "Input",
 CellID->27432],
Cell[24950, 895, 867, 18, 70, "Output",
 CellID->880649358]
}, Open  ]],
Cell[25832, 916, 85, 1, 70, "ExampleText",
 CellID->1633928066],
Cell[CellGroupData[{
Cell[25942, 921, 186, 6, 70, "Input",
 CellID->217213459],
Cell[26131, 929, 316, 10, 70, "Output",
 CellID->2131889160]
}, Open  ]],
Cell[26462, 942, 125, 5, 70, "ExampleText",
 CellID->1555611073],
Cell[CellGroupData[{
Cell[26612, 951, 187, 6, 70, "Input",
 CellID->1033344781],
Cell[26802, 959, 71, 2, 70, "Output",
 CellID->725480978]
}, Open  ]],
Cell[26888, 964, 126, 3, 70, "ExampleDelimiter",
 CellID->2124922981],
Cell[27017, 969, 245, 8, 70, "ExampleText",
 CellID->927492057],
Cell[CellGroupData[{
Cell[27287, 981, 285, 9, 70, "Input",
 CellID->1689385333],
Cell[27575, 992, 6473, 110, 70, "Output",
 CellID->1825340279]
}, Open  ]],
Cell[CellGroupData[{
Cell[34085, 1107, 142, 4, 70, "Input",
 CellID->1690171758],
Cell[34230, 1113, 88, 2, 70, "Output",
 CellID->1950537837]
}, Open  ]],
Cell[34333, 1118, 125, 3, 70, "ExampleDelimiter",
 CellID->140361808],
Cell[34461, 1123, 88, 1, 70, "ExampleText",
 CellID->1123862650],
Cell[CellGroupData[{
Cell[34574, 1128, 29352, 489, 70, "Input",
 CellID->1071273883],
Cell[63929, 1619, 86, 2, 70, "Output",
 CellID->397255133]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[64054, 1626, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

