(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40216,       1256]
NotebookOptionsPosition[     34147,       1062]
NotebookOutlinePosition[     35752,       1103]
CellTagsIndexPosition[     35666,       1098]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"], 
          "Exporting Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExportingGraphicsAndSounds"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing Graphics and Sounds\"\>", 
       2->"\<\"Exporting Graphics and Sounds\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"PBM\"" :> Documentation`HelpLookup["paclet:ref/format/PBM"], 
          "\"PGM\"" :> Documentation`HelpLookup["paclet:ref/format/PGM"], 
          "\"PNG\"" :> Documentation`HelpLookup["paclet:ref/format/PNG"], 
          "\"PPM\"" :> Documentation`HelpLookup["paclet:ref/format/PPM"], 
          "\"TIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TIFF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"GIF\\\"\"\>", 
       2->"\<\"\\\"PBM\\\"\"\>", 3->"\<\"\\\"PGM\\\"\"\>", 
       4->"\<\"\\\"PNG\\\"\"\>", 5->"\<\"\\\"PPM\\\"\"\>", 
       6->"\<\"\\\"TIFF\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Listing of All Formats\"\>", 
       2->"\<\"Raster Image Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "PNM ",
 StyleBox["(.pnm)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->7514],

Cell[TextData[{
 "MIME types: ",
 StyleBox["image/x-portable-anymap", "InlineCode"],
 ", ",
 StyleBox["image/pbm", "InlineCode"],
 "\nPNM raster image format.\nGeneric format of the Portable family of image \
formats.\nIncludes the PBM (monochrome), PGM (gray-level) and PPM (RGB color) \
image formats.\nNative format of the Netpbm graphics software package.\n\
Primarily used as an intermediate file format on Unix systems.\nPNM is an \
acronym derived from Portable Any Map.\nASCII or binary format.\nStores \
raster images formatted as plain text, representing each pixel as color \
values."
}], "FormatUsage",
 CellID->10168],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the ",
 "PNM",
 " format. "
}], "FormatNotes",
 CellID->5055],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " creates binary PNM files."
}], "FormatNotes",
 CellID->1596450368],

Cell[TextData[{
 "If multiple images are present in a ",
 "PNM",
 " file, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " returns the first of the images."
}], "FormatNotes",
 CellID->1665544589]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->5973],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pnm\>\"", "]"}]], "InlineFormula"],
 " imports a ",
 "PNM",
 " file, returning a graphics object."
}], "FormatNotes",
 CellID->8922],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pnm\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports graphics or any other expression as a PNM raster image."
}], "FormatNotes",
 CellID->6748],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default generates binary PNM files."
}], "FormatNotes",
 CellID->1765409907],

Cell["", "WeakDivider",
 CellID->5651],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pnm\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     StyleBox["data", "TI"], "]"}], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " is an array of color values."
}], "FormatNotes",
 CellID->10986],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pnm\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "creates a ",
 "PNM",
 " image with the same image size as the displayed form of ",
 Cell[BoxData[
  FormBox[
   StyleBox["expr", "TI"], TraditionalForm]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->2144],

Cell["\<\
Because PNM is a raster image format, all fonts are rasterized on export.\
\>", "FormatNotes",
 CellID->16446],

Cell["", "WeakDivider",
 CellID->31577],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pnm\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a ",
 "PNM",
 " file."
}], "FormatNotes",
 CellID->26517],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pnm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->14629],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pnm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->29916],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<PNM\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<PNM\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5874],

Cell["", "WeakDivider",
 CellID->15791],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pnm\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 "PNM",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->15469],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pnm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], 
      StyleBox["}", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->22912],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pnm\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->8146],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pnm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->30693],

Cell["", "WeakDivider",
 CellID->9091],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "PNM",
 " format."
}], "FormatNotes",
 CellID->26949]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->26857],

Cell[TextData[{
 "In the notebook front end, ",
 StyleBox["Insert \[FilledRightTriangle] Picture", "MenuName"],
 " and the ",
 StyleBox["Open", "MenuName"],
 " menu allow import of a PNM file into a cell. "
}], "FormatNotes",
 CellID->20640],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook as a PNM file."
}], "FormatNotes",
 CellID->26052]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->236],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->8551],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->9487],

Cell["", "WeakDivider",
 CellID->31226],

Cell["Data representation elements:", "FormatNotes",
 CellID->28162],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "array of color values", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Graphics\>\"", Cell["", "TableText"]}], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " object representing an image"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GrayLevels\>\"", Cell[
    "array of normalized gray-level values", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RGBColorArray\>\"", Cell[TextData[{
     "array of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->16955],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default use the ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 "element for ",
 "PNM",
 " files."
}], "FormatNotes",
 CellID->8394],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " element:"
}], "FormatNotes",
 CellID->468620669],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ImageSize\>\"", Cell[
    "raster dimensions", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1285050334]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->30180],

Cell["General option:", "FormatNotes",
 CellID->16097],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall image size", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->3065],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->2513],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ColorMap\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
determines the color reduction palette used for representing the imported PNM \
image\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DitheringMethod\>\"", 
    "\"\<FloydSteinberg\>\"", Cell[TextData[{
     "the dithering method used when color reduction is performed on ",
     Cell[BoxData[
      ButtonBox["Import",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Import"]], "InlineFormula"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->9261],

Cell["The following settings can be given for \"ColorMap\": ", "FormatNotes",
 CellID->31101],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "chooses an adaptive set of at most 256 colors", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "adaptive set of at most ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " colors"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["color", "TI"], 
       StyleBox["1", "TR"]], ",", " ", 
      SubscriptBox[
       StyleBox["color", "TI"], 
       StyleBox["2", "TR"]], ",", " ", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no color reduction is performed", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->24393],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<DitheringMethod\>\""], "InlineFormula"],
 " option specifies the dithering algorithm used for generating the color \
reduction palette on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 ":"
}], "FormatNotes",
 CellID->442094198],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<FloydSteinberg\>\"", Cell["\<\
Floyd\[Dash]Steinberg error diffusion dithering\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no dithering is used", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->10285],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->21078],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ImageTopOrientation\>\"", 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "orientation of the exported image", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->16878],

Cell["Detailed properties and settings:", "FormatNotes",
 CellID->4611],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ColorSpace\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "color space of the image", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->31947]
}, Closed]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->24750],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "Tutorials",
 CellID->9009],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "Tutorials",
 CellID->503348882]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22214],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PBM\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PBM"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PGM\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PGM"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PPM\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PPM"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TIFF"]], "InlineFormula"]
}], "SeeAlso",
 CellID->218642263]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->342259899],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->734789279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", "\"\<ExampleData/ca.pnm\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399563061],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3L+LZllaB/ABI3NhYIMaBDGQgRLcwECjwcQ1UcFEow4WShFNBDEZpFkR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   "], {{0, 0}, {102, 76}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{102, 76},
  PlotRange->{{0, 102}, {0, 76}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->275002058]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", 
  RowBox[{"\"\<ExampleData/ca.pnm\>\"", ",", " ", "\"\<ImageSize\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1706109139],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"102", ",", "76"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1374644429]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PNM - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 41.4349730}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME types: image/x-portable-anymap, image/pbm PNM raster image format. \
Generic format of the Portable family of image formats. Includes the PBM \
(monochrome), PGM (gray-level) and PPM (RGB color) image formats. Native \
format of the Netpbm graphics software package. Primarily used as an \
intermediate file format on Unix systems. PNM is an acronym derived from \
Portable Any Map. ASCII or binary format. Stores raster images formatted as \
plain text, representing each pixel as color values.", "synonyms" -> {}, 
    "title" -> "PNM", "type" -> "Format", "uri" -> "ref/format/PNM"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[24442, 872, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35532, 1091}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2643, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3266, 87, 101, 4, 70, "ObjectNameAlt",
 CellID->7514],
Cell[3370, 93, 630, 13, 70, "FormatUsage",
 CellID->10168],
Cell[4003, 108, 334, 14, 70, "FormatNotes",
 CellID->5055],
Cell[4340, 124, 200, 7, 70, "FormatNotes",
 CellID->1596450368],
Cell[4543, 133, 268, 10, 70, "FormatNotes",
 CellID->1665544589]
}, Open  ]],
Cell[CellGroupData[{
Cell[4848, 148, 63, 1, 70, "ImportExportSection",
 CellID->5973],
Cell[4914, 151, 304, 11, 70, "FormatNotes",
 CellID->8922],
Cell[5221, 164, 357, 11, 70, "FormatNotes",
 CellID->6748],
Cell[5581, 177, 213, 7, 70, "FormatNotes",
 CellID->1765409907],
Cell[5797, 186, 38, 1, 70, "WeakDivider",
 CellID->5651],
Cell[5838, 189, 748, 26, 70, "FormatNotes",
 CellID->10986],
Cell[6589, 217, 493, 18, 70, "FormatNotes",
 CellID->2144],
Cell[7085, 237, 120, 3, 70, "FormatNotes",
 CellID->16446],
Cell[7208, 242, 39, 1, 70, "WeakDivider",
 CellID->31577],
Cell[7250, 245, 351, 13, 70, "FormatNotes",
 CellID->26517],
Cell[7604, 260, 574, 20, 70, "FormatNotes",
 CellID->14629],
Cell[8181, 282, 582, 21, 70, "FormatNotes",
 CellID->29916],
Cell[8766, 305, 702, 25, 70, "FormatNotes",
 CellID->5874],
Cell[9471, 332, 39, 1, 70, "WeakDivider",
 CellID->15791],
Cell[9513, 335, 524, 20, 70, "FormatNotes",
 CellID->15469],
Cell[10040, 357, 1096, 40, 70, "FormatNotes",
 CellID->22912],
Cell[11139, 399, 661, 22, 70, "FormatNotes",
 CellID->8146],
Cell[11803, 423, 816, 28, 70, "FormatNotes",
 CellID->30693],
Cell[12622, 453, 38, 1, 70, "WeakDivider",
 CellID->9091],
Cell[12663, 456, 360, 14, 70, "FormatNotes",
 CellID->9815],
Cell[13026, 472, 352, 14, 70, "FormatNotes",
 CellID->26949]
}, Closed]],
Cell[CellGroupData[{
Cell[13415, 491, 70, 1, 70, "NotebookInterfaceSection",
 CellID->26857],
Cell[13488, 494, 241, 7, 70, "FormatNotes",
 CellID->20640],
Cell[13732, 503, 153, 4, 70, "FormatNotes",
 CellID->26052]
}, Closed]],
Cell[CellGroupData[{
Cell[13922, 512, 49, 1, 70, "ElementsSection",
 CellID->236],
Cell[13974, 515, 191, 8, 70, "FormatNotes",
 CellID->8551],
Cell[14168, 525, 710, 14, 70, "2ColumnTableMod",
 CellID->9487],
Cell[14881, 541, 39, 1, 70, "WeakDivider",
 CellID->31226],
Cell[14923, 544, 68, 1, 70, "FormatNotes",
 CellID->28162],
Cell[14994, 547, 1082, 27, 70, "2ColumnTableMod",
 CellID->16955],
Cell[16079, 576, 403, 16, 70, "FormatNotes",
 CellID->8394],
Cell[16485, 594, 196, 8, 70, "FormatNotes",
 CellID->468620669],
Cell[16684, 604, 354, 9, 70, "2ColumnTableMod",
 CellID->1285050334]
}, Open  ]],
Cell[CellGroupData[{
Cell[17075, 618, 49, 1, 70, "OptionsSection",
 CellID->30180],
Cell[17127, 621, 54, 1, 70, "FormatNotes",
 CellID->16097],
Cell[17184, 624, 516, 15, 70, "3ColumnTableMod",
 CellID->3065],
Cell[17703, 641, 177, 7, 70, "FormatNotes",
 CellID->2513],
Cell[17883, 650, 849, 22, 70, "3ColumnTableMod",
 CellID->9261],
Cell[18735, 674, 93, 1, 70, "FormatNotes",
 CellID->31101],
Cell[18831, 677, 1388, 41, 70, "2ColumnTableMod",
 CellID->24393],
Cell[20222, 720, 343, 11, 70, "FormatNotes",
 CellID->442094198],
Cell[20568, 733, 568, 15, 70, "2ColumnTableMod",
 CellID->10285],
Cell[21139, 750, 178, 7, 70, "FormatNotes",
 CellID->21078],
Cell[21320, 759, 457, 12, 70, "3ColumnTableMod",
 CellID->16878],
Cell[21780, 773, 71, 1, 70, "FormatNotes",
 CellID->4611],
Cell[21854, 776, 451, 12, 70, "3ColumnTableMod",
 CellID->31947]
}, Closed]],
Cell[CellGroupData[{
Cell[22342, 793, 53, 1, 70, "TutorialsSection",
 CellID->24750],
Cell[22398, 796, 165, 3, 70, "Tutorials",
 CellID->9009],
Cell[22566, 801, 170, 3, 70, "Tutorials",
 CellID->503348882]
}, Closed]],
Cell[CellGroupData[{
Cell[22773, 809, 50, 1, 70, "SeeAlsoSection",
 CellID->22214],
Cell[22826, 812, 1215, 41, 70, "SeeAlso",
 CellID->218642263]
}, Open  ]],
Cell[CellGroupData[{
Cell[24078, 858, 58, 1, 70, "MoreAboutSection",
 CellID->342259899],
Cell[24139, 861, 133, 2, 70, "MoreAbout"],
Cell[24275, 865, 130, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24442, 872, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[24558, 878, 60, 1, 70, "ExampleSection",
 CellID->734789279],
Cell[CellGroupData[{
Cell[24643, 883, 132, 3, 70, "Input",
 CellID->399563061],
Cell[24778, 888, 8963, 151, 70, "Output",
 CellID->275002058]
}, Open  ]],
Cell[CellGroupData[{
Cell[33778, 1044, 180, 5, 70, "Input",
 CellID->1706109139],
Cell[33961, 1051, 120, 4, 70, "Output",
 CellID->1374644429]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[34120, 1060, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

