(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   5641001,      88024]
NotebookOptionsPosition[   5635525,      87847]
NotebookOutlinePosition[   5636922,      87886]
CellTagsIndexPosition[   5636833,      87881]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"3DS\"" :> Documentation`HelpLookup["paclet:ref/format/3DS"], 
          "\"BYU\"" :> Documentation`HelpLookup["paclet:ref/format/BYU"], 
          "\"JVX\"" :> Documentation`HelpLookup["paclet:ref/format/JVX"], 
          "\"LWO\"" :> Documentation`HelpLookup["paclet:ref/format/LWO"], 
          "\"Maya\"" :> Documentation`HelpLookup["paclet:ref/format/Maya"], 
          "\"NOFF\"" :> Documentation`HelpLookup["paclet:ref/format/NOFF"], 
          "\"OBJ\"" :> Documentation`HelpLookup["paclet:ref/format/OBJ"], 
          "\"OFF\"" :> Documentation`HelpLookup["paclet:ref/format/OFF"], 
          "\"PLY\"" :> Documentation`HelpLookup["paclet:ref/format/PLY"], 
          "\"POV\"" :> Documentation`HelpLookup["paclet:ref/format/POV"], 
          "\"STL\"" :> Documentation`HelpLookup["paclet:ref/format/STL"], 
          "\"VRML\"" :> Documentation`HelpLookup["paclet:ref/format/VRML"], 
          "\"X3D\"" :> Documentation`HelpLookup["paclet:ref/format/X3D"], 
          "\"ZPR\"" :> Documentation`HelpLookup["paclet:ref/format/ZPR"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"3DS\\\"\"\>", 
       2->"\<\"\\\"BYU\\\"\"\>", 3->"\<\"\\\"JVX\\\"\"\>", 
       4->"\<\"\\\"LWO\\\"\"\>", 5->"\<\"\\\"Maya\\\"\"\>", 
       6->"\<\"\\\"NOFF\\\"\"\>", 7->"\<\"\\\"OBJ\\\"\"\>", 
       8->"\<\"\\\"OFF\\\"\"\>", 9->"\<\"\\\"PLY\\\"\"\>", 
       10->"\<\"\\\"POV\\\"\"\>", 11->"\<\"\\\"STL\\\"\"\>", 
       12->"\<\"\\\"VRML\\\"\"\>", 13->"\<\"\\\"X3D\\\"\"\>", 
       14->"\<\"\\\"ZPR\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"3D Geometry & Modeling Formats\"\>", 
       2->"\<\"Listing of All Formats\"\>", 
       3->"\<\"New in 6.0: Import & Export Formats\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "RIB ",
 StyleBox["(.rib)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell["\<\
RenderMan RIB user entity file.
3D geometry format.
Used for photorealistic modeling and rendering.
Stores 3D object definitions and scene descriptions.
Native format of the RenderMan application.
RIB is an acronym for RenderMan Interface Bytestream.
Developed by Pixar in 1990.\
\>", "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support version 1.1 of the RIB entity file format."
}], "FormatNotes",
 CellID->5821],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " reads planar convex polygon data from RIB entity files, ignoring possible \
directives for geometric transformations."
}], "FormatNotes",
 CellID->1979082349]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rib\>\"", "]"}]], "InlineFormula"],
 "imports an ",
 "RIB",
 " file ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rib\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " expression to an ",
 "RIB",
 " file."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rib\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "[", " ", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    RowBox[{
     StyleBox["vertices", "TI"], 
     StyleBox[",", "TI"], 
     StyleBox["primitives", "TI"], ",", 
     StyleBox["opts", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->25134],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rib\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "RIB",
 " entity file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rib\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rib\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<RIB\>\""}], "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<RIB\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rib\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates an RIB entity file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rib\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rib\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rib\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "RIB",
 " format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->15947],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Data representation elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "RIB user entity file represented as a ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsComplex\>\"", Cell[
    TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " objects, each representing a 3D geometry stored in the file"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonData\>\"", Cell[
    "polygon data in indexed form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexColors\>\"", Cell["\<\
colors associated with each vertex, given as a list of color primitives\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexData\>\"", Cell[
    "list of vertex coordinates", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexNormals\>\"", Cell[TextData[{
     "normal vectors corresponding to the vertices given by ",
     Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->230773093],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Graphics3D\>\""], "InlineFormula"],
 " element by default for RIB files."
}], "FormatNotes",
 CellID->13037],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"],
 " element corresponds to the first argument of ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->4998],

Cell[TextData[{
 "When rendering a RIB color model, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically uses the setting",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    ButtonBox["Lighting",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Lighting"], "->", "\"\<Neutral\>\""}]}]], 
  "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1495251562]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1911960202],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what background color to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall size of the graphics to display", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Lighting",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Lighting"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what simulated lighting to use in coloring 3D surfaces", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->2123520593],

Cell["Meta-information options:", "FormatNotes",
 CellID->45056417],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Comments\>\"", Cell["", "TableText"]}], Cell[TextData[Cell[
    BoxData[
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]], "InlineFormula"]], "TableText"], Cell[
    "list of strings, representing user comments", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<CreationDate\>\"", Cell["", "TableText"]}], Cell[TextData[
    Cell[BoxData[
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]], "InlineFormula"]], "TableText"], 
    Cell["time and date when the file was created, given as a string", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Creator\>\"", Cell["", "TableText"]}], Cell[TextData[Cell[
    BoxData[
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]], "InlineFormula"]], "TableText"], 
    Cell["application used to generate the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Scene\>\"", Cell["", "TableText"]}], Cell[TextData[Cell[
    BoxData[
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]], "InlineFormula"]], "TableText"], 
    Cell["scene name associated with the entity file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1348956775]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<3DS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/3DS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<BYU\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/BYU"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JVX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JVX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LWO\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LWO"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Maya\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Maya"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NOFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NOFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OBJ\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OBJ"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PLY\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PLY"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<POV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/POV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<STL\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/STL"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<VRML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/VRML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<X3D\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/X3D"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ZPR\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ZPR"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1919681360]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->149206020],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->45555245],

Cell[TextData[{
 "This imports a RIB example file, rendering it as ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1038555288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/tesselatedcube.rib.gz\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17199],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[None], 
   GraphicsComplex3DBox[{{0., 0., 
    0.}, {-0.005171109167864868, -0.07756663751797302, 
    0.005171109167864868}, {-0.008765155746547347, -0.11600941429253843`, 
    0.013921129715104607`}, {-0.0012873487674722039`, -0.05793069453624921, 
    0.0038620463024166113`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.005171109167864868, -0.07756663751797302, 
    0.005171109167864868}, {-0.02041142073737483, -0.15308565553031123`, 
    0.02041142073737483}, {-0.02248032781181198, -0.17441633647095503`, 
    0.030232164988298865`}, {-0.008765155746547347, -0.11600941429253843`, 
    0.013921129715104607`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.02041142073737483, -0.15308565553031123`, 
    0.02041142073737483}, {-0.04495902221896904, -0.22479511109484523`, 
    0.04495902221896904}, {-0.04202978289190042, -0.23065124757750236`, 
    0.052280949450900525`}, {-0.02248032781181198, -0.17441633647095503`, 
    0.030232164988298865`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.04495902221896904, -0.22479511109484523`, 
    0.04495902221896904}, {-0.07771364461602205, -0.2914261673100827, 
    0.07771364461602205}, {-0.0668487308419404, -0.2837917818761621, 
    0.07946169892532537}, {-0.04202978289190042, -0.23065124757750236`, 
    0.052280949450900525`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07771364461602205, -0.2914261673100827, 
    0.07771364461602205}, {-0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {-0.09630795334285228, -0.3333736846483348, 
    0.11112456154944492`}, {-0.0668487308419404, -0.2837917818761621, 
    0.07946169892532537}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {-0.09546533160684004, -0.3579949935256501, 
    0.14319799741026004`}, {-0.08026080379573056, -0.3407298274347052, 
    0.131748866608086}, {-0.09630795334285228, -0.3333736846483348, 
    0.11112456154944492`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09546533160684004, -0.3579949935256501, 
    0.14319799741026004`}, {-0.07483045886349166, -0.37415229431745833`, 
    0.1746044040148139}, {-0.0647349985271792, -0.3552530406979347, 
    0.15631133790709126`}, {-0.08026080379573056, -0.3407298274347052, 
    0.131748866608086}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07483045886349166, -0.37415229431745833`, 
    0.1746044040148139}, {-0.05311638731862741, -0.3983729048897056, 
    0.21246554927450964`}, {-0.04838919502195432, -0.3754334096530939, 
    0.18521381542885962`}, {-0.0647349985271792, -0.3552530406979347, 
    0.15631133790709126`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.05311638731862741, -0.3983729048897056, 
    0.21246554927450964`}, {-0.028521062476874796`, -0.42781593715312194`, 
    0.2566895622918732}, {-0.030189136362876293`, -0.39956209892042155`, 
    0.21842728074316375`}, {-0.04838919502195432, -0.3754334096530939, 
    0.18521381542885962`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.028521062476874796`, -0.42781593715312194`, 
    0.2566895622918732}, {0., -0.45998714286871445`, 
    0.3066580952458096}, {-0.009468363199652228, -0.4260763439843505, 
    0.2556458063906103}, {-0.030189136362876293`, -0.39956209892042155`, 
    0.21842728074316375`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.45998714286871445`, 0.3066580952458096}, {
    0., -0.38905011534806727`, 
    0.20749339485230253`}, {-0.008131042914707273, -0.36589693116182753`, 
    0.18050915270650156`}, {-0.009468363199652228, -0.4260763439843505, 
    0.2556458063906103}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.38905011534806727`, 0.20749339485230253`}, {
    0., -0.30673802522798127`, 
    0.1226952100911925}, {-0.006628516589374509, -0.2982832465218531, 
    0.11533618865511652`}, {-0.008131042914707273, -0.36589693116182753`, 
    0.18050915270650156`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.30673802522798127`, 0.1226952100911925}, {
    0., -0.21282462147366246`, 
    0.05675323239297665}, {-0.004963354542040988, -0.22335095439184463`, 
    0.06253826722971649}, {-0.006628516589374509, -0.2982832465218531, 
    0.11533618865511652`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.21282462147366246`, 0.05675323239297665}, {
    0., -0.10920608786993075`, 
    0.014560811715990765`}, {-0.003160550910532909, -0.142224790973981, 
    0.0246522971021567}, {-0.004963354542040988, -0.22335095439184463`, 
    0.06253826722971649}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.10920608786993075`, 0.014560811715990765`}, {
    0., 0., 0.}, {-0.0012873487674722039`, -0.05793069453624921, 
    0.0038620463024166113`}, {-0.003160550910532909, -0.142224790973981, 
    0.0246522971021567}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.45998714286871445`, 
    0.3066580952458096}, {-0.06219340349207606, -0.4664505261905705, 
    0.3109670174603803}, {-0.07978930111077108, -0.4603228910236794, 
    0.2966525297708156}, {-0.03004186805503801, -0.45062802082557046`, 
    0.29040472453203425`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06219340349207606, -0.4664505261905705, 
    0.3109670174603803}, {-0.12923159990300587`, -0.48461849963627207`, 
    0.3230789997575147}, {-0.13366765457769086`, -0.4773844806346103, 
    0.30764777640897106`}, {-0.07978930111077108, -0.4603228910236794, 
    0.2966525297708156}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.12923159990300587`, -0.48461849963627207`, 
    0.3230789997575147}, {-0.20461481167731652`, -0.5115370291932914, 
    0.3410246861288609}, {-0.19333151383599093`, -0.4999952944034249, 
    0.32221918972665153`}, {-0.13366765457769086`, -0.4773844806346103, 
    0.30764777640897106`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20461481167731652`, -0.5115370291932914, 
    0.3410246861288609}, {-0.29013399227834397`, -0.5440012355218949, 
    0.36266749034792994`}, {-0.25965194503259137`, -0.5263215102011988, 
    0.3391849732407725}, {-0.19333151383599093`, -0.4999952944034249, 
    0.32221918972665153`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.29013399227834397`, -0.5440012355218949, 
    0.36266749034792994`}, {-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.3329657494680982, -0.5549429157801637, 
    0.3576298790583277}, {-0.25965194503259137`, -0.5263215102011988, 
    0.3391849732407725}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.3251055239962821, -0.5418425399938036, 
    0.3251055239962821}, {-0.2862137017352461, -0.5235616495156941, 
    0.30948310838038806`}, {-0.3329657494680982, -0.5549429157801637, 
    0.3576298790583277}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3251055239962821, -0.5418425399938036, 
    0.3251055239962821}, {-0.2673132787288769, -0.5012123976166442, 
    0.2673132787288769}, {-0.24176935360143517`, -0.49007301405696324`, 
    0.2635503764484113}, {-0.2862137017352461, -0.5235616495156941, 
    0.30948310838038806`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2673132787288769, -0.5012123976166442, 
    0.2673132787288769}, {-0.21311308081691166`, -0.4566708874648107, 
    0.21311308081691166`}, {-0.19972264378740437`, -0.4539150995168281, 
    0.2198966482103745}, {-0.24176935360143517`, -0.49007301405696324`, 
    0.2635503764484113}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21311308081691166`, -0.4566708874648107, 
    0.21311308081691166`}, {-0.1629042820200324, -0.40726070505008105`, 
    0.1629042820200324}, {-0.1603207616432846, -0.4146226594222878, 
    0.1787484353953863}, {-0.19972264378740437`, -0.4539150995168281, 
    0.2198966482103745}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1629042820200324, -0.40726070505008105`, 
    0.1629042820200324}, {-0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {-0.12394767411382335`, -0.37184302234147004`, 
    0.1404740306623331}, {-0.1603207616432846, -0.4146226594222878, 
    0.1787484353953863}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {-0.09546533160684004, -0.3579949935256501, 
    0.14319799741026004`}, {-0.10580644230106709`, -0.37788015107523965`, 
    0.16290833179688105`}, {-0.12394767411382335`, -0.37184302234147004`, 
    0.1404740306623331}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09546533160684004, -0.3579949935256501, 
    0.14319799741026004`}, {-0.07483045886349166, -0.37415229431745833`, 
    0.1746044040148139}, {-0.08838155995073098, -0.38991864684146027`, 
    0.18889392224764073`}, {-0.10580644230106709`, -0.37788015107523965`, 
    0.16290833179688105`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07483045886349166, -0.37415229431745833`, 
    0.1746044040148139}, {-0.05311638731862741, -0.3983729048897056, 
    0.21246554927450964`}, {-0.07052824422808539, -0.40689371670049274`, 
    0.2188183987589316}, {-0.08838155995073098, -0.38991864684146027`, 
    0.18889392224764073`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.05311638731862741, -0.3983729048897056, 
    0.21246554927450964`}, {-0.028521062476874796`, -0.42781593715312194`, 
    0.2566895622918732}, {-0.05130464075001894, -0.4275386729168246, 
    0.2527228599908341}, {-0.07052824422808539, -0.40689371670049274`, 
    0.2188183987589316}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.028521062476874796`, -0.42781593715312194`, 
    0.2566895622918732}, {0., -0.45998714286871445`, 
    0.3066580952458096}, {-0.03004186805503801, -0.45062802082557046`, 
    0.29040472453203425`}, {-0.05130464075001894, -0.4275386729168246, 
    0.2527228599908341}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {0., -0.10920608786993075`, 
    0.014560811715990765`}, {0.003160550910532909, -0.142224790973981, 
    0.0246522971021567}, {0.0012873487674722039`, -0.05793069453624921, 
    0.0038620463024166113`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.10920608786993075`, 0.014560811715990765`}, {
    0., -0.21282462147366246`, 0.05675323239297665}, {
    0.004963354542040988, -0.22335095439184463`, 0.06253826722971648}, {
    0.003160550910532909, -0.142224790973981, 0.0246522971021567}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.21282462147366246`, 0.05675323239297665}, {
    0., -0.30673802522798127`, 0.1226952100911925}, {
    0.006628516589374509, -0.2982832465218531, 0.11533618865511652`}, {
    0.004963354542040988, -0.22335095439184463`, 0.06253826722971648}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.30673802522798127`, 0.1226952100911925}, {
    0., -0.38905011534806727`, 0.20749339485230253`}, {
    0.008131042914707273, -0.36589693116182753`, 0.18050915270650156`}, {
    0.006628516589374509, -0.2982832465218531, 0.11533618865511652`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.38905011534806727`, 0.20749339485230253`}, {
    0., -0.45998714286871445`, 0.3066580952458096}, {
    0.009468363199652228, -0.4260763439843505, 0.2556458063906103}, {
    0.008131042914707273, -0.36589693116182753`, 0.18050915270650156`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.45998714286871445`, 0.3066580952458096}, {
    0.028521062476874796`, -0.42781593715312194`, 0.2566895622918732}, {
    0.030189136362876293`, -0.39956209892042155`, 0.21842728074316375`}, {
    0.009468363199652228, -0.4260763439843505, 0.2556458063906103}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.028521062476874796`, -0.42781593715312194`, 
    0.2566895622918732}, {0.05311638731862741, -0.3983729048897056, 
    0.21246554927450964`}, {0.04838919502195432, -0.3754334096530939, 
    0.18521381542885962`}, {0.030189136362876293`, -0.39956209892042155`, 
    0.21842728074316375`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.05311638731862741, -0.3983729048897056, 
    0.21246554927450964`}, {0.07483045886349166, -0.37415229431745833`, 
    0.1746044040148139}, {0.0647349985271792, -0.3552530406979347, 
    0.15631133790709126`}, {0.04838919502195432, -0.3754334096530939, 
    0.18521381542885962`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07483045886349166, -0.37415229431745833`, 
    0.1746044040148139}, {0.09546533160684004, -0.3579949935256501, 
    0.14319799741026004`}, {0.08026080379573056, -0.3407298274347052, 
    0.131748866608086}, {0.0647349985271792, -0.3552530406979347, 
    0.15631133790709126`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.09546533160684004, -0.3579949935256501, 
    0.14319799741026004`}, {0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {0.09630795334285228, -0.3333736846483348, 
    0.11112456154944492`}, {0.08026080379573056, -0.3407298274347052, 
    0.131748866608086}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {0.07771364461602205, -0.2914261673100827, 
    0.07771364461602205}, {0.0668487308419404, -0.2837917818761621, 
    0.07946169892532537}, {0.09630795334285228, -0.3333736846483348, 
    0.11112456154944492`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07771364461602205, -0.2914261673100827, 
    0.07771364461602205}, {0.04495902221896904, -0.22479511109484523`, 
    0.04495902221896904}, {0.04202978289190042, -0.23065124757750236`, 
    0.052280949450900525`}, {0.0668487308419404, -0.2837917818761621, 
    0.07946169892532537}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.04495902221896904, -0.22479511109484523`, 
    0.04495902221896904}, {0.02041142073737483, -0.15308565553031123`, 
    0.02041142073737483}, {0.02248032781181198, -0.17441633647095503`, 
    0.030232164988298865`}, {0.04202978289190042, -0.23065124757750236`, 
    0.052280949450900525`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.02041142073737483, -0.15308565553031123`, 
    0.02041142073737483}, {0.005171109167864868, -0.07756663751797302, 
    0.005171109167864868}, {0.008765155746547347, -0.11600941429253843`, 
    0.013921129715104607`}, {0.02248032781181198, -0.17441633647095503`, 
    0.030232164988298865`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.005171109167864868, -0.07756663751797302, 
    0.005171109167864868}, {0., 0., 0.}, {
    0.0012873487674722039`, -0.05793069453624921, 0.0038620463024166113`}, {
    0.008765155746547347, -0.11600941429253843`, 0.013921129715104607`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.45998714286871445`, 0.3066580952458096}, {
    0.028521062476874796`, -0.42781593715312194`, 0.2566895622918732}, {
    0.05130464075001894, -0.4275386729168246, 0.2527228599908341}, {
    0.03004186805503801, -0.45062802082557046`, 0.29040472453203425`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.028521062476874796`, -0.42781593715312194`, 
    0.2566895622918732}, {0.05311638731862741, -0.3983729048897056, 
    0.21246554927450964`}, {0.07052824422808539, -0.40689371670049274`, 
    0.2188183987589316}, {0.05130464075001894, -0.4275386729168246, 
    0.2527228599908341}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.05311638731862741, -0.3983729048897056, 
    0.21246554927450964`}, {0.07483045886349166, -0.37415229431745833`, 
    0.1746044040148139}, {0.08838155995073098, -0.38991864684146027`, 
    0.18889392224764073`}, {0.07052824422808539, -0.40689371670049274`, 
    0.2188183987589316}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07483045886349166, -0.37415229431745833`, 
    0.1746044040148139}, {0.09546533160684004, -0.3579949935256501, 
    0.14319799741026004`}, {0.10580644230106709`, -0.37788015107523965`, 
    0.16290833179688105`}, {0.08838155995073098, -0.38991864684146027`, 
    0.18889392224764073`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.09546533160684004, -0.3579949935256501, 
    0.14319799741026004`}, {0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {0.12394767411382335`, -0.37184302234147004`, 
    0.1404740306623331}, {0.10580644230106709`, -0.37788015107523965`, 
    0.16290833179688105`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {0.1629042820200324, -0.40726070505008105`, 
    0.1629042820200324}, {0.1603207616432846, -0.4146226594222878, 
    0.1787484353953863}, {0.12394767411382335`, -0.37184302234147004`, 
    0.1404740306623331}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1629042820200324, -0.40726070505008105`, 
    0.1629042820200324}, {0.21311308081691166`, -0.4566708874648107, 
    0.21311308081691166`}, {0.19972264378740437`, -0.4539150995168281, 
    0.2198966482103745}, {0.1603207616432846, -0.4146226594222878, 
    0.1787484353953863}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21311308081691166`, -0.4566708874648107, 
    0.21311308081691166`}, {0.2673132787288769, -0.5012123976166442, 
    0.2673132787288769}, {0.24176935360143517`, -0.49007301405696324`, 
    0.2635503764484113}, {0.19972264378740437`, -0.4539150995168281, 
    0.2198966482103745}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2673132787288769, -0.5012123976166442, 
    0.2673132787288769}, {0.3251055239962821, -0.5418425399938036, 
    0.3251055239962821}, {0.2862137017352461, -0.5235616495156941, 
    0.30948310838038806`}, {0.24176935360143517`, -0.49007301405696324`, 
    0.2635503764484113}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3251055239962821, -0.5418425399938036, 
    0.3251055239962821}, {0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.3329657494680982, -0.5549429157801637, 
    0.3576298790583277}, {0.2862137017352461, -0.5235616495156941, 
    0.30948310838038806`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.29013399227834397`, -0.5440012355218949, 
    0.36266749034792994`}, {0.25965194503259137`, -0.5263215102011988, 
    0.3391849732407725}, {0.3329657494680982, -0.5549429157801637, 
    0.3576298790583277}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.29013399227834397`, -0.5440012355218949, 
    0.36266749034792994`}, {0.20461481167731652`, -0.5115370291932914, 
    0.3410246861288609}, {0.19333151383599093`, -0.4999952944034249, 
    0.32221918972665153`}, {0.25965194503259137`, -0.5263215102011988, 
    0.3391849732407725}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20461481167731652`, -0.5115370291932914, 
    0.3410246861288609}, {0.12923159990300587`, -0.48461849963627207`, 
    0.3230789997575147}, {0.1336676545776909, -0.4773844806346103, 
    0.30764777640897106`}, {0.19333151383599093`, -0.4999952944034249, 
    0.32221918972665153`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.12923159990300587`, -0.48461849963627207`, 
    0.3230789997575147}, {0.06219340349207606, -0.4664505261905705, 
    0.3109670174603803}, {0.07978930111077108, -0.4603228910236794, 
    0.2966525297708156}, {0.1336676545776909, -0.4773844806346103, 
    0.30764777640897106`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.06219340349207606, -0.4664505261905705, 
    0.3109670174603803}, {0., -0.45998714286871445`, 0.3066580952458096}, {
    0.03004186805503801, -0.45062802082557046`, 0.29040472453203425`}, {
    0.07978930111077108, -0.4603228910236794, 0.2966525297708156}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.4407985310247471, -0.6103364275727268, 
    0.4407985310247471}, {-0.4452427310725714, -0.6164899353312527, 
    0.4589425074132659}, {-0.4013008374837915, -0.5920832028449382, 
    0.41445824199145676`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4407985310247471, -0.6103364275727268, 
    0.4407985310247471}, {-0.49871361404698694`, -0.6412032180604118, 
    0.49871361404698694`}, {-0.4916236345631913, -0.641248218995467, 
    0.5058735949853128}, {-0.4452427310725714, -0.6164899353312527, 
    0.4589425074132659}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49871361404698694`, -0.6412032180604118, 
    0.49871361404698694`}, {-0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {-0.5412105935744802, -0.6672459372836057, 
    0.5560382810696715}, {-0.4916236345631913, -0.641248218995467, 
    0.5058735949853128}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {-0.5251512437069583, -0.6751944561946608, 
    0.6001728499508097}, {-0.5123956646927323, -0.6683421713383466, 
    0.5866559059525488}, {-0.5412105935744802, -0.6672459372836057, 
    0.5560382810696715}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5251512437069583, -0.6751944561946608, 
    0.6001728499508097}, {-0.49015740221892146`, -0.6786794799954298, 
    0.6409750644401281}, {-0.484544369547659, -0.670907588604451, 
    0.6187258872685492}, {-0.5123956646927323, -0.6683421713383466, 
    0.5866559059525488}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49015740221892146`, -0.6786794799954298, 
    0.6409750644401281}, {-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.4574749594975597, -0.6749630549963996, 
    0.6524642864965196}, {-0.484544369547659, -0.670907588604451, 
    0.6187258872685492}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.4304670307029078, -0.6457005460543618, 
    0.5739560409372104}, {-0.43706252979527566`, -0.6448463554356526, 
    0.5660318008824062}, {-0.4574749594975597, -0.6749630549963996, 
    0.6524642864965196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4304670307029078, -0.6457005460543618, 
    0.5739560409372104}, {-0.40767204398438894`, -0.6115080659765835, 
    0.4756173846484537}, {-0.4185959624434206, -0.6176006003263583, 
    0.48721825136857155`}, {-0.43706252979527566`, -0.6448463554356526, 
    0.5660318008824062}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.40767204398438894`, -0.6115080659765835, 
    0.4756173846484537}, {-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.4013008374837915, -0.5920832028449382, 
    0.41445824199145676`}, {-0.4185959624434206, -0.6176006003263583, 
    0.48721825136857155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.5578135523930144, -0.7171888530767329, 
    0.7171888530767329}, {-0.5649747532204069, -0.716165180138544, 
    0.7082077892481158}, {-0.48235791827893554`, -0.6890827403984794, 
    0.6814262655051629}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5578135523930144, -0.7171888530767329, 
    0.7171888530767329}, {-0.6791732466493353, -0.7640699024805022, 
    0.7640699024805022}, {-0.6601152491051621, -0.7520300306261339, 
    0.7436741413969546}, {-0.5649747532204069, -0.716165180138544, 
    0.7082077892481158}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6791732466493353, -0.7640699024805022, 
    0.7640699024805022}, {-0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {-0.7834402264884363, -0.8104554067121754, 
    0.8014503466375957}, {-0.6601152491051621, -0.7520300306261339, 
    0.7436741413969546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {-0.7198653019554957, -0.7622103197175837, 
    0.7198653019554957}, {-0.6920462242465636, -0.7504115684601292, 
    0.7087220368790109}, {-0.7834402264884363, -0.8104554067121754, 
    0.8014503466375957}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7198653019554957, -0.7622103197175837, 
    0.7198653019554957}, {-0.6327645227143793, -0.7118600880536767, 
    0.6327645227143793}, {-0.6249011299737146, -0.7119126797168901, 
    0.6407214117452011}, {-0.6920462242465636, -0.7504115684601292, 
    0.7087220368790109}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6327645227143793, -0.7118600880536767, 
    0.6327645227143793}, {-0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {-0.5675936973120723, -0.6811124367744867, 
    0.5827295292403942}, {-0.6249011299737146, -0.7119126797168901, 
    0.6407214117452011}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {-0.5251512437069583, -0.6751944561946608, 
    0.6001728499508097}, {-0.5382118349147983, -0.68224035411735, 
    0.614016318705615}, {-0.5675936973120723, -0.6811124367744867, 
    0.5827295292403942}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5251512437069583, -0.6751944561946608, 
    0.6001728499508097}, {-0.49015740221892146`, -0.6786794799954298, 
    0.6409750644401281}, {-0.5098591242716168, -0.6848853908126196, 
    0.6468362024341406}, {-0.5382118349147983, -0.68224035411735, 
    0.614016318705615}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49015740221892146`, -0.6786794799954298, 
    0.6409750644401281}, {-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.48235791827893554`, -0.6890827403984794, 
    0.6814262655051629}, {-0.5098591242716168, -0.6848853908126196, 
    0.6468362024341406}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.45998714286871445`, 
    0.3066580952458096}, {-0.038544848628222717`, -0.46253818353867265`, 
    0.30835878902578173`}, {-0.052786379282336135`, -0.47507741354102534`, 
    0.3272755515504841}, {-0.020955630116874954`, -0.47150167762968676`, 
    0.324812266811562}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.038544848628222717`, -0.46253818353867265`, 
    0.30835878902578173`}, {-0.07833195316248512, -0.46999171897491077`, 
    0.3133278126499405}, {-0.08560802621248467, -0.48154514744522636`, 
    0.33173110157337815`}, {-0.052786379282336135`, -0.47507741354102534`, 
    0.3272755515504841}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07833195316248512, -0.46999171897491077`, 
    0.3133278126499405}, {-0.12044994043743079`, -0.4817997617497233, 
    0.32119984116648215`}, {-0.11992963743797559`, -0.4906212440644457, 
    0.3379835236888404}, {-0.08560802621248467, -0.48154514744522636`, 
    0.33173110157337815`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.12044994043743079`, -0.4817997617497233, 
    0.32119984116648215`}, {-0.1657318525960958, -0.4971955577882874, 
    0.3314637051921916}, {-0.1561613637329016, -0.5019472405700409, 
    0.3457858768371393}, {-0.11992963743797559`, -0.4906212440644457, 
    0.3379835236888404}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1657318525960958, -0.4971955577882874, 
    0.3314637051921916}, {-0.176735752448586, -0.530207257345758, 
    0.39765544300931854`}, {-0.16447360317195706`, -0.5286651530527192, 
    0.3994358934176101}, {-0.1561613637329016, -0.5019472405700409, 
    0.3457858768371393}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.176735752448586, -0.530207257345758, 
    0.39765544300931854`}, {-0.18726648266764945`, -0.5617994480029483, 
    0.4681662066691236}, {-0.17247195529467113`, -0.5543741420185859, 
    0.4558187389930595}, {-0.16447360317195706`, -0.5286651530527192, 
    0.3994358934176101}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.18726648266764945`, -0.5617994480029483, 
    0.4681662066691236}, {-0.19749453248903248`, -0.5924835974670974, 
    0.5431099643448393}, {-0.18023995030369647`, -0.5793426974047388, 
    0.5149712865819899}, {-0.17247195529467113`, -0.5543741420185859, 
    0.4558187389930595}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.19749453248903248`, -0.5924835974670974, 
    0.5431099643448393}, {-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.18789655708653166`, -0.6039532192067091, 
    0.577110853908633}, {-0.18023995030369647`, -0.5793426974047388, 
    0.5149712865819899}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.14565785306317142`, -0.5826314122526858, 
    0.5340787945649619}, {-0.13970138965108453`, -0.571505684936255, 
    0.508005053276671}, {-0.18789655708653166`, -0.6039532192067091, 
    0.577110853908633}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.14565785306317142`, -0.5826314122526858, 
    0.5340787945649619}, {-0.09039737304879422, -0.5423842382927654, 
    0.4519868652439711}, {-0.09578808133406011, -0.5388079575040883, 
    0.4430198761700281}, {-0.13970138965108453`, -0.571505684936255, 
    0.508005053276671}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09039737304879422, -0.5423842382927654, 
    0.4519868652439711}, {-0.041781498251368454`, -0.5013779790164213, 
    0.37603348426231603`}, {-0.05615961056021798, -0.5054364950419619, 
    0.38188535180948235`}, {-0.09578808133406011, -0.5388079575040883, 
    0.4430198761700281}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.041781498251368454`, -0.5013779790164213, 
    0.37603348426231603`}, {0., -0.45998714286871445`, 
    0.3066580952458096}, {-0.020955630116874954`, -0.47150167762968676`, 
    0.324812266811562}, {-0.05615961056021798, -0.5054364950419619, 
    0.38188535180948235`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.45998714286871445`, 
    0.3066580952458096}, {-0.02708690739129757, -0.4875643330433564, 
    0.3521297960868685}, {-0.027651165009234, -0.4977209701662121, 
    0.37052561112373567`}, {-0.005290785729710824, -0.47617071567397445`, 
    0.33331950097178215`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.02708690739129757, -0.4875643330433564, 
    0.3521297960868685}, {-0.057237380507313335`, -0.5151364245658201, 
    0.4006616635511933}, {-0.05192776126127516, -0.5192776126127516, 
    0.4096523388389484}, {-0.027651165009234, -0.4977209701662121, 
    0.37052561112373567`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.057237380507313335`, -0.5151364245658201, 
    0.4006616635511933}, {-0.09039737304879422, -0.5423842382927654, 
    0.4519868652439711}, {-0.07810031047988147, -0.5406944571684102, 
    0.45057871430700847`}, {-0.05192776126127516, -0.5192776126127516, 
    0.4096523388389484}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09039737304879422, -0.5423842382927654, 
    0.4519868652439711}, {-0.06234543329511677, -0.5611088996560509, 
    0.49876346636093416`}, {-0.055613276850190324`, -0.5561327685019032, 
    0.48816098568500393`}, {-0.07810031047988147, -0.5406944571684102, 
    0.45057871430700847`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06234543329511677, -0.5611088996560509, 
    0.49876346636093416`}, {-0.03227981539684726, -0.5810366771432506, 
    0.5487568617464034}, {-0.03179444453423547, -0.5723000016162385, 
    0.5277877792683088}, {-0.055613276850190324`, -0.5561327685019032, 
    0.48816098568500393`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.03227981539684726, -0.5810366771432506, 
    0.5487568617464034}, {0., -0.6020420732135735, 
    0.6020420732135735}, {-0.006545673176541602, -0.5891105858887445, 
    0.5694735663591197}, {-0.03179444453423547, -0.5723000016162385, 
    0.5277877792683088}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.6020420732135735, 0.6020420732135735}, {
    0., -0.5583263670978953, 
    0.49629010408701807`}, {-0.006154011462866676, -0.5538610316580012, 
    0.4861669055664677}, {-0.006545673176541602, -0.5891105858887445, 
    0.5694735663591197}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.5583263670978953, 0.49629010408701807`}, {
    0., -0.5116766815928779, 
    0.3979707523500161}, {-0.005739686383923255, -0.5165717745530933, 
    0.40751773325855134`}, {-0.006154011462866676, -0.5538610316580012, 
    0.4861669055664677}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.5116766815928779, 0.3979707523500161}, {
    0., -0.45998714286871445`, 
    0.3066580952458096}, {-0.005290785729710824, -0.47617071567397445`, 
    0.33331950097178215`}, {-0.005739686383923255, -0.5165717745530933, 
    0.40751773325855134`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.6020420732135735, 
    0.6020420732135735}, {-0.06715883546475819, -0.6044295191828238, 
    0.6044295191828238}, {-0.0734128220308756, -0.6006503620708005, 
    0.5939764691589027}, {-0.01993158821950005, -0.597947646585002, 
    0.5913037838451686}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06715883546475819, -0.6044295191828238, 
    0.6044295191828238}, {-0.13589068132812965`, -0.6115080659765835, 
    0.6115080659765835}, {-0.12801278465860869`, -0.6063763483828833, 
    0.5996388334008513}, {-0.0734128220308756, -0.6006503620708005, 
    0.5939764691589027}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.13589068132812965`, -0.6115080659765835, 
    0.6115080659765835}, {-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.1845016009799007, -0.615005336599669, 
    0.6081719439707838}, {-0.12801278465860869`, -0.6063763483828833, 
    0.5996388334008513}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.16555673570625662`, -0.5960042485425239, 
    0.5628929014012725}, {-0.15171241243773156`, -0.5936572660606888, 
    0.560676306835095}, {-0.1845016009799007, -0.615005336599669, 
    0.6081719439707838}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.16555673570625662`, -0.5960042485425239, 
    0.5628929014012725}, {-0.12650407746706638`, -0.5692683486017988, 
    0.5060163098682655}, {-0.12086351903845649`, -0.572511405971636, 
    0.5152602653744724}, {-0.15171241243773156`, -0.5936572660606888, 
    0.560676306835095}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.12650407746706638`, -0.5692683486017988, 
    0.5060163098682655}, {-0.09039737304879422, -0.5423842382927654, 
    0.4519868652439711}, {-0.09188927555772322, -0.5513356533463394, 
    0.4716982811963126}, {-0.12086351903845649`, -0.572511405971636, 
    0.5152602653744724}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09039737304879422, -0.5423842382927654, 
    0.4519868652439711}, {-0.06234543329511677, -0.5611088996560509, 
    0.49876346636093416`}, {-0.06918894281144454, -0.5660913502754553, 
    0.5094822152479098}, {-0.09188927555772322, -0.5513356533463394, 
    0.4716982811963126}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06234543329511677, -0.5611088996560509, 
    0.49876346636093416`}, {-0.03227981539684726, -0.5810366771432506, 
    0.5487568617464034}, {-0.04523945407613895, -0.5816501238360723, 
    0.5493362280674016}, {-0.06918894281144454, -0.5660913502754553, 
    0.5094822152479098}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.03227981539684726, -0.5810366771432506, 
    0.5487568617464034}, {0., -0.6020420732135735, 
    0.6020420732135735}, {-0.01993158821950005, -0.597947646585002, 
    0.5913037838451686}, {-0.04523945407613895, -0.5816501238360723, 
    0.5493362280674016}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.32497414755462956`, -0.5570985386650793, 
    0.3713990257767195}, {-0.30930754461094684`, -0.5567535802997043, 
    0.3835413553175741}, {-0.35717979235010267`, -0.5740389519912366, 
    0.39544905581618517`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.32497414755462956`, -0.5570985386650793, 
    0.3713990257767195}, {-0.26775615427580557`, -0.5355123085516112, 
    0.35700820570107417`}, {-0.26413196393268323`, -0.540269926225943, 
    0.37218594917787184`}, {-0.30930754461094684`, -0.5567535802997043, 
    0.3835413553175741}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.26775615427580557`, -0.5355123085516112, 
    0.35700820570107417`}, {-0.21472944721406304`, -0.5153506733137513, 
    0.34356711554250086`}, {-0.22157332212441513`, -0.5247789208209833, 
    0.3615143676766774}, {-0.26413196393268323`, -0.540269926225943, 
    0.37218594917787184`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21472944721406304`, -0.5153506733137513, 
    0.34356711554250086`}, {-0.1657318525960958, -0.4971955577882874, 
    0.3314637051921916}, {-0.18153126854126964`, -0.510556692772321, 
    0.35171683279870997`}, {-0.22157332212441513`, -0.5247789208209833, 
    0.3615143676766774}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1657318525960958, -0.4971955577882874, 
    0.3314637051921916}, {-0.176735752448586, -0.530207257345758, 
    0.39765544300931854`}, {-0.1906578017409655, -0.5362250673964656, 
    0.4051478286995518}, {-0.18153126854126964`, -0.510556692772321, 
    0.35171683279870997`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.176735752448586, -0.530207257345758, 
    0.39765544300931854`}, {-0.18726648266764945`, -0.5617994480029483, 
    0.4681662066691236}, {-0.19950538654437358`, -0.5611088996560508, 
    0.461356206383864}, {-0.1906578017409655, -0.5362250673964656, 
    0.4051478286995518}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.18726648266764945`, -0.5617994480029483, 
    0.4681662066691236}, {-0.19749453248903248`, -0.5924835974670974, 
    0.5431099643448393}, {-0.20816159484924335`, -0.5854544855134971, 
    0.5204039871231084}, {-0.19950538654437358`, -0.5611088996560508, 
    0.461356206383864}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.19749453248903248`, -0.5924835974670974, 
    0.5431099643448393}, {-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.21675802958570295`, -0.6096319582097897, 
    0.5825372045115768}, {-0.20816159484924335`, -0.5854544855134971, 
    0.5204039871231084}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.251969546341623, -0.6047269112198952, 
    0.5543330019515705}, {-0.2515845081118029, -0.5958580455279544, 
    0.5296515960248482}, {-0.21675802958570295`, -0.6096319582097897, 
    0.5825372045115768}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.251969546341623, -0.6047269112198952, 
    0.5543330019515705}, {-0.29554773118396116`, -0.5910954623679224, 
    0.4925795519732687}, {-0.2860742984158683, -0.585151974032458, 
    0.4811249564266876}, {-0.2515845081118029, -0.5958580455279544, 
    0.5296515960248482}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.29554773118396116`, -0.5910954623679224, 
    0.4925795519732687}, {-0.3398683238140667, -0.5826314122526858, 
    0.43697355918951436`}, {-0.32099644718097237`, -0.5777936049257504, 
    0.4365551681661225}, {-0.2860742984158683, -0.585151974032458, 
    0.4811249564266876}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3398683238140667, -0.5826314122526858, 
    0.43697355918951436`}, {-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.35717979235010267`, -0.5740389519912366, 
    0.39544905581618517`}, {-0.32099644718097237`, -0.5777936049257504, 
    0.4365551681661225}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.3550779693653198, -0.5810366771432506, 
    0.41963760015901436`}, {-0.3591582529035913, -0.5877135047513313, 
    0.4375200535371022}, {-0.38422691935919384`, -0.5861088600394483, 
    0.41027620202761383`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3550779693653198, -0.5810366771432506, 
    0.41963760015901436`}, {-0.32491619395345206`, -0.5848491491162138, 
    0.45488267153483286`}, {-0.33484194093648584`, -0.5908975428290927, 
    0.46615250600961755`}, {-0.3591582529035913, -0.5877135047513313, 
    0.4375200535371022}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.32491619395345206`, -0.5848491491162138, 
    0.45488267153483286`}, {-0.2955477311839612, -0.5910954623679224, 
    0.4925795519732687}, {-0.31104298811316416`, -0.595614232557123, 
    0.49634519379760245`}, {-0.33484194093648584`, -0.5908975428290927, 
    0.46615250600961755`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2955477311839612, -0.5910954623679224, 
    0.4925795519732687}, {-0.34487850812687415`, -0.6207813146283735, 
    0.5518056130029987}, {-0.3510197768048997, -0.6194466649498231, 
    0.5437365170115114}, {-0.31104298811316416`, -0.595614232557123, 
    0.49634519379760245`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.34487850812687415`, -0.6207813146283735, 
    0.5518056130029987}, {-0.39802947182437354`, -0.6513209538944295, 
    0.6151364564558499}, {-0.3934133114373311, -0.643767236897451, 
    0.593696451805427}, {-0.3510197768048997, -0.6194466649498231, 
    0.5437365170115114}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.39802947182437354`, -0.6513209538944295, 
    0.6151364564558499}, {-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.43885530547477725`, -0.6694402964869484, 
    0.6471256199373834}, {-0.3934133114373311, -0.643767236897451, 
    0.593696451805427}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.4304670307029078, -0.6457005460543618, 
    0.5739560409372104}, {-0.41919337488646585`, -0.639447521013253, 
    0.5612928240005222}, {-0.43885530547477725`, -0.6694402964869484, 
    0.6471256199373834}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4304670307029078, -0.6457005460543618, 
    0.5739560409372104}, {-0.40767204398438894`, -0.6115080659765835, 
    0.4756173846484537}, {-0.4012148338270782, -0.6120226278718142, 
    0.4828178508766534}, {-0.41919337488646585`, -0.639447521013253, 
    0.5612928240005222}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.40767204398438894`, -0.6115080659765835, 
    0.4756173846484537}, {-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.38422691935919384`, -0.5861088600394483, 
    0.41027620202761383`}, {-0.4012148338270782, -0.6120226278718142, 
    0.4828178508766534}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.3662276185282054, -0.6592097133507697, 
    0.6592097133507697}, {-0.35549008961826795`, -0.6529409809315125, 
    0.6456860811433847}, {-0.4257232357078877, -0.6721945826966649, 
    0.6647257540000353}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3662276185282054, -0.6592097133507697, 
    0.6592097133507697}, {-0.2839786944782409, -0.6389520625760421, 
    0.6389520625760421}, {-0.2900719574991448, -0.6367433213395861, 
    0.629668395546924}, {-0.35549008961826795`, -0.6529409809315125, 
    0.6456860811433847}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2839786944782409, -0.6389520625760421, 
    0.6389520625760421}, {-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.22854498053961364`, -0.6233044923807646, 
    0.6163788869098672}, {-0.2900719574991448, -0.6367433213395861, 
    0.629668395546924}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.23735305516717142`, -0.6103364275727265, 
    0.5764288482631306}, {-0.25229999183570073`, -0.6137026828435964, 
    0.5796080893522855}, {-0.22854498053961364`, -0.6233044923807646, 
    0.6163788869098672}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.23735305516717142`, -0.6103364275727265, 
    0.5764288482631306}, {-0.2665063311720162, -0.5996392451370365, 
    0.5330126623440324}, {-0.2758060279446175, -0.605427866219892, 
    0.5448850795979028}, {-0.25229999183570073`, -0.6137026828435964, 
    0.5796080893522855}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2665063311720162, -0.5996392451370365, 
    0.5330126623440324}, {-0.2955477311839612, -0.5910954623679224, 
    0.4925795519732687}, {-0.29926426963948155`, -0.5985285392789631, 
    0.5120744169386685}, {-0.2758060279446175, -0.605427866219892, 
    0.5448850795979028}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2955477311839612, -0.5910954623679224, 
    0.4925795519732687}, {-0.34487850812687415`, -0.6207813146283735, 
    0.5518056130029987}, {-0.33875590314851456`, -0.6222047200687002, 
    0.5599842480618302}, {-0.29926426963948155`, -0.5985285392789631, 
    0.5120744169386685}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.34487850812687415`, -0.6207813146283735, 
    0.5518056130029987}, {-0.39802947182437354`, -0.6513209538944295, 
    0.6151364564558499}, {-0.3806959241330279, -0.6464647768296701, 
    0.6105500670057994}, {-0.33875590314851456`, -0.6222047200687002, 
    0.5599842480618302}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.39802947182437354`, -0.6513209538944295, 
    0.6151364564558499}, {-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.4257232357078877, -0.6721945826966649, 
    0.6647257540000353}, {-0.3806959241330279, -0.6464647768296701, 
    0.6105500670057994}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.32497414755462956`, -0.5570985386650793, 
    0.3713990257767195}, {0.30930754461094684`, -0.5567535802997043, 
    0.3835413553175741}, {0.35717979235010267`, -0.5740389519912366, 
    0.39544905581618517`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.32497414755462956`, -0.5570985386650793, 
    0.3713990257767195}, {0.26775615427580557`, -0.5355123085516112, 
    0.35700820570107417`}, {0.26413196393268323`, -0.540269926225943, 
    0.37218594917787184`}, {0.30930754461094684`, -0.5567535802997043, 
    0.3835413553175741}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.26775615427580557`, -0.5355123085516112, 
    0.35700820570107417`}, {0.21472944721406304`, -0.5153506733137513, 
    0.34356711554250086`}, {0.22157332212441513`, -0.5247789208209833, 
    0.3615143676766774}, {0.26413196393268323`, -0.540269926225943, 
    0.37218594917787184`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21472944721406304`, -0.5153506733137513, 
    0.34356711554250086`}, {0.1657318525960958, -0.4971955577882874, 
    0.3314637051921916}, {0.18153126854126964`, -0.510556692772321, 
    0.35171683279870997`}, {0.22157332212441513`, -0.5247789208209833, 
    0.3615143676766774}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1657318525960958, -0.4971955577882874, 
    0.3314637051921916}, {0.176735752448586, -0.530207257345758, 
    0.39765544300931854`}, {0.1906578017409655, -0.5362250673964656, 
    0.4051478286995518}, {0.18153126854126964`, -0.510556692772321, 
    0.35171683279870997`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.176735752448586, -0.530207257345758, 
    0.39765544300931854`}, {0.18726648266764945`, -0.5617994480029483, 
    0.4681662066691236}, {0.19950538654437358`, -0.5611088996560508, 
    0.461356206383864}, {0.1906578017409655, -0.5362250673964656, 
    0.4051478286995518}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.18726648266764945`, -0.5617994480029483, 
    0.4681662066691236}, {0.19749453248903248`, -0.5924835974670974, 
    0.5431099643448393}, {0.20816159484924335`, -0.5854544855134971, 
    0.5204039871231084}, {0.19950538654437358`, -0.5611088996560508, 
    0.461356206383864}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.19749453248903248`, -0.5924835974670974, 
    0.5431099643448393}, {0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.21675802958570295`, -0.6096319582097897, 
    0.5825372045115768}, {0.20816159484924335`, -0.5854544855134971, 
    0.5204039871231084}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.251969546341623, -0.6047269112198952, 
    0.5543330019515705}, {0.2515845081118029, -0.5958580455279544, 
    0.5296515960248482}, {0.21675802958570295`, -0.6096319582097897, 
    0.5825372045115768}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.251969546341623, -0.6047269112198952, 
    0.5543330019515705}, {0.29554773118396116`, -0.5910954623679224, 
    0.4925795519732687}, {0.2860742984158683, -0.585151974032458, 
    0.4811249564266876}, {0.2515845081118029, -0.5958580455279544, 
    0.5296515960248482}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.29554773118396116`, -0.5910954623679224, 
    0.4925795519732687}, {0.3398683238140667, -0.5826314122526858, 
    0.43697355918951436`}, {0.32099644718097237`, -0.5777936049257504, 
    0.4365551681661225}, {0.2860742984158683, -0.585151974032458, 
    0.4811249564266876}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3398683238140667, -0.5826314122526858, 
    0.43697355918951436`}, {0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.35717979235010267`, -0.5740389519912366, 
    0.39544905581618517`}, {0.32099644718097237`, -0.5777936049257504, 
    0.4365551681661225}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.3550779693653198, -0.5810366771432506, 
    0.41963760015901436`}, {0.3591582529035913, -0.5877135047513313, 
    0.4375200535371022}, {0.38422691935919384`, -0.5861088600394483, 
    0.41027620202761383`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3550779693653198, -0.5810366771432506, 
    0.41963760015901436`}, {0.32491619395345206`, -0.5848491491162138, 
    0.45488267153483286`}, {0.33484194093648584`, -0.5908975428290927, 
    0.46615250600961755`}, {0.3591582529035913, -0.5877135047513313, 
    0.4375200535371022}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.32491619395345206`, -0.5848491491162138, 
    0.45488267153483286`}, {0.2955477311839612, -0.5910954623679224, 
    0.4925795519732687}, {0.31104298811316416`, -0.595614232557123, 
    0.49634519379760245`}, {0.33484194093648584`, -0.5908975428290927, 
    0.46615250600961755`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2955477311839612, -0.5910954623679224, 
    0.4925795519732687}, {0.34487850812687415`, -0.6207813146283735, 
    0.5518056130029987}, {0.3510197768048997, -0.6194466649498231, 
    0.5437365170115114}, {0.31104298811316416`, -0.595614232557123, 
    0.49634519379760245`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.34487850812687415`, -0.6207813146283735, 
    0.5518056130029987}, {0.39802947182437354`, -0.6513209538944295, 
    0.6151364564558499}, {0.3934133114373311, -0.643767236897451, 
    0.593696451805427}, {0.3510197768048997, -0.6194466649498231, 
    0.5437365170115114}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.39802947182437354`, -0.6513209538944295, 
    0.6151364564558499}, {0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.43885530547477725`, -0.6694402964869484, 
    0.6471256199373834}, {0.3934133114373311, -0.643767236897451, 
    0.593696451805427}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.4304670307029078, -0.6457005460543618, 
    0.5739560409372104}, {0.41919337488646585`, -0.639447521013253, 
    0.5612928240005222}, {0.43885530547477725`, -0.6694402964869484, 
    0.6471256199373834}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4304670307029078, -0.6457005460543618, 
    0.5739560409372104}, {0.40767204398438894`, -0.6115080659765835, 
    0.4756173846484537}, {0.4012148338270782, -0.6120226278718142, 
    0.4828178508766534}, {0.41919337488646585`, -0.639447521013253, 
    0.5612928240005222}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.40767204398438894`, -0.6115080659765835, 
    0.4756173846484537}, {0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.38422691935919384`, -0.5861088600394483, 
    0.41027620202761383`}, {0.4012148338270782, -0.6120226278718142, 
    0.4828178508766534}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.3662276185282054, -0.6592097133507697, 
    0.6592097133507697}, {0.35549008961826795`, -0.6529409809315125, 
    0.6456860811433847}, {0.4257232357078877, -0.6721945826966649, 
    0.6647257540000353}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3662276185282054, -0.6592097133507697, 
    0.6592097133507697}, {0.2839786944782409, -0.6389520625760421, 
    0.6389520625760421}, {0.2900719574991448, -0.6367433213395861, 
    0.629668395546924}, {0.35549008961826795`, -0.6529409809315125, 
    0.6456860811433847}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2839786944782409, -0.6389520625760421, 
    0.6389520625760421}, {0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.22854498053961364`, -0.6233044923807646, 
    0.6163788869098672}, {0.2900719574991448, -0.6367433213395861, 
    0.629668395546924}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.23735305516717142`, -0.6103364275727265, 
    0.5764288482631306}, {0.25229999183570073`, -0.6137026828435964, 
    0.5796080893522855}, {0.22854498053961364`, -0.6233044923807646, 
    0.6163788869098672}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.23735305516717142`, -0.6103364275727265, 
    0.5764288482631306}, {0.2665063311720162, -0.5996392451370365, 
    0.5330126623440324}, {0.2758060279446175, -0.605427866219892, 
    0.5448850795979028}, {0.25229999183570073`, -0.6137026828435964, 
    0.5796080893522855}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2665063311720162, -0.5996392451370365, 
    0.5330126623440324}, {0.2955477311839612, -0.5910954623679224, 
    0.4925795519732687}, {0.29926426963948155`, -0.5985285392789631, 
    0.5120744169386685}, {0.2758060279446175, -0.605427866219892, 
    0.5448850795979028}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2955477311839612, -0.5910954623679224, 
    0.4925795519732687}, {0.34487850812687415`, -0.6207813146283735, 
    0.5518056130029987}, {0.33875590314851456`, -0.6222047200687002, 
    0.5599842480618302}, {0.29926426963948155`, -0.5985285392789631, 
    0.5120744169386685}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.34487850812687415`, -0.6207813146283735, 
    0.5518056130029987}, {0.39802947182437354`, -0.6513209538944295, 
    0.6151364564558499}, {0.3806959241330279, -0.6464647768296701, 
    0.6105500670057994}, {0.33875590314851456`, -0.6222047200687002, 
    0.5599842480618302}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.39802947182437354`, -0.6513209538944295, 
    0.6151364564558499}, {0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.4257232357078877, -0.6721945826966649, 
    0.6647257540000353}, {0.3806959241330279, -0.6464647768296701, 
    0.6105500670057994}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.45998714286871445`, 0.3066580952458096}, {
    0.038544848628222717`, -0.46253818353867265`, 0.30835878902578173`}, {
    0.052786379282336135`, -0.47507741354102534`, 0.3272755515504841}, {
    0.020955630116874954`, -0.47150167762968676`, 0.324812266811562}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.038544848628222717`, -0.46253818353867265`, 
    0.30835878902578173`}, {0.07833195316248512, -0.46999171897491077`, 
    0.3133278126499405}, {0.08560802621248467, -0.48154514744522636`, 
    0.33173110157337815`}, {0.052786379282336135`, -0.47507741354102534`, 
    0.3272755515504841}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07833195316248512, -0.46999171897491077`, 
    0.3133278126499405}, {0.12044994043743079`, -0.4817997617497233, 
    0.32119984116648215`}, {0.11992963743797559`, -0.4906212440644457, 
    0.3379835236888404}, {0.08560802621248467, -0.48154514744522636`, 
    0.33173110157337815`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.12044994043743079`, -0.4817997617497233, 
    0.32119984116648215`}, {0.1657318525960958, -0.4971955577882874, 
    0.3314637051921916}, {0.1561613637329016, -0.5019472405700409, 
    0.3457858768371393}, {0.11992963743797559`, -0.4906212440644457, 
    0.3379835236888404}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1657318525960958, -0.4971955577882874, 
    0.3314637051921916}, {0.176735752448586, -0.530207257345758, 
    0.39765544300931854`}, {0.16447360317195706`, -0.5286651530527192, 
    0.3994358934176101}, {0.1561613637329016, -0.5019472405700409, 
    0.3457858768371393}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.176735752448586, -0.530207257345758, 
    0.39765544300931854`}, {0.18726648266764945`, -0.5617994480029483, 
    0.4681662066691236}, {0.17247195529467113`, -0.5543741420185859, 
    0.4558187389930595}, {0.16447360317195706`, -0.5286651530527192, 
    0.3994358934176101}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.18726648266764945`, -0.5617994480029483, 
    0.4681662066691236}, {0.19749453248903248`, -0.5924835974670974, 
    0.5431099643448393}, {0.18023995030369647`, -0.5793426974047388, 
    0.5149712865819899}, {0.17247195529467113`, -0.5543741420185859, 
    0.4558187389930595}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.19749453248903248`, -0.5924835974670974, 
    0.5431099643448393}, {0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.18789655708653166`, -0.6039532192067091, 
    0.577110853908633}, {0.18023995030369647`, -0.5793426974047388, 
    0.5149712865819899}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.14565785306317142`, -0.5826314122526858, 
    0.5340787945649619}, {0.13970138965108453`, -0.571505684936255, 
    0.508005053276671}, {0.18789655708653166`, -0.6039532192067091, 
    0.577110853908633}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.14565785306317142`, -0.5826314122526858, 
    0.5340787945649619}, {0.09039737304879422, -0.5423842382927654, 
    0.4519868652439711}, {0.09578808133406011, -0.5388079575040883, 
    0.4430198761700281}, {0.13970138965108453`, -0.571505684936255, 
    0.508005053276671}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.09039737304879422, -0.5423842382927654, 
    0.4519868652439711}, {0.041781498251368454`, -0.5013779790164213, 
    0.37603348426231603`}, {0.05615961056021798, -0.5054364950419619, 
    0.38188535180948235`}, {0.09578808133406011, -0.5388079575040883, 
    0.4430198761700281}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.041781498251368454`, -0.5013779790164213, 
    0.37603348426231603`}, {0., -0.45998714286871445`, 0.3066580952458096}, {
    0.020955630116874954`, -0.47150167762968676`, 0.324812266811562}, {
    0.05615961056021798, -0.5054364950419619, 0.38188535180948235`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.45998714286871445`, 0.3066580952458096}, {
    0.02708690739129757, -0.4875643330433564, 0.3521297960868685}, {
    0.027651165009234, -0.4977209701662121, 0.37052561112373567`}, {
    0.005290785729710824, -0.47617071567397445`, 0.33331950097178215`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.02708690739129757, -0.4875643330433564, 
    0.3521297960868685}, {0.057237380507313335`, -0.5151364245658201, 
    0.4006616635511933}, {0.05192776126127516, -0.5192776126127516, 
    0.4096523388389484}, {0.027651165009234, -0.4977209701662121, 
    0.37052561112373567`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.057237380507313335`, -0.5151364245658201, 
    0.4006616635511933}, {0.09039737304879422, -0.5423842382927654, 
    0.4519868652439711}, {0.07810031047988147, -0.5406944571684102, 
    0.45057871430700847`}, {0.05192776126127516, -0.5192776126127516, 
    0.4096523388389484}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.09039737304879422, -0.5423842382927654, 
    0.4519868652439711}, {0.06234543329511677, -0.5611088996560509, 
    0.49876346636093416`}, {0.055613276850190324`, -0.5561327685019032, 
    0.48816098568500393`}, {0.07810031047988147, -0.5406944571684102, 
    0.45057871430700847`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.06234543329511677, -0.5611088996560509, 
    0.49876346636093416`}, {0.03227981539684726, -0.5810366771432506, 
    0.5487568617464034}, {0.03179444453423547, -0.5723000016162385, 
    0.5277877792683088}, {0.055613276850190324`, -0.5561327685019032, 
    0.48816098568500393`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.03227981539684726, -0.5810366771432506, 
    0.5487568617464034}, {0., -0.6020420732135735, 0.6020420732135735}, {
    0.006545673176541602, -0.5891105858887445, 0.5694735663591197}, {
    0.03179444453423547, -0.5723000016162385, 0.5277877792683088}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.6020420732135735, 0.6020420732135735}, {
    0., -0.5583263670978953, 0.49629010408701807`}, {
    0.006154011462866676, -0.5538610316580012, 0.4861669055664677}, {
    0.006545673176541602, -0.5891105858887445, 0.5694735663591197}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.5583263670978953, 0.49629010408701807`}, {
    0., -0.5116766815928779, 0.3979707523500161}, {
    0.005739686383923255, -0.5165717745530933, 0.40751773325855134`}, {
    0.006154011462866676, -0.5538610316580012, 0.4861669055664677}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.5116766815928779, 0.3979707523500161}, {
    0., -0.45998714286871445`, 0.3066580952458096}, {
    0.005290785729710824, -0.47617071567397445`, 0.33331950097178215`}, {
    0.005739686383923255, -0.5165717745530933, 0.40751773325855134`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.6020420732135735, 0.6020420732135735}, {
    0.06715883546475819, -0.6044295191828238, 0.6044295191828238}, {
    0.0734128220308756, -0.6006503620708005, 0.5939764691589027}, {
    0.01993158821950005, -0.597947646585002, 0.5913037838451686}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.06715883546475819, -0.6044295191828238, 
    0.6044295191828238}, {0.13589068132812965`, -0.6115080659765835, 
    0.6115080659765835}, {0.12801278465860869`, -0.6063763483828833, 
    0.5996388334008513}, {0.0734128220308756, -0.6006503620708005, 
    0.5939764691589027}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.13589068132812965`, -0.6115080659765835, 
    0.6115080659765835}, {0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.1845016009799007, -0.615005336599669, 
    0.6081719439707838}, {0.12801278465860869`, -0.6063763483828833, 
    0.5996388334008513}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.16555673570625662`, -0.5960042485425239, 
    0.5628929014012725}, {0.15171241243773156`, -0.5936572660606888, 
    0.560676306835095}, {0.1845016009799007, -0.615005336599669, 
    0.6081719439707838}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.16555673570625662`, -0.5960042485425239, 
    0.5628929014012725}, {0.12650407746706638`, -0.5692683486017988, 
    0.5060163098682655}, {0.12086351903845649`, -0.572511405971636, 
    0.5152602653744724}, {0.15171241243773156`, -0.5936572660606888, 
    0.560676306835095}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.12650407746706638`, -0.5692683486017988, 
    0.5060163098682655}, {0.09039737304879422, -0.5423842382927654, 
    0.4519868652439711}, {0.09188927555772322, -0.5513356533463394, 
    0.4716982811963126}, {0.12086351903845649`, -0.572511405971636, 
    0.5152602653744724}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.09039737304879422, -0.5423842382927654, 
    0.4519868652439711}, {0.06234543329511677, -0.5611088996560509, 
    0.49876346636093416`}, {0.06918894281144454, -0.5660913502754553, 
    0.5094822152479098}, {0.09188927555772322, -0.5513356533463394, 
    0.4716982811963126}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.06234543329511677, -0.5611088996560509, 
    0.49876346636093416`}, {0.03227981539684726, -0.5810366771432506, 
    0.5487568617464034}, {0.04523945407613895, -0.5816501238360723, 
    0.5493362280674016}, {0.06918894281144454, -0.5660913502754553, 
    0.5094822152479098}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.03227981539684726, -0.5810366771432506, 
    0.5487568617464034}, {0., -0.6020420732135735, 0.6020420732135735}, {
    0.01993158821950005, -0.597947646585002, 0.5913037838451686}, {
    0.04523945407613895, -0.5816501238360723, 0.5493362280674016}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.40767204398438894`, -0.6115080659765835, 
    0.4756173846484537}, {0.4185959624434206, -0.6176006003263583, 
    0.48721825136857155`}, {0.4013008374837915, -0.5920832028449382, 
    0.41445824199145676`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.40767204398438894`, -0.6115080659765835, 
    0.4756173846484537}, {0.4304670307029078, -0.6457005460543618, 
    0.5739560409372104}, {0.43706252979527566`, -0.6448463554356526, 
    0.5660318008824062}, {0.4185959624434206, -0.6176006003263583, 
    0.48721825136857155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4304670307029078, -0.6457005460543618, 
    0.5739560409372104}, {0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.4574749594975597, -0.6749630549963996, 
    0.6524642864965196}, {0.43706252979527566`, -0.6448463554356526, 
    0.5660318008824062}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.49015740221892146`, -0.6786794799954298, 
    0.6409750644401281}, {0.484544369547659, -0.670907588604451, 
    0.6187258872685492}, {0.4574749594975597, -0.6749630549963996, 
    0.6524642864965196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49015740221892146`, -0.6786794799954298, 
    0.6409750644401281}, {0.5251512437069583, -0.6751944561946608, 
    0.6001728499508097}, {0.5123956646927323, -0.6683421713383466, 
    0.5866559059525488}, {0.484544369547659, -0.670907588604451, 
    0.6187258872685492}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5251512437069583, -0.6751944561946608, 
    0.6001728499508097}, {0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {0.5412105935744802, -0.6672459372836057, 
    0.5560382810696715}, {0.5123956646927323, -0.6683421713383466, 
    0.5866559059525488}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {0.49871361404698694`, -0.6412032180604118, 
    0.49871361404698694`}, {0.4916236345631913, -0.641248218995467, 
    0.5058735949853128}, {0.5412105935744802, -0.6672459372836057, 
    0.5560382810696715}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49871361404698694`, -0.6412032180604118, 
    0.49871361404698694`}, {0.4407985310247471, -0.6103364275727268, 
    0.4407985310247471}, {0.4452427310725714, -0.6164899353312527, 
    0.4589425074132659}, {0.4916236345631913, -0.641248218995467, 
    0.5058735949853128}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4407985310247471, -0.6103364275727268, 
    0.4407985310247471}, {0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.4013008374837915, -0.5920832028449382, 
    0.41445824199145676`}, {0.4452427310725714, -0.6164899353312527, 
    0.4589425074132659}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.49015740221892146`, -0.6786794799954298, 
    0.6409750644401281}, {0.5098591242716168, -0.6848853908126196, 
    0.6468362024341406}, {0.48235791827893554`, -0.6890827403984794, 
    0.6814262655051629}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49015740221892146`, -0.6786794799954298, 
    0.6409750644401281}, {0.5251512437069583, -0.6751944561946608, 
    0.6001728499508097}, {0.5382118349147983, -0.68224035411735, 
    0.614016318705615}, {0.5098591242716168, -0.6848853908126196, 
    0.6468362024341406}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5251512437069583, -0.6751944561946608, 
    0.6001728499508097}, {0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {0.5675936973120723, -0.6811124367744867, 
    0.5827295292403942}, {0.5382118349147983, -0.68224035411735, 
    0.614016318705615}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {0.6327645227143793, -0.7118600880536767, 
    0.6327645227143793}, {0.6249011299737146, -0.7119126797168901, 
    0.6407214117452011}, {0.5675936973120723, -0.6811124367744867, 
    0.5827295292403942}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6327645227143793, -0.7118600880536767, 
    0.6327645227143793}, {0.7198653019554957, -0.7622103197175837, 
    0.7198653019554957}, {0.6920462242465636, -0.7504115684601292, 
    0.7087220368790109}, {0.6249011299737146, -0.7119126797168901, 
    0.6407214117452011}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7198653019554957, -0.7622103197175837, 
    0.7198653019554957}, {0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {0.7834402264884363, -0.8104554067121754, 
    0.8014503466375957}, {0.6920462242465636, -0.7504115684601292, 
    0.7087220368790109}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {0.6791732466493353, -0.7640699024805022, 
    0.7640699024805022}, {0.6601152491051621, -0.7520300306261339, 
    0.7436741413969546}, {0.7834402264884363, -0.8104554067121754, 
    0.8014503466375957}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6791732466493353, -0.7640699024805022, 
    0.7640699024805022}, {0.5578135523930144, -0.7171888530767329, 
    0.7171888530767329}, {0.5649747532204069, -0.716165180138544, 
    0.7082077892481158}, {0.6601152491051621, -0.7520300306261339, 
    0.7436741413969546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5578135523930144, -0.7171888530767329, 
    0.7171888530767329}, {0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.48235791827893554`, -0.6890827403984794, 
    0.6814262655051629}, {0.5649747532204069, -0.716165180138544, 
    0.7082077892481158}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 
    0.}, {-0.005171109167864868, -0.07756663751797302, \
-0.005171109167864868}, {-0.013921129715104607`, -0.11600941429253843`, \
-0.008765155746547347}, {-0.0038620463024166113`, -0.05793069453624921, \
-0.0012873487674722039`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.005171109167864868, -0.07756663751797302, \
-0.005171109167864868}, {-0.02041142073737483, -0.15308565553031123`, \
-0.02041142073737483}, {-0.030232164988298865`, -0.17441633647095503`, \
-0.02248032781181198}, {-0.013921129715104607`, -0.11600941429253843`, \
-0.008765155746547347}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.02041142073737483, -0.15308565553031123`, \
-0.02041142073737483}, {-0.04495902221896904, -0.22479511109484523`, \
-0.04495902221896904}, {-0.052280949450900525`, -0.23065124757750236`, \
-0.04202978289190042}, {-0.030232164988298865`, -0.17441633647095503`, \
-0.02248032781181198}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.04495902221896904, -0.22479511109484523`, \
-0.04495902221896904}, {-0.07771364461602205, -0.2914261673100827, \
-0.07771364461602205}, {-0.07946169892532537, -0.2837917818761621, \
-0.0668487308419404}, {-0.052280949450900525`, -0.23065124757750236`, \
-0.04202978289190042}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07771364461602205, -0.2914261673100827, \
-0.07771364461602205}, {-0.11743040006038394`, -0.35229120018115184`, \
-0.11743040006038394`}, {-0.11112456154944492`, -0.3333736846483348, \
-0.09630795334285228}, {-0.07946169892532537, -0.2837917818761621, \
-0.0668487308419404}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, -0.35229120018115184`, \
-0.11743040006038394`}, {-0.14319799741026004`, -0.3579949935256501, \
-0.09546533160684004}, {-0.131748866608086, -0.3407298274347052, \
-0.08026080379573056}, {-0.11112456154944492`, -0.3333736846483348, \
-0.09630795334285228}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.14319799741026004`, -0.3579949935256501, \
-0.09546533160684004}, {-0.1746044040148139, -0.37415229431745833`, \
-0.07483045886349166}, {-0.15631133790709126`, -0.3552530406979347, \
-0.0647349985271792}, {-0.131748866608086, -0.3407298274347052, \
-0.08026080379573056}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1746044040148139, -0.37415229431745833`, \
-0.07483045886349166}, {-0.21246554927450964`, -0.3983729048897056, \
-0.05311638731862741}, {-0.18521381542885962`, -0.3754334096530939, \
-0.04838919502195432}, {-0.15631133790709126`, -0.3552530406979347, \
-0.0647349985271792}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21246554927450964`, -0.3983729048897056, \
-0.05311638731862741}, {-0.2566895622918732, -0.42781593715312194`, \
-0.028521062476874796`}, {-0.21842728074316375`, -0.39956209892042155`, \
-0.030189136362876293`}, {-0.18521381542885962`, -0.3754334096530939, \
-0.04838919502195432}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2566895622918732, -0.42781593715312194`, \
-0.028521062476874796`}, {-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.2556458063906103, -0.4260763439843505, -0.009468363199652228}, \
{-0.21842728074316375`, -0.39956209892042155`, -0.030189136362876293`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.20749339485230253`, -0.38905011534806727`, 
    0.}, {-0.18050915270650156`, -0.36589693116182753`, \
-0.008131042914707273}, {-0.2556458063906103, -0.4260763439843505, \
-0.009468363199652228}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20749339485230253`, -0.38905011534806727`, 
    0.}, {-0.1226952100911925, -0.30673802522798127`, 
    0.}, {-0.11533618865511652`, -0.2982832465218531, -0.006628516589374509}, \
{-0.18050915270650156`, -0.36589693116182753`, -0.008131042914707273}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1226952100911925, -0.30673802522798127`, 
    0.}, {-0.05675323239297665, -0.21282462147366246`, 
    0.}, {-0.06253826722971649, -0.22335095439184463`, \
-0.004963354542040988}, {-0.11533618865511652`, -0.2982832465218531, \
-0.006628516589374509}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.05675323239297665, -0.21282462147366246`, 
    0.}, {-0.014560811715990765`, -0.10920608786993075`, 
    0.}, {-0.0246522971021567, -0.142224790973981, -0.003160550910532909}, \
{-0.06253826722971649, -0.22335095439184463`, -0.004963354542040988}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.014560811715990765`, -0.10920608786993075`, 
    0.}, {0., 0., 
    0.}, {-0.0038620463024166113`, -0.05793069453624921, \
-0.0012873487674722039`}, {-0.0246522971021567, -0.142224790973981, \
-0.003160550910532909}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.3109670174603803, -0.4664505261905705, -0.06219340349207606}, \
{-0.2966525297708156, -0.4603228910236794, -0.07978930111077108}, \
{-0.29040472453203425`, -0.45062802082557046`, -0.03004186805503801}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3109670174603803, -0.4664505261905705, \
-0.06219340349207606}, {-0.3230789997575147, -0.48461849963627207`, \
-0.12923159990300587`}, {-0.3076477764089712, -0.4773844806346105, \
-0.1336676545776909}, {-0.2966525297708156, -0.4603228910236794, \
-0.07978930111077108}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3230789997575147, -0.48461849963627207`, \
-0.12923159990300587`}, {-0.3410246861288609, -0.5115370291932914, \
-0.20461481167731652`}, {-0.3222191897266516, -0.49999529440342494`, \
-0.19333151383599095`}, {-0.3076477764089712, -0.4773844806346105, \
-0.1336676545776909}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3410246861288609, -0.5115370291932914, \
-0.20461481167731652`}, {-0.36266749034792994`, -0.5440012355218949, \
-0.29013399227834397`}, {-0.3391849732407725, -0.5263215102011988, \
-0.25965194503259137`}, {-0.3222191897266516, -0.49999529440342494`, \
-0.19333151383599095`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.36266749034792994`, -0.5440012355218949, \
-0.29013399227834397`}, {-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.3576298790583277, -0.5549429157801637, \
-0.3329657494680982}, {-0.3391849732407725, -0.5263215102011988, \
-0.25965194503259137`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.3251055239962821, -0.5418425399938036, \
-0.3251055239962821}, {-0.30948310838038806`, -0.5235616495156941, \
-0.2862137017352461}, {-0.3576298790583277, -0.5549429157801637, \
-0.3329657494680982}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3251055239962821, -0.5418425399938036, \
-0.3251055239962821}, {-0.2673132787288769, -0.5012123976166442, \
-0.2673132787288769}, {-0.2635503764484113, -0.49007301405696324`, \
-0.24176935360143517`}, {-0.30948310838038806`, -0.5235616495156941, \
-0.2862137017352461}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2673132787288769, -0.5012123976166442, \
-0.2673132787288769}, {-0.21311308081691166`, -0.4566708874648107, \
-0.21311308081691166`}, {-0.2198966482103745, -0.4539150995168281, \
-0.19972264378740437`}, {-0.2635503764484113, -0.49007301405696324`, \
-0.24176935360143517`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21311308081691166`, -0.4566708874648107, \
-0.21311308081691166`}, {-0.1629042820200324, -0.40726070505008105`, \
-0.1629042820200324}, {-0.1787484353953863, -0.4146226594222878, \
-0.1603207616432846}, {-0.2198966482103745, -0.4539150995168281, \
-0.19972264378740437`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1629042820200324, -0.40726070505008105`, \
-0.1629042820200324}, {-0.11743040006038394`, -0.35229120018115184`, \
-0.11743040006038394`}, {-0.1404740306623331, -0.37184302234147004`, \
-0.12394767411382335`}, {-0.1787484353953863, -0.4146226594222878, \
-0.1603207616432846}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, -0.35229120018115184`, \
-0.11743040006038394`}, {-0.14319799741026004`, -0.3579949935256501, \
-0.09546533160684004}, {-0.16290833179688105`, -0.37788015107523965`, \
-0.10580644230106709`}, {-0.1404740306623331, -0.37184302234147004`, \
-0.12394767411382335`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.14319799741026004`, -0.3579949935256501, \
-0.09546533160684004}, {-0.1746044040148139, -0.37415229431745833`, \
-0.07483045886349166}, {-0.18889392224764073`, -0.38991864684146027`, \
-0.08838155995073098}, {-0.16290833179688105`, -0.37788015107523965`, \
-0.10580644230106709`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1746044040148139, -0.37415229431745833`, \
-0.07483045886349166}, {-0.21246554927450964`, -0.3983729048897056, \
-0.05311638731862741}, {-0.2188183987589316, -0.40689371670049274`, \
-0.07052824422808539}, {-0.18889392224764073`, -0.38991864684146027`, \
-0.08838155995073098}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21246554927450964`, -0.3983729048897056, \
-0.05311638731862741}, {-0.2566895622918732, -0.42781593715312194`, \
-0.028521062476874796`}, {-0.2527228599908341, -0.4275386729168246, \
-0.05130464075001894}, {-0.2188183987589316, -0.40689371670049274`, \
-0.07052824422808539}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2566895622918732, -0.42781593715312194`, \
-0.028521062476874796`}, {-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.29040472453203425`, -0.45062802082557046`, \
-0.03004186805503801}, {-0.2527228599908341, -0.4275386729168246, \
-0.05130464075001894}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 
    0.}, {-0.014560811715990765`, -0.10920608786993075`, 
    0.}, {-0.0246522971021567, -0.142224790973981, 
    0.003160550910532909}, {-0.0038620463024166113`, -0.05793069453624921, 
    0.0012873487674722039`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.014560811715990765`, -0.10920608786993075`, 
    0.}, {-0.05675323239297665, -0.21282462147366246`, 
    0.}, {-0.06253826722971648, -0.22335095439184463`, 
    0.004963354542040988}, {-0.0246522971021567, -0.142224790973981, 
    0.003160550910532909}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.05675323239297665, -0.21282462147366246`, 
    0.}, {-0.1226952100911925, -0.30673802522798127`, 
    0.}, {-0.11533618865511652`, -0.2982832465218531, 
    0.006628516589374509}, {-0.06253826722971648, -0.22335095439184463`, 
    0.004963354542040988}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1226952100911925, -0.30673802522798127`, 
    0.}, {-0.20749339485230253`, -0.38905011534806727`, 
    0.}, {-0.18050915270650156`, -0.36589693116182753`, 
    0.008131042914707273}, {-0.11533618865511652`, -0.2982832465218531, 
    0.006628516589374509}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20749339485230253`, -0.38905011534806727`, 
    0.}, {-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.2556458063906103, -0.4260763439843505, 
    0.009468363199652228}, {-0.18050915270650156`, -0.36589693116182753`, 
    0.008131042914707273}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.2566895622918732, -0.42781593715312194`, 
    0.028521062476874796`}, {-0.21842728074316375`, -0.39956209892042155`, 
    0.030189136362876293`}, {-0.2556458063906103, -0.4260763439843505, 
    0.009468363199652228}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2566895622918732, -0.42781593715312194`, 
    0.028521062476874796`}, {-0.21246554927450964`, -0.3983729048897056, 
    0.05311638731862741}, {-0.18521381542885962`, -0.3754334096530939, 
    0.04838919502195432}, {-0.21842728074316375`, -0.39956209892042155`, 
    0.030189136362876293`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21246554927450964`, -0.3983729048897056, 
    0.05311638731862741}, {-0.1746044040148139, -0.37415229431745833`, 
    0.07483045886349166}, {-0.15631133790709126`, -0.3552530406979347, 
    0.0647349985271792}, {-0.18521381542885962`, -0.3754334096530939, 
    0.04838919502195432}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1746044040148139, -0.37415229431745833`, 
    0.07483045886349166}, {-0.14319799741026004`, -0.3579949935256501, 
    0.09546533160684004}, {-0.131748866608086, -0.3407298274347052, 
    0.08026080379573056}, {-0.15631133790709126`, -0.3552530406979347, 
    0.0647349985271792}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.14319799741026004`, -0.3579949935256501, 
    0.09546533160684004}, {-0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {-0.11112456154944492`, -0.3333736846483348, 
    0.09630795334285228}, {-0.131748866608086, -0.3407298274347052, 
    0.08026080379573056}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {-0.07771364461602205, -0.2914261673100827, 
    0.07771364461602205}, {-0.07946169892532537, -0.2837917818761621, 
    0.0668487308419404}, {-0.11112456154944492`, -0.3333736846483348, 
    0.09630795334285228}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07771364461602205, -0.2914261673100827, 
    0.07771364461602205}, {-0.04495902221896904, -0.22479511109484523`, 
    0.04495902221896904}, {-0.052280949450900525`, -0.23065124757750236`, 
    0.04202978289190042}, {-0.07946169892532537, -0.2837917818761621, 
    0.0668487308419404}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.04495902221896904, -0.22479511109484523`, 
    0.04495902221896904}, {-0.02041142073737483, -0.15308565553031123`, 
    0.02041142073737483}, {-0.030232164988298865`, -0.17441633647095503`, 
    0.02248032781181198}, {-0.052280949450900525`, -0.23065124757750236`, 
    0.04202978289190042}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.02041142073737483, -0.15308565553031123`, 
    0.02041142073737483}, {-0.005171109167864868, -0.07756663751797302, 
    0.005171109167864868}, {-0.013921129715104607`, -0.11600941429253843`, 
    0.008765155746547347}, {-0.030232164988298865`, -0.17441633647095503`, 
    0.02248032781181198}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.005171109167864868, -0.07756663751797302, 
    0.005171109167864868}, {0., 0., 
    0.}, {-0.0038620463024166113`, -0.05793069453624921, 
    0.0012873487674722039`}, {-0.013921129715104607`, -0.11600941429253843`, 
    0.008765155746547347}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.2566895622918732, -0.42781593715312194`, 
    0.028521062476874796`}, {-0.2527228599908341, -0.4275386729168246, 
    0.05130464075001894}, {-0.29040472453203425`, -0.45062802082557046`, 
    0.03004186805503801}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2566895622918732, -0.42781593715312194`, 
    0.028521062476874796`}, {-0.21246554927450964`, -0.3983729048897056, 
    0.05311638731862741}, {-0.2188183987589316, -0.40689371670049274`, 
    0.07052824422808539}, {-0.2527228599908341, -0.4275386729168246, 
    0.05130464075001894}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21246554927450964`, -0.3983729048897056, 
    0.05311638731862741}, {-0.1746044040148139, -0.37415229431745833`, 
    0.07483045886349166}, {-0.18889392224764073`, -0.38991864684146027`, 
    0.08838155995073098}, {-0.2188183987589316, -0.40689371670049274`, 
    0.07052824422808539}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1746044040148139, -0.37415229431745833`, 
    0.07483045886349166}, {-0.14319799741026004`, -0.3579949935256501, 
    0.09546533160684004}, {-0.16290833179688105`, -0.37788015107523965`, 
    0.10580644230106709`}, {-0.18889392224764073`, -0.38991864684146027`, 
    0.08838155995073098}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.14319799741026004`, -0.3579949935256501, 
    0.09546533160684004}, {-0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {-0.1404740306623331, -0.37184302234147004`, 
    0.12394767411382335`}, {-0.16290833179688105`, -0.37788015107523965`, 
    0.10580644230106709`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {-0.1629042820200324, -0.40726070505008105`, 
    0.1629042820200324}, {-0.1787484353953863, -0.4146226594222878, 
    0.1603207616432846}, {-0.1404740306623331, -0.37184302234147004`, 
    0.12394767411382335`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1629042820200324, -0.40726070505008105`, 
    0.1629042820200324}, {-0.21311308081691166`, -0.4566708874648107, 
    0.21311308081691166`}, {-0.2198966482103745, -0.4539150995168281, 
    0.19972264378740437`}, {-0.1787484353953863, -0.4146226594222878, 
    0.1603207616432846}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21311308081691166`, -0.4566708874648107, 
    0.21311308081691166`}, {-0.2673132787288769, -0.5012123976166442, 
    0.2673132787288769}, {-0.2635503764484113, -0.49007301405696324`, 
    0.24176935360143517`}, {-0.2198966482103745, -0.4539150995168281, 
    0.19972264378740437`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2673132787288769, -0.5012123976166442, 
    0.2673132787288769}, {-0.3251055239962821, -0.5418425399938036, 
    0.3251055239962821}, {-0.30948310838038806`, -0.5235616495156941, 
    0.2862137017352461}, {-0.2635503764484113, -0.49007301405696324`, 
    0.24176935360143517`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3251055239962821, -0.5418425399938036, 
    0.3251055239962821}, {-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.3576298790583277, -0.5549429157801637, 
    0.3329657494680982}, {-0.30948310838038806`, -0.5235616495156941, 
    0.2862137017352461}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.36266749034792994`, -0.5440012355218949, 
    0.29013399227834397`}, {-0.3391849732407725, -0.5263215102011988, 
    0.25965194503259137`}, {-0.3576298790583277, -0.5549429157801637, 
    0.3329657494680982}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.36266749034792994`, -0.5440012355218949, 
    0.29013399227834397`}, {-0.3410246861288609, -0.5115370291932914, 
    0.20461481167731652`}, {-0.3222191897266516, -0.49999529440342494`, 
    0.19333151383599095`}, {-0.3391849732407725, -0.5263215102011988, 
    0.25965194503259137`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3410246861288609, -0.5115370291932914, 
    0.20461481167731652`}, {-0.3230789997575147, -0.48461849963627207`, 
    0.12923159990300587`}, {-0.3076477764089712, -0.4773844806346105, 
    0.13366765457769092`}, {-0.3222191897266516, -0.49999529440342494`, 
    0.19333151383599095`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3230789997575147, -0.48461849963627207`, 
    0.12923159990300587`}, {-0.3109670174603803, -0.4664505261905705, 
    0.06219340349207606}, {-0.2966525297708156, -0.4603228910236794, 
    0.07978930111077108}, {-0.3076477764089712, -0.4773844806346105, 
    0.13366765457769092`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3109670174603803, -0.4664505261905705, 
    0.06219340349207606}, {-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.29040472453203425`, -0.45062802082557046`, 
    0.03004186805503801}, {-0.2966525297708156, -0.4603228910236794, 
    0.07978930111077108}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.4407985310247471, -0.6103364275727268, \
-0.4407985310247471}, {-0.4589425074132659, -0.6164899353312527, \
-0.4452427310725714}, {-0.41445824199145676`, -0.5920832028449382, \
-0.4013008374837915}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4407985310247471, -0.6103364275727268, \
-0.4407985310247471}, {-0.49871361404698694`, -0.6412032180604118, \
-0.49871361404698694`}, {-0.5058735949853128, -0.641248218995467, \
-0.4916236345631913}, {-0.4589425074132659, -0.6164899353312527, \
-0.4452427310725714}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49871361404698694`, -0.6412032180604118, \
-0.49871361404698694`}, {-0.5616987892757247, -0.6740385471308696, \
-0.5616987892757247}, {-0.5560382810696715, -0.6672459372836057, \
-0.5412105935744802}, {-0.5058735949853128, -0.641248218995467, \
-0.4916236345631913}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, -0.6740385471308696, \
-0.5616987892757247}, {-0.6001728499508097, -0.6751944561946608, \
-0.5251512437069583}, {-0.5866559059525488, -0.6683421713383466, \
-0.5123956646927323}, {-0.5560382810696715, -0.6672459372836057, \
-0.5412105935744802}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6001728499508097, -0.6751944561946608, \
-0.5251512437069583}, {-0.6409750644401281, -0.6786794799954298, \
-0.49015740221892146`}, {-0.6187258872685492, -0.670907588604451, \
-0.484544369547659}, {-0.5866559059525488, -0.6683421713383466, \
-0.5123956646927323}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6409750644401281, -0.6786794799954298, \
-0.49015740221892146`}, {-0.6845537086570662, -0.6845537086570662, \
-0.4563691391047108}, {-0.6524642864965196, -0.6749630549963996, \
-0.4574749594975597}, {-0.6187258872685492, -0.670907588604451, \
-0.484544369547659}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.6845537086570662, \
-0.4563691391047108}, {-0.5739560409372104, -0.6457005460543618, \
-0.4304670307029078}, {-0.5660318008824062, -0.6448463554356526, \
-0.43706252979527566`}, {-0.6524642864965196, -0.6749630549963996, \
-0.4574749594975597}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5739560409372104, -0.6457005460543618, \
-0.4304670307029078}, {-0.4756173846484537, -0.6115080659765835, \
-0.40767204398438894`}, {-0.48721825136857155`, -0.6176006003263583, \
-0.4185959624434206}, {-0.5660318008824062, -0.6448463554356526, \
-0.43706252979527566`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4756173846484537, -0.6115080659765835, \
-0.40767204398438894`}, {-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.41445824199145676`, -0.5920832028449382, \
-0.4013008374837915}, {-0.48721825136857155`, -0.6176006003263583, \
-0.4185959624434206}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.6845537086570662, \
-0.4563691391047108}, {-0.7171888530767329, -0.7171888530767329, \
-0.5578135523930144}, {-0.7082077892481158, -0.716165180138544, \
-0.5649747532204069}, {-0.6814262655051632, -0.6890827403984796, \
-0.4823579182789357}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7171888530767329, -0.7171888530767329, \
-0.5578135523930144}, {-0.7640699024805022, -0.7640699024805022, \
-0.6791732466493353}, {-0.7436741413969546, -0.7520300306261339, \
-0.6601152491051621}, {-0.7082077892481158, -0.716165180138544, \
-0.5649747532204069}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7640699024805022, -0.7640699024805022, \
-0.6791732466493353}, {-0.9068996821171088, -0.9068996821171088, \
-0.9068996821171088}, {-0.8014503466375957, -0.8104554067121754, \
-0.7834402264884363}, {-0.7436741413969546, -0.7520300306261339, \
-0.6601152491051621}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.9068996821171088, -0.9068996821171088, \
-0.9068996821171088}, {-0.7198653019554957, -0.7622103197175837, \
-0.7198653019554957}, {-0.7087220368790109, -0.7504115684601292, \
-0.6920462242465636}, {-0.8014503466375957, -0.8104554067121754, \
-0.7834402264884363}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7198653019554957, -0.7622103197175837, \
-0.7198653019554957}, {-0.6327645227143793, -0.7118600880536767, \
-0.6327645227143793}, {-0.6407214117452011, -0.7119126797168901, \
-0.6249011299737146}, {-0.7087220368790109, -0.7504115684601292, \
-0.6920462242465636}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6327645227143793, -0.7118600880536767, \
-0.6327645227143793}, {-0.5616987892757247, -0.6740385471308696, \
-0.5616987892757247}, {-0.5827295292403942, -0.6811124367744867, \
-0.5675936973120723}, {-0.6407214117452011, -0.7119126797168901, \
-0.6249011299737146}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, -0.6740385471308696, \
-0.5616987892757247}, {-0.6001728499508097, -0.6751944561946608, \
-0.5251512437069583}, {-0.614016318705615, -0.68224035411735, \
-0.5382118349147983}, {-0.5827295292403942, -0.6811124367744867, \
-0.5675936973120723}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6001728499508097, -0.6751944561946608, \
-0.5251512437069583}, {-0.6409750644401281, -0.6786794799954298, \
-0.49015740221892146`}, {-0.6468362024341406, -0.6848853908126196, \
-0.5098591242716168}, {-0.614016318705615, -0.68224035411735, \
-0.5382118349147983}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6409750644401281, -0.6786794799954298, \
-0.49015740221892146`}, {-0.6845537086570662, -0.6845537086570662, \
-0.4563691391047108}, {-0.6814262655051632, -0.6890827403984796, \
-0.4823579182789357}, {-0.6468362024341406, -0.6848853908126196, \
-0.5098591242716168}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.30835878902578173`, -0.46253818353867265`, \
-0.038544848628222717`}, {-0.3272755515504841, -0.47507741354102534`, \
-0.052786379282336135`}, {-0.324812266811562, -0.47150167762968676`, \
-0.020955630116874954`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.30835878902578173`, -0.46253818353867265`, \
-0.038544848628222717`}, {-0.3133278126499405, -0.46999171897491077`, \
-0.07833195316248512}, {-0.33173110157337826`, -0.48154514744522653`, \
-0.0856080262124847}, {-0.3272755515504841, -0.47507741354102534`, \
-0.052786379282336135`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3133278126499405, -0.46999171897491077`, \
-0.07833195316248512}, {-0.32119984116648215`, -0.4817997617497233, \
-0.12044994043743079`}, {-0.3379835236888404, -0.4906212440644457, \
-0.11992963743797559`}, {-0.33173110157337826`, -0.48154514744522653`, \
-0.0856080262124847}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.32119984116648215`, -0.4817997617497233, \
-0.12044994043743079`}, {-0.3314637051921916, -0.4971955577882874, \
-0.1657318525960958}, {-0.3457858768371393, -0.5019472405700409, \
-0.1561613637329016}, {-0.3379835236888404, -0.4906212440644457, \
-0.11992963743797559`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3314637051921916, -0.4971955577882874, \
-0.1657318525960958}, {-0.39765544300931854`, -0.530207257345758, \
-0.176735752448586}, {-0.3994358934176101, -0.5286651530527192, \
-0.16447360317195706`}, {-0.3457858768371393, -0.5019472405700409, \
-0.1561613637329016}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.39765544300931854`, -0.530207257345758, \
-0.176735752448586}, {-0.4681662066691236, -0.5617994480029483, \
-0.18726648266764945`}, {-0.4558187389930595, -0.5543741420185859, \
-0.17247195529467113`}, {-0.3994358934176101, -0.5286651530527192, \
-0.16447360317195706`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4681662066691236, -0.5617994480029483, \
-0.18726648266764945`}, {-0.5431099643448393, -0.5924835974670974, \
-0.19749453248903248`}, {-0.5149712865819899, -0.5793426974047388, \
-0.18023995030369647`}, {-0.4558187389930595, -0.5543741420185859, \
-0.17247195529467113`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5431099643448393, -0.5924835974670974, \
-0.19749453248903248`}, {-0.6230755279293883, -0.6230755279293883, \
-0.20769184264312943`}, {-0.577110853908633, -0.6039532192067091, \
-0.18789655708653166`}, {-0.5149712865819899, -0.5793426974047388, \
-0.18023995030369647`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.6230755279293883, \
-0.20769184264312943`}, {-0.5340787945649619, -0.5826314122526858, \
-0.14565785306317142`}, {-0.508005053276671, -0.571505684936255, \
-0.13970138965108453`}, {-0.577110853908633, -0.6039532192067091, \
-0.18789655708653166`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5340787945649619, -0.5826314122526858, \
-0.14565785306317142`}, {-0.4519868652439711, -0.5423842382927654, \
-0.09039737304879422}, {-0.4430198761700281, -0.5388079575040883, \
-0.09578808133406011}, {-0.508005053276671, -0.571505684936255, \
-0.13970138965108453`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4519868652439711, -0.5423842382927654, \
-0.09039737304879422}, {-0.3760334842623161, -0.5013779790164214, \
-0.04178149825136846}, {-0.38188535180948235`, -0.5054364950419619, \
-0.05615961056021798}, {-0.4430198761700281, -0.5388079575040883, \
-0.09578808133406011}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3760334842623161, -0.5013779790164214, \
-0.04178149825136846}, {-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.324812266811562, -0.47150167762968676`, -0.020955630116874954`}, \
{-0.38188535180948235`, -0.5054364950419619, -0.05615961056021798}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.3521297960868685, -0.4875643330433564, -0.02708690739129757}, \
{-0.3705256111237356, -0.49772097016621203`, -0.027651165009233997`}, \
{-0.33331950097178215`, -0.47617071567397445`, -0.005290785729710824}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3521297960868685, -0.4875643330433564, \
-0.02708690739129757}, {-0.4006616635511933, -0.5151364245658201, \
-0.057237380507313335`}, {-0.4096523388389484, -0.5192776126127516, \
-0.05192776126127516}, {-0.3705256111237356, -0.49772097016621203`, \
-0.027651165009233997`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4006616635511933, -0.5151364245658201, \
-0.057237380507313335`}, {-0.4519868652439711, -0.5423842382927654, \
-0.09039737304879422}, {-0.45057871430700847`, -0.5406944571684102, \
-0.07810031047988147}, {-0.4096523388389484, -0.5192776126127516, \
-0.05192776126127516}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4519868652439711, -0.5423842382927654, \
-0.09039737304879422}, {-0.49876346636093416`, -0.5611088996560509, \
-0.06234543329511677}, {-0.48816098568500393`, -0.5561327685019032, \
-0.055613276850190324`}, {-0.45057871430700847`, -0.5406944571684102, \
-0.07810031047988147}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49876346636093416`, -0.5611088996560509, \
-0.06234543329511677}, {-0.5487568617464034, -0.5810366771432506, \
-0.03227981539684726}, {-0.5277877792683088, -0.5723000016162385, \
-0.03179444453423547}, {-0.48816098568500393`, -0.5561327685019032, \
-0.055613276850190324`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5487568617464034, -0.5810366771432506, \
-0.03227981539684726}, {-0.6020420732135735, -0.6020420732135735, 
    0.}, {-0.5694735663591197, -0.5891105858887445, -0.006545673176541602}, \
{-0.5277877792683088, -0.5723000016162385, -0.03179444453423547}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6020420732135735, -0.6020420732135735, 
    0.}, {-0.49629010408701807`, -0.5583263670978953, 
    0.}, {-0.4861669055664677, -0.5538610316580012, -0.006154011462866676}, \
{-0.5694735663591197, -0.5891105858887445, -0.006545673176541602}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49629010408701807`, -0.5583263670978953, 
    0.}, {-0.3979707523500161, -0.5116766815928779, 
    0.}, {-0.40751773325855134`, -0.5165717745530933, -0.005739686383923255}, \
{-0.4861669055664677, -0.5538610316580012, -0.006154011462866676}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3979707523500161, -0.5116766815928779, 
    0.}, {-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.33331950097178215`, -0.47617071567397445`, \
-0.005290785729710824}, {-0.40751773325855134`, -0.5165717745530933, \
-0.005739686383923255}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6020420732135735, -0.6020420732135735, 
    0.}, {-0.6044295191828238, -0.6044295191828238, -0.06715883546475819}, \
{-0.5939764691589027, -0.6006503620708005, -0.0734128220308756}, \
{-0.5913037838451686, -0.597947646585002, -0.01993158821950005}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6044295191828238, -0.6044295191828238, \
-0.06715883546475819}, {-0.6115080659765835, -0.6115080659765835, \
-0.13589068132812965`}, {-0.5996388334008513, -0.6063763483828833, \
-0.12801278465860869`}, {-0.5939764691589027, -0.6006503620708005, \
-0.0734128220308756}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6115080659765835, -0.6115080659765835, \
-0.13589068132812965`}, {-0.6230755279293883, -0.6230755279293883, \
-0.20769184264312943`}, {-0.6081719439707838, -0.615005336599669, \
-0.1845016009799007}, {-0.5996388334008513, -0.6063763483828833, \
-0.12801278465860869`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.6230755279293883, \
-0.20769184264312943`}, {-0.5628929014012727, -0.596004248542524, \
-0.16555673570625667`}, {-0.560676306835095, -0.5936572660606888, \
-0.15171241243773156`}, {-0.6081719439707838, -0.615005336599669, \
-0.1845016009799007}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5628929014012727, -0.596004248542524, \
-0.16555673570625667`}, {-0.5060163098682655, -0.5692683486017988, \
-0.12650407746706638`}, {-0.5152602653744724, -0.5725114059716361, \
-0.1208635190384565}, {-0.560676306835095, -0.5936572660606888, \
-0.15171241243773156`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5060163098682655, -0.5692683486017988, \
-0.12650407746706638`}, {-0.4519868652439711, -0.5423842382927654, \
-0.09039737304879422}, {-0.4716982811963126, -0.5513356533463394, \
-0.09188927555772322}, {-0.5152602653744724, -0.5725114059716361, \
-0.1208635190384565}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4519868652439711, -0.5423842382927654, \
-0.09039737304879422}, {-0.49876346636093416`, -0.5611088996560509, \
-0.06234543329511677}, {-0.5094822152479099, -0.5660913502754555, \
-0.06918894281144455}, {-0.4716982811963126, -0.5513356533463394, \
-0.09188927555772322}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49876346636093416`, -0.5611088996560509, \
-0.06234543329511677}, {-0.5487568617464034, -0.5810366771432506, \
-0.03227981539684726}, {-0.5493362280674016, -0.5816501238360723, \
-0.04523945407613895}, {-0.5094822152479099, -0.5660913502754555, \
-0.06918894281144455}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5487568617464034, -0.5810366771432506, \
-0.03227981539684726}, {-0.6020420732135735, -0.6020420732135735, 
    0.}, {-0.5913037838451686, -0.597947646585002, -0.01993158821950005}, \
{-0.5493362280674016, -0.5816501238360723, -0.04523945407613895}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.3713990257767195, -0.5570985386650793, \
-0.32497414755462956`}, {-0.3835413553175742, -0.5567535802997046, \
-0.3093075446109469}, {-0.39544905581618517`, -0.5740389519912366, \
-0.35717979235010267`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3713990257767195, -0.5570985386650793, \
-0.32497414755462956`}, {-0.35700820570107417`, -0.5355123085516112, \
-0.26775615427580557`}, {-0.37218594917787184`, -0.540269926225943, \
-0.26413196393268323`}, {-0.3835413553175742, -0.5567535802997046, \
-0.3093075446109469}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.35700820570107417`, -0.5355123085516112, \
-0.26775615427580557`}, {-0.34356711554250086`, -0.5153506733137513, \
-0.21472944721406304`}, {-0.3615143676766774, -0.5247789208209833, \
-0.22157332212441513`}, {-0.37218594917787184`, -0.540269926225943, \
-0.26413196393268323`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.34356711554250086`, -0.5153506733137513, \
-0.21472944721406304`}, {-0.3314637051921916, -0.4971955577882874, \
-0.1657318525960958}, {-0.35171683279870997`, -0.510556692772321, \
-0.18153126854126964`}, {-0.3615143676766774, -0.5247789208209833, \
-0.22157332212441513`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3314637051921916, -0.4971955577882874, \
-0.1657318525960958}, {-0.39765544300931854`, -0.530207257345758, \
-0.176735752448586}, {-0.4051478286995518, -0.5362250673964656, \
-0.1906578017409655}, {-0.35171683279870997`, -0.510556692772321, \
-0.18153126854126964`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.39765544300931854`, -0.530207257345758, \
-0.176735752448586}, {-0.4681662066691236, -0.5617994480029483, \
-0.18726648266764945`}, {-0.461356206383864, -0.5611088996560508, \
-0.19950538654437358`}, {-0.4051478286995518, -0.5362250673964656, \
-0.1906578017409655}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4681662066691236, -0.5617994480029483, \
-0.18726648266764945`}, {-0.5431099643448393, -0.5924835974670974, \
-0.19749453248903248`}, {-0.5204039871231084, -0.5854544855134971, \
-0.20816159484924335`}, {-0.461356206383864, -0.5611088996560508, \
-0.19950538654437358`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5431099643448393, -0.5924835974670974, \
-0.19749453248903248`}, {-0.6230755279293883, -0.6230755279293883, \
-0.20769184264312943`}, {-0.5825372045115768, -0.6096319582097897, \
-0.21675802958570295`}, {-0.5204039871231084, -0.5854544855134971, \
-0.20816159484924335`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.6230755279293883, \
-0.20769184264312943`}, {-0.5543330019515704, -0.604726911219895, \
-0.25196954634162294`}, {-0.5296515960248482, -0.5958580455279544, \
-0.2515845081118029}, {-0.5825372045115768, -0.6096319582097897, \
-0.21675802958570295`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5543330019515704, -0.604726911219895, \
-0.25196954634162294`}, {-0.4925795519732687, -0.5910954623679224, \
-0.29554773118396116`}, {-0.4811249564266876, -0.585151974032458, \
-0.2860742984158683}, {-0.5296515960248482, -0.5958580455279544, \
-0.2515845081118029}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4925795519732687, -0.5910954623679224, \
-0.29554773118396116`}, {-0.43697355918951436`, -0.5826314122526858, \
-0.3398683238140667}, {-0.4365551681661225, -0.5777936049257504, \
-0.32099644718097237`}, {-0.4811249564266876, -0.585151974032458, \
-0.2860742984158683}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.43697355918951436`, -0.5826314122526858, \
-0.3398683238140667}, {-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.39544905581618517`, -0.5740389519912366, \
-0.35717979235010267`}, {-0.4365551681661225, -0.5777936049257504, \
-0.32099644718097237`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.41963760015901447`, -0.5810366771432508, \
-0.3550779693653199}, {-0.4375200535371022, -0.5877135047513313, \
-0.3591582529035913}, {-0.41027620202761383`, -0.5861088600394483, \
-0.38422691935919384`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.41963760015901447`, -0.5810366771432508, \
-0.3550779693653199}, {-0.45488267153483286`, -0.5848491491162138, \
-0.32491619395345206`}, {-0.46615250600961755`, -0.5908975428290927, \
-0.33484194093648584`}, {-0.4375200535371022, -0.5877135047513313, \
-0.3591582529035913}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45488267153483286`, -0.5848491491162138, \
-0.32491619395345206`}, {-0.4925795519732687, -0.5910954623679224, \
-0.2955477311839612}, {-0.49634519379760245`, -0.595614232557123, \
-0.31104298811316416`}, {-0.46615250600961755`, -0.5908975428290927, \
-0.33484194093648584`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4925795519732687, -0.5910954623679224, \
-0.2955477311839612}, {-0.5518056130029987, -0.6207813146283735, \
-0.34487850812687415`}, {-0.5437365170115114, -0.6194466649498231, \
-0.3510197768048997}, {-0.49634519379760245`, -0.595614232557123, \
-0.31104298811316416`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5518056130029987, -0.6207813146283735, \
-0.34487850812687415`}, {-0.6151364564558499, -0.6513209538944295, \
-0.39802947182437354`}, {-0.593696451805427, -0.643767236897451, \
-0.3934133114373311}, {-0.5437365170115114, -0.6194466649498231, \
-0.3510197768048997}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6151364564558499, -0.6513209538944295, \
-0.39802947182437354`}, {-0.6845537086570662, -0.6845537086570662, \
-0.4563691391047108}, {-0.6471256199373834, -0.6694402964869484, \
-0.43885530547477725`}, {-0.593696451805427, -0.643767236897451, \
-0.3934133114373311}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.6845537086570662, \
-0.4563691391047108}, {-0.5739560409372104, -0.6457005460543618, \
-0.4304670307029078}, {-0.5612928240005222, -0.639447521013253, \
-0.41919337488646585`}, {-0.6471256199373834, -0.6694402964869484, \
-0.43885530547477725`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5739560409372104, -0.6457005460543618, \
-0.4304670307029078}, {-0.4756173846484537, -0.6115080659765835, \
-0.40767204398438894`}, {-0.4828178508766534, -0.6120226278718142, \
-0.4012148338270782}, {-0.5612928240005222, -0.639447521013253, \
-0.41919337488646585`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4756173846484537, -0.6115080659765835, \
-0.40767204398438894`}, {-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.41027620202761383`, -0.5861088600394483, \
-0.38422691935919384`}, {-0.4828178508766534, -0.6120226278718142, \
-0.4012148338270782}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.6845537086570662, \
-0.4563691391047108}, {-0.6592097133507697, -0.6592097133507697, \
-0.3662276185282054}, {-0.6456860811433847, -0.6529409809315125, \
-0.35549008961826795`}, {-0.6647257540000352, -0.6721945826966648, \
-0.42572323570788767`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6592097133507697, -0.6592097133507697, \
-0.3662276185282054}, {-0.6389520625760421, -0.6389520625760421, \
-0.2839786944782409}, {-0.629668395546924, -0.6367433213395861, \
-0.2900719574991448}, {-0.6456860811433847, -0.6529409809315125, \
-0.35549008961826795`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6389520625760421, -0.6389520625760421, \
-0.2839786944782409}, {-0.6230755279293883, -0.6230755279293883, \
-0.20769184264312943`}, {-0.6163788869098672, -0.6233044923807646, \
-0.22854498053961364`}, {-0.629668395546924, -0.6367433213395861, \
-0.2900719574991448}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.6230755279293883, \
-0.20769184264312943`}, {-0.5764288482631306, -0.6103364275727265, \
-0.23735305516717142`}, {-0.5796080893522857, -0.6137026828435966, \
-0.2522999918357008}, {-0.6163788869098672, -0.6233044923807646, \
-0.22854498053961364`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5764288482631306, -0.6103364275727265, \
-0.23735305516717142`}, {-0.5330126623440324, -0.5996392451370365, \
-0.2665063311720162}, {-0.5448850795979028, -0.605427866219892, \
-0.2758060279446175}, {-0.5796080893522857, -0.6137026828435966, \
-0.2522999918357008}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5330126623440324, -0.5996392451370365, \
-0.2665063311720162}, {-0.4925795519732687, -0.5910954623679224, \
-0.2955477311839612}, {-0.5120744169386685, -0.5985285392789631, \
-0.29926426963948155`}, {-0.5448850795979028, -0.605427866219892, \
-0.2758060279446175}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4925795519732687, -0.5910954623679224, \
-0.2955477311839612}, {-0.5518056130029987, -0.6207813146283735, \
-0.34487850812687415`}, {-0.5599842480618302, -0.6222047200687002, \
-0.33875590314851456`}, {-0.5120744169386685, -0.5985285392789631, \
-0.29926426963948155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5518056130029987, -0.6207813146283735, \
-0.34487850812687415`}, {-0.6151364564558499, -0.6513209538944295, \
-0.39802947182437354`}, {-0.6105500670057994, -0.6464647768296701, \
-0.3806959241330279}, {-0.5599842480618302, -0.6222047200687002, \
-0.33875590314851456`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6151364564558499, -0.6513209538944295, \
-0.39802947182437354`}, {-0.6845537086570662, -0.6845537086570662, \
-0.4563691391047108}, {-0.6647257540000352, -0.6721945826966648, \
-0.42572323570788767`}, {-0.6105500670057994, -0.6464647768296701, \
-0.3806959241330279}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.3713990257767195, -0.5570985386650793, 
    0.32497414755462956`}, {-0.3835413553175742, -0.5567535802997046, 
    0.3093075446109469}, {-0.39544905581618517`, -0.5740389519912366, 
    0.35717979235010267`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3713990257767195, -0.5570985386650793, 
    0.32497414755462956`}, {-0.35700820570107417`, -0.5355123085516112, 
    0.26775615427580557`}, {-0.37218594917787184`, -0.540269926225943, 
    0.26413196393268323`}, {-0.3835413553175742, -0.5567535802997046, 
    0.3093075446109469}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.35700820570107417`, -0.5355123085516112, 
    0.26775615427580557`}, {-0.34356711554250086`, -0.5153506733137513, 
    0.21472944721406304`}, {-0.3615143676766774, -0.5247789208209833, 
    0.22157332212441513`}, {-0.37218594917787184`, -0.540269926225943, 
    0.26413196393268323`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.34356711554250086`, -0.5153506733137513, 
    0.21472944721406304`}, {-0.3314637051921916, -0.4971955577882874, 
    0.1657318525960958}, {-0.35171683279870997`, -0.510556692772321, 
    0.18153126854126964`}, {-0.3615143676766774, -0.5247789208209833, 
    0.22157332212441513`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3314637051921916, -0.4971955577882874, 
    0.1657318525960958}, {-0.39765544300931854`, -0.530207257345758, 
    0.176735752448586}, {-0.4051478286995518, -0.5362250673964656, 
    0.1906578017409655}, {-0.35171683279870997`, -0.510556692772321, 
    0.18153126854126964`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.39765544300931854`, -0.530207257345758, 
    0.176735752448586}, {-0.4681662066691236, -0.5617994480029483, 
    0.18726648266764945`}, {-0.461356206383864, -0.5611088996560508, 
    0.19950538654437358`}, {-0.4051478286995518, -0.5362250673964656, 
    0.1906578017409655}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4681662066691236, -0.5617994480029483, 
    0.18726648266764945`}, {-0.5431099643448393, -0.5924835974670974, 
    0.19749453248903248`}, {-0.5204039871231084, -0.5854544855134971, 
    0.20816159484924335`}, {-0.461356206383864, -0.5611088996560508, 
    0.19950538654437358`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5431099643448393, -0.5924835974670974, 
    0.19749453248903248`}, {-0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {-0.5825372045115768, -0.6096319582097897, 
    0.21675802958570295`}, {-0.5204039871231084, -0.5854544855134971, 
    0.20816159484924335`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {-0.5543330019515704, -0.604726911219895, 
    0.25196954634162294`}, {-0.5296515960248482, -0.5958580455279544, 
    0.2515845081118029}, {-0.5825372045115768, -0.6096319582097897, 
    0.21675802958570295`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5543330019515704, -0.604726911219895, 
    0.25196954634162294`}, {-0.4925795519732687, -0.5910954623679224, 
    0.29554773118396116`}, {-0.4811249564266876, -0.585151974032458, 
    0.2860742984158683}, {-0.5296515960248482, -0.5958580455279544, 
    0.2515845081118029}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4925795519732687, -0.5910954623679224, 
    0.29554773118396116`}, {-0.43697355918951436`, -0.5826314122526858, 
    0.3398683238140667}, {-0.4365551681661225, -0.5777936049257504, 
    0.32099644718097237`}, {-0.4811249564266876, -0.585151974032458, 
    0.2860742984158683}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.43697355918951436`, -0.5826314122526858, 
    0.3398683238140667}, {-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.39544905581618517`, -0.5740389519912366, 
    0.35717979235010267`}, {-0.4365551681661225, -0.5777936049257504, 
    0.32099644718097237`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.41963760015901447`, -0.5810366771432508, 
    0.3550779693653199}, {-0.4375200535371022, -0.5877135047513313, 
    0.3591582529035913}, {-0.41027620202761383`, -0.5861088600394483, 
    0.38422691935919384`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.41963760015901447`, -0.5810366771432508, 
    0.3550779693653199}, {-0.45488267153483286`, -0.5848491491162138, 
    0.32491619395345206`}, {-0.46615250600961755`, -0.5908975428290927, 
    0.33484194093648584`}, {-0.4375200535371022, -0.5877135047513313, 
    0.3591582529035913}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45488267153483286`, -0.5848491491162138, 
    0.32491619395345206`}, {-0.4925795519732687, -0.5910954623679224, 
    0.2955477311839612}, {-0.49634519379760245`, -0.595614232557123, 
    0.31104298811316416`}, {-0.46615250600961755`, -0.5908975428290927, 
    0.33484194093648584`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4925795519732687, -0.5910954623679224, 
    0.2955477311839612}, {-0.5518056130029987, -0.6207813146283735, 
    0.34487850812687415`}, {-0.5437365170115114, -0.6194466649498231, 
    0.3510197768048997}, {-0.49634519379760245`, -0.595614232557123, 
    0.31104298811316416`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5518056130029987, -0.6207813146283735, 
    0.34487850812687415`}, {-0.6151364564558499, -0.6513209538944295, 
    0.39802947182437354`}, {-0.593696451805427, -0.643767236897451, 
    0.3934133114373311}, {-0.5437365170115114, -0.6194466649498231, 
    0.3510197768048997}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6151364564558499, -0.6513209538944295, 
    0.39802947182437354`}, {-0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {-0.6471256199373834, -0.6694402964869484, 
    0.43885530547477725`}, {-0.593696451805427, -0.643767236897451, 
    0.3934133114373311}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {-0.5739560409372104, -0.6457005460543618, 
    0.4304670307029078}, {-0.5612928240005222, -0.639447521013253, 
    0.41919337488646585`}, {-0.6471256199373834, -0.6694402964869484, 
    0.43885530547477725`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5739560409372104, -0.6457005460543618, 
    0.4304670307029078}, {-0.4756173846484537, -0.6115080659765835, 
    0.40767204398438894`}, {-0.4828178508766534, -0.6120226278718142, 
    0.4012148338270782}, {-0.5612928240005222, -0.639447521013253, 
    0.41919337488646585`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4756173846484537, -0.6115080659765835, 
    0.40767204398438894`}, {-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.41027620202761383`, -0.5861088600394483, 
    0.38422691935919384`}, {-0.4828178508766534, -0.6120226278718142, 
    0.4012148338270782}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {-0.6592097133507697, -0.6592097133507697, 
    0.3662276185282054}, {-0.6456860811433847, -0.6529409809315125, 
    0.35549008961826795`}, {-0.6647257540000352, -0.6721945826966648, 
    0.42572323570788767`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6592097133507697, -0.6592097133507697, 
    0.3662276185282054}, {-0.6389520625760421, -0.6389520625760421, 
    0.2839786944782409}, {-0.629668395546924, -0.6367433213395861, 
    0.2900719574991448}, {-0.6456860811433847, -0.6529409809315125, 
    0.35549008961826795`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6389520625760421, -0.6389520625760421, 
    0.2839786944782409}, {-0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {-0.6163788869098672, -0.6233044923807646, 
    0.22854498053961364`}, {-0.629668395546924, -0.6367433213395861, 
    0.2900719574991448}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {-0.5764288482631306, -0.6103364275727265, 
    0.23735305516717142`}, {-0.5796080893522857, -0.6137026828435966, 
    0.2522999918357008}, {-0.6163788869098672, -0.6233044923807646, 
    0.22854498053961364`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5764288482631306, -0.6103364275727265, 
    0.23735305516717142`}, {-0.5330126623440324, -0.5996392451370365, 
    0.2665063311720162}, {-0.5448850795979028, -0.605427866219892, 
    0.2758060279446175}, {-0.5796080893522857, -0.6137026828435966, 
    0.2522999918357008}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5330126623440324, -0.5996392451370365, 
    0.2665063311720162}, {-0.4925795519732687, -0.5910954623679224, 
    0.2955477311839612}, {-0.5120744169386685, -0.5985285392789631, 
    0.29926426963948155`}, {-0.5448850795979028, -0.605427866219892, 
    0.2758060279446175}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4925795519732687, -0.5910954623679224, 
    0.2955477311839612}, {-0.5518056130029987, -0.6207813146283735, 
    0.34487850812687415`}, {-0.5599842480618302, -0.6222047200687002, 
    0.33875590314851456`}, {-0.5120744169386685, -0.5985285392789631, 
    0.29926426963948155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5518056130029987, -0.6207813146283735, 
    0.34487850812687415`}, {-0.6151364564558499, -0.6513209538944295, 
    0.39802947182437354`}, {-0.6105500670057994, -0.6464647768296701, 
    0.3806959241330279}, {-0.5599842480618302, -0.6222047200687002, 
    0.33875590314851456`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6151364564558499, -0.6513209538944295, 
    0.39802947182437354`}, {-0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {-0.6647257540000352, -0.6721945826966648, 
    0.42572323570788767`}, {-0.6105500670057994, -0.6464647768296701, 
    0.3806959241330279}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.30835878902578173`, -0.46253818353867265`, 
    0.038544848628222717`}, {-0.3272755515504841, -0.47507741354102534`, 
    0.052786379282336135`}, {-0.324812266811562, -0.47150167762968676`, 
    0.020955630116874954`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.30835878902578173`, -0.46253818353867265`, 
    0.038544848628222717`}, {-0.3133278126499405, -0.46999171897491077`, 
    0.07833195316248512}, {-0.33173110157337826`, -0.48154514744522653`, 
    0.0856080262124847}, {-0.3272755515504841, -0.47507741354102534`, 
    0.052786379282336135`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3133278126499405, -0.46999171897491077`, 
    0.07833195316248512}, {-0.32119984116648215`, -0.4817997617497233, 
    0.12044994043743079`}, {-0.3379835236888404, -0.4906212440644457, 
    0.11992963743797559`}, {-0.33173110157337826`, -0.48154514744522653`, 
    0.0856080262124847}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.32119984116648215`, -0.4817997617497233, 
    0.12044994043743079`}, {-0.3314637051921916, -0.4971955577882874, 
    0.1657318525960958}, {-0.3457858768371393, -0.5019472405700409, 
    0.1561613637329016}, {-0.3379835236888404, -0.4906212440644457, 
    0.11992963743797559`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3314637051921916, -0.4971955577882874, 
    0.1657318525960958}, {-0.39765544300931854`, -0.530207257345758, 
    0.176735752448586}, {-0.3994358934176101, -0.5286651530527192, 
    0.16447360317195706`}, {-0.3457858768371393, -0.5019472405700409, 
    0.1561613637329016}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.39765544300931854`, -0.530207257345758, 
    0.176735752448586}, {-0.4681662066691236, -0.5617994480029483, 
    0.18726648266764945`}, {-0.4558187389930595, -0.5543741420185859, 
    0.17247195529467113`}, {-0.3994358934176101, -0.5286651530527192, 
    0.16447360317195706`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4681662066691236, -0.5617994480029483, 
    0.18726648266764945`}, {-0.5431099643448393, -0.5924835974670974, 
    0.19749453248903248`}, {-0.5149712865819899, -0.5793426974047388, 
    0.18023995030369647`}, {-0.4558187389930595, -0.5543741420185859, 
    0.17247195529467113`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5431099643448393, -0.5924835974670974, 
    0.19749453248903248`}, {-0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {-0.577110853908633, -0.6039532192067091, 
    0.18789655708653166`}, {-0.5149712865819899, -0.5793426974047388, 
    0.18023995030369647`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {-0.5340787945649619, -0.5826314122526858, 
    0.14565785306317142`}, {-0.508005053276671, -0.571505684936255, 
    0.13970138965108453`}, {-0.577110853908633, -0.6039532192067091, 
    0.18789655708653166`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5340787945649619, -0.5826314122526858, 
    0.14565785306317142`}, {-0.4519868652439711, -0.5423842382927654, 
    0.09039737304879422}, {-0.4430198761700281, -0.5388079575040883, 
    0.09578808133406011}, {-0.508005053276671, -0.571505684936255, 
    0.13970138965108453`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4519868652439711, -0.5423842382927654, 
    0.09039737304879422}, {-0.3760334842623161, -0.5013779790164214, 
    0.04178149825136846}, {-0.38188535180948235`, -0.5054364950419619, 
    0.05615961056021798}, {-0.4430198761700281, -0.5388079575040883, 
    0.09578808133406011}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3760334842623161, -0.5013779790164214, 
    0.04178149825136846}, {-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.324812266811562, -0.47150167762968676`, 
    0.020955630116874954`}, {-0.38188535180948235`, -0.5054364950419619, 
    0.05615961056021798}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.3521297960868685, -0.4875643330433564, 
    0.02708690739129757}, {-0.3705256111237356, -0.49772097016621203`, 
    0.027651165009233997`}, {-0.33331950097178215`, -0.47617071567397445`, 
    0.005290785729710824}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3521297960868685, -0.4875643330433564, 
    0.02708690739129757}, {-0.4006616635511933, -0.5151364245658201, 
    0.057237380507313335`}, {-0.4096523388389484, -0.5192776126127516, 
    0.05192776126127516}, {-0.3705256111237356, -0.49772097016621203`, 
    0.027651165009233997`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4006616635511933, -0.5151364245658201, 
    0.057237380507313335`}, {-0.4519868652439711, -0.5423842382927654, 
    0.09039737304879422}, {-0.45057871430700847`, -0.5406944571684102, 
    0.07810031047988147}, {-0.4096523388389484, -0.5192776126127516, 
    0.05192776126127516}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4519868652439711, -0.5423842382927654, 
    0.09039737304879422}, {-0.49876346636093416`, -0.5611088996560509, 
    0.06234543329511677}, {-0.48816098568500393`, -0.5561327685019032, 
    0.055613276850190324`}, {-0.45057871430700847`, -0.5406944571684102, 
    0.07810031047988147}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49876346636093416`, -0.5611088996560509, 
    0.06234543329511677}, {-0.5487568617464034, -0.5810366771432506, 
    0.03227981539684726}, {-0.5277877792683088, -0.5723000016162385, 
    0.03179444453423547}, {-0.48816098568500393`, -0.5561327685019032, 
    0.055613276850190324`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5487568617464034, -0.5810366771432506, 
    0.03227981539684726}, {-0.6020420732135735, -0.6020420732135735, 
    0.}, {-0.5694735663591197, -0.5891105858887445, 
    0.006545673176541602}, {-0.5277877792683088, -0.5723000016162385, 
    0.03179444453423547}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6020420732135735, -0.6020420732135735, 
    0.}, {-0.49629010408701807`, -0.5583263670978953, 
    0.}, {-0.4861669055664677, -0.5538610316580012, 
    0.006154011462866676}, {-0.5694735663591197, -0.5891105858887445, 
    0.006545673176541602}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49629010408701807`, -0.5583263670978953, 
    0.}, {-0.3979707523500161, -0.5116766815928779, 
    0.}, {-0.40751773325855134`, -0.5165717745530933, 
    0.005739686383923255}, {-0.4861669055664677, -0.5538610316580012, 
    0.006154011462866676}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3979707523500161, -0.5116766815928779, 
    0.}, {-0.3066580952458096, -0.45998714286871445`, 
    0.}, {-0.33331950097178215`, -0.47617071567397445`, 
    0.005290785729710824}, {-0.40751773325855134`, -0.5165717745530933, 
    0.005739686383923255}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6020420732135735, -0.6020420732135735, 
    0.}, {-0.6044295191828238, -0.6044295191828238, 
    0.06715883546475819}, {-0.5939764691589027, -0.6006503620708005, 
    0.0734128220308756}, {-0.5913037838451686, -0.597947646585002, 
    0.01993158821950005}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6044295191828238, -0.6044295191828238, 
    0.06715883546475819}, {-0.6115080659765835, -0.6115080659765835, 
    0.13589068132812965`}, {-0.5996388334008513, -0.6063763483828833, 
    0.12801278465860869`}, {-0.5939764691589027, -0.6006503620708005, 
    0.0734128220308756}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6115080659765835, -0.6115080659765835, 
    0.13589068132812965`}, {-0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {-0.6081719439707838, -0.615005336599669, 
    0.1845016009799007}, {-0.5996388334008513, -0.6063763483828833, 
    0.12801278465860869`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {-0.5628929014012727, -0.596004248542524, 
    0.16555673570625667`}, {-0.560676306835095, -0.5936572660606888, 
    0.15171241243773156`}, {-0.6081719439707838, -0.615005336599669, 
    0.1845016009799007}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5628929014012727, -0.596004248542524, 
    0.16555673570625667`}, {-0.5060163098682655, -0.5692683486017988, 
    0.12650407746706638`}, {-0.5152602653744724, -0.5725114059716361, 
    0.1208635190384565}, {-0.560676306835095, -0.5936572660606888, 
    0.15171241243773156`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5060163098682655, -0.5692683486017988, 
    0.12650407746706638`}, {-0.4519868652439711, -0.5423842382927654, 
    0.09039737304879422}, {-0.4716982811963126, -0.5513356533463394, 
    0.09188927555772322}, {-0.5152602653744724, -0.5725114059716361, 
    0.1208635190384565}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4519868652439711, -0.5423842382927654, 
    0.09039737304879422}, {-0.49876346636093416`, -0.5611088996560509, 
    0.06234543329511677}, {-0.5094822152479099, -0.5660913502754555, 
    0.06918894281144455}, {-0.4716982811963126, -0.5513356533463394, 
    0.09188927555772322}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49876346636093416`, -0.5611088996560509, 
    0.06234543329511677}, {-0.5487568617464034, -0.5810366771432506, 
    0.03227981539684726}, {-0.5493362280674016, -0.5816501238360723, 
    0.04523945407613895}, {-0.5094822152479099, -0.5660913502754555, 
    0.06918894281144455}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5487568617464034, -0.5810366771432506, 
    0.03227981539684726}, {-0.6020420732135735, -0.6020420732135735, 
    0.}, {-0.5913037838451686, -0.597947646585002, 
    0.01993158821950005}, {-0.5493362280674016, -0.5816501238360723, 
    0.04523945407613895}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.4756173846484537, -0.6115080659765835, 
    0.40767204398438894`}, {-0.48721825136857155`, -0.6176006003263583, 
    0.4185959624434206}, {-0.41445824199145676`, -0.5920832028449382, 
    0.4013008374837915}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4756173846484537, -0.6115080659765835, 
    0.40767204398438894`}, {-0.5739560409372104, -0.6457005460543618, 
    0.4304670307029078}, {-0.5660318008824062, -0.6448463554356526, 
    0.43706252979527566`}, {-0.48721825136857155`, -0.6176006003263583, 
    0.4185959624434206}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5739560409372104, -0.6457005460543618, 
    0.4304670307029078}, {-0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {-0.6524642864965196, -0.6749630549963996, 
    0.4574749594975597}, {-0.5660318008824062, -0.6448463554356526, 
    0.43706252979527566`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {-0.6409750644401281, -0.6786794799954298, 
    0.49015740221892146`}, {-0.6187258872685492, -0.670907588604451, 
    0.484544369547659}, {-0.6524642864965196, -0.6749630549963996, 
    0.4574749594975597}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6409750644401281, -0.6786794799954298, 
    0.49015740221892146`}, {-0.6001728499508097, -0.6751944561946608, 
    0.5251512437069583}, {-0.5866559059525488, -0.6683421713383466, 
    0.5123956646927323}, {-0.6187258872685492, -0.670907588604451, 
    0.484544369547659}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6001728499508097, -0.6751944561946608, 
    0.5251512437069583}, {-0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {-0.5560382810696715, -0.6672459372836057, 
    0.5412105935744802}, {-0.5866559059525488, -0.6683421713383466, 
    0.5123956646927323}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {-0.49871361404698694`, -0.6412032180604118, 
    0.49871361404698694`}, {-0.5058735949853128, -0.641248218995467, 
    0.4916236345631913}, {-0.5560382810696715, -0.6672459372836057, 
    0.5412105935744802}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49871361404698694`, -0.6412032180604118, 
    0.49871361404698694`}, {-0.4407985310247471, -0.6103364275727268, 
    0.4407985310247471}, {-0.4589425074132659, -0.6164899353312527, 
    0.4452427310725714}, {-0.5058735949853128, -0.641248218995467, 
    0.4916236345631913}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4407985310247471, -0.6103364275727268, 
    0.4407985310247471}, {-0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {-0.41445824199145676`, -0.5920832028449382, 
    0.4013008374837915}, {-0.4589425074132659, -0.6164899353312527, 
    0.4452427310725714}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {-0.6409750644401281, -0.6786794799954298, 
    0.49015740221892146`}, {-0.6468362024341406, -0.6848853908126196, 
    0.5098591242716168}, {-0.6814262655051632, -0.6890827403984796, 
    0.4823579182789357}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6409750644401281, -0.6786794799954298, 
    0.49015740221892146`}, {-0.6001728499508097, -0.6751944561946608, 
    0.5251512437069583}, {-0.614016318705615, -0.68224035411735, 
    0.5382118349147983}, {-0.6468362024341406, -0.6848853908126196, 
    0.5098591242716168}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6001728499508097, -0.6751944561946608, 
    0.5251512437069583}, {-0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {-0.5827295292403942, -0.6811124367744867, 
    0.5675936973120723}, {-0.614016318705615, -0.68224035411735, 
    0.5382118349147983}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {-0.6327645227143793, -0.7118600880536767, 
    0.6327645227143793}, {-0.6407214117452011, -0.7119126797168901, 
    0.6249011299737146}, {-0.5827295292403942, -0.6811124367744867, 
    0.5675936973120723}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6327645227143793, -0.7118600880536767, 
    0.6327645227143793}, {-0.7198653019554957, -0.7622103197175837, 
    0.7198653019554957}, {-0.7087220368790109, -0.7504115684601292, 
    0.6920462242465636}, {-0.6407214117452011, -0.7119126797168901, 
    0.6249011299737146}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7198653019554957, -0.7622103197175837, 
    0.7198653019554957}, {-0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {-0.8014503466375957, -0.8104554067121754, 
    0.7834402264884363}, {-0.7087220368790109, -0.7504115684601292, 
    0.6920462242465636}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {-0.7640699024805022, -0.7640699024805022, 
    0.6791732466493353}, {-0.7436741413969546, -0.7520300306261339, 
    0.6601152491051621}, {-0.8014503466375957, -0.8104554067121754, 
    0.7834402264884363}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7640699024805022, -0.7640699024805022, 
    0.6791732466493353}, {-0.7171888530767329, -0.7171888530767329, 
    0.5578135523930144}, {-0.7082077892481158, -0.716165180138544, 
    0.5649747532204069}, {-0.7436741413969546, -0.7520300306261339, 
    0.6601152491051621}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7171888530767329, -0.7171888530767329, 
    0.5578135523930144}, {-0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {-0.6814262655051632, -0.6890827403984796, 
    0.4823579182789357}, {-0.7082077892481158, -0.716165180138544, 
    0.5649747532204069}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {
    0.005171109167864868, -0.07756663751797302, -0.005171109167864868}, {
    0.008765155746547347, -0.11600941429253843`, -0.013921129715104607`}, {
    0.0012873487674722039`, -0.05793069453624921, -0.0038620463024166113`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.005171109167864868, -0.07756663751797302, -0.005171109167864868}, {
    0.02041142073737483, -0.15308565553031123`, -0.02041142073737483}, {
    0.02248032781181198, -0.17441633647095503`, -0.030232164988298865`}, {
    0.008765155746547347, -0.11600941429253843`, -0.013921129715104607`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.02041142073737483, -0.15308565553031123`, -0.02041142073737483}, {
    0.04495902221896904, -0.22479511109484523`, -0.04495902221896904}, {
    0.04202978289190042, -0.23065124757750236`, -0.052280949450900525`}, {
    0.02248032781181198, -0.17441633647095503`, -0.030232164988298865`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.04495902221896904, -0.22479511109484523`, -0.04495902221896904}, {
    0.07771364461602205, -0.2914261673100827, -0.07771364461602205}, {
    0.0668487308419404, -0.2837917818761621, -0.07946169892532537}, {
    0.04202978289190042, -0.23065124757750236`, -0.052280949450900525`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.07771364461602205, -0.2914261673100827, -0.07771364461602205}, {
    0.11743040006038394`, -0.35229120018115184`, -0.11743040006038394`}, {
    0.09630795334285228, -0.3333736846483348, -0.11112456154944492`}, {
    0.0668487308419404, -0.2837917818761621, -0.07946169892532537}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.11743040006038394`, -0.35229120018115184`, -0.11743040006038394`}, {
    0.09546533160684004, -0.3579949935256501, -0.14319799741026004`}, {
    0.08026080379573056, -0.3407298274347052, -0.131748866608086}, {
    0.09630795334285228, -0.3333736846483348, -0.11112456154944492`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.09546533160684004, -0.3579949935256501, -0.14319799741026004`}, {
    0.07483045886349166, -0.37415229431745833`, -0.1746044040148139}, {
    0.0647349985271792, -0.3552530406979347, -0.15631133790709126`}, {
    0.08026080379573056, -0.3407298274347052, -0.131748866608086}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.07483045886349166, -0.37415229431745833`, -0.1746044040148139}, {
    0.05311638731862741, -0.3983729048897056, -0.21246554927450964`}, {
    0.04838919502195432, -0.3754334096530939, -0.18521381542885962`}, {
    0.0647349985271792, -0.3552530406979347, -0.15631133790709126`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.05311638731862741, -0.3983729048897056, -0.21246554927450964`}, {
    0.028521062476874796`, -0.42781593715312194`, -0.2566895622918732}, {
    0.030189136362876293`, -0.39956209892042155`, -0.21842728074316375`}, {
    0.04838919502195432, -0.3754334096530939, -0.18521381542885962`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.028521062476874796`, -0.42781593715312194`, -0.2566895622918732}, {
    0., -0.45998714286871445`, -0.3066580952458096}, {
    0.009468363199652228, -0.4260763439843505, -0.2556458063906103}, {
    0.030189136362876293`, -0.39956209892042155`, -0.21842728074316375`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.45998714286871445`, -0.3066580952458096}, {
    0., -0.38905011534806727`, -0.20749339485230253`}, {
    0.008131042914707273, -0.36589693116182753`, -0.18050915270650156`}, {
    0.009468363199652228, -0.4260763439843505, -0.2556458063906103}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.38905011534806727`, -0.20749339485230253`}, {
    0., -0.30673802522798127`, -0.1226952100911925}, {
    0.006628516589374509, -0.2982832465218531, -0.11533618865511652`}, {
    0.008131042914707273, -0.36589693116182753`, -0.18050915270650156`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.30673802522798127`, -0.1226952100911925}, {
    0., -0.21282462147366246`, -0.05675323239297665}, {
    0.004963354542040988, -0.22335095439184463`, -0.06253826722971649}, {
    0.006628516589374509, -0.2982832465218531, -0.11533618865511652`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.21282462147366246`, -0.05675323239297665}, {
    0., -0.10920608786993075`, -0.014560811715990765`}, {
    0.003160550910532909, -0.142224790973981, -0.0246522971021567}, {
    0.004963354542040988, -0.22335095439184463`, -0.06253826722971649}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0., -0.10920608786993075`, -0.014560811715990765`}, {0., 0., 0.}, {
    0.0012873487674722039`, -0.05793069453624921, -0.0038620463024166113`}, {
    0.003160550910532909, -0.142224790973981, -0.0246522971021567}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.45998714286871445`, -0.3066580952458096}, {
    0.06219340349207606, -0.4664505261905705, -0.3109670174603803}, {
    0.07978930111077108, -0.4603228910236794, -0.2966525297708156}, {
    0.03004186805503801, -0.45062802082557046`, -0.29040472453203425`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.06219340349207606, -0.4664505261905705, -0.3109670174603803}, {
    0.12923159990300587`, -0.48461849963627207`, -0.3230789997575147}, {
    0.13366765457769086`, -0.4773844806346103, -0.30764777640897106`}, {
    0.07978930111077108, -0.4603228910236794, -0.2966525297708156}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.12923159990300587`, -0.48461849963627207`, -0.3230789997575147}, {
    0.20461481167731652`, -0.5115370291932914, -0.3410246861288609}, {
    0.19333151383599093`, -0.4999952944034249, -0.32221918972665153`}, {
    0.13366765457769086`, -0.4773844806346103, -0.30764777640897106`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.20461481167731652`, -0.5115370291932914, -0.3410246861288609}, {
    0.29013399227834397`, -0.5440012355218949, -0.36266749034792994`}, {
    0.25965194503259137`, -0.5263215102011988, -0.3391849732407725}, {
    0.19333151383599093`, -0.4999952944034249, -0.32221918972665153`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.29013399227834397`, -0.5440012355218949, -0.36266749034792994`}, {
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.3329657494680982, -0.5549429157801637, -0.3576298790583277}, {
    0.25965194503259137`, -0.5263215102011988, -0.3391849732407725}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.3251055239962821, -0.5418425399938036, -0.3251055239962821}, {
    0.2862137017352461, -0.5235616495156941, -0.30948310838038806`}, {
    0.3329657494680982, -0.5549429157801637, -0.3576298790583277}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3251055239962821, -0.5418425399938036, -0.3251055239962821}, {
    0.2673132787288769, -0.5012123976166442, -0.2673132787288769}, {
    0.24176935360143517`, -0.49007301405696324`, -0.2635503764484113}, {
    0.2862137017352461, -0.5235616495156941, -0.30948310838038806`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.2673132787288769, -0.5012123976166442, -0.2673132787288769}, {
    0.21311308081691166`, -0.4566708874648107, -0.21311308081691166`}, {
    0.19972264378740437`, -0.4539150995168281, -0.2198966482103745}, {
    0.24176935360143517`, -0.49007301405696324`, -0.2635503764484113}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.21311308081691166`, -0.4566708874648107, -0.21311308081691166`}, {
    0.1629042820200324, -0.40726070505008105`, -0.1629042820200324}, {
    0.1603207616432846, -0.4146226594222878, -0.1787484353953863}, {
    0.19972264378740437`, -0.4539150995168281, -0.2198966482103745}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.1629042820200324, -0.40726070505008105`, -0.1629042820200324}, {
    0.11743040006038394`, -0.35229120018115184`, -0.11743040006038394`}, {
    0.12394767411382335`, -0.37184302234147004`, -0.1404740306623331}, {
    0.1603207616432846, -0.4146226594222878, -0.1787484353953863}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.11743040006038394`, -0.35229120018115184`, -0.11743040006038394`}, {
    0.09546533160684004, -0.3579949935256501, -0.14319799741026004`}, {
    0.10580644230106709`, -0.37788015107523965`, -0.16290833179688105`}, {
    0.12394767411382335`, -0.37184302234147004`, -0.1404740306623331}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.09546533160684004, -0.3579949935256501, -0.14319799741026004`}, {
    0.07483045886349166, -0.37415229431745833`, -0.1746044040148139}, {
    0.08838155995073098, -0.38991864684146027`, -0.18889392224764073`}, {
    0.10580644230106709`, -0.37788015107523965`, -0.16290833179688105`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.07483045886349166, -0.37415229431745833`, -0.1746044040148139}, {
    0.05311638731862741, -0.3983729048897056, -0.21246554927450964`}, {
    0.07052824422808539, -0.40689371670049274`, -0.2188183987589316}, {
    0.08838155995073098, -0.38991864684146027`, -0.18889392224764073`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.05311638731862741, -0.3983729048897056, -0.21246554927450964`}, {
    0.028521062476874796`, -0.42781593715312194`, -0.2566895622918732}, {
    0.05130464075001894, -0.4275386729168246, -0.2527228599908341}, {
    0.07052824422808539, -0.40689371670049274`, -0.2188183987589316}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.028521062476874796`, -0.42781593715312194`, -0.2566895622918732}, {
    0., -0.45998714286871445`, -0.3066580952458096}, {
    0.03004186805503801, -0.45062802082557046`, -0.29040472453203425`}, {
    0.05130464075001894, -0.4275386729168246, -0.2527228599908341}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {
    0., -0.10920608786993075`, -0.014560811715990765`}, \
{-0.003160550910532909, -0.142224790973981, -0.0246522971021567}, \
{-0.0012873487674722039`, -0.05793069453624921, -0.0038620463024166113`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0., -0.10920608786993075`, -0.014560811715990765`}, {
    0., -0.21282462147366246`, -0.05675323239297665}, {-0.004963354542040988, \
-0.22335095439184463`, -0.06253826722971648}, {-0.003160550910532909, \
-0.142224790973981, -0.0246522971021567}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.21282462147366246`, -0.05675323239297665}, {
    0., -0.30673802522798127`, -0.1226952100911925}, {-0.006628516589374509, \
-0.2982832465218531, -0.11533618865511652`}, {-0.004963354542040988, \
-0.22335095439184463`, -0.06253826722971648}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.30673802522798127`, -0.1226952100911925}, {
    0., -0.38905011534806727`, -0.20749339485230253`}, \
{-0.008131042914707273, -0.36589693116182753`, -0.18050915270650156`}, \
{-0.006628516589374509, -0.2982832465218531, -0.11533618865511652`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.38905011534806727`, -0.20749339485230253`}, {
    0., -0.45998714286871445`, -0.3066580952458096}, {-0.009468363199652228, \
-0.4260763439843505, -0.2556458063906103}, {-0.008131042914707273, \
-0.36589693116182753`, -0.18050915270650156`}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{
    0., -0.45998714286871445`, -0.3066580952458096}, {-0.028521062476874796`, \
-0.42781593715312194`, -0.2566895622918732}, {-0.030189136362876293`, \
-0.39956209892042155`, -0.21842728074316375`}, {-0.009468363199652228, \
-0.4260763439843505, -0.2556458063906103}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.028521062476874796`, -0.42781593715312194`, \
-0.2566895622918732}, {-0.05311638731862741, -0.3983729048897056, \
-0.21246554927450964`}, {-0.04838919502195432, -0.3754334096530939, \
-0.18521381542885962`}, {-0.030189136362876293`, -0.39956209892042155`, \
-0.21842728074316375`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.05311638731862741, -0.3983729048897056, \
-0.21246554927450964`}, {-0.07483045886349166, -0.37415229431745833`, \
-0.1746044040148139}, {-0.0647349985271792, -0.3552530406979347, \
-0.15631133790709126`}, {-0.04838919502195432, -0.3754334096530939, \
-0.18521381542885962`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07483045886349166, -0.37415229431745833`, \
-0.1746044040148139}, {-0.09546533160684004, -0.3579949935256501, \
-0.14319799741026004`}, {-0.08026080379573056, -0.3407298274347052, \
-0.131748866608086}, {-0.0647349985271792, -0.3552530406979347, \
-0.15631133790709126`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09546533160684004, -0.3579949935256501, \
-0.14319799741026004`}, {-0.11743040006038394`, -0.35229120018115184`, \
-0.11743040006038394`}, {-0.09630795334285228, -0.3333736846483348, \
-0.11112456154944492`}, {-0.08026080379573056, -0.3407298274347052, \
-0.131748866608086}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, -0.35229120018115184`, \
-0.11743040006038394`}, {-0.07771364461602205, -0.2914261673100827, \
-0.07771364461602205}, {-0.0668487308419404, -0.2837917818761621, \
-0.07946169892532537}, {-0.09630795334285228, -0.3333736846483348, \
-0.11112456154944492`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07771364461602205, -0.2914261673100827, \
-0.07771364461602205}, {-0.04495902221896904, -0.22479511109484523`, \
-0.04495902221896904}, {-0.04202978289190042, -0.23065124757750236`, \
-0.052280949450900525`}, {-0.0668487308419404, -0.2837917818761621, \
-0.07946169892532537}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.04495902221896904, -0.22479511109484523`, \
-0.04495902221896904}, {-0.02041142073737483, -0.15308565553031123`, \
-0.02041142073737483}, {-0.02248032781181198, -0.17441633647095503`, \
-0.030232164988298865`}, {-0.04202978289190042, -0.23065124757750236`, \
-0.052280949450900525`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.02041142073737483, -0.15308565553031123`, \
-0.02041142073737483}, {-0.005171109167864868, -0.07756663751797302, \
-0.005171109167864868}, {-0.008765155746547347, -0.11600941429253843`, \
-0.013921129715104607`}, {-0.02248032781181198, -0.17441633647095503`, \
-0.030232164988298865`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.005171109167864868, -0.07756663751797302, \
-0.005171109167864868}, {0., 0., 
    0.}, {-0.0012873487674722039`, -0.05793069453624921, \
-0.0038620463024166113`}, {-0.008765155746547347, -0.11600941429253843`, \
-0.013921129715104607`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0., -0.45998714286871445`, -0.3066580952458096}, {-0.028521062476874796`, \
-0.42781593715312194`, -0.2566895622918732}, {-0.05130464075001894, \
-0.4275386729168246, -0.2527228599908341}, {-0.03004186805503801, \
-0.45062802082557046`, -0.29040472453203425`}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{-0.028521062476874796`, -0.42781593715312194`, \
-0.2566895622918732}, {-0.05311638731862741, -0.3983729048897056, \
-0.21246554927450964`}, {-0.07052824422808539, -0.40689371670049274`, \
-0.2188183987589316}, {-0.05130464075001894, -0.4275386729168246, \
-0.2527228599908341}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.05311638731862741, -0.3983729048897056, \
-0.21246554927450964`}, {-0.07483045886349166, -0.37415229431745833`, \
-0.1746044040148139}, {-0.08838155995073098, -0.38991864684146027`, \
-0.18889392224764073`}, {-0.07052824422808539, -0.40689371670049274`, \
-0.2188183987589316}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07483045886349166, -0.37415229431745833`, \
-0.1746044040148139}, {-0.09546533160684004, -0.3579949935256501, \
-0.14319799741026004`}, {-0.10580644230106709`, -0.37788015107523965`, \
-0.16290833179688105`}, {-0.08838155995073098, -0.38991864684146027`, \
-0.18889392224764073`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09546533160684004, -0.3579949935256501, \
-0.14319799741026004`}, {-0.11743040006038394`, -0.35229120018115184`, \
-0.11743040006038394`}, {-0.12394767411382335`, -0.37184302234147004`, \
-0.1404740306623331}, {-0.10580644230106709`, -0.37788015107523965`, \
-0.16290833179688105`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, -0.35229120018115184`, \
-0.11743040006038394`}, {-0.1629042820200324, -0.40726070505008105`, \
-0.1629042820200324}, {-0.1603207616432846, -0.4146226594222878, \
-0.1787484353953863}, {-0.12394767411382335`, -0.37184302234147004`, \
-0.1404740306623331}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1629042820200324, -0.40726070505008105`, \
-0.1629042820200324}, {-0.21311308081691166`, -0.4566708874648107, \
-0.21311308081691166`}, {-0.19972264378740437`, -0.4539150995168281, \
-0.2198966482103745}, {-0.1603207616432846, -0.4146226594222878, \
-0.1787484353953863}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21311308081691166`, -0.4566708874648107, \
-0.21311308081691166`}, {-0.2673132787288769, -0.5012123976166442, \
-0.2673132787288769}, {-0.24176935360143517`, -0.49007301405696324`, \
-0.2635503764484113}, {-0.19972264378740437`, -0.4539150995168281, \
-0.2198966482103745}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2673132787288769, -0.5012123976166442, \
-0.2673132787288769}, {-0.3251055239962821, -0.5418425399938036, \
-0.3251055239962821}, {-0.2862137017352461, -0.5235616495156941, \
-0.30948310838038806`}, {-0.24176935360143517`, -0.49007301405696324`, \
-0.2635503764484113}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3251055239962821, -0.5418425399938036, \
-0.3251055239962821}, {-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.3329657494680982, -0.5549429157801637, \
-0.3576298790583277}, {-0.2862137017352461, -0.5235616495156941, \
-0.30948310838038806`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.29013399227834397`, -0.5440012355218949, \
-0.36266749034792994`}, {-0.25965194503259137`, -0.5263215102011988, \
-0.3391849732407725}, {-0.3329657494680982, -0.5549429157801637, \
-0.3576298790583277}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.29013399227834397`, -0.5440012355218949, \
-0.36266749034792994`}, {-0.20461481167731652`, -0.5115370291932914, \
-0.3410246861288609}, {-0.19333151383599093`, -0.4999952944034249, \
-0.32221918972665153`}, {-0.25965194503259137`, -0.5263215102011988, \
-0.3391849732407725}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20461481167731652`, -0.5115370291932914, \
-0.3410246861288609}, {-0.12923159990300587`, -0.48461849963627207`, \
-0.3230789997575147}, {-0.1336676545776909, -0.4773844806346103, \
-0.30764777640897106`}, {-0.19333151383599093`, -0.4999952944034249, \
-0.32221918972665153`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.12923159990300587`, -0.48461849963627207`, \
-0.3230789997575147}, {-0.06219340349207606, -0.4664505261905705, \
-0.3109670174603803}, {-0.07978930111077108, -0.4603228910236794, \
-0.2966525297708156}, {-0.1336676545776909, -0.4773844806346103, \
-0.30764777640897106`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06219340349207606, -0.4664505261905705, \
-0.3109670174603803}, {
    0., -0.45998714286871445`, -0.3066580952458096}, {-0.03004186805503801, \
-0.45062802082557046`, -0.29040472453203425`}, {-0.07978930111077108, \
-0.4603228910236794, -0.2966525297708156}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.4407985310247471, -0.6103364275727268, -0.4407985310247471}, {
    0.4452427310725714, -0.6164899353312527, -0.4589425074132659}, {
    0.4013008374837915, -0.5920832028449382, -0.41445824199145676`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4407985310247471, -0.6103364275727268, -0.4407985310247471}, {
    0.49871361404698694`, -0.6412032180604118, -0.49871361404698694`}, {
    0.4916236345631913, -0.641248218995467, -0.5058735949853128}, {
    0.4452427310725714, -0.6164899353312527, -0.4589425074132659}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.49871361404698694`, -0.6412032180604118, -0.49871361404698694`}, {
    0.5616987892757247, -0.6740385471308696, -0.5616987892757247}, {
    0.5412105935744802, -0.6672459372836057, -0.5560382810696715}, {
    0.4916236345631913, -0.641248218995467, -0.5058735949853128}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5616987892757247, -0.6740385471308696, -0.5616987892757247}, {
    0.5251512437069583, -0.6751944561946608, -0.6001728499508097}, {
    0.5123956646927323, -0.6683421713383466, -0.5866559059525488}, {
    0.5412105935744802, -0.6672459372836057, -0.5560382810696715}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5251512437069583, -0.6751944561946608, -0.6001728499508097}, {
    0.49015740221892146`, -0.6786794799954298, -0.6409750644401281}, {
    0.484544369547659, -0.670907588604451, -0.6187258872685492}, {
    0.5123956646927323, -0.6683421713383466, -0.5866559059525488}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.49015740221892146`, -0.6786794799954298, -0.6409750644401281}, {
    0.4563691391047108, -0.6845537086570662, -0.6845537086570662}, {
    0.4574749594975597, -0.6749630549963996, -0.6524642864965196}, {
    0.484544369547659, -0.670907588604451, -0.6187258872685492}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4563691391047108, -0.6845537086570662, -0.6845537086570662}, {
    0.4304670307029078, -0.6457005460543618, -0.5739560409372104}, {
    0.43706252979527566`, -0.6448463554356526, -0.5660318008824062}, {
    0.4574749594975597, -0.6749630549963996, -0.6524642864965196}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4304670307029078, -0.6457005460543618, -0.5739560409372104}, {
    0.40767204398438894`, -0.6115080659765835, -0.4756173846484537}, {
    0.4185959624434206, -0.6176006003263583, -0.48721825136857155`}, {
    0.43706252979527566`, -0.6448463554356526, -0.5660318008824062}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.40767204398438894`, -0.6115080659765835, -0.4756173846484537}, {
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.4013008374837915, -0.5920832028449382, -0.41445824199145676`}, {
    0.4185959624434206, -0.6176006003263583, -0.48721825136857155`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4563691391047108, -0.6845537086570662, -0.6845537086570662}, {
    0.5578135523930144, -0.7171888530767329, -0.7171888530767329}, {
    0.5649747532204069, -0.716165180138544, -0.7082077892481158}, {
    0.48235791827893554`, -0.6890827403984794, -0.6814262655051629}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5578135523930144, -0.7171888530767329, -0.7171888530767329}, {
    0.6791732466493353, -0.7640699024805022, -0.7640699024805022}, {
    0.6601152491051621, -0.7520300306261339, -0.7436741413969546}, {
    0.5649747532204069, -0.716165180138544, -0.7082077892481158}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6791732466493353, -0.7640699024805022, -0.7640699024805022}, {
    0.9068996821171088, -0.9068996821171088, -0.9068996821171088}, {
    0.7834402264884363, -0.8104554067121754, -0.8014503466375957}, {
    0.6601152491051621, -0.7520300306261339, -0.7436741413969546}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.9068996821171088, -0.9068996821171088, -0.9068996821171088}, {
    0.7198653019554957, -0.7622103197175837, -0.7198653019554957}, {
    0.6920462242465636, -0.7504115684601292, -0.7087220368790109}, {
    0.7834402264884363, -0.8104554067121754, -0.8014503466375957}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.7198653019554957, -0.7622103197175837, -0.7198653019554957}, {
    0.6327645227143793, -0.7118600880536767, -0.6327645227143793}, {
    0.6249011299737146, -0.7119126797168901, -0.6407214117452011}, {
    0.6920462242465636, -0.7504115684601292, -0.7087220368790109}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6327645227143793, -0.7118600880536767, -0.6327645227143793}, {
    0.5616987892757247, -0.6740385471308696, -0.5616987892757247}, {
    0.5675936973120723, -0.6811124367744867, -0.5827295292403942}, {
    0.6249011299737146, -0.7119126797168901, -0.6407214117452011}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5616987892757247, -0.6740385471308696, -0.5616987892757247}, {
    0.5251512437069583, -0.6751944561946608, -0.6001728499508097}, {
    0.5382118349147983, -0.68224035411735, -0.614016318705615}, {
    0.5675936973120723, -0.6811124367744867, -0.5827295292403942}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5251512437069583, -0.6751944561946608, -0.6001728499508097}, {
    0.49015740221892146`, -0.6786794799954298, -0.6409750644401281}, {
    0.5098591242716168, -0.6848853908126196, -0.6468362024341406}, {
    0.5382118349147983, -0.68224035411735, -0.614016318705615}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.49015740221892146`, -0.6786794799954298, -0.6409750644401281}, {
    0.4563691391047108, -0.6845537086570662, -0.6845537086570662}, {
    0.48235791827893554`, -0.6890827403984794, -0.6814262655051629}, {
    0.5098591242716168, -0.6848853908126196, -0.6468362024341406}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.45998714286871445`, -0.3066580952458096}, {
    0.038544848628222717`, -0.46253818353867265`, -0.30835878902578173`}, {
    0.052786379282336135`, -0.47507741354102534`, -0.3272755515504841}, {
    0.020955630116874954`, -0.47150167762968676`, -0.324812266811562}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.038544848628222717`, -0.46253818353867265`, -0.30835878902578173`}, {
    0.07833195316248512, -0.46999171897491077`, -0.3133278126499405}, {
    0.08560802621248467, -0.48154514744522636`, -0.33173110157337815`}, {
    0.052786379282336135`, -0.47507741354102534`, -0.3272755515504841}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.07833195316248512, -0.46999171897491077`, -0.3133278126499405}, {
    0.12044994043743079`, -0.4817997617497233, -0.32119984116648215`}, {
    0.11992963743797559`, -0.4906212440644457, -0.3379835236888404}, {
    0.08560802621248467, -0.48154514744522636`, -0.33173110157337815`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.12044994043743079`, -0.4817997617497233, -0.32119984116648215`}, {
    0.1657318525960958, -0.4971955577882874, -0.3314637051921916}, {
    0.1561613637329016, -0.5019472405700409, -0.3457858768371393}, {
    0.11992963743797559`, -0.4906212440644457, -0.3379835236888404}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.1657318525960958, -0.4971955577882874, -0.3314637051921916}, {
    0.176735752448586, -0.530207257345758, -0.39765544300931854`}, {
    0.16447360317195706`, -0.5286651530527192, -0.3994358934176101}, {
    0.1561613637329016, -0.5019472405700409, -0.3457858768371393}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.176735752448586, -0.530207257345758, -0.39765544300931854`}, {
    0.18726648266764945`, -0.5617994480029483, -0.4681662066691236}, {
    0.17247195529467113`, -0.5543741420185859, -0.4558187389930595}, {
    0.16447360317195706`, -0.5286651530527192, -0.3994358934176101}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.18726648266764945`, -0.5617994480029483, -0.4681662066691236}, {
    0.19749453248903248`, -0.5924835974670974, -0.5431099643448393}, {
    0.18023995030369647`, -0.5793426974047388, -0.5149712865819899}, {
    0.17247195529467113`, -0.5543741420185859, -0.4558187389930595}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.19749453248903248`, -0.5924835974670974, -0.5431099643448393}, {
    0.20769184264312943`, -0.6230755279293883, -0.6230755279293883}, {
    0.18789655708653166`, -0.6039532192067091, -0.577110853908633}, {
    0.18023995030369647`, -0.5793426974047388, -0.5149712865819899}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.20769184264312943`, -0.6230755279293883, -0.6230755279293883}, {
    0.14565785306317142`, -0.5826314122526858, -0.5340787945649619}, {
    0.13970138965108453`, -0.571505684936255, -0.508005053276671}, {
    0.18789655708653166`, -0.6039532192067091, -0.577110853908633}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.14565785306317142`, -0.5826314122526858, -0.5340787945649619}, {
    0.09039737304879422, -0.5423842382927654, -0.4519868652439711}, {
    0.09578808133406011, -0.5388079575040883, -0.4430198761700281}, {
    0.13970138965108453`, -0.571505684936255, -0.508005053276671}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.09039737304879422, -0.5423842382927654, -0.4519868652439711}, {
    0.041781498251368454`, -0.5013779790164213, -0.37603348426231603`}, {
    0.05615961056021798, -0.5054364950419619, -0.38188535180948235`}, {
    0.09578808133406011, -0.5388079575040883, -0.4430198761700281}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.041781498251368454`, -0.5013779790164213, -0.37603348426231603`}, {
    0., -0.45998714286871445`, -0.3066580952458096}, {
    0.020955630116874954`, -0.47150167762968676`, -0.324812266811562}, {
    0.05615961056021798, -0.5054364950419619, -0.38188535180948235`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.45998714286871445`, -0.3066580952458096}, {
    0.02708690739129757, -0.4875643330433564, -0.3521297960868685}, {
    0.027651165009234, -0.4977209701662121, -0.37052561112373567`}, {
    0.005290785729710824, -0.47617071567397445`, -0.33331950097178215`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.02708690739129757, -0.4875643330433564, -0.3521297960868685}, {
    0.057237380507313335`, -0.5151364245658201, -0.4006616635511933}, {
    0.05192776126127516, -0.5192776126127516, -0.4096523388389484}, {
    0.027651165009234, -0.4977209701662121, -0.37052561112373567`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.057237380507313335`, -0.5151364245658201, -0.4006616635511933}, {
    0.09039737304879422, -0.5423842382927654, -0.4519868652439711}, {
    0.07810031047988147, -0.5406944571684102, -0.45057871430700847`}, {
    0.05192776126127516, -0.5192776126127516, -0.4096523388389484}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.09039737304879422, -0.5423842382927654, -0.4519868652439711}, {
    0.06234543329511677, -0.5611088996560509, -0.49876346636093416`}, {
    0.055613276850190324`, -0.5561327685019032, -0.48816098568500393`}, {
    0.07810031047988147, -0.5406944571684102, -0.45057871430700847`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.06234543329511677, -0.5611088996560509, -0.49876346636093416`}, {
    0.03227981539684726, -0.5810366771432506, -0.5487568617464034}, {
    0.03179444453423547, -0.5723000016162385, -0.5277877792683088}, {
    0.055613276850190324`, -0.5561327685019032, -0.48816098568500393`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.03227981539684726, -0.5810366771432506, -0.5487568617464034}, {
    0., -0.6020420732135735, -0.6020420732135735}, {
    0.006545673176541602, -0.5891105858887445, -0.5694735663591197}, {
    0.03179444453423547, -0.5723000016162385, -0.5277877792683088}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.6020420732135735, -0.6020420732135735}, {
    0., -0.5583263670978953, -0.49629010408701807`}, {
    0.006154011462866676, -0.5538610316580012, -0.4861669055664677}, {
    0.006545673176541602, -0.5891105858887445, -0.5694735663591197}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.5583263670978953, -0.49629010408701807`}, {
    0., -0.5116766815928779, -0.3979707523500161}, {
    0.005739686383923255, -0.5165717745530933, -0.40751773325855134`}, {
    0.006154011462866676, -0.5538610316580012, -0.4861669055664677}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.5116766815928779, -0.3979707523500161}, {
    0., -0.45998714286871445`, -0.3066580952458096}, {
    0.005290785729710824, -0.47617071567397445`, -0.33331950097178215`}, {
    0.005739686383923255, -0.5165717745530933, -0.40751773325855134`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.6020420732135735, -0.6020420732135735}, {
    0.06715883546475819, -0.6044295191828238, -0.6044295191828238}, {
    0.0734128220308756, -0.6006503620708005, -0.5939764691589027}, {
    0.01993158821950005, -0.597947646585002, -0.5913037838451686}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.06715883546475819, -0.6044295191828238, -0.6044295191828238}, {
    0.13589068132812965`, -0.6115080659765835, -0.6115080659765835}, {
    0.12801278465860869`, -0.6063763483828833, -0.5996388334008513}, {
    0.0734128220308756, -0.6006503620708005, -0.5939764691589027}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.13589068132812965`, -0.6115080659765835, -0.6115080659765835}, {
    0.20769184264312943`, -0.6230755279293883, -0.6230755279293883}, {
    0.1845016009799007, -0.615005336599669, -0.6081719439707838}, {
    0.12801278465860869`, -0.6063763483828833, -0.5996388334008513}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.20769184264312943`, -0.6230755279293883, -0.6230755279293883}, {
    0.16555673570625662`, -0.5960042485425239, -0.5628929014012725}, {
    0.15171241243773156`, -0.5936572660606888, -0.560676306835095}, {
    0.1845016009799007, -0.615005336599669, -0.6081719439707838}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.16555673570625662`, -0.5960042485425239, -0.5628929014012725}, {
    0.12650407746706638`, -0.5692683486017988, -0.5060163098682655}, {
    0.12086351903845649`, -0.572511405971636, -0.5152602653744724}, {
    0.15171241243773156`, -0.5936572660606888, -0.560676306835095}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.12650407746706638`, -0.5692683486017988, -0.5060163098682655}, {
    0.09039737304879422, -0.5423842382927654, -0.4519868652439711}, {
    0.09188927555772322, -0.5513356533463394, -0.4716982811963126}, {
    0.12086351903845649`, -0.572511405971636, -0.5152602653744724}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.09039737304879422, -0.5423842382927654, -0.4519868652439711}, {
    0.06234543329511677, -0.5611088996560509, -0.49876346636093416`}, {
    0.06918894281144454, -0.5660913502754553, -0.5094822152479098}, {
    0.09188927555772322, -0.5513356533463394, -0.4716982811963126}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.06234543329511677, -0.5611088996560509, -0.49876346636093416`}, {
    0.03227981539684726, -0.5810366771432506, -0.5487568617464034}, {
    0.04523945407613895, -0.5816501238360723, -0.5493362280674016}, {
    0.06918894281144454, -0.5660913502754553, -0.5094822152479098}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.03227981539684726, -0.5810366771432506, -0.5487568617464034}, {
    0., -0.6020420732135735, -0.6020420732135735}, {
    0.01993158821950005, -0.597947646585002, -0.5913037838451686}, {
    0.04523945407613895, -0.5816501238360723, -0.5493362280674016}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.32497414755462956`, -0.5570985386650793, -0.3713990257767195}, {
    0.30930754461094684`, -0.5567535802997043, -0.3835413553175741}, {
    0.35717979235010267`, -0.5740389519912366, -0.39544905581618517`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.32497414755462956`, -0.5570985386650793, -0.3713990257767195}, {
    0.26775615427580557`, -0.5355123085516112, -0.35700820570107417`}, {
    0.26413196393268323`, -0.540269926225943, -0.37218594917787184`}, {
    0.30930754461094684`, -0.5567535802997043, -0.3835413553175741}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.26775615427580557`, -0.5355123085516112, -0.35700820570107417`}, {
    0.21472944721406304`, -0.5153506733137513, -0.34356711554250086`}, {
    0.22157332212441513`, -0.5247789208209833, -0.3615143676766774}, {
    0.26413196393268323`, -0.540269926225943, -0.37218594917787184`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.21472944721406304`, -0.5153506733137513, -0.34356711554250086`}, {
    0.1657318525960958, -0.4971955577882874, -0.3314637051921916}, {
    0.18153126854126964`, -0.510556692772321, -0.35171683279870997`}, {
    0.22157332212441513`, -0.5247789208209833, -0.3615143676766774}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.1657318525960958, -0.4971955577882874, -0.3314637051921916}, {
    0.176735752448586, -0.530207257345758, -0.39765544300931854`}, {
    0.1906578017409655, -0.5362250673964656, -0.4051478286995518}, {
    0.18153126854126964`, -0.510556692772321, -0.35171683279870997`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.176735752448586, -0.530207257345758, -0.39765544300931854`}, {
    0.18726648266764945`, -0.5617994480029483, -0.4681662066691236}, {
    0.19950538654437358`, -0.5611088996560508, -0.461356206383864}, {
    0.1906578017409655, -0.5362250673964656, -0.4051478286995518}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.18726648266764945`, -0.5617994480029483, -0.4681662066691236}, {
    0.19749453248903248`, -0.5924835974670974, -0.5431099643448393}, {
    0.20816159484924335`, -0.5854544855134971, -0.5204039871231084}, {
    0.19950538654437358`, -0.5611088996560508, -0.461356206383864}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.19749453248903248`, -0.5924835974670974, -0.5431099643448393}, {
    0.20769184264312943`, -0.6230755279293883, -0.6230755279293883}, {
    0.21675802958570295`, -0.6096319582097897, -0.5825372045115768}, {
    0.20816159484924335`, -0.5854544855134971, -0.5204039871231084}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.20769184264312943`, -0.6230755279293883, -0.6230755279293883}, {
    0.251969546341623, -0.6047269112198952, -0.5543330019515705}, {
    0.2515845081118029, -0.5958580455279544, -0.5296515960248482}, {
    0.21675802958570295`, -0.6096319582097897, -0.5825372045115768}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.251969546341623, -0.6047269112198952, -0.5543330019515705}, {
    0.29554773118396116`, -0.5910954623679224, -0.4925795519732687}, {
    0.2860742984158683, -0.585151974032458, -0.4811249564266876}, {
    0.2515845081118029, -0.5958580455279544, -0.5296515960248482}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.29554773118396116`, -0.5910954623679224, -0.4925795519732687}, {
    0.3398683238140667, -0.5826314122526858, -0.43697355918951436`}, {
    0.32099644718097237`, -0.5777936049257504, -0.4365551681661225}, {
    0.2860742984158683, -0.585151974032458, -0.4811249564266876}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3398683238140667, -0.5826314122526858, -0.43697355918951436`}, {
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.35717979235010267`, -0.5740389519912366, -0.39544905581618517`}, {
    0.32099644718097237`, -0.5777936049257504, -0.4365551681661225}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.3550779693653198, -0.5810366771432506, -0.41963760015901436`}, {
    0.3591582529035913, -0.5877135047513313, -0.4375200535371022}, {
    0.38422691935919384`, -0.5861088600394483, -0.41027620202761383`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3550779693653198, -0.5810366771432506, -0.41963760015901436`}, {
    0.32491619395345206`, -0.5848491491162138, -0.45488267153483286`}, {
    0.33484194093648584`, -0.5908975428290927, -0.46615250600961755`}, {
    0.3591582529035913, -0.5877135047513313, -0.4375200535371022}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.32491619395345206`, -0.5848491491162138, -0.45488267153483286`}, {
    0.2955477311839612, -0.5910954623679224, -0.4925795519732687}, {
    0.31104298811316416`, -0.595614232557123, -0.49634519379760245`}, {
    0.33484194093648584`, -0.5908975428290927, -0.46615250600961755`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.2955477311839612, -0.5910954623679224, -0.4925795519732687}, {
    0.34487850812687415`, -0.6207813146283735, -0.5518056130029987}, {
    0.3510197768048997, -0.6194466649498231, -0.5437365170115114}, {
    0.31104298811316416`, -0.595614232557123, -0.49634519379760245`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.34487850812687415`, -0.6207813146283735, -0.5518056130029987}, {
    0.39802947182437354`, -0.6513209538944295, -0.6151364564558499}, {
    0.3934133114373311, -0.643767236897451, -0.593696451805427}, {
    0.3510197768048997, -0.6194466649498231, -0.5437365170115114}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.39802947182437354`, -0.6513209538944295, -0.6151364564558499}, {
    0.4563691391047108, -0.6845537086570662, -0.6845537086570662}, {
    0.43885530547477725`, -0.6694402964869484, -0.6471256199373834}, {
    0.3934133114373311, -0.643767236897451, -0.593696451805427}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4563691391047108, -0.6845537086570662, -0.6845537086570662}, {
    0.4304670307029078, -0.6457005460543618, -0.5739560409372104}, {
    0.41919337488646585`, -0.639447521013253, -0.5612928240005222}, {
    0.43885530547477725`, -0.6694402964869484, -0.6471256199373834}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4304670307029078, -0.6457005460543618, -0.5739560409372104}, {
    0.40767204398438894`, -0.6115080659765835, -0.4756173846484537}, {
    0.4012148338270782, -0.6120226278718142, -0.4828178508766534}, {
    0.41919337488646585`, -0.639447521013253, -0.5612928240005222}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.40767204398438894`, -0.6115080659765835, -0.4756173846484537}, {
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.38422691935919384`, -0.5861088600394483, -0.41027620202761383`}, {
    0.4012148338270782, -0.6120226278718142, -0.4828178508766534}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4563691391047108, -0.6845537086570662, -0.6845537086570662}, {
    0.3662276185282054, -0.6592097133507697, -0.6592097133507697}, {
    0.35549008961826795`, -0.6529409809315125, -0.6456860811433847}, {
    0.4257232357078877, -0.6721945826966649, -0.6647257540000353}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3662276185282054, -0.6592097133507697, -0.6592097133507697}, {
    0.2839786944782409, -0.6389520625760421, -0.6389520625760421}, {
    0.2900719574991448, -0.6367433213395861, -0.629668395546924}, {
    0.35549008961826795`, -0.6529409809315125, -0.6456860811433847}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.2839786944782409, -0.6389520625760421, -0.6389520625760421}, {
    0.20769184264312943`, -0.6230755279293883, -0.6230755279293883}, {
    0.22854498053961364`, -0.6233044923807646, -0.6163788869098672}, {
    0.2900719574991448, -0.6367433213395861, -0.629668395546924}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.20769184264312943`, -0.6230755279293883, -0.6230755279293883}, {
    0.23735305516717142`, -0.6103364275727265, -0.5764288482631306}, {
    0.25229999183570073`, -0.6137026828435964, -0.5796080893522855}, {
    0.22854498053961364`, -0.6233044923807646, -0.6163788869098672}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.23735305516717142`, -0.6103364275727265, -0.5764288482631306}, {
    0.2665063311720162, -0.5996392451370365, -0.5330126623440324}, {
    0.2758060279446175, -0.605427866219892, -0.5448850795979028}, {
    0.25229999183570073`, -0.6137026828435964, -0.5796080893522855}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.2665063311720162, -0.5996392451370365, -0.5330126623440324}, {
    0.2955477311839612, -0.5910954623679224, -0.4925795519732687}, {
    0.29926426963948155`, -0.5985285392789631, -0.5120744169386685}, {
    0.2758060279446175, -0.605427866219892, -0.5448850795979028}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.2955477311839612, -0.5910954623679224, -0.4925795519732687}, {
    0.34487850812687415`, -0.6207813146283735, -0.5518056130029987}, {
    0.33875590314851456`, -0.6222047200687002, -0.5599842480618302}, {
    0.29926426963948155`, -0.5985285392789631, -0.5120744169386685}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.34487850812687415`, -0.6207813146283735, -0.5518056130029987}, {
    0.39802947182437354`, -0.6513209538944295, -0.6151364564558499}, {
    0.3806959241330279, -0.6464647768296701, -0.6105500670057994}, {
    0.33875590314851456`, -0.6222047200687002, -0.5599842480618302}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.39802947182437354`, -0.6513209538944295, -0.6151364564558499}, {
    0.4563691391047108, -0.6845537086570662, -0.6845537086570662}, {
    0.4257232357078877, -0.6721945826966649, -0.6647257540000353}, {
    0.3806959241330279, -0.6464647768296701, -0.6105500670057994}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.32497414755462956`, -0.5570985386650793, \
-0.3713990257767195}, {-0.30930754461094684`, -0.5567535802997043, \
-0.3835413553175741}, {-0.35717979235010267`, -0.5740389519912366, \
-0.39544905581618517`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.32497414755462956`, -0.5570985386650793, \
-0.3713990257767195}, {-0.26775615427580557`, -0.5355123085516112, \
-0.35700820570107417`}, {-0.26413196393268323`, -0.540269926225943, \
-0.37218594917787184`}, {-0.30930754461094684`, -0.5567535802997043, \
-0.3835413553175741}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.26775615427580557`, -0.5355123085516112, \
-0.35700820570107417`}, {-0.21472944721406304`, -0.5153506733137513, \
-0.34356711554250086`}, {-0.22157332212441513`, -0.5247789208209833, \
-0.3615143676766774}, {-0.26413196393268323`, -0.540269926225943, \
-0.37218594917787184`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21472944721406304`, -0.5153506733137513, \
-0.34356711554250086`}, {-0.1657318525960958, -0.4971955577882874, \
-0.3314637051921916}, {-0.18153126854126964`, -0.510556692772321, \
-0.35171683279870997`}, {-0.22157332212441513`, -0.5247789208209833, \
-0.3615143676766774}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1657318525960958, -0.4971955577882874, \
-0.3314637051921916}, {-0.176735752448586, -0.530207257345758, \
-0.39765544300931854`}, {-0.1906578017409655, -0.5362250673964656, \
-0.4051478286995518}, {-0.18153126854126964`, -0.510556692772321, \
-0.35171683279870997`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.176735752448586, -0.530207257345758, \
-0.39765544300931854`}, {-0.18726648266764945`, -0.5617994480029483, \
-0.4681662066691236}, {-0.19950538654437358`, -0.5611088996560508, \
-0.461356206383864}, {-0.1906578017409655, -0.5362250673964656, \
-0.4051478286995518}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.18726648266764945`, -0.5617994480029483, \
-0.4681662066691236}, {-0.19749453248903248`, -0.5924835974670974, \
-0.5431099643448393}, {-0.20816159484924335`, -0.5854544855134971, \
-0.5204039871231084}, {-0.19950538654437358`, -0.5611088996560508, \
-0.461356206383864}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.19749453248903248`, -0.5924835974670974, \
-0.5431099643448393}, {-0.20769184264312943`, -0.6230755279293883, \
-0.6230755279293883}, {-0.21675802958570295`, -0.6096319582097897, \
-0.5825372045115768}, {-0.20816159484924335`, -0.5854544855134971, \
-0.5204039871231084}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, -0.6230755279293883, \
-0.6230755279293883}, {-0.251969546341623, -0.6047269112198952, \
-0.5543330019515705}, {-0.2515845081118029, -0.5958580455279544, \
-0.5296515960248482}, {-0.21675802958570295`, -0.6096319582097897, \
-0.5825372045115768}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.251969546341623, -0.6047269112198952, \
-0.5543330019515705}, {-0.29554773118396116`, -0.5910954623679224, \
-0.4925795519732687}, {-0.2860742984158683, -0.585151974032458, \
-0.4811249564266876}, {-0.2515845081118029, -0.5958580455279544, \
-0.5296515960248482}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.29554773118396116`, -0.5910954623679224, \
-0.4925795519732687}, {-0.3398683238140667, -0.5826314122526858, \
-0.43697355918951436`}, {-0.32099644718097237`, -0.5777936049257504, \
-0.4365551681661225}, {-0.2860742984158683, -0.585151974032458, \
-0.4811249564266876}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3398683238140667, -0.5826314122526858, \
-0.43697355918951436`}, {-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.35717979235010267`, -0.5740389519912366, \
-0.39544905581618517`}, {-0.32099644718097237`, -0.5777936049257504, \
-0.4365551681661225}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.3550779693653198, -0.5810366771432506, \
-0.41963760015901436`}, {-0.3591582529035913, -0.5877135047513313, \
-0.4375200535371022}, {-0.38422691935919384`, -0.5861088600394483, \
-0.41027620202761383`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3550779693653198, -0.5810366771432506, \
-0.41963760015901436`}, {-0.32491619395345206`, -0.5848491491162138, \
-0.45488267153483286`}, {-0.33484194093648584`, -0.5908975428290927, \
-0.46615250600961755`}, {-0.3591582529035913, -0.5877135047513313, \
-0.4375200535371022}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.32491619395345206`, -0.5848491491162138, \
-0.45488267153483286`}, {-0.2955477311839612, -0.5910954623679224, \
-0.4925795519732687}, {-0.31104298811316416`, -0.595614232557123, \
-0.49634519379760245`}, {-0.33484194093648584`, -0.5908975428290927, \
-0.46615250600961755`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2955477311839612, -0.5910954623679224, \
-0.4925795519732687}, {-0.34487850812687415`, -0.6207813146283735, \
-0.5518056130029987}, {-0.3510197768048997, -0.6194466649498231, \
-0.5437365170115114}, {-0.31104298811316416`, -0.595614232557123, \
-0.49634519379760245`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.34487850812687415`, -0.6207813146283735, \
-0.5518056130029987}, {-0.39802947182437354`, -0.6513209538944295, \
-0.6151364564558499}, {-0.3934133114373311, -0.643767236897451, \
-0.593696451805427}, {-0.3510197768048997, -0.6194466649498231, \
-0.5437365170115114}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.39802947182437354`, -0.6513209538944295, \
-0.6151364564558499}, {-0.4563691391047108, -0.6845537086570662, \
-0.6845537086570662}, {-0.43885530547477725`, -0.6694402964869484, \
-0.6471256199373834}, {-0.3934133114373311, -0.643767236897451, \
-0.593696451805427}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, -0.6845537086570662, \
-0.6845537086570662}, {-0.4304670307029078, -0.6457005460543618, \
-0.5739560409372104}, {-0.41919337488646585`, -0.639447521013253, \
-0.5612928240005222}, {-0.43885530547477725`, -0.6694402964869484, \
-0.6471256199373834}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4304670307029078, -0.6457005460543618, \
-0.5739560409372104}, {-0.40767204398438894`, -0.6115080659765835, \
-0.4756173846484537}, {-0.4012148338270782, -0.6120226278718142, \
-0.4828178508766534}, {-0.41919337488646585`, -0.639447521013253, \
-0.5612928240005222}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.40767204398438894`, -0.6115080659765835, \
-0.4756173846484537}, {-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.38422691935919384`, -0.5861088600394483, \
-0.41027620202761383`}, {-0.4012148338270782, -0.6120226278718142, \
-0.4828178508766534}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, -0.6845537086570662, \
-0.6845537086570662}, {-0.3662276185282054, -0.6592097133507697, \
-0.6592097133507697}, {-0.35549008961826795`, -0.6529409809315125, \
-0.6456860811433847}, {-0.4257232357078877, -0.6721945826966649, \
-0.6647257540000353}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3662276185282054, -0.6592097133507697, \
-0.6592097133507697}, {-0.2839786944782409, -0.6389520625760421, \
-0.6389520625760421}, {-0.2900719574991448, -0.6367433213395861, \
-0.629668395546924}, {-0.35549008961826795`, -0.6529409809315125, \
-0.6456860811433847}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2839786944782409, -0.6389520625760421, \
-0.6389520625760421}, {-0.20769184264312943`, -0.6230755279293883, \
-0.6230755279293883}, {-0.22854498053961364`, -0.6233044923807646, \
-0.6163788869098672}, {-0.2900719574991448, -0.6367433213395861, \
-0.629668395546924}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, -0.6230755279293883, \
-0.6230755279293883}, {-0.23735305516717142`, -0.6103364275727265, \
-0.5764288482631306}, {-0.25229999183570073`, -0.6137026828435964, \
-0.5796080893522855}, {-0.22854498053961364`, -0.6233044923807646, \
-0.6163788869098672}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.23735305516717142`, -0.6103364275727265, \
-0.5764288482631306}, {-0.2665063311720162, -0.5996392451370365, \
-0.5330126623440324}, {-0.2758060279446175, -0.605427866219892, \
-0.5448850795979028}, {-0.25229999183570073`, -0.6137026828435964, \
-0.5796080893522855}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2665063311720162, -0.5996392451370365, \
-0.5330126623440324}, {-0.2955477311839612, -0.5910954623679224, \
-0.4925795519732687}, {-0.29926426963948155`, -0.5985285392789631, \
-0.5120744169386685}, {-0.2758060279446175, -0.605427866219892, \
-0.5448850795979028}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2955477311839612, -0.5910954623679224, \
-0.4925795519732687}, {-0.34487850812687415`, -0.6207813146283735, \
-0.5518056130029987}, {-0.33875590314851456`, -0.6222047200687002, \
-0.5599842480618302}, {-0.29926426963948155`, -0.5985285392789631, \
-0.5120744169386685}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.34487850812687415`, -0.6207813146283735, \
-0.5518056130029987}, {-0.39802947182437354`, -0.6513209538944295, \
-0.6151364564558499}, {-0.3806959241330279, -0.6464647768296701, \
-0.6105500670057994}, {-0.33875590314851456`, -0.6222047200687002, \
-0.5599842480618302}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.39802947182437354`, -0.6513209538944295, \
-0.6151364564558499}, {-0.4563691391047108, -0.6845537086570662, \
-0.6845537086570662}, {-0.4257232357078877, -0.6721945826966649, \
-0.6647257540000353}, {-0.3806959241330279, -0.6464647768296701, \
-0.6105500670057994}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0., -0.45998714286871445`, -0.3066580952458096}, {-0.038544848628222717`, \
-0.46253818353867265`, -0.30835878902578173`}, {-0.052786379282336135`, \
-0.47507741354102534`, -0.3272755515504841}, {-0.020955630116874954`, \
-0.47150167762968676`, -0.324812266811562}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.038544848628222717`, -0.46253818353867265`, \
-0.30835878902578173`}, {-0.07833195316248512, -0.46999171897491077`, \
-0.3133278126499405}, {-0.08560802621248467, -0.48154514744522636`, \
-0.33173110157337815`}, {-0.052786379282336135`, -0.47507741354102534`, \
-0.3272755515504841}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07833195316248512, -0.46999171897491077`, \
-0.3133278126499405}, {-0.12044994043743079`, -0.4817997617497233, \
-0.32119984116648215`}, {-0.11992963743797559`, -0.4906212440644457, \
-0.3379835236888404}, {-0.08560802621248467, -0.48154514744522636`, \
-0.33173110157337815`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.12044994043743079`, -0.4817997617497233, \
-0.32119984116648215`}, {-0.1657318525960958, -0.4971955577882874, \
-0.3314637051921916}, {-0.1561613637329016, -0.5019472405700409, \
-0.3457858768371393}, {-0.11992963743797559`, -0.4906212440644457, \
-0.3379835236888404}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1657318525960958, -0.4971955577882874, \
-0.3314637051921916}, {-0.176735752448586, -0.530207257345758, \
-0.39765544300931854`}, {-0.16447360317195706`, -0.5286651530527192, \
-0.3994358934176101}, {-0.1561613637329016, -0.5019472405700409, \
-0.3457858768371393}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.176735752448586, -0.530207257345758, \
-0.39765544300931854`}, {-0.18726648266764945`, -0.5617994480029483, \
-0.4681662066691236}, {-0.17247195529467113`, -0.5543741420185859, \
-0.4558187389930595}, {-0.16447360317195706`, -0.5286651530527192, \
-0.3994358934176101}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.18726648266764945`, -0.5617994480029483, \
-0.4681662066691236}, {-0.19749453248903248`, -0.5924835974670974, \
-0.5431099643448393}, {-0.18023995030369647`, -0.5793426974047388, \
-0.5149712865819899}, {-0.17247195529467113`, -0.5543741420185859, \
-0.4558187389930595}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.19749453248903248`, -0.5924835974670974, \
-0.5431099643448393}, {-0.20769184264312943`, -0.6230755279293883, \
-0.6230755279293883}, {-0.18789655708653166`, -0.6039532192067091, \
-0.577110853908633}, {-0.18023995030369647`, -0.5793426974047388, \
-0.5149712865819899}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, -0.6230755279293883, \
-0.6230755279293883}, {-0.14565785306317142`, -0.5826314122526858, \
-0.5340787945649619}, {-0.13970138965108453`, -0.571505684936255, \
-0.508005053276671}, {-0.18789655708653166`, -0.6039532192067091, \
-0.577110853908633}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.14565785306317142`, -0.5826314122526858, \
-0.5340787945649619}, {-0.09039737304879422, -0.5423842382927654, \
-0.4519868652439711}, {-0.09578808133406011, -0.5388079575040883, \
-0.4430198761700281}, {-0.13970138965108453`, -0.571505684936255, \
-0.508005053276671}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09039737304879422, -0.5423842382927654, \
-0.4519868652439711}, {-0.041781498251368454`, -0.5013779790164213, \
-0.37603348426231603`}, {-0.05615961056021798, -0.5054364950419619, \
-0.38188535180948235`}, {-0.09578808133406011, -0.5388079575040883, \
-0.4430198761700281}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.041781498251368454`, -0.5013779790164213, \
-0.37603348426231603`}, {
    0., -0.45998714286871445`, -0.3066580952458096}, {-0.020955630116874954`, \
-0.47150167762968676`, -0.324812266811562}, {-0.05615961056021798, \
-0.5054364950419619, -0.38188535180948235`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0., -0.45998714286871445`, -0.3066580952458096}, {-0.02708690739129757, \
-0.4875643330433564, -0.3521297960868685}, {-0.027651165009234, \
-0.4977209701662121, -0.37052561112373567`}, {-0.005290785729710824, \
-0.47617071567397445`, -0.33331950097178215`}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{-0.02708690739129757, -0.4875643330433564, \
-0.3521297960868685}, {-0.057237380507313335`, -0.5151364245658201, \
-0.4006616635511933}, {-0.05192776126127516, -0.5192776126127516, \
-0.4096523388389484}, {-0.027651165009234, -0.4977209701662121, \
-0.37052561112373567`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.057237380507313335`, -0.5151364245658201, \
-0.4006616635511933}, {-0.09039737304879422, -0.5423842382927654, \
-0.4519868652439711}, {-0.07810031047988147, -0.5406944571684102, \
-0.45057871430700847`}, {-0.05192776126127516, -0.5192776126127516, \
-0.4096523388389484}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09039737304879422, -0.5423842382927654, \
-0.4519868652439711}, {-0.06234543329511677, -0.5611088996560509, \
-0.49876346636093416`}, {-0.055613276850190324`, -0.5561327685019032, \
-0.48816098568500393`}, {-0.07810031047988147, -0.5406944571684102, \
-0.45057871430700847`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06234543329511677, -0.5611088996560509, \
-0.49876346636093416`}, {-0.03227981539684726, -0.5810366771432506, \
-0.5487568617464034}, {-0.03179444453423547, -0.5723000016162385, \
-0.5277877792683088}, {-0.055613276850190324`, -0.5561327685019032, \
-0.48816098568500393`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.03227981539684726, -0.5810366771432506, \
-0.5487568617464034}, {
    0., -0.6020420732135735, -0.6020420732135735}, {-0.006545673176541602, \
-0.5891105858887445, -0.5694735663591197}, {-0.03179444453423547, \
-0.5723000016162385, -0.5277877792683088}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.6020420732135735, -0.6020420732135735}, {
    0., -0.5583263670978953, -0.49629010408701807`}, {-0.006154011462866676, \
-0.5538610316580012, -0.4861669055664677}, {-0.006545673176541602, \
-0.5891105858887445, -0.5694735663591197}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.5583263670978953, -0.49629010408701807`}, {
    0., -0.5116766815928779, -0.3979707523500161}, {-0.005739686383923255, \
-0.5165717745530933, -0.40751773325855134`}, {-0.006154011462866676, \
-0.5538610316580012, -0.4861669055664677}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.5116766815928779, -0.3979707523500161}, {
    0., -0.45998714286871445`, -0.3066580952458096}, {-0.005290785729710824, \
-0.47617071567397445`, -0.33331950097178215`}, {-0.005739686383923255, \
-0.5165717745530933, -0.40751773325855134`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0., -0.6020420732135735, -0.6020420732135735}, {-0.06715883546475819, \
-0.6044295191828238, -0.6044295191828238}, {-0.0734128220308756, \
-0.6006503620708005, -0.5939764691589027}, {-0.01993158821950005, \
-0.597947646585002, -0.5913037838451686}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06715883546475819, -0.6044295191828238, \
-0.6044295191828238}, {-0.13589068132812965`, -0.6115080659765835, \
-0.6115080659765835}, {-0.12801278465860869`, -0.6063763483828833, \
-0.5996388334008513}, {-0.0734128220308756, -0.6006503620708005, \
-0.5939764691589027}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.13589068132812965`, -0.6115080659765835, \
-0.6115080659765835}, {-0.20769184264312943`, -0.6230755279293883, \
-0.6230755279293883}, {-0.1845016009799007, -0.615005336599669, \
-0.6081719439707838}, {-0.12801278465860869`, -0.6063763483828833, \
-0.5996388334008513}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, -0.6230755279293883, \
-0.6230755279293883}, {-0.16555673570625662`, -0.5960042485425239, \
-0.5628929014012725}, {-0.15171241243773156`, -0.5936572660606888, \
-0.560676306835095}, {-0.1845016009799007, -0.615005336599669, \
-0.6081719439707838}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.16555673570625662`, -0.5960042485425239, \
-0.5628929014012725}, {-0.12650407746706638`, -0.5692683486017988, \
-0.5060163098682655}, {-0.12086351903845649`, -0.572511405971636, \
-0.5152602653744724}, {-0.15171241243773156`, -0.5936572660606888, \
-0.560676306835095}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.12650407746706638`, -0.5692683486017988, \
-0.5060163098682655}, {-0.09039737304879422, -0.5423842382927654, \
-0.4519868652439711}, {-0.09188927555772322, -0.5513356533463394, \
-0.4716982811963126}, {-0.12086351903845649`, -0.572511405971636, \
-0.5152602653744724}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09039737304879422, -0.5423842382927654, \
-0.4519868652439711}, {-0.06234543329511677, -0.5611088996560509, \
-0.49876346636093416`}, {-0.06918894281144454, -0.5660913502754553, \
-0.5094822152479098}, {-0.09188927555772322, -0.5513356533463394, \
-0.4716982811963126}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06234543329511677, -0.5611088996560509, \
-0.49876346636093416`}, {-0.03227981539684726, -0.5810366771432506, \
-0.5487568617464034}, {-0.04523945407613895, -0.5816501238360723, \
-0.5493362280674016}, {-0.06918894281144454, -0.5660913502754553, \
-0.5094822152479098}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.03227981539684726, -0.5810366771432506, \
-0.5487568617464034}, {
    0., -0.6020420732135735, -0.6020420732135735}, {-0.01993158821950005, \
-0.597947646585002, -0.5913037838451686}, {-0.04523945407613895, \
-0.5816501238360723, -0.5493362280674016}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.40767204398438894`, -0.6115080659765835, \
-0.4756173846484537}, {-0.4185959624434206, -0.6176006003263583, \
-0.48721825136857155`}, {-0.4013008374837915, -0.5920832028449382, \
-0.41445824199145676`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.40767204398438894`, -0.6115080659765835, \
-0.4756173846484537}, {-0.4304670307029078, -0.6457005460543618, \
-0.5739560409372104}, {-0.43706252979527566`, -0.6448463554356526, \
-0.5660318008824062}, {-0.4185959624434206, -0.6176006003263583, \
-0.48721825136857155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4304670307029078, -0.6457005460543618, \
-0.5739560409372104}, {-0.4563691391047108, -0.6845537086570662, \
-0.6845537086570662}, {-0.4574749594975597, -0.6749630549963996, \
-0.6524642864965196}, {-0.43706252979527566`, -0.6448463554356526, \
-0.5660318008824062}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, -0.6845537086570662, \
-0.6845537086570662}, {-0.49015740221892146`, -0.6786794799954298, \
-0.6409750644401281}, {-0.484544369547659, -0.670907588604451, \
-0.6187258872685492}, {-0.4574749594975597, -0.6749630549963996, \
-0.6524642864965196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49015740221892146`, -0.6786794799954298, \
-0.6409750644401281}, {-0.5251512437069583, -0.6751944561946608, \
-0.6001728499508097}, {-0.5123956646927323, -0.6683421713383466, \
-0.5866559059525488}, {-0.484544369547659, -0.670907588604451, \
-0.6187258872685492}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5251512437069583, -0.6751944561946608, \
-0.6001728499508097}, {-0.5616987892757247, -0.6740385471308696, \
-0.5616987892757247}, {-0.5412105935744802, -0.6672459372836057, \
-0.5560382810696715}, {-0.5123956646927323, -0.6683421713383466, \
-0.5866559059525488}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, -0.6740385471308696, \
-0.5616987892757247}, {-0.49871361404698694`, -0.6412032180604118, \
-0.49871361404698694`}, {-0.4916236345631913, -0.641248218995467, \
-0.5058735949853128}, {-0.5412105935744802, -0.6672459372836057, \
-0.5560382810696715}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49871361404698694`, -0.6412032180604118, \
-0.49871361404698694`}, {-0.4407985310247471, -0.6103364275727268, \
-0.4407985310247471}, {-0.4452427310725714, -0.6164899353312527, \
-0.4589425074132659}, {-0.4916236345631913, -0.641248218995467, \
-0.5058735949853128}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4407985310247471, -0.6103364275727268, \
-0.4407985310247471}, {-0.38650287499487973`, -0.5797543124923197, \
-0.38650287499487973`}, {-0.4013008374837915, -0.5920832028449382, \
-0.41445824199145676`}, {-0.4452427310725714, -0.6164899353312527, \
-0.4589425074132659}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, -0.6845537086570662, \
-0.6845537086570662}, {-0.49015740221892146`, -0.6786794799954298, \
-0.6409750644401281}, {-0.5098591242716168, -0.6848853908126196, \
-0.6468362024341406}, {-0.48235791827893554`, -0.6890827403984794, \
-0.6814262655051629}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49015740221892146`, -0.6786794799954298, \
-0.6409750644401281}, {-0.5251512437069583, -0.6751944561946608, \
-0.6001728499508097}, {-0.5382118349147983, -0.68224035411735, \
-0.614016318705615}, {-0.5098591242716168, -0.6848853908126196, \
-0.6468362024341406}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5251512437069583, -0.6751944561946608, \
-0.6001728499508097}, {-0.5616987892757247, -0.6740385471308696, \
-0.5616987892757247}, {-0.5675936973120723, -0.6811124367744867, \
-0.5827295292403942}, {-0.5382118349147983, -0.68224035411735, \
-0.614016318705615}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, -0.6740385471308696, \
-0.5616987892757247}, {-0.6327645227143793, -0.7118600880536767, \
-0.6327645227143793}, {-0.6249011299737146, -0.7119126797168901, \
-0.6407214117452011}, {-0.5675936973120723, -0.6811124367744867, \
-0.5827295292403942}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6327645227143793, -0.7118600880536767, \
-0.6327645227143793}, {-0.7198653019554957, -0.7622103197175837, \
-0.7198653019554957}, {-0.6920462242465636, -0.7504115684601292, \
-0.7087220368790109}, {-0.6249011299737146, -0.7119126797168901, \
-0.6407214117452011}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7198653019554957, -0.7622103197175837, \
-0.7198653019554957}, {-0.9068996821171088, -0.9068996821171088, \
-0.9068996821171088}, {-0.7834402264884363, -0.8104554067121754, \
-0.8014503466375957}, {-0.6920462242465636, -0.7504115684601292, \
-0.7087220368790109}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.9068996821171088, -0.9068996821171088, \
-0.9068996821171088}, {-0.6791732466493353, -0.7640699024805022, \
-0.7640699024805022}, {-0.6601152491051621, -0.7520300306261339, \
-0.7436741413969546}, {-0.7834402264884363, -0.8104554067121754, \
-0.8014503466375957}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6791732466493353, -0.7640699024805022, \
-0.7640699024805022}, {-0.5578135523930144, -0.7171888530767329, \
-0.7171888530767329}, {-0.5649747532204069, -0.716165180138544, \
-0.7082077892481158}, {-0.6601152491051621, -0.7520300306261339, \
-0.7436741413969546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5578135523930144, -0.7171888530767329, \
-0.7171888530767329}, {-0.4563691391047108, -0.6845537086570662, \
-0.6845537086570662}, {-0.48235791827893554`, -0.6890827403984794, \
-0.6814262655051629}, {-0.5649747532204069, -0.716165180138544, \
-0.7082077892481158}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {
    0.005171109167864868, -0.07756663751797302, 0.005171109167864868}, {
    0.013921129715104607`, -0.11600941429253843`, 0.008765155746547347}, {
    0.0038620463024166113`, -0.05793069453624921, 0.0012873487674722039`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.005171109167864868, -0.07756663751797302, 
    0.005171109167864868}, {0.02041142073737483, -0.15308565553031123`, 
    0.02041142073737483}, {0.030232164988298865`, -0.17441633647095503`, 
    0.02248032781181198}, {0.013921129715104607`, -0.11600941429253843`, 
    0.008765155746547347}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.02041142073737483, -0.15308565553031123`, 
    0.02041142073737483}, {0.04495902221896904, -0.22479511109484523`, 
    0.04495902221896904}, {0.052280949450900525`, -0.23065124757750236`, 
    0.04202978289190042}, {0.030232164988298865`, -0.17441633647095503`, 
    0.02248032781181198}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.04495902221896904, -0.22479511109484523`, 
    0.04495902221896904}, {0.07771364461602205, -0.2914261673100827, 
    0.07771364461602205}, {0.07946169892532537, -0.2837917818761621, 
    0.0668487308419404}, {0.052280949450900525`, -0.23065124757750236`, 
    0.04202978289190042}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07771364461602205, -0.2914261673100827, 
    0.07771364461602205}, {0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {0.11112456154944492`, -0.3333736846483348, 
    0.09630795334285228}, {0.07946169892532537, -0.2837917818761621, 
    0.0668487308419404}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {0.14319799741026004`, -0.3579949935256501, 
    0.09546533160684004}, {0.131748866608086, -0.3407298274347052, 
    0.08026080379573056}, {0.11112456154944492`, -0.3333736846483348, 
    0.09630795334285228}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.14319799741026004`, -0.3579949935256501, 
    0.09546533160684004}, {0.1746044040148139, -0.37415229431745833`, 
    0.07483045886349166}, {0.15631133790709126`, -0.3552530406979347, 
    0.0647349985271792}, {0.131748866608086, -0.3407298274347052, 
    0.08026080379573056}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1746044040148139, -0.37415229431745833`, 
    0.07483045886349166}, {0.21246554927450964`, -0.3983729048897056, 
    0.05311638731862741}, {0.18521381542885962`, -0.3754334096530939, 
    0.04838919502195432}, {0.15631133790709126`, -0.3552530406979347, 
    0.0647349985271792}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21246554927450964`, -0.3983729048897056, 
    0.05311638731862741}, {0.2566895622918732, -0.42781593715312194`, 
    0.028521062476874796`}, {0.21842728074316375`, -0.39956209892042155`, 
    0.030189136362876293`}, {0.18521381542885962`, -0.3754334096530939, 
    0.04838919502195432}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2566895622918732, -0.42781593715312194`, 
    0.028521062476874796`}, {0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.2556458063906103, -0.4260763439843505, 0.009468363199652228}, {
    0.21842728074316375`, -0.39956209892042155`, 0.030189136362876293`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.20749339485230253`, -0.38905011534806727`, 0.}, {
    0.18050915270650156`, -0.36589693116182753`, 0.008131042914707273}, {
    0.2556458063906103, -0.4260763439843505, 0.009468363199652228}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20749339485230253`, -0.38905011534806727`, 0.}, {
    0.1226952100911925, -0.30673802522798127`, 0.}, {
    0.11533618865511652`, -0.2982832465218531, 0.006628516589374509}, {
    0.18050915270650156`, -0.36589693116182753`, 0.008131042914707273}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1226952100911925, -0.30673802522798127`, 0.}, {
    0.05675323239297665, -0.21282462147366246`, 0.}, {
    0.06253826722971649, -0.22335095439184463`, 0.004963354542040988}, {
    0.11533618865511652`, -0.2982832465218531, 0.006628516589374509}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.05675323239297665, -0.21282462147366246`, 0.}, {
    0.014560811715990765`, -0.10920608786993075`, 0.}, {
    0.0246522971021567, -0.142224790973981, 0.003160550910532909}, {
    0.06253826722971649, -0.22335095439184463`, 0.004963354542040988}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.014560811715990765`, -0.10920608786993075`, 0.}, {
    0., 0., 0.}, {0.0038620463024166113`, -0.05793069453624921, 
    0.0012873487674722039`}, {0.0246522971021567, -0.142224790973981, 
    0.003160550910532909}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.3109670174603803, -0.4664505261905705, 0.06219340349207606}, {
    0.2966525297708156, -0.4603228910236794, 0.07978930111077108}, {
    0.29040472453203425`, -0.45062802082557046`, 0.03004186805503801}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3109670174603803, -0.4664505261905705, 
    0.06219340349207606}, {0.3230789997575147, -0.48461849963627207`, 
    0.12923159990300587`}, {0.3076477764089712, -0.4773844806346105, 
    0.1336676545776909}, {0.2966525297708156, -0.4603228910236794, 
    0.07978930111077108}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3230789997575147, -0.48461849963627207`, 
    0.12923159990300587`}, {0.3410246861288609, -0.5115370291932914, 
    0.20461481167731652`}, {0.3222191897266516, -0.49999529440342494`, 
    0.19333151383599095`}, {0.3076477764089712, -0.4773844806346105, 
    0.1336676545776909}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3410246861288609, -0.5115370291932914, 
    0.20461481167731652`}, {0.36266749034792994`, -0.5440012355218949, 
    0.29013399227834397`}, {0.3391849732407725, -0.5263215102011988, 
    0.25965194503259137`}, {0.3222191897266516, -0.49999529440342494`, 
    0.19333151383599095`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.36266749034792994`, -0.5440012355218949, 
    0.29013399227834397`}, {0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.3576298790583277, -0.5549429157801637, 
    0.3329657494680982}, {0.3391849732407725, -0.5263215102011988, 
    0.25965194503259137`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.3251055239962821, -0.5418425399938036, 
    0.3251055239962821}, {0.30948310838038806`, -0.5235616495156941, 
    0.2862137017352461}, {0.3576298790583277, -0.5549429157801637, 
    0.3329657494680982}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3251055239962821, -0.5418425399938036, 
    0.3251055239962821}, {0.2673132787288769, -0.5012123976166442, 
    0.2673132787288769}, {0.2635503764484113, -0.49007301405696324`, 
    0.24176935360143517`}, {0.30948310838038806`, -0.5235616495156941, 
    0.2862137017352461}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2673132787288769, -0.5012123976166442, 
    0.2673132787288769}, {0.21311308081691166`, -0.4566708874648107, 
    0.21311308081691166`}, {0.2198966482103745, -0.4539150995168281, 
    0.19972264378740437`}, {0.2635503764484113, -0.49007301405696324`, 
    0.24176935360143517`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21311308081691166`, -0.4566708874648107, 
    0.21311308081691166`}, {0.1629042820200324, -0.40726070505008105`, 
    0.1629042820200324}, {0.1787484353953863, -0.4146226594222878, 
    0.1603207616432846}, {0.2198966482103745, -0.4539150995168281, 
    0.19972264378740437`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1629042820200324, -0.40726070505008105`, 
    0.1629042820200324}, {0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {0.1404740306623331, -0.37184302234147004`, 
    0.12394767411382335`}, {0.1787484353953863, -0.4146226594222878, 
    0.1603207616432846}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.11743040006038394`, -0.35229120018115184`, 
    0.11743040006038394`}, {0.14319799741026004`, -0.3579949935256501, 
    0.09546533160684004}, {0.16290833179688105`, -0.37788015107523965`, 
    0.10580644230106709`}, {0.1404740306623331, -0.37184302234147004`, 
    0.12394767411382335`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.14319799741026004`, -0.3579949935256501, 
    0.09546533160684004}, {0.1746044040148139, -0.37415229431745833`, 
    0.07483045886349166}, {0.18889392224764073`, -0.38991864684146027`, 
    0.08838155995073098}, {0.16290833179688105`, -0.37788015107523965`, 
    0.10580644230106709`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1746044040148139, -0.37415229431745833`, 
    0.07483045886349166}, {0.21246554927450964`, -0.3983729048897056, 
    0.05311638731862741}, {0.2188183987589316, -0.40689371670049274`, 
    0.07052824422808539}, {0.18889392224764073`, -0.38991864684146027`, 
    0.08838155995073098}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21246554927450964`, -0.3983729048897056, 
    0.05311638731862741}, {0.2566895622918732, -0.42781593715312194`, 
    0.028521062476874796`}, {0.2527228599908341, -0.4275386729168246, 
    0.05130464075001894}, {0.2188183987589316, -0.40689371670049274`, 
    0.07052824422808539}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2566895622918732, -0.42781593715312194`, 
    0.028521062476874796`}, {0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.29040472453203425`, -0.45062802082557046`, 0.03004186805503801}, {
    0.2527228599908341, -0.4275386729168246, 0.05130464075001894}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {
    0.014560811715990765`, -0.10920608786993075`, 0.}, {
    0.0246522971021567, -0.142224790973981, -0.003160550910532909}, {
    0.0038620463024166113`, -0.05793069453624921, -0.0012873487674722039`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.014560811715990765`, -0.10920608786993075`, 0.}, {
    0.05675323239297665, -0.21282462147366246`, 0.}, {
    0.06253826722971648, -0.22335095439184463`, -0.004963354542040988}, {
    0.0246522971021567, -0.142224790973981, -0.003160550910532909}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.05675323239297665, -0.21282462147366246`, 0.}, {
    0.1226952100911925, -0.30673802522798127`, 0.}, {
    0.11533618865511652`, -0.2982832465218531, -0.006628516589374509}, {
    0.06253826722971648, -0.22335095439184463`, -0.004963354542040988}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1226952100911925, -0.30673802522798127`, 0.}, {
    0.20749339485230253`, -0.38905011534806727`, 0.}, {
    0.18050915270650156`, -0.36589693116182753`, -0.008131042914707273}, {
    0.11533618865511652`, -0.2982832465218531, -0.006628516589374509}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20749339485230253`, -0.38905011534806727`, 0.}, {
    0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.2556458063906103, -0.4260763439843505, -0.009468363199652228}, {
    0.18050915270650156`, -0.36589693116182753`, -0.008131042914707273}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.2566895622918732, -0.42781593715312194`, -0.028521062476874796`}, {
    0.21842728074316375`, -0.39956209892042155`, -0.030189136362876293`}, {
    0.2556458063906103, -0.4260763439843505, -0.009468363199652228}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.2566895622918732, -0.42781593715312194`, -0.028521062476874796`}, {
    0.21246554927450964`, -0.3983729048897056, -0.05311638731862741}, {
    0.18521381542885962`, -0.3754334096530939, -0.04838919502195432}, {
    0.21842728074316375`, -0.39956209892042155`, -0.030189136362876293`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.21246554927450964`, -0.3983729048897056, -0.05311638731862741}, {
    0.1746044040148139, -0.37415229431745833`, -0.07483045886349166}, {
    0.15631133790709126`, -0.3552530406979347, -0.0647349985271792}, {
    0.18521381542885962`, -0.3754334096530939, -0.04838919502195432}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.1746044040148139, -0.37415229431745833`, -0.07483045886349166}, {
    0.14319799741026004`, -0.3579949935256501, -0.09546533160684004}, {
    0.131748866608086, -0.3407298274347052, -0.08026080379573056}, {
    0.15631133790709126`, -0.3552530406979347, -0.0647349985271792}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.14319799741026004`, -0.3579949935256501, -0.09546533160684004}, {
    0.11743040006038394`, -0.35229120018115184`, -0.11743040006038394`}, {
    0.11112456154944492`, -0.3333736846483348, -0.09630795334285228}, {
    0.131748866608086, -0.3407298274347052, -0.08026080379573056}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.11743040006038394`, -0.35229120018115184`, -0.11743040006038394`}, {
    0.07771364461602205, -0.2914261673100827, -0.07771364461602205}, {
    0.07946169892532537, -0.2837917818761621, -0.0668487308419404}, {
    0.11112456154944492`, -0.3333736846483348, -0.09630795334285228}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.07771364461602205, -0.2914261673100827, -0.07771364461602205}, {
    0.04495902221896904, -0.22479511109484523`, -0.04495902221896904}, {
    0.052280949450900525`, -0.23065124757750236`, -0.04202978289190042}, {
    0.07946169892532537, -0.2837917818761621, -0.0668487308419404}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.04495902221896904, -0.22479511109484523`, -0.04495902221896904}, {
    0.02041142073737483, -0.15308565553031123`, -0.02041142073737483}, {
    0.030232164988298865`, -0.17441633647095503`, -0.02248032781181198}, {
    0.052280949450900525`, -0.23065124757750236`, -0.04202978289190042}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.02041142073737483, -0.15308565553031123`, -0.02041142073737483}, {
    0.005171109167864868, -0.07756663751797302, -0.005171109167864868}, {
    0.013921129715104607`, -0.11600941429253843`, -0.008765155746547347}, {
    0.030232164988298865`, -0.17441633647095503`, -0.02248032781181198}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.005171109167864868, -0.07756663751797302, -0.005171109167864868}, {0., 
    0., 0.}, {
    0.0038620463024166113`, -0.05793069453624921, -0.0012873487674722039`}, {
    0.013921129715104607`, -0.11600941429253843`, -0.008765155746547347}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.2566895622918732, -0.42781593715312194`, -0.028521062476874796`}, {
    0.2527228599908341, -0.4275386729168246, -0.05130464075001894}, {
    0.29040472453203425`, -0.45062802082557046`, -0.03004186805503801}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.2566895622918732, -0.42781593715312194`, -0.028521062476874796`}, {
    0.21246554927450964`, -0.3983729048897056, -0.05311638731862741}, {
    0.2188183987589316, -0.40689371670049274`, -0.07052824422808539}, {
    0.2527228599908341, -0.4275386729168246, -0.05130464075001894}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.21246554927450964`, -0.3983729048897056, -0.05311638731862741}, {
    0.1746044040148139, -0.37415229431745833`, -0.07483045886349166}, {
    0.18889392224764073`, -0.38991864684146027`, -0.08838155995073098}, {
    0.2188183987589316, -0.40689371670049274`, -0.07052824422808539}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.1746044040148139, -0.37415229431745833`, -0.07483045886349166}, {
    0.14319799741026004`, -0.3579949935256501, -0.09546533160684004}, {
    0.16290833179688105`, -0.37788015107523965`, -0.10580644230106709`}, {
    0.18889392224764073`, -0.38991864684146027`, -0.08838155995073098}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.14319799741026004`, -0.3579949935256501, -0.09546533160684004}, {
    0.11743040006038394`, -0.35229120018115184`, -0.11743040006038394`}, {
    0.1404740306623331, -0.37184302234147004`, -0.12394767411382335`}, {
    0.16290833179688105`, -0.37788015107523965`, -0.10580644230106709`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.11743040006038394`, -0.35229120018115184`, -0.11743040006038394`}, {
    0.1629042820200324, -0.40726070505008105`, -0.1629042820200324}, {
    0.1787484353953863, -0.4146226594222878, -0.1603207616432846}, {
    0.1404740306623331, -0.37184302234147004`, -0.12394767411382335`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.1629042820200324, -0.40726070505008105`, -0.1629042820200324}, {
    0.21311308081691166`, -0.4566708874648107, -0.21311308081691166`}, {
    0.2198966482103745, -0.4539150995168281, -0.19972264378740437`}, {
    0.1787484353953863, -0.4146226594222878, -0.1603207616432846}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.21311308081691166`, -0.4566708874648107, -0.21311308081691166`}, {
    0.2673132787288769, -0.5012123976166442, -0.2673132787288769}, {
    0.2635503764484113, -0.49007301405696324`, -0.24176935360143517`}, {
    0.2198966482103745, -0.4539150995168281, -0.19972264378740437`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.2673132787288769, -0.5012123976166442, -0.2673132787288769}, {
    0.3251055239962821, -0.5418425399938036, -0.3251055239962821}, {
    0.30948310838038806`, -0.5235616495156941, -0.2862137017352461}, {
    0.2635503764484113, -0.49007301405696324`, -0.24176935360143517`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3251055239962821, -0.5418425399938036, -0.3251055239962821}, {
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.3576298790583277, -0.5549429157801637, -0.3329657494680982}, {
    0.30948310838038806`, -0.5235616495156941, -0.2862137017352461}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.36266749034792994`, -0.5440012355218949, -0.29013399227834397`}, {
    0.3391849732407725, -0.5263215102011988, -0.25965194503259137`}, {
    0.3576298790583277, -0.5549429157801637, -0.3329657494680982}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.36266749034792994`, -0.5440012355218949, -0.29013399227834397`}, {
    0.3410246861288609, -0.5115370291932914, -0.20461481167731652`}, {
    0.3222191897266516, -0.49999529440342494`, -0.19333151383599095`}, {
    0.3391849732407725, -0.5263215102011988, -0.25965194503259137`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3410246861288609, -0.5115370291932914, -0.20461481167731652`}, {
    0.3230789997575147, -0.48461849963627207`, -0.12923159990300587`}, {
    0.3076477764089712, -0.4773844806346105, -0.13366765457769092`}, {
    0.3222191897266516, -0.49999529440342494`, -0.19333151383599095`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3230789997575147, -0.48461849963627207`, -0.12923159990300587`}, {
    0.3109670174603803, -0.4664505261905705, -0.06219340349207606}, {
    0.2966525297708156, -0.4603228910236794, -0.07978930111077108}, {
    0.3076477764089712, -0.4773844806346105, -0.13366765457769092`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3109670174603803, -0.4664505261905705, -0.06219340349207606}, {
    0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.29040472453203425`, -0.45062802082557046`, -0.03004186805503801}, {
    0.2966525297708156, -0.4603228910236794, -0.07978930111077108}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.4407985310247471, -0.6103364275727268, 
    0.4407985310247471}, {0.4589425074132659, -0.6164899353312527, 
    0.4452427310725714}, {0.41445824199145676`, -0.5920832028449382, 
    0.4013008374837915}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4407985310247471, -0.6103364275727268, 
    0.4407985310247471}, {0.49871361404698694`, -0.6412032180604118, 
    0.49871361404698694`}, {0.5058735949853128, -0.641248218995467, 
    0.4916236345631913}, {0.4589425074132659, -0.6164899353312527, 
    0.4452427310725714}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49871361404698694`, -0.6412032180604118, 
    0.49871361404698694`}, {0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {0.5560382810696715, -0.6672459372836057, 
    0.5412105935744802}, {0.5058735949853128, -0.641248218995467, 
    0.4916236345631913}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {0.6001728499508097, -0.6751944561946608, 
    0.5251512437069583}, {0.5866559059525488, -0.6683421713383466, 
    0.5123956646927323}, {0.5560382810696715, -0.6672459372836057, 
    0.5412105935744802}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6001728499508097, -0.6751944561946608, 
    0.5251512437069583}, {0.6409750644401281, -0.6786794799954298, 
    0.49015740221892146`}, {0.6187258872685492, -0.670907588604451, 
    0.484544369547659}, {0.5866559059525488, -0.6683421713383466, 
    0.5123956646927323}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6409750644401281, -0.6786794799954298, 
    0.49015740221892146`}, {0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.6524642864965196, -0.6749630549963996, 
    0.4574749594975597}, {0.6187258872685492, -0.670907588604451, 
    0.484544369547659}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.5739560409372104, -0.6457005460543618, 
    0.4304670307029078}, {0.5660318008824062, -0.6448463554356526, 
    0.43706252979527566`}, {0.6524642864965196, -0.6749630549963996, 
    0.4574749594975597}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5739560409372104, -0.6457005460543618, 
    0.4304670307029078}, {0.4756173846484537, -0.6115080659765835, 
    0.40767204398438894`}, {0.48721825136857155`, -0.6176006003263583, 
    0.4185959624434206}, {0.5660318008824062, -0.6448463554356526, 
    0.43706252979527566`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4756173846484537, -0.6115080659765835, 
    0.40767204398438894`}, {0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.41445824199145676`, -0.5920832028449382, 
    0.4013008374837915}, {0.48721825136857155`, -0.6176006003263583, 
    0.4185959624434206}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.7171888530767329, -0.7171888530767329, 
    0.5578135523930144}, {0.7082077892481158, -0.716165180138544, 
    0.5649747532204069}, {0.6814262655051632, -0.6890827403984796, 
    0.4823579182789357}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7171888530767329, -0.7171888530767329, 
    0.5578135523930144}, {0.7640699024805022, -0.7640699024805022, 
    0.6791732466493353}, {0.7436741413969546, -0.7520300306261339, 
    0.6601152491051621}, {0.7082077892481158, -0.716165180138544, 
    0.5649747532204069}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7640699024805022, -0.7640699024805022, 
    0.6791732466493353}, {0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {0.8014503466375957, -0.8104554067121754, 
    0.7834402264884363}, {0.7436741413969546, -0.7520300306261339, 
    0.6601152491051621}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {0.7198653019554957, -0.7622103197175837, 
    0.7198653019554957}, {0.7087220368790109, -0.7504115684601292, 
    0.6920462242465636}, {0.8014503466375957, -0.8104554067121754, 
    0.7834402264884363}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7198653019554957, -0.7622103197175837, 
    0.7198653019554957}, {0.6327645227143793, -0.7118600880536767, 
    0.6327645227143793}, {0.6407214117452011, -0.7119126797168901, 
    0.6249011299737146}, {0.7087220368790109, -0.7504115684601292, 
    0.6920462242465636}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6327645227143793, -0.7118600880536767, 
    0.6327645227143793}, {0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {0.5827295292403942, -0.6811124367744867, 
    0.5675936973120723}, {0.6407214117452011, -0.7119126797168901, 
    0.6249011299737146}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5616987892757247, -0.6740385471308696, 
    0.5616987892757247}, {0.6001728499508097, -0.6751944561946608, 
    0.5251512437069583}, {0.614016318705615, -0.68224035411735, 
    0.5382118349147983}, {0.5827295292403942, -0.6811124367744867, 
    0.5675936973120723}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6001728499508097, -0.6751944561946608, 
    0.5251512437069583}, {0.6409750644401281, -0.6786794799954298, 
    0.49015740221892146`}, {0.6468362024341406, -0.6848853908126196, 
    0.5098591242716168}, {0.614016318705615, -0.68224035411735, 
    0.5382118349147983}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6409750644401281, -0.6786794799954298, 
    0.49015740221892146`}, {0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.6814262655051632, -0.6890827403984796, 
    0.4823579182789357}, {0.6468362024341406, -0.6848853908126196, 
    0.5098591242716168}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.30835878902578173`, -0.46253818353867265`, 0.038544848628222717`}, {
    0.3272755515504841, -0.47507741354102534`, 0.052786379282336135`}, {
    0.324812266811562, -0.47150167762968676`, 0.020955630116874954`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.30835878902578173`, -0.46253818353867265`, 
    0.038544848628222717`}, {0.3133278126499405, -0.46999171897491077`, 
    0.07833195316248512}, {0.33173110157337826`, -0.48154514744522653`, 
    0.0856080262124847}, {0.3272755515504841, -0.47507741354102534`, 
    0.052786379282336135`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3133278126499405, -0.46999171897491077`, 
    0.07833195316248512}, {0.32119984116648215`, -0.4817997617497233, 
    0.12044994043743079`}, {0.3379835236888404, -0.4906212440644457, 
    0.11992963743797559`}, {0.33173110157337826`, -0.48154514744522653`, 
    0.0856080262124847}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.32119984116648215`, -0.4817997617497233, 
    0.12044994043743079`}, {0.3314637051921916, -0.4971955577882874, 
    0.1657318525960958}, {0.3457858768371393, -0.5019472405700409, 
    0.1561613637329016}, {0.3379835236888404, -0.4906212440644457, 
    0.11992963743797559`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3314637051921916, -0.4971955577882874, 
    0.1657318525960958}, {0.39765544300931854`, -0.530207257345758, 
    0.176735752448586}, {0.3994358934176101, -0.5286651530527192, 
    0.16447360317195706`}, {0.3457858768371393, -0.5019472405700409, 
    0.1561613637329016}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.39765544300931854`, -0.530207257345758, 
    0.176735752448586}, {0.4681662066691236, -0.5617994480029483, 
    0.18726648266764945`}, {0.4558187389930595, -0.5543741420185859, 
    0.17247195529467113`}, {0.3994358934176101, -0.5286651530527192, 
    0.16447360317195706`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4681662066691236, -0.5617994480029483, 
    0.18726648266764945`}, {0.5431099643448393, -0.5924835974670974, 
    0.19749453248903248`}, {0.5149712865819899, -0.5793426974047388, 
    0.18023995030369647`}, {0.4558187389930595, -0.5543741420185859, 
    0.17247195529467113`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5431099643448393, -0.5924835974670974, 
    0.19749453248903248`}, {0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.577110853908633, -0.6039532192067091, 
    0.18789655708653166`}, {0.5149712865819899, -0.5793426974047388, 
    0.18023995030369647`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.5340787945649619, -0.5826314122526858, 
    0.14565785306317142`}, {0.508005053276671, -0.571505684936255, 
    0.13970138965108453`}, {0.577110853908633, -0.6039532192067091, 
    0.18789655708653166`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5340787945649619, -0.5826314122526858, 
    0.14565785306317142`}, {0.4519868652439711, -0.5423842382927654, 
    0.09039737304879422}, {0.4430198761700281, -0.5388079575040883, 
    0.09578808133406011}, {0.508005053276671, -0.571505684936255, 
    0.13970138965108453`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4519868652439711, -0.5423842382927654, 
    0.09039737304879422}, {0.3760334842623161, -0.5013779790164214, 
    0.04178149825136846}, {0.38188535180948235`, -0.5054364950419619, 
    0.05615961056021798}, {0.4430198761700281, -0.5388079575040883, 
    0.09578808133406011}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3760334842623161, -0.5013779790164214, 
    0.04178149825136846}, {0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.324812266811562, -0.47150167762968676`, 0.020955630116874954`}, {
    0.38188535180948235`, -0.5054364950419619, 0.05615961056021798}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.3521297960868685, -0.4875643330433564, 0.02708690739129757}, {
    0.3705256111237356, -0.49772097016621203`, 0.027651165009233997`}, {
    0.33331950097178215`, -0.47617071567397445`, 0.005290785729710824}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3521297960868685, -0.4875643330433564, 
    0.02708690739129757}, {0.4006616635511933, -0.5151364245658201, 
    0.057237380507313335`}, {0.4096523388389484, -0.5192776126127516, 
    0.05192776126127516}, {0.3705256111237356, -0.49772097016621203`, 
    0.027651165009233997`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4006616635511933, -0.5151364245658201, 
    0.057237380507313335`}, {0.4519868652439711, -0.5423842382927654, 
    0.09039737304879422}, {0.45057871430700847`, -0.5406944571684102, 
    0.07810031047988147}, {0.4096523388389484, -0.5192776126127516, 
    0.05192776126127516}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4519868652439711, -0.5423842382927654, 
    0.09039737304879422}, {0.49876346636093416`, -0.5611088996560509, 
    0.06234543329511677}, {0.48816098568500393`, -0.5561327685019032, 
    0.055613276850190324`}, {0.45057871430700847`, -0.5406944571684102, 
    0.07810031047988147}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49876346636093416`, -0.5611088996560509, 
    0.06234543329511677}, {0.5487568617464034, -0.5810366771432506, 
    0.03227981539684726}, {0.5277877792683088, -0.5723000016162385, 
    0.03179444453423547}, {0.48816098568500393`, -0.5561327685019032, 
    0.055613276850190324`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5487568617464034, -0.5810366771432506, 
    0.03227981539684726}, {0.6020420732135735, -0.6020420732135735, 0.}, {
    0.5694735663591197, -0.5891105858887445, 0.006545673176541602}, {
    0.5277877792683088, -0.5723000016162385, 0.03179444453423547}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, -0.6020420732135735, 0.}, {
    0.49629010408701807`, -0.5583263670978953, 0.}, {
    0.4861669055664677, -0.5538610316580012, 0.006154011462866676}, {
    0.5694735663591197, -0.5891105858887445, 0.006545673176541602}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49629010408701807`, -0.5583263670978953, 0.}, {
    0.3979707523500161, -0.5116766815928779, 0.}, {
    0.40751773325855134`, -0.5165717745530933, 0.005739686383923255}, {
    0.4861669055664677, -0.5538610316580012, 0.006154011462866676}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3979707523500161, -0.5116766815928779, 0.}, {
    0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.33331950097178215`, -0.47617071567397445`, 0.005290785729710824}, {
    0.40751773325855134`, -0.5165717745530933, 0.005739686383923255}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, -0.6020420732135735, 0.}, {
    0.6044295191828238, -0.6044295191828238, 0.06715883546475819}, {
    0.5939764691589027, -0.6006503620708005, 0.0734128220308756}, {
    0.5913037838451686, -0.597947646585002, 0.01993158821950005}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6044295191828238, -0.6044295191828238, 
    0.06715883546475819}, {0.6115080659765835, -0.6115080659765835, 
    0.13589068132812965`}, {0.5996388334008513, -0.6063763483828833, 
    0.12801278465860869`}, {0.5939764691589027, -0.6006503620708005, 
    0.0734128220308756}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, -0.6115080659765835, 
    0.13589068132812965`}, {0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.6081719439707838, -0.615005336599669, 
    0.1845016009799007}, {0.5996388334008513, -0.6063763483828833, 
    0.12801278465860869`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.5628929014012727, -0.596004248542524, 
    0.16555673570625667`}, {0.560676306835095, -0.5936572660606888, 
    0.15171241243773156`}, {0.6081719439707838, -0.615005336599669, 
    0.1845016009799007}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5628929014012727, -0.596004248542524, 
    0.16555673570625667`}, {0.5060163098682655, -0.5692683486017988, 
    0.12650407746706638`}, {0.5152602653744724, -0.5725114059716361, 
    0.1208635190384565}, {0.560676306835095, -0.5936572660606888, 
    0.15171241243773156`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5060163098682655, -0.5692683486017988, 
    0.12650407746706638`}, {0.4519868652439711, -0.5423842382927654, 
    0.09039737304879422}, {0.4716982811963126, -0.5513356533463394, 
    0.09188927555772322}, {0.5152602653744724, -0.5725114059716361, 
    0.1208635190384565}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4519868652439711, -0.5423842382927654, 
    0.09039737304879422}, {0.49876346636093416`, -0.5611088996560509, 
    0.06234543329511677}, {0.5094822152479099, -0.5660913502754555, 
    0.06918894281144455}, {0.4716982811963126, -0.5513356533463394, 
    0.09188927555772322}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49876346636093416`, -0.5611088996560509, 
    0.06234543329511677}, {0.5487568617464034, -0.5810366771432506, 
    0.03227981539684726}, {0.5493362280674016, -0.5816501238360723, 
    0.04523945407613895}, {0.5094822152479099, -0.5660913502754555, 
    0.06918894281144455}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5487568617464034, -0.5810366771432506, 
    0.03227981539684726}, {0.6020420732135735, -0.6020420732135735, 0.}, {
    0.5913037838451686, -0.597947646585002, 0.01993158821950005}, {
    0.5493362280674016, -0.5816501238360723, 0.04523945407613895}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.3713990257767195, -0.5570985386650793, 
    0.32497414755462956`}, {0.3835413553175742, -0.5567535802997046, 
    0.3093075446109469}, {0.39544905581618517`, -0.5740389519912366, 
    0.35717979235010267`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3713990257767195, -0.5570985386650793, 
    0.32497414755462956`}, {0.35700820570107417`, -0.5355123085516112, 
    0.26775615427580557`}, {0.37218594917787184`, -0.540269926225943, 
    0.26413196393268323`}, {0.3835413553175742, -0.5567535802997046, 
    0.3093075446109469}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.35700820570107417`, -0.5355123085516112, 
    0.26775615427580557`}, {0.34356711554250086`, -0.5153506733137513, 
    0.21472944721406304`}, {0.3615143676766774, -0.5247789208209833, 
    0.22157332212441513`}, {0.37218594917787184`, -0.540269926225943, 
    0.26413196393268323`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.34356711554250086`, -0.5153506733137513, 
    0.21472944721406304`}, {0.3314637051921916, -0.4971955577882874, 
    0.1657318525960958}, {0.35171683279870997`, -0.510556692772321, 
    0.18153126854126964`}, {0.3615143676766774, -0.5247789208209833, 
    0.22157332212441513`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3314637051921916, -0.4971955577882874, 
    0.1657318525960958}, {0.39765544300931854`, -0.530207257345758, 
    0.176735752448586}, {0.4051478286995518, -0.5362250673964656, 
    0.1906578017409655}, {0.35171683279870997`, -0.510556692772321, 
    0.18153126854126964`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.39765544300931854`, -0.530207257345758, 
    0.176735752448586}, {0.4681662066691236, -0.5617994480029483, 
    0.18726648266764945`}, {0.461356206383864, -0.5611088996560508, 
    0.19950538654437358`}, {0.4051478286995518, -0.5362250673964656, 
    0.1906578017409655}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4681662066691236, -0.5617994480029483, 
    0.18726648266764945`}, {0.5431099643448393, -0.5924835974670974, 
    0.19749453248903248`}, {0.5204039871231084, -0.5854544855134971, 
    0.20816159484924335`}, {0.461356206383864, -0.5611088996560508, 
    0.19950538654437358`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5431099643448393, -0.5924835974670974, 
    0.19749453248903248`}, {0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.5825372045115768, -0.6096319582097897, 
    0.21675802958570295`}, {0.5204039871231084, -0.5854544855134971, 
    0.20816159484924335`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.5543330019515704, -0.604726911219895, 
    0.25196954634162294`}, {0.5296515960248482, -0.5958580455279544, 
    0.2515845081118029}, {0.5825372045115768, -0.6096319582097897, 
    0.21675802958570295`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5543330019515704, -0.604726911219895, 
    0.25196954634162294`}, {0.4925795519732687, -0.5910954623679224, 
    0.29554773118396116`}, {0.4811249564266876, -0.585151974032458, 
    0.2860742984158683}, {0.5296515960248482, -0.5958580455279544, 
    0.2515845081118029}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4925795519732687, -0.5910954623679224, 
    0.29554773118396116`}, {0.43697355918951436`, -0.5826314122526858, 
    0.3398683238140667}, {0.4365551681661225, -0.5777936049257504, 
    0.32099644718097237`}, {0.4811249564266876, -0.585151974032458, 
    0.2860742984158683}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.43697355918951436`, -0.5826314122526858, 
    0.3398683238140667}, {0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.39544905581618517`, -0.5740389519912366, 
    0.35717979235010267`}, {0.4365551681661225, -0.5777936049257504, 
    0.32099644718097237`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.41963760015901447`, -0.5810366771432508, 
    0.3550779693653199}, {0.4375200535371022, -0.5877135047513313, 
    0.3591582529035913}, {0.41027620202761383`, -0.5861088600394483, 
    0.38422691935919384`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.41963760015901447`, -0.5810366771432508, 
    0.3550779693653199}, {0.45488267153483286`, -0.5848491491162138, 
    0.32491619395345206`}, {0.46615250600961755`, -0.5908975428290927, 
    0.33484194093648584`}, {0.4375200535371022, -0.5877135047513313, 
    0.3591582529035913}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45488267153483286`, -0.5848491491162138, 
    0.32491619395345206`}, {0.4925795519732687, -0.5910954623679224, 
    0.2955477311839612}, {0.49634519379760245`, -0.595614232557123, 
    0.31104298811316416`}, {0.46615250600961755`, -0.5908975428290927, 
    0.33484194093648584`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4925795519732687, -0.5910954623679224, 
    0.2955477311839612}, {0.5518056130029987, -0.6207813146283735, 
    0.34487850812687415`}, {0.5437365170115114, -0.6194466649498231, 
    0.3510197768048997}, {0.49634519379760245`, -0.595614232557123, 
    0.31104298811316416`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5518056130029987, -0.6207813146283735, 
    0.34487850812687415`}, {0.6151364564558499, -0.6513209538944295, 
    0.39802947182437354`}, {0.593696451805427, -0.643767236897451, 
    0.3934133114373311}, {0.5437365170115114, -0.6194466649498231, 
    0.3510197768048997}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6151364564558499, -0.6513209538944295, 
    0.39802947182437354`}, {0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.6471256199373834, -0.6694402964869484, 
    0.43885530547477725`}, {0.593696451805427, -0.643767236897451, 
    0.3934133114373311}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.5739560409372104, -0.6457005460543618, 
    0.4304670307029078}, {0.5612928240005222, -0.639447521013253, 
    0.41919337488646585`}, {0.6471256199373834, -0.6694402964869484, 
    0.43885530547477725`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5739560409372104, -0.6457005460543618, 
    0.4304670307029078}, {0.4756173846484537, -0.6115080659765835, 
    0.40767204398438894`}, {0.4828178508766534, -0.6120226278718142, 
    0.4012148338270782}, {0.5612928240005222, -0.639447521013253, 
    0.41919337488646585`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4756173846484537, -0.6115080659765835, 
    0.40767204398438894`}, {0.38650287499487973`, -0.5797543124923197, 
    0.38650287499487973`}, {0.41027620202761383`, -0.5861088600394483, 
    0.38422691935919384`}, {0.4828178508766534, -0.6120226278718142, 
    0.4012148338270782}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.6592097133507697, -0.6592097133507697, 
    0.3662276185282054}, {0.6456860811433847, -0.6529409809315125, 
    0.35549008961826795`}, {0.6647257540000352, -0.6721945826966648, 
    0.42572323570788767`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6592097133507697, -0.6592097133507697, 
    0.3662276185282054}, {0.6389520625760421, -0.6389520625760421, 
    0.2839786944782409}, {0.629668395546924, -0.6367433213395861, 
    0.2900719574991448}, {0.6456860811433847, -0.6529409809315125, 
    0.35549008961826795`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6389520625760421, -0.6389520625760421, 
    0.2839786944782409}, {0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.6163788869098672, -0.6233044923807646, 
    0.22854498053961364`}, {0.629668395546924, -0.6367433213395861, 
    0.2900719574991448}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.5764288482631306, -0.6103364275727265, 
    0.23735305516717142`}, {0.5796080893522857, -0.6137026828435966, 
    0.2522999918357008}, {0.6163788869098672, -0.6233044923807646, 
    0.22854498053961364`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5764288482631306, -0.6103364275727265, 
    0.23735305516717142`}, {0.5330126623440324, -0.5996392451370365, 
    0.2665063311720162}, {0.5448850795979028, -0.605427866219892, 
    0.2758060279446175}, {0.5796080893522857, -0.6137026828435966, 
    0.2522999918357008}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5330126623440324, -0.5996392451370365, 
    0.2665063311720162}, {0.4925795519732687, -0.5910954623679224, 
    0.2955477311839612}, {0.5120744169386685, -0.5985285392789631, 
    0.29926426963948155`}, {0.5448850795979028, -0.605427866219892, 
    0.2758060279446175}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4925795519732687, -0.5910954623679224, 
    0.2955477311839612}, {0.5518056130029987, -0.6207813146283735, 
    0.34487850812687415`}, {0.5599842480618302, -0.6222047200687002, 
    0.33875590314851456`}, {0.5120744169386685, -0.5985285392789631, 
    0.29926426963948155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5518056130029987, -0.6207813146283735, 
    0.34487850812687415`}, {0.6151364564558499, -0.6513209538944295, 
    0.39802947182437354`}, {0.6105500670057994, -0.6464647768296701, 
    0.3806959241330279}, {0.5599842480618302, -0.6222047200687002, 
    0.33875590314851456`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6151364564558499, -0.6513209538944295, 
    0.39802947182437354`}, {0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.6647257540000352, -0.6721945826966648, 
    0.42572323570788767`}, {0.6105500670057994, -0.6464647768296701, 
    0.3806959241330279}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.3713990257767195, -0.5570985386650793, -0.32497414755462956`}, {
    0.3835413553175742, -0.5567535802997046, -0.3093075446109469}, {
    0.39544905581618517`, -0.5740389519912366, -0.35717979235010267`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3713990257767195, -0.5570985386650793, -0.32497414755462956`}, {
    0.35700820570107417`, -0.5355123085516112, -0.26775615427580557`}, {
    0.37218594917787184`, -0.540269926225943, -0.26413196393268323`}, {
    0.3835413553175742, -0.5567535802997046, -0.3093075446109469}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.35700820570107417`, -0.5355123085516112, -0.26775615427580557`}, {
    0.34356711554250086`, -0.5153506733137513, -0.21472944721406304`}, {
    0.3615143676766774, -0.5247789208209833, -0.22157332212441513`}, {
    0.37218594917787184`, -0.540269926225943, -0.26413196393268323`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.34356711554250086`, -0.5153506733137513, -0.21472944721406304`}, {
    0.3314637051921916, -0.4971955577882874, -0.1657318525960958}, {
    0.35171683279870997`, -0.510556692772321, -0.18153126854126964`}, {
    0.3615143676766774, -0.5247789208209833, -0.22157332212441513`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3314637051921916, -0.4971955577882874, -0.1657318525960958}, {
    0.39765544300931854`, -0.530207257345758, -0.176735752448586}, {
    0.4051478286995518, -0.5362250673964656, -0.1906578017409655}, {
    0.35171683279870997`, -0.510556692772321, -0.18153126854126964`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.39765544300931854`, -0.530207257345758, -0.176735752448586}, {
    0.4681662066691236, -0.5617994480029483, -0.18726648266764945`}, {
    0.461356206383864, -0.5611088996560508, -0.19950538654437358`}, {
    0.4051478286995518, -0.5362250673964656, -0.1906578017409655}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4681662066691236, -0.5617994480029483, -0.18726648266764945`}, {
    0.5431099643448393, -0.5924835974670974, -0.19749453248903248`}, {
    0.5204039871231084, -0.5854544855134971, -0.20816159484924335`}, {
    0.461356206383864, -0.5611088996560508, -0.19950538654437358`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5431099643448393, -0.5924835974670974, -0.19749453248903248`}, {
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.5825372045115768, -0.6096319582097897, -0.21675802958570295`}, {
    0.5204039871231084, -0.5854544855134971, -0.20816159484924335`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.5543330019515704, -0.604726911219895, -0.25196954634162294`}, {
    0.5296515960248482, -0.5958580455279544, -0.2515845081118029}, {
    0.5825372045115768, -0.6096319582097897, -0.21675802958570295`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5543330019515704, -0.604726911219895, -0.25196954634162294`}, {
    0.4925795519732687, -0.5910954623679224, -0.29554773118396116`}, {
    0.4811249564266876, -0.585151974032458, -0.2860742984158683}, {
    0.5296515960248482, -0.5958580455279544, -0.2515845081118029}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4925795519732687, -0.5910954623679224, -0.29554773118396116`}, {
    0.43697355918951436`, -0.5826314122526858, -0.3398683238140667}, {
    0.4365551681661225, -0.5777936049257504, -0.32099644718097237`}, {
    0.4811249564266876, -0.585151974032458, -0.2860742984158683}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.43697355918951436`, -0.5826314122526858, -0.3398683238140667}, {
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.39544905581618517`, -0.5740389519912366, -0.35717979235010267`}, {
    0.4365551681661225, -0.5777936049257504, -0.32099644718097237`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.41963760015901447`, -0.5810366771432508, -0.3550779693653199}, {
    0.4375200535371022, -0.5877135047513313, -0.3591582529035913}, {
    0.41027620202761383`, -0.5861088600394483, -0.38422691935919384`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.41963760015901447`, -0.5810366771432508, -0.3550779693653199}, {
    0.45488267153483286`, -0.5848491491162138, -0.32491619395345206`}, {
    0.46615250600961755`, -0.5908975428290927, -0.33484194093648584`}, {
    0.4375200535371022, -0.5877135047513313, -0.3591582529035913}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.45488267153483286`, -0.5848491491162138, -0.32491619395345206`}, {
    0.4925795519732687, -0.5910954623679224, -0.2955477311839612}, {
    0.49634519379760245`, -0.595614232557123, -0.31104298811316416`}, {
    0.46615250600961755`, -0.5908975428290927, -0.33484194093648584`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4925795519732687, -0.5910954623679224, -0.2955477311839612}, {
    0.5518056130029987, -0.6207813146283735, -0.34487850812687415`}, {
    0.5437365170115114, -0.6194466649498231, -0.3510197768048997}, {
    0.49634519379760245`, -0.595614232557123, -0.31104298811316416`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5518056130029987, -0.6207813146283735, -0.34487850812687415`}, {
    0.6151364564558499, -0.6513209538944295, -0.39802947182437354`}, {
    0.593696451805427, -0.643767236897451, -0.3934133114373311}, {
    0.5437365170115114, -0.6194466649498231, -0.3510197768048997}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6151364564558499, -0.6513209538944295, -0.39802947182437354`}, {
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.6471256199373834, -0.6694402964869484, -0.43885530547477725`}, {
    0.593696451805427, -0.643767236897451, -0.3934133114373311}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.5739560409372104, -0.6457005460543618, -0.4304670307029078}, {
    0.5612928240005222, -0.639447521013253, -0.41919337488646585`}, {
    0.6471256199373834, -0.6694402964869484, -0.43885530547477725`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5739560409372104, -0.6457005460543618, -0.4304670307029078}, {
    0.4756173846484537, -0.6115080659765835, -0.40767204398438894`}, {
    0.4828178508766534, -0.6120226278718142, -0.4012148338270782}, {
    0.5612928240005222, -0.639447521013253, -0.41919337488646585`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4756173846484537, -0.6115080659765835, -0.40767204398438894`}, {
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.41027620202761383`, -0.5861088600394483, -0.38422691935919384`}, {
    0.4828178508766534, -0.6120226278718142, -0.4012148338270782}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.6592097133507697, -0.6592097133507697, -0.3662276185282054}, {
    0.6456860811433847, -0.6529409809315125, -0.35549008961826795`}, {
    0.6647257540000352, -0.6721945826966648, -0.42572323570788767`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6592097133507697, -0.6592097133507697, -0.3662276185282054}, {
    0.6389520625760421, -0.6389520625760421, -0.2839786944782409}, {
    0.629668395546924, -0.6367433213395861, -0.2900719574991448}, {
    0.6456860811433847, -0.6529409809315125, -0.35549008961826795`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6389520625760421, -0.6389520625760421, -0.2839786944782409}, {
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.6163788869098672, -0.6233044923807646, -0.22854498053961364`}, {
    0.629668395546924, -0.6367433213395861, -0.2900719574991448}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.5764288482631306, -0.6103364275727265, -0.23735305516717142`}, {
    0.5796080893522857, -0.6137026828435966, -0.2522999918357008}, {
    0.6163788869098672, -0.6233044923807646, -0.22854498053961364`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5764288482631306, -0.6103364275727265, -0.23735305516717142`}, {
    0.5330126623440324, -0.5996392451370365, -0.2665063311720162}, {
    0.5448850795979028, -0.605427866219892, -0.2758060279446175}, {
    0.5796080893522857, -0.6137026828435966, -0.2522999918357008}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5330126623440324, -0.5996392451370365, -0.2665063311720162}, {
    0.4925795519732687, -0.5910954623679224, -0.2955477311839612}, {
    0.5120744169386685, -0.5985285392789631, -0.29926426963948155`}, {
    0.5448850795979028, -0.605427866219892, -0.2758060279446175}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4925795519732687, -0.5910954623679224, -0.2955477311839612}, {
    0.5518056130029987, -0.6207813146283735, -0.34487850812687415`}, {
    0.5599842480618302, -0.6222047200687002, -0.33875590314851456`}, {
    0.5120744169386685, -0.5985285392789631, -0.29926426963948155`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5518056130029987, -0.6207813146283735, -0.34487850812687415`}, {
    0.6151364564558499, -0.6513209538944295, -0.39802947182437354`}, {
    0.6105500670057994, -0.6464647768296701, -0.3806959241330279}, {
    0.5599842480618302, -0.6222047200687002, -0.33875590314851456`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6151364564558499, -0.6513209538944295, -0.39802947182437354`}, {
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.6647257540000352, -0.6721945826966648, -0.42572323570788767`}, {
    0.6105500670057994, -0.6464647768296701, -0.3806959241330279}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.30835878902578173`, -0.46253818353867265`, -0.038544848628222717`}, {
    0.3272755515504841, -0.47507741354102534`, -0.052786379282336135`}, {
    0.324812266811562, -0.47150167762968676`, -0.020955630116874954`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.30835878902578173`, -0.46253818353867265`, -0.038544848628222717`}, {
    0.3133278126499405, -0.46999171897491077`, -0.07833195316248512}, {
    0.33173110157337826`, -0.48154514744522653`, -0.0856080262124847}, {
    0.3272755515504841, -0.47507741354102534`, -0.052786379282336135`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3133278126499405, -0.46999171897491077`, -0.07833195316248512}, {
    0.32119984116648215`, -0.4817997617497233, -0.12044994043743079`}, {
    0.3379835236888404, -0.4906212440644457, -0.11992963743797559`}, {
    0.33173110157337826`, -0.48154514744522653`, -0.0856080262124847}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.32119984116648215`, -0.4817997617497233, -0.12044994043743079`}, {
    0.3314637051921916, -0.4971955577882874, -0.1657318525960958}, {
    0.3457858768371393, -0.5019472405700409, -0.1561613637329016}, {
    0.3379835236888404, -0.4906212440644457, -0.11992963743797559`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3314637051921916, -0.4971955577882874, -0.1657318525960958}, {
    0.39765544300931854`, -0.530207257345758, -0.176735752448586}, {
    0.3994358934176101, -0.5286651530527192, -0.16447360317195706`}, {
    0.3457858768371393, -0.5019472405700409, -0.1561613637329016}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.39765544300931854`, -0.530207257345758, -0.176735752448586}, {
    0.4681662066691236, -0.5617994480029483, -0.18726648266764945`}, {
    0.4558187389930595, -0.5543741420185859, -0.17247195529467113`}, {
    0.3994358934176101, -0.5286651530527192, -0.16447360317195706`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4681662066691236, -0.5617994480029483, -0.18726648266764945`}, {
    0.5431099643448393, -0.5924835974670974, -0.19749453248903248`}, {
    0.5149712865819899, -0.5793426974047388, -0.18023995030369647`}, {
    0.4558187389930595, -0.5543741420185859, -0.17247195529467113`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5431099643448393, -0.5924835974670974, -0.19749453248903248`}, {
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.577110853908633, -0.6039532192067091, -0.18789655708653166`}, {
    0.5149712865819899, -0.5793426974047388, -0.18023995030369647`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.5340787945649619, -0.5826314122526858, -0.14565785306317142`}, {
    0.508005053276671, -0.571505684936255, -0.13970138965108453`}, {
    0.577110853908633, -0.6039532192067091, -0.18789655708653166`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5340787945649619, -0.5826314122526858, -0.14565785306317142`}, {
    0.4519868652439711, -0.5423842382927654, -0.09039737304879422}, {
    0.4430198761700281, -0.5388079575040883, -0.09578808133406011}, {
    0.508005053276671, -0.571505684936255, -0.13970138965108453`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4519868652439711, -0.5423842382927654, -0.09039737304879422}, {
    0.3760334842623161, -0.5013779790164214, -0.04178149825136846}, {
    0.38188535180948235`, -0.5054364950419619, -0.05615961056021798}, {
    0.4430198761700281, -0.5388079575040883, -0.09578808133406011}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3760334842623161, -0.5013779790164214, -0.04178149825136846}, {
    0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.324812266811562, -0.47150167762968676`, -0.020955630116874954`}, {
    0.38188535180948235`, -0.5054364950419619, -0.05615961056021798}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.3521297960868685, -0.4875643330433564, -0.02708690739129757}, {
    0.3705256111237356, -0.49772097016621203`, -0.027651165009233997`}, {
    0.33331950097178215`, -0.47617071567397445`, -0.005290785729710824}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3521297960868685, -0.4875643330433564, -0.02708690739129757}, {
    0.4006616635511933, -0.5151364245658201, -0.057237380507313335`}, {
    0.4096523388389484, -0.5192776126127516, -0.05192776126127516}, {
    0.3705256111237356, -0.49772097016621203`, -0.027651165009233997`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4006616635511933, -0.5151364245658201, -0.057237380507313335`}, {
    0.4519868652439711, -0.5423842382927654, -0.09039737304879422}, {
    0.45057871430700847`, -0.5406944571684102, -0.07810031047988147}, {
    0.4096523388389484, -0.5192776126127516, -0.05192776126127516}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4519868652439711, -0.5423842382927654, -0.09039737304879422}, {
    0.49876346636093416`, -0.5611088996560509, -0.06234543329511677}, {
    0.48816098568500393`, -0.5561327685019032, -0.055613276850190324`}, {
    0.45057871430700847`, -0.5406944571684102, -0.07810031047988147}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.49876346636093416`, -0.5611088996560509, -0.06234543329511677}, {
    0.5487568617464034, -0.5810366771432506, -0.03227981539684726}, {
    0.5277877792683088, -0.5723000016162385, -0.03179444453423547}, {
    0.48816098568500393`, -0.5561327685019032, -0.055613276850190324`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5487568617464034, -0.5810366771432506, -0.03227981539684726}, {
    0.6020420732135735, -0.6020420732135735, 0.}, {
    0.5694735663591197, -0.5891105858887445, -0.006545673176541602}, {
    0.5277877792683088, -0.5723000016162385, -0.03179444453423547}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, -0.6020420732135735, 0.}, {
    0.49629010408701807`, -0.5583263670978953, 0.}, {
    0.4861669055664677, -0.5538610316580012, -0.006154011462866676}, {
    0.5694735663591197, -0.5891105858887445, -0.006545673176541602}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49629010408701807`, -0.5583263670978953, 0.}, {
    0.3979707523500161, -0.5116766815928779, 0.}, {
    0.40751773325855134`, -0.5165717745530933, -0.005739686383923255}, {
    0.4861669055664677, -0.5538610316580012, -0.006154011462866676}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3979707523500161, -0.5116766815928779, 0.}, {
    0.3066580952458096, -0.45998714286871445`, 0.}, {
    0.33331950097178215`, -0.47617071567397445`, -0.005290785729710824}, {
    0.40751773325855134`, -0.5165717745530933, -0.005739686383923255}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, -0.6020420732135735, 0.}, {
    0.6044295191828238, -0.6044295191828238, -0.06715883546475819}, {
    0.5939764691589027, -0.6006503620708005, -0.0734128220308756}, {
    0.5913037838451686, -0.597947646585002, -0.01993158821950005}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6044295191828238, -0.6044295191828238, -0.06715883546475819}, {
    0.6115080659765835, -0.6115080659765835, -0.13589068132812965`}, {
    0.5996388334008513, -0.6063763483828833, -0.12801278465860869`}, {
    0.5939764691589027, -0.6006503620708005, -0.0734128220308756}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6115080659765835, -0.6115080659765835, -0.13589068132812965`}, {
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.6081719439707838, -0.615005336599669, -0.1845016009799007}, {
    0.5996388334008513, -0.6063763483828833, -0.12801278465860869`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.5628929014012727, -0.596004248542524, -0.16555673570625667`}, {
    0.560676306835095, -0.5936572660606888, -0.15171241243773156`}, {
    0.6081719439707838, -0.615005336599669, -0.1845016009799007}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5628929014012727, -0.596004248542524, -0.16555673570625667`}, {
    0.5060163098682655, -0.5692683486017988, -0.12650407746706638`}, {
    0.5152602653744724, -0.5725114059716361, -0.1208635190384565}, {
    0.560676306835095, -0.5936572660606888, -0.15171241243773156`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5060163098682655, -0.5692683486017988, -0.12650407746706638`}, {
    0.4519868652439711, -0.5423842382927654, -0.09039737304879422}, {
    0.4716982811963126, -0.5513356533463394, -0.09188927555772322}, {
    0.5152602653744724, -0.5725114059716361, -0.1208635190384565}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4519868652439711, -0.5423842382927654, -0.09039737304879422}, {
    0.49876346636093416`, -0.5611088996560509, -0.06234543329511677}, {
    0.5094822152479099, -0.5660913502754555, -0.06918894281144455}, {
    0.4716982811963126, -0.5513356533463394, -0.09188927555772322}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.49876346636093416`, -0.5611088996560509, -0.06234543329511677}, {
    0.5487568617464034, -0.5810366771432506, -0.03227981539684726}, {
    0.5493362280674016, -0.5816501238360723, -0.04523945407613895}, {
    0.5094822152479099, -0.5660913502754555, -0.06918894281144455}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5487568617464034, -0.5810366771432506, -0.03227981539684726}, {
    0.6020420732135735, -0.6020420732135735, 0.}, {
    0.5913037838451686, -0.597947646585002, -0.01993158821950005}, {
    0.5493362280674016, -0.5816501238360723, -0.04523945407613895}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.4756173846484537, -0.6115080659765835, -0.40767204398438894`}, {
    0.48721825136857155`, -0.6176006003263583, -0.4185959624434206}, {
    0.41445824199145676`, -0.5920832028449382, -0.4013008374837915}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4756173846484537, -0.6115080659765835, -0.40767204398438894`}, {
    0.5739560409372104, -0.6457005460543618, -0.4304670307029078}, {
    0.5660318008824062, -0.6448463554356526, -0.43706252979527566`}, {
    0.48721825136857155`, -0.6176006003263583, -0.4185959624434206}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5739560409372104, -0.6457005460543618, -0.4304670307029078}, {
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.6524642864965196, -0.6749630549963996, -0.4574749594975597}, {
    0.5660318008824062, -0.6448463554356526, -0.43706252979527566`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.6409750644401281, -0.6786794799954298, -0.49015740221892146`}, {
    0.6187258872685492, -0.670907588604451, -0.484544369547659}, {
    0.6524642864965196, -0.6749630549963996, -0.4574749594975597}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6409750644401281, -0.6786794799954298, -0.49015740221892146`}, {
    0.6001728499508097, -0.6751944561946608, -0.5251512437069583}, {
    0.5866559059525488, -0.6683421713383466, -0.5123956646927323}, {
    0.6187258872685492, -0.670907588604451, -0.484544369547659}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6001728499508097, -0.6751944561946608, -0.5251512437069583}, {
    0.5616987892757247, -0.6740385471308696, -0.5616987892757247}, {
    0.5560382810696715, -0.6672459372836057, -0.5412105935744802}, {
    0.5866559059525488, -0.6683421713383466, -0.5123956646927323}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5616987892757247, -0.6740385471308696, -0.5616987892757247}, {
    0.49871361404698694`, -0.6412032180604118, -0.49871361404698694`}, {
    0.5058735949853128, -0.641248218995467, -0.4916236345631913}, {
    0.5560382810696715, -0.6672459372836057, -0.5412105935744802}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.49871361404698694`, -0.6412032180604118, -0.49871361404698694`}, {
    0.4407985310247471, -0.6103364275727268, -0.4407985310247471}, {
    0.4589425074132659, -0.6164899353312527, -0.4452427310725714}, {
    0.5058735949853128, -0.641248218995467, -0.4916236345631913}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4407985310247471, -0.6103364275727268, -0.4407985310247471}, {
    0.38650287499487973`, -0.5797543124923197, -0.38650287499487973`}, {
    0.41445824199145676`, -0.5920832028449382, -0.4013008374837915}, {
    0.4589425074132659, -0.6164899353312527, -0.4452427310725714}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.6409750644401281, -0.6786794799954298, -0.49015740221892146`}, {
    0.6468362024341406, -0.6848853908126196, -0.5098591242716168}, {
    0.6814262655051632, -0.6890827403984796, -0.4823579182789357}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6409750644401281, -0.6786794799954298, -0.49015740221892146`}, {
    0.6001728499508097, -0.6751944561946608, -0.5251512437069583}, {
    0.614016318705615, -0.68224035411735, -0.5382118349147983}, {
    0.6468362024341406, -0.6848853908126196, -0.5098591242716168}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6001728499508097, -0.6751944561946608, -0.5251512437069583}, {
    0.5616987892757247, -0.6740385471308696, -0.5616987892757247}, {
    0.5827295292403942, -0.6811124367744867, -0.5675936973120723}, {
    0.614016318705615, -0.68224035411735, -0.5382118349147983}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5616987892757247, -0.6740385471308696, -0.5616987892757247}, {
    0.6327645227143793, -0.7118600880536767, -0.6327645227143793}, {
    0.6407214117452011, -0.7119126797168901, -0.6249011299737146}, {
    0.5827295292403942, -0.6811124367744867, -0.5675936973120723}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6327645227143793, -0.7118600880536767, -0.6327645227143793}, {
    0.7198653019554957, -0.7622103197175837, -0.7198653019554957}, {
    0.7087220368790109, -0.7504115684601292, -0.6920462242465636}, {
    0.6407214117452011, -0.7119126797168901, -0.6249011299737146}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.7198653019554957, -0.7622103197175837, -0.7198653019554957}, {
    0.9068996821171088, -0.9068996821171088, -0.9068996821171088}, {
    0.8014503466375957, -0.8104554067121754, -0.7834402264884363}, {
    0.7087220368790109, -0.7504115684601292, -0.6920462242465636}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.9068996821171088, -0.9068996821171088, -0.9068996821171088}, {
    0.7640699024805022, -0.7640699024805022, -0.6791732466493353}, {
    0.7436741413969546, -0.7520300306261339, -0.6601152491051621}, {
    0.8014503466375957, -0.8104554067121754, -0.7834402264884363}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.7640699024805022, -0.7640699024805022, -0.6791732466493353}, {
    0.7171888530767329, -0.7171888530767329, -0.5578135523930144}, {
    0.7082077892481158, -0.716165180138544, -0.5649747532204069}, {
    0.7436741413969546, -0.7520300306261339, -0.6601152491051621}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.7171888530767329, -0.7171888530767329, -0.5578135523930144}, {
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.6814262655051632, -0.6890827403984796, -0.4823579182789357}, {
    0.7082077892481158, -0.716165180138544, -0.5649747532204069}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {
    0.07756663751797302, -0.005171109167864868, -0.005171109167864868}, {
    0.11600941429253843`, -0.013921129715104607`, -0.008765155746547347}, {
    0.05793069453624921, -0.0038620463024166113`, -0.0012873487674722039`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.07756663751797302, -0.005171109167864868, -0.005171109167864868}, {
    0.15308565553031123`, -0.02041142073737483, -0.02041142073737483}, {
    0.17441633647095503`, -0.030232164988298865`, -0.02248032781181198}, {
    0.11600941429253843`, -0.013921129715104607`, -0.008765155746547347}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.15308565553031123`, -0.02041142073737483, -0.02041142073737483}, {
    0.22479511109484523`, -0.04495902221896904, -0.04495902221896904}, {
    0.23065124757750236`, -0.052280949450900525`, -0.04202978289190042}, {
    0.17441633647095503`, -0.030232164988298865`, -0.02248032781181198}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.22479511109484523`, -0.04495902221896904, -0.04495902221896904}, {
    0.2914261673100827, -0.07771364461602205, -0.07771364461602205}, {
    0.2837917818761621, -0.07946169892532537, -0.0668487308419404}, {
    0.23065124757750236`, -0.052280949450900525`, -0.04202978289190042}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.2914261673100827, -0.07771364461602205, -0.07771364461602205}, {
    0.35229120018115184`, -0.11743040006038394`, -0.11743040006038394`}, {
    0.3333736846483348, -0.11112456154944492`, -0.09630795334285228}, {
    0.2837917818761621, -0.07946169892532537, -0.0668487308419404}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.35229120018115184`, -0.11743040006038394`, -0.11743040006038394`}, {
    0.3579949935256501, -0.14319799741026004`, -0.09546533160684004}, {
    0.3407298274347052, -0.131748866608086, -0.08026080379573056}, {
    0.3333736846483348, -0.11112456154944492`, -0.09630795334285228}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3579949935256501, -0.14319799741026004`, -0.09546533160684004}, {
    0.37415229431745833`, -0.1746044040148139, -0.07483045886349166}, {
    0.3552530406979347, -0.15631133790709126`, -0.0647349985271792}, {
    0.3407298274347052, -0.131748866608086, -0.08026080379573056}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.37415229431745833`, -0.1746044040148139, -0.07483045886349166}, {
    0.3983729048897056, -0.21246554927450964`, -0.05311638731862741}, {
    0.3754334096530939, -0.18521381542885962`, -0.04838919502195432}, {
    0.3552530406979347, -0.15631133790709126`, -0.0647349985271792}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3983729048897056, -0.21246554927450964`, -0.05311638731862741}, {
    0.42781593715312194`, -0.2566895622918732, -0.028521062476874796`}, {
    0.39956209892042155`, -0.21842728074316375`, -0.030189136362876293`}, {
    0.3754334096530939, -0.18521381542885962`, -0.04838919502195432}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.42781593715312194`, -0.2566895622918732, -0.028521062476874796`}, {
    0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.4260763439843505, -0.2556458063906103, -0.009468363199652228}, {
    0.39956209892042155`, -0.21842728074316375`, -0.030189136362876293`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.38905011534806727`, -0.20749339485230253`, 0.}, {
    0.36589693116182753`, -0.18050915270650156`, -0.008131042914707273}, {
    0.4260763439843505, -0.2556458063906103, -0.009468363199652228}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38905011534806727`, -0.20749339485230253`, 0.}, {
    0.30673802522798127`, -0.1226952100911925, 0.}, {
    0.2982832465218531, -0.11533618865511652`, -0.006628516589374509}, {
    0.36589693116182753`, -0.18050915270650156`, -0.008131042914707273}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.30673802522798127`, -0.1226952100911925, 0.}, {
    0.21282462147366246`, -0.05675323239297665, 0.}, {
    0.22335095439184463`, -0.06253826722971649, -0.004963354542040988}, {
    0.2982832465218531, -0.11533618865511652`, -0.006628516589374509}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21282462147366246`, -0.05675323239297665, 0.}, {
    0.10920608786993075`, -0.014560811715990765`, 0.}, {
    0.142224790973981, -0.0246522971021567, -0.003160550910532909}, {
    0.22335095439184463`, -0.06253826722971649, -0.004963354542040988}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.10920608786993075`, -0.014560811715990765`, 0.}, {
    0., 0., 0.}, {
    0.05793069453624921, -0.0038620463024166113`, -0.0012873487674722039`}, {
    0.142224790973981, -0.0246522971021567, -0.003160550910532909}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.4664505261905705, -0.3109670174603803, -0.06219340349207606}, {
    0.4603228910236794, -0.2966525297708156, -0.07978930111077108}, {
    0.45062802082557046`, -0.29040472453203425`, -0.03004186805503801}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4664505261905705, -0.3109670174603803, -0.06219340349207606}, {
    0.48461849963627207`, -0.3230789997575147, -0.12923159990300587`}, {
    0.4773844806346105, -0.3076477764089712, -0.1336676545776909}, {
    0.4603228910236794, -0.2966525297708156, -0.07978930111077108}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.48461849963627207`, -0.3230789997575147, -0.12923159990300587`}, {
    0.5115370291932914, -0.3410246861288609, -0.20461481167731652`}, {
    0.49999529440342494`, -0.3222191897266516, -0.19333151383599095`}, {
    0.4773844806346105, -0.3076477764089712, -0.1336676545776909}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5115370291932914, -0.3410246861288609, -0.20461481167731652`}, {
    0.5440012355218949, -0.36266749034792994`, -0.29013399227834397`}, {
    0.5263215102011988, -0.3391849732407725, -0.25965194503259137`}, {
    0.49999529440342494`, -0.3222191897266516, -0.19333151383599095`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5440012355218949, -0.36266749034792994`, -0.29013399227834397`}, {
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.5549429157801637, -0.3576298790583277, -0.3329657494680982}, {
    0.5263215102011988, -0.3391849732407725, -0.25965194503259137`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.5418425399938036, -0.3251055239962821, -0.3251055239962821}, {
    0.5235616495156941, -0.30948310838038806`, -0.2862137017352461}, {
    0.5549429157801637, -0.3576298790583277, -0.3329657494680982}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5418425399938036, -0.3251055239962821, -0.3251055239962821}, {
    0.5012123976166442, -0.2673132787288769, -0.2673132787288769}, {
    0.49007301405696324`, -0.2635503764484113, -0.24176935360143517`}, {
    0.5235616495156941, -0.30948310838038806`, -0.2862137017352461}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5012123976166442, -0.2673132787288769, -0.2673132787288769}, {
    0.4566708874648107, -0.21311308081691166`, -0.21311308081691166`}, {
    0.4539150995168281, -0.2198966482103745, -0.19972264378740437`}, {
    0.49007301405696324`, -0.2635503764484113, -0.24176935360143517`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4566708874648107, -0.21311308081691166`, -0.21311308081691166`}, {
    0.40726070505008105`, -0.1629042820200324, -0.1629042820200324}, {
    0.4146226594222878, -0.1787484353953863, -0.1603207616432846}, {
    0.4539150995168281, -0.2198966482103745, -0.19972264378740437`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.40726070505008105`, -0.1629042820200324, -0.1629042820200324}, {
    0.35229120018115184`, -0.11743040006038394`, -0.11743040006038394`}, {
    0.37184302234147004`, -0.1404740306623331, -0.12394767411382335`}, {
    0.4146226594222878, -0.1787484353953863, -0.1603207616432846}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.35229120018115184`, -0.11743040006038394`, -0.11743040006038394`}, {
    0.3579949935256501, -0.14319799741026004`, -0.09546533160684004}, {
    0.37788015107523965`, -0.16290833179688105`, -0.10580644230106709`}, {
    0.37184302234147004`, -0.1404740306623331, -0.12394767411382335`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3579949935256501, -0.14319799741026004`, -0.09546533160684004}, {
    0.37415229431745833`, -0.1746044040148139, -0.07483045886349166}, {
    0.38991864684146027`, -0.18889392224764073`, -0.08838155995073098}, {
    0.37788015107523965`, -0.16290833179688105`, -0.10580644230106709`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.37415229431745833`, -0.1746044040148139, -0.07483045886349166}, {
    0.3983729048897056, -0.21246554927450964`, -0.05311638731862741}, {
    0.40689371670049274`, -0.2188183987589316, -0.07052824422808539}, {
    0.38991864684146027`, -0.18889392224764073`, -0.08838155995073098}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3983729048897056, -0.21246554927450964`, -0.05311638731862741}, {
    0.42781593715312194`, -0.2566895622918732, -0.028521062476874796`}, {
    0.4275386729168246, -0.2527228599908341, -0.05130464075001894}, {
    0.40689371670049274`, -0.2188183987589316, -0.07052824422808539}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.42781593715312194`, -0.2566895622918732, -0.028521062476874796`}, {
    0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.45062802082557046`, -0.29040472453203425`, -0.03004186805503801}, {
    0.4275386729168246, -0.2527228599908341, -0.05130464075001894}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {
    0.10920608786993075`, -0.014560811715990765`, 0.}, {
    0.142224790973981, -0.0246522971021567, 0.003160550910532909}, {
    0.05793069453624921, -0.0038620463024166113`, 0.0012873487674722039`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.10920608786993075`, -0.014560811715990765`, 0.}, {
    0.21282462147366246`, -0.05675323239297665, 0.}, {
    0.22335095439184463`, -0.06253826722971648, 0.004963354542040988}, {
    0.142224790973981, -0.0246522971021567, 0.003160550910532909}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21282462147366246`, -0.05675323239297665, 0.}, {
    0.30673802522798127`, -0.1226952100911925, 0.}, {
    0.2982832465218531, -0.11533618865511652`, 0.006628516589374509}, {
    0.22335095439184463`, -0.06253826722971648, 0.004963354542040988}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.30673802522798127`, -0.1226952100911925, 0.}, {
    0.38905011534806727`, -0.20749339485230253`, 0.}, {
    0.36589693116182753`, -0.18050915270650156`, 0.008131042914707273}, {
    0.2982832465218531, -0.11533618865511652`, 0.006628516589374509}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38905011534806727`, -0.20749339485230253`, 0.}, {
    0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.4260763439843505, -0.2556458063906103, 0.009468363199652228}, {
    0.36589693116182753`, -0.18050915270650156`, 0.008131042914707273}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.42781593715312194`, -0.2566895622918732, 0.028521062476874796`}, {
    0.39956209892042155`, -0.21842728074316375`, 0.030189136362876293`}, {
    0.4260763439843505, -0.2556458063906103, 0.009468363199652228}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.42781593715312194`, -0.2566895622918732, 
    0.028521062476874796`}, {0.3983729048897056, -0.21246554927450964`, 
    0.05311638731862741}, {0.3754334096530939, -0.18521381542885962`, 
    0.04838919502195432}, {0.39956209892042155`, -0.21842728074316375`, 
    0.030189136362876293`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3983729048897056, -0.21246554927450964`, 
    0.05311638731862741}, {0.37415229431745833`, -0.1746044040148139, 
    0.07483045886349166}, {0.3552530406979347, -0.15631133790709126`, 
    0.0647349985271792}, {0.3754334096530939, -0.18521381542885962`, 
    0.04838919502195432}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.37415229431745833`, -0.1746044040148139, 
    0.07483045886349166}, {0.3579949935256501, -0.14319799741026004`, 
    0.09546533160684004}, {0.3407298274347052, -0.131748866608086, 
    0.08026080379573056}, {0.3552530406979347, -0.15631133790709126`, 
    0.0647349985271792}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3579949935256501, -0.14319799741026004`, 
    0.09546533160684004}, {0.35229120018115184`, -0.11743040006038394`, 
    0.11743040006038394`}, {0.3333736846483348, -0.11112456154944492`, 
    0.09630795334285228}, {0.3407298274347052, -0.131748866608086, 
    0.08026080379573056}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.35229120018115184`, -0.11743040006038394`, 
    0.11743040006038394`}, {0.2914261673100827, -0.07771364461602205, 
    0.07771364461602205}, {0.2837917818761621, -0.07946169892532537, 
    0.0668487308419404}, {0.3333736846483348, -0.11112456154944492`, 
    0.09630795334285228}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2914261673100827, -0.07771364461602205, 
    0.07771364461602205}, {0.22479511109484523`, -0.04495902221896904, 
    0.04495902221896904}, {0.23065124757750236`, -0.052280949450900525`, 
    0.04202978289190042}, {0.2837917818761621, -0.07946169892532537, 
    0.0668487308419404}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.22479511109484523`, -0.04495902221896904, 
    0.04495902221896904}, {0.15308565553031123`, -0.02041142073737483, 
    0.02041142073737483}, {0.17441633647095503`, -0.030232164988298865`, 
    0.02248032781181198}, {0.23065124757750236`, -0.052280949450900525`, 
    0.04202978289190042}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.15308565553031123`, -0.02041142073737483, 
    0.02041142073737483}, {0.07756663751797302, -0.005171109167864868, 
    0.005171109167864868}, {0.11600941429253843`, -0.013921129715104607`, 
    0.008765155746547347}, {0.17441633647095503`, -0.030232164988298865`, 
    0.02248032781181198}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07756663751797302, -0.005171109167864868, 
    0.005171109167864868}, {0., 0., 0.}, {
    0.05793069453624921, -0.0038620463024166113`, 0.0012873487674722039`}, {
    0.11600941429253843`, -0.013921129715104607`, 0.008765155746547347}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.42781593715312194`, -0.2566895622918732, 0.028521062476874796`}, {
    0.4275386729168246, -0.2527228599908341, 0.05130464075001894}, {
    0.45062802082557046`, -0.29040472453203425`, 0.03004186805503801}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.42781593715312194`, -0.2566895622918732, 
    0.028521062476874796`}, {0.3983729048897056, -0.21246554927450964`, 
    0.05311638731862741}, {0.40689371670049274`, -0.2188183987589316, 
    0.07052824422808539}, {0.4275386729168246, -0.2527228599908341, 
    0.05130464075001894}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3983729048897056, -0.21246554927450964`, 
    0.05311638731862741}, {0.37415229431745833`, -0.1746044040148139, 
    0.07483045886349166}, {0.38991864684146027`, -0.18889392224764073`, 
    0.08838155995073098}, {0.40689371670049274`, -0.2188183987589316, 
    0.07052824422808539}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.37415229431745833`, -0.1746044040148139, 
    0.07483045886349166}, {0.3579949935256501, -0.14319799741026004`, 
    0.09546533160684004}, {0.37788015107523965`, -0.16290833179688105`, 
    0.10580644230106709`}, {0.38991864684146027`, -0.18889392224764073`, 
    0.08838155995073098}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3579949935256501, -0.14319799741026004`, 
    0.09546533160684004}, {0.35229120018115184`, -0.11743040006038394`, 
    0.11743040006038394`}, {0.37184302234147004`, -0.1404740306623331, 
    0.12394767411382335`}, {0.37788015107523965`, -0.16290833179688105`, 
    0.10580644230106709`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.35229120018115184`, -0.11743040006038394`, 
    0.11743040006038394`}, {0.40726070505008105`, -0.1629042820200324, 
    0.1629042820200324}, {0.4146226594222878, -0.1787484353953863, 
    0.1603207616432846}, {0.37184302234147004`, -0.1404740306623331, 
    0.12394767411382335`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.40726070505008105`, -0.1629042820200324, 
    0.1629042820200324}, {0.4566708874648107, -0.21311308081691166`, 
    0.21311308081691166`}, {0.4539150995168281, -0.2198966482103745, 
    0.19972264378740437`}, {0.4146226594222878, -0.1787484353953863, 
    0.1603207616432846}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4566708874648107, -0.21311308081691166`, 
    0.21311308081691166`}, {0.5012123976166442, -0.2673132787288769, 
    0.2673132787288769}, {0.49007301405696324`, -0.2635503764484113, 
    0.24176935360143517`}, {0.4539150995168281, -0.2198966482103745, 
    0.19972264378740437`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5012123976166442, -0.2673132787288769, 
    0.2673132787288769}, {0.5418425399938036, -0.3251055239962821, 
    0.3251055239962821}, {0.5235616495156941, -0.30948310838038806`, 
    0.2862137017352461}, {0.49007301405696324`, -0.2635503764484113, 
    0.24176935360143517`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5418425399938036, -0.3251055239962821, 
    0.3251055239962821}, {0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.5549429157801637, -0.3576298790583277, 
    0.3329657494680982}, {0.5235616495156941, -0.30948310838038806`, 
    0.2862137017352461}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.5440012355218949, -0.36266749034792994`, 
    0.29013399227834397`}, {0.5263215102011988, -0.3391849732407725, 
    0.25965194503259137`}, {0.5549429157801637, -0.3576298790583277, 
    0.3329657494680982}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5440012355218949, -0.36266749034792994`, 
    0.29013399227834397`}, {0.5115370291932914, -0.3410246861288609, 
    0.20461481167731652`}, {0.49999529440342494`, -0.3222191897266516, 
    0.19333151383599095`}, {0.5263215102011988, -0.3391849732407725, 
    0.25965194503259137`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5115370291932914, -0.3410246861288609, 
    0.20461481167731652`}, {0.48461849963627207`, -0.3230789997575147, 
    0.12923159990300587`}, {0.4773844806346105, -0.3076477764089712, 
    0.13366765457769092`}, {0.49999529440342494`, -0.3222191897266516, 
    0.19333151383599095`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.48461849963627207`, -0.3230789997575147, 
    0.12923159990300587`}, {0.4664505261905705, -0.3109670174603803, 
    0.06219340349207606}, {0.4603228910236794, -0.2966525297708156, 
    0.07978930111077108}, {0.4773844806346105, -0.3076477764089712, 
    0.13366765457769092`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4664505261905705, -0.3109670174603803, 
    0.06219340349207606}, {0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.45062802082557046`, -0.29040472453203425`, 0.03004186805503801}, {
    0.4603228910236794, -0.2966525297708156, 0.07978930111077108}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.6103364275727268, -0.4407985310247471, -0.4407985310247471}, {
    0.6164899353312527, -0.4589425074132659, -0.4452427310725714}, {
    0.5920832028449382, -0.41445824199145676`, -0.4013008374837915}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6103364275727268, -0.4407985310247471, -0.4407985310247471}, {
    0.6412032180604118, -0.49871361404698694`, -0.49871361404698694`}, {
    0.641248218995467, -0.5058735949853128, -0.4916236345631913}, {
    0.6164899353312527, -0.4589425074132659, -0.4452427310725714}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6412032180604118, -0.49871361404698694`, -0.49871361404698694`}, {
    0.6740385471308696, -0.5616987892757247, -0.5616987892757247}, {
    0.6672459372836057, -0.5560382810696715, -0.5412105935744802}, {
    0.641248218995467, -0.5058735949853128, -0.4916236345631913}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6740385471308696, -0.5616987892757247, -0.5616987892757247}, {
    0.6751944561946608, -0.6001728499508097, -0.5251512437069583}, {
    0.6683421713383466, -0.5866559059525488, -0.5123956646927323}, {
    0.6672459372836057, -0.5560382810696715, -0.5412105935744802}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6751944561946608, -0.6001728499508097, -0.5251512437069583}, {
    0.6786794799954298, -0.6409750644401281, -0.49015740221892146`}, {
    0.670907588604451, -0.6187258872685492, -0.484544369547659}, {
    0.6683421713383466, -0.5866559059525488, -0.5123956646927323}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6786794799954298, -0.6409750644401281, -0.49015740221892146`}, {
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.6749630549963996, -0.6524642864965196, -0.4574749594975597}, {
    0.670907588604451, -0.6187258872685492, -0.484544369547659}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.6457005460543618, -0.5739560409372104, -0.4304670307029078}, {
    0.6448463554356526, -0.5660318008824062, -0.43706252979527566`}, {
    0.6749630549963996, -0.6524642864965196, -0.4574749594975597}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6457005460543618, -0.5739560409372104, -0.4304670307029078}, {
    0.6115080659765835, -0.4756173846484537, -0.40767204398438894`}, {
    0.6176006003263583, -0.48721825136857155`, -0.4185959624434206}, {
    0.6448463554356526, -0.5660318008824062, -0.43706252979527566`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6115080659765835, -0.4756173846484537, -0.40767204398438894`}, {
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.5920832028449382, -0.41445824199145676`, -0.4013008374837915}, {
    0.6176006003263583, -0.48721825136857155`, -0.4185959624434206}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.7171888530767329, -0.7171888530767329, -0.5578135523930144}, {
    0.716165180138544, -0.7082077892481158, -0.5649747532204069}, {
    0.6890827403984796, -0.6814262655051632, -0.4823579182789357}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.7171888530767329, -0.7171888530767329, -0.5578135523930144}, {
    0.7640699024805022, -0.7640699024805022, -0.6791732466493353}, {
    0.7520300306261339, -0.7436741413969546, -0.6601152491051621}, {
    0.716165180138544, -0.7082077892481158, -0.5649747532204069}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.7640699024805022, -0.7640699024805022, -0.6791732466493353}, {
    0.9068996821171088, -0.9068996821171088, -0.9068996821171088}, {
    0.8104554067121754, -0.8014503466375957, -0.7834402264884363}, {
    0.7520300306261339, -0.7436741413969546, -0.6601152491051621}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.9068996821171088, -0.9068996821171088, -0.9068996821171088}, {
    0.7622103197175837, -0.7198653019554957, -0.7198653019554957}, {
    0.7504115684601292, -0.7087220368790109, -0.6920462242465636}, {
    0.8104554067121754, -0.8014503466375957, -0.7834402264884363}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.7622103197175837, -0.7198653019554957, -0.7198653019554957}, {
    0.7118600880536767, -0.6327645227143793, -0.6327645227143793}, {
    0.7119126797168901, -0.6407214117452011, -0.6249011299737146}, {
    0.7504115684601292, -0.7087220368790109, -0.6920462242465636}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.7118600880536767, -0.6327645227143793, -0.6327645227143793}, {
    0.6740385471308696, -0.5616987892757247, -0.5616987892757247}, {
    0.6811124367744867, -0.5827295292403942, -0.5675936973120723}, {
    0.7119126797168901, -0.6407214117452011, -0.6249011299737146}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6740385471308696, -0.5616987892757247, -0.5616987892757247}, {
    0.6751944561946608, -0.6001728499508097, -0.5251512437069583}, {
    0.68224035411735, -0.614016318705615, -0.5382118349147983}, {
    0.6811124367744867, -0.5827295292403942, -0.5675936973120723}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6751944561946608, -0.6001728499508097, -0.5251512437069583}, {
    0.6786794799954298, -0.6409750644401281, -0.49015740221892146`}, {
    0.6848853908126196, -0.6468362024341406, -0.5098591242716168}, {
    0.68224035411735, -0.614016318705615, -0.5382118349147983}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6786794799954298, -0.6409750644401281, -0.49015740221892146`}, {
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.6890827403984796, -0.6814262655051632, -0.4823579182789357}, {
    0.6848853908126196, -0.6468362024341406, -0.5098591242716168}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.46253818353867265`, -0.30835878902578173`, -0.038544848628222717`}, {
    0.47507741354102534`, -0.3272755515504841, -0.052786379282336135`}, {
    0.47150167762968676`, -0.324812266811562, -0.020955630116874954`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.46253818353867265`, -0.30835878902578173`, -0.038544848628222717`}, {
    0.46999171897491077`, -0.3133278126499405, -0.07833195316248512}, {
    0.48154514744522653`, -0.33173110157337826`, -0.0856080262124847}, {
    0.47507741354102534`, -0.3272755515504841, -0.052786379282336135`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.46999171897491077`, -0.3133278126499405, -0.07833195316248512}, {
    0.4817997617497233, -0.32119984116648215`, -0.12044994043743079`}, {
    0.4906212440644457, -0.3379835236888404, -0.11992963743797559`}, {
    0.48154514744522653`, -0.33173110157337826`, -0.0856080262124847}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4817997617497233, -0.32119984116648215`, -0.12044994043743079`}, {
    0.4971955577882874, -0.3314637051921916, -0.1657318525960958}, {
    0.5019472405700409, -0.3457858768371393, -0.1561613637329016}, {
    0.4906212440644457, -0.3379835236888404, -0.11992963743797559`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4971955577882874, -0.3314637051921916, -0.1657318525960958}, {
    0.530207257345758, -0.39765544300931854`, -0.176735752448586}, {
    0.5286651530527192, -0.3994358934176101, -0.16447360317195706`}, {
    0.5019472405700409, -0.3457858768371393, -0.1561613637329016}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.530207257345758, -0.39765544300931854`, -0.176735752448586}, {
    0.5617994480029483, -0.4681662066691236, -0.18726648266764945`}, {
    0.5543741420185859, -0.4558187389930595, -0.17247195529467113`}, {
    0.5286651530527192, -0.3994358934176101, -0.16447360317195706`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5617994480029483, -0.4681662066691236, -0.18726648266764945`}, {
    0.5924835974670974, -0.5431099643448393, -0.19749453248903248`}, {
    0.5793426974047388, -0.5149712865819899, -0.18023995030369647`}, {
    0.5543741420185859, -0.4558187389930595, -0.17247195529467113`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5924835974670974, -0.5431099643448393, -0.19749453248903248`}, {
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.6039532192067091, -0.577110853908633, -0.18789655708653166`}, {
    0.5793426974047388, -0.5149712865819899, -0.18023995030369647`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.5826314122526858, -0.5340787945649619, -0.14565785306317142`}, {
    0.571505684936255, -0.508005053276671, -0.13970138965108453`}, {
    0.6039532192067091, -0.577110853908633, -0.18789655708653166`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5826314122526858, -0.5340787945649619, -0.14565785306317142`}, {
    0.5423842382927654, -0.4519868652439711, -0.09039737304879422}, {
    0.5388079575040883, -0.4430198761700281, -0.09578808133406011}, {
    0.571505684936255, -0.508005053276671, -0.13970138965108453`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5423842382927654, -0.4519868652439711, -0.09039737304879422}, {
    0.5013779790164214, -0.3760334842623161, -0.04178149825136846}, {
    0.5054364950419619, -0.38188535180948235`, -0.05615961056021798}, {
    0.5388079575040883, -0.4430198761700281, -0.09578808133406011}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5013779790164214, -0.3760334842623161, -0.04178149825136846}, {
    0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.47150167762968676`, -0.324812266811562, -0.020955630116874954`}, {
    0.5054364950419619, -0.38188535180948235`, -0.05615961056021798}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.4875643330433564, -0.3521297960868685, -0.02708690739129757}, {
    0.49772097016621203`, -0.3705256111237356, -0.027651165009233997`}, {
    0.47617071567397445`, -0.33331950097178215`, -0.005290785729710824}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4875643330433564, -0.3521297960868685, -0.02708690739129757}, {
    0.5151364245658201, -0.4006616635511933, -0.057237380507313335`}, {
    0.5192776126127516, -0.4096523388389484, -0.05192776126127516}, {
    0.49772097016621203`, -0.3705256111237356, -0.027651165009233997`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5151364245658201, -0.4006616635511933, -0.057237380507313335`}, {
    0.5423842382927654, -0.4519868652439711, -0.09039737304879422}, {
    0.5406944571684102, -0.45057871430700847`, -0.07810031047988147}, {
    0.5192776126127516, -0.4096523388389484, -0.05192776126127516}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5423842382927654, -0.4519868652439711, -0.09039737304879422}, {
    0.5611088996560509, -0.49876346636093416`, -0.06234543329511677}, {
    0.5561327685019032, -0.48816098568500393`, -0.055613276850190324`}, {
    0.5406944571684102, -0.45057871430700847`, -0.07810031047988147}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5611088996560509, -0.49876346636093416`, -0.06234543329511677}, {
    0.5810366771432506, -0.5487568617464034, -0.03227981539684726}, {
    0.5723000016162385, -0.5277877792683088, -0.03179444453423547}, {
    0.5561327685019032, -0.48816098568500393`, -0.055613276850190324`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5810366771432506, -0.5487568617464034, -0.03227981539684726}, {
    0.6020420732135735, -0.6020420732135735, 0.}, {
    0.5891105858887445, -0.5694735663591197, -0.006545673176541602}, {
    0.5723000016162385, -0.5277877792683088, -0.03179444453423547}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, -0.6020420732135735, 0.}, {
    0.5583263670978953, -0.49629010408701807`, 0.}, {
    0.5538610316580012, -0.4861669055664677, -0.006154011462866676}, {
    0.5891105858887445, -0.5694735663591197, -0.006545673176541602}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5583263670978953, -0.49629010408701807`, 0.}, {
    0.5116766815928779, -0.3979707523500161, 0.}, {
    0.5165717745530933, -0.40751773325855134`, -0.005739686383923255}, {
    0.5538610316580012, -0.4861669055664677, -0.006154011462866676}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5116766815928779, -0.3979707523500161, 0.}, {
    0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.47617071567397445`, -0.33331950097178215`, -0.005290785729710824}, {
    0.5165717745530933, -0.40751773325855134`, -0.005739686383923255}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, -0.6020420732135735, 0.}, {
    0.6044295191828238, -0.6044295191828238, -0.06715883546475819}, {
    0.6006503620708005, -0.5939764691589027, -0.0734128220308756}, {
    0.597947646585002, -0.5913037838451686, -0.01993158821950005}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6044295191828238, -0.6044295191828238, -0.06715883546475819}, {
    0.6115080659765835, -0.6115080659765835, -0.13589068132812965`}, {
    0.6063763483828833, -0.5996388334008513, -0.12801278465860869`}, {
    0.6006503620708005, -0.5939764691589027, -0.0734128220308756}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6115080659765835, -0.6115080659765835, -0.13589068132812965`}, {
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.615005336599669, -0.6081719439707838, -0.1845016009799007}, {
    0.6063763483828833, -0.5996388334008513, -0.12801278465860869`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.596004248542524, -0.5628929014012727, -0.16555673570625667`}, {
    0.5936572660606888, -0.560676306835095, -0.15171241243773156`}, {
    0.615005336599669, -0.6081719439707838, -0.1845016009799007}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.596004248542524, -0.5628929014012727, -0.16555673570625667`}, {
    0.5692683486017988, -0.5060163098682655, -0.12650407746706638`}, {
    0.5725114059716361, -0.5152602653744724, -0.1208635190384565}, {
    0.5936572660606888, -0.560676306835095, -0.15171241243773156`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5692683486017988, -0.5060163098682655, -0.12650407746706638`}, {
    0.5423842382927654, -0.4519868652439711, -0.09039737304879422}, {
    0.5513356533463394, -0.4716982811963126, -0.09188927555772322}, {
    0.5725114059716361, -0.5152602653744724, -0.1208635190384565}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5423842382927654, -0.4519868652439711, -0.09039737304879422}, {
    0.5611088996560509, -0.49876346636093416`, -0.06234543329511677}, {
    0.5660913502754555, -0.5094822152479099, -0.06918894281144455}, {
    0.5513356533463394, -0.4716982811963126, -0.09188927555772322}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5611088996560509, -0.49876346636093416`, -0.06234543329511677}, {
    0.5810366771432506, -0.5487568617464034, -0.03227981539684726}, {
    0.5816501238360723, -0.5493362280674016, -0.04523945407613895}, {
    0.5660913502754555, -0.5094822152479099, -0.06918894281144455}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5810366771432506, -0.5487568617464034, -0.03227981539684726}, {
    0.6020420732135735, -0.6020420732135735, 0.}, {
    0.597947646585002, -0.5913037838451686, -0.01993158821950005}, {
    0.5816501238360723, -0.5493362280674016, -0.04523945407613895}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.5570985386650793, -0.3713990257767195, -0.32497414755462956`}, {
    0.5567535802997046, -0.3835413553175742, -0.3093075446109469}, {
    0.5740389519912366, -0.39544905581618517`, -0.35717979235010267`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5570985386650793, -0.3713990257767195, -0.32497414755462956`}, {
    0.5355123085516112, -0.35700820570107417`, -0.26775615427580557`}, {
    0.540269926225943, -0.37218594917787184`, -0.26413196393268323`}, {
    0.5567535802997046, -0.3835413553175742, -0.3093075446109469}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5355123085516112, -0.35700820570107417`, -0.26775615427580557`}, {
    0.5153506733137513, -0.34356711554250086`, -0.21472944721406304`}, {
    0.5247789208209833, -0.3615143676766774, -0.22157332212441513`}, {
    0.540269926225943, -0.37218594917787184`, -0.26413196393268323`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5153506733137513, -0.34356711554250086`, -0.21472944721406304`}, {
    0.4971955577882874, -0.3314637051921916, -0.1657318525960958}, {
    0.510556692772321, -0.35171683279870997`, -0.18153126854126964`}, {
    0.5247789208209833, -0.3615143676766774, -0.22157332212441513`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4971955577882874, -0.3314637051921916, -0.1657318525960958}, {
    0.530207257345758, -0.39765544300931854`, -0.176735752448586}, {
    0.5362250673964656, -0.4051478286995518, -0.1906578017409655}, {
    0.510556692772321, -0.35171683279870997`, -0.18153126854126964`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.530207257345758, -0.39765544300931854`, -0.176735752448586}, {
    0.5617994480029483, -0.4681662066691236, -0.18726648266764945`}, {
    0.5611088996560508, -0.461356206383864, -0.19950538654437358`}, {
    0.5362250673964656, -0.4051478286995518, -0.1906578017409655}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5617994480029483, -0.4681662066691236, -0.18726648266764945`}, {
    0.5924835974670974, -0.5431099643448393, -0.19749453248903248`}, {
    0.5854544855134971, -0.5204039871231084, -0.20816159484924335`}, {
    0.5611088996560508, -0.461356206383864, -0.19950538654437358`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5924835974670974, -0.5431099643448393, -0.19749453248903248`}, {
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.6096319582097897, -0.5825372045115768, -0.21675802958570295`}, {
    0.5854544855134971, -0.5204039871231084, -0.20816159484924335`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.604726911219895, -0.5543330019515704, -0.25196954634162294`}, {
    0.5958580455279544, -0.5296515960248482, -0.2515845081118029}, {
    0.6096319582097897, -0.5825372045115768, -0.21675802958570295`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.604726911219895, -0.5543330019515704, -0.25196954634162294`}, {
    0.5910954623679224, -0.4925795519732687, -0.29554773118396116`}, {
    0.585151974032458, -0.4811249564266876, -0.2860742984158683}, {
    0.5958580455279544, -0.5296515960248482, -0.2515845081118029}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5910954623679224, -0.4925795519732687, -0.29554773118396116`}, {
    0.5826314122526858, -0.43697355918951436`, -0.3398683238140667}, {
    0.5777936049257504, -0.4365551681661225, -0.32099644718097237`}, {
    0.585151974032458, -0.4811249564266876, -0.2860742984158683}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5826314122526858, -0.43697355918951436`, -0.3398683238140667}, {
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.5740389519912366, -0.39544905581618517`, -0.35717979235010267`}, {
    0.5777936049257504, -0.4365551681661225, -0.32099644718097237`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.5810366771432508, -0.41963760015901447`, -0.3550779693653199}, {
    0.5877135047513313, -0.4375200535371022, -0.3591582529035913}, {
    0.5861088600394483, -0.41027620202761383`, -0.38422691935919384`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5810366771432508, -0.41963760015901447`, -0.3550779693653199}, {
    0.5848491491162138, -0.45488267153483286`, -0.32491619395345206`}, {
    0.5908975428290927, -0.46615250600961755`, -0.33484194093648584`}, {
    0.5877135047513313, -0.4375200535371022, -0.3591582529035913}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5848491491162138, -0.45488267153483286`, -0.32491619395345206`}, {
    0.5910954623679224, -0.4925795519732687, -0.2955477311839612}, {
    0.595614232557123, -0.49634519379760245`, -0.31104298811316416`}, {
    0.5908975428290927, -0.46615250600961755`, -0.33484194093648584`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5910954623679224, -0.4925795519732687, -0.2955477311839612}, {
    0.6207813146283735, -0.5518056130029987, -0.34487850812687415`}, {
    0.6194466649498231, -0.5437365170115114, -0.3510197768048997}, {
    0.595614232557123, -0.49634519379760245`, -0.31104298811316416`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6207813146283735, -0.5518056130029987, -0.34487850812687415`}, {
    0.6513209538944295, -0.6151364564558499, -0.39802947182437354`}, {
    0.643767236897451, -0.593696451805427, -0.3934133114373311}, {
    0.6194466649498231, -0.5437365170115114, -0.3510197768048997}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6513209538944295, -0.6151364564558499, -0.39802947182437354`}, {
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.6694402964869484, -0.6471256199373834, -0.43885530547477725`}, {
    0.643767236897451, -0.593696451805427, -0.3934133114373311}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.6457005460543618, -0.5739560409372104, -0.4304670307029078}, {
    0.639447521013253, -0.5612928240005222, -0.41919337488646585`}, {
    0.6694402964869484, -0.6471256199373834, -0.43885530547477725`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6457005460543618, -0.5739560409372104, -0.4304670307029078}, {
    0.6115080659765835, -0.4756173846484537, -0.40767204398438894`}, {
    0.6120226278718142, -0.4828178508766534, -0.4012148338270782}, {
    0.639447521013253, -0.5612928240005222, -0.41919337488646585`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6115080659765835, -0.4756173846484537, -0.40767204398438894`}, {
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.5861088600394483, -0.41027620202761383`, -0.38422691935919384`}, {
    0.6120226278718142, -0.4828178508766534, -0.4012148338270782}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.6592097133507697, -0.6592097133507697, -0.3662276185282054}, {
    0.6529409809315125, -0.6456860811433847, -0.35549008961826795`}, {
    0.6721945826966648, -0.6647257540000352, -0.42572323570788767`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6592097133507697, -0.6592097133507697, -0.3662276185282054}, {
    0.6389520625760421, -0.6389520625760421, -0.2839786944782409}, {
    0.6367433213395861, -0.629668395546924, -0.2900719574991448}, {
    0.6529409809315125, -0.6456860811433847, -0.35549008961826795`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6389520625760421, -0.6389520625760421, -0.2839786944782409}, {
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.6233044923807646, -0.6163788869098672, -0.22854498053961364`}, {
    0.6367433213395861, -0.629668395546924, -0.2900719574991448}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6230755279293883, -0.6230755279293883, -0.20769184264312943`}, {
    0.6103364275727265, -0.5764288482631306, -0.23735305516717142`}, {
    0.6137026828435966, -0.5796080893522857, -0.2522999918357008}, {
    0.6233044923807646, -0.6163788869098672, -0.22854498053961364`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6103364275727265, -0.5764288482631306, -0.23735305516717142`}, {
    0.5996392451370365, -0.5330126623440324, -0.2665063311720162}, {
    0.605427866219892, -0.5448850795979028, -0.2758060279446175}, {
    0.6137026828435966, -0.5796080893522857, -0.2522999918357008}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5996392451370365, -0.5330126623440324, -0.2665063311720162}, {
    0.5910954623679224, -0.4925795519732687, -0.2955477311839612}, {
    0.5985285392789631, -0.5120744169386685, -0.29926426963948155`}, {
    0.605427866219892, -0.5448850795979028, -0.2758060279446175}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5910954623679224, -0.4925795519732687, -0.2955477311839612}, {
    0.6207813146283735, -0.5518056130029987, -0.34487850812687415`}, {
    0.6222047200687002, -0.5599842480618302, -0.33875590314851456`}, {
    0.5985285392789631, -0.5120744169386685, -0.29926426963948155`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6207813146283735, -0.5518056130029987, -0.34487850812687415`}, {
    0.6513209538944295, -0.6151364564558499, -0.39802947182437354`}, {
    0.6464647768296701, -0.6105500670057994, -0.3806959241330279}, {
    0.6222047200687002, -0.5599842480618302, -0.33875590314851456`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6513209538944295, -0.6151364564558499, -0.39802947182437354`}, {
    0.6845537086570662, -0.6845537086570662, -0.4563691391047108}, {
    0.6721945826966648, -0.6647257540000352, -0.42572323570788767`}, {
    0.6464647768296701, -0.6105500670057994, -0.3806959241330279}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.5570985386650793, -0.3713990257767195, 
    0.32497414755462956`}, {0.5567535802997046, -0.3835413553175742, 
    0.3093075446109469}, {0.5740389519912366, -0.39544905581618517`, 
    0.35717979235010267`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5570985386650793, -0.3713990257767195, 
    0.32497414755462956`}, {0.5355123085516112, -0.35700820570107417`, 
    0.26775615427580557`}, {0.540269926225943, -0.37218594917787184`, 
    0.26413196393268323`}, {0.5567535802997046, -0.3835413553175742, 
    0.3093075446109469}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5355123085516112, -0.35700820570107417`, 
    0.26775615427580557`}, {0.5153506733137513, -0.34356711554250086`, 
    0.21472944721406304`}, {0.5247789208209833, -0.3615143676766774, 
    0.22157332212441513`}, {0.540269926225943, -0.37218594917787184`, 
    0.26413196393268323`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5153506733137513, -0.34356711554250086`, 
    0.21472944721406304`}, {0.4971955577882874, -0.3314637051921916, 
    0.1657318525960958}, {0.510556692772321, -0.35171683279870997`, 
    0.18153126854126964`}, {0.5247789208209833, -0.3615143676766774, 
    0.22157332212441513`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4971955577882874, -0.3314637051921916, 
    0.1657318525960958}, {0.530207257345758, -0.39765544300931854`, 
    0.176735752448586}, {0.5362250673964656, -0.4051478286995518, 
    0.1906578017409655}, {0.510556692772321, -0.35171683279870997`, 
    0.18153126854126964`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.530207257345758, -0.39765544300931854`, 
    0.176735752448586}, {0.5617994480029483, -0.4681662066691236, 
    0.18726648266764945`}, {0.5611088996560508, -0.461356206383864, 
    0.19950538654437358`}, {0.5362250673964656, -0.4051478286995518, 
    0.1906578017409655}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5617994480029483, -0.4681662066691236, 
    0.18726648266764945`}, {0.5924835974670974, -0.5431099643448393, 
    0.19749453248903248`}, {0.5854544855134971, -0.5204039871231084, 
    0.20816159484924335`}, {0.5611088996560508, -0.461356206383864, 
    0.19950538654437358`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5924835974670974, -0.5431099643448393, 
    0.19749453248903248`}, {0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.6096319582097897, -0.5825372045115768, 
    0.21675802958570295`}, {0.5854544855134971, -0.5204039871231084, 
    0.20816159484924335`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.604726911219895, -0.5543330019515704, 
    0.25196954634162294`}, {0.5958580455279544, -0.5296515960248482, 
    0.2515845081118029}, {0.6096319582097897, -0.5825372045115768, 
    0.21675802958570295`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.604726911219895, -0.5543330019515704, 
    0.25196954634162294`}, {0.5910954623679224, -0.4925795519732687, 
    0.29554773118396116`}, {0.585151974032458, -0.4811249564266876, 
    0.2860742984158683}, {0.5958580455279544, -0.5296515960248482, 
    0.2515845081118029}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, -0.4925795519732687, 
    0.29554773118396116`}, {0.5826314122526858, -0.43697355918951436`, 
    0.3398683238140667}, {0.5777936049257504, -0.4365551681661225, 
    0.32099644718097237`}, {0.585151974032458, -0.4811249564266876, 
    0.2860742984158683}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5826314122526858, -0.43697355918951436`, 
    0.3398683238140667}, {0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.5740389519912366, -0.39544905581618517`, 
    0.35717979235010267`}, {0.5777936049257504, -0.4365551681661225, 
    0.32099644718097237`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.5810366771432508, -0.41963760015901447`, 
    0.3550779693653199}, {0.5877135047513313, -0.4375200535371022, 
    0.3591582529035913}, {0.5861088600394483, -0.41027620202761383`, 
    0.38422691935919384`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432508, -0.41963760015901447`, 
    0.3550779693653199}, {0.5848491491162138, -0.45488267153483286`, 
    0.32491619395345206`}, {0.5908975428290927, -0.46615250600961755`, 
    0.33484194093648584`}, {0.5877135047513313, -0.4375200535371022, 
    0.3591582529035913}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5848491491162138, -0.45488267153483286`, 
    0.32491619395345206`}, {0.5910954623679224, -0.4925795519732687, 
    0.2955477311839612}, {0.595614232557123, -0.49634519379760245`, 
    0.31104298811316416`}, {0.5908975428290927, -0.46615250600961755`, 
    0.33484194093648584`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, -0.4925795519732687, 
    0.2955477311839612}, {0.6207813146283735, -0.5518056130029987, 
    0.34487850812687415`}, {0.6194466649498231, -0.5437365170115114, 
    0.3510197768048997}, {0.595614232557123, -0.49634519379760245`, 
    0.31104298811316416`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6207813146283735, -0.5518056130029987, 
    0.34487850812687415`}, {0.6513209538944295, -0.6151364564558499, 
    0.39802947182437354`}, {0.643767236897451, -0.593696451805427, 
    0.3934133114373311}, {0.6194466649498231, -0.5437365170115114, 
    0.3510197768048997}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6513209538944295, -0.6151364564558499, 
    0.39802947182437354`}, {0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.6694402964869484, -0.6471256199373834, 
    0.43885530547477725`}, {0.643767236897451, -0.593696451805427, 
    0.3934133114373311}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.6457005460543618, -0.5739560409372104, 
    0.4304670307029078}, {0.639447521013253, -0.5612928240005222, 
    0.41919337488646585`}, {0.6694402964869484, -0.6471256199373834, 
    0.43885530547477725`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6457005460543618, -0.5739560409372104, 
    0.4304670307029078}, {0.6115080659765835, -0.4756173846484537, 
    0.40767204398438894`}, {0.6120226278718142, -0.4828178508766534, 
    0.4012148338270782}, {0.639447521013253, -0.5612928240005222, 
    0.41919337488646585`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, -0.4756173846484537, 
    0.40767204398438894`}, {0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.5861088600394483, -0.41027620202761383`, 
    0.38422691935919384`}, {0.6120226278718142, -0.4828178508766534, 
    0.4012148338270782}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.6592097133507697, -0.6592097133507697, 
    0.3662276185282054}, {0.6529409809315125, -0.6456860811433847, 
    0.35549008961826795`}, {0.6721945826966648, -0.6647257540000352, 
    0.42572323570788767`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6592097133507697, -0.6592097133507697, 
    0.3662276185282054}, {0.6389520625760421, -0.6389520625760421, 
    0.2839786944782409}, {0.6367433213395861, -0.629668395546924, 
    0.2900719574991448}, {0.6529409809315125, -0.6456860811433847, 
    0.35549008961826795`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6389520625760421, -0.6389520625760421, 
    0.2839786944782409}, {0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.6233044923807646, -0.6163788869098672, 
    0.22854498053961364`}, {0.6367433213395861, -0.629668395546924, 
    0.2900719574991448}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.6103364275727265, -0.5764288482631306, 
    0.23735305516717142`}, {0.6137026828435966, -0.5796080893522857, 
    0.2522999918357008}, {0.6233044923807646, -0.6163788869098672, 
    0.22854498053961364`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6103364275727265, -0.5764288482631306, 
    0.23735305516717142`}, {0.5996392451370365, -0.5330126623440324, 
    0.2665063311720162}, {0.605427866219892, -0.5448850795979028, 
    0.2758060279446175}, {0.6137026828435966, -0.5796080893522857, 
    0.2522999918357008}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5996392451370365, -0.5330126623440324, 
    0.2665063311720162}, {0.5910954623679224, -0.4925795519732687, 
    0.2955477311839612}, {0.5985285392789631, -0.5120744169386685, 
    0.29926426963948155`}, {0.605427866219892, -0.5448850795979028, 
    0.2758060279446175}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, -0.4925795519732687, 
    0.2955477311839612}, {0.6207813146283735, -0.5518056130029987, 
    0.34487850812687415`}, {0.6222047200687002, -0.5599842480618302, 
    0.33875590314851456`}, {0.5985285392789631, -0.5120744169386685, 
    0.29926426963948155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6207813146283735, -0.5518056130029987, 
    0.34487850812687415`}, {0.6513209538944295, -0.6151364564558499, 
    0.39802947182437354`}, {0.6464647768296701, -0.6105500670057994, 
    0.3806959241330279}, {0.6222047200687002, -0.5599842480618302, 
    0.33875590314851456`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6513209538944295, -0.6151364564558499, 
    0.39802947182437354`}, {0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.6721945826966648, -0.6647257540000352, 
    0.42572323570788767`}, {0.6464647768296701, -0.6105500670057994, 
    0.3806959241330279}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.46253818353867265`, -0.30835878902578173`, 0.038544848628222717`}, {
    0.47507741354102534`, -0.3272755515504841, 0.052786379282336135`}, {
    0.47150167762968676`, -0.324812266811562, 0.020955630116874954`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.46253818353867265`, -0.30835878902578173`, 
    0.038544848628222717`}, {0.46999171897491077`, -0.3133278126499405, 
    0.07833195316248512}, {0.48154514744522653`, -0.33173110157337826`, 
    0.0856080262124847}, {0.47507741354102534`, -0.3272755515504841, 
    0.052786379282336135`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.46999171897491077`, -0.3133278126499405, 
    0.07833195316248512}, {0.4817997617497233, -0.32119984116648215`, 
    0.12044994043743079`}, {0.4906212440644457, -0.3379835236888404, 
    0.11992963743797559`}, {0.48154514744522653`, -0.33173110157337826`, 
    0.0856080262124847}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4817997617497233, -0.32119984116648215`, 
    0.12044994043743079`}, {0.4971955577882874, -0.3314637051921916, 
    0.1657318525960958}, {0.5019472405700409, -0.3457858768371393, 
    0.1561613637329016}, {0.4906212440644457, -0.3379835236888404, 
    0.11992963743797559`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4971955577882874, -0.3314637051921916, 
    0.1657318525960958}, {0.530207257345758, -0.39765544300931854`, 
    0.176735752448586}, {0.5286651530527192, -0.3994358934176101, 
    0.16447360317195706`}, {0.5019472405700409, -0.3457858768371393, 
    0.1561613637329016}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.530207257345758, -0.39765544300931854`, 
    0.176735752448586}, {0.5617994480029483, -0.4681662066691236, 
    0.18726648266764945`}, {0.5543741420185859, -0.4558187389930595, 
    0.17247195529467113`}, {0.5286651530527192, -0.3994358934176101, 
    0.16447360317195706`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5617994480029483, -0.4681662066691236, 
    0.18726648266764945`}, {0.5924835974670974, -0.5431099643448393, 
    0.19749453248903248`}, {0.5793426974047388, -0.5149712865819899, 
    0.18023995030369647`}, {0.5543741420185859, -0.4558187389930595, 
    0.17247195529467113`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5924835974670974, -0.5431099643448393, 
    0.19749453248903248`}, {0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.6039532192067091, -0.577110853908633, 
    0.18789655708653166`}, {0.5793426974047388, -0.5149712865819899, 
    0.18023995030369647`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.5826314122526858, -0.5340787945649619, 
    0.14565785306317142`}, {0.571505684936255, -0.508005053276671, 
    0.13970138965108453`}, {0.6039532192067091, -0.577110853908633, 
    0.18789655708653166`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5826314122526858, -0.5340787945649619, 
    0.14565785306317142`}, {0.5423842382927654, -0.4519868652439711, 
    0.09039737304879422}, {0.5388079575040883, -0.4430198761700281, 
    0.09578808133406011}, {0.571505684936255, -0.508005053276671, 
    0.13970138965108453`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5423842382927654, -0.4519868652439711, 
    0.09039737304879422}, {0.5013779790164214, -0.3760334842623161, 
    0.04178149825136846}, {0.5054364950419619, -0.38188535180948235`, 
    0.05615961056021798}, {0.5388079575040883, -0.4430198761700281, 
    0.09578808133406011}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5013779790164214, -0.3760334842623161, 
    0.04178149825136846}, {0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.47150167762968676`, -0.324812266811562, 0.020955630116874954`}, {
    0.5054364950419619, -0.38188535180948235`, 0.05615961056021798}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.4875643330433564, -0.3521297960868685, 0.02708690739129757}, {
    0.49772097016621203`, -0.3705256111237356, 0.027651165009233997`}, {
    0.47617071567397445`, -0.33331950097178215`, 0.005290785729710824}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4875643330433564, -0.3521297960868685, 
    0.02708690739129757}, {0.5151364245658201, -0.4006616635511933, 
    0.057237380507313335`}, {0.5192776126127516, -0.4096523388389484, 
    0.05192776126127516}, {0.49772097016621203`, -0.3705256111237356, 
    0.027651165009233997`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5151364245658201, -0.4006616635511933, 
    0.057237380507313335`}, {0.5423842382927654, -0.4519868652439711, 
    0.09039737304879422}, {0.5406944571684102, -0.45057871430700847`, 
    0.07810031047988147}, {0.5192776126127516, -0.4096523388389484, 
    0.05192776126127516}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5423842382927654, -0.4519868652439711, 
    0.09039737304879422}, {0.5611088996560509, -0.49876346636093416`, 
    0.06234543329511677}, {0.5561327685019032, -0.48816098568500393`, 
    0.055613276850190324`}, {0.5406944571684102, -0.45057871430700847`, 
    0.07810031047988147}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5611088996560509, -0.49876346636093416`, 
    0.06234543329511677}, {0.5810366771432506, -0.5487568617464034, 
    0.03227981539684726}, {0.5723000016162385, -0.5277877792683088, 
    0.03179444453423547}, {0.5561327685019032, -0.48816098568500393`, 
    0.055613276850190324`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432506, -0.5487568617464034, 
    0.03227981539684726}, {0.6020420732135735, -0.6020420732135735, 0.}, {
    0.5891105858887445, -0.5694735663591197, 0.006545673176541602}, {
    0.5723000016162385, -0.5277877792683088, 0.03179444453423547}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, -0.6020420732135735, 0.}, {
    0.5583263670978953, -0.49629010408701807`, 0.}, {
    0.5538610316580012, -0.4861669055664677, 0.006154011462866676}, {
    0.5891105858887445, -0.5694735663591197, 0.006545673176541602}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5583263670978953, -0.49629010408701807`, 0.}, {
    0.5116766815928779, -0.3979707523500161, 0.}, {
    0.5165717745530933, -0.40751773325855134`, 0.005739686383923255}, {
    0.5538610316580012, -0.4861669055664677, 0.006154011462866676}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5116766815928779, -0.3979707523500161, 0.}, {
    0.45998714286871445`, -0.3066580952458096, 0.}, {
    0.47617071567397445`, -0.33331950097178215`, 0.005290785729710824}, {
    0.5165717745530933, -0.40751773325855134`, 0.005739686383923255}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, -0.6020420732135735, 0.}, {
    0.6044295191828238, -0.6044295191828238, 0.06715883546475819}, {
    0.6006503620708005, -0.5939764691589027, 0.0734128220308756}, {
    0.597947646585002, -0.5913037838451686, 0.01993158821950005}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6044295191828238, -0.6044295191828238, 
    0.06715883546475819}, {0.6115080659765835, -0.6115080659765835, 
    0.13589068132812965`}, {0.6063763483828833, -0.5996388334008513, 
    0.12801278465860869`}, {0.6006503620708005, -0.5939764691589027, 
    0.0734128220308756}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, -0.6115080659765835, 
    0.13589068132812965`}, {0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.615005336599669, -0.6081719439707838, 
    0.1845016009799007}, {0.6063763483828833, -0.5996388334008513, 
    0.12801278465860869`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.6230755279293883, 
    0.20769184264312943`}, {0.596004248542524, -0.5628929014012727, 
    0.16555673570625667`}, {0.5936572660606888, -0.560676306835095, 
    0.15171241243773156`}, {0.615005336599669, -0.6081719439707838, 
    0.1845016009799007}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.596004248542524, -0.5628929014012727, 
    0.16555673570625667`}, {0.5692683486017988, -0.5060163098682655, 
    0.12650407746706638`}, {0.5725114059716361, -0.5152602653744724, 
    0.1208635190384565}, {0.5936572660606888, -0.560676306835095, 
    0.15171241243773156`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5692683486017988, -0.5060163098682655, 
    0.12650407746706638`}, {0.5423842382927654, -0.4519868652439711, 
    0.09039737304879422}, {0.5513356533463394, -0.4716982811963126, 
    0.09188927555772322}, {0.5725114059716361, -0.5152602653744724, 
    0.1208635190384565}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5423842382927654, -0.4519868652439711, 
    0.09039737304879422}, {0.5611088996560509, -0.49876346636093416`, 
    0.06234543329511677}, {0.5660913502754555, -0.5094822152479099, 
    0.06918894281144455}, {0.5513356533463394, -0.4716982811963126, 
    0.09188927555772322}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5611088996560509, -0.49876346636093416`, 
    0.06234543329511677}, {0.5810366771432506, -0.5487568617464034, 
    0.03227981539684726}, {0.5816501238360723, -0.5493362280674016, 
    0.04523945407613895}, {0.5660913502754555, -0.5094822152479099, 
    0.06918894281144455}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432506, -0.5487568617464034, 
    0.03227981539684726}, {0.6020420732135735, -0.6020420732135735, 0.}, {
    0.597947646585002, -0.5913037838451686, 0.01993158821950005}, {
    0.5816501238360723, -0.5493362280674016, 0.04523945407613895}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.6115080659765835, -0.4756173846484537, 
    0.40767204398438894`}, {0.6176006003263583, -0.48721825136857155`, 
    0.4185959624434206}, {0.5920832028449382, -0.41445824199145676`, 
    0.4013008374837915}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, -0.4756173846484537, 
    0.40767204398438894`}, {0.6457005460543618, -0.5739560409372104, 
    0.4304670307029078}, {0.6448463554356526, -0.5660318008824062, 
    0.43706252979527566`}, {0.6176006003263583, -0.48721825136857155`, 
    0.4185959624434206}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6457005460543618, -0.5739560409372104, 
    0.4304670307029078}, {0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.6749630549963996, -0.6524642864965196, 
    0.4574749594975597}, {0.6448463554356526, -0.5660318008824062, 
    0.43706252979527566`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.6786794799954298, -0.6409750644401281, 
    0.49015740221892146`}, {0.670907588604451, -0.6187258872685492, 
    0.484544369547659}, {0.6749630549963996, -0.6524642864965196, 
    0.4574749594975597}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6786794799954298, -0.6409750644401281, 
    0.49015740221892146`}, {0.6751944561946608, -0.6001728499508097, 
    0.5251512437069583}, {0.6683421713383466, -0.5866559059525488, 
    0.5123956646927323}, {0.670907588604451, -0.6187258872685492, 
    0.484544369547659}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6751944561946608, -0.6001728499508097, 
    0.5251512437069583}, {0.6740385471308696, -0.5616987892757247, 
    0.5616987892757247}, {0.6672459372836057, -0.5560382810696715, 
    0.5412105935744802}, {0.6683421713383466, -0.5866559059525488, 
    0.5123956646927323}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6740385471308696, -0.5616987892757247, 
    0.5616987892757247}, {0.6412032180604118, -0.49871361404698694`, 
    0.49871361404698694`}, {0.641248218995467, -0.5058735949853128, 
    0.4916236345631913}, {0.6672459372836057, -0.5560382810696715, 
    0.5412105935744802}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6412032180604118, -0.49871361404698694`, 
    0.49871361404698694`}, {0.6103364275727268, -0.4407985310247471, 
    0.4407985310247471}, {0.6164899353312527, -0.4589425074132659, 
    0.4452427310725714}, {0.641248218995467, -0.5058735949853128, 
    0.4916236345631913}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6103364275727268, -0.4407985310247471, 
    0.4407985310247471}, {0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.5920832028449382, -0.41445824199145676`, 
    0.4013008374837915}, {0.6164899353312527, -0.4589425074132659, 
    0.4452427310725714}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.6786794799954298, -0.6409750644401281, 
    0.49015740221892146`}, {0.6848853908126196, -0.6468362024341406, 
    0.5098591242716168}, {0.6890827403984796, -0.6814262655051632, 
    0.4823579182789357}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6786794799954298, -0.6409750644401281, 
    0.49015740221892146`}, {0.6751944561946608, -0.6001728499508097, 
    0.5251512437069583}, {0.68224035411735, -0.614016318705615, 
    0.5382118349147983}, {0.6848853908126196, -0.6468362024341406, 
    0.5098591242716168}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6751944561946608, -0.6001728499508097, 
    0.5251512437069583}, {0.6740385471308696, -0.5616987892757247, 
    0.5616987892757247}, {0.6811124367744867, -0.5827295292403942, 
    0.5675936973120723}, {0.68224035411735, -0.614016318705615, 
    0.5382118349147983}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6740385471308696, -0.5616987892757247, 
    0.5616987892757247}, {0.7118600880536767, -0.6327645227143793, 
    0.6327645227143793}, {0.7119126797168901, -0.6407214117452011, 
    0.6249011299737146}, {0.6811124367744867, -0.5827295292403942, 
    0.5675936973120723}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7118600880536767, -0.6327645227143793, 
    0.6327645227143793}, {0.7622103197175837, -0.7198653019554957, 
    0.7198653019554957}, {0.7504115684601292, -0.7087220368790109, 
    0.6920462242465636}, {0.7119126797168901, -0.6407214117452011, 
    0.6249011299737146}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7622103197175837, -0.7198653019554957, 
    0.7198653019554957}, {0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {0.8104554067121754, -0.8014503466375957, 
    0.7834402264884363}, {0.7504115684601292, -0.7087220368790109, 
    0.6920462242465636}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {0.7640699024805022, -0.7640699024805022, 
    0.6791732466493353}, {0.7520300306261339, -0.7436741413969546, 
    0.6601152491051621}, {0.8104554067121754, -0.8014503466375957, 
    0.7834402264884363}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7640699024805022, -0.7640699024805022, 
    0.6791732466493353}, {0.7171888530767329, -0.7171888530767329, 
    0.5578135523930144}, {0.716165180138544, -0.7082077892481158, 
    0.5649747532204069}, {0.7520300306261339, -0.7436741413969546, 
    0.6601152491051621}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7171888530767329, -0.7171888530767329, 
    0.5578135523930144}, {0.6845537086570662, -0.6845537086570662, 
    0.4563691391047108}, {0.6890827403984796, -0.6814262655051632, 
    0.4823579182789357}, {0.716165180138544, -0.7082077892481158, 
    0.5649747532204069}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {0.07756663751797302, 
    0.005171109167864868, -0.005171109167864868}, {0.11600941429253843`, 
    0.008765155746547347, -0.013921129715104607`}, {0.05793069453624921, 
    0.0012873487674722039`, -0.0038620463024166113`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07756663751797302, 
    0.005171109167864868, -0.005171109167864868}, {0.15308565553031123`, 
    0.02041142073737483, -0.02041142073737483}, {0.17441633647095503`, 
    0.02248032781181198, -0.030232164988298865`}, {0.11600941429253843`, 
    0.008765155746547347, -0.013921129715104607`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.15308565553031123`, 
    0.02041142073737483, -0.02041142073737483}, {0.22479511109484523`, 
    0.04495902221896904, -0.04495902221896904}, {0.23065124757750236`, 
    0.04202978289190042, -0.052280949450900525`}, {0.17441633647095503`, 
    0.02248032781181198, -0.030232164988298865`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.22479511109484523`, 
    0.04495902221896904, -0.04495902221896904}, {0.2914261673100827, 
    0.07771364461602205, -0.07771364461602205}, {0.2837917818761621, 
    0.0668487308419404, -0.07946169892532537}, {0.23065124757750236`, 
    0.04202978289190042, -0.052280949450900525`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2914261673100827, 
    0.07771364461602205, -0.07771364461602205}, {0.35229120018115184`, 
    0.11743040006038394`, -0.11743040006038394`}, {0.3333736846483348, 
    0.09630795334285228, -0.11112456154944492`}, {0.2837917818761621, 
    0.0668487308419404, -0.07946169892532537}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.35229120018115184`, 
    0.11743040006038394`, -0.11743040006038394`}, {0.3579949935256501, 
    0.09546533160684004, -0.14319799741026004`}, {0.3407298274347052, 
    0.08026080379573056, -0.131748866608086}, {0.3333736846483348, 
    0.09630795334285228, -0.11112456154944492`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3579949935256501, 
    0.09546533160684004, -0.14319799741026004`}, {0.37415229431745833`, 
    0.07483045886349166, -0.1746044040148139}, {0.3552530406979347, 
    0.0647349985271792, -0.15631133790709126`}, {0.3407298274347052, 
    0.08026080379573056, -0.131748866608086}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.37415229431745833`, 
    0.07483045886349166, -0.1746044040148139}, {0.3983729048897056, 
    0.05311638731862741, -0.21246554927450964`}, {0.3754334096530939, 
    0.04838919502195432, -0.18521381542885962`}, {0.3552530406979347, 
    0.0647349985271792, -0.15631133790709126`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3983729048897056, 
    0.05311638731862741, -0.21246554927450964`}, {0.42781593715312194`, 
    0.028521062476874796`, -0.2566895622918732}, {0.39956209892042155`, 
    0.030189136362876293`, -0.21842728074316375`}, {0.3754334096530939, 
    0.04838919502195432, -0.18521381542885962`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.42781593715312194`, 
    0.028521062476874796`, -0.2566895622918732}, {0.45998714286871445`, 
    0., -0.3066580952458096}, {0.4260763439843505, 
    0.009468363199652228, -0.2556458063906103}, {0.39956209892042155`, 
    0.030189136362876293`, -0.21842728074316375`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., -0.3066580952458096}, {
    0.38905011534806727`, 0., -0.20749339485230253`}, {0.36589693116182753`, 
    0.008131042914707273, -0.18050915270650156`}, {0.4260763439843505, 
    0.009468363199652228, -0.2556458063906103}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38905011534806727`, 0., -0.20749339485230253`}, {
    0.30673802522798127`, 0., -0.1226952100911925}, {0.2982832465218531, 
    0.006628516589374509, -0.11533618865511652`}, {0.36589693116182753`, 
    0.008131042914707273, -0.18050915270650156`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.30673802522798127`, 0., -0.1226952100911925}, {
    0.21282462147366246`, 0., -0.05675323239297665}, {0.22335095439184463`, 
    0.004963354542040988, -0.06253826722971649}, {0.2982832465218531, 
    0.006628516589374509, -0.11533618865511652`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21282462147366246`, 0., -0.05675323239297665}, {
    0.10920608786993075`, 0., -0.014560811715990765`}, {0.142224790973981, 
    0.003160550910532909, -0.0246522971021567}, {0.22335095439184463`, 
    0.004963354542040988, -0.06253826722971649}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.10920608786993075`, 0., -0.014560811715990765`}, {
    0., 0., 0.}, {0.05793069453624921, 
    0.0012873487674722039`, -0.0038620463024166113`}, {0.142224790973981, 
    0.003160550910532909, -0.0246522971021567}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., -0.3066580952458096}, {
    0.4664505261905705, 0.06219340349207606, -0.3109670174603803}, {
    0.4603228910236794, 0.07978930111077108, -0.2966525297708156}, {
    0.45062802082557046`, 0.03004186805503801, -0.29040472453203425`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4664505261905705, 
    0.06219340349207606, -0.3109670174603803}, {0.48461849963627207`, 
    0.12923159990300587`, -0.3230789997575147}, {0.4773844806346103, 
    0.13366765457769086`, -0.30764777640897106`}, {0.4603228910236794, 
    0.07978930111077108, -0.2966525297708156}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.48461849963627207`, 
    0.12923159990300587`, -0.3230789997575147}, {0.5115370291932914, 
    0.20461481167731652`, -0.3410246861288609}, {0.4999952944034249, 
    0.19333151383599093`, -0.32221918972665153`}, {0.4773844806346103, 
    0.13366765457769086`, -0.30764777640897106`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5115370291932914, 
    0.20461481167731652`, -0.3410246861288609}, {0.5440012355218949, 
    0.29013399227834397`, -0.36266749034792994`}, {0.5263215102011988, 
    0.25965194503259137`, -0.3391849732407725}, {0.4999952944034249, 
    0.19333151383599093`, -0.32221918972665153`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5440012355218949, 
    0.29013399227834397`, -0.36266749034792994`}, {0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.5549429157801637, 
    0.3329657494680982, -0.3576298790583277}, {0.5263215102011988, 
    0.25965194503259137`, -0.3391849732407725}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.5418425399938036, 
    0.3251055239962821, -0.3251055239962821}, {0.5235616495156941, 
    0.2862137017352461, -0.30948310838038806`}, {0.5549429157801637, 
    0.3329657494680982, -0.3576298790583277}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5418425399938036, 
    0.3251055239962821, -0.3251055239962821}, {0.5012123976166442, 
    0.2673132787288769, -0.2673132787288769}, {0.49007301405696324`, 
    0.24176935360143517`, -0.2635503764484113}, {0.5235616495156941, 
    0.2862137017352461, -0.30948310838038806`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5012123976166442, 
    0.2673132787288769, -0.2673132787288769}, {0.4566708874648107, 
    0.21311308081691166`, -0.21311308081691166`}, {0.4539150995168281, 
    0.19972264378740437`, -0.2198966482103745}, {0.49007301405696324`, 
    0.24176935360143517`, -0.2635503764484113}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4566708874648107, 
    0.21311308081691166`, -0.21311308081691166`}, {0.40726070505008105`, 
    0.1629042820200324, -0.1629042820200324}, {0.4146226594222878, 
    0.1603207616432846, -0.1787484353953863}, {0.4539150995168281, 
    0.19972264378740437`, -0.2198966482103745}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.40726070505008105`, 
    0.1629042820200324, -0.1629042820200324}, {0.35229120018115184`, 
    0.11743040006038394`, -0.11743040006038394`}, {0.37184302234147004`, 
    0.12394767411382335`, -0.1404740306623331}, {0.4146226594222878, 
    0.1603207616432846, -0.1787484353953863}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.35229120018115184`, 
    0.11743040006038394`, -0.11743040006038394`}, {0.3579949935256501, 
    0.09546533160684004, -0.14319799741026004`}, {0.37788015107523965`, 
    0.10580644230106709`, -0.16290833179688105`}, {0.37184302234147004`, 
    0.12394767411382335`, -0.1404740306623331}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3579949935256501, 
    0.09546533160684004, -0.14319799741026004`}, {0.37415229431745833`, 
    0.07483045886349166, -0.1746044040148139}, {0.38991864684146027`, 
    0.08838155995073098, -0.18889392224764073`}, {0.37788015107523965`, 
    0.10580644230106709`, -0.16290833179688105`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.37415229431745833`, 
    0.07483045886349166, -0.1746044040148139}, {0.3983729048897056, 
    0.05311638731862741, -0.21246554927450964`}, {0.40689371670049274`, 
    0.07052824422808539, -0.2188183987589316}, {0.38991864684146027`, 
    0.08838155995073098, -0.18889392224764073`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3983729048897056, 
    0.05311638731862741, -0.21246554927450964`}, {0.42781593715312194`, 
    0.028521062476874796`, -0.2566895622918732}, {0.4275386729168246, 
    0.05130464075001894, -0.2527228599908341}, {0.40689371670049274`, 
    0.07052824422808539, -0.2188183987589316}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.42781593715312194`, 
    0.028521062476874796`, -0.2566895622918732}, {0.45998714286871445`, 
    0., -0.3066580952458096}, {0.45062802082557046`, 
    0.03004186805503801, -0.29040472453203425`}, {0.4275386729168246, 
    0.05130464075001894, -0.2527228599908341}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0., 0., 0.}, {0.10920608786993075`, 
    0., -0.014560811715990765`}, {
    0.142224790973981, -0.003160550910532909, -0.0246522971021567}, {
    0.05793069453624921, -0.0012873487674722039`, -0.0038620463024166113`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.10920608786993075`, 0., -0.014560811715990765`}, {
    0.21282462147366246`, 0., -0.05675323239297665}, {
    0.22335095439184463`, -0.004963354542040988, -0.06253826722971648}, {
    0.142224790973981, -0.003160550910532909, -0.0246522971021567}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21282462147366246`, 0., -0.05675323239297665}, {
    0.30673802522798127`, 0., -0.1226952100911925}, {
    0.2982832465218531, -0.006628516589374509, -0.11533618865511652`}, {
    0.22335095439184463`, -0.004963354542040988, -0.06253826722971648}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.30673802522798127`, 0., -0.1226952100911925}, {
    0.38905011534806727`, 0., -0.20749339485230253`}, {
    0.36589693116182753`, -0.008131042914707273, -0.18050915270650156`}, {
    0.2982832465218531, -0.006628516589374509, -0.11533618865511652`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38905011534806727`, 0., -0.20749339485230253`}, {
    0.45998714286871445`, 0., -0.3066580952458096}, {
    0.4260763439843505, -0.009468363199652228, -0.2556458063906103}, {
    0.36589693116182753`, -0.008131042914707273, -0.18050915270650156`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., -0.3066580952458096}, {
    0.42781593715312194`, -0.028521062476874796`, -0.2566895622918732}, {
    0.39956209892042155`, -0.030189136362876293`, -0.21842728074316375`}, {
    0.4260763439843505, -0.009468363199652228, -0.2556458063906103}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.42781593715312194`, -0.028521062476874796`, -0.2566895622918732}, {
    0.3983729048897056, -0.05311638731862741, -0.21246554927450964`}, {
    0.3754334096530939, -0.04838919502195432, -0.18521381542885962`}, {
    0.39956209892042155`, -0.030189136362876293`, -0.21842728074316375`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3983729048897056, -0.05311638731862741, -0.21246554927450964`}, {
    0.37415229431745833`, -0.07483045886349166, -0.1746044040148139}, {
    0.3552530406979347, -0.0647349985271792, -0.15631133790709126`}, {
    0.3754334096530939, -0.04838919502195432, -0.18521381542885962`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.37415229431745833`, -0.07483045886349166, -0.1746044040148139}, {
    0.3579949935256501, -0.09546533160684004, -0.14319799741026004`}, {
    0.3407298274347052, -0.08026080379573056, -0.131748866608086}, {
    0.3552530406979347, -0.0647349985271792, -0.15631133790709126`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3579949935256501, -0.09546533160684004, -0.14319799741026004`}, {
    0.35229120018115184`, -0.11743040006038394`, -0.11743040006038394`}, {
    0.3333736846483348, -0.09630795334285228, -0.11112456154944492`}, {
    0.3407298274347052, -0.08026080379573056, -0.131748866608086}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.35229120018115184`, -0.11743040006038394`, -0.11743040006038394`}, {
    0.2914261673100827, -0.07771364461602205, -0.07771364461602205}, {
    0.2837917818761621, -0.0668487308419404, -0.07946169892532537}, {
    0.3333736846483348, -0.09630795334285228, -0.11112456154944492`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.2914261673100827, -0.07771364461602205, -0.07771364461602205}, {
    0.22479511109484523`, -0.04495902221896904, -0.04495902221896904}, {
    0.23065124757750236`, -0.04202978289190042, -0.052280949450900525`}, {
    0.2837917818761621, -0.0668487308419404, -0.07946169892532537}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.22479511109484523`, -0.04495902221896904, -0.04495902221896904}, {
    0.15308565553031123`, -0.02041142073737483, -0.02041142073737483}, {
    0.17441633647095503`, -0.02248032781181198, -0.030232164988298865`}, {
    0.23065124757750236`, -0.04202978289190042, -0.052280949450900525`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.15308565553031123`, -0.02041142073737483, -0.02041142073737483}, {
    0.07756663751797302, -0.005171109167864868, -0.005171109167864868}, {
    0.11600941429253843`, -0.008765155746547347, -0.013921129715104607`}, {
    0.17441633647095503`, -0.02248032781181198, -0.030232164988298865`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.07756663751797302, -0.005171109167864868, -0.005171109167864868}, {0., 
    0., 0.}, {
    0.05793069453624921, -0.0012873487674722039`, -0.0038620463024166113`}, {
    0.11600941429253843`, -0.008765155746547347, -0.013921129715104607`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., -0.3066580952458096}, {
    0.42781593715312194`, -0.028521062476874796`, -0.2566895622918732}, {
    0.4275386729168246, -0.05130464075001894, -0.2527228599908341}, {
    0.45062802082557046`, -0.03004186805503801, -0.29040472453203425`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.42781593715312194`, -0.028521062476874796`, -0.2566895622918732}, {
    0.3983729048897056, -0.05311638731862741, -0.21246554927450964`}, {
    0.40689371670049274`, -0.07052824422808539, -0.2188183987589316}, {
    0.4275386729168246, -0.05130464075001894, -0.2527228599908341}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3983729048897056, -0.05311638731862741, -0.21246554927450964`}, {
    0.37415229431745833`, -0.07483045886349166, -0.1746044040148139}, {
    0.38991864684146027`, -0.08838155995073098, -0.18889392224764073`}, {
    0.40689371670049274`, -0.07052824422808539, -0.2188183987589316}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.37415229431745833`, -0.07483045886349166, -0.1746044040148139}, {
    0.3579949935256501, -0.09546533160684004, -0.14319799741026004`}, {
    0.37788015107523965`, -0.10580644230106709`, -0.16290833179688105`}, {
    0.38991864684146027`, -0.08838155995073098, -0.18889392224764073`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.3579949935256501, -0.09546533160684004, -0.14319799741026004`}, {
    0.35229120018115184`, -0.11743040006038394`, -0.11743040006038394`}, {
    0.37184302234147004`, -0.12394767411382335`, -0.1404740306623331}, {
    0.37788015107523965`, -0.10580644230106709`, -0.16290833179688105`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.35229120018115184`, -0.11743040006038394`, -0.11743040006038394`}, {
    0.40726070505008105`, -0.1629042820200324, -0.1629042820200324}, {
    0.4146226594222878, -0.1603207616432846, -0.1787484353953863}, {
    0.37184302234147004`, -0.12394767411382335`, -0.1404740306623331}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.40726070505008105`, -0.1629042820200324, -0.1629042820200324}, {
    0.4566708874648107, -0.21311308081691166`, -0.21311308081691166`}, {
    0.4539150995168281, -0.19972264378740437`, -0.2198966482103745}, {
    0.4146226594222878, -0.1603207616432846, -0.1787484353953863}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4566708874648107, -0.21311308081691166`, -0.21311308081691166`}, {
    0.5012123976166442, -0.2673132787288769, -0.2673132787288769}, {
    0.49007301405696324`, -0.24176935360143517`, -0.2635503764484113}, {
    0.4539150995168281, -0.19972264378740437`, -0.2198966482103745}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5012123976166442, -0.2673132787288769, -0.2673132787288769}, {
    0.5418425399938036, -0.3251055239962821, -0.3251055239962821}, {
    0.5235616495156941, -0.2862137017352461, -0.30948310838038806`}, {
    0.49007301405696324`, -0.24176935360143517`, -0.2635503764484113}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5418425399938036, -0.3251055239962821, -0.3251055239962821}, {
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.5549429157801637, -0.3329657494680982, -0.3576298790583277}, {
    0.5235616495156941, -0.2862137017352461, -0.30948310838038806`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.5440012355218949, -0.29013399227834397`, -0.36266749034792994`}, {
    0.5263215102011988, -0.25965194503259137`, -0.3391849732407725}, {
    0.5549429157801637, -0.3329657494680982, -0.3576298790583277}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5440012355218949, -0.29013399227834397`, -0.36266749034792994`}, {
    0.5115370291932914, -0.20461481167731652`, -0.3410246861288609}, {
    0.4999952944034249, -0.19333151383599093`, -0.32221918972665153`}, {
    0.5263215102011988, -0.25965194503259137`, -0.3391849732407725}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5115370291932914, -0.20461481167731652`, -0.3410246861288609}, {
    0.48461849963627207`, -0.12923159990300587`, -0.3230789997575147}, {
    0.4773844806346103, -0.1336676545776909, -0.30764777640897106`}, {
    0.4999952944034249, -0.19333151383599093`, -0.32221918972665153`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.48461849963627207`, -0.12923159990300587`, -0.3230789997575147}, {
    0.4664505261905705, -0.06219340349207606, -0.3109670174603803}, {
    0.4603228910236794, -0.07978930111077108, -0.2966525297708156}, {
    0.4773844806346103, -0.1336676545776909, -0.30764777640897106`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4664505261905705, -0.06219340349207606, -0.3109670174603803}, {
    0.45998714286871445`, 0., -0.3066580952458096}, {
    0.45062802082557046`, -0.03004186805503801, -0.29040472453203425`}, {
    0.4603228910236794, -0.07978930111077108, -0.2966525297708156}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.6103364275727268, 
    0.4407985310247471, -0.4407985310247471}, {0.6164899353312527, 
    0.4452427310725714, -0.4589425074132659}, {0.5920832028449382, 
    0.4013008374837915, -0.41445824199145676`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6103364275727268, 
    0.4407985310247471, -0.4407985310247471}, {0.6412032180604118, 
    0.49871361404698694`, -0.49871361404698694`}, {0.641248218995467, 
    0.4916236345631913, -0.5058735949853128}, {0.6164899353312527, 
    0.4452427310725714, -0.4589425074132659}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6412032180604118, 
    0.49871361404698694`, -0.49871361404698694`}, {0.6740385471308696, 
    0.5616987892757247, -0.5616987892757247}, {0.6672459372836057, 
    0.5412105935744802, -0.5560382810696715}, {0.641248218995467, 
    0.4916236345631913, -0.5058735949853128}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6740385471308696, 
    0.5616987892757247, -0.5616987892757247}, {0.6751944561946608, 
    0.5251512437069583, -0.6001728499508097}, {0.6683421713383466, 
    0.5123956646927323, -0.5866559059525488}, {0.6672459372836057, 
    0.5412105935744802, -0.5560382810696715}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6751944561946608, 
    0.5251512437069583, -0.6001728499508097}, {0.6786794799954298, 
    0.49015740221892146`, -0.6409750644401281}, {0.670907588604451, 
    0.484544369547659, -0.6187258872685492}, {0.6683421713383466, 
    0.5123956646927323, -0.5866559059525488}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6786794799954298, 
    0.49015740221892146`, -0.6409750644401281}, {0.6845537086570662, 
    0.4563691391047108, -0.6845537086570662}, {0.6749630549963996, 
    0.4574749594975597, -0.6524642864965196}, {0.670907588604451, 
    0.484544369547659, -0.6187258872685492}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 
    0.4563691391047108, -0.6845537086570662}, {0.6457005460543618, 
    0.4304670307029078, -0.5739560409372104}, {0.6448463554356526, 
    0.43706252979527566`, -0.5660318008824062}, {0.6749630549963996, 
    0.4574749594975597, -0.6524642864965196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6457005460543618, 
    0.4304670307029078, -0.5739560409372104}, {0.6115080659765835, 
    0.40767204398438894`, -0.4756173846484537}, {0.6176006003263583, 
    0.4185959624434206, -0.48721825136857155`}, {0.6448463554356526, 
    0.43706252979527566`, -0.5660318008824062}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, 
    0.40767204398438894`, -0.4756173846484537}, {0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.5920832028449382, 
    0.4013008374837915, -0.41445824199145676`}, {0.6176006003263583, 
    0.4185959624434206, -0.48721825136857155`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 
    0.4563691391047108, -0.6845537086570662}, {0.7171888530767329, 
    0.5578135523930144, -0.7171888530767329}, {0.716165180138544, 
    0.5649747532204069, -0.7082077892481158}, {0.6890827403984794, 
    0.48235791827893554`, -0.6814262655051629}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7171888530767329, 
    0.5578135523930144, -0.7171888530767329}, {0.7640699024805022, 
    0.6791732466493353, -0.7640699024805022}, {0.7520300306261339, 
    0.6601152491051621, -0.7436741413969546}, {0.716165180138544, 
    0.5649747532204069, -0.7082077892481158}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7640699024805022, 
    0.6791732466493353, -0.7640699024805022}, {0.9068996821171088, 
    0.9068996821171088, -0.9068996821171088}, {0.8104554067121754, 
    0.7834402264884363, -0.8014503466375957}, {0.7520300306261339, 
    0.6601152491051621, -0.7436741413969546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.9068996821171088, 
    0.9068996821171088, -0.9068996821171088}, {0.7622103197175837, 
    0.7198653019554957, -0.7198653019554957}, {0.7504115684601292, 
    0.6920462242465636, -0.7087220368790109}, {0.8104554067121754, 
    0.7834402264884363, -0.8014503466375957}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7622103197175837, 
    0.7198653019554957, -0.7198653019554957}, {0.7118600880536767, 
    0.6327645227143793, -0.6327645227143793}, {0.7119126797168901, 
    0.6249011299737146, -0.6407214117452011}, {0.7504115684601292, 
    0.6920462242465636, -0.7087220368790109}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7118600880536767, 
    0.6327645227143793, -0.6327645227143793}, {0.6740385471308696, 
    0.5616987892757247, -0.5616987892757247}, {0.6811124367744867, 
    0.5675936973120723, -0.5827295292403942}, {0.7119126797168901, 
    0.6249011299737146, -0.6407214117452011}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6740385471308696, 
    0.5616987892757247, -0.5616987892757247}, {0.6751944561946608, 
    0.5251512437069583, -0.6001728499508097}, {0.68224035411735, 
    0.5382118349147983, -0.614016318705615}, {0.6811124367744867, 
    0.5675936973120723, -0.5827295292403942}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6751944561946608, 
    0.5251512437069583, -0.6001728499508097}, {0.6786794799954298, 
    0.49015740221892146`, -0.6409750644401281}, {0.6848853908126196, 
    0.5098591242716168, -0.6468362024341406}, {0.68224035411735, 
    0.5382118349147983, -0.614016318705615}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6786794799954298, 
    0.49015740221892146`, -0.6409750644401281}, {0.6845537086570662, 
    0.4563691391047108, -0.6845537086570662}, {0.6890827403984794, 
    0.48235791827893554`, -0.6814262655051629}, {0.6848853908126196, 
    0.5098591242716168, -0.6468362024341406}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., -0.3066580952458096}, {
    0.46253818353867265`, 0.038544848628222717`, -0.30835878902578173`}, {
    0.47507741354102534`, 0.052786379282336135`, -0.3272755515504841}, {
    0.47150167762968676`, 0.020955630116874954`, -0.324812266811562}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.46253818353867265`, 
    0.038544848628222717`, -0.30835878902578173`}, {0.46999171897491077`, 
    0.07833195316248512, -0.3133278126499405}, {0.48154514744522636`, 
    0.08560802621248467, -0.33173110157337815`}, {0.47507741354102534`, 
    0.052786379282336135`, -0.3272755515504841}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.46999171897491077`, 
    0.07833195316248512, -0.3133278126499405}, {0.4817997617497233, 
    0.12044994043743079`, -0.32119984116648215`}, {0.4906212440644457, 
    0.11992963743797559`, -0.3379835236888404}, {0.48154514744522636`, 
    0.08560802621248467, -0.33173110157337815`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4817997617497233, 
    0.12044994043743079`, -0.32119984116648215`}, {0.4971955577882874, 
    0.1657318525960958, -0.3314637051921916}, {0.5019472405700409, 
    0.1561613637329016, -0.3457858768371393}, {0.4906212440644457, 
    0.11992963743797559`, -0.3379835236888404}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4971955577882874, 
    0.1657318525960958, -0.3314637051921916}, {0.530207257345758, 
    0.176735752448586, -0.39765544300931854`}, {0.5286651530527192, 
    0.16447360317195706`, -0.3994358934176101}, {0.5019472405700409, 
    0.1561613637329016, -0.3457858768371393}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.530207257345758, 
    0.176735752448586, -0.39765544300931854`}, {0.5617994480029483, 
    0.18726648266764945`, -0.4681662066691236}, {0.5543741420185859, 
    0.17247195529467113`, -0.4558187389930595}, {0.5286651530527192, 
    0.16447360317195706`, -0.3994358934176101}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5617994480029483, 
    0.18726648266764945`, -0.4681662066691236}, {0.5924835974670974, 
    0.19749453248903248`, -0.5431099643448393}, {0.5793426974047388, 
    0.18023995030369647`, -0.5149712865819899}, {0.5543741420185859, 
    0.17247195529467113`, -0.4558187389930595}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5924835974670974, 
    0.19749453248903248`, -0.5431099643448393}, {0.6230755279293883, 
    0.20769184264312943`, -0.6230755279293883}, {0.6039532192067091, 
    0.18789655708653166`, -0.577110853908633}, {0.5793426974047388, 
    0.18023995030369647`, -0.5149712865819899}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 
    0.20769184264312943`, -0.6230755279293883}, {0.5826314122526858, 
    0.14565785306317142`, -0.5340787945649619}, {0.571505684936255, 
    0.13970138965108453`, -0.508005053276671}, {0.6039532192067091, 
    0.18789655708653166`, -0.577110853908633}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5826314122526858, 
    0.14565785306317142`, -0.5340787945649619}, {0.5423842382927654, 
    0.09039737304879422, -0.4519868652439711}, {0.5388079575040883, 
    0.09578808133406011, -0.4430198761700281}, {0.571505684936255, 
    0.13970138965108453`, -0.508005053276671}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5423842382927654, 
    0.09039737304879422, -0.4519868652439711}, {0.5013779790164213, 
    0.041781498251368454`, -0.37603348426231603`}, {0.5054364950419619, 
    0.05615961056021798, -0.38188535180948235`}, {0.5388079575040883, 
    0.09578808133406011, -0.4430198761700281}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5013779790164213, 
    0.041781498251368454`, -0.37603348426231603`}, {0.45998714286871445`, 
    0., -0.3066580952458096}, {0.47150167762968676`, 
    0.020955630116874954`, -0.324812266811562}, {0.5054364950419619, 
    0.05615961056021798, -0.38188535180948235`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., -0.3066580952458096}, {
    0.4875643330433564, 0.02708690739129757, -0.3521297960868685}, {
    0.4977209701662121, 0.027651165009234, -0.37052561112373567`}, {
    0.47617071567397445`, 0.005290785729710824, -0.33331950097178215`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4875643330433564, 
    0.02708690739129757, -0.3521297960868685}, {0.5151364245658201, 
    0.057237380507313335`, -0.4006616635511933}, {0.5192776126127516, 
    0.05192776126127516, -0.4096523388389484}, {0.4977209701662121, 
    0.027651165009234, -0.37052561112373567`}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5151364245658201, 
    0.057237380507313335`, -0.4006616635511933}, {0.5423842382927654, 
    0.09039737304879422, -0.4519868652439711}, {0.5406944571684102, 
    0.07810031047988147, -0.45057871430700847`}, {0.5192776126127516, 
    0.05192776126127516, -0.4096523388389484}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5423842382927654, 
    0.09039737304879422, -0.4519868652439711}, {0.5611088996560509, 
    0.06234543329511677, -0.49876346636093416`}, {0.5561327685019032, 
    0.055613276850190324`, -0.48816098568500393`}, {0.5406944571684102, 
    0.07810031047988147, -0.45057871430700847`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5611088996560509, 
    0.06234543329511677, -0.49876346636093416`}, {0.5810366771432506, 
    0.03227981539684726, -0.5487568617464034}, {0.5723000016162385, 
    0.03179444453423547, -0.5277877792683088}, {0.5561327685019032, 
    0.055613276850190324`, -0.48816098568500393`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432506, 
    0.03227981539684726, -0.5487568617464034}, {0.6020420732135735, 
    0., -0.6020420732135735}, {0.5891105858887445, 
    0.006545673176541602, -0.5694735663591197}, {0.5723000016162385, 
    0.03179444453423547, -0.5277877792683088}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.6020420732135735, 0., -0.6020420732135735}, {
    0.5583263670978953, 0., -0.49629010408701807`}, {0.5538610316580012, 
    0.006154011462866676, -0.4861669055664677}, {0.5891105858887445, 
    0.006545673176541602, -0.5694735663591197}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5583263670978953, 0., -0.49629010408701807`}, {
    0.5116766815928779, 0., -0.3979707523500161}, {0.5165717745530933, 
    0.005739686383923255, -0.40751773325855134`}, {0.5538610316580012, 
    0.006154011462866676, -0.4861669055664677}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5116766815928779, 0., -0.3979707523500161}, {
    0.45998714286871445`, 0., -0.3066580952458096}, {0.47617071567397445`, 
    0.005290785729710824, -0.33331950097178215`}, {0.5165717745530933, 
    0.005739686383923255, -0.40751773325855134`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, 0., -0.6020420732135735}, {
    0.6044295191828238, 0.06715883546475819, -0.6044295191828238}, {
    0.6006503620708005, 0.0734128220308756, -0.5939764691589027}, {
    0.597947646585002, 0.01993158821950005, -0.5913037838451686}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6044295191828238, 
    0.06715883546475819, -0.6044295191828238}, {0.6115080659765835, 
    0.13589068132812965`, -0.6115080659765835}, {0.6063763483828833, 
    0.12801278465860869`, -0.5996388334008513}, {0.6006503620708005, 
    0.0734128220308756, -0.5939764691589027}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, 
    0.13589068132812965`, -0.6115080659765835}, {0.6230755279293883, 
    0.20769184264312943`, -0.6230755279293883}, {0.615005336599669, 
    0.1845016009799007, -0.6081719439707838}, {0.6063763483828833, 
    0.12801278465860869`, -0.5996388334008513}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 
    0.20769184264312943`, -0.6230755279293883}, {0.5960042485425239, 
    0.16555673570625662`, -0.5628929014012725}, {0.5936572660606888, 
    0.15171241243773156`, -0.560676306835095}, {0.615005336599669, 
    0.1845016009799007, -0.6081719439707838}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5960042485425239, 
    0.16555673570625662`, -0.5628929014012725}, {0.5692683486017988, 
    0.12650407746706638`, -0.5060163098682655}, {0.572511405971636, 
    0.12086351903845649`, -0.5152602653744724}, {0.5936572660606888, 
    0.15171241243773156`, -0.560676306835095}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5692683486017988, 
    0.12650407746706638`, -0.5060163098682655}, {0.5423842382927654, 
    0.09039737304879422, -0.4519868652439711}, {0.5513356533463394, 
    0.09188927555772322, -0.4716982811963126}, {0.572511405971636, 
    0.12086351903845649`, -0.5152602653744724}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5423842382927654, 
    0.09039737304879422, -0.4519868652439711}, {0.5611088996560509, 
    0.06234543329511677, -0.49876346636093416`}, {0.5660913502754553, 
    0.06918894281144454, -0.5094822152479098}, {0.5513356533463394, 
    0.09188927555772322, -0.4716982811963126}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5611088996560509, 
    0.06234543329511677, -0.49876346636093416`}, {0.5810366771432506, 
    0.03227981539684726, -0.5487568617464034}, {0.5816501238360723, 
    0.04523945407613895, -0.5493362280674016}, {0.5660913502754553, 
    0.06918894281144454, -0.5094822152479098}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5810366771432506, 
    0.03227981539684726, -0.5487568617464034}, {0.6020420732135735, 
    0., -0.6020420732135735}, {0.597947646585002, 
    0.01993158821950005, -0.5913037838451686}, {0.5816501238360723, 
    0.04523945407613895, -0.5493362280674016}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.5570985386650793, 
    0.32497414755462956`, -0.3713990257767195}, {0.5567535802997043, 
    0.30930754461094684`, -0.3835413553175741}, {0.5740389519912366, 
    0.35717979235010267`, -0.39544905581618517`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5570985386650793, 
    0.32497414755462956`, -0.3713990257767195}, {0.5355123085516112, 
    0.26775615427580557`, -0.35700820570107417`}, {0.540269926225943, 
    0.26413196393268323`, -0.37218594917787184`}, {0.5567535802997043, 
    0.30930754461094684`, -0.3835413553175741}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5355123085516112, 
    0.26775615427580557`, -0.35700820570107417`}, {0.5153506733137513, 
    0.21472944721406304`, -0.34356711554250086`}, {0.5247789208209833, 
    0.22157332212441513`, -0.3615143676766774}, {0.540269926225943, 
    0.26413196393268323`, -0.37218594917787184`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5153506733137513, 
    0.21472944721406304`, -0.34356711554250086`}, {0.4971955577882874, 
    0.1657318525960958, -0.3314637051921916}, {0.510556692772321, 
    0.18153126854126964`, -0.35171683279870997`}, {0.5247789208209833, 
    0.22157332212441513`, -0.3615143676766774}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4971955577882874, 
    0.1657318525960958, -0.3314637051921916}, {0.530207257345758, 
    0.176735752448586, -0.39765544300931854`}, {0.5362250673964656, 
    0.1906578017409655, -0.4051478286995518}, {0.510556692772321, 
    0.18153126854126964`, -0.35171683279870997`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.530207257345758, 
    0.176735752448586, -0.39765544300931854`}, {0.5617994480029483, 
    0.18726648266764945`, -0.4681662066691236}, {0.5611088996560508, 
    0.19950538654437358`, -0.461356206383864}, {0.5362250673964656, 
    0.1906578017409655, -0.4051478286995518}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5617994480029483, 
    0.18726648266764945`, -0.4681662066691236}, {0.5924835974670974, 
    0.19749453248903248`, -0.5431099643448393}, {0.5854544855134971, 
    0.20816159484924335`, -0.5204039871231084}, {0.5611088996560508, 
    0.19950538654437358`, -0.461356206383864}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5924835974670974, 
    0.19749453248903248`, -0.5431099643448393}, {0.6230755279293883, 
    0.20769184264312943`, -0.6230755279293883}, {0.6096319582097897, 
    0.21675802958570295`, -0.5825372045115768}, {0.5854544855134971, 
    0.20816159484924335`, -0.5204039871231084}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 
    0.20769184264312943`, -0.6230755279293883}, {0.6047269112198952, 
    0.251969546341623, -0.5543330019515705}, {0.5958580455279544, 
    0.2515845081118029, -0.5296515960248482}, {0.6096319582097897, 
    0.21675802958570295`, -0.5825372045115768}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6047269112198952, 
    0.251969546341623, -0.5543330019515705}, {0.5910954623679224, 
    0.29554773118396116`, -0.4925795519732687}, {0.585151974032458, 
    0.2860742984158683, -0.4811249564266876}, {0.5958580455279544, 
    0.2515845081118029, -0.5296515960248482}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, 
    0.29554773118396116`, -0.4925795519732687}, {0.5826314122526858, 
    0.3398683238140667, -0.43697355918951436`}, {0.5777936049257504, 
    0.32099644718097237`, -0.4365551681661225}, {0.585151974032458, 
    0.2860742984158683, -0.4811249564266876}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5826314122526858, 
    0.3398683238140667, -0.43697355918951436`}, {0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.5740389519912366, 
    0.35717979235010267`, -0.39544905581618517`}, {0.5777936049257504, 
    0.32099644718097237`, -0.4365551681661225}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.5810366771432506, 
    0.3550779693653198, -0.41963760015901436`}, {0.5877135047513313, 
    0.3591582529035913, -0.4375200535371022}, {0.5861088600394483, 
    0.38422691935919384`, -0.41027620202761383`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432506, 
    0.3550779693653198, -0.41963760015901436`}, {0.5848491491162138, 
    0.32491619395345206`, -0.45488267153483286`}, {0.5908975428290927, 
    0.33484194093648584`, -0.46615250600961755`}, {0.5877135047513313, 
    0.3591582529035913, -0.4375200535371022}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5848491491162138, 
    0.32491619395345206`, -0.45488267153483286`}, {0.5910954623679224, 
    0.2955477311839612, -0.4925795519732687}, {0.595614232557123, 
    0.31104298811316416`, -0.49634519379760245`}, {0.5908975428290927, 
    0.33484194093648584`, -0.46615250600961755`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, 
    0.2955477311839612, -0.4925795519732687}, {0.6207813146283735, 
    0.34487850812687415`, -0.5518056130029987}, {0.6194466649498231, 
    0.3510197768048997, -0.5437365170115114}, {0.595614232557123, 
    0.31104298811316416`, -0.49634519379760245`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6207813146283735, 
    0.34487850812687415`, -0.5518056130029987}, {0.6513209538944295, 
    0.39802947182437354`, -0.6151364564558499}, {0.643767236897451, 
    0.3934133114373311, -0.593696451805427}, {0.6194466649498231, 
    0.3510197768048997, -0.5437365170115114}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6513209538944295, 
    0.39802947182437354`, -0.6151364564558499}, {0.6845537086570662, 
    0.4563691391047108, -0.6845537086570662}, {0.6694402964869484, 
    0.43885530547477725`, -0.6471256199373834}, {0.643767236897451, 
    0.3934133114373311, -0.593696451805427}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 
    0.4563691391047108, -0.6845537086570662}, {0.6457005460543618, 
    0.4304670307029078, -0.5739560409372104}, {0.639447521013253, 
    0.41919337488646585`, -0.5612928240005222}, {0.6694402964869484, 
    0.43885530547477725`, -0.6471256199373834}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6457005460543618, 
    0.4304670307029078, -0.5739560409372104}, {0.6115080659765835, 
    0.40767204398438894`, -0.4756173846484537}, {0.6120226278718142, 
    0.4012148338270782, -0.4828178508766534}, {0.639447521013253, 
    0.41919337488646585`, -0.5612928240005222}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, 
    0.40767204398438894`, -0.4756173846484537}, {0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.5861088600394483, 
    0.38422691935919384`, -0.41027620202761383`}, {0.6120226278718142, 
    0.4012148338270782, -0.4828178508766534}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 
    0.4563691391047108, -0.6845537086570662}, {0.6592097133507697, 
    0.3662276185282054, -0.6592097133507697}, {0.6529409809315125, 
    0.35549008961826795`, -0.6456860811433847}, {0.6721945826966649, 
    0.4257232357078877, -0.6647257540000353}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6592097133507697, 
    0.3662276185282054, -0.6592097133507697}, {0.6389520625760421, 
    0.2839786944782409, -0.6389520625760421}, {0.6367433213395861, 
    0.2900719574991448, -0.629668395546924}, {0.6529409809315125, 
    0.35549008961826795`, -0.6456860811433847}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6389520625760421, 
    0.2839786944782409, -0.6389520625760421}, {0.6230755279293883, 
    0.20769184264312943`, -0.6230755279293883}, {0.6233044923807646, 
    0.22854498053961364`, -0.6163788869098672}, {0.6367433213395861, 
    0.2900719574991448, -0.629668395546924}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 
    0.20769184264312943`, -0.6230755279293883}, {0.6103364275727265, 
    0.23735305516717142`, -0.5764288482631306}, {0.6137026828435964, 
    0.25229999183570073`, -0.5796080893522855}, {0.6233044923807646, 
    0.22854498053961364`, -0.6163788869098672}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6103364275727265, 
    0.23735305516717142`, -0.5764288482631306}, {0.5996392451370365, 
    0.2665063311720162, -0.5330126623440324}, {0.605427866219892, 
    0.2758060279446175, -0.5448850795979028}, {0.6137026828435964, 
    0.25229999183570073`, -0.5796080893522855}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5996392451370365, 
    0.2665063311720162, -0.5330126623440324}, {0.5910954623679224, 
    0.2955477311839612, -0.4925795519732687}, {0.5985285392789631, 
    0.29926426963948155`, -0.5120744169386685}, {0.605427866219892, 
    0.2758060279446175, -0.5448850795979028}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, 
    0.2955477311839612, -0.4925795519732687}, {0.6207813146283735, 
    0.34487850812687415`, -0.5518056130029987}, {0.6222047200687002, 
    0.33875590314851456`, -0.5599842480618302}, {0.5985285392789631, 
    0.29926426963948155`, -0.5120744169386685}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6207813146283735, 
    0.34487850812687415`, -0.5518056130029987}, {0.6513209538944295, 
    0.39802947182437354`, -0.6151364564558499}, {0.6464647768296701, 
    0.3806959241330279, -0.6105500670057994}, {0.6222047200687002, 
    0.33875590314851456`, -0.5599842480618302}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6513209538944295, 
    0.39802947182437354`, -0.6151364564558499}, {0.6845537086570662, 
    0.4563691391047108, -0.6845537086570662}, {0.6721945826966649, 
    0.4257232357078877, -0.6647257540000353}, {0.6464647768296701, 
    0.3806959241330279, -0.6105500670057994}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.5570985386650793, -0.32497414755462956`, -0.3713990257767195}, {
    0.5567535802997043, -0.30930754461094684`, -0.3835413553175741}, {
    0.5740389519912366, -0.35717979235010267`, -0.39544905581618517`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5570985386650793, -0.32497414755462956`, -0.3713990257767195}, {
    0.5355123085516112, -0.26775615427580557`, -0.35700820570107417`}, {
    0.540269926225943, -0.26413196393268323`, -0.37218594917787184`}, {
    0.5567535802997043, -0.30930754461094684`, -0.3835413553175741}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5355123085516112, -0.26775615427580557`, -0.35700820570107417`}, {
    0.5153506733137513, -0.21472944721406304`, -0.34356711554250086`}, {
    0.5247789208209833, -0.22157332212441513`, -0.3615143676766774}, {
    0.540269926225943, -0.26413196393268323`, -0.37218594917787184`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5153506733137513, -0.21472944721406304`, -0.34356711554250086`}, {
    0.4971955577882874, -0.1657318525960958, -0.3314637051921916}, {
    0.510556692772321, -0.18153126854126964`, -0.35171683279870997`}, {
    0.5247789208209833, -0.22157332212441513`, -0.3615143676766774}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4971955577882874, -0.1657318525960958, -0.3314637051921916}, {
    0.530207257345758, -0.176735752448586, -0.39765544300931854`}, {
    0.5362250673964656, -0.1906578017409655, -0.4051478286995518}, {
    0.510556692772321, -0.18153126854126964`, -0.35171683279870997`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.530207257345758, -0.176735752448586, -0.39765544300931854`}, {
    0.5617994480029483, -0.18726648266764945`, -0.4681662066691236}, {
    0.5611088996560508, -0.19950538654437358`, -0.461356206383864}, {
    0.5362250673964656, -0.1906578017409655, -0.4051478286995518}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5617994480029483, -0.18726648266764945`, -0.4681662066691236}, {
    0.5924835974670974, -0.19749453248903248`, -0.5431099643448393}, {
    0.5854544855134971, -0.20816159484924335`, -0.5204039871231084}, {
    0.5611088996560508, -0.19950538654437358`, -0.461356206383864}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5924835974670974, -0.19749453248903248`, -0.5431099643448393}, {
    0.6230755279293883, -0.20769184264312943`, -0.6230755279293883}, {
    0.6096319582097897, -0.21675802958570295`, -0.5825372045115768}, {
    0.5854544855134971, -0.20816159484924335`, -0.5204039871231084}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6230755279293883, -0.20769184264312943`, -0.6230755279293883}, {
    0.6047269112198952, -0.251969546341623, -0.5543330019515705}, {
    0.5958580455279544, -0.2515845081118029, -0.5296515960248482}, {
    0.6096319582097897, -0.21675802958570295`, -0.5825372045115768}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6047269112198952, -0.251969546341623, -0.5543330019515705}, {
    0.5910954623679224, -0.29554773118396116`, -0.4925795519732687}, {
    0.585151974032458, -0.2860742984158683, -0.4811249564266876}, {
    0.5958580455279544, -0.2515845081118029, -0.5296515960248482}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5910954623679224, -0.29554773118396116`, -0.4925795519732687}, {
    0.5826314122526858, -0.3398683238140667, -0.43697355918951436`}, {
    0.5777936049257504, -0.32099644718097237`, -0.4365551681661225}, {
    0.585151974032458, -0.2860742984158683, -0.4811249564266876}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5826314122526858, -0.3398683238140667, -0.43697355918951436`}, {
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.5740389519912366, -0.35717979235010267`, -0.39544905581618517`}, {
    0.5777936049257504, -0.32099644718097237`, -0.4365551681661225}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.5810366771432506, -0.3550779693653198, -0.41963760015901436`}, {
    0.5877135047513313, -0.3591582529035913, -0.4375200535371022}, {
    0.5861088600394483, -0.38422691935919384`, -0.41027620202761383`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5810366771432506, -0.3550779693653198, -0.41963760015901436`}, {
    0.5848491491162138, -0.32491619395345206`, -0.45488267153483286`}, {
    0.5908975428290927, -0.33484194093648584`, -0.46615250600961755`}, {
    0.5877135047513313, -0.3591582529035913, -0.4375200535371022}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5848491491162138, -0.32491619395345206`, -0.45488267153483286`}, {
    0.5910954623679224, -0.2955477311839612, -0.4925795519732687}, {
    0.595614232557123, -0.31104298811316416`, -0.49634519379760245`}, {
    0.5908975428290927, -0.33484194093648584`, -0.46615250600961755`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5910954623679224, -0.2955477311839612, -0.4925795519732687}, {
    0.6207813146283735, -0.34487850812687415`, -0.5518056130029987}, {
    0.6194466649498231, -0.3510197768048997, -0.5437365170115114}, {
    0.595614232557123, -0.31104298811316416`, -0.49634519379760245`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6207813146283735, -0.34487850812687415`, -0.5518056130029987}, {
    0.6513209538944295, -0.39802947182437354`, -0.6151364564558499}, {
    0.643767236897451, -0.3934133114373311, -0.593696451805427}, {
    0.6194466649498231, -0.3510197768048997, -0.5437365170115114}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6513209538944295, -0.39802947182437354`, -0.6151364564558499}, {
    0.6845537086570662, -0.4563691391047108, -0.6845537086570662}, {
    0.6694402964869484, -0.43885530547477725`, -0.6471256199373834}, {
    0.643767236897451, -0.3934133114373311, -0.593696451805427}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6845537086570662, -0.4563691391047108, -0.6845537086570662}, {
    0.6457005460543618, -0.4304670307029078, -0.5739560409372104}, {
    0.639447521013253, -0.41919337488646585`, -0.5612928240005222}, {
    0.6694402964869484, -0.43885530547477725`, -0.6471256199373834}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6457005460543618, -0.4304670307029078, -0.5739560409372104}, {
    0.6115080659765835, -0.40767204398438894`, -0.4756173846484537}, {
    0.6120226278718142, -0.4012148338270782, -0.4828178508766534}, {
    0.639447521013253, -0.41919337488646585`, -0.5612928240005222}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6115080659765835, -0.40767204398438894`, -0.4756173846484537}, {
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.5861088600394483, -0.38422691935919384`, -0.41027620202761383`}, {
    0.6120226278718142, -0.4012148338270782, -0.4828178508766534}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6845537086570662, -0.4563691391047108, -0.6845537086570662}, {
    0.6592097133507697, -0.3662276185282054, -0.6592097133507697}, {
    0.6529409809315125, -0.35549008961826795`, -0.6456860811433847}, {
    0.6721945826966649, -0.4257232357078877, -0.6647257540000353}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6592097133507697, -0.3662276185282054, -0.6592097133507697}, {
    0.6389520625760421, -0.2839786944782409, -0.6389520625760421}, {
    0.6367433213395861, -0.2900719574991448, -0.629668395546924}, {
    0.6529409809315125, -0.35549008961826795`, -0.6456860811433847}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6389520625760421, -0.2839786944782409, -0.6389520625760421}, {
    0.6230755279293883, -0.20769184264312943`, -0.6230755279293883}, {
    0.6233044923807646, -0.22854498053961364`, -0.6163788869098672}, {
    0.6367433213395861, -0.2900719574991448, -0.629668395546924}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6230755279293883, -0.20769184264312943`, -0.6230755279293883}, {
    0.6103364275727265, -0.23735305516717142`, -0.5764288482631306}, {
    0.6137026828435964, -0.25229999183570073`, -0.5796080893522855}, {
    0.6233044923807646, -0.22854498053961364`, -0.6163788869098672}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6103364275727265, -0.23735305516717142`, -0.5764288482631306}, {
    0.5996392451370365, -0.2665063311720162, -0.5330126623440324}, {
    0.605427866219892, -0.2758060279446175, -0.5448850795979028}, {
    0.6137026828435964, -0.25229999183570073`, -0.5796080893522855}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5996392451370365, -0.2665063311720162, -0.5330126623440324}, {
    0.5910954623679224, -0.2955477311839612, -0.4925795519732687}, {
    0.5985285392789631, -0.29926426963948155`, -0.5120744169386685}, {
    0.605427866219892, -0.2758060279446175, -0.5448850795979028}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5910954623679224, -0.2955477311839612, -0.4925795519732687}, {
    0.6207813146283735, -0.34487850812687415`, -0.5518056130029987}, {
    0.6222047200687002, -0.33875590314851456`, -0.5599842480618302}, {
    0.5985285392789631, -0.29926426963948155`, -0.5120744169386685}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6207813146283735, -0.34487850812687415`, -0.5518056130029987}, {
    0.6513209538944295, -0.39802947182437354`, -0.6151364564558499}, {
    0.6464647768296701, -0.3806959241330279, -0.6105500670057994}, {
    0.6222047200687002, -0.33875590314851456`, -0.5599842480618302}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6513209538944295, -0.39802947182437354`, -0.6151364564558499}, {
    0.6845537086570662, -0.4563691391047108, -0.6845537086570662}, {
    0.6721945826966649, -0.4257232357078877, -0.6647257540000353}, {
    0.6464647768296701, -0.3806959241330279, -0.6105500670057994}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., -0.3066580952458096}, {
    0.46253818353867265`, -0.038544848628222717`, -0.30835878902578173`}, {
    0.47507741354102534`, -0.052786379282336135`, -0.3272755515504841}, {
    0.47150167762968676`, -0.020955630116874954`, -0.324812266811562}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.46253818353867265`, -0.038544848628222717`, -0.30835878902578173`}, {
    0.46999171897491077`, -0.07833195316248512, -0.3133278126499405}, {
    0.48154514744522636`, -0.08560802621248467, -0.33173110157337815`}, {
    0.47507741354102534`, -0.052786379282336135`, -0.3272755515504841}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.46999171897491077`, -0.07833195316248512, -0.3133278126499405}, {
    0.4817997617497233, -0.12044994043743079`, -0.32119984116648215`}, {
    0.4906212440644457, -0.11992963743797559`, -0.3379835236888404}, {
    0.48154514744522636`, -0.08560802621248467, -0.33173110157337815`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4817997617497233, -0.12044994043743079`, -0.32119984116648215`}, {
    0.4971955577882874, -0.1657318525960958, -0.3314637051921916}, {
    0.5019472405700409, -0.1561613637329016, -0.3457858768371393}, {
    0.4906212440644457, -0.11992963743797559`, -0.3379835236888404}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4971955577882874, -0.1657318525960958, -0.3314637051921916}, {
    0.530207257345758, -0.176735752448586, -0.39765544300931854`}, {
    0.5286651530527192, -0.16447360317195706`, -0.3994358934176101}, {
    0.5019472405700409, -0.1561613637329016, -0.3457858768371393}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.530207257345758, -0.176735752448586, -0.39765544300931854`}, {
    0.5617994480029483, -0.18726648266764945`, -0.4681662066691236}, {
    0.5543741420185859, -0.17247195529467113`, -0.4558187389930595}, {
    0.5286651530527192, -0.16447360317195706`, -0.3994358934176101}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5617994480029483, -0.18726648266764945`, -0.4681662066691236}, {
    0.5924835974670974, -0.19749453248903248`, -0.5431099643448393}, {
    0.5793426974047388, -0.18023995030369647`, -0.5149712865819899}, {
    0.5543741420185859, -0.17247195529467113`, -0.4558187389930595}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5924835974670974, -0.19749453248903248`, -0.5431099643448393}, {
    0.6230755279293883, -0.20769184264312943`, -0.6230755279293883}, {
    0.6039532192067091, -0.18789655708653166`, -0.577110853908633}, {
    0.5793426974047388, -0.18023995030369647`, -0.5149712865819899}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6230755279293883, -0.20769184264312943`, -0.6230755279293883}, {
    0.5826314122526858, -0.14565785306317142`, -0.5340787945649619}, {
    0.571505684936255, -0.13970138965108453`, -0.508005053276671}, {
    0.6039532192067091, -0.18789655708653166`, -0.577110853908633}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5826314122526858, -0.14565785306317142`, -0.5340787945649619}, {
    0.5423842382927654, -0.09039737304879422, -0.4519868652439711}, {
    0.5388079575040883, -0.09578808133406011, -0.4430198761700281}, {
    0.571505684936255, -0.13970138965108453`, -0.508005053276671}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5423842382927654, -0.09039737304879422, -0.4519868652439711}, {
    0.5013779790164213, -0.041781498251368454`, -0.37603348426231603`}, {
    0.5054364950419619, -0.05615961056021798, -0.38188535180948235`}, {
    0.5388079575040883, -0.09578808133406011, -0.4430198761700281}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5013779790164213, -0.041781498251368454`, -0.37603348426231603`}, {
    0.45998714286871445`, 0., -0.3066580952458096}, {
    0.47150167762968676`, -0.020955630116874954`, -0.324812266811562}, {
    0.5054364950419619, -0.05615961056021798, -0.38188535180948235`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., -0.3066580952458096}, {
    0.4875643330433564, -0.02708690739129757, -0.3521297960868685}, {
    0.4977209701662121, -0.027651165009234, -0.37052561112373567`}, {
    0.47617071567397445`, -0.005290785729710824, -0.33331950097178215`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.4875643330433564, -0.02708690739129757, -0.3521297960868685}, {
    0.5151364245658201, -0.057237380507313335`, -0.4006616635511933}, {
    0.5192776126127516, -0.05192776126127516, -0.4096523388389484}, {
    0.4977209701662121, -0.027651165009234, -0.37052561112373567`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5151364245658201, -0.057237380507313335`, -0.4006616635511933}, {
    0.5423842382927654, -0.09039737304879422, -0.4519868652439711}, {
    0.5406944571684102, -0.07810031047988147, -0.45057871430700847`}, {
    0.5192776126127516, -0.05192776126127516, -0.4096523388389484}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5423842382927654, -0.09039737304879422, -0.4519868652439711}, {
    0.5611088996560509, -0.06234543329511677, -0.49876346636093416`}, {
    0.5561327685019032, -0.055613276850190324`, -0.48816098568500393`}, {
    0.5406944571684102, -0.07810031047988147, -0.45057871430700847`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5611088996560509, -0.06234543329511677, -0.49876346636093416`}, {
    0.5810366771432506, -0.03227981539684726, -0.5487568617464034}, {
    0.5723000016162385, -0.03179444453423547, -0.5277877792683088}, {
    0.5561327685019032, -0.055613276850190324`, -0.48816098568500393`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5810366771432506, -0.03227981539684726, -0.5487568617464034}, {
    0.6020420732135735, 0., -0.6020420732135735}, {
    0.5891105858887445, -0.006545673176541602, -0.5694735663591197}, {
    0.5723000016162385, -0.03179444453423547, -0.5277877792683088}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, 0., -0.6020420732135735}, {
    0.5583263670978953, 0., -0.49629010408701807`}, {
    0.5538610316580012, -0.006154011462866676, -0.4861669055664677}, {
    0.5891105858887445, -0.006545673176541602, -0.5694735663591197}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5583263670978953, 0., -0.49629010408701807`}, {
    0.5116766815928779, 0., -0.3979707523500161}, {
    0.5165717745530933, -0.005739686383923255, -0.40751773325855134`}, {
    0.5538610316580012, -0.006154011462866676, -0.4861669055664677}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5116766815928779, 0., -0.3979707523500161}, {
    0.45998714286871445`, 0., -0.3066580952458096}, {
    0.47617071567397445`, -0.005290785729710824, -0.33331950097178215`}, {
    0.5165717745530933, -0.005739686383923255, -0.40751773325855134`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, 0., -0.6020420732135735}, {
    0.6044295191828238, -0.06715883546475819, -0.6044295191828238}, {
    0.6006503620708005, -0.0734128220308756, -0.5939764691589027}, {
    0.597947646585002, -0.01993158821950005, -0.5913037838451686}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6044295191828238, -0.06715883546475819, -0.6044295191828238}, {
    0.6115080659765835, -0.13589068132812965`, -0.6115080659765835}, {
    0.6063763483828833, -0.12801278465860869`, -0.5996388334008513}, {
    0.6006503620708005, -0.0734128220308756, -0.5939764691589027}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6115080659765835, -0.13589068132812965`, -0.6115080659765835}, {
    0.6230755279293883, -0.20769184264312943`, -0.6230755279293883}, {
    0.615005336599669, -0.1845016009799007, -0.6081719439707838}, {
    0.6063763483828833, -0.12801278465860869`, -0.5996388334008513}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6230755279293883, -0.20769184264312943`, -0.6230755279293883}, {
    0.5960042485425239, -0.16555673570625662`, -0.5628929014012725}, {
    0.5936572660606888, -0.15171241243773156`, -0.560676306835095}, {
    0.615005336599669, -0.1845016009799007, -0.6081719439707838}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5960042485425239, -0.16555673570625662`, -0.5628929014012725}, {
    0.5692683486017988, -0.12650407746706638`, -0.5060163098682655}, {
    0.572511405971636, -0.12086351903845649`, -0.5152602653744724}, {
    0.5936572660606888, -0.15171241243773156`, -0.560676306835095}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5692683486017988, -0.12650407746706638`, -0.5060163098682655}, {
    0.5423842382927654, -0.09039737304879422, -0.4519868652439711}, {
    0.5513356533463394, -0.09188927555772322, -0.4716982811963126}, {
    0.572511405971636, -0.12086351903845649`, -0.5152602653744724}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5423842382927654, -0.09039737304879422, -0.4519868652439711}, {
    0.5611088996560509, -0.06234543329511677, -0.49876346636093416`}, {
    0.5660913502754553, -0.06918894281144454, -0.5094822152479098}, {
    0.5513356533463394, -0.09188927555772322, -0.4716982811963126}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5611088996560509, -0.06234543329511677, -0.49876346636093416`}, {
    0.5810366771432506, -0.03227981539684726, -0.5487568617464034}, {
    0.5816501238360723, -0.04523945407613895, -0.5493362280674016}, {
    0.5660913502754553, -0.06918894281144454, -0.5094822152479098}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5810366771432506, -0.03227981539684726, -0.5487568617464034}, {
    0.6020420732135735, 0., -0.6020420732135735}, {
    0.597947646585002, -0.01993158821950005, -0.5913037838451686}, {
    0.5816501238360723, -0.04523945407613895, -0.5493362280674016}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.6115080659765835, -0.40767204398438894`, -0.4756173846484537}, {
    0.6176006003263583, -0.4185959624434206, -0.48721825136857155`}, {
    0.5920832028449382, -0.4013008374837915, -0.41445824199145676`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6115080659765835, -0.40767204398438894`, -0.4756173846484537}, {
    0.6457005460543618, -0.4304670307029078, -0.5739560409372104}, {
    0.6448463554356526, -0.43706252979527566`, -0.5660318008824062}, {
    0.6176006003263583, -0.4185959624434206, -0.48721825136857155`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6457005460543618, -0.4304670307029078, -0.5739560409372104}, {
    0.6845537086570662, -0.4563691391047108, -0.6845537086570662}, {
    0.6749630549963996, -0.4574749594975597, -0.6524642864965196}, {
    0.6448463554356526, -0.43706252979527566`, -0.5660318008824062}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6845537086570662, -0.4563691391047108, -0.6845537086570662}, {
    0.6786794799954298, -0.49015740221892146`, -0.6409750644401281}, {
    0.670907588604451, -0.484544369547659, -0.6187258872685492}, {
    0.6749630549963996, -0.4574749594975597, -0.6524642864965196}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6786794799954298, -0.49015740221892146`, -0.6409750644401281}, {
    0.6751944561946608, -0.5251512437069583, -0.6001728499508097}, {
    0.6683421713383466, -0.5123956646927323, -0.5866559059525488}, {
    0.670907588604451, -0.484544369547659, -0.6187258872685492}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6751944561946608, -0.5251512437069583, -0.6001728499508097}, {
    0.6740385471308696, -0.5616987892757247, -0.5616987892757247}, {
    0.6672459372836057, -0.5412105935744802, -0.5560382810696715}, {
    0.6683421713383466, -0.5123956646927323, -0.5866559059525488}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6740385471308696, -0.5616987892757247, -0.5616987892757247}, {
    0.6412032180604118, -0.49871361404698694`, -0.49871361404698694`}, {
    0.641248218995467, -0.4916236345631913, -0.5058735949853128}, {
    0.6672459372836057, -0.5412105935744802, -0.5560382810696715}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6412032180604118, -0.49871361404698694`, -0.49871361404698694`}, {
    0.6103364275727268, -0.4407985310247471, -0.4407985310247471}, {
    0.6164899353312527, -0.4452427310725714, -0.4589425074132659}, {
    0.641248218995467, -0.4916236345631913, -0.5058735949853128}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6103364275727268, -0.4407985310247471, -0.4407985310247471}, {
    0.5797543124923197, -0.38650287499487973`, -0.38650287499487973`}, {
    0.5920832028449382, -0.4013008374837915, -0.41445824199145676`}, {
    0.6164899353312527, -0.4452427310725714, -0.4589425074132659}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6845537086570662, -0.4563691391047108, -0.6845537086570662}, {
    0.6786794799954298, -0.49015740221892146`, -0.6409750644401281}, {
    0.6848853908126196, -0.5098591242716168, -0.6468362024341406}, {
    0.6890827403984794, -0.48235791827893554`, -0.6814262655051629}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6786794799954298, -0.49015740221892146`, -0.6409750644401281}, {
    0.6751944561946608, -0.5251512437069583, -0.6001728499508097}, {
    0.68224035411735, -0.5382118349147983, -0.614016318705615}, {
    0.6848853908126196, -0.5098591242716168, -0.6468362024341406}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6751944561946608, -0.5251512437069583, -0.6001728499508097}, {
    0.6740385471308696, -0.5616987892757247, -0.5616987892757247}, {
    0.6811124367744867, -0.5675936973120723, -0.5827295292403942}, {
    0.68224035411735, -0.5382118349147983, -0.614016318705615}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.6740385471308696, -0.5616987892757247, -0.5616987892757247}, {
    0.7118600880536767, -0.6327645227143793, -0.6327645227143793}, {
    0.7119126797168901, -0.6249011299737146, -0.6407214117452011}, {
    0.6811124367744867, -0.5675936973120723, -0.5827295292403942}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.7118600880536767, -0.6327645227143793, -0.6327645227143793}, {
    0.7622103197175837, -0.7198653019554957, -0.7198653019554957}, {
    0.7504115684601292, -0.6920462242465636, -0.7087220368790109}, {
    0.7119126797168901, -0.6249011299737146, -0.6407214117452011}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.7622103197175837, -0.7198653019554957, -0.7198653019554957}, {
    0.9068996821171088, -0.9068996821171088, -0.9068996821171088}, {
    0.8104554067121754, -0.7834402264884363, -0.8014503466375957}, {
    0.7504115684601292, -0.6920462242465636, -0.7087220368790109}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.9068996821171088, -0.9068996821171088, -0.9068996821171088}, {
    0.7640699024805022, -0.6791732466493353, -0.7640699024805022}, {
    0.7520300306261339, -0.6601152491051621, -0.7436741413969546}, {
    0.8104554067121754, -0.7834402264884363, -0.8014503466375957}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.7640699024805022, -0.6791732466493353, -0.7640699024805022}, {
    0.7171888530767329, -0.5578135523930144, -0.7171888530767329}, {
    0.716165180138544, -0.5649747532204069, -0.7082077892481158}, {
    0.7520300306261339, -0.6601152491051621, -0.7436741413969546}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{
    0.7171888530767329, -0.5578135523930144, -0.7171888530767329}, {
    0.6845537086570662, -0.4563691391047108, -0.6845537086570662}, {
    0.6890827403984794, -0.48235791827893554`, -0.6814262655051629}, {
    0.716165180138544, -0.5649747532204069, -0.7082077892481158}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {0.07756663751797302, 
    0.005171109167864868, 0.005171109167864868}, {0.11600941429253843`, 
    0.013921129715104607`, 0.008765155746547347}, {0.05793069453624921, 
    0.0038620463024166113`, 0.0012873487674722039`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07756663751797302, 0.005171109167864868, 
    0.005171109167864868}, {0.15308565553031123`, 0.02041142073737483, 
    0.02041142073737483}, {0.17441633647095503`, 0.030232164988298865`, 
    0.02248032781181198}, {0.11600941429253843`, 0.013921129715104607`, 
    0.008765155746547347}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.15308565553031123`, 0.02041142073737483, 
    0.02041142073737483}, {0.22479511109484523`, 0.04495902221896904, 
    0.04495902221896904}, {0.23065124757750236`, 0.052280949450900525`, 
    0.04202978289190042}, {0.17441633647095503`, 0.030232164988298865`, 
    0.02248032781181198}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.22479511109484523`, 0.04495902221896904, 
    0.04495902221896904}, {0.2914261673100827, 0.07771364461602205, 
    0.07771364461602205}, {0.2837917818761621, 0.07946169892532537, 
    0.0668487308419404}, {0.23065124757750236`, 0.052280949450900525`, 
    0.04202978289190042}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2914261673100827, 0.07771364461602205, 
    0.07771364461602205}, {0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {0.3333736846483348, 0.11112456154944492`, 
    0.09630795334285228}, {0.2837917818761621, 0.07946169892532537, 
    0.0668487308419404}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {0.3579949935256501, 0.14319799741026004`, 
    0.09546533160684004}, {0.3407298274347052, 0.131748866608086, 
    0.08026080379573056}, {0.3333736846483348, 0.11112456154944492`, 
    0.09630795334285228}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3579949935256501, 0.14319799741026004`, 
    0.09546533160684004}, {0.37415229431745833`, 0.1746044040148139, 
    0.07483045886349166}, {0.3552530406979347, 0.15631133790709126`, 
    0.0647349985271792}, {0.3407298274347052, 0.131748866608086, 
    0.08026080379573056}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.37415229431745833`, 0.1746044040148139, 
    0.07483045886349166}, {0.3983729048897056, 0.21246554927450964`, 
    0.05311638731862741}, {0.3754334096530939, 0.18521381542885962`, 
    0.04838919502195432}, {0.3552530406979347, 0.15631133790709126`, 
    0.0647349985271792}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3983729048897056, 0.21246554927450964`, 
    0.05311638731862741}, {0.42781593715312194`, 0.2566895622918732, 
    0.028521062476874796`}, {0.39956209892042155`, 0.21842728074316375`, 
    0.030189136362876293`}, {0.3754334096530939, 0.18521381542885962`, 
    0.04838919502195432}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.42781593715312194`, 0.2566895622918732, 
    0.028521062476874796`}, {0.45998714286871445`, 0.3066580952458096, 0.}, {
    0.4260763439843505, 0.2556458063906103, 0.009468363199652228}, {
    0.39956209892042155`, 0.21842728074316375`, 0.030189136362876293`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0.3066580952458096, 0.}, {
    0.38905011534806727`, 0.20749339485230253`, 0.}, {0.36589693116182753`, 
    0.18050915270650156`, 0.008131042914707273}, {0.4260763439843505, 
    0.2556458063906103, 0.009468363199652228}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.38905011534806727`, 0.20749339485230253`, 0.}, {
    0.30673802522798127`, 0.1226952100911925, 0.}, {0.2982832465218531, 
    0.11533618865511652`, 0.006628516589374509}, {0.36589693116182753`, 
    0.18050915270650156`, 0.008131042914707273}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.30673802522798127`, 0.1226952100911925, 0.}, {
    0.21282462147366246`, 0.05675323239297665, 0.}, {0.22335095439184463`, 
    0.06253826722971649, 0.004963354542040988}, {0.2982832465218531, 
    0.11533618865511652`, 0.006628516589374509}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21282462147366246`, 0.05675323239297665, 0.}, {
    0.10920608786993075`, 0.014560811715990765`, 0.}, {0.142224790973981, 
    0.0246522971021567, 0.003160550910532909}, {0.22335095439184463`, 
    0.06253826722971649, 0.004963354542040988}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.10920608786993075`, 0.014560811715990765`, 0.}, {
    0., 0., 0.}, {0.05793069453624921, 0.0038620463024166113`, 
    0.0012873487674722039`}, {0.142224790973981, 0.0246522971021567, 
    0.003160550910532909}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0.3066580952458096, 0.}, {
    0.4664505261905705, 0.3109670174603803, 0.06219340349207606}, {
    0.4603228910236794, 0.2966525297708156, 0.07978930111077108}, {
    0.45062802082557046`, 0.29040472453203425`, 0.03004186805503801}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4664505261905705, 0.3109670174603803, 
    0.06219340349207606}, {0.48461849963627207`, 0.3230789997575147, 
    0.12923159990300587`}, {0.4773844806346105, 0.3076477764089712, 
    0.1336676545776909}, {0.4603228910236794, 0.2966525297708156, 
    0.07978930111077108}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.48461849963627207`, 0.3230789997575147, 
    0.12923159990300587`}, {0.5115370291932914, 0.3410246861288609, 
    0.20461481167731652`}, {0.49999529440342494`, 0.3222191897266516, 
    0.19333151383599095`}, {0.4773844806346105, 0.3076477764089712, 
    0.1336676545776909}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5115370291932914, 0.3410246861288609, 
    0.20461481167731652`}, {0.5440012355218949, 0.36266749034792994`, 
    0.29013399227834397`}, {0.5263215102011988, 0.3391849732407725, 
    0.25965194503259137`}, {0.49999529440342494`, 0.3222191897266516, 
    0.19333151383599095`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5440012355218949, 0.36266749034792994`, 
    0.29013399227834397`}, {0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.5549429157801637, 0.3576298790583277, 
    0.3329657494680982}, {0.5263215102011988, 0.3391849732407725, 
    0.25965194503259137`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.5418425399938036, 0.3251055239962821, 
    0.3251055239962821}, {0.5235616495156941, 0.30948310838038806`, 
    0.2862137017352461}, {0.5549429157801637, 0.3576298790583277, 
    0.3329657494680982}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5418425399938036, 0.3251055239962821, 
    0.3251055239962821}, {0.5012123976166442, 0.2673132787288769, 
    0.2673132787288769}, {0.49007301405696324`, 0.2635503764484113, 
    0.24176935360143517`}, {0.5235616495156941, 0.30948310838038806`, 
    0.2862137017352461}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5012123976166442, 0.2673132787288769, 
    0.2673132787288769}, {0.4566708874648107, 0.21311308081691166`, 
    0.21311308081691166`}, {0.4539150995168281, 0.2198966482103745, 
    0.19972264378740437`}, {0.49007301405696324`, 0.2635503764484113, 
    0.24176935360143517`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4566708874648107, 0.21311308081691166`, 
    0.21311308081691166`}, {0.40726070505008105`, 0.1629042820200324, 
    0.1629042820200324}, {0.4146226594222878, 0.1787484353953863, 
    0.1603207616432846}, {0.4539150995168281, 0.2198966482103745, 
    0.19972264378740437`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.40726070505008105`, 0.1629042820200324, 
    0.1629042820200324}, {0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {0.37184302234147004`, 0.1404740306623331, 
    0.12394767411382335`}, {0.4146226594222878, 0.1787484353953863, 
    0.1603207616432846}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {0.3579949935256501, 0.14319799741026004`, 
    0.09546533160684004}, {0.37788015107523965`, 0.16290833179688105`, 
    0.10580644230106709`}, {0.37184302234147004`, 0.1404740306623331, 
    0.12394767411382335`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3579949935256501, 0.14319799741026004`, 
    0.09546533160684004}, {0.37415229431745833`, 0.1746044040148139, 
    0.07483045886349166}, {0.38991864684146027`, 0.18889392224764073`, 
    0.08838155995073098}, {0.37788015107523965`, 0.16290833179688105`, 
    0.10580644230106709`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.37415229431745833`, 0.1746044040148139, 
    0.07483045886349166}, {0.3983729048897056, 0.21246554927450964`, 
    0.05311638731862741}, {0.40689371670049274`, 0.2188183987589316, 
    0.07052824422808539}, {0.38991864684146027`, 0.18889392224764073`, 
    0.08838155995073098}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3983729048897056, 0.21246554927450964`, 
    0.05311638731862741}, {0.42781593715312194`, 0.2566895622918732, 
    0.028521062476874796`}, {0.4275386729168246, 0.2527228599908341, 
    0.05130464075001894}, {0.40689371670049274`, 0.2188183987589316, 
    0.07052824422808539}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.42781593715312194`, 0.2566895622918732, 
    0.028521062476874796`}, {0.45998714286871445`, 0.3066580952458096, 0.}, {
    0.45062802082557046`, 0.29040472453203425`, 0.03004186805503801}, {
    0.4275386729168246, 0.2527228599908341, 0.05130464075001894}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {0.10920608786993075`, 
    0.014560811715990765`, 0.}, {0.142224790973981, 
    0.0246522971021567, -0.003160550910532909}, {0.05793069453624921, 
    0.0038620463024166113`, -0.0012873487674722039`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.10920608786993075`, 0.014560811715990765`, 0.}, {
    0.21282462147366246`, 0.05675323239297665, 0.}, {0.22335095439184463`, 
    0.06253826722971648, -0.004963354542040988}, {0.142224790973981, 
    0.0246522971021567, -0.003160550910532909}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21282462147366246`, 0.05675323239297665, 0.}, {
    0.30673802522798127`, 0.1226952100911925, 0.}, {0.2982832465218531, 
    0.11533618865511652`, -0.006628516589374509}, {0.22335095439184463`, 
    0.06253826722971648, -0.004963354542040988}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.30673802522798127`, 0.1226952100911925, 0.}, {
    0.38905011534806727`, 0.20749339485230253`, 0.}, {0.36589693116182753`, 
    0.18050915270650156`, -0.008131042914707273}, {0.2982832465218531, 
    0.11533618865511652`, -0.006628516589374509}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38905011534806727`, 0.20749339485230253`, 0.}, {
    0.45998714286871445`, 0.3066580952458096, 0.}, {0.4260763439843505, 
    0.2556458063906103, -0.009468363199652228}, {0.36589693116182753`, 
    0.18050915270650156`, -0.008131042914707273}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0.3066580952458096, 0.}, {
    0.42781593715312194`, 0.2566895622918732, -0.028521062476874796`}, {
    0.39956209892042155`, 0.21842728074316375`, -0.030189136362876293`}, {
    0.4260763439843505, 0.2556458063906103, -0.009468363199652228}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.42781593715312194`, 
    0.2566895622918732, -0.028521062476874796`}, {0.3983729048897056, 
    0.21246554927450964`, -0.05311638731862741}, {0.3754334096530939, 
    0.18521381542885962`, -0.04838919502195432}, {0.39956209892042155`, 
    0.21842728074316375`, -0.030189136362876293`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3983729048897056, 
    0.21246554927450964`, -0.05311638731862741}, {0.37415229431745833`, 
    0.1746044040148139, -0.07483045886349166}, {0.3552530406979347, 
    0.15631133790709126`, -0.0647349985271792}, {0.3754334096530939, 
    0.18521381542885962`, -0.04838919502195432}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.37415229431745833`, 
    0.1746044040148139, -0.07483045886349166}, {0.3579949935256501, 
    0.14319799741026004`, -0.09546533160684004}, {0.3407298274347052, 
    0.131748866608086, -0.08026080379573056}, {0.3552530406979347, 
    0.15631133790709126`, -0.0647349985271792}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3579949935256501, 
    0.14319799741026004`, -0.09546533160684004}, {0.35229120018115184`, 
    0.11743040006038394`, -0.11743040006038394`}, {0.3333736846483348, 
    0.11112456154944492`, -0.09630795334285228}, {0.3407298274347052, 
    0.131748866608086, -0.08026080379573056}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.35229120018115184`, 
    0.11743040006038394`, -0.11743040006038394`}, {0.2914261673100827, 
    0.07771364461602205, -0.07771364461602205}, {0.2837917818761621, 
    0.07946169892532537, -0.0668487308419404}, {0.3333736846483348, 
    0.11112456154944492`, -0.09630795334285228}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2914261673100827, 
    0.07771364461602205, -0.07771364461602205}, {0.22479511109484523`, 
    0.04495902221896904, -0.04495902221896904}, {0.23065124757750236`, 
    0.052280949450900525`, -0.04202978289190042}, {0.2837917818761621, 
    0.07946169892532537, -0.0668487308419404}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.22479511109484523`, 
    0.04495902221896904, -0.04495902221896904}, {0.15308565553031123`, 
    0.02041142073737483, -0.02041142073737483}, {0.17441633647095503`, 
    0.030232164988298865`, -0.02248032781181198}, {0.23065124757750236`, 
    0.052280949450900525`, -0.04202978289190042}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.15308565553031123`, 
    0.02041142073737483, -0.02041142073737483}, {0.07756663751797302, 
    0.005171109167864868, -0.005171109167864868}, {0.11600941429253843`, 
    0.013921129715104607`, -0.008765155746547347}, {0.17441633647095503`, 
    0.030232164988298865`, -0.02248032781181198}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07756663751797302, 
    0.005171109167864868, -0.005171109167864868}, {0., 0., 0.}, {
    0.05793069453624921, 0.0038620463024166113`, -0.0012873487674722039`}, {
    0.11600941429253843`, 0.013921129715104607`, -0.008765155746547347}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0.3066580952458096, 0.}, {
    0.42781593715312194`, 0.2566895622918732, -0.028521062476874796`}, {
    0.4275386729168246, 0.2527228599908341, -0.05130464075001894}, {
    0.45062802082557046`, 0.29040472453203425`, -0.03004186805503801}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.42781593715312194`, 
    0.2566895622918732, -0.028521062476874796`}, {0.3983729048897056, 
    0.21246554927450964`, -0.05311638731862741}, {0.40689371670049274`, 
    0.2188183987589316, -0.07052824422808539}, {0.4275386729168246, 
    0.2527228599908341, -0.05130464075001894}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.3983729048897056, 
    0.21246554927450964`, -0.05311638731862741}, {0.37415229431745833`, 
    0.1746044040148139, -0.07483045886349166}, {0.38991864684146027`, 
    0.18889392224764073`, -0.08838155995073098}, {0.40689371670049274`, 
    0.2188183987589316, -0.07052824422808539}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.37415229431745833`, 
    0.1746044040148139, -0.07483045886349166}, {0.3579949935256501, 
    0.14319799741026004`, -0.09546533160684004}, {0.37788015107523965`, 
    0.16290833179688105`, -0.10580644230106709`}, {0.38991864684146027`, 
    0.18889392224764073`, -0.08838155995073098}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3579949935256501, 
    0.14319799741026004`, -0.09546533160684004}, {0.35229120018115184`, 
    0.11743040006038394`, -0.11743040006038394`}, {0.37184302234147004`, 
    0.1404740306623331, -0.12394767411382335`}, {0.37788015107523965`, 
    0.16290833179688105`, -0.10580644230106709`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.35229120018115184`, 
    0.11743040006038394`, -0.11743040006038394`}, {0.40726070505008105`, 
    0.1629042820200324, -0.1629042820200324}, {0.4146226594222878, 
    0.1787484353953863, -0.1603207616432846}, {0.37184302234147004`, 
    0.1404740306623331, -0.12394767411382335`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.40726070505008105`, 
    0.1629042820200324, -0.1629042820200324}, {0.4566708874648107, 
    0.21311308081691166`, -0.21311308081691166`}, {0.4539150995168281, 
    0.2198966482103745, -0.19972264378740437`}, {0.4146226594222878, 
    0.1787484353953863, -0.1603207616432846}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4566708874648107, 
    0.21311308081691166`, -0.21311308081691166`}, {0.5012123976166442, 
    0.2673132787288769, -0.2673132787288769}, {0.49007301405696324`, 
    0.2635503764484113, -0.24176935360143517`}, {0.4539150995168281, 
    0.2198966482103745, -0.19972264378740437`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5012123976166442, 
    0.2673132787288769, -0.2673132787288769}, {0.5418425399938036, 
    0.3251055239962821, -0.3251055239962821}, {0.5235616495156941, 
    0.30948310838038806`, -0.2862137017352461}, {0.49007301405696324`, 
    0.2635503764484113, -0.24176935360143517`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5418425399938036, 
    0.3251055239962821, -0.3251055239962821}, {0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.5549429157801637, 
    0.3576298790583277, -0.3329657494680982}, {0.5235616495156941, 
    0.30948310838038806`, -0.2862137017352461}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.5440012355218949, 
    0.36266749034792994`, -0.29013399227834397`}, {0.5263215102011988, 
    0.3391849732407725, -0.25965194503259137`}, {0.5549429157801637, 
    0.3576298790583277, -0.3329657494680982}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5440012355218949, 
    0.36266749034792994`, -0.29013399227834397`}, {0.5115370291932914, 
    0.3410246861288609, -0.20461481167731652`}, {0.49999529440342494`, 
    0.3222191897266516, -0.19333151383599095`}, {0.5263215102011988, 
    0.3391849732407725, -0.25965194503259137`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5115370291932914, 
    0.3410246861288609, -0.20461481167731652`}, {0.48461849963627207`, 
    0.3230789997575147, -0.12923159990300587`}, {0.4773844806346105, 
    0.3076477764089712, -0.13366765457769092`}, {0.49999529440342494`, 
    0.3222191897266516, -0.19333151383599095`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.48461849963627207`, 
    0.3230789997575147, -0.12923159990300587`}, {0.4664505261905705, 
    0.3109670174603803, -0.06219340349207606}, {0.4603228910236794, 
    0.2966525297708156, -0.07978930111077108}, {0.4773844806346105, 
    0.3076477764089712, -0.13366765457769092`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4664505261905705, 
    0.3109670174603803, -0.06219340349207606}, {0.45998714286871445`, 
    0.3066580952458096, 0.}, {0.45062802082557046`, 
    0.29040472453203425`, -0.03004186805503801}, {0.4603228910236794, 
    0.2966525297708156, -0.07978930111077108}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.6103364275727268, 0.4407985310247471, 
    0.4407985310247471}, {0.6164899353312527, 0.4589425074132659, 
    0.4452427310725714}, {0.5920832028449382, 0.41445824199145676`, 
    0.4013008374837915}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6103364275727268, 0.4407985310247471, 
    0.4407985310247471}, {0.6412032180604118, 0.49871361404698694`, 
    0.49871361404698694`}, {0.641248218995467, 0.5058735949853128, 
    0.4916236345631913}, {0.6164899353312527, 0.4589425074132659, 
    0.4452427310725714}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6412032180604118, 0.49871361404698694`, 
    0.49871361404698694`}, {0.6740385471308696, 0.5616987892757247, 
    0.5616987892757247}, {0.6672459372836057, 0.5560382810696715, 
    0.5412105935744802}, {0.641248218995467, 0.5058735949853128, 
    0.4916236345631913}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6740385471308696, 0.5616987892757247, 
    0.5616987892757247}, {0.6751944561946608, 0.6001728499508097, 
    0.5251512437069583}, {0.6683421713383466, 0.5866559059525488, 
    0.5123956646927323}, {0.6672459372836057, 0.5560382810696715, 
    0.5412105935744802}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6751944561946608, 0.6001728499508097, 
    0.5251512437069583}, {0.6786794799954298, 0.6409750644401281, 
    0.49015740221892146`}, {0.670907588604451, 0.6187258872685492, 
    0.484544369547659}, {0.6683421713383466, 0.5866559059525488, 
    0.5123956646927323}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6786794799954298, 0.6409750644401281, 
    0.49015740221892146`}, {0.6845537086570662, 0.6845537086570662, 
    0.4563691391047108}, {0.6749630549963996, 0.6524642864965196, 
    0.4574749594975597}, {0.670907588604451, 0.6187258872685492, 
    0.484544369547659}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 0.6845537086570662, 
    0.4563691391047108}, {0.6457005460543618, 0.5739560409372104, 
    0.4304670307029078}, {0.6448463554356526, 0.5660318008824062, 
    0.43706252979527566`}, {0.6749630549963996, 0.6524642864965196, 
    0.4574749594975597}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6457005460543618, 0.5739560409372104, 
    0.4304670307029078}, {0.6115080659765835, 0.4756173846484537, 
    0.40767204398438894`}, {0.6176006003263583, 0.48721825136857155`, 
    0.4185959624434206}, {0.6448463554356526, 0.5660318008824062, 
    0.43706252979527566`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, 0.4756173846484537, 
    0.40767204398438894`}, {0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.5920832028449382, 0.41445824199145676`, 
    0.4013008374837915}, {0.6176006003263583, 0.48721825136857155`, 
    0.4185959624434206}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 0.6845537086570662, 
    0.4563691391047108}, {0.7171888530767329, 0.7171888530767329, 
    0.5578135523930144}, {0.716165180138544, 0.7082077892481158, 
    0.5649747532204069}, {0.6890827403984796, 0.6814262655051632, 
    0.4823579182789357}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7171888530767329, 0.7171888530767329, 
    0.5578135523930144}, {0.7640699024805022, 0.7640699024805022, 
    0.6791732466493353}, {0.7520300306261339, 0.7436741413969546, 
    0.6601152491051621}, {0.716165180138544, 0.7082077892481158, 
    0.5649747532204069}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7640699024805022, 0.7640699024805022, 
    0.6791732466493353}, {0.9068996821171088, 0.9068996821171088, 
    0.9068996821171088}, {0.8104554067121754, 0.8014503466375957, 
    0.7834402264884363}, {0.7520300306261339, 0.7436741413969546, 
    0.6601152491051621}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.9068996821171088, 0.9068996821171088, 
    0.9068996821171088}, {0.7622103197175837, 0.7198653019554957, 
    0.7198653019554957}, {0.7504115684601292, 0.7087220368790109, 
    0.6920462242465636}, {0.8104554067121754, 0.8014503466375957, 
    0.7834402264884363}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7622103197175837, 0.7198653019554957, 
    0.7198653019554957}, {0.7118600880536767, 0.6327645227143793, 
    0.6327645227143793}, {0.7119126797168901, 0.6407214117452011, 
    0.6249011299737146}, {0.7504115684601292, 0.7087220368790109, 
    0.6920462242465636}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7118600880536767, 0.6327645227143793, 
    0.6327645227143793}, {0.6740385471308696, 0.5616987892757247, 
    0.5616987892757247}, {0.6811124367744867, 0.5827295292403942, 
    0.5675936973120723}, {0.7119126797168901, 0.6407214117452011, 
    0.6249011299737146}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6740385471308696, 0.5616987892757247, 
    0.5616987892757247}, {0.6751944561946608, 0.6001728499508097, 
    0.5251512437069583}, {0.68224035411735, 0.614016318705615, 
    0.5382118349147983}, {0.6811124367744867, 0.5827295292403942, 
    0.5675936973120723}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6751944561946608, 0.6001728499508097, 
    0.5251512437069583}, {0.6786794799954298, 0.6409750644401281, 
    0.49015740221892146`}, {0.6848853908126196, 0.6468362024341406, 
    0.5098591242716168}, {0.68224035411735, 0.614016318705615, 
    0.5382118349147983}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6786794799954298, 0.6409750644401281, 
    0.49015740221892146`}, {0.6845537086570662, 0.6845537086570662, 
    0.4563691391047108}, {0.6890827403984796, 0.6814262655051632, 
    0.4823579182789357}, {0.6848853908126196, 0.6468362024341406, 
    0.5098591242716168}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0.3066580952458096, 0.}, {
    0.46253818353867265`, 0.30835878902578173`, 0.038544848628222717`}, {
    0.47507741354102534`, 0.3272755515504841, 0.052786379282336135`}, {
    0.47150167762968676`, 0.324812266811562, 0.020955630116874954`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.46253818353867265`, 0.30835878902578173`, 
    0.038544848628222717`}, {0.46999171897491077`, 0.3133278126499405, 
    0.07833195316248512}, {0.48154514744522653`, 0.33173110157337826`, 
    0.0856080262124847}, {0.47507741354102534`, 0.3272755515504841, 
    0.052786379282336135`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.46999171897491077`, 0.3133278126499405, 
    0.07833195316248512}, {0.4817997617497233, 0.32119984116648215`, 
    0.12044994043743079`}, {0.4906212440644457, 0.3379835236888404, 
    0.11992963743797559`}, {0.48154514744522653`, 0.33173110157337826`, 
    0.0856080262124847}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4817997617497233, 0.32119984116648215`, 
    0.12044994043743079`}, {0.4971955577882874, 0.3314637051921916, 
    0.1657318525960958}, {0.5019472405700409, 0.3457858768371393, 
    0.1561613637329016}, {0.4906212440644457, 0.3379835236888404, 
    0.11992963743797559`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4971955577882874, 0.3314637051921916, 
    0.1657318525960958}, {0.530207257345758, 0.39765544300931854`, 
    0.176735752448586}, {0.5286651530527192, 0.3994358934176101, 
    0.16447360317195706`}, {0.5019472405700409, 0.3457858768371393, 
    0.1561613637329016}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.530207257345758, 0.39765544300931854`, 
    0.176735752448586}, {0.5617994480029483, 0.4681662066691236, 
    0.18726648266764945`}, {0.5543741420185859, 0.4558187389930595, 
    0.17247195529467113`}, {0.5286651530527192, 0.3994358934176101, 
    0.16447360317195706`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5617994480029483, 0.4681662066691236, 
    0.18726648266764945`}, {0.5924835974670974, 0.5431099643448393, 
    0.19749453248903248`}, {0.5793426974047388, 0.5149712865819899, 
    0.18023995030369647`}, {0.5543741420185859, 0.4558187389930595, 
    0.17247195529467113`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5924835974670974, 0.5431099643448393, 
    0.19749453248903248`}, {0.6230755279293883, 0.6230755279293883, 
    0.20769184264312943`}, {0.6039532192067091, 0.577110853908633, 
    0.18789655708653166`}, {0.5793426974047388, 0.5149712865819899, 
    0.18023995030369647`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 0.6230755279293883, 
    0.20769184264312943`}, {0.5826314122526858, 0.5340787945649619, 
    0.14565785306317142`}, {0.571505684936255, 0.508005053276671, 
    0.13970138965108453`}, {0.6039532192067091, 0.577110853908633, 
    0.18789655708653166`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5826314122526858, 0.5340787945649619, 
    0.14565785306317142`}, {0.5423842382927654, 0.4519868652439711, 
    0.09039737304879422}, {0.5388079575040883, 0.4430198761700281, 
    0.09578808133406011}, {0.571505684936255, 0.508005053276671, 
    0.13970138965108453`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5423842382927654, 0.4519868652439711, 
    0.09039737304879422}, {0.5013779790164214, 0.3760334842623161, 
    0.04178149825136846}, {0.5054364950419619, 0.38188535180948235`, 
    0.05615961056021798}, {0.5388079575040883, 0.4430198761700281, 
    0.09578808133406011}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5013779790164214, 0.3760334842623161, 
    0.04178149825136846}, {0.45998714286871445`, 0.3066580952458096, 0.}, {
    0.47150167762968676`, 0.324812266811562, 0.020955630116874954`}, {
    0.5054364950419619, 0.38188535180948235`, 0.05615961056021798}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0.3066580952458096, 0.}, {
    0.4875643330433564, 0.3521297960868685, 0.02708690739129757}, {
    0.49772097016621203`, 0.3705256111237356, 0.027651165009233997`}, {
    0.47617071567397445`, 0.33331950097178215`, 0.005290785729710824}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4875643330433564, 0.3521297960868685, 
    0.02708690739129757}, {0.5151364245658201, 0.4006616635511933, 
    0.057237380507313335`}, {0.5192776126127516, 0.4096523388389484, 
    0.05192776126127516}, {0.49772097016621203`, 0.3705256111237356, 
    0.027651165009233997`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5151364245658201, 0.4006616635511933, 
    0.057237380507313335`}, {0.5423842382927654, 0.4519868652439711, 
    0.09039737304879422}, {0.5406944571684102, 0.45057871430700847`, 
    0.07810031047988147}, {0.5192776126127516, 0.4096523388389484, 
    0.05192776126127516}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5423842382927654, 0.4519868652439711, 
    0.09039737304879422}, {0.5611088996560509, 0.49876346636093416`, 
    0.06234543329511677}, {0.5561327685019032, 0.48816098568500393`, 
    0.055613276850190324`}, {0.5406944571684102, 0.45057871430700847`, 
    0.07810031047988147}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5611088996560509, 0.49876346636093416`, 
    0.06234543329511677}, {0.5810366771432506, 0.5487568617464034, 
    0.03227981539684726}, {0.5723000016162385, 0.5277877792683088, 
    0.03179444453423547}, {0.5561327685019032, 0.48816098568500393`, 
    0.055613276850190324`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432506, 0.5487568617464034, 
    0.03227981539684726}, {0.6020420732135735, 0.6020420732135735, 0.}, {
    0.5891105858887445, 0.5694735663591197, 0.006545673176541602}, {
    0.5723000016162385, 0.5277877792683088, 0.03179444453423547}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, 0.6020420732135735, 0.}, {
    0.5583263670978953, 0.49629010408701807`, 0.}, {0.5538610316580012, 
    0.4861669055664677, 0.006154011462866676}, {0.5891105858887445, 
    0.5694735663591197, 0.006545673176541602}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5583263670978953, 0.49629010408701807`, 0.}, {
    0.5116766815928779, 0.3979707523500161, 0.}, {0.5165717745530933, 
    0.40751773325855134`, 0.005739686383923255}, {0.5538610316580012, 
    0.4861669055664677, 0.006154011462866676}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5116766815928779, 0.3979707523500161, 0.}, {
    0.45998714286871445`, 0.3066580952458096, 0.}, {0.47617071567397445`, 
    0.33331950097178215`, 0.005290785729710824}, {0.5165717745530933, 
    0.40751773325855134`, 0.005739686383923255}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, 0.6020420732135735, 0.}, {
    0.6044295191828238, 0.6044295191828238, 0.06715883546475819}, {
    0.6006503620708005, 0.5939764691589027, 0.0734128220308756}, {
    0.597947646585002, 0.5913037838451686, 0.01993158821950005}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6044295191828238, 0.6044295191828238, 
    0.06715883546475819}, {0.6115080659765835, 0.6115080659765835, 
    0.13589068132812965`}, {0.6063763483828833, 0.5996388334008513, 
    0.12801278465860869`}, {0.6006503620708005, 0.5939764691589027, 
    0.0734128220308756}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, 0.6115080659765835, 
    0.13589068132812965`}, {0.6230755279293883, 0.6230755279293883, 
    0.20769184264312943`}, {0.615005336599669, 0.6081719439707838, 
    0.1845016009799007}, {0.6063763483828833, 0.5996388334008513, 
    0.12801278465860869`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 0.6230755279293883, 
    0.20769184264312943`}, {0.596004248542524, 0.5628929014012727, 
    0.16555673570625667`}, {0.5936572660606888, 0.560676306835095, 
    0.15171241243773156`}, {0.615005336599669, 0.6081719439707838, 
    0.1845016009799007}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.596004248542524, 0.5628929014012727, 
    0.16555673570625667`}, {0.5692683486017988, 0.5060163098682655, 
    0.12650407746706638`}, {0.5725114059716361, 0.5152602653744724, 
    0.1208635190384565}, {0.5936572660606888, 0.560676306835095, 
    0.15171241243773156`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5692683486017988, 0.5060163098682655, 
    0.12650407746706638`}, {0.5423842382927654, 0.4519868652439711, 
    0.09039737304879422}, {0.5513356533463394, 0.4716982811963126, 
    0.09188927555772322}, {0.5725114059716361, 0.5152602653744724, 
    0.1208635190384565}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5423842382927654, 0.4519868652439711, 
    0.09039737304879422}, {0.5611088996560509, 0.49876346636093416`, 
    0.06234543329511677}, {0.5660913502754555, 0.5094822152479099, 
    0.06918894281144455}, {0.5513356533463394, 0.4716982811963126, 
    0.09188927555772322}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5611088996560509, 0.49876346636093416`, 
    0.06234543329511677}, {0.5810366771432506, 0.5487568617464034, 
    0.03227981539684726}, {0.5816501238360723, 0.5493362280674016, 
    0.04523945407613895}, {0.5660913502754555, 0.5094822152479099, 
    0.06918894281144455}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432506, 0.5487568617464034, 
    0.03227981539684726}, {0.6020420732135735, 0.6020420732135735, 0.}, {
    0.597947646585002, 0.5913037838451686, 0.01993158821950005}, {
    0.5816501238360723, 0.5493362280674016, 0.04523945407613895}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.5570985386650793, 0.3713990257767195, 
    0.32497414755462956`}, {0.5567535802997046, 0.3835413553175742, 
    0.3093075446109469}, {0.5740389519912366, 0.39544905581618517`, 
    0.35717979235010267`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5570985386650793, 0.3713990257767195, 
    0.32497414755462956`}, {0.5355123085516112, 0.35700820570107417`, 
    0.26775615427580557`}, {0.540269926225943, 0.37218594917787184`, 
    0.26413196393268323`}, {0.5567535802997046, 0.3835413553175742, 
    0.3093075446109469}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5355123085516112, 0.35700820570107417`, 
    0.26775615427580557`}, {0.5153506733137513, 0.34356711554250086`, 
    0.21472944721406304`}, {0.5247789208209833, 0.3615143676766774, 
    0.22157332212441513`}, {0.540269926225943, 0.37218594917787184`, 
    0.26413196393268323`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5153506733137513, 0.34356711554250086`, 
    0.21472944721406304`}, {0.4971955577882874, 0.3314637051921916, 
    0.1657318525960958}, {0.510556692772321, 0.35171683279870997`, 
    0.18153126854126964`}, {0.5247789208209833, 0.3615143676766774, 
    0.22157332212441513`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4971955577882874, 0.3314637051921916, 
    0.1657318525960958}, {0.530207257345758, 0.39765544300931854`, 
    0.176735752448586}, {0.5362250673964656, 0.4051478286995518, 
    0.1906578017409655}, {0.510556692772321, 0.35171683279870997`, 
    0.18153126854126964`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.530207257345758, 0.39765544300931854`, 
    0.176735752448586}, {0.5617994480029483, 0.4681662066691236, 
    0.18726648266764945`}, {0.5611088996560508, 0.461356206383864, 
    0.19950538654437358`}, {0.5362250673964656, 0.4051478286995518, 
    0.1906578017409655}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5617994480029483, 0.4681662066691236, 
    0.18726648266764945`}, {0.5924835974670974, 0.5431099643448393, 
    0.19749453248903248`}, {0.5854544855134971, 0.5204039871231084, 
    0.20816159484924335`}, {0.5611088996560508, 0.461356206383864, 
    0.19950538654437358`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5924835974670974, 0.5431099643448393, 
    0.19749453248903248`}, {0.6230755279293883, 0.6230755279293883, 
    0.20769184264312943`}, {0.6096319582097897, 0.5825372045115768, 
    0.21675802958570295`}, {0.5854544855134971, 0.5204039871231084, 
    0.20816159484924335`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 0.6230755279293883, 
    0.20769184264312943`}, {0.604726911219895, 0.5543330019515704, 
    0.25196954634162294`}, {0.5958580455279544, 0.5296515960248482, 
    0.2515845081118029}, {0.6096319582097897, 0.5825372045115768, 
    0.21675802958570295`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.604726911219895, 0.5543330019515704, 
    0.25196954634162294`}, {0.5910954623679224, 0.4925795519732687, 
    0.29554773118396116`}, {0.585151974032458, 0.4811249564266876, 
    0.2860742984158683}, {0.5958580455279544, 0.5296515960248482, 
    0.2515845081118029}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, 0.4925795519732687, 
    0.29554773118396116`}, {0.5826314122526858, 0.43697355918951436`, 
    0.3398683238140667}, {0.5777936049257504, 0.4365551681661225, 
    0.32099644718097237`}, {0.585151974032458, 0.4811249564266876, 
    0.2860742984158683}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5826314122526858, 0.43697355918951436`, 
    0.3398683238140667}, {0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.5740389519912366, 0.39544905581618517`, 
    0.35717979235010267`}, {0.5777936049257504, 0.4365551681661225, 
    0.32099644718097237`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.5810366771432508, 0.41963760015901447`, 
    0.3550779693653199}, {0.5877135047513313, 0.4375200535371022, 
    0.3591582529035913}, {0.5861088600394483, 0.41027620202761383`, 
    0.38422691935919384`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432508, 0.41963760015901447`, 
    0.3550779693653199}, {0.5848491491162138, 0.45488267153483286`, 
    0.32491619395345206`}, {0.5908975428290927, 0.46615250600961755`, 
    0.33484194093648584`}, {0.5877135047513313, 0.4375200535371022, 
    0.3591582529035913}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5848491491162138, 0.45488267153483286`, 
    0.32491619395345206`}, {0.5910954623679224, 0.4925795519732687, 
    0.2955477311839612}, {0.595614232557123, 0.49634519379760245`, 
    0.31104298811316416`}, {0.5908975428290927, 0.46615250600961755`, 
    0.33484194093648584`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, 0.4925795519732687, 
    0.2955477311839612}, {0.6207813146283735, 0.5518056130029987, 
    0.34487850812687415`}, {0.6194466649498231, 0.5437365170115114, 
    0.3510197768048997}, {0.595614232557123, 0.49634519379760245`, 
    0.31104298811316416`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6207813146283735, 0.5518056130029987, 
    0.34487850812687415`}, {0.6513209538944295, 0.6151364564558499, 
    0.39802947182437354`}, {0.643767236897451, 0.593696451805427, 
    0.3934133114373311}, {0.6194466649498231, 0.5437365170115114, 
    0.3510197768048997}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6513209538944295, 0.6151364564558499, 
    0.39802947182437354`}, {0.6845537086570662, 0.6845537086570662, 
    0.4563691391047108}, {0.6694402964869484, 0.6471256199373834, 
    0.43885530547477725`}, {0.643767236897451, 0.593696451805427, 
    0.3934133114373311}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 0.6845537086570662, 
    0.4563691391047108}, {0.6457005460543618, 0.5739560409372104, 
    0.4304670307029078}, {0.639447521013253, 0.5612928240005222, 
    0.41919337488646585`}, {0.6694402964869484, 0.6471256199373834, 
    0.43885530547477725`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6457005460543618, 0.5739560409372104, 
    0.4304670307029078}, {0.6115080659765835, 0.4756173846484537, 
    0.40767204398438894`}, {0.6120226278718142, 0.4828178508766534, 
    0.4012148338270782}, {0.639447521013253, 0.5612928240005222, 
    0.41919337488646585`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, 0.4756173846484537, 
    0.40767204398438894`}, {0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.5861088600394483, 0.41027620202761383`, 
    0.38422691935919384`}, {0.6120226278718142, 0.4828178508766534, 
    0.4012148338270782}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 0.6845537086570662, 
    0.4563691391047108}, {0.6592097133507697, 0.6592097133507697, 
    0.3662276185282054}, {0.6529409809315125, 0.6456860811433847, 
    0.35549008961826795`}, {0.6721945826966648, 0.6647257540000352, 
    0.42572323570788767`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6592097133507697, 0.6592097133507697, 
    0.3662276185282054}, {0.6389520625760421, 0.6389520625760421, 
    0.2839786944782409}, {0.6367433213395861, 0.629668395546924, 
    0.2900719574991448}, {0.6529409809315125, 0.6456860811433847, 
    0.35549008961826795`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6389520625760421, 0.6389520625760421, 
    0.2839786944782409}, {0.6230755279293883, 0.6230755279293883, 
    0.20769184264312943`}, {0.6233044923807646, 0.6163788869098672, 
    0.22854498053961364`}, {0.6367433213395861, 0.629668395546924, 
    0.2900719574991448}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 0.6230755279293883, 
    0.20769184264312943`}, {0.6103364275727265, 0.5764288482631306, 
    0.23735305516717142`}, {0.6137026828435966, 0.5796080893522857, 
    0.2522999918357008}, {0.6233044923807646, 0.6163788869098672, 
    0.22854498053961364`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6103364275727265, 0.5764288482631306, 
    0.23735305516717142`}, {0.5996392451370365, 0.5330126623440324, 
    0.2665063311720162}, {0.605427866219892, 0.5448850795979028, 
    0.2758060279446175}, {0.6137026828435966, 0.5796080893522857, 
    0.2522999918357008}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5996392451370365, 0.5330126623440324, 
    0.2665063311720162}, {0.5910954623679224, 0.4925795519732687, 
    0.2955477311839612}, {0.5985285392789631, 0.5120744169386685, 
    0.29926426963948155`}, {0.605427866219892, 0.5448850795979028, 
    0.2758060279446175}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, 0.4925795519732687, 
    0.2955477311839612}, {0.6207813146283735, 0.5518056130029987, 
    0.34487850812687415`}, {0.6222047200687002, 0.5599842480618302, 
    0.33875590314851456`}, {0.5985285392789631, 0.5120744169386685, 
    0.29926426963948155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6207813146283735, 0.5518056130029987, 
    0.34487850812687415`}, {0.6513209538944295, 0.6151364564558499, 
    0.39802947182437354`}, {0.6464647768296701, 0.6105500670057994, 
    0.3806959241330279}, {0.6222047200687002, 0.5599842480618302, 
    0.33875590314851456`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6513209538944295, 0.6151364564558499, 
    0.39802947182437354`}, {0.6845537086570662, 0.6845537086570662, 
    0.4563691391047108}, {0.6721945826966648, 0.6647257540000352, 
    0.42572323570788767`}, {0.6464647768296701, 0.6105500670057994, 
    0.3806959241330279}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.5570985386650793, 
    0.3713990257767195, -0.32497414755462956`}, {0.5567535802997046, 
    0.3835413553175742, -0.3093075446109469}, {0.5740389519912366, 
    0.39544905581618517`, -0.35717979235010267`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5570985386650793, 
    0.3713990257767195, -0.32497414755462956`}, {0.5355123085516112, 
    0.35700820570107417`, -0.26775615427580557`}, {0.540269926225943, 
    0.37218594917787184`, -0.26413196393268323`}, {0.5567535802997046, 
    0.3835413553175742, -0.3093075446109469}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5355123085516112, 
    0.35700820570107417`, -0.26775615427580557`}, {0.5153506733137513, 
    0.34356711554250086`, -0.21472944721406304`}, {0.5247789208209833, 
    0.3615143676766774, -0.22157332212441513`}, {0.540269926225943, 
    0.37218594917787184`, -0.26413196393268323`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5153506733137513, 
    0.34356711554250086`, -0.21472944721406304`}, {0.4971955577882874, 
    0.3314637051921916, -0.1657318525960958}, {0.510556692772321, 
    0.35171683279870997`, -0.18153126854126964`}, {0.5247789208209833, 
    0.3615143676766774, -0.22157332212441513`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4971955577882874, 
    0.3314637051921916, -0.1657318525960958}, {0.530207257345758, 
    0.39765544300931854`, -0.176735752448586}, {0.5362250673964656, 
    0.4051478286995518, -0.1906578017409655}, {0.510556692772321, 
    0.35171683279870997`, -0.18153126854126964`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.530207257345758, 
    0.39765544300931854`, -0.176735752448586}, {0.5617994480029483, 
    0.4681662066691236, -0.18726648266764945`}, {0.5611088996560508, 
    0.461356206383864, -0.19950538654437358`}, {0.5362250673964656, 
    0.4051478286995518, -0.1906578017409655}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5617994480029483, 
    0.4681662066691236, -0.18726648266764945`}, {0.5924835974670974, 
    0.5431099643448393, -0.19749453248903248`}, {0.5854544855134971, 
    0.5204039871231084, -0.20816159484924335`}, {0.5611088996560508, 
    0.461356206383864, -0.19950538654437358`}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5924835974670974, 
    0.5431099643448393, -0.19749453248903248`}, {0.6230755279293883, 
    0.6230755279293883, -0.20769184264312943`}, {0.6096319582097897, 
    0.5825372045115768, -0.21675802958570295`}, {0.5854544855134971, 
    0.5204039871231084, -0.20816159484924335`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 
    0.6230755279293883, -0.20769184264312943`}, {0.604726911219895, 
    0.5543330019515704, -0.25196954634162294`}, {0.5958580455279544, 
    0.5296515960248482, -0.2515845081118029}, {0.6096319582097897, 
    0.5825372045115768, -0.21675802958570295`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.604726911219895, 
    0.5543330019515704, -0.25196954634162294`}, {0.5910954623679224, 
    0.4925795519732687, -0.29554773118396116`}, {0.585151974032458, 
    0.4811249564266876, -0.2860742984158683}, {0.5958580455279544, 
    0.5296515960248482, -0.2515845081118029}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, 
    0.4925795519732687, -0.29554773118396116`}, {0.5826314122526858, 
    0.43697355918951436`, -0.3398683238140667}, {0.5777936049257504, 
    0.4365551681661225, -0.32099644718097237`}, {0.585151974032458, 
    0.4811249564266876, -0.2860742984158683}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5826314122526858, 
    0.43697355918951436`, -0.3398683238140667}, {0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.5740389519912366, 
    0.39544905581618517`, -0.35717979235010267`}, {0.5777936049257504, 
    0.4365551681661225, -0.32099644718097237`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.5810366771432508, 
    0.41963760015901447`, -0.3550779693653199}, {0.5877135047513313, 
    0.4375200535371022, -0.3591582529035913}, {0.5861088600394483, 
    0.41027620202761383`, -0.38422691935919384`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432508, 
    0.41963760015901447`, -0.3550779693653199}, {0.5848491491162138, 
    0.45488267153483286`, -0.32491619395345206`}, {0.5908975428290927, 
    0.46615250600961755`, -0.33484194093648584`}, {0.5877135047513313, 
    0.4375200535371022, -0.3591582529035913}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5848491491162138, 
    0.45488267153483286`, -0.32491619395345206`}, {0.5910954623679224, 
    0.4925795519732687, -0.2955477311839612}, {0.595614232557123, 
    0.49634519379760245`, -0.31104298811316416`}, {0.5908975428290927, 
    0.46615250600961755`, -0.33484194093648584`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, 
    0.4925795519732687, -0.2955477311839612}, {0.6207813146283735, 
    0.5518056130029987, -0.34487850812687415`}, {0.6194466649498231, 
    0.5437365170115114, -0.3510197768048997}, {0.595614232557123, 
    0.49634519379760245`, -0.31104298811316416`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6207813146283735, 
    0.5518056130029987, -0.34487850812687415`}, {0.6513209538944295, 
    0.6151364564558499, -0.39802947182437354`}, {0.643767236897451, 
    0.593696451805427, -0.3934133114373311}, {0.6194466649498231, 
    0.5437365170115114, -0.3510197768048997}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6513209538944295, 
    0.6151364564558499, -0.39802947182437354`}, {0.6845537086570662, 
    0.6845537086570662, -0.4563691391047108}, {0.6694402964869484, 
    0.6471256199373834, -0.43885530547477725`}, {0.643767236897451, 
    0.593696451805427, -0.3934133114373311}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 
    0.6845537086570662, -0.4563691391047108}, {0.6457005460543618, 
    0.5739560409372104, -0.4304670307029078}, {0.639447521013253, 
    0.5612928240005222, -0.41919337488646585`}, {0.6694402964869484, 
    0.6471256199373834, -0.43885530547477725`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6457005460543618, 
    0.5739560409372104, -0.4304670307029078}, {0.6115080659765835, 
    0.4756173846484537, -0.40767204398438894`}, {0.6120226278718142, 
    0.4828178508766534, -0.4012148338270782}, {0.639447521013253, 
    0.5612928240005222, -0.41919337488646585`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, 
    0.4756173846484537, -0.40767204398438894`}, {0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.5861088600394483, 
    0.41027620202761383`, -0.38422691935919384`}, {0.6120226278718142, 
    0.4828178508766534, -0.4012148338270782}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 
    0.6845537086570662, -0.4563691391047108}, {0.6592097133507697, 
    0.6592097133507697, -0.3662276185282054}, {0.6529409809315125, 
    0.6456860811433847, -0.35549008961826795`}, {0.6721945826966648, 
    0.6647257540000352, -0.42572323570788767`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6592097133507697, 
    0.6592097133507697, -0.3662276185282054}, {0.6389520625760421, 
    0.6389520625760421, -0.2839786944782409}, {0.6367433213395861, 
    0.629668395546924, -0.2900719574991448}, {0.6529409809315125, 
    0.6456860811433847, -0.35549008961826795`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6389520625760421, 
    0.6389520625760421, -0.2839786944782409}, {0.6230755279293883, 
    0.6230755279293883, -0.20769184264312943`}, {0.6233044923807646, 
    0.6163788869098672, -0.22854498053961364`}, {0.6367433213395861, 
    0.629668395546924, -0.2900719574991448}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 
    0.6230755279293883, -0.20769184264312943`}, {0.6103364275727265, 
    0.5764288482631306, -0.23735305516717142`}, {0.6137026828435966, 
    0.5796080893522857, -0.2522999918357008}, {0.6233044923807646, 
    0.6163788869098672, -0.22854498053961364`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6103364275727265, 
    0.5764288482631306, -0.23735305516717142`}, {0.5996392451370365, 
    0.5330126623440324, -0.2665063311720162}, {0.605427866219892, 
    0.5448850795979028, -0.2758060279446175}, {0.6137026828435966, 
    0.5796080893522857, -0.2522999918357008}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5996392451370365, 
    0.5330126623440324, -0.2665063311720162}, {0.5910954623679224, 
    0.4925795519732687, -0.2955477311839612}, {0.5985285392789631, 
    0.5120744169386685, -0.29926426963948155`}, {0.605427866219892, 
    0.5448850795979028, -0.2758060279446175}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, 
    0.4925795519732687, -0.2955477311839612}, {0.6207813146283735, 
    0.5518056130029987, -0.34487850812687415`}, {0.6222047200687002, 
    0.5599842480618302, -0.33875590314851456`}, {0.5985285392789631, 
    0.5120744169386685, -0.29926426963948155`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6207813146283735, 
    0.5518056130029987, -0.34487850812687415`}, {0.6513209538944295, 
    0.6151364564558499, -0.39802947182437354`}, {0.6464647768296701, 
    0.6105500670057994, -0.3806959241330279}, {0.6222047200687002, 
    0.5599842480618302, -0.33875590314851456`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6513209538944295, 
    0.6151364564558499, -0.39802947182437354`}, {0.6845537086570662, 
    0.6845537086570662, -0.4563691391047108}, {0.6721945826966648, 
    0.6647257540000352, -0.42572323570788767`}, {0.6464647768296701, 
    0.6105500670057994, -0.3806959241330279}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0.3066580952458096, 0.}, {
    0.46253818353867265`, 0.30835878902578173`, -0.038544848628222717`}, {
    0.47507741354102534`, 0.3272755515504841, -0.052786379282336135`}, {
    0.47150167762968676`, 0.324812266811562, -0.020955630116874954`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.46253818353867265`, 
    0.30835878902578173`, -0.038544848628222717`}, {0.46999171897491077`, 
    0.3133278126499405, -0.07833195316248512}, {0.48154514744522653`, 
    0.33173110157337826`, -0.0856080262124847}, {0.47507741354102534`, 
    0.3272755515504841, -0.052786379282336135`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.46999171897491077`, 
    0.3133278126499405, -0.07833195316248512}, {0.4817997617497233, 
    0.32119984116648215`, -0.12044994043743079`}, {0.4906212440644457, 
    0.3379835236888404, -0.11992963743797559`}, {0.48154514744522653`, 
    0.33173110157337826`, -0.0856080262124847}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4817997617497233, 
    0.32119984116648215`, -0.12044994043743079`}, {0.4971955577882874, 
    0.3314637051921916, -0.1657318525960958}, {0.5019472405700409, 
    0.3457858768371393, -0.1561613637329016}, {0.4906212440644457, 
    0.3379835236888404, -0.11992963743797559`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4971955577882874, 
    0.3314637051921916, -0.1657318525960958}, {0.530207257345758, 
    0.39765544300931854`, -0.176735752448586}, {0.5286651530527192, 
    0.3994358934176101, -0.16447360317195706`}, {0.5019472405700409, 
    0.3457858768371393, -0.1561613637329016}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.530207257345758, 
    0.39765544300931854`, -0.176735752448586}, {0.5617994480029483, 
    0.4681662066691236, -0.18726648266764945`}, {0.5543741420185859, 
    0.4558187389930595, -0.17247195529467113`}, {0.5286651530527192, 
    0.3994358934176101, -0.16447360317195706`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5617994480029483, 
    0.4681662066691236, -0.18726648266764945`}, {0.5924835974670974, 
    0.5431099643448393, -0.19749453248903248`}, {0.5793426974047388, 
    0.5149712865819899, -0.18023995030369647`}, {0.5543741420185859, 
    0.4558187389930595, -0.17247195529467113`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5924835974670974, 
    0.5431099643448393, -0.19749453248903248`}, {0.6230755279293883, 
    0.6230755279293883, -0.20769184264312943`}, {0.6039532192067091, 
    0.577110853908633, -0.18789655708653166`}, {0.5793426974047388, 
    0.5149712865819899, -0.18023995030369647`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 
    0.6230755279293883, -0.20769184264312943`}, {0.5826314122526858, 
    0.5340787945649619, -0.14565785306317142`}, {0.571505684936255, 
    0.508005053276671, -0.13970138965108453`}, {0.6039532192067091, 
    0.577110853908633, -0.18789655708653166`}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5826314122526858, 
    0.5340787945649619, -0.14565785306317142`}, {0.5423842382927654, 
    0.4519868652439711, -0.09039737304879422}, {0.5388079575040883, 
    0.4430198761700281, -0.09578808133406011}, {0.571505684936255, 
    0.508005053276671, -0.13970138965108453`}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5423842382927654, 
    0.4519868652439711, -0.09039737304879422}, {0.5013779790164214, 
    0.3760334842623161, -0.04178149825136846}, {0.5054364950419619, 
    0.38188535180948235`, -0.05615961056021798}, {0.5388079575040883, 
    0.4430198761700281, -0.09578808133406011}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5013779790164214, 
    0.3760334842623161, -0.04178149825136846}, {0.45998714286871445`, 
    0.3066580952458096, 0.}, {0.47150167762968676`, 
    0.324812266811562, -0.020955630116874954`}, {0.5054364950419619, 
    0.38188535180948235`, -0.05615961056021798}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0.3066580952458096, 0.}, {
    0.4875643330433564, 0.3521297960868685, -0.02708690739129757}, {
    0.49772097016621203`, 0.3705256111237356, -0.027651165009233997`}, {
    0.47617071567397445`, 0.33331950097178215`, -0.005290785729710824}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4875643330433564, 
    0.3521297960868685, -0.02708690739129757}, {0.5151364245658201, 
    0.4006616635511933, -0.057237380507313335`}, {0.5192776126127516, 
    0.4096523388389484, -0.05192776126127516}, {0.49772097016621203`, 
    0.3705256111237356, -0.027651165009233997`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5151364245658201, 
    0.4006616635511933, -0.057237380507313335`}, {0.5423842382927654, 
    0.4519868652439711, -0.09039737304879422}, {0.5406944571684102, 
    0.45057871430700847`, -0.07810031047988147}, {0.5192776126127516, 
    0.4096523388389484, -0.05192776126127516}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5423842382927654, 
    0.4519868652439711, -0.09039737304879422}, {0.5611088996560509, 
    0.49876346636093416`, -0.06234543329511677}, {0.5561327685019032, 
    0.48816098568500393`, -0.055613276850190324`}, {0.5406944571684102, 
    0.45057871430700847`, -0.07810031047988147}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5611088996560509, 
    0.49876346636093416`, -0.06234543329511677}, {0.5810366771432506, 
    0.5487568617464034, -0.03227981539684726}, {0.5723000016162385, 
    0.5277877792683088, -0.03179444453423547}, {0.5561327685019032, 
    0.48816098568500393`, -0.055613276850190324`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432506, 
    0.5487568617464034, -0.03227981539684726}, {0.6020420732135735, 
    0.6020420732135735, 0.}, {0.5891105858887445, 
    0.5694735663591197, -0.006545673176541602}, {0.5723000016162385, 
    0.5277877792683088, -0.03179444453423547}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.6020420732135735, 0.6020420732135735, 0.}, {
    0.5583263670978953, 0.49629010408701807`, 0.}, {0.5538610316580012, 
    0.4861669055664677, -0.006154011462866676}, {0.5891105858887445, 
    0.5694735663591197, -0.006545673176541602}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5583263670978953, 0.49629010408701807`, 0.}, {
    0.5116766815928779, 0.3979707523500161, 0.}, {0.5165717745530933, 
    0.40751773325855134`, -0.005739686383923255}, {0.5538610316580012, 
    0.4861669055664677, -0.006154011462866676}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5116766815928779, 0.3979707523500161, 0.}, {
    0.45998714286871445`, 0.3066580952458096, 0.}, {0.47617071567397445`, 
    0.33331950097178215`, -0.005290785729710824}, {0.5165717745530933, 
    0.40751773325855134`, -0.005739686383923255}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, 0.6020420732135735, 0.}, {
    0.6044295191828238, 0.6044295191828238, -0.06715883546475819}, {
    0.6006503620708005, 0.5939764691589027, -0.0734128220308756}, {
    0.597947646585002, 0.5913037838451686, -0.01993158821950005}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6044295191828238, 
    0.6044295191828238, -0.06715883546475819}, {0.6115080659765835, 
    0.6115080659765835, -0.13589068132812965`}, {0.6063763483828833, 
    0.5996388334008513, -0.12801278465860869`}, {0.6006503620708005, 
    0.5939764691589027, -0.0734128220308756}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, 
    0.6115080659765835, -0.13589068132812965`}, {0.6230755279293883, 
    0.6230755279293883, -0.20769184264312943`}, {0.615005336599669, 
    0.6081719439707838, -0.1845016009799007}, {0.6063763483828833, 
    0.5996388334008513, -0.12801278465860869`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 
    0.6230755279293883, -0.20769184264312943`}, {0.596004248542524, 
    0.5628929014012727, -0.16555673570625667`}, {0.5936572660606888, 
    0.560676306835095, -0.15171241243773156`}, {0.615005336599669, 
    0.6081719439707838, -0.1845016009799007}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.596004248542524, 
    0.5628929014012727, -0.16555673570625667`}, {0.5692683486017988, 
    0.5060163098682655, -0.12650407746706638`}, {0.5725114059716361, 
    0.5152602653744724, -0.1208635190384565}, {0.5936572660606888, 
    0.560676306835095, -0.15171241243773156`}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5692683486017988, 
    0.5060163098682655, -0.12650407746706638`}, {0.5423842382927654, 
    0.4519868652439711, -0.09039737304879422}, {0.5513356533463394, 
    0.4716982811963126, -0.09188927555772322}, {0.5725114059716361, 
    0.5152602653744724, -0.1208635190384565}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5423842382927654, 
    0.4519868652439711, -0.09039737304879422}, {0.5611088996560509, 
    0.49876346636093416`, -0.06234543329511677}, {0.5660913502754555, 
    0.5094822152479099, -0.06918894281144455}, {0.5513356533463394, 
    0.4716982811963126, -0.09188927555772322}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5611088996560509, 
    0.49876346636093416`, -0.06234543329511677}, {0.5810366771432506, 
    0.5487568617464034, -0.03227981539684726}, {0.5816501238360723, 
    0.5493362280674016, -0.04523945407613895}, {0.5660913502754555, 
    0.5094822152479099, -0.06918894281144455}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5810366771432506, 
    0.5487568617464034, -0.03227981539684726}, {0.6020420732135735, 
    0.6020420732135735, 0.}, {0.597947646585002, 
    0.5913037838451686, -0.01993158821950005}, {0.5816501238360723, 
    0.5493362280674016, -0.04523945407613895}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.6115080659765835, 
    0.4756173846484537, -0.40767204398438894`}, {0.6176006003263583, 
    0.48721825136857155`, -0.4185959624434206}, {0.5920832028449382, 
    0.41445824199145676`, -0.4013008374837915}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, 
    0.4756173846484537, -0.40767204398438894`}, {0.6457005460543618, 
    0.5739560409372104, -0.4304670307029078}, {0.6448463554356526, 
    0.5660318008824062, -0.43706252979527566`}, {0.6176006003263583, 
    0.48721825136857155`, -0.4185959624434206}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6457005460543618, 
    0.5739560409372104, -0.4304670307029078}, {0.6845537086570662, 
    0.6845537086570662, -0.4563691391047108}, {0.6749630549963996, 
    0.6524642864965196, -0.4574749594975597}, {0.6448463554356526, 
    0.5660318008824062, -0.43706252979527566`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 
    0.6845537086570662, -0.4563691391047108}, {0.6786794799954298, 
    0.6409750644401281, -0.49015740221892146`}, {0.670907588604451, 
    0.6187258872685492, -0.484544369547659}, {0.6749630549963996, 
    0.6524642864965196, -0.4574749594975597}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6786794799954298, 
    0.6409750644401281, -0.49015740221892146`}, {0.6751944561946608, 
    0.6001728499508097, -0.5251512437069583}, {0.6683421713383466, 
    0.5866559059525488, -0.5123956646927323}, {0.670907588604451, 
    0.6187258872685492, -0.484544369547659}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6751944561946608, 
    0.6001728499508097, -0.5251512437069583}, {0.6740385471308696, 
    0.5616987892757247, -0.5616987892757247}, {0.6672459372836057, 
    0.5560382810696715, -0.5412105935744802}, {0.6683421713383466, 
    0.5866559059525488, -0.5123956646927323}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6740385471308696, 
    0.5616987892757247, -0.5616987892757247}, {0.6412032180604118, 
    0.49871361404698694`, -0.49871361404698694`}, {0.641248218995467, 
    0.5058735949853128, -0.4916236345631913}, {0.6672459372836057, 
    0.5560382810696715, -0.5412105935744802}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6412032180604118, 
    0.49871361404698694`, -0.49871361404698694`}, {0.6103364275727268, 
    0.4407985310247471, -0.4407985310247471}, {0.6164899353312527, 
    0.4589425074132659, -0.4452427310725714}, {0.641248218995467, 
    0.5058735949853128, -0.4916236345631913}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6103364275727268, 
    0.4407985310247471, -0.4407985310247471}, {0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {0.5920832028449382, 
    0.41445824199145676`, -0.4013008374837915}, {0.6164899353312527, 
    0.4589425074132659, -0.4452427310725714}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 
    0.6845537086570662, -0.4563691391047108}, {0.6786794799954298, 
    0.6409750644401281, -0.49015740221892146`}, {0.6848853908126196, 
    0.6468362024341406, -0.5098591242716168}, {0.6890827403984796, 
    0.6814262655051632, -0.4823579182789357}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6786794799954298, 
    0.6409750644401281, -0.49015740221892146`}, {0.6751944561946608, 
    0.6001728499508097, -0.5251512437069583}, {0.68224035411735, 
    0.614016318705615, -0.5382118349147983}, {0.6848853908126196, 
    0.6468362024341406, -0.5098591242716168}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6751944561946608, 
    0.6001728499508097, -0.5251512437069583}, {0.6740385471308696, 
    0.5616987892757247, -0.5616987892757247}, {0.6811124367744867, 
    0.5827295292403942, -0.5675936973120723}, {0.68224035411735, 
    0.614016318705615, -0.5382118349147983}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6740385471308696, 
    0.5616987892757247, -0.5616987892757247}, {0.7118600880536767, 
    0.6327645227143793, -0.6327645227143793}, {0.7119126797168901, 
    0.6407214117452011, -0.6249011299737146}, {0.6811124367744867, 
    0.5827295292403942, -0.5675936973120723}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7118600880536767, 
    0.6327645227143793, -0.6327645227143793}, {0.7622103197175837, 
    0.7198653019554957, -0.7198653019554957}, {0.7504115684601292, 
    0.7087220368790109, -0.6920462242465636}, {0.7119126797168901, 
    0.6407214117452011, -0.6249011299737146}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7622103197175837, 
    0.7198653019554957, -0.7198653019554957}, {0.9068996821171088, 
    0.9068996821171088, -0.9068996821171088}, {0.8104554067121754, 
    0.8014503466375957, -0.7834402264884363}, {0.7504115684601292, 
    0.7087220368790109, -0.6920462242465636}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.9068996821171088, 
    0.9068996821171088, -0.9068996821171088}, {0.7640699024805022, 
    0.7640699024805022, -0.6791732466493353}, {0.7520300306261339, 
    0.7436741413969546, -0.6601152491051621}, {0.8104554067121754, 
    0.8014503466375957, -0.7834402264884363}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7640699024805022, 
    0.7640699024805022, -0.6791732466493353}, {0.7171888530767329, 
    0.7171888530767329, -0.5578135523930144}, {0.716165180138544, 
    0.7082077892481158, -0.5649747532204069}, {0.7520300306261339, 
    0.7436741413969546, -0.6601152491051621}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7171888530767329, 
    0.7171888530767329, -0.5578135523930144}, {0.6845537086570662, 
    0.6845537086570662, -0.4563691391047108}, {0.6890827403984796, 
    0.6814262655051632, -0.4823579182789357}, {0.716165180138544, 
    0.7082077892481158, -0.5649747532204069}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {
    0.07756663751797302, -0.005171109167864868, 0.005171109167864868}, {
    0.11600941429253843`, -0.008765155746547347, 0.013921129715104607`}, {
    0.05793069453624921, -0.0012873487674722039`, 0.0038620463024166113`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07756663751797302, -0.005171109167864868, 
    0.005171109167864868}, {0.15308565553031123`, -0.02041142073737483, 
    0.02041142073737483}, {0.17441633647095503`, -0.02248032781181198, 
    0.030232164988298865`}, {0.11600941429253843`, -0.008765155746547347, 
    0.013921129715104607`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.15308565553031123`, -0.02041142073737483, 
    0.02041142073737483}, {0.22479511109484523`, -0.04495902221896904, 
    0.04495902221896904}, {0.23065124757750236`, -0.04202978289190042, 
    0.052280949450900525`}, {0.17441633647095503`, -0.02248032781181198, 
    0.030232164988298865`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.22479511109484523`, -0.04495902221896904, 
    0.04495902221896904}, {0.2914261673100827, -0.07771364461602205, 
    0.07771364461602205}, {0.2837917818761621, -0.0668487308419404, 
    0.07946169892532537}, {0.23065124757750236`, -0.04202978289190042, 
    0.052280949450900525`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2914261673100827, -0.07771364461602205, 
    0.07771364461602205}, {0.35229120018115184`, -0.11743040006038394`, 
    0.11743040006038394`}, {0.3333736846483348, -0.09630795334285228, 
    0.11112456154944492`}, {0.2837917818761621, -0.0668487308419404, 
    0.07946169892532537}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.35229120018115184`, -0.11743040006038394`, 
    0.11743040006038394`}, {0.3579949935256501, -0.09546533160684004, 
    0.14319799741026004`}, {0.3407298274347052, -0.08026080379573056, 
    0.131748866608086}, {0.3333736846483348, -0.09630795334285228, 
    0.11112456154944492`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3579949935256501, -0.09546533160684004, 
    0.14319799741026004`}, {0.37415229431745833`, -0.07483045886349166, 
    0.1746044040148139}, {0.3552530406979347, -0.0647349985271792, 
    0.15631133790709126`}, {0.3407298274347052, -0.08026080379573056, 
    0.131748866608086}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.37415229431745833`, -0.07483045886349166, 
    0.1746044040148139}, {0.3983729048897056, -0.05311638731862741, 
    0.21246554927450964`}, {0.3754334096530939, -0.04838919502195432, 
    0.18521381542885962`}, {0.3552530406979347, -0.0647349985271792, 
    0.15631133790709126`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3983729048897056, -0.05311638731862741, 
    0.21246554927450964`}, {0.42781593715312194`, -0.028521062476874796`, 
    0.2566895622918732}, {0.39956209892042155`, -0.030189136362876293`, 
    0.21842728074316375`}, {0.3754334096530939, -0.04838919502195432, 
    0.18521381542885962`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.42781593715312194`, -0.028521062476874796`, 
    0.2566895622918732}, {0.45998714286871445`, 0., 0.3066580952458096}, {
    0.4260763439843505, -0.009468363199652228, 0.2556458063906103}, {
    0.39956209892042155`, -0.030189136362876293`, 0.21842728074316375`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., 0.3066580952458096}, {
    0.38905011534806727`, 0., 0.20749339485230253`}, {
    0.36589693116182753`, -0.008131042914707273, 0.18050915270650156`}, {
    0.4260763439843505, -0.009468363199652228, 0.2556458063906103}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38905011534806727`, 0., 0.20749339485230253`}, {
    0.30673802522798127`, 0., 0.1226952100911925}, {
    0.2982832465218531, -0.006628516589374509, 0.11533618865511652`}, {
    0.36589693116182753`, -0.008131042914707273, 0.18050915270650156`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.30673802522798127`, 0., 0.1226952100911925}, {
    0.21282462147366246`, 0., 0.05675323239297665}, {
    0.22335095439184463`, -0.004963354542040988, 0.06253826722971649}, {
    0.2982832465218531, -0.006628516589374509, 0.11533618865511652`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21282462147366246`, 0., 0.05675323239297665}, {
    0.10920608786993075`, 0., 0.014560811715990765`}, {
    0.142224790973981, -0.003160550910532909, 0.0246522971021567}, {
    0.22335095439184463`, -0.004963354542040988, 0.06253826722971649}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.10920608786993075`, 0., 0.014560811715990765`}, {
    0., 0., 0.}, {0.05793069453624921, -0.0012873487674722039`, 
    0.0038620463024166113`}, {0.142224790973981, -0.003160550910532909, 
    0.0246522971021567}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., 0.3066580952458096}, {
    0.4664505261905705, -0.06219340349207606, 0.3109670174603803}, {
    0.4603228910236794, -0.07978930111077108, 0.2966525297708156}, {
    0.45062802082557046`, -0.03004186805503801, 0.29040472453203425`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4664505261905705, -0.06219340349207606, 
    0.3109670174603803}, {0.48461849963627207`, -0.12923159990300587`, 
    0.3230789997575147}, {0.4773844806346103, -0.13366765457769086`, 
    0.30764777640897106`}, {0.4603228910236794, -0.07978930111077108, 
    0.2966525297708156}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.48461849963627207`, -0.12923159990300587`, 
    0.3230789997575147}, {0.5115370291932914, -0.20461481167731652`, 
    0.3410246861288609}, {0.4999952944034249, -0.19333151383599093`, 
    0.32221918972665153`}, {0.4773844806346103, -0.13366765457769086`, 
    0.30764777640897106`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5115370291932914, -0.20461481167731652`, 
    0.3410246861288609}, {0.5440012355218949, -0.29013399227834397`, 
    0.36266749034792994`}, {0.5263215102011988, -0.25965194503259137`, 
    0.3391849732407725}, {0.4999952944034249, -0.19333151383599093`, 
    0.32221918972665153`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5440012355218949, -0.29013399227834397`, 
    0.36266749034792994`}, {0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.5549429157801637, -0.3329657494680982, 
    0.3576298790583277}, {0.5263215102011988, -0.25965194503259137`, 
    0.3391849732407725}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.5418425399938036, -0.3251055239962821, 
    0.3251055239962821}, {0.5235616495156941, -0.2862137017352461, 
    0.30948310838038806`}, {0.5549429157801637, -0.3329657494680982, 
    0.3576298790583277}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5418425399938036, -0.3251055239962821, 
    0.3251055239962821}, {0.5012123976166442, -0.2673132787288769, 
    0.2673132787288769}, {0.49007301405696324`, -0.24176935360143517`, 
    0.2635503764484113}, {0.5235616495156941, -0.2862137017352461, 
    0.30948310838038806`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5012123976166442, -0.2673132787288769, 
    0.2673132787288769}, {0.4566708874648107, -0.21311308081691166`, 
    0.21311308081691166`}, {0.4539150995168281, -0.19972264378740437`, 
    0.2198966482103745}, {0.49007301405696324`, -0.24176935360143517`, 
    0.2635503764484113}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4566708874648107, -0.21311308081691166`, 
    0.21311308081691166`}, {0.40726070505008105`, -0.1629042820200324, 
    0.1629042820200324}, {0.4146226594222878, -0.1603207616432846, 
    0.1787484353953863}, {0.4539150995168281, -0.19972264378740437`, 
    0.2198966482103745}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.40726070505008105`, -0.1629042820200324, 
    0.1629042820200324}, {0.35229120018115184`, -0.11743040006038394`, 
    0.11743040006038394`}, {0.37184302234147004`, -0.12394767411382335`, 
    0.1404740306623331}, {0.4146226594222878, -0.1603207616432846, 
    0.1787484353953863}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.35229120018115184`, -0.11743040006038394`, 
    0.11743040006038394`}, {0.3579949935256501, -0.09546533160684004, 
    0.14319799741026004`}, {0.37788015107523965`, -0.10580644230106709`, 
    0.16290833179688105`}, {0.37184302234147004`, -0.12394767411382335`, 
    0.1404740306623331}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3579949935256501, -0.09546533160684004, 
    0.14319799741026004`}, {0.37415229431745833`, -0.07483045886349166, 
    0.1746044040148139}, {0.38991864684146027`, -0.08838155995073098, 
    0.18889392224764073`}, {0.37788015107523965`, -0.10580644230106709`, 
    0.16290833179688105`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.37415229431745833`, -0.07483045886349166, 
    0.1746044040148139}, {0.3983729048897056, -0.05311638731862741, 
    0.21246554927450964`}, {0.40689371670049274`, -0.07052824422808539, 
    0.2188183987589316}, {0.38991864684146027`, -0.08838155995073098, 
    0.18889392224764073`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3983729048897056, -0.05311638731862741, 
    0.21246554927450964`}, {0.42781593715312194`, -0.028521062476874796`, 
    0.2566895622918732}, {0.4275386729168246, -0.05130464075001894, 
    0.2527228599908341}, {0.40689371670049274`, -0.07052824422808539, 
    0.2188183987589316}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.42781593715312194`, -0.028521062476874796`, 
    0.2566895622918732}, {0.45998714286871445`, 0., 0.3066580952458096}, {
    0.45062802082557046`, -0.03004186805503801, 0.29040472453203425`}, {
    0.4275386729168246, -0.05130464075001894, 0.2527228599908341}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {0.10920608786993075`, 0., 
    0.014560811715990765`}, {0.142224790973981, 0.003160550910532909, 
    0.0246522971021567}, {0.05793069453624921, 0.0012873487674722039`, 
    0.0038620463024166113`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.10920608786993075`, 0., 0.014560811715990765`}, {
    0.21282462147366246`, 0., 0.05675323239297665}, {0.22335095439184463`, 
    0.004963354542040988, 0.06253826722971648}, {0.142224790973981, 
    0.003160550910532909, 0.0246522971021567}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.21282462147366246`, 0., 0.05675323239297665}, {
    0.30673802522798127`, 0., 0.1226952100911925}, {0.2982832465218531, 
    0.006628516589374509, 0.11533618865511652`}, {0.22335095439184463`, 
    0.004963354542040988, 0.06253826722971648}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.30673802522798127`, 0., 0.1226952100911925}, {
    0.38905011534806727`, 0., 0.20749339485230253`}, {0.36589693116182753`, 
    0.008131042914707273, 0.18050915270650156`}, {0.2982832465218531, 
    0.006628516589374509, 0.11533618865511652`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38905011534806727`, 0., 0.20749339485230253`}, {
    0.45998714286871445`, 0., 0.3066580952458096}, {0.4260763439843505, 
    0.009468363199652228, 0.2556458063906103}, {0.36589693116182753`, 
    0.008131042914707273, 0.18050915270650156`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., 0.3066580952458096}, {
    0.42781593715312194`, 0.028521062476874796`, 0.2566895622918732}, {
    0.39956209892042155`, 0.030189136362876293`, 0.21842728074316375`}, {
    0.4260763439843505, 0.009468363199652228, 0.2556458063906103}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.42781593715312194`, 0.028521062476874796`, 
    0.2566895622918732}, {0.3983729048897056, 0.05311638731862741, 
    0.21246554927450964`}, {0.3754334096530939, 0.04838919502195432, 
    0.18521381542885962`}, {0.39956209892042155`, 0.030189136362876293`, 
    0.21842728074316375`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3983729048897056, 0.05311638731862741, 
    0.21246554927450964`}, {0.37415229431745833`, 0.07483045886349166, 
    0.1746044040148139}, {0.3552530406979347, 0.0647349985271792, 
    0.15631133790709126`}, {0.3754334096530939, 0.04838919502195432, 
    0.18521381542885962`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.37415229431745833`, 0.07483045886349166, 
    0.1746044040148139}, {0.3579949935256501, 0.09546533160684004, 
    0.14319799741026004`}, {0.3407298274347052, 0.08026080379573056, 
    0.131748866608086}, {0.3552530406979347, 0.0647349985271792, 
    0.15631133790709126`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3579949935256501, 0.09546533160684004, 
    0.14319799741026004`}, {0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {0.3333736846483348, 0.09630795334285228, 
    0.11112456154944492`}, {0.3407298274347052, 0.08026080379573056, 
    0.131748866608086}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {0.2914261673100827, 0.07771364461602205, 
    0.07771364461602205}, {0.2837917818761621, 0.0668487308419404, 
    0.07946169892532537}, {0.3333736846483348, 0.09630795334285228, 
    0.11112456154944492`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2914261673100827, 0.07771364461602205, 
    0.07771364461602205}, {0.22479511109484523`, 0.04495902221896904, 
    0.04495902221896904}, {0.23065124757750236`, 0.04202978289190042, 
    0.052280949450900525`}, {0.2837917818761621, 0.0668487308419404, 
    0.07946169892532537}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.22479511109484523`, 0.04495902221896904, 
    0.04495902221896904}, {0.15308565553031123`, 0.02041142073737483, 
    0.02041142073737483}, {0.17441633647095503`, 0.02248032781181198, 
    0.030232164988298865`}, {0.23065124757750236`, 0.04202978289190042, 
    0.052280949450900525`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.15308565553031123`, 0.02041142073737483, 
    0.02041142073737483}, {0.07756663751797302, 0.005171109167864868, 
    0.005171109167864868}, {0.11600941429253843`, 0.008765155746547347, 
    0.013921129715104607`}, {0.17441633647095503`, 0.02248032781181198, 
    0.030232164988298865`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07756663751797302, 0.005171109167864868, 
    0.005171109167864868}, {0., 0., 0.}, {0.05793069453624921, 
    0.0012873487674722039`, 0.0038620463024166113`}, {0.11600941429253843`, 
    0.008765155746547347, 0.013921129715104607`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., 0.3066580952458096}, {
    0.42781593715312194`, 0.028521062476874796`, 0.2566895622918732}, {
    0.4275386729168246, 0.05130464075001894, 0.2527228599908341}, {
    0.45062802082557046`, 0.03004186805503801, 0.29040472453203425`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.42781593715312194`, 0.028521062476874796`, 
    0.2566895622918732}, {0.3983729048897056, 0.05311638731862741, 
    0.21246554927450964`}, {0.40689371670049274`, 0.07052824422808539, 
    0.2188183987589316}, {0.4275386729168246, 0.05130464075001894, 
    0.2527228599908341}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3983729048897056, 0.05311638731862741, 
    0.21246554927450964`}, {0.37415229431745833`, 0.07483045886349166, 
    0.1746044040148139}, {0.38991864684146027`, 0.08838155995073098, 
    0.18889392224764073`}, {0.40689371670049274`, 0.07052824422808539, 
    0.2188183987589316}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.37415229431745833`, 0.07483045886349166, 
    0.1746044040148139}, {0.3579949935256501, 0.09546533160684004, 
    0.14319799741026004`}, {0.37788015107523965`, 0.10580644230106709`, 
    0.16290833179688105`}, {0.38991864684146027`, 0.08838155995073098, 
    0.18889392224764073`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3579949935256501, 0.09546533160684004, 
    0.14319799741026004`}, {0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {0.37184302234147004`, 0.12394767411382335`, 
    0.1404740306623331}, {0.37788015107523965`, 0.10580644230106709`, 
    0.16290833179688105`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {0.40726070505008105`, 0.1629042820200324, 
    0.1629042820200324}, {0.4146226594222878, 0.1603207616432846, 
    0.1787484353953863}, {0.37184302234147004`, 0.12394767411382335`, 
    0.1404740306623331}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.40726070505008105`, 0.1629042820200324, 
    0.1629042820200324}, {0.4566708874648107, 0.21311308081691166`, 
    0.21311308081691166`}, {0.4539150995168281, 0.19972264378740437`, 
    0.2198966482103745}, {0.4146226594222878, 0.1603207616432846, 
    0.1787484353953863}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4566708874648107, 0.21311308081691166`, 
    0.21311308081691166`}, {0.5012123976166442, 0.2673132787288769, 
    0.2673132787288769}, {0.49007301405696324`, 0.24176935360143517`, 
    0.2635503764484113}, {0.4539150995168281, 0.19972264378740437`, 
    0.2198966482103745}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5012123976166442, 0.2673132787288769, 
    0.2673132787288769}, {0.5418425399938036, 0.3251055239962821, 
    0.3251055239962821}, {0.5235616495156941, 0.2862137017352461, 
    0.30948310838038806`}, {0.49007301405696324`, 0.24176935360143517`, 
    0.2635503764484113}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5418425399938036, 0.3251055239962821, 
    0.3251055239962821}, {0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.5549429157801637, 0.3329657494680982, 
    0.3576298790583277}, {0.5235616495156941, 0.2862137017352461, 
    0.30948310838038806`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.5440012355218949, 0.29013399227834397`, 
    0.36266749034792994`}, {0.5263215102011988, 0.25965194503259137`, 
    0.3391849732407725}, {0.5549429157801637, 0.3329657494680982, 
    0.3576298790583277}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5440012355218949, 0.29013399227834397`, 
    0.36266749034792994`}, {0.5115370291932914, 0.20461481167731652`, 
    0.3410246861288609}, {0.4999952944034249, 0.19333151383599093`, 
    0.32221918972665153`}, {0.5263215102011988, 0.25965194503259137`, 
    0.3391849732407725}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5115370291932914, 0.20461481167731652`, 
    0.3410246861288609}, {0.48461849963627207`, 0.12923159990300587`, 
    0.3230789997575147}, {0.4773844806346103, 0.1336676545776909, 
    0.30764777640897106`}, {0.4999952944034249, 0.19333151383599093`, 
    0.32221918972665153`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.48461849963627207`, 0.12923159990300587`, 
    0.3230789997575147}, {0.4664505261905705, 0.06219340349207606, 
    0.3109670174603803}, {0.4603228910236794, 0.07978930111077108, 
    0.2966525297708156}, {0.4773844806346103, 0.1336676545776909, 
    0.30764777640897106`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4664505261905705, 0.06219340349207606, 
    0.3109670174603803}, {0.45998714286871445`, 0., 0.3066580952458096}, {
    0.45062802082557046`, 0.03004186805503801, 0.29040472453203425`}, {
    0.4603228910236794, 0.07978930111077108, 0.2966525297708156}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.6103364275727268, -0.4407985310247471, 
    0.4407985310247471}, {0.6164899353312527, -0.4452427310725714, 
    0.4589425074132659}, {0.5920832028449382, -0.4013008374837915, 
    0.41445824199145676`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6103364275727268, -0.4407985310247471, 
    0.4407985310247471}, {0.6412032180604118, -0.49871361404698694`, 
    0.49871361404698694`}, {0.641248218995467, -0.4916236345631913, 
    0.5058735949853128}, {0.6164899353312527, -0.4452427310725714, 
    0.4589425074132659}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6412032180604118, -0.49871361404698694`, 
    0.49871361404698694`}, {0.6740385471308696, -0.5616987892757247, 
    0.5616987892757247}, {0.6672459372836057, -0.5412105935744802, 
    0.5560382810696715}, {0.641248218995467, -0.4916236345631913, 
    0.5058735949853128}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6740385471308696, -0.5616987892757247, 
    0.5616987892757247}, {0.6751944561946608, -0.5251512437069583, 
    0.6001728499508097}, {0.6683421713383466, -0.5123956646927323, 
    0.5866559059525488}, {0.6672459372836057, -0.5412105935744802, 
    0.5560382810696715}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6751944561946608, -0.5251512437069583, 
    0.6001728499508097}, {0.6786794799954298, -0.49015740221892146`, 
    0.6409750644401281}, {0.670907588604451, -0.484544369547659, 
    0.6187258872685492}, {0.6683421713383466, -0.5123956646927323, 
    0.5866559059525488}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6786794799954298, -0.49015740221892146`, 
    0.6409750644401281}, {0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.6749630549963996, -0.4574749594975597, 
    0.6524642864965196}, {0.670907588604451, -0.484544369547659, 
    0.6187258872685492}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.6457005460543618, -0.4304670307029078, 
    0.5739560409372104}, {0.6448463554356526, -0.43706252979527566`, 
    0.5660318008824062}, {0.6749630549963996, -0.4574749594975597, 
    0.6524642864965196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6457005460543618, -0.4304670307029078, 
    0.5739560409372104}, {0.6115080659765835, -0.40767204398438894`, 
    0.4756173846484537}, {0.6176006003263583, -0.4185959624434206, 
    0.48721825136857155`}, {0.6448463554356526, -0.43706252979527566`, 
    0.5660318008824062}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, -0.40767204398438894`, 
    0.4756173846484537}, {0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.5920832028449382, -0.4013008374837915, 
    0.41445824199145676`}, {0.6176006003263583, -0.4185959624434206, 
    0.48721825136857155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.7171888530767329, -0.5578135523930144, 
    0.7171888530767329}, {0.716165180138544, -0.5649747532204069, 
    0.7082077892481158}, {0.6890827403984794, -0.48235791827893554`, 
    0.6814262655051629}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7171888530767329, -0.5578135523930144, 
    0.7171888530767329}, {0.7640699024805022, -0.6791732466493353, 
    0.7640699024805022}, {0.7520300306261339, -0.6601152491051621, 
    0.7436741413969546}, {0.716165180138544, -0.5649747532204069, 
    0.7082077892481158}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7640699024805022, -0.6791732466493353, 
    0.7640699024805022}, {0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {0.8104554067121754, -0.7834402264884363, 
    0.8014503466375957}, {0.7520300306261339, -0.6601152491051621, 
    0.7436741413969546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {0.7622103197175837, -0.7198653019554957, 
    0.7198653019554957}, {0.7504115684601292, -0.6920462242465636, 
    0.7087220368790109}, {0.8104554067121754, -0.7834402264884363, 
    0.8014503466375957}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7622103197175837, -0.7198653019554957, 
    0.7198653019554957}, {0.7118600880536767, -0.6327645227143793, 
    0.6327645227143793}, {0.7119126797168901, -0.6249011299737146, 
    0.6407214117452011}, {0.7504115684601292, -0.6920462242465636, 
    0.7087220368790109}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7118600880536767, -0.6327645227143793, 
    0.6327645227143793}, {0.6740385471308696, -0.5616987892757247, 
    0.5616987892757247}, {0.6811124367744867, -0.5675936973120723, 
    0.5827295292403942}, {0.7119126797168901, -0.6249011299737146, 
    0.6407214117452011}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6740385471308696, -0.5616987892757247, 
    0.5616987892757247}, {0.6751944561946608, -0.5251512437069583, 
    0.6001728499508097}, {0.68224035411735, -0.5382118349147983, 
    0.614016318705615}, {0.6811124367744867, -0.5675936973120723, 
    0.5827295292403942}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6751944561946608, -0.5251512437069583, 
    0.6001728499508097}, {0.6786794799954298, -0.49015740221892146`, 
    0.6409750644401281}, {0.6848853908126196, -0.5098591242716168, 
    0.6468362024341406}, {0.68224035411735, -0.5382118349147983, 
    0.614016318705615}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6786794799954298, -0.49015740221892146`, 
    0.6409750644401281}, {0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.6890827403984794, -0.48235791827893554`, 
    0.6814262655051629}, {0.6848853908126196, -0.5098591242716168, 
    0.6468362024341406}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., 0.3066580952458096}, {
    0.46253818353867265`, -0.038544848628222717`, 0.30835878902578173`}, {
    0.47507741354102534`, -0.052786379282336135`, 0.3272755515504841}, {
    0.47150167762968676`, -0.020955630116874954`, 0.324812266811562}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.46253818353867265`, -0.038544848628222717`, 
    0.30835878902578173`}, {0.46999171897491077`, -0.07833195316248512, 
    0.3133278126499405}, {0.48154514744522636`, -0.08560802621248467, 
    0.33173110157337815`}, {0.47507741354102534`, -0.052786379282336135`, 
    0.3272755515504841}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.46999171897491077`, -0.07833195316248512, 
    0.3133278126499405}, {0.4817997617497233, -0.12044994043743079`, 
    0.32119984116648215`}, {0.4906212440644457, -0.11992963743797559`, 
    0.3379835236888404}, {0.48154514744522636`, -0.08560802621248467, 
    0.33173110157337815`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4817997617497233, -0.12044994043743079`, 
    0.32119984116648215`}, {0.4971955577882874, -0.1657318525960958, 
    0.3314637051921916}, {0.5019472405700409, -0.1561613637329016, 
    0.3457858768371393}, {0.4906212440644457, -0.11992963743797559`, 
    0.3379835236888404}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4971955577882874, -0.1657318525960958, 
    0.3314637051921916}, {0.530207257345758, -0.176735752448586, 
    0.39765544300931854`}, {0.5286651530527192, -0.16447360317195706`, 
    0.3994358934176101}, {0.5019472405700409, -0.1561613637329016, 
    0.3457858768371393}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.530207257345758, -0.176735752448586, 
    0.39765544300931854`}, {0.5617994480029483, -0.18726648266764945`, 
    0.4681662066691236}, {0.5543741420185859, -0.17247195529467113`, 
    0.4558187389930595}, {0.5286651530527192, -0.16447360317195706`, 
    0.3994358934176101}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5617994480029483, -0.18726648266764945`, 
    0.4681662066691236}, {0.5924835974670974, -0.19749453248903248`, 
    0.5431099643448393}, {0.5793426974047388, -0.18023995030369647`, 
    0.5149712865819899}, {0.5543741420185859, -0.17247195529467113`, 
    0.4558187389930595}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5924835974670974, -0.19749453248903248`, 
    0.5431099643448393}, {0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.6039532192067091, -0.18789655708653166`, 
    0.577110853908633}, {0.5793426974047388, -0.18023995030369647`, 
    0.5149712865819899}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.5826314122526858, -0.14565785306317142`, 
    0.5340787945649619}, {0.571505684936255, -0.13970138965108453`, 
    0.508005053276671}, {0.6039532192067091, -0.18789655708653166`, 
    0.577110853908633}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5826314122526858, -0.14565785306317142`, 
    0.5340787945649619}, {0.5423842382927654, -0.09039737304879422, 
    0.4519868652439711}, {0.5388079575040883, -0.09578808133406011, 
    0.4430198761700281}, {0.571505684936255, -0.13970138965108453`, 
    0.508005053276671}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5423842382927654, -0.09039737304879422, 
    0.4519868652439711}, {0.5013779790164213, -0.041781498251368454`, 
    0.37603348426231603`}, {0.5054364950419619, -0.05615961056021798, 
    0.38188535180948235`}, {0.5388079575040883, -0.09578808133406011, 
    0.4430198761700281}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5013779790164213, -0.041781498251368454`, 
    0.37603348426231603`}, {0.45998714286871445`, 0., 0.3066580952458096}, {
    0.47150167762968676`, -0.020955630116874954`, 0.324812266811562}, {
    0.5054364950419619, -0.05615961056021798, 0.38188535180948235`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., 0.3066580952458096}, {
    0.4875643330433564, -0.02708690739129757, 0.3521297960868685}, {
    0.4977209701662121, -0.027651165009234, 0.37052561112373567`}, {
    0.47617071567397445`, -0.005290785729710824, 0.33331950097178215`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4875643330433564, -0.02708690739129757, 
    0.3521297960868685}, {0.5151364245658201, -0.057237380507313335`, 
    0.4006616635511933}, {0.5192776126127516, -0.05192776126127516, 
    0.4096523388389484}, {0.4977209701662121, -0.027651165009234, 
    0.37052561112373567`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5151364245658201, -0.057237380507313335`, 
    0.4006616635511933}, {0.5423842382927654, -0.09039737304879422, 
    0.4519868652439711}, {0.5406944571684102, -0.07810031047988147, 
    0.45057871430700847`}, {0.5192776126127516, -0.05192776126127516, 
    0.4096523388389484}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5423842382927654, -0.09039737304879422, 
    0.4519868652439711}, {0.5611088996560509, -0.06234543329511677, 
    0.49876346636093416`}, {0.5561327685019032, -0.055613276850190324`, 
    0.48816098568500393`}, {0.5406944571684102, -0.07810031047988147, 
    0.45057871430700847`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5611088996560509, -0.06234543329511677, 
    0.49876346636093416`}, {0.5810366771432506, -0.03227981539684726, 
    0.5487568617464034}, {0.5723000016162385, -0.03179444453423547, 
    0.5277877792683088}, {0.5561327685019032, -0.055613276850190324`, 
    0.48816098568500393`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432506, -0.03227981539684726, 
    0.5487568617464034}, {0.6020420732135735, 0., 0.6020420732135735}, {
    0.5891105858887445, -0.006545673176541602, 0.5694735663591197}, {
    0.5723000016162385, -0.03179444453423547, 0.5277877792683088}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, 0., 0.6020420732135735}, {
    0.5583263670978953, 0., 0.49629010408701807`}, {
    0.5538610316580012, -0.006154011462866676, 0.4861669055664677}, {
    0.5891105858887445, -0.006545673176541602, 0.5694735663591197}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5583263670978953, 0., 0.49629010408701807`}, {
    0.5116766815928779, 0., 0.3979707523500161}, {
    0.5165717745530933, -0.005739686383923255, 0.40751773325855134`}, {
    0.5538610316580012, -0.006154011462866676, 0.4861669055664677}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5116766815928779, 0., 0.3979707523500161}, {
    0.45998714286871445`, 0., 0.3066580952458096}, {
    0.47617071567397445`, -0.005290785729710824, 0.33331950097178215`}, {
    0.5165717745530933, -0.005739686383923255, 0.40751773325855134`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, 0., 0.6020420732135735}, {
    0.6044295191828238, -0.06715883546475819, 0.6044295191828238}, {
    0.6006503620708005, -0.0734128220308756, 0.5939764691589027}, {
    0.597947646585002, -0.01993158821950005, 0.5913037838451686}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6044295191828238, -0.06715883546475819, 
    0.6044295191828238}, {0.6115080659765835, -0.13589068132812965`, 
    0.6115080659765835}, {0.6063763483828833, -0.12801278465860869`, 
    0.5996388334008513}, {0.6006503620708005, -0.0734128220308756, 
    0.5939764691589027}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, -0.13589068132812965`, 
    0.6115080659765835}, {0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.615005336599669, -0.1845016009799007, 
    0.6081719439707838}, {0.6063763483828833, -0.12801278465860869`, 
    0.5996388334008513}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.5960042485425239, -0.16555673570625662`, 
    0.5628929014012725}, {0.5936572660606888, -0.15171241243773156`, 
    0.560676306835095}, {0.615005336599669, -0.1845016009799007, 
    0.6081719439707838}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5960042485425239, -0.16555673570625662`, 
    0.5628929014012725}, {0.5692683486017988, -0.12650407746706638`, 
    0.5060163098682655}, {0.572511405971636, -0.12086351903845649`, 
    0.5152602653744724}, {0.5936572660606888, -0.15171241243773156`, 
    0.560676306835095}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5692683486017988, -0.12650407746706638`, 
    0.5060163098682655}, {0.5423842382927654, -0.09039737304879422, 
    0.4519868652439711}, {0.5513356533463394, -0.09188927555772322, 
    0.4716982811963126}, {0.572511405971636, -0.12086351903845649`, 
    0.5152602653744724}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5423842382927654, -0.09039737304879422, 
    0.4519868652439711}, {0.5611088996560509, -0.06234543329511677, 
    0.49876346636093416`}, {0.5660913502754553, -0.06918894281144454, 
    0.5094822152479098}, {0.5513356533463394, -0.09188927555772322, 
    0.4716982811963126}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5611088996560509, -0.06234543329511677, 
    0.49876346636093416`}, {0.5810366771432506, -0.03227981539684726, 
    0.5487568617464034}, {0.5816501238360723, -0.04523945407613895, 
    0.5493362280674016}, {0.5660913502754553, -0.06918894281144454, 
    0.5094822152479098}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432506, -0.03227981539684726, 
    0.5487568617464034}, {0.6020420732135735, 0., 0.6020420732135735}, {
    0.597947646585002, -0.01993158821950005, 0.5913037838451686}, {
    0.5816501238360723, -0.04523945407613895, 0.5493362280674016}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.5570985386650793, -0.32497414755462956`, 
    0.3713990257767195}, {0.5567535802997043, -0.30930754461094684`, 
    0.3835413553175741}, {0.5740389519912366, -0.35717979235010267`, 
    0.39544905581618517`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5570985386650793, -0.32497414755462956`, 
    0.3713990257767195}, {0.5355123085516112, -0.26775615427580557`, 
    0.35700820570107417`}, {0.540269926225943, -0.26413196393268323`, 
    0.37218594917787184`}, {0.5567535802997043, -0.30930754461094684`, 
    0.3835413553175741}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5355123085516112, -0.26775615427580557`, 
    0.35700820570107417`}, {0.5153506733137513, -0.21472944721406304`, 
    0.34356711554250086`}, {0.5247789208209833, -0.22157332212441513`, 
    0.3615143676766774}, {0.540269926225943, -0.26413196393268323`, 
    0.37218594917787184`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5153506733137513, -0.21472944721406304`, 
    0.34356711554250086`}, {0.4971955577882874, -0.1657318525960958, 
    0.3314637051921916}, {0.510556692772321, -0.18153126854126964`, 
    0.35171683279870997`}, {0.5247789208209833, -0.22157332212441513`, 
    0.3615143676766774}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4971955577882874, -0.1657318525960958, 
    0.3314637051921916}, {0.530207257345758, -0.176735752448586, 
    0.39765544300931854`}, {0.5362250673964656, -0.1906578017409655, 
    0.4051478286995518}, {0.510556692772321, -0.18153126854126964`, 
    0.35171683279870997`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.530207257345758, -0.176735752448586, 
    0.39765544300931854`}, {0.5617994480029483, -0.18726648266764945`, 
    0.4681662066691236}, {0.5611088996560508, -0.19950538654437358`, 
    0.461356206383864}, {0.5362250673964656, -0.1906578017409655, 
    0.4051478286995518}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5617994480029483, -0.18726648266764945`, 
    0.4681662066691236}, {0.5924835974670974, -0.19749453248903248`, 
    0.5431099643448393}, {0.5854544855134971, -0.20816159484924335`, 
    0.5204039871231084}, {0.5611088996560508, -0.19950538654437358`, 
    0.461356206383864}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5924835974670974, -0.19749453248903248`, 
    0.5431099643448393}, {0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.6096319582097897, -0.21675802958570295`, 
    0.5825372045115768}, {0.5854544855134971, -0.20816159484924335`, 
    0.5204039871231084}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.6047269112198952, -0.251969546341623, 
    0.5543330019515705}, {0.5958580455279544, -0.2515845081118029, 
    0.5296515960248482}, {0.6096319582097897, -0.21675802958570295`, 
    0.5825372045115768}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6047269112198952, -0.251969546341623, 
    0.5543330019515705}, {0.5910954623679224, -0.29554773118396116`, 
    0.4925795519732687}, {0.585151974032458, -0.2860742984158683, 
    0.4811249564266876}, {0.5958580455279544, -0.2515845081118029, 
    0.5296515960248482}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, -0.29554773118396116`, 
    0.4925795519732687}, {0.5826314122526858, -0.3398683238140667, 
    0.43697355918951436`}, {0.5777936049257504, -0.32099644718097237`, 
    0.4365551681661225}, {0.585151974032458, -0.2860742984158683, 
    0.4811249564266876}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5826314122526858, -0.3398683238140667, 
    0.43697355918951436`}, {0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.5740389519912366, -0.35717979235010267`, 
    0.39544905581618517`}, {0.5777936049257504, -0.32099644718097237`, 
    0.4365551681661225}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.5810366771432506, -0.3550779693653198, 
    0.41963760015901436`}, {0.5877135047513313, -0.3591582529035913, 
    0.4375200535371022}, {0.5861088600394483, -0.38422691935919384`, 
    0.41027620202761383`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432506, -0.3550779693653198, 
    0.41963760015901436`}, {0.5848491491162138, -0.32491619395345206`, 
    0.45488267153483286`}, {0.5908975428290927, -0.33484194093648584`, 
    0.46615250600961755`}, {0.5877135047513313, -0.3591582529035913, 
    0.4375200535371022}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5848491491162138, -0.32491619395345206`, 
    0.45488267153483286`}, {0.5910954623679224, -0.2955477311839612, 
    0.4925795519732687}, {0.595614232557123, -0.31104298811316416`, 
    0.49634519379760245`}, {0.5908975428290927, -0.33484194093648584`, 
    0.46615250600961755`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, -0.2955477311839612, 
    0.4925795519732687}, {0.6207813146283735, -0.34487850812687415`, 
    0.5518056130029987}, {0.6194466649498231, -0.3510197768048997, 
    0.5437365170115114}, {0.595614232557123, -0.31104298811316416`, 
    0.49634519379760245`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6207813146283735, -0.34487850812687415`, 
    0.5518056130029987}, {0.6513209538944295, -0.39802947182437354`, 
    0.6151364564558499}, {0.643767236897451, -0.3934133114373311, 
    0.593696451805427}, {0.6194466649498231, -0.3510197768048997, 
    0.5437365170115114}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6513209538944295, -0.39802947182437354`, 
    0.6151364564558499}, {0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.6694402964869484, -0.43885530547477725`, 
    0.6471256199373834}, {0.643767236897451, -0.3934133114373311, 
    0.593696451805427}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.6457005460543618, -0.4304670307029078, 
    0.5739560409372104}, {0.639447521013253, -0.41919337488646585`, 
    0.5612928240005222}, {0.6694402964869484, -0.43885530547477725`, 
    0.6471256199373834}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6457005460543618, -0.4304670307029078, 
    0.5739560409372104}, {0.6115080659765835, -0.40767204398438894`, 
    0.4756173846484537}, {0.6120226278718142, -0.4012148338270782, 
    0.4828178508766534}, {0.639447521013253, -0.41919337488646585`, 
    0.5612928240005222}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, -0.40767204398438894`, 
    0.4756173846484537}, {0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {0.5861088600394483, -0.38422691935919384`, 
    0.41027620202761383`}, {0.6120226278718142, -0.4012148338270782, 
    0.4828178508766534}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.6592097133507697, -0.3662276185282054, 
    0.6592097133507697}, {0.6529409809315125, -0.35549008961826795`, 
    0.6456860811433847}, {0.6721945826966649, -0.4257232357078877, 
    0.6647257540000353}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6592097133507697, -0.3662276185282054, 
    0.6592097133507697}, {0.6389520625760421, -0.2839786944782409, 
    0.6389520625760421}, {0.6367433213395861, -0.2900719574991448, 
    0.629668395546924}, {0.6529409809315125, -0.35549008961826795`, 
    0.6456860811433847}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6389520625760421, -0.2839786944782409, 
    0.6389520625760421}, {0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.6233044923807646, -0.22854498053961364`, 
    0.6163788869098672}, {0.6367433213395861, -0.2900719574991448, 
    0.629668395546924}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.6103364275727265, -0.23735305516717142`, 
    0.5764288482631306}, {0.6137026828435964, -0.25229999183570073`, 
    0.5796080893522855}, {0.6233044923807646, -0.22854498053961364`, 
    0.6163788869098672}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6103364275727265, -0.23735305516717142`, 
    0.5764288482631306}, {0.5996392451370365, -0.2665063311720162, 
    0.5330126623440324}, {0.605427866219892, -0.2758060279446175, 
    0.5448850795979028}, {0.6137026828435964, -0.25229999183570073`, 
    0.5796080893522855}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5996392451370365, -0.2665063311720162, 
    0.5330126623440324}, {0.5910954623679224, -0.2955477311839612, 
    0.4925795519732687}, {0.5985285392789631, -0.29926426963948155`, 
    0.5120744169386685}, {0.605427866219892, -0.2758060279446175, 
    0.5448850795979028}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, -0.2955477311839612, 
    0.4925795519732687}, {0.6207813146283735, -0.34487850812687415`, 
    0.5518056130029987}, {0.6222047200687002, -0.33875590314851456`, 
    0.5599842480618302}, {0.5985285392789631, -0.29926426963948155`, 
    0.5120744169386685}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6207813146283735, -0.34487850812687415`, 
    0.5518056130029987}, {0.6513209538944295, -0.39802947182437354`, 
    0.6151364564558499}, {0.6464647768296701, -0.3806959241330279, 
    0.6105500670057994}, {0.6222047200687002, -0.33875590314851456`, 
    0.5599842480618302}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6513209538944295, -0.39802947182437354`, 
    0.6151364564558499}, {0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.6721945826966649, -0.4257232357078877, 
    0.6647257540000353}, {0.6464647768296701, -0.3806959241330279, 
    0.6105500670057994}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.5570985386650793, 0.32497414755462956`, 
    0.3713990257767195}, {0.5567535802997043, 0.30930754461094684`, 
    0.3835413553175741}, {0.5740389519912366, 0.35717979235010267`, 
    0.39544905581618517`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5570985386650793, 0.32497414755462956`, 
    0.3713990257767195}, {0.5355123085516112, 0.26775615427580557`, 
    0.35700820570107417`}, {0.540269926225943, 0.26413196393268323`, 
    0.37218594917787184`}, {0.5567535802997043, 0.30930754461094684`, 
    0.3835413553175741}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5355123085516112, 0.26775615427580557`, 
    0.35700820570107417`}, {0.5153506733137513, 0.21472944721406304`, 
    0.34356711554250086`}, {0.5247789208209833, 0.22157332212441513`, 
    0.3615143676766774}, {0.540269926225943, 0.26413196393268323`, 
    0.37218594917787184`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5153506733137513, 0.21472944721406304`, 
    0.34356711554250086`}, {0.4971955577882874, 0.1657318525960958, 
    0.3314637051921916}, {0.510556692772321, 0.18153126854126964`, 
    0.35171683279870997`}, {0.5247789208209833, 0.22157332212441513`, 
    0.3615143676766774}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4971955577882874, 0.1657318525960958, 
    0.3314637051921916}, {0.530207257345758, 0.176735752448586, 
    0.39765544300931854`}, {0.5362250673964656, 0.1906578017409655, 
    0.4051478286995518}, {0.510556692772321, 0.18153126854126964`, 
    0.35171683279870997`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.530207257345758, 0.176735752448586, 
    0.39765544300931854`}, {0.5617994480029483, 0.18726648266764945`, 
    0.4681662066691236}, {0.5611088996560508, 0.19950538654437358`, 
    0.461356206383864}, {0.5362250673964656, 0.1906578017409655, 
    0.4051478286995518}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5617994480029483, 0.18726648266764945`, 
    0.4681662066691236}, {0.5924835974670974, 0.19749453248903248`, 
    0.5431099643448393}, {0.5854544855134971, 0.20816159484924335`, 
    0.5204039871231084}, {0.5611088996560508, 0.19950538654437358`, 
    0.461356206383864}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5924835974670974, 0.19749453248903248`, 
    0.5431099643448393}, {0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.6096319582097897, 0.21675802958570295`, 
    0.5825372045115768}, {0.5854544855134971, 0.20816159484924335`, 
    0.5204039871231084}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.6047269112198952, 0.251969546341623, 
    0.5543330019515705}, {0.5958580455279544, 0.2515845081118029, 
    0.5296515960248482}, {0.6096319582097897, 0.21675802958570295`, 
    0.5825372045115768}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6047269112198952, 0.251969546341623, 
    0.5543330019515705}, {0.5910954623679224, 0.29554773118396116`, 
    0.4925795519732687}, {0.585151974032458, 0.2860742984158683, 
    0.4811249564266876}, {0.5958580455279544, 0.2515845081118029, 
    0.5296515960248482}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, 0.29554773118396116`, 
    0.4925795519732687}, {0.5826314122526858, 0.3398683238140667, 
    0.43697355918951436`}, {0.5777936049257504, 0.32099644718097237`, 
    0.4365551681661225}, {0.585151974032458, 0.2860742984158683, 
    0.4811249564266876}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5826314122526858, 0.3398683238140667, 
    0.43697355918951436`}, {0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.5740389519912366, 0.35717979235010267`, 
    0.39544905581618517`}, {0.5777936049257504, 0.32099644718097237`, 
    0.4365551681661225}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.5810366771432506, 0.3550779693653198, 
    0.41963760015901436`}, {0.5877135047513313, 0.3591582529035913, 
    0.4375200535371022}, {0.5861088600394483, 0.38422691935919384`, 
    0.41027620202761383`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432506, 0.3550779693653198, 
    0.41963760015901436`}, {0.5848491491162138, 0.32491619395345206`, 
    0.45488267153483286`}, {0.5908975428290927, 0.33484194093648584`, 
    0.46615250600961755`}, {0.5877135047513313, 0.3591582529035913, 
    0.4375200535371022}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5848491491162138, 0.32491619395345206`, 
    0.45488267153483286`}, {0.5910954623679224, 0.2955477311839612, 
    0.4925795519732687}, {0.595614232557123, 0.31104298811316416`, 
    0.49634519379760245`}, {0.5908975428290927, 0.33484194093648584`, 
    0.46615250600961755`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, 0.2955477311839612, 
    0.4925795519732687}, {0.6207813146283735, 0.34487850812687415`, 
    0.5518056130029987}, {0.6194466649498231, 0.3510197768048997, 
    0.5437365170115114}, {0.595614232557123, 0.31104298811316416`, 
    0.49634519379760245`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6207813146283735, 0.34487850812687415`, 
    0.5518056130029987}, {0.6513209538944295, 0.39802947182437354`, 
    0.6151364564558499}, {0.643767236897451, 0.3934133114373311, 
    0.593696451805427}, {0.6194466649498231, 0.3510197768048997, 
    0.5437365170115114}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6513209538944295, 0.39802947182437354`, 
    0.6151364564558499}, {0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.6694402964869484, 0.43885530547477725`, 
    0.6471256199373834}, {0.643767236897451, 0.3934133114373311, 
    0.593696451805427}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.6457005460543618, 0.4304670307029078, 
    0.5739560409372104}, {0.639447521013253, 0.41919337488646585`, 
    0.5612928240005222}, {0.6694402964869484, 0.43885530547477725`, 
    0.6471256199373834}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6457005460543618, 0.4304670307029078, 
    0.5739560409372104}, {0.6115080659765835, 0.40767204398438894`, 
    0.4756173846484537}, {0.6120226278718142, 0.4012148338270782, 
    0.4828178508766534}, {0.639447521013253, 0.41919337488646585`, 
    0.5612928240005222}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, 0.40767204398438894`, 
    0.4756173846484537}, {0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.5861088600394483, 0.38422691935919384`, 
    0.41027620202761383`}, {0.6120226278718142, 0.4012148338270782, 
    0.4828178508766534}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.6592097133507697, 0.3662276185282054, 
    0.6592097133507697}, {0.6529409809315125, 0.35549008961826795`, 
    0.6456860811433847}, {0.6721945826966649, 0.4257232357078877, 
    0.6647257540000353}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6592097133507697, 0.3662276185282054, 
    0.6592097133507697}, {0.6389520625760421, 0.2839786944782409, 
    0.6389520625760421}, {0.6367433213395861, 0.2900719574991448, 
    0.629668395546924}, {0.6529409809315125, 0.35549008961826795`, 
    0.6456860811433847}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6389520625760421, 0.2839786944782409, 
    0.6389520625760421}, {0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.6233044923807646, 0.22854498053961364`, 
    0.6163788869098672}, {0.6367433213395861, 0.2900719574991448, 
    0.629668395546924}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.6103364275727265, 0.23735305516717142`, 
    0.5764288482631306}, {0.6137026828435964, 0.25229999183570073`, 
    0.5796080893522855}, {0.6233044923807646, 0.22854498053961364`, 
    0.6163788869098672}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6103364275727265, 0.23735305516717142`, 
    0.5764288482631306}, {0.5996392451370365, 0.2665063311720162, 
    0.5330126623440324}, {0.605427866219892, 0.2758060279446175, 
    0.5448850795979028}, {0.6137026828435964, 0.25229999183570073`, 
    0.5796080893522855}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5996392451370365, 0.2665063311720162, 
    0.5330126623440324}, {0.5910954623679224, 0.2955477311839612, 
    0.4925795519732687}, {0.5985285392789631, 0.29926426963948155`, 
    0.5120744169386685}, {0.605427866219892, 0.2758060279446175, 
    0.5448850795979028}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5910954623679224, 0.2955477311839612, 
    0.4925795519732687}, {0.6207813146283735, 0.34487850812687415`, 
    0.5518056130029987}, {0.6222047200687002, 0.33875590314851456`, 
    0.5599842480618302}, {0.5985285392789631, 0.29926426963948155`, 
    0.5120744169386685}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6207813146283735, 0.34487850812687415`, 
    0.5518056130029987}, {0.6513209538944295, 0.39802947182437354`, 
    0.6151364564558499}, {0.6464647768296701, 0.3806959241330279, 
    0.6105500670057994}, {0.6222047200687002, 0.33875590314851456`, 
    0.5599842480618302}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6513209538944295, 0.39802947182437354`, 
    0.6151364564558499}, {0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.6721945826966649, 0.4257232357078877, 
    0.6647257540000353}, {0.6464647768296701, 0.3806959241330279, 
    0.6105500670057994}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., 0.3066580952458096}, {
    0.46253818353867265`, 0.038544848628222717`, 0.30835878902578173`}, {
    0.47507741354102534`, 0.052786379282336135`, 0.3272755515504841}, {
    0.47150167762968676`, 0.020955630116874954`, 0.324812266811562}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.46253818353867265`, 0.038544848628222717`, 
    0.30835878902578173`}, {0.46999171897491077`, 0.07833195316248512, 
    0.3133278126499405}, {0.48154514744522636`, 0.08560802621248467, 
    0.33173110157337815`}, {0.47507741354102534`, 0.052786379282336135`, 
    0.3272755515504841}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.46999171897491077`, 0.07833195316248512, 
    0.3133278126499405}, {0.4817997617497233, 0.12044994043743079`, 
    0.32119984116648215`}, {0.4906212440644457, 0.11992963743797559`, 
    0.3379835236888404}, {0.48154514744522636`, 0.08560802621248467, 
    0.33173110157337815`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4817997617497233, 0.12044994043743079`, 
    0.32119984116648215`}, {0.4971955577882874, 0.1657318525960958, 
    0.3314637051921916}, {0.5019472405700409, 0.1561613637329016, 
    0.3457858768371393}, {0.4906212440644457, 0.11992963743797559`, 
    0.3379835236888404}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4971955577882874, 0.1657318525960958, 
    0.3314637051921916}, {0.530207257345758, 0.176735752448586, 
    0.39765544300931854`}, {0.5286651530527192, 0.16447360317195706`, 
    0.3994358934176101}, {0.5019472405700409, 0.1561613637329016, 
    0.3457858768371393}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.530207257345758, 0.176735752448586, 
    0.39765544300931854`}, {0.5617994480029483, 0.18726648266764945`, 
    0.4681662066691236}, {0.5543741420185859, 0.17247195529467113`, 
    0.4558187389930595}, {0.5286651530527192, 0.16447360317195706`, 
    0.3994358934176101}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5617994480029483, 0.18726648266764945`, 
    0.4681662066691236}, {0.5924835974670974, 0.19749453248903248`, 
    0.5431099643448393}, {0.5793426974047388, 0.18023995030369647`, 
    0.5149712865819899}, {0.5543741420185859, 0.17247195529467113`, 
    0.4558187389930595}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5924835974670974, 0.19749453248903248`, 
    0.5431099643448393}, {0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.6039532192067091, 0.18789655708653166`, 
    0.577110853908633}, {0.5793426974047388, 0.18023995030369647`, 
    0.5149712865819899}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.5826314122526858, 0.14565785306317142`, 
    0.5340787945649619}, {0.571505684936255, 0.13970138965108453`, 
    0.508005053276671}, {0.6039532192067091, 0.18789655708653166`, 
    0.577110853908633}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5826314122526858, 0.14565785306317142`, 
    0.5340787945649619}, {0.5423842382927654, 0.09039737304879422, 
    0.4519868652439711}, {0.5388079575040883, 0.09578808133406011, 
    0.4430198761700281}, {0.571505684936255, 0.13970138965108453`, 
    0.508005053276671}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5423842382927654, 0.09039737304879422, 
    0.4519868652439711}, {0.5013779790164213, 0.041781498251368454`, 
    0.37603348426231603`}, {0.5054364950419619, 0.05615961056021798, 
    0.38188535180948235`}, {0.5388079575040883, 0.09578808133406011, 
    0.4430198761700281}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5013779790164213, 0.041781498251368454`, 
    0.37603348426231603`}, {0.45998714286871445`, 0., 0.3066580952458096}, {
    0.47150167762968676`, 0.020955630116874954`, 0.324812266811562}, {
    0.5054364950419619, 0.05615961056021798, 0.38188535180948235`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45998714286871445`, 0., 0.3066580952458096}, {
    0.4875643330433564, 0.02708690739129757, 0.3521297960868685}, {
    0.4977209701662121, 0.027651165009234, 0.37052561112373567`}, {
    0.47617071567397445`, 0.005290785729710824, 0.33331950097178215`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4875643330433564, 0.02708690739129757, 
    0.3521297960868685}, {0.5151364245658201, 0.057237380507313335`, 
    0.4006616635511933}, {0.5192776126127516, 0.05192776126127516, 
    0.4096523388389484}, {0.4977209701662121, 0.027651165009234, 
    0.37052561112373567`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5151364245658201, 0.057237380507313335`, 
    0.4006616635511933}, {0.5423842382927654, 0.09039737304879422, 
    0.4519868652439711}, {0.5406944571684102, 0.07810031047988147, 
    0.45057871430700847`}, {0.5192776126127516, 0.05192776126127516, 
    0.4096523388389484}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5423842382927654, 0.09039737304879422, 
    0.4519868652439711}, {0.5611088996560509, 0.06234543329511677, 
    0.49876346636093416`}, {0.5561327685019032, 0.055613276850190324`, 
    0.48816098568500393`}, {0.5406944571684102, 0.07810031047988147, 
    0.45057871430700847`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5611088996560509, 0.06234543329511677, 
    0.49876346636093416`}, {0.5810366771432506, 0.03227981539684726, 
    0.5487568617464034}, {0.5723000016162385, 0.03179444453423547, 
    0.5277877792683088}, {0.5561327685019032, 0.055613276850190324`, 
    0.48816098568500393`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432506, 0.03227981539684726, 
    0.5487568617464034}, {0.6020420732135735, 0., 0.6020420732135735}, {
    0.5891105858887445, 0.006545673176541602, 0.5694735663591197}, {
    0.5723000016162385, 0.03179444453423547, 0.5277877792683088}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, 0., 0.6020420732135735}, {
    0.5583263670978953, 0., 0.49629010408701807`}, {0.5538610316580012, 
    0.006154011462866676, 0.4861669055664677}, {0.5891105858887445, 
    0.006545673176541602, 0.5694735663591197}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5583263670978953, 0., 0.49629010408701807`}, {
    0.5116766815928779, 0., 0.3979707523500161}, {0.5165717745530933, 
    0.005739686383923255, 0.40751773325855134`}, {0.5538610316580012, 
    0.006154011462866676, 0.4861669055664677}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.5116766815928779, 0., 0.3979707523500161}, {
    0.45998714286871445`, 0., 0.3066580952458096}, {0.47617071567397445`, 
    0.005290785729710824, 0.33331950097178215`}, {0.5165717745530933, 
    0.005739686383923255, 0.40751773325855134`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, 0., 0.6020420732135735}, {
    0.6044295191828238, 0.06715883546475819, 0.6044295191828238}, {
    0.6006503620708005, 0.0734128220308756, 0.5939764691589027}, {
    0.597947646585002, 0.01993158821950005, 0.5913037838451686}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6044295191828238, 0.06715883546475819, 
    0.6044295191828238}, {0.6115080659765835, 0.13589068132812965`, 
    0.6115080659765835}, {0.6063763483828833, 0.12801278465860869`, 
    0.5996388334008513}, {0.6006503620708005, 0.0734128220308756, 
    0.5939764691589027}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, 0.13589068132812965`, 
    0.6115080659765835}, {0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.615005336599669, 0.1845016009799007, 
    0.6081719439707838}, {0.6063763483828833, 0.12801278465860869`, 
    0.5996388334008513}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.5960042485425239, 0.16555673570625662`, 
    0.5628929014012725}, {0.5936572660606888, 0.15171241243773156`, 
    0.560676306835095}, {0.615005336599669, 0.1845016009799007, 
    0.6081719439707838}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5960042485425239, 0.16555673570625662`, 
    0.5628929014012725}, {0.5692683486017988, 0.12650407746706638`, 
    0.5060163098682655}, {0.572511405971636, 0.12086351903845649`, 
    0.5152602653744724}, {0.5936572660606888, 0.15171241243773156`, 
    0.560676306835095}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5692683486017988, 0.12650407746706638`, 
    0.5060163098682655}, {0.5423842382927654, 0.09039737304879422, 
    0.4519868652439711}, {0.5513356533463394, 0.09188927555772322, 
    0.4716982811963126}, {0.572511405971636, 0.12086351903845649`, 
    0.5152602653744724}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5423842382927654, 0.09039737304879422, 
    0.4519868652439711}, {0.5611088996560509, 0.06234543329511677, 
    0.49876346636093416`}, {0.5660913502754553, 0.06918894281144454, 
    0.5094822152479098}, {0.5513356533463394, 0.09188927555772322, 
    0.4716982811963126}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5611088996560509, 0.06234543329511677, 
    0.49876346636093416`}, {0.5810366771432506, 0.03227981539684726, 
    0.5487568617464034}, {0.5816501238360723, 0.04523945407613895, 
    0.5493362280674016}, {0.5660913502754553, 0.06918894281144454, 
    0.5094822152479098}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5810366771432506, 0.03227981539684726, 
    0.5487568617464034}, {0.6020420732135735, 0., 0.6020420732135735}, {
    0.597947646585002, 0.01993158821950005, 0.5913037838451686}, {
    0.5816501238360723, 0.04523945407613895, 0.5493362280674016}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.6115080659765835, 0.40767204398438894`, 
    0.4756173846484537}, {0.6176006003263583, 0.4185959624434206, 
    0.48721825136857155`}, {0.5920832028449382, 0.4013008374837915, 
    0.41445824199145676`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, 0.40767204398438894`, 
    0.4756173846484537}, {0.6457005460543618, 0.4304670307029078, 
    0.5739560409372104}, {0.6448463554356526, 0.43706252979527566`, 
    0.5660318008824062}, {0.6176006003263583, 0.4185959624434206, 
    0.48721825136857155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6457005460543618, 0.4304670307029078, 
    0.5739560409372104}, {0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.6749630549963996, 0.4574749594975597, 
    0.6524642864965196}, {0.6448463554356526, 0.43706252979527566`, 
    0.5660318008824062}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.6786794799954298, 0.49015740221892146`, 
    0.6409750644401281}, {0.670907588604451, 0.484544369547659, 
    0.6187258872685492}, {0.6749630549963996, 0.4574749594975597, 
    0.6524642864965196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6786794799954298, 0.49015740221892146`, 
    0.6409750644401281}, {0.6751944561946608, 0.5251512437069583, 
    0.6001728499508097}, {0.6683421713383466, 0.5123956646927323, 
    0.5866559059525488}, {0.670907588604451, 0.484544369547659, 
    0.6187258872685492}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6751944561946608, 0.5251512437069583, 
    0.6001728499508097}, {0.6740385471308696, 0.5616987892757247, 
    0.5616987892757247}, {0.6672459372836057, 0.5412105935744802, 
    0.5560382810696715}, {0.6683421713383466, 0.5123956646927323, 
    0.5866559059525488}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6740385471308696, 0.5616987892757247, 
    0.5616987892757247}, {0.6412032180604118, 0.49871361404698694`, 
    0.49871361404698694`}, {0.641248218995467, 0.4916236345631913, 
    0.5058735949853128}, {0.6672459372836057, 0.5412105935744802, 
    0.5560382810696715}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6412032180604118, 0.49871361404698694`, 
    0.49871361404698694`}, {0.6103364275727268, 0.4407985310247471, 
    0.4407985310247471}, {0.6164899353312527, 0.4452427310725714, 
    0.4589425074132659}, {0.641248218995467, 0.4916236345631913, 
    0.5058735949853128}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6103364275727268, 0.4407985310247471, 
    0.4407985310247471}, {0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {0.5920832028449382, 0.4013008374837915, 
    0.41445824199145676`}, {0.6164899353312527, 0.4452427310725714, 
    0.4589425074132659}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.6786794799954298, 0.49015740221892146`, 
    0.6409750644401281}, {0.6848853908126196, 0.5098591242716168, 
    0.6468362024341406}, {0.6890827403984794, 0.48235791827893554`, 
    0.6814262655051629}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6786794799954298, 0.49015740221892146`, 
    0.6409750644401281}, {0.6751944561946608, 0.5251512437069583, 
    0.6001728499508097}, {0.68224035411735, 0.5382118349147983, 
    0.614016318705615}, {0.6848853908126196, 0.5098591242716168, 
    0.6468362024341406}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6751944561946608, 0.5251512437069583, 
    0.6001728499508097}, {0.6740385471308696, 0.5616987892757247, 
    0.5616987892757247}, {0.6811124367744867, 0.5675936973120723, 
    0.5827295292403942}, {0.68224035411735, 0.5382118349147983, 
    0.614016318705615}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6740385471308696, 0.5616987892757247, 
    0.5616987892757247}, {0.7118600880536767, 0.6327645227143793, 
    0.6327645227143793}, {0.7119126797168901, 0.6249011299737146, 
    0.6407214117452011}, {0.6811124367744867, 0.5675936973120723, 
    0.5827295292403942}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7118600880536767, 0.6327645227143793, 
    0.6327645227143793}, {0.7622103197175837, 0.7198653019554957, 
    0.7198653019554957}, {0.7504115684601292, 0.6920462242465636, 
    0.7087220368790109}, {0.7119126797168901, 0.6249011299737146, 
    0.6407214117452011}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7622103197175837, 0.7198653019554957, 
    0.7198653019554957}, {0.9068996821171088, 0.9068996821171088, 
    0.9068996821171088}, {0.8104554067121754, 0.7834402264884363, 
    0.8014503466375957}, {0.7504115684601292, 0.6920462242465636, 
    0.7087220368790109}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.9068996821171088, 0.9068996821171088, 
    0.9068996821171088}, {0.7640699024805022, 0.6791732466493353, 
    0.7640699024805022}, {0.7520300306261339, 0.6601152491051621, 
    0.7436741413969546}, {0.8104554067121754, 0.7834402264884363, 
    0.8014503466375957}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7640699024805022, 0.6791732466493353, 
    0.7640699024805022}, {0.7171888530767329, 0.5578135523930144, 
    0.7171888530767329}, {0.716165180138544, 0.5649747532204069, 
    0.7082077892481158}, {0.7520300306261339, 0.6601152491051621, 
    0.7436741413969546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7171888530767329, 0.5578135523930144, 
    0.7171888530767329}, {0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.6890827403984794, 0.48235791827893554`, 
    0.6814262655051629}, {0.716165180138544, 0.5649747532204069, 
    0.7082077892481158}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {0.005171109167864868, 
    0.005171109167864868, 0.07756663751797302}, {0.013921129715104607`, 
    0.008765155746547347, 0.11600941429253843`}, {0.0038620463024166113`, 
    0.0012873487674722039`, 0.05793069453624921}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.005171109167864868, 0.005171109167864868, 
    0.07756663751797302}, {0.020411420737374928`, 0.020411420737374928`, 
    0.15308565553031198`}, {0.030232164988298796`, 0.022480327811811928`, 
    0.1744163364709546}, {0.013921129715104607`, 0.008765155746547347, 
    0.11600941429253843`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.020411420737374928`, 0.020411420737374928`, 
    0.15308565553031198`}, {0.04495902221896904, 0.04495902221896904, 
    0.22479511109484523`}, {0.052280949450900525`, 0.04202978289190042, 
    0.23065124757750236`}, {0.030232164988298796`, 0.022480327811811928`, 
    0.1744163364709546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.04495902221896904, 0.04495902221896904, 
    0.22479511109484523`}, {0.07771364461602205, 0.07771364461602205, 
    0.2914261673100827}, {0.07946169892532537, 0.0668487308419404, 
    0.2837917818761621}, {0.052280949450900525`, 0.04202978289190042, 
    0.23065124757750236`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07771364461602205, 0.07771364461602205, 
    0.2914261673100827}, {0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {0.11112456154944483`, 0.09630795334285219, 
    0.3333736846483345}, {0.07946169892532537, 0.0668487308419404, 
    0.2837917818761621}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {0.14319799741026004`, 0.09546533160684004, 
    0.3579949935256501}, {0.131748866608086, 0.08026080379573056, 
    0.3407298274347052}, {0.11112456154944483`, 0.09630795334285219, 
    0.3333736846483345}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.14319799741026004`, 0.09546533160684004, 
    0.3579949935256501}, {0.1746044040148139, 0.07483045886349166, 
    0.37415229431745833`}, {0.1563113379070913, 0.06473499852717923, 
    0.35525304069793484`}, {0.131748866608086, 0.08026080379573056, 
    0.3407298274347052}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1746044040148139, 0.07483045886349166, 
    0.37415229431745833`}, {0.21246554927450964`, 0.05311638731862741, 
    0.3983729048897056}, {0.18521381542885962`, 0.04838919502195432, 
    0.3754334096530939}, {0.1563113379070913, 0.06473499852717923, 
    0.35525304069793484`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21246554927450964`, 0.05311638731862741, 
    0.3983729048897056}, {0.2566895622918732, 0.028521062476874796`, 
    0.42781593715312194`}, {0.21842728074316375`, 0.030189136362876293`, 
    0.39956209892042155`}, {0.18521381542885962`, 0.04838919502195432, 
    0.3754334096530939}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2566895622918732, 0.028521062476874796`, 
    0.42781593715312194`}, {0.3066580952458096, 0., 0.45998714286871445`}, {
    0.2556458063906103, 0.009468363199652228, 0.4260763439843505}, {
    0.21842728074316375`, 0.030189136362876293`, 0.39956209892042155`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, 0., 0.45998714286871445`}, {
    0.20749339485230253`, 0., 0.38905011534806727`}, {0.18050915270650167`, 
    0.008131042914707278, 0.36589693116182775`}, {0.2556458063906103, 
    0.009468363199652228, 0.4260763439843505}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.20749339485230253`, 0., 0.38905011534806727`}, {
    0.1226952100911925, 0., 0.30673802522798127`}, {0.11533618865511652`, 
    0.006628516589374509, 0.2982832465218531}, {0.18050915270650167`, 
    0.008131042914707278, 0.36589693116182775`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1226952100911925, 0., 0.30673802522798127`}, {
    0.05675323239297665, 0., 0.21282462147366246`}, {0.06253826722971649, 
    0.004963354542040988, 0.22335095439184463`}, {0.11533618865511652`, 
    0.006628516589374509, 0.2982832465218531}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.05675323239297665, 0., 0.21282462147366246`}, {
    0.014560811715990765`, 0., 0.10920608786993075`}, {0.0246522971021567, 
    0.003160550910532909, 0.142224790973981}, {0.06253826722971649, 
    0.004963354542040988, 0.22335095439184463`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.014560811715990765`, 0., 0.10920608786993075`}, {
    0., 0., 0.}, {0.0038620463024166113`, 0.0012873487674722039`, 
    0.05793069453624921}, {0.0246522971021567, 0.003160550910532909, 
    0.142224790973981}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, 0., 0.45998714286871445`}, {
    0.31096701746038047`, 0.06219340349207609, 0.46645052619057076`}, {
    0.29665252977081547`, 0.07978930111077105, 0.46032289102367924`}, {
    0.29040472453203425`, 0.03004186805503801, 0.45062802082557046`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.31096701746038047`, 0.06219340349207609, 
    0.46645052619057076`}, {0.3230789997575147, 0.12923159990300587`, 
    0.48461849963627207`}, {0.30764777640897106`, 0.13366765457769086`, 
    0.4773844806346103}, {0.29665252977081547`, 0.07978930111077105, 
    0.46032289102367924`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3230789997575147, 0.12923159990300587`, 
    0.48461849963627207`}, {0.3410246861288609, 0.20461481167731652`, 
    0.5115370291932914}, {0.32221918972665153`, 0.19333151383599093`, 
    0.4999952944034249}, {0.30764777640897106`, 0.13366765457769086`, 
    0.4773844806346103}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3410246861288609, 0.20461481167731652`, 
    0.5115370291932914}, {0.36266749034792994`, 0.29013399227834397`, 
    0.5440012355218949}, {0.3391849732407725, 0.25965194503259137`, 
    0.5263215102011988}, {0.32221918972665153`, 0.19333151383599093`, 
    0.4999952944034249}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.36266749034792994`, 0.29013399227834397`, 
    0.5440012355218949}, {0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.3576298790583277, 0.3329657494680982, 
    0.5549429157801637}, {0.3391849732407725, 0.25965194503259137`, 
    0.5263215102011988}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.3251055239962821, 0.3251055239962821, 
    0.5418425399938036}, {0.30948310838038806`, 0.2862137017352461, 
    0.5235616495156941}, {0.3576298790583277, 0.3329657494680982, 
    0.5549429157801637}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3251055239962821, 0.3251055239962821, 
    0.5418425399938036}, {0.2673132787288768, 0.2673132787288768, 
    0.501212397616644}, {0.2635503764484113, 0.24176935360143517`, 
    0.49007301405696324`}, {0.30948310838038806`, 0.2862137017352461, 
    0.5235616495156941}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2673132787288768, 0.2673132787288768, 
    0.501212397616644}, {0.21311308081691155`, 0.21311308081691155`, 
    0.4566708874648105}, {0.2198966482103745, 0.19972264378740437`, 
    0.4539150995168281}, {0.2635503764484113, 0.24176935360143517`, 
    0.49007301405696324`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21311308081691155`, 0.21311308081691155`, 
    0.4566708874648105}, {0.1629042820200325, 0.1629042820200325, 
    0.4072607050500812}, {0.1787484353953863, 0.1603207616432846, 
    0.4146226594222878}, {0.2198966482103745, 0.19972264378740437`, 
    0.4539150995168281}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1629042820200325, 0.1629042820200325, 
    0.4072607050500812}, {0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {0.1404740306623331, 0.12394767411382335`, 
    0.37184302234147004`}, {0.1787484353953863, 0.1603207616432846, 
    0.4146226594222878}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {0.14319799741026004`, 0.09546533160684004, 
    0.3579949935256501}, {0.16290833179688105`, 0.10580644230106709`, 
    0.37788015107523965`}, {0.1404740306623331, 0.12394767411382335`, 
    0.37184302234147004`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.14319799741026004`, 0.09546533160684004, 
    0.3579949935256501}, {0.1746044040148139, 0.07483045886349166, 
    0.37415229431745833`}, {0.18889392224764073`, 0.08838155995073098, 
    0.38991864684146027`}, {0.16290833179688105`, 0.10580644230106709`, 
    0.37788015107523965`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1746044040148139, 0.07483045886349166, 
    0.37415229431745833`}, {0.21246554927450964`, 0.05311638731862741, 
    0.3983729048897056}, {0.2188183987589316, 0.07052824422808539, 
    0.40689371670049274`}, {0.18889392224764073`, 0.08838155995073098, 
    0.38991864684146027`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21246554927450964`, 0.05311638731862741, 
    0.3983729048897056}, {0.2566895622918732, 0.028521062476874796`, 
    0.42781593715312194`}, {0.2527228599908341, 0.05130464075001894, 
    0.4275386729168246}, {0.2188183987589316, 0.07052824422808539, 
    0.40689371670049274`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2566895622918732, 0.028521062476874796`, 
    0.42781593715312194`}, {0.3066580952458096, 0., 0.45998714286871445`}, {
    0.29040472453203425`, 0.03004186805503801, 0.45062802082557046`}, {
    0.2527228599908341, 0.05130464075001894, 0.4275386729168246}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {0.014560811715990765`, 0., 
    0.10920608786993075`}, {0.0246522971021567, -0.003160550910532909, 
    0.142224790973981}, {0.0038620463024166113`, -0.0012873487674722039`, 
    0.05793069453624921}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.014560811715990765`, 0., 0.10920608786993075`}, {
    0.05675323239297665, 0., 0.21282462147366246`}, {
    0.06253826722971648, -0.004963354542040988, 0.22335095439184463`}, {
    0.0246522971021567, -0.003160550910532909, 0.142224790973981}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.05675323239297665, 0., 0.21282462147366246`}, {
    0.1226952100911925, 0., 0.30673802522798127`}, {
    0.11533618865511652`, -0.006628516589374509, 0.2982832465218531}, {
    0.06253826722971648, -0.004963354542040988, 0.22335095439184463`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1226952100911925, 0., 0.30673802522798127`}, {
    0.20749339485230253`, 0., 0.38905011534806727`}, {
    0.18050915270650167`, -0.008131042914707278, 0.36589693116182775`}, {
    0.11533618865511652`, -0.006628516589374509, 0.2982832465218531}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20749339485230253`, 0., 0.38905011534806727`}, {
    0.3066580952458096, 0., 0.45998714286871445`}, {
    0.2556458063906103, -0.009468363199652228, 0.4260763439843505}, {
    0.18050915270650167`, -0.008131042914707278, 0.36589693116182775`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, 0., 0.45998714286871445`}, {
    0.2566895622918732, -0.028521062476874796`, 0.42781593715312194`}, {
    0.21842728074316375`, -0.030189136362876293`, 0.39956209892042155`}, {
    0.2556458063906103, -0.009468363199652228, 0.4260763439843505}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2566895622918732, -0.028521062476874796`, 
    0.42781593715312194`}, {0.21246554927450964`, -0.05311638731862741, 
    0.3983729048897056}, {0.18521381542885962`, -0.04838919502195432, 
    0.3754334096530939}, {0.21842728074316375`, -0.030189136362876293`, 
    0.39956209892042155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21246554927450964`, -0.05311638731862741, 
    0.3983729048897056}, {0.1746044040148139, -0.07483045886349166, 
    0.37415229431745833`}, {0.1563113379070913, -0.06473499852717923, 
    0.35525304069793484`}, {0.18521381542885962`, -0.04838919502195432, 
    0.3754334096530939}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1746044040148139, -0.07483045886349166, 
    0.37415229431745833`}, {0.14319799741026004`, -0.09546533160684004, 
    0.3579949935256501}, {0.131748866608086, -0.08026080379573056, 
    0.3407298274347052}, {0.1563113379070913, -0.06473499852717923, 
    0.35525304069793484`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.14319799741026004`, -0.09546533160684004, 
    0.3579949935256501}, {0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {0.11112456154944483`, -0.09630795334285219, 
    0.3333736846483345}, {0.131748866608086, -0.08026080379573056, 
    0.3407298274347052}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {0.07771364461602205, -0.07771364461602205, 
    0.2914261673100827}, {0.07946169892532537, -0.0668487308419404, 
    0.2837917818761621}, {0.11112456154944483`, -0.09630795334285219, 
    0.3333736846483345}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07771364461602205, -0.07771364461602205, 
    0.2914261673100827}, {0.04495902221896904, -0.04495902221896904, 
    0.22479511109484523`}, {0.052280949450900525`, -0.04202978289190042, 
    0.23065124757750236`}, {0.07946169892532537, -0.0668487308419404, 
    0.2837917818761621}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.04495902221896904, -0.04495902221896904, 
    0.22479511109484523`}, {0.020411420737374928`, -0.020411420737374928`, 
    0.15308565553031198`}, {0.030232164988298796`, -0.022480327811811928`, 
    0.1744163364709546}, {0.052280949450900525`, -0.04202978289190042, 
    0.23065124757750236`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.020411420737374928`, -0.020411420737374928`, 
    0.15308565553031198`}, {0.005171109167864868, -0.005171109167864868, 
    0.07756663751797302}, {0.013921129715104607`, -0.008765155746547347, 
    0.11600941429253843`}, {0.030232164988298796`, -0.022480327811811928`, 
    0.1744163364709546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.005171109167864868, -0.005171109167864868, 
    0.07756663751797302}, {0., 0., 0.}, {
    0.0038620463024166113`, -0.0012873487674722039`, 0.05793069453624921}, {
    0.013921129715104607`, -0.008765155746547347, 0.11600941429253843`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, 0., 0.45998714286871445`}, {
    0.2566895622918732, -0.028521062476874796`, 0.42781593715312194`}, {
    0.2527228599908341, -0.05130464075001894, 0.4275386729168246}, {
    0.29040472453203425`, -0.03004186805503801, 0.45062802082557046`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2566895622918732, -0.028521062476874796`, 
    0.42781593715312194`}, {0.21246554927450964`, -0.05311638731862741, 
    0.3983729048897056}, {0.2188183987589316, -0.07052824422808539, 
    0.40689371670049274`}, {0.2527228599908341, -0.05130464075001894, 
    0.4275386729168246}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21246554927450964`, -0.05311638731862741, 
    0.3983729048897056}, {0.1746044040148139, -0.07483045886349166, 
    0.37415229431745833`}, {0.18889392224764073`, -0.08838155995073098, 
    0.38991864684146027`}, {0.2188183987589316, -0.07052824422808539, 
    0.40689371670049274`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1746044040148139, -0.07483045886349166, 
    0.37415229431745833`}, {0.14319799741026004`, -0.09546533160684004, 
    0.3579949935256501}, {0.16290833179688105`, -0.10580644230106709`, 
    0.37788015107523965`}, {0.18889392224764073`, -0.08838155995073098, 
    0.38991864684146027`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.14319799741026004`, -0.09546533160684004, 
    0.3579949935256501}, {0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {0.1404740306623331, -0.12394767411382335`, 
    0.37184302234147004`}, {0.16290833179688105`, -0.10580644230106709`, 
    0.37788015107523965`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {0.1629042820200325, -0.1629042820200325, 
    0.4072607050500812}, {0.1787484353953863, -0.1603207616432846, 
    0.4146226594222878}, {0.1404740306623331, -0.12394767411382335`, 
    0.37184302234147004`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1629042820200325, -0.1629042820200325, 
    0.4072607050500812}, {0.21311308081691155`, -0.21311308081691155`, 
    0.4566708874648105}, {0.2198966482103745, -0.19972264378740437`, 
    0.4539150995168281}, {0.1787484353953863, -0.1603207616432846, 
    0.4146226594222878}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21311308081691155`, -0.21311308081691155`, 
    0.4566708874648105}, {0.2673132787288768, -0.2673132787288768, 
    0.501212397616644}, {0.2635503764484113, -0.24176935360143517`, 
    0.49007301405696324`}, {0.2198966482103745, -0.19972264378740437`, 
    0.4539150995168281}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2673132787288768, -0.2673132787288768, 
    0.501212397616644}, {0.3251055239962821, -0.3251055239962821, 
    0.5418425399938036}, {0.30948310838038806`, -0.2862137017352461, 
    0.5235616495156941}, {0.2635503764484113, -0.24176935360143517`, 
    0.49007301405696324`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3251055239962821, -0.3251055239962821, 
    0.5418425399938036}, {0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.3576298790583277, -0.3329657494680982, 
    0.5549429157801637}, {0.30948310838038806`, -0.2862137017352461, 
    0.5235616495156941}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.36266749034792994`, -0.29013399227834397`, 
    0.5440012355218949}, {0.3391849732407725, -0.25965194503259137`, 
    0.5263215102011988}, {0.3576298790583277, -0.3329657494680982, 
    0.5549429157801637}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.36266749034792994`, -0.29013399227834397`, 
    0.5440012355218949}, {0.3410246861288609, -0.20461481167731652`, 
    0.5115370291932914}, {0.32221918972665153`, -0.19333151383599093`, 
    0.4999952944034249}, {0.3391849732407725, -0.25965194503259137`, 
    0.5263215102011988}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3410246861288609, -0.20461481167731652`, 
    0.5115370291932914}, {0.3230789997575147, -0.12923159990300587`, 
    0.48461849963627207`}, {0.30764777640897106`, -0.1336676545776909, 
    0.4773844806346103}, {0.32221918972665153`, -0.19333151383599093`, 
    0.4999952944034249}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3230789997575147, -0.12923159990300587`, 
    0.48461849963627207`}, {0.31096701746038047`, -0.06219340349207609, 
    0.46645052619057076`}, {0.29665252977081547`, -0.07978930111077105, 
    0.46032289102367924`}, {0.30764777640897106`, -0.1336676545776909, 
    0.4773844806346103}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.31096701746038047`, -0.06219340349207609, 
    0.46645052619057076`}, {0.3066580952458096, 0., 0.45998714286871445`}, {
    0.29040472453203425`, -0.03004186805503801, 0.45062802082557046`}, {
    0.29665252977081547`, -0.07978930111077105, 0.46032289102367924`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.4407985310247471, 0.4407985310247471, 
    0.6103364275727268}, {0.4589425074132659, 0.4452427310725714, 
    0.6164899353312527}, {0.41445824199145676`, 0.4013008374837915, 
    0.5920832028449382}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4407985310247471, 0.4407985310247471, 
    0.6103364275727268}, {0.49871361404698694`, 0.49871361404698694`, 
    0.6412032180604118}, {0.5058735949853128, 0.4916236345631913, 
    0.641248218995467}, {0.4589425074132659, 0.4452427310725714, 
    0.6164899353312527}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49871361404698694`, 0.49871361404698694`, 
    0.6412032180604118}, {0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {0.5560382810696715, 0.5412105935744802, 
    0.6672459372836057}, {0.5058735949853128, 0.4916236345631913, 
    0.641248218995467}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {0.6001728499508097, 0.5251512437069583, 
    0.6751944561946608}, {0.5866559059525488, 0.5123956646927323, 
    0.6683421713383466}, {0.5560382810696715, 0.5412105935744802, 
    0.6672459372836057}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6001728499508097, 0.5251512437069583, 
    0.6751944561946608}, {0.6409750644401281, 0.49015740221892146`, 
    0.6786794799954298}, {0.6187258872685492, 0.484544369547659, 
    0.670907588604451}, {0.5866559059525488, 0.5123956646927323, 
    0.6683421713383466}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6409750644401281, 0.49015740221892146`, 
    0.6786794799954298}, {0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.6524642864965196, 0.4574749594975597, 
    0.6749630549963996}, {0.6187258872685492, 0.484544369547659, 
    0.670907588604451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.5739560409372104, 0.4304670307029078, 
    0.6457005460543618}, {0.5660318008824062, 0.43706252979527566`, 
    0.6448463554356526}, {0.6524642864965196, 0.4574749594975597, 
    0.6749630549963996}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5739560409372104, 0.4304670307029078, 
    0.6457005460543618}, {0.4756173846484537, 0.40767204398438894`, 
    0.6115080659765835}, {0.4872182513685714, 0.4185959624434205, 
    0.6176006003263582}, {0.5660318008824062, 0.43706252979527566`, 
    0.6448463554356526}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4756173846484537, 0.40767204398438894`, 
    0.6115080659765835}, {0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.41445824199145676`, 0.4013008374837915, 
    0.5920832028449382}, {0.4872182513685714, 0.4185959624434205, 
    0.6176006003263582}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.7171888530767329, 0.5578135523930144, 
    0.7171888530767329}, {0.7082077892481158, 0.5649747532204069, 
    0.716165180138544}, {0.6814262655051629, 0.48235791827893554`, 
    0.6890827403984794}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7171888530767329, 0.5578135523930144, 
    0.7171888530767329}, {0.7640699024805022, 0.6791732466493353, 
    0.7640699024805022}, {0.7436741413969546, 0.6601152491051621, 
    0.7520300306261339}, {0.7082077892481158, 0.5649747532204069, 
    0.716165180138544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7640699024805022, 0.6791732466493353, 
    0.7640699024805022}, {0.9068996821171088, 0.9068996821171088, 
    0.9068996821171088}, {0.8014503466375957, 0.7834402264884363, 
    0.8104554067121754}, {0.7436741413969546, 0.6601152491051621, 
    0.7520300306261339}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.9068996821171088, 0.9068996821171088, 
    0.9068996821171088}, {0.7198653019554957, 0.7198653019554957, 
    0.7622103197175837}, {0.7087220368790109, 0.6920462242465636, 
    0.7504115684601292}, {0.8014503466375957, 0.7834402264884363, 
    0.8104554067121754}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7198653019554957, 0.7198653019554957, 
    0.7622103197175837}, {0.6327645227143793, 0.6327645227143793, 
    0.7118600880536767}, {0.6407214117452011, 0.6249011299737146, 
    0.7119126797168901}, {0.7087220368790109, 0.6920462242465636, 
    0.7504115684601292}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6327645227143793, 0.6327645227143793, 
    0.7118600880536767}, {0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {0.5827295292403942, 0.5675936973120723, 
    0.6811124367744867}, {0.6407214117452011, 0.6249011299737146, 
    0.7119126797168901}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {0.6001728499508097, 0.5251512437069583, 
    0.6751944561946608}, {0.6140163187056149, 0.5382118349147982, 
    0.68224035411735}, {0.5827295292403942, 0.5675936973120723, 
    0.6811124367744867}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6001728499508097, 0.5251512437069583, 
    0.6751944561946608}, {0.6409750644401281, 0.49015740221892146`, 
    0.6786794799954298}, {0.6468362024341406, 0.5098591242716168, 
    0.6848853908126196}, {0.6140163187056149, 0.5382118349147982, 
    0.68224035411735}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6409750644401281, 0.49015740221892146`, 
    0.6786794799954298}, {0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.6814262655051629, 0.48235791827893554`, 
    0.6890827403984794}, {0.6468362024341406, 0.5098591242716168, 
    0.6848853908126196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, 0., 0.45998714286871445`}, {
    0.30835878902578173`, 0.038544848628222717`, 0.46253818353867265`}, {
    0.3272755515504841, 0.052786379282336135`, 0.47507741354102534`}, {
    0.324812266811562, 0.020955630116874954`, 0.47150167762968676`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.30835878902578173`, 0.038544848628222717`, 
    0.46253818353867265`}, {0.3133278126499405, 0.07833195316248512, 
    0.46999171897491077`}, {0.33173110157337826`, 0.0856080262124847, 
    0.48154514744522653`}, {0.3272755515504841, 0.052786379282336135`, 
    0.47507741354102534`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3133278126499405, 0.07833195316248512, 
    0.46999171897491077`}, {0.32119984116648215`, 0.12044994043743079`, 
    0.4817997617497233}, {0.3379835236888404, 0.11992963743797559`, 
    0.4906212440644457}, {0.33173110157337826`, 0.0856080262124847, 
    0.48154514744522653`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.32119984116648215`, 0.12044994043743079`, 
    0.4817997617497233}, {0.3314637051921916, 0.1657318525960958, 
    0.4971955577882874}, {0.3457858768371393, 0.1561613637329016, 
    0.5019472405700409}, {0.3379835236888404, 0.11992963743797559`, 
    0.4906212440644457}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3314637051921916, 0.1657318525960958, 
    0.4971955577882874}, {0.3976554430093185, 0.17673575244858597`, 
    0.5302072573457579}, {0.3994358934176101, 0.16447360317195706`, 
    0.5286651530527192}, {0.3457858768371393, 0.1561613637329016, 
    0.5019472405700409}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3976554430093185, 0.17673575244858597`, 
    0.5302072573457579}, {0.4681662066691236, 0.18726648266764945`, 
    0.5617994480029483}, {0.4558187389930595, 0.17247195529467113`, 
    0.5543741420185859}, {0.3994358934176101, 0.16447360317195706`, 
    0.5286651530527192}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4681662066691236, 0.18726648266764945`, 
    0.5617994480029483}, {0.5431099643448393, 0.19749453248903248`, 
    0.5924835974670974}, {0.5149712865819899, 0.18023995030369647`, 
    0.5793426974047388}, {0.4558187389930595, 0.17247195529467113`, 
    0.5543741420185859}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5431099643448393, 0.19749453248903248`, 
    0.5924835974670974}, {0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.577110853908633, 0.18789655708653166`, 
    0.6039532192067091}, {0.5149712865819899, 0.18023995030369647`, 
    0.5793426974047388}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.5340787945649619, 0.14565785306317142`, 
    0.5826314122526858}, {0.508005053276671, 0.13970138965108453`, 
    0.571505684936255}, {0.577110853908633, 0.18789655708653166`, 
    0.6039532192067091}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5340787945649619, 0.14565785306317142`, 
    0.5826314122526858}, {0.45198686524397114`, 0.09039737304879422, 
    0.5423842382927654}, {0.4430198761700281, 0.09578808133406011, 
    0.5388079575040883}, {0.508005053276671, 0.13970138965108453`, 
    0.571505684936255}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45198686524397114`, 0.09039737304879422, 
    0.5423842382927654}, {0.37603348426231603`, 0.041781498251368454`, 
    0.5013779790164213}, {0.3818853518094823, 0.05615961056021797, 
    0.5054364950419619}, {0.4430198761700281, 0.09578808133406011, 
    0.5388079575040883}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.37603348426231603`, 0.041781498251368454`, 
    0.5013779790164213}, {0.3066580952458096, 0., 0.45998714286871445`}, {
    0.324812266811562, 0.020955630116874954`, 0.47150167762968676`}, {
    0.3818853518094823, 0.05615961056021797, 0.5054364950419619}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, 0., 0.45998714286871445`}, {
    0.3521297960868685, 0.02708690739129757, 0.4875643330433564}, {
    0.37052561112373567`, 0.027651165009234, 0.4977209701662121}, {
    0.33331950097178215`, 0.005290785729710824, 0.47617071567397445`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3521297960868685, 0.02708690739129757, 
    0.4875643330433564}, {0.4006616635511933, 0.057237380507313335`, 
    0.5151364245658201}, {0.4096523388389484, 0.05192776126127516, 
    0.5192776126127516}, {0.37052561112373567`, 0.027651165009234, 
    0.4977209701662121}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4006616635511933, 0.057237380507313335`, 
    0.5151364245658201}, {0.45198686524397114`, 0.09039737304879422, 
    0.5423842382927654}, {0.45057871430700847`, 0.07810031047988147, 
    0.5406944571684102}, {0.4096523388389484, 0.05192776126127516, 
    0.5192776126127516}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45198686524397114`, 0.09039737304879422, 
    0.5423842382927654}, {0.49876346636093416`, 0.06234543329511677, 
    0.5611088996560509}, {0.48816098568500393`, 0.055613276850190324`, 
    0.5561327685019032}, {0.45057871430700847`, 0.07810031047988147, 
    0.5406944571684102}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49876346636093416`, 0.06234543329511677, 
    0.5611088996560509}, {0.5487568617464034, 0.03227981539684726, 
    0.5810366771432506}, {0.5277877792683088, 0.03179444453423547, 
    0.5723000016162385}, {0.48816098568500393`, 0.055613276850190324`, 
    0.5561327685019032}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5487568617464034, 0.03227981539684726, 
    0.5810366771432506}, {0.6020420732135735, 0., 0.6020420732135735}, {
    0.5694735663591197, 0.006545673176541602, 0.5891105858887445}, {
    0.5277877792683088, 0.03179444453423547, 0.5723000016162385}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, 0., 0.6020420732135735}, {
    0.49629010408701807`, 0., 0.5583263670978953}, {0.4861669055664678, 
    0.0061540114628666764`, 0.5538610316580013}, {0.5694735663591197, 
    0.006545673176541602, 0.5891105858887445}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.49629010408701807`, 0., 0.5583263670978953}, {
    0.3979707523500161, 0., 0.5116766815928779}, {0.40751773325855134`, 
    0.005739686383923255, 0.5165717745530933}, {0.4861669055664678, 
    0.0061540114628666764`, 0.5538610316580013}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3979707523500161, 0., 0.5116766815928779}, {
    0.3066580952458096, 0., 0.45998714286871445`}, {0.33331950097178215`, 
    0.005290785729710824, 0.47617071567397445`}, {0.40751773325855134`, 
    0.005739686383923255, 0.5165717745530933}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0.6020420732135735, 0., 0.6020420732135735}, {
    0.6044295191828238, 0.06715883546475819, 0.6044295191828238}, {
    0.5939764691589027, 0.0734128220308756, 0.6006503620708005}, {
    0.5913037838451686, 0.01993158821950005, 0.597947646585002}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6044295191828238, 0.06715883546475819, 
    0.6044295191828238}, {0.6115080659765835, 0.13589068132812965`, 
    0.6115080659765835}, {0.5996388334008513, 0.12801278465860869`, 
    0.6063763483828833}, {0.5939764691589027, 0.0734128220308756, 
    0.6006503620708005}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, 0.13589068132812965`, 
    0.6115080659765835}, {0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.6081719439707838, 0.1845016009799007, 
    0.615005336599669}, {0.5996388334008513, 0.12801278465860869`, 
    0.6063763483828833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.5628929014012727, 0.16555673570625667`, 
    0.596004248542524}, {0.560676306835095, 0.15171241243773156`, 
    0.5936572660606888}, {0.6081719439707838, 0.1845016009799007, 
    0.615005336599669}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5628929014012727, 0.16555673570625667`, 
    0.596004248542524}, {0.5060163098682655, 0.12650407746706638`, 
    0.5692683486017988}, {0.5152602653744724, 0.12086351903845649`, 
    0.572511405971636}, {0.560676306835095, 0.15171241243773156`, 
    0.5936572660606888}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5060163098682655, 0.12650407746706638`, 
    0.5692683486017988}, {0.45198686524397114`, 0.09039737304879422, 
    0.5423842382927654}, {0.4716982811963126, 0.09188927555772322, 
    0.5513356533463394}, {0.5152602653744724, 0.12086351903845649`, 
    0.572511405971636}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45198686524397114`, 0.09039737304879422, 
    0.5423842382927654}, {0.49876346636093416`, 0.06234543329511677, 
    0.5611088996560509}, {0.5094822152479099, 0.06918894281144455, 
    0.5660913502754555}, {0.4716982811963126, 0.09188927555772322, 
    0.5513356533463394}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49876346636093416`, 0.06234543329511677, 
    0.5611088996560509}, {0.5487568617464034, 0.03227981539684726, 
    0.5810366771432506}, {0.5493362280674016, 0.04523945407613895, 
    0.5816501238360723}, {0.5094822152479099, 0.06918894281144455, 
    0.5660913502754555}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5487568617464034, 0.03227981539684726, 
    0.5810366771432506}, {0.6020420732135735, 0., 0.6020420732135735}, {
    0.5913037838451686, 0.01993158821950005, 0.597947646585002}, {
    0.5493362280674016, 0.04523945407613895, 0.5816501238360723}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.3713990257767195, 0.32497414755462956`, 
    0.5570985386650793}, {0.3835413553175741, 0.30930754461094684`, 
    0.5567535802997043}, {0.39544905581618517`, 0.35717979235010267`, 
    0.5740389519912366}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3713990257767195, 0.32497414755462956`, 
    0.5570985386650793}, {0.35700820570107417`, 0.26775615427580557`, 
    0.5355123085516112}, {0.37218594917787184`, 0.26413196393268323`, 
    0.540269926225943}, {0.3835413553175741, 0.30930754461094684`, 
    0.5567535802997043}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.35700820570107417`, 0.26775615427580557`, 
    0.5355123085516112}, {0.34356711554250086`, 0.21472944721406304`, 
    0.5153506733137513}, {0.3615143676766774, 0.22157332212441513`, 
    0.5247789208209833}, {0.37218594917787184`, 0.26413196393268323`, 
    0.540269926225943}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.34356711554250086`, 0.21472944721406304`, 
    0.5153506733137513}, {0.3314637051921916, 0.1657318525960958, 
    0.4971955577882874}, {0.35171683279870997`, 0.18153126854126964`, 
    0.510556692772321}, {0.3615143676766774, 0.22157332212441513`, 
    0.5247789208209833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3314637051921916, 0.1657318525960958, 
    0.4971955577882874}, {0.3976554430093185, 0.17673575244858597`, 
    0.5302072573457579}, {0.4051478286995518, 0.1906578017409655, 
    0.5362250673964656}, {0.35171683279870997`, 0.18153126854126964`, 
    0.510556692772321}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3976554430093185, 0.17673575244858597`, 
    0.5302072573457579}, {0.4681662066691236, 0.18726648266764945`, 
    0.5617994480029483}, {0.461356206383864, 0.19950538654437358`, 
    0.5611088996560508}, {0.4051478286995518, 0.1906578017409655, 
    0.5362250673964656}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4681662066691236, 0.18726648266764945`, 
    0.5617994480029483}, {0.5431099643448393, 0.19749453248903248`, 
    0.5924835974670974}, {0.5204039871231084, 0.20816159484924335`, 
    0.5854544855134971}, {0.461356206383864, 0.19950538654437358`, 
    0.5611088996560508}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5431099643448393, 0.19749453248903248`, 
    0.5924835974670974}, {0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.5825372045115768, 0.21675802958570295`, 
    0.6096319582097897}, {0.5204039871231084, 0.20816159484924335`, 
    0.5854544855134971}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.5543330019515705, 0.251969546341623, 
    0.6047269112198952}, {0.5296515960248482, 0.2515845081118029, 
    0.5958580455279544}, {0.5825372045115768, 0.21675802958570295`, 
    0.6096319582097897}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5543330019515705, 0.251969546341623, 
    0.6047269112198952}, {0.4925795519732687, 0.29554773118396116`, 
    0.5910954623679224}, {0.4811249564266876, 0.2860742984158683, 
    0.585151974032458}, {0.5296515960248482, 0.2515845081118029, 
    0.5958580455279544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4925795519732687, 0.29554773118396116`, 
    0.5910954623679224}, {0.43697355918951436`, 0.3398683238140667, 
    0.5826314122526858}, {0.4365551681661225, 0.32099644718097237`, 
    0.5777936049257504}, {0.4811249564266876, 0.2860742984158683, 
    0.585151974032458}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.43697355918951436`, 0.3398683238140667, 
    0.5826314122526858}, {0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.39544905581618517`, 0.35717979235010267`, 
    0.5740389519912366}, {0.4365551681661225, 0.32099644718097237`, 
    0.5777936049257504}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.41963760015901447`, 0.3550779693653199, 
    0.5810366771432508}, {0.4375200535371022, 0.3591582529035913, 
    0.5877135047513313}, {0.41027620202761383`, 0.38422691935919384`, 
    0.5861088600394483}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.41963760015901447`, 0.3550779693653199, 
    0.5810366771432508}, {0.45488267153483286`, 0.32491619395345206`, 
    0.5848491491162138}, {0.46615250600961755`, 0.33484194093648584`, 
    0.5908975428290927}, {0.4375200535371022, 0.3591582529035913, 
    0.5877135047513313}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45488267153483286`, 0.32491619395345206`, 
    0.5848491491162138}, {0.4925795519732687, 0.2955477311839612, 
    0.5910954623679224}, {0.49634519379760245`, 0.31104298811316416`, 
    0.595614232557123}, {0.46615250600961755`, 0.33484194093648584`, 
    0.5908975428290927}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4925795519732687, 0.2955477311839612, 
    0.5910954623679224}, {0.5518056130029987, 0.34487850812687415`, 
    0.6207813146283735}, {0.5437365170115114, 0.3510197768048997, 
    0.6194466649498231}, {0.49634519379760245`, 0.31104298811316416`, 
    0.595614232557123}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5518056130029987, 0.34487850812687415`, 
    0.6207813146283735}, {0.6151364564558499, 0.39802947182437354`, 
    0.6513209538944295}, {0.593696451805427, 0.3934133114373311, 
    0.643767236897451}, {0.5437365170115114, 0.3510197768048997, 
    0.6194466649498231}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6151364564558499, 0.39802947182437354`, 
    0.6513209538944295}, {0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.6471256199373834, 0.43885530547477725`, 
    0.6694402964869484}, {0.593696451805427, 0.3934133114373311, 
    0.643767236897451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.5739560409372104, 0.4304670307029078, 
    0.6457005460543618}, {0.561292824000522, 0.4191933748864658, 
    0.639447521013253}, {0.6471256199373834, 0.43885530547477725`, 
    0.6694402964869484}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5739560409372104, 0.4304670307029078, 
    0.6457005460543618}, {0.4756173846484537, 0.40767204398438894`, 
    0.6115080659765835}, {0.4828178508766534, 0.4012148338270782, 
    0.6120226278718142}, {0.561292824000522, 0.4191933748864658, 
    0.639447521013253}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4756173846484537, 0.40767204398438894`, 
    0.6115080659765835}, {0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.41027620202761383`, 0.38422691935919384`, 
    0.5861088600394483}, {0.4828178508766534, 0.4012148338270782, 
    0.6120226278718142}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.6592097133507697, 0.3662276185282054, 
    0.6592097133507697}, {0.6456860811433847, 0.35549008961826795`, 
    0.6529409809315125}, {0.6647257540000352, 0.42572323570788767`, 
    0.6721945826966648}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6592097133507697, 0.3662276185282054, 
    0.6592097133507697}, {0.6389520625760421, 0.2839786944782409, 
    0.6389520625760421}, {0.629668395546924, 0.2900719574991448, 
    0.6367433213395861}, {0.6456860811433847, 0.35549008961826795`, 
    0.6529409809315125}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6389520625760421, 0.2839786944782409, 
    0.6389520625760421}, {0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.6163788869098672, 0.22854498053961364`, 
    0.6233044923807646}, {0.629668395546924, 0.2900719574991448, 
    0.6367433213395861}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {0.5764288482631306, 0.23735305516717142`, 
    0.6103364275727265}, {0.5796080893522855, 0.25229999183570073`, 
    0.6137026828435964}, {0.6163788869098672, 0.22854498053961364`, 
    0.6233044923807646}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5764288482631306, 0.23735305516717142`, 
    0.6103364275727265}, {0.5330126623440324, 0.2665063311720162, 
    0.5996392451370365}, {0.5448850795979028, 0.2758060279446175, 
    0.605427866219892}, {0.5796080893522855, 0.25229999183570073`, 
    0.6137026828435964}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5330126623440324, 0.2665063311720162, 
    0.5996392451370365}, {0.4925795519732687, 0.2955477311839612, 
    0.5910954623679224}, {0.5120744169386685, 0.29926426963948155`, 
    0.5985285392789631}, {0.5448850795979028, 0.2758060279446175, 
    0.605427866219892}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4925795519732687, 0.2955477311839612, 
    0.5910954623679224}, {0.5518056130029987, 0.34487850812687415`, 
    0.6207813146283735}, {0.5599842480618302, 0.33875590314851456`, 
    0.6222047200687002}, {0.5120744169386685, 0.29926426963948155`, 
    0.5985285392789631}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5518056130029987, 0.34487850812687415`, 
    0.6207813146283735}, {0.6151364564558499, 0.39802947182437354`, 
    0.6513209538944295}, {0.6105500670057994, 0.3806959241330279, 
    0.6464647768296701}, {0.5599842480618302, 0.33875590314851456`, 
    0.6222047200687002}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6151364564558499, 0.39802947182437354`, 
    0.6513209538944295}, {0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {0.6647257540000352, 0.42572323570788767`, 
    0.6721945826966648}, {0.6105500670057994, 0.3806959241330279, 
    0.6464647768296701}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.3713990257767195, -0.32497414755462956`, 
    0.5570985386650793}, {0.3835413553175741, -0.30930754461094684`, 
    0.5567535802997043}, {0.39544905581618517`, -0.35717979235010267`, 
    0.5740389519912366}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3713990257767195, -0.32497414755462956`, 
    0.5570985386650793}, {0.35700820570107417`, -0.26775615427580557`, 
    0.5355123085516112}, {0.37218594917787184`, -0.26413196393268323`, 
    0.540269926225943}, {0.3835413553175741, -0.30930754461094684`, 
    0.5567535802997043}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.35700820570107417`, -0.26775615427580557`, 
    0.5355123085516112}, {0.34356711554250086`, -0.21472944721406304`, 
    0.5153506733137513}, {0.3615143676766774, -0.22157332212441513`, 
    0.5247789208209833}, {0.37218594917787184`, -0.26413196393268323`, 
    0.540269926225943}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.34356711554250086`, -0.21472944721406304`, 
    0.5153506733137513}, {0.3314637051921916, -0.1657318525960958, 
    0.4971955577882874}, {0.35171683279870997`, -0.18153126854126964`, 
    0.510556692772321}, {0.3615143676766774, -0.22157332212441513`, 
    0.5247789208209833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3314637051921916, -0.1657318525960958, 
    0.4971955577882874}, {0.3976554430093185, -0.17673575244858597`, 
    0.5302072573457579}, {0.4051478286995518, -0.1906578017409655, 
    0.5362250673964656}, {0.35171683279870997`, -0.18153126854126964`, 
    0.510556692772321}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3976554430093185, -0.17673575244858597`, 
    0.5302072573457579}, {0.4681662066691236, -0.18726648266764945`, 
    0.5617994480029483}, {0.461356206383864, -0.19950538654437358`, 
    0.5611088996560508}, {0.4051478286995518, -0.1906578017409655, 
    0.5362250673964656}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4681662066691236, -0.18726648266764945`, 
    0.5617994480029483}, {0.5431099643448393, -0.19749453248903248`, 
    0.5924835974670974}, {0.5204039871231084, -0.20816159484924335`, 
    0.5854544855134971}, {0.461356206383864, -0.19950538654437358`, 
    0.5611088996560508}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5431099643448393, -0.19749453248903248`, 
    0.5924835974670974}, {0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.5825372045115768, -0.21675802958570295`, 
    0.6096319582097897}, {0.5204039871231084, -0.20816159484924335`, 
    0.5854544855134971}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.5543330019515705, -0.251969546341623, 
    0.6047269112198952}, {0.5296515960248482, -0.2515845081118029, 
    0.5958580455279544}, {0.5825372045115768, -0.21675802958570295`, 
    0.6096319582097897}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5543330019515705, -0.251969546341623, 
    0.6047269112198952}, {0.4925795519732687, -0.29554773118396116`, 
    0.5910954623679224}, {0.4811249564266876, -0.2860742984158683, 
    0.585151974032458}, {0.5296515960248482, -0.2515845081118029, 
    0.5958580455279544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4925795519732687, -0.29554773118396116`, 
    0.5910954623679224}, {0.43697355918951436`, -0.3398683238140667, 
    0.5826314122526858}, {0.4365551681661225, -0.32099644718097237`, 
    0.5777936049257504}, {0.4811249564266876, -0.2860742984158683, 
    0.585151974032458}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.43697355918951436`, -0.3398683238140667, 
    0.5826314122526858}, {0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.39544905581618517`, -0.35717979235010267`, 
    0.5740389519912366}, {0.4365551681661225, -0.32099644718097237`, 
    0.5777936049257504}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.41963760015901447`, -0.3550779693653199, 
    0.5810366771432508}, {0.4375200535371022, -0.3591582529035913, 
    0.5877135047513313}, {0.41027620202761383`, -0.38422691935919384`, 
    0.5861088600394483}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.41963760015901447`, -0.3550779693653199, 
    0.5810366771432508}, {0.45488267153483286`, -0.32491619395345206`, 
    0.5848491491162138}, {0.46615250600961755`, -0.33484194093648584`, 
    0.5908975428290927}, {0.4375200535371022, -0.3591582529035913, 
    0.5877135047513313}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45488267153483286`, -0.32491619395345206`, 
    0.5848491491162138}, {0.4925795519732687, -0.2955477311839612, 
    0.5910954623679224}, {0.49634519379760245`, -0.31104298811316416`, 
    0.595614232557123}, {0.46615250600961755`, -0.33484194093648584`, 
    0.5908975428290927}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4925795519732687, -0.2955477311839612, 
    0.5910954623679224}, {0.5518056130029987, -0.34487850812687415`, 
    0.6207813146283735}, {0.5437365170115114, -0.3510197768048997, 
    0.6194466649498231}, {0.49634519379760245`, -0.31104298811316416`, 
    0.595614232557123}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5518056130029987, -0.34487850812687415`, 
    0.6207813146283735}, {0.6151364564558499, -0.39802947182437354`, 
    0.6513209538944295}, {0.593696451805427, -0.3934133114373311, 
    0.643767236897451}, {0.5437365170115114, -0.3510197768048997, 
    0.6194466649498231}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6151364564558499, -0.39802947182437354`, 
    0.6513209538944295}, {0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.6471256199373834, -0.43885530547477725`, 
    0.6694402964869484}, {0.593696451805427, -0.3934133114373311, 
    0.643767236897451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.5739560409372104, -0.4304670307029078, 
    0.6457005460543618}, {0.561292824000522, -0.4191933748864658, 
    0.639447521013253}, {0.6471256199373834, -0.43885530547477725`, 
    0.6694402964869484}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5739560409372104, -0.4304670307029078, 
    0.6457005460543618}, {0.4756173846484537, -0.40767204398438894`, 
    0.6115080659765835}, {0.4828178508766534, -0.4012148338270782, 
    0.6120226278718142}, {0.561292824000522, -0.4191933748864658, 
    0.639447521013253}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4756173846484537, -0.40767204398438894`, 
    0.6115080659765835}, {0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.41027620202761383`, -0.38422691935919384`, 
    0.5861088600394483}, {0.4828178508766534, -0.4012148338270782, 
    0.6120226278718142}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.6592097133507697, -0.3662276185282054, 
    0.6592097133507697}, {0.6456860811433847, -0.35549008961826795`, 
    0.6529409809315125}, {0.6647257540000352, -0.42572323570788767`, 
    0.6721945826966648}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6592097133507697, -0.3662276185282054, 
    0.6592097133507697}, {0.6389520625760421, -0.2839786944782409, 
    0.6389520625760421}, {0.629668395546924, -0.2900719574991448, 
    0.6367433213395861}, {0.6456860811433847, -0.35549008961826795`, 
    0.6529409809315125}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6389520625760421, -0.2839786944782409, 
    0.6389520625760421}, {0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.6163788869098672, -0.22854498053961364`, 
    0.6233044923807646}, {0.629668395546924, -0.2900719574991448, 
    0.6367433213395861}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.5764288482631306, -0.23735305516717142`, 
    0.6103364275727265}, {0.5796080893522855, -0.25229999183570073`, 
    0.6137026828435964}, {0.6163788869098672, -0.22854498053961364`, 
    0.6233044923807646}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5764288482631306, -0.23735305516717142`, 
    0.6103364275727265}, {0.5330126623440324, -0.2665063311720162, 
    0.5996392451370365}, {0.5448850795979028, -0.2758060279446175, 
    0.605427866219892}, {0.5796080893522855, -0.25229999183570073`, 
    0.6137026828435964}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5330126623440324, -0.2665063311720162, 
    0.5996392451370365}, {0.4925795519732687, -0.2955477311839612, 
    0.5910954623679224}, {0.5120744169386685, -0.29926426963948155`, 
    0.5985285392789631}, {0.5448850795979028, -0.2758060279446175, 
    0.605427866219892}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4925795519732687, -0.2955477311839612, 
    0.5910954623679224}, {0.5518056130029987, -0.34487850812687415`, 
    0.6207813146283735}, {0.5599842480618302, -0.33875590314851456`, 
    0.6222047200687002}, {0.5120744169386685, -0.29926426963948155`, 
    0.5985285392789631}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5518056130029987, -0.34487850812687415`, 
    0.6207813146283735}, {0.6151364564558499, -0.39802947182437354`, 
    0.6513209538944295}, {0.6105500670057994, -0.3806959241330279, 
    0.6464647768296701}, {0.5599842480618302, -0.33875590314851456`, 
    0.6222047200687002}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6151364564558499, -0.39802947182437354`, 
    0.6513209538944295}, {0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.6647257540000352, -0.42572323570788767`, 
    0.6721945826966648}, {0.6105500670057994, -0.3806959241330279, 
    0.6464647768296701}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, 0., 0.45998714286871445`}, {
    0.30835878902578173`, -0.038544848628222717`, 0.46253818353867265`}, {
    0.3272755515504841, -0.052786379282336135`, 0.47507741354102534`}, {
    0.324812266811562, -0.020955630116874954`, 0.47150167762968676`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.30835878902578173`, -0.038544848628222717`, 
    0.46253818353867265`}, {0.3133278126499405, -0.07833195316248512, 
    0.46999171897491077`}, {0.33173110157337826`, -0.0856080262124847, 
    0.48154514744522653`}, {0.3272755515504841, -0.052786379282336135`, 
    0.47507741354102534`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3133278126499405, -0.07833195316248512, 
    0.46999171897491077`}, {0.32119984116648215`, -0.12044994043743079`, 
    0.4817997617497233}, {0.3379835236888404, -0.11992963743797559`, 
    0.4906212440644457}, {0.33173110157337826`, -0.0856080262124847, 
    0.48154514744522653`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.32119984116648215`, -0.12044994043743079`, 
    0.4817997617497233}, {0.3314637051921916, -0.1657318525960958, 
    0.4971955577882874}, {0.3457858768371393, -0.1561613637329016, 
    0.5019472405700409}, {0.3379835236888404, -0.11992963743797559`, 
    0.4906212440644457}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3314637051921916, -0.1657318525960958, 
    0.4971955577882874}, {0.3976554430093185, -0.17673575244858597`, 
    0.5302072573457579}, {0.3994358934176101, -0.16447360317195706`, 
    0.5286651530527192}, {0.3457858768371393, -0.1561613637329016, 
    0.5019472405700409}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3976554430093185, -0.17673575244858597`, 
    0.5302072573457579}, {0.4681662066691236, -0.18726648266764945`, 
    0.5617994480029483}, {0.4558187389930595, -0.17247195529467113`, 
    0.5543741420185859}, {0.3994358934176101, -0.16447360317195706`, 
    0.5286651530527192}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4681662066691236, -0.18726648266764945`, 
    0.5617994480029483}, {0.5431099643448393, -0.19749453248903248`, 
    0.5924835974670974}, {0.5149712865819899, -0.18023995030369647`, 
    0.5793426974047388}, {0.4558187389930595, -0.17247195529467113`, 
    0.5543741420185859}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5431099643448393, -0.19749453248903248`, 
    0.5924835974670974}, {0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.577110853908633, -0.18789655708653166`, 
    0.6039532192067091}, {0.5149712865819899, -0.18023995030369647`, 
    0.5793426974047388}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.5340787945649619, -0.14565785306317142`, 
    0.5826314122526858}, {0.508005053276671, -0.13970138965108453`, 
    0.571505684936255}, {0.577110853908633, -0.18789655708653166`, 
    0.6039532192067091}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5340787945649619, -0.14565785306317142`, 
    0.5826314122526858}, {0.45198686524397114`, -0.09039737304879422, 
    0.5423842382927654}, {0.4430198761700281, -0.09578808133406011, 
    0.5388079575040883}, {0.508005053276671, -0.13970138965108453`, 
    0.571505684936255}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45198686524397114`, -0.09039737304879422, 
    0.5423842382927654}, {0.37603348426231603`, -0.041781498251368454`, 
    0.5013779790164213}, {0.3818853518094823, -0.05615961056021797, 
    0.5054364950419619}, {0.4430198761700281, -0.09578808133406011, 
    0.5388079575040883}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.37603348426231603`, -0.041781498251368454`, 
    0.5013779790164213}, {0.3066580952458096, 0., 0.45998714286871445`}, {
    0.324812266811562, -0.020955630116874954`, 0.47150167762968676`}, {
    0.3818853518094823, -0.05615961056021797, 0.5054364950419619}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3066580952458096, 0., 0.45998714286871445`}, {
    0.3521297960868685, -0.02708690739129757, 0.4875643330433564}, {
    0.37052561112373567`, -0.027651165009234, 0.4977209701662121}, {
    0.33331950097178215`, -0.005290785729710824, 0.47617071567397445`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3521297960868685, -0.02708690739129757, 
    0.4875643330433564}, {0.4006616635511933, -0.057237380507313335`, 
    0.5151364245658201}, {0.4096523388389484, -0.05192776126127516, 
    0.5192776126127516}, {0.37052561112373567`, -0.027651165009234, 
    0.4977209701662121}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4006616635511933, -0.057237380507313335`, 
    0.5151364245658201}, {0.45198686524397114`, -0.09039737304879422, 
    0.5423842382927654}, {0.45057871430700847`, -0.07810031047988147, 
    0.5406944571684102}, {0.4096523388389484, -0.05192776126127516, 
    0.5192776126127516}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45198686524397114`, -0.09039737304879422, 
    0.5423842382927654}, {0.49876346636093416`, -0.06234543329511677, 
    0.5611088996560509}, {0.48816098568500393`, -0.055613276850190324`, 
    0.5561327685019032}, {0.45057871430700847`, -0.07810031047988147, 
    0.5406944571684102}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49876346636093416`, -0.06234543329511677, 
    0.5611088996560509}, {0.5487568617464034, -0.03227981539684726, 
    0.5810366771432506}, {0.5277877792683088, -0.03179444453423547, 
    0.5723000016162385}, {0.48816098568500393`, -0.055613276850190324`, 
    0.5561327685019032}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5487568617464034, -0.03227981539684726, 
    0.5810366771432506}, {0.6020420732135735, 0., 0.6020420732135735}, {
    0.5694735663591197, -0.006545673176541602, 0.5891105858887445}, {
    0.5277877792683088, -0.03179444453423547, 0.5723000016162385}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, 0., 0.6020420732135735}, {
    0.49629010408701807`, 0., 0.5583263670978953}, {
    0.4861669055664678, -0.0061540114628666764`, 0.5538610316580013}, {
    0.5694735663591197, -0.006545673176541602, 0.5891105858887445}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49629010408701807`, 0., 0.5583263670978953}, {
    0.3979707523500161, 0., 0.5116766815928779}, {
    0.40751773325855134`, -0.005739686383923255, 0.5165717745530933}, {
    0.4861669055664678, -0.0061540114628666764`, 0.5538610316580013}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3979707523500161, 0., 0.5116766815928779}, {
    0.3066580952458096, 0., 0.45998714286871445`}, {
    0.33331950097178215`, -0.005290785729710824, 0.47617071567397445`}, {
    0.40751773325855134`, -0.005739686383923255, 0.5165717745530933}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6020420732135735, 0., 0.6020420732135735}, {
    0.6044295191828238, -0.06715883546475819, 0.6044295191828238}, {
    0.5939764691589027, -0.0734128220308756, 0.6006503620708005}, {
    0.5913037838451686, -0.01993158821950005, 0.597947646585002}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6044295191828238, -0.06715883546475819, 
    0.6044295191828238}, {0.6115080659765835, -0.13589068132812965`, 
    0.6115080659765835}, {0.5996388334008513, -0.12801278465860869`, 
    0.6063763483828833}, {0.5939764691589027, -0.0734128220308756, 
    0.6006503620708005}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6115080659765835, -0.13589068132812965`, 
    0.6115080659765835}, {0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.6081719439707838, -0.1845016009799007, 
    0.615005336599669}, {0.5996388334008513, -0.12801278465860869`, 
    0.6063763483828833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {0.5628929014012727, -0.16555673570625667`, 
    0.596004248542524}, {0.560676306835095, -0.15171241243773156`, 
    0.5936572660606888}, {0.6081719439707838, -0.1845016009799007, 
    0.615005336599669}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5628929014012727, -0.16555673570625667`, 
    0.596004248542524}, {0.5060163098682655, -0.12650407746706638`, 
    0.5692683486017988}, {0.5152602653744724, -0.12086351903845649`, 
    0.572511405971636}, {0.560676306835095, -0.15171241243773156`, 
    0.5936572660606888}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5060163098682655, -0.12650407746706638`, 
    0.5692683486017988}, {0.45198686524397114`, -0.09039737304879422, 
    0.5423842382927654}, {0.4716982811963126, -0.09188927555772322, 
    0.5513356533463394}, {0.5152602653744724, -0.12086351903845649`, 
    0.572511405971636}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.45198686524397114`, -0.09039737304879422, 
    0.5423842382927654}, {0.49876346636093416`, -0.06234543329511677, 
    0.5611088996560509}, {0.5094822152479099, -0.06918894281144455, 
    0.5660913502754555}, {0.4716982811963126, -0.09188927555772322, 
    0.5513356533463394}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49876346636093416`, -0.06234543329511677, 
    0.5611088996560509}, {0.5487568617464034, -0.03227981539684726, 
    0.5810366771432506}, {0.5493362280674016, -0.04523945407613895, 
    0.5816501238360723}, {0.5094822152479099, -0.06918894281144455, 
    0.5660913502754555}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5487568617464034, -0.03227981539684726, 
    0.5810366771432506}, {0.6020420732135735, 0., 0.6020420732135735}, {
    0.5913037838451686, -0.01993158821950005, 0.597947646585002}, {
    0.5493362280674016, -0.04523945407613895, 0.5816501238360723}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.4756173846484537, -0.40767204398438894`, 
    0.6115080659765835}, {0.4872182513685714, -0.4185959624434205, 
    0.6176006003263582}, {0.41445824199145676`, -0.4013008374837915, 
    0.5920832028449382}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4756173846484537, -0.40767204398438894`, 
    0.6115080659765835}, {0.5739560409372104, -0.4304670307029078, 
    0.6457005460543618}, {0.5660318008824062, -0.43706252979527566`, 
    0.6448463554356526}, {0.4872182513685714, -0.4185959624434205, 
    0.6176006003263582}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5739560409372104, -0.4304670307029078, 
    0.6457005460543618}, {0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.6524642864965196, -0.4574749594975597, 
    0.6749630549963996}, {0.5660318008824062, -0.43706252979527566`, 
    0.6448463554356526}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.6409750644401281, -0.49015740221892146`, 
    0.6786794799954298}, {0.6187258872685492, -0.484544369547659, 
    0.670907588604451}, {0.6524642864965196, -0.4574749594975597, 
    0.6749630549963996}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6409750644401281, -0.49015740221892146`, 
    0.6786794799954298}, {0.6001728499508097, -0.5251512437069583, 
    0.6751944561946608}, {0.5866559059525488, -0.5123956646927323, 
    0.6683421713383466}, {0.6187258872685492, -0.484544369547659, 
    0.670907588604451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6001728499508097, -0.5251512437069583, 
    0.6751944561946608}, {0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {0.5560382810696715, -0.5412105935744802, 
    0.6672459372836057}, {0.5866559059525488, -0.5123956646927323, 
    0.6683421713383466}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {0.49871361404698694`, -0.49871361404698694`, 
    0.6412032180604118}, {0.5058735949853128, -0.4916236345631913, 
    0.641248218995467}, {0.5560382810696715, -0.5412105935744802, 
    0.6672459372836057}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49871361404698694`, -0.49871361404698694`, 
    0.6412032180604118}, {0.4407985310247471, -0.4407985310247471, 
    0.6103364275727268}, {0.4589425074132659, -0.4452427310725714, 
    0.6164899353312527}, {0.5058735949853128, -0.4916236345631913, 
    0.641248218995467}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4407985310247471, -0.4407985310247471, 
    0.6103364275727268}, {0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.41445824199145676`, -0.4013008374837915, 
    0.5920832028449382}, {0.4589425074132659, -0.4452427310725714, 
    0.6164899353312527}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.6409750644401281, -0.49015740221892146`, 
    0.6786794799954298}, {0.6468362024341406, -0.5098591242716168, 
    0.6848853908126196}, {0.6814262655051629, -0.48235791827893554`, 
    0.6890827403984794}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6409750644401281, -0.49015740221892146`, 
    0.6786794799954298}, {0.6001728499508097, -0.5251512437069583, 
    0.6751944561946608}, {0.6140163187056149, -0.5382118349147982, 
    0.68224035411735}, {0.6468362024341406, -0.5098591242716168, 
    0.6848853908126196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6001728499508097, -0.5251512437069583, 
    0.6751944561946608}, {0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {0.5827295292403942, -0.5675936973120723, 
    0.6811124367744867}, {0.6140163187056149, -0.5382118349147982, 
    0.68224035411735}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {0.6327645227143793, -0.6327645227143793, 
    0.7118600880536767}, {0.6407214117452011, -0.6249011299737146, 
    0.7119126797168901}, {0.5827295292403942, -0.5675936973120723, 
    0.6811124367744867}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6327645227143793, -0.6327645227143793, 
    0.7118600880536767}, {0.7198653019554957, -0.7198653019554957, 
    0.7622103197175837}, {0.7087220368790109, -0.6920462242465636, 
    0.7504115684601292}, {0.6407214117452011, -0.6249011299737146, 
    0.7119126797168901}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7198653019554957, -0.7198653019554957, 
    0.7622103197175837}, {0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {0.8014503466375957, -0.7834402264884363, 
    0.8104554067121754}, {0.7087220368790109, -0.6920462242465636, 
    0.7504115684601292}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {0.7640699024805022, -0.6791732466493353, 
    0.7640699024805022}, {0.7436741413969546, -0.6601152491051621, 
    0.7520300306261339}, {0.8014503466375957, -0.7834402264884363, 
    0.8104554067121754}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7640699024805022, -0.6791732466493353, 
    0.7640699024805022}, {0.7171888530767329, -0.5578135523930144, 
    0.7171888530767329}, {0.7082077892481158, -0.5649747532204069, 
    0.716165180138544}, {0.7436741413969546, -0.6601152491051621, 
    0.7520300306261339}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7171888530767329, -0.5578135523930144, 
    0.7171888530767329}, {0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {0.6814262655051629, -0.48235791827893554`, 
    0.6890827403984794}, {0.7082077892481158, -0.5649747532204069, 
    0.716165180138544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {-0.005171109167864868, 
    0.005171109167864868, 0.07756663751797302}, {-0.008765155746547347, 
    0.013921129715104607`, 0.11600941429253843`}, {-0.0012873487674722039`, 
    0.0038620463024166113`, 0.05793069453624921}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.005171109167864868, 0.005171109167864868, 
    0.07756663751797302}, {-0.020411420737374928`, 0.020411420737374928`, 
    0.15308565553031198`}, {-0.022480327811811928`, 0.030232164988298796`, 
    0.1744163364709546}, {-0.008765155746547347, 0.013921129715104607`, 
    0.11600941429253843`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.020411420737374928`, 0.020411420737374928`, 
    0.15308565553031198`}, {-0.04495902221896904, 0.04495902221896904, 
    0.22479511109484523`}, {-0.04202978289190042, 0.052280949450900525`, 
    0.23065124757750236`}, {-0.022480327811811928`, 0.030232164988298796`, 
    0.1744163364709546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.04495902221896904, 0.04495902221896904, 
    0.22479511109484523`}, {-0.07771364461602205, 0.07771364461602205, 
    0.2914261673100827}, {-0.0668487308419404, 0.07946169892532537, 
    0.2837917818761621}, {-0.04202978289190042, 0.052280949450900525`, 
    0.23065124757750236`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07771364461602205, 0.07771364461602205, 
    0.2914261673100827}, {-0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {-0.09630795334285219, 0.11112456154944483`, 
    0.3333736846483345}, {-0.0668487308419404, 0.07946169892532537, 
    0.2837917818761621}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {-0.09546533160684004, 0.14319799741026004`, 
    0.3579949935256501}, {-0.08026080379573056, 0.131748866608086, 
    0.3407298274347052}, {-0.09630795334285219, 0.11112456154944483`, 
    0.3333736846483345}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09546533160684004, 0.14319799741026004`, 
    0.3579949935256501}, {-0.07483045886349166, 0.1746044040148139, 
    0.37415229431745833`}, {-0.06473499852717923, 0.1563113379070913, 
    0.35525304069793484`}, {-0.08026080379573056, 0.131748866608086, 
    0.3407298274347052}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07483045886349166, 0.1746044040148139, 
    0.37415229431745833`}, {-0.05311638731862741, 0.21246554927450964`, 
    0.3983729048897056}, {-0.04838919502195432, 0.18521381542885962`, 
    0.3754334096530939}, {-0.06473499852717923, 0.1563113379070913, 
    0.35525304069793484`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.05311638731862741, 0.21246554927450964`, 
    0.3983729048897056}, {-0.028521062476874796`, 0.2566895622918732, 
    0.42781593715312194`}, {-0.030189136362876293`, 0.21842728074316375`, 
    0.39956209892042155`}, {-0.04838919502195432, 0.18521381542885962`, 
    0.3754334096530939}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.028521062476874796`, 0.2566895622918732, 
    0.42781593715312194`}, {0., 0.3066580952458096, 
    0.45998714286871445`}, {-0.009468363199652228, 0.2556458063906103, 
    0.4260763439843505}, {-0.030189136362876293`, 0.21842728074316375`, 
    0.39956209892042155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.3066580952458096, 0.45998714286871445`}, {0., 
    0.20749339485230253`, 0.38905011534806727`}, {-0.008131042914707278, 
    0.18050915270650167`, 0.36589693116182775`}, {-0.009468363199652228, 
    0.2556458063906103, 0.4260763439843505}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.20749339485230253`, 0.38905011534806727`}, {
    0., 0.1226952100911925, 0.30673802522798127`}, {-0.006628516589374509, 
    0.11533618865511652`, 0.2982832465218531}, {-0.008131042914707278, 
    0.18050915270650167`, 0.36589693116182775`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.1226952100911925, 0.30673802522798127`}, {0., 
    0.05675323239297665, 0.21282462147366246`}, {-0.004963354542040988, 
    0.06253826722971649, 0.22335095439184463`}, {-0.006628516589374509, 
    0.11533618865511652`, 0.2982832465218531}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0., 0.05675323239297665, 0.21282462147366246`}, {
    0., 0.014560811715990765`, 0.10920608786993075`}, {-0.003160550910532909, 
    0.0246522971021567, 0.142224790973981}, {-0.004963354542040988, 
    0.06253826722971649, 0.22335095439184463`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.014560811715990765`, 0.10920608786993075`}, {
    0., 0., 0.}, {-0.0012873487674722039`, 0.0038620463024166113`, 
    0.05793069453624921}, {-0.003160550910532909, 0.0246522971021567, 
    0.142224790973981}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.3066580952458096, 
    0.45998714286871445`}, {-0.06219340349207609, 0.31096701746038047`, 
    0.46645052619057076`}, {-0.07978930111077105, 0.29665252977081547`, 
    0.46032289102367924`}, {-0.03004186805503801, 0.29040472453203425`, 
    0.45062802082557046`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06219340349207609, 0.31096701746038047`, 
    0.46645052619057076`}, {-0.12923159990300587`, 0.3230789997575147, 
    0.48461849963627207`}, {-0.13366765457769086`, 0.30764777640897106`, 
    0.4773844806346103}, {-0.07978930111077105, 0.29665252977081547`, 
    0.46032289102367924`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.12923159990300587`, 0.3230789997575147, 
    0.48461849963627207`}, {-0.20461481167731652`, 0.3410246861288609, 
    0.5115370291932914}, {-0.19333151383599093`, 0.32221918972665153`, 
    0.4999952944034249}, {-0.13366765457769086`, 0.30764777640897106`, 
    0.4773844806346103}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20461481167731652`, 0.3410246861288609, 
    0.5115370291932914}, {-0.29013399227834397`, 0.36266749034792994`, 
    0.5440012355218949}, {-0.25965194503259137`, 0.3391849732407725, 
    0.5263215102011988}, {-0.19333151383599093`, 0.32221918972665153`, 
    0.4999952944034249}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.29013399227834397`, 0.36266749034792994`, 
    0.5440012355218949}, {-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.3329657494680982, 0.3576298790583277, 
    0.5549429157801637}, {-0.25965194503259137`, 0.3391849732407725, 
    0.5263215102011988}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.3251055239962821, 0.3251055239962821, 
    0.5418425399938036}, {-0.2862137017352461, 0.30948310838038806`, 
    0.5235616495156941}, {-0.3329657494680982, 0.3576298790583277, 
    0.5549429157801637}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3251055239962821, 0.3251055239962821, 
    0.5418425399938036}, {-0.2673132787288768, 0.2673132787288768, 
    0.501212397616644}, {-0.24176935360143517`, 0.2635503764484113, 
    0.49007301405696324`}, {-0.2862137017352461, 0.30948310838038806`, 
    0.5235616495156941}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2673132787288768, 0.2673132787288768, 
    0.501212397616644}, {-0.21311308081691155`, 0.21311308081691155`, 
    0.4566708874648105}, {-0.19972264378740437`, 0.2198966482103745, 
    0.4539150995168281}, {-0.24176935360143517`, 0.2635503764484113, 
    0.49007301405696324`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21311308081691155`, 0.21311308081691155`, 
    0.4566708874648105}, {-0.1629042820200325, 0.1629042820200325, 
    0.4072607050500812}, {-0.1603207616432846, 0.1787484353953863, 
    0.4146226594222878}, {-0.19972264378740437`, 0.2198966482103745, 
    0.4539150995168281}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1629042820200325, 0.1629042820200325, 
    0.4072607050500812}, {-0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {-0.12394767411382335`, 0.1404740306623331, 
    0.37184302234147004`}, {-0.1603207616432846, 0.1787484353953863, 
    0.4146226594222878}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {-0.09546533160684004, 0.14319799741026004`, 
    0.3579949935256501}, {-0.10580644230106709`, 0.16290833179688105`, 
    0.37788015107523965`}, {-0.12394767411382335`, 0.1404740306623331, 
    0.37184302234147004`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09546533160684004, 0.14319799741026004`, 
    0.3579949935256501}, {-0.07483045886349166, 0.1746044040148139, 
    0.37415229431745833`}, {-0.08838155995073098, 0.18889392224764073`, 
    0.38991864684146027`}, {-0.10580644230106709`, 0.16290833179688105`, 
    0.37788015107523965`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07483045886349166, 0.1746044040148139, 
    0.37415229431745833`}, {-0.05311638731862741, 0.21246554927450964`, 
    0.3983729048897056}, {-0.07052824422808539, 0.2188183987589316, 
    0.40689371670049274`}, {-0.08838155995073098, 0.18889392224764073`, 
    0.38991864684146027`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.05311638731862741, 0.21246554927450964`, 
    0.3983729048897056}, {-0.028521062476874796`, 0.2566895622918732, 
    0.42781593715312194`}, {-0.05130464075001894, 0.2527228599908341, 
    0.4275386729168246}, {-0.07052824422808539, 0.2188183987589316, 
    0.40689371670049274`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.028521062476874796`, 0.2566895622918732, 
    0.42781593715312194`}, {0., 0.3066580952458096, 
    0.45998714286871445`}, {-0.03004186805503801, 0.29040472453203425`, 
    0.45062802082557046`}, {-0.05130464075001894, 0.2527228599908341, 
    0.4275386729168246}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {0., 0.014560811715990765`, 
    0.10920608786993075`}, {0.003160550910532909, 0.0246522971021567, 
    0.142224790973981}, {0.0012873487674722039`, 0.0038620463024166113`, 
    0.05793069453624921}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.014560811715990765`, 0.10920608786993075`}, {
    0., 0.05675323239297665, 0.21282462147366246`}, {0.004963354542040988, 
    0.06253826722971648, 0.22335095439184463`}, {0.003160550910532909, 
    0.0246522971021567, 0.142224790973981}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.05675323239297665, 0.21282462147366246`}, {0.,
     0.1226952100911925, 0.30673802522798127`}, {0.006628516589374509, 
    0.11533618865511652`, 0.2982832465218531}, {0.004963354542040988, 
    0.06253826722971648, 0.22335095439184463`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.1226952100911925, 0.30673802522798127`}, {0., 
    0.20749339485230253`, 0.38905011534806727`}, {0.008131042914707278, 
    0.18050915270650167`, 0.36589693116182775`}, {0.006628516589374509, 
    0.11533618865511652`, 0.2982832465218531}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0., 0.20749339485230253`, 0.38905011534806727`}, {
    0., 0.3066580952458096, 0.45998714286871445`}, {0.009468363199652228, 
    0.2556458063906103, 0.4260763439843505}, {0.008131042914707278, 
    0.18050915270650167`, 0.36589693116182775`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.3066580952458096, 0.45998714286871445`}, {
    0.028521062476874796`, 0.2566895622918732, 0.42781593715312194`}, {
    0.030189136362876293`, 0.21842728074316375`, 0.39956209892042155`}, {
    0.009468363199652228, 0.2556458063906103, 0.4260763439843505}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.028521062476874796`, 0.2566895622918732, 
    0.42781593715312194`}, {0.05311638731862741, 0.21246554927450964`, 
    0.3983729048897056}, {0.04838919502195432, 0.18521381542885962`, 
    0.3754334096530939}, {0.030189136362876293`, 0.21842728074316375`, 
    0.39956209892042155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.05311638731862741, 0.21246554927450964`, 
    0.3983729048897056}, {0.07483045886349166, 0.1746044040148139, 
    0.37415229431745833`}, {0.06473499852717923, 0.1563113379070913, 
    0.35525304069793484`}, {0.04838919502195432, 0.18521381542885962`, 
    0.3754334096530939}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07483045886349166, 0.1746044040148139, 
    0.37415229431745833`}, {0.09546533160684004, 0.14319799741026004`, 
    0.3579949935256501}, {0.08026080379573056, 0.131748866608086, 
    0.3407298274347052}, {0.06473499852717923, 0.1563113379070913, 
    0.35525304069793484`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.09546533160684004, 0.14319799741026004`, 
    0.3579949935256501}, {0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {0.09630795334285219, 0.11112456154944483`, 
    0.3333736846483345}, {0.08026080379573056, 0.131748866608086, 
    0.3407298274347052}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {0.07771364461602205, 0.07771364461602205, 
    0.2914261673100827}, {0.0668487308419404, 0.07946169892532537, 
    0.2837917818761621}, {0.09630795334285219, 0.11112456154944483`, 
    0.3333736846483345}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07771364461602205, 0.07771364461602205, 
    0.2914261673100827}, {0.04495902221896904, 0.04495902221896904, 
    0.22479511109484523`}, {0.04202978289190042, 0.052280949450900525`, 
    0.23065124757750236`}, {0.0668487308419404, 0.07946169892532537, 
    0.2837917818761621}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.04495902221896904, 0.04495902221896904, 
    0.22479511109484523`}, {0.020411420737374928`, 0.020411420737374928`, 
    0.15308565553031198`}, {0.022480327811811928`, 0.030232164988298796`, 
    0.1744163364709546}, {0.04202978289190042, 0.052280949450900525`, 
    0.23065124757750236`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.020411420737374928`, 0.020411420737374928`, 
    0.15308565553031198`}, {0.005171109167864868, 0.005171109167864868, 
    0.07756663751797302}, {0.008765155746547347, 0.013921129715104607`, 
    0.11600941429253843`}, {0.022480327811811928`, 0.030232164988298796`, 
    0.1744163364709546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.005171109167864868, 0.005171109167864868, 
    0.07756663751797302}, {0., 0., 0.}, {0.0012873487674722039`, 
    0.0038620463024166113`, 0.05793069453624921}, {0.008765155746547347, 
    0.013921129715104607`, 0.11600941429253843`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.3066580952458096, 0.45998714286871445`}, {
    0.028521062476874796`, 0.2566895622918732, 0.42781593715312194`}, {
    0.05130464075001894, 0.2527228599908341, 0.4275386729168246}, {
    0.03004186805503801, 0.29040472453203425`, 0.45062802082557046`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.028521062476874796`, 0.2566895622918732, 
    0.42781593715312194`}, {0.05311638731862741, 0.21246554927450964`, 
    0.3983729048897056}, {0.07052824422808539, 0.2188183987589316, 
    0.40689371670049274`}, {0.05130464075001894, 0.2527228599908341, 
    0.4275386729168246}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.05311638731862741, 0.21246554927450964`, 
    0.3983729048897056}, {0.07483045886349166, 0.1746044040148139, 
    0.37415229431745833`}, {0.08838155995073098, 0.18889392224764073`, 
    0.38991864684146027`}, {0.07052824422808539, 0.2188183987589316, 
    0.40689371670049274`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07483045886349166, 0.1746044040148139, 
    0.37415229431745833`}, {0.09546533160684004, 0.14319799741026004`, 
    0.3579949935256501}, {0.10580644230106709`, 0.16290833179688105`, 
    0.37788015107523965`}, {0.08838155995073098, 0.18889392224764073`, 
    0.38991864684146027`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.09546533160684004, 0.14319799741026004`, 
    0.3579949935256501}, {0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {0.12394767411382335`, 0.1404740306623331, 
    0.37184302234147004`}, {0.10580644230106709`, 0.16290833179688105`, 
    0.37788015107523965`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {0.1629042820200325, 0.1629042820200325, 
    0.4072607050500812}, {0.1603207616432846, 0.1787484353953863, 
    0.4146226594222878}, {0.12394767411382335`, 0.1404740306623331, 
    0.37184302234147004`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1629042820200325, 0.1629042820200325, 
    0.4072607050500812}, {0.21311308081691155`, 0.21311308081691155`, 
    0.4566708874648105}, {0.19972264378740437`, 0.2198966482103745, 
    0.4539150995168281}, {0.1603207616432846, 0.1787484353953863, 
    0.4146226594222878}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21311308081691155`, 0.21311308081691155`, 
    0.4566708874648105}, {0.2673132787288768, 0.2673132787288768, 
    0.501212397616644}, {0.24176935360143517`, 0.2635503764484113, 
    0.49007301405696324`}, {0.19972264378740437`, 0.2198966482103745, 
    0.4539150995168281}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2673132787288768, 0.2673132787288768, 
    0.501212397616644}, {0.3251055239962821, 0.3251055239962821, 
    0.5418425399938036}, {0.2862137017352461, 0.30948310838038806`, 
    0.5235616495156941}, {0.24176935360143517`, 0.2635503764484113, 
    0.49007301405696324`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3251055239962821, 0.3251055239962821, 
    0.5418425399938036}, {0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.3329657494680982, 0.3576298790583277, 
    0.5549429157801637}, {0.2862137017352461, 0.30948310838038806`, 
    0.5235616495156941}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.29013399227834397`, 0.36266749034792994`, 
    0.5440012355218949}, {0.25965194503259137`, 0.3391849732407725, 
    0.5263215102011988}, {0.3329657494680982, 0.3576298790583277, 
    0.5549429157801637}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.29013399227834397`, 0.36266749034792994`, 
    0.5440012355218949}, {0.20461481167731652`, 0.3410246861288609, 
    0.5115370291932914}, {0.19333151383599093`, 0.32221918972665153`, 
    0.4999952944034249}, {0.25965194503259137`, 0.3391849732407725, 
    0.5263215102011988}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20461481167731652`, 0.3410246861288609, 
    0.5115370291932914}, {0.12923159990300587`, 0.3230789997575147, 
    0.48461849963627207`}, {0.1336676545776909, 0.30764777640897106`, 
    0.4773844806346103}, {0.19333151383599093`, 0.32221918972665153`, 
    0.4999952944034249}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.12923159990300587`, 0.3230789997575147, 
    0.48461849963627207`}, {0.06219340349207609, 0.31096701746038047`, 
    0.46645052619057076`}, {0.07978930111077105, 0.29665252977081547`, 
    0.46032289102367924`}, {0.1336676545776909, 0.30764777640897106`, 
    0.4773844806346103}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.06219340349207609, 0.31096701746038047`, 
    0.46645052619057076`}, {0., 0.3066580952458096, 0.45998714286871445`}, {
    0.03004186805503801, 0.29040472453203425`, 0.45062802082557046`}, {
    0.07978930111077105, 0.29665252977081547`, 0.46032289102367924`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.4407985310247471, 0.4407985310247471, 
    0.6103364275727268}, {-0.4452427310725714, 0.4589425074132659, 
    0.6164899353312527}, {-0.4013008374837915, 0.41445824199145676`, 
    0.5920832028449382}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4407985310247471, 0.4407985310247471, 
    0.6103364275727268}, {-0.49871361404698694`, 0.49871361404698694`, 
    0.6412032180604118}, {-0.4916236345631913, 0.5058735949853128, 
    0.641248218995467}, {-0.4452427310725714, 0.4589425074132659, 
    0.6164899353312527}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49871361404698694`, 0.49871361404698694`, 
    0.6412032180604118}, {-0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {-0.5412105935744802, 0.5560382810696715, 
    0.6672459372836057}, {-0.4916236345631913, 0.5058735949853128, 
    0.641248218995467}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {-0.5251512437069583, 0.6001728499508097, 
    0.6751944561946608}, {-0.5123956646927323, 0.5866559059525488, 
    0.6683421713383466}, {-0.5412105935744802, 0.5560382810696715, 
    0.6672459372836057}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5251512437069583, 0.6001728499508097, 
    0.6751944561946608}, {-0.49015740221892146`, 0.6409750644401281, 
    0.6786794799954298}, {-0.484544369547659, 0.6187258872685492, 
    0.670907588604451}, {-0.5123956646927323, 0.5866559059525488, 
    0.6683421713383466}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49015740221892146`, 0.6409750644401281, 
    0.6786794799954298}, {-0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {-0.4574749594975597, 0.6524642864965196, 
    0.6749630549963996}, {-0.484544369547659, 0.6187258872685492, 
    0.670907588604451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {-0.4304670307029078, 0.5739560409372104, 
    0.6457005460543618}, {-0.43706252979527566`, 0.5660318008824062, 
    0.6448463554356526}, {-0.4574749594975597, 0.6524642864965196, 
    0.6749630549963996}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4304670307029078, 0.5739560409372104, 
    0.6457005460543618}, {-0.40767204398438894`, 0.4756173846484537, 
    0.6115080659765835}, {-0.4185959624434205, 0.4872182513685714, 
    0.6176006003263582}, {-0.43706252979527566`, 0.5660318008824062, 
    0.6448463554356526}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.40767204398438894`, 0.4756173846484537, 
    0.6115080659765835}, {-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.4013008374837915, 0.41445824199145676`, 
    0.5920832028449382}, {-0.4185959624434205, 0.4872182513685714, 
    0.6176006003263582}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {-0.5578135523930144, 0.7171888530767329, 
    0.7171888530767329}, {-0.5649747532204069, 0.7082077892481158, 
    0.716165180138544}, {-0.48235791827893554`, 0.6814262655051629, 
    0.6890827403984794}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5578135523930144, 0.7171888530767329, 
    0.7171888530767329}, {-0.6791732466493353, 0.7640699024805022, 
    0.7640699024805022}, {-0.6601152491051621, 0.7436741413969546, 
    0.7520300306261339}, {-0.5649747532204069, 0.7082077892481158, 
    0.716165180138544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6791732466493353, 0.7640699024805022, 
    0.7640699024805022}, {-0.9068996821171088, 0.9068996821171088, 
    0.9068996821171088}, {-0.7834402264884363, 0.8014503466375957, 
    0.8104554067121754}, {-0.6601152491051621, 0.7436741413969546, 
    0.7520300306261339}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.9068996821171088, 0.9068996821171088, 
    0.9068996821171088}, {-0.7198653019554957, 0.7198653019554957, 
    0.7622103197175837}, {-0.6920462242465636, 0.7087220368790109, 
    0.7504115684601292}, {-0.7834402264884363, 0.8014503466375957, 
    0.8104554067121754}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7198653019554957, 0.7198653019554957, 
    0.7622103197175837}, {-0.6327645227143793, 0.6327645227143793, 
    0.7118600880536767}, {-0.6249011299737146, 0.6407214117452011, 
    0.7119126797168901}, {-0.6920462242465636, 0.7087220368790109, 
    0.7504115684601292}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6327645227143793, 0.6327645227143793, 
    0.7118600880536767}, {-0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {-0.5675936973120723, 0.5827295292403942, 
    0.6811124367744867}, {-0.6249011299737146, 0.6407214117452011, 
    0.7119126797168901}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {-0.5251512437069583, 0.6001728499508097, 
    0.6751944561946608}, {-0.5382118349147982, 0.6140163187056149, 
    0.68224035411735}, {-0.5675936973120723, 0.5827295292403942, 
    0.6811124367744867}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5251512437069583, 0.6001728499508097, 
    0.6751944561946608}, {-0.49015740221892146`, 0.6409750644401281, 
    0.6786794799954298}, {-0.5098591242716168, 0.6468362024341406, 
    0.6848853908126196}, {-0.5382118349147982, 0.6140163187056149, 
    0.68224035411735}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49015740221892146`, 0.6409750644401281, 
    0.6786794799954298}, {-0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {-0.48235791827893554`, 0.6814262655051629, 
    0.6890827403984794}, {-0.5098591242716168, 0.6468362024341406, 
    0.6848853908126196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.3066580952458096, 
    0.45998714286871445`}, {-0.038544848628222717`, 0.30835878902578173`, 
    0.46253818353867265`}, {-0.052786379282336135`, 0.3272755515504841, 
    0.47507741354102534`}, {-0.020955630116874954`, 0.324812266811562, 
    0.47150167762968676`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.038544848628222717`, 0.30835878902578173`, 
    0.46253818353867265`}, {-0.07833195316248512, 0.3133278126499405, 
    0.46999171897491077`}, {-0.0856080262124847, 0.33173110157337826`, 
    0.48154514744522653`}, {-0.052786379282336135`, 0.3272755515504841, 
    0.47507741354102534`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07833195316248512, 0.3133278126499405, 
    0.46999171897491077`}, {-0.12044994043743079`, 0.32119984116648215`, 
    0.4817997617497233}, {-0.11992963743797559`, 0.3379835236888404, 
    0.4906212440644457}, {-0.0856080262124847, 0.33173110157337826`, 
    0.48154514744522653`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.12044994043743079`, 0.32119984116648215`, 
    0.4817997617497233}, {-0.1657318525960958, 0.3314637051921916, 
    0.4971955577882874}, {-0.1561613637329016, 0.3457858768371393, 
    0.5019472405700409}, {-0.11992963743797559`, 0.3379835236888404, 
    0.4906212440644457}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1657318525960958, 0.3314637051921916, 
    0.4971955577882874}, {-0.17673575244858597`, 0.3976554430093185, 
    0.5302072573457579}, {-0.16447360317195706`, 0.3994358934176101, 
    0.5286651530527192}, {-0.1561613637329016, 0.3457858768371393, 
    0.5019472405700409}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.17673575244858597`, 0.3976554430093185, 
    0.5302072573457579}, {-0.18726648266764945`, 0.4681662066691236, 
    0.5617994480029483}, {-0.17247195529467113`, 0.4558187389930595, 
    0.5543741420185859}, {-0.16447360317195706`, 0.3994358934176101, 
    0.5286651530527192}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.18726648266764945`, 0.4681662066691236, 
    0.5617994480029483}, {-0.19749453248903248`, 0.5431099643448393, 
    0.5924835974670974}, {-0.18023995030369647`, 0.5149712865819899, 
    0.5793426974047388}, {-0.17247195529467113`, 0.4558187389930595, 
    0.5543741420185859}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.19749453248903248`, 0.5431099643448393, 
    0.5924835974670974}, {-0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {-0.18789655708653166`, 0.577110853908633, 
    0.6039532192067091}, {-0.18023995030369647`, 0.5149712865819899, 
    0.5793426974047388}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {-0.14565785306317142`, 0.5340787945649619, 
    0.5826314122526858}, {-0.13970138965108453`, 0.508005053276671, 
    0.571505684936255}, {-0.18789655708653166`, 0.577110853908633, 
    0.6039532192067091}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.14565785306317142`, 0.5340787945649619, 
    0.5826314122526858}, {-0.09039737304879422, 0.45198686524397114`, 
    0.5423842382927654}, {-0.09578808133406011, 0.4430198761700281, 
    0.5388079575040883}, {-0.13970138965108453`, 0.508005053276671, 
    0.571505684936255}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09039737304879422, 0.45198686524397114`, 
    0.5423842382927654}, {-0.041781498251368454`, 0.37603348426231603`, 
    0.5013779790164213}, {-0.05615961056021797, 0.3818853518094823, 
    0.5054364950419619}, {-0.09578808133406011, 0.4430198761700281, 
    0.5388079575040883}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.041781498251368454`, 0.37603348426231603`, 
    0.5013779790164213}, {0., 0.3066580952458096, 
    0.45998714286871445`}, {-0.020955630116874954`, 0.324812266811562, 
    0.47150167762968676`}, {-0.05615961056021797, 0.3818853518094823, 
    0.5054364950419619}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.3066580952458096, 
    0.45998714286871445`}, {-0.02708690739129757, 0.3521297960868685, 
    0.4875643330433564}, {-0.027651165009234, 0.37052561112373567`, 
    0.4977209701662121}, {-0.005290785729710824, 0.33331950097178215`, 
    0.47617071567397445`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.02708690739129757, 0.3521297960868685, 
    0.4875643330433564}, {-0.057237380507313335`, 0.4006616635511933, 
    0.5151364245658201}, {-0.05192776126127516, 0.4096523388389484, 
    0.5192776126127516}, {-0.027651165009234, 0.37052561112373567`, 
    0.4977209701662121}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.057237380507313335`, 0.4006616635511933, 
    0.5151364245658201}, {-0.09039737304879422, 0.45198686524397114`, 
    0.5423842382927654}, {-0.07810031047988147, 0.45057871430700847`, 
    0.5406944571684102}, {-0.05192776126127516, 0.4096523388389484, 
    0.5192776126127516}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09039737304879422, 0.45198686524397114`, 
    0.5423842382927654}, {-0.06234543329511677, 0.49876346636093416`, 
    0.5611088996560509}, {-0.055613276850190324`, 0.48816098568500393`, 
    0.5561327685019032}, {-0.07810031047988147, 0.45057871430700847`, 
    0.5406944571684102}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06234543329511677, 0.49876346636093416`, 
    0.5611088996560509}, {-0.03227981539684726, 0.5487568617464034, 
    0.5810366771432506}, {-0.03179444453423547, 0.5277877792683088, 
    0.5723000016162385}, {-0.055613276850190324`, 0.48816098568500393`, 
    0.5561327685019032}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.03227981539684726, 0.5487568617464034, 
    0.5810366771432506}, {0., 0.6020420732135735, 
    0.6020420732135735}, {-0.006545673176541602, 0.5694735663591197, 
    0.5891105858887445}, {-0.03179444453423547, 0.5277877792683088, 
    0.5723000016162385}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.6020420732135735, 0.6020420732135735}, {0., 
    0.49629010408701807`, 0.5583263670978953}, {-0.0061540114628666764`, 
    0.4861669055664678, 0.5538610316580013}, {-0.006545673176541602, 
    0.5694735663591197, 0.5891105858887445}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.49629010408701807`, 0.5583263670978953}, {0., 
    0.3979707523500161, 0.5116766815928779}, {-0.005739686383923255, 
    0.40751773325855134`, 0.5165717745530933}, {-0.0061540114628666764`, 
    0.4861669055664678, 0.5538610316580013}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.3979707523500161, 0.5116766815928779}, {0., 
    0.3066580952458096, 0.45998714286871445`}, {-0.005290785729710824, 
    0.33331950097178215`, 0.47617071567397445`}, {-0.005739686383923255, 
    0.40751773325855134`, 0.5165717745530933}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0., 0.6020420732135735, 
    0.6020420732135735}, {-0.06715883546475819, 0.6044295191828238, 
    0.6044295191828238}, {-0.0734128220308756, 0.5939764691589027, 
    0.6006503620708005}, {-0.01993158821950005, 0.5913037838451686, 
    0.597947646585002}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06715883546475819, 0.6044295191828238, 
    0.6044295191828238}, {-0.13589068132812965`, 0.6115080659765835, 
    0.6115080659765835}, {-0.12801278465860869`, 0.5996388334008513, 
    0.6063763483828833}, {-0.0734128220308756, 0.5939764691589027, 
    0.6006503620708005}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.13589068132812965`, 0.6115080659765835, 
    0.6115080659765835}, {-0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {-0.1845016009799007, 0.6081719439707838, 
    0.615005336599669}, {-0.12801278465860869`, 0.5996388334008513, 
    0.6063763483828833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {-0.16555673570625667`, 0.5628929014012727, 
    0.596004248542524}, {-0.15171241243773156`, 0.560676306835095, 
    0.5936572660606888}, {-0.1845016009799007, 0.6081719439707838, 
    0.615005336599669}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.16555673570625667`, 0.5628929014012727, 
    0.596004248542524}, {-0.12650407746706638`, 0.5060163098682655, 
    0.5692683486017988}, {-0.12086351903845649`, 0.5152602653744724, 
    0.572511405971636}, {-0.15171241243773156`, 0.560676306835095, 
    0.5936572660606888}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.12650407746706638`, 0.5060163098682655, 
    0.5692683486017988}, {-0.09039737304879422, 0.45198686524397114`, 
    0.5423842382927654}, {-0.09188927555772322, 0.4716982811963126, 
    0.5513356533463394}, {-0.12086351903845649`, 0.5152602653744724, 
    0.572511405971636}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09039737304879422, 0.45198686524397114`, 
    0.5423842382927654}, {-0.06234543329511677, 0.49876346636093416`, 
    0.5611088996560509}, {-0.06918894281144455, 0.5094822152479099, 
    0.5660913502754555}, {-0.09188927555772322, 0.4716982811963126, 
    0.5513356533463394}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06234543329511677, 0.49876346636093416`, 
    0.5611088996560509}, {-0.03227981539684726, 0.5487568617464034, 
    0.5810366771432506}, {-0.04523945407613895, 0.5493362280674016, 
    0.5816501238360723}, {-0.06918894281144455, 0.5094822152479099, 
    0.5660913502754555}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.03227981539684726, 0.5487568617464034, 
    0.5810366771432506}, {0., 0.6020420732135735, 
    0.6020420732135735}, {-0.01993158821950005, 0.5913037838451686, 
    0.597947646585002}, {-0.04523945407613895, 0.5493362280674016, 
    0.5816501238360723}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.32497414755462956`, 0.3713990257767195, 
    0.5570985386650793}, {-0.30930754461094684`, 0.3835413553175741, 
    0.5567535802997043}, {-0.35717979235010267`, 0.39544905581618517`, 
    0.5740389519912366}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.32497414755462956`, 0.3713990257767195, 
    0.5570985386650793}, {-0.26775615427580557`, 0.35700820570107417`, 
    0.5355123085516112}, {-0.26413196393268323`, 0.37218594917787184`, 
    0.540269926225943}, {-0.30930754461094684`, 0.3835413553175741, 
    0.5567535802997043}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.26775615427580557`, 0.35700820570107417`, 
    0.5355123085516112}, {-0.21472944721406304`, 0.34356711554250086`, 
    0.5153506733137513}, {-0.22157332212441513`, 0.3615143676766774, 
    0.5247789208209833}, {-0.26413196393268323`, 0.37218594917787184`, 
    0.540269926225943}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21472944721406304`, 0.34356711554250086`, 
    0.5153506733137513}, {-0.1657318525960958, 0.3314637051921916, 
    0.4971955577882874}, {-0.18153126854126964`, 0.35171683279870997`, 
    0.510556692772321}, {-0.22157332212441513`, 0.3615143676766774, 
    0.5247789208209833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1657318525960958, 0.3314637051921916, 
    0.4971955577882874}, {-0.17673575244858597`, 0.3976554430093185, 
    0.5302072573457579}, {-0.1906578017409655, 0.4051478286995518, 
    0.5362250673964656}, {-0.18153126854126964`, 0.35171683279870997`, 
    0.510556692772321}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.17673575244858597`, 0.3976554430093185, 
    0.5302072573457579}, {-0.18726648266764945`, 0.4681662066691236, 
    0.5617994480029483}, {-0.19950538654437358`, 0.461356206383864, 
    0.5611088996560508}, {-0.1906578017409655, 0.4051478286995518, 
    0.5362250673964656}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.18726648266764945`, 0.4681662066691236, 
    0.5617994480029483}, {-0.19749453248903248`, 0.5431099643448393, 
    0.5924835974670974}, {-0.20816159484924335`, 0.5204039871231084, 
    0.5854544855134971}, {-0.19950538654437358`, 0.461356206383864, 
    0.5611088996560508}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.19749453248903248`, 0.5431099643448393, 
    0.5924835974670974}, {-0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {-0.21675802958570295`, 0.5825372045115768, 
    0.6096319582097897}, {-0.20816159484924335`, 0.5204039871231084, 
    0.5854544855134971}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {-0.251969546341623, 0.5543330019515705, 
    0.6047269112198952}, {-0.2515845081118029, 0.5296515960248482, 
    0.5958580455279544}, {-0.21675802958570295`, 0.5825372045115768, 
    0.6096319582097897}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.251969546341623, 0.5543330019515705, 
    0.6047269112198952}, {-0.29554773118396116`, 0.4925795519732687, 
    0.5910954623679224}, {-0.2860742984158683, 0.4811249564266876, 
    0.585151974032458}, {-0.2515845081118029, 0.5296515960248482, 
    0.5958580455279544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.29554773118396116`, 0.4925795519732687, 
    0.5910954623679224}, {-0.3398683238140667, 0.43697355918951436`, 
    0.5826314122526858}, {-0.32099644718097237`, 0.4365551681661225, 
    0.5777936049257504}, {-0.2860742984158683, 0.4811249564266876, 
    0.585151974032458}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3398683238140667, 0.43697355918951436`, 
    0.5826314122526858}, {-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.35717979235010267`, 0.39544905581618517`, 
    0.5740389519912366}, {-0.32099644718097237`, 0.4365551681661225, 
    0.5777936049257504}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.3550779693653199, 0.41963760015901447`, 
    0.5810366771432508}, {-0.3591582529035913, 0.4375200535371022, 
    0.5877135047513313}, {-0.38422691935919384`, 0.41027620202761383`, 
    0.5861088600394483}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3550779693653199, 0.41963760015901447`, 
    0.5810366771432508}, {-0.32491619395345206`, 0.45488267153483286`, 
    0.5848491491162138}, {-0.33484194093648584`, 0.46615250600961755`, 
    0.5908975428290927}, {-0.3591582529035913, 0.4375200535371022, 
    0.5877135047513313}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.32491619395345206`, 0.45488267153483286`, 
    0.5848491491162138}, {-0.2955477311839612, 0.4925795519732687, 
    0.5910954623679224}, {-0.31104298811316416`, 0.49634519379760245`, 
    0.595614232557123}, {-0.33484194093648584`, 0.46615250600961755`, 
    0.5908975428290927}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2955477311839612, 0.4925795519732687, 
    0.5910954623679224}, {-0.34487850812687415`, 0.5518056130029987, 
    0.6207813146283735}, {-0.3510197768048997, 0.5437365170115114, 
    0.6194466649498231}, {-0.31104298811316416`, 0.49634519379760245`, 
    0.595614232557123}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.34487850812687415`, 0.5518056130029987, 
    0.6207813146283735}, {-0.39802947182437354`, 0.6151364564558499, 
    0.6513209538944295}, {-0.3934133114373311, 0.593696451805427, 
    0.643767236897451}, {-0.3510197768048997, 0.5437365170115114, 
    0.6194466649498231}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.39802947182437354`, 0.6151364564558499, 
    0.6513209538944295}, {-0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {-0.43885530547477725`, 0.6471256199373834, 
    0.6694402964869484}, {-0.3934133114373311, 0.593696451805427, 
    0.643767236897451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {-0.4304670307029078, 0.5739560409372104, 
    0.6457005460543618}, {-0.4191933748864658, 0.561292824000522, 
    0.639447521013253}, {-0.43885530547477725`, 0.6471256199373834, 
    0.6694402964869484}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4304670307029078, 0.5739560409372104, 
    0.6457005460543618}, {-0.40767204398438894`, 0.4756173846484537, 
    0.6115080659765835}, {-0.4012148338270782, 0.4828178508766534, 
    0.6120226278718142}, {-0.4191933748864658, 0.561292824000522, 
    0.639447521013253}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.40767204398438894`, 0.4756173846484537, 
    0.6115080659765835}, {-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.38422691935919384`, 0.41027620202761383`, 
    0.5861088600394483}, {-0.4012148338270782, 0.4828178508766534, 
    0.6120226278718142}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {-0.3662276185282054, 0.6592097133507697, 
    0.6592097133507697}, {-0.35549008961826795`, 0.6456860811433847, 
    0.6529409809315125}, {-0.42572323570788767`, 0.6647257540000352, 
    0.6721945826966648}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3662276185282054, 0.6592097133507697, 
    0.6592097133507697}, {-0.2839786944782409, 0.6389520625760421, 
    0.6389520625760421}, {-0.2900719574991448, 0.629668395546924, 
    0.6367433213395861}, {-0.35549008961826795`, 0.6456860811433847, 
    0.6529409809315125}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2839786944782409, 0.6389520625760421, 
    0.6389520625760421}, {-0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {-0.22854498053961364`, 0.6163788869098672, 
    0.6233044923807646}, {-0.2900719574991448, 0.629668395546924, 
    0.6367433213395861}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {-0.23735305516717142`, 0.5764288482631306, 
    0.6103364275727265}, {-0.25229999183570073`, 0.5796080893522855, 
    0.6137026828435964}, {-0.22854498053961364`, 0.6163788869098672, 
    0.6233044923807646}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.23735305516717142`, 0.5764288482631306, 
    0.6103364275727265}, {-0.2665063311720162, 0.5330126623440324, 
    0.5996392451370365}, {-0.2758060279446175, 0.5448850795979028, 
    0.605427866219892}, {-0.25229999183570073`, 0.5796080893522855, 
    0.6137026828435964}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2665063311720162, 0.5330126623440324, 
    0.5996392451370365}, {-0.2955477311839612, 0.4925795519732687, 
    0.5910954623679224}, {-0.29926426963948155`, 0.5120744169386685, 
    0.5985285392789631}, {-0.2758060279446175, 0.5448850795979028, 
    0.605427866219892}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2955477311839612, 0.4925795519732687, 
    0.5910954623679224}, {-0.34487850812687415`, 0.5518056130029987, 
    0.6207813146283735}, {-0.33875590314851456`, 0.5599842480618302, 
    0.6222047200687002}, {-0.29926426963948155`, 0.5120744169386685, 
    0.5985285392789631}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.34487850812687415`, 0.5518056130029987, 
    0.6207813146283735}, {-0.39802947182437354`, 0.6151364564558499, 
    0.6513209538944295}, {-0.3806959241330279, 0.6105500670057994, 
    0.6464647768296701}, {-0.33875590314851456`, 0.5599842480618302, 
    0.6222047200687002}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.39802947182437354`, 0.6151364564558499, 
    0.6513209538944295}, {-0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {-0.42572323570788767`, 0.6647257540000352, 
    0.6721945826966648}, {-0.3806959241330279, 0.6105500670057994, 
    0.6464647768296701}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.32497414755462956`, 0.3713990257767195, 
    0.5570985386650793}, {0.30930754461094684`, 0.3835413553175741, 
    0.5567535802997043}, {0.35717979235010267`, 0.39544905581618517`, 
    0.5740389519912366}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.32497414755462956`, 0.3713990257767195, 
    0.5570985386650793}, {0.26775615427580557`, 0.35700820570107417`, 
    0.5355123085516112}, {0.26413196393268323`, 0.37218594917787184`, 
    0.540269926225943}, {0.30930754461094684`, 0.3835413553175741, 
    0.5567535802997043}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.26775615427580557`, 0.35700820570107417`, 
    0.5355123085516112}, {0.21472944721406304`, 0.34356711554250086`, 
    0.5153506733137513}, {0.22157332212441513`, 0.3615143676766774, 
    0.5247789208209833}, {0.26413196393268323`, 0.37218594917787184`, 
    0.540269926225943}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21472944721406304`, 0.34356711554250086`, 
    0.5153506733137513}, {0.1657318525960958, 0.3314637051921916, 
    0.4971955577882874}, {0.18153126854126964`, 0.35171683279870997`, 
    0.510556692772321}, {0.22157332212441513`, 0.3615143676766774, 
    0.5247789208209833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1657318525960958, 0.3314637051921916, 
    0.4971955577882874}, {0.17673575244858597`, 0.3976554430093185, 
    0.5302072573457579}, {0.1906578017409655, 0.4051478286995518, 
    0.5362250673964656}, {0.18153126854126964`, 0.35171683279870997`, 
    0.510556692772321}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.17673575244858597`, 0.3976554430093185, 
    0.5302072573457579}, {0.18726648266764945`, 0.4681662066691236, 
    0.5617994480029483}, {0.19950538654437358`, 0.461356206383864, 
    0.5611088996560508}, {0.1906578017409655, 0.4051478286995518, 
    0.5362250673964656}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.18726648266764945`, 0.4681662066691236, 
    0.5617994480029483}, {0.19749453248903248`, 0.5431099643448393, 
    0.5924835974670974}, {0.20816159484924335`, 0.5204039871231084, 
    0.5854544855134971}, {0.19950538654437358`, 0.461356206383864, 
    0.5611088996560508}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.19749453248903248`, 0.5431099643448393, 
    0.5924835974670974}, {0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {0.21675802958570295`, 0.5825372045115768, 
    0.6096319582097897}, {0.20816159484924335`, 0.5204039871231084, 
    0.5854544855134971}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {0.251969546341623, 0.5543330019515705, 
    0.6047269112198952}, {0.2515845081118029, 0.5296515960248482, 
    0.5958580455279544}, {0.21675802958570295`, 0.5825372045115768, 
    0.6096319582097897}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.251969546341623, 0.5543330019515705, 
    0.6047269112198952}, {0.29554773118396116`, 0.4925795519732687, 
    0.5910954623679224}, {0.2860742984158683, 0.4811249564266876, 
    0.585151974032458}, {0.2515845081118029, 0.5296515960248482, 
    0.5958580455279544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.29554773118396116`, 0.4925795519732687, 
    0.5910954623679224}, {0.3398683238140667, 0.43697355918951436`, 
    0.5826314122526858}, {0.32099644718097237`, 0.4365551681661225, 
    0.5777936049257504}, {0.2860742984158683, 0.4811249564266876, 
    0.585151974032458}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3398683238140667, 0.43697355918951436`, 
    0.5826314122526858}, {0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.35717979235010267`, 0.39544905581618517`, 
    0.5740389519912366}, {0.32099644718097237`, 0.4365551681661225, 
    0.5777936049257504}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.3550779693653199, 0.41963760015901447`, 
    0.5810366771432508}, {0.3591582529035913, 0.4375200535371022, 
    0.5877135047513313}, {0.38422691935919384`, 0.41027620202761383`, 
    0.5861088600394483}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3550779693653199, 0.41963760015901447`, 
    0.5810366771432508}, {0.32491619395345206`, 0.45488267153483286`, 
    0.5848491491162138}, {0.33484194093648584`, 0.46615250600961755`, 
    0.5908975428290927}, {0.3591582529035913, 0.4375200535371022, 
    0.5877135047513313}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.32491619395345206`, 0.45488267153483286`, 
    0.5848491491162138}, {0.2955477311839612, 0.4925795519732687, 
    0.5910954623679224}, {0.31104298811316416`, 0.49634519379760245`, 
    0.595614232557123}, {0.33484194093648584`, 0.46615250600961755`, 
    0.5908975428290927}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2955477311839612, 0.4925795519732687, 
    0.5910954623679224}, {0.34487850812687415`, 0.5518056130029987, 
    0.6207813146283735}, {0.3510197768048997, 0.5437365170115114, 
    0.6194466649498231}, {0.31104298811316416`, 0.49634519379760245`, 
    0.595614232557123}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.34487850812687415`, 0.5518056130029987, 
    0.6207813146283735}, {0.39802947182437354`, 0.6151364564558499, 
    0.6513209538944295}, {0.3934133114373311, 0.593696451805427, 
    0.643767236897451}, {0.3510197768048997, 0.5437365170115114, 
    0.6194466649498231}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.39802947182437354`, 0.6151364564558499, 
    0.6513209538944295}, {0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {0.43885530547477725`, 0.6471256199373834, 
    0.6694402964869484}, {0.3934133114373311, 0.593696451805427, 
    0.643767236897451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {0.4304670307029078, 0.5739560409372104, 
    0.6457005460543618}, {0.4191933748864658, 0.561292824000522, 
    0.639447521013253}, {0.43885530547477725`, 0.6471256199373834, 
    0.6694402964869484}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4304670307029078, 0.5739560409372104, 
    0.6457005460543618}, {0.40767204398438894`, 0.4756173846484537, 
    0.6115080659765835}, {0.4012148338270782, 0.4828178508766534, 
    0.6120226278718142}, {0.4191933748864658, 0.561292824000522, 
    0.639447521013253}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.40767204398438894`, 0.4756173846484537, 
    0.6115080659765835}, {0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.38422691935919384`, 0.41027620202761383`, 
    0.5861088600394483}, {0.4012148338270782, 0.4828178508766534, 
    0.6120226278718142}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {0.3662276185282054, 0.6592097133507697, 
    0.6592097133507697}, {0.35549008961826795`, 0.6456860811433847, 
    0.6529409809315125}, {0.42572323570788767`, 0.6647257540000352, 
    0.6721945826966648}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3662276185282054, 0.6592097133507697, 
    0.6592097133507697}, {0.2839786944782409, 0.6389520625760421, 
    0.6389520625760421}, {0.2900719574991448, 0.629668395546924, 
    0.6367433213395861}, {0.35549008961826795`, 0.6456860811433847, 
    0.6529409809315125}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2839786944782409, 0.6389520625760421, 
    0.6389520625760421}, {0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {0.22854498053961364`, 0.6163788869098672, 
    0.6233044923807646}, {0.2900719574991448, 0.629668395546924, 
    0.6367433213395861}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {0.23735305516717142`, 0.5764288482631306, 
    0.6103364275727265}, {0.25229999183570073`, 0.5796080893522855, 
    0.6137026828435964}, {0.22854498053961364`, 0.6163788869098672, 
    0.6233044923807646}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.23735305516717142`, 0.5764288482631306, 
    0.6103364275727265}, {0.2665063311720162, 0.5330126623440324, 
    0.5996392451370365}, {0.2758060279446175, 0.5448850795979028, 
    0.605427866219892}, {0.25229999183570073`, 0.5796080893522855, 
    0.6137026828435964}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2665063311720162, 0.5330126623440324, 
    0.5996392451370365}, {0.2955477311839612, 0.4925795519732687, 
    0.5910954623679224}, {0.29926426963948155`, 0.5120744169386685, 
    0.5985285392789631}, {0.2758060279446175, 0.5448850795979028, 
    0.605427866219892}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2955477311839612, 0.4925795519732687, 
    0.5910954623679224}, {0.34487850812687415`, 0.5518056130029987, 
    0.6207813146283735}, {0.33875590314851456`, 0.5599842480618302, 
    0.6222047200687002}, {0.29926426963948155`, 0.5120744169386685, 
    0.5985285392789631}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.34487850812687415`, 0.5518056130029987, 
    0.6207813146283735}, {0.39802947182437354`, 0.6151364564558499, 
    0.6513209538944295}, {0.3806959241330279, 0.6105500670057994, 
    0.6464647768296701}, {0.33875590314851456`, 0.5599842480618302, 
    0.6222047200687002}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.39802947182437354`, 0.6151364564558499, 
    0.6513209538944295}, {0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {0.42572323570788767`, 0.6647257540000352, 
    0.6721945826966648}, {0.3806959241330279, 0.6105500670057994, 
    0.6464647768296701}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.3066580952458096, 0.45998714286871445`}, {
    0.038544848628222717`, 0.30835878902578173`, 0.46253818353867265`}, {
    0.052786379282336135`, 0.3272755515504841, 0.47507741354102534`}, {
    0.020955630116874954`, 0.324812266811562, 0.47150167762968676`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.038544848628222717`, 0.30835878902578173`, 
    0.46253818353867265`}, {0.07833195316248512, 0.3133278126499405, 
    0.46999171897491077`}, {0.0856080262124847, 0.33173110157337826`, 
    0.48154514744522653`}, {0.052786379282336135`, 0.3272755515504841, 
    0.47507741354102534`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07833195316248512, 0.3133278126499405, 
    0.46999171897491077`}, {0.12044994043743079`, 0.32119984116648215`, 
    0.4817997617497233}, {0.11992963743797559`, 0.3379835236888404, 
    0.4906212440644457}, {0.0856080262124847, 0.33173110157337826`, 
    0.48154514744522653`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.12044994043743079`, 0.32119984116648215`, 
    0.4817997617497233}, {0.1657318525960958, 0.3314637051921916, 
    0.4971955577882874}, {0.1561613637329016, 0.3457858768371393, 
    0.5019472405700409}, {0.11992963743797559`, 0.3379835236888404, 
    0.4906212440644457}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1657318525960958, 0.3314637051921916, 
    0.4971955577882874}, {0.17673575244858597`, 0.3976554430093185, 
    0.5302072573457579}, {0.16447360317195706`, 0.3994358934176101, 
    0.5286651530527192}, {0.1561613637329016, 0.3457858768371393, 
    0.5019472405700409}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.17673575244858597`, 0.3976554430093185, 
    0.5302072573457579}, {0.18726648266764945`, 0.4681662066691236, 
    0.5617994480029483}, {0.17247195529467113`, 0.4558187389930595, 
    0.5543741420185859}, {0.16447360317195706`, 0.3994358934176101, 
    0.5286651530527192}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.18726648266764945`, 0.4681662066691236, 
    0.5617994480029483}, {0.19749453248903248`, 0.5431099643448393, 
    0.5924835974670974}, {0.18023995030369647`, 0.5149712865819899, 
    0.5793426974047388}, {0.17247195529467113`, 0.4558187389930595, 
    0.5543741420185859}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.19749453248903248`, 0.5431099643448393, 
    0.5924835974670974}, {0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {0.18789655708653166`, 0.577110853908633, 
    0.6039532192067091}, {0.18023995030369647`, 0.5149712865819899, 
    0.5793426974047388}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {0.14565785306317142`, 0.5340787945649619, 
    0.5826314122526858}, {0.13970138965108453`, 0.508005053276671, 
    0.571505684936255}, {0.18789655708653166`, 0.577110853908633, 
    0.6039532192067091}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.14565785306317142`, 0.5340787945649619, 
    0.5826314122526858}, {0.09039737304879422, 0.45198686524397114`, 
    0.5423842382927654}, {0.09578808133406011, 0.4430198761700281, 
    0.5388079575040883}, {0.13970138965108453`, 0.508005053276671, 
    0.571505684936255}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.09039737304879422, 0.45198686524397114`, 
    0.5423842382927654}, {0.041781498251368454`, 0.37603348426231603`, 
    0.5013779790164213}, {0.05615961056021797, 0.3818853518094823, 
    0.5054364950419619}, {0.09578808133406011, 0.4430198761700281, 
    0.5388079575040883}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.041781498251368454`, 0.37603348426231603`, 
    0.5013779790164213}, {0., 0.3066580952458096, 0.45998714286871445`}, {
    0.020955630116874954`, 0.324812266811562, 0.47150167762968676`}, {
    0.05615961056021797, 0.3818853518094823, 0.5054364950419619}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.3066580952458096, 0.45998714286871445`}, {
    0.02708690739129757, 0.3521297960868685, 0.4875643330433564}, {
    0.027651165009234, 0.37052561112373567`, 0.4977209701662121}, {
    0.005290785729710824, 0.33331950097178215`, 0.47617071567397445`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.02708690739129757, 0.3521297960868685, 
    0.4875643330433564}, {0.057237380507313335`, 0.4006616635511933, 
    0.5151364245658201}, {0.05192776126127516, 0.4096523388389484, 
    0.5192776126127516}, {0.027651165009234, 0.37052561112373567`, 
    0.4977209701662121}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.057237380507313335`, 0.4006616635511933, 
    0.5151364245658201}, {0.09039737304879422, 0.45198686524397114`, 
    0.5423842382927654}, {0.07810031047988147, 0.45057871430700847`, 
    0.5406944571684102}, {0.05192776126127516, 0.4096523388389484, 
    0.5192776126127516}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.09039737304879422, 0.45198686524397114`, 
    0.5423842382927654}, {0.06234543329511677, 0.49876346636093416`, 
    0.5611088996560509}, {0.055613276850190324`, 0.48816098568500393`, 
    0.5561327685019032}, {0.07810031047988147, 0.45057871430700847`, 
    0.5406944571684102}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.06234543329511677, 0.49876346636093416`, 
    0.5611088996560509}, {0.03227981539684726, 0.5487568617464034, 
    0.5810366771432506}, {0.03179444453423547, 0.5277877792683088, 
    0.5723000016162385}, {0.055613276850190324`, 0.48816098568500393`, 
    0.5561327685019032}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.03227981539684726, 0.5487568617464034, 
    0.5810366771432506}, {0., 0.6020420732135735, 0.6020420732135735}, {
    0.006545673176541602, 0.5694735663591197, 0.5891105858887445}, {
    0.03179444453423547, 0.5277877792683088, 0.5723000016162385}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.6020420732135735, 0.6020420732135735}, {0., 
    0.49629010408701807`, 0.5583263670978953}, {0.0061540114628666764`, 
    0.4861669055664678, 0.5538610316580013}, {0.006545673176541602, 
    0.5694735663591197, 0.5891105858887445}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.49629010408701807`, 0.5583263670978953}, {0., 
    0.3979707523500161, 0.5116766815928779}, {0.005739686383923255, 
    0.40751773325855134`, 0.5165717745530933}, {0.0061540114628666764`, 
    0.4861669055664678, 0.5538610316580013}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0.3979707523500161, 0.5116766815928779}, {0., 
    0.3066580952458096, 0.45998714286871445`}, {0.005290785729710824, 
    0.33331950097178215`, 0.47617071567397445`}, {0.005739686383923255, 
    0.40751773325855134`, 0.5165717745530933}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0., 0.6020420732135735, 0.6020420732135735}, {
    0.06715883546475819, 0.6044295191828238, 0.6044295191828238}, {
    0.0734128220308756, 0.5939764691589027, 0.6006503620708005}, {
    0.01993158821950005, 0.5913037838451686, 0.597947646585002}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.06715883546475819, 0.6044295191828238, 
    0.6044295191828238}, {0.13589068132812965`, 0.6115080659765835, 
    0.6115080659765835}, {0.12801278465860869`, 0.5996388334008513, 
    0.6063763483828833}, {0.0734128220308756, 0.5939764691589027, 
    0.6006503620708005}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.13589068132812965`, 0.6115080659765835, 
    0.6115080659765835}, {0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {0.1845016009799007, 0.6081719439707838, 
    0.615005336599669}, {0.12801278465860869`, 0.5996388334008513, 
    0.6063763483828833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20769184264312943`, 0.6230755279293883, 
    0.6230755279293883}, {0.16555673570625667`, 0.5628929014012727, 
    0.596004248542524}, {0.15171241243773156`, 0.560676306835095, 
    0.5936572660606888}, {0.1845016009799007, 0.6081719439707838, 
    0.615005336599669}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.16555673570625667`, 0.5628929014012727, 
    0.596004248542524}, {0.12650407746706638`, 0.5060163098682655, 
    0.5692683486017988}, {0.12086351903845649`, 0.5152602653744724, 
    0.572511405971636}, {0.15171241243773156`, 0.560676306835095, 
    0.5936572660606888}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.12650407746706638`, 0.5060163098682655, 
    0.5692683486017988}, {0.09039737304879422, 0.45198686524397114`, 
    0.5423842382927654}, {0.09188927555772322, 0.4716982811963126, 
    0.5513356533463394}, {0.12086351903845649`, 0.5152602653744724, 
    0.572511405971636}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.09039737304879422, 0.45198686524397114`, 
    0.5423842382927654}, {0.06234543329511677, 0.49876346636093416`, 
    0.5611088996560509}, {0.06918894281144455, 0.5094822152479099, 
    0.5660913502754555}, {0.09188927555772322, 0.4716982811963126, 
    0.5513356533463394}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.06234543329511677, 0.49876346636093416`, 
    0.5611088996560509}, {0.03227981539684726, 0.5487568617464034, 
    0.5810366771432506}, {0.04523945407613895, 0.5493362280674016, 
    0.5816501238360723}, {0.06918894281144455, 0.5094822152479099, 
    0.5660913502754555}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.03227981539684726, 0.5487568617464034, 
    0.5810366771432506}, {0., 0.6020420732135735, 0.6020420732135735}, {
    0.01993158821950005, 0.5913037838451686, 0.597947646585002}, {
    0.04523945407613895, 0.5493362280674016, 0.5816501238360723}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.40767204398438894`, 0.4756173846484537, 
    0.6115080659765835}, {0.4185959624434205, 0.4872182513685714, 
    0.6176006003263582}, {0.4013008374837915, 0.41445824199145676`, 
    0.5920832028449382}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.40767204398438894`, 0.4756173846484537, 
    0.6115080659765835}, {0.4304670307029078, 0.5739560409372104, 
    0.6457005460543618}, {0.43706252979527566`, 0.5660318008824062, 
    0.6448463554356526}, {0.4185959624434205, 0.4872182513685714, 
    0.6176006003263582}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4304670307029078, 0.5739560409372104, 
    0.6457005460543618}, {0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {0.4574749594975597, 0.6524642864965196, 
    0.6749630549963996}, {0.43706252979527566`, 0.5660318008824062, 
    0.6448463554356526}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {0.49015740221892146`, 0.6409750644401281, 
    0.6786794799954298}, {0.484544369547659, 0.6187258872685492, 
    0.670907588604451}, {0.4574749594975597, 0.6524642864965196, 
    0.6749630549963996}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49015740221892146`, 0.6409750644401281, 
    0.6786794799954298}, {0.5251512437069583, 0.6001728499508097, 
    0.6751944561946608}, {0.5123956646927323, 0.5866559059525488, 
    0.6683421713383466}, {0.484544369547659, 0.6187258872685492, 
    0.670907588604451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5251512437069583, 0.6001728499508097, 
    0.6751944561946608}, {0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {0.5412105935744802, 0.5560382810696715, 
    0.6672459372836057}, {0.5123956646927323, 0.5866559059525488, 
    0.6683421713383466}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {0.49871361404698694`, 0.49871361404698694`, 
    0.6412032180604118}, {0.4916236345631913, 0.5058735949853128, 
    0.641248218995467}, {0.5412105935744802, 0.5560382810696715, 
    0.6672459372836057}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49871361404698694`, 0.49871361404698694`, 
    0.6412032180604118}, {0.4407985310247471, 0.4407985310247471, 
    0.6103364275727268}, {0.4452427310725714, 0.4589425074132659, 
    0.6164899353312527}, {0.4916236345631913, 0.5058735949853128, 
    0.641248218995467}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4407985310247471, 0.4407985310247471, 
    0.6103364275727268}, {0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {0.4013008374837915, 0.41445824199145676`, 
    0.5920832028449382}, {0.4452427310725714, 0.4589425074132659, 
    0.6164899353312527}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {0.49015740221892146`, 0.6409750644401281, 
    0.6786794799954298}, {0.5098591242716168, 0.6468362024341406, 
    0.6848853908126196}, {0.48235791827893554`, 0.6814262655051629, 
    0.6890827403984794}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49015740221892146`, 0.6409750644401281, 
    0.6786794799954298}, {0.5251512437069583, 0.6001728499508097, 
    0.6751944561946608}, {0.5382118349147982, 0.6140163187056149, 
    0.68224035411735}, {0.5098591242716168, 0.6468362024341406, 
    0.6848853908126196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5251512437069583, 0.6001728499508097, 
    0.6751944561946608}, {0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {0.5675936973120723, 0.5827295292403942, 
    0.6811124367744867}, {0.5382118349147982, 0.6140163187056149, 
    0.68224035411735}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {0.6327645227143793, 0.6327645227143793, 
    0.7118600880536767}, {0.6249011299737146, 0.6407214117452011, 
    0.7119126797168901}, {0.5675936973120723, 0.5827295292403942, 
    0.6811124367744867}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6327645227143793, 0.6327645227143793, 
    0.7118600880536767}, {0.7198653019554957, 0.7198653019554957, 
    0.7622103197175837}, {0.6920462242465636, 0.7087220368790109, 
    0.7504115684601292}, {0.6249011299737146, 0.6407214117452011, 
    0.7119126797168901}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7198653019554957, 0.7198653019554957, 
    0.7622103197175837}, {0.9068996821171088, 0.9068996821171088, 
    0.9068996821171088}, {0.7834402264884363, 0.8014503466375957, 
    0.8104554067121754}, {0.6920462242465636, 0.7087220368790109, 
    0.7504115684601292}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.9068996821171088, 0.9068996821171088, 
    0.9068996821171088}, {0.6791732466493353, 0.7640699024805022, 
    0.7640699024805022}, {0.6601152491051621, 0.7436741413969546, 
    0.7520300306261339}, {0.7834402264884363, 0.8014503466375957, 
    0.8104554067121754}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6791732466493353, 0.7640699024805022, 
    0.7640699024805022}, {0.5578135523930144, 0.7171888530767329, 
    0.7171888530767329}, {0.5649747532204069, 0.7082077892481158, 
    0.716165180138544}, {0.6601152491051621, 0.7436741413969546, 
    0.7520300306261339}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5578135523930144, 0.7171888530767329, 
    0.7171888530767329}, {0.4563691391047108, 0.6845537086570662, 
    0.6845537086570662}, {0.48235791827893554`, 0.6814262655051629, 
    0.6890827403984794}, {0.5649747532204069, 0.7082077892481158, 
    0.716165180138544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 
    0.}, {-0.005171109167864868, -0.005171109167864868, 
    0.07756663751797302}, {-0.013921129715104607`, -0.008765155746547347, 
    0.11600941429253843`}, {-0.0038620463024166113`, -0.0012873487674722039`, 
    0.05793069453624921}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.005171109167864868, -0.005171109167864868, 
    0.07756663751797302}, {-0.020411420737374928`, -0.020411420737374928`, 
    0.15308565553031198`}, {-0.030232164988298796`, -0.022480327811811928`, 
    0.1744163364709546}, {-0.013921129715104607`, -0.008765155746547347, 
    0.11600941429253843`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.020411420737374928`, -0.020411420737374928`, 
    0.15308565553031198`}, {-0.04495902221896904, -0.04495902221896904, 
    0.22479511109484523`}, {-0.052280949450900525`, -0.04202978289190042, 
    0.23065124757750236`}, {-0.030232164988298796`, -0.022480327811811928`, 
    0.1744163364709546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.04495902221896904, -0.04495902221896904, 
    0.22479511109484523`}, {-0.07771364461602205, -0.07771364461602205, 
    0.2914261673100827}, {-0.07946169892532537, -0.0668487308419404, 
    0.2837917818761621}, {-0.052280949450900525`, -0.04202978289190042, 
    0.23065124757750236`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07771364461602205, -0.07771364461602205, 
    0.2914261673100827}, {-0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {-0.11112456154944483`, -0.09630795334285219, 
    0.3333736846483345}, {-0.07946169892532537, -0.0668487308419404, 
    0.2837917818761621}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {-0.14319799741026004`, -0.09546533160684004, 
    0.3579949935256501}, {-0.131748866608086, -0.08026080379573056, 
    0.3407298274347052}, {-0.11112456154944483`, -0.09630795334285219, 
    0.3333736846483345}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.14319799741026004`, -0.09546533160684004, 
    0.3579949935256501}, {-0.1746044040148139, -0.07483045886349166, 
    0.37415229431745833`}, {-0.1563113379070913, -0.06473499852717923, 
    0.35525304069793484`}, {-0.131748866608086, -0.08026080379573056, 
    0.3407298274347052}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1746044040148139, -0.07483045886349166, 
    0.37415229431745833`}, {-0.21246554927450964`, -0.05311638731862741, 
    0.3983729048897056}, {-0.18521381542885962`, -0.04838919502195432, 
    0.3754334096530939}, {-0.1563113379070913, -0.06473499852717923, 
    0.35525304069793484`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21246554927450964`, -0.05311638731862741, 
    0.3983729048897056}, {-0.2566895622918732, -0.028521062476874796`, 
    0.42781593715312194`}, {-0.21842728074316375`, -0.030189136362876293`, 
    0.39956209892042155`}, {-0.18521381542885962`, -0.04838919502195432, 
    0.3754334096530939}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2566895622918732, -0.028521062476874796`, 
    0.42781593715312194`}, {-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.2556458063906103, -0.009468363199652228, 
    0.4260763439843505}, {-0.21842728074316375`, -0.030189136362876293`, 
    0.39956209892042155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.20749339485230253`, 0., 
    0.38905011534806727`}, {-0.18050915270650167`, -0.008131042914707278, 
    0.36589693116182775`}, {-0.2556458063906103, -0.009468363199652228, 
    0.4260763439843505}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20749339485230253`, 0., 
    0.38905011534806727`}, {-0.1226952100911925, 0., 
    0.30673802522798127`}, {-0.11533618865511652`, -0.006628516589374509, 
    0.2982832465218531}, {-0.18050915270650167`, -0.008131042914707278, 
    0.36589693116182775`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1226952100911925, 0., 
    0.30673802522798127`}, {-0.05675323239297665, 0., 
    0.21282462147366246`}, {-0.06253826722971649, -0.004963354542040988, 
    0.22335095439184463`}, {-0.11533618865511652`, -0.006628516589374509, 
    0.2982832465218531}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.05675323239297665, 0., 
    0.21282462147366246`}, {-0.014560811715990765`, 0., 
    0.10920608786993075`}, {-0.0246522971021567, -0.003160550910532909, 
    0.142224790973981}, {-0.06253826722971649, -0.004963354542040988, 
    0.22335095439184463`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.014560811715990765`, 0., 0.10920608786993075`}, {
    0., 0., 0.}, {-0.0038620463024166113`, -0.0012873487674722039`, 
    0.05793069453624921}, {-0.0246522971021567, -0.003160550910532909, 
    0.142224790973981}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.31096701746038047`, -0.06219340349207609, 
    0.46645052619057076`}, {-0.29665252977081547`, -0.07978930111077105, 
    0.46032289102367924`}, {-0.29040472453203425`, -0.03004186805503801, 
    0.45062802082557046`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.31096701746038047`, -0.06219340349207609, 
    0.46645052619057076`}, {-0.3230789997575147, -0.12923159990300587`, 
    0.48461849963627207`}, {-0.30764777640897106`, -0.13366765457769086`, 
    0.4773844806346103}, {-0.29665252977081547`, -0.07978930111077105, 
    0.46032289102367924`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3230789997575147, -0.12923159990300587`, 
    0.48461849963627207`}, {-0.3410246861288609, -0.20461481167731652`, 
    0.5115370291932914}, {-0.32221918972665153`, -0.19333151383599093`, 
    0.4999952944034249}, {-0.30764777640897106`, -0.13366765457769086`, 
    0.4773844806346103}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3410246861288609, -0.20461481167731652`, 
    0.5115370291932914}, {-0.36266749034792994`, -0.29013399227834397`, 
    0.5440012355218949}, {-0.3391849732407725, -0.25965194503259137`, 
    0.5263215102011988}, {-0.32221918972665153`, -0.19333151383599093`, 
    0.4999952944034249}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.36266749034792994`, -0.29013399227834397`, 
    0.5440012355218949}, {-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.3576298790583277, -0.3329657494680982, 
    0.5549429157801637}, {-0.3391849732407725, -0.25965194503259137`, 
    0.5263215102011988}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.3251055239962821, -0.3251055239962821, 
    0.5418425399938036}, {-0.30948310838038806`, -0.2862137017352461, 
    0.5235616495156941}, {-0.3576298790583277, -0.3329657494680982, 
    0.5549429157801637}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3251055239962821, -0.3251055239962821, 
    0.5418425399938036}, {-0.2673132787288768, -0.2673132787288768, 
    0.501212397616644}, {-0.2635503764484113, -0.24176935360143517`, 
    0.49007301405696324`}, {-0.30948310838038806`, -0.2862137017352461, 
    0.5235616495156941}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2673132787288768, -0.2673132787288768, 
    0.501212397616644}, {-0.21311308081691155`, -0.21311308081691155`, 
    0.4566708874648105}, {-0.2198966482103745, -0.19972264378740437`, 
    0.4539150995168281}, {-0.2635503764484113, -0.24176935360143517`, 
    0.49007301405696324`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21311308081691155`, -0.21311308081691155`, 
    0.4566708874648105}, {-0.1629042820200325, -0.1629042820200325, 
    0.4072607050500812}, {-0.1787484353953863, -0.1603207616432846, 
    0.4146226594222878}, {-0.2198966482103745, -0.19972264378740437`, 
    0.4539150995168281}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1629042820200325, -0.1629042820200325, 
    0.4072607050500812}, {-0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {-0.1404740306623331, -0.12394767411382335`, 
    0.37184302234147004`}, {-0.1787484353953863, -0.1603207616432846, 
    0.4146226594222878}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {-0.14319799741026004`, -0.09546533160684004, 
    0.3579949935256501}, {-0.16290833179688105`, -0.10580644230106709`, 
    0.37788015107523965`}, {-0.1404740306623331, -0.12394767411382335`, 
    0.37184302234147004`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.14319799741026004`, -0.09546533160684004, 
    0.3579949935256501}, {-0.1746044040148139, -0.07483045886349166, 
    0.37415229431745833`}, {-0.18889392224764073`, -0.08838155995073098, 
    0.38991864684146027`}, {-0.16290833179688105`, -0.10580644230106709`, 
    0.37788015107523965`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1746044040148139, -0.07483045886349166, 
    0.37415229431745833`}, {-0.21246554927450964`, -0.05311638731862741, 
    0.3983729048897056}, {-0.2188183987589316, -0.07052824422808539, 
    0.40689371670049274`}, {-0.18889392224764073`, -0.08838155995073098, 
    0.38991864684146027`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21246554927450964`, -0.05311638731862741, 
    0.3983729048897056}, {-0.2566895622918732, -0.028521062476874796`, 
    0.42781593715312194`}, {-0.2527228599908341, -0.05130464075001894, 
    0.4275386729168246}, {-0.2188183987589316, -0.07052824422808539, 
    0.40689371670049274`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2566895622918732, -0.028521062476874796`, 
    0.42781593715312194`}, {-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.29040472453203425`, -0.03004186805503801, 
    0.45062802082557046`}, {-0.2527228599908341, -0.05130464075001894, 
    0.4275386729168246}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {-0.014560811715990765`, 0., 
    0.10920608786993075`}, {-0.0246522971021567, 0.003160550910532909, 
    0.142224790973981}, {-0.0038620463024166113`, 0.0012873487674722039`, 
    0.05793069453624921}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.014560811715990765`, 0., 
    0.10920608786993075`}, {-0.05675323239297665, 0., 
    0.21282462147366246`}, {-0.06253826722971648, 0.004963354542040988, 
    0.22335095439184463`}, {-0.0246522971021567, 0.003160550910532909, 
    0.142224790973981}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.05675323239297665, 0., 
    0.21282462147366246`}, {-0.1226952100911925, 0., 
    0.30673802522798127`}, {-0.11533618865511652`, 0.006628516589374509, 
    0.2982832465218531}, {-0.06253826722971648, 0.004963354542040988, 
    0.22335095439184463`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1226952100911925, 0., 
    0.30673802522798127`}, {-0.20749339485230253`, 0., 
    0.38905011534806727`}, {-0.18050915270650167`, 0.008131042914707278, 
    0.36589693116182775`}, {-0.11533618865511652`, 0.006628516589374509, 
    0.2982832465218531}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20749339485230253`, 0., 
    0.38905011534806727`}, {-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.2556458063906103, 0.009468363199652228, 
    0.4260763439843505}, {-0.18050915270650167`, 0.008131042914707278, 
    0.36589693116182775`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.2566895622918732, 0.028521062476874796`, 
    0.42781593715312194`}, {-0.21842728074316375`, 0.030189136362876293`, 
    0.39956209892042155`}, {-0.2556458063906103, 0.009468363199652228, 
    0.4260763439843505}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2566895622918732, 0.028521062476874796`, 
    0.42781593715312194`}, {-0.21246554927450964`, 0.05311638731862741, 
    0.3983729048897056}, {-0.18521381542885962`, 0.04838919502195432, 
    0.3754334096530939}, {-0.21842728074316375`, 0.030189136362876293`, 
    0.39956209892042155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21246554927450964`, 0.05311638731862741, 
    0.3983729048897056}, {-0.1746044040148139, 0.07483045886349166, 
    0.37415229431745833`}, {-0.1563113379070913, 0.06473499852717923, 
    0.35525304069793484`}, {-0.18521381542885962`, 0.04838919502195432, 
    0.3754334096530939}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1746044040148139, 0.07483045886349166, 
    0.37415229431745833`}, {-0.14319799741026004`, 0.09546533160684004, 
    0.3579949935256501}, {-0.131748866608086, 0.08026080379573056, 
    0.3407298274347052}, {-0.1563113379070913, 0.06473499852717923, 
    0.35525304069793484`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.14319799741026004`, 0.09546533160684004, 
    0.3579949935256501}, {-0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {-0.11112456154944483`, 0.09630795334285219, 
    0.3333736846483345}, {-0.131748866608086, 0.08026080379573056, 
    0.3407298274347052}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {-0.07771364461602205, 0.07771364461602205, 
    0.2914261673100827}, {-0.07946169892532537, 0.0668487308419404, 
    0.2837917818761621}, {-0.11112456154944483`, 0.09630795334285219, 
    0.3333736846483345}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07771364461602205, 0.07771364461602205, 
    0.2914261673100827}, {-0.04495902221896904, 0.04495902221896904, 
    0.22479511109484523`}, {-0.052280949450900525`, 0.04202978289190042, 
    0.23065124757750236`}, {-0.07946169892532537, 0.0668487308419404, 
    0.2837917818761621}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.04495902221896904, 0.04495902221896904, 
    0.22479511109484523`}, {-0.020411420737374928`, 0.020411420737374928`, 
    0.15308565553031198`}, {-0.030232164988298796`, 0.022480327811811928`, 
    0.1744163364709546}, {-0.052280949450900525`, 0.04202978289190042, 
    0.23065124757750236`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.020411420737374928`, 0.020411420737374928`, 
    0.15308565553031198`}, {-0.005171109167864868, 0.005171109167864868, 
    0.07756663751797302}, {-0.013921129715104607`, 0.008765155746547347, 
    0.11600941429253843`}, {-0.030232164988298796`, 0.022480327811811928`, 
    0.1744163364709546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.005171109167864868, 0.005171109167864868, 
    0.07756663751797302}, {0., 0., 0.}, {-0.0038620463024166113`, 
    0.0012873487674722039`, 0.05793069453624921}, {-0.013921129715104607`, 
    0.008765155746547347, 0.11600941429253843`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.2566895622918732, 0.028521062476874796`, 
    0.42781593715312194`}, {-0.2527228599908341, 0.05130464075001894, 
    0.4275386729168246}, {-0.29040472453203425`, 0.03004186805503801, 
    0.45062802082557046`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2566895622918732, 0.028521062476874796`, 
    0.42781593715312194`}, {-0.21246554927450964`, 0.05311638731862741, 
    0.3983729048897056}, {-0.2188183987589316, 0.07052824422808539, 
    0.40689371670049274`}, {-0.2527228599908341, 0.05130464075001894, 
    0.4275386729168246}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21246554927450964`, 0.05311638731862741, 
    0.3983729048897056}, {-0.1746044040148139, 0.07483045886349166, 
    0.37415229431745833`}, {-0.18889392224764073`, 0.08838155995073098, 
    0.38991864684146027`}, {-0.2188183987589316, 0.07052824422808539, 
    0.40689371670049274`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1746044040148139, 0.07483045886349166, 
    0.37415229431745833`}, {-0.14319799741026004`, 0.09546533160684004, 
    0.3579949935256501}, {-0.16290833179688105`, 0.10580644230106709`, 
    0.37788015107523965`}, {-0.18889392224764073`, 0.08838155995073098, 
    0.38991864684146027`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.14319799741026004`, 0.09546533160684004, 
    0.3579949935256501}, {-0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {-0.1404740306623331, 0.12394767411382335`, 
    0.37184302234147004`}, {-0.16290833179688105`, 0.10580644230106709`, 
    0.37788015107523965`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, 0.11743040006038394`, 
    0.35229120018115184`}, {-0.1629042820200325, 0.1629042820200325, 
    0.4072607050500812}, {-0.1787484353953863, 0.1603207616432846, 
    0.4146226594222878}, {-0.1404740306623331, 0.12394767411382335`, 
    0.37184302234147004`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1629042820200325, 0.1629042820200325, 
    0.4072607050500812}, {-0.21311308081691155`, 0.21311308081691155`, 
    0.4566708874648105}, {-0.2198966482103745, 0.19972264378740437`, 
    0.4539150995168281}, {-0.1787484353953863, 0.1603207616432846, 
    0.4146226594222878}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21311308081691155`, 0.21311308081691155`, 
    0.4566708874648105}, {-0.2673132787288768, 0.2673132787288768, 
    0.501212397616644}, {-0.2635503764484113, 0.24176935360143517`, 
    0.49007301405696324`}, {-0.2198966482103745, 0.19972264378740437`, 
    0.4539150995168281}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2673132787288768, 0.2673132787288768, 
    0.501212397616644}, {-0.3251055239962821, 0.3251055239962821, 
    0.5418425399938036}, {-0.30948310838038806`, 0.2862137017352461, 
    0.5235616495156941}, {-0.2635503764484113, 0.24176935360143517`, 
    0.49007301405696324`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3251055239962821, 0.3251055239962821, 
    0.5418425399938036}, {-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.3576298790583277, 0.3329657494680982, 
    0.5549429157801637}, {-0.30948310838038806`, 0.2862137017352461, 
    0.5235616495156941}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.36266749034792994`, 0.29013399227834397`, 
    0.5440012355218949}, {-0.3391849732407725, 0.25965194503259137`, 
    0.5263215102011988}, {-0.3576298790583277, 0.3329657494680982, 
    0.5549429157801637}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.36266749034792994`, 0.29013399227834397`, 
    0.5440012355218949}, {-0.3410246861288609, 0.20461481167731652`, 
    0.5115370291932914}, {-0.32221918972665153`, 0.19333151383599093`, 
    0.4999952944034249}, {-0.3391849732407725, 0.25965194503259137`, 
    0.5263215102011988}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3410246861288609, 0.20461481167731652`, 
    0.5115370291932914}, {-0.3230789997575147, 0.12923159990300587`, 
    0.48461849963627207`}, {-0.30764777640897106`, 0.1336676545776909, 
    0.4773844806346103}, {-0.32221918972665153`, 0.19333151383599093`, 
    0.4999952944034249}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3230789997575147, 0.12923159990300587`, 
    0.48461849963627207`}, {-0.31096701746038047`, 0.06219340349207609, 
    0.46645052619057076`}, {-0.29665252977081547`, 0.07978930111077105, 
    0.46032289102367924`}, {-0.30764777640897106`, 0.1336676545776909, 
    0.4773844806346103}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.31096701746038047`, 0.06219340349207609, 
    0.46645052619057076`}, {-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.29040472453203425`, 0.03004186805503801, 
    0.45062802082557046`}, {-0.29665252977081547`, 0.07978930111077105, 
    0.46032289102367924`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.4407985310247471, -0.4407985310247471, 
    0.6103364275727268}, {-0.4589425074132659, -0.4452427310725714, 
    0.6164899353312527}, {-0.41445824199145676`, -0.4013008374837915, 
    0.5920832028449382}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4407985310247471, -0.4407985310247471, 
    0.6103364275727268}, {-0.49871361404698694`, -0.49871361404698694`, 
    0.6412032180604118}, {-0.5058735949853128, -0.4916236345631913, 
    0.641248218995467}, {-0.4589425074132659, -0.4452427310725714, 
    0.6164899353312527}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49871361404698694`, -0.49871361404698694`, 
    0.6412032180604118}, {-0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {-0.5560382810696715, -0.5412105935744802, 
    0.6672459372836057}, {-0.5058735949853128, -0.4916236345631913, 
    0.641248218995467}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {-0.6001728499508097, -0.5251512437069583, 
    0.6751944561946608}, {-0.5866559059525488, -0.5123956646927323, 
    0.6683421713383466}, {-0.5560382810696715, -0.5412105935744802, 
    0.6672459372836057}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6001728499508097, -0.5251512437069583, 
    0.6751944561946608}, {-0.6409750644401281, -0.49015740221892146`, 
    0.6786794799954298}, {-0.6187258872685492, -0.484544369547659, 
    0.670907588604451}, {-0.5866559059525488, -0.5123956646927323, 
    0.6683421713383466}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6409750644401281, -0.49015740221892146`, 
    0.6786794799954298}, {-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.6524642864965196, -0.4574749594975597, 
    0.6749630549963996}, {-0.6187258872685492, -0.484544369547659, 
    0.670907588604451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.5739560409372104, -0.4304670307029078, 
    0.6457005460543618}, {-0.5660318008824062, -0.43706252979527566`, 
    0.6448463554356526}, {-0.6524642864965196, -0.4574749594975597, 
    0.6749630549963996}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5739560409372104, -0.4304670307029078, 
    0.6457005460543618}, {-0.4756173846484537, -0.40767204398438894`, 
    0.6115080659765835}, {-0.4872182513685714, -0.4185959624434205, 
    0.6176006003263582}, {-0.5660318008824062, -0.43706252979527566`, 
    0.6448463554356526}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4756173846484537, -0.40767204398438894`, 
    0.6115080659765835}, {-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.41445824199145676`, -0.4013008374837915, 
    0.5920832028449382}, {-0.4872182513685714, -0.4185959624434205, 
    0.6176006003263582}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.7171888530767329, -0.5578135523930144, 
    0.7171888530767329}, {-0.7082077892481158, -0.5649747532204069, 
    0.716165180138544}, {-0.6814262655051629, -0.48235791827893554`, 
    0.6890827403984794}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7171888530767329, -0.5578135523930144, 
    0.7171888530767329}, {-0.7640699024805022, -0.6791732466493353, 
    0.7640699024805022}, {-0.7436741413969546, -0.6601152491051621, 
    0.7520300306261339}, {-0.7082077892481158, -0.5649747532204069, 
    0.716165180138544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7640699024805022, -0.6791732466493353, 
    0.7640699024805022}, {-0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {-0.8014503466375957, -0.7834402264884363, 
    0.8104554067121754}, {-0.7436741413969546, -0.6601152491051621, 
    0.7520300306261339}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {-0.7198653019554957, -0.7198653019554957, 
    0.7622103197175837}, {-0.7087220368790109, -0.6920462242465636, 
    0.7504115684601292}, {-0.8014503466375957, -0.7834402264884363, 
    0.8104554067121754}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7198653019554957, -0.7198653019554957, 
    0.7622103197175837}, {-0.6327645227143793, -0.6327645227143793, 
    0.7118600880536767}, {-0.6407214117452011, -0.6249011299737146, 
    0.7119126797168901}, {-0.7087220368790109, -0.6920462242465636, 
    0.7504115684601292}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6327645227143793, -0.6327645227143793, 
    0.7118600880536767}, {-0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {-0.5827295292403942, -0.5675936973120723, 
    0.6811124367744867}, {-0.6407214117452011, -0.6249011299737146, 
    0.7119126797168901}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {-0.6001728499508097, -0.5251512437069583, 
    0.6751944561946608}, {-0.6140163187056149, -0.5382118349147982, 
    0.68224035411735}, {-0.5827295292403942, -0.5675936973120723, 
    0.6811124367744867}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6001728499508097, -0.5251512437069583, 
    0.6751944561946608}, {-0.6409750644401281, -0.49015740221892146`, 
    0.6786794799954298}, {-0.6468362024341406, -0.5098591242716168, 
    0.6848853908126196}, {-0.6140163187056149, -0.5382118349147982, 
    0.68224035411735}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6409750644401281, -0.49015740221892146`, 
    0.6786794799954298}, {-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.6814262655051629, -0.48235791827893554`, 
    0.6890827403984794}, {-0.6468362024341406, -0.5098591242716168, 
    0.6848853908126196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.30835878902578173`, -0.038544848628222717`, 
    0.46253818353867265`}, {-0.3272755515504841, -0.052786379282336135`, 
    0.47507741354102534`}, {-0.324812266811562, -0.020955630116874954`, 
    0.47150167762968676`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.30835878902578173`, -0.038544848628222717`, 
    0.46253818353867265`}, {-0.3133278126499405, -0.07833195316248512, 
    0.46999171897491077`}, {-0.33173110157337826`, -0.0856080262124847, 
    0.48154514744522653`}, {-0.3272755515504841, -0.052786379282336135`, 
    0.47507741354102534`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3133278126499405, -0.07833195316248512, 
    0.46999171897491077`}, {-0.32119984116648215`, -0.12044994043743079`, 
    0.4817997617497233}, {-0.3379835236888404, -0.11992963743797559`, 
    0.4906212440644457}, {-0.33173110157337826`, -0.0856080262124847, 
    0.48154514744522653`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.32119984116648215`, -0.12044994043743079`, 
    0.4817997617497233}, {-0.3314637051921916, -0.1657318525960958, 
    0.4971955577882874}, {-0.3457858768371393, -0.1561613637329016, 
    0.5019472405700409}, {-0.3379835236888404, -0.11992963743797559`, 
    0.4906212440644457}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3314637051921916, -0.1657318525960958, 
    0.4971955577882874}, {-0.3976554430093185, -0.17673575244858597`, 
    0.5302072573457579}, {-0.3994358934176101, -0.16447360317195706`, 
    0.5286651530527192}, {-0.3457858768371393, -0.1561613637329016, 
    0.5019472405700409}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3976554430093185, -0.17673575244858597`, 
    0.5302072573457579}, {-0.4681662066691236, -0.18726648266764945`, 
    0.5617994480029483}, {-0.4558187389930595, -0.17247195529467113`, 
    0.5543741420185859}, {-0.3994358934176101, -0.16447360317195706`, 
    0.5286651530527192}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4681662066691236, -0.18726648266764945`, 
    0.5617994480029483}, {-0.5431099643448393, -0.19749453248903248`, 
    0.5924835974670974}, {-0.5149712865819899, -0.18023995030369647`, 
    0.5793426974047388}, {-0.4558187389930595, -0.17247195529467113`, 
    0.5543741420185859}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5431099643448393, -0.19749453248903248`, 
    0.5924835974670974}, {-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.577110853908633, -0.18789655708653166`, 
    0.6039532192067091}, {-0.5149712865819899, -0.18023995030369647`, 
    0.5793426974047388}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.5340787945649619, -0.14565785306317142`, 
    0.5826314122526858}, {-0.508005053276671, -0.13970138965108453`, 
    0.571505684936255}, {-0.577110853908633, -0.18789655708653166`, 
    0.6039532192067091}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5340787945649619, -0.14565785306317142`, 
    0.5826314122526858}, {-0.45198686524397114`, -0.09039737304879422, 
    0.5423842382927654}, {-0.4430198761700281, -0.09578808133406011, 
    0.5388079575040883}, {-0.508005053276671, -0.13970138965108453`, 
    0.571505684936255}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45198686524397114`, -0.09039737304879422, 
    0.5423842382927654}, {-0.37603348426231603`, -0.041781498251368454`, 
    0.5013779790164213}, {-0.3818853518094823, -0.05615961056021797, 
    0.5054364950419619}, {-0.4430198761700281, -0.09578808133406011, 
    0.5388079575040883}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.37603348426231603`, -0.041781498251368454`, 
    0.5013779790164213}, {-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.324812266811562, -0.020955630116874954`, 
    0.47150167762968676`}, {-0.3818853518094823, -0.05615961056021797, 
    0.5054364950419619}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.3521297960868685, -0.02708690739129757, 
    0.4875643330433564}, {-0.37052561112373567`, -0.027651165009234, 
    0.4977209701662121}, {-0.33331950097178215`, -0.005290785729710824, 
    0.47617071567397445`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3521297960868685, -0.02708690739129757, 
    0.4875643330433564}, {-0.4006616635511933, -0.057237380507313335`, 
    0.5151364245658201}, {-0.4096523388389484, -0.05192776126127516, 
    0.5192776126127516}, {-0.37052561112373567`, -0.027651165009234, 
    0.4977209701662121}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4006616635511933, -0.057237380507313335`, 
    0.5151364245658201}, {-0.45198686524397114`, -0.09039737304879422, 
    0.5423842382927654}, {-0.45057871430700847`, -0.07810031047988147, 
    0.5406944571684102}, {-0.4096523388389484, -0.05192776126127516, 
    0.5192776126127516}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45198686524397114`, -0.09039737304879422, 
    0.5423842382927654}, {-0.49876346636093416`, -0.06234543329511677, 
    0.5611088996560509}, {-0.48816098568500393`, -0.055613276850190324`, 
    0.5561327685019032}, {-0.45057871430700847`, -0.07810031047988147, 
    0.5406944571684102}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49876346636093416`, -0.06234543329511677, 
    0.5611088996560509}, {-0.5487568617464034, -0.03227981539684726, 
    0.5810366771432506}, {-0.5277877792683088, -0.03179444453423547, 
    0.5723000016162385}, {-0.48816098568500393`, -0.055613276850190324`, 
    0.5561327685019032}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5487568617464034, -0.03227981539684726, 
    0.5810366771432506}, {-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.5694735663591197, -0.006545673176541602, 
    0.5891105858887445}, {-0.5277877792683088, -0.03179444453423547, 
    0.5723000016162385}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.49629010408701807`, 0., 
    0.5583263670978953}, {-0.4861669055664678, -0.0061540114628666764`, 
    0.5538610316580013}, {-0.5694735663591197, -0.006545673176541602, 
    0.5891105858887445}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49629010408701807`, 0., 
    0.5583263670978953}, {-0.3979707523500161, 0., 
    0.5116766815928779}, {-0.40751773325855134`, -0.005739686383923255, 
    0.5165717745530933}, {-0.4861669055664678, -0.0061540114628666764`, 
    0.5538610316580013}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3979707523500161, 0., 
    0.5116766815928779}, {-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.33331950097178215`, -0.005290785729710824, 
    0.47617071567397445`}, {-0.40751773325855134`, -0.005739686383923255, 
    0.5165717745530933}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.6044295191828238, -0.06715883546475819, 
    0.6044295191828238}, {-0.5939764691589027, -0.0734128220308756, 
    0.6006503620708005}, {-0.5913037838451686, -0.01993158821950005, 
    0.597947646585002}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6044295191828238, -0.06715883546475819, 
    0.6044295191828238}, {-0.6115080659765835, -0.13589068132812965`, 
    0.6115080659765835}, {-0.5996388334008513, -0.12801278465860869`, 
    0.6063763483828833}, {-0.5939764691589027, -0.0734128220308756, 
    0.6006503620708005}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6115080659765835, -0.13589068132812965`, 
    0.6115080659765835}, {-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.6081719439707838, -0.1845016009799007, 
    0.615005336599669}, {-0.5996388334008513, -0.12801278465860869`, 
    0.6063763483828833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.5628929014012727, -0.16555673570625667`, 
    0.596004248542524}, {-0.560676306835095, -0.15171241243773156`, 
    0.5936572660606888}, {-0.6081719439707838, -0.1845016009799007, 
    0.615005336599669}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5628929014012727, -0.16555673570625667`, 
    0.596004248542524}, {-0.5060163098682655, -0.12650407746706638`, 
    0.5692683486017988}, {-0.5152602653744724, -0.12086351903845649`, 
    0.572511405971636}, {-0.560676306835095, -0.15171241243773156`, 
    0.5936572660606888}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5060163098682655, -0.12650407746706638`, 
    0.5692683486017988}, {-0.45198686524397114`, -0.09039737304879422, 
    0.5423842382927654}, {-0.4716982811963126, -0.09188927555772322, 
    0.5513356533463394}, {-0.5152602653744724, -0.12086351903845649`, 
    0.572511405971636}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45198686524397114`, -0.09039737304879422, 
    0.5423842382927654}, {-0.49876346636093416`, -0.06234543329511677, 
    0.5611088996560509}, {-0.5094822152479099, -0.06918894281144455, 
    0.5660913502754555}, {-0.4716982811963126, -0.09188927555772322, 
    0.5513356533463394}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49876346636093416`, -0.06234543329511677, 
    0.5611088996560509}, {-0.5487568617464034, -0.03227981539684726, 
    0.5810366771432506}, {-0.5493362280674016, -0.04523945407613895, 
    0.5816501238360723}, {-0.5094822152479099, -0.06918894281144455, 
    0.5660913502754555}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5487568617464034, -0.03227981539684726, 
    0.5810366771432506}, {-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.5913037838451686, -0.01993158821950005, 
    0.597947646585002}, {-0.5493362280674016, -0.04523945407613895, 
    0.5816501238360723}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.3713990257767195, -0.32497414755462956`, 
    0.5570985386650793}, {-0.3835413553175741, -0.30930754461094684`, 
    0.5567535802997043}, {-0.39544905581618517`, -0.35717979235010267`, 
    0.5740389519912366}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3713990257767195, -0.32497414755462956`, 
    0.5570985386650793}, {-0.35700820570107417`, -0.26775615427580557`, 
    0.5355123085516112}, {-0.37218594917787184`, -0.26413196393268323`, 
    0.540269926225943}, {-0.3835413553175741, -0.30930754461094684`, 
    0.5567535802997043}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.35700820570107417`, -0.26775615427580557`, 
    0.5355123085516112}, {-0.34356711554250086`, -0.21472944721406304`, 
    0.5153506733137513}, {-0.3615143676766774, -0.22157332212441513`, 
    0.5247789208209833}, {-0.37218594917787184`, -0.26413196393268323`, 
    0.540269926225943}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.34356711554250086`, -0.21472944721406304`, 
    0.5153506733137513}, {-0.3314637051921916, -0.1657318525960958, 
    0.4971955577882874}, {-0.35171683279870997`, -0.18153126854126964`, 
    0.510556692772321}, {-0.3615143676766774, -0.22157332212441513`, 
    0.5247789208209833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3314637051921916, -0.1657318525960958, 
    0.4971955577882874}, {-0.3976554430093185, -0.17673575244858597`, 
    0.5302072573457579}, {-0.4051478286995518, -0.1906578017409655, 
    0.5362250673964656}, {-0.35171683279870997`, -0.18153126854126964`, 
    0.510556692772321}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3976554430093185, -0.17673575244858597`, 
    0.5302072573457579}, {-0.4681662066691236, -0.18726648266764945`, 
    0.5617994480029483}, {-0.461356206383864, -0.19950538654437358`, 
    0.5611088996560508}, {-0.4051478286995518, -0.1906578017409655, 
    0.5362250673964656}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4681662066691236, -0.18726648266764945`, 
    0.5617994480029483}, {-0.5431099643448393, -0.19749453248903248`, 
    0.5924835974670974}, {-0.5204039871231084, -0.20816159484924335`, 
    0.5854544855134971}, {-0.461356206383864, -0.19950538654437358`, 
    0.5611088996560508}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5431099643448393, -0.19749453248903248`, 
    0.5924835974670974}, {-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.5825372045115768, -0.21675802958570295`, 
    0.6096319582097897}, {-0.5204039871231084, -0.20816159484924335`, 
    0.5854544855134971}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.5543330019515705, -0.251969546341623, 
    0.6047269112198952}, {-0.5296515960248482, -0.2515845081118029, 
    0.5958580455279544}, {-0.5825372045115768, -0.21675802958570295`, 
    0.6096319582097897}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5543330019515705, -0.251969546341623, 
    0.6047269112198952}, {-0.4925795519732687, -0.29554773118396116`, 
    0.5910954623679224}, {-0.4811249564266876, -0.2860742984158683, 
    0.585151974032458}, {-0.5296515960248482, -0.2515845081118029, 
    0.5958580455279544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4925795519732687, -0.29554773118396116`, 
    0.5910954623679224}, {-0.43697355918951436`, -0.3398683238140667, 
    0.5826314122526858}, {-0.4365551681661225, -0.32099644718097237`, 
    0.5777936049257504}, {-0.4811249564266876, -0.2860742984158683, 
    0.585151974032458}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.43697355918951436`, -0.3398683238140667, 
    0.5826314122526858}, {-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.39544905581618517`, -0.35717979235010267`, 
    0.5740389519912366}, {-0.4365551681661225, -0.32099644718097237`, 
    0.5777936049257504}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.41963760015901447`, -0.3550779693653199, 
    0.5810366771432508}, {-0.4375200535371022, -0.3591582529035913, 
    0.5877135047513313}, {-0.41027620202761383`, -0.38422691935919384`, 
    0.5861088600394483}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.41963760015901447`, -0.3550779693653199, 
    0.5810366771432508}, {-0.45488267153483286`, -0.32491619395345206`, 
    0.5848491491162138}, {-0.46615250600961755`, -0.33484194093648584`, 
    0.5908975428290927}, {-0.4375200535371022, -0.3591582529035913, 
    0.5877135047513313}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45488267153483286`, -0.32491619395345206`, 
    0.5848491491162138}, {-0.4925795519732687, -0.2955477311839612, 
    0.5910954623679224}, {-0.49634519379760245`, -0.31104298811316416`, 
    0.595614232557123}, {-0.46615250600961755`, -0.33484194093648584`, 
    0.5908975428290927}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4925795519732687, -0.2955477311839612, 
    0.5910954623679224}, {-0.5518056130029987, -0.34487850812687415`, 
    0.6207813146283735}, {-0.5437365170115114, -0.3510197768048997, 
    0.6194466649498231}, {-0.49634519379760245`, -0.31104298811316416`, 
    0.595614232557123}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5518056130029987, -0.34487850812687415`, 
    0.6207813146283735}, {-0.6151364564558499, -0.39802947182437354`, 
    0.6513209538944295}, {-0.593696451805427, -0.3934133114373311, 
    0.643767236897451}, {-0.5437365170115114, -0.3510197768048997, 
    0.6194466649498231}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6151364564558499, -0.39802947182437354`, 
    0.6513209538944295}, {-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.6471256199373834, -0.43885530547477725`, 
    0.6694402964869484}, {-0.593696451805427, -0.3934133114373311, 
    0.643767236897451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.5739560409372104, -0.4304670307029078, 
    0.6457005460543618}, {-0.561292824000522, -0.4191933748864658, 
    0.639447521013253}, {-0.6471256199373834, -0.43885530547477725`, 
    0.6694402964869484}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5739560409372104, -0.4304670307029078, 
    0.6457005460543618}, {-0.4756173846484537, -0.40767204398438894`, 
    0.6115080659765835}, {-0.4828178508766534, -0.4012148338270782, 
    0.6120226278718142}, {-0.561292824000522, -0.4191933748864658, 
    0.639447521013253}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4756173846484537, -0.40767204398438894`, 
    0.6115080659765835}, {-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.41027620202761383`, -0.38422691935919384`, 
    0.5861088600394483}, {-0.4828178508766534, -0.4012148338270782, 
    0.6120226278718142}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.6592097133507697, -0.3662276185282054, 
    0.6592097133507697}, {-0.6456860811433847, -0.35549008961826795`, 
    0.6529409809315125}, {-0.6647257540000352, -0.42572323570788767`, 
    0.6721945826966648}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6592097133507697, -0.3662276185282054, 
    0.6592097133507697}, {-0.6389520625760421, -0.2839786944782409, 
    0.6389520625760421}, {-0.629668395546924, -0.2900719574991448, 
    0.6367433213395861}, {-0.6456860811433847, -0.35549008961826795`, 
    0.6529409809315125}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6389520625760421, -0.2839786944782409, 
    0.6389520625760421}, {-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.6163788869098672, -0.22854498053961364`, 
    0.6233044923807646}, {-0.629668395546924, -0.2900719574991448, 
    0.6367433213395861}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.5764288482631306, -0.23735305516717142`, 
    0.6103364275727265}, {-0.5796080893522855, -0.25229999183570073`, 
    0.6137026828435964}, {-0.6163788869098672, -0.22854498053961364`, 
    0.6233044923807646}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5764288482631306, -0.23735305516717142`, 
    0.6103364275727265}, {-0.5330126623440324, -0.2665063311720162, 
    0.5996392451370365}, {-0.5448850795979028, -0.2758060279446175, 
    0.605427866219892}, {-0.5796080893522855, -0.25229999183570073`, 
    0.6137026828435964}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5330126623440324, -0.2665063311720162, 
    0.5996392451370365}, {-0.4925795519732687, -0.2955477311839612, 
    0.5910954623679224}, {-0.5120744169386685, -0.29926426963948155`, 
    0.5985285392789631}, {-0.5448850795979028, -0.2758060279446175, 
    0.605427866219892}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4925795519732687, -0.2955477311839612, 
    0.5910954623679224}, {-0.5518056130029987, -0.34487850812687415`, 
    0.6207813146283735}, {-0.5599842480618302, -0.33875590314851456`, 
    0.6222047200687002}, {-0.5120744169386685, -0.29926426963948155`, 
    0.5985285392789631}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5518056130029987, -0.34487850812687415`, 
    0.6207813146283735}, {-0.6151364564558499, -0.39802947182437354`, 
    0.6513209538944295}, {-0.6105500670057994, -0.3806959241330279, 
    0.6464647768296701}, {-0.5599842480618302, -0.33875590314851456`, 
    0.6222047200687002}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6151364564558499, -0.39802947182437354`, 
    0.6513209538944295}, {-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.6647257540000352, -0.42572323570788767`, 
    0.6721945826966648}, {-0.6105500670057994, -0.3806959241330279, 
    0.6464647768296701}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.3713990257767195, 0.32497414755462956`, 
    0.5570985386650793}, {-0.3835413553175741, 0.30930754461094684`, 
    0.5567535802997043}, {-0.39544905581618517`, 0.35717979235010267`, 
    0.5740389519912366}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3713990257767195, 0.32497414755462956`, 
    0.5570985386650793}, {-0.35700820570107417`, 0.26775615427580557`, 
    0.5355123085516112}, {-0.37218594917787184`, 0.26413196393268323`, 
    0.540269926225943}, {-0.3835413553175741, 0.30930754461094684`, 
    0.5567535802997043}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.35700820570107417`, 0.26775615427580557`, 
    0.5355123085516112}, {-0.34356711554250086`, 0.21472944721406304`, 
    0.5153506733137513}, {-0.3615143676766774, 0.22157332212441513`, 
    0.5247789208209833}, {-0.37218594917787184`, 0.26413196393268323`, 
    0.540269926225943}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.34356711554250086`, 0.21472944721406304`, 
    0.5153506733137513}, {-0.3314637051921916, 0.1657318525960958, 
    0.4971955577882874}, {-0.35171683279870997`, 0.18153126854126964`, 
    0.510556692772321}, {-0.3615143676766774, 0.22157332212441513`, 
    0.5247789208209833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3314637051921916, 0.1657318525960958, 
    0.4971955577882874}, {-0.3976554430093185, 0.17673575244858597`, 
    0.5302072573457579}, {-0.4051478286995518, 0.1906578017409655, 
    0.5362250673964656}, {-0.35171683279870997`, 0.18153126854126964`, 
    0.510556692772321}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3976554430093185, 0.17673575244858597`, 
    0.5302072573457579}, {-0.4681662066691236, 0.18726648266764945`, 
    0.5617994480029483}, {-0.461356206383864, 0.19950538654437358`, 
    0.5611088996560508}, {-0.4051478286995518, 0.1906578017409655, 
    0.5362250673964656}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4681662066691236, 0.18726648266764945`, 
    0.5617994480029483}, {-0.5431099643448393, 0.19749453248903248`, 
    0.5924835974670974}, {-0.5204039871231084, 0.20816159484924335`, 
    0.5854544855134971}, {-0.461356206383864, 0.19950538654437358`, 
    0.5611088996560508}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5431099643448393, 0.19749453248903248`, 
    0.5924835974670974}, {-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.5825372045115768, 0.21675802958570295`, 
    0.6096319582097897}, {-0.5204039871231084, 0.20816159484924335`, 
    0.5854544855134971}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.5543330019515705, 0.251969546341623, 
    0.6047269112198952}, {-0.5296515960248482, 0.2515845081118029, 
    0.5958580455279544}, {-0.5825372045115768, 0.21675802958570295`, 
    0.6096319582097897}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5543330019515705, 0.251969546341623, 
    0.6047269112198952}, {-0.4925795519732687, 0.29554773118396116`, 
    0.5910954623679224}, {-0.4811249564266876, 0.2860742984158683, 
    0.585151974032458}, {-0.5296515960248482, 0.2515845081118029, 
    0.5958580455279544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4925795519732687, 0.29554773118396116`, 
    0.5910954623679224}, {-0.43697355918951436`, 0.3398683238140667, 
    0.5826314122526858}, {-0.4365551681661225, 0.32099644718097237`, 
    0.5777936049257504}, {-0.4811249564266876, 0.2860742984158683, 
    0.585151974032458}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.43697355918951436`, 0.3398683238140667, 
    0.5826314122526858}, {-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.39544905581618517`, 0.35717979235010267`, 
    0.5740389519912366}, {-0.4365551681661225, 0.32099644718097237`, 
    0.5777936049257504}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.41963760015901447`, 0.3550779693653199, 
    0.5810366771432508}, {-0.4375200535371022, 0.3591582529035913, 
    0.5877135047513313}, {-0.41027620202761383`, 0.38422691935919384`, 
    0.5861088600394483}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.41963760015901447`, 0.3550779693653199, 
    0.5810366771432508}, {-0.45488267153483286`, 0.32491619395345206`, 
    0.5848491491162138}, {-0.46615250600961755`, 0.33484194093648584`, 
    0.5908975428290927}, {-0.4375200535371022, 0.3591582529035913, 
    0.5877135047513313}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45488267153483286`, 0.32491619395345206`, 
    0.5848491491162138}, {-0.4925795519732687, 0.2955477311839612, 
    0.5910954623679224}, {-0.49634519379760245`, 0.31104298811316416`, 
    0.595614232557123}, {-0.46615250600961755`, 0.33484194093648584`, 
    0.5908975428290927}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4925795519732687, 0.2955477311839612, 
    0.5910954623679224}, {-0.5518056130029987, 0.34487850812687415`, 
    0.6207813146283735}, {-0.5437365170115114, 0.3510197768048997, 
    0.6194466649498231}, {-0.49634519379760245`, 0.31104298811316416`, 
    0.595614232557123}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5518056130029987, 0.34487850812687415`, 
    0.6207813146283735}, {-0.6151364564558499, 0.39802947182437354`, 
    0.6513209538944295}, {-0.593696451805427, 0.3934133114373311, 
    0.643767236897451}, {-0.5437365170115114, 0.3510197768048997, 
    0.6194466649498231}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6151364564558499, 0.39802947182437354`, 
    0.6513209538944295}, {-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.6471256199373834, 0.43885530547477725`, 
    0.6694402964869484}, {-0.593696451805427, 0.3934133114373311, 
    0.643767236897451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.5739560409372104, 0.4304670307029078, 
    0.6457005460543618}, {-0.561292824000522, 0.4191933748864658, 
    0.639447521013253}, {-0.6471256199373834, 0.43885530547477725`, 
    0.6694402964869484}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5739560409372104, 0.4304670307029078, 
    0.6457005460543618}, {-0.4756173846484537, 0.40767204398438894`, 
    0.6115080659765835}, {-0.4828178508766534, 0.4012148338270782, 
    0.6120226278718142}, {-0.561292824000522, 0.4191933748864658, 
    0.639447521013253}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4756173846484537, 0.40767204398438894`, 
    0.6115080659765835}, {-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.41027620202761383`, 0.38422691935919384`, 
    0.5861088600394483}, {-0.4828178508766534, 0.4012148338270782, 
    0.6120226278718142}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.6592097133507697, 0.3662276185282054, 
    0.6592097133507697}, {-0.6456860811433847, 0.35549008961826795`, 
    0.6529409809315125}, {-0.6647257540000352, 0.42572323570788767`, 
    0.6721945826966648}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6592097133507697, 0.3662276185282054, 
    0.6592097133507697}, {-0.6389520625760421, 0.2839786944782409, 
    0.6389520625760421}, {-0.629668395546924, 0.2900719574991448, 
    0.6367433213395861}, {-0.6456860811433847, 0.35549008961826795`, 
    0.6529409809315125}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6389520625760421, 0.2839786944782409, 
    0.6389520625760421}, {-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.6163788869098672, 0.22854498053961364`, 
    0.6233044923807646}, {-0.629668395546924, 0.2900719574991448, 
    0.6367433213395861}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.5764288482631306, 0.23735305516717142`, 
    0.6103364275727265}, {-0.5796080893522855, 0.25229999183570073`, 
    0.6137026828435964}, {-0.6163788869098672, 0.22854498053961364`, 
    0.6233044923807646}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5764288482631306, 0.23735305516717142`, 
    0.6103364275727265}, {-0.5330126623440324, 0.2665063311720162, 
    0.5996392451370365}, {-0.5448850795979028, 0.2758060279446175, 
    0.605427866219892}, {-0.5796080893522855, 0.25229999183570073`, 
    0.6137026828435964}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5330126623440324, 0.2665063311720162, 
    0.5996392451370365}, {-0.4925795519732687, 0.2955477311839612, 
    0.5910954623679224}, {-0.5120744169386685, 0.29926426963948155`, 
    0.5985285392789631}, {-0.5448850795979028, 0.2758060279446175, 
    0.605427866219892}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4925795519732687, 0.2955477311839612, 
    0.5910954623679224}, {-0.5518056130029987, 0.34487850812687415`, 
    0.6207813146283735}, {-0.5599842480618302, 0.33875590314851456`, 
    0.6222047200687002}, {-0.5120744169386685, 0.29926426963948155`, 
    0.5985285392789631}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5518056130029987, 0.34487850812687415`, 
    0.6207813146283735}, {-0.6151364564558499, 0.39802947182437354`, 
    0.6513209538944295}, {-0.6105500670057994, 0.3806959241330279, 
    0.6464647768296701}, {-0.5599842480618302, 0.33875590314851456`, 
    0.6222047200687002}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6151364564558499, 0.39802947182437354`, 
    0.6513209538944295}, {-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.6647257540000352, 0.42572323570788767`, 
    0.6721945826966648}, {-0.6105500670057994, 0.3806959241330279, 
    0.6464647768296701}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.30835878902578173`, 0.038544848628222717`, 
    0.46253818353867265`}, {-0.3272755515504841, 0.052786379282336135`, 
    0.47507741354102534`}, {-0.324812266811562, 0.020955630116874954`, 
    0.47150167762968676`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.30835878902578173`, 0.038544848628222717`, 
    0.46253818353867265`}, {-0.3133278126499405, 0.07833195316248512, 
    0.46999171897491077`}, {-0.33173110157337826`, 0.0856080262124847, 
    0.48154514744522653`}, {-0.3272755515504841, 0.052786379282336135`, 
    0.47507741354102534`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3133278126499405, 0.07833195316248512, 
    0.46999171897491077`}, {-0.32119984116648215`, 0.12044994043743079`, 
    0.4817997617497233}, {-0.3379835236888404, 0.11992963743797559`, 
    0.4906212440644457}, {-0.33173110157337826`, 0.0856080262124847, 
    0.48154514744522653`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.32119984116648215`, 0.12044994043743079`, 
    0.4817997617497233}, {-0.3314637051921916, 0.1657318525960958, 
    0.4971955577882874}, {-0.3457858768371393, 0.1561613637329016, 
    0.5019472405700409}, {-0.3379835236888404, 0.11992963743797559`, 
    0.4906212440644457}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3314637051921916, 0.1657318525960958, 
    0.4971955577882874}, {-0.3976554430093185, 0.17673575244858597`, 
    0.5302072573457579}, {-0.3994358934176101, 0.16447360317195706`, 
    0.5286651530527192}, {-0.3457858768371393, 0.1561613637329016, 
    0.5019472405700409}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3976554430093185, 0.17673575244858597`, 
    0.5302072573457579}, {-0.4681662066691236, 0.18726648266764945`, 
    0.5617994480029483}, {-0.4558187389930595, 0.17247195529467113`, 
    0.5543741420185859}, {-0.3994358934176101, 0.16447360317195706`, 
    0.5286651530527192}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4681662066691236, 0.18726648266764945`, 
    0.5617994480029483}, {-0.5431099643448393, 0.19749453248903248`, 
    0.5924835974670974}, {-0.5149712865819899, 0.18023995030369647`, 
    0.5793426974047388}, {-0.4558187389930595, 0.17247195529467113`, 
    0.5543741420185859}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5431099643448393, 0.19749453248903248`, 
    0.5924835974670974}, {-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.577110853908633, 0.18789655708653166`, 
    0.6039532192067091}, {-0.5149712865819899, 0.18023995030369647`, 
    0.5793426974047388}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.5340787945649619, 0.14565785306317142`, 
    0.5826314122526858}, {-0.508005053276671, 0.13970138965108453`, 
    0.571505684936255}, {-0.577110853908633, 0.18789655708653166`, 
    0.6039532192067091}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5340787945649619, 0.14565785306317142`, 
    0.5826314122526858}, {-0.45198686524397114`, 0.09039737304879422, 
    0.5423842382927654}, {-0.4430198761700281, 0.09578808133406011, 
    0.5388079575040883}, {-0.508005053276671, 0.13970138965108453`, 
    0.571505684936255}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45198686524397114`, 0.09039737304879422, 
    0.5423842382927654}, {-0.37603348426231603`, 0.041781498251368454`, 
    0.5013779790164213}, {-0.3818853518094823, 0.05615961056021797, 
    0.5054364950419619}, {-0.4430198761700281, 0.09578808133406011, 
    0.5388079575040883}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.37603348426231603`, 0.041781498251368454`, 
    0.5013779790164213}, {-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.324812266811562, 0.020955630116874954`, 
    0.47150167762968676`}, {-0.3818853518094823, 0.05615961056021797, 
    0.5054364950419619}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.3521297960868685, 0.02708690739129757, 
    0.4875643330433564}, {-0.37052561112373567`, 0.027651165009234, 
    0.4977209701662121}, {-0.33331950097178215`, 0.005290785729710824, 
    0.47617071567397445`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3521297960868685, 0.02708690739129757, 
    0.4875643330433564}, {-0.4006616635511933, 0.057237380507313335`, 
    0.5151364245658201}, {-0.4096523388389484, 0.05192776126127516, 
    0.5192776126127516}, {-0.37052561112373567`, 0.027651165009234, 
    0.4977209701662121}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4006616635511933, 0.057237380507313335`, 
    0.5151364245658201}, {-0.45198686524397114`, 0.09039737304879422, 
    0.5423842382927654}, {-0.45057871430700847`, 0.07810031047988147, 
    0.5406944571684102}, {-0.4096523388389484, 0.05192776126127516, 
    0.5192776126127516}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45198686524397114`, 0.09039737304879422, 
    0.5423842382927654}, {-0.49876346636093416`, 0.06234543329511677, 
    0.5611088996560509}, {-0.48816098568500393`, 0.055613276850190324`, 
    0.5561327685019032}, {-0.45057871430700847`, 0.07810031047988147, 
    0.5406944571684102}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49876346636093416`, 0.06234543329511677, 
    0.5611088996560509}, {-0.5487568617464034, 0.03227981539684726, 
    0.5810366771432506}, {-0.5277877792683088, 0.03179444453423547, 
    0.5723000016162385}, {-0.48816098568500393`, 0.055613276850190324`, 
    0.5561327685019032}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5487568617464034, 0.03227981539684726, 
    0.5810366771432506}, {-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.5694735663591197, 0.006545673176541602, 
    0.5891105858887445}, {-0.5277877792683088, 0.03179444453423547, 
    0.5723000016162385}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.49629010408701807`, 0., 
    0.5583263670978953}, {-0.4861669055664678, 0.0061540114628666764`, 
    0.5538610316580013}, {-0.5694735663591197, 0.006545673176541602, 
    0.5891105858887445}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49629010408701807`, 0., 
    0.5583263670978953}, {-0.3979707523500161, 0., 
    0.5116766815928779}, {-0.40751773325855134`, 0.005739686383923255, 
    0.5165717745530933}, {-0.4861669055664678, 0.0061540114628666764`, 
    0.5538610316580013}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3979707523500161, 0., 
    0.5116766815928779}, {-0.3066580952458096, 0., 
    0.45998714286871445`}, {-0.33331950097178215`, 0.005290785729710824, 
    0.47617071567397445`}, {-0.40751773325855134`, 0.005739686383923255, 
    0.5165717745530933}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.6044295191828238, 0.06715883546475819, 
    0.6044295191828238}, {-0.5939764691589027, 0.0734128220308756, 
    0.6006503620708005}, {-0.5913037838451686, 0.01993158821950005, 
    0.597947646585002}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6044295191828238, 0.06715883546475819, 
    0.6044295191828238}, {-0.6115080659765835, 0.13589068132812965`, 
    0.6115080659765835}, {-0.5996388334008513, 0.12801278465860869`, 
    0.6063763483828833}, {-0.5939764691589027, 0.0734128220308756, 
    0.6006503620708005}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6115080659765835, 0.13589068132812965`, 
    0.6115080659765835}, {-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.6081719439707838, 0.1845016009799007, 
    0.615005336599669}, {-0.5996388334008513, 0.12801278465860869`, 
    0.6063763483828833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.5628929014012727, 0.16555673570625667`, 
    0.596004248542524}, {-0.560676306835095, 0.15171241243773156`, 
    0.5936572660606888}, {-0.6081719439707838, 0.1845016009799007, 
    0.615005336599669}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5628929014012727, 0.16555673570625667`, 
    0.596004248542524}, {-0.5060163098682655, 0.12650407746706638`, 
    0.5692683486017988}, {-0.5152602653744724, 0.12086351903845649`, 
    0.572511405971636}, {-0.560676306835095, 0.15171241243773156`, 
    0.5936572660606888}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5060163098682655, 0.12650407746706638`, 
    0.5692683486017988}, {-0.45198686524397114`, 0.09039737304879422, 
    0.5423842382927654}, {-0.4716982811963126, 0.09188927555772322, 
    0.5513356533463394}, {-0.5152602653744724, 0.12086351903845649`, 
    0.572511405971636}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45198686524397114`, 0.09039737304879422, 
    0.5423842382927654}, {-0.49876346636093416`, 0.06234543329511677, 
    0.5611088996560509}, {-0.5094822152479099, 0.06918894281144455, 
    0.5660913502754555}, {-0.4716982811963126, 0.09188927555772322, 
    0.5513356533463394}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49876346636093416`, 0.06234543329511677, 
    0.5611088996560509}, {-0.5487568617464034, 0.03227981539684726, 
    0.5810366771432506}, {-0.5493362280674016, 0.04523945407613895, 
    0.5816501238360723}, {-0.5094822152479099, 0.06918894281144455, 
    0.5660913502754555}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5487568617464034, 0.03227981539684726, 
    0.5810366771432506}, {-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.5913037838451686, 0.01993158821950005, 
    0.597947646585002}, {-0.5493362280674016, 0.04523945407613895, 
    0.5816501238360723}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.4756173846484537, 0.40767204398438894`, 
    0.6115080659765835}, {-0.4872182513685714, 0.4185959624434205, 
    0.6176006003263582}, {-0.41445824199145676`, 0.4013008374837915, 
    0.5920832028449382}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4756173846484537, 0.40767204398438894`, 
    0.6115080659765835}, {-0.5739560409372104, 0.4304670307029078, 
    0.6457005460543618}, {-0.5660318008824062, 0.43706252979527566`, 
    0.6448463554356526}, {-0.4872182513685714, 0.4185959624434205, 
    0.6176006003263582}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5739560409372104, 0.4304670307029078, 
    0.6457005460543618}, {-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.6524642864965196, 0.4574749594975597, 
    0.6749630549963996}, {-0.5660318008824062, 0.43706252979527566`, 
    0.6448463554356526}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.6409750644401281, 0.49015740221892146`, 
    0.6786794799954298}, {-0.6187258872685492, 0.484544369547659, 
    0.670907588604451}, {-0.6524642864965196, 0.4574749594975597, 
    0.6749630549963996}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6409750644401281, 0.49015740221892146`, 
    0.6786794799954298}, {-0.6001728499508097, 0.5251512437069583, 
    0.6751944561946608}, {-0.5866559059525488, 0.5123956646927323, 
    0.6683421713383466}, {-0.6187258872685492, 0.484544369547659, 
    0.670907588604451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6001728499508097, 0.5251512437069583, 
    0.6751944561946608}, {-0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {-0.5560382810696715, 0.5412105935744802, 
    0.6672459372836057}, {-0.5866559059525488, 0.5123956646927323, 
    0.6683421713383466}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {-0.49871361404698694`, 0.49871361404698694`, 
    0.6412032180604118}, {-0.5058735949853128, 0.4916236345631913, 
    0.641248218995467}, {-0.5560382810696715, 0.5412105935744802, 
    0.6672459372836057}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49871361404698694`, 0.49871361404698694`, 
    0.6412032180604118}, {-0.4407985310247471, 0.4407985310247471, 
    0.6103364275727268}, {-0.4589425074132659, 0.4452427310725714, 
    0.6164899353312527}, {-0.5058735949853128, 0.4916236345631913, 
    0.641248218995467}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4407985310247471, 0.4407985310247471, 
    0.6103364275727268}, {-0.38650287499487973`, 0.38650287499487973`, 
    0.5797543124923197}, {-0.41445824199145676`, 0.4013008374837915, 
    0.5920832028449382}, {-0.4589425074132659, 0.4452427310725714, 
    0.6164899353312527}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.6409750644401281, 0.49015740221892146`, 
    0.6786794799954298}, {-0.6468362024341406, 0.5098591242716168, 
    0.6848853908126196}, {-0.6814262655051629, 0.48235791827893554`, 
    0.6890827403984794}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6409750644401281, 0.49015740221892146`, 
    0.6786794799954298}, {-0.6001728499508097, 0.5251512437069583, 
    0.6751944561946608}, {-0.6140163187056149, 0.5382118349147982, 
    0.68224035411735}, {-0.6468362024341406, 0.5098591242716168, 
    0.6848853908126196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6001728499508097, 0.5251512437069583, 
    0.6751944561946608}, {-0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {-0.5827295292403942, 0.5675936973120723, 
    0.6811124367744867}, {-0.6140163187056149, 0.5382118349147982, 
    0.68224035411735}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, 0.5616987892757247, 
    0.6740385471308696}, {-0.6327645227143793, 0.6327645227143793, 
    0.7118600880536767}, {-0.6407214117452011, 0.6249011299737146, 
    0.7119126797168901}, {-0.5827295292403942, 0.5675936973120723, 
    0.6811124367744867}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6327645227143793, 0.6327645227143793, 
    0.7118600880536767}, {-0.7198653019554957, 0.7198653019554957, 
    0.7622103197175837}, {-0.7087220368790109, 0.6920462242465636, 
    0.7504115684601292}, {-0.6407214117452011, 0.6249011299737146, 
    0.7119126797168901}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7198653019554957, 0.7198653019554957, 
    0.7622103197175837}, {-0.9068996821171088, 0.9068996821171088, 
    0.9068996821171088}, {-0.8014503466375957, 0.7834402264884363, 
    0.8104554067121754}, {-0.7087220368790109, 0.6920462242465636, 
    0.7504115684601292}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.9068996821171088, 0.9068996821171088, 
    0.9068996821171088}, {-0.7640699024805022, 0.6791732466493353, 
    0.7640699024805022}, {-0.7436741413969546, 0.6601152491051621, 
    0.7520300306261339}, {-0.8014503466375957, 0.7834402264884363, 
    0.8104554067121754}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7640699024805022, 0.6791732466493353, 
    0.7640699024805022}, {-0.7171888530767329, 0.5578135523930144, 
    0.7171888530767329}, {-0.7082077892481158, 0.5649747532204069, 
    0.716165180138544}, {-0.7436741413969546, 0.6601152491051621, 
    0.7520300306261339}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7171888530767329, 0.5578135523930144, 
    0.7171888530767329}, {-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.6814262655051629, 0.48235791827893554`, 
    0.6890827403984794}, {-0.7082077892481158, 0.5649747532204069, 
    0.716165180138544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {
    0.005171109167864868, -0.005171109167864868, 0.07756663751797302}, {
    0.008765155746547347, -0.013921129715104607`, 0.11600941429253843`}, {
    0.0012873487674722039`, -0.0038620463024166113`, 0.05793069453624921}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.005171109167864868, -0.005171109167864868, 
    0.07756663751797302}, {0.020411420737374928`, -0.020411420737374928`, 
    0.15308565553031198`}, {0.022480327811811928`, -0.030232164988298796`, 
    0.1744163364709546}, {0.008765155746547347, -0.013921129715104607`, 
    0.11600941429253843`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.020411420737374928`, -0.020411420737374928`, 
    0.15308565553031198`}, {0.04495902221896904, -0.04495902221896904, 
    0.22479511109484523`}, {0.04202978289190042, -0.052280949450900525`, 
    0.23065124757750236`}, {0.022480327811811928`, -0.030232164988298796`, 
    0.1744163364709546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.04495902221896904, -0.04495902221896904, 
    0.22479511109484523`}, {0.07771364461602205, -0.07771364461602205, 
    0.2914261673100827}, {0.0668487308419404, -0.07946169892532537, 
    0.2837917818761621}, {0.04202978289190042, -0.052280949450900525`, 
    0.23065124757750236`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07771364461602205, -0.07771364461602205, 
    0.2914261673100827}, {0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {0.09630795334285219, -0.11112456154944483`, 
    0.3333736846483345}, {0.0668487308419404, -0.07946169892532537, 
    0.2837917818761621}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {0.09546533160684004, -0.14319799741026004`, 
    0.3579949935256501}, {0.08026080379573056, -0.131748866608086, 
    0.3407298274347052}, {0.09630795334285219, -0.11112456154944483`, 
    0.3333736846483345}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.09546533160684004, -0.14319799741026004`, 
    0.3579949935256501}, {0.07483045886349166, -0.1746044040148139, 
    0.37415229431745833`}, {0.06473499852717923, -0.1563113379070913, 
    0.35525304069793484`}, {0.08026080379573056, -0.131748866608086, 
    0.3407298274347052}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07483045886349166, -0.1746044040148139, 
    0.37415229431745833`}, {0.05311638731862741, -0.21246554927450964`, 
    0.3983729048897056}, {0.04838919502195432, -0.18521381542885962`, 
    0.3754334096530939}, {0.06473499852717923, -0.1563113379070913, 
    0.35525304069793484`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.05311638731862741, -0.21246554927450964`, 
    0.3983729048897056}, {0.028521062476874796`, -0.2566895622918732, 
    0.42781593715312194`}, {0.030189136362876293`, -0.21842728074316375`, 
    0.39956209892042155`}, {0.04838919502195432, -0.18521381542885962`, 
    0.3754334096530939}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.028521062476874796`, -0.2566895622918732, 
    0.42781593715312194`}, {0., -0.3066580952458096, 0.45998714286871445`}, {
    0.009468363199652228, -0.2556458063906103, 0.4260763439843505}, {
    0.030189136362876293`, -0.21842728074316375`, 0.39956209892042155`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.3066580952458096, 0.45998714286871445`}, {
    0., -0.20749339485230253`, 0.38905011534806727`}, {
    0.008131042914707278, -0.18050915270650167`, 0.36589693116182775`}, {
    0.009468363199652228, -0.2556458063906103, 0.4260763439843505}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.20749339485230253`, 0.38905011534806727`}, {
    0., -0.1226952100911925, 0.30673802522798127`}, {
    0.006628516589374509, -0.11533618865511652`, 0.2982832465218531}, {
    0.008131042914707278, -0.18050915270650167`, 0.36589693116182775`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.1226952100911925, 0.30673802522798127`}, {
    0., -0.05675323239297665, 0.21282462147366246`}, {
    0.004963354542040988, -0.06253826722971649, 0.22335095439184463`}, {
    0.006628516589374509, -0.11533618865511652`, 0.2982832465218531}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.05675323239297665, 0.21282462147366246`}, {
    0., -0.014560811715990765`, 0.10920608786993075`}, {
    0.003160550910532909, -0.0246522971021567, 0.142224790973981}, {
    0.004963354542040988, -0.06253826722971649, 0.22335095439184463`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.014560811715990765`, 0.10920608786993075`}, {
    0., 0., 0.}, {0.0012873487674722039`, -0.0038620463024166113`, 
    0.05793069453624921}, {0.003160550910532909, -0.0246522971021567, 
    0.142224790973981}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.3066580952458096, 0.45998714286871445`}, {
    0.06219340349207609, -0.31096701746038047`, 0.46645052619057076`}, {
    0.07978930111077105, -0.29665252977081547`, 0.46032289102367924`}, {
    0.03004186805503801, -0.29040472453203425`, 0.45062802082557046`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.06219340349207609, -0.31096701746038047`, 
    0.46645052619057076`}, {0.12923159990300587`, -0.3230789997575147, 
    0.48461849963627207`}, {0.13366765457769086`, -0.30764777640897106`, 
    0.4773844806346103}, {0.07978930111077105, -0.29665252977081547`, 
    0.46032289102367924`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.12923159990300587`, -0.3230789997575147, 
    0.48461849963627207`}, {0.20461481167731652`, -0.3410246861288609, 
    0.5115370291932914}, {0.19333151383599093`, -0.32221918972665153`, 
    0.4999952944034249}, {0.13366765457769086`, -0.30764777640897106`, 
    0.4773844806346103}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20461481167731652`, -0.3410246861288609, 
    0.5115370291932914}, {0.29013399227834397`, -0.36266749034792994`, 
    0.5440012355218949}, {0.25965194503259137`, -0.3391849732407725, 
    0.5263215102011988}, {0.19333151383599093`, -0.32221918972665153`, 
    0.4999952944034249}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.29013399227834397`, -0.36266749034792994`, 
    0.5440012355218949}, {0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.3329657494680982, -0.3576298790583277, 
    0.5549429157801637}, {0.25965194503259137`, -0.3391849732407725, 
    0.5263215102011988}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.3251055239962821, -0.3251055239962821, 
    0.5418425399938036}, {0.2862137017352461, -0.30948310838038806`, 
    0.5235616495156941}, {0.3329657494680982, -0.3576298790583277, 
    0.5549429157801637}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3251055239962821, -0.3251055239962821, 
    0.5418425399938036}, {0.2673132787288768, -0.2673132787288768, 
    0.501212397616644}, {0.24176935360143517`, -0.2635503764484113, 
    0.49007301405696324`}, {0.2862137017352461, -0.30948310838038806`, 
    0.5235616495156941}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2673132787288768, -0.2673132787288768, 
    0.501212397616644}, {0.21311308081691155`, -0.21311308081691155`, 
    0.4566708874648105}, {0.19972264378740437`, -0.2198966482103745, 
    0.4539150995168281}, {0.24176935360143517`, -0.2635503764484113, 
    0.49007301405696324`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21311308081691155`, -0.21311308081691155`, 
    0.4566708874648105}, {0.1629042820200325, -0.1629042820200325, 
    0.4072607050500812}, {0.1603207616432846, -0.1787484353953863, 
    0.4146226594222878}, {0.19972264378740437`, -0.2198966482103745, 
    0.4539150995168281}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1629042820200325, -0.1629042820200325, 
    0.4072607050500812}, {0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {0.12394767411382335`, -0.1404740306623331, 
    0.37184302234147004`}, {0.1603207616432846, -0.1787484353953863, 
    0.4146226594222878}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {0.09546533160684004, -0.14319799741026004`, 
    0.3579949935256501}, {0.10580644230106709`, -0.16290833179688105`, 
    0.37788015107523965`}, {0.12394767411382335`, -0.1404740306623331, 
    0.37184302234147004`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.09546533160684004, -0.14319799741026004`, 
    0.3579949935256501}, {0.07483045886349166, -0.1746044040148139, 
    0.37415229431745833`}, {0.08838155995073098, -0.18889392224764073`, 
    0.38991864684146027`}, {0.10580644230106709`, -0.16290833179688105`, 
    0.37788015107523965`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07483045886349166, -0.1746044040148139, 
    0.37415229431745833`}, {0.05311638731862741, -0.21246554927450964`, 
    0.3983729048897056}, {0.07052824422808539, -0.2188183987589316, 
    0.40689371670049274`}, {0.08838155995073098, -0.18889392224764073`, 
    0.38991864684146027`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.05311638731862741, -0.21246554927450964`, 
    0.3983729048897056}, {0.028521062476874796`, -0.2566895622918732, 
    0.42781593715312194`}, {0.05130464075001894, -0.2527228599908341, 
    0.4275386729168246}, {0.07052824422808539, -0.2188183987589316, 
    0.40689371670049274`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.028521062476874796`, -0.2566895622918732, 
    0.42781593715312194`}, {0., -0.3066580952458096, 0.45998714286871445`}, {
    0.03004186805503801, -0.29040472453203425`, 0.45062802082557046`}, {
    0.05130464075001894, -0.2527228599908341, 0.4275386729168246}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {0., -0.014560811715990765`, 
    0.10920608786993075`}, {-0.003160550910532909, -0.0246522971021567, 
    0.142224790973981}, {-0.0012873487674722039`, -0.0038620463024166113`, 
    0.05793069453624921}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.014560811715990765`, 0.10920608786993075`}, {
    0., -0.05675323239297665, 
    0.21282462147366246`}, {-0.004963354542040988, -0.06253826722971648, 
    0.22335095439184463`}, {-0.003160550910532909, -0.0246522971021567, 
    0.142224790973981}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.05675323239297665, 0.21282462147366246`}, {
    0., -0.1226952100911925, 
    0.30673802522798127`}, {-0.006628516589374509, -0.11533618865511652`, 
    0.2982832465218531}, {-0.004963354542040988, -0.06253826722971648, 
    0.22335095439184463`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.1226952100911925, 0.30673802522798127`}, {
    0., -0.20749339485230253`, 
    0.38905011534806727`}, {-0.008131042914707278, -0.18050915270650167`, 
    0.36589693116182775`}, {-0.006628516589374509, -0.11533618865511652`, 
    0.2982832465218531}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.20749339485230253`, 0.38905011534806727`}, {
    0., -0.3066580952458096, 
    0.45998714286871445`}, {-0.009468363199652228, -0.2556458063906103, 
    0.4260763439843505}, {-0.008131042914707278, -0.18050915270650167`, 
    0.36589693116182775`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.3066580952458096, 
    0.45998714286871445`}, {-0.028521062476874796`, -0.2566895622918732, 
    0.42781593715312194`}, {-0.030189136362876293`, -0.21842728074316375`, 
    0.39956209892042155`}, {-0.009468363199652228, -0.2556458063906103, 
    0.4260763439843505}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.028521062476874796`, -0.2566895622918732, 
    0.42781593715312194`}, {-0.05311638731862741, -0.21246554927450964`, 
    0.3983729048897056}, {-0.04838919502195432, -0.18521381542885962`, 
    0.3754334096530939}, {-0.030189136362876293`, -0.21842728074316375`, 
    0.39956209892042155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.05311638731862741, -0.21246554927450964`, 
    0.3983729048897056}, {-0.07483045886349166, -0.1746044040148139, 
    0.37415229431745833`}, {-0.06473499852717923, -0.1563113379070913, 
    0.35525304069793484`}, {-0.04838919502195432, -0.18521381542885962`, 
    0.3754334096530939}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07483045886349166, -0.1746044040148139, 
    0.37415229431745833`}, {-0.09546533160684004, -0.14319799741026004`, 
    0.3579949935256501}, {-0.08026080379573056, -0.131748866608086, 
    0.3407298274347052}, {-0.06473499852717923, -0.1563113379070913, 
    0.35525304069793484`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09546533160684004, -0.14319799741026004`, 
    0.3579949935256501}, {-0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {-0.09630795334285219, -0.11112456154944483`, 
    0.3333736846483345}, {-0.08026080379573056, -0.131748866608086, 
    0.3407298274347052}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {-0.07771364461602205, -0.07771364461602205, 
    0.2914261673100827}, {-0.0668487308419404, -0.07946169892532537, 
    0.2837917818761621}, {-0.09630795334285219, -0.11112456154944483`, 
    0.3333736846483345}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07771364461602205, -0.07771364461602205, 
    0.2914261673100827}, {-0.04495902221896904, -0.04495902221896904, 
    0.22479511109484523`}, {-0.04202978289190042, -0.052280949450900525`, 
    0.23065124757750236`}, {-0.0668487308419404, -0.07946169892532537, 
    0.2837917818761621}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.04495902221896904, -0.04495902221896904, 
    0.22479511109484523`}, {-0.020411420737374928`, -0.020411420737374928`, 
    0.15308565553031198`}, {-0.022480327811811928`, -0.030232164988298796`, 
    0.1744163364709546}, {-0.04202978289190042, -0.052280949450900525`, 
    0.23065124757750236`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.020411420737374928`, -0.020411420737374928`, 
    0.15308565553031198`}, {-0.005171109167864868, -0.005171109167864868, 
    0.07756663751797302}, {-0.008765155746547347, -0.013921129715104607`, 
    0.11600941429253843`}, {-0.022480327811811928`, -0.030232164988298796`, 
    0.1744163364709546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.005171109167864868, -0.005171109167864868, 
    0.07756663751797302}, {0., 0., 
    0.}, {-0.0012873487674722039`, -0.0038620463024166113`, 
    0.05793069453624921}, {-0.008765155746547347, -0.013921129715104607`, 
    0.11600941429253843`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.3066580952458096, 
    0.45998714286871445`}, {-0.028521062476874796`, -0.2566895622918732, 
    0.42781593715312194`}, {-0.05130464075001894, -0.2527228599908341, 
    0.4275386729168246}, {-0.03004186805503801, -0.29040472453203425`, 
    0.45062802082557046`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.028521062476874796`, -0.2566895622918732, 
    0.42781593715312194`}, {-0.05311638731862741, -0.21246554927450964`, 
    0.3983729048897056}, {-0.07052824422808539, -0.2188183987589316, 
    0.40689371670049274`}, {-0.05130464075001894, -0.2527228599908341, 
    0.4275386729168246}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.05311638731862741, -0.21246554927450964`, 
    0.3983729048897056}, {-0.07483045886349166, -0.1746044040148139, 
    0.37415229431745833`}, {-0.08838155995073098, -0.18889392224764073`, 
    0.38991864684146027`}, {-0.07052824422808539, -0.2188183987589316, 
    0.40689371670049274`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07483045886349166, -0.1746044040148139, 
    0.37415229431745833`}, {-0.09546533160684004, -0.14319799741026004`, 
    0.3579949935256501}, {-0.10580644230106709`, -0.16290833179688105`, 
    0.37788015107523965`}, {-0.08838155995073098, -0.18889392224764073`, 
    0.38991864684146027`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09546533160684004, -0.14319799741026004`, 
    0.3579949935256501}, {-0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {-0.12394767411382335`, -0.1404740306623331, 
    0.37184302234147004`}, {-0.10580644230106709`, -0.16290833179688105`, 
    0.37788015107523965`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.11743040006038394`, -0.11743040006038394`, 
    0.35229120018115184`}, {-0.1629042820200325, -0.1629042820200325, 
    0.4072607050500812}, {-0.1603207616432846, -0.1787484353953863, 
    0.4146226594222878}, {-0.12394767411382335`, -0.1404740306623331, 
    0.37184302234147004`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1629042820200325, -0.1629042820200325, 
    0.4072607050500812}, {-0.21311308081691155`, -0.21311308081691155`, 
    0.4566708874648105}, {-0.19972264378740437`, -0.2198966482103745, 
    0.4539150995168281}, {-0.1603207616432846, -0.1787484353953863, 
    0.4146226594222878}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21311308081691155`, -0.21311308081691155`, 
    0.4566708874648105}, {-0.2673132787288768, -0.2673132787288768, 
    0.501212397616644}, {-0.24176935360143517`, -0.2635503764484113, 
    0.49007301405696324`}, {-0.19972264378740437`, -0.2198966482103745, 
    0.4539150995168281}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2673132787288768, -0.2673132787288768, 
    0.501212397616644}, {-0.3251055239962821, -0.3251055239962821, 
    0.5418425399938036}, {-0.2862137017352461, -0.30948310838038806`, 
    0.5235616495156941}, {-0.24176935360143517`, -0.2635503764484113, 
    0.49007301405696324`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3251055239962821, -0.3251055239962821, 
    0.5418425399938036}, {-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.3329657494680982, -0.3576298790583277, 
    0.5549429157801637}, {-0.2862137017352461, -0.30948310838038806`, 
    0.5235616495156941}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.29013399227834397`, -0.36266749034792994`, 
    0.5440012355218949}, {-0.25965194503259137`, -0.3391849732407725, 
    0.5263215102011988}, {-0.3329657494680982, -0.3576298790583277, 
    0.5549429157801637}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.29013399227834397`, -0.36266749034792994`, 
    0.5440012355218949}, {-0.20461481167731652`, -0.3410246861288609, 
    0.5115370291932914}, {-0.19333151383599093`, -0.32221918972665153`, 
    0.4999952944034249}, {-0.25965194503259137`, -0.3391849732407725, 
    0.5263215102011988}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20461481167731652`, -0.3410246861288609, 
    0.5115370291932914}, {-0.12923159990300587`, -0.3230789997575147, 
    0.48461849963627207`}, {-0.1336676545776909, -0.30764777640897106`, 
    0.4773844806346103}, {-0.19333151383599093`, -0.32221918972665153`, 
    0.4999952944034249}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.12923159990300587`, -0.3230789997575147, 
    0.48461849963627207`}, {-0.06219340349207609, -0.31096701746038047`, 
    0.46645052619057076`}, {-0.07978930111077105, -0.29665252977081547`, 
    0.46032289102367924`}, {-0.1336676545776909, -0.30764777640897106`, 
    0.4773844806346103}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06219340349207609, -0.31096701746038047`, 
    0.46645052619057076`}, {0., -0.3066580952458096, 
    0.45998714286871445`}, {-0.03004186805503801, -0.29040472453203425`, 
    0.45062802082557046`}, {-0.07978930111077105, -0.29665252977081547`, 
    0.46032289102367924`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.4407985310247471, -0.4407985310247471, 
    0.6103364275727268}, {0.4452427310725714, -0.4589425074132659, 
    0.6164899353312527}, {0.4013008374837915, -0.41445824199145676`, 
    0.5920832028449382}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4407985310247471, -0.4407985310247471, 
    0.6103364275727268}, {0.49871361404698694`, -0.49871361404698694`, 
    0.6412032180604118}, {0.4916236345631913, -0.5058735949853128, 
    0.641248218995467}, {0.4452427310725714, -0.4589425074132659, 
    0.6164899353312527}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49871361404698694`, -0.49871361404698694`, 
    0.6412032180604118}, {0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {0.5412105935744802, -0.5560382810696715, 
    0.6672459372836057}, {0.4916236345631913, -0.5058735949853128, 
    0.641248218995467}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {0.5251512437069583, -0.6001728499508097, 
    0.6751944561946608}, {0.5123956646927323, -0.5866559059525488, 
    0.6683421713383466}, {0.5412105935744802, -0.5560382810696715, 
    0.6672459372836057}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5251512437069583, -0.6001728499508097, 
    0.6751944561946608}, {0.49015740221892146`, -0.6409750644401281, 
    0.6786794799954298}, {0.484544369547659, -0.6187258872685492, 
    0.670907588604451}, {0.5123956646927323, -0.5866559059525488, 
    0.6683421713383466}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49015740221892146`, -0.6409750644401281, 
    0.6786794799954298}, {0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.4574749594975597, -0.6524642864965196, 
    0.6749630549963996}, {0.484544369547659, -0.6187258872685492, 
    0.670907588604451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.4304670307029078, -0.5739560409372104, 
    0.6457005460543618}, {0.43706252979527566`, -0.5660318008824062, 
    0.6448463554356526}, {0.4574749594975597, -0.6524642864965196, 
    0.6749630549963996}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4304670307029078, -0.5739560409372104, 
    0.6457005460543618}, {0.40767204398438894`, -0.4756173846484537, 
    0.6115080659765835}, {0.4185959624434205, -0.4872182513685714, 
    0.6176006003263582}, {0.43706252979527566`, -0.5660318008824062, 
    0.6448463554356526}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.40767204398438894`, -0.4756173846484537, 
    0.6115080659765835}, {0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.4013008374837915, -0.41445824199145676`, 
    0.5920832028449382}, {0.4185959624434205, -0.4872182513685714, 
    0.6176006003263582}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.5578135523930144, -0.7171888530767329, 
    0.7171888530767329}, {0.5649747532204069, -0.7082077892481158, 
    0.716165180138544}, {0.48235791827893554`, -0.6814262655051629, 
    0.6890827403984794}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5578135523930144, -0.7171888530767329, 
    0.7171888530767329}, {0.6791732466493353, -0.7640699024805022, 
    0.7640699024805022}, {0.6601152491051621, -0.7436741413969546, 
    0.7520300306261339}, {0.5649747532204069, -0.7082077892481158, 
    0.716165180138544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6791732466493353, -0.7640699024805022, 
    0.7640699024805022}, {0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {0.7834402264884363, -0.8014503466375957, 
    0.8104554067121754}, {0.6601152491051621, -0.7436741413969546, 
    0.7520300306261339}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {0.7198653019554957, -0.7198653019554957, 
    0.7622103197175837}, {0.6920462242465636, -0.7087220368790109, 
    0.7504115684601292}, {0.7834402264884363, -0.8014503466375957, 
    0.8104554067121754}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.7198653019554957, -0.7198653019554957, 
    0.7622103197175837}, {0.6327645227143793, -0.6327645227143793, 
    0.7118600880536767}, {0.6249011299737146, -0.6407214117452011, 
    0.7119126797168901}, {0.6920462242465636, -0.7087220368790109, 
    0.7504115684601292}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.6327645227143793, -0.6327645227143793, 
    0.7118600880536767}, {0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {0.5675936973120723, -0.5827295292403942, 
    0.6811124367744867}, {0.6249011299737146, -0.6407214117452011, 
    0.7119126797168901}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {0.5251512437069583, -0.6001728499508097, 
    0.6751944561946608}, {0.5382118349147982, -0.6140163187056149, 
    0.68224035411735}, {0.5675936973120723, -0.5827295292403942, 
    0.6811124367744867}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.5251512437069583, -0.6001728499508097, 
    0.6751944561946608}, {0.49015740221892146`, -0.6409750644401281, 
    0.6786794799954298}, {0.5098591242716168, -0.6468362024341406, 
    0.6848853908126196}, {0.5382118349147982, -0.6140163187056149, 
    0.68224035411735}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.49015740221892146`, -0.6409750644401281, 
    0.6786794799954298}, {0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.48235791827893554`, -0.6814262655051629, 
    0.6890827403984794}, {0.5098591242716168, -0.6468362024341406, 
    0.6848853908126196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.3066580952458096, 0.45998714286871445`}, {
    0.038544848628222717`, -0.30835878902578173`, 0.46253818353867265`}, {
    0.052786379282336135`, -0.3272755515504841, 0.47507741354102534`}, {
    0.020955630116874954`, -0.324812266811562, 0.47150167762968676`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.038544848628222717`, -0.30835878902578173`, 
    0.46253818353867265`}, {0.07833195316248512, -0.3133278126499405, 
    0.46999171897491077`}, {0.0856080262124847, -0.33173110157337826`, 
    0.48154514744522653`}, {0.052786379282336135`, -0.3272755515504841, 
    0.47507741354102534`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.07833195316248512, -0.3133278126499405, 
    0.46999171897491077`}, {0.12044994043743079`, -0.32119984116648215`, 
    0.4817997617497233}, {0.11992963743797559`, -0.3379835236888404, 
    0.4906212440644457}, {0.0856080262124847, -0.33173110157337826`, 
    0.48154514744522653`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.12044994043743079`, -0.32119984116648215`, 
    0.4817997617497233}, {0.1657318525960958, -0.3314637051921916, 
    0.4971955577882874}, {0.1561613637329016, -0.3457858768371393, 
    0.5019472405700409}, {0.11992963743797559`, -0.3379835236888404, 
    0.4906212440644457}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1657318525960958, -0.3314637051921916, 
    0.4971955577882874}, {0.17673575244858597`, -0.3976554430093185, 
    0.5302072573457579}, {0.16447360317195706`, -0.3994358934176101, 
    0.5286651530527192}, {0.1561613637329016, -0.3457858768371393, 
    0.5019472405700409}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.17673575244858597`, -0.3976554430093185, 
    0.5302072573457579}, {0.18726648266764945`, -0.4681662066691236, 
    0.5617994480029483}, {0.17247195529467113`, -0.4558187389930595, 
    0.5543741420185859}, {0.16447360317195706`, -0.3994358934176101, 
    0.5286651530527192}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.18726648266764945`, -0.4681662066691236, 
    0.5617994480029483}, {0.19749453248903248`, -0.5431099643448393, 
    0.5924835974670974}, {0.18023995030369647`, -0.5149712865819899, 
    0.5793426974047388}, {0.17247195529467113`, -0.4558187389930595, 
    0.5543741420185859}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.19749453248903248`, -0.5431099643448393, 
    0.5924835974670974}, {0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.18789655708653166`, -0.577110853908633, 
    0.6039532192067091}, {0.18023995030369647`, -0.5149712865819899, 
    0.5793426974047388}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.14565785306317142`, -0.5340787945649619, 
    0.5826314122526858}, {0.13970138965108453`, -0.508005053276671, 
    0.571505684936255}, {0.18789655708653166`, -0.577110853908633, 
    0.6039532192067091}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.14565785306317142`, -0.5340787945649619, 
    0.5826314122526858}, {0.09039737304879422, -0.45198686524397114`, 
    0.5423842382927654}, {0.09578808133406011, -0.4430198761700281, 
    0.5388079575040883}, {0.13970138965108453`, -0.508005053276671, 
    0.571505684936255}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.09039737304879422, -0.45198686524397114`, 
    0.5423842382927654}, {0.041781498251368454`, -0.37603348426231603`, 
    0.5013779790164213}, {0.05615961056021797, -0.3818853518094823, 
    0.5054364950419619}, {0.09578808133406011, -0.4430198761700281, 
    0.5388079575040883}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.041781498251368454`, -0.37603348426231603`, 
    0.5013779790164213}, {0., -0.3066580952458096, 0.45998714286871445`}, {
    0.020955630116874954`, -0.324812266811562, 0.47150167762968676`}, {
    0.05615961056021797, -0.3818853518094823, 0.5054364950419619}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.3066580952458096, 0.45998714286871445`}, {
    0.02708690739129757, -0.3521297960868685, 0.4875643330433564}, {
    0.027651165009234, -0.37052561112373567`, 0.4977209701662121}, {
    0.005290785729710824, -0.33331950097178215`, 0.47617071567397445`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.02708690739129757, -0.3521297960868685, 
    0.4875643330433564}, {0.057237380507313335`, -0.4006616635511933, 
    0.5151364245658201}, {0.05192776126127516, -0.4096523388389484, 
    0.5192776126127516}, {0.027651165009234, -0.37052561112373567`, 
    0.4977209701662121}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.057237380507313335`, -0.4006616635511933, 
    0.5151364245658201}, {0.09039737304879422, -0.45198686524397114`, 
    0.5423842382927654}, {0.07810031047988147, -0.45057871430700847`, 
    0.5406944571684102}, {0.05192776126127516, -0.4096523388389484, 
    0.5192776126127516}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.09039737304879422, -0.45198686524397114`, 
    0.5423842382927654}, {0.06234543329511677, -0.49876346636093416`, 
    0.5611088996560509}, {0.055613276850190324`, -0.48816098568500393`, 
    0.5561327685019032}, {0.07810031047988147, -0.45057871430700847`, 
    0.5406944571684102}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.06234543329511677, -0.49876346636093416`, 
    0.5611088996560509}, {0.03227981539684726, -0.5487568617464034, 
    0.5810366771432506}, {0.03179444453423547, -0.5277877792683088, 
    0.5723000016162385}, {0.055613276850190324`, -0.48816098568500393`, 
    0.5561327685019032}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.03227981539684726, -0.5487568617464034, 
    0.5810366771432506}, {0., -0.6020420732135735, 0.6020420732135735}, {
    0.006545673176541602, -0.5694735663591197, 0.5891105858887445}, {
    0.03179444453423547, -0.5277877792683088, 0.5723000016162385}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.6020420732135735, 0.6020420732135735}, {
    0., -0.49629010408701807`, 0.5583263670978953}, {
    0.0061540114628666764`, -0.4861669055664678, 0.5538610316580013}, {
    0.006545673176541602, -0.5694735663591197, 0.5891105858887445}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.49629010408701807`, 0.5583263670978953}, {
    0., -0.3979707523500161, 0.5116766815928779}, {
    0.005739686383923255, -0.40751773325855134`, 0.5165717745530933}, {
    0.0061540114628666764`, -0.4861669055664678, 0.5538610316580013}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.3979707523500161, 0.5116766815928779}, {
    0., -0.3066580952458096, 0.45998714286871445`}, {
    0.005290785729710824, -0.33331950097178215`, 0.47617071567397445`}, {
    0.005739686383923255, -0.40751773325855134`, 0.5165717745530933}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.6020420732135735, 0.6020420732135735}, {
    0.06715883546475819, -0.6044295191828238, 0.6044295191828238}, {
    0.0734128220308756, -0.5939764691589027, 0.6006503620708005}, {
    0.01993158821950005, -0.5913037838451686, 0.597947646585002}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.06715883546475819, -0.6044295191828238, 
    0.6044295191828238}, {0.13589068132812965`, -0.6115080659765835, 
    0.6115080659765835}, {0.12801278465860869`, -0.5996388334008513, 
    0.6063763483828833}, {0.0734128220308756, -0.5939764691589027, 
    0.6006503620708005}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.13589068132812965`, -0.6115080659765835, 
    0.6115080659765835}, {0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.1845016009799007, -0.6081719439707838, 
    0.615005336599669}, {0.12801278465860869`, -0.5996388334008513, 
    0.6063763483828833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.16555673570625667`, -0.5628929014012727, 
    0.596004248542524}, {0.15171241243773156`, -0.560676306835095, 
    0.5936572660606888}, {0.1845016009799007, -0.6081719439707838, 
    0.615005336599669}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.16555673570625667`, -0.5628929014012727, 
    0.596004248542524}, {0.12650407746706638`, -0.5060163098682655, 
    0.5692683486017988}, {0.12086351903845649`, -0.5152602653744724, 
    0.572511405971636}, {0.15171241243773156`, -0.560676306835095, 
    0.5936572660606888}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.12650407746706638`, -0.5060163098682655, 
    0.5692683486017988}, {0.09039737304879422, -0.45198686524397114`, 
    0.5423842382927654}, {0.09188927555772322, -0.4716982811963126, 
    0.5513356533463394}, {0.12086351903845649`, -0.5152602653744724, 
    0.572511405971636}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.09039737304879422, -0.45198686524397114`, 
    0.5423842382927654}, {0.06234543329511677, -0.49876346636093416`, 
    0.5611088996560509}, {0.06918894281144455, -0.5094822152479099, 
    0.5660913502754555}, {0.09188927555772322, -0.4716982811963126, 
    0.5513356533463394}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.06234543329511677, -0.49876346636093416`, 
    0.5611088996560509}, {0.03227981539684726, -0.5487568617464034, 
    0.5810366771432506}, {0.04523945407613895, -0.5493362280674016, 
    0.5816501238360723}, {0.06918894281144455, -0.5094822152479099, 
    0.5660913502754555}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.03227981539684726, -0.5487568617464034, 
    0.5810366771432506}, {0., -0.6020420732135735, 0.6020420732135735}, {
    0.01993158821950005, -0.5913037838451686, 0.597947646585002}, {
    0.04523945407613895, -0.5493362280674016, 0.5816501238360723}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.32497414755462956`, -0.3713990257767195, 
    0.5570985386650793}, {0.30930754461094684`, -0.3835413553175741, 
    0.5567535802997043}, {0.35717979235010267`, -0.39544905581618517`, 
    0.5740389519912366}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.32497414755462956`, -0.3713990257767195, 
    0.5570985386650793}, {0.26775615427580557`, -0.35700820570107417`, 
    0.5355123085516112}, {0.26413196393268323`, -0.37218594917787184`, 
    0.540269926225943}, {0.30930754461094684`, -0.3835413553175741, 
    0.5567535802997043}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.26775615427580557`, -0.35700820570107417`, 
    0.5355123085516112}, {0.21472944721406304`, -0.34356711554250086`, 
    0.5153506733137513}, {0.22157332212441513`, -0.3615143676766774, 
    0.5247789208209833}, {0.26413196393268323`, -0.37218594917787184`, 
    0.540269926225943}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.21472944721406304`, -0.34356711554250086`, 
    0.5153506733137513}, {0.1657318525960958, -0.3314637051921916, 
    0.4971955577882874}, {0.18153126854126964`, -0.35171683279870997`, 
    0.510556692772321}, {0.22157332212441513`, -0.3615143676766774, 
    0.5247789208209833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.1657318525960958, -0.3314637051921916, 
    0.4971955577882874}, {0.17673575244858597`, -0.3976554430093185, 
    0.5302072573457579}, {0.1906578017409655, -0.4051478286995518, 
    0.5362250673964656}, {0.18153126854126964`, -0.35171683279870997`, 
    0.510556692772321}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.17673575244858597`, -0.3976554430093185, 
    0.5302072573457579}, {0.18726648266764945`, -0.4681662066691236, 
    0.5617994480029483}, {0.19950538654437358`, -0.461356206383864, 
    0.5611088996560508}, {0.1906578017409655, -0.4051478286995518, 
    0.5362250673964656}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.18726648266764945`, -0.4681662066691236, 
    0.5617994480029483}, {0.19749453248903248`, -0.5431099643448393, 
    0.5924835974670974}, {0.20816159484924335`, -0.5204039871231084, 
    0.5854544855134971}, {0.19950538654437358`, -0.461356206383864, 
    0.5611088996560508}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.19749453248903248`, -0.5431099643448393, 
    0.5924835974670974}, {0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.21675802958570295`, -0.5825372045115768, 
    0.6096319582097897}, {0.20816159484924335`, -0.5204039871231084, 
    0.5854544855134971}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.251969546341623, -0.5543330019515705, 
    0.6047269112198952}, {0.2515845081118029, -0.5296515960248482, 
    0.5958580455279544}, {0.21675802958570295`, -0.5825372045115768, 
    0.6096319582097897}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.251969546341623, -0.5543330019515705, 
    0.6047269112198952}, {0.29554773118396116`, -0.4925795519732687, 
    0.5910954623679224}, {0.2860742984158683, -0.4811249564266876, 
    0.585151974032458}, {0.2515845081118029, -0.5296515960248482, 
    0.5958580455279544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.29554773118396116`, -0.4925795519732687, 
    0.5910954623679224}, {0.3398683238140667, -0.43697355918951436`, 
    0.5826314122526858}, {0.32099644718097237`, -0.4365551681661225, 
    0.5777936049257504}, {0.2860742984158683, -0.4811249564266876, 
    0.585151974032458}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3398683238140667, -0.43697355918951436`, 
    0.5826314122526858}, {0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.35717979235010267`, -0.39544905581618517`, 
    0.5740389519912366}, {0.32099644718097237`, -0.4365551681661225, 
    0.5777936049257504}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.3550779693653199, -0.41963760015901447`, 
    0.5810366771432508}, {0.3591582529035913, -0.4375200535371022, 
    0.5877135047513313}, {0.38422691935919384`, -0.41027620202761383`, 
    0.5861088600394483}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3550779693653199, -0.41963760015901447`, 
    0.5810366771432508}, {0.32491619395345206`, -0.45488267153483286`, 
    0.5848491491162138}, {0.33484194093648584`, -0.46615250600961755`, 
    0.5908975428290927}, {0.3591582529035913, -0.4375200535371022, 
    0.5877135047513313}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.32491619395345206`, -0.45488267153483286`, 
    0.5848491491162138}, {0.2955477311839612, -0.4925795519732687, 
    0.5910954623679224}, {0.31104298811316416`, -0.49634519379760245`, 
    0.595614232557123}, {0.33484194093648584`, -0.46615250600961755`, 
    0.5908975428290927}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2955477311839612, -0.4925795519732687, 
    0.5910954623679224}, {0.34487850812687415`, -0.5518056130029987, 
    0.6207813146283735}, {0.3510197768048997, -0.5437365170115114, 
    0.6194466649498231}, {0.31104298811316416`, -0.49634519379760245`, 
    0.595614232557123}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.34487850812687415`, -0.5518056130029987, 
    0.6207813146283735}, {0.39802947182437354`, -0.6151364564558499, 
    0.6513209538944295}, {0.3934133114373311, -0.593696451805427, 
    0.643767236897451}, {0.3510197768048997, -0.5437365170115114, 
    0.6194466649498231}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.39802947182437354`, -0.6151364564558499, 
    0.6513209538944295}, {0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.43885530547477725`, -0.6471256199373834, 
    0.6694402964869484}, {0.3934133114373311, -0.593696451805427, 
    0.643767236897451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.4304670307029078, -0.5739560409372104, 
    0.6457005460543618}, {0.4191933748864658, -0.561292824000522, 
    0.639447521013253}, {0.43885530547477725`, -0.6471256199373834, 
    0.6694402964869484}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4304670307029078, -0.5739560409372104, 
    0.6457005460543618}, {0.40767204398438894`, -0.4756173846484537, 
    0.6115080659765835}, {0.4012148338270782, -0.4828178508766534, 
    0.6120226278718142}, {0.4191933748864658, -0.561292824000522, 
    0.639447521013253}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.40767204398438894`, -0.4756173846484537, 
    0.6115080659765835}, {0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {0.38422691935919384`, -0.41027620202761383`, 
    0.5861088600394483}, {0.4012148338270782, -0.4828178508766534, 
    0.6120226278718142}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.3662276185282054, -0.6592097133507697, 
    0.6592097133507697}, {0.35549008961826795`, -0.6456860811433847, 
    0.6529409809315125}, {0.42572323570788767`, -0.6647257540000352, 
    0.6721945826966648}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.3662276185282054, -0.6592097133507697, 
    0.6592097133507697}, {0.2839786944782409, -0.6389520625760421, 
    0.6389520625760421}, {0.2900719574991448, -0.629668395546924, 
    0.6367433213395861}, {0.35549008961826795`, -0.6456860811433847, 
    0.6529409809315125}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2839786944782409, -0.6389520625760421, 
    0.6389520625760421}, {0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.22854498053961364`, -0.6163788869098672, 
    0.6233044923807646}, {0.2900719574991448, -0.629668395546924, 
    0.6367433213395861}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {0.23735305516717142`, -0.5764288482631306, 
    0.6103364275727265}, {0.25229999183570073`, -0.5796080893522855, 
    0.6137026828435964}, {0.22854498053961364`, -0.6163788869098672, 
    0.6233044923807646}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.23735305516717142`, -0.5764288482631306, 
    0.6103364275727265}, {0.2665063311720162, -0.5330126623440324, 
    0.5996392451370365}, {0.2758060279446175, -0.5448850795979028, 
    0.605427866219892}, {0.25229999183570073`, -0.5796080893522855, 
    0.6137026828435964}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2665063311720162, -0.5330126623440324, 
    0.5996392451370365}, {0.2955477311839612, -0.4925795519732687, 
    0.5910954623679224}, {0.29926426963948155`, -0.5120744169386685, 
    0.5985285392789631}, {0.2758060279446175, -0.5448850795979028, 
    0.605427866219892}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.2955477311839612, -0.4925795519732687, 
    0.5910954623679224}, {0.34487850812687415`, -0.5518056130029987, 
    0.6207813146283735}, {0.33875590314851456`, -0.5599842480618302, 
    0.6222047200687002}, {0.29926426963948155`, -0.5120744169386685, 
    0.5985285392789631}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.34487850812687415`, -0.5518056130029987, 
    0.6207813146283735}, {0.39802947182437354`, -0.6151364564558499, 
    0.6513209538944295}, {0.3806959241330279, -0.6105500670057994, 
    0.6464647768296701}, {0.33875590314851456`, -0.5599842480618302, 
    0.6222047200687002}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0.39802947182437354`, -0.6151364564558499, 
    0.6513209538944295}, {0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {0.42572323570788767`, -0.6647257540000352, 
    0.6721945826966648}, {0.3806959241330279, -0.6105500670057994, 
    0.6464647768296701}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.32497414755462956`, -0.3713990257767195, 
    0.5570985386650793}, {-0.30930754461094684`, -0.3835413553175741, 
    0.5567535802997043}, {-0.35717979235010267`, -0.39544905581618517`, 
    0.5740389519912366}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.32497414755462956`, -0.3713990257767195, 
    0.5570985386650793}, {-0.26775615427580557`, -0.35700820570107417`, 
    0.5355123085516112}, {-0.26413196393268323`, -0.37218594917787184`, 
    0.540269926225943}, {-0.30930754461094684`, -0.3835413553175741, 
    0.5567535802997043}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.26775615427580557`, -0.35700820570107417`, 
    0.5355123085516112}, {-0.21472944721406304`, -0.34356711554250086`, 
    0.5153506733137513}, {-0.22157332212441513`, -0.3615143676766774, 
    0.5247789208209833}, {-0.26413196393268323`, -0.37218594917787184`, 
    0.540269926225943}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21472944721406304`, -0.34356711554250086`, 
    0.5153506733137513}, {-0.1657318525960958, -0.3314637051921916, 
    0.4971955577882874}, {-0.18153126854126964`, -0.35171683279870997`, 
    0.510556692772321}, {-0.22157332212441513`, -0.3615143676766774, 
    0.5247789208209833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1657318525960958, -0.3314637051921916, 
    0.4971955577882874}, {-0.17673575244858597`, -0.3976554430093185, 
    0.5302072573457579}, {-0.1906578017409655, -0.4051478286995518, 
    0.5362250673964656}, {-0.18153126854126964`, -0.35171683279870997`, 
    0.510556692772321}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.17673575244858597`, -0.3976554430093185, 
    0.5302072573457579}, {-0.18726648266764945`, -0.4681662066691236, 
    0.5617994480029483}, {-0.19950538654437358`, -0.461356206383864, 
    0.5611088996560508}, {-0.1906578017409655, -0.4051478286995518, 
    0.5362250673964656}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.18726648266764945`, -0.4681662066691236, 
    0.5617994480029483}, {-0.19749453248903248`, -0.5431099643448393, 
    0.5924835974670974}, {-0.20816159484924335`, -0.5204039871231084, 
    0.5854544855134971}, {-0.19950538654437358`, -0.461356206383864, 
    0.5611088996560508}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.19749453248903248`, -0.5431099643448393, 
    0.5924835974670974}, {-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.21675802958570295`, -0.5825372045115768, 
    0.6096319582097897}, {-0.20816159484924335`, -0.5204039871231084, 
    0.5854544855134971}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.251969546341623, -0.5543330019515705, 
    0.6047269112198952}, {-0.2515845081118029, -0.5296515960248482, 
    0.5958580455279544}, {-0.21675802958570295`, -0.5825372045115768, 
    0.6096319582097897}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.251969546341623, -0.5543330019515705, 
    0.6047269112198952}, {-0.29554773118396116`, -0.4925795519732687, 
    0.5910954623679224}, {-0.2860742984158683, -0.4811249564266876, 
    0.585151974032458}, {-0.2515845081118029, -0.5296515960248482, 
    0.5958580455279544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.29554773118396116`, -0.4925795519732687, 
    0.5910954623679224}, {-0.3398683238140667, -0.43697355918951436`, 
    0.5826314122526858}, {-0.32099644718097237`, -0.4365551681661225, 
    0.5777936049257504}, {-0.2860742984158683, -0.4811249564266876, 
    0.585151974032458}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3398683238140667, -0.43697355918951436`, 
    0.5826314122526858}, {-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.35717979235010267`, -0.39544905581618517`, 
    0.5740389519912366}, {-0.32099644718097237`, -0.4365551681661225, 
    0.5777936049257504}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.3550779693653199, -0.41963760015901447`, 
    0.5810366771432508}, {-0.3591582529035913, -0.4375200535371022, 
    0.5877135047513313}, {-0.38422691935919384`, -0.41027620202761383`, 
    0.5861088600394483}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3550779693653199, -0.41963760015901447`, 
    0.5810366771432508}, {-0.32491619395345206`, -0.45488267153483286`, 
    0.5848491491162138}, {-0.33484194093648584`, -0.46615250600961755`, 
    0.5908975428290927}, {-0.3591582529035913, -0.4375200535371022, 
    0.5877135047513313}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.32491619395345206`, -0.45488267153483286`, 
    0.5848491491162138}, {-0.2955477311839612, -0.4925795519732687, 
    0.5910954623679224}, {-0.31104298811316416`, -0.49634519379760245`, 
    0.595614232557123}, {-0.33484194093648584`, -0.46615250600961755`, 
    0.5908975428290927}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2955477311839612, -0.4925795519732687, 
    0.5910954623679224}, {-0.34487850812687415`, -0.5518056130029987, 
    0.6207813146283735}, {-0.3510197768048997, -0.5437365170115114, 
    0.6194466649498231}, {-0.31104298811316416`, -0.49634519379760245`, 
    0.595614232557123}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.34487850812687415`, -0.5518056130029987, 
    0.6207813146283735}, {-0.39802947182437354`, -0.6151364564558499, 
    0.6513209538944295}, {-0.3934133114373311, -0.593696451805427, 
    0.643767236897451}, {-0.3510197768048997, -0.5437365170115114, 
    0.6194466649498231}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.39802947182437354`, -0.6151364564558499, 
    0.6513209538944295}, {-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.43885530547477725`, -0.6471256199373834, 
    0.6694402964869484}, {-0.3934133114373311, -0.593696451805427, 
    0.643767236897451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.4304670307029078, -0.5739560409372104, 
    0.6457005460543618}, {-0.4191933748864658, -0.561292824000522, 
    0.639447521013253}, {-0.43885530547477725`, -0.6471256199373834, 
    0.6694402964869484}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4304670307029078, -0.5739560409372104, 
    0.6457005460543618}, {-0.40767204398438894`, -0.4756173846484537, 
    0.6115080659765835}, {-0.4012148338270782, -0.4828178508766534, 
    0.6120226278718142}, {-0.4191933748864658, -0.561292824000522, 
    0.639447521013253}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.40767204398438894`, -0.4756173846484537, 
    0.6115080659765835}, {-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.38422691935919384`, -0.41027620202761383`, 
    0.5861088600394483}, {-0.4012148338270782, -0.4828178508766534, 
    0.6120226278718142}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.3662276185282054, -0.6592097133507697, 
    0.6592097133507697}, {-0.35549008961826795`, -0.6456860811433847, 
    0.6529409809315125}, {-0.42572323570788767`, -0.6647257540000352, 
    0.6721945826966648}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3662276185282054, -0.6592097133507697, 
    0.6592097133507697}, {-0.2839786944782409, -0.6389520625760421, 
    0.6389520625760421}, {-0.2900719574991448, -0.629668395546924, 
    0.6367433213395861}, {-0.35549008961826795`, -0.6456860811433847, 
    0.6529409809315125}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2839786944782409, -0.6389520625760421, 
    0.6389520625760421}, {-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.22854498053961364`, -0.6163788869098672, 
    0.6233044923807646}, {-0.2900719574991448, -0.629668395546924, 
    0.6367433213395861}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.23735305516717142`, -0.5764288482631306, 
    0.6103364275727265}, {-0.25229999183570073`, -0.5796080893522855, 
    0.6137026828435964}, {-0.22854498053961364`, -0.6163788869098672, 
    0.6233044923807646}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.23735305516717142`, -0.5764288482631306, 
    0.6103364275727265}, {-0.2665063311720162, -0.5330126623440324, 
    0.5996392451370365}, {-0.2758060279446175, -0.5448850795979028, 
    0.605427866219892}, {-0.25229999183570073`, -0.5796080893522855, 
    0.6137026828435964}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2665063311720162, -0.5330126623440324, 
    0.5996392451370365}, {-0.2955477311839612, -0.4925795519732687, 
    0.5910954623679224}, {-0.29926426963948155`, -0.5120744169386685, 
    0.5985285392789631}, {-0.2758060279446175, -0.5448850795979028, 
    0.605427866219892}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2955477311839612, -0.4925795519732687, 
    0.5910954623679224}, {-0.34487850812687415`, -0.5518056130029987, 
    0.6207813146283735}, {-0.33875590314851456`, -0.5599842480618302, 
    0.6222047200687002}, {-0.29926426963948155`, -0.5120744169386685, 
    0.5985285392789631}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.34487850812687415`, -0.5518056130029987, 
    0.6207813146283735}, {-0.39802947182437354`, -0.6151364564558499, 
    0.6513209538944295}, {-0.3806959241330279, -0.6105500670057994, 
    0.6464647768296701}, {-0.33875590314851456`, -0.5599842480618302, 
    0.6222047200687002}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.39802947182437354`, -0.6151364564558499, 
    0.6513209538944295}, {-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.42572323570788767`, -0.6647257540000352, 
    0.6721945826966648}, {-0.3806959241330279, -0.6105500670057994, 
    0.6464647768296701}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.3066580952458096, 
    0.45998714286871445`}, {-0.038544848628222717`, -0.30835878902578173`, 
    0.46253818353867265`}, {-0.052786379282336135`, -0.3272755515504841, 
    0.47507741354102534`}, {-0.020955630116874954`, -0.324812266811562, 
    0.47150167762968676`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.038544848628222717`, -0.30835878902578173`, 
    0.46253818353867265`}, {-0.07833195316248512, -0.3133278126499405, 
    0.46999171897491077`}, {-0.0856080262124847, -0.33173110157337826`, 
    0.48154514744522653`}, {-0.052786379282336135`, -0.3272755515504841, 
    0.47507741354102534`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07833195316248512, -0.3133278126499405, 
    0.46999171897491077`}, {-0.12044994043743079`, -0.32119984116648215`, 
    0.4817997617497233}, {-0.11992963743797559`, -0.3379835236888404, 
    0.4906212440644457}, {-0.0856080262124847, -0.33173110157337826`, 
    0.48154514744522653`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.12044994043743079`, -0.32119984116648215`, 
    0.4817997617497233}, {-0.1657318525960958, -0.3314637051921916, 
    0.4971955577882874}, {-0.1561613637329016, -0.3457858768371393, 
    0.5019472405700409}, {-0.11992963743797559`, -0.3379835236888404, 
    0.4906212440644457}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.1657318525960958, -0.3314637051921916, 
    0.4971955577882874}, {-0.17673575244858597`, -0.3976554430093185, 
    0.5302072573457579}, {-0.16447360317195706`, -0.3994358934176101, 
    0.5286651530527192}, {-0.1561613637329016, -0.3457858768371393, 
    0.5019472405700409}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.17673575244858597`, -0.3976554430093185, 
    0.5302072573457579}, {-0.18726648266764945`, -0.4681662066691236, 
    0.5617994480029483}, {-0.17247195529467113`, -0.4558187389930595, 
    0.5543741420185859}, {-0.16447360317195706`, -0.3994358934176101, 
    0.5286651530527192}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.18726648266764945`, -0.4681662066691236, 
    0.5617994480029483}, {-0.19749453248903248`, -0.5431099643448393, 
    0.5924835974670974}, {-0.18023995030369647`, -0.5149712865819899, 
    0.5793426974047388}, {-0.17247195529467113`, -0.4558187389930595, 
    0.5543741420185859}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.19749453248903248`, -0.5431099643448393, 
    0.5924835974670974}, {-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.18789655708653166`, -0.577110853908633, 
    0.6039532192067091}, {-0.18023995030369647`, -0.5149712865819899, 
    0.5793426974047388}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.14565785306317142`, -0.5340787945649619, 
    0.5826314122526858}, {-0.13970138965108453`, -0.508005053276671, 
    0.571505684936255}, {-0.18789655708653166`, -0.577110853908633, 
    0.6039532192067091}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.14565785306317142`, -0.5340787945649619, 
    0.5826314122526858}, {-0.09039737304879422, -0.45198686524397114`, 
    0.5423842382927654}, {-0.09578808133406011, -0.4430198761700281, 
    0.5388079575040883}, {-0.13970138965108453`, -0.508005053276671, 
    0.571505684936255}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09039737304879422, -0.45198686524397114`, 
    0.5423842382927654}, {-0.041781498251368454`, -0.37603348426231603`, 
    0.5013779790164213}, {-0.05615961056021797, -0.3818853518094823, 
    0.5054364950419619}, {-0.09578808133406011, -0.4430198761700281, 
    0.5388079575040883}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.041781498251368454`, -0.37603348426231603`, 
    0.5013779790164213}, {0., -0.3066580952458096, 
    0.45998714286871445`}, {-0.020955630116874954`, -0.324812266811562, 
    0.47150167762968676`}, {-0.05615961056021797, -0.3818853518094823, 
    0.5054364950419619}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.3066580952458096, 
    0.45998714286871445`}, {-0.02708690739129757, -0.3521297960868685, 
    0.4875643330433564}, {-0.027651165009234, -0.37052561112373567`, 
    0.4977209701662121}, {-0.005290785729710824, -0.33331950097178215`, 
    0.47617071567397445`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.02708690739129757, -0.3521297960868685, 
    0.4875643330433564}, {-0.057237380507313335`, -0.4006616635511933, 
    0.5151364245658201}, {-0.05192776126127516, -0.4096523388389484, 
    0.5192776126127516}, {-0.027651165009234, -0.37052561112373567`, 
    0.4977209701662121}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.057237380507313335`, -0.4006616635511933, 
    0.5151364245658201}, {-0.09039737304879422, -0.45198686524397114`, 
    0.5423842382927654}, {-0.07810031047988147, -0.45057871430700847`, 
    0.5406944571684102}, {-0.05192776126127516, -0.4096523388389484, 
    0.5192776126127516}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09039737304879422, -0.45198686524397114`, 
    0.5423842382927654}, {-0.06234543329511677, -0.49876346636093416`, 
    0.5611088996560509}, {-0.055613276850190324`, -0.48816098568500393`, 
    0.5561327685019032}, {-0.07810031047988147, -0.45057871430700847`, 
    0.5406944571684102}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06234543329511677, -0.49876346636093416`, 
    0.5611088996560509}, {-0.03227981539684726, -0.5487568617464034, 
    0.5810366771432506}, {-0.03179444453423547, -0.5277877792683088, 
    0.5723000016162385}, {-0.055613276850190324`, -0.48816098568500393`, 
    0.5561327685019032}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.03227981539684726, -0.5487568617464034, 
    0.5810366771432506}, {0., -0.6020420732135735, 
    0.6020420732135735}, {-0.006545673176541602, -0.5694735663591197, 
    0.5891105858887445}, {-0.03179444453423547, -0.5277877792683088, 
    0.5723000016162385}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.6020420732135735, 0.6020420732135735}, {
    0., -0.49629010408701807`, 
    0.5583263670978953}, {-0.0061540114628666764`, -0.4861669055664678, 
    0.5538610316580013}, {-0.006545673176541602, -0.5694735663591197, 
    0.5891105858887445}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.49629010408701807`, 0.5583263670978953}, {
    0., -0.3979707523500161, 
    0.5116766815928779}, {-0.005739686383923255, -0.40751773325855134`, 
    0.5165717745530933}, {-0.0061540114628666764`, -0.4861669055664678, 
    0.5538610316580013}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.3979707523500161, 0.5116766815928779}, {
    0., -0.3066580952458096, 
    0.45998714286871445`}, {-0.005290785729710824, -0.33331950097178215`, 
    0.47617071567397445`}, {-0.005739686383923255, -0.40751773325855134`, 
    0.5165717745530933}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., -0.6020420732135735, 
    0.6020420732135735}, {-0.06715883546475819, -0.6044295191828238, 
    0.6044295191828238}, {-0.0734128220308756, -0.5939764691589027, 
    0.6006503620708005}, {-0.01993158821950005, -0.5913037838451686, 
    0.597947646585002}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06715883546475819, -0.6044295191828238, 
    0.6044295191828238}, {-0.13589068132812965`, -0.6115080659765835, 
    0.6115080659765835}, {-0.12801278465860869`, -0.5996388334008513, 
    0.6063763483828833}, {-0.0734128220308756, -0.5939764691589027, 
    0.6006503620708005}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.13589068132812965`, -0.6115080659765835, 
    0.6115080659765835}, {-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.1845016009799007, -0.6081719439707838, 
    0.615005336599669}, {-0.12801278465860869`, -0.5996388334008513, 
    0.6063763483828833}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.20769184264312943`, -0.6230755279293883, 
    0.6230755279293883}, {-0.16555673570625667`, -0.5628929014012727, 
    0.596004248542524}, {-0.15171241243773156`, -0.560676306835095, 
    0.5936572660606888}, {-0.1845016009799007, -0.6081719439707838, 
    0.615005336599669}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.16555673570625667`, -0.5628929014012727, 
    0.596004248542524}, {-0.12650407746706638`, -0.5060163098682655, 
    0.5692683486017988}, {-0.12086351903845649`, -0.5152602653744724, 
    0.572511405971636}, {-0.15171241243773156`, -0.560676306835095, 
    0.5936572660606888}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.12650407746706638`, -0.5060163098682655, 
    0.5692683486017988}, {-0.09039737304879422, -0.45198686524397114`, 
    0.5423842382927654}, {-0.09188927555772322, -0.4716982811963126, 
    0.5513356533463394}, {-0.12086351903845649`, -0.5152602653744724, 
    0.572511405971636}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.09039737304879422, -0.45198686524397114`, 
    0.5423842382927654}, {-0.06234543329511677, -0.49876346636093416`, 
    0.5611088996560509}, {-0.06918894281144455, -0.5094822152479099, 
    0.5660913502754555}, {-0.09188927555772322, -0.4716982811963126, 
    0.5513356533463394}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.06234543329511677, -0.49876346636093416`, 
    0.5611088996560509}, {-0.03227981539684726, -0.5487568617464034, 
    0.5810366771432506}, {-0.04523945407613895, -0.5493362280674016, 
    0.5816501238360723}, {-0.06918894281144455, -0.5094822152479099, 
    0.5660913502754555}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.03227981539684726, -0.5487568617464034, 
    0.5810366771432506}, {0., -0.6020420732135735, 
    0.6020420732135735}, {-0.01993158821950005, -0.5913037838451686, 
    0.597947646585002}, {-0.04523945407613895, -0.5493362280674016, 
    0.5816501238360723}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.40767204398438894`, -0.4756173846484537, 
    0.6115080659765835}, {-0.4185959624434205, -0.4872182513685714, 
    0.6176006003263582}, {-0.4013008374837915, -0.41445824199145676`, 
    0.5920832028449382}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.40767204398438894`, -0.4756173846484537, 
    0.6115080659765835}, {-0.4304670307029078, -0.5739560409372104, 
    0.6457005460543618}, {-0.43706252979527566`, -0.5660318008824062, 
    0.6448463554356526}, {-0.4185959624434205, -0.4872182513685714, 
    0.6176006003263582}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4304670307029078, -0.5739560409372104, 
    0.6457005460543618}, {-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.4574749594975597, -0.6524642864965196, 
    0.6749630549963996}, {-0.43706252979527566`, -0.5660318008824062, 
    0.6448463554356526}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.49015740221892146`, -0.6409750644401281, 
    0.6786794799954298}, {-0.484544369547659, -0.6187258872685492, 
    0.670907588604451}, {-0.4574749594975597, -0.6524642864965196, 
    0.6749630549963996}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49015740221892146`, -0.6409750644401281, 
    0.6786794799954298}, {-0.5251512437069583, -0.6001728499508097, 
    0.6751944561946608}, {-0.5123956646927323, -0.5866559059525488, 
    0.6683421713383466}, {-0.484544369547659, -0.6187258872685492, 
    0.670907588604451}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5251512437069583, -0.6001728499508097, 
    0.6751944561946608}, {-0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {-0.5412105935744802, -0.5560382810696715, 
    0.6672459372836057}, {-0.5123956646927323, -0.5866559059525488, 
    0.6683421713383466}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {-0.49871361404698694`, -0.49871361404698694`, 
    0.6412032180604118}, {-0.4916236345631913, -0.5058735949853128, 
    0.641248218995467}, {-0.5412105935744802, -0.5560382810696715, 
    0.6672459372836057}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49871361404698694`, -0.49871361404698694`, 
    0.6412032180604118}, {-0.4407985310247471, -0.4407985310247471, 
    0.6103364275727268}, {-0.4452427310725714, -0.4589425074132659, 
    0.6164899353312527}, {-0.4916236345631913, -0.5058735949853128, 
    0.641248218995467}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4407985310247471, -0.4407985310247471, 
    0.6103364275727268}, {-0.38650287499487973`, -0.38650287499487973`, 
    0.5797543124923197}, {-0.4013008374837915, -0.41445824199145676`, 
    0.5920832028449382}, {-0.4452427310725714, -0.4589425074132659, 
    0.6164899353312527}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.49015740221892146`, -0.6409750644401281, 
    0.6786794799954298}, {-0.5098591242716168, -0.6468362024341406, 
    0.6848853908126196}, {-0.48235791827893554`, -0.6814262655051629, 
    0.6890827403984794}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.49015740221892146`, -0.6409750644401281, 
    0.6786794799954298}, {-0.5251512437069583, -0.6001728499508097, 
    0.6751944561946608}, {-0.5382118349147982, -0.6140163187056149, 
    0.68224035411735}, {-0.5098591242716168, -0.6468362024341406, 
    0.6848853908126196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5251512437069583, -0.6001728499508097, 
    0.6751944561946608}, {-0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {-0.5675936973120723, -0.5827295292403942, 
    0.6811124367744867}, {-0.5382118349147982, -0.6140163187056149, 
    0.68224035411735}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5616987892757247, -0.5616987892757247, 
    0.6740385471308696}, {-0.6327645227143793, -0.6327645227143793, 
    0.7118600880536767}, {-0.6249011299737146, -0.6407214117452011, 
    0.7119126797168901}, {-0.5675936973120723, -0.5827295292403942, 
    0.6811124367744867}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6327645227143793, -0.6327645227143793, 
    0.7118600880536767}, {-0.7198653019554957, -0.7198653019554957, 
    0.7622103197175837}, {-0.6920462242465636, -0.7087220368790109, 
    0.7504115684601292}, {-0.6249011299737146, -0.6407214117452011, 
    0.7119126797168901}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7198653019554957, -0.7198653019554957, 
    0.7622103197175837}, {-0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {-0.7834402264884363, -0.8014503466375957, 
    0.8104554067121754}, {-0.6920462242465636, -0.7087220368790109, 
    0.7504115684601292}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {-0.6791732466493353, -0.7640699024805022, 
    0.7640699024805022}, {-0.6601152491051621, -0.7436741413969546, 
    0.7520300306261339}, {-0.7834402264884363, -0.8014503466375957, 
    0.8104554067121754}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6791732466493353, -0.7640699024805022, 
    0.7640699024805022}, {-0.5578135523930144, -0.7171888530767329, 
    0.7171888530767329}, {-0.5649747532204069, -0.7082077892481158, 
    0.716165180138544}, {-0.6601152491051621, -0.7436741413969546, 
    0.7520300306261339}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5578135523930144, -0.7171888530767329, 
    0.7171888530767329}, {-0.4563691391047108, -0.6845537086570662, 
    0.6845537086570662}, {-0.48235791827893554`, -0.6814262655051629, 
    0.6890827403984794}, {-0.5649747532204069, -0.7082077892481158, 
    0.716165180138544}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {-0.07756663751797302, 
    0.005171109167864868, 0.005171109167864868}, {-0.11600941429253843`, 
    0.008765155746547347, 0.013921129715104607`}, {-0.05793069453624921, 
    0.0012873487674722039`, 0.0038620463024166113`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07756663751797302, 0.005171109167864868, 
    0.005171109167864868}, {-0.15308565553031123`, 0.02041142073737483, 
    0.02041142073737483}, {-0.17441633647095503`, 0.02248032781181198, 
    0.030232164988298865`}, {-0.11600941429253843`, 0.008765155746547347, 
    0.013921129715104607`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.15308565553031123`, 0.02041142073737483, 
    0.02041142073737483}, {-0.22479511109484523`, 0.04495902221896904, 
    0.04495902221896904}, {-0.23065124757750236`, 0.04202978289190042, 
    0.052280949450900525`}, {-0.17441633647095503`, 0.02248032781181198, 
    0.030232164988298865`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.22479511109484523`, 0.04495902221896904, 
    0.04495902221896904}, {-0.2914261673100827, 0.07771364461602205, 
    0.07771364461602205}, {-0.2837917818761621, 0.0668487308419404, 
    0.07946169892532537}, {-0.23065124757750236`, 0.04202978289190042, 
    0.052280949450900525`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2914261673100827, 0.07771364461602205, 
    0.07771364461602205}, {-0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {-0.3333736846483348, 0.09630795334285228, 
    0.11112456154944492`}, {-0.2837917818761621, 0.0668487308419404, 
    0.07946169892532537}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {-0.3579949935256501, 0.09546533160684004, 
    0.14319799741026004`}, {-0.3407298274347052, 0.08026080379573056, 
    0.131748866608086}, {-0.3333736846483348, 0.09630795334285228, 
    0.11112456154944492`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3579949935256501, 0.09546533160684004, 
    0.14319799741026004`}, {-0.37415229431745833`, 0.07483045886349166, 
    0.1746044040148139}, {-0.3552530406979347, 0.0647349985271792, 
    0.15631133790709126`}, {-0.3407298274347052, 0.08026080379573056, 
    0.131748866608086}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.37415229431745833`, 0.07483045886349166, 
    0.1746044040148139}, {-0.3983729048897056, 0.05311638731862741, 
    0.21246554927450964`}, {-0.3754334096530939, 0.04838919502195432, 
    0.18521381542885962`}, {-0.3552530406979347, 0.0647349985271792, 
    0.15631133790709126`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3983729048897056, 0.05311638731862741, 
    0.21246554927450964`}, {-0.42781593715312194`, 0.028521062476874796`, 
    0.2566895622918732}, {-0.39956209892042155`, 0.030189136362876293`, 
    0.21842728074316375`}, {-0.3754334096530939, 0.04838919502195432, 
    0.18521381542885962`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.42781593715312194`, 0.028521062476874796`, 
    0.2566895622918732}, {-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.4260763439843505, 0.009468363199652228, 
    0.2556458063906103}, {-0.39956209892042155`, 0.030189136362876293`, 
    0.21842728074316375`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.38905011534806727`, 0., 
    0.20749339485230253`}, {-0.36589693116182753`, 0.008131042914707273, 
    0.18050915270650156`}, {-0.4260763439843505, 0.009468363199652228, 
    0.2556458063906103}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38905011534806727`, 0., 
    0.20749339485230253`}, {-0.30673802522798127`, 0., 
    0.1226952100911925}, {-0.2982832465218531, 0.006628516589374509, 
    0.11533618865511652`}, {-0.36589693116182753`, 0.008131042914707273, 
    0.18050915270650156`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.30673802522798127`, 0., 
    0.1226952100911925}, {-0.21282462147366246`, 0., 
    0.05675323239297665}, {-0.22335095439184463`, 0.004963354542040988, 
    0.06253826722971649}, {-0.2982832465218531, 0.006628516589374509, 
    0.11533618865511652`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21282462147366246`, 0., 
    0.05675323239297665}, {-0.10920608786993075`, 0., 
    0.014560811715990765`}, {-0.142224790973981, 0.003160550910532909, 
    0.0246522971021567}, {-0.22335095439184463`, 0.004963354542040988, 
    0.06253826722971649}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.10920608786993075`, 0., 0.014560811715990765`}, {
    0., 0., 0.}, {-0.05793069453624921, 0.0012873487674722039`, 
    0.0038620463024166113`}, {-0.142224790973981, 0.003160550910532909, 
    0.0246522971021567}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.4664505261905705, 0.06219340349207606, 
    0.3109670174603803}, {-0.4603228910236794, 0.07978930111077108, 
    0.2966525297708156}, {-0.45062802082557046`, 0.03004186805503801, 
    0.29040472453203425`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4664505261905705, 0.06219340349207606, 
    0.3109670174603803}, {-0.48461849963627207`, 0.12923159990300587`, 
    0.3230789997575147}, {-0.4773844806346103, 0.13366765457769086`, 
    0.30764777640897106`}, {-0.4603228910236794, 0.07978930111077108, 
    0.2966525297708156}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.48461849963627207`, 0.12923159990300587`, 
    0.3230789997575147}, {-0.5115370291932914, 0.20461481167731652`, 
    0.3410246861288609}, {-0.4999952944034249, 0.19333151383599093`, 
    0.32221918972665153`}, {-0.4773844806346103, 0.13366765457769086`, 
    0.30764777640897106`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5115370291932914, 0.20461481167731652`, 
    0.3410246861288609}, {-0.5440012355218949, 0.29013399227834397`, 
    0.36266749034792994`}, {-0.5263215102011988, 0.25965194503259137`, 
    0.3391849732407725}, {-0.4999952944034249, 0.19333151383599093`, 
    0.32221918972665153`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5440012355218949, 0.29013399227834397`, 
    0.36266749034792994`}, {-0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {-0.5549429157801637, 0.3329657494680982, 
    0.3576298790583277}, {-0.5263215102011988, 0.25965194503259137`, 
    0.3391849732407725}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {-0.5418425399938036, 0.3251055239962821, 
    0.3251055239962821}, {-0.5235616495156941, 0.2862137017352461, 
    0.30948310838038806`}, {-0.5549429157801637, 0.3329657494680982, 
    0.3576298790583277}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5418425399938036, 0.3251055239962821, 
    0.3251055239962821}, {-0.5012123976166442, 0.2673132787288769, 
    0.2673132787288769}, {-0.49007301405696324`, 0.24176935360143517`, 
    0.2635503764484113}, {-0.5235616495156941, 0.2862137017352461, 
    0.30948310838038806`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5012123976166442, 0.2673132787288769, 
    0.2673132787288769}, {-0.4566708874648107, 0.21311308081691166`, 
    0.21311308081691166`}, {-0.4539150995168281, 0.19972264378740437`, 
    0.2198966482103745}, {-0.49007301405696324`, 0.24176935360143517`, 
    0.2635503764484113}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4566708874648107, 0.21311308081691166`, 
    0.21311308081691166`}, {-0.40726070505008105`, 0.1629042820200324, 
    0.1629042820200324}, {-0.4146226594222878, 0.1603207616432846, 
    0.1787484353953863}, {-0.4539150995168281, 0.19972264378740437`, 
    0.2198966482103745}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.40726070505008105`, 0.1629042820200324, 
    0.1629042820200324}, {-0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {-0.37184302234147004`, 0.12394767411382335`, 
    0.1404740306623331}, {-0.4146226594222878, 0.1603207616432846, 
    0.1787484353953863}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {-0.3579949935256501, 0.09546533160684004, 
    0.14319799741026004`}, {-0.37788015107523965`, 0.10580644230106709`, 
    0.16290833179688105`}, {-0.37184302234147004`, 0.12394767411382335`, 
    0.1404740306623331}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3579949935256501, 0.09546533160684004, 
    0.14319799741026004`}, {-0.37415229431745833`, 0.07483045886349166, 
    0.1746044040148139}, {-0.38991864684146027`, 0.08838155995073098, 
    0.18889392224764073`}, {-0.37788015107523965`, 0.10580644230106709`, 
    0.16290833179688105`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.37415229431745833`, 0.07483045886349166, 
    0.1746044040148139}, {-0.3983729048897056, 0.05311638731862741, 
    0.21246554927450964`}, {-0.40689371670049274`, 0.07052824422808539, 
    0.2188183987589316}, {-0.38991864684146027`, 0.08838155995073098, 
    0.18889392224764073`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3983729048897056, 0.05311638731862741, 
    0.21246554927450964`}, {-0.42781593715312194`, 0.028521062476874796`, 
    0.2566895622918732}, {-0.4275386729168246, 0.05130464075001894, 
    0.2527228599908341}, {-0.40689371670049274`, 0.07052824422808539, 
    0.2188183987589316}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.42781593715312194`, 0.028521062476874796`, 
    0.2566895622918732}, {-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.45062802082557046`, 0.03004186805503801, 
    0.29040472453203425`}, {-0.4275386729168246, 0.05130464075001894, 
    0.2527228599908341}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {-0.10920608786993075`, 0., 
    0.014560811715990765`}, {-0.142224790973981, -0.003160550910532909, 
    0.0246522971021567}, {-0.05793069453624921, -0.0012873487674722039`, 
    0.0038620463024166113`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.10920608786993075`, 0., 
    0.014560811715990765`}, {-0.21282462147366246`, 0., 
    0.05675323239297665}, {-0.22335095439184463`, -0.004963354542040988, 
    0.06253826722971648}, {-0.142224790973981, -0.003160550910532909, 
    0.0246522971021567}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21282462147366246`, 0., 
    0.05675323239297665}, {-0.30673802522798127`, 0., 
    0.1226952100911925}, {-0.2982832465218531, -0.006628516589374509, 
    0.11533618865511652`}, {-0.22335095439184463`, -0.004963354542040988, 
    0.06253826722971648}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.30673802522798127`, 0., 
    0.1226952100911925}, {-0.38905011534806727`, 0., 
    0.20749339485230253`}, {-0.36589693116182753`, -0.008131042914707273, 
    0.18050915270650156`}, {-0.2982832465218531, -0.006628516589374509, 
    0.11533618865511652`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38905011534806727`, 0., 
    0.20749339485230253`}, {-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.4260763439843505, -0.009468363199652228, 
    0.2556458063906103}, {-0.36589693116182753`, -0.008131042914707273, 
    0.18050915270650156`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.42781593715312194`, -0.028521062476874796`, 
    0.2566895622918732}, {-0.39956209892042155`, -0.030189136362876293`, 
    0.21842728074316375`}, {-0.4260763439843505, -0.009468363199652228, 
    0.2556458063906103}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.42781593715312194`, -0.028521062476874796`, 
    0.2566895622918732}, {-0.3983729048897056, -0.05311638731862741, 
    0.21246554927450964`}, {-0.3754334096530939, -0.04838919502195432, 
    0.18521381542885962`}, {-0.39956209892042155`, -0.030189136362876293`, 
    0.21842728074316375`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3983729048897056, -0.05311638731862741, 
    0.21246554927450964`}, {-0.37415229431745833`, -0.07483045886349166, 
    0.1746044040148139}, {-0.3552530406979347, -0.0647349985271792, 
    0.15631133790709126`}, {-0.3754334096530939, -0.04838919502195432, 
    0.18521381542885962`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.37415229431745833`, -0.07483045886349166, 
    0.1746044040148139}, {-0.3579949935256501, -0.09546533160684004, 
    0.14319799741026004`}, {-0.3407298274347052, -0.08026080379573056, 
    0.131748866608086}, {-0.3552530406979347, -0.0647349985271792, 
    0.15631133790709126`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3579949935256501, -0.09546533160684004, 
    0.14319799741026004`}, {-0.35229120018115184`, -0.11743040006038394`, 
    0.11743040006038394`}, {-0.3333736846483348, -0.09630795334285228, 
    0.11112456154944492`}, {-0.3407298274347052, -0.08026080379573056, 
    0.131748866608086}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.35229120018115184`, -0.11743040006038394`, 
    0.11743040006038394`}, {-0.2914261673100827, -0.07771364461602205, 
    0.07771364461602205}, {-0.2837917818761621, -0.0668487308419404, 
    0.07946169892532537}, {-0.3333736846483348, -0.09630795334285228, 
    0.11112456154944492`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2914261673100827, -0.07771364461602205, 
    0.07771364461602205}, {-0.22479511109484523`, -0.04495902221896904, 
    0.04495902221896904}, {-0.23065124757750236`, -0.04202978289190042, 
    0.052280949450900525`}, {-0.2837917818761621, -0.0668487308419404, 
    0.07946169892532537}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.22479511109484523`, -0.04495902221896904, 
    0.04495902221896904}, {-0.15308565553031123`, -0.02041142073737483, 
    0.02041142073737483}, {-0.17441633647095503`, -0.02248032781181198, 
    0.030232164988298865`}, {-0.23065124757750236`, -0.04202978289190042, 
    0.052280949450900525`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.15308565553031123`, -0.02041142073737483, 
    0.02041142073737483}, {-0.07756663751797302, -0.005171109167864868, 
    0.005171109167864868}, {-0.11600941429253843`, -0.008765155746547347, 
    0.013921129715104607`}, {-0.17441633647095503`, -0.02248032781181198, 
    0.030232164988298865`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07756663751797302, -0.005171109167864868, 
    0.005171109167864868}, {0., 0., 
    0.}, {-0.05793069453624921, -0.0012873487674722039`, 
    0.0038620463024166113`}, {-0.11600941429253843`, -0.008765155746547347, 
    0.013921129715104607`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.42781593715312194`, -0.028521062476874796`, 
    0.2566895622918732}, {-0.4275386729168246, -0.05130464075001894, 
    0.2527228599908341}, {-0.45062802082557046`, -0.03004186805503801, 
    0.29040472453203425`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.42781593715312194`, -0.028521062476874796`, 
    0.2566895622918732}, {-0.3983729048897056, -0.05311638731862741, 
    0.21246554927450964`}, {-0.40689371670049274`, -0.07052824422808539, 
    0.2188183987589316}, {-0.4275386729168246, -0.05130464075001894, 
    0.2527228599908341}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3983729048897056, -0.05311638731862741, 
    0.21246554927450964`}, {-0.37415229431745833`, -0.07483045886349166, 
    0.1746044040148139}, {-0.38991864684146027`, -0.08838155995073098, 
    0.18889392224764073`}, {-0.40689371670049274`, -0.07052824422808539, 
    0.2188183987589316}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.37415229431745833`, -0.07483045886349166, 
    0.1746044040148139}, {-0.3579949935256501, -0.09546533160684004, 
    0.14319799741026004`}, {-0.37788015107523965`, -0.10580644230106709`, 
    0.16290833179688105`}, {-0.38991864684146027`, -0.08838155995073098, 
    0.18889392224764073`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3579949935256501, -0.09546533160684004, 
    0.14319799741026004`}, {-0.35229120018115184`, -0.11743040006038394`, 
    0.11743040006038394`}, {-0.37184302234147004`, -0.12394767411382335`, 
    0.1404740306623331}, {-0.37788015107523965`, -0.10580644230106709`, 
    0.16290833179688105`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.35229120018115184`, -0.11743040006038394`, 
    0.11743040006038394`}, {-0.40726070505008105`, -0.1629042820200324, 
    0.1629042820200324}, {-0.4146226594222878, -0.1603207616432846, 
    0.1787484353953863}, {-0.37184302234147004`, -0.12394767411382335`, 
    0.1404740306623331}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.40726070505008105`, -0.1629042820200324, 
    0.1629042820200324}, {-0.4566708874648107, -0.21311308081691166`, 
    0.21311308081691166`}, {-0.4539150995168281, -0.19972264378740437`, 
    0.2198966482103745}, {-0.4146226594222878, -0.1603207616432846, 
    0.1787484353953863}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4566708874648107, -0.21311308081691166`, 
    0.21311308081691166`}, {-0.5012123976166442, -0.2673132787288769, 
    0.2673132787288769}, {-0.49007301405696324`, -0.24176935360143517`, 
    0.2635503764484113}, {-0.4539150995168281, -0.19972264378740437`, 
    0.2198966482103745}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5012123976166442, -0.2673132787288769, 
    0.2673132787288769}, {-0.5418425399938036, -0.3251055239962821, 
    0.3251055239962821}, {-0.5235616495156941, -0.2862137017352461, 
    0.30948310838038806`}, {-0.49007301405696324`, -0.24176935360143517`, 
    0.2635503764484113}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5418425399938036, -0.3251055239962821, 
    0.3251055239962821}, {-0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {-0.5549429157801637, -0.3329657494680982, 
    0.3576298790583277}, {-0.5235616495156941, -0.2862137017352461, 
    0.30948310838038806`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {-0.5440012355218949, -0.29013399227834397`, 
    0.36266749034792994`}, {-0.5263215102011988, -0.25965194503259137`, 
    0.3391849732407725}, {-0.5549429157801637, -0.3329657494680982, 
    0.3576298790583277}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5440012355218949, -0.29013399227834397`, 
    0.36266749034792994`}, {-0.5115370291932914, -0.20461481167731652`, 
    0.3410246861288609}, {-0.4999952944034249, -0.19333151383599093`, 
    0.32221918972665153`}, {-0.5263215102011988, -0.25965194503259137`, 
    0.3391849732407725}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5115370291932914, -0.20461481167731652`, 
    0.3410246861288609}, {-0.48461849963627207`, -0.12923159990300587`, 
    0.3230789997575147}, {-0.4773844806346103, -0.1336676545776909, 
    0.30764777640897106`}, {-0.4999952944034249, -0.19333151383599093`, 
    0.32221918972665153`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.48461849963627207`, -0.12923159990300587`, 
    0.3230789997575147}, {-0.4664505261905705, -0.06219340349207606, 
    0.3109670174603803}, {-0.4603228910236794, -0.07978930111077108, 
    0.2966525297708156}, {-0.4773844806346103, -0.1336676545776909, 
    0.30764777640897106`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4664505261905705, -0.06219340349207606, 
    0.3109670174603803}, {-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.45062802082557046`, -0.03004186805503801, 
    0.29040472453203425`}, {-0.4603228910236794, -0.07978930111077108, 
    0.2966525297708156}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {-0.6103364275727268, 0.4407985310247471, 
    0.4407985310247471}, {-0.6164899353312527, 0.4452427310725714, 
    0.4589425074132659}, {-0.5920832028449382, 0.4013008374837915, 
    0.41445824199145676`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6103364275727268, 0.4407985310247471, 
    0.4407985310247471}, {-0.6412032180604118, 0.49871361404698694`, 
    0.49871361404698694`}, {-0.641248218995467, 0.4916236345631913, 
    0.5058735949853128}, {-0.6164899353312527, 0.4452427310725714, 
    0.4589425074132659}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6412032180604118, 0.49871361404698694`, 
    0.49871361404698694`}, {-0.6740385471308696, 0.5616987892757247, 
    0.5616987892757247}, {-0.6672459372836057, 0.5412105935744802, 
    0.5560382810696715}, {-0.641248218995467, 0.4916236345631913, 
    0.5058735949853128}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6740385471308696, 0.5616987892757247, 
    0.5616987892757247}, {-0.6751944561946608, 0.5251512437069583, 
    0.6001728499508097}, {-0.6683421713383466, 0.5123956646927323, 
    0.5866559059525488}, {-0.6672459372836057, 0.5412105935744802, 
    0.5560382810696715}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6751944561946608, 0.5251512437069583, 
    0.6001728499508097}, {-0.6786794799954298, 0.49015740221892146`, 
    0.6409750644401281}, {-0.670907588604451, 0.484544369547659, 
    0.6187258872685492}, {-0.6683421713383466, 0.5123956646927323, 
    0.5866559059525488}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6786794799954298, 0.49015740221892146`, 
    0.6409750644401281}, {-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.6749630549963996, 0.4574749594975597, 
    0.6524642864965196}, {-0.670907588604451, 0.484544369547659, 
    0.6187258872685492}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.6457005460543618, 0.4304670307029078, 
    0.5739560409372104}, {-0.6448463554356526, 0.43706252979527566`, 
    0.5660318008824062}, {-0.6749630549963996, 0.4574749594975597, 
    0.6524642864965196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6457005460543618, 0.4304670307029078, 
    0.5739560409372104}, {-0.6115080659765835, 0.40767204398438894`, 
    0.4756173846484537}, {-0.6176006003263583, 0.4185959624434206, 
    0.48721825136857155`}, {-0.6448463554356526, 0.43706252979527566`, 
    0.5660318008824062}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6115080659765835, 0.40767204398438894`, 
    0.4756173846484537}, {-0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {-0.5920832028449382, 0.4013008374837915, 
    0.41445824199145676`}, {-0.6176006003263583, 0.4185959624434206, 
    0.48721825136857155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.7171888530767329, 0.5578135523930144, 
    0.7171888530767329}, {-0.716165180138544, 0.5649747532204069, 
    0.7082077892481158}, {-0.6890827403984794, 0.48235791827893554`, 
    0.6814262655051629}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7171888530767329, 0.5578135523930144, 
    0.7171888530767329}, {-0.7640699024805022, 0.6791732466493353, 
    0.7640699024805022}, {-0.7520300306261339, 0.6601152491051621, 
    0.7436741413969546}, {-0.716165180138544, 0.5649747532204069, 
    0.7082077892481158}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7640699024805022, 0.6791732466493353, 
    0.7640699024805022}, {-0.9068996821171088, 0.9068996821171088, 
    0.9068996821171088}, {-0.8104554067121754, 0.7834402264884363, 
    0.8014503466375957}, {-0.7520300306261339, 0.6601152491051621, 
    0.7436741413969546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.9068996821171088, 0.9068996821171088, 
    0.9068996821171088}, {-0.7622103197175837, 0.7198653019554957, 
    0.7198653019554957}, {-0.7504115684601292, 0.6920462242465636, 
    0.7087220368790109}, {-0.8104554067121754, 0.7834402264884363, 
    0.8014503466375957}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7622103197175837, 0.7198653019554957, 
    0.7198653019554957}, {-0.7118600880536767, 0.6327645227143793, 
    0.6327645227143793}, {-0.7119126797168901, 0.6249011299737146, 
    0.6407214117452011}, {-0.7504115684601292, 0.6920462242465636, 
    0.7087220368790109}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7118600880536767, 0.6327645227143793, 
    0.6327645227143793}, {-0.6740385471308696, 0.5616987892757247, 
    0.5616987892757247}, {-0.6811124367744867, 0.5675936973120723, 
    0.5827295292403942}, {-0.7119126797168901, 0.6249011299737146, 
    0.6407214117452011}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6740385471308696, 0.5616987892757247, 
    0.5616987892757247}, {-0.6751944561946608, 0.5251512437069583, 
    0.6001728499508097}, {-0.68224035411735, 0.5382118349147983, 
    0.614016318705615}, {-0.6811124367744867, 0.5675936973120723, 
    0.5827295292403942}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6751944561946608, 0.5251512437069583, 
    0.6001728499508097}, {-0.6786794799954298, 0.49015740221892146`, 
    0.6409750644401281}, {-0.6848853908126196, 0.5098591242716168, 
    0.6468362024341406}, {-0.68224035411735, 0.5382118349147983, 
    0.614016318705615}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6786794799954298, 0.49015740221892146`, 
    0.6409750644401281}, {-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.6890827403984794, 0.48235791827893554`, 
    0.6814262655051629}, {-0.6848853908126196, 0.5098591242716168, 
    0.6468362024341406}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.46253818353867265`, 0.038544848628222717`, 
    0.30835878902578173`}, {-0.47507741354102534`, 0.052786379282336135`, 
    0.3272755515504841}, {-0.47150167762968676`, 0.020955630116874954`, 
    0.324812266811562}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.46253818353867265`, 0.038544848628222717`, 
    0.30835878902578173`}, {-0.46999171897491077`, 0.07833195316248512, 
    0.3133278126499405}, {-0.48154514744522636`, 0.08560802621248467, 
    0.33173110157337815`}, {-0.47507741354102534`, 0.052786379282336135`, 
    0.3272755515504841}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.46999171897491077`, 0.07833195316248512, 
    0.3133278126499405}, {-0.4817997617497233, 0.12044994043743079`, 
    0.32119984116648215`}, {-0.4906212440644457, 0.11992963743797559`, 
    0.3379835236888404}, {-0.48154514744522636`, 0.08560802621248467, 
    0.33173110157337815`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4817997617497233, 0.12044994043743079`, 
    0.32119984116648215`}, {-0.4971955577882874, 0.1657318525960958, 
    0.3314637051921916}, {-0.5019472405700409, 0.1561613637329016, 
    0.3457858768371393}, {-0.4906212440644457, 0.11992963743797559`, 
    0.3379835236888404}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4971955577882874, 0.1657318525960958, 
    0.3314637051921916}, {-0.530207257345758, 0.176735752448586, 
    0.39765544300931854`}, {-0.5286651530527192, 0.16447360317195706`, 
    0.3994358934176101}, {-0.5019472405700409, 0.1561613637329016, 
    0.3457858768371393}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.530207257345758, 0.176735752448586, 
    0.39765544300931854`}, {-0.5617994480029483, 0.18726648266764945`, 
    0.4681662066691236}, {-0.5543741420185859, 0.17247195529467113`, 
    0.4558187389930595}, {-0.5286651530527192, 0.16447360317195706`, 
    0.3994358934176101}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5617994480029483, 0.18726648266764945`, 
    0.4681662066691236}, {-0.5924835974670974, 0.19749453248903248`, 
    0.5431099643448393}, {-0.5793426974047388, 0.18023995030369647`, 
    0.5149712865819899}, {-0.5543741420185859, 0.17247195529467113`, 
    0.4558187389930595}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5924835974670974, 0.19749453248903248`, 
    0.5431099643448393}, {-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.6039532192067091, 0.18789655708653166`, 
    0.577110853908633}, {-0.5793426974047388, 0.18023995030369647`, 
    0.5149712865819899}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.5826314122526858, 0.14565785306317142`, 
    0.5340787945649619}, {-0.571505684936255, 0.13970138965108453`, 
    0.508005053276671}, {-0.6039532192067091, 0.18789655708653166`, 
    0.577110853908633}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5826314122526858, 0.14565785306317142`, 
    0.5340787945649619}, {-0.5423842382927654, 0.09039737304879422, 
    0.4519868652439711}, {-0.5388079575040883, 0.09578808133406011, 
    0.4430198761700281}, {-0.571505684936255, 0.13970138965108453`, 
    0.508005053276671}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5423842382927654, 0.09039737304879422, 
    0.4519868652439711}, {-0.5013779790164213, 0.041781498251368454`, 
    0.37603348426231603`}, {-0.5054364950419619, 0.05615961056021798, 
    0.38188535180948235`}, {-0.5388079575040883, 0.09578808133406011, 
    0.4430198761700281}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5013779790164213, 0.041781498251368454`, 
    0.37603348426231603`}, {-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.47150167762968676`, 0.020955630116874954`, 
    0.324812266811562}, {-0.5054364950419619, 0.05615961056021798, 
    0.38188535180948235`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.4875643330433564, 0.02708690739129757, 
    0.3521297960868685}, {-0.4977209701662121, 0.027651165009234, 
    0.37052561112373567`}, {-0.47617071567397445`, 0.005290785729710824, 
    0.33331950097178215`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4875643330433564, 0.02708690739129757, 
    0.3521297960868685}, {-0.5151364245658201, 0.057237380507313335`, 
    0.4006616635511933}, {-0.5192776126127516, 0.05192776126127516, 
    0.4096523388389484}, {-0.4977209701662121, 0.027651165009234, 
    0.37052561112373567`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5151364245658201, 0.057237380507313335`, 
    0.4006616635511933}, {-0.5423842382927654, 0.09039737304879422, 
    0.4519868652439711}, {-0.5406944571684102, 0.07810031047988147, 
    0.45057871430700847`}, {-0.5192776126127516, 0.05192776126127516, 
    0.4096523388389484}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5423842382927654, 0.09039737304879422, 
    0.4519868652439711}, {-0.5611088996560509, 0.06234543329511677, 
    0.49876346636093416`}, {-0.5561327685019032, 0.055613276850190324`, 
    0.48816098568500393`}, {-0.5406944571684102, 0.07810031047988147, 
    0.45057871430700847`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5611088996560509, 0.06234543329511677, 
    0.49876346636093416`}, {-0.5810366771432506, 0.03227981539684726, 
    0.5487568617464034}, {-0.5723000016162385, 0.03179444453423547, 
    0.5277877792683088}, {-0.5561327685019032, 0.055613276850190324`, 
    0.48816098568500393`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5810366771432506, 0.03227981539684726, 
    0.5487568617464034}, {-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.5891105858887445, 0.006545673176541602, 
    0.5694735663591197}, {-0.5723000016162385, 0.03179444453423547, 
    0.5277877792683088}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.5583263670978953, 0., 
    0.49629010408701807`}, {-0.5538610316580012, 0.006154011462866676, 
    0.4861669055664677}, {-0.5891105858887445, 0.006545673176541602, 
    0.5694735663591197}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5583263670978953, 0., 
    0.49629010408701807`}, {-0.5116766815928779, 0., 
    0.3979707523500161}, {-0.5165717745530933, 0.005739686383923255, 
    0.40751773325855134`}, {-0.5538610316580012, 0.006154011462866676, 
    0.4861669055664677}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5116766815928779, 0., 
    0.3979707523500161}, {-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.47617071567397445`, 0.005290785729710824, 
    0.33331950097178215`}, {-0.5165717745530933, 0.005739686383923255, 
    0.40751773325855134`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.6044295191828238, 0.06715883546475819, 
    0.6044295191828238}, {-0.6006503620708005, 0.0734128220308756, 
    0.5939764691589027}, {-0.597947646585002, 0.01993158821950005, 
    0.5913037838451686}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6044295191828238, 0.06715883546475819, 
    0.6044295191828238}, {-0.6115080659765835, 0.13589068132812965`, 
    0.6115080659765835}, {-0.6063763483828833, 0.12801278465860869`, 
    0.5996388334008513}, {-0.6006503620708005, 0.0734128220308756, 
    0.5939764691589027}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6115080659765835, 0.13589068132812965`, 
    0.6115080659765835}, {-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.615005336599669, 0.1845016009799007, 
    0.6081719439707838}, {-0.6063763483828833, 0.12801278465860869`, 
    0.5996388334008513}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.5960042485425239, 0.16555673570625662`, 
    0.5628929014012725}, {-0.5936572660606888, 0.15171241243773156`, 
    0.560676306835095}, {-0.615005336599669, 0.1845016009799007, 
    0.6081719439707838}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5960042485425239, 0.16555673570625662`, 
    0.5628929014012725}, {-0.5692683486017988, 0.12650407746706638`, 
    0.5060163098682655}, {-0.572511405971636, 0.12086351903845649`, 
    0.5152602653744724}, {-0.5936572660606888, 0.15171241243773156`, 
    0.560676306835095}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5692683486017988, 0.12650407746706638`, 
    0.5060163098682655}, {-0.5423842382927654, 0.09039737304879422, 
    0.4519868652439711}, {-0.5513356533463394, 0.09188927555772322, 
    0.4716982811963126}, {-0.572511405971636, 0.12086351903845649`, 
    0.5152602653744724}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5423842382927654, 0.09039737304879422, 
    0.4519868652439711}, {-0.5611088996560509, 0.06234543329511677, 
    0.49876346636093416`}, {-0.5660913502754553, 0.06918894281144454, 
    0.5094822152479098}, {-0.5513356533463394, 0.09188927555772322, 
    0.4716982811963126}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5611088996560509, 0.06234543329511677, 
    0.49876346636093416`}, {-0.5810366771432506, 0.03227981539684726, 
    0.5487568617464034}, {-0.5816501238360723, 0.04523945407613895, 
    0.5493362280674016}, {-0.5660913502754553, 0.06918894281144454, 
    0.5094822152479098}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5810366771432506, 0.03227981539684726, 
    0.5487568617464034}, {-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.597947646585002, 0.01993158821950005, 
    0.5913037838451686}, {-0.5816501238360723, 0.04523945407613895, 
    0.5493362280674016}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {-0.5570985386650793, 0.32497414755462956`, 
    0.3713990257767195}, {-0.5567535802997043, 0.30930754461094684`, 
    0.3835413553175741}, {-0.5740389519912366, 0.35717979235010267`, 
    0.39544905581618517`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5570985386650793, 0.32497414755462956`, 
    0.3713990257767195}, {-0.5355123085516112, 0.26775615427580557`, 
    0.35700820570107417`}, {-0.540269926225943, 0.26413196393268323`, 
    0.37218594917787184`}, {-0.5567535802997043, 0.30930754461094684`, 
    0.3835413553175741}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5355123085516112, 0.26775615427580557`, 
    0.35700820570107417`}, {-0.5153506733137513, 0.21472944721406304`, 
    0.34356711554250086`}, {-0.5247789208209833, 0.22157332212441513`, 
    0.3615143676766774}, {-0.540269926225943, 0.26413196393268323`, 
    0.37218594917787184`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5153506733137513, 0.21472944721406304`, 
    0.34356711554250086`}, {-0.4971955577882874, 0.1657318525960958, 
    0.3314637051921916}, {-0.510556692772321, 0.18153126854126964`, 
    0.35171683279870997`}, {-0.5247789208209833, 0.22157332212441513`, 
    0.3615143676766774}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4971955577882874, 0.1657318525960958, 
    0.3314637051921916}, {-0.530207257345758, 0.176735752448586, 
    0.39765544300931854`}, {-0.5362250673964656, 0.1906578017409655, 
    0.4051478286995518}, {-0.510556692772321, 0.18153126854126964`, 
    0.35171683279870997`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.530207257345758, 0.176735752448586, 
    0.39765544300931854`}, {-0.5617994480029483, 0.18726648266764945`, 
    0.4681662066691236}, {-0.5611088996560508, 0.19950538654437358`, 
    0.461356206383864}, {-0.5362250673964656, 0.1906578017409655, 
    0.4051478286995518}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5617994480029483, 0.18726648266764945`, 
    0.4681662066691236}, {-0.5924835974670974, 0.19749453248903248`, 
    0.5431099643448393}, {-0.5854544855134971, 0.20816159484924335`, 
    0.5204039871231084}, {-0.5611088996560508, 0.19950538654437358`, 
    0.461356206383864}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5924835974670974, 0.19749453248903248`, 
    0.5431099643448393}, {-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.6096319582097897, 0.21675802958570295`, 
    0.5825372045115768}, {-0.5854544855134971, 0.20816159484924335`, 
    0.5204039871231084}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.6047269112198952, 0.251969546341623, 
    0.5543330019515705}, {-0.5958580455279544, 0.2515845081118029, 
    0.5296515960248482}, {-0.6096319582097897, 0.21675802958570295`, 
    0.5825372045115768}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6047269112198952, 0.251969546341623, 
    0.5543330019515705}, {-0.5910954623679224, 0.29554773118396116`, 
    0.4925795519732687}, {-0.585151974032458, 0.2860742984158683, 
    0.4811249564266876}, {-0.5958580455279544, 0.2515845081118029, 
    0.5296515960248482}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5910954623679224, 0.29554773118396116`, 
    0.4925795519732687}, {-0.5826314122526858, 0.3398683238140667, 
    0.43697355918951436`}, {-0.5777936049257504, 0.32099644718097237`, 
    0.4365551681661225}, {-0.585151974032458, 0.2860742984158683, 
    0.4811249564266876}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5826314122526858, 0.3398683238140667, 
    0.43697355918951436`}, {-0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {-0.5740389519912366, 0.35717979235010267`, 
    0.39544905581618517`}, {-0.5777936049257504, 0.32099644718097237`, 
    0.4365551681661225}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {-0.5810366771432506, 0.3550779693653198, 
    0.41963760015901436`}, {-0.5877135047513313, 0.3591582529035913, 
    0.4375200535371022}, {-0.5861088600394483, 0.38422691935919384`, 
    0.41027620202761383`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5810366771432506, 0.3550779693653198, 
    0.41963760015901436`}, {-0.5848491491162138, 0.32491619395345206`, 
    0.45488267153483286`}, {-0.5908975428290927, 0.33484194093648584`, 
    0.46615250600961755`}, {-0.5877135047513313, 0.3591582529035913, 
    0.4375200535371022}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5848491491162138, 0.32491619395345206`, 
    0.45488267153483286`}, {-0.5910954623679224, 0.2955477311839612, 
    0.4925795519732687}, {-0.595614232557123, 0.31104298811316416`, 
    0.49634519379760245`}, {-0.5908975428290927, 0.33484194093648584`, 
    0.46615250600961755`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5910954623679224, 0.2955477311839612, 
    0.4925795519732687}, {-0.6207813146283735, 0.34487850812687415`, 
    0.5518056130029987}, {-0.6194466649498231, 0.3510197768048997, 
    0.5437365170115114}, {-0.595614232557123, 0.31104298811316416`, 
    0.49634519379760245`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6207813146283735, 0.34487850812687415`, 
    0.5518056130029987}, {-0.6513209538944295, 0.39802947182437354`, 
    0.6151364564558499}, {-0.643767236897451, 0.3934133114373311, 
    0.593696451805427}, {-0.6194466649498231, 0.3510197768048997, 
    0.5437365170115114}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6513209538944295, 0.39802947182437354`, 
    0.6151364564558499}, {-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.6694402964869484, 0.43885530547477725`, 
    0.6471256199373834}, {-0.643767236897451, 0.3934133114373311, 
    0.593696451805427}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.6457005460543618, 0.4304670307029078, 
    0.5739560409372104}, {-0.639447521013253, 0.41919337488646585`, 
    0.5612928240005222}, {-0.6694402964869484, 0.43885530547477725`, 
    0.6471256199373834}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6457005460543618, 0.4304670307029078, 
    0.5739560409372104}, {-0.6115080659765835, 0.40767204398438894`, 
    0.4756173846484537}, {-0.6120226278718142, 0.4012148338270782, 
    0.4828178508766534}, {-0.639447521013253, 0.41919337488646585`, 
    0.5612928240005222}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6115080659765835, 0.40767204398438894`, 
    0.4756173846484537}, {-0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {-0.5861088600394483, 0.38422691935919384`, 
    0.41027620202761383`}, {-0.6120226278718142, 0.4012148338270782, 
    0.4828178508766534}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.6592097133507697, 0.3662276185282054, 
    0.6592097133507697}, {-0.6529409809315125, 0.35549008961826795`, 
    0.6456860811433847}, {-0.6721945826966649, 0.4257232357078877, 
    0.6647257540000353}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6592097133507697, 0.3662276185282054, 
    0.6592097133507697}, {-0.6389520625760421, 0.2839786944782409, 
    0.6389520625760421}, {-0.6367433213395861, 0.2900719574991448, 
    0.629668395546924}, {-0.6529409809315125, 0.35549008961826795`, 
    0.6456860811433847}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6389520625760421, 0.2839786944782409, 
    0.6389520625760421}, {-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.6233044923807646, 0.22854498053961364`, 
    0.6163788869098672}, {-0.6367433213395861, 0.2900719574991448, 
    0.629668395546924}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, 0.20769184264312943`, 
    0.6230755279293883}, {-0.6103364275727265, 0.23735305516717142`, 
    0.5764288482631306}, {-0.6137026828435964, 0.25229999183570073`, 
    0.5796080893522855}, {-0.6233044923807646, 0.22854498053961364`, 
    0.6163788869098672}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6103364275727265, 0.23735305516717142`, 
    0.5764288482631306}, {-0.5996392451370365, 0.2665063311720162, 
    0.5330126623440324}, {-0.605427866219892, 0.2758060279446175, 
    0.5448850795979028}, {-0.6137026828435964, 0.25229999183570073`, 
    0.5796080893522855}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5996392451370365, 0.2665063311720162, 
    0.5330126623440324}, {-0.5910954623679224, 0.2955477311839612, 
    0.4925795519732687}, {-0.5985285392789631, 0.29926426963948155`, 
    0.5120744169386685}, {-0.605427866219892, 0.2758060279446175, 
    0.5448850795979028}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5910954623679224, 0.2955477311839612, 
    0.4925795519732687}, {-0.6207813146283735, 0.34487850812687415`, 
    0.5518056130029987}, {-0.6222047200687002, 0.33875590314851456`, 
    0.5599842480618302}, {-0.5985285392789631, 0.29926426963948155`, 
    0.5120744169386685}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6207813146283735, 0.34487850812687415`, 
    0.5518056130029987}, {-0.6513209538944295, 0.39802947182437354`, 
    0.6151364564558499}, {-0.6464647768296701, 0.3806959241330279, 
    0.6105500670057994}, {-0.6222047200687002, 0.33875590314851456`, 
    0.5599842480618302}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6513209538944295, 0.39802947182437354`, 
    0.6151364564558499}, {-0.6845537086570662, 0.4563691391047108, 
    0.6845537086570662}, {-0.6721945826966649, 0.4257232357078877, 
    0.6647257540000353}, {-0.6464647768296701, 0.3806959241330279, 
    0.6105500670057994}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {-0.5570985386650793, -0.32497414755462956`, 
    0.3713990257767195}, {-0.5567535802997043, -0.30930754461094684`, 
    0.3835413553175741}, {-0.5740389519912366, -0.35717979235010267`, 
    0.39544905581618517`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5570985386650793, -0.32497414755462956`, 
    0.3713990257767195}, {-0.5355123085516112, -0.26775615427580557`, 
    0.35700820570107417`}, {-0.540269926225943, -0.26413196393268323`, 
    0.37218594917787184`}, {-0.5567535802997043, -0.30930754461094684`, 
    0.3835413553175741}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5355123085516112, -0.26775615427580557`, 
    0.35700820570107417`}, {-0.5153506733137513, -0.21472944721406304`, 
    0.34356711554250086`}, {-0.5247789208209833, -0.22157332212441513`, 
    0.3615143676766774}, {-0.540269926225943, -0.26413196393268323`, 
    0.37218594917787184`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5153506733137513, -0.21472944721406304`, 
    0.34356711554250086`}, {-0.4971955577882874, -0.1657318525960958, 
    0.3314637051921916}, {-0.510556692772321, -0.18153126854126964`, 
    0.35171683279870997`}, {-0.5247789208209833, -0.22157332212441513`, 
    0.3615143676766774}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4971955577882874, -0.1657318525960958, 
    0.3314637051921916}, {-0.530207257345758, -0.176735752448586, 
    0.39765544300931854`}, {-0.5362250673964656, -0.1906578017409655, 
    0.4051478286995518}, {-0.510556692772321, -0.18153126854126964`, 
    0.35171683279870997`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.530207257345758, -0.176735752448586, 
    0.39765544300931854`}, {-0.5617994480029483, -0.18726648266764945`, 
    0.4681662066691236}, {-0.5611088996560508, -0.19950538654437358`, 
    0.461356206383864}, {-0.5362250673964656, -0.1906578017409655, 
    0.4051478286995518}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5617994480029483, -0.18726648266764945`, 
    0.4681662066691236}, {-0.5924835974670974, -0.19749453248903248`, 
    0.5431099643448393}, {-0.5854544855134971, -0.20816159484924335`, 
    0.5204039871231084}, {-0.5611088996560508, -0.19950538654437358`, 
    0.461356206383864}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5924835974670974, -0.19749453248903248`, 
    0.5431099643448393}, {-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.6096319582097897, -0.21675802958570295`, 
    0.5825372045115768}, {-0.5854544855134971, -0.20816159484924335`, 
    0.5204039871231084}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.6047269112198952, -0.251969546341623, 
    0.5543330019515705}, {-0.5958580455279544, -0.2515845081118029, 
    0.5296515960248482}, {-0.6096319582097897, -0.21675802958570295`, 
    0.5825372045115768}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6047269112198952, -0.251969546341623, 
    0.5543330019515705}, {-0.5910954623679224, -0.29554773118396116`, 
    0.4925795519732687}, {-0.585151974032458, -0.2860742984158683, 
    0.4811249564266876}, {-0.5958580455279544, -0.2515845081118029, 
    0.5296515960248482}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5910954623679224, -0.29554773118396116`, 
    0.4925795519732687}, {-0.5826314122526858, -0.3398683238140667, 
    0.43697355918951436`}, {-0.5777936049257504, -0.32099644718097237`, 
    0.4365551681661225}, {-0.585151974032458, -0.2860742984158683, 
    0.4811249564266876}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5826314122526858, -0.3398683238140667, 
    0.43697355918951436`}, {-0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {-0.5740389519912366, -0.35717979235010267`, 
    0.39544905581618517`}, {-0.5777936049257504, -0.32099644718097237`, 
    0.4365551681661225}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {-0.5810366771432506, -0.3550779693653198, 
    0.41963760015901436`}, {-0.5877135047513313, -0.3591582529035913, 
    0.4375200535371022}, {-0.5861088600394483, -0.38422691935919384`, 
    0.41027620202761383`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5810366771432506, -0.3550779693653198, 
    0.41963760015901436`}, {-0.5848491491162138, -0.32491619395345206`, 
    0.45488267153483286`}, {-0.5908975428290927, -0.33484194093648584`, 
    0.46615250600961755`}, {-0.5877135047513313, -0.3591582529035913, 
    0.4375200535371022}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5848491491162138, -0.32491619395345206`, 
    0.45488267153483286`}, {-0.5910954623679224, -0.2955477311839612, 
    0.4925795519732687}, {-0.595614232557123, -0.31104298811316416`, 
    0.49634519379760245`}, {-0.5908975428290927, -0.33484194093648584`, 
    0.46615250600961755`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5910954623679224, -0.2955477311839612, 
    0.4925795519732687}, {-0.6207813146283735, -0.34487850812687415`, 
    0.5518056130029987}, {-0.6194466649498231, -0.3510197768048997, 
    0.5437365170115114}, {-0.595614232557123, -0.31104298811316416`, 
    0.49634519379760245`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6207813146283735, -0.34487850812687415`, 
    0.5518056130029987}, {-0.6513209538944295, -0.39802947182437354`, 
    0.6151364564558499}, {-0.643767236897451, -0.3934133114373311, 
    0.593696451805427}, {-0.6194466649498231, -0.3510197768048997, 
    0.5437365170115114}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6513209538944295, -0.39802947182437354`, 
    0.6151364564558499}, {-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.6694402964869484, -0.43885530547477725`, 
    0.6471256199373834}, {-0.643767236897451, -0.3934133114373311, 
    0.593696451805427}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.6457005460543618, -0.4304670307029078, 
    0.5739560409372104}, {-0.639447521013253, -0.41919337488646585`, 
    0.5612928240005222}, {-0.6694402964869484, -0.43885530547477725`, 
    0.6471256199373834}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6457005460543618, -0.4304670307029078, 
    0.5739560409372104}, {-0.6115080659765835, -0.40767204398438894`, 
    0.4756173846484537}, {-0.6120226278718142, -0.4012148338270782, 
    0.4828178508766534}, {-0.639447521013253, -0.41919337488646585`, 
    0.5612928240005222}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6115080659765835, -0.40767204398438894`, 
    0.4756173846484537}, {-0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {-0.5861088600394483, -0.38422691935919384`, 
    0.41027620202761383`}, {-0.6120226278718142, -0.4012148338270782, 
    0.4828178508766534}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.6592097133507697, -0.3662276185282054, 
    0.6592097133507697}, {-0.6529409809315125, -0.35549008961826795`, 
    0.6456860811433847}, {-0.6721945826966649, -0.4257232357078877, 
    0.6647257540000353}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6592097133507697, -0.3662276185282054, 
    0.6592097133507697}, {-0.6389520625760421, -0.2839786944782409, 
    0.6389520625760421}, {-0.6367433213395861, -0.2900719574991448, 
    0.629668395546924}, {-0.6529409809315125, -0.35549008961826795`, 
    0.6456860811433847}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6389520625760421, -0.2839786944782409, 
    0.6389520625760421}, {-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.6233044923807646, -0.22854498053961364`, 
    0.6163788869098672}, {-0.6367433213395861, -0.2900719574991448, 
    0.629668395546924}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.6103364275727265, -0.23735305516717142`, 
    0.5764288482631306}, {-0.6137026828435964, -0.25229999183570073`, 
    0.5796080893522855}, {-0.6233044923807646, -0.22854498053961364`, 
    0.6163788869098672}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6103364275727265, -0.23735305516717142`, 
    0.5764288482631306}, {-0.5996392451370365, -0.2665063311720162, 
    0.5330126623440324}, {-0.605427866219892, -0.2758060279446175, 
    0.5448850795979028}, {-0.6137026828435964, -0.25229999183570073`, 
    0.5796080893522855}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5996392451370365, -0.2665063311720162, 
    0.5330126623440324}, {-0.5910954623679224, -0.2955477311839612, 
    0.4925795519732687}, {-0.5985285392789631, -0.29926426963948155`, 
    0.5120744169386685}, {-0.605427866219892, -0.2758060279446175, 
    0.5448850795979028}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5910954623679224, -0.2955477311839612, 
    0.4925795519732687}, {-0.6207813146283735, -0.34487850812687415`, 
    0.5518056130029987}, {-0.6222047200687002, -0.33875590314851456`, 
    0.5599842480618302}, {-0.5985285392789631, -0.29926426963948155`, 
    0.5120744169386685}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6207813146283735, -0.34487850812687415`, 
    0.5518056130029987}, {-0.6513209538944295, -0.39802947182437354`, 
    0.6151364564558499}, {-0.6464647768296701, -0.3806959241330279, 
    0.6105500670057994}, {-0.6222047200687002, -0.33875590314851456`, 
    0.5599842480618302}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6513209538944295, -0.39802947182437354`, 
    0.6151364564558499}, {-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.6721945826966649, -0.4257232357078877, 
    0.6647257540000353}, {-0.6464647768296701, -0.3806959241330279, 
    0.6105500670057994}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.46253818353867265`, -0.038544848628222717`, 
    0.30835878902578173`}, {-0.47507741354102534`, -0.052786379282336135`, 
    0.3272755515504841}, {-0.47150167762968676`, -0.020955630116874954`, 
    0.324812266811562}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.46253818353867265`, -0.038544848628222717`, 
    0.30835878902578173`}, {-0.46999171897491077`, -0.07833195316248512, 
    0.3133278126499405}, {-0.48154514744522636`, -0.08560802621248467, 
    0.33173110157337815`}, {-0.47507741354102534`, -0.052786379282336135`, 
    0.3272755515504841}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.46999171897491077`, -0.07833195316248512, 
    0.3133278126499405}, {-0.4817997617497233, -0.12044994043743079`, 
    0.32119984116648215`}, {-0.4906212440644457, -0.11992963743797559`, 
    0.3379835236888404}, {-0.48154514744522636`, -0.08560802621248467, 
    0.33173110157337815`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4817997617497233, -0.12044994043743079`, 
    0.32119984116648215`}, {-0.4971955577882874, -0.1657318525960958, 
    0.3314637051921916}, {-0.5019472405700409, -0.1561613637329016, 
    0.3457858768371393}, {-0.4906212440644457, -0.11992963743797559`, 
    0.3379835236888404}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4971955577882874, -0.1657318525960958, 
    0.3314637051921916}, {-0.530207257345758, -0.176735752448586, 
    0.39765544300931854`}, {-0.5286651530527192, -0.16447360317195706`, 
    0.3994358934176101}, {-0.5019472405700409, -0.1561613637329016, 
    0.3457858768371393}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.530207257345758, -0.176735752448586, 
    0.39765544300931854`}, {-0.5617994480029483, -0.18726648266764945`, 
    0.4681662066691236}, {-0.5543741420185859, -0.17247195529467113`, 
    0.4558187389930595}, {-0.5286651530527192, -0.16447360317195706`, 
    0.3994358934176101}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5617994480029483, -0.18726648266764945`, 
    0.4681662066691236}, {-0.5924835974670974, -0.19749453248903248`, 
    0.5431099643448393}, {-0.5793426974047388, -0.18023995030369647`, 
    0.5149712865819899}, {-0.5543741420185859, -0.17247195529467113`, 
    0.4558187389930595}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5924835974670974, -0.19749453248903248`, 
    0.5431099643448393}, {-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.6039532192067091, -0.18789655708653166`, 
    0.577110853908633}, {-0.5793426974047388, -0.18023995030369647`, 
    0.5149712865819899}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.5826314122526858, -0.14565785306317142`, 
    0.5340787945649619}, {-0.571505684936255, -0.13970138965108453`, 
    0.508005053276671}, {-0.6039532192067091, -0.18789655708653166`, 
    0.577110853908633}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5826314122526858, -0.14565785306317142`, 
    0.5340787945649619}, {-0.5423842382927654, -0.09039737304879422, 
    0.4519868652439711}, {-0.5388079575040883, -0.09578808133406011, 
    0.4430198761700281}, {-0.571505684936255, -0.13970138965108453`, 
    0.508005053276671}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5423842382927654, -0.09039737304879422, 
    0.4519868652439711}, {-0.5013779790164213, -0.041781498251368454`, 
    0.37603348426231603`}, {-0.5054364950419619, -0.05615961056021798, 
    0.38188535180948235`}, {-0.5388079575040883, -0.09578808133406011, 
    0.4430198761700281}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5013779790164213, -0.041781498251368454`, 
    0.37603348426231603`}, {-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.47150167762968676`, -0.020955630116874954`, 
    0.324812266811562}, {-0.5054364950419619, -0.05615961056021798, 
    0.38188535180948235`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.4875643330433564, -0.02708690739129757, 
    0.3521297960868685}, {-0.4977209701662121, -0.027651165009234, 
    0.37052561112373567`}, {-0.47617071567397445`, -0.005290785729710824, 
    0.33331950097178215`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4875643330433564, -0.02708690739129757, 
    0.3521297960868685}, {-0.5151364245658201, -0.057237380507313335`, 
    0.4006616635511933}, {-0.5192776126127516, -0.05192776126127516, 
    0.4096523388389484}, {-0.4977209701662121, -0.027651165009234, 
    0.37052561112373567`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5151364245658201, -0.057237380507313335`, 
    0.4006616635511933}, {-0.5423842382927654, -0.09039737304879422, 
    0.4519868652439711}, {-0.5406944571684102, -0.07810031047988147, 
    0.45057871430700847`}, {-0.5192776126127516, -0.05192776126127516, 
    0.4096523388389484}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5423842382927654, -0.09039737304879422, 
    0.4519868652439711}, {-0.5611088996560509, -0.06234543329511677, 
    0.49876346636093416`}, {-0.5561327685019032, -0.055613276850190324`, 
    0.48816098568500393`}, {-0.5406944571684102, -0.07810031047988147, 
    0.45057871430700847`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5611088996560509, -0.06234543329511677, 
    0.49876346636093416`}, {-0.5810366771432506, -0.03227981539684726, 
    0.5487568617464034}, {-0.5723000016162385, -0.03179444453423547, 
    0.5277877792683088}, {-0.5561327685019032, -0.055613276850190324`, 
    0.48816098568500393`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5810366771432506, -0.03227981539684726, 
    0.5487568617464034}, {-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.5891105858887445, -0.006545673176541602, 
    0.5694735663591197}, {-0.5723000016162385, -0.03179444453423547, 
    0.5277877792683088}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.5583263670978953, 0., 
    0.49629010408701807`}, {-0.5538610316580012, -0.006154011462866676, 
    0.4861669055664677}, {-0.5891105858887445, -0.006545673176541602, 
    0.5694735663591197}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5583263670978953, 0., 
    0.49629010408701807`}, {-0.5116766815928779, 0., 
    0.3979707523500161}, {-0.5165717745530933, -0.005739686383923255, 
    0.40751773325855134`}, {-0.5538610316580012, -0.006154011462866676, 
    0.4861669055664677}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5116766815928779, 0., 
    0.3979707523500161}, {-0.45998714286871445`, 0., 
    0.3066580952458096}, {-0.47617071567397445`, -0.005290785729710824, 
    0.33331950097178215`}, {-0.5165717745530933, -0.005739686383923255, 
    0.40751773325855134`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.6044295191828238, -0.06715883546475819, 
    0.6044295191828238}, {-0.6006503620708005, -0.0734128220308756, 
    0.5939764691589027}, {-0.597947646585002, -0.01993158821950005, 
    0.5913037838451686}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6044295191828238, -0.06715883546475819, 
    0.6044295191828238}, {-0.6115080659765835, -0.13589068132812965`, 
    0.6115080659765835}, {-0.6063763483828833, -0.12801278465860869`, 
    0.5996388334008513}, {-0.6006503620708005, -0.0734128220308756, 
    0.5939764691589027}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6115080659765835, -0.13589068132812965`, 
    0.6115080659765835}, {-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.615005336599669, -0.1845016009799007, 
    0.6081719439707838}, {-0.6063763483828833, -0.12801278465860869`, 
    0.5996388334008513}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, -0.20769184264312943`, 
    0.6230755279293883}, {-0.5960042485425239, -0.16555673570625662`, 
    0.5628929014012725}, {-0.5936572660606888, -0.15171241243773156`, 
    0.560676306835095}, {-0.615005336599669, -0.1845016009799007, 
    0.6081719439707838}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5960042485425239, -0.16555673570625662`, 
    0.5628929014012725}, {-0.5692683486017988, -0.12650407746706638`, 
    0.5060163098682655}, {-0.572511405971636, -0.12086351903845649`, 
    0.5152602653744724}, {-0.5936572660606888, -0.15171241243773156`, 
    0.560676306835095}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5692683486017988, -0.12650407746706638`, 
    0.5060163098682655}, {-0.5423842382927654, -0.09039737304879422, 
    0.4519868652439711}, {-0.5513356533463394, -0.09188927555772322, 
    0.4716982811963126}, {-0.572511405971636, -0.12086351903845649`, 
    0.5152602653744724}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5423842382927654, -0.09039737304879422, 
    0.4519868652439711}, {-0.5611088996560509, -0.06234543329511677, 
    0.49876346636093416`}, {-0.5660913502754553, -0.06918894281144454, 
    0.5094822152479098}, {-0.5513356533463394, -0.09188927555772322, 
    0.4716982811963126}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5611088996560509, -0.06234543329511677, 
    0.49876346636093416`}, {-0.5810366771432506, -0.03227981539684726, 
    0.5487568617464034}, {-0.5816501238360723, -0.04523945407613895, 
    0.5493362280674016}, {-0.5660913502754553, -0.06918894281144454, 
    0.5094822152479098}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5810366771432506, -0.03227981539684726, 
    0.5487568617464034}, {-0.6020420732135735, 0., 
    0.6020420732135735}, {-0.597947646585002, -0.01993158821950005, 
    0.5913037838451686}, {-0.5816501238360723, -0.04523945407613895, 
    0.5493362280674016}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {-0.6115080659765835, -0.40767204398438894`, 
    0.4756173846484537}, {-0.6176006003263583, -0.4185959624434206, 
    0.48721825136857155`}, {-0.5920832028449382, -0.4013008374837915, 
    0.41445824199145676`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6115080659765835, -0.40767204398438894`, 
    0.4756173846484537}, {-0.6457005460543618, -0.4304670307029078, 
    0.5739560409372104}, {-0.6448463554356526, -0.43706252979527566`, 
    0.5660318008824062}, {-0.6176006003263583, -0.4185959624434206, 
    0.48721825136857155`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6457005460543618, -0.4304670307029078, 
    0.5739560409372104}, {-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.6749630549963996, -0.4574749594975597, 
    0.6524642864965196}, {-0.6448463554356526, -0.43706252979527566`, 
    0.5660318008824062}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.6786794799954298, -0.49015740221892146`, 
    0.6409750644401281}, {-0.670907588604451, -0.484544369547659, 
    0.6187258872685492}, {-0.6749630549963996, -0.4574749594975597, 
    0.6524642864965196}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6786794799954298, -0.49015740221892146`, 
    0.6409750644401281}, {-0.6751944561946608, -0.5251512437069583, 
    0.6001728499508097}, {-0.6683421713383466, -0.5123956646927323, 
    0.5866559059525488}, {-0.670907588604451, -0.484544369547659, 
    0.6187258872685492}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6751944561946608, -0.5251512437069583, 
    0.6001728499508097}, {-0.6740385471308696, -0.5616987892757247, 
    0.5616987892757247}, {-0.6672459372836057, -0.5412105935744802, 
    0.5560382810696715}, {-0.6683421713383466, -0.5123956646927323, 
    0.5866559059525488}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6740385471308696, -0.5616987892757247, 
    0.5616987892757247}, {-0.6412032180604118, -0.49871361404698694`, 
    0.49871361404698694`}, {-0.641248218995467, -0.4916236345631913, 
    0.5058735949853128}, {-0.6672459372836057, -0.5412105935744802, 
    0.5560382810696715}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6412032180604118, -0.49871361404698694`, 
    0.49871361404698694`}, {-0.6103364275727268, -0.4407985310247471, 
    0.4407985310247471}, {-0.6164899353312527, -0.4452427310725714, 
    0.4589425074132659}, {-0.641248218995467, -0.4916236345631913, 
    0.5058735949853128}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6103364275727268, -0.4407985310247471, 
    0.4407985310247471}, {-0.5797543124923197, -0.38650287499487973`, 
    0.38650287499487973`}, {-0.5920832028449382, -0.4013008374837915, 
    0.41445824199145676`}, {-0.6164899353312527, -0.4452427310725714, 
    0.4589425074132659}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.6786794799954298, -0.49015740221892146`, 
    0.6409750644401281}, {-0.6848853908126196, -0.5098591242716168, 
    0.6468362024341406}, {-0.6890827403984794, -0.48235791827893554`, 
    0.6814262655051629}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6786794799954298, -0.49015740221892146`, 
    0.6409750644401281}, {-0.6751944561946608, -0.5251512437069583, 
    0.6001728499508097}, {-0.68224035411735, -0.5382118349147983, 
    0.614016318705615}, {-0.6848853908126196, -0.5098591242716168, 
    0.6468362024341406}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6751944561946608, -0.5251512437069583, 
    0.6001728499508097}, {-0.6740385471308696, -0.5616987892757247, 
    0.5616987892757247}, {-0.6811124367744867, -0.5675936973120723, 
    0.5827295292403942}, {-0.68224035411735, -0.5382118349147983, 
    0.614016318705615}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6740385471308696, -0.5616987892757247, 
    0.5616987892757247}, {-0.7118600880536767, -0.6327645227143793, 
    0.6327645227143793}, {-0.7119126797168901, -0.6249011299737146, 
    0.6407214117452011}, {-0.6811124367744867, -0.5675936973120723, 
    0.5827295292403942}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7118600880536767, -0.6327645227143793, 
    0.6327645227143793}, {-0.7622103197175837, -0.7198653019554957, 
    0.7198653019554957}, {-0.7504115684601292, -0.6920462242465636, 
    0.7087220368790109}, {-0.7119126797168901, -0.6249011299737146, 
    0.6407214117452011}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7622103197175837, -0.7198653019554957, 
    0.7198653019554957}, {-0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {-0.8104554067121754, -0.7834402264884363, 
    0.8014503466375957}, {-0.7504115684601292, -0.6920462242465636, 
    0.7087220368790109}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.9068996821171088, -0.9068996821171088, 
    0.9068996821171088}, {-0.7640699024805022, -0.6791732466493353, 
    0.7640699024805022}, {-0.7520300306261339, -0.6601152491051621, 
    0.7436741413969546}, {-0.8104554067121754, -0.7834402264884363, 
    0.8014503466375957}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7640699024805022, -0.6791732466493353, 
    0.7640699024805022}, {-0.7171888530767329, -0.5578135523930144, 
    0.7171888530767329}, {-0.716165180138544, -0.5649747532204069, 
    0.7082077892481158}, {-0.7520300306261339, -0.6601152491051621, 
    0.7436741413969546}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7171888530767329, -0.5578135523930144, 
    0.7171888530767329}, {-0.6845537086570662, -0.4563691391047108, 
    0.6845537086570662}, {-0.6890827403984794, -0.48235791827893554`, 
    0.6814262655051629}, {-0.716165180138544, -0.5649747532204069, 
    0.7082077892481158}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{0., 0., 0.}, {-0.07756663751797302, 
    0.005171109167864868, -0.005171109167864868}, {-0.11600941429253843`, 
    0.013921129715104607`, -0.008765155746547347}, {-0.05793069453624921, 
    0.0038620463024166113`, -0.0012873487674722039`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07756663751797302, 
    0.005171109167864868, -0.005171109167864868}, {-0.15308565553031123`, 
    0.02041142073737483, -0.02041142073737483}, {-0.17441633647095503`, 
    0.030232164988298865`, -0.02248032781181198}, {-0.11600941429253843`, 
    0.013921129715104607`, -0.008765155746547347}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.15308565553031123`, 
    0.02041142073737483, -0.02041142073737483}, {-0.22479511109484523`, 
    0.04495902221896904, -0.04495902221896904}, {-0.23065124757750236`, 
    0.052280949450900525`, -0.04202978289190042}, {-0.17441633647095503`, 
    0.030232164988298865`, -0.02248032781181198}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.22479511109484523`, 
    0.04495902221896904, -0.04495902221896904}, {-0.2914261673100827, 
    0.07771364461602205, -0.07771364461602205}, {-0.2837917818761621, 
    0.07946169892532537, -0.0668487308419404}, {-0.23065124757750236`, 
    0.052280949450900525`, -0.04202978289190042}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2914261673100827, 
    0.07771364461602205, -0.07771364461602205}, {-0.35229120018115184`, 
    0.11743040006038394`, -0.11743040006038394`}, {-0.3333736846483348, 
    0.11112456154944492`, -0.09630795334285228}, {-0.2837917818761621, 
    0.07946169892532537, -0.0668487308419404}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{-0.35229120018115184`, 
    0.11743040006038394`, -0.11743040006038394`}, {-0.3579949935256501, 
    0.14319799741026004`, -0.09546533160684004}, {-0.3407298274347052, 
    0.131748866608086, -0.08026080379573056}, {-0.3333736846483348, 
    0.11112456154944492`, -0.09630795334285228}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3579949935256501, 
    0.14319799741026004`, -0.09546533160684004}, {-0.37415229431745833`, 
    0.1746044040148139, -0.07483045886349166}, {-0.3552530406979347, 
    0.15631133790709126`, -0.0647349985271792}, {-0.3407298274347052, 
    0.131748866608086, -0.08026080379573056}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.37415229431745833`, 
    0.1746044040148139, -0.07483045886349166}, {-0.3983729048897056, 
    0.21246554927450964`, -0.05311638731862741}, {-0.3754334096530939, 
    0.18521381542885962`, -0.04838919502195432}, {-0.3552530406979347, 
    0.15631133790709126`, -0.0647349985271792}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3983729048897056, 
    0.21246554927450964`, -0.05311638731862741}, {-0.42781593715312194`, 
    0.2566895622918732, -0.028521062476874796`}, {-0.39956209892042155`, 
    0.21842728074316375`, -0.030189136362876293`}, {-0.3754334096530939, 
    0.18521381542885962`, -0.04838919502195432}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.42781593715312194`, 
    0.2566895622918732, -0.028521062476874796`}, {-0.45998714286871445`, 
    0.3066580952458096, 0.}, {-0.4260763439843505, 
    0.2556458063906103, -0.009468363199652228}, {-0.39956209892042155`, 
    0.21842728074316375`, -0.030189136362876293`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45998714286871445`, 0.3066580952458096, 
    0.}, {-0.38905011534806727`, 0.20749339485230253`, 
    0.}, {-0.36589693116182753`, 
    0.18050915270650156`, -0.008131042914707273}, {-0.4260763439843505, 
    0.2556458063906103, -0.009468363199652228}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38905011534806727`, 0.20749339485230253`, 
    0.}, {-0.30673802522798127`, 0.1226952100911925, 
    0.}, {-0.2982832465218531, 
    0.11533618865511652`, -0.006628516589374509}, {-0.36589693116182753`, 
    0.18050915270650156`, -0.008131042914707273}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.30673802522798127`, 0.1226952100911925, 
    0.}, {-0.21282462147366246`, 0.05675323239297665, 
    0.}, {-0.22335095439184463`, 
    0.06253826722971649, -0.004963354542040988}, {-0.2982832465218531, 
    0.11533618865511652`, -0.006628516589374509}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21282462147366246`, 0.05675323239297665, 
    0.}, {-0.10920608786993075`, 0.014560811715990765`, 
    0.}, {-0.142224790973981, 
    0.0246522971021567, -0.003160550910532909}, {-0.22335095439184463`, 
    0.06253826722971649, -0.004963354542040988}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.10920608786993075`, 0.014560811715990765`, 0.}, {
    0., 0., 0.}, {-0.05793069453624921, 
    0.0038620463024166113`, -0.0012873487674722039`}, {-0.142224790973981, 
    0.0246522971021567, -0.003160550910532909}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45998714286871445`, 0.3066580952458096, 
    0.}, {-0.4664505261905705, 
    0.3109670174603803, -0.06219340349207606}, {-0.4603228910236794, 
    0.2966525297708156, -0.07978930111077108}, {-0.45062802082557046`, 
    0.29040472453203425`, -0.03004186805503801}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4664505261905705, 
    0.3109670174603803, -0.06219340349207606}, {-0.48461849963627207`, 
    0.3230789997575147, -0.12923159990300587`}, {-0.4773844806346105, 
    0.3076477764089712, -0.1336676545776909}, {-0.4603228910236794, 
    0.2966525297708156, -0.07978930111077108}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{-0.48461849963627207`, 
    0.3230789997575147, -0.12923159990300587`}, {-0.5115370291932914, 
    0.3410246861288609, -0.20461481167731652`}, {-0.49999529440342494`, 
    0.3222191897266516, -0.19333151383599095`}, {-0.4773844806346105, 
    0.3076477764089712, -0.1336676545776909}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5115370291932914, 
    0.3410246861288609, -0.20461481167731652`}, {-0.5440012355218949, 
    0.36266749034792994`, -0.29013399227834397`}, {-0.5263215102011988, 
    0.3391849732407725, -0.25965194503259137`}, {-0.49999529440342494`, 
    0.3222191897266516, -0.19333151383599095`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5440012355218949, 
    0.36266749034792994`, -0.29013399227834397`}, {-0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {-0.5549429157801637, 
    0.3576298790583277, -0.3329657494680982}, {-0.5263215102011988, 
    0.3391849732407725, -0.25965194503259137`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {-0.5418425399938036, 
    0.3251055239962821, -0.3251055239962821}, {-0.5235616495156941, 
    0.30948310838038806`, -0.2862137017352461}, {-0.5549429157801637, 
    0.3576298790583277, -0.3329657494680982}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5418425399938036, 
    0.3251055239962821, -0.3251055239962821}, {-0.5012123976166442, 
    0.2673132787288769, -0.2673132787288769}, {-0.49007301405696324`, 
    0.2635503764484113, -0.24176935360143517`}, {-0.5235616495156941, 
    0.30948310838038806`, -0.2862137017352461}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5012123976166442, 
    0.2673132787288769, -0.2673132787288769}, {-0.4566708874648107, 
    0.21311308081691166`, -0.21311308081691166`}, {-0.4539150995168281, 
    0.2198966482103745, -0.19972264378740437`}, {-0.49007301405696324`, 
    0.2635503764484113, -0.24176935360143517`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4566708874648107, 
    0.21311308081691166`, -0.21311308081691166`}, {-0.40726070505008105`, 
    0.1629042820200324, -0.1629042820200324}, {-0.4146226594222878, 
    0.1787484353953863, -0.1603207616432846}, {-0.4539150995168281, 
    0.2198966482103745, -0.19972264378740437`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.40726070505008105`, 
    0.1629042820200324, -0.1629042820200324}, {-0.35229120018115184`, 
    0.11743040006038394`, -0.11743040006038394`}, {-0.37184302234147004`, 
    0.1404740306623331, -0.12394767411382335`}, {-0.4146226594222878, 
    0.1787484353953863, -0.1603207616432846}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.35229120018115184`, 
    0.11743040006038394`, -0.11743040006038394`}, {-0.3579949935256501, 
    0.14319799741026004`, -0.09546533160684004}, {-0.37788015107523965`, 
    0.16290833179688105`, -0.10580644230106709`}, {-0.37184302234147004`, 
    0.1404740306623331, -0.12394767411382335`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3579949935256501, 
    0.14319799741026004`, -0.09546533160684004}, {-0.37415229431745833`, 
    0.1746044040148139, -0.07483045886349166}, {-0.38991864684146027`, 
    0.18889392224764073`, -0.08838155995073098}, {-0.37788015107523965`, 
    0.16290833179688105`, -0.10580644230106709`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.37415229431745833`, 
    0.1746044040148139, -0.07483045886349166}, {-0.3983729048897056, 
    0.21246554927450964`, -0.05311638731862741}, {-0.40689371670049274`, 
    0.2188183987589316, -0.07052824422808539}, {-0.38991864684146027`, 
    0.18889392224764073`, -0.08838155995073098}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3983729048897056, 
    0.21246554927450964`, -0.05311638731862741}, {-0.42781593715312194`, 
    0.2566895622918732, -0.028521062476874796`}, {-0.4275386729168246, 
    0.2527228599908341, -0.05130464075001894}, {-0.40689371670049274`, 
    0.2188183987589316, -0.07052824422808539}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{-0.42781593715312194`, 
    0.2566895622918732, -0.028521062476874796`}, {-0.45998714286871445`, 
    0.3066580952458096, 0.}, {-0.45062802082557046`, 
    0.29040472453203425`, -0.03004186805503801}, {-0.4275386729168246, 
    0.2527228599908341, -0.05130464075001894}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{0., 0., 0.}, {-0.10920608786993075`, 
    0.014560811715990765`, 0.}, {-0.142224790973981, 0.0246522971021567, 
    0.003160550910532909}, {-0.05793069453624921, 0.0038620463024166113`, 
    0.0012873487674722039`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.10920608786993075`, 0.014560811715990765`, 
    0.}, {-0.21282462147366246`, 0.05675323239297665, 
    0.}, {-0.22335095439184463`, 0.06253826722971648, 
    0.004963354542040988}, {-0.142224790973981, 0.0246522971021567, 
    0.003160550910532909}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.21282462147366246`, 0.05675323239297665, 
    0.}, {-0.30673802522798127`, 0.1226952100911925, 
    0.}, {-0.2982832465218531, 0.11533618865511652`, 
    0.006628516589374509}, {-0.22335095439184463`, 0.06253826722971648, 
    0.004963354542040988}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.30673802522798127`, 0.1226952100911925, 
    0.}, {-0.38905011534806727`, 0.20749339485230253`, 
    0.}, {-0.36589693116182753`, 0.18050915270650156`, 
    0.008131042914707273}, {-0.2982832465218531, 0.11533618865511652`, 
    0.006628516589374509}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.38905011534806727`, 0.20749339485230253`, 
    0.}, {-0.45998714286871445`, 0.3066580952458096, 
    0.}, {-0.4260763439843505, 0.2556458063906103, 
    0.009468363199652228}, {-0.36589693116182753`, 0.18050915270650156`, 
    0.008131042914707273}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45998714286871445`, 0.3066580952458096, 
    0.}, {-0.42781593715312194`, 0.2566895622918732, 
    0.028521062476874796`}, {-0.39956209892042155`, 0.21842728074316375`, 
    0.030189136362876293`}, {-0.4260763439843505, 0.2556458063906103, 
    0.009468363199652228}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.42781593715312194`, 0.2566895622918732, 
    0.028521062476874796`}, {-0.3983729048897056, 0.21246554927450964`, 
    0.05311638731862741}, {-0.3754334096530939, 0.18521381542885962`, 
    0.04838919502195432}, {-0.39956209892042155`, 0.21842728074316375`, 
    0.030189136362876293`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3983729048897056, 0.21246554927450964`, 
    0.05311638731862741}, {-0.37415229431745833`, 0.1746044040148139, 
    0.07483045886349166}, {-0.3552530406979347, 0.15631133790709126`, 
    0.0647349985271792}, {-0.3754334096530939, 0.18521381542885962`, 
    0.04838919502195432}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.37415229431745833`, 0.1746044040148139, 
    0.07483045886349166}, {-0.3579949935256501, 0.14319799741026004`, 
    0.09546533160684004}, {-0.3407298274347052, 0.131748866608086, 
    0.08026080379573056}, {-0.3552530406979347, 0.15631133790709126`, 
    0.0647349985271792}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3579949935256501, 0.14319799741026004`, 
    0.09546533160684004}, {-0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {-0.3333736846483348, 0.11112456154944492`, 
    0.09630795334285228}, {-0.3407298274347052, 0.131748866608086, 
    0.08026080379573056}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {-0.2914261673100827, 0.07771364461602205, 
    0.07771364461602205}, {-0.2837917818761621, 0.07946169892532537, 
    0.0668487308419404}, {-0.3333736846483348, 0.11112456154944492`, 
    0.09630795334285228}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.2914261673100827, 0.07771364461602205, 
    0.07771364461602205}, {-0.22479511109484523`, 0.04495902221896904, 
    0.04495902221896904}, {-0.23065124757750236`, 0.052280949450900525`, 
    0.04202978289190042}, {-0.2837917818761621, 0.07946169892532537, 
    0.0668487308419404}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.22479511109484523`, 0.04495902221896904, 
    0.04495902221896904}, {-0.15308565553031123`, 0.02041142073737483, 
    0.02041142073737483}, {-0.17441633647095503`, 0.030232164988298865`, 
    0.02248032781181198}, {-0.23065124757750236`, 0.052280949450900525`, 
    0.04202978289190042}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.15308565553031123`, 0.02041142073737483, 
    0.02041142073737483}, {-0.07756663751797302, 0.005171109167864868, 
    0.005171109167864868}, {-0.11600941429253843`, 0.013921129715104607`, 
    0.008765155746547347}, {-0.17441633647095503`, 0.030232164988298865`, 
    0.02248032781181198}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.07756663751797302, 0.005171109167864868, 
    0.005171109167864868}, {0., 0., 0.}, {-0.05793069453624921, 
    0.0038620463024166113`, 0.0012873487674722039`}, {-0.11600941429253843`, 
    0.013921129715104607`, 0.008765155746547347}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45998714286871445`, 0.3066580952458096, 
    0.}, {-0.42781593715312194`, 0.2566895622918732, 
    0.028521062476874796`}, {-0.4275386729168246, 0.2527228599908341, 
    0.05130464075001894}, {-0.45062802082557046`, 0.29040472453203425`, 
    0.03004186805503801}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.42781593715312194`, 0.2566895622918732, 
    0.028521062476874796`}, {-0.3983729048897056, 0.21246554927450964`, 
    0.05311638731862741}, {-0.40689371670049274`, 0.2188183987589316, 
    0.07052824422808539}, {-0.4275386729168246, 0.2527228599908341, 
    0.05130464075001894}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3983729048897056, 0.21246554927450964`, 
    0.05311638731862741}, {-0.37415229431745833`, 0.1746044040148139, 
    0.07483045886349166}, {-0.38991864684146027`, 0.18889392224764073`, 
    0.08838155995073098}, {-0.40689371670049274`, 0.2188183987589316, 
    0.07052824422808539}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.37415229431745833`, 0.1746044040148139, 
    0.07483045886349166}, {-0.3579949935256501, 0.14319799741026004`, 
    0.09546533160684004}, {-0.37788015107523965`, 0.16290833179688105`, 
    0.10580644230106709`}, {-0.38991864684146027`, 0.18889392224764073`, 
    0.08838155995073098}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.3579949935256501, 0.14319799741026004`, 
    0.09546533160684004}, {-0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {-0.37184302234147004`, 0.1404740306623331, 
    0.12394767411382335`}, {-0.37788015107523965`, 0.16290833179688105`, 
    0.10580644230106709`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.35229120018115184`, 0.11743040006038394`, 
    0.11743040006038394`}, {-0.40726070505008105`, 0.1629042820200324, 
    0.1629042820200324}, {-0.4146226594222878, 0.1787484353953863, 
    0.1603207616432846}, {-0.37184302234147004`, 0.1404740306623331, 
    0.12394767411382335`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.40726070505008105`, 0.1629042820200324, 
    0.1629042820200324}, {-0.4566708874648107, 0.21311308081691166`, 
    0.21311308081691166`}, {-0.4539150995168281, 0.2198966482103745, 
    0.19972264378740437`}, {-0.4146226594222878, 0.1787484353953863, 
    0.1603207616432846}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4566708874648107, 0.21311308081691166`, 
    0.21311308081691166`}, {-0.5012123976166442, 0.2673132787288769, 
    0.2673132787288769}, {-0.49007301405696324`, 0.2635503764484113, 
    0.24176935360143517`}, {-0.4539150995168281, 0.2198966482103745, 
    0.19972264378740437`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5012123976166442, 0.2673132787288769, 
    0.2673132787288769}, {-0.5418425399938036, 0.3251055239962821, 
    0.3251055239962821}, {-0.5235616495156941, 0.30948310838038806`, 
    0.2862137017352461}, {-0.49007301405696324`, 0.2635503764484113, 
    0.24176935360143517`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5418425399938036, 0.3251055239962821, 
    0.3251055239962821}, {-0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {-0.5549429157801637, 0.3576298790583277, 
    0.3329657494680982}, {-0.5235616495156941, 0.30948310838038806`, 
    0.2862137017352461}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5797543124923197, 0.38650287499487973`, 
    0.38650287499487973`}, {-0.5440012355218949, 0.36266749034792994`, 
    0.29013399227834397`}, {-0.5263215102011988, 0.3391849732407725, 
    0.25965194503259137`}, {-0.5549429157801637, 0.3576298790583277, 
    0.3329657494680982}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5440012355218949, 0.36266749034792994`, 
    0.29013399227834397`}, {-0.5115370291932914, 0.3410246861288609, 
    0.20461481167731652`}, {-0.49999529440342494`, 0.3222191897266516, 
    0.19333151383599095`}, {-0.5263215102011988, 0.3391849732407725, 
    0.25965194503259137`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5115370291932914, 0.3410246861288609, 
    0.20461481167731652`}, {-0.48461849963627207`, 0.3230789997575147, 
    0.12923159990300587`}, {-0.4773844806346105, 0.3076477764089712, 
    0.13366765457769092`}, {-0.49999529440342494`, 0.3222191897266516, 
    0.19333151383599095`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.48461849963627207`, 0.3230789997575147, 
    0.12923159990300587`}, {-0.4664505261905705, 0.3109670174603803, 
    0.06219340349207606}, {-0.4603228910236794, 0.2966525297708156, 
    0.07978930111077108}, {-0.4773844806346105, 0.3076477764089712, 
    0.13366765457769092`}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4664505261905705, 0.3109670174603803, 
    0.06219340349207606}, {-0.45998714286871445`, 0.3066580952458096, 
    0.}, {-0.45062802082557046`, 0.29040472453203425`, 
    0.03004186805503801}, {-0.4603228910236794, 0.2966525297708156, 
    0.07978930111077108}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {-0.6103364275727268, 
    0.4407985310247471, -0.4407985310247471}, {-0.6164899353312527, 
    0.4589425074132659, -0.4452427310725714}, {-0.5920832028449382, 
    0.41445824199145676`, -0.4013008374837915}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6103364275727268, 
    0.4407985310247471, -0.4407985310247471}, {-0.6412032180604118, 
    0.49871361404698694`, -0.49871361404698694`}, {-0.641248218995467, 
    0.5058735949853128, -0.4916236345631913}, {-0.6164899353312527, 
    0.4589425074132659, -0.4452427310725714}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6412032180604118, 
    0.49871361404698694`, -0.49871361404698694`}, {-0.6740385471308696, 
    0.5616987892757247, -0.5616987892757247}, {-0.6672459372836057, 
    0.5560382810696715, -0.5412105935744802}, {-0.641248218995467, 
    0.5058735949853128, -0.4916236345631913}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6740385471308696, 
    0.5616987892757247, -0.5616987892757247}, {-0.6751944561946608, 
    0.6001728499508097, -0.5251512437069583}, {-0.6683421713383466, 
    0.5866559059525488, -0.5123956646927323}, {-0.6672459372836057, 
    0.5560382810696715, -0.5412105935744802}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6751944561946608, 
    0.6001728499508097, -0.5251512437069583}, {-0.6786794799954298, 
    0.6409750644401281, -0.49015740221892146`}, {-0.670907588604451, 
    0.6187258872685492, -0.484544369547659}, {-0.6683421713383466, 
    0.5866559059525488, -0.5123956646927323}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6786794799954298, 
    0.6409750644401281, -0.49015740221892146`}, {-0.6845537086570662, 
    0.6845537086570662, -0.4563691391047108}, {-0.6749630549963996, 
    0.6524642864965196, -0.4574749594975597}, {-0.670907588604451, 
    0.6187258872685492, -0.484544369547659}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, 
    0.6845537086570662, -0.4563691391047108}, {-0.6457005460543618, 
    0.5739560409372104, -0.4304670307029078}, {-0.6448463554356526, 
    0.5660318008824062, -0.43706252979527566`}, {-0.6749630549963996, 
    0.6524642864965196, -0.4574749594975597}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6457005460543618, 
    0.5739560409372104, -0.4304670307029078}, {-0.6115080659765835, 
    0.4756173846484537, -0.40767204398438894`}, {-0.6176006003263583, 
    0.48721825136857155`, -0.4185959624434206}, {-0.6448463554356526, 
    0.5660318008824062, -0.43706252979527566`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6115080659765835, 
    0.4756173846484537, -0.40767204398438894`}, {-0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {-0.5920832028449382, 
    0.41445824199145676`, -0.4013008374837915}, {-0.6176006003263583, 
    0.48721825136857155`, -0.4185959624434206}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6845537086570662, 
    0.6845537086570662, -0.4563691391047108}, {-0.7171888530767329, 
    0.7171888530767329, -0.5578135523930144}, {-0.716165180138544, 
    0.7082077892481158, -0.5649747532204069}, {-0.6890827403984796, 
    0.6814262655051632, -0.4823579182789357}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7171888530767329, 
    0.7171888530767329, -0.5578135523930144}, {-0.7640699024805022, 
    0.7640699024805022, -0.6791732466493353}, {-0.7520300306261339, 
    0.7436741413969546, -0.6601152491051621}, {-0.716165180138544, 
    0.7082077892481158, -0.5649747532204069}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7640699024805022, 
    0.7640699024805022, -0.6791732466493353}, {-0.9068996821171088, 
    0.9068996821171088, -0.9068996821171088}, {-0.8104554067121754, 
    0.8014503466375957, -0.7834402264884363}, {-0.7520300306261339, 
    0.7436741413969546, -0.6601152491051621}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.9068996821171088, 
    0.9068996821171088, -0.9068996821171088}, {-0.7622103197175837, 
    0.7198653019554957, -0.7198653019554957}, {-0.7504115684601292, 
    0.7087220368790109, -0.6920462242465636}, {-0.8104554067121754, 
    0.8014503466375957, -0.7834402264884363}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7622103197175837, 
    0.7198653019554957, -0.7198653019554957}, {-0.7118600880536767, 
    0.6327645227143793, -0.6327645227143793}, {-0.7119126797168901, 
    0.6407214117452011, -0.6249011299737146}, {-0.7504115684601292, 
    0.7087220368790109, -0.6920462242465636}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.7118600880536767, 
    0.6327645227143793, -0.6327645227143793}, {-0.6740385471308696, 
    0.5616987892757247, -0.5616987892757247}, {-0.6811124367744867, 
    0.5827295292403942, -0.5675936973120723}, {-0.7119126797168901, 
    0.6407214117452011, -0.6249011299737146}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6740385471308696, 
    0.5616987892757247, -0.5616987892757247}, {-0.6751944561946608, 
    0.6001728499508097, -0.5251512437069583}, {-0.68224035411735, 
    0.614016318705615, -0.5382118349147983}, {-0.6811124367744867, 
    0.5827295292403942, -0.5675936973120723}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6751944561946608, 
    0.6001728499508097, -0.5251512437069583}, {-0.6786794799954298, 
    0.6409750644401281, -0.49015740221892146`}, {-0.6848853908126196, 
    0.6468362024341406, -0.5098591242716168}, {-0.68224035411735, 
    0.614016318705615, -0.5382118349147983}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6786794799954298, 
    0.6409750644401281, -0.49015740221892146`}, {-0.6845537086570662, 
    0.6845537086570662, -0.4563691391047108}, {-0.6890827403984796, 
    0.6814262655051632, -0.4823579182789357}, {-0.6848853908126196, 
    0.6468362024341406, -0.5098591242716168}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45998714286871445`, 0.3066580952458096, 
    0.}, {-0.46253818353867265`, 
    0.30835878902578173`, -0.038544848628222717`}, {-0.47507741354102534`, 
    0.3272755515504841, -0.052786379282336135`}, {-0.47150167762968676`, 
    0.324812266811562, -0.020955630116874954`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.46253818353867265`, 
    0.30835878902578173`, -0.038544848628222717`}, {-0.46999171897491077`, 
    0.3133278126499405, -0.07833195316248512}, {-0.48154514744522653`, 
    0.33173110157337826`, -0.0856080262124847}, {-0.47507741354102534`, 
    0.3272755515504841, -0.052786379282336135`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.46999171897491077`, 
    0.3133278126499405, -0.07833195316248512}, {-0.4817997617497233, 
    0.32119984116648215`, -0.12044994043743079`}, {-0.4906212440644457, 
    0.3379835236888404, -0.11992963743797559`}, {-0.48154514744522653`, 
    0.33173110157337826`, -0.0856080262124847}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4817997617497233, 
    0.32119984116648215`, -0.12044994043743079`}, {-0.4971955577882874, 
    0.3314637051921916, -0.1657318525960958}, {-0.5019472405700409, 
    0.3457858768371393, -0.1561613637329016}, {-0.4906212440644457, 
    0.3379835236888404, -0.11992963743797559`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4971955577882874, 
    0.3314637051921916, -0.1657318525960958}, {-0.530207257345758, 
    0.39765544300931854`, -0.176735752448586}, {-0.5286651530527192, 
    0.3994358934176101, -0.16447360317195706`}, {-0.5019472405700409, 
    0.3457858768371393, -0.1561613637329016}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.530207257345758, 
    0.39765544300931854`, -0.176735752448586}, {-0.5617994480029483, 
    0.4681662066691236, -0.18726648266764945`}, {-0.5543741420185859, 
    0.4558187389930595, -0.17247195529467113`}, {-0.5286651530527192, 
    0.3994358934176101, -0.16447360317195706`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5617994480029483, 
    0.4681662066691236, -0.18726648266764945`}, {-0.5924835974670974, 
    0.5431099643448393, -0.19749453248903248`}, {-0.5793426974047388, 
    0.5149712865819899, -0.18023995030369647`}, {-0.5543741420185859, 
    0.4558187389930595, -0.17247195529467113`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5924835974670974, 
    0.5431099643448393, -0.19749453248903248`}, {-0.6230755279293883, 
    0.6230755279293883, -0.20769184264312943`}, {-0.6039532192067091, 
    0.577110853908633, -0.18789655708653166`}, {-0.5793426974047388, 
    0.5149712865819899, -0.18023995030369647`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, 
    0.6230755279293883, -0.20769184264312943`}, {-0.5826314122526858, 
    0.5340787945649619, -0.14565785306317142`}, {-0.571505684936255, 
    0.508005053276671, -0.13970138965108453`}, {-0.6039532192067091, 
    0.577110853908633, -0.18789655708653166`}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{-0.5826314122526858, 
    0.5340787945649619, -0.14565785306317142`}, {-0.5423842382927654, 
    0.4519868652439711, -0.09039737304879422}, {-0.5388079575040883, 
    0.4430198761700281, -0.09578808133406011}, {-0.571505684936255, 
    0.508005053276671, -0.13970138965108453`}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{-0.5423842382927654, 
    0.4519868652439711, -0.09039737304879422}, {-0.5013779790164214, 
    0.3760334842623161, -0.04178149825136846}, {-0.5054364950419619, 
    0.38188535180948235`, -0.05615961056021798}, {-0.5388079575040883, 
    0.4430198761700281, -0.09578808133406011}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{-0.5013779790164214, 
    0.3760334842623161, -0.04178149825136846}, {-0.45998714286871445`, 
    0.3066580952458096, 0.}, {-0.47150167762968676`, 
    0.324812266811562, -0.020955630116874954`}, {-0.5054364950419619, 
    0.38188535180948235`, -0.05615961056021798}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.45998714286871445`, 0.3066580952458096, 
    0.}, {-0.4875643330433564, 
    0.3521297960868685, -0.02708690739129757}, {-0.49772097016621203`, 
    0.3705256111237356, -0.027651165009233997`}, {-0.47617071567397445`, 
    0.33331950097178215`, -0.005290785729710824}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.4875643330433564, 
    0.3521297960868685, -0.02708690739129757}, {-0.5151364245658201, 
    0.4006616635511933, -0.057237380507313335`}, {-0.5192776126127516, 
    0.4096523388389484, -0.05192776126127516}, {-0.49772097016621203`, 
    0.3705256111237356, -0.027651165009233997`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5151364245658201, 
    0.4006616635511933, -0.057237380507313335`}, {-0.5423842382927654, 
    0.4519868652439711, -0.09039737304879422}, {-0.5406944571684102, 
    0.45057871430700847`, -0.07810031047988147}, {-0.5192776126127516, 
    0.4096523388389484, -0.05192776126127516}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{-0.5423842382927654, 
    0.4519868652439711, -0.09039737304879422}, {-0.5611088996560509, 
    0.49876346636093416`, -0.06234543329511677}, {-0.5561327685019032, 
    0.48816098568500393`, -0.055613276850190324`}, {-0.5406944571684102, 
    0.45057871430700847`, -0.07810031047988147}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5611088996560509, 
    0.49876346636093416`, -0.06234543329511677}, {-0.5810366771432506, 
    0.5487568617464034, -0.03227981539684726}, {-0.5723000016162385, 
    0.5277877792683088, -0.03179444453423547}, {-0.5561327685019032, 
    0.48816098568500393`, -0.055613276850190324`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5810366771432506, 
    0.5487568617464034, -0.03227981539684726}, {-0.6020420732135735, 
    0.6020420732135735, 0.}, {-0.5891105858887445, 
    0.5694735663591197, -0.006545673176541602}, {-0.5723000016162385, 
    0.5277877792683088, -0.03179444453423547}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{-0.6020420732135735, 0.6020420732135735, 
    0.}, {-0.5583263670978953, 0.49629010408701807`, 
    0.}, {-0.5538610316580012, 
    0.4861669055664677, -0.006154011462866676}, {-0.5891105858887445, 
    0.5694735663591197, -0.006545673176541602}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5583263670978953, 0.49629010408701807`, 
    0.}, {-0.5116766815928779, 0.3979707523500161, 0.}, {-0.5165717745530933, 
    0.40751773325855134`, -0.005739686383923255}, {-0.5538610316580012, 
    0.4861669055664677, -0.006154011462866676}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5116766815928779, 0.3979707523500161, 
    0.}, {-0.45998714286871445`, 0.3066580952458096, 
    0.}, {-0.47617071567397445`, 
    0.33331950097178215`, -0.005290785729710824}, {-0.5165717745530933, 
    0.40751773325855134`, -0.005739686383923255}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6020420732135735, 0.6020420732135735, 
    0.}, {-0.6044295191828238, 
    0.6044295191828238, -0.06715883546475819}, {-0.6006503620708005, 
    0.5939764691589027, -0.0734128220308756}, {-0.597947646585002, 
    0.5913037838451686, -0.01993158821950005}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{-0.6044295191828238, 
    0.6044295191828238, -0.06715883546475819}, {-0.6115080659765835, 
    0.6115080659765835, -0.13589068132812965`}, {-0.6063763483828833, 
    0.5996388334008513, -0.12801278465860869`}, {-0.6006503620708005, 
    0.5939764691589027, -0.0734128220308756}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6115080659765835, 
    0.6115080659765835, -0.13589068132812965`}, {-0.6230755279293883, 
    0.6230755279293883, -0.20769184264312943`}, {-0.615005336599669, 
    0.6081719439707838, -0.1845016009799007}, {-0.6063763483828833, 
    0.5996388334008513, -0.12801278465860869`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.6230755279293883, 
    0.6230755279293883, -0.20769184264312943`}, {-0.596004248542524, 
    0.5628929014012727, -0.16555673570625667`}, {-0.5936572660606888, 
    0.560676306835095, -0.15171241243773156`}, {-0.615005336599669, 
    0.6081719439707838, -0.1845016009799007}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.596004248542524, 
    0.5628929014012727, -0.16555673570625667`}, {-0.5692683486017988, 
    0.5060163098682655, -0.12650407746706638`}, {-0.5725114059716361, 
    0.5152602653744724, -0.1208635190384565}, {-0.5936572660606888, 
    0.560676306835095, -0.15171241243773156`}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{-0.5692683486017988, 
    0.5060163098682655, -0.12650407746706638`}, {-0.5423842382927654, 
    0.4519868652439711, -0.09039737304879422}, {-0.5513356533463394, 
    0.4716982811963126, -0.09188927555772322}, {-0.5725114059716361, 
    0.5152602653744724, -0.1208635190384565}}, Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5423842382927654, 
    0.4519868652439711, -0.09039737304879422}, {-0.5611088996560509, 
    0.49876346636093416`, -0.06234543329511677}, {-0.5660913502754555, 
    0.5094822152479099, -0.06918894281144455}, {-0.5513356533463394, 
    0.4716982811963126, -0.09188927555772322}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{-0.5611088996560509, 
    0.49876346636093416`, -0.06234543329511677}, {-0.5810366771432506, 
    0.5487568617464034, -0.03227981539684726}, {-0.5816501238360723, 
    0.5493362280674016, -0.04523945407613895}, {-0.5660913502754555, 
    0.5094822152479099, -0.06918894281144455}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{-0.5810366771432506, 
    0.5487568617464034, -0.03227981539684726}, {-0.6020420732135735, 
    0.6020420732135735, 0.}, {-0.597947646585002, 
    0.5913037838451686, -0.01993158821950005}, {-0.5816501238360723, 
    0.5493362280674016, -0.04523945407613895}}, Polygon3DBox[{{1, 2, 3, 4}}]],
    GraphicsComplex3DBox[{{-0.5797543124923197, 
    0.38650287499487973`, -0.38650287499487973`}, {-0.5570985386650793, 
    0.3713990257767195, -0.32497414755462956`}, {-0.5567535802997046, 
    0.3835413553175742, -0.3093075446109469}, {-0.5740389519912366, 
    0.39544905581618517`, -0.35717979235010267`}}, 
    Polygon3DBox[{{1, 2, 3, 4}}]], 
   GraphicsComplex3DBox[{{-0.5570985386650793, 
    0.3713990257767195, -0.32497414755462956`}, {-0.5355123085516112, 
    0.35700820570107417`, -0.26775615427580557