(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21232,        695]
NotebookOptionsPosition[     16986,        563]
NotebookOutlinePosition[     18507,        603]
CellTagsIndexPosition[     18422,        598]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Internet Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InternetConnectivity"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathematica Internet Connectivity\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Systems & Utility Formats" :> 
          Documentation`HelpLookup["paclet:guide/SystemsAndUtilityFormats"], 
          "Web Formats" :> 
          Documentation`HelpLookup["paclet:guide/WebFormats"], 
          "Web Operations" :> 
          Documentation`HelpLookup["paclet:guide/WebOperations"], 
          "XML Formats" :> 
          Documentation`HelpLookup["paclet:guide/XMLFormats"], 
          "XML Import & Export" :> 
          Documentation`HelpLookup["paclet:guide/XMLImportAndExport"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Importing & Exporting\"\>", 
       2->"\<\"Listing of All Formats\"\>", 
       3->"\<\"Systems & Utility Formats\"\>", 4->"\<\"Web Formats\"\>", 
       5->"\<\"Web Operations\"\>", 6->"\<\"XML Formats\"\>", 
       7->"\<\"XML Import & Export\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "RSS ",
 StyleBox["(.rss)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "MIME type: ",
 StyleBox["application/rss+xml", "InlineCode"],
 "\nRSS web syndication format.\nCommonly used to transmit frequently updated \
web content to feed readers or news aggregators.\nRSS is an acronym for \
Really Simple Syndication.\nStores names, addresses, and other contact \
information.\nXML-based format.\nStores news headlines together with date \
information and web links.\nIntroduced in 1999 by Netscape under the name RDF \
Site Summary."
}], "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " fully supports RSS version 2.0.1 and earlier."
}], "FormatNotes",
 CellID->344331575]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rss\>\"", "]"}]], "InlineFormula"],
 " imports an RSS file as a notebook expression."
}], "FormatNotes",
 CellID->28652],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rss\>\"", "]"}], " "}]], "InlineFormula"],
 "reads an RSS file and returns its contents formatted as a notebook."
}], "FormatNotes",
 CellID->28396],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rss\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "RSS",
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rss\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rss\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<RSS\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<RSS\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " supports the ",
 "RSS",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Notebook\>\"", Cell[
    "gives an RSS file formatted as a notebook expression", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NotebookObject\>\"", Cell[
    "creates a notebook and opens it in a new window", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SymbolicXML\>\"", Cell[
    "RSS file imported as a symbolic XML expression", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1019936196],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Notebook\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->1823001078],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"],
  FontSlant->"Italic"],
 ButtonBox[" Internet Connectivity",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"]
}], "Tutorials",
 CellID->1029926197]
}, Closed]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->210521534],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Systems & Utility Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemsAndUtilityFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebOperations"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Import & Export",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLImportAndExport"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->338004593],

Cell[TextData[{
 "Import an example RSS file as a ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->1521944672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", " ", "\"\<ExampleData/wr.rss\>\"", " ", "]"}], " ", 
  "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->976592890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cell", "[", 
    RowBox[{"\<\"Wolfram Research News\"\>", ",", "\<\"Title\"\>"}], "]"}], 
   ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"\<\"Wolfram Research RSS Feed\"\>", ",", "\<\"Text\"\>"}], "]"}],
    ",", 
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{"TextData", "[", 
      RowBox[{"ButtonBox", "[", 
       RowBox[{"\<\"http://www.wolfram.com/news\"\>", ",", 
        RowBox[{"ButtonData", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"URL", "[", "\<\"http://www.wolfram.com/news\"\>", "]"}], 
           ",", "None"}], "}"}]}], ",", 
        RowBox[{"BaseStyle", "\[Rule]", "\<\"Hyperlink\"\>"}]}], "]"}], "]"}],
      ",", "\<\"Text\"\>"}], "]"}], ",", 
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{"BoxData", "[", 
      RowBox[{"FormBox", "[", 
       RowBox[{
        RowBox[{"GridBox", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cell", "[", 
              RowBox[{
              "TextData", 
               "[", "\<\"Last refreshed at 11:09:13 on 2/19/2007\"\>", "]"}], 
              "]"}], ",", 
             RowBox[{"Cell", "[", 
              RowBox[{"BoxData", "[", 
               RowBox[{"ButtonBox", "[", 
                RowBox[{"\<\"Refresh RSS\"\>", ",", 
                 RowBox[{"Evaluator", "\[Rule]", "Automatic"}], ",", 
                 RowBox[{"ButtonFrame", "\[Rule]", "\<\"DialogBox\"\>"}], ",",
                  
                 RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                  RowBox[{"XML`RSS`RefreshRSS", "[", 
                   RowBox[{
                    RowBox[{"ButtonNotebook", "[", "]"}], 
                    ",", "\<\"ExampleData/wr.rss\"\>"}], "]"}]}]}], "]"}], 
               "]"}], "]"}]}], "}"}], "}"}], ",", 
          RowBox[{"ColumnWidths", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"0.7`", ",", "0.25`"}], "}"}]}], ",", 
          RowBox[{"ColumnAlignments", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Left", ",", "Right"}], "}"}]}]}], "]"}], ",", 
        "TextForm"}], "]"}], "]"}], ",", "\<\"Text\"\>"}], "]"}], ",", 
   RowBox[{"CellGroupData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\<\"Mathematica Reinvented\"\>", ",", "\<\"Section\"\>"}], 
        "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\<\"Wolfram Research announces Mathematica 6.\"\>", 
         ",", "\<\"Text\"\>"}], "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"TextData", "[", 
          RowBox[{"ButtonBox", "[", 
           RowBox[{"\<\"http://www.wolfram.com/news\"\>", ",", 
            RowBox[{"ButtonData", "\[RuleDelayed]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
               "URL", "[", "\<\"http://www.wolfram.com/news\"\>", "]"}], ",", 
               "None"}], "}"}]}], ",", 
            RowBox[{"BaseStyle", "\[Rule]", "\<\"Hyperlink\"\>"}]}], "]"}], 
          "]"}], ",", "\<\"Text\"\>"}], "]"}]}], "}"}], ",", "Closed"}], 
    "]"}], ",", 
   RowBox[{"CellGroupData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\<\"Wolfram Workbench\"\>", ",", "\<\"Section\"\>"}], "]"}], 
       ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\<\"Wolfram Workbench introduces the state of the art for \
technical development.\"\>", ",", "\<\"Text\"\>"}], "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"TextData", "[", 
          RowBox[{"ButtonBox", "[", 
           
           RowBox[{"\<\"http://www.wolfram.com/news/workbench.html\"\>", ",", 
            
            RowBox[{"ButtonData", "\[RuleDelayed]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
               "URL", "[", \
"\<\"http://www.wolfram.com/news/workbench.html\"\>", "]"}], ",", "None"}], 
              "}"}]}], ",", 
            RowBox[{"BaseStyle", "\[Rule]", "\<\"Hyperlink\"\>"}]}], "]"}], 
          "]"}], ",", "\<\"Text\"\>"}], "]"}]}], "}"}], ",", "Closed"}], 
    "]"}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1816010321]
}, Open  ]],

Cell["Import an RSS file and format it as a notebook:", "ExampleText",
 CellID->1784895283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", " ", 
   RowBox[{"\"\<ExampleData/wr.rss\>\"", ",", " ", "\"\<NotebookObject\>\""}],
    " ", "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1647873883],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "ManipulatePasteIcon"],
           ImageSizeCache->{13., {4., 9.}}],
          DynamicUpdating->True],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["x5n_shm", 1, 1]], 35]]}],
         Evaluator->None,
         Method->"Queued"],
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEStrings", "NotebookObjectToTheFront"]]], 
       StyleBox["\<\"Wolfram Research News-rss\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["x5n_shm", 1, 1]], 35],
  Editable->False]], "Output",
 CellLabel->"Out[2]=",
 CellID->1867239869]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RSS - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 57.7010144}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: application/rss+xml RSS web syndication format. Commonly used \
to transmit frequently updated web content to feed readers or news \
aggregators. RSS is an acronym for Really Simple Syndication. Stores names, \
addresses, and other contact information. XML-based format. Stores news \
headlines together with date information and web links. Introduced in 1999 by \
Netscape under the name RDF Site Summary.", "synonyms" -> {}, "title" -> 
    "RSS", "type" -> "Format", "uri" -> "ref/format/RSS"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10561, 366, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18288, 591}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2093, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2716, 75, 107, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[2826, 81, 515, 10, 70, "FormatUsage",
 CellID->37585799],
Cell[3344, 93, 219, 7, 70, "FormatNotes",
 CellID->344331575]
}, Open  ]],
Cell[CellGroupData[{
Cell[3600, 105, 53, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[3656, 108, 292, 9, 70, "FormatNotes",
 CellID->28652],
Cell[3951, 119, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[3993, 122, 335, 10, 70, "FormatNotes",
 CellID->28396],
Cell[4331, 134, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[4373, 137, 352, 13, 70, "FormatNotes",
 CellID->29174],
Cell[4728, 152, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[5305, 174, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[5888, 197, 703, 25, 70, "FormatNotes",
 CellID->32611],
Cell[6594, 224, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[6635, 227, 236, 9, 70, "FormatNotes",
 CellID->16216],
Cell[6874, 238, 216, 9, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[7127, 252, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[7186, 255, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[7385, 265, 672, 13, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[8060, 280, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[8104, 283, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[8179, 286, 684, 13, 70, "2ColumnTableMod",
 CellID->1019936196],
Cell[8866, 301, 262, 9, 70, "FormatNotes",
 CellID->1999285391]
}, Open  ]],
Cell[CellGroupData[{
Cell[9165, 315, 58, 1, 70, "TutorialsSection",
 CellID->1823001078],
Cell[9226, 318, 300, 9, 70, "Tutorials",
 CellID->1029926197]
}, Closed]],
Cell[CellGroupData[{
Cell[9563, 332, 58, 1, 70, "MoreAboutSection",
 CellID->210521534],
Cell[9624, 335, 134, 2, 70, "MoreAbout"],
Cell[9761, 339, 133, 2, 70, "MoreAbout"],
Cell[9897, 343, 141, 2, 70, "MoreAbout"],
Cell[10041, 347, 113, 2, 70, "MoreAbout"],
Cell[10157, 351, 119, 2, 70, "MoreAbout"],
Cell[10279, 355, 113, 2, 70, "MoreAbout"],
Cell[10395, 359, 129, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10561, 366, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[10677, 372, 60, 1, 70, "ExampleSection",
 CellID->338004593],
Cell[10740, 375, 219, 8, 70, "ExampleText",
 CellID->1521944672],
Cell[CellGroupData[{
Cell[10984, 387, 196, 6, 70, "Input",
 CellID->976592890],
Cell[11183, 395, 4220, 108, 70, "Output",
 CellID->1816010321]
}, Open  ]],
Cell[15418, 506, 91, 1, 70, "ExampleText",
 CellID->1784895283],
Cell[CellGroupData[{
Cell[15534, 511, 210, 6, 70, "Input",
 CellID->1647873883],
Cell[15747, 519, 1173, 37, 70, "Output",
 CellID->1867239869]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[16959, 561, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

