(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24134,        878]
NotebookOptionsPosition[     19107,        714]
NotebookOutlinePosition[     20534,        753]
CellTagsIndexPosition[     20449,        748]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"NB\"" :> 
          Documentation`HelpLookup["paclet:ref/format/X3D"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"\\\"NB\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Document Formats" :> 
          Documentation`HelpLookup["paclet:guide/DocumentFormats"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Importing & Exporting in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/ImportingAndExportingInNotebooks"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Document Formats\"\>", 
       2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Importing & Exporting in Notebooks\"\>", 
       4->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "RTF ",
 StyleBox["(.rtf)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell[TextData[{
 "MIME type: ",
 StyleBox["application/rtf", "InlineCode"],
 "\nRTF document file format.\nUsed for cross-platform exchange of formatted \
text documents.\nSupported by most word processors.\nRTF is an acronym for \
Rich Text Format.\n7-bit ASCII format.\nStores formatted text using a \
human-readable document markup language.\nDeveloped since 1987 by Microsoft."
}], "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support RTF format Version 1.3."
}], "FormatNotes",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rtf\>\"", "]"}]], "InlineFormula"],
 "imports an RTF file as a ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " expression."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rtf\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " expression or elements of a notebook to RTF."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rtf\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Notebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Notebook"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->25134],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rtf\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "RTF",
 " file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rtf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rtf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""}]], "InlineFormula"],
 ",",
 Cell[BoxData[
  ButtonBox["\"\<RTF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/RTF"]], "InlineFormula"],
 "] or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<RTF\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rtf\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates an ",
 "RTF",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rtf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rtf\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rtf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the RTF format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->26857],

Cell[TextData[{
 StyleBox["Save As", "MenuName"],
 " exports the active notebook as an RTF file."
}], "FormatNotes",
 CellID->26052]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Data representation elements:", "FormatNotes",
 CellID->525384128],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Notebook\>\"", Cell[TextData[{
     "a ",
     Cell[BoxData[
      ButtonBox["Notebook",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
     " version of the RTF file"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NotebookObject\>\"", Cell[TextData[{
     "RTF file converted to ",
     Cell[BoxData[
      ButtonBox["NotebookObject",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->263380570],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Notebook\>\""], "InlineFormula"],
 " element by default for RTF files."
}], "FormatNotes",
 CellID->13037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[Cell[BoxData[
 ButtonBox["\"\<NB\>\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/X3D"]], "InlineFormula"]], "SeeAlso",
 CellID->2645]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->186576928],

Cell[TextData[ButtonBox["Document Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExportingInNotebooks"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->61799099],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in an RTF sample file:"
}], "ExampleText",
 CellID->1856085850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/sample.rtf\>\"", ",", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1922689863],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Notebook\"\>", ",", "\<\"NotebookObject\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1462091032]
}, Open  ]],

Cell[TextData[{
 "Import this file as a ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->887424628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/sample.rtf\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->910738447],

Cell[BoxData[
 RowBox[{"Notebook", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Cell", "[", 
     RowBox[{
      RowBox[{"TextData", "[", 
       RowBox[{"{", 
        RowBox[{"\<\"Lorem ipsum\"\>", ",", 
         RowBox[{"StyleBox", "[", 
          
          RowBox[{"\<\" dolor sit amet, \\nconsectetur adipisicing elit, \
\\nsed do eiusmod tempor incididunt \\nut labore et dolore magna aliqua. \
\\n\"\>", ",", 
           RowBox[{"FontFamily", "\[Rule]", "\<\"Times-Roman\"\>"}], ",", 
           RowBox[{"FontWeight", "\[Rule]", "\<\"Plain\"\>"}]}], "]"}]}], 
        "}"}], "]"}], ",", "\<\"Input\"\>"}], "]"}], "}"}], ",", 
   RowBox[{"WindowSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"640", ",", "712"}], "}"}]}], ",", 
   RowBox[{"WindowMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"400", ",", "Automatic"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "50"}], "}"}]}], "}"}]}], ",", 
   RowBox[{
   "FrontEndVersion", 
    "\[Rule]", "\<\"6.0 for Mac OS X x86 (32-bit) (March 30, 2007)\"\>"}], 
   ",", 
   RowBox[{"StyleDefinitions", "\[Rule]", "\<\"Default.nb\"\>"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1665126560]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->671794381],

Cell[TextData[{
 "Export a ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " expression containing typeset math to RTF:"
}], "ExampleText",
 CellID->2069632007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<cell.rtf\>\"", ",", 
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{"BoxData", "[", 
      RowBox[{"SuperscriptBox", "[", 
       RowBox[{"\"\<x\>\"", ",", "\"\<2\>\""}], "]"}], "]"}], ",", 
     "\"\<Output\>\""}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1512511190],

Cell[BoxData["\<\"cell.rtf\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1011640791]
}, Open  ]],

Cell[TextData[{
 "Convert the generated file to a ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->1780678988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<cell.rtf\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1018741038],

Cell[BoxData[
 RowBox[{"Notebook", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Cell", "[", 
     RowBox[{
      RowBox[{"TextData", "[", 
       RowBox[{"{", 
        RowBox[{"\<\" x\"\>", ",", 
         RowBox[{"StyleBox", "[", 
          RowBox[{"\<\"2\"\>", ",", 
           RowBox[{"FontVariations", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\<\"CompatibilityType\"\>", "\[Rule]", "Superscript"}], 
             "}"}]}]}], "]"}]}], "}"}], "]"}], ",", "\<\"Input\"\>"}], "]"}], 
    "}"}], ",", 
   RowBox[{"WindowSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"640", ",", "712"}], "}"}]}], ",", 
   RowBox[{"WindowMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"400", ",", "Automatic"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "50"}], "}"}]}], "}"}]}], ",", 
   RowBox[{
   "FrontEndVersion", 
    "\[Rule]", "\<\"6.0 for Mac OS X x86 (32-bit) (March 30, 2007)\"\>"}], 
   ",", 
   RowBox[{"StyleDefinitions", "\[Rule]", "\<\"Default.nb\"\>"}]}], 
  "]"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->93508135]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RTF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 57.9197700}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: application/rtf RTF document file format. Used for \
cross-platform exchange of formatted text documents. Supported by most word \
processors. RTF is an acronym for Rich Text Format. 7-bit ASCII format. \
Stores formatted text using a human-readable document markup language. \
Developed since 1987 by Microsoft.", "synonyms" -> {}, "title" -> "RTF", 
    "type" -> "Format", "uri" -> "ref/format/RTF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14341, 533, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20315, 741}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1672, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2295, 68, 101, 4, 70, "ObjectNameAlt",
 CellID->5045],
Cell[2399, 74, 416, 8, 70, "FormatUsage",
 CellID->20778],
Cell[2818, 84, 325, 12, 70, "FormatNotes",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[3180, 101, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[3247, 104, 406, 14, 70, "FormatNotes",
 CellID->2520],
Cell[3656, 120, 474, 16, 70, "FormatNotes",
 CellID->12927],
Cell[4133, 138, 39, 1, 70, "WeakDivider",
 CellID->24773],
Cell[4175, 141, 488, 17, 70, "FormatNotes",
 CellID->25134],
Cell[4666, 160, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[4708, 163, 352, 13, 70, "FormatNotes",
 CellID->22675],
Cell[5063, 178, 574, 20, 70, "FormatNotes",
 CellID->13336],
Cell[5640, 200, 582, 21, 70, "FormatNotes",
 CellID->16334],
Cell[6225, 223, 770, 28, 70, "FormatNotes",
 CellID->21001],
Cell[6998, 253, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[7039, 256, 524, 20, 70, "FormatNotes",
 CellID->9310],
Cell[7566, 278, 1075, 40, 70, "FormatNotes",
 CellID->5974],
Cell[8644, 320, 661, 22, 70, "FormatNotes",
 CellID->7590],
Cell[9308, 344, 816, 28, 70, "FormatNotes",
 CellID->20356],
Cell[10127, 374, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[10168, 377, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[10532, 393, 342, 12, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[10911, 410, 70, 1, 70, "NotebookInterfaceSection",
 CellID->26857],
Cell[10984, 413, 132, 4, 70, "FormatNotes",
 CellID->26052]
}, Closed]],
Cell[CellGroupData[{
Cell[11153, 422, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[11207, 425, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[11402, 435, 667, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[12072, 450, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[12114, 453, 72, 1, 70, "FormatNotes",
 CellID->525384128],
Cell[12189, 456, 813, 22, 70, "2ColumnTableMod",
 CellID->263380570],
Cell[13005, 480, 395, 14, 70, "FormatNotes",
 CellID->13037]
}, Open  ]],
Cell[CellGroupData[{
Cell[13437, 499, 50, 1, 70, "SeeAlsoSection",
 CellID->20829],
Cell[13490, 502, 159, 4, 70, "SeeAlso",
 CellID->2645]
}, Open  ]],
Cell[CellGroupData[{
Cell[13686, 511, 58, 1, 70, "MoreAboutSection",
 CellID->186576928],
Cell[13747, 514, 123, 2, 70, "MoreAbout"],
Cell[13873, 518, 134, 2, 70, "MoreAbout"],
Cell[14010, 522, 158, 2, 70, "MoreAbout"],
Cell[14171, 526, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14341, 533, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[14457, 539, 59, 1, 70, "ExampleSection",
 CellID->61799099],
Cell[14519, 542, 230, 8, 70, "ExampleText",
 CellID->1856085850],
Cell[CellGroupData[{
Cell[14774, 554, 173, 5, 70, "Input",
 CellID->1922689863],
Cell[14950, 561, 156, 5, 70, "Output",
 CellID->1462091032]
}, Open  ]],
Cell[15121, 569, 216, 8, 70, "ExampleText",
 CellID->887424628],
Cell[CellGroupData[{
Cell[15362, 581, 131, 3, 70, "Input",
 CellID->910738447],
Cell[15496, 586, 1223, 34, 70, "Output",
 CellID->1665126560]
}, Open  ]],
Cell[16734, 623, 125, 3, 70, "ExampleDelimiter",
 CellID->671794381],
Cell[16862, 628, 227, 8, 70, "ExampleText",
 CellID->2069632007],
Cell[CellGroupData[{
Cell[17114, 640, 343, 10, 70, "Input",
 CellID->1512511190],
Cell[17460, 652, 87, 2, 70, "Output",
 CellID->1011640791]
}, Open  ]],
Cell[17562, 657, 227, 8, 70, "ExampleText",
 CellID->1780678988],
Cell[CellGroupData[{
Cell[17814, 669, 118, 3, 70, "Input",
 CellID->1018741038],
Cell[17935, 674, 1106, 33, 70, "Output",
 CellID->93508135]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[19080, 712, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

